"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getVeturFullConfig = exports.getDefaultVLSConfig = void 0;
const path = require("path");
const paths_1 = require("./utils/paths");
const fg = require("fast-glob");
const workspace_1 = require("./utils/workspace");
const lodash_1 = require("lodash");
function getDefaultVLSConfig() {
    return {
        stml: {
            ignoreProjectWarning: false,
            useWorkspaceDependencies: false,
            validation: {
                template: true,
                templateProps: false,
                interpolation: true,
                style: true,
                script: true
            },
            completion: {
                autoImport: false,
                tagCasing: 'initial',
                scaffoldSnippetSources: {
                    workspace: '💼',
                    user: '🗒️',
                    vetur: '✌'
                }
            },
            grammar: {
                customBlocks: {}
            },
            format: {
                enable: true,
                options: {
                    tabSize: 2,
                    useTabs: false
                },
                defaultFormatter: {},
                defaultFormatterOptions: {},
                scriptInitialIndent: false,
                styleInitialIndent: false
            },
            languageFeatures: {
                codeActions: true
            },
            trace: {
                server: 'off'
            },
            dev: {
                vlsPath: '',
                vlsPort: -1,
                logLevel: 'INFO'
            },
            experimental: {
                templateInterpolationService: false
            }
        },
        css: {},
        html: {
            suggest: {}
        },
        javascript: {
            format: {}
        },
        typescript: {
            tsdk: null,
            format: {}
        },
        emmet: {},
        stylusSupremacy: {}
    };
}
exports.getDefaultVLSConfig = getDefaultVLSConfig;
async function getVeturFullConfig(rootPathForConfig, workspacePath, veturConfig) {
    var _a, _b;
    const oldProjects = (_a = veturConfig.projects) !== null && _a !== void 0 ? _a : [workspacePath];
    const projects = oldProjects
        .map(project => {
        var _a, _b;
        const getFallbackPackagePath = (projectRoot) => {
            const fallbackPackage = workspace_1.findConfigFile(projectRoot, 'package.json');
            return fallbackPackage ? paths_1.normalizeFileNameToFsPath(fallbackPackage) : undefined;
        };
        const getFallbackTsconfigPath = (projectRoot) => {
            const jsconfigPath = workspace_1.findConfigFile(projectRoot, 'jsconfig.json');
            const tsconfigPath = workspace_1.findConfigFile(projectRoot, 'tsconfig.json');
            if (jsconfigPath && tsconfigPath) {
                const tsconfigFsPath = paths_1.normalizeFileNameToFsPath(tsconfigPath);
                const jsconfigFsPath = paths_1.normalizeFileNameToFsPath(jsconfigPath);
                return paths_1.getPathDepth(tsconfigPath, '/') >= paths_1.getPathDepth(jsconfigFsPath, '/') ? tsconfigFsPath : jsconfigFsPath;
            }
            const configPath = tsconfigPath || jsconfigPath;
            return configPath ? paths_1.normalizeFileNameToFsPath(configPath) : undefined;
        };
        if (typeof project === 'string') {
            const projectRoot = paths_1.normalizeAbsolutePath(project, rootPathForConfig);
            return {
                root: projectRoot,
                package: getFallbackPackagePath(projectRoot),
                tsconfig: getFallbackTsconfigPath(projectRoot),
                snippetFolder: paths_1.normalizeFileNameResolve(projectRoot, '.vscode/vetur/snippets'),
                globalComponents: []
            };
        }
        const projectRoot = paths_1.normalizeAbsolutePath(project.root, rootPathForConfig);
        return {
            root: projectRoot,
            package: project.package
                ? paths_1.normalizeAbsolutePath(project.package, projectRoot)
                : getFallbackPackagePath(projectRoot),
            tsconfig: project.tsconfig
                ? paths_1.normalizeAbsolutePath(project.tsconfig, projectRoot)
                : getFallbackTsconfigPath(projectRoot),
            snippetFolder: project.snippetFolder
                ? paths_1.normalizeAbsolutePath(project.snippetFolder, projectRoot)
                : paths_1.normalizeFileNameResolve(projectRoot, '.vscode/vetur/snippets'),
            globalComponents: lodash_1.flatten((_b = (_a = project.globalComponents) === null || _a === void 0 ? void 0 : _a.map(comp => {
                if (typeof comp === 'string') {
                    return fg.sync(comp, { cwd: projectRoot, absolute: true, suppressErrors: true }).map(fileName => ({
                        name: path.basename(fileName, path.extname(fileName)),
                        path: paths_1.normalizeFileNameToFsPath(fileName)
                    }));
                }
                return comp;
            })) !== null && _b !== void 0 ? _b : [])
        };
    })
        .sort((a, b) => paths_1.getPathDepth(b.root, '/') - paths_1.getPathDepth(a.root, '/'));
    return {
        settings: (_b = veturConfig.settings) !== null && _b !== void 0 ? _b : {},
        projects
    };
}
exports.getVeturFullConfig = getVeturFullConfig;
//# sourceMappingURL=config.js.map