"use strict";
/* --------------------------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 * ------------------------------------------------------------------------------------------ */
Object.defineProperty(exports, "__esModule", { value: true });
exports.OnTypeRenameFeature = void 0;
const vscode_languageserver_protocol_1 = require("vscode-languageserver-protocol");
exports.OnTypeRenameFeature = (Base) => {
    return class extends Base {
        onOnTypeRename(handler) {
            this.connection.onRequest(vscode_languageserver_protocol_1.OnTypeRenameRequest.type, (params, cancel) => {
                return handler(params, cancel, this.attachWorkDoneProgress(params), undefined);
            });
        }
    };
};
//# sourceMappingURL=onTypeRename.js.map