import type { integer } from 'vscode-languageserver-types';
import * as mk from './protocol.moniker.proposed';
export * from 'vscode-jsonrpc';
export * from 'vscode-languageserver-types';
export * from './messages';
export * from './protocol';
export { ProtocolConnection, createProtocolConnection } from './connection';
export declare namespace LSPErrorCodes {
    /**
    * This is the start range of LSP reserved error codes.
    * It doesn't denote a real error code.
    *
    * @since 3.16.0
    */
    const lspReservedErrorRangeStart: integer;
    const ContentModified: integer;
    const RequestCancelled: integer;
    /**
    * This is the end range of LSP reserved error codes.
    * It doesn't denote a real error code.
    *
    * @since 3.16.0
    */
    const lspReservedErrorRangeEnd: integer;
}
export declare namespace Proposed {
    const UniquenessLevel: typeof mk.UniquenessLevel;
    const MonikerKind: typeof mk.MonikerKind;
    type Moniker = mk.Moniker;
    type MonikerClientCapabilities = mk.MonikerClientCapabilities;
    type MonikerServerCapabilities = mk.MonikerServerCapabilities;
    type MonikerOptions = mk.MonikerOptions;
    type MonikerParams = mk.MonikerParams;
    type MonikerRegistrationOptions = mk.MonikerRegistrationOptions;
    namespace MonikerRequest {
        const method: "textDocument/moniker";
        const type: import("./messages").ProtocolRequestType<mk.MonikerParams, mk.Moniker[] | null, mk.Moniker[], void, mk.MonikerRegistrationOptions>;
    }
}
