var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import assert from 'assert';
import { describe, it } from 'mocha';
import { TextDocument } from 'vscode-languageserver-textdocument';
import { Position } from 'vscode-languageserver-types';
import { doComplete } from '../emmetHelper';
const COMPLETE_OPTIONS = {
    preferences: {},
    showExpandedAbbreviation: 'always',
    showAbbreviationSuggestions: false,
    syntaxProfiles: {},
    variables: {}
};
describe('Expand Abbreviations', () => {
    function testExpand(syntax, abbrev, expanded) {
        it(`should expand ${abbrev} to ${expanded}`, () => __awaiter(this, void 0, void 0, function* () {
            const document = TextDocument.create(`test://test/test.${syntax}`, syntax, 0, abbrev);
            const position = Position.create(0, abbrev.length);
            const completionList = doComplete(document, position, syntax, COMPLETE_OPTIONS);
            assert.ok(completionList && completionList.items, `completion list exists for ${abbrev}`);
            assert.ok(completionList.items.length > 0, `completion list is not empty for ${abbrev}`);
            assert.strictEqual(expanded, TextDocument.applyEdits(document, [completionList.items[0].textEdit]));
        }));
    }
    function testNotExpand(syntax, abbrev) {
        it(`should not expand ${abbrev}`, () => __awaiter(this, void 0, void 0, function* () {
            const document = TextDocument.create(`test://test/test.${syntax}`, syntax, 0, abbrev);
            const position = Position.create(0, abbrev.length);
            const completionList = doComplete(document, position, syntax, COMPLETE_OPTIONS);
            assert.ok(!completionList);
        }));
    }
    testExpand('jsx', 'button[onClick={props.onClick}]', '<button onClick="props.onClick">${0}</button>');
    testExpand('css', 'd', 'display: ${2:block};');
    testNotExpand('html', 'div*101');
});
//# sourceMappingURL=expand.test.js.map