"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const assert_1 = __importDefault(require("assert"));
const mocha_1 = require("mocha");
const vscode_languageserver_textdocument_1 = require("vscode-languageserver-textdocument");
const vscode_languageserver_types_1 = require("vscode-languageserver-types");
const emmetHelper_1 = require("../emmetHelper");
const COMPLETE_OPTIONS = {
    preferences: {},
    showExpandedAbbreviation: 'always',
    showAbbreviationSuggestions: false,
    syntaxProfiles: {},
    variables: {}
};
mocha_1.describe('Expand Abbreviations', () => {
    function testExpand(syntax, abbrev, expanded) {
        mocha_1.it(`should expand ${abbrev} to ${expanded}`, () => __awaiter(this, void 0, void 0, function* () {
            const document = vscode_languageserver_textdocument_1.TextDocument.create(`test://test/test.${syntax}`, syntax, 0, abbrev);
            const position = vscode_languageserver_types_1.Position.create(0, abbrev.length);
            const completionList = emmetHelper_1.doComplete(document, position, syntax, COMPLETE_OPTIONS);
            assert_1.default.ok(completionList && completionList.items, `completion list exists for ${abbrev}`);
            assert_1.default.ok(completionList.items.length > 0, `completion list is not empty for ${abbrev}`);
            assert_1.default.strictEqual(expanded, vscode_languageserver_textdocument_1.TextDocument.applyEdits(document, [completionList.items[0].textEdit]));
        }));
    }
    function testNotExpand(syntax, abbrev) {
        mocha_1.it(`should not expand ${abbrev}`, () => __awaiter(this, void 0, void 0, function* () {
            const document = vscode_languageserver_textdocument_1.TextDocument.create(`test://test/test.${syntax}`, syntax, 0, abbrev);
            const position = vscode_languageserver_types_1.Position.create(0, abbrev.length);
            const completionList = emmetHelper_1.doComplete(document, position, syntax, COMPLETE_OPTIONS);
            assert_1.default.ok(!completionList);
        }));
    }
    testExpand('jsx', 'button[onClick={props.onClick}]', '<button onClick="props.onClick">${0}</button>');
    testExpand('css', 'd', 'display: ${2:block};');
    testNotExpand('html', 'div*101');
});
//# sourceMappingURL=expand.test.js.map