/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
// file generated from vscode-web-custom-data NPM package
(function (factory) {
	if (typeof module === "object" && typeof module.exports === "object") {
		var v = factory(require, exports);
		if (v !== undefined) module.exports = v;
	}
	else if (typeof define === "function" && define.amd) {
		define(["require", "exports"], factory);
	}
})(function (require, exports) {
	"use strict";
	Object.defineProperty(exports, "__esModule", { value: true });
	exports.cssData = void 0;
	exports.cssData = {
		"version": 1.1,
		"properties": [
			{
				"name": "align-content",
				"values": [
					{
						"name": "center",
						"description": "Lines are packed toward the center of the flex container."
					},
					{
						"name": "flex-end",
						"description": "Lines are packed toward the end of the flex container."
					},
					{
						"name": "flex-start",
						"description": "Lines are packed toward the start of the flex container."
					},
					{
						"name": "space-around",
						"description": "Lines are evenly distributed in the flex container, with half-size spaces on either end."
					},
					{
						"name": "space-between",
						"description": "Lines are evenly distributed in the flex container."
					},
					{
						"name": "stretch",
						"description": "Lines stretch to take up the remaining space."
					}
				],
				"syntax": "normal | <baseline-position> | <content-distribution> | <overflow-position>? <content-position>",
				"relevance": 59,
				"description": "Aligns a flex container’s lines within the flex container when there is extra space in the cross-axis, similar to how 'justify-content' aligns individual items within the main-axis.",
				"restrictions": [
					"enum"
				]
			},
			{
				"name": "align-items",
				"values": [
					{
						"name": "baseline",
						"description": "If the flex item’s inline axis is the same as the cross axis, this value is identical to 'flex-start'. Otherwise, it participates in baseline alignment."
					},
					{
						"name": "center",
						"description": "The flex item’s margin box is centered in the cross axis within the line."
					},
					{
						"name": "flex-end",
						"description": "The cross-end margin edge of the flex item is placed flush with the cross-end edge of the line."
					},
					{
						"name": "flex-start",
						"description": "The cross-start margin edge of the flex item is placed flush with the cross-start edge of the line."
					},
					{
						"name": "stretch",
						"description": "If the cross size property of the flex item computes to auto, and neither of the cross-axis margins are auto, the flex item is stretched."
					}
				],
				"syntax": "normal | stretch | <baseline-position> | [ <overflow-position>? <self-position> ]",
				"relevance": 81,
				"description": "Aligns flex items along the cross axis of the current line of the flex container.",
				"restrictions": [
					"enum"
				]
			},
			{
				"name": "align-self",
				"values": [
					{
						"name": "auto",
						"description": "Computes to the value of 'align-items' on the element’s parent, or 'stretch' if the element has no parent. On absolutely positioned elements, it computes to itself."
					},
					{
						"name": "baseline",
						"description": "If the flex item’s inline axis is the same as the cross axis, this value is identical to 'flex-start'. Otherwise, it participates in baseline alignment."
					},
					{
						"name": "center",
						"description": "The flex item’s margin box is centered in the cross axis within the line."
					},
					{
						"name": "flex-end",
						"description": "The cross-end margin edge of the flex item is placed flush with the cross-end edge of the line."
					},
					{
						"name": "flex-start",
						"description": "The cross-start margin edge of the flex item is placed flush with the cross-start edge of the line."
					},
					{
						"name": "stretch",
						"description": "If the cross size property of the flex item computes to auto, and neither of the cross-axis margins are auto, the flex item is stretched."
					}
				],
				"syntax": "auto | normal | stretch | <baseline-position> | <overflow-position>? <self-position>",
				"relevance": 69,
				"description": "Allows the default alignment along the cross axis to be overridden for individual flex items.",
				"restrictions": [
					"enum"
				]
			},
			{
				"name": "background",
				"values": [
					{
						"name": "fixed",
						"description": "The background is fixed with regard to the viewport. In paged media where there is no viewport, a 'fixed' background is fixed with respect to the page box and therefore replicated on every page."
					},
					{
						"name": "local",
						"description": "The background is fixed with regard to the element's contents: if the element has a scrolling mechanism, the background scrolls with the element's contents."
					},
					{
						"name": "none",
						"description": "A value of 'none' counts as an image layer but draws nothing."
					},
					{
						"name": "scroll",
						"description": "The background is fixed with regard to the element itself and does not scroll with its contents. (It is effectively attached to the element's border.)"
					}
				],
				"syntax": "[ <bg-layer> , ]* <final-bg-layer>",
				"relevance": 93,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/background"
					}
				],
				"description": "Shorthand property for setting most background properties at the same place in the style sheet.",
				"restrictions": [
					"enum",
					"image",
					"color",
					"position",
					"length",
					"repeat",
					"percentage",
					"box"
				]
			},
			{
				"name": "background-color",
				"syntax": "<color>",
				"relevance": 94,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/background-color"
					}
				],
				"description": "Sets the background color of an element.",
				"restrictions": [
					"color"
				]
			},
			{
				"name": "background-image",
				"values": [
					{
						"name": "none",
						"description": "Counts as an image layer but draws nothing."
					}
				],
				"syntax": "<bg-image>#",
				"relevance": 88,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/background-image"
					}
				],
				"description": "Sets the background image(s) of an element.",
				"restrictions": [
					"image",
					"enum"
				]
			},
			{
				"name": "background-position",
				"syntax": "<bg-position>#",
				"relevance": 87,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/background-position"
					}
				],
				"description": "Specifies the initial position of the background image(s) (after any resizing) within their corresponding background positioning area.",
				"restrictions": [
					"position",
					"length",
					"percentage"
				]
			},
			{
				"name": "background-repeat",
				"values": [],
				"syntax": "<repeat-style>#",
				"relevance": 85,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/background-repeat"
					}
				],
				"description": "Specifies how background images are tiled after they have been sized and positioned.",
				"restrictions": [
					"repeat"
				]
			},
			{
				"name": "background-size",
				"values": [
					{
						"name": "auto",
						"description": "Resolved by using the image’s intrinsic ratio and the size of the other dimension, or failing that, using the image’s intrinsic size, or failing that, treating it as 100%."
					},
					{
						"name": "contain",
						"description": "Scale the image, while preserving its intrinsic aspect ratio (if any), to the largest size such that both its width and its height can fit inside the background positioning area."
					},
					{
						"name": "cover",
						"description": "Scale the image, while preserving its intrinsic aspect ratio (if any), to the smallest size such that both its width and its height can completely cover the background positioning area."
					}
				],
				"syntax": "<bg-size>#",
				"relevance": 85,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/background-size"
					}
				],
				"description": "Specifies the size of the background images.",
				"restrictions": [
					"length",
					"percentage"
				]
			},
			{
				"name": "border",
				"syntax": "<line-width> || <line-style> || <color>",
				"relevance": 95,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/border"
					}
				],
				"description": "Shorthand property for setting border width, style, and color.",
				"restrictions": [
					"length",
					"line-width",
					"line-style",
					"color"
				]
			},
			{
				"name": "border-bottom",
				"syntax": "<line-width> || <line-style> || <color>",
				"relevance": 88,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/border-bottom"
					}
				],
				"description": "Shorthand property for setting border width, style and color.",
				"restrictions": [
					"length",
					"line-width",
					"line-style",
					"color"
				]
			},
			{
				"name": "border-bottom-color",
				"syntax": "<'border-top-color'>",
				"relevance": 71,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/border-bottom-color"
					}
				],
				"description": "Sets the color of the bottom border.",
				"restrictions": [
					"color"
				]
			},
			{
				"name": "border-bottom-left-radius",
				"syntax": "<length-percentage>{1,2}",
				"relevance": 74,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/border-bottom-left-radius"
					}
				],
				"description": "Defines the radii of the bottom left outer border edge.",
				"restrictions": [
					"length",
					"percentage"
				]
			},
			{
				"name": "border-bottom-right-radius",
				"syntax": "<length-percentage>{1,2}",
				"relevance": 73,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/border-bottom-right-radius"
					}
				],
				"description": "Defines the radii of the bottom right outer border edge.",
				"restrictions": [
					"length",
					"percentage"
				]
			},
			{
				"name": "border-bottom-style",
				"syntax": "<line-style>",
				"relevance": 57,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/border-bottom-style"
					}
				],
				"description": "Sets the style of the bottom border.",
				"restrictions": [
					"line-style"
				]
			},
			{
				"name": "border-bottom-width",
				"syntax": "<line-width>",
				"relevance": 62,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/border-bottom-width"
					}
				],
				"description": "Sets the thickness of the bottom border.",
				"restrictions": [
					"length",
					"line-width"
				]
			},
			{
				"name": "border-color",
				"values": [],
				"syntax": "<color>{1,4}",
				"relevance": 86,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/border-color"
					}
				],
				"description": "The color of the border around all four edges of an element.",
				"restrictions": [
					"color"
				]
			},
			{
				"name": "border-left",
				"syntax": "<line-width> || <line-style> || <color>",
				"relevance": 82,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/border-left"
					}
				],
				"description": "Shorthand property for setting border width, style and color",
				"restrictions": [
					"length",
					"line-width",
					"line-style",
					"color"
				]
			},
			{
				"name": "border-left-color",
				"syntax": "<color>",
				"relevance": 65,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/border-left-color"
					}
				],
				"description": "Sets the color of the left border.",
				"restrictions": [
					"color"
				]
			},
			{
				"name": "border-left-style",
				"syntax": "<line-style>",
				"relevance": 54,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/border-left-style"
					}
				],
				"description": "Sets the style of the left border.",
				"restrictions": [
					"line-style"
				]
			},
			{
				"name": "border-left-width",
				"syntax": "<line-width>",
				"relevance": 58,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/border-left-width"
					}
				],
				"description": "Sets the thickness of the left border.",
				"restrictions": [
					"length",
					"line-width"
				]
			},
			{
				"name": "border-radius",
				"syntax": "<length-percentage>{1,4} [ / <length-percentage>{1,4} ]?",
				"relevance": 91,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/border-radius"
					}
				],
				"description": "Defines the radii of the outer border edge.",
				"restrictions": [
					"length",
					"percentage"
				]
			},
			{
				"name": "border-right",
				"syntax": "<line-width> || <line-style> || <color>",
				"relevance": 81,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/border-right"
					}
				],
				"description": "Shorthand property for setting border width, style and color",
				"restrictions": [
					"length",
					"line-width",
					"line-style",
					"color"
				]
			},
			{
				"name": "border-right-color",
				"syntax": "<color>",
				"relevance": 64,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/border-right-color"
					}
				],
				"description": "Sets the color of the right border.",
				"restrictions": [
					"color"
				]
			},
			{
				"name": "border-right-style",
				"syntax": "<line-style>",
				"relevance": 54,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/border-right-style"
					}
				],
				"description": "Sets the style of the right border.",
				"restrictions": [
					"line-style"
				]
			},
			{
				"name": "border-right-width",
				"syntax": "<line-width>",
				"relevance": 60,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/border-right-width"
					}
				],
				"description": "Sets the thickness of the right border.",
				"restrictions": [
					"length",
					"line-width"
				]
			},
			{
				"name": "border-style",
				"values": [],
				"syntax": "<line-style>{1,4}",
				"relevance": 79,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/border-style"
					}
				],
				"description": "The style of the border around edges of an element.",
				"restrictions": [
					"line-style"
				]
			},
			{
				"name": "border-top",
				"syntax": "<line-width> || <line-style> || <color>",
				"relevance": 87,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/border-top"
					}
				],
				"description": "Shorthand property for setting border width, style and color",
				"restrictions": [
					"length",
					"line-width",
					"line-style",
					"color"
				]
			},
			{
				"name": "border-top-color",
				"syntax": "<color>",
				"relevance": 71,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/border-top-color"
					}
				],
				"description": "Sets the color of the top border.",
				"restrictions": [
					"color"
				]
			},
			{
				"name": "border-top-left-radius",
				"syntax": "<length-percentage>{1,2}",
				"relevance": 74,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/border-top-left-radius"
					}
				],
				"description": "Defines the radii of the top left outer border edge.",
				"restrictions": [
					"length",
					"percentage"
				]
			},
			{
				"name": "border-top-right-radius",
				"syntax": "<length-percentage>{1,2}",
				"relevance": 72,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/border-top-right-radius"
					}
				],
				"description": "Defines the radii of the top right outer border edge.",
				"restrictions": [
					"length",
					"percentage"
				]
			},
			{
				"name": "border-top-style",
				"syntax": "<line-style>",
				"relevance": 57,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/border-top-style"
					}
				],
				"description": "Sets the style of the top border.",
				"restrictions": [
					"line-style"
				]
			},
			{
				"name": "border-top-width",
				"syntax": "<line-width>",
				"relevance": 61,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/border-top-width"
					}
				],
				"description": "Sets the thickness of the top border.",
				"restrictions": [
					"length",
					"line-width"
				]
			},
			{
				"name": "border-width",
				"values": [],
				"syntax": "<line-width>{1,4}",
				"relevance": 81,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/border-width"
					}
				],
				"description": "Shorthand that sets the four 'border-*-width' properties. If it has four values, they set top, right, bottom and left in that order. If left is missing, it is the same as right; if bottom is missing, it is the same as top; if right is missing, it is the same as top.",
				"restrictions": [
					"length",
					"line-width"
				]
			},
			{
				"name": "bottom",
				"values": [
					{
						"name": "auto",
						"description": "For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well"
					}
				],
				"syntax": "<length> | <percentage> | auto",
				"relevance": 89,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/bottom"
					}
				],
				"description": "Specifies how far an absolutely positioned box's bottom margin edge is offset above the bottom edge of the box's 'containing block'.",
				"restrictions": [
					"length",
					"percentage"
				]
			},
			{
				"name": "box-shadow",
				"values": [
					{
						"name": "inset",
						"description": "Changes the drop shadow from an outer shadow (one that shadows the box onto the canvas, as if it were lifted above the canvas) to an inner shadow (one that shadows the canvas onto the box, as if the box were cut out of the canvas and shifted behind it)."
					},
					{
						"name": "none",
						"description": "No shadow."
					}
				],
				"syntax": "none | <shadow>#",
				"relevance": 89,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/box-shadow"
					}
				],
				"description": "Attaches one or more drop-shadows to the box. The property is a comma-separated list of shadows, each specified by 2-4 length values, an optional color, and an optional 'inset' keyword. Omitted lengths are 0; omitted colors are a user agent chosen color.",
				"restrictions": [
					"length",
					"color",
					"enum"
				]
			},
			{
				"name": "box-sizing",
				"values": [
					{
						"name": "border-box",
						"description": "The specified width and height (and respective min/max properties) on this element determine the border box of the element."
					},
					{
						"name": "content-box",
						"description": "Behavior of width and height as specified by CSS2.1. The specified width and height (and respective min/max properties) apply to the width and height respectively of the content box of the element."
					}
				],
				"syntax": "content-box | border-box",
				"relevance": 92,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/box-sizing"
					}
				],
				"description": "Specifies the behavior of the 'width' and 'height' properties.",
				"restrictions": [
					"enum"
				]
			},
			{
				"name": "color",
				"syntax": "<color>",
				"relevance": 94,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/color"
					}
				],
				"description": "Sets the color of an element's text",
				"restrictions": [
					"color"
				]
			},
			{
				"name": "direction",
				"values": [
					{
						"name": "ltr",
						"description": "Left-to-right direction."
					},
					{
						"name": "rtl",
						"description": "Right-to-left direction."
					}
				],
				"syntax": "ltr | rtl",
				"relevance": 68,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/direction"
					}
				],
				"description": "Specifies the inline base direction or directionality of any bidi paragraph, embedding, isolate, or override established by the box. Note: for HTML content use the 'dir' attribute and 'bdo' element rather than this property.",
				"restrictions": [
					"enum"
				]
			},
			{
				"name": "display",
				"values": [
					{
						"name": "flex",
						"description": "The element generates a principal flex container box and establishes a flex formatting context."
					},
					{
						"name": "none",
						"description": "The element and its descendants generates no boxes."
					},
				],
				"syntax": "[ <display-outside> || <display-inside> ] | <display-listitem> | <display-internal> | <display-box> | <display-legacy>",
				"relevance": 96,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/display"
					}
				],
				"description": "In combination with 'float' and 'position', determines the type of box or boxes that are generated for an element.",
				"restrictions": [
					"enum"
				]
			},
			{
				"name": "flex",
				"values": [
					{
						"name": "auto",
						"description": "Retrieves the value of the main size property as the used 'flex-basis'."
					},
					{
						"name": "content",
						"description": "Indicates automatic sizing, based on the flex item’s content."
					},
					{
						"name": "none",
						"description": "Expands to '0 0 auto'."
					}
				],
				"syntax": "none | [ <'flex-grow'> <'flex-shrink'>? || <'flex-basis'> ]",
				"relevance": 77,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/flex"
					}
				],
				"description": "Specifies the components of a flexible length: the flex grow factor and flex shrink factor, and the flex basis.",
				"restrictions": [
					"length",
					"number",
					"percentage"
				]
			},
			{
				"name": "flex-basis",
				"values": [
					{
						"name": "auto",
						"description": "Retrieves the value of the main size property as the used 'flex-basis'."
					},
					{
						"name": "content",
						"description": "Indicates automatic sizing, based on the flex item’s content."
					}
				],
				"syntax": "content | <'width'>",
				"relevance": 62,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/flex-basis"
					}
				],
				"description": "Sets the flex basis.",
				"restrictions": [
					"length",
					"number",
					"percentage"
				]
			},
			{
				"name": "flex-direction",
				"values": [
					{
						"name": "column",
						"description": "The flex container’s main axis has the same orientation as the block axis of the current writing mode."
					},
					{
						"name": "column-reverse",
						"description": "Same as 'column', except the main-start and main-end directions are swapped."
					},
					{
						"name": "row",
						"description": "The flex container’s main axis has the same orientation as the inline axis of the current writing mode."
					},
					{
						"name": "row-reverse",
						"description": "Same as 'row', except the main-start and main-end directions are swapped."
					}
				],
				"syntax": "row | row-reverse | column | column-reverse",
				"relevance": 78,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/flex-direction"
					}
				],
				"description": "Specifies how flex items are placed in the flex container, by setting the direction of the flex container’s main axis.",
				"restrictions": [
					"enum"
				]
			},
			{
				"name": "flex-flow",
				"values": [
					{
						"name": "column",
						"description": "The flex container’s main axis has the same orientation as the block axis of the current writing mode."
					},
					{
						"name": "column-reverse",
						"description": "Same as 'column', except the main-start and main-end directions are swapped."
					},
					{
						"name": "nowrap",
						"description": "The flex container is single-line."
					},
					{
						"name": "row",
						"description": "The flex container’s main axis has the same orientation as the inline axis of the current writing mode."
					},
					{
						"name": "row-reverse",
						"description": "Same as 'row', except the main-start and main-end directions are swapped."
					},
					{
						"name": "wrap",
						"description": "The flexbox is multi-line."
					},
					{
						"name": "wrap-reverse",
						"description": "Same as 'wrap', except the cross-start and cross-end directions are swapped."
					}
				],
				"syntax": "<'flex-direction'> || <'flex-wrap'>",
				"relevance": 58,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/flex-flow"
					}
				],
				"description": "Specifies how flexbox items are placed in the flexbox.",
				"restrictions": [
					"enum"
				]
			},
			{
				"name": "flex-grow",
				"syntax": "<number>",
				"relevance": 71,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/flex-grow"
					}
				],
				"description": "Sets the flex grow factor. Negative numbers are invalid.",
				"restrictions": [
					"number"
				]
			},
			{
				"name": "flex-shrink",
				"syntax": "<number>",
				"relevance": 69,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/flex-shrink"
					}
				],
				"description": "Sets the flex shrink factor. Negative numbers are invalid.",
				"restrictions": [
					"number"
				]
			},
			{
				"name": "flex-wrap",
				"values": [
					{
						"name": "nowrap",
						"description": "The flex container is single-line."
					},
					{
						"name": "wrap",
						"description": "The flexbox is multi-line."
					},
					{
						"name": "wrap-reverse",
						"description": "Same as 'wrap', except the cross-start and cross-end directions are swapped."
					}
				],
				"syntax": "nowrap | wrap | wrap-reverse",
				"relevance": 74,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/flex-wrap"
					}
				],
				"description": "Controls whether the flex container is single-line or multi-line, and the direction of the cross-axis, which determines the direction new lines are stacked in.",
				"restrictions": [
					"enum"
				]
			},
			{
				"name": "font-family",
				"values": [
					{
						"name": "-apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif"
					},
					{
						"name": "Arial, Helvetica, sans-serif"
					},
					{
						"name": "Cambria, Cochin, Georgia, Times, 'Times New Roman', serif"
					},
					{
						"name": "'Courier New', Courier, monospace"
					},
					{
						"name": "cursive"
					},
					{
						"name": "fantasy"
					},
					{
						"name": "'Franklin Gothic Medium', 'Arial Narrow', Arial, sans-serif"
					},
					{
						"name": "Georgia, 'Times New Roman', Times, serif"
					},
					{
						"name": "'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif"
					},
					{
						"name": "Impact, Haettenschweiler, 'Arial Narrow Bold', sans-serif"
					},
					{
						"name": "'Lucida Sans', 'Lucida Sans Regular', 'Lucida Grande', 'Lucida Sans Unicode', Geneva, Verdana, sans-serif"
					},
					{
						"name": "monospace"
					},
					{
						"name": "sans-serif"
					},
					{
						"name": "'Segoe UI', Tahoma, Geneva, Verdana, sans-serif"
					},
					{
						"name": "serif"
					},
					{
						"name": "'Times New Roman', Times, serif"
					},
					{
						"name": "'Trebuchet MS', 'Lucida Sans Unicode', 'Lucida Grande', 'Lucida Sans', Arial, sans-serif"
					},
					{
						"name": "Verdana, Geneva, Tahoma, sans-serif"
					}
				],
				"syntax": "<family-name>",
				"relevance": 92,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/font-family"
					}
				],
				"description": "Specifies a prioritized list of font family names or generic family names. A user agent iterates through the list of family names until it matches an available font that contains a glyph for the character to be rendered.",
				"restrictions": [
					"font"
				]
			},
			{
				"name": "font-size",
				"values": [
					{
						"name": "large"
					},
					{
						"name": "larger"
					},
					{
						"name": "medium"
					},
					{
						"name": "small"
					},
					{
						"name": "smaller"
					},
					{
						"name": "x-large"
					},
					{
						"name": "x-small"
					},
					{
						"name": "xx-large"
					},
					{
						"name": "xx-small"
					}
				],
				"syntax": "<absolute-size> | <relative-size> | <length-percentage>",
				"relevance": 94,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/font-size"
					}
				],
				"description": "Indicates the desired height of glyphs from the font. For scalable fonts, the font-size is a scale factor applied to the EM unit of the font. (Note that certain glyphs may bleed outside their EM box.) For non-scalable fonts, the font-size is converted into absolute units and matched against the declared font-size of the font, using the same absolute coordinate space for both of the matched values.",
				"restrictions": [
					"length",
					"percentage"
				]
			},
			{
				"name": "font-style",
				"values": [
					{
						"name": "italic",
						"description": "Selects a font that is labeled as an 'italic' face, or an 'oblique' face if one is not"
					},
					{
						"name": "normal",
						"description": "Selects a face that is classified as 'normal'."
					},
					{
						"name": "oblique",
						"description": "Selects a font that is labeled as an 'oblique' face, or an 'italic' face if one is not."
					}
				],
				"syntax": "normal | italic | oblique <angle>{0,2}",
				"relevance": 83,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/font-style"
					}
				],
				"description": "Allows italic or oblique faces to be selected. Italic forms are generally cursive in nature while oblique faces are typically sloped versions of the regular face.",
				"restrictions": [
					"enum"
				]
			},
			{
				"name": "font-variant",
				"values": [
					{
						"name": "normal",
						"description": "Specifies a face that is not labeled as a small-caps font."
					},
					{
						"name": "small-caps",
						"description": "Specifies a font that is labeled as a small-caps font. If a genuine small-caps font is not available, user agents should simulate a small-caps font."
					}
				],
				"syntax": "normal | none | [ <common-lig-values> || <discretionary-lig-values> || <historical-lig-values> || <contextual-alt-values> || stylistic(<feature-value-name>) || historical-forms || styleset(<feature-value-name>#) || character-variant(<feature-value-name>#) || swash(<feature-value-name>) || ornaments(<feature-value-name>) || annotation(<feature-value-name>) || [ small-caps | all-small-caps | petite-caps | all-petite-caps | unicase | titling-caps ] || <numeric-figure-values> || <numeric-spacing-values> || <numeric-fraction-values> || ordinal || slashed-zero || <east-asian-variant-values> || <east-asian-width-values> || ruby ]",
				"relevance": 63,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/font-variant"
					}
				],
				"description": "Specifies variant representations of the font",
				"restrictions": [
					"enum"
				]
			},
			{
				"name": "font-weight",
				"values": [
					{
						"name": "100",
						"description": "Thin"
					},
					{
						"name": "200",
						"description": "Extra Light (Ultra Light)"
					},
					{
						"name": "300",
						"description": "Light"
					},
					{
						"name": "400",
						"description": "Normal"
					},
					{
						"name": "500",
						"description": "Medium"
					},
					{
						"name": "600",
						"description": "Semi Bold (Demi Bold)"
					},
					{
						"name": "700",
						"description": "Bold"
					},
					{
						"name": "800",
						"description": "Extra Bold (Ultra Bold)"
					},
					{
						"name": "900",
						"description": "Black (Heavy)"
					},
					{
						"name": "bold",
						"description": "Same as 700"
					},
					{
						"name": "bolder",
						"description": "Specifies the weight of the face bolder than the inherited value."
					},
					{
						"name": "lighter",
						"description": "Specifies the weight of the face lighter than the inherited value."
					},
					{
						"name": "normal",
						"description": "Same as 400"
					}
				],
				"syntax": "<font-weight-absolute>{1,2}",
				"relevance": 93,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/font-weight"
					}
				],
				"description": "Specifies weight of glyphs in the font, their degree of blackness or stroke thickness.",
				"restrictions": [
					"enum"
				]
			},
			{
				"name": "height",
				"values": [
					{
						"name": "auto",
						"description": "The height depends on the values of other properties."
					},
					{
						"name": "fit-content",
						"description": "Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."
					},
					{
						"name": "max-content",
						"description": "Use the max-content inline size or max-content block size, as appropriate to the writing mode."
					},
					{
						"name": "min-content",
						"description": "Use the min-content inline size or min-content block size, as appropriate to the writing mode."
					}
				],
				"syntax": "<viewport-length>{1,2}",
				"relevance": 96,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/height"
					}
				],
				"description": "Specifies the height of the content area, padding area or border area (depending on 'box-sizing') of certain boxes.",
				"restrictions": [
					"length",
					"percentage"
				]
			},
			{
				"name": "justify-content",
				"values": [
					{
						"name": "center",
						"description": "Flex items are packed toward the center of the line."
					},
					{
						"name": "start",
						"description": "The items are packed flush to each other toward the start edge of the alignment container in the main axis."
					},
					{
						"name": "end",
						"description": "The items are packed flush to each other toward the end edge of the alignment container in the main axis."
					},
					{
						"name": "left",
						"description": "The items are packed flush to each other toward the left edge of the alignment container in the main axis."
					},
					{
						"name": "right",
						"description": "The items are packed flush to each other toward the right edge of the alignment container in the main axis."
					},
					{
						"name": "safe",
						"description": "If the size of the item overflows the alignment container, the item is instead aligned as if the alignment mode were start."
					},
					{
						"name": "unsafe",
						"description": "Regardless of the relative sizes of the item and alignment container, the given alignment value is honored."
					},
					{
						"name": "stretch",
						"description": "If the combined size of the alignment subjects is less than the size of the alignment container, any auto-sized alignment subjects have their size increased equally (not proportionally), while still respecting the constraints imposed by max-height/max-width (or equivalent functionality), so that the combined size exactly fills the alignment container."
					},
					{
						"name": "space-evenly",
						"description": "The items are evenly distributed within the alignment container along the main axis."
					},
					{
						"name": "flex-end",
						"description": "Flex items are packed toward the end of the line."
					},
					{
						"name": "flex-start",
						"description": "Flex items are packed toward the start of the line."
					},
					{
						"name": "space-around",
						"description": "Flex items are evenly distributed in the line, with half-size spaces on either end."
					},
					{
						"name": "space-between",
						"description": "Flex items are evenly distributed in the line."
					},
					{
						"name": "baseline",
						"description": "Specifies participation in first-baseline alignment."
					},
					{
						"name": "first baseline",
						"description": "Specifies participation in first-baseline alignment."
					},
					{
						"name": "last baseline",
						"description": "Specifies participation in last-baseline alignment."
					}
				],
				"syntax": "normal | <content-distribution> | <overflow-position>? [ <content-position> | left | right ]",
				"relevance": 82,
				"description": "Aligns flex items along the main axis of the current line of the flex container.",
				"restrictions": [
					"enum"
				]
			},
			{
				"name": "left",
				"values": [
					{
						"name": "auto",
						"description": "For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well"
					}
				],
				"syntax": "<length> | <percentage> | auto",
				"relevance": 95,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/left"
					}
				],
				"description": "Specifies how far an absolutely positioned box's left margin edge is offset to the right of the left edge of the box's 'containing block'.",
				"restrictions": [
					"length",
					"percentage"
				]
			},
			{
				"name": "letter-spacing",
				"values": [
					{
						"name": "normal",
						"description": "The spacing is the normal spacing for the current font. It is typically zero-length."
					}
				],
				"syntax": "normal | <length>",
				"relevance": 79,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/letter-spacing"
					}
				],
				"description": "Specifies the minimum, maximum, and optimal spacing between grapheme clusters.",
				"restrictions": [
					"length"
				]
			},
			{
				"name": "line-height",
				"values": [
					{
						"name": "normal",
						"description": "Tells user agents to set the computed value to a 'reasonable' value based on the font size of the element."
					}
				],
				"syntax": "normal | <number> | <length> | <percentage>",
				"relevance": 92,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/line-height"
					}
				],
				"description": "Determines the block-progression dimension of the text content area of an inline box.",
				"restrictions": [
					"number",
					"length",
					"percentage"
				]
			},
			{
				"name": "margin",
				"values": [
					{
						"name": "auto"
					}
				],
				"syntax": "[ <length> | <percentage> | auto ]{1,4}",
				"relevance": 95,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/margin"
					}
				],
				"description": "Shorthand property to set values the thickness of the margin area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. Negative values for margin properties are allowed, but there may be implementation-specific limits.",
				"restrictions": [
					"length",
					"percentage"
				]
			},
			{
				"name": "margin-bottom",
				"values": [
					{
						"name": "auto"
					}
				],
				"syntax": "<length> | <percentage> | auto",
				"relevance": 91,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/margin-bottom"
					}
				],
				"description": "Shorthand property to set values the thickness of the margin area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. Negative values for margin properties are allowed, but there may be implementation-specific limits..",
				"restrictions": [
					"length",
					"percentage"
				]
			},
			{
				"name": "margin-left",
				"values": [
					{
						"name": "auto"
					}
				],
				"syntax": "<length> | <percentage> | auto",
				"relevance": 91,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/margin-left"
					}
				],
				"description": "Shorthand property to set values the thickness of the margin area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. Negative values for margin properties are allowed, but there may be implementation-specific limits..",
				"restrictions": [
					"length",
					"percentage"
				]
			},
			{
				"name": "margin-right",
				"values": [
					{
						"name": "auto"
					}
				],
				"syntax": "<length> | <percentage> | auto",
				"relevance": 90,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/margin-right"
					}
				],
				"description": "Shorthand property to set values the thickness of the margin area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. Negative values for margin properties are allowed, but there may be implementation-specific limits..",
				"restrictions": [
					"length",
					"percentage"
				]
			},
			{
				"name": "margin-top",
				"values": [
					{
						"name": "auto"
					}
				],
				"syntax": "<length> | <percentage> | auto",
				"relevance": 95,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/margin-top"
					}
				],
				"description": "Shorthand property to set values the thickness of the margin area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. Negative values for margin properties are allowed, but there may be implementation-specific limits..",
				"restrictions": [
					"length",
					"percentage"
				]
			},
			{
				"name": "max-height",
				"values": [
					{
						"name": "none",
						"description": "No limit on the height of the box."
					},
					{
						"name": "fit-content",
						"description": "Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."
					},
					{
						"name": "max-content",
						"description": "Use the max-content inline size or max-content block size, as appropriate to the writing mode."
					},
					{
						"name": "min-content",
						"description": "Use the min-content inline size or min-content block size, as appropriate to the writing mode."
					}
				],
				"syntax": "<viewport-length>",
				"relevance": 84,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/max-height"
					}
				],
				"description": "Allows authors to constrain content height to a certain range.",
				"restrictions": [
					"length",
					"percentage"
				]
			},
			{
				"name": "max-width",
				"values": [
					{
						"name": "none",
						"description": "No limit on the width of the box."
					},
					{
						"name": "fit-content",
						"description": "Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."
					},
					{
						"name": "max-content",
						"description": "Use the max-content inline size or max-content block size, as appropriate to the writing mode."
					},
					{
						"name": "min-content",
						"description": "Use the min-content inline size or min-content block size, as appropriate to the writing mode."
					}
				],
				"syntax": "<viewport-length>",
				"relevance": 89,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/max-width"
					}
				],
				"description": "Allows authors to constrain content width to a certain range.",
				"restrictions": [
					"length",
					"percentage"
				]
			},
			{
				"name": "min-height",
				"values": [
					{
						"name": "auto"
					},
					{
						"name": "fit-content",
						"description": "Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."
					},
					{
						"name": "max-content",
						"description": "Use the max-content inline size or max-content block size, as appropriate to the writing mode."
					},
					{
						"name": "min-content",
						"description": "Use the min-content inline size or min-content block size, as appropriate to the writing mode."
					}
				],
				"syntax": "<viewport-length>",
				"relevance": 88,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/min-height"
					}
				],
				"description": "Allows authors to constrain content height to a certain range.",
				"restrictions": [
					"length",
					"percentage"
				]
			},
			{
				"name": "min-width",
				"values": [
					{
						"name": "auto"
					},
					{
						"name": "fit-content",
						"description": "Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."
					},
					{
						"name": "max-content",
						"description": "Use the max-content inline size or max-content block size, as appropriate to the writing mode."
					},
					{
						"name": "min-content",
						"description": "Use the min-content inline size or min-content block size, as appropriate to the writing mode."
					}
				],
				"syntax": "<viewport-length>",
				"relevance": 87,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/min-width"
					}
				],
				"description": "Allows authors to constrain content width to a certain range.",
				"restrictions": [
					"length",
					"percentage"
				]
			},
			{
				"name": "opacity",
				"syntax": "<alpha-value>",
				"relevance": 93,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/opacity"
					}
				],
				"description": "Opacity of an element's text, where 1 is opaque and 0 is entirely transparent.",
				"restrictions": [
					"number(0-1)"
				]
			},
			{
				"name": "overflow",
				"values": [
					{
						"name": "auto",
						"description": "The behavior of the 'auto' value is UA-dependent, but should cause a scrolling mechanism to be provided for overflowing boxes."
					},
					{
						"name": "hidden",
						"description": "Content is clipped and no scrolling mechanism should be provided to view the content outside the clipping region."
					},
					{
						"name": "-moz-hidden-unscrollable",
						"description": "Same as the standardized 'clip', except doesn’t establish a block formatting context."
					},
					{
						"name": "scroll",
						"description": "Content is clipped and if the user agent uses a scrolling mechanism that is visible on the screen (such as a scroll bar or a panner), that mechanism should be displayed for a box whether or not any of its content is clipped."
					},
					{
						"name": "visible",
						"description": "Content is not clipped, i.e., it may be rendered outside the content box."
					}
				],
				"syntax": "[ visible | hidden | clip | scroll | auto ]{1,2}",
				"relevance": 92,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/overflow"
					}
				],
				"description": "Shorthand for setting 'overflow-x' and 'overflow-y'.",
				"restrictions": [
					"enum"
				]
			},
			{
				"name": "padding",
				"values": [],
				"syntax": "[ <length> | <percentage> ]{1,4}",
				"relevance": 96,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/padding"
					}
				],
				"description": "Shorthand property to set values the thickness of the padding area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. The value may not be negative.",
				"restrictions": [
					"length",
					"percentage"
				]
			},
			{
				"name": "padding-bottom",
				"syntax": "<length> | <percentage>",
				"relevance": 88,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/padding-bottom"
					}
				],
				"description": "Shorthand property to set values the thickness of the padding area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. The value may not be negative.",
				"restrictions": [
					"length",
					"percentage"
				]
			},
			{
				"name": "padding-left",
				"syntax": "<length> | <percentage>",
				"relevance": 90,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/padding-left"
					}
				],
				"description": "Shorthand property to set values the thickness of the padding area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. The value may not be negative.",
				"restrictions": [
					"length",
					"percentage"
				]
			},
			{
				"name": "padding-right",
				"syntax": "<length> | <percentage>",
				"relevance": 88,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/padding-right"
					}
				],
				"description": "Shorthand property to set values the thickness of the padding area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. The value may not be negative.",
				"restrictions": [
					"length",
					"percentage"
				]
			},
			{
				"name": "padding-top",
				"syntax": "<length> | <percentage>",
				"relevance": 90,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/padding-top"
					}
				],
				"description": "Shorthand property to set values the thickness of the padding area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. The value may not be negative.",
				"restrictions": [
					"length",
					"percentage"
				]
			},
			{
				"name": "position",
				"values": [
					{
						"name": "absolute",
						"description": "The box's position (and possibly size) is specified with the 'top', 'right', 'bottom', and 'left' properties. These properties specify offsets with respect to the box's 'containing block'."
					},
					{
						"name": "relative",
						"description": "The box's position is calculated according to the normal flow (this is called the position in normal flow). Then the box is offset relative to its normal position."
					}
				],
				"syntax": "static | relative | absolute | sticky | fixed",
				"relevance": 96,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/position"
					}
				],
				"description": "The position CSS property sets how an element is positioned in a document. The top, right, bottom, and left properties determine the final location of positioned elements.",
				"restrictions": [
					"enum"
				]
			},
			{
				"name": "right",
				"values": [
					{
						"name": "auto",
						"description": "For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well"
					}
				],
				"syntax": "<length> | <percentage> | auto",
				"relevance": 90,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/right"
					}
				],
				"description": "Specifies how far an absolutely positioned box's right margin edge is offset to the left of the right edge of the box's 'containing block'.",
				"restrictions": [
					"length",
					"percentage"
				]
			},
			{
				"name": "text-align",
				"values": [
					{
						"name": "center",
						"description": "The inline contents are centered within the line box."
					},
					{
						"name": "end",
						"description": "The inline contents are aligned to the end edge of the line box."
					},
					{
						"name": "justify",
						"description": "The text is justified according to the method specified by the 'text-justify' property."
					},
					{
						"name": "left",
						"description": "The inline contents are aligned to the left edge of the line box. In vertical text, 'left' aligns to the edge of the line box that would be the start edge for left-to-right text."
					},
					{
						"name": "right",
						"description": "The inline contents are aligned to the right edge of the line box. In vertical text, 'right' aligns to the edge of the line box that would be the end edge for left-to-right text."
					},
					{
						"name": "start",
						"description": "The inline contents are aligned to the start edge of the line box."
					}
				],
				"syntax": "start | end | left | right | center | justify | match-parent",
				"relevance": 93,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/text-align"
					}
				],
				"description": "Describes how inline contents of a block are horizontally aligned if the contents do not completely fill the line box.",
				"restrictions": [
					"string"
				]
			},
			{
				"name": "text-decoration",
				"values": [
					{
						"name": "dashed",
						"description": "Produces a dashed line style."
					},
					{
						"name": "dotted",
						"description": "Produces a dotted line."
					},
					{
						"name": "double",
						"description": "Produces a double line."
					},
					{
						"name": "line-through",
						"description": "Each line of text has a line through the middle."
					},
					{
						"name": "none",
						"description": "Produces no line."
					},
					{
						"name": "overline",
						"description": "Each line of text has a line above it."
					},
					{
						"name": "solid",
						"description": "Produces a solid line."
					},
					{
						"name": "underline",
						"description": "Each line of text is underlined."
					},
					{
						"name": "wavy",
						"description": "Produces a wavy line."
					}
				],
				"syntax": "<'text-decoration-line'> || <'text-decoration-style'> || <'text-decoration-color'> || <'text-decoration-thickness'>",
				"relevance": 91,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/text-decoration"
					}
				],
				"description": "Decorations applied to font used for an element's text.",
				"restrictions": [
					"enum",
					"color"
				]
			},
			{
				"name": "text-indent",
				"values": [],
				"syntax": "<length-percentage> && hanging? && each-line?",
				"relevance": 68,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/text-indent"
					}
				],
				"description": "Specifies the indentation applied to lines of inline content in a block. The indentation only affects the first line of inline content in the block unless the 'hanging' keyword is specified, in which case it affects all lines except the first.",
				"restrictions": [
					"percentage",
					"length"
				]
			},
			{
				"name": "text-overflow",
				"values": [
					{
						"name": "clip",
						"description": "Clip inline content that overflows. Characters may be only partially rendered."
					},
					{
						"name": "ellipsis",
						"description": "Render an ellipsis character (U+2026) to represent clipped inline content."
					}
				],
				"syntax": "[ clip | ellipsis | <string> ]{1,2}",
				"relevance": 81,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/text-overflow"
					}
				],
				"description": "Text can overflow for example when it is prevented from wrapping.",
				"restrictions": [
					"enum",
					"string"
				]
			},
			{
				"name": "text-shadow",
				"values": [
					{
						"name": "none",
						"description": "No shadow."
					}
				],
				"syntax": "none | <shadow-t>#",
				"relevance": 74,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/text-shadow"
					}
				],
				"description": "Enables shadow effects to be applied to the text of the element.",
				"restrictions": [
					"length",
					"color"
				]
			},
			{
				"name": "top",
				"values": [
					{
						"name": "auto",
						"description": "For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well"
					}
				],
				"syntax": "<length> | <percentage> | auto",
				"relevance": 95,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/top"
					}
				],
				"description": "Specifies how far an absolutely positioned box's top margin edge is offset below the top edge of the box's 'containing block'.",
				"restrictions": [
					"length",
					"percentage"
				]
			},
			{
				"name": "transform",
				"values": [
					{
						"name": "matrix()",
						"description": "Specifies a 2D transformation in the form of a transformation matrix of six values. matrix(a,b,c,d,e,f) is equivalent to applying the transformation matrix [a b c d e f]"
					},
					{
						"name": "matrix3d()",
						"description": "Specifies a 3D transformation as a 4x4 homogeneous matrix of 16 values in column-major order."
					},
					{
						"name": "none"
					},
					{
						"name": "perspective()",
						"description": "Specifies a perspective projection matrix."
					},
					{
						"name": "rotate()",
						"description": "Specifies a 2D rotation by the angle specified in the parameter about the origin of the element, as defined by the transform-origin property."
					},
					{
						"name": "rotate3d()",
						"description": "Specifies a clockwise 3D rotation by the angle specified in last parameter about the [x,y,z] direction vector described by the first 3 parameters."
					},
					{
						"name": "rotateX('angle')",
						"description": "Specifies a clockwise rotation by the given angle about the X axis."
					},
					{
						"name": "rotateY('angle')",
						"description": "Specifies a clockwise rotation by the given angle about the Y axis."
					},
					{
						"name": "rotateZ('angle')",
						"description": "Specifies a clockwise rotation by the given angle about the Z axis."
					},
					{
						"name": "scale()",
						"description": "Specifies a 2D scale operation by the [sx,sy] scaling vector described by the 2 parameters. If the second parameter is not provided, it is takes a value equal to the first."
					},
					{
						"name": "scale3d()",
						"description": "Specifies a 3D scale operation by the [sx,sy,sz] scaling vector described by the 3 parameters."
					},
					{
						"name": "scaleX()",
						"description": "Specifies a scale operation using the [sx,1] scaling vector, where sx is given as the parameter."
					},
					{
						"name": "scaleY()",
						"description": "Specifies a scale operation using the [sy,1] scaling vector, where sy is given as the parameter."
					},
					{
						"name": "scaleZ()",
						"description": "Specifies a scale operation using the [1,1,sz] scaling vector, where sz is given as the parameter."
					},
					{
						"name": "skew()",
						"description": "Specifies a skew transformation along the X and Y axes. The first angle parameter specifies the skew on the X axis. The second angle parameter specifies the skew on the Y axis. If the second parameter is not given then a value of 0 is used for the Y angle (ie: no skew on the Y axis)."
					},
					{
						"name": "skewX()",
						"description": "Specifies a skew transformation along the X axis by the given angle."
					},
					{
						"name": "skewY()",
						"description": "Specifies a skew transformation along the Y axis by the given angle."
					},
					{
						"name": "translate()",
						"description": "Specifies a 2D translation by the vector [tx, ty], where tx is the first translation-value parameter and ty is the optional second translation-value parameter."
					},
					{
						"name": "translate3d()",
						"description": "Specifies a 3D translation by the vector [tx,ty,tz], with tx, ty and tz being the first, second and third translation-value parameters respectively."
					},
					{
						"name": "translateX()",
						"description": "Specifies a translation by the given amount in the X direction."
					},
					{
						"name": "translateY()",
						"description": "Specifies a translation by the given amount in the Y direction."
					},
					{
						"name": "translateZ()",
						"description": "Specifies a translation by the given amount in the Z direction. Note that percentage values are not allowed in the translateZ translation-value, and if present are evaluated as 0."
					}
				],
				"syntax": "none | <transform-list>",
				"relevance": 88,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/transform"
					}
				],
				"description": "A two-dimensional transformation is applied to an element through the 'transform' property. This property contains a list of transform functions similar to those allowed by SVG.",
				"restrictions": [
					"enum"
				]
			},
			{
				"name": "transform-origin",
				"syntax": "[ <length-percentage> | left | center | right | top | bottom ] | [ [ <length-percentage> | left | center | right ] && [ <length-percentage> | top | center | bottom ] ] <length>?",
				"relevance": 74,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/transform-origin"
					}
				],
				"description": "Establishes the origin of transformation for an element.",
				"restrictions": [
					"position",
					"length",
					"percentage"
				]
			},
			{
				"name": "transition",
				"values": [
					{
						"name": "all",
						"description": "Every property that is able to undergo a transition will do so."
					},
					{
						"name": "none",
						"description": "No property will transition."
					}
				],
				"syntax": "<single-transition>#",
				"relevance": 87,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/transition"
					}
				],
				"description": "Shorthand property combines four of the transition properties into a single property.",
				"restrictions": [
					"time",
					"property",
					"timing-function",
					"enum"
				]
			},
			{
				"name": "transition-delay",
				"syntax": "<time>#",
				"relevance": 62,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/transition-delay"
					}
				],
				"description": "Defines when the transition will start. It allows a transition to begin execution some period of time from when it is applied.",
				"restrictions": [
					"time"
				]
			},
			{
				"name": "transition-duration",
				"syntax": "<time>#",
				"relevance": 62,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/transition-duration"
					}
				],
				"description": "Specifies how long the transition from the old value to the new value should take.",
				"restrictions": [
					"time"
				]
			},
			{
				"name": "transition-property",
				"values": [
					{
						"name": "all",
						"description": "Every property that is able to undergo a transition will do so."
					},
					{
						"name": "none",
						"description": "No property will transition."
					}
				],
				"syntax": "none | <single-transition-property>#",
				"relevance": 64,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/transition-property"
					}
				],
				"description": "Specifies the name of the CSS property to which the transition is applied.",
				"restrictions": [
					"property"
				]
			},
			{
				"name": "transition-timing-function",
				"syntax": "<timing-function>#",
				"relevance": 60,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/transition-timing-function"
					}
				],
				"description": "Describes how the intermediate values used during a transition will be calculated.",
				"restrictions": [
					"timing-function"
				]
			},
			{
				"name": "unicode-bidi",
				"values": [
					{
						"name": "bidi-override",
						"description": "Inside the element, reordering is strictly in sequence according to the 'direction' property; the implicit part of the bidirectional algorithm is ignored."
					},
					{
						"name": "embed",
						"description": "If the element is inline-level, this value opens an additional level of embedding with respect to the bidirectional algorithm. The direction of this embedding level is given by the 'direction' property."
					},
					{
						"name": "isolate",
						"description": "The contents of the element are considered to be inside a separate, independent paragraph."
					},
					{
						"name": "isolate-override",
						"description": "This combines the isolation behavior of 'isolate' with the directional override behavior of 'bidi-override'"
					},
					{
						"name": "normal",
						"description": "The element does not open an additional level of embedding with respect to the bidirectional algorithm. For inline-level elements, implicit reordering works across element boundaries."
					},
					{
						"name": "plaintext",
						"description": "For the purposes of the Unicode bidirectional algorithm, the base directionality of each bidi paragraph for which the element forms the containing block is determined not by the element's computed 'direction'."
					}
				],
				"syntax": "normal | embed | isolate | bidi-override | isolate-override | plaintext",
				"relevance": 57,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/unicode-bidi"
					}
				],
				"description": "The level of embedding with respect to the bidirectional algorithm.",
				"restrictions": [
					"enum"
				]
			},
			{
				"name": "visibility",
				"values": [
					{
						"name": "collapse",
						"description": "Table-specific. If used on elements other than rows, row groups, columns, or column groups, 'collapse' has the same meaning as 'hidden'."
					},
					{
						"name": "hidden",
						"description": "The generated box is invisible (fully transparent, nothing is drawn), but still affects layout."
					},
					{
						"name": "visible",
						"description": "The generated box is visible."
					}
				],
				"syntax": "visible | hidden | collapse",
				"relevance": 88,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/visibility"
					}
				],
				"description": "Specifies whether the boxes generated by an element are rendered. Invisible boxes still affect layout (set the ‘display’ property to ‘none’ to suppress box generation altogether).",
				"restrictions": [
					"enum"
				]
			},
			{
				"name": "white-space",
				"values": [
					{
						"name": "normal",
						"description": "Sets 'white-space-collapsing' to 'collapse' and 'text-wrap' to 'normal'."
					},
					{
						"name": "nowrap",
						"description": "Sets 'white-space-collapsing' to 'collapse' and 'text-wrap' to 'none'."
					},
					{
						"name": "pre",
						"description": "Sets 'white-space-collapsing' to 'preserve' and 'text-wrap' to 'none'."
					},
					{
						"name": "pre-line",
						"description": "Sets 'white-space-collapsing' to 'preserve-breaks' and 'text-wrap' to 'normal'."
					},
					{
						"name": "pre-wrap",
						"description": "Sets 'white-space-collapsing' to 'preserve' and 'text-wrap' to 'normal'."
					}
				],
				"syntax": "normal | pre | nowrap | pre-wrap | pre-line | break-spaces",
				"relevance": 88,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/white-space"
					}
				],
				"description": "Shorthand property for the 'white-space-collapsing' and 'text-wrap' properties.",
				"restrictions": [
					"enum"
				]
			},
			{
				"name": "width",
				"values": [
					{
						"name": "auto",
						"description": "The width depends on the values of other properties."
					},
					{
						"name": "fit-content",
						"description": "Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."
					},
					{
						"name": "max-content",
						"description": "Use the max-content inline size or max-content block size, as appropriate to the writing mode."
					},
					{
						"name": "min-content",
						"description": "Use the min-content inline size or min-content block size, as appropriate to the writing mode."
					}
				],
				"syntax": "<viewport-length>{1,2}",
				"relevance": 96,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/width"
					}
				],
				"description": "Specifies the width of the content area, padding area or border area (depending on 'box-sizing') of certain boxes.",
				"restrictions": [
					"length",
					"percentage"
				]
			},
			{
				"name": "word-break",
				"values": [
					{
						"name": "break-all",
						"description": "Lines may break between any two grapheme clusters for non-CJK scripts."
					},
					{
						"name": "keep-all",
						"description": "Block characters can no longer create implied break points."
					},
					{
						"name": "normal",
						"description": "Breaks non-CJK scripts according to their own rules."
					}
				],
				"syntax": "normal | break-all | keep-all | break-word",
				"relevance": 72,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/word-break"
					}
				],
				"description": "Specifies line break opportunities for non-CJK scripts.",
				"restrictions": [
					"enum"
				]
			},
			{
				"name": "z-index",
				"values": [
					{
						"name": "auto",
						"description": "The stack level of the generated box in the current stacking context is 0. The box does not establish a new stacking context unless it is the root element."
					}
				],
				"syntax": "auto | <integer>",
				"relevance": 91,
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/z-index"
					}
				],
				"description": "For a positioned box, the 'z-index' property specifies the stack level of the box in the current stacking context and whether the box establishes a local stacking context.",
				"restrictions": [
					"integer"
				]
			}
		],
		"atDirectives": [
			{
				"name": "@charset",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/@charset"
					}
				],
				"description": "Defines character set of the document."
			},
			{
				"name": "@counter-style",
				"browsers": [
					"FF33"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/@counter-style"
					}
				],
				"description": "Defines a custom counter style."
			},
			{
				"name": "@font-face",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/@font-face"
					}
				],
				"description": "Allows for linking to fonts that are automatically activated when needed. This permits authors to work around the limitation of 'web-safe' fonts, allowing for consistent rendering independent of the fonts available in a given user's environment."
			},
			{
				"name": "@font-feature-values",
				"browsers": [
					"FF34",
					"S9.1"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/@font-feature-values"
					}
				],
				"description": "Defines named values for the indices used to select alternate glyphs for a given font family."
			},
			{
				"name": "@import",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/@import"
					}
				],
				"description": "Includes content of another file."
			},
			{
				"name": "@keyframes",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/@keyframes"
					}
				],
				"description": "Defines set of animation key frames."
			},
			{
				"name": "@media",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/@media"
					}
				],
				"description": "Defines a stylesheet for a particular media type."
			},
			{
				"name": "@-moz-document",
				"browsers": [
					"FF1.8"
				],
				"description": "Gecko-specific at-rule that restricts the style rules contained within it based on the URL of the document."
			},
			{
				"name": "@-moz-keyframes",
				"browsers": [
					"FF5"
				],
				"description": "Defines set of animation key frames."
			},
			{
				"name": "@-ms-viewport",
				"browsers": [
					"E",
					"IE10"
				],
				"description": "Specifies the size, zoom factor, and orientation of the viewport."
			},
			{
				"name": "@namespace",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/@namespace"
					}
				],
				"description": "Declares a prefix and associates it with a namespace name."
			},
			{
				"name": "@-o-keyframes",
				"browsers": [
					"O12"
				],
				"description": "Defines set of animation key frames."
			},
			{
				"name": "@-o-viewport",
				"browsers": [
					"O11"
				],
				"description": "Specifies the size, zoom factor, and orientation of the viewport."
			},
			{
				"name": "@page",
				"browsers": [
					"E12",
					"FF19",
					"C2",
					"IE8",
					"O6"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/@page"
					}
				],
				"description": "Directive defines various page parameters."
			},
			{
				"name": "@supports",
				"browsers": [
					"E12",
					"FF22",
					"S9",
					"C28",
					"O12.1"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/@supports"
					}
				],
				"description": "A conditional group rule whose condition tests whether the user agent supports CSS property:value pairs."
			},
			{
				"name": "@-webkit-keyframes",
				"browsers": [
					"C",
					"S4"
				],
				"description": "Defines set of animation key frames."
			}
		],
		"pseudoClasses": [
			{
				"name": ":active",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:active"
					}
				],
				"description": "Applies while an element is being activated by the user. For example, between the times the user presses the mouse button and releases it."
			},
			{
				"name": ":any-link",
				"browsers": [
					"E79",
					"FF50",
					"S9",
					"C65",
					"O52"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:any-link"
					}
				],
				"description": "Represents an element that acts as the source anchor of a hyperlink. Applies to both visited and unvisited links."
			},
			{
				"name": ":checked",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:checked"
					}
				],
				"description": "Radio and checkbox elements can be toggled by the user. Some menu items are 'checked' when the user selects them. When such elements are toggled 'on' the :checked pseudo-class applies."
			},
			{
				"name": ":corner-present",
				"browsers": [
					"C",
					"S5"
				],
				"description": "Non-standard. Indicates whether or not a scrollbar corner is present."
			},
			{
				"name": ":decrement",
				"browsers": [
					"C",
					"S5"
				],
				"description": "Non-standard. Applies to buttons and track pieces. Indicates whether or not the button or track piece will decrement the view’s position when used."
			},
			{
				"name": ":default",
				"browsers": [
					"E79",
					"FF4",
					"S5",
					"C10",
					"O10"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:default"
					}
				],
				"description": "Applies to the one or more UI elements that are the default among a set of similar elements. Typically applies to context menu items, buttons, and select lists/menus."
			},
			{
				"name": ":disabled",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:disabled"
					}
				],
				"description": "Represents user interface elements that are in a disabled state; such elements have a corresponding enabled state."
			},
			{
				"name": ":double-button",
				"browsers": [
					"C",
					"S5"
				],
				"description": "Non-standard. Applies to buttons and track pieces. Applies when both buttons are displayed together at the same end of the scrollbar."
			},
			{
				"name": ":empty",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:empty"
					}
				],
				"description": "Represents an element that has no children at all."
			},
			{
				"name": ":enabled",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:enabled"
					}
				],
				"description": "Represents user interface elements that are in an enabled state; such elements have a corresponding disabled state."
			},
			{
				"name": ":end",
				"browsers": [
					"C",
					"S5"
				],
				"description": "Non-standard. Applies to buttons and track pieces. Indicates whether the object is placed after the thumb."
			},
			{
				"name": ":first",
				"browsers": [
					"E12",
					"S6",
					"C18",
					"IE8",
					"O9.2"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:first"
					}
				],
				"description": "When printing double-sided documents, the page boxes on left and right pages may be different. This can be expressed through CSS pseudo-classes defined in the  page context."
			},
			{
				"name": ":first-child",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:first-child"
					}
				],
				"description": "Same as :nth-child(1). Represents an element that is the first child of some other element."
			},
			{
				"name": ":first-of-type",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:first-of-type"
					}
				],
				"description": "Same as :nth-of-type(1). Represents an element that is the first sibling of its type in the list of children of its parent element."
			},
			{
				"name": ":focus",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:focus"
					}
				],
				"description": "Applies while an element has the focus (accepts keyboard or mouse events, or other forms of input)."
			},
			{
				"name": ":fullscreen",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:fullscreen"
					}
				],
				"description": "Matches any element that has its fullscreen flag set."
			},
			{
				"name": ":future",
				"browsers": [
					"C",
					"O16",
					"S6"
				],
				"description": "Represents any element that is defined to occur entirely after a :current element."
			},
			{
				"name": ":horizontal",
				"browsers": [
					"C",
					"S5"
				],
				"description": "Non-standard. Applies to any scrollbar pieces that have a horizontal orientation."
			},
			{
				"name": ":host",
				"browsers": [
					"E79",
					"FF63",
					"S10",
					"C54",
					"O41"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:host"
					}
				],
				"description": "When evaluated in the context of a shadow tree, matches the shadow tree’s host element."
			},
			{
				"name": ":host()",
				"browsers": [
					"C35",
					"O22"
				],
				"description": "When evaluated in the context of a shadow tree, it matches the shadow tree’s host element if the host element, in its normal context, matches the selector argument."
			},
			{
				"name": ":host-context()",
				"browsers": [
					"C35",
					"O22"
				],
				"description": "Tests whether there is an ancestor, outside the shadow tree, which matches a particular selector."
			},
			{
				"name": ":hover",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:hover"
					}
				],
				"description": "Applies while the user designates an element with a pointing device, but does not necessarily activate it. For example, a visual user agent could apply this pseudo-class when the cursor (mouse pointer) hovers over a box generated by the element."
			},
			{
				"name": ":increment",
				"browsers": [
					"C",
					"S5"
				],
				"description": "Non-standard. Applies to buttons and track pieces. Indicates whether or not the button or track piece will increment the view’s position when used."
			},
			{
				"name": ":indeterminate",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:indeterminate"
					}
				],
				"description": "Applies to UI elements whose value is in an indeterminate state."
			},
			{
				"name": ":in-range",
				"browsers": [
					"E13",
					"FF29",
					"S5.1",
					"C10",
					"O11"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:in-range"
					}
				],
				"description": "Used in conjunction with the min and max attributes, whether on a range input, a number field, or any other types that accept those attributes."
			},
			{
				"name": ":invalid",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:invalid"
					}
				],
				"description": "An element is :valid or :invalid when it is, respectively, valid or invalid with respect to data validity semantics defined by a different specification."
			},
			{
				"name": ":lang()",
				"browsers": [
					"E",
					"C",
					"FF1",
					"IE8",
					"O8",
					"S3"
				],
				"description": "Represents an element that is in language specified."
			},
			{
				"name": ":last-child",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:last-child"
					}
				],
				"description": "Same as :nth-last-child(1). Represents an element that is the last child of some other element."
			},
			{
				"name": ":last-of-type",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:last-of-type"
					}
				],
				"description": "Same as :nth-last-of-type(1). Represents an element that is the last sibling of its type in the list of children of its parent element."
			},
			{
				"name": ":left",
				"browsers": [
					"E12",
					"S5.1",
					"C6",
					"IE8",
					"O9.2"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:left"
					}
				],
				"description": "When printing double-sided documents, the page boxes on left and right pages may be different. This can be expressed through CSS pseudo-classes defined in the  page context."
			},
			{
				"name": ":link",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:link"
					}
				],
				"description": "Applies to links that have not yet been visited."
			},
			{
				"name": ":matches()",
				"browsers": [
					"S9"
				],
				"description": "Takes a selector list as its argument. It represents an element that is represented by its argument."
			},
			{
				"name": ":-moz-any()",
				"browsers": [
					"FF4"
				],
				"description": "Represents an element that is represented by the selector list passed as its argument. Standardized as :matches()."
			},
			{
				"name": ":-moz-any-link",
				"browsers": [
					"FF1"
				],
				"description": "Represents an element that acts as the source anchor of a hyperlink. Applies to both visited and unvisited links."
			},
			{
				"name": ":-moz-broken",
				"browsers": [
					"FF3"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:-moz-broken"
					}
				],
				"description": "Non-standard. Matches elements representing broken images."
			},
			{
				"name": ":-moz-drag-over",
				"browsers": [
					"FF1"
				],
				"description": "Non-standard. Matches elements when a drag-over event applies to it."
			},
			{
				"name": ":-moz-first-node",
				"browsers": [
					"FF1"
				],
				"description": "Non-standard. Represents an element that is the first child node of some other element."
			},
			{
				"name": ":-moz-focusring",
				"browsers": [
					"FF4"
				],
				"description": "Non-standard. Matches an element that has focus and focus ring drawing is enabled in the browser."
			},
			{
				"name": ":-moz-full-screen",
				"browsers": [
					"FF9"
				],
				"description": "Matches any element that has its fullscreen flag set. Standardized as :fullscreen."
			},
			{
				"name": ":-moz-last-node",
				"browsers": [
					"FF1"
				],
				"description": "Non-standard. Represents an element that is the last child node of some other element."
			},
			{
				"name": ":-moz-loading",
				"browsers": [
					"FF3"
				],
				"description": "Non-standard. Matches elements, such as images, that haven’t started loading yet."
			},
			{
				"name": ":-moz-only-whitespace",
				"browsers": [
					"FF1"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:-moz-only-whitespace"
					}
				],
				"description": "The same as :empty, except that it additionally matches elements that only contain code points affected by whitespace processing. Standardized as :blank."
			},
			{
				"name": ":-moz-placeholder",
				"browsers": [
					"FF4"
				],
				"description": "Deprecated. Represents placeholder text in an input field. Use ::-moz-placeholder for Firefox 19+."
			},
			{
				"name": ":-moz-submit-invalid",
				"browsers": [
					"FF4"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:-moz-submit-invalid"
					}
				],
				"description": "Non-standard. Represents any submit button when the contents of the associated form are not valid."
			},
			{
				"name": ":-moz-suppressed",
				"browsers": [
					"FF3"
				],
				"description": "Non-standard. Matches elements representing images that have been blocked from loading."
			},
			{
				"name": ":-moz-ui-invalid",
				"browsers": [
					"FF4"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:-moz-ui-invalid"
					}
				],
				"description": "Non-standard. Represents any validated form element whose value isn't valid "
			},
			{
				"name": ":-moz-ui-valid",
				"browsers": [
					"FF4"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:-moz-ui-valid"
					}
				],
				"description": "Non-standard. Represents any validated form element whose value is valid "
			},
			{
				"name": ":-moz-user-disabled",
				"browsers": [
					"FF3"
				],
				"description": "Non-standard. Matches elements representing images that have been disabled due to the user’s preferences."
			},
			{
				"name": ":-moz-window-inactive",
				"browsers": [
					"FF4"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:-moz-window-inactive"
					}
				],
				"description": "Non-standard. Matches elements in an inactive window."
			},
			{
				"name": ":-ms-fullscreen",
				"browsers": [
					"IE11"
				],
				"description": "Matches any element that has its fullscreen flag set."
			},
			{
				"name": ":-ms-input-placeholder",
				"browsers": [
					"IE10"
				],
				"description": "Represents placeholder text in an input field. Note: for Edge use the pseudo-element ::-ms-input-placeholder. Standardized as ::placeholder."
			},
			{
				"name": ":-ms-keyboard-active",
				"browsers": [
					"IE10"
				],
				"description": "Windows Store apps only. Applies one or more styles to an element when it has focus and the user presses the space bar."
			},
			{
				"name": ":-ms-lang()",
				"browsers": [
					"E",
					"IE10"
				],
				"description": "Represents an element that is in the language specified. Accepts a comma separated list of language tokens."
			},
			{
				"name": ":no-button",
				"browsers": [
					"C",
					"S5"
				],
				"description": "Non-standard. Applies to track pieces. Applies when there is no button at that end of the track."
			},
			{
				"name": ":not()",
				"browsers": [
					"E",
					"C",
					"FF1",
					"IE9",
					"O9.5",
					"S2"
				],
				"description": "The negation pseudo-class, :not(X), is a functional notation taking a simple selector (excluding the negation pseudo-class itself) as an argument. It represents an element that is not represented by its argument."
			},
			{
				"name": ":nth-child()",
				"browsers": [
					"E",
					"C",
					"FF3.5",
					"IE9",
					"O9.5",
					"S3.1"
				],
				"description": "Represents an element that has an+b-1 siblings before it in the document tree, for any positive integer or zero value of n, and has a parent element."
			},
			{
				"name": ":nth-last-child()",
				"browsers": [
					"E",
					"C",
					"FF3.5",
					"IE9",
					"O9.5",
					"S3.1"
				],
				"description": "Represents an element that has an+b-1 siblings after it in the document tree, for any positive integer or zero value of n, and has a parent element."
			},
			{
				"name": ":nth-last-of-type()",
				"browsers": [
					"E",
					"C",
					"FF3.5",
					"IE9",
					"O9.5",
					"S3.1"
				],
				"description": "Represents an element that has an+b-1 siblings with the same expanded element name after it in the document tree, for any zero or positive integer value of n, and has a parent element."
			},
			{
				"name": ":nth-of-type()",
				"browsers": [
					"E",
					"C",
					"FF3.5",
					"IE9",
					"O9.5",
					"S3.1"
				],
				"description": "Represents an element that has an+b-1 siblings with the same expanded element name before it in the document tree, for any zero or positive integer value of n, and has a parent element."
			},
			{
				"name": ":only-child",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:only-child"
					}
				],
				"description": "Represents an element that has a parent element and whose parent element has no other element children. Same as :first-child:last-child or :nth-child(1):nth-last-child(1), but with a lower specificity."
			},
			{
				"name": ":only-of-type",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:only-of-type"
					}
				],
				"description": "Matches every element that is the only child of its type, of its parent. Same as :first-of-type:last-of-type or :nth-of-type(1):nth-last-of-type(1), but with a lower specificity."
			},
			{
				"name": ":optional",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:optional"
					}
				],
				"description": "A form element is :required or :optional if a value for it is, respectively, required or optional before the form it belongs to is submitted. Elements that are not form elements are neither required nor optional."
			},
			{
				"name": ":out-of-range",
				"browsers": [
					"E13",
					"FF29",
					"S5.1",
					"C10",
					"O11"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:out-of-range"
					}
				],
				"description": "Used in conjunction with the min and max attributes, whether on a range input, a number field, or any other types that accept those attributes."
			},
			{
				"name": ":past",
				"browsers": [
					"C",
					"O16",
					"S6"
				],
				"description": "Represents any element that is defined to occur entirely prior to a :current element."
			},
			{
				"name": ":read-only",
				"browsers": [
					"E13",
					"FF78",
					"S4",
					"C1",
					"O9"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:read-only"
					}
				],
				"description": "An element whose contents are not user-alterable is :read-only. However, elements whose contents are user-alterable (such as text input fields) are considered to be in a :read-write state. In typical documents, most elements are :read-only."
			},
			{
				"name": ":read-write",
				"browsers": [
					"E13",
					"FF78",
					"S4",
					"C1",
					"O9"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:read-write"
					}
				],
				"description": "An element whose contents are not user-alterable is :read-only. However, elements whose contents are user-alterable (such as text input fields) are considered to be in a :read-write state. In typical documents, most elements are :read-only."
			},
			{
				"name": ":required",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:required"
					}
				],
				"description": "A form element is :required or :optional if a value for it is, respectively, required or optional before the form it belongs to is submitted. Elements that are not form elements are neither required nor optional."
			},
			{
				"name": ":right",
				"browsers": [
					"E12",
					"S5.1",
					"C6",
					"IE8",
					"O9.2"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:right"
					}
				],
				"description": "When printing double-sided documents, the page boxes on left and right pages may be different. This can be expressed through CSS pseudo-classes defined in the  page context."
			},
			{
				"name": ":root",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:root"
					}
				],
				"description": "Represents an element that is the root of the document. In HTML 4, this is always the HTML element."
			},
			{
				"name": ":scope",
				"browsers": [
					"E79",
					"FF32",
					"S7",
					"C27",
					"O15"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:scope"
					}
				],
				"description": "Represents any element that is in the contextual reference element set."
			},
			{
				"name": ":single-button",
				"browsers": [
					"C",
					"S5"
				],
				"description": "Non-standard. Applies to buttons and track pieces. Applies when both buttons are displayed separately at either end of the scrollbar."
			},
			{
				"name": ":start",
				"browsers": [
					"C",
					"S5"
				],
				"description": "Non-standard. Applies to buttons and track pieces. Indicates whether the object is placed before the thumb."
			},
			{
				"name": ":target",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:target"
					}
				],
				"description": "Some URIs refer to a location within a resource. This kind of URI ends with a 'number sign' (#) followed by an anchor identifier (called the fragment identifier)."
			},
			{
				"name": ":valid",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:valid"
					}
				],
				"description": "An element is :valid or :invalid when it is, respectively, valid or invalid with respect to data validity semantics defined by a different specification."
			},
			{
				"name": ":vertical",
				"browsers": [
					"C",
					"S5"
				],
				"description": "Non-standard. Applies to any scrollbar pieces that have a vertical orientation."
			},
			{
				"name": ":visited",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:visited"
					}
				],
				"description": "Applies once the link has been visited by the user."
			},
			{
				"name": ":-webkit-any()",
				"browsers": [
					"C",
					"S5"
				],
				"description": "Represents an element that is represented by the selector list passed as its argument. Standardized as :matches()."
			},
			{
				"name": ":-webkit-full-screen",
				"browsers": [
					"C",
					"S6"
				],
				"description": "Matches any element that has its fullscreen flag set. Standardized as :fullscreen."
			},
			{
				"name": ":window-inactive",
				"browsers": [
					"C",
					"S3"
				],
				"description": "Non-standard. Applies to all scrollbar pieces. Indicates whether or not the window containing the scrollbar is currently active."
			},
			{
				"name": ":blank",
				"status": "experimental",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:blank"
					}
				],
				"description": "The :blank CSS pseudo-class selects empty user input elements (eg. <input> or <textarea>)."
			},
			{
				"name": ":defined",
				"status": "experimental",
				"browsers": [
					"E79",
					"FF63",
					"S10",
					"C54",
					"O41"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:defined"
					}
				],
				"description": "The :defined CSS pseudo-class represents any element that has been defined. This includes any standard element built in to the browser, and custom elements that have been successfully defined (i.e. with the CustomElementRegistry.define() method)."
			},
			{
				"name": ":dir",
				"browsers": [
					"FF49"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:dir"
					}
				],
				"description": "The :dir() CSS pseudo-class matches elements based on the directionality of the text contained in them."
			},
			{
				"name": ":focus-visible",
				"status": "experimental",
				"browsers": [
					"E79",
					"FF4",
					"C67",
					"O54"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:focus-visible"
					}
				],
				"description": "The :focus-visible pseudo-class applies while an element matches the :focus pseudo-class and the UA determines via heuristics that the focus should be made evident on the element."
			},
			{
				"name": ":focus-within",
				"status": "experimental",
				"browsers": [
					"E79",
					"FF52",
					"S10.1",
					"C60",
					"O47"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:focus-within"
					}
				],
				"description": "The :focus-within pseudo-class applies to any element for which the :focus pseudo class applies as well as to an element whose descendant in the flat tree (including non-element nodes, such as text nodes) matches the conditions for matching :focus."
			},
			{
				"name": ":has",
				"status": "experimental",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:has"
					}
				],
				"description": ":The :has() CSS pseudo-class represents an element if any of the selectors passed as parameters (relative to the :scope of the given element), match at least one element."
			},
			{
				"name": ":is",
				"status": "experimental",
				"browsers": [
					"E79",
					"FF78",
					"S9",
					"C68",
					"O55"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:is"
					}
				],
				"description": "The :is() CSS pseudo-class function takes a selector list as its argument, and selects any element that can be selected by one of the selectors in that list. This is useful for writing large selectors in a more compact form."
			},
			{
				"name": ":placeholder-shown",
				"status": "experimental",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:placeholder-shown"
					}
				],
				"description": "The :placeholder-shown CSS pseudo-class represents any <input> or <textarea> element that is currently displaying placeholder text."
			},
			{
				"name": ":where",
				"status": "experimental",
				"browsers": [
					"FF78",
					"C72"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/:where"
					}
				],
				"description": "The :where() CSS pseudo-class function takes a selector list as its argument, and selects any element that can be selected by one of the selectors in that list."
			}
		],
		"pseudoElements": [
			{
				"name": "::after",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/::after"
					}
				],
				"description": "Represents a styleable child pseudo-element immediately after the originating element’s actual content."
			},
			{
				"name": "::backdrop",
				"browsers": [
					"E12",
					"FF47",
					"C37",
					"IE11",
					"O24"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/::backdrop"
					}
				],
				"description": "Used to create a backdrop that hides the underlying document for an element in a top layer (such as an element that is displayed fullscreen)."
			},
			{
				"name": "::before",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/::before"
					}
				],
				"description": "Represents a styleable child pseudo-element immediately before the originating element’s actual content."
			},
			{
				"name": "::content",
				"browsers": [
					"C35",
					"O22"
				],
				"description": "Deprecated. Matches the distribution list itself, on elements that have one. Use ::slotted for forward compatibility."
			},
			{
				"name": "::cue",
				"browsers": [
					"E79",
					"FF55",
					"S6.1",
					"C26",
					"O15"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/::cue"
					}
				]
			},
			{
				"name": "::cue()",
				"browsers": [
					"C",
					"O16",
					"S6"
				]
			},
			{
				"name": "::cue-region",
				"browsers": [
					"C",
					"O16",
					"S6"
				]
			},
			{
				"name": "::cue-region()",
				"browsers": [
					"C",
					"O16",
					"S6"
				]
			},
			{
				"name": "::first-letter",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/::first-letter"
					}
				],
				"description": "Represents the first letter of an element, if it is not preceded by any other content (such as images or inline tables) on its line."
			},
			{
				"name": "::first-line",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/::first-line"
					}
				],
				"description": "Describes the contents of the first formatted line of its originating element."
			},
			{
				"name": "::-moz-focus-inner",
				"browsers": [
					"FF4"
				]
			},
			{
				"name": "::-moz-focus-outer",
				"browsers": [
					"FF4"
				]
			},
			{
				"name": "::-moz-list-bullet",
				"browsers": [
					"FF1"
				],
				"description": "Used to style the bullet of a list element. Similar to the standardized ::marker."
			},
			{
				"name": "::-moz-list-number",
				"browsers": [
					"FF1"
				],
				"description": "Used to style the numbers of a list element. Similar to the standardized ::marker."
			},
			{
				"name": "::-moz-placeholder",
				"browsers": [
					"FF19"
				],
				"description": "Represents placeholder text in an input field"
			},
			{
				"name": "::-moz-progress-bar",
				"browsers": [
					"FF9"
				],
				"description": "Represents the bar portion of a progress bar."
			},
			{
				"name": "::-moz-selection",
				"browsers": [
					"FF1"
				],
				"description": "Represents the portion of a document that has been highlighted by the user."
			},
			{
				"name": "::-ms-backdrop",
				"browsers": [
					"IE11"
				],
				"description": "Used to create a backdrop that hides the underlying document for an element in a top layer (such as an element that is displayed fullscreen)."
			},
			{
				"name": "::-ms-browse",
				"browsers": [
					"E",
					"IE10"
				],
				"description": "Represents the browse button of an input type=file control."
			},
			{
				"name": "::-ms-check",
				"browsers": [
					"E",
					"IE10"
				],
				"description": "Represents the check of a checkbox or radio button input control."
			},
			{
				"name": "::-ms-clear",
				"browsers": [
					"E",
					"IE10"
				],
				"description": "Represents the clear button of a text input control"
			},
			{
				"name": "::-ms-expand",
				"browsers": [
					"E",
					"IE10"
				],
				"description": "Represents the drop-down button of a select control."
			},
			{
				"name": "::-ms-fill",
				"browsers": [
					"E",
					"IE10"
				],
				"description": "Represents the bar portion of a progress bar."
			},
			{
				"name": "::-ms-fill-lower",
				"browsers": [
					"E",
					"IE10"
				],
				"description": "Represents the portion of the slider track from its smallest value up to the value currently selected by the thumb. In a left-to-right layout, this is the portion of the slider track to the left of the thumb."
			},
			{
				"name": "::-ms-fill-upper",
				"browsers": [
					"E",
					"IE10"
				],
				"description": "Represents the portion of the slider track from the value currently selected by the thumb up to the slider's largest value. In a left-to-right layout, this is the portion of the slider track to the right of the thumb."
			},
			{
				"name": "::-ms-reveal",
				"browsers": [
					"E",
					"IE10"
				],
				"description": "Represents the password reveal button of an input type=password control."
			},
			{
				"name": "::-ms-thumb",
				"browsers": [
					"E",
					"IE10"
				],
				"description": "Represents the portion of range input control (also known as a slider control) that the user drags."
			},
			{
				"name": "::-ms-ticks-after",
				"browsers": [
					"E",
					"IE10"
				],
				"description": "Represents the tick marks of a slider that begin just after the thumb and continue up to the slider's largest value. In a left-to-right layout, these are the ticks to the right of the thumb."
			},
			{
				"name": "::-ms-ticks-before",
				"browsers": [
					"E",
					"IE10"
				],
				"description": "Represents the tick marks of a slider that represent its smallest values up to the value currently selected by the thumb. In a left-to-right layout, these are the ticks to the left of the thumb."
			},
			{
				"name": "::-ms-tooltip",
				"browsers": [
					"E",
					"IE10"
				],
				"description": "Represents the tooltip of a slider (input type=range)."
			},
			{
				"name": "::-ms-track",
				"browsers": [
					"E",
					"IE10"
				],
				"description": "Represents the track of a slider."
			},
			{
				"name": "::-ms-value",
				"browsers": [
					"E",
					"IE10"
				],
				"description": "Represents the content of a text or password input control, or a select control."
			},
			{
				"name": "::selection",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/::selection"
					}
				],
				"description": "Represents the portion of a document that has been highlighted by the user."
			},
			{
				"name": "::shadow",
				"browsers": [
					"C35",
					"O22"
				],
				"description": "Matches the shadow root if an element has a shadow tree."
			},
			{
				"name": "::-webkit-file-upload-button",
				"browsers": [
					"E79",
					"S3",
					"C1",
					"O15"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/::-webkit-file-upload-button"
					}
				]
			},
			{
				"name": "::-webkit-inner-spin-button",
				"browsers": [
					"E79",
					"S5",
					"C6",
					"O15"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/::-webkit-inner-spin-button"
					}
				]
			},
			{
				"name": "::-webkit-input-placeholder",
				"browsers": [
					"C",
					"S4"
				]
			},
			{
				"name": "::-webkit-keygen-select",
				"browsers": [
					"C",
					"O",
					"S6"
				]
			},
			{
				"name": "::-webkit-meter-bar",
				"browsers": [
					"E79",
					"S5.1",
					"C12",
					"O15"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/::-webkit-meter-bar"
					}
				]
			},
			{
				"name": "::-webkit-meter-even-less-good-value",
				"browsers": [
					"E79",
					"S5.1",
					"C12",
					"O15"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/::-webkit-meter-even-less-good-value"
					}
				]
			},
			{
				"name": "::-webkit-meter-optimum-value",
				"browsers": [
					"E79",
					"S5.1",
					"C12",
					"O15"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/::-webkit-meter-optimum-value"
					}
				]
			},
			{
				"name": "::-webkit-meter-suboptimum-value",
				"browsers": [
					"E79",
					"S5.1",
					"C12",
					"O15"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/::-webkit-meter-suboptimum-value"
					}
				]
			},
			{
				"name": "::-webkit-outer-spin-button",
				"browsers": [
					"S5",
					"C6"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/::-webkit-outer-spin-button"
					}
				]
			},
			{
				"name": "::-webkit-progress-bar",
				"browsers": [
					"E79",
					"S6.1",
					"C25",
					"O15"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/::-webkit-progress-bar"
					}
				]
			},
			{
				"name": "::-webkit-progress-inner-element",
				"browsers": [
					"E79",
					"S6.1",
					"C23",
					"O15"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/::-webkit-progress-inner-element"
					}
				]
			},
			{
				"name": "::-webkit-progress-value",
				"browsers": [
					"E79",
					"S6.1",
					"C25",
					"O15"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/::-webkit-progress-value"
					}
				]
			},
			{
				"name": "::-webkit-resizer",
				"browsers": [
					"E79",
					"S4",
					"C2",
					"O15"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/::-webkit-scrollbar"
					}
				]
			},
			{
				"name": "::-webkit-scrollbar",
				"browsers": [
					"E79",
					"S4",
					"C2",
					"O15"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/::-webkit-scrollbar"
					}
				]
			},
			{
				"name": "::-webkit-scrollbar-button",
				"browsers": [
					"E79",
					"S4",
					"C2",
					"O15"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/::-webkit-scrollbar"
					}
				]
			},
			{
				"name": "::-webkit-scrollbar-corner",
				"browsers": [
					"E79",
					"S4",
					"C2",
					"O15"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/::-webkit-scrollbar"
					}
				]
			},
			{
				"name": "::-webkit-scrollbar-thumb",
				"browsers": [
					"E79",
					"S4",
					"C2",
					"O15"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/::-webkit-scrollbar"
					}
				]
			},
			{
				"name": "::-webkit-scrollbar-track",
				"browsers": [
					"E79",
					"S4",
					"C2",
					"O15"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/::-webkit-scrollbar"
					}
				]
			},
			{
				"name": "::-webkit-scrollbar-track-piece",
				"browsers": [
					"E79",
					"S4",
					"C2",
					"O15"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/::-webkit-scrollbar"
					}
				]
			},
			{
				"name": "::-webkit-search-cancel-button",
				"browsers": [
					"E79",
					"S3",
					"C1",
					"O15"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/::-webkit-search-cancel-button"
					}
				]
			},
			{
				"name": "::-webkit-search-decoration",
				"browsers": [
					"C",
					"S4"
				]
			},
			{
				"name": "::-webkit-search-results-button",
				"browsers": [
					"E79",
					"S3",
					"C1",
					"O15"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/::-webkit-search-results-button"
					}
				]
			},
			{
				"name": "::-webkit-search-results-decoration",
				"browsers": [
					"C",
					"S4"
				]
			},
			{
				"name": "::-webkit-slider-runnable-track",
				"browsers": [
					"C",
					"O",
					"S6"
				]
			},
			{
				"name": "::-webkit-slider-thumb",
				"browsers": [
					"C",
					"O",
					"S6"
				]
			},
			{
				"name": "::-webkit-textfield-decoration-container",
				"browsers": [
					"C",
					"O",
					"S6"
				]
			},
			{
				"name": "::-webkit-validation-bubble",
				"browsers": [
					"C",
					"O",
					"S6"
				]
			},
			{
				"name": "::-webkit-validation-bubble-arrow",
				"browsers": [
					"C",
					"O",
					"S6"
				]
			},
			{
				"name": "::-webkit-validation-bubble-arrow-clipper",
				"browsers": [
					"C",
					"O",
					"S6"
				]
			},
			{
				"name": "::-webkit-validation-bubble-heading",
				"browsers": [
					"C",
					"O",
					"S6"
				]
			},
			{
				"name": "::-webkit-validation-bubble-message",
				"browsers": [
					"C",
					"O",
					"S6"
				]
			},
			{
				"name": "::-webkit-validation-bubble-text-block",
				"browsers": [
					"C",
					"O",
					"S6"
				]
			},
			{
				"name": "::-moz-range-progress",
				"status": "nonstandard",
				"browsers": [
					"FF22"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/::-moz-range-progress"
					}
				],
				"description": "The ::-moz-range-progress CSS pseudo-element is a Mozilla extension that represents the lower portion of the track (i.e., groove) in which the indicator slides in an <input> of type=\"range\". This portion corresponds to values lower than the value currently selected by the thumb (i.e., virtual knob)."
			},
			{
				"name": "::-moz-range-thumb",
				"status": "nonstandard",
				"browsers": [
					"FF21"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/::-moz-range-thumb"
					}
				],
				"description": "The ::-moz-range-thumb CSS pseudo-element is a Mozilla extension that represents the thumb (i.e., virtual knob) of an <input> of type=\"range\". The user can move the thumb along the input's track to alter its numerical value."
			},
			{
				"name": "::-moz-range-track",
				"status": "nonstandard",
				"browsers": [
					"FF21"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/::-moz-range-track"
					}
				],
				"description": "The ::-moz-range-track CSS pseudo-element is a Mozilla extension that represents the track (i.e., groove) in which the indicator slides in an <input> of type=\"range\"."
			},
			{
				"name": "::-webkit-progress-inner-value",
				"status": "nonstandard",
				"description": "The ::-webkit-progress-value CSS pseudo-element represents the filled-in portion of the bar of a <progress> element. It is a child of the ::-webkit-progress-bar pseudo-element.\n\nIn order to let ::-webkit-progress-value take effect, -webkit-appearance needs to be set to none on the <progress> element."
			},
			{
				"name": "::grammar-error",
				"status": "experimental",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/::grammar-error"
					}
				],
				"description": "The ::grammar-error CSS pseudo-element represents a text segment which the user agent has flagged as grammatically incorrect."
			},
			{
				"name": "::marker",
				"browsers": [
					"E80",
					"FF68",
					"S11.1",
					"C80"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/::marker"
					}
				],
				"description": "The ::marker CSS pseudo-element selects the marker box of a list item, which typically contains a bullet or number. It works on any element or pseudo-element set to display: list-item, such as the <li> and <summary> elements."
			},
			{
				"name": "::part",
				"status": "experimental",
				"browsers": [
					"E79",
					"FF72",
					"S13.1",
					"C73",
					"O60"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/::part"
					}
				],
				"description": "The ::part CSS pseudo-element represents any element within a shadow tree that has a matching part attribute."
			},
			{
				"name": "::placeholder",
				"browsers": [
					"E12",
					"FF51",
					"S10.1",
					"C57",
					"O44"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/::placeholder"
					}
				],
				"description": "The ::placeholder CSS pseudo-element represents the placeholder text of a form element."
			},
			{
				"name": "::slotted",
				"browsers": [
					"E79",
					"FF63",
					"S10",
					"C50",
					"O37"
				],
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/::slotted"
					}
				],
				"description": "The :slotted() CSS pseudo-element represents any element that has been placed into a slot inside an HTML template."
			},
			{
				"name": "::spelling-error",
				"status": "experimental",
				"references": [
					{
						"name": "MDN Reference",
						"url": "https://developer.mozilla.org/docs/Web/CSS/::spelling-error"
					}
				],
				"description": "The ::spelling-error CSS pseudo-element represents a text segment which the user agent has flagged as incorrectly spelled."
			}
		]
	};
});
