interface muPDF {
	/** 申请存储权限，仅支持Android*/ 
	requestPermission():void

	/**
	 * `打开PDF文件`
	 * ========params==========
	 *
	 * `path` :string : 文件所在路径（本地路径或网络路径）
	 *
	 * `fileName` :string : 文件名（**需要添加 .pdf 后缀**），下载并保存到本地的自定义文件名称
	 *
	 * `showLoading` :boolean : 是否打开进度提示框
	 *
	 * `diaLogStyle` :string : 弹出框类型
	 *
	 * `isPrivate` :boolean : 仅Android支持，下载pdf文件时是否存储在私有目录
	 */
	viewpdfFile(params:muPDF_viewpdfFile_Params, callback?: (ret:JSON) => void):void

}
interface muPDF_viewpdfFile_Params {
	/**文件所在路径（本地路径或网络路径）*/ 
	path:string,

	/**文件名（**需要添加 .pdf 后缀**），下载并保存到本地的自定义文件名称*/ 
	fileName:string,

	/**是否打开进度提示框*/ 
	showLoading:boolean,

	/**弹出框类型*/ 
	diaLogStyle:string,

	/**仅Android支持，下载pdf文件时是否存储在私有目录*/ 
	isPrivate:boolean,

}

interface mailUtils {
	/** 设置本地账号*/ 
	setFromAddres(callback?: (ret:JSON, err:JSON) => void):void

	/** 发送邮件*/ 
	sendEmail(callback?: (ret:JSON, err:JSON) => void):void

}
interface helper {
	/** 初始化参数，将要监听的应用包名传入即可，不传默认监听所有应用。*/ 
	init():void

	/** 传入需要点击事件的控件id，窗口出现该控件时会自动点击该控件。*/ 
	click():void

	/** 传入需要长按事件的控件id，窗口出现该控件时会自动长按该控件。*/ 
	longClick():void

	/** 传入需要粘贴文本的控件id，窗口出现控件时会自动将粘贴板上的内容粘贴到该控件上。*/ 
	paste():void

}
interface phoneStatusOB {
	/** 设置电话状态监听，*/ 
	setCallListener(callback?: (ret:JSON, err:JSON) => void):void

	/** 取消电话状态监听*/ 
	cancleCallListener(callback?: (ret:JSON, err:JSON) => void):void

}
interface vpnIOS {
	/** 打开vpn代理*/ 
	vpnStart():void

	/** 打开vpn代理*/ 
	vpnStop():void

}
interface jlLangDetect {
	/**
	 * `语言检测`
	 * ========params==========
	 *
	 * `text` :string : 文本内容
	 */
	detect(params:jlLangDetect_detect_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface jlLangDetect_detect_Params {
	/**文本内容*/ 
	text:string,

}

interface fileDetect {
	/** 打开系统文件选择，选择文件后返回路径。注意：由于Android11文件沙盒存储模式，尽量从侧边栏手机图片进去，从”最近“、“下载”等其他路径访问可能无法拿到文件真实路径。*/ 
	select(callback?: (ret:JSON, err:JSON) => void):void

	/** 把公用文件复制到APP私有目录中，用于适配Android11 选择共有目录文件上传失败的问题*/ 
	copyToInnerStorage(callback?: (ret:JSON) => void):void

	/** 传入文件url获取文件类型*/ 
	getFileType(callback?: (ret:JSON) => void):void

}
interface sendMail {
	/**
	 * `发送简单文本邮件`
	 * ========params==========
	 *
	 * `host` :string : （可选项）smtp地址
	 *
	 * `port` :number : （可选项）smtp端口
	 *
	 * `sendName` :string : （必填项）发送方名称。
	 *
	 * `fromUser` :string : （必填项）发送方邮件地址。
	 *
	 * `password` :string : （必填项）邮箱POP3/SMTP服务授权码。
	 *
	 * `receiveUser` :string : （必填项）接受方邮件地址。
	 *
	 * `title` :string : （必填项）设置邮件标题。
	 *
	 * `content` :string : （必填项）设置邮件内容。
	 */
	sendText(params:sendMail_sendText_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `发送html文本邮件`
	 * ========params==========
	 *
	 * `host` :string : （可选项）smtp地址
	 *
	 * `port` :number : （可选项）smtp端口
	 *
	 * `sendName` :string : （必填项）发送方名称。
	 *
	 * `fromUser` :string : （必填项）发送方邮件地址。
	 *
	 * `password` :string : （必填项）邮箱POP3/SMTP服务授权码。
	 *
	 * `receiveUser` :string : （必填项）接受方邮件地址。
	 *
	 * `title` :string : （必填项）设置邮件标题。
	 *
	 * `content` :string : （必填项）设置邮件html内容。
	 */
	sendHtml(params:sendMail_sendHtml_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `发送带附件邮件`
	 * ========params==========
	 *
	 * `host` :string : （可选项）smtp地址
	 *
	 * `port` :number : （可选项）smtp端口
	 *
	 * `sendName` :string : （必填项）发送方名称。
	 *
	 * `fromUser` :string : （必填项）发送方邮件地址。
	 *
	 * `password` :string : （必填项）邮箱POP3/SMTP服务授权码。
	 *
	 * `receiveUser` :string : （必填项）接受方邮件地址。
	 *
	 * `title` :string : （必填项）设置邮件标题。
	 *
	 * `content` :string : （必填项）设置邮件html内容。
	 *
	 * `paths` :Array : （必填项）需要发送附件文件列表(支持fs://、widget://路径,widget://路径不支持大文件)。
	 */
	sendFile(params:sendMail_sendFile_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface sendMail_sendText_Params {
	/**（可选项）smtp地址*/ 
	host?:string,

	/**（可选项）smtp端口*/ 
	port?:number,

	/**（必填项）发送方名称。*/ 
	sendName:string,

	/**（必填项）发送方邮件地址。*/ 
	fromUser:string,

	/**（必填项）邮箱POP3/SMTP服务授权码。*/ 
	password:string,

	/**（必填项）接受方邮件地址。*/ 
	receiveUser:string,

	/**（必填项）设置邮件标题。*/ 
	title:string,

	/**（必填项）设置邮件内容。*/ 
	content:string,

}

interface sendMail_sendHtml_Params {
	/**（可选项）smtp地址*/ 
	host?:string,

	/**（可选项）smtp端口*/ 
	port?:number,

	/**（必填项）发送方名称。*/ 
	sendName:string,

	/**（必填项）发送方邮件地址。*/ 
	fromUser:string,

	/**（必填项）邮箱POP3/SMTP服务授权码。*/ 
	password:string,

	/**（必填项）接受方邮件地址。*/ 
	receiveUser:string,

	/**（必填项）设置邮件标题。*/ 
	title:string,

	/**（必填项）设置邮件html内容。*/ 
	content:string,

}

interface sendMail_sendFile_Params {
	/**（可选项）smtp地址*/ 
	host?:string,

	/**（可选项）smtp端口*/ 
	port?:number,

	/**（必填项）发送方名称。*/ 
	sendName:string,

	/**（必填项）发送方邮件地址。*/ 
	fromUser:string,

	/**（必填项）邮箱POP3/SMTP服务授权码。*/ 
	password:string,

	/**（必填项）接受方邮件地址。*/ 
	receiveUser:string,

	/**（必填项）设置邮件标题。*/ 
	title:string,

	/**（必填项）设置邮件html内容。*/ 
	content:string,

	/**（必填项）需要发送附件文件列表(支持fs://、widget://路径,widget://路径不支持大文件)。*/ 
	paths:Array,

}

interface audioTrans {
	/**
	 * `将wav音频格式转换为amr格式。仅支持 api.startRecord 录制的音频`
	 * ========params==========
	 *
	 * `path` :string : mp3音频路径,支持本地路径（widget://、fs://）或绝对路径
	 */
	wavToAmr(params:audioTrans_wavToAmr_Params, callback?: (ret:JSON) => void):void

	/**
	 * `将amr音频格式转换为wav格式。`
	 * ========params==========
	 *
	 * `path` :string : amr音频路径,支持本地路径（widget://、fs://）或绝对路径
	 */
	amrToWav(params:audioTrans_amrToWav_Params, callback?: (ret:JSON) => void):void

	/** 清除音频文件本地缓存。*/ 
	clearCache():void

}
interface audioTrans_wavToAmr_Params {
	/**mp3音频路径,支持本地路径（widget://、fs://）或绝对路径*/ 
	path:string,

}

interface audioTrans_amrToWav_Params {
	/**amr音频路径,支持本地路径（widget://、fs://）或绝对路径*/ 
	path:string,

}

interface imageHandle {
	/**
	 * `设置马赛克`
	 * ========params==========
	 *
	 * `path` :string : 图片路径，支持fs、widget
	 */
	setMosaic(params:imageHandle_setMosaic_Params, callback?: (ret:JSON) => void):void

	/**
	 * `添加图片水印`
	 * ========params==========
	 *
	 * `path` :string : 图片路径，支持fs、widget
	 *
	 * `waterPath` :string : 水印图片路径，支持fs、widget
	 *
	 * `waterRect` :JSON : （可选项）水印图片的位置及尺寸
	 */
	setWatermark(params:imageHandle_setWatermark_Params, callback?: (ret:JSON) => void):void

	/**
	 * `设置文字水印`
	 * ========params==========
	 *
	 * `path` :string : 图片路径，支持fs、widget
	 *
	 * `text` :string : 文字内容
	 *
	 * `textPoint` :JSON : （可选项）文字水印的位置
	 *
	 * `textColor` :string : (可选项)文字颜色，支持rgb、rgba、#
	 *
	 * `textFont` :number : (可选项)文字的大小
	 */
	setText(params:imageHandle_setText_Params, callback?: (ret:JSON) => void):void

	/**
	 * `给图片添加水印`
	 * ========params==========
	 *
	 * `image` :string : 图片路径，支持fs、widget、box、系统本地路径
	 *
	 * `watermark` :JSON : 水印
	 */
	addImageWaterMark(params:imageHandle_addImageWaterMark_Params, callback?: (ret:JSON) => void):void

}
interface imageHandle_setMosaic_Params {
	/**图片路径，支持fs、widget*/ 
	path:string,

}

interface imageHandle_setWatermark_Params {
	/**图片路径，支持fs、widget*/ 
	path:string,

	/**水印图片路径，支持fs、widget*/ 
	waterPath:string,

	/**（可选项）水印图片的位置及尺寸*/ 
	waterRect?:JSON,

}

interface imageHandle_setText_Params {
	/**图片路径，支持fs、widget*/ 
	path:string,

	/**文字内容*/ 
	text:string,

	/**（可选项）文字水印的位置*/ 
	textPoint?:JSON,

	/**(可选项)文字颜色，支持rgb、rgba、#*/ 
	textColor?:string,

	/**(可选项)文字的大小*/ 
	textFont?:number,

}

interface imageHandle_addImageWaterMark_Params {
	/**图片路径，支持fs、widget、box、系统本地路径*/ 
	image:string,

	/**水印*/ 
	watermark:JSON,

}

interface callLog {
	/**
	 * `获取通话记录`
	 * ========params==========
	 *
	 * `pageSize` :number : (可选项)分页获取，一页数量，默认获取所有
	 *
	 * `page` :number : （可选项）页数，从0开始
	 */
	loadCallLog(params:callLog_loadCallLog_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface callLog_loadCallLog_Params {
	/**(可选项)分页获取，一页数量，默认获取所有*/ 
	pageSize?:number,

	/**（可选项）页数，从0开始*/ 
	page?:number,

}

interface moduleXdlScan {
}
interface QRScan {
	/**
	 * `打开可自定义的二维码/条形码扫描器`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）扫描器的位置及尺寸
	 *
	 * `rectOfInterest` :JSON : （可选项）在扫码区域上的扫码识别区域
	 *
	 * `scanLine` :JSON : （可选项）扫描线配置
	 *
	 * `isShowClose` :boolean : （可选项）是否显示扫描界面关闭按钮
	 *
	 * `closeButton` :JSON : （可选项）关闭按钮图标设置
	 *
	 * `maskColor` :string : （可选项）遮罩层色值，支持rgba、rgb、#
	 *
	 * `tipString` :string : （可选项）识别框下面的提示文字
	 *
	 * `marginB` :number : （可选项）打开手电筒按钮距离底部的距离
	 *
	 * `sound` :string : （可选项）扫描结束后的提示音文件路径，要求本地路径（fs://、widget://），**为保证兼容性，推荐使用 wav 格式的短音频文件**
	 *
	 * `formatType` :string : (可选项) 二维码与一维码的类型
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	customizedScanner(params:QRScan_customizedScanner_Params, callback?: (ret:JSON) => void):void

	/** 关闭自定义大小的二维码/条码扫描器*/ 
	closeCustomizedScanner():void

	/** 显示自定义大小的二维码/条码扫描器*/ 
	showCustomizedScanner():void

	/** 关闭自定义大小的二维码/条码扫描器*/ 
	hideCustomizedScanner():void

	/**
	 * `打开/关闭闪光灯（在Android上，已打开扫码视图时有效）`
	 * ========params==========
	 *
	 * `status` :string : （可选项）打开/关闭闪光灯，默认值：'off'
	 */
	switchLight(params:QRScan_switchLight_Params):void

	/**
	 * `直接识别图片`
	 * ========params==========
	 *
	 * `imagePath` :string : 要识别的图片路径，要求本地路径（fs://）
	 *
	 * `formatType` :string : (可选项) 二维码与一维码的类型
	 */
	scanPictureDirect(params:QRScan_scanPictureDirect_Params, callback?: (ret:JSON) => void):void

}
interface QRScan_customizedScanner_Params {
	/**（可选项）扫描器的位置及尺寸*/ 
	rect?:JSON,

	/**（可选项）在扫码区域上的扫码识别区域*/ 
	rectOfInterest?:JSON,

	/**（可选项）扫描线配置*/ 
	scanLine?:JSON,

	/**（可选项）是否显示扫描界面关闭按钮*/ 
	isShowClose?:boolean,

	/**（可选项）关闭按钮图标设置*/ 
	closeButton?:JSON,

	/**（可选项）遮罩层色值，支持rgba、rgb、#*/ 
	maskColor?:string,

	/**（可选项）识别框下面的提示文字*/ 
	tipString?:string,

	/**（可选项）打开手电筒按钮距离底部的距离*/ 
	marginB?:number,

	/**（可选项）扫描结束后的提示音文件路径，要求本地路径（fs://、widget://），**为保证兼容性，推荐使用 wav 格式的短音频文件***/ 
	sound?:string,

	/**(可选项) 二维码与一维码的类型*/ 
	formatType?:string,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface QRScan_switchLight_Params {
	/**（可选项）打开/关闭闪光灯，默认值：'off'*/ 
	status?:string,

}

interface QRScan_scanPictureDirect_Params {
	/**要识别的图片路径，要求本地路径（fs://）*/ 
	imagePath:string,

	/**(可选项) 二维码与一维码的类型*/ 
	formatType?:string,

}

interface fs {
	/**
	 * `删除文件目录，**里面的所有文件将会一起被删除**`
	 * ========params==========
	 *
	 * `path` :string : 目标文件路径
	 */
	rmdir(params:fs_rmdir_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `删除文件目录，**里面的所有文件将会一起被删除**`
	 * ========params==========
	 *
	 * `path` :string : 目标文件路径
	 */
	rmdirSync(params:fs_rmdirSync_Params):JSON;

}
interface fs_rmdir_Params {
	/**目标文件路径*/ 
	path:string,

}

interface fs_rmdirSync_Params {
	/**目标文件路径*/ 
	path:string,

}

interface checknotification {
	/** 判断当前应用是否开启了通知权限*/ 
	check(callback?: (ret:JSON) => void):void

	/** 跳转通知设置，无参无返回*/ 
	jumpSetting():void

}
interface NSUserDefaults {
	/**
	 * `往 NSUserDefaults 添加数据`
	 * ========params==========
	 *
	 * `key` :string : 数据的 key 值
	 *
	 * `value` :string : 数据的 value 值
	 *
	 * `groupID` :string : （可选项）App 分组的ID
	 */
	setValue(params:NSUserDefaults_setValue_Params):void

	/**
	 * `从 NSUserDefaults 读取数据`
	 * ========params==========
	 *
	 * `key` :string : 要获取的数据的key值
	 */
	getValue(params:NSUserDefaults_getValue_Params, callback?: (ret:JSON) => void):void

}
interface NSUserDefaults_setValue_Params {
	/**数据的 key 值*/ 
	key:string,

	/**数据的 value 值*/ 
	value:string,

	/**（可选项）App 分组的ID*/ 
	groupID?:string,

}

interface NSUserDefaults_getValue_Params {
	/**要获取的数据的key值*/ 
	key:string,

}

interface cameraQQ {
	/**
	 * `打开固定 UI 的相机页面`
	 * ========params==========
	 *
	 * `save` :JSON : （可选项）拍摄的图片保存信息
	 *
	 * `timer` :number : (可选项)视频录制倒计时计时器，单位为秒（s)，也可以在录制视频过程中单击停止视频录制
	 *
	 * `album` :boolean : （可选项）拍照成功后是否将所拍图片存入系统相册
	 *
	 * `animation` :boolean : （可选项）打开拍照页面时是否带有动画效果
	 *
	 * `quality` :string : （可选项）所拍照片质量
	 *
	 * `style` :JSON : （可选项）页面样式设置（仅android有效）
	 */
	open(params:cameraQQ_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `取消/关闭拍照页面`
	 * ========params==========
	 *
	 * `animation` :boolean : （可选项）关闭拍照页面时是否带有动画效果
	 */
	cancel(params:cameraQQ_cancel_Params):void

}
interface cameraQQ_open_Params {
	/**（可选项）拍摄的图片保存信息*/ 
	save?:JSON,

	/**(可选项)视频录制倒计时计时器，单位为秒（s)，也可以在录制视频过程中单击停止视频录制*/ 
	timer?:number,

	/**（可选项）拍照成功后是否将所拍图片存入系统相册*/ 
	album?:boolean,

	/**（可选项）打开拍照页面时是否带有动画效果*/ 
	animation?:boolean,

	/**（可选项）所拍照片质量*/ 
	quality?:string,

	/**（可选项）页面样式设置（仅android有效）*/ 
	style?:JSON,

}

interface cameraQQ_cancel_Params {
	/**（可选项）关闭拍照页面时是否带有动画效果*/ 
	animation?:boolean,

}

interface preSensor {
	/** 获取所处位置大气压强*/ 
	getPressure():void

	/** 销毁获取气压,当应用不需要再获取时，需调用次方法释放内存，防止内存溢出。*/ 
	stopPressure():void

}
interface websocketClient {
}
interface AudioSession {
	/**
	 * `激活 AVAudioSession`
	 * ========params==========
	 *
	 * `active` :boolean : （可选项）是否激活
	 */
	setAudioSessionActive(params:AudioSession_setAudioSessionActive_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 获取当前 seesion  的 category*/ 
	getAudioSessionCategory():void

	/** 获取当前设备支持的 category*/ 
	availableCategories():void

	/** 获取当前设备支持的 modes*/ 
	availableModes():void

	/**
	 * `设置 AVAudioSession 的 category`
	 * ========params==========
	 *
	 * `category` :string : 要设置的 category
	 *
	 * `options` :Array : 要设置的 category 的选项
	 */
	setAudioSessionCategory(params:AudioSession_setAudioSessionCategory_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `设置 AVAudioSession 的 mode`
	 * ========params==========
	 *
	 * `mode` :string : 要设置的 mode
	 */
	setAudioSessionMode(params:AudioSession_setAudioSessionMode_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface AudioSession_setAudioSessionActive_Params {
	/**（可选项）是否激活*/ 
	active?:boolean,

}

interface AudioSession_setAudioSessionCategory_Params {
	/**要设置的 category*/ 
	category:string,

	/**要设置的 category 的选项*/ 
	options:Array,

}

interface AudioSession_setAudioSessionMode_Params {
	/**要设置的 mode*/ 
	mode:string,

}

interface keychain {
	/**
	 * `往钥匙串添加数据`
	 * ========params==========
	 *
	 * `username` :string : 用户名
	 *
	 * `serviceName` :string : 服务器名（android为通过自定义模块设置的accountType固定值）
	 *
	 * `password` :string : 密码
	 *
	 * `updateExisting` :boolean : （可选项）若已存在，是否覆盖（仅iOS支持，android不可覆盖）
	 */
	add(params:keychain_add_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `往钥匙串删除数据`
	 * ========params==========
	 *
	 * `username` :string : 用户名
	 *
	 * `serviceName` :string : 服务器名（android为通过自定义模块设置的accountType固定值）
	 */
	delete(params:keychain_delete_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `清空钥匙串中的某条数据（仅iOS支持）`
	 * ========params==========
	 *
	 * `serviceName` :string : 服务器名
	 */
	purge(params:keychain_purge_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `查询钥匙串中的数据`
	 * ========params==========
	 *
	 * `username` :string : 用户名
	 *
	 * `serviceName` :string : 服务器名（android为通过自定义模块设置的accountType固定值）
	 */
	check(params:keychain_check_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface keychain_add_Params {
	/**用户名*/ 
	username:string,

	/**服务器名（android为通过自定义模块设置的accountType固定值）*/ 
	serviceName:string,

	/**密码*/ 
	password:string,

	/**（可选项）若已存在，是否覆盖（仅iOS支持，android不可覆盖）*/ 
	updateExisting?:boolean,

}

interface keychain_delete_Params {
	/**用户名*/ 
	username:string,

	/**服务器名（android为通过自定义模块设置的accountType固定值）*/ 
	serviceName:string,

}

interface keychain_purge_Params {
	/**服务器名*/ 
	serviceName:string,

}

interface keychain_check_Params {
	/**用户名*/ 
	username:string,

	/**服务器名（android为通过自定义模块设置的accountType固定值）*/ 
	serviceName:string,

}

interface ACTencentCOS {
	/**
	 * `创建存储桶`
	 * ========params==========
	 *
	 * `bucket` :string : 存储桶名[存储桶名称规范](https://cloud.tencent.com/document/product/436/13312#.E5.91.BD.E5.90.8D.E8.A7.84.E8.8C.83)
	 *
	 * `accessControlList` :string : （可选项）定义 Bucket 的 ACL 属性。有效值：private，public-read-write，public-read；
	 *
	 * `grantRead` :string : （可选项）赋予被授权者读的权限。（仅iOS支持）
	 *
	 * `grantWrite` :number : （可选项）授予被授权者写的权限。格式同grantRead（仅iOS支持）
	 *
	 * `grantFullControl` :string : （可选项）授予被授权者写的权限。格式同grantRead（仅iOS支持）
	 *
	 * `grantReadAccount` :Array<JSON> : （可选项）设置可读权限账号（仅android支持）
	 *
	 * `grantWriteAccount` :Array<JSON> : （可选项）设置可写权限账号（仅android支持）
	 *
	 * `grantFullAccount` :Array<JSON> : （可选项）设置可读可写可写权限账号（仅android支持）
	 *
	 * `bucket` :string : 存储桶名[存储桶名称规范](https://cloud.tencent.com/document/product/436/13312#.E5.91.BD.E5.90.8D.E8.A7.84.E8.8C.83)
	 *
	 * `accessControlList` :string : （可选项）定义 Bucket 的 ACL 属性。有效值：private，public-read-write，public-read；
	 *
	 * `grantRead` :string : （可选项）赋予被授权者读的权限。（仅iOS支持）
	 *
	 * `grantWrite` :number : （可选项）授予被授权者写的权限。格式同grantRead（仅iOS支持）
	 *
	 * `grantFullControl` :string : （可选项）授予被授权者写的权限。格式同grantRead（仅iOS支持）
	 *
	 * `grantReadAccount` :Array<JSON> : （可选项）设置可读权限账号（仅android支持）
	 *
	 * `grantWriteAccount` :Array<JSON> : （可选项）设置可写权限账号（仅android支持）
	 *
	 * `grantFullAccount` :Array<JSON> : （可选项）设置可读可写可写权限账号（仅android支持）
	 */
	putBucket(params:ACTencentCOS_putBucket_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 用于查询指定账号下的存储桶列表*/ 
	getService(callback?: (ret:JSON, err:JSON) => void):void

	/** 删除存储桶*/ 
	deleteBucket(callback?: (ret:JSON) => void):void

	/**
	 * `确认该存储桶是否存在，是否有权限访问`
	 * ========params==========
	 *
	 * `bucket` :string : 存储桶名称
	 */
	inspectBucket(params:ACTencentCOS_inspectBucket_Params, callback?: (ret:JSON) => void):void

	/**
	 * `为已存在的存储桶设置标签`
	 * ========params==========
	 *
	 * `bucket` :string : 存储桶名称
	 *
	 * `key` :string : 标签名
	 *
	 * `value` :string : 标签值
	 */
	setBucketLabel(params:ACTencentCOS_setBucketLabel_Params):void

	/**
	 * `查询指定存储桶下已有的存储桶标签`
	 * ========params==========
	 *
	 * `bucket` :string : 存储桶名称
	 */
	queryBucketLabel(params:ACTencentCOS_queryBucketLabel_Params):void

	/**
	 * `为源存储桶开启日志记录，将源存储桶的访问日志保存到指定的目标存储桶中。`
	 * ========params==========
	 *
	 * `srcBucket` :string : 源存储桶
	 *
	 * `targetBucket` :string : 目标存储桶
	 *
	 * `storagePath` :string : 日志存储的指定位置
	 */
	setManagement(params:ACTencentCOS_setManagement_Params, callback?: (ret:JSON) => void):void

	/**
	 * `上传文件`
	 * ========params==========
	 *
	 * `path` :string : 文件路径fs
	 *
	 * `bucket` :string : 存储桶名称[存储桶名称规范](https://cloud.tencent.com/document/product/436/13312#.E5.91.BD.E5.90.8D.E8.A7.84.E8.8C.83)
	 *
	 * `object` :string : 上传文件（对象）的文件名，也是对象的key，不可重复，请注意文件名中不可以含有问号即"?"字符，
	 */
	beginUpload(params:ACTencentCOS_beginUpload_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `取消上传`
	 * ========params==========
	 *
	 * `object` :string : 上传文件（对象）的文件名，也是对象的key
	 */
	abortUpload(params:ACTencentCOS_abortUpload_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `创建存储桶`
	 * ========params==========
	 *
	 * `bucket` :string : 存储桶名[存储桶名称规范](https://cloud.tencent.com/document/product/436/13312#.E5.91.BD.E5.90.8D.E8.A7.84.E8.8C.83)
	 *
	 * `accessControlList` :string : （可选项）定义 Bucket 的 ACL 属性。有效值：private，public-read-write，public-read；
	 *
	 * `grantRead` :string : （可选项）赋予被授权者读的权限。（仅iOS支持）
	 *
	 * `grantWrite` :number : （可选项）授予被授权者写的权限。格式同grantRead（仅iOS支持）
	 *
	 * `grantFullControl` :string : （可选项）授予被授权者写的权限。格式同grantRead（仅iOS支持）
	 *
	 * `grantReadAccount` :Array<JSON> : （可选项）设置可读权限账号（仅android支持）
	 *
	 * `grantWriteAccount` :Array<JSON> : （可选项）设置可写权限账号（仅android支持）
	 *
	 * `grantFullAccount` :Array<JSON> : （可选项）设置可读可写可写权限账号（仅android支持）
	 *
	 * `bucket` :string : 存储桶名[存储桶名称规范](https://cloud.tencent.com/document/product/436/13312#.E5.91.BD.E5.90.8D.E8.A7.84.E8.8C.83)
	 *
	 * `accessControlList` :string : （可选项）定义 Bucket 的 ACL 属性。有效值：private，public-read-write，public-read；
	 *
	 * `grantRead` :string : （可选项）赋予被授权者读的权限。（仅iOS支持）
	 *
	 * `grantWrite` :number : （可选项）授予被授权者写的权限。格式同grantRead（仅iOS支持）
	 *
	 * `grantFullControl` :string : （可选项）授予被授权者写的权限。格式同grantRead（仅iOS支持）
	 *
	 * `grantReadAccount` :Array<JSON> : （可选项）设置可读权限账号（仅android支持）
	 *
	 * `grantWriteAccount` :Array<JSON> : （可选项）设置可写权限账号（仅android支持）
	 *
	 * `grantFullAccount` :Array<JSON> : （可选项）设置可读可写可写权限账号（仅android支持）
	 */
	putBucket(params:ACTencentCOS_putBucket_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `列举存储桶内的内容`
	 * ========params==========
	 *
	 * `bucket` :string : 存储桶名，[存储桶名称规范](https://cloud.tencent.com/document/product/436/13312#.E5.91.BD.E5.90.8D.E8.A7.84.E8.8C.83)
	 *
	 * `prefix` :string : （可选项）前缀匹配，用来规定返回的文件前缀地址
	 *
	 * `delimiter` :string : （可选项）定界符为一个符号，如果有 Prefix，则将 Prefix 到 delimiter 之间的相同路径归为一类，定义为 Common Prefix，然后列出所有 Common Prefix。如果没有 Prefix，则从路径起点开始。可以将其理解为结束的符号，例如如果想要结尾是 A 的结果，那么将delimiter设置为 A 即可。
	 *
	 * `encodingType` :string : （可选项）规定返回值的编码方式，可选值：url
	 *
	 * `marker` :string : （可选项）默认以 UTF-8 二进制顺序列出条目，所有列出条目从 marker 开始
	 *
	 * `maxKeys` :number : （可选项）单次返回的最大条目数量，
	 */
	getBucket(params:ACTencentCOS_getBucket_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `生成预签名下载链接`
	 * ========params==========
	 *
	 * `bucket` :string : 存储桶名称
	 *
	 * `cosPath` :any : 对象键（文件名）
	 */
	GenerateLinks(params:ACTencentCOS_GenerateLinks_Params):void

	/**
	 * `删除单个对象`
	 * ========params==========
	 *
	 * `bucket` :string : 存储桶名,[存储桶名称规范](https://cloud.tencent.com/document/product/436/13312#.E5.91.BD.E5.90.8D.E8.A7.84.E8.8C.83)
	 *
	 * `object` :string : 对象键（Key）是对象在存储桶中的唯一标识。例如，在对象的访问域名 bucket1-1250000000.cos.ap-guangzhou.myqcloud.com/doc1/pic1.jpg 中，对象键为 doc1/pic1.jpg。更详细的描述可以参考[对象描述](https://cloud.tencent.com/document/product/436/13324)
	 */
	deleteObject(params:ACTencentCOS_deleteObject_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `删除多个对象`
	 * ========params==========
	 *
	 * `bucket` :string : 存储桶名,[存储桶名称规范](https://cloud.tencent.com/document/product/436/13312#.E5.91.BD.E5.90.8D.E8.A7.84.E8.8C.83)
	 *
	 * `deleteObjects` :Array : 存放需要删除对象信息的数组
	 */
	deleteMultipleObject(params:ACTencentCOS_deleteMultipleObject_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * ` 复制文件到目标存储桶`
	 * ========params==========
	 *
	 * `sourceAppid` :string : 账号APPID
	 *
	 * `sourceBucket` :string : 源对象所在的存储桶，**不需要加【-APPID】**
	 *
	 * `sourceRegion` :string : 源对象的存储桶所在的地域
	 *
	 * `sourceCosPath` :string : 源对象的对象键（文件名）
	 *
	 * `targetBucket` :string : 目标存储桶，**需要加【-APPID】**
	 *
	 * `targetCosPath` :string : 存入的目标存储桶的对象键（文件名）
	 */
	copyObject(params:ACTencentCOS_copyObject_Params):void

	/**
	 * `查询对象元数据`
	 * ========params==========
	 *
	 * `bucket` :string : 存储桶名称
	 *
	 * `cosPath` :any : 对象键（文件名）
	 */
	queryObjectMetadata(params:ACTencentCOS_queryObjectMetadata_Params):void

}
interface ACTencentCOS_putBucket_Params {
	/**存储桶名[存储桶名称规范](https://cloud.tencent.com/document/product/436/13312#.E5.91.BD.E5.90.8D.E8.A7.84.E8.8C.83)*/ 
	bucket:string,

	/**（可选项）定义 Bucket 的 ACL 属性。有效值：private，public-read-write，public-read；*/ 
	accessControlList?:string,

	/**（可选项）赋予被授权者读的权限。（仅iOS支持）*/ 
	grantRead?:string,

	/**（可选项）授予被授权者写的权限。格式同grantRead（仅iOS支持）*/ 
	grantWrite?:number,

	/**（可选项）授予被授权者写的权限。格式同grantRead（仅iOS支持）*/ 
	grantFullControl?:string,

	/**（可选项）设置可读权限账号（仅android支持）*/ 
	grantReadAccount?:Array<JSON>,

	/**（可选项）设置可写权限账号（仅android支持）*/ 
	grantWriteAccount?:Array<JSON>,

	/**（可选项）设置可读可写可写权限账号（仅android支持）*/ 
	grantFullAccount?:Array<JSON>,

	/**存储桶名[存储桶名称规范](https://cloud.tencent.com/document/product/436/13312#.E5.91.BD.E5.90.8D.E8.A7.84.E8.8C.83)*/ 
	bucket:string,

	/**（可选项）定义 Bucket 的 ACL 属性。有效值：private，public-read-write，public-read；*/ 
	accessControlList?:string,

	/**（可选项）赋予被授权者读的权限。（仅iOS支持）*/ 
	grantRead?:string,

	/**（可选项）授予被授权者写的权限。格式同grantRead（仅iOS支持）*/ 
	grantWrite?:number,

	/**（可选项）授予被授权者写的权限。格式同grantRead（仅iOS支持）*/ 
	grantFullControl?:string,

	/**（可选项）设置可读权限账号（仅android支持）*/ 
	grantReadAccount?:Array<JSON>,

	/**（可选项）设置可写权限账号（仅android支持）*/ 
	grantWriteAccount?:Array<JSON>,

	/**（可选项）设置可读可写可写权限账号（仅android支持）*/ 
	grantFullAccount?:Array<JSON>,

}

interface ACTencentCOS_inspectBucket_Params {
	/**存储桶名称*/ 
	bucket:string,

}

interface ACTencentCOS_setBucketLabel_Params {
	/**存储桶名称*/ 
	bucket:string,

	/**标签名*/ 
	key:string,

	/**标签值*/ 
	value:string,

}

interface ACTencentCOS_queryBucketLabel_Params {
	/**存储桶名称*/ 
	bucket:string,

}

interface ACTencentCOS_setManagement_Params {
	/**源存储桶*/ 
	srcBucket:string,

	/**目标存储桶*/ 
	targetBucket:string,

	/**日志存储的指定位置*/ 
	storagePath:string,

}

interface ACTencentCOS_beginUpload_Params {
	/**文件路径fs*/ 
	path:string,

	/**存储桶名称[存储桶名称规范](https://cloud.tencent.com/document/product/436/13312#.E5.91.BD.E5.90.8D.E8.A7.84.E8.8C.83)*/ 
	bucket:string,

	/**上传文件（对象）的文件名，也是对象的key，不可重复，请注意文件名中不可以含有问号即"?"字符，*/ 
	object:string,

}

interface ACTencentCOS_abortUpload_Params {
	/**上传文件（对象）的文件名，也是对象的key*/ 
	object:string,

}

interface ACTencentCOS_putBucket_Params {
	/**存储桶名[存储桶名称规范](https://cloud.tencent.com/document/product/436/13312#.E5.91.BD.E5.90.8D.E8.A7.84.E8.8C.83)*/ 
	bucket:string,

	/**（可选项）定义 Bucket 的 ACL 属性。有效值：private，public-read-write，public-read；*/ 
	accessControlList?:string,

	/**（可选项）赋予被授权者读的权限。（仅iOS支持）*/ 
	grantRead?:string,

	/**（可选项）授予被授权者写的权限。格式同grantRead（仅iOS支持）*/ 
	grantWrite?:number,

	/**（可选项）授予被授权者写的权限。格式同grantRead（仅iOS支持）*/ 
	grantFullControl?:string,

	/**（可选项）设置可读权限账号（仅android支持）*/ 
	grantReadAccount?:Array<JSON>,

	/**（可选项）设置可写权限账号（仅android支持）*/ 
	grantWriteAccount?:Array<JSON>,

	/**（可选项）设置可读可写可写权限账号（仅android支持）*/ 
	grantFullAccount?:Array<JSON>,

	/**存储桶名[存储桶名称规范](https://cloud.tencent.com/document/product/436/13312#.E5.91.BD.E5.90.8D.E8.A7.84.E8.8C.83)*/ 
	bucket:string,

	/**（可选项）定义 Bucket 的 ACL 属性。有效值：private，public-read-write，public-read；*/ 
	accessControlList?:string,

	/**（可选项）赋予被授权者读的权限。（仅iOS支持）*/ 
	grantRead?:string,

	/**（可选项）授予被授权者写的权限。格式同grantRead（仅iOS支持）*/ 
	grantWrite?:number,

	/**（可选项）授予被授权者写的权限。格式同grantRead（仅iOS支持）*/ 
	grantFullControl?:string,

	/**（可选项）设置可读权限账号（仅android支持）*/ 
	grantReadAccount?:Array<JSON>,

	/**（可选项）设置可写权限账号（仅android支持）*/ 
	grantWriteAccount?:Array<JSON>,

	/**（可选项）设置可读可写可写权限账号（仅android支持）*/ 
	grantFullAccount?:Array<JSON>,

}

interface ACTencentCOS_getBucket_Params {
	/**存储桶名，[存储桶名称规范](https://cloud.tencent.com/document/product/436/13312#.E5.91.BD.E5.90.8D.E8.A7.84.E8.8C.83)*/ 
	bucket:string,

	/**（可选项）前缀匹配，用来规定返回的文件前缀地址*/ 
	prefix?:string,

	/**（可选项）定界符为一个符号，如果有 Prefix，则将 Prefix 到 delimiter 之间的相同路径归为一类，定义为 Common Prefix，然后列出所有 Common Prefix。如果没有 Prefix，则从路径起点开始。可以将其理解为结束的符号，例如如果想要结尾是 A 的结果，那么将delimiter设置为 A 即可。*/ 
	delimiter?:string,

	/**（可选项）规定返回值的编码方式，可选值：url*/ 
	encodingType?:string,

	/**（可选项）默认以 UTF-8 二进制顺序列出条目，所有列出条目从 marker 开始*/ 
	marker?:string,

	/**（可选项）单次返回的最大条目数量，*/ 
	maxKeys?:number,

}

interface ACTencentCOS_GenerateLinks_Params {
	/**存储桶名称*/ 
	bucket:string,

	/**对象键（文件名）*/ 
	cosPath:any,

}

interface ACTencentCOS_deleteObject_Params {
	/**存储桶名,[存储桶名称规范](https://cloud.tencent.com/document/product/436/13312#.E5.91.BD.E5.90.8D.E8.A7.84.E8.8C.83)*/ 
	bucket:string,

	/**对象键（Key）是对象在存储桶中的唯一标识。例如，在对象的访问域名 bucket1-1250000000.cos.ap-guangzhou.myqcloud.com/doc1/pic1.jpg 中，对象键为 doc1/pic1.jpg。更详细的描述可以参考[对象描述](https://cloud.tencent.com/document/product/436/13324)*/ 
	object:string,

}

interface ACTencentCOS_deleteMultipleObject_Params {
	/**存储桶名,[存储桶名称规范](https://cloud.tencent.com/document/product/436/13312#.E5.91.BD.E5.90.8D.E8.A7.84.E8.8C.83)*/ 
	bucket:string,

	/**存放需要删除对象信息的数组*/ 
	deleteObjects:Array,

}

interface ACTencentCOS_copyObject_Params {
	/**账号APPID*/ 
	sourceAppid:string,

	/**源对象所在的存储桶，**不需要加【-APPID】***/ 
	sourceBucket:string,

	/**源对象的存储桶所在的地域*/ 
	sourceRegion:string,

	/**源对象的对象键（文件名）*/ 
	sourceCosPath:string,

	/**目标存储桶，**需要加【-APPID】***/ 
	targetBucket:string,

	/**存入的目标存储桶的对象键（文件名）*/ 
	targetCosPath:string,

}

interface ACTencentCOS_queryObjectMetadata_Params {
	/**存储桶名称*/ 
	bucket:string,

	/**对象键（文件名）*/ 
	cosPath:any,

}

interface compactPicture {
}
interface moduleAppScore {
	/** 跳转到应用商店当前已上架的App评分页面*/ 
	requestReview(callback?: (ret:JSON) => void):void

	/** 弹出应用评分对话框（iOS可用），必须是已上架App才能对其讲行评分，如果debug模式或未架App也能弹出评分对话框，但评分按钮是灰色属正常现象。*/ 
	requestReviewDialog(callback?: (ret:JSON) => void):void

}
interface UIImageEdit {
	/**
	 * `开启图片操作界面`
	 * ========params==========
	 *
	 * `path` :string : 要编辑的图片的路径，要求本地路径（fs://、widget://）
	 *
	 * `savePath` :string : 编辑完成后文件保存的路径，路径包括文件的后缀名(后缀png或者jpg)默认（fs://UIImageEdit/UIImageEdit.png）
	 *
	 * `width` :number : 编辑时画笔的宽度
	 *
	 * `isShowArrow` :boolean : 是否显示箭头模式按钮
	 *
	 * `isShowRect` :boolean : 是否显示矩形模式按钮
	 *
	 * `isShowOval` :boolean : 是否显示圆形模式按钮
	 */
	open(params:UIImageEdit_open_Params, callback?: (ret:JSON) => void):void

	/** 清除本模块产生的图片文件*/ 
	clearCache():void

}
interface UIImageEdit_open_Params {
	/**要编辑的图片的路径，要求本地路径（fs://、widget://）*/ 
	path:string,

	/**编辑完成后文件保存的路径，路径包括文件的后缀名(后缀png或者jpg)默认（fs://UIImageEdit/UIImageEdit.png）*/ 
	savePath:string,

	/**编辑时画笔的宽度*/ 
	width:number,

	/**是否显示箭头模式按钮*/ 
	isShowArrow:boolean,

	/**是否显示矩形模式按钮*/ 
	isShowRect:boolean,

	/**是否显示圆形模式按钮*/ 
	isShowOval:boolean,

}

interface videoKit {
	/**
	 * `压缩本地视频文件`
	 * ========params==========
	 *
	 * `path` :string : 通过文件选择器获得的本地视频文件url，不可为空。
	 *
	 * `quality` :string : （可选项）视频压缩质量，取值l, m, h。其中l为low，m为medium，h为high。
	 */
	compressVideo(params:videoKit_compressVideo_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `手动选取时间段裁剪视频`
	 * ========params==========
	 *
	 * `path` :string : 通过文件选择器获得的本地视频文件url，不可为空。
	 */
	clipVideo(params:videoKit_clipVideo_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `任意时间点截屏`
	 * ========params==========
	 *
	 * `path` :string : 通过文件选择器获得的本地视频文件url，不可为空。
	 *
	 * `startTime` :string : （可选项）截屏时间点，数量级为秒，如0，3.5，10等，超过总长报错。
	 */
	captureScreen(params:videoKit_captureScreen_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取视频总时长`
	 * ========params==========
	 *
	 * `path` :string : 通过文件选择器获得的本地视频文件url，不可为空。
	 */
	getVideoDuration(params:videoKit_getVideoDuration_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface videoKit_compressVideo_Params {
	/**通过文件选择器获得的本地视频文件url，不可为空。*/ 
	path:string,

	/**（可选项）视频压缩质量，取值l, m, h。其中l为low，m为medium，h为high。*/ 
	quality?:string,

}

interface videoKit_clipVideo_Params {
	/**通过文件选择器获得的本地视频文件url，不可为空。*/ 
	path:string,

}

interface videoKit_captureScreen_Params {
	/**通过文件选择器获得的本地视频文件url，不可为空。*/ 
	path:string,

	/**（可选项）截屏时间点，数量级为秒，如0，3.5，10等，超过总长报错。*/ 
	startTime?:string,

}

interface videoKit_getVideoDuration_Params {
	/**通过文件选择器获得的本地视频文件url，不可为空。*/ 
	path:string,

}

interface lightStyle {
}
interface mMarket {
	/**
	 * `打开安卓市场应用页`
	 * ========params==========
	 *
	 * `pkg` :string : 应用的包名
	 */
	androidScore(params:mMarket_androidScore_Params):void

	/**
	 * `打开当前应用的应用内评分`
	 * ========params==========
	 *
	 * `appid` :string : 应用id
	 */
	iosShowStar(params:mMarket_iosShowStar_Params):void

	/**
	 * `打开App Store应用评分评论页`
	 * ========params==========
	 *
	 * `appid` :string : 应用id
	 */
	iosShowComment(params:mMarket_iosShowComment_Params):void

	/**
	 * `打开App Store应用详情`
	 * ========params==========
	 *
	 * `appid` :string : 应用id
	 */
	iosShowDetail(params:mMarket_iosShowDetail_Params):void

}
interface mMarket_androidScore_Params {
	/**应用的包名*/ 
	pkg:string,

}

interface mMarket_iosShowStar_Params {
	/**应用id*/ 
	appid:string,

}

interface mMarket_iosShowComment_Params {
	/**应用id*/ 
	appid:string,

}

interface mMarket_iosShowDetail_Params {
	/**应用id*/ 
	appid:string,

}

interface musicList {
	/** 获取铃声列表*/ 
	getMusicList():void

	/**
	 * `文件夹监听（文件夹里面的文件增加还是减少）`
	 * ========params==========
	 *
	 * `soundID` :string : 铃声名称（仅android有效）
	 */
	playSound(params:musicList_playSound_Params):void

	/** 停止播放（仅android支持）*/ 
	stopSound():void

}
interface musicList_playSound_Params {
	/**铃声名称（仅android有效）*/ 
	soundID:string,

}

interface switchLoudspeaker {
	/**
	 * `听筒和扬声器切换`
	 * ========params==========
	 *
	 * `type` :string : 切换的类型
	 */
	switchType(params:switchLoudspeaker_switchType_Params):void

}
interface switchLoudspeaker_switchType_Params {
	/**切换的类型*/ 
	type:string,

}

interface UDPSocket {
	/**
	 * `开启 Socket 并绑定端口`
	 * ========params==========
	 *
	 * `port` :number : （可选项）端口号
	 */
	createAndBind(params:UDPSocket_createAndBind_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 获取 IP*/ 
	getAddress(callback?: (ret:JSON, err:JSON) => void):void

	/** 发送数据*/ 
	sendData(callback?: (ret:JSON, err:JSON) => void):void

	/** 监听客户端发送来数据的事件*/ 
	addReceiveDataListener():void

}
interface UDPSocket_createAndBind_Params {
	/**（可选项）端口号*/ 
	port?:number,

}

interface imagePalette {
}
interface appshortcut {
}
interface qiniuStorage {
	/**
	 * `配置文件上传参数（此方法必须调用）`
	 * ========params==========
	 *
	 * `mimeType` :string : （可选项）为上传文件设置一个自定义的 MIME 类型，如果为空，那么服务端自动检测文件的 MIME 类型
	 *
	 * `checkCrc` :boolean : （可选项）为 false 时，服务端不会校验 crc32 值，checkCrc 为 YES 时，服务端会计算上传文件的 crc32 值，然后与用户提供的 crc32 参数值比较确认文件的完整性，如果校验失败会返回 406 错误。
	 *
	 * `params` :JSON : （可选项）用户自定义参数，必须以 x: 开头，这些参数可以作为变量用于 upToken 的 callbackBody、returnBody、asyncOps 参数中
	 *
	 * `zone` :string : 支持区域
	 */
	configUploader(params:qiniuStorage_configUploader_Params):void

	/**
	 * `开始上传文件`
	 * ========params==========
	 *
	 * `token` :string : 从服务器端 SDK 获取的 token
	 *
	 * `path` :string : 上传的文件（图片、视频等）的路径，要求本地路径（fs://、widget:// **注意：Android暂不支持widget://**）
	 *
	 * `key` :string : （可选项）上传到云存储的key（文件名），不传时表示是由七牛生成
	 */
	start(params:qiniuStorage_start_Params):void

	/** 停止、取消上传文件*/ 
	cancel():void

	/** 添加上传进度的监听*/ 
	addEventListener():void

}
interface qiniuStorage_configUploader_Params {
	/**（可选项）为上传文件设置一个自定义的 MIME 类型，如果为空，那么服务端自动检测文件的 MIME 类型*/ 
	mimeType?:string,

	/**（可选项）为 false 时，服务端不会校验 crc32 值，checkCrc 为 YES 时，服务端会计算上传文件的 crc32 值，然后与用户提供的 crc32 参数值比较确认文件的完整性，如果校验失败会返回 406 错误。*/ 
	checkCrc?:boolean,

	/**（可选项）用户自定义参数，必须以 x: 开头，这些参数可以作为变量用于 upToken 的 callbackBody、returnBody、asyncOps 参数中*/ 
	params?:JSON,

	/**支持区域*/ 
	zone:string,

}

interface qiniuStorage_start_Params {
	/**从服务器端 SDK 获取的 token*/ 
	token:string,

	/**上传的文件（图片、视频等）的路径，要求本地路径（fs://、widget:// **注意：Android暂不支持widget://**）*/ 
	path:string,

	/**（可选项）上传到云存储的key（文件名），不传时表示是由七牛生成*/ 
	key?:string,

}

interface backGroundAudioPlayer {
	/**
	 * `开启后台音频播放`
	 * ========params==========
	 *
	 * `path` :string : （必填项）音频文件路径。
	 */
	backGroundPlay(params:backGroundAudioPlayer_backGroundPlay_Params):void

	/** 停止后台音频播放*/ 
	backGroundStop():void

}
interface backGroundAudioPlayer_backGroundPlay_Params {
	/**（必填项）音频文件路径。*/ 
	path:string,

}

interface pictureWatermark {
	/**
	 * `获取原图的大小`
	 * ========params==========
	 *
	 * `path` :string : 需要添加水印的图片路径，要求本地路径（ fs://、 widget://）
	 */
	getPictureSize(params:pictureWatermark_getPictureSize_Params, callback?: (ret:JSON) => void):void

	/**
	 * `添加图片水印`
	 * ========params==========
	 *
	 * `watermark` :JSON : 水印配置
	 */
	mark(params:pictureWatermark_mark_Params, callback?: (ret:JSON) => void):void

	/** 清除本地缓存的水印图片，**本接口只清除本模块缓存的数据，若要清除本 app 缓存的所有数据则调用 api.clearCache***/ 
	clearCache():void

}
interface pictureWatermark_getPictureSize_Params {
	/**需要添加水印的图片路径，要求本地路径（ fs://、 widget://）*/ 
	path:string,

}

interface pictureWatermark_mark_Params {
	/**水印配置*/ 
	watermark:JSON,

}

interface imrCamera {
	/**
	 * `打开相机`
	 * ========params==========
	 *
	 * `maxFileSize` :number : 图片压缩参数：目标大小
	 *
	 * `quality` :number : （可选项）压缩质量
	 */
	startCamera(params:imrCamera_startCamera_Params, callback?: (ret:JSON) => void):void

	/**
	 * `打开相册`
	 * ========params==========
	 *
	 * `maxFileSize` :number : 图片压缩参数：目标大小
	 *
	 * `quality` :number : （可选项）压缩质量
	 */
	openAlbum(params:imrCamera_openAlbum_Params, callback?: (ret:JSON) => void):void

}
interface imrCamera_startCamera_Params {
	/**图片压缩参数：目标大小*/ 
	maxFileSize:number,

	/**（可选项）压缩质量*/ 
	quality?:number,

}

interface imrCamera_openAlbum_Params {
	/**图片压缩参数：目标大小*/ 
	maxFileSize:number,

	/**（可选项）压缩质量*/ 
	quality?:number,

}

interface zyHmsScan {
}
interface androidEmail {
}
interface sqlCipher {
	/**
	 * `打开数据库，若数据库不存在则创建数据库。`
	 * ========params==========
	 *
	 * `name` :string : 数据库别名
	 *
	 * `path` :string : （可选项）数据库所在路径，不传时使用默认创建的路径。支持 fs://、widget://等协议（如fs://user.db）
	 *
	 * `passWord` :string : 数据库密码
	 */
	openDatabase(params:sqlCipher_openDatabase_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `关闭数据库`
	 * ========params==========
	 *
	 * `name` :string : 数据库别名
	 */
	closeDatabase(params:sqlCipher_closeDatabase_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `执行事务操作语句`
	 * ========params==========
	 *
	 * `name` :string : 数据库别名
	 *
	 * `operation` :string : 事务操作类型，取值范围如下：
	 */
	transaction(params:sqlCipher_transaction_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `执行 sql`
	 * ========params==========
	 *
	 * `name` :string : 数据库别名
	 *
	 * `sql` :string : sql 语句
	 */
	executeSql(params:sqlCipher_executeSql_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `查询sql`
	 * ========params==========
	 *
	 * `name` :string : 数据库别名
	 *
	 * `sql` :string : sql语句
	 */
	selectSql(params:sqlCipher_selectSql_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `打开数据库，若数据库不存在则创建数据库。`
	 * ========params==========
	 *
	 * `name` :string : 数据库别名
	 *
	 * `path` :string : （可选项）数据库所在路径，不传时使用默认创建的路径。支持 fs://、widget://等协议（如fs://user.db）
	 *
	 * `passWord` :string : 数据库密码
	 */
	openDatabaseSyn(params:sqlCipher_openDatabaseSyn_Params):boolean;

	/**
	 * `关闭数据库`
	 * ========params==========
	 *
	 * `name` :string : 数据库别名
	 */
	closeDatabaseSyn(params:sqlCipher_closeDatabaseSyn_Params):boolean;

	/**
	 * `执行事务操作语句`
	 * ========params==========
	 *
	 * `name` :string : 数据库别名
	 *
	 * `operation` :string : 事务操作类型，取值范围如下：
	 */
	transactionSyn(params:sqlCipher_transactionSyn_Params):boolean;

	/**
	 * `执行 sql`
	 * ========params==========
	 *
	 * `name` :string : 数据库别名
	 *
	 * `sql` :string : sql 语句
	 */
	executeSqlSyn(params:sqlCipher_executeSqlSyn_Params):boolean;

	/**
	 * `查询sql`
	 * ========params==========
	 *
	 * `name` :string : 数据库别名
	 *
	 * `sql` :string : sql语句
	 */
	selectSqlSyn(params:sqlCipher_selectSqlSyn_Params):Array<JSON>;

}
interface sqlCipher_openDatabase_Params {
	/**数据库别名*/ 
	name:string,

	/**（可选项）数据库所在路径，不传时使用默认创建的路径。支持 fs://、widget://等协议（如fs://user.db）*/ 
	path?:string,

	/**数据库密码*/ 
	passWord:string,

}

interface sqlCipher_closeDatabase_Params {
	/**数据库别名*/ 
	name:string,

}

interface sqlCipher_transaction_Params {
	/**数据库别名*/ 
	name:string,

	/**事务操作类型，取值范围如下：*/ 
	operation:string,

}

interface sqlCipher_executeSql_Params {
	/**数据库别名*/ 
	name:string,

	/**sql 语句*/ 
	sql:string,

}

interface sqlCipher_selectSql_Params {
	/**数据库别名*/ 
	name:string,

	/**sql语句*/ 
	sql:string,

}

interface sqlCipher_openDatabaseSyn_Params {
	/**数据库别名*/ 
	name:string,

	/**（可选项）数据库所在路径，不传时使用默认创建的路径。支持 fs://、widget://等协议（如fs://user.db）*/ 
	path?:string,

	/**数据库密码*/ 
	passWord:string,

}

interface sqlCipher_closeDatabaseSyn_Params {
	/**数据库别名*/ 
	name:string,

}

interface sqlCipher_transactionSyn_Params {
	/**数据库别名*/ 
	name:string,

	/**事务操作类型，取值范围如下：*/ 
	operation:string,

}

interface sqlCipher_executeSqlSyn_Params {
	/**数据库别名*/ 
	name:string,

	/**sql 语句*/ 
	sql:string,

}

interface sqlCipher_selectSqlSyn_Params {
	/**数据库别名*/ 
	name:string,

	/**sql语句*/ 
	sql:string,

}

interface recentPic {
}
interface FNImageClip {
}
interface SDWebImage {
	/**
	 * `打开自带缓存功能的图片`
	 * ========params==========
	 *
	 * `imgURL` :string : 网络图片路径
	 *
	 * `placeholder` :string : 占位图图片片路径，要求本地路径fs://、widget://
	 *
	 * `rect` :JSON : （可选项）GIF 图片显示区域的位置及大小
	 *
	 * `fixedOn` :string : （可选项）模块添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）预览窗口是否随所属 window 或 frame 滚动
	 */
	open(params:SDWebImage_open_Params):void

	/**
	 * `关闭 open 接口打开的图片`
	 * ========params==========
	 *
	 * `ID` :string : 图片的 ID
	 */
	close(params:SDWebImage_close_Params):void

	/**
	 * `显示 open 接口打开的图片`
	 * ========params==========
	 *
	 * `ID` :string : 图片的 ID
	 */
	show(params:SDWebImage_show_Params):void

	/**
	 * `隐藏 open 接口打开的图片`
	 * ========params==========
	 *
	 * `ID` :string : 图片的 ID
	 */
	hide(params:SDWebImage_hide_Params):void

	/**
	 * `重设指定图片的位置和大小`
	 * ========params==========
	 *
	 * `ID` :string : 重设的图片的 ID
	 *
	 * `rect` :JSON : （可选项）图片显示区域的位置及大小
	 */
	reset(params:SDWebImage_reset_Params):void

	/** 获取已经缓存的图片的大小*/ 
	cacheSize():void

	/** 清除内存缓存*/ 
	clearMemory():void

	/** 清除硬盘缓存*/ 
	clearDisk():void

	/**
	 * `下载图片 (Android 不支持该方法)`
	 * ========params==========
	 *
	 * `imgURL` :string : 网络图片路径
	 */
	download(params:SDWebImage_download_Params):void

	/**
	 * `获取本地缓存图片的路径`
	 * ========params==========
	 *
	 * `imgURL` :string : 网络图片路径
	 */
	getCachePath(params:SDWebImage_getCachePath_Params):void

	/**
	 * `是否已缓存`
	 * ========params==========
	 *
	 * `imgURL` :string : 网络图片路径
	 */
	imageCached(params:SDWebImage_imageCached_Params):void

}
interface SDWebImage_open_Params {
	/**网络图片路径*/ 
	imgURL:string,

	/**占位图图片片路径，要求本地路径fs://、widget://*/ 
	placeholder:string,

	/**（可选项）GIF 图片显示区域的位置及大小*/ 
	rect?:JSON,

	/**（可选项）模块添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）预览窗口是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface SDWebImage_close_Params {
	/**图片的 ID*/ 
	ID:string,

}

interface SDWebImage_show_Params {
	/**图片的 ID*/ 
	ID:string,

}

interface SDWebImage_hide_Params {
	/**图片的 ID*/ 
	ID:string,

}

interface SDWebImage_reset_Params {
	/**重设的图片的 ID*/ 
	ID:string,

	/**（可选项）图片显示区域的位置及大小*/ 
	rect?:JSON,

}

interface SDWebImage_download_Params {
	/**网络图片路径*/ 
	imgURL:string,

}

interface SDWebImage_getCachePath_Params {
	/**网络图片路径*/ 
	imgURL:string,

}

interface SDWebImage_imageCached_Params {
	/**网络图片路径*/ 
	imgURL:string,

}

interface imageCutOut {
	/**
	 * `打开剪切预览视图`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）浏览器窗口的位置和大小，设置margin后，在不同手机上面会保持与父页面的各方向边距一致，而中间区域会自动扩充。建议使用margin布局，可以完美适配带smartBar的手机。
	 *
	 * `fixedOn` :string : （可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 Window 或 Frame 滚动
	 *
	 * `filePath` :string : （必填项）设置需要剪切的本地图片路径(支持fs:// widget://)[备注：安卓不支持widget路径]。
	 */
	openCropView(params:imageCutOut_openCropView_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 隐藏预览剪切视图*/ 
	hideCropView(callback?: (ret:JSON, err:JSON) => void):void

	/** 显示预览剪切视图*/ 
	showCropView(callback?: (ret:JSON, err:JSON) => void):void

	/** 关闭预览剪切视图*/ 
	closeCropView(callback?: (ret:JSON, err:JSON) => void):void

	/** 剪切图片*/ 
	clipImage(callback?: (ret:JSON, err:JSON) => void):void

	/** 保存剪切的图片*/ 
	saveImage(callback?: (ret:JSON, err:JSON) => void):void

}
interface imageCutOut_openCropView_Params {
	/**（可选项）浏览器窗口的位置和大小，设置margin后，在不同手机上面会保持与父页面的各方向边距一致，而中间区域会自动扩充。建议使用margin布局，可以完美适配带smartBar的手机。*/ 
	rect?:JSON,

	/**（可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 Window 或 Frame 滚动*/ 
	fixed?:boolean,

	/**（必填项）设置需要剪切的本地图片路径(支持fs:// widget://)[备注：安卓不支持widget路径]。*/ 
	filePath:string,

}

interface fileBrowser {
	/** Android11以上设备需调用此方法检测是否拥有文件管理权限*/ 
	isAllfilesPermission():void

	/** Android11以上设备打开系统申请管理所有文件权限的界面*/ 
	requestAllfilesPermission():void

	/**
	 * `打开文件浏览器`
	 * ========params==========
	 *
	 * `confirm` :boolean : （可选项）当设置true时 点击设置按钮进入选择界面选择文件或文件夹点击确认返回路径,当为false时进入到删除界面
	 *
	 * `path` :string : （可选项）需要打开的文件的目录路径；本地（fs://）路径
	 */
	open(params:fileBrowser_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭文件浏览器*/ 
	close():void

	/** 换肤接口，调用此接口后要重新打开界面才能换肤成功*/ 
	skin():void

}
interface fileBrowser_open_Params {
	/**（可选项）当设置true时 点击设置按钮进入选择界面选择文件或文件夹点击确认返回路径,当为false时进入到删除界面*/ 
	confirm?:boolean,

	/**（可选项）需要打开的文件的目录路径；本地（fs://）路径*/ 
	path?:string,

}

interface cocoVideo {
	/**
	 * `模块初始化及参数设置接口`
	 * ========params==========
	 *
	 * `mode` :any : 设置拍摄最短有效时长，单位(秒)
	 */
	config(params:cocoVideo_config_Params, callback?: (ret:JSON) => void):void

	/**
	 * `启动拍照/拍摄`
	 * ========params==========
	 *
	 * `mode` :number : 拍照模式下，设置能从相册中选择的图片的数量
	 */
	openCamera(params:cocoVideo_openCamera_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface cocoVideo_config_Params {
	/**设置拍摄最短有效时长，单位(秒)*/ 
	mode:any,

}

interface cocoVideo_openCamera_Params {
	/**拍照模式下，设置能从相册中选择的图片的数量*/ 
	mode:number,

}

interface webToImage {
	/**
	 * `把模块所依附的当前 webview 转换为图片`
	 * ========params==========
	 *
	 * `save` :JSON : （可选项）转换的 图片的保存信息
	 */
	transImage(params:webToImage_transImage_Params, callback?: (ret:JSON) => void):void

	/** 当 webToImage 接口内 save 参数未传 path 值，则模块会将转换后的 图片保存在缓存目录。调用本接口，可清除本模块产生的所有图片。调用 api 对象下的 clearCache 接口会清除缓存目录下所有文件（不仅本模块产生的图片文件）。*/ 
	clearCache():void

}
interface webToImage_transImage_Params {
	/**（可选项）转换的 图片的保存信息*/ 
	save?:JSON,

}

interface zxycamera {
	/**
	 * `调用照相功能`
	 * ========params==========
	 *
	 * `albumName` :string : 创建系统相册的名字，建议使用app名字。
	 *
	 * `albumName` :string : 创建系统相册的名字，建议使用app名字。
	 *
	 * `voideLength` :string : 录制视频最长时间，单位为秒，使用整数。
	 *
	 * `albumName` :string : 创建系统相册的名字，建议使用app名字。
	 *
	 * `voideLength` :string : 录制视频最长时间，单位为秒，使用整数。
	 */
	takePictureClick(params:zxycamera_takePictureClick_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 视频压缩，格式转换*/ 
	compressVideo(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `截取视频任意时间点静态图`
	 * ========params==========
	 *
	 * `path` :string : 处理视频的绝对路径
	 *
	 * `startTime` :number : （可选项）截屏时间点，数量级为秒，如0，3.5，10等。
	 */
	captureScreen(params:zxycamera_captureScreen_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取视频信息`
	 * ========params==========
	 *
	 * `path` :string : 处理视频的绝对路径
	 */
	getVideoInfo(params:zxycamera_getVideoInfo_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `压缩图片`
	 * ========params==========
	 *
	 * `path` :string : 处理图片的绝对路径
	 *
	 * `compressionQuality` :string : 压缩图片比例。默认为1，取值在0到1之间。
	 */
	compressImg(params:zxycamera_compressImg_Params, callback?: (ret:JSON) => void):void

	/**
	 * `获取压缩图片信息`
	 * ========params==========
	 *
	 * `path` :string : 要获取图片信息的绝对地址
	 *
	 * `ret` :JSON : null
	 *
	 * `err` :JSON : null
	 */
	getImageInfo(params:zxycamera_getImageInfo_Params):void

}
interface zxycamera_takePictureClick_Params {
	/**创建系统相册的名字，建议使用app名字。*/ 
	albumName:string,

	/**创建系统相册的名字，建议使用app名字。*/ 
	albumName:string,

	/**录制视频最长时间，单位为秒，使用整数。*/ 
	voideLength:string,

	/**创建系统相册的名字，建议使用app名字。*/ 
	albumName:string,

	/**录制视频最长时间，单位为秒，使用整数。*/ 
	voideLength:string,

}

interface zxycamera_captureScreen_Params {
	/**处理视频的绝对路径*/ 
	path:string,

	/**（可选项）截屏时间点，数量级为秒，如0，3.5，10等。*/ 
	startTime?:number,

}

interface zxycamera_getVideoInfo_Params {
	/**处理视频的绝对路径*/ 
	path:string,

}

interface zxycamera_compressImg_Params {
	/**处理图片的绝对路径*/ 
	path:string,

	/**压缩图片比例。默认为1，取值在0到1之间。*/ 
	compressionQuality:string,

}

interface zxycamera_getImageInfo_Params {
	/**要获取图片信息的绝对地址*/ 
	path:string,

	/**null*/ 
	ret:JSON,

	/**null*/ 
	err:JSON,

}

interface webCapturer {
	/**
	 * `将指定的网页地址，转换为png图片，并返回图片的base64内容`
	 * ========params==========
	 *
	 * `w` :any : （必选项）以怎样的宽度去装载网页（单位：px）。
	 *
	 * `h` :any : （必选项）以怎样的高度去装载网页（单位：px）。
	 *
	 * `url` :string : （必选项）网页地址。
	 *
	 * `path` :boolean : （可选项）是否返回base64内容，默认为true。
	 */
	saveWebImage(params:webCapturer_saveWebImage_Params):void

}
interface webCapturer_saveWebImage_Params {
	/**（必选项）以怎样的宽度去装载网页（单位：px）。*/ 
	w:any,

	/**（必选项）以怎样的高度去装载网页（单位：px）。*/ 
	h:any,

	/**（必选项）网页地址。*/ 
	url:string,

	/**（可选项）是否返回base64内容，默认为true。*/ 
	path?:boolean,

}

interface wifiServer {
	/**
	 * `开启服务。`
	 * ========params==========
	 *
	 * `userName` :string : 用户名 （暂仅支持Android）
	 *
	 * `password` :string : 密码 （暂仅支持Android）
	 *
	 * `path` :string : 服务器提供的网页html文件所在的目录，如：widget://wifiServer。下载 [wifiServer](/img/docImage/wifiServer/wifiServer.zip) 示例html文件。（Android仅支持fs://路径）
	 *
	 * `port` :number : （可选项）端口号，不传则随机取值
	 */
	start(params:wifiServer_start_Params, callback?: (ret:JSON) => void):void

	/** 获取上传的文件的目录，及其文件列表 （Android暂不支持该方法）*/ 
	getUploadDirectory():void

}
interface wifiServer_start_Params {
	/**用户名 （暂仅支持Android）*/ 
	userName:string,

	/**密码 （暂仅支持Android）*/ 
	password:string,

	/**服务器提供的网页html文件所在的目录，如：widget://wifiServer。下载 [wifiServer](/img/docImage/wifiServer/wifiServer.zip) 示例html文件。（Android仅支持fs://路径）*/ 
	path:string,

	/**（可选项）端口号，不传则随机取值*/ 
	port?:number,

}

interface trans {
	/**
	 * `将相册图片地址转换为可以直接使用的本地路径地址（临时文件夹的绝对路径），**相册图片会被拷贝到临时文件夹，调用 api.clearCache 接口可清除该临时图片文件**（仅iOS支持）`
	 * ========params==========
	 *
	 * `paths` :Array : 要转换的图片路径数组（在iOS端为在相册库的ID）
	 *
	 * `scale` :number : （可选项）图片质量
	 */
	batchTransPath(params:trans_batchTransPath_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface trans_batchTransPath_Params {
	/**要转换的图片路径数组（在iOS端为在相册库的ID）*/ 
	paths:Array,

	/**（可选项）图片质量*/ 
	scale?:number,

}

interface netTools {
	/**
	 * `检查与某个 IP 是否联通`
	 * ========params==========
	 *
	 * `hostName` :string : 主机名
	 *
	 * `pingTimes` :number : （可选项）ping的次数，0为一直ping（仅android支持）
	 *
	 * `delayTime` :number : （可选项）每次ping间隔时间,毫秒（仅android支持）
	 */
	ping(params:netTools_ping_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 停止 ping*/ 
	stopPing():void

	/** 获取IP地址*/ 
	getIPAddress():void

	/** 检查vpn是否开启*/ 
	isVPNOn():void

	/** 获取网络状态*/ 
	getNetworkStatus():void

	/** 获取手机号码、运营商等信息*/ 
	getOperators():void

	/** 监听vpn状态改变事件（仅iOS支持）*/ 
	addVPNStatusChangedListener():void

	/** 监听网络状态改变事件*/ 
	addNetworkChangedListener():void

	/** 移除网络监听（仅android支持）*/ 
	removeNetworkChangedListener():void

}
interface netTools_ping_Params {
	/**主机名*/ 
	hostName:string,

	/**（可选项）ping的次数，0为一直ping（仅android支持）*/ 
	pingTimes?:number,

	/**（可选项）每次ping间隔时间,毫秒（仅android支持）*/ 
	delayTime?:number,

}

interface launchImage {
	/**
	 * `获取启动图`
	 * ========params==========
	 *
	 * `isPortrait` :boolean : （可选项）是否为竖屏。
	 *
	 * `debug` :boolean : （可选项）调试模式。开启时，每次都会从底层获取启动图，方便调试；关闭时，如果有缓存，则直接返回图片地址。
	 */
	get(params:launchImage_get_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `清除缓存的启动图`
	 * ========params==========
	 *
	 * `reGet` :boolean : （可选项）清除缓存后是否立即重新获取。
	 *
	 * `isPortrait` :boolean : （可选项）是否为竖屏。如果reGet为true，且APP是横屏应用，需要设置此项
	 */
	clearCache(params:launchImage_clearCache_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface launchImage_get_Params {
	/**（可选项）是否为竖屏。*/ 
	isPortrait?:boolean,

	/**（可选项）调试模式。开启时，每次都会从底层获取启动图，方便调试；关闭时，如果有缓存，则直接返回图片地址。*/ 
	debug?:boolean,

}

interface launchImage_clearCache_Params {
	/**（可选项）清除缓存后是否立即重新获取。*/ 
	reGet?:boolean,

	/**（可选项）是否为竖屏。如果reGet为true，且APP是横屏应用，需要设置此项*/ 
	isPortrait?:boolean,

}

interface presentation {
	/** 检查是否已授权*/ 
	checkPermission(callback?: (ret:JSON) => void):void

	/** 申请授权*/ 
	reqPermission():void

	/** 获取分屏*/ 
	getScreens(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `在分屏打开页面`
	 * ========params==========
	 *
	 * `id` :number : 屏幕id，通过[getScreens](#getScreens)获取
	 *
	 * `pagePath` :string : 页面路径，支持widget，fs，网络路径
	 */
	open(params:presentation_open_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `关闭分屏打开的页面`
	 * ========params==========
	 *
	 * `pageId` :number : 已打开页面id
	 */
	close(params:presentation_close_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface presentation_open_Params {
	/**屏幕id，通过[getScreens](#getScreens)获取*/ 
	id:number,

	/**页面路径，支持widget，fs，网络路径*/ 
	pagePath:string,

}

interface presentation_close_Params {
	/**已打开页面id*/ 
	pageId:number,

}

interface phoneListener {
	/** 判断当前设备是否有耳机插入*/ 
	hasHeadset(callback?: (ret:JSON) => void):void

	/**
	 * `监听耳机插拔事件`
	 * ========params==========
	 *
	 * `enable` :boolean : （可选项）是否启动耳机插拔事件监听
	 */
	headphonePluggedListener(params:phoneListener_headphonePluggedListener_Params, callback?: (ret:JSON) => void):void

	/**
	 * `监听静音事件`
	 * ========params==========
	 *
	 * `enable` :boolean : （可选项）是否启动静音事件监听
	 */
	ringerModeSilentListener(params:phoneListener_ringerModeSilentListener_Params, callback?: (ret:JSON) => void):void

	/**
	 * `监听电话事件状态。注意：在 iOS 端本接口仅获取当前手机电话状态`
	 * ========params==========
	 *
	 * `enable` :boolean : （可选项）是否启动电话事件监听
	 */
	callStateListener(params:phoneListener_callStateListener_Params, callback?: (ret:JSON) => void):void

}
interface phoneListener_headphonePluggedListener_Params {
	/**（可选项）是否启动耳机插拔事件监听*/ 
	enable?:boolean,

}

interface phoneListener_ringerModeSilentListener_Params {
	/**（可选项）是否启动静音事件监听*/ 
	enable?:boolean,

}

interface phoneListener_callStateListener_Params {
	/**（可选项）是否启动电话事件监听*/ 
	enable?:boolean,

}

interface acc5Util {
	/** 获取app系统媒体音量*/ 
	getVol():void

	/** 设置媒体音量*/ 
	setVol():void

	/** 设置音频不会被静音键和锁屏键静音。适用于音频是主要功能的APP，像网易云这些音乐app，锁屏后依然可以播放。*/ 
	audioSessionPlayback():void

	/** 设置音频会被静音键和锁屏键静音。*/ 
	audioSessionSoloAmbient():void

	/** 获取屏幕亮度*/ 
	getBrightness():void

	/** 设置屏幕亮度*/ 
	setBrightness():void

}
interface myTimer {
	/**
	 * `启动定时器`
	 * ========params==========
	 *
	 * `step` :number : （可选项）执行事件间隔(秒)；
	 *
	 * `isLoop` :boolean : （可选项）是否循环执行
	 */
	startTimer(params:myTimer_startTimer_Params, callback?: (ret:JSON) => void):void

	/**
	 * `停止定时器`
	 * ========params==========
	 *
	 * `index` :number : （可选项）需要停止定时器的序号（不传时默认停止当前页面所有的任务）；
	 */
	stopTimer(params:myTimer_stopTimer_Params, callback?: (ret:JSON) => void):void

}
interface myTimer_startTimer_Params {
	/**（可选项）执行事件间隔(秒)；*/ 
	step?:number,

	/**（可选项）是否循环执行*/ 
	isLoop?:boolean,

}

interface myTimer_stopTimer_Params {
	/**（可选项）需要停止定时器的序号（不传时默认停止当前页面所有的任务）；*/ 
	index?:number,

}

interface notificationUtil {
	/**
	 * `创建通知通道`
	 * ========params==========
	 *
	 * `Id` :string : 通道id
	 *
	 * `name` :string : 通道名称，创建成功后应用设置中可见
	 *
	 * `description` :string : 通道描述，创建成功后应用设置中可见
	 *
	 * `light` :boolean : （可选项）来消息跑马灯是否亮起
	 *
	 * `vibration` :Array : （可选项）来消息是否震动
	 *
	 * `sound` :string : （可选项）铃声，设置铃声消息等级最小需要为中等级
	 *
	 * `importance` :number : （可选项）消息等级
	 */
	creatChannel(params:notificationUtil_creatChannel_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface notificationUtil_creatChannel_Params {
	/**通道id*/ 
	Id:string,

	/**通道名称，创建成功后应用设置中可见*/ 
	name:string,

	/**通道描述，创建成功后应用设置中可见*/ 
	description:string,

	/**（可选项）来消息跑马灯是否亮起*/ 
	light?:boolean,

	/**（可选项）来消息是否震动*/ 
	vibration?:Array,

	/**（可选项）铃声，设置铃声消息等级最小需要为中等级*/ 
	sound?:string,

	/**（可选项）消息等级*/ 
	importance?:number,

}

interface vPlayer {
}
interface qn {
	/**
	 * `上传文件`
	 * ========params==========
	 *
	 * `file` :string : 本地文件路径  fs://
	 *
	 * `key` :string : 保存的文件名
	 *
	 * `token` :string : 从服务端获取的上传token
	 */
	start(params:qn_start_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface qn_start_Params {
	/**本地文件路径  fs://*/ 
	file:string,

	/**保存的文件名*/ 
	key:string,

	/**从服务端获取的上传token*/ 
	token:string,

}

interface micoMqtt {
}
interface bdObjectStorage {
	/**
	 * `新建一个Bucket。Bucket是BOS上的命名空间，相当于数据的容器，可以存储若干数据实体（Object）。在上传数据前，必须先创建一个Bucket。`
	 * ========params==========
	 *
	 * `point` :string : Bucket所在区域域名；北京区域：http://bj.bcebos.com，广州区域
	 *
	 * `bucketName` :string : Bucket名称
	 */
	creatBucket(params:bdObjectStorage_creatBucket_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取Bucket列表。`
	 * ========params==========
	 *
	 * `point` :string : Bucket所在区域域名
	 */
	getBuckets(params:bdObjectStorage_getBuckets_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `判断Bucket是否存在`
	 * ========params==========
	 *
	 * `point` :string : Bucket所在区域域名
	 *
	 * `bucketName` :string : Bucket名称
	 */
	doesBucketExist(params:bdObjectStorage_doesBucketExist_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `删除已存在Bucket`
	 * ========params==========
	 *
	 * `point` :string : Bucket所在区域域名
	 *
	 * `bucketName` :string : Bucket名称
	 */
	deleteBucket(params:bdObjectStorage_deleteBucket_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `设置Bucket的访问权限`
	 * ========params==========
	 *
	 * `point` :string : Bucket所在区域域名
	 *
	 * `bucketName` :string : Bucket名称
	 *
	 * `permission` :string : 权限类别
	 */
	setBucketAcl(params:bdObjectStorage_setBucketAcl_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `设置指定用户对Bucket的访问权限`
	 * ========params==========
	 *
	 * `point` :string : Bucket所在区域域名
	 *
	 * `bucketName` :string : 用户Id
	 *
	 * `permission` :string : 权限
	 */
	setUserBucketAcl(params:bdObjectStorage_setUserBucketAcl_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `以文件形式上传Object`
	 * ========params==========
	 *
	 * `point` :string : Bucket所在区域域名
	 *
	 * `bucketName` :string : Bucket名称
	 *
	 * `objectKey` :string : 上传的Objectkey
	 *
	 * `filePath` :string : 文件路径；支持widget、fs格式
	 *
	 * `metaData` :Array<JSON> : (可选)自定义元数据	，BOS支持用户自定义元数据来对Object进行描述
	 */
	uploadFile(params:bdObjectStorage_uploadFile_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `以字符串形式上传Object`
	 * ========params==========
	 *
	 * `point` :string : Bucket所在区域域名
	 *
	 * `bucketName` :string : Bucket名称
	 *
	 * `objectKey` :string : 上传的Objectkey
	 *
	 * `strData` :string : 需要上传的字符串
	 *
	 * `metaData` :Array<JSON> : (可选)自定义元数据	，BOS支持用户自定义元数据来对Object进行描述
	 */
	uploadStr(params:bdObjectStorage_uploadStr_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `CopyObject接口用于将一个已经存在的Object拷贝到另外一个Object，拷贝过程中会对源Object的Etag或修改状态进行判断，根据判断结果决定是否执行拷贝。`
	 * ========params==========
	 *
	 * `point` :string : Bucket所在区域域名
	 *
	 * `srcBucket` :string : 源Object 的Bucket名称
	 *
	 * `srcKey` :string : 源Object 的 Key
	 *
	 * `destBucket` :string : 新Object 的Bucket名称
	 *
	 * `destKey` :string : 新Object  Key
	 *
	 * `checkETag` :JSON : (可选)判断源Object是否有修改决定是否拷贝，与checkETag二选一
	 *
	 * `metaData` :Array<JSON> : (可选)自定义元数据	，新Object的自定义数据
	 */
	copyObject(params:bdObjectStorage_copyObject_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `查看Bucket中Object列表。`
	 * ========params==========
	 *
	 * `point` :string : Bucket所在区域域名
	 *
	 * `bucketName` :string : 源Object 的Bucket名称
	 */
	getObjsFromBucket(params:bdObjectStorage_getObjsFromBucket_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `扩展查询,通过设置参数来筛选Object`
	 * ========params==========
	 *
	 * `point` :string : Bucket所在区域域名
	 *
	 * `bucketName` :string : 源Object 的Bucket名称
	 *
	 * `MaxKeys` :number : 设定此次返回Object的最大个数，不可超过1000。（可选）
	 *
	 * `Prefix` :string : 设定objectKey的前缀，前缀是指objectKey包含并以Prefix的值作为开始。通常与Delimiter配合在查询模拟文件夹中使用。（可选）
	 *
	 * `Delimiter` :string : 是一个分隔符，用来对objectKey进行分层。通常与Prefix配合在查询模拟文件夹中使用。从Prefix开始到第一次出现Delimiter字符之间的objectKey称为：CommonPrefixes。（可选）
	 *
	 * `Marker` :string : 是一个字符串，用来设定返回结果的起始位置。设定Marker值之后，返回的Object会从Marker值之后按字母排序开始返回。（可选）
	 */
	getFiletrateObjects(params:bdObjectStorage_getFiletrateObjects_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取Object`
	 * ========params==========
	 *
	 * `point` :string : Bucket所在区域域名
	 *
	 * `bucketName` :string : 查询Object的key
	 */
	getObject(params:bdObjectStorage_getObject_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取Object中的一部分`
	 * ========params==========
	 *
	 * `point` :string : Bucket所在区域域名
	 *
	 * `bucketName` :string : Bucket名称
	 *
	 * `objectKey` :string : 查询Object的key
	 *
	 * `startPosition` :number : 从第几个字节开始截取
	 *
	 * `endPosition` :number : 截取到第几个字节
	 */
	getObjectPart(params:bdObjectStorage_getObjectPart_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `下载Object到指定路径`
	 * ========params==========
	 *
	 * `point` :string : Bucket所在区域域名
	 *
	 * `bucketName` :string : Bucket名称
	 *
	 * `objectKey` :string : 查询Object的key
	 *
	 * `savePath` :string : 保存地址 支持fs路径 不支持widget路径
	 */
	downloadObject(params:bdObjectStorage_downloadObject_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `只获取ObjectMetadata`
	 * ========params==========
	 *
	 * `point` :string : Bucket所在区域域名
	 *
	 * `bucketName` :string : Bucket名称
	 *
	 * `objectKey` :string : 查询Object的key
	 */
	getObjectMetaData(params:bdObjectStorage_getObjectMetaData_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取Object的URL`
	 * ========params==========
	 *
	 * `point` :string : Bucket所在区域域名
	 *
	 * `bucketName` :string : Bucket名称
	 *
	 * `objectKey` :string : 查询Object的key
	 *
	 * `keepTime` :number : 指定的URL有效时长（s）如果要设置为永久不失效的时间，可以设置为 -1，不可设置为其他负数。
	 */
	getObjectUrl(params:bdObjectStorage_getObjectUrl_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `删除Object`
	 * ========params==========
	 *
	 * `point` :string : Bucket所在区域域名
	 *
	 * `bucketName` :string : Bucket名称
	 *
	 * `objectKey` :string : 查询Object的key
	 */
	deleteObject(params:bdObjectStorage_deleteObject_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `分块上传`
	 * ========params==========
	 *
	 * `point` :string : Bucket所在区域域名
	 *
	 * `bucketName` :string : Bucket名称
	 *
	 * `objectKey` :string : 上传的Objectkey
	 *
	 * `filePath` :string : 文件路径；支持widget\fs路径；
	 *
	 * `partSize` :number : 每块大小；不得小于5Mb
	 */
	multipartUpload(params:bdObjectStorage_multipartUpload_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `取消分块上传`
	 * ========params==========
	 *
	 * `point` :string : Bucket所在区域域名
	 *
	 * `bucketName` :string : Bucket名称
	 *
	 * `objectKey` :string : 上传的Objectkey
	 *
	 * `uploadId` :string : 分块上传uploadId
	 */
	cancleMultipartUpload(params:bdObjectStorage_cancleMultipartUpload_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取未完成的分块上传`
	 * ========params==========
	 *
	 * `point` :string : Bucket所在区域域名
	 *
	 * `bucketName` :string : Bucket名称
	 */
	getUnUploadMultiparts(params:bdObjectStorage_getUnUploadMultiparts_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 获取所有已上传的分块信息*/ 
	getUploadMultiparts():void

}
interface bdObjectStorage_creatBucket_Params {
	/**Bucket所在区域域名；北京区域：http://bj.bcebos.com，广州区域*/ 
	point:string,

	/**Bucket名称*/ 
	bucketName:string,

}

interface bdObjectStorage_getBuckets_Params {
	/**Bucket所在区域域名*/ 
	point:string,

}

interface bdObjectStorage_doesBucketExist_Params {
	/**Bucket所在区域域名*/ 
	point:string,

	/**Bucket名称*/ 
	bucketName:string,

}

interface bdObjectStorage_deleteBucket_Params {
	/**Bucket所在区域域名*/ 
	point:string,

	/**Bucket名称*/ 
	bucketName:string,

}

interface bdObjectStorage_setBucketAcl_Params {
	/**Bucket所在区域域名*/ 
	point:string,

	/**Bucket名称*/ 
	bucketName:string,

	/**权限类别*/ 
	permission:string,

}

interface bdObjectStorage_setUserBucketAcl_Params {
	/**Bucket所在区域域名*/ 
	point:string,

	/**用户Id*/ 
	bucketName:string,

	/**权限*/ 
	permission:string,

}

interface bdObjectStorage_uploadFile_Params {
	/**Bucket所在区域域名*/ 
	point:string,

	/**Bucket名称*/ 
	bucketName:string,

	/**上传的Objectkey*/ 
	objectKey:string,

	/**文件路径；支持widget、fs格式*/ 
	filePath:string,

	/**(可选)自定义元数据	，BOS支持用户自定义元数据来对Object进行描述*/ 
	metaData?:Array<JSON>,

}

interface bdObjectStorage_uploadStr_Params {
	/**Bucket所在区域域名*/ 
	point:string,

	/**Bucket名称*/ 
	bucketName:string,

	/**上传的Objectkey*/ 
	objectKey:string,

	/**需要上传的字符串*/ 
	strData:string,

	/**(可选)自定义元数据	，BOS支持用户自定义元数据来对Object进行描述*/ 
	metaData?:Array<JSON>,

}

interface bdObjectStorage_copyObject_Params {
	/**Bucket所在区域域名*/ 
	point:string,

	/**源Object 的Bucket名称*/ 
	srcBucket:string,

	/**源Object 的 Key*/ 
	srcKey:string,

	/**新Object 的Bucket名称*/ 
	destBucket:string,

	/**新Object  Key*/ 
	destKey:string,

	/**(可选)判断源Object是否有修改决定是否拷贝，与checkETag二选一*/ 
	checkETag?:JSON,

	/**(可选)自定义元数据	，新Object的自定义数据*/ 
	metaData?:Array<JSON>,

}

interface bdObjectStorage_getObjsFromBucket_Params {
	/**Bucket所在区域域名*/ 
	point:string,

	/**源Object 的Bucket名称*/ 
	bucketName:string,

}

interface bdObjectStorage_getFiletrateObjects_Params {
	/**Bucket所在区域域名*/ 
	point:string,

	/**源Object 的Bucket名称*/ 
	bucketName:string,

	/**设定此次返回Object的最大个数，不可超过1000。（可选）*/ 
	MaxKeys?:number,

	/**设定objectKey的前缀，前缀是指objectKey包含并以Prefix的值作为开始。通常与Delimiter配合在查询模拟文件夹中使用。（可选）*/ 
	Prefix?:string,

	/**是一个分隔符，用来对objectKey进行分层。通常与Prefix配合在查询模拟文件夹中使用。从Prefix开始到第一次出现Delimiter字符之间的objectKey称为：CommonPrefixes。（可选）*/ 
	Delimiter?:string,

	/**是一个字符串，用来设定返回结果的起始位置。设定Marker值之后，返回的Object会从Marker值之后按字母排序开始返回。（可选）*/ 
	Marker?:string,

}

interface bdObjectStorage_getObject_Params {
	/**Bucket所在区域域名*/ 
	point:string,

	/**查询Object的key*/ 
	bucketName:string,

}

interface bdObjectStorage_getObjectPart_Params {
	/**Bucket所在区域域名*/ 
	point:string,

	/**Bucket名称*/ 
	bucketName:string,

	/**查询Object的key*/ 
	objectKey:string,

	/**从第几个字节开始截取*/ 
	startPosition:number,

	/**截取到第几个字节*/ 
	endPosition:number,

}

interface bdObjectStorage_downloadObject_Params {
	/**Bucket所在区域域名*/ 
	point:string,

	/**Bucket名称*/ 
	bucketName:string,

	/**查询Object的key*/ 
	objectKey:string,

	/**保存地址 支持fs路径 不支持widget路径*/ 
	savePath:string,

}

interface bdObjectStorage_getObjectMetaData_Params {
	/**Bucket所在区域域名*/ 
	point:string,

	/**Bucket名称*/ 
	bucketName:string,

	/**查询Object的key*/ 
	objectKey:string,

}

interface bdObjectStorage_getObjectUrl_Params {
	/**Bucket所在区域域名*/ 
	point:string,

	/**Bucket名称*/ 
	bucketName:string,

	/**查询Object的key*/ 
	objectKey:string,

	/**指定的URL有效时长（s）如果要设置为永久不失效的时间，可以设置为 -1，不可设置为其他负数。*/ 
	keepTime:number,

}

interface bdObjectStorage_deleteObject_Params {
	/**Bucket所在区域域名*/ 
	point:string,

	/**Bucket名称*/ 
	bucketName:string,

	/**查询Object的key*/ 
	objectKey:string,

}

interface bdObjectStorage_multipartUpload_Params {
	/**Bucket所在区域域名*/ 
	point:string,

	/**Bucket名称*/ 
	bucketName:string,

	/**上传的Objectkey*/ 
	objectKey:string,

	/**文件路径；支持widget\fs路径；*/ 
	filePath:string,

	/**每块大小；不得小于5Mb*/ 
	partSize:number,

}

interface bdObjectStorage_cancleMultipartUpload_Params {
	/**Bucket所在区域域名*/ 
	point:string,

	/**Bucket名称*/ 
	bucketName:string,

	/**上传的Objectkey*/ 
	objectKey:string,

	/**分块上传uploadId*/ 
	uploadId:string,

}

interface bdObjectStorage_getUnUploadMultiparts_Params {
	/**Bucket所在区域域名*/ 
	point:string,

	/**Bucket名称*/ 
	bucketName:string,

}

interface shortcutCreator {
	/** 创建快捷方式*/ 
	createShortcut():void

}
interface ftpServer {
	/** 开启ftp服务，开启成功后在电脑端文件资源管理器输入ftp://ip:端口号即可访问手机分享文件。需要开启存储权限。*/ 
	startFtp(callback?: (ret:JSON, err:JSON) => void):void

	/** 关闭ftp服务。*/ 
	stopFtp(callback?: (ret:JSON, err:JSON) => void):void

}
interface lockControler {
	/**
	 * `设置开关机时间`
	 * ========params==========
	 *
	 * `openDate` :string : 开机时间，格式yyyy-MM-dd HH:mm:ss
	 *
	 * `closeDate` :string : 关机时间，格式yyyy-MM-dd HH:mm:ss
	 */
	setPowerTime(params:lockControler_setPowerTime_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 取消定时开关机时间*/ 
	cancelPowerTimef(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `设置系统时间`
	 * ========params==========
	 *
	 * `date` :string : 时间，格式yyyy-MM-dd HH:mm:ss
	 */
	setSysTime(params:lockControler_setSysTime_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 立刻关机*/ 
	powerOff(callback?: (ret:JSON, err:JSON) => void):void

	/** 重启板卡*/ 
	reboot(callback?: (ret:JSON, err:JSON) => void):void

	/** 隐藏导航栏*/ 
	hideBar(callback?: (ret:JSON, err:JSON) => void):void

	/** 显示导航栏*/ 
	showBar(callback?: (ret:JSON, err:JSON) => void):void

	/** 截屏，调用此接口系统会进行截屏，图片保存路径， /mnt/sdcard/Screenshots， 文件名按时间保存， 例如 Screenshot_2011-01-01-20-00-58.png*/ 
	screenshot(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `背光灯灯管理`
	 * ========params==========
	 *
	 * `open` :boolean : 打开或关闭背光灯
	 */
	backlight(params:lockControler_backlight_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `恢复出厂设置`
	 * ========params==========
	 *
	 * `enable` :boolean : 是否恢复出厂，ture/恢复出厂设置，false/取消恢复出厂
	 */
	recovery(params:lockControler_recovery_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `开关锁`
	 * ========params==========
	 *
	 * `open` :boolean : 打开或关闭锁
	 */
	lockControl(params:lockControler_lockControl_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `OTA升级`
	 * ========params==========
	 *
	 * `path` :string : 升级包路径，支持fs以及原生路径。
	 */
	otaupdate(params:lockControler_otaupdate_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface lockControler_setPowerTime_Params {
	/**开机时间，格式yyyy-MM-dd HH:mm:ss*/ 
	openDate:string,

	/**关机时间，格式yyyy-MM-dd HH:mm:ss*/ 
	closeDate:string,

}

interface lockControler_setSysTime_Params {
	/**时间，格式yyyy-MM-dd HH:mm:ss*/ 
	date:string,

}

interface lockControler_backlight_Params {
	/**打开或关闭背光灯*/ 
	open:boolean,

}

interface lockControler_recovery_Params {
	/**是否恢复出厂，ture/恢复出厂设置，false/取消恢复出厂*/ 
	enable:boolean,

}

interface lockControler_lockControl_Params {
	/**打开或关闭锁*/ 
	open:boolean,

}

interface lockControler_otaupdate_Params {
	/**升级包路径，支持fs以及原生路径。*/ 
	path:string,

}

interface zip {
}
interface appManage {
}
interface wmVideoRecorder {
	/** 调用系统相机录制视频*/ 
	recordVedios(callback?: (ret:JSON) => void):void

}
interface browser {
	/**
	 * `初始化浏览器`
	 * ========params==========
	 *
	 * `x` :number : 左上角x坐标，默认0
	 *
	 * `y` :number : 左上角y坐标，默认0
	 *
	 * `w` :number : 宽，默认屏幕宽
	 *
	 * `h` :number : 高，默认屏幕高
	 */
	init(params:browser_init_Params):void

	/** 关闭浏览器*/ 
	close():void

	/** 隐藏浏览器*/ 
	hide():void

	/** 显示浏览器*/ 
	show():void

	/**
	 * `加载网址`
	 * ========params==========
	 *
	 * `url` :string : 加载的网站地址
	 */
	loadUrl(params:browser_loadUrl_Params):void

	/** 历史记录后退一页*/ 
	historyBack():void

	/** 历史记录前进一页*/ 
	historyForward():void

	/** 是否能后退一页*/ 
	isHistoryBack(callback?: (ret:JSON) => void):void

	/** 是否能前进一页*/ 
	isHistoryForward(callback?: (ret:JSON) => void):void

	/**
	 * `插入js字符串并且执行，返回仅限字符串类型（也可返回）`
	 * ========params==========
	 *
	 * `jsStr` :string : js语句
	 */
	insertJSstr(params:browser_insertJSstr_Params):void

	/**
	 * `插入js文件，文件写法说明在测试用例的script目录下myJS.js中`
	 * ========params==========
	 *
	 * `path` :string : js文件地址（相对地址）
	 */
	insertJSFile(params:browser_insertJSFile_Params):void

	/**
	 * `执行插入js文件中的方法`
	 * ========params==========
	 *
	 * `functionName` :string : 方法名字
	 */
	executeJS(params:browser_executeJS_Params):void

	/**
	 * `监听事件`
	 * ========params==========
	 *
	 * `name` :string : 事件名称。
	 */
	addEventListener(params:browser_addEventListener_Params, callback?: (ret:JSON) => void):void

}
interface browser_init_Params {
	/**左上角x坐标，默认0*/ 
	x:number,

	/**左上角y坐标，默认0*/ 
	y:number,

	/**宽，默认屏幕宽*/ 
	w:number,

	/**高，默认屏幕高*/ 
	h:number,

}

interface browser_loadUrl_Params {
	/**加载的网站地址*/ 
	url:string,

}

interface browser_insertJSstr_Params {
	/**js语句*/ 
	jsStr:string,

}

interface browser_insertJSFile_Params {
	/**js文件地址（相对地址）*/ 
	path:string,

}

interface browser_executeJS_Params {
	/**方法名字*/ 
	functionName:string,

}

interface browser_addEventListener_Params {
	/**事件名称。*/ 
	name:string,

}

interface videoTool {
	/** 视频压缩，格式转换*/ 
	compressVideo(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `截取视频任意时间点静态图`
	 * ========params==========
	 *
	 * `path` :string : 处理视频的绝对路径
	 *
	 * `startTime` :number : （可选项）截屏时间点，数量级为秒，如0，3.5，10等。
	 */
	captureScreen(params:videoTool_captureScreen_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取视频信息`
	 * ========params==========
	 *
	 * `path` :string : 处理视频的绝对路径
	 */
	getVideoInfo(params:videoTool_getVideoInfo_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `截取视频功能`
	 * ========params==========
	 *
	 * `path` :string : 处理视频的绝对路径，路径须正确，并有此文件
	 *
	 * `rulerLabelInterval` :number : 标尺数字距离显示，默认值为5
	 *
	 * `maxLength` :number : 截取视频的最长时间，单位为秒。默认值为15
	 *
	 * `minLength` :number : 截取视频的最短时间，单位为秒。默认值为3
	 */
	interceptionVideo(params:videoTool_interceptionVideo_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface videoTool_captureScreen_Params {
	/**处理视频的绝对路径*/ 
	path:string,

	/**（可选项）截屏时间点，数量级为秒，如0，3.5，10等。*/ 
	startTime?:number,

}

interface videoTool_getVideoInfo_Params {
	/**处理视频的绝对路径*/ 
	path:string,

}

interface videoTool_interceptionVideo_Params {
	/**处理视频的绝对路径，路径须正确，并有此文件*/ 
	path:string,

	/**标尺数字距离显示，默认值为5*/ 
	rulerLabelInterval:number,

	/**截取视频的最长时间，单位为秒。默认值为15*/ 
	maxLength:number,

	/**截取视频的最短时间，单位为秒。默认值为3*/ 
	minLength:number,

}

interface mp3Recorder {
	/** 视频结果和声音分贝监听*/ 
	addEventListener():void

	/**
	 * `开始录音`
	 * ========params==========
	 *
	 * `channel` :number : （可选项）声道支持:1 单声道 2 立体声道。
	 *
	 * `sampleRates` :number : （可选项）采样率。(8000/44100/96000)
	 *
	 * `isDefaultToSpeaker` :boolean : （可选项）限定录制声音时是否限定扬声器进行播放音频。
	 */
	startRecord(params:mp3Recorder_startRecord_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 停止录音*/ 
	stopRecord(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `显示线性波形图`
	 * ========params==========
	 *
	 * `rect` :JSON : （必填项）模块的位置及尺寸
	 *
	 * `fixedOn` :string : （可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window
	 *
	 * `fixed` :boolean : （（可选项）模块是否随所属 Window 或 Frame 滚动
	 *
	 * `isTransparent` :boolean : （可选项）背景是否透明(透明时可以穿透点击视图)。
	 */
	openVoiceLine(params:mp3Recorder_openVoiceLine_Params, callback?: (ret:JSON) => void):void

	/** 关闭线性波形图*/ 
	closeVoiceLine(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `设置波形图的分贝值`
	 * ========params==========
	 *
	 * `decibel` :any : （可选项）分贝值，范围0-60
	 */
	setDecibels(params:mp3Recorder_setDecibels_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 暂停录音*/ 
	pauseRecord(callback?: (ret:JSON, err:JSON) => void):void

	/** 恢复录音*/ 
	resumeRecord(callback?: (ret:JSON, err:JSON) => void):void

}
interface mp3Recorder_startRecord_Params {
	/**（可选项）声道支持:1 单声道 2 立体声道。*/ 
	channel?:number,

	/**（可选项）采样率。(8000/44100/96000)*/ 
	sampleRates?:number,

	/**（可选项）限定录制声音时是否限定扬声器进行播放音频。*/ 
	isDefaultToSpeaker?:boolean,

}

interface mp3Recorder_openVoiceLine_Params {
	/**（必填项）模块的位置及尺寸*/ 
	rect:JSON,

	/**（可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window*/ 
	fixedOn?:string,

	/**（（可选项）模块是否随所属 Window 或 Frame 滚动*/ 
	fixed?:boolean,

	/**（可选项）背景是否透明(透明时可以穿透点击视图)。*/ 
	isTransparent?:boolean,

}

interface mp3Recorder_setDecibels_Params {
	/**（可选项）分贝值，范围0-60*/ 
	decibel?:any,

}

interface widgetPlan {
	/**
	 * `设置userId`
	 * ========params==========
	 *
	 * `userId` :string : 登陆账号userId
	 */
	setUserId(params:widgetPlan_setUserId_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 获取userId*/ 
	getUserId(callback?: (ret:JSON, err:JSON) => void):void

	/** 清除已保存UserId*/ 
	removeUserId(callback?: (ret:JSON, err:JSON) => void):void

}
interface widgetPlan_setUserId_Params {
	/**登陆账号userId*/ 
	userId:string,

}

interface volume {
	/**
	 * `初始化媒体音量控制器`
	 * ========params==========
	 *
	 * `isShowSystemUI` :boolean : （可选项）是否显示系统自带的音量控制条(显示:true 隐藏:false)
	 */
	initVolume(params:volume_initVolume_Params, callback?: (ret:JSON) => void):void

	/** 获取当前媒体音量*/ 
	getVolume():void

	/**
	 * `设置媒体音量`
	 * ========params==========
	 *
	 * `volume` :number : （可选项）0-100
	 */
	setVolume(params:volume_setVolume_Params, callback?: (ret:JSON) => void):void

	/** 扬声器与听筒切换*/ 
	setSpeakerphoneOn():void

	/** 监听手机物理音量按键事件*/ 
	addVolumeEvent():void

	/** 移除监听手机物理音量按键事件*/ 
	removeVolumeEvent():void

}
interface volume_initVolume_Params {
	/**（可选项）是否显示系统自带的音量控制条(显示:true 隐藏:false)*/ 
	isShowSystemUI?:boolean,

}

interface volume_setVolume_Params {
	/**（可选项）0-100*/ 
	volume?:number,

}

interface acWebsocket {
	/**
	 * `连接websocket`
	 * ========params==========
	 *
	 * `url` :string : 连接地址
	 *
	 * `heartInterval` :number : （可选项）发送心跳包间隔
	 *
	 * `heartData` :string : （可选项）发送心跳包内容，heartInterval大于0有效
	 */
	open(params:acWebsocket_open_Params):void

	/** 断开连接websocket*/ 
	close():void

	/**
	 * `发送消息`
	 * ========params==========
	 *
	 * `content` :string : 发送的消息内容
	 */
	send(params:acWebsocket_send_Params):void

	/** 获取WebSocket连接状态*/ 
	getSocketReadyState():void

	/** 添加监听*/ 
	addEventListener():void

}
interface acWebsocket_open_Params {
	/**连接地址*/ 
	url:string,

	/**（可选项）发送心跳包间隔*/ 
	heartInterval?:number,

	/**（可选项）发送心跳包内容，heartInterval大于0有效*/ 
	heartData?:string,

}

interface acWebsocket_send_Params {
	/**发送的消息内容*/ 
	content:string,

}

interface setJumpNew {
	/** 打开对应app设置页面*/ 
	open():void

	/** 是否开启推送通知*/ 
	isUserNotificationEnable():void

}
interface mobcommonlib {
}
interface makeSharePic {
	/**
	 * `生成分享图片`
	 * ========params==========
	 *
	 * `imgUrl` :string : 要分享的图片的路径。支持本地路径和网络url,如：fs://...、cache://...、https://...
	 *
	 * `savePath` :string : （可选项）最终生成图片的本地保存路径，如：cache://image、fs://image等。
	 *
	 * `fileName` :string : （可选项）最终生成图片的文件名，如：toShare.png。
	 *
	 * `insertImage` :boolean : 是否把生成的图片插入到本地相册
	 *
	 * `qrCode` :string : 要生成的二维码内容
	 *
	 * `qrImgUrl` :string : (可选项)替换图中二维码位置(包含“长按识别二维码”部分)的图片路径。支持本地路径和网络url,如：fs://...、cache://...、https://...
	 *
	 * `erWeiMaErrorL` :string : （可选项）二维码的纠错等级 **仅Android有效**
	 *
	 * `erWeiMaWidth` :number : （可选项）Android中为创建二维码时的宽度，Ios中为创建二维码时的正方形边长。（注意：该参数是创建二维码时设置的初始参数，最终的视图会填充到图片的相应位置）
	 *
	 * `erWeiMaHeight` :number : （可选项）创建二维码时的高度。（注意：该参数是创建二维码时设置的初始参数，最终的视图会填充到图片的相应位置） **仅Android有效**
	 *
	 * `expressType` :string : 对应生成图片的 包邮 内容。
	 *
	 * `goodTitle` :string : 对应生成图片的 商品标题 内容。
	 *
	 * `nowPriceStatus` :string : 对应生成图片的 现价描述 内容（如："现价 ：￥20000"）。
	 *
	 * `discountType` :string : 对应生成图片的 券 内容（如："券"）。
	 *
	 * `discountPrice` :string : 对应生成图片的 券减价格 内容（如："100元"）。
	 *
	 * `finalPriceType` :string : 对应生成图片的 券后价 内容（如："券后价" "抢购价"等）。
	 *
	 * `moneyUnit` :string : 对应生成图片的 券后价价格前面的￥ 内容(如："￥")。（如不需要可以设空""）
	 *
	 * `finalPrice` :string : 对应生成图片的 券后价价格 内容(如："100.0")。
	 *
	 * `isHtmlText` :boolean : 传入的商品信息内容是否是Html格式内容（如：nowPriceStatus 传："现价 ：```xml <font color='#FF0000'>￥200</font>" ```）。
	 */
	makePicture(params:makeSharePic_makePicture_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `打开二维码`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）二维码视图的位置。
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）是否将模块视图固定到窗口上，不跟随窗口上下滚动，可为空
	 *
	 * `qrCode` :string : 要生成的二维码内容
	 *
	 * `erWeiMaErrorL` :string : （可选项）二维码的纠错等级 **仅Android有效**
	 *
	 * `erWeiMaWidth` :number : （可选项）Android中为创建二维码时的宽度。（注意：该参数是创建二维码时设置的初始参数，最终的视图会填充到rect区域） **仅Android有效**
	 *
	 * `erWeiMaHeight` :number : （可选项）创建二维码时的高度。（注意：该参数是创建二维码时设置的初始参数，最终的视图会填充到rect区域） **仅Android有效**
	 *
	 * `bgColor` :string : （可选项）二维码视图的背景颜色,支持“#+6位数的十六进制”的颜色设置（如："#ff0000"）。
	 */
	openErWeiMa(params:makeSharePic_openErWeiMa_Params):void

	/** 关闭当前打开的二维码视图*/ 
	closeErWeiMa():void

	/**
	 * `将字符串生成二维图片`
	 * ========params==========
	 *
	 * `width` :number : （可选项）二维码图片的宽度。
	 *
	 * `height` :number : （可选项）二维码图片的高度。
	 *
	 * `margin` :number : （可选项）生成图片的边框宽度 （注意ios中二维码自带4个像素的边框）。
	 *
	 * `savePath` :string : （可选项）最终生成图片的本地保存路径，如：cache://image、fs://image等。
	 *
	 * `fileName` :string : （可选项）最终生成图片的文件名，如：toShare.png。
	 *
	 * `qrCode` :string : 要生成的二维码内容
	 *
	 * `erWeiMaErrorL` :string : （可选项）二维码的纠错等级 **仅Android有效**
	 *
	 * `bgColor` :string : （可选项）生成图片的背景颜色,支持“#+6位数的十六进制”的颜色设置（如："#ff0000"）。
	 */
	createErweimaPic(params:makeSharePic_createErweimaPic_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `由两张图片合成生成一张图片（可自定义上层图片位置）`
	 * ========params==========
	 *
	 * `bgPicUrl` :string : 合成图片所需的两张图片中作为**底层**图片的地址。支持本地路径和网络url,如：fs://...、cache://...、https://...
	 *
	 * `attachPicUrl` :string : 合成图片所需的两张图片中作为**上层**图片的地址。支持本地路径和网络url,如：fs://...、cache://...、https://...
	 *
	 * `insertImage` :boolean : 是否把生成的图片插入到本地相册
	 *
	 * `mainWidth` :number : （可选项）合成图片的最终宽度。
	 *
	 * `mainHeight` :number : （可选项）合成图片的最终高度。
	 *
	 * `l` :number : 上层图片相对于合成图片的 左边距（用于定位上层图片left位置）。
	 *
	 * `t` :number : 上层图片相对于合成图片的 上边距（用于定位上层图片位置）。
	 *
	 * `subWidth` :number : （需传大于0的值！）上层图片在最终合成图片中的 宽度（用于定位上层图片位置）。
	 *
	 * `subHeight` :number : 上层图片在最终合成图片中的 高度（用于定位上层图片位置）。
	 *
	 * `savePath` :string : （可选项）最终生成图片的本地保存路径，如：cache://image、fs://image等。
	 *
	 * `fileName` :string : （可选项）最终生成图片的文件名，如：toShare.png。
	 */
	composePic(params:makeSharePic_composePic_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface makeSharePic_makePicture_Params {
	/**要分享的图片的路径。支持本地路径和网络url,如：fs://...、cache://...、https://...*/ 
	imgUrl:string,

	/**（可选项）最终生成图片的本地保存路径，如：cache://image、fs://image等。*/ 
	savePath?:string,

	/**（可选项）最终生成图片的文件名，如：toShare.png。*/ 
	fileName?:string,

	/**是否把生成的图片插入到本地相册*/ 
	insertImage:boolean,

	/**要生成的二维码内容*/ 
	qrCode:string,

	/**(可选项)替换图中二维码位置(包含“长按识别二维码”部分)的图片路径。支持本地路径和网络url,如：fs://...、cache://...、https://...*/ 
	qrImgUrl?:string,

	/**（可选项）二维码的纠错等级 **仅Android有效***/ 
	erWeiMaErrorL?:string,

	/**（可选项）Android中为创建二维码时的宽度，Ios中为创建二维码时的正方形边长。（注意：该参数是创建二维码时设置的初始参数，最终的视图会填充到图片的相应位置）*/ 
	erWeiMaWidth?:number,

	/**（可选项）创建二维码时的高度。（注意：该参数是创建二维码时设置的初始参数，最终的视图会填充到图片的相应位置） **仅Android有效***/ 
	erWeiMaHeight?:number,

	/**对应生成图片的 包邮 内容。*/ 
	expressType:string,

	/**对应生成图片的 商品标题 内容。*/ 
	goodTitle:string,

	/**对应生成图片的 现价描述 内容（如："现价 ：￥20000"）。*/ 
	nowPriceStatus:string,

	/**对应生成图片的 券 内容（如："券"）。*/ 
	discountType:string,

	/**对应生成图片的 券减价格 内容（如："100元"）。*/ 
	discountPrice:string,

	/**对应生成图片的 券后价 内容（如："券后价" "抢购价"等）。*/ 
	finalPriceType:string,

	/**对应生成图片的 券后价价格前面的￥ 内容(如："￥")。（如不需要可以设空""）*/ 
	moneyUnit:string,

	/**对应生成图片的 券后价价格 内容(如："100.0")。*/ 
	finalPrice:string,

	/**传入的商品信息内容是否是Html格式内容（如：nowPriceStatus 传："现价 ：```xml <font color='#FF0000'>￥200</font>" ```）。*/ 
	isHtmlText:boolean,

}

interface makeSharePic_openErWeiMa_Params {
	/**（可选项）二维码视图的位置。*/ 
	rect?:JSON,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）是否将模块视图固定到窗口上，不跟随窗口上下滚动，可为空*/ 
	fixed?:boolean,

	/**要生成的二维码内容*/ 
	qrCode:string,

	/**（可选项）二维码的纠错等级 **仅Android有效***/ 
	erWeiMaErrorL?:string,

	/**（可选项）Android中为创建二维码时的宽度。（注意：该参数是创建二维码时设置的初始参数，最终的视图会填充到rect区域） **仅Android有效***/ 
	erWeiMaWidth?:number,

	/**（可选项）创建二维码时的高度。（注意：该参数是创建二维码时设置的初始参数，最终的视图会填充到rect区域） **仅Android有效***/ 
	erWeiMaHeight?:number,

	/**（可选项）二维码视图的背景颜色,支持“#+6位数的十六进制”的颜色设置（如："#ff0000"）。*/ 
	bgColor?:string,

}

interface makeSharePic_createErweimaPic_Params {
	/**（可选项）二维码图片的宽度。*/ 
	width?:number,

	/**（可选项）二维码图片的高度。*/ 
	height?:number,

	/**（可选项）生成图片的边框宽度 （注意ios中二维码自带4个像素的边框）。*/ 
	margin?:number,

	/**（可选项）最终生成图片的本地保存路径，如：cache://image、fs://image等。*/ 
	savePath?:string,

	/**（可选项）最终生成图片的文件名，如：toShare.png。*/ 
	fileName?:string,

	/**要生成的二维码内容*/ 
	qrCode:string,

	/**（可选项）二维码的纠错等级 **仅Android有效***/ 
	erWeiMaErrorL?:string,

	/**（可选项）生成图片的背景颜色,支持“#+6位数的十六进制”的颜色设置（如："#ff0000"）。*/ 
	bgColor?:string,

}

interface makeSharePic_composePic_Params {
	/**合成图片所需的两张图片中作为**底层**图片的地址。支持本地路径和网络url,如：fs://...、cache://...、https://...*/ 
	bgPicUrl:string,

	/**合成图片所需的两张图片中作为**上层**图片的地址。支持本地路径和网络url,如：fs://...、cache://...、https://...*/ 
	attachPicUrl:string,

	/**是否把生成的图片插入到本地相册*/ 
	insertImage:boolean,

	/**（可选项）合成图片的最终宽度。*/ 
	mainWidth?:number,

	/**（可选项）合成图片的最终高度。*/ 
	mainHeight?:number,

	/**上层图片相对于合成图片的 左边距（用于定位上层图片left位置）。*/ 
	l:number,

	/**上层图片相对于合成图片的 上边距（用于定位上层图片位置）。*/ 
	t:number,

	/**（需传大于0的值！）上层图片在最终合成图片中的 宽度（用于定位上层图片位置）。*/ 
	subWidth:number,

	/**上层图片在最终合成图片中的 高度（用于定位上层图片位置）。*/ 
	subHeight:number,

	/**（可选项）最终生成图片的本地保存路径，如：cache://image、fs://image等。*/ 
	savePath?:string,

	/**（可选项）最终生成图片的文件名，如：toShare.png。*/ 
	fileName?:string,

}

interface tvcontrol {
	/**
	 * `开启电视遥控器等按键监听`
	 * ========params==========
	 *
	 * `coverBack` :boolean : （可选项）是否覆盖返回键，填true时，点击返回键将没有效果，自行在回调函数中处理。默认false时，不覆盖，也就是说回调函数返回“返回键”的keyCode值时，原先返回事件依然有效。
	 *
	 * `coverHome` :boolean : （可选项）是否覆盖主页键，填true时，点主页键将没有效果，自行在回调函数中处理。
	 *
	 * `canClick` :boolean : （可选项）页面是否可以点击。填true时，点击一下屏幕后，监听事件结束，然后，就可以点击页面按钮了。**（这个函数只是为了方便大家在手机上调试时使用，因为手机没有遥控器上下左右和确定键，只有通过屏幕点击到下一页。去电视上测试时，可以忽略这个。）**
	 *
	 * `coverOtherDefault` :boolean : （可选项）是否覆盖其他键（除了“返回键”和“主页键”以外的键，**要想增加按键是否覆盖，后期可以联系开发者添加**），填true时，点击遥控器其他键盘将没有效果，自行在回调函数中处理。
	 */
	open(params:tvcontrol_open_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface tvcontrol_open_Params {
	/**（可选项）是否覆盖返回键，填true时，点击返回键将没有效果，自行在回调函数中处理。默认false时，不覆盖，也就是说回调函数返回“返回键”的keyCode值时，原先返回事件依然有效。*/ 
	coverBack?:boolean,

	/**（可选项）是否覆盖主页键，填true时，点主页键将没有效果，自行在回调函数中处理。*/ 
	coverHome?:boolean,

	/**（可选项）页面是否可以点击。填true时，点击一下屏幕后，监听事件结束，然后，就可以点击页面按钮了。**（这个函数只是为了方便大家在手机上调试时使用，因为手机没有遥控器上下左右和确定键，只有通过屏幕点击到下一页。去电视上测试时，可以忽略这个。）***/ 
	canClick?:boolean,

	/**（可选项）是否覆盖其他键（除了“返回键”和“主页键”以外的键，**要想增加按键是否覆盖，后期可以联系开发者添加**），填true时，点击遥控器其他键盘将没有效果，自行在回调函数中处理。*/ 
	coverOtherDefault?:boolean,

}

interface wlnotice {
	/** 判断当前设备是否开启了相关权限。*/ 
	isEnabled():void

	/** 跳转权限列表*/ 
	goNotificationSettings():void

	/** 监控导航栏内容。*/ 
	notice():void

}
interface miniAudio {
	/** 播放音效，只支持wav格式音效。*/ 
	play(callback?: (ret:JSON) => void):void

}
interface sysPrintPlus {
	/** 跳转系统打印设置页面*/ 
	toSystemPrintPage():void

	/**
	 * `打印pdf`
	 * ========params==========
	 *
	 * `filePath` :string : （必填项）文件路径；支持widget以及fs路径
	 *
	 * `margins` :JSON : （可选项）边距设置
	 *
	 * `jobName` :string : 打印任务名称
	 *
	 * `colorType` :number : 是否彩色打印(1:黑白图像 2:彩色图像)
	 *
	 * `duplexType` :number : 是否双面打印(0:禁止双面 1:单面打印 2:双面打印)
	 *
	 * `orientationType` :number : 设置打印方向(1:设置图像是以横向打印 2:设置图像是以纵向打印)
	 *
	 * `scaleType` :number : 设置图片是否缩放(1:铺满 2:原图-四边有留白)
	 */
	printPdf(params:sysPrintPlus_printPdf_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `打印网页内容`
	 * ========params==========
	 *
	 * `url` :string : （必填项）网站路径
	 *
	 * `margins` :JSON : （可选项）边距设置
	 *
	 * `jobName` :string : 打印任务名称
	 *
	 * `colorType` :number : 是否彩色打印(1:黑白图像 2:彩色图像)
	 *
	 * `duplexType` :number : 是否双面打印(0:禁止双面 1:单面打印 2:双面打印)
	 *
	 * `orientationType` :number : 设置打印方向(1:设置图像是以横向打印 2:设置图像是以纵向打印)
	 *
	 * `scaleType` :number : 设置图片是否缩放(1:铺满 2:原图-四边有留白)
	 */
	printWebPage(params:sysPrintPlus_printWebPage_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `打印Html`
	 * ========params==========
	 *
	 * `html` :string : （必填项）html网页内容
	 *
	 * `margins` :JSON : （可选项）边距设置
	 *
	 * `jobName` :string : 打印任务名称
	 *
	 * `colorType` :number : 是否彩色打印(1:黑白图像 2:彩色图像)
	 *
	 * `duplexType` :number : 是否双面打印(0:禁止双面 1:单面打印 2:双面打印)
	 *
	 * `orientationType` :number : 设置打印方向(1:设置图像是以横向打印 2:设置图像是以纵向打印)
	 *
	 * `scaleType` :number : 设置图片是否缩放(1:铺满 2:原图-四边有留白)
	 */
	printHtml(params:sysPrintPlus_printHtml_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `打印图片`
	 * ========params==========
	 *
	 * `filePath` :string : （必填项）文件路径；支持widget以及fs路径
	 *
	 * `jobName` :string : 打印任务名称
	 *
	 * `scaleType` :number : 是否彩色打印(1:选择图像是否填满纸张并被裁剪 2:图像是否缩放，但是留出空白)
	 *
	 * `colorType` :number : 是否彩色打印(1:黑白图像 2:彩色图像)
	 *
	 * `orientationType` :number : 设置打印方向(1:设置图像是以横向打印 2:设置图像是以纵向打印)
	 *
	 * `scaleType` :number : 设置图片是否缩放(1:铺满 2:原图-四边有留白)
	 */
	printImg(params:sysPrintPlus_printImg_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 判断是否有打印服务*/ 
	hasPrintService():void

}
interface sysPrintPlus_printPdf_Params {
	/**（必填项）文件路径；支持widget以及fs路径*/ 
	filePath:string,

	/**（可选项）边距设置*/ 
	margins?:JSON,

	/**打印任务名称*/ 
	jobName:string,

	/**是否彩色打印(1:黑白图像 2:彩色图像)*/ 
	colorType:number,

	/**是否双面打印(0:禁止双面 1:单面打印 2:双面打印)*/ 
	duplexType:number,

	/**设置打印方向(1:设置图像是以横向打印 2:设置图像是以纵向打印)*/ 
	orientationType:number,

	/**设置图片是否缩放(1:铺满 2:原图-四边有留白)*/ 
	scaleType:number,

}

interface sysPrintPlus_printWebPage_Params {
	/**（必填项）网站路径*/ 
	url:string,

	/**（可选项）边距设置*/ 
	margins?:JSON,

	/**打印任务名称*/ 
	jobName:string,

	/**是否彩色打印(1:黑白图像 2:彩色图像)*/ 
	colorType:number,

	/**是否双面打印(0:禁止双面 1:单面打印 2:双面打印)*/ 
	duplexType:number,

	/**设置打印方向(1:设置图像是以横向打印 2:设置图像是以纵向打印)*/ 
	orientationType:number,

	/**设置图片是否缩放(1:铺满 2:原图-四边有留白)*/ 
	scaleType:number,

}

interface sysPrintPlus_printHtml_Params {
	/**（必填项）html网页内容*/ 
	html:string,

	/**（可选项）边距设置*/ 
	margins?:JSON,

	/**打印任务名称*/ 
	jobName:string,

	/**是否彩色打印(1:黑白图像 2:彩色图像)*/ 
	colorType:number,

	/**是否双面打印(0:禁止双面 1:单面打印 2:双面打印)*/ 
	duplexType:number,

	/**设置打印方向(1:设置图像是以横向打印 2:设置图像是以纵向打印)*/ 
	orientationType:number,

	/**设置图片是否缩放(1:铺满 2:原图-四边有留白)*/ 
	scaleType:number,

}

interface sysPrintPlus_printImg_Params {
	/**（必填项）文件路径；支持widget以及fs路径*/ 
	filePath:string,

	/**打印任务名称*/ 
	jobName:string,

	/**是否彩色打印(1:选择图像是否填满纸张并被裁剪 2:图像是否缩放，但是留出空白)*/ 
	scaleType:number,

	/**是否彩色打印(1:黑白图像 2:彩色图像)*/ 
	colorType:number,

	/**设置打印方向(1:设置图像是以横向打印 2:设置图像是以纵向打印)*/ 
	orientationType:number,

	/**设置图片是否缩放(1:铺满 2:原图-四边有留白)*/ 
	scaleType:number,

}

interface phoneInfoPlus {
	/** 获取手机名称*/ 
	getName():void

	/** 获取手机电量*/ 
	getBatteryLevel():void

	/** 获取当前系统名称*/ 
	getSystemName():void

	/** 获取当前系统版本号*/ 
	getSystemVersion():void

	/** 获取广告标识符*/ 
	getAdvertisingIdentifier():void

	/** 获取UUID。注意：Android获取uuid需要“READ_PHONE_STATE”权限，此权限为敏感权限，需要在隐私政策中说明，否则上架应用市场可能无法通过审核。*/ 
	getUUID():void

	/** 获取设备当前语言*/ 
	getDeviceLanguage():void

	/** 获取系统总内存空间*/ 
	getPhysicalMemory():void

	/** 获取设备IMEI;Android10及以上不可用，调用前需要先申请电话权限*/ 
	getIMEI():void

	/** 获取iccid;Android10及以上不可用，调用前需要先申请电话权限*/ 
	getICCID():void

}
interface ARRuler {
	/** 判断当前设备是否支持 AR 尺子*/ 
	isSupported():void

	/**
	 * `监听尺子各种事件`
	 * ========params==========
	 *
	 * `target` :string : 监听的事件名
	 */
	addEventListener(params:ARRuler_addEventListener_Params, callback?: (ret:JSON) => void):void

	/**
	 * `打开摄像头`
	 * ========params==========
	 *
	 * `lineColor` :string : 测量线颜色，支持rgb、rgba、#
	 *
	 * `textColor` :string : 测量长度文本颜色，支持rgb、rgba、#
	 *
	 * `centrum` :JSON : 锚钉样式配置
	 *
	 * `crossMark` :JSON : 摄像头捕捉的画面正中间的准星样式配置
	 */
	open(params:ARRuler_open_Params, callback?: (ret:JSON) => void):void

	/** 在当前位置（准星所在的位置，画面的正中间）添加铆钉*/ 
	addAnchor(callback?: (ret:JSON, err:JSON) => void):void

	/** 清除铆钉及测量线*/ 
	clean():void

	/** 关闭*/ 
	close():void

	/** 隐藏*/ 
	hide():void

	/** 显示*/ 
	show():void

}
interface ARRuler_addEventListener_Params {
	/**监听的事件名*/ 
	target:string,

}

interface ARRuler_open_Params {
	/**测量线颜色，支持rgb、rgba、#*/ 
	lineColor:string,

	/**测量长度文本颜色，支持rgb、rgba、#*/ 
	textColor:string,

	/**锚钉样式配置*/ 
	centrum:JSON,

	/**摄像头捕捉的画面正中间的准星样式配置*/ 
	crossMark:JSON,

}

interface patternLock {
}
interface soundPlayer {
	/**
	 * `开始播放音效。`
	 * ========params==========
	 *
	 * `paths` :JSON : 音效文件的路径json集合，以路径作为key，每个key对应一段属性，可以同时播放多个路径文件，支持本地路径(fs://, widget://)
	 *
	 * `alert` :boolean : （可选项）播放音效时手机是否震动，暂仅支持iOS平台
	 */
	playSound(params:soundPlayer_playSound_Params):void

	/**
	 * `停止播放音效。`
	 * ========params==========
	 *
	 * `paths` :Array : 音效文件路径,支持本地路径（fs://, widget://)
	 */
	stopSound(params:soundPlayer_stopSound_Params):void

	/**
	 * `开始播放音效。`
	 * ========params==========
	 *
	 * `paths` :Array : 音效文件的路径json集合，可以同时播放多个路径文件，支持本地路径(fs://, widget://)
	 *
	 * `alert` :boolean : （可选项）播放音效时手机是否震动，暂仅支持iOS平台
	 */
	play(params:soundPlayer_play_Params):void

}
interface soundPlayer_playSound_Params {
	/**音效文件的路径json集合，以路径作为key，每个key对应一段属性，可以同时播放多个路径文件，支持本地路径(fs://, widget://)*/ 
	paths:JSON,

	/**（可选项）播放音效时手机是否震动，暂仅支持iOS平台*/ 
	alert?:boolean,

}

interface soundPlayer_stopSound_Params {
	/**音效文件路径,支持本地路径（fs://, widget://)*/ 
	paths:Array,

}

interface soundPlayer_play_Params {
	/**音效文件的路径json集合，可以同时播放多个路径文件，支持本地路径(fs://, widget://)*/ 
	paths:Array,

	/**（可选项）播放音效时手机是否震动，暂仅支持iOS平台*/ 
	alert?:boolean,

}

interface xyTimeout {
}
interface netSpeed {
	/**
	 * `获取实时网速`
	 * ========params==========
	 *
	 * `fresh` :number : （可选项）设置获取网速的时间间隔
	 */
	getnetSpeed(params:netSpeed_getnetSpeed_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 销毁实时网速,当应用不需要再获取网速时，需调用次方法释放内存，防止内存溢出。*/ 
	destroy():void

}
interface netSpeed_getnetSpeed_Params {
	/**（可选项）设置获取网速的时间间隔*/ 
	fresh?:number,

}

interface reachability {
	/** 开始监听*/ 
	start():void

	/** 停止监听*/ 
	stop():void

}
interface cacheManager {
	/** 清除App缓存（包含app沙盒及sd卡缓存目录；在Android系统中沙盒路径为/data/data/你的应用包名/cache/，sd卡缓存路径为SDCard/Android/data/你的应用包名/cache/,下同）。iOS端清除 Library/Caches：（cache://协议对应的路径的根目录）目录下所有数据。*/ 
	clearAppCache():void

	/**
	 * `清除任意指定路径的缓存`
	 * ========params==========
	 *
	 * `dir` :string : 本地路径，支持fs、box、本地可访问路径
	 */
	clearCache(params:cacheManager_clearCache_Params, callback?: (ret:JSON) => void):void

	/** 获取app缓存大小（包含app沙盒及sd卡缓存目录）*/ 
	getAppCacheSize():void

	/**
	 * `获取任意路径下的缓存大小`
	 * ========params==========
	 *
	 * `dir` :string : 本地路径，支持fs、box、本地可访问路径
	 */
	getCacheSize(params:cacheManager_getCacheSize_Params, callback?: (ret:JSON) => void):void

	/**
	 * `清空设置数据（Android对应app的SharedPreference。iOS端清除偏好设置的数据（Library/Preferences 目录）。`
	 * ========params==========
	 *
	 * `tag` :string : 数据的tag，iOS端忽略本参数
	 */
	clearSettingData(params:cacheManager_clearSettingData_Params, callback?: (ret:JSON) => void):void

	/** iOS端获取沙盒根目录。*/ 
	getHomeDirectory():void

}
interface cacheManager_clearCache_Params {
	/**本地路径，支持fs、box、本地可访问路径*/ 
	dir:string,

}

interface cacheManager_getCacheSize_Params {
	/**本地路径，支持fs、box、本地可访问路径*/ 
	dir:string,

}

interface cacheManager_clearSettingData_Params {
	/**数据的tag，iOS端忽略本参数*/ 
	tag:string,

}

interface easyShareImages {
	/**
	 * `分享多图`
	 * ========params==========
	 *
	 * `type` :any : 分享类型：0/1/2   0本地sdcard文件路径； 1网络url； 2 base64（ps：请严格按照参数传参，否则容易出错）
	 *
	 * `title` :string : 分享的文字内容
	 *
	 * `list` :Array : 分享的图片地址或者base64数组，例如：网络地址['https://www.baidu.com/img/bd_logo1.png?where=super',	'https://www.baidu.com/img/bd_logo1.png?where=super']； android本地sdcard地址['/sdcard/1.png','/sdcard/2.png'];base64字符串由于太长，不再举例。
	 */
	sharePics(params:easyShareImages_sharePics_Params):void

}
interface easyShareImages_sharePics_Params {
	/**分享类型：0/1/2   0本地sdcard文件路径； 1网络url； 2 base64（ps：请严格按照参数传参，否则容易出错）*/ 
	type:any,

	/**分享的文字内容*/ 
	title:string,

	/**分享的图片地址或者base64数组，例如：网络地址['https://www.baidu.com/img/bd_logo1.png?where=super',	'https://www.baidu.com/img/bd_logo1.png?where=super']； android本地sdcard地址['/sdcard/1.png','/sdcard/2.png'];base64字符串由于太长，不再举例。*/ 
	list:Array,

}

interface colorGain {
	/**
	 * `获取颜色`
	 * ========params==========
	 *
	 * `path` :string : 图片路径，支持fs、widget
	 *
	 * `rect` :JSON : （可选项）图片中获取颜色的位置
	 */
	getColor(params:colorGain_getColor_Params, callback?: (ret:JSON) => void):void

}
interface colorGain_getColor_Params {
	/**图片路径，支持fs、widget*/ 
	path:string,

	/**（可选项）图片中获取颜色的位置*/ 
	rect?:JSON,

}

interface fileScan {
	/**     打开文件扫描器*/ 
	openFileScan():void

}
interface videoMerge {
	/**
	 * `合并视频`
	 * ========params==========
	 *
	 * `videos` :Array : 合并的视频的地址组成的数组，要求本地路径（fs://、widget://。android端不支持widget://）
	 *
	 * `export` :JSON : （可选项）输出视频的配置
	 *
	 * `quality` :string : （可选项）录像视频质量（android不支持）
	 */
	merge(params:videoMerge_merge_Params, callback?: (ret:JSON) => void):void

	/** 清除本模块产生的视频文件，本接口仅当 merge -> export -> path 参数不传或传空时有效，**本接口只清除本模块产生的临时数据，若要清除本 app 缓存的所有数据则调用 api.clearCache***/ 
	clearCache():void

}
interface videoMerge_merge_Params {
	/**合并的视频的地址组成的数组，要求本地路径（fs://、widget://。android端不支持widget://）*/ 
	videos:Array,

	/**（可选项）输出视频的配置*/ 
	export?:JSON,

	/**（可选项）录像视频质量（android不支持）*/ 
	quality?:string,

}

interface svideo {
	/** 启动svideo模块,打开摄像头，等待用户录制。*/ 
	start(callback?: (ret:JSON) => void):void

}
interface floatView {
	/** 检测悬浮框权限,使用悬浮框需要先获取权限*/ 
	checkFloadPermission(callback?: (ret:JSON, err:JSON) => void):void

	/** 添加悬浮框*/ 
	addFloadWindow(callback?: (ret:JSON, err:JSON) => void):void

	/** 移除悬浮框*/ 
	removeFloadWindow(callback?: (ret:JSON, err:JSON) => void):void

	/** 打开“显示在其他应用的上层”的设置界面*/ 
	openFloadSetting():void

}
interface bookReader {
	/**
	 * `打开阅读器`
	 * ========params==========
	 *
	 * `x` :number : （可选项）模块视图左上角点的坐标
	 *
	 * `y` :number : （可选项）模块视图左上角点的坐标
	 *
	 * `w` :number : （可选项）模块视图的宽
	 *
	 * `h` :number : （可选项）模块视图的高
	 *
	 * `bg` :string : （可选项）阅读器的背景色，支持 rgb，rgba，img，#
	 *
	 * `animType` :string : 翻页动画效果，可为空。（保留使用）
	 *
	 * `progress` :number : （可选项）阅读器打开时的进度的百分比，取值范围 0-100
	 *
	 * `textStyle` :JSON : （可选项）阅读文本字体样式设置
	 *
	 * `filePath` :string : 阅读器数据源文件地址，支持 widget 等本地路径协议，必传
	 *
	 * `codingType` :string : （可选项）所要阅读的文本的编码格式，取值范围:gbk、utf8
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）是否将模块视图固定到窗口上，不跟随窗口上下滚动
	 */
	open(params:bookReader_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `设置阅读器的参数`
	 * ========params==========
	 *
	 * `bg` :string : （可选项）阅读器的背景色，支持 rgb，rgba，img，#
	 *
	 * `animType` :string : 翻页动画效果，可为空。（保留使用）
	 *
	 * `progress` :number : （可选项）阅读器打开时的进度百分比，取值范围 0-100
	 *
	 * `textStyle` :JSON : （可选项）阅读文本字体样式设置
	 *
	 * `filePath` :string : （可选项）阅读器数据源文件地址，支持 widget 等本地路径协议
	 */
	setValue(params:bookReader_setValue_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 获取屏幕亮度，iOS 平台上获取的是系统屏幕亮度，Android 平台上获取的是本 APP 内的屏幕亮度*/ 
	getBrightness(callback?: (ret:JSON, err:JSON) => void):void

}
interface bookReader_open_Params {
	/**（可选项）模块视图左上角点的坐标*/ 
	x?:number,

	/**（可选项）模块视图左上角点的坐标*/ 
	y?:number,

	/**（可选项）模块视图的宽*/ 
	w?:number,

	/**（可选项）模块视图的高*/ 
	h?:number,

	/**（可选项）阅读器的背景色，支持 rgb，rgba，img，#*/ 
	bg?:string,

	/**翻页动画效果，可为空。（保留使用）*/ 
	animType:string,

	/**（可选项）阅读器打开时的进度的百分比，取值范围 0-100*/ 
	progress?:number,

	/**（可选项）阅读文本字体样式设置*/ 
	textStyle?:JSON,

	/**阅读器数据源文件地址，支持 widget 等本地路径协议，必传*/ 
	filePath:string,

	/**（可选项）所要阅读的文本的编码格式，取值范围:gbk、utf8*/ 
	codingType?:string,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）是否将模块视图固定到窗口上，不跟随窗口上下滚动*/ 
	fixed?:boolean,

}

interface bookReader_setValue_Params {
	/**（可选项）阅读器的背景色，支持 rgb，rgba，img，#*/ 
	bg?:string,

	/**翻页动画效果，可为空。（保留使用）*/ 
	animType:string,

	/**（可选项）阅读器打开时的进度百分比，取值范围 0-100*/ 
	progress?:number,

	/**（可选项）阅读文本字体样式设置*/ 
	textStyle?:JSON,

	/**（可选项）阅读器数据源文件地址，支持 widget 等本地路径协议*/ 
	filePath?:string,

}

interface softInputMgr {
	/** 弹入和弹出键盘*/ 
	toggleKeyboard():void

}
interface screenLock {
}
interface videoScreenshots {
	/**
	 * `视频截图`
	 * ========params==========
	 *
	 * `videoUrl` :string : 视频地址，支持本地(widget://和fs://)和网络视频
	 *
	 * `time` :number : 指定位置(单位为秒)
	 *
	 * `isRotation` :boolean : （可选项）是否顺时针90°旋转
	 *
	 * `isAblum` :boolean : （可选项）是否保存相册
	 *
	 * `name` :string : （可选）图片名
	 *
	 * `thumbnailQuality` :number : 缩略图质量（0-100）
	 */
	screenshots(params:videoScreenshots_screenshots_Params, callback?: (ret:JSON) => void):void

	/** 当 screenshots 接口内 未传 path 值，则模块会将转换后的 图片保存在缓存目录。调用本接口，可清除本模块产生的所有图片。调用 api 对象下的 clearCache 接口会清除缓存目录下所有文件（不仅本模块产生的图片文件）。*/ 
	clearCache():void

}
interface videoScreenshots_screenshots_Params {
	/**视频地址，支持本地(widget://和fs://)和网络视频*/ 
	videoUrl:string,

	/**指定位置(单位为秒)*/ 
	time:number,

	/**（可选项）是否顺时针90°旋转*/ 
	isRotation?:boolean,

	/**（可选项）是否保存相册*/ 
	isAblum?:boolean,

	/**（可选）图片名*/ 
	name?:string,

	/**缩略图质量（0-100）*/ 
	thumbnailQuality:number,

}

interface judgeNotification {
	/** 打开对应设置页面*/ 
	judge():void

}
interface replay {
	/** 开始录屏（ios用户按下home键退出APP再次进入后录屏会停止并保存录屏文件到相册根目录）*/ 
	start():void

	/**
	 * `停止录屏（调用本接口停止录屏视频文件会存入相册中）`
	 * ========params==========
	 *
	 * `folderName` :any : 视频存入相册文件夹名称，创建失败视频将存入相册根路径
	 */
	stopAlbum(params:replay_stopAlbum_Params, callback?: (ret:JSON) => void):void

	/** 停止录屏（ios调用本接口停止录屏视频文件会存入沙盒并返回文件路径）*/ 
	stopShahe():void

	/** 开始录屏（调用iOS ReplayKi SDK，录屏结束后会弹出回放的预览页面，在预览中可以选择保存视频到相册中、放弃、或者分享出去，不能保存在沙盒路径中，当APP推入后台时录屏将暂停，再次进入APP后录屏恢复。注意本接口在iPhone设备上仅支持 iOS9.0 及以上版本。）*/ 
	startReplayKit():void

	/** 停止录屏（调用iOS ReplayKi Sdk，注意本接口在iPhone设备上仅支持 iOS9.0 及以上版本。）*/ 
	stopReplayKit():void

	/** 清除沙盒下路径所有视频资源,android清除录制默认路径下所有视频资源*/ 
	clearPath():void

}
interface replay_stopAlbum_Params {
	/**视频存入相册文件夹名称，创建失败视频将存入相册根路径*/ 
	folderName:any,

}

interface m3u8Downloader {
	/**
	 * `启动下载服务。`
	 * ========params==========
	 *
	 * `root` :string : （可选项）保存文件的根目录，默认为m3u8_downloader，都是在sd卡的根路径之下。
	 */
	startService(params:m3u8Downloader_startService_Params, callback?: (ret:JSON) => void):void

	/**
	 * `查询下载进度。`
	 * ========params==========
	 *
	 * `url` :string : （必填）下载m3u8的url。
	 */
	getProgress(params:m3u8Downloader_getProgress_Params, callback?: (ret:JSON) => void):void

}
interface m3u8Downloader_startService_Params {
	/**（可选项）保存文件的根目录，默认为m3u8_downloader，都是在sd卡的根路径之下。*/ 
	root?:string,

}

interface m3u8Downloader_getProgress_Params {
	/**（必填）下载m3u8的url。*/ 
	url:string,

}

interface audioStreamer {
	/**
	 * `打开音频播放器，并播放。`
	 * ========params==========
	 *
	 * `path` :string : 音频资源地址，支持本地和网络路径（fs://、widget://、http://、https:// 等）
	 */
	openPlayer(params:audioStreamer_openPlayer_Params, callback?: (ret:JSON) => void):void

	/** 暂停播放 ，如果想恢复播放可调用openPlayer继续播放(仅支持安卓这样调用)*/ 
	pause():void

	/** 恢复播放，仅支持iOS*/ 
	resume():void

	/** 停止播放*/ 
	stop():void

	/**
	 * `设置播放位置`
	 * ========params==========
	 *
	 * `time` :number : （可选项）播放位置，取值范围大于 0 不超过当前播放音频的总时长，单位为秒（s）
	 */
	seekToTime(params:audioStreamer_seekToTime_Params):void

	/**
	 * `设置是否循环播放`
	 * ========params==========
	 *
	 * `loop` :boolean : 设置是否循环播放
	 */
	setLoop(params:audioStreamer_setLoop_Params):void

	/** 获取当前播放的位置*/ 
	getCurrentTime():void

	/** 获取已缓冲的音频文件占音频文件的百分比*/ 
	getBufferingRatio():void

	/** 播放状态监听*/ 
	addEventListener():void

	/** 监听实时播放进度*/ 
	addProgressListener():void

	/** 移除实时播放进度*/ 
	removeProgressListener():void

	/**
	 * `设置音量`
	 * ========params==========
	 *
	 * `volume` :number : （可选项）音量大小（0-1）
	 */
	setVolume(params:audioStreamer_setVolume_Params):void

	/** 获取音量*/ 
	getVolume():void

}
interface audioStreamer_openPlayer_Params {
	/**音频资源地址，支持本地和网络路径（fs://、widget://、http://、https:// 等）*/ 
	path:string,

}

interface audioStreamer_seekToTime_Params {
	/**（可选项）播放位置，取值范围大于 0 不超过当前播放音频的总时长，单位为秒（s）*/ 
	time?:number,

}

interface audioStreamer_setLoop_Params {
	/**设置是否循环播放*/ 
	loop:boolean,

}

interface audioStreamer_setVolume_Params {
	/**（可选项）音量大小（0-1）*/ 
	volume?:number,

}

interface hwOBS {
	/**
	 * `初始化OBS客户端`
	 * ========params==========
	 *
	 * `accessKey` :string : Access Key ID，接入键标识，用户在对象存储服务系统中的接入键标识，一个接入键标识唯一对应一个用户，一个用户可以同时拥有多个接入键标识。对象存储服务系统通过接入键标识识别访问系统的用户
	 *
	 * `secretKey` :string : Secret Access Key，安全接入键，用户在对象存储服务系统中的安全接入键，是用户访问对象存储服务系统的密钥，用户根据安全接入键和请求头域生成鉴权信息。安全接入键和接入键标识一一对应。
	 *
	 * `endPoint` :string : 可以从[这里](https://developer.huaweicloud.com/endpoint)查看OBS当前开通的服务地址和区域信息
	 */
	initClient(params:hwOBS_initClient_Params):void

	/**
	 * `创建桶`
	 * ========params==========
	 *
	 * `bucketName` :string : 桶的名字。桶的名字是全局唯一的，所以您需要确保不与已有的桶名称重复
	 *
	 * `storage` :string : （可选项）存储模式。
	 *
	 * `location` :string : （可选项）区域位置。创建桶时，如果使用的终端节点归属于默认区域华北-北京一（cn-north-1），则可以不指定区域；如果使用的终端节点归属于其他区域，则必须指定区域，且指定的区域必须与终端节点归属的区域一致。当前有效的区域名称有：cn-north-1、cn-east-2、cn-south-1、ap-southeast-1
	 */
	createBucket(params:hwOBS_createBucket_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 列举桶*/ 
	listBucket(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `删除桶`
	 * ========params==========
	 *
	 * `bucketName` :string : 桶的名字
	 */
	deleteBucket(params:hwOBS_deleteBucket_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `上传文件`
	 * ========params==========
	 *
	 * `path` :string : 上传的文件的路径，要求本地路径（fs://、widget://）；Android仅支持fs://
	 *
	 * `bucketName` :string : 桶的名字
	 *
	 * `objectKey` :string : 对象描述标识
	 *
	 * `background` :boolean : （可选项）是否开启后台上传，为true时，当应用退出到后台后，上传任务仍然会进行
	 */
	uploadFile(params:hwOBS_uploadFile_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `列举对象`
	 * ========params==========
	 *
	 * `bucketName` :string : 桶的名字
	 *
	 * `prefix` :string : （可选项）列举以指定的字符串prefix开头的对象
	 *
	 * `count` :any : （可选项）指定列举数目
	 */
	listObject(params:hwOBS_listObject_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取云存储对象（该方法仅支持Android）`
	 * ========params==========
	 *
	 * `bucketName` :string : 桶的名字
	 *
	 * `objectKey` :string : 对象KEY
	 *
	 * `savePath` :string : 保存路径（仅支持fs:// 及 Android系统本地路径）
	 */
	getObject(params:hwOBS_getObject_Params, callback?: (ret:JSON) => void):void

	/**
	 * `删除对象`
	 * ========params==========
	 *
	 * `bucketName` :string : 桶的名字
	 *
	 * `objectKey` :string : 对象KEY
	 */
	deleteObject(params:hwOBS_deleteObject_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `设置桶标签`
	 * ========params==========
	 *
	 * `bucketName` :string : 桶的名字
	 *
	 * `tagKey` :string : 标签key
	 *
	 * `tagValue` :string : 标签value
	 */
	setTag(params:hwOBS_setTag_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `查看桶标签`
	 * ========params==========
	 *
	 * `bucketName` :string : 桶的名字
	 */
	getTag(params:hwOBS_getTag_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `删除桶标签`
	 * ========params==========
	 *
	 * `bucketName` :string : 桶的名字
	 */
	deleteTag(params:hwOBS_deleteTag_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface hwOBS_initClient_Params {
	/**Access Key ID，接入键标识，用户在对象存储服务系统中的接入键标识，一个接入键标识唯一对应一个用户，一个用户可以同时拥有多个接入键标识。对象存储服务系统通过接入键标识识别访问系统的用户*/ 
	accessKey:string,

	/**Secret Access Key，安全接入键，用户在对象存储服务系统中的安全接入键，是用户访问对象存储服务系统的密钥，用户根据安全接入键和请求头域生成鉴权信息。安全接入键和接入键标识一一对应。*/ 
	secretKey:string,

	/**可以从[这里](https://developer.huaweicloud.com/endpoint)查看OBS当前开通的服务地址和区域信息*/ 
	endPoint:string,

}

interface hwOBS_createBucket_Params {
	/**桶的名字。桶的名字是全局唯一的，所以您需要确保不与已有的桶名称重复*/ 
	bucketName:string,

	/**（可选项）存储模式。*/ 
	storage?:string,

	/**（可选项）区域位置。创建桶时，如果使用的终端节点归属于默认区域华北-北京一（cn-north-1），则可以不指定区域；如果使用的终端节点归属于其他区域，则必须指定区域，且指定的区域必须与终端节点归属的区域一致。当前有效的区域名称有：cn-north-1、cn-east-2、cn-south-1、ap-southeast-1*/ 
	location?:string,

}

interface hwOBS_deleteBucket_Params {
	/**桶的名字*/ 
	bucketName:string,

}

interface hwOBS_uploadFile_Params {
	/**上传的文件的路径，要求本地路径（fs://、widget://）；Android仅支持fs://*/ 
	path:string,

	/**桶的名字*/ 
	bucketName:string,

	/**对象描述标识*/ 
	objectKey:string,

	/**（可选项）是否开启后台上传，为true时，当应用退出到后台后，上传任务仍然会进行*/ 
	background?:boolean,

}

interface hwOBS_listObject_Params {
	/**桶的名字*/ 
	bucketName:string,

	/**（可选项）列举以指定的字符串prefix开头的对象*/ 
	prefix?:string,

	/**（可选项）指定列举数目*/ 
	count?:any,

}

interface hwOBS_getObject_Params {
	/**桶的名字*/ 
	bucketName:string,

	/**对象KEY*/ 
	objectKey:string,

	/**保存路径（仅支持fs:// 及 Android系统本地路径）*/ 
	savePath:string,

}

interface hwOBS_deleteObject_Params {
	/**桶的名字*/ 
	bucketName:string,

	/**对象KEY*/ 
	objectKey:string,

}

interface hwOBS_setTag_Params {
	/**桶的名字*/ 
	bucketName:string,

	/**标签key*/ 
	tagKey:string,

	/**标签value*/ 
	tagValue:string,

}

interface hwOBS_getTag_Params {
	/**桶的名字*/ 
	bucketName:string,

}

interface hwOBS_deleteTag_Params {
	/**桶的名字*/ 
	bucketName:string,

}

interface openContacts {
	/** 在应用内打开系统通讯录界面选择联系人*/ 
	open(callback?: (ret:JSON, err:JSON) => void):void

}
interface sysPrint {
	/** 跳转系统打印设置页面*/ 
	toSystemPrintPage(callback?: (ret:JSON, err:JSON) => void):void

	/** 打印pdf*/ 
	printPdf(callback?: (ret:JSON, err:JSON) => void):void

	/** 打印图片*/ 
	printImg(callback?: (ret:JSON, err:JSON) => void):void

	/** 判断是否又打印服务*/ 
	hasPrintService(callback?: (ret:JSON, err:JSON) => void):void

}
interface ybxIDCardRead {
	/** 上电*/ 
	powerOn():void

	/** 连接*/ 
	connect():void

	/** 读卡,读卡结果在读卡监听addIDCardListener的回调中返回，此处的回调里只返回状态*/ 
	readID():void

	/** 下电*/ 
	powerOff():void

	/** 断开连接*/ 
	disConnect():void

	/** 开启自动读卡，读卡结果会在读卡监听addIDCardListener的回调中返回*/ 
	startAutoRead():void

	/** 停止自动读卡*/ 
	stopAutoRead():void

	/** 读卡结果监听，读卡信息在该方法的回调中返回*/ 
	addIDCardListener():void

}
interface photoBrowser {
	/**
	 * `打开图片浏览器`
	 * ========params==========
	 *
	 * `images` :Array : 要读取的图片路径组成的数组，图片路径支持 fs://、http:// 协议、base64
	 *
	 * `activeIndex` :number : （可选项）当前要显示的图片在图片路径数组中的索引
	 *
	 * `placeholderImg` :string : （可选项）当加载网络图片时显示的占位图路径，要求本地图片路径（widget://、fs://）
	 *
	 * `bgColor` :string : （可选项）图片浏览器背景色，支持 rgb、rgba、#
	 *
	 * `zoomEnabled` :boolean : （可选项）是否打开缩放手势识别功能（随手势放大缩小图片）
	 *
	 * `mode` :number : （可选项）图片的现实模式；1：为图片原本大小 2：图片宽度等比例放大到宽等于屏幕款;android不支持此参数
	 *
	 * `atime` :number : （可选项）打开动画的执行时间，传0无动画
	 */
	open(params:photoBrowser_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭图片浏览器*/ 
	close():void

	/** 隐藏图片浏览器*/ 
	hide():void

	/** 显示图片浏览器*/ 
	show():void

	/**
	 * `设置当前显示图片`
	 * ========params==========
	 *
	 * `index` :number : （可选项）当前要显示的图片在图片路径数组中的索引
	 */
	setIndex(params:photoBrowser_setIndex_Params):void

	/** 获取当前图片在图片路径数组内的索引*/ 
	getIndex():void

	/**
	 * `获取指定图片在本地的绝对路径`
	 * ========params==========
	 *
	 * `index` :number : 指定图片在图片数组中的索引
	 */
	getImage(params:photoBrowser_getImage_Params, callback?: (ret:JSON) => void):void

	/**
	 * `设置指定位置的图片，**若设置的是网络图片加载成功或失败会给 open 接口回调该加载事件**`
	 * ========params==========
	 *
	 * `index` :number : （可选项）指定图片在图片数组中的索引
	 *
	 * `image` :string : 要设置的图片路径，支持本地和网络路径（fs://、http://）
	 */
	setImage(params:photoBrowser_setImage_Params):void

	/**
	 * `往已打开的图片浏览器里添加图片（拼接在最后）`
	 * ========params==========
	 *
	 * `images` :Array : 要拼接的图片路径组成的数组，图片路径支持 fs://、http:// 协议
	 */
	appendImage(params:photoBrowser_appendImage_Params):void

	/**
	 * `删除指定位置的图片`
	 * ========params==========
	 *
	 * `index` :number : （可选项）删除的指定图片在图片数组中的索引
	 */
	deleteImage(params:photoBrowser_deleteImage_Params):void

	/** 清除缓存到本地的网络图片，**本接口只清除本模块缓存的数据，若要清除本 app 缓存的所有数据则调用 api.clearCache***/ 
	clearCache():void

}
interface photoBrowser_open_Params {
	/**要读取的图片路径组成的数组，图片路径支持 fs://、http:// 协议、base64*/ 
	images:Array,

	/**（可选项）当前要显示的图片在图片路径数组中的索引*/ 
	activeIndex?:number,

	/**（可选项）当加载网络图片时显示的占位图路径，要求本地图片路径（widget://、fs://）*/ 
	placeholderImg?:string,

	/**（可选项）图片浏览器背景色，支持 rgb、rgba、#*/ 
	bgColor?:string,

	/**（可选项）是否打开缩放手势识别功能（随手势放大缩小图片）*/ 
	zoomEnabled?:boolean,

	/**（可选项）图片的现实模式；1：为图片原本大小 2：图片宽度等比例放大到宽等于屏幕款;android不支持此参数*/ 
	mode?:number,

	/**（可选项）打开动画的执行时间，传0无动画*/ 
	atime?:number,

}

interface photoBrowser_setIndex_Params {
	/**（可选项）当前要显示的图片在图片路径数组中的索引*/ 
	index?:number,

}

interface photoBrowser_getImage_Params {
	/**指定图片在图片数组中的索引*/ 
	index:number,

}

interface photoBrowser_setImage_Params {
	/**（可选项）指定图片在图片数组中的索引*/ 
	index?:number,

	/**要设置的图片路径，支持本地和网络路径（fs://、http://）*/ 
	image:string,

}

interface photoBrowser_appendImage_Params {
	/**要拼接的图片路径组成的数组，图片路径支持 fs://、http:// 协议*/ 
	images:Array,

}

interface photoBrowser_deleteImage_Params {
	/**（可选项）删除的指定图片在图片数组中的索引*/ 
	index?:number,

}

interface mySqlUtils {
	/** 连接数据库*/ 
	connect(callback?: (ret:JSON, err:JSON) => void):void

	/** 判断数据库是否连接，**本接口仅支持 iOS 端。***/ 
	isConnected(callback?: (ret:JSON) => void):void

	/** 在 iOS 端执行一段 SQL 语句（select除外），**仅支持 iOS 平台***/ 
	executeSQLString(callback?: (ret:JSON, err:JSON) => void):void

	/** 增加删除操作*/ 
	addOrDel(callback?: (ret:JSON, err:JSON) => void):void

	/** 修改数据库数据*/ 
	update(callback?: (ret:JSON, err:JSON) => void):void

}
interface MCBluetooth {
	/**
	 * `开始广播`
	 * ========params==========
	 *
	 * `serviceType` :string : 服务的类型标示符，是由ASCII字母组成的短文本串，最多15个字符。
	 */
	startAdvertising(params:MCBluetooth_startAdvertising_Params, callback?: (ret:JSON) => void):void

	/** 停止广播*/ 
	stopAdvertising():void

	/** 断开链接*/ 
	disconnect():void

	/** 获取当前连接的设备列表*/ 
	getCurrentPeers():void

	/**
	 * `发送字符串`
	 * ========params==========
	 *
	 * `data` :string : 发送的字符串
	 *
	 * `toPeers` :Array : （可选项）要发送给的设备在连接列表里的索引组成的数组
	 */
	sendString(params:MCBluetooth_sendString_Params, callback?: (ret:JSON) => void):void

	/**
	 * `发送文件`
	 * ========params==========
	 *
	 * `path` :string : 发送的文件路径
	 *
	 * `resourceName` :string : 资源名称
	 *
	 * `toPeerIndex` :number : （可选项）要发送给的设备在连接列表里的索引
	 */
	sendFile(params:MCBluetooth_sendFile_Params, callback?: (ret:JSON) => void):void

	/**
	 * `开始扫描附近的设备`
	 * ========params==========
	 *
	 * `serviceType` :string : 服务的类型标示符，是由ASCII字母组成的短文本串，最多15个字符。
	 */
	startBrowsing(params:MCBluetooth_startBrowsing_Params, callback?: (ret:JSON) => void):void

	/**
	 * `邀请附近的设备发起连接`
	 * ========params==========
	 *
	 * `index` :number : （可选项）所邀请的设备在已扫描新设备列表的下标，从0开始
	 *
	 * `timeout` :number : （可选项）超时时间
	 */
	invitePeer(params:MCBluetooth_invitePeer_Params, callback?: (ret:JSON) => void):void

	/** 停止扫描*/ 
	stopBrowsing():void

}
interface MCBluetooth_startAdvertising_Params {
	/**服务的类型标示符，是由ASCII字母组成的短文本串，最多15个字符。*/ 
	serviceType:string,

}

interface MCBluetooth_sendString_Params {
	/**发送的字符串*/ 
	data:string,

	/**（可选项）要发送给的设备在连接列表里的索引组成的数组*/ 
	toPeers?:Array,

}

interface MCBluetooth_sendFile_Params {
	/**发送的文件路径*/ 
	path:string,

	/**资源名称*/ 
	resourceName:string,

	/**（可选项）要发送给的设备在连接列表里的索引*/ 
	toPeerIndex?:number,

}

interface MCBluetooth_startBrowsing_Params {
	/**服务的类型标示符，是由ASCII字母组成的短文本串，最多15个字符。*/ 
	serviceType:string,

}

interface MCBluetooth_invitePeer_Params {
	/**（可选项）所邀请的设备在已扫描新设备列表的下标，从0开始*/ 
	index?:number,

	/**（可选项）超时时间*/ 
	timeout?:number,

}

interface batteryManager {
	/** 获取当前电池的充电状态*/ 
	getBatteryStatus():void

	/** 电池健康信息*/ 
	getBatteryHealthInfo():void

	/** 是否取出电池（注意：有些手机即使取出电池，只需要连接USB也可以工作，iOS 可以忽略该方法）*/ 
	isBatteryPresent():void

	/** 获取当前电池剩余电量*/ 
	getBatteryLevel():void

	/** 获取当前电池剩余电量*/ 
	getBatteryScale():void

	/** 获取当前电池的充电插线类型*/ 
	getBatteryPluggedType():void

	/** 获取当前电池的电压*/ 
	getBatteryVoltage():void

	/** 获取当前电池的电压*/ 
	getBatteryTemperature():void

	/** 电池技术*/ 
	getBatteryTechnology():void

}
interface mtlPrint {
	/**  打印PDF文档*/ 
	printPDF():void

	/**  打印图片*/ 
	printImage():void

}
interface UIFoxitPDF {
	/**
	 * `初始化配置sdk`
	 * ========params==========
	 *
	 * `sn` :string : 福昕官方（https://developers.foxitsoftware.cn/pdf-sdk/）提供的sn
	 *
	 * `key` :string : 福昕官方提供的key
	 */
	config(params:UIFoxitPDF_config_Params, callback?: (ret:JSON) => void):void

	/**
	 * `打开pdf文档预览界面`
	 * ========params==========
	 *
	 * `path` :string : 文档的路径，支持 widget://、fs://、本地路径
	 */
	openPDF(params:UIFoxitPDF_openPDF_Params):void

}
interface UIFoxitPDF_config_Params {
	/**福昕官方（https://developers.foxitsoftware.cn/pdf-sdk/）提供的sn*/ 
	sn:string,

	/**福昕官方提供的key*/ 
	key:string,

}

interface UIFoxitPDF_openPDF_Params {
	/**文档的路径，支持 widget://、fs://、本地路径*/ 
	path:string,

}

interface myWebSocket {
	/**
	 * `打开连接<br>`
	 * ========params==========
	 *
	 * `url` :string : 服务端地址
	 *
	 * `pingInterval` :any : （可选项）心跳间隔，单位秒，设置大于0时起效果
	 *
	 * `pingData` :string : （可选项）心跳数据，配合pingInterval 使用
	 *
	 * `msg` :string : 发送内容
	 */
	open(params:myWebSocket_open_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface myWebSocket_open_Params {
	/**服务端地址*/ 
	url:string,

	/**（可选项）心跳间隔，单位秒，设置大于0时起效果*/ 
	pingInterval?:any,

	/**（可选项）心跳数据，配合pingInterval 使用*/ 
	pingData?:string,

	/**发送内容*/ 
	msg:string,

}

interface imageEdit {
	/**
	 * `添加图片`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）图片的位置及尺寸
	 *
	 * `bgColor` :string : 模块的背景颜色，支持rgb、rgba
	 *
	 * `path` :string : 要编辑的图片的路径，要求本地路径（fs://、widget://）
	 *
	 * `contentMode` :string : （可选项）图片填充模式
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	open(params:imageEdit_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `设置画笔，用户点击某个形状（矩形框、圆形框、文本和箭头，不包括线条）时，模块会自动动态调整这个形状的边框颜色、边框粗细(如果是文字，就是文字颜色和文字字体大小)为当前画笔的样式。`
	 * ========params==========
	 *
	 * `color` :string : (可选项)画笔颜色，支持rgb、rgba、#
	 *
	 * `width` :number : (可选项)画笔粗细
	 *
	 * `type` :string : (可选项)画笔类型
	 *
	 * `size` :number : (可选项)文字的大小，仅当 type 为 text 的时候有效
	 */
	setBrush(params:imageEdit_setBrush_Params):void

	/**
	 * `添加监听事件`
	 * ========params==========
	 *
	 * `name` :string : 监听的事件名字
	 */
	addEventListener(params:imageEdit_addEventListener_Params, callback?: (ret:JSON) => void):void

	/**
	 * `保存编辑后的图片`
	 * ========params==========
	 *
	 * `path` :string : （可选项）保存图片路径，要求本地路径（fs://），注意图片后缀名输入完整。若不传或传空，则模块默认将图片保存到临时数据文件夹下
	 *
	 * `copyToAlbum` :boolean : （可选项）是否将结果同时保存到系统相册
	 */
	save(params:imageEdit_save_Params, callback?: (ret:JSON) => void):void

	/** 清除本模块产生的图片文件，本接口仅当 save -> path 参数不传或传空时有效，**本接口只清除本模块产生的临时数据，若要清除本 app 缓存的所有数据则调用 api.clearCache***/ 
	clearCache():void

	/**
	 * `重新设置模块位置、尺寸`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 */
	resetRect(params:imageEdit_resetRect_Params):void

}
interface imageEdit_open_Params {
	/**（可选项）图片的位置及尺寸*/ 
	rect?:JSON,

	/**模块的背景颜色，支持rgb、rgba*/ 
	bgColor:string,

	/**要编辑的图片的路径，要求本地路径（fs://、widget://）*/ 
	path:string,

	/**（可选项）图片填充模式*/ 
	contentMode?:string,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface imageEdit_setBrush_Params {
	/**(可选项)画笔颜色，支持rgb、rgba、#*/ 
	color?:string,

	/**(可选项)画笔粗细*/ 
	width?:number,

	/**(可选项)画笔类型*/ 
	type?:string,

	/**(可选项)文字的大小，仅当 type 为 text 的时候有效*/ 
	size?:number,

}

interface imageEdit_addEventListener_Params {
	/**监听的事件名字*/ 
	name:string,

}

interface imageEdit_save_Params {
	/**（可选项）保存图片路径，要求本地路径（fs://），注意图片后缀名输入完整。若不传或传空，则模块默认将图片保存到临时数据文件夹下*/ 
	path?:string,

	/**（可选项）是否将结果同时保存到系统相册*/ 
	copyToAlbum?:boolean,

}

interface imageEdit_resetRect_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

}

interface screenClip {
	/**
	 * `打开截图功能`
	 * ========params==========
	 *
	 * `bg` :string : （可选项）背景颜色设置，支持#，rgb，rgba
	 *
	 * `cutFrame` :JSON : （可选项）截取框配置
	 *
	 * `save` :JSON : 所生成的图片保存位置
	 */
	open(params:screenClip_open_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface screenClip_open_Params {
	/**（可选项）背景颜色设置，支持#，rgb，rgba*/ 
	bg?:string,

	/**（可选项）截取框配置*/ 
	cutFrame?:JSON,

	/**所生成的图片保存位置*/ 
	save:JSON,

}

interface sortList {
	/**
	 * `打开索引列表`
	 * ========params==========
	 *
	 * `rect` :JSON : 索引器的frame
	 *
	 * `height` :number : 每个字母显示的高度（仅iOS支持）
	 *
	 * `bgColor` :string : 索引器背景颜色
	 *
	 * `dataArray` :Array : 数据源,名单列表
	 *
	 * `style` :JSON : null
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）（仅android支持）
	 *
	 * `fixed` :boolean : （可选项）是否将模块视图固定到窗口上，不跟随窗口上下滚动（仅android支持）
	 */
	open(params:sortList_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭索引列表*/ 
	close():void

	/** 隐藏索引列表*/ 
	hide():void

	/** 显示索引列表*/ 
	show():void

	/**
	 * `更新索引列表`
	 * ========params==========
	 *
	 * `dataArray` :Array : 数据源,名单列表
	 */
	upLoad(params:sortList_upLoad_Params, callback?: (ret:JSON) => void):void

	/**
	 * `添加数据`
	 * ========params==========
	 *
	 * `dataArray` :Array : 数据源,名单列表
	 */
	addSource(params:sortList_addSource_Params, callback?: (ret:JSON) => void):void

	/**
	 * `删除数据（仅iOS支持）`
	 * ========params==========
	 *
	 * `dataArray` :Array : 数据源,名单列表
	 */
	reduceSource(params:sortList_reduceSource_Params, callback?: (ret:JSON) => void):void

}
interface sortList_open_Params {
	/**索引器的frame*/ 
	rect:JSON,

	/**每个字母显示的高度（仅iOS支持）*/ 
	height:number,

	/**索引器背景颜色*/ 
	bgColor:string,

	/**数据源,名单列表*/ 
	dataArray:Array,

	/**null*/ 
	style:JSON,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）（仅android支持）*/ 
	fixedOn?:string,

	/**（可选项）是否将模块视图固定到窗口上，不跟随窗口上下滚动（仅android支持）*/ 
	fixed?:boolean,

}

interface sortList_upLoad_Params {
	/**数据源,名单列表*/ 
	dataArray:Array,

}

interface sortList_addSource_Params {
	/**数据源,名单列表*/ 
	dataArray:Array,

}

interface sortList_reduceSource_Params {
	/**数据源,名单列表*/ 
	dataArray:Array,

}

interface iNoRobot {
}
interface sapSso {
	/** 获取token*/ 
	getToken():void

	/** 跳转到 sap 平台的 APP，仅支持 iOS 端。*/ 
	openSap():void

}
interface imageOptim {
	/**
	 * `压缩图片`
	 * ========params==========
	 *
	 * `imgPath` :string : （必填）原图片的路径,支持绝对路径和UZ路径
	 *
	 * `quality` :any : （必填）图片质量
	 *
	 * `width` :any : 设置图片的宽度,如果仅设宽度，模块将固定宽度,将高度自动进行等比例设置
	 *
	 * `height` :any : 设置图片的高度,如果仅设高度，模块将固定搞定将宽度自动进行等比例设置
	 *
	 * `destinationPath` :string : (选填)输出路径，支持绝对路径和UZ路径
	 */
	compress(params:imageOptim_compress_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface imageOptim_compress_Params {
	/**（必填）原图片的路径,支持绝对路径和UZ路径*/ 
	imgPath:string,

	/**（必填）图片质量*/ 
	quality:any,

	/**设置图片的宽度,如果仅设宽度，模块将固定宽度,将高度自动进行等比例设置*/ 
	width:any,

	/**设置图片的高度,如果仅设高度，模块将固定搞定将宽度自动进行等比例设置*/ 
	height:any,

	/**(选填)输出路径，支持绝对路径和UZ路径*/ 
	destinationPath:string,

}

interface yingmeiPrinter {
	/** 搜索可用的映美打印设备，需要手机开启蓝牙和位置；使用局域网wifi,需要先扫描打印机上的二维码，配置网络。*/ 
	searchDevices(callback?: (ret:JSON) => void):void

	/** 是否支持蓝牙BLE*/ 
	isSupportedBLE():void

	/** 蓝牙是否开启*/ 
	isBluetoothOpen():void

	/**
	 * `是否开启调试日志，仅支持 Android 端`
	 * ========params==========
	 *
	 * `debug` :boolean : 是否开启调试日志，日志输出tag为 print，开启后自动会将日志写入文件，默认的日志文件存储路径为根目录下的ttt.log
	 */
	setDebug(params:yingmeiPrinter_setDebug_Params):void

	/** 获取已连接的设备信息。在 android 端 sdk未提供建立链接的接口，打印时可以先调用此方法判断是否已经建立链接，已经建立链接的话可以直接打印。iOS 端 可以调用连接接口进行链接操作。*/ 
	getConnectedDevice():void

	/** 判断是否有访问蓝牙的权限*/ 
	getBleAuthorization(callback?: (ret:JSON) => void):void

	/** iOS 端获取蓝牙状态*/ 
	getBleState():void

	/**
	 * `iOS 端连接打印机`
	 * ========params==========
	 *
	 * `host` :string : （可选项）连接的 Wi-Fi 打印机的 IP 地址
	 *
	 * `name` :string : （可选项）连接的蓝牙打印机的 name
	 */
	connect(params:yingmeiPrinter_connect_Params, callback?: (ret:JSON) => void):void

	/** 打印图片, 注意图片仅支持png和jpg格式的，大小有限制，不能超过600K*/ 
	printPicture(callback?: (ret:JSON) => void):void

	/** 打印html，和映美技术人员确认，CFP-820BW只支持wifi链接打印；支持标准规范的html标签，样式只能支持到IE11内核，可以打印表格数据以及标准规范排版页面，html页面的body宽度不大于打印机的纸张宽度值，Body宽度的像素最大值等于纸张宽度*打印机dpi/25.4打印机的dpi值。CFP-820BW的dpi值为180。*/ 
	printHTML(callback?: (ret:JSON) => void):void

	/** 打开系统的文件选择器，选择一个文件打印，只支持图片、html文件；pdf需要转成图片后才能打印。打印图片大小不能超过600K,图片格式为jpg、png*/ 
	printFile(callback?: (ret:JSON) => void):void

	/** 停止搜索*/ 
	stopSearch():void

	/** 关闭链接，调用该方法会关闭与打印机的通信，未发送完的数据会丢失，应当在不需要连接的时候使用。*/ 
	closeConnect():void

	/** 释放资源，调用该方法会关闭与打印机的通信，日志写入也会停止。可以在APP退出或页面关闭时调用。仅支持 Android 端。*/ 
	release():void

}
interface yingmeiPrinter_setDebug_Params {
	/**是否开启调试日志，日志输出tag为 print，开启后自动会将日志写入文件，默认的日志文件存储路径为根目录下的ttt.log*/ 
	debug:boolean,

}

interface yingmeiPrinter_connect_Params {
	/**（可选项）连接的 Wi-Fi 打印机的 IP 地址*/ 
	host?:string,

	/**（可选项）连接的蓝牙打印机的 name*/ 
	name?:string,

}

interface audioCombine {
	/**
	 * `音频合并`
	 * ========params==========
	 *
	 * `wayPath` :string : （可选项）音频路径1;支持本地和网络路径（fs://、widget://、http://、https:// 等）
	 *
	 * `easyPath` :string : （可选项）音频路径2;支持本地和网络路径（fs://、widget://、http://、https:// 等）
	 */
	audioMerge(params:audioCombine_audioMerge_Params, callback?: (ret:JSON) => void):void

	/**
	 * `音频剪切`
	 * ========params==========
	 *
	 * `inputPath` :string : （可选项）需要剪切的音频路径;支持widget://,fs://
	 *
	 * `startTime` :number : （可选项）裁剪起点时间
	 *
	 * `endTime` :number : （可选项）裁剪终点时间
	 */
	audioClip(params:audioCombine_audioClip_Params, callback?: (ret:JSON) => void):void

}
interface audioCombine_audioMerge_Params {
	/**（可选项）音频路径1;支持本地和网络路径（fs://、widget://、http://、https:// 等）*/ 
	wayPath?:string,

	/**（可选项）音频路径2;支持本地和网络路径（fs://、widget://、http://、https:// 等）*/ 
	easyPath?:string,

}

interface audioCombine_audioClip_Params {
	/**（可选项）需要剪切的音频路径;支持widget://,fs://*/ 
	inputPath?:string,

	/**（可选项）裁剪起点时间*/ 
	startTime?:number,

	/**（可选项）裁剪终点时间*/ 
	endTime?:number,

}

interface touchDebugger {
}
interface Apple {
	/**
	 * `用苹果账号登录`
	 * ========params==========
	 *
	 * `requestedScopes` :Array : 范围，仅在第一次登录有效
	 */
	login(params:Apple_login_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取授权状态`
	 * ========params==========
	 *
	 * `user` :string : 用户ID
	 */
	getAuthticationState(params:Apple_getAuthticationState_Params, callback?: (ret:JSON) => void):void

	/** 监听用户从设置内删除该App的授权事件，注意：删除后无法再次授权该App*/ 
	observeAppleSignInState():void

}
interface Apple_login_Params {
	/**范围，仅在第一次登录有效*/ 
	requestedScopes:Array,

}

interface Apple_getAuthticationState_Params {
	/**用户ID*/ 
	user:string,

}

interface zipModule {
	/**
	 * `压缩单个文件`
	 * ========params==========
	 *
	 * `zipPath` :string : 压缩后的文件存放路径，支持fs、widget (Android 不支持widget)
	 *
	 * `samplePath` :string : 压缩文件路径
	 *
	 * `password` :string : （可选项）压缩文件密码，不传则压缩文件没有密码
	 *
	 * `ret` :JSON : null
	 */
	createZip(params:zipModule_createZip_Params):void

	/**
	 * `压缩多个个文件`
	 * ========params==========
	 *
	 * `zipPath` :string : 压缩后的文件存放路径，支持fs、widget (Android 不支持widget)
	 *
	 * `samplePaths` :Array : 压缩文件路径数组
	 *
	 * `password` :string : （可选项）压缩文件密码，不传则压缩文件没有密码
	 *
	 * `ret` :JSON : null
	 */
	createMultipleZip(params:zipModule_createMultipleZip_Params):void

	/**
	 * `解压文件`
	 * ========params==========
	 *
	 * `zipPath` :string : 压缩文件路径，支持fs、widget
	 *
	 * `unzipPath` :string : 解压压缩文件后的路径，支持fs、widget
	 *
	 * `password` :string : （可选项）压缩文件密码，压缩文件没有密码可不传
	 *
	 * `ret` :JSON : null
	 */
	unzip(params:zipModule_unzip_Params):void

	/**
	 * `验证压缩文件是否有密码`
	 * ========params==========
	 *
	 * `zipPath` :string : 压缩文件路径，支持fs、widget
	 *
	 * `ret` :JSON : null
	 */
	hasPassword(params:zipModule_hasPassword_Params):void

	/**
	 * `验证压缩文件密码是否正确 （Android不支持该方法）`
	 * ========params==========
	 *
	 * `zipPath` :string : 压缩文件路径，支持fs、widget
	 *
	 * `password` :string : 压缩文件密码
	 *
	 * `ret` :JSON : null
	 */
	isPasswordValidForArchiveAtPath(params:zipModule_isPasswordValidForArchiveAtPath_Params):void

	/**
	 * `获取解压文件大小 （Android不支持该方法）`
	 * ========params==========
	 *
	 * `zipPath` :string : 压缩文件路径，支持fs、widget
	 *
	 * `ret` :JSON : null
	 */
	payloadSizeForArchiveAtPath(params:zipModule_payloadSizeForArchiveAtPath_Params):void

}
interface zipModule_createZip_Params {
	/**压缩后的文件存放路径，支持fs、widget (Android 不支持widget)*/ 
	zipPath:string,

	/**压缩文件路径*/ 
	samplePath:string,

	/**（可选项）压缩文件密码，不传则压缩文件没有密码*/ 
	password?:string,

	/**null*/ 
	ret:JSON,

}

interface zipModule_createMultipleZip_Params {
	/**压缩后的文件存放路径，支持fs、widget (Android 不支持widget)*/ 
	zipPath:string,

	/**压缩文件路径数组*/ 
	samplePaths:Array,

	/**（可选项）压缩文件密码，不传则压缩文件没有密码*/ 
	password?:string,

	/**null*/ 
	ret:JSON,

}

interface zipModule_unzip_Params {
	/**压缩文件路径，支持fs、widget*/ 
	zipPath:string,

	/**解压压缩文件后的路径，支持fs、widget*/ 
	unzipPath:string,

	/**（可选项）压缩文件密码，压缩文件没有密码可不传*/ 
	password?:string,

	/**null*/ 
	ret:JSON,

}

interface zipModule_hasPassword_Params {
	/**压缩文件路径，支持fs、widget*/ 
	zipPath:string,

	/**null*/ 
	ret:JSON,

}

interface zipModule_isPasswordValidForArchiveAtPath_Params {
	/**压缩文件路径，支持fs、widget*/ 
	zipPath:string,

	/**压缩文件密码*/ 
	password:string,

	/**null*/ 
	ret:JSON,

}

interface zipModule_payloadSizeForArchiveAtPath_Params {
	/**压缩文件路径，支持fs、widget*/ 
	zipPath:string,

	/**null*/ 
	ret:JSON,

}

interface baseService {
}
interface photoSelect {
}
interface pdfViewer {
	/** 打开pdf文档视图*/ 
	openView():void

	/** 打开pdf文档缩略图*/ 
	preView():void

	/** 打开pdf文档目录结构视图（如果pdf文档没有做目录，则会返回来失败）*/ 
	category():void

	/** 清除缓存到本地的文件，本接口只清除本模块缓存的数据，若要清除本app缓存的所有数据这调用api.clearCache*/ 
	clearCache():void

	/** 显示文档视图*/ 
	showView():void

	/** 隐藏文档视图*/ 
	hideView():void

	/** 关闭文档视图*/ 
	closeView():void

}
interface imageColorParser {
	/**
	 * `异步解析.后台解析,性能最高.`
	 * ========params==========
	 *
	 * `img` :string : 图片路径.支持 widget:// , fs:// 等本地路径.支持png、jpg等图片.
	 *
	 * `size` :JSON : 图片尺寸.不需要与图片真实尺寸一致.用于控制图片缩放级别.越小,则解析性能越高;越大,则解析的颜色值更准确.
	 */
	parse(params:imageColorParser_parse_Params, callback?: (ret:JSON) => void):void

	/**
	 * `同步解析. 频繁调用或图片过大时,可能会引起 App 卡顿.`
	 * ========params==========
	 *
	 * `img` :string : 图片路径.支持 widget:// , fs:// 等本地路径.支持png、jpg等图片.
	 *
	 * `size` :JSON : 图片尺寸.不需要与图片真实尺寸一致.用于控制图片缩放级别.越小,则解析性能越高;越大,则解析的颜色值更准确.
	 */
	parseSync(params:imageColorParser_parseSync_Params):JSON;

}
interface imageColorParser_parse_Params {
	/**图片路径.支持 widget:// , fs:// 等本地路径.支持png、jpg等图片.*/ 
	img:string,

	/**图片尺寸.不需要与图片真实尺寸一致.用于控制图片缩放级别.越小,则解析性能越高;越大,则解析的颜色值更准确.*/ 
	size:JSON,

}

interface imageColorParser_parseSync_Params {
	/**图片路径.支持 widget:// , fs:// 等本地路径.支持png、jpg等图片.*/ 
	img:string,

	/**图片尺寸.不需要与图片真实尺寸一致.用于控制图片缩放级别.越小,则解析性能越高;越大,则解析的颜色值更准确.*/ 
	size:JSON,

}

interface soundDetection {
	/** 结束分贝检测*/ 
	stop():void

	/** 设置返回间隔*/ 
	setInterval(callback?: (ret:JSON, err:JSON) => void):void

}
interface moduleGaoDeNavi {
}
interface uimusic {
	/**
	 * `播放本地视频、网络音乐`
	 * ========params==========
	 *
	 * `musics` :Array : （必填项）模块的位置及尺寸
	 *
	 * `ttf` :string : （可选项）字体文件(仅支持widget://路径)。
	 *
	 * `downmusicBtn` :boolean : （可选项）是否显示下载按钮。
	 *
	 * `fenxiangBtn` :boolean : （可选项）是否显示分享按钮。
	 *
	 * `pinglunBtn` :boolean : （可选项）是否显示评论按钮。
	 *
	 * `nameTextSize` :any : （可选项）歌曲名称字体大小。
	 *
	 * `singerTextSize` :any : （可选项）歌曲演唱者字体大小。
	 *
	 * `isShowUi` :boolean : （可选项）是否默认打开UI界面。
	 */
	playMusic(params:uimusic_playMusic_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 显示播放界面*/ 
	showUI(callback?: (ret:JSON, err:JSON) => void):void

	/** 隐藏播放界面*/ 
	closeUI(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `音乐界面按钮监听`
	 * ========params==========
	 *
	 * `name` :string : （必填项）监听事件类型>>隐藏播放器界面:closeui 评论按钮:pinglun 分享按钮:fenxiang 下载按钮:downmusic
	 */
	addEventListener(params:uimusic_addEventListener_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 添加播放音乐*/ 
	addMusic():void

	/**
	 * `通过数组序号播放音乐`
	 * ========params==========
	 *
	 * `index` :number : （必填项）待播放音乐信息的序号(备注：other传值时为非必填项)
	 *
	 * `other` :any : （必填项）自定义属性值，可以是自己的主键id(备注：index传值时为非必填项)
	 */
	selectMusic(params:uimusic_selectMusic_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 获取当前正在播放的音乐*/ 
	getCurrentPlayer(callback?: (ret:JSON, err:JSON) => void):void

	/** 停止正在播放的音乐，重新播放需要重新初始化播放器,执行退出应用前请执行该接口*/ 
	stopMusic(callback?: (ret:JSON, err:JSON) => void):void

	/** 暂停或者继续播放音乐*/ 
	musicPlayPause(callback?: (ret:JSON, err:JSON) => void):void

	/** 切换上一曲播放*/ 
	musicPrevious(callback?: (ret:JSON, err:JSON) => void):void

	/** 切换下一曲播放*/ 
	musicNext(callback?: (ret:JSON, err:JSON) => void):void

}
interface uimusic_playMusic_Params {
	/**（必填项）模块的位置及尺寸*/ 
	musics:Array,

	/**（可选项）字体文件(仅支持widget://路径)。*/ 
	ttf?:string,

	/**（可选项）是否显示下载按钮。*/ 
	downmusicBtn?:boolean,

	/**（可选项）是否显示分享按钮。*/ 
	fenxiangBtn?:boolean,

	/**（可选项）是否显示评论按钮。*/ 
	pinglunBtn?:boolean,

	/**（可选项）歌曲名称字体大小。*/ 
	nameTextSize?:any,

	/**（可选项）歌曲演唱者字体大小。*/ 
	singerTextSize?:any,

	/**（可选项）是否默认打开UI界面。*/ 
	isShowUi?:boolean,

}

interface uimusic_addEventListener_Params {
	/**（必填项）监听事件类型>>隐藏播放器界面:closeui 评论按钮:pinglun 分享按钮:fenxiang 下载按钮:downmusic*/ 
	name:string,

}

interface uimusic_selectMusic_Params {
	/**（必填项）待播放音乐信息的序号(备注：other传值时为非必填项)*/ 
	index:number,

	/**（必填项）自定义属性值，可以是自己的主键id(备注：index传值时为非必填项)*/ 
	other:any,

}

interface audioPlayer {
	/**
	 * `初始化音频播放器，并播放。若是网络音频资源则同时开始缓冲音频文件到本地`
	 * ========params==========
	 *
	 * `path` :string : 音频资源地址，支持本地和网络路径（fs://、widget://、http://、ipod-library:// 等）
	 *
	 * `cache` :boolean : 是否支持缓存网络资源
	 */
	initPlayer(params:audioPlayer_initPlayer_Params, callback?: (ret:JSON) => void):void

	/** 播放音频，只有当前播放器为暂停、播放完成状态时有效*/ 
	play():void

	/** 暂停播放*/ 
	pause():void

	/** 停止播放*/ 
	stop():void

	/**
	 * `设置音量`
	 * ========params==========
	 *
	 * `volume` :number : （可选项）音量大小（0-1）
	 *
	 * `system` :boolean : （可选项）是否设置系统音量，若为false表示设置播放器音量，仅支持iOS端
	 */
	setVolume(params:audioPlayer_setVolume_Params):void

	/**
	 * `获取音量`
	 * ========params==========
	 *
	 * `system` :boolean : （可选项）是否获取系统音量，若为false表示获取播放器音量，仅支持iOS端
	 */
	getVolume(params:audioPlayer_getVolume_Params, callback?: (ret:JSON) => void):void

	/**
	 * `设置播放位置`
	 * ========params==========
	 *
	 * `current` :number : （可选项）播放位置，取值范围大于 0 不超过当前播放音频的总时长，单位为秒（s）
	 */
	setCurrent(params:audioPlayer_setCurrent_Params):void

	/** 获取当前播放的位置*/ 
	getCurrent():void

	/** 获取当前播放器的状态*/ 
	getState():void

	/** 获取已缓冲的音频文件占音频文件的百分比*/ 
	getBufferRatio():void

	/**
	 * `监听事件`
	 * ========params==========
	 *
	 * `name` :string : （可选项）监听的事件类型
	 */
	addEventListener(params:audioPlayer_addEventListener_Params, callback?: (ret:JSON) => void):void

	/**
	 * `移除指定事件的监听`
	 * ========params==========
	 *
	 * `name` :string : （可选项）要移除的监听事件类型
	 */
	removeEventListener(params:audioPlayer_removeEventListener_Params):void

	/** 清除缓存到本地的音频文件，**本接口只清除本模块缓存的数据，若要清除本 app 缓存的所有数据则调用api.clearCache***/ 
	clearCache():void

	/** 扫描本地音频资源，在 iOS 上仅扫描系统音乐库资源*/ 
	scanAudioLibrary():void

	/**
	 * `获取本地音频文件属性（文件大小和音频时长）`
	 * ========params==========
	 *
	 * `path` :string : 音频的路径 （仅支持 fs://）
	 */
	getAttr(params:audioPlayer_getAttr_Params, callback?: (ret:JSON) => void):void

}
interface audioPlayer_initPlayer_Params {
	/**音频资源地址，支持本地和网络路径（fs://、widget://、http://、ipod-library:// 等）*/ 
	path:string,

	/**是否支持缓存网络资源*/ 
	cache:boolean,

}

interface audioPlayer_setVolume_Params {
	/**（可选项）音量大小（0-1）*/ 
	volume?:number,

	/**（可选项）是否设置系统音量，若为false表示设置播放器音量，仅支持iOS端*/ 
	system?:boolean,

}

interface audioPlayer_getVolume_Params {
	/**（可选项）是否获取系统音量，若为false表示获取播放器音量，仅支持iOS端*/ 
	system?:boolean,

}

interface audioPlayer_setCurrent_Params {
	/**（可选项）播放位置，取值范围大于 0 不超过当前播放音频的总时长，单位为秒（s）*/ 
	current?:number,

}

interface audioPlayer_addEventListener_Params {
	/**（可选项）监听的事件类型*/ 
	name?:string,

}

interface audioPlayer_removeEventListener_Params {
	/**（可选项）要移除的监听事件类型*/ 
	name?:string,

}

interface audioPlayer_getAttr_Params {
	/**音频的路径 （仅支持 fs://）*/ 
	path:string,

}

interface richText {
	/**
	 * `打开富文本编辑器`
	 * ========params==========
	 *
	 * `title` :string : （可选项）顶部显示标题。
	 *
	 * `html` :string : （可选项）显示html内容。
	 *
	 * `placeholder` :string : （可选项）当打开本模块时，如果html为空需要默认显示的提示内容。
	 */
	openTextEditor(params:richText_openTextEditor_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface richText_openTextEditor_Params {
	/**（可选项）顶部显示标题。*/ 
	title?:string,

	/**（可选项）显示html内容。*/ 
	html?:string,

	/**（可选项）当打开本模块时，如果html为空需要默认显示的提示内容。*/ 
	placeholder?:string,

}

interface cardReader {
}
interface thumbnailUtil {
}
interface checkProxy {
	/** 是否用了代理(异步接口)*/ 
	isProxyUsed():void

	/** 是否用了VPN(异步接口)*/ 
	isVpnUsed():void

	/** 是否用了代理(同步接口)*/ 
	isProxyUsedSync():boolean;

	/** 是否用了VPN(同步接口)*/ 
	isVpnUsedSync():boolean;

}
interface playerCut {
	/**
	 * `打开视频地址`
	 * ========params==========
	 *
	 * `path` :string : 视频的路径，仅支持本地（fs://、widget://）路径
	 */
	open(params:playerCut_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `截取视频`
	 * ========params==========
	 *
	 * `cacheDir` :string : 保存地址；
	 *
	 * `startTime` :number : （选填项）截取视频的起始时间
	 *
	 * `endTime` :number : （选填项）截取视频的结束时间
	 */
	cutVideo(params:playerCut_cutVideo_Params, callback?: (ret:JSON) => void):void

	/**
	 * `获取截取的视频的缩略图`
	 * ========params==========
	 *
	 * `number` :number : （选填项）获取缩略图个数
	 *
	 * `cacheDir` :string : 所有缩略图的保存地址的文件名；
	 */
	getVideoThumbnail(params:playerCut_getVideoThumbnail_Params, callback?: (ret:JSON) => void):void

	/** 获取本地要被截取的视频的总长度*/ 
	getVideoTime():void

}
interface playerCut_open_Params {
	/**视频的路径，仅支持本地（fs://、widget://）路径*/ 
	path:string,

}

interface playerCut_cutVideo_Params {
	/**保存地址；*/ 
	cacheDir:string,

	/**（选填项）截取视频的起始时间*/ 
	startTime:number,

	/**（选填项）截取视频的结束时间*/ 
	endTime:number,

}

interface playerCut_getVideoThumbnail_Params {
	/**（选填项）获取缩略图个数*/ 
	number:number,

	/**所有缩略图的保存地址的文件名；*/ 
	cacheDir:string,

}

interface editorText {
	/** 打开富文本页面*/ 
	open():void

	/** 关闭富文本页面*/ 
	close():void

	/** 添加文本内容*/ 
	addText():void

	/** 添加图片，支持gif图片*/ 
	addImage():void

	/**  清除文本内容*/ 
	remove():void

}
interface fileInfo {
	/** 获取文件信息*/ 
	getFileInfo():void

}
interface touping {
	/** 搜索当前局域网内支持投屏的设备*/ 
	browse():void

	/** 传入设备序号和视频地址开始投屏*/ 
	play():void

	/** 退出投屏*/ 
	stop():void

	/** 设置播放进度*/ 
	seek():void

	/** 设置音量*/ 
	volume():void

	/** 切换视频地址*/ 
	playUrl():void

}
interface videoCompression {
	/**
	 * `压缩本地视频文件`
	 * ========params==========
	 *
	 * `path` :string : 要压缩的视频文件路径，要求本地路径（fs://a/test.mp4、自定义sd卡路径）
	 *
	 * `quality` :string : （可选项）压缩视频质量，**注意：在android端要等比压缩，比如2160p为16:9 可以压缩为16:9的720p，不能压缩为4:3的480p**
	 */
	compression(params:videoCompression_compression_Params, callback?: (ret:JSON) => void):void

	/** 获取当前压缩视频的进度*/ 
	getProgress(callback?: (ret:JSON) => void):void

	/** 停止，取消视频压缩*/ 
	cancel():void

	/** 清除本地存放的压缩的视频文件，**本接口只清除本模块压缩视频文件，调用 api.clearCache接口也会清除压缩的视频文件***/ 
	clearCache():void

}
interface videoCompression_compression_Params {
	/**要压缩的视频文件路径，要求本地路径（fs://a/test.mp4、自定义sd卡路径）*/ 
	path:string,

	/**（可选项）压缩视频质量，**注意：在android端要等比压缩，比如2160p为16:9 可以压缩为16:9的720p，不能压缩为4:3的480p***/ 
	quality?:string,

}

interface mySQL {
	/** 连接MySQL数据库。*/ 
	connect(callback?: (ret:JSON) => void):void

	/** 是否连接。*/ 
	isConnected():void

	/** 执行SQL查询。*/ 
	query(callback?: (ret:JSON) => void):void

	/** 关闭连接。*/ 
	close():void

	/** 执行SQL更新。*/ 
	update(callback?: (ret:JSON) => void):void

}
interface shootPicture {
	/** 打开自定义的拍摄界面。*/ 
	shoot(callback?: (ret:JSON) => void):void

}
interface mosaic {
	/**
	 * `添加图片`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）图片的位置及尺寸
	 *
	 * `bgColor` :string : 模块的背景颜色，支持rgb、rgba
	 *
	 * `path` :boolean : （可选项）是否是整张图片被马赛克，不需要手指涂抹
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	open(params:mosaic_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `保存编辑后的图片`
	 * ========params==========
	 *
	 * `path` :string : （可选项）保存图片路径，要求本地路径（fs://），注意图片后缀名输入完整。若不传或传空，则模块默认将图片保存到临时数据文件夹下
	 *
	 * `copyToAlbum` :boolean : （可选项）是否将结果同时保存到系统相册
	 */
	save(params:mosaic_save_Params, callback?: (ret:JSON) => void):void

	/** 清除本模块产生的图片文件，本接口仅当 save -> path 参数不传或传空时有效，**本接口只清除本模块产生的临时数据，若要清除本 app 缓存的所有数据则调用 api.clearCache***/ 
	clearCache():void

}
interface mosaic_open_Params {
	/**（可选项）图片的位置及尺寸*/ 
	rect?:JSON,

	/**模块的背景颜色，支持rgb、rgba*/ 
	bgColor:string,

	/**（可选项）是否是整张图片被马赛克，不需要手指涂抹*/ 
	path?:boolean,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface mosaic_save_Params {
	/**（可选项）保存图片路径，要求本地路径（fs://），注意图片后缀名输入完整。若不传或传空，则模块默认将图片保存到临时数据文件夹下*/ 
	path?:string,

	/**（可选项）是否将结果同时保存到系统相册*/ 
	copyToAlbum?:boolean,

}

interface webSocket {
	/** websocket消息监听，可以监听连接，断开，接收消息等事件。*/ 
	addEventListener(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `连接websocket`
	 * ========params==========
	 *
	 * `url` :string : （必填项）websocket的连接地址：如：ws://192.168.1.102:8887/socket。
	 *
	 * `pingInterval` :any : (可选项）心跳间隔，单位秒，设置大于0时起效果。
	 *
	 * `pingData` :string : （可选项）心跳数据，配合pingInterval 使用。
	 *
	 * `isBtyes` :boolean : （可选项）是否用流的方式发送数据。
	 *
	 * `isAutoConnect` :boolean : （可选项）是否开启自动断开重连逻辑(需要配合设置心跳间隔和心跳数据才能生效)。
	 */
	open(params:webSocket_open_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `发送内容`
	 * ========params==========
	 *
	 * `data` :string : （必填项）发送的消息内容。
	 *
	 * `isBtyes` :boolean : （可选项）是否用流的方式发送数据。
	 */
	send(params:webSocket_send_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 关闭连接*/ 
	close(callback?: (ret:JSON, err:JSON) => void):void

	/** 获取连接状态*/ 
	getConnectState():void

}
interface webSocket_open_Params {
	/**（必填项）websocket的连接地址：如：ws://192.168.1.102:8887/socket。*/ 
	url:string,

	/**(可选项）心跳间隔，单位秒，设置大于0时起效果。*/ 
	pingInterval?:any,

	/**（可选项）心跳数据，配合pingInterval 使用。*/ 
	pingData?:string,

	/**（可选项）是否用流的方式发送数据。*/ 
	isBtyes?:boolean,

	/**（可选项）是否开启自动断开重连逻辑(需要配合设置心跳间隔和心跳数据才能生效)。*/ 
	isAutoConnect?:boolean,

}

interface webSocket_send_Params {
	/**（必填项）发送的消息内容。*/ 
	data:string,

	/**（可选项）是否用流的方式发送数据。*/ 
	isBtyes?:boolean,

}

interface cardcamera {
	/** 拍照身份证正面方法，返回裁剪后照片的路径*/ 
	frontIdCard():void

}
interface nativeTimer {
	/** 启动一个新的计时器。*/ 
	start():void

	/** 通过计时器ID结束1个或者多个计时器。*/ 
	stop():void

	/** 修改某个计时器的循环周期（只可修改循环计时器）*/ 
	setInterval():void

	/** 向系统声明本应用保持对CPU的占用，可提高应用在手机锁屏的情况下，timer的准确率，但会消耗更多的电量。仅支持Android系统。*/ 
	acquireCpu():void

	/** 释放本应用对CPU的占用，与acquireCpu配对使用。仅支持Android系统。*/ 
	releaseCpu():void

}
interface xxtea {
	/**
	 * `设置密钥(异步接口)`
	 * ========params==========
	 *
	 * `key` :string : （必填项）
	 */
	setKey(params:xxtea_setKey_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `加密(异步接口)`
	 * ========params==========
	 *
	 * `data` :string : （必填项）要加密的字符串
	 */
	encrypt(params:xxtea_encrypt_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `解密(异步接口)`
	 * ========params==========
	 *
	 * `data` :string : （必填项）要解密的字符串
	 */
	decrypt(params:xxtea_decrypt_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `设置密钥(同步接口)`
	 * ========params==========
	 *
	 * `key` :string : （必填项）
	 */
	setKeySync(params:xxtea_setKeySync_Params):boolean;

	/**
	 * `加密(同步接口)`
	 * ========params==========
	 *
	 * `data` :string : （必填项）要加密的字符串
	 */
	encryptSync(params:xxtea_encryptSync_Params):string;

	/**
	 * `解密(同步接口)`
	 * ========params==========
	 *
	 * `data` :string : （必填项）要解密的字符串
	 */
	decryptSync(params:xxtea_decryptSync_Params):string;

}
interface xxtea_setKey_Params {
	/**（必填项）*/ 
	key:string,

}

interface xxtea_encrypt_Params {
	/**（必填项）要加密的字符串*/ 
	data:string,

}

interface xxtea_decrypt_Params {
	/**（必填项）要解密的字符串*/ 
	data:string,

}

interface xxtea_setKeySync_Params {
	/**（必填项）*/ 
	key:string,

}

interface xxtea_encryptSync_Params {
	/**（必填项）要加密的字符串*/ 
	data:string,

}

interface xxtea_decryptSync_Params {
	/**（必填项）要解密的字符串*/ 
	data:string,

}

interface imageClipTools {
	/** 图片裁剪*/ 
	clip(callback?: (ret:JSON) => void):void

	/** 获取圆角图片*/ 
	getRoundBitmap(callback?: (ret:JSON) => void):void

	/** 获取图片大小*/ 
	getImageSize(callback?: (ret:JSON) => void):void

	/** 清除图片缓存（模块处理后的图片保存到了沙盒路径下，调用该接口可全部清除）*/ 
	clearCache(callback?: (ret:JSON) => void):void

}
interface epubReader {
}
interface LBAirDrop {
	/** 搜索可投屏的设备*/ 
	searchList():void

	/** 停止搜索（仅android支持）*/ 
	stopBrowse():void

	/** 链接投屏设备*/ 
	connect():void

	/** 断开连接*/ 
	disConnect():void

	/** 通过pin码获取设备，成功获取后可通过connect连接*/ 
	getDeviceByPin():void

	/**
	 * `视频投屏`
	 * ========params==========
	 *
	 * `videoType` :string : 视频类型
	 *
	 * `path` :string : 视频文件的路径 （iOS暂不支持本地视频播放）
	 *
	 * `mediaType` :number : 媒体播放类型
	 *
	 * `startPosition` :number : （可选项）播放的起始位置；默认：0
	 *
	 * `loopMode` :string : 播放循环模式
	 */
	open(params:LBAirDrop_open_Params):void

	/** 暂停播放*/ 
	pause():void

	/** 恢复播放*/ 
	resumePlay():void

	/**
	 * `设置播放进度`
	 * ========params==========
	 *
	 * `playProgress` :number : 播放进度
	 */
	seekTime(params:LBAirDrop_seekTime_Params):void

	/** 退出播放*/ 
	stop():void

	/**
	 * ` 设置音量值`
	 * ========params==========
	 *
	 * `Volume` :number : 音量值，范围0 ~ 100
	 */
	setVolume(params:LBAirDrop_setVolume_Params):void

	/**  增加音量*/ 
	addVolume():void

	/**  加少音量*/ 
	reduceVolume():void

	/**
	 * `通过扫描二维码获取到的字符串获取服务`
	 * ========params==========
	 *
	 * `codeStringValue` :string : 二维码扫描获取到的字符串
	 */
	scanString(params:LBAirDrop_scanString_Params, callback?: (ret:JSON) => void):void

	/** 是否支持推送弹幕*/ 
	canSupportPushBarrage():void

	/** 是否现在可以推送弹幕（仅iOS支持）*/ 
	canCurrentPushBarrage():void

	/** 设置播控监听*/ 
	setMediaListener():void

	/**
	 * `开启镜像（仅android支持）`
	 * ========params==========
	 *
	 * `resolutionLevel` :number : （可选项）分辨率
	 *
	 * `bitRateLevel` :number : （可选项）比特率
	 *
	 * `audioEnable` :boolean : （可选项）是否开启录制声音
	 *
	 * `ret` :JSON : null
	 *
	 * `err` :JSON : null
	 */
	mirror(params:LBAirDrop_mirror_Params):void

	/** 关闭镜像（仅android支持）*/ 
	stopMirror():void

}
interface LBAirDrop_open_Params {
	/**视频类型*/ 
	videoType:string,

	/**视频文件的路径 （iOS暂不支持本地视频播放）*/ 
	path:string,

	/**媒体播放类型*/ 
	mediaType:number,

	/**（可选项）播放的起始位置；默认：0*/ 
	startPosition?:number,

	/**播放循环模式*/ 
	loopMode:string,

}

interface LBAirDrop_seekTime_Params {
	/**播放进度*/ 
	playProgress:number,

}

interface LBAirDrop_setVolume_Params {
	/**音量值，范围0 ~ 100*/ 
	Volume:number,

}

interface LBAirDrop_scanString_Params {
	/**二维码扫描获取到的字符串*/ 
	codeStringValue:string,

}

interface LBAirDrop_mirror_Params {
	/**（可选项）分辨率*/ 
	resolutionLevel?:number,

	/**（可选项）比特率*/ 
	bitRateLevel?:number,

	/**（可选项）是否开启录制声音*/ 
	audioEnable?:boolean,

	/**null*/ 
	ret:JSON,

	/**null*/ 
	err:JSON,

}

interface posterBuilder {
	/** 进行海报的制作*/ 
	posterBuild(callback?: (ret:JSON, err:JSON) => void):void

}
interface privacy {
	/** 判断是否有定位权限*/ 
	location(callback?: (ret:JSON) => void):void

	/** 判断是否有访问联系人权限*/ 
	contacts(callback?: (ret:JSON) => void):void

	/** 判断是否有访问日历权限*/ 
	calendars(callback?: (ret:JSON) => void):void

	/** 判断是否有访问提醒事项的权限*/ 
	reminders(callback?: (ret:JSON) => void):void

	/** 判断是否有访问相册的权限*/ 
	photos(callback?: (ret:JSON) => void):void

	/** 判断是否有访问蓝牙的权限*/ 
	bluetooth(callback?: (ret:JSON) => void):void

	/** 判断是否有访问录音器的权限*/ 
	microphone(callback?: (ret:JSON) => void):void

	/** 判断是否有访问摄像头的权限*/ 
	camera(callback?: (ret:JSON) => void):void

}
interface phoneNumber {
	/**
	 * `获取电话号码区号`
	 * ========params==========
	 *
	 * `phoneNumber` :string : 电话号码
	 *
	 * `region` :string : 国际域名缩写
	 *
	 * `ret` :JSON : null
	 */
	extractCountryCode(params:phoneNumber_extractCountryCode_Params):void

}
interface phoneNumber_extractCountryCode_Params {
	/**电话号码*/ 
	phoneNumber:string,

	/**国际域名缩写*/ 
	region:string,

	/**null*/ 
	ret:JSON,

}

interface autoStartUp {
}
interface mobilePrint {
	/**
	 * `图片按比例缩放大小，并且保存到指定目录。`
	 * ========params==========
	 *
	 * `flipping` :string : （可选项）图片翻转，取值范围(sx:上下翻转，zy:左右翻转，all:全翻转)。
	 *
	 * `angle` :string : （可选项）图片顺时针旋转角度，取值范围(90,180,270)。
	 *
	 * `oldimgurl` :string : （必选项）缩放前的图片路径，只支持设备内部图片，不支持网络图片。
	 *
	 * `newimgurl` :string : （必选项）缩放后的图片路径，只支持设备内部图片，不支持网络图片。
	 *
	 * `width` :any : （必选项）同比例缩放后图片的宽度（像素）。
	 */
	imgZoom(params:mobilePrint_imgZoom_Params, callback?: (ret:JSON) => void):void

}
interface mobilePrint_imgZoom_Params {
	/**（可选项）图片翻转，取值范围(sx:上下翻转，zy:左右翻转，all:全翻转)。*/ 
	flipping?:string,

	/**（可选项）图片顺时针旋转角度，取值范围(90,180,270)。*/ 
	angle?:string,

	/**（必选项）缩放前的图片路径，只支持设备内部图片，不支持网络图片。*/ 
	oldimgurl:string,

	/**（必选项）缩放后的图片路径，只支持设备内部图片，不支持网络图片。*/ 
	newimgurl:string,

	/**（必选项）同比例缩放后图片的宽度（像素）。*/ 
	width:any,

}

interface youboScan {
	/** 添加扫描监听，设备按键扫描和app内调用startScan都可以通过此方法接收扫描结果*/ 
	addScanListener():void

	/**
	 * `设置扫描设置中的触发模式`
	 * ========params==========
	 *
	 * `mode` :string : null
	 */
	setTriggerMode(params:youboScan_setTriggerMode_Params):void

	/** 获取设置中扫描设置的开关状态*/ 
	getScannerState():void

	/** 打开设置中扫描设置的开关*/ 
	openScanner():void

	/** 关闭设置中扫描设置的开关*/ 
	closeScanner():void

	/** 应用内调用此方法开启扫描*/ 
	startDecode():void

	/** 连续扫描时可调用此方法关闭扫描*/ 
	stopDecode():void

	/**
	 * `播放内置提示音`
	 * ========params==========
	 *
	 * `soundId` :number : 内置两种提示音，0声音短促；1声音尖锐
	 */
	play(params:youboScan_play_Params):void

}
interface youboScan_setTriggerMode_Params {
	/**null*/ 
	mode:string,

}

interface youboScan_play_Params {
	/**内置两种提示音，0声音短促；1声音尖锐*/ 
	soundId:number,

}

interface pasteboard {
}
interface docReader {
	/**
	 * `打开一个文档 （注意：在Android系统上调用此接口会打开第三方APP，通过第三方app阅读文档，而非在应用内打开）`
	 * ========params==========
	 *
	 * `path` :string : 打开文档的路径，要求本地路径（ widget://，fs:// ）
	 *
	 * `autorotation` :boolean : （可选项）是否适应当前设备自动旋转屏幕方向。仅iOS平台支持
	 */
	open(params:docReader_open_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 监听交互事件，仅对 open 接口打开的文档阅读器有效（仅iOS支持）*/ 
	addEventListener():void

	/**
	 * `打开一个文档，仅支持 iOS 端`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `path` :string : 打开文档的路径，要求本地路径（ widget://，fs:// ）
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	openDocView(params:docReader_openDocView_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 关闭 openDocView 打开的文档预览区域，仅支持 iOS 端*/ 
	closeDocView():void

	/**  隐藏 openDocView 打开的文档预览区域，仅支持 iOS 端*/ 
	hideDocView():void

	/** 显示 openDocView 打开的文档预览区域，仅支持 iOS 端*/ 
	showDocView():void

}
interface docReader_open_Params {
	/**打开文档的路径，要求本地路径（ widget://，fs:// ）*/ 
	path:string,

	/**（可选项）是否适应当前设备自动旋转屏幕方向。仅iOS平台支持*/ 
	autorotation?:boolean,

}

interface docReader_openDocView_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**打开文档的路径，要求本地路径（ widget://，fs:// ）*/ 
	path:string,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface DRMScreenShot {
	/**
	 * `打开禁止截屏的区域`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）禁止截屏的区域的位置及大小
	 *
	 * `videoPath` :string : （可选项）禁止截屏区域生成的视频，要求本地路径（fs://、widget://），本参数与image->path参数互斥，都有值时以本参数为准
	 *
	 * `image` :JSON : （可选项）禁止截屏的区域生成的截图，videoPath有值时忽略本参数。
	 */
	open(params:DRMScreenShot_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭*/ 
	close():void

	/** 隐藏*/ 
	hide():void

	/** 显示*/ 
	show():void

}
interface DRMScreenShot_open_Params {
	/**（可选项）禁止截屏的区域的位置及大小*/ 
	rect?:JSON,

	/**（可选项）禁止截屏区域生成的视频，要求本地路径（fs://、widget://），本参数与image->path参数互斥，都有值时以本参数为准*/ 
	videoPath?:string,

	/**（可选项）禁止截屏的区域生成的截图，videoPath有值时忽略本参数。*/ 
	image?:JSON,

}

interface hwScanner {
	/**
	 * `打开自带默认 UI 效果的二维码/条形码扫描页面，本界面相当于打开一个 window 窗口，其界面内容不支持自定义`
	 * ========params==========
	 *
	 * `sound` :string : （可选项）扫描结束后的提示音文件路径，要求本地路径（fs://、widget://），**为保证兼容性，推荐使用 wav 格式的短音频文件** （仅iOS支持）
	 *
	 * `formatType` :string : (可选项) 二维码与一维码的类型
	 */
	defaultScanner(params:hwScanner_defaultScanner_Params, callback?: (ret:JSON) => void):void

	/**
	 * `打开可自定义的二维码/条形码扫描器`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）扫描器的位置及尺寸
	 *
	 * `rectOfInterest` :JSON : （可选项）在扫码区域上的扫码识别区域
	 *
	 * `sound` :string : （可选项）扫描结束后的提示音文件路径，要求本地路径（fs://、widget://），**为保证兼容性，推荐使用 wav 格式的短音频文件**（仅iOS支持）
	 *
	 * `formatType` :string : (可选项) 二维码与一维码的类型
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	customizedScanner(params:hwScanner_customizedScanner_Params, callback?: (ret:JSON) => void):void

	/**
	 * `打开可自定义扫描框样式、描述文案的扫码界面，调用closeCustomizedScanner关闭`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）扫描器的位置及尺寸
	 *
	 * `rectOfInterest` :JSON : （可选项）在扫码区域上的扫码识别区域
	 *
	 * `scanLine` :JSON : （可选项）扫描线配置
	 *
	 * `isShowClose` :boolean : （可选项）是否显示扫描界面关闭按钮
	 *
	 * `isShowLight` :boolean : （可选项）是否显示闪光灯
	 *
	 * `isShowScanDesc` :boolean : （可选项）是否显示描述文案
	 *
	 * `scanUIStyle` :number : （可选项）带蒙版为1，只有scanUIStyle为1时isShowScanDesc、isShowLight 这三个参数才生效
	 *
	 * `cornerLenthRatio` :number : （可选项）扫描框的边角长度，大于等于0 小于0.5，[0, 0.5)
	 *
	 * `closeButton` :JSON : （可选项）关闭按钮图标设置
	 *
	 * `maskColor` :string : （可选项）遮罩层色值，支持rgba、rgb、#
	 *
	 * `tipString` :string : （可选项）识别框下面的提示文字
	 *
	 * `marginB` :number : （可选项）打开手电筒按钮距离扫描识别区域框底部的距离
	 *
	 * `sound` :string : （可选项）扫描结束后的提示音文件路径，要求本地路径（fs://、widget://），**为保证兼容性，推荐使用 wav 格式的短音频文件**
	 *
	 * `formatType` :string : (可选项) 二维码与一维码的类型
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	customizedScannerNew(params:hwScanner_customizedScannerNew_Params, callback?: (ret:JSON) => void):void

	/** 关闭自定义大小的二维码/条码扫描器*/ 
	closeCustomizedScanner():void

	/** 显示自定义大小的二维码/条码扫描器*/ 
	showCustomizedScanner():void

	/** 关闭自定义大小的二维码/条码扫描器*/ 
	hideCustomizedScanner():void

	/**
	 * `打开/关闭闪光灯（在Android上，已打开扫码视图时有效）`
	 * ========params==========
	 *
	 * `status` :string : （可选项）打开/关闭闪光灯，默认值：'off'
	 */
	switchLight(params:hwScanner_switchLight_Params):void

	/**
	 * `直接识别图片`
	 * ========params==========
	 *
	 * `imagePath` :string : 要识别的图片路径，要求本地路径（fs://）
	 *
	 * `formatType` :string : (可选项) 二维码与一维码的类型
	 */
	scanPictureDirect(params:hwScanner_scanPictureDirect_Params, callback?: (ret:JSON) => void):void

	/**
	 * `将字符串生成二维码/条形码图片`
	 * ========params==========
	 *
	 * `formatType` :string : (可选项) 二维码与一维码的类型
	 *
	 * `content` :string : 所要生成的二维码/条形码字符串
	 *
	 * `size` :JSON : （可选项）生成图片的大小
	 *
	 * `backgroundColor` :string : null
	 *
	 * `bitmapColor` :string : （可选项）码图颜色（仅android支持）
	 *
	 * `margin` :number : （可选项）码图边框宽度（仅android支持）
	 */
	encodeContent(params:hwScanner_encodeContent_Params, callback?: (ret:JSON) => void):void

}
interface hwScanner_defaultScanner_Params {
	/**（可选项）扫描结束后的提示音文件路径，要求本地路径（fs://、widget://），**为保证兼容性，推荐使用 wav 格式的短音频文件** （仅iOS支持）*/ 
	sound?:string,

	/**(可选项) 二维码与一维码的类型*/ 
	formatType?:string,

}

interface hwScanner_customizedScanner_Params {
	/**（可选项）扫描器的位置及尺寸*/ 
	rect?:JSON,

	/**（可选项）在扫码区域上的扫码识别区域*/ 
	rectOfInterest?:JSON,

	/**（可选项）扫描结束后的提示音文件路径，要求本地路径（fs://、widget://），**为保证兼容性，推荐使用 wav 格式的短音频文件**（仅iOS支持）*/ 
	sound?:string,

	/**(可选项) 二维码与一维码的类型*/ 
	formatType?:string,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface hwScanner_customizedScannerNew_Params {
	/**（可选项）扫描器的位置及尺寸*/ 
	rect?:JSON,

	/**（可选项）在扫码区域上的扫码识别区域*/ 
	rectOfInterest?:JSON,

	/**（可选项）扫描线配置*/ 
	scanLine?:JSON,

	/**（可选项）是否显示扫描界面关闭按钮*/ 
	isShowClose?:boolean,

	/**（可选项）是否显示闪光灯*/ 
	isShowLight?:boolean,

	/**（可选项）是否显示描述文案*/ 
	isShowScanDesc?:boolean,

	/**（可选项）带蒙版为1，只有scanUIStyle为1时isShowScanDesc、isShowLight 这三个参数才生效*/ 
	scanUIStyle?:number,

	/**（可选项）扫描框的边角长度，大于等于0 小于0.5，[0, 0.5)*/ 
	cornerLenthRatio?:number,

	/**（可选项）关闭按钮图标设置*/ 
	closeButton?:JSON,

	/**（可选项）遮罩层色值，支持rgba、rgb、#*/ 
	maskColor?:string,

	/**（可选项）识别框下面的提示文字*/ 
	tipString?:string,

	/**（可选项）打开手电筒按钮距离扫描识别区域框底部的距离*/ 
	marginB?:number,

	/**（可选项）扫描结束后的提示音文件路径，要求本地路径（fs://、widget://），**为保证兼容性，推荐使用 wav 格式的短音频文件***/ 
	sound?:string,

	/**(可选项) 二维码与一维码的类型*/ 
	formatType?:string,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface hwScanner_switchLight_Params {
	/**（可选项）打开/关闭闪光灯，默认值：'off'*/ 
	status?:string,

}

interface hwScanner_scanPictureDirect_Params {
	/**要识别的图片路径，要求本地路径（fs://）*/ 
	imagePath:string,

	/**(可选项) 二维码与一维码的类型*/ 
	formatType?:string,

}

interface hwScanner_encodeContent_Params {
	/**(可选项) 二维码与一维码的类型*/ 
	formatType?:string,

	/**所要生成的二维码/条形码字符串*/ 
	content:string,

	/**（可选项）生成图片的大小*/ 
	size?:JSON,

	/**null*/ 
	backgroundColor:string,

	/**（可选项）码图颜色（仅android支持）*/ 
	bitmapColor?:string,

	/**（可选项）码图边框宽度（仅android支持）*/ 
	margin?:number,

}

interface networkIndicator {
	/** 显示状态栏网络加载指示器*/ 
	show():void

	/** 隐藏状态栏网络加载指示器*/ 
	hide():void

	/**
	 * `设置进度（仅支持Android）`
	 * ========params==========
	 *
	 * `progress` :number : 需要更新的进度
	 */
	setProgress(params:networkIndicator_setProgress_Params):void

}
interface networkIndicator_setProgress_Params {
	/**需要更新的进度*/ 
	progress:number,

}

interface audioRecorder {
	/**
	 * `开始录音`
	 * ========params==========
	 *
	 * `channel` :number : （可选项）声道支持
	 *
	 * `sampleRates` :number : （可选项）采样率
	 *
	 * `savePath` :string : 保存路径 （仅支持 fs://）
	 *
	 * `format` :string : （可选项）音频格式
	 */
	startRecord(params:audioRecorder_startRecord_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 获取当前/实时音量*/ 
	getVolume():void

	/**
	 * `添加事件监听者`
	 * ========params==========
	 *
	 * `name` :string : （可选项）要监听对象的名字。
	 */
	addEventListener(params:audioRecorder_addEventListener_Params, callback?: (ret:JSON) => void):void

	/** 恢复录音，暂仅支持iOS端*/ 
	resumeRecord():void

	/** 暂停录音，暂仅支持iOS端*/ 
	pauseRecord():void

	/** 停止录音*/ 
	stopRecord():void

	/**
	 * `获取文件属性（文件大小和音频时长）`
	 * ========params==========
	 *
	 * `path` :string : 音频的路径 （仅支持 fs://）
	 */
	getAttr(params:audioRecorder_getAttr_Params, callback?: (ret:JSON) => void):void

}
interface audioRecorder_startRecord_Params {
	/**（可选项）声道支持*/ 
	channel?:number,

	/**（可选项）采样率*/ 
	sampleRates?:number,

	/**保存路径 （仅支持 fs://）*/ 
	savePath:string,

	/**（可选项）音频格式*/ 
	format?:string,

}

interface audioRecorder_addEventListener_Params {
	/**（可选项）要监听对象的名字。*/ 
	name?:string,

}

interface audioRecorder_getAttr_Params {
	/**音频的路径 （仅支持 fs://）*/ 
	path:string,

}

interface idfa {
}
interface upYun {
	/**
	 * `本地签名的表单上传`
	 * ========params==========
	 *
	 * `bucketName` :string : 上传空间名
	 *
	 * `operator` :string : 空间操作员
	 *
	 * `password` :string : 空间操作员密码
	 *
	 * `file` :string : 上传文件，支持fs://、cache://等文件路径协议及真实路径。
	 *
	 * `saveKey` :string : 上传文件的保存路径
	 */
	localUploader(params:upYun_localUploader_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `服务器端签名的表单上传`
	 * ========params==========
	 *
	 * `operator` :string : 空间操作员
	 *
	 * `policy` :string : 上传策略
	 *
	 * `signature` :string : 上传策略签名
	 *
	 * `file` :string : 上传文件，支持fs://、cache://等文件路径协议及真实路径。
	 */
	serverUploader(params:upYun_serverUploader_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `分块上传`
	 * ========params==========
	 *
	 * `bucketName` :string : 上传空间名
	 *
	 * `operator` :string : 空间操作员
	 *
	 * `operatorPassword` :string : 空间操作员密码
	 *
	 * `filePath` :string : 上传文件本地路径，支持fs://、cache://等文件路径协议及真实路径。
	 *
	 * `savePath` :string : 上传文件的保存路径, 例如：“/2015/0901/file1.jpg”
	 */
	blockUpLoader(params:upYun_blockUpLoader_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `表单上传加异步多媒体处理－－视频截图`
	 * ========params==========
	 *
	 * `bucketName` :string : 上传空间名
	 *
	 * `operator` :string : 空间操作员
	 *
	 * `password` :string : 空间操作员密码
	 *
	 * `file` :string : 上传文件，支持fs://、cache://等文件路径协议及真实路径。
	 *
	 * `saveKey` :string : 上传文件的保存路径
	 *
	 * `otherParameters` :string : (可选项)具体参考表单参数，http://docs.upyun.com/api/form_api/#_2
	 */
	uploaderAndAsyncTask(params:upYun_uploaderAndAsyncTask_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface upYun_localUploader_Params {
	/**上传空间名*/ 
	bucketName:string,

	/**空间操作员*/ 
	operator:string,

	/**空间操作员密码*/ 
	password:string,

	/**上传文件，支持fs://、cache://等文件路径协议及真实路径。*/ 
	file:string,

	/**上传文件的保存路径*/ 
	saveKey:string,

}

interface upYun_serverUploader_Params {
	/**空间操作员*/ 
	operator:string,

	/**上传策略*/ 
	policy:string,

	/**上传策略签名*/ 
	signature:string,

	/**上传文件，支持fs://、cache://等文件路径协议及真实路径。*/ 
	file:string,

}

interface upYun_blockUpLoader_Params {
	/**上传空间名*/ 
	bucketName:string,

	/**空间操作员*/ 
	operator:string,

	/**空间操作员密码*/ 
	operatorPassword:string,

	/**上传文件本地路径，支持fs://、cache://等文件路径协议及真实路径。*/ 
	filePath:string,

	/**上传文件的保存路径, 例如：“/2015/0901/file1.jpg”*/ 
	savePath:string,

}

interface upYun_uploaderAndAsyncTask_Params {
	/**上传空间名*/ 
	bucketName:string,

	/**空间操作员*/ 
	operator:string,

	/**空间操作员密码*/ 
	password:string,

	/**上传文件，支持fs://、cache://等文件路径协议及真实路径。*/ 
	file:string,

	/**上传文件的保存路径*/ 
	saveKey:string,

	/**(可选项)具体参考表单参数，http://docs.upyun.com/api/form_api/#_2*/ 
	otherParameters?:string,

}

interface alarmNotification {
}
interface tutu {
	/** 初始化tutu*/ 
	init():void

	/** 打开相机*/ 
	openCamera():void

	/** 编辑图片(单图编辑)*/ 
	editPicture():void

	/** 多图编辑*/ 
	multiPictureEdit():void

	/** 裁剪 + 滤镜组件*/ 
	editAndCutPicture():void

	/** 头像编辑*/ 
	editAvatar():void

	/** 裁剪+滤镜+贴纸组件*/ 
	editAdvanced():void

	/** 打开相册*/ 
	openAlbum():void

	/**
	 * `打开多选相册`
	 * ========params==========
	 *
	 * `autoDismissWhenCompelted` :boolean : (可选项) 是否在组件执行完成后自动关闭组件;
	 *
	 * `ret` :JSON : 编辑图片的返回对象
	 */
	openMultiAlbum(params:tutu_openMultiAlbum_Params):void

	/** 编辑图片直接可以进到指定功能*/ 
	editPictureSpecifiedFunction():void

}
interface tutu_openMultiAlbum_Params {
	/**(可选项) 是否在组件执行完成后自动关闭组件;*/ 
	autoDismissWhenCompelted?:boolean,

	/**编辑图片的返回对象*/ 
	ret:JSON,

}

interface FNPhotograph {
	/**
	 * `打开固定 UI 的相机页面`
	 * ========params==========
	 *
	 * `path` :string : （可选项）图片保存路径，要求本地路径（fs://）
	 *
	 * `album` :boolean : （可选项）拍照成功后是否将所拍图片存入系统相册
	 *
	 * `quality` :string : （可选项）所拍照片质量 **（该参数已弃用，建议使用 qualityValue）**
	 *
	 * `qualityValue` :number : （可选项）所拍照片质量
	 *
	 * `attachedWindow` :boolean : 是否依附在window上
	 *
	 * `usePreview` :boolean : 是否在拍照完后显示预览页面（暂仅支持 android）
	 *
	 * `useAdvanceFeature` :boolean : 是否打开高级属性特性（暂仅支持android）
	 *
	 * `pictureSize` :any : 照片分辨率设置（暂仅支持android）（注意：只有useAdvanceFeature为true时该参数有效，并且该参数不能为空）
	 *
	 * `previewSize` :any : 相机预览分辨率设置（暂仅支持android）（注意：只有useAdvanceFeature为true时该参数有效，并且该参数不能为空）
	 *
	 * `isShowAlbum` :boolean : 是否显示进入相册按钮
	 */
	open(params:FNPhotograph_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `打开纯相机页面`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `orientation` :string : （可选项）设置摄像头朝向
	 *
	 * `isStatusBarHidden` :boolean : （可选项）是否隐藏状态栏 **仅支持iOS**
	 *
	 * `useFrontCamera` :boolean : 是否使用前置摄像头；
	 *
	 * `useAdvanceFeature` :boolean : 是否打开高级属性特性（暂仅支持android）
	 *
	 * `pictureSize` :any : 照片分辨率设置（暂仅支持android）（注意：只有useAdvanceFeature为true时该参数有效，并且该参数不能为空）
	 *
	 * `fixedOn` :string : （可选项）模块添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	openCameraView(params:FNPhotograph_openCameraView_Params, callback?: (ret:JSON) => void):void

	/**
	 * `拍照 （注意此方法与openCameraView配合使用）`
	 * ========params==========
	 *
	 * `quality` :string : （可选项）所拍照片质量  **（该参数已弃用，建议使用 qualityValue）**
	 *
	 * `qualityValue` :number : （可选项）所拍照片质量
	 *
	 * `path` :string : （可选项）图片保存路径，要求本地路径（fs://）。Androd 上若不传，则无法保存到相册。
	 *
	 * `album` :boolean : （可选项）拍照成功后是否将所拍图片存入系统相册
	 *
	 * `isRotation` :boolean : （可选项）是否开启图片自动旋转适配方向功能 **仅支持iOS**
	 */
	takePhoto(params:FNPhotograph_takePhoto_Params, callback?: (ret:JSON) => void):void

	/**
	 * `重设拍摄区域的大小和位置,（注意此方法与openCameraView配合使用）`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）重设模块的位置及尺寸
	 */
	setRect(params:FNPhotograph_setRect_Params):void

	/** 获取相机当前缩放数值（注意此方法与openCameraView配合使用）*/ 
	getZoom():void

	/**
	 * `设置视图大小，若为 2 则表示远视图被放大一倍（注意此方法与openCameraView配合使用。另外，设置视图的放大倍数不能超过视图的最大放大倍数，如果超过最大放大倍数，按最大放大倍数来处理）`
	 * ========params==========
	 *
	 * `zoom` :number : （可选项）设置的焦距大小（视图被放大的倍数），取值范围：大于 1.0
	 */
	setZoom(params:FNPhotograph_setZoom_Params):void

	/** 获取相机支持的最大放大倍率（注意此方法与openCameraView配合使用）*/ 
	getMaxZoom():void

	/**
	 * `设置闪关灯，在 iOS 平台上，前置摄像头打开时不支持操作闪光灯（注意此方法与openCameraView配合使用）`
	 * ========params==========
	 *
	 * `flashlight` :string : （可选项）闪光灯类型
	 */
	setFlashlight(params:FNPhotograph_setFlashlight_Params):void

	/** 获取当前占用的摄像头（注意此方法与openCameraView配合使用）*/ 
	getCamera():void

	/**
	 * `设置前置/后置摄像头（注意此方法与openCameraView配合使用）`
	 * ========params==========
	 *
	 * `camera` :string : （可选项）摄像头
	 */
	setCamera(params:FNPhotograph_setCamera_Params):void

	/**
	 * `设置当前相机对焦模式，配合 setFocusRegion 接口使用（注意此方法与openCameraView配合使用）`
	 * ========params==========
	 *
	 * `focusMode` :string : （可选项）对焦模式
	 */
	setFocusMode(params:FNPhotograph_setFocusMode_Params):void

	/**
	 * `设置当前相机对焦区域，需要跟 setFocusMode 接口同时使用（注意此方法与openCameraView配合使用）`
	 * ========params==========
	 *
	 * `region` :JSON : （可选项）焦点坐标（在录像区域内的坐标，原点在该区域左上角，往右为x轴，下为y轴）
	 */
	setFocusRegion(params:FNPhotograph_setFocusRegion_Params):void

	/**
	 * `设置当前相机对焦提示框（注意此方法与openCameraView配合使用）`
	 * ========params==========
	 *
	 * `box` :string : （可选项）对焦提示框样式配置，该提示框是一个空心的正方形框。当调用setFocusRegion接口时，如果 animation 参数为 true，该提示框的显示与隐藏会有动画。
	 *
	 * `icon` :string : （可选项）自定义的提示框图标路径，要求本地路径（支持fs://、widget://协议），图标大小为：80*80
	 *
	 * `autoHide` :number : （可选项）设置对焦提示框自动隐藏时间，当为 -1 时，不自动隐藏，需调用 hideFocusBox 接口手动隐藏
	 *
	 * `animation` :boolean : （可选项）设置对焦提示框显示和隐藏时是否使用动画
	 */
	setFocusBox(params:FNPhotograph_setFocusBox_Params):void

	/** 隐藏对焦提示框（注意此方法与openCameraView配合使用）*/ 
	hideFocusBox():void

	/**
	 * `事件监听（注意此方法与openCameraView配合使用）`
	 * ========params==========
	 *
	 * `name` :string : 监听的事件类型
	 */
	addEventListener(params:FNPhotograph_addEventListener_Params, callback?: (ret:JSON) => void):void

	/** 关闭相机界面（注意此方法与openCameraView配合使用）*/ 
	closeCameraView():void

	/** 在android系统中，有些相机图片在网页中显示的时候会被旋转，此方法可以获取图片被旋转的角度(未被旋转返回0)，可以使用js将图片旋转解决此问题*/ 
	getRotateDegree():void

	/** 获取支持的相机预览分辨率（暂仅支持android）*/ 
	getSupportPreviewSize():void

	/** 获取支持的拍照后图片的分辨率（暂仅支持android）*/ 
	getSupportPictureSize():void

	/** 关闭相机界面(此接口关闭定制UI的相机页面)*/ 
	close():void

}
interface FNPhotograph_open_Params {
	/**（可选项）图片保存路径，要求本地路径（fs://）*/ 
	path?:string,

	/**（可选项）拍照成功后是否将所拍图片存入系统相册*/ 
	album?:boolean,

	/**（可选项）所拍照片质量 **（该参数已弃用，建议使用 qualityValue）***/ 
	quality?:string,

	/**（可选项）所拍照片质量*/ 
	qualityValue?:number,

	/**是否依附在window上*/ 
	attachedWindow:boolean,

	/**是否在拍照完后显示预览页面（暂仅支持 android）*/ 
	usePreview:boolean,

	/**是否打开高级属性特性（暂仅支持android）*/ 
	useAdvanceFeature:boolean,

	/**照片分辨率设置（暂仅支持android）（注意：只有useAdvanceFeature为true时该参数有效，并且该参数不能为空）*/ 
	pictureSize:any,

	/**相机预览分辨率设置（暂仅支持android）（注意：只有useAdvanceFeature为true时该参数有效，并且该参数不能为空）*/ 
	previewSize:any,

	/**是否显示进入相册按钮*/ 
	isShowAlbum:boolean,

}

interface FNPhotograph_openCameraView_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**（可选项）设置摄像头朝向*/ 
	orientation?:string,

	/**（可选项）是否隐藏状态栏 **仅支持iOS***/ 
	isStatusBarHidden?:boolean,

	/**是否使用前置摄像头；*/ 
	useFrontCamera:boolean,

	/**是否打开高级属性特性（暂仅支持android）*/ 
	useAdvanceFeature:boolean,

	/**照片分辨率设置（暂仅支持android）（注意：只有useAdvanceFeature为true时该参数有效，并且该参数不能为空）*/ 
	pictureSize:any,

	/**（可选项）模块添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface FNPhotograph_takePhoto_Params {
	/**（可选项）所拍照片质量  **（该参数已弃用，建议使用 qualityValue）***/ 
	quality?:string,

	/**（可选项）所拍照片质量*/ 
	qualityValue?:number,

	/**（可选项）图片保存路径，要求本地路径（fs://）。Androd 上若不传，则无法保存到相册。*/ 
	path?:string,

	/**（可选项）拍照成功后是否将所拍图片存入系统相册*/ 
	album?:boolean,

	/**（可选项）是否开启图片自动旋转适配方向功能 **仅支持iOS***/ 
	isRotation?:boolean,

}

interface FNPhotograph_setRect_Params {
	/**（可选项）重设模块的位置及尺寸*/ 
	rect?:JSON,

}

interface FNPhotograph_setZoom_Params {
	/**（可选项）设置的焦距大小（视图被放大的倍数），取值范围：大于 1.0*/ 
	zoom?:number,

}

interface FNPhotograph_setFlashlight_Params {
	/**（可选项）闪光灯类型*/ 
	flashlight?:string,

}

interface FNPhotograph_setCamera_Params {
	/**（可选项）摄像头*/ 
	camera?:string,

}

interface FNPhotograph_setFocusMode_Params {
	/**（可选项）对焦模式*/ 
	focusMode?:string,

}

interface FNPhotograph_setFocusRegion_Params {
	/**（可选项）焦点坐标（在录像区域内的坐标，原点在该区域左上角，往右为x轴，下为y轴）*/ 
	region?:JSON,

}

interface FNPhotograph_setFocusBox_Params {
	/**（可选项）对焦提示框样式配置，该提示框是一个空心的正方形框。当调用setFocusRegion接口时，如果 animation 参数为 true，该提示框的显示与隐藏会有动画。*/ 
	box?:string,

	/**（可选项）自定义的提示框图标路径，要求本地路径（支持fs://、widget://协议），图标大小为：80*80*/ 
	icon?:string,

	/**（可选项）设置对焦提示框自动隐藏时间，当为 -1 时，不自动隐藏，需调用 hideFocusBox 接口手动隐藏*/ 
	autoHide?:number,

	/**（可选项）设置对焦提示框显示和隐藏时是否使用动画*/ 
	animation?:boolean,

}

interface FNPhotograph_addEventListener_Params {
	/**监听的事件类型*/ 
	name:string,

}

interface appmanager {
	/** 获取手机设备信息:*/ 
	getmobileinfo():void

	/** 根据包名获取 APP 的签名:*/ 
	getappsign():void

}
interface baseTools {
}
interface UserDefault {
	/**
	 * `设置数据`
	 * ========params==========
	 *
	 * `key` :string : 设置数据的 Key
	 *
	 * `value` :string : 设置的数据，注意要传基本数据类型，如果是数组这样的，其包含的元素也都必须是基本数据类型
	 */
	setValueForKey(params:UserDefault_setValueForKey_Params):void

	/**
	 * `根据 key 获取数据`
	 * ========params==========
	 *
	 * `key` :string : 获取数据的 Key
	 */
	getValueForKey(params:UserDefault_getValueForKey_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据 key 移除数据`
	 * ========params==========
	 *
	 * `key` :string : 要获取的数据的 Key
	 */
	removeValueForKey(params:UserDefault_removeValueForKey_Params):void

	/** 获取之前设置的所有数据*/ 
	valueRepresentation():void

	/** 设置默认数据*/ 
	registerDefaults():void

}
interface UserDefault_setValueForKey_Params {
	/**设置数据的 Key*/ 
	key:string,

	/**设置的数据，注意要传基本数据类型，如果是数组这样的，其包含的元素也都必须是基本数据类型*/ 
	value:string,

}

interface UserDefault_getValueForKey_Params {
	/**获取数据的 Key*/ 
	key:string,

}

interface UserDefault_removeValueForKey_Params {
	/**要获取的数据的 Key*/ 
	key:string,

}

interface sunmiT1Screen {
	/** 初始化副屏*/ 
	screenInit(callback?: (ret:JSON) => void):void

	/** 显示欢迎*/ 
	showWelcome(callback?: (ret:JSON) => void):void

	/**
	 * `显示文本`
	 * ========params==========
	 *
	 * `title` :null : null
	 *
	 * `content` :string : （必填项）显示数据
	 */
	showText(params:sunmiT1Screen_showText_Params, callback?: (ret:JSON) => void):void

	/**
	 * `显示清单`
	 * ========params==========
	 *
	 * `json` :JSON : （必填项）显示数据
	 */
	showMenu(params:sunmiT1Screen_showMenu_Params, callback?: (ret:JSON) => void):void

	/**
	 * `微信支付`
	 * ========params==========
	 *
	 * `title` :null : null
	 *
	 * `img` :null : null
	 *
	 * `content` :string : （必填项）显示数据
	 */
	showWXpay(params:sunmiT1Screen_showWXpay_Params, callback?: (ret:JSON) => void):void

	/**
	 * `显示图片`
	 * ========params==========
	 *
	 * `imgKey` :null : null
	 *
	 * `img` :string : （必填项）显示数据
	 */
	showImg(params:sunmiT1Screen_showImg_Params, callback?: (ret:JSON) => void):void

	/**
	 * `显示轮播图片`
	 * ========params==========
	 *
	 * `imgsKey` :null : null
	 *
	 * `imgs` :Array : （必填项）显示数据
	 */
	showImgs(params:sunmiT1Screen_showImgs_Params, callback?: (ret:JSON) => void):void

	/**
	 * `显示单个视频`
	 * ========params==========
	 *
	 * `videosKey` :null : null
	 *
	 * `PathVideo` :string : （必填项）显示数据
	 */
	showVideo(params:sunmiT1Screen_showVideo_Params, callback?: (ret:JSON) => void):void

	/** 显示轮播视频*/ 
	showVideos(callback?: (ret:JSON) => void):void

	/**
	 * `显示单个图片清单`
	 * ========params==========
	 *
	 * `imgMenuKey` :null : null
	 *
	 * `json` :null : null
	 *
	 * `img` :string : （必填项）显示数据
	 */
	imageLists(params:sunmiT1Screen_imageLists_Params, callback?: (ret:JSON) => void):void

	/**
	 * `显示单个视频清单`
	 * ========params==========
	 *
	 * `json` :null : null
	 *
	 * `videoMenuKey` :null : null
	 *
	 * `video` :string : （必填项）显示数据
	 */
	videoLists(params:sunmiT1Screen_videoLists_Params, callback?: (ret:JSON) => void):void

	/**
	 * `显示轮播图清单`
	 * ========params==========
	 *
	 * `json` :null : null
	 *
	 * `imgsMenuKey` :null : null
	 *
	 * `imgs` :Array : （必填项）显示数据
	 */
	imagesLists(params:sunmiT1Screen_imagesLists_Params, callback?: (ret:JSON) => void):void

	/** 显示轮播视频清单*/ 
	videosLists(callback?: (ret:JSON) => void):void

	/** 退出副屏*/ 
	exitScreen(callback?: (ret:JSON) => void):void

	/** 清除缓存*/ 
	cachefile(callback?: (ret:JSON) => void):void

}
interface sunmiT1Screen_showText_Params {
	/**null*/ 
	title:null,

	/**（必填项）显示数据*/ 
	content:string,

}

interface sunmiT1Screen_showMenu_Params {
	/**（必填项）显示数据*/ 
	json:JSON,

}

interface sunmiT1Screen_showWXpay_Params {
	/**null*/ 
	title:null,

	/**null*/ 
	img:null,

	/**（必填项）显示数据*/ 
	content:string,

}

interface sunmiT1Screen_showImg_Params {
	/**null*/ 
	imgKey:null,

	/**（必填项）显示数据*/ 
	img:string,

}

interface sunmiT1Screen_showImgs_Params {
	/**null*/ 
	imgsKey:null,

	/**（必填项）显示数据*/ 
	imgs:Array,

}

interface sunmiT1Screen_showVideo_Params {
	/**null*/ 
	videosKey:null,

	/**（必填项）显示数据*/ 
	PathVideo:string,

}

interface sunmiT1Screen_imageLists_Params {
	/**null*/ 
	imgMenuKey:null,

	/**null*/ 
	json:null,

	/**（必填项）显示数据*/ 
	img:string,

}

interface sunmiT1Screen_videoLists_Params {
	/**null*/ 
	json:null,

	/**null*/ 
	videoMenuKey:null,

	/**（必填项）显示数据*/ 
	video:string,

}

interface sunmiT1Screen_imagesLists_Params {
	/**null*/ 
	json:null,

	/**null*/ 
	imgsMenuKey:null,

	/**（必填项）显示数据*/ 
	imgs:Array,

}

interface alarmHelper {
	/**
	 * `设置闹铃`
	 * ========params==========
	 *
	 * `notice` :JSON : （可选项）弹出通知到状态栏。弹出时是否震动或响铃
	 *
	 * `alarm` :JSON : 设置闹铃
	 */
	set(params:alarmHelper_set_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `取消闹铃`
	 * ========params==========
	 *
	 * `id` :number : 闹钟id
	 */
	cancel(params:alarmHelper_cancel_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface alarmHelper_set_Params {
	/**（可选项）弹出通知到状态栏。弹出时是否震动或响铃*/ 
	notice?:JSON,

	/**设置闹铃*/ 
	alarm:JSON,

}

interface alarmHelper_cancel_Params {
	/**闹钟id*/ 
	id:number,

}

interface install {
}
interface fileReader {
	/**
	 * `以 window 的形式打开 Files`
	 * ========params==========
	 *
	 * `types` :Array : （可选项）打开文件的类型，详情参考[苹果官方文档](https://developer.apple.com/library/archive/documentation/Miscellaneous/Reference/UTIRef/Articles/System-DeclaredUniformTypeIdentifiers.html#//apple_ref/doc/uid/TP40009259)
	 */
	open(params:fileReader_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `添加事件监听`
	 * ========params==========
	 *
	 * `target` :string : （可选项）所要监听的事件
	 */
	addEventListener(params:fileReader_addEventListener_Params, callback?: (ret:JSON) => void):void

}
interface fileReader_open_Params {
	/**（可选项）打开文件的类型，详情参考[苹果官方文档](https://developer.apple.com/library/archive/documentation/Miscellaneous/Reference/UTIRef/Articles/System-DeclaredUniformTypeIdentifiers.html#//apple_ref/doc/uid/TP40009259)*/ 
	types?:Array,

}

interface fileReader_addEventListener_Params {
	/**（可选项）所要监听的事件*/ 
	target?:string,

}

interface aliyunOSS {
	/**
	 * `初始化sdk  （调用优先级最高，只需要调用一次）`
	 * ========params==========
	 *
	 * `accessKeyId` :string : （可选项）从阿里云获取的accessKeyId
	 *
	 * `accessKeySecret` :string : （可选项）从阿里云获取的accessKeySecret
	 *
	 * `endpoint` :string : 阿里云OSS服务在各个区域的地址，如：https://oss-cn-hangzhou.aliyuncs.com
	 *
	 * `serverUrl` :string : （可选项）自签名URL地址，明文模式时可选。如：https://localhost:8080/distribute-token.json
	 */
	initOSSClient(params:aliyunOSS_initOSSClient_Params, callback?: (ret:JSON) => void):void

	/**
	 * `文件上传， 通过NSURL上传一个文件`
	 * ========params==========
	 *
	 * `bucketName` :string : Bucket名称。
	 *
	 * `objectKey` :string : Object名称。如："folder/subfolder/file"
	 *
	 * `file` :string : 要上传的文件，支持fs://、cache://等文件路径协议及真实路径。
	 *
	 * `uploadType` :number : 上传文件的类型，1为异步上传，2为追加上传，3为断点续传(Android仅支持异步上传)
	 */
	upload(params:aliyunOSS_upload_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `下载文件，当下载图片并且传入process参数时可以处理图片。`
	 * ========params==========
	 *
	 * `bucketName` :string : Bucket名称。
	 *
	 * `objectKey` :string : 待下载的阿里OSS文件名，"folder/subfolder/file"
	 *
	 * `process` :string : （可选项）下载图片时对图片进行处理的命令。处理命令参见阿里文档：图片处理 (仅当下载图片时有效)
	 *
	 * `saveFileName` :string : 下载文件路径（仅支持 fs://）
	 */
	download(params:aliyunOSS_download_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `删除单个文件，要求对所在的Bucket有写权限。`
	 * ========params==========
	 *
	 * `bucketName` :string : Bucket名称。
	 *
	 * `objectKey` :string : 待删除的阿里OSS文件名，"folder/subfolder/file"
	 */
	deleteObject(params:aliyunOSS_deleteObject_Params, callback?: (ret:JSON) => void):void

}
interface aliyunOSS_initOSSClient_Params {
	/**（可选项）从阿里云获取的accessKeyId*/ 
	accessKeyId?:string,

	/**（可选项）从阿里云获取的accessKeySecret*/ 
	accessKeySecret?:string,

	/**阿里云OSS服务在各个区域的地址，如：https://oss-cn-hangzhou.aliyuncs.com*/ 
	endpoint:string,

	/**（可选项）自签名URL地址，明文模式时可选。如：https://localhost:8080/distribute-token.json*/ 
	serverUrl?:string,

}

interface aliyunOSS_upload_Params {
	/**Bucket名称。*/ 
	bucketName:string,

	/**Object名称。如："folder/subfolder/file"*/ 
	objectKey:string,

	/**要上传的文件，支持fs://、cache://等文件路径协议及真实路径。*/ 
	file:string,

	/**上传文件的类型，1为异步上传，2为追加上传，3为断点续传(Android仅支持异步上传)*/ 
	uploadType:number,

}

interface aliyunOSS_download_Params {
	/**Bucket名称。*/ 
	bucketName:string,

	/**待下载的阿里OSS文件名，"folder/subfolder/file"*/ 
	objectKey:string,

	/**（可选项）下载图片时对图片进行处理的命令。处理命令参见阿里文档：图片处理 (仅当下载图片时有效)*/ 
	process?:string,

	/**下载文件路径（仅支持 fs://）*/ 
	saveFileName:string,

}

interface aliyunOSS_deleteObject_Params {
	/**Bucket名称。*/ 
	bucketName:string,

	/**待删除的阿里OSS文件名，"folder/subfolder/file"*/ 
	objectKey:string,

}

interface openAppPlus {
	/**
	 * `打开手机上其它应用`
	 * ========params==========
	 *
	 * `androidPkg` :string : （可选项）目标APP的包名
	 *
	 * `className` :string : （可选项）目标APP的类名
	 *
	 * `uri` :string : （可选项）指定目标应用响应的uri
	 */
	openApp(params:openAppPlus_openApp_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface openAppPlus_openApp_Params {
	/**（可选项）目标APP的包名*/ 
	androidPkg?:string,

	/**（可选项）目标APP的类名*/ 
	className?:string,

	/**（可选项）指定目标应用响应的uri*/ 
	uri?:string,

}

interface macauPay {
	/** 切换使用环境*/ 
	changeEnvironment(callback?: (ret:JSON, err:JSON) => void):void

	/** 澳门支付*/ 
	macauPay(callback?: (ret:JSON, err:JSON) => void):void

	/** 支付宝支付*/ 
	aliPay(callback?: (ret:JSON, err:JSON) => void):void

}
interface fivegswitcher {
	/** 判断当前设备是否支持5G*/ 
	isFiveGCapable(callback?: (ret:JSON, err:JSON) => void):void

	/** 是否开启了5G开关*/ 
	isUserFiveGEnabled(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `设置开启和关闭5G`
	 * ========params==========
	 *
	 * `isOpen` :boolean : true设置开启5G,false关闭5G
	 */
	setUserFiveGEnabled(params:fivegswitcher_setUserFiveGEnabled_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface fivegswitcher_setUserFiveGEnabled_Params {
	/**true设置开启5G,false关闭5G*/ 
	isOpen:boolean,

}

interface pdfTrans {
	/**
	 * `把模块所依附的当前 webview 转换为一个 pdf 文件`
	 * ========params==========
	 *
	 * `save` :JSON : （可选项）转换的 pdf 文件的保存信息
	 */
	trans(params:pdfTrans_trans_Params, callback?: (ret:JSON) => void):void

}
interface pdfTrans_trans_Params {
	/**（可选项）转换的 pdf 文件的保存信息*/ 
	save?:JSON,

}

interface iTVBox {
	/**
	 * `置入云端服务器地址`
	 * ========params==========
	 *
	 * `ServerURL` :string : （必填项）填写您云端服务器地址，不带http&https的地址（例：app.haleyryan.cn/moduleitvbox）。
	 */
	setServerURL(params:iTVBox_setServerURL_Params, callback?: (ret:JSON) => void):void

	/** 发送给云端指令（注意云端接收脚本名为SendMsg）*/ 
	sendMsg(callback?: (ret:JSON) => void):void

	/** 接收来自云端指令代码（注意云端接收脚本名为DownMsg）*/ 
	downMsg(callback?: (ret:JSON) => void):void

}
interface iTVBox_setServerURL_Params {
	/**（必填项）填写您云端服务器地址，不带http&https的地址（例：app.haleyryan.cn/moduleitvbox）。*/ 
	ServerURL:string,

}

interface audio {
	/** 播放网络音频时，清除本地缓存*/ 
	expungeCache():void

}
interface sunmiPrinterInner {
	/** 连接打印机*/ 
	connect(callback?: (ret:JSON) => void):void

	/** 断开打印机*/ 
	disconnect():void

	/** 获取打印机状态*/ 
	getPrinterStatus(callback?: (ret:JSON) => void):void

	/** 打印机初始化*/ 
	printInit():void

	/** 可通过自检页查看打印效果、打印机信息*/ 
	printSelfCheck():void

	/** 接收ESC指令内容并执行打印（参考ESC指令）*/ 
	printRawData():void

	/**
	 * `打印富含样式的文本内容`
	 * ========params==========
	 *
	 * `text` :string : 要打印的文本内容
	 *
	 * `align` :any : 对齐方式
	 *
	 * `size` :any : 打印文本的字体大小
	 *
	 * `bold` :boolean : 文本内容是否加粗
	 *
	 * `underline` :boolean : 文本内容是否下划线
	 *
	 * `compact` :boolean : 文本内容是否紧凑模式
	 *
	 * `skip` :boolean : 文本内容当不满一行时是否直接输出
	 */
	printText(params:sunmiPrinterInner_printText_Params):void

	/**
	 * `按列打印文本内容`
	 * ========params==========
	 *
	 * `texts` :Array : 字符串数组表示每一列的文本内容
	 *
	 * `lengths` :Array : 整型数组表示每一列占的字符数量
	 *
	 * `aligns` :Array : 整型数组表示每一列的对齐方式
	 *
	 * `bold` :boolean : 文本内容是否加粗
	 */
	printColumnsText(params:sunmiPrinterInner_printColumnsText_Params):void

	/**
	 * `打印条码内容`
	 * ========params==========
	 *
	 * `text` :string : 要打印的条形码内容需搭配条形码类型
	 *
	 * `symbology` :any : 条形码类型
	 *
	 * `height` :any : 条形码高度
	 *
	 * `width` :any : 条形码宽度
	 *
	 * `hri` :any : HRI位置
	 *
	 * `align` :any : 对齐方式
	 */
	printBarCode(params:sunmiPrinterInner_printBarCode_Params):void

	/**
	 * `打印二维码码内容`
	 * ========params==========
	 *
	 * `text` :string : 二维码内容
	 *
	 * `size` :any : 二维码块大小
	 *
	 * `errorlevel` :any : 纠错等级
	 *
	 * `align` :any : 对齐方式
	 */
	printQrCode(params:sunmiPrinterInner_printQrCode_Params):void

	/**
	 * `打印富含样式的文本内容`
	 * ========params==========
	 *
	 * `path` :string : 图片的存储路径
	 *
	 * `url` :string : 来自网络的图片url
	 *
	 * `align` :any : 对齐方式
	 */
	printBitmap(params:sunmiPrinterInner_printBitmap_Params):void

	/** 切刀切纸*/ 
	cutPaper():void

}
interface sunmiPrinterInner_printText_Params {
	/**要打印的文本内容*/ 
	text:string,

	/**对齐方式*/ 
	align:any,

	/**打印文本的字体大小*/ 
	size:any,

	/**文本内容是否加粗*/ 
	bold:boolean,

	/**文本内容是否下划线*/ 
	underline:boolean,

	/**文本内容是否紧凑模式*/ 
	compact:boolean,

	/**文本内容当不满一行时是否直接输出*/ 
	skip:boolean,

}

interface sunmiPrinterInner_printColumnsText_Params {
	/**字符串数组表示每一列的文本内容*/ 
	texts:Array,

	/**整型数组表示每一列占的字符数量*/ 
	lengths:Array,

	/**整型数组表示每一列的对齐方式*/ 
	aligns:Array,

	/**文本内容是否加粗*/ 
	bold:boolean,

}

interface sunmiPrinterInner_printBarCode_Params {
	/**要打印的条形码内容需搭配条形码类型*/ 
	text:string,

	/**条形码类型*/ 
	symbology:any,

	/**条形码高度*/ 
	height:any,

	/**条形码宽度*/ 
	width:any,

	/**HRI位置*/ 
	hri:any,

	/**对齐方式*/ 
	align:any,

}

interface sunmiPrinterInner_printQrCode_Params {
	/**二维码内容*/ 
	text:string,

	/**二维码块大小*/ 
	size:any,

	/**纠错等级*/ 
	errorlevel:any,

	/**对齐方式*/ 
	align:any,

}

interface sunmiPrinterInner_printBitmap_Params {
	/**图片的存储路径*/ 
	path:string,

	/**来自网络的图片url*/ 
	url:string,

	/**对齐方式*/ 
	align:any,

}

interface tencentCos {
	/**
	 * `初始化IM`
	 * ========params==========
	 *
	 * `appId` :string : (必填项)应用的Id
	 *
	 * `secretId` :string : (必填项)加密Id
	 *
	 * `secretKey` :string : (必填项)加密Key
	 *
	 * `ret` :boolean : 初始化是否成功; true表示操作成功
	 */
	init(params:tencentCos_init_Params):void

	/** 上传对象*/ 
	uploadObject():void

	/**
	 * `取消上传`
	 * ========params==========
	 *
	 * `bucket` :string : (必填项)要上传的存储桶
	 *
	 * `key` :string : (必填项)键名
	 *
	 * `ret` :string : 取消上传的键值
	 *
	 * `err` :any : 错误信息
	 */
	cancelUpload(params:tencentCos_cancelUpload_Params):void

	/**
	 * `下载对象`
	 * ========params==========
	 *
	 * `bucket` :string : (必填项)要上传的存储桶
	 *
	 * `key` :string : (必填项)键名
	 *
	 * `path` :string : (必填项)指定下载的文件路径
	 *
	 * `ret` :string : 下载的文件路径
	 *
	 * `err` :any : 错误信息
	 */
	downloadObject(params:tencentCos_downloadObject_Params):void

	/**
	 * `删除单个对象`
	 * ========params==========
	 *
	 * `bucket` :string : (必填项)要上传的存储桶
	 *
	 * `key` :string : (必填项)键名
	 *
	 * `ret` :boolean : true表示操作成功
	 *
	 * `err` :any : 错误信息
	 */
	deleteObject(params:tencentCos_deleteObject_Params):void

}
interface tencentCos_init_Params {
	/**(必填项)应用的Id*/ 
	appId:string,

	/**(必填项)加密Id*/ 
	secretId:string,

	/**(必填项)加密Key*/ 
	secretKey:string,

	/**初始化是否成功; true表示操作成功*/ 
	ret:boolean,

}

interface tencentCos_cancelUpload_Params {
	/**(必填项)要上传的存储桶*/ 
	bucket:string,

	/**(必填项)键名*/ 
	key:string,

	/**取消上传的键值*/ 
	ret:string,

	/**错误信息*/ 
	err:any,

}

interface tencentCos_downloadObject_Params {
	/**(必填项)要上传的存储桶*/ 
	bucket:string,

	/**(必填项)键名*/ 
	key:string,

	/**(必填项)指定下载的文件路径*/ 
	path:string,

	/**下载的文件路径*/ 
	ret:string,

	/**错误信息*/ 
	err:any,

}

interface tencentCos_deleteObject_Params {
	/**(必填项)要上传的存储桶*/ 
	bucket:string,

	/**(必填项)键名*/ 
	key:string,

	/**true表示操作成功*/ 
	ret:boolean,

	/**错误信息*/ 
	err:any,

}

interface serialPortPlus {
	/**
	 * `获取所有串口信息`
	 * ========params==========
	 *
	 * `index` :JSON : (可选项) 打开指定序号。
	 */
	getAllDevices(params:serialPortPlus_getAllDevices_Params):void

	/**
	 * `查询串口设备地址列表`
	 * ========params==========
	 *
	 * `index` :JSON : (可选项) 打开指定序号。
	 */
	getAllDeicesPath(params:serialPortPlus_getAllDeicesPath_Params):void

	/**
	 * `串口接收数据监听`
	 * ========params==========
	 *
	 * `index` :number : (可选项) 打开指定序号。
	 *
	 * `revType` :string : (可选项) 接收数据类型;(text hex)。
	 */
	addEventListener(params:serialPortPlus_addEventListener_Params, callback?: (ret:JSON) => void):void

	/**
	 * `打开串口`
	 * ========params==========
	 *
	 * `index` :number : (可选项) 打开指定序号。
	 *
	 * `port` :string : (必填项) 端口 （如:/dev/ttyS2)。
	 *
	 * `baudRate` :number : (必填项) 波特率（0,50,75,110,134,150,200,300,600,1200,1800,2400,4800,9600,19200,38400,57600,115200,230400,460800,500000,576000,921600,1000000,1152000,1500000,2000000,2500000,3000000,3500000,4000000）
	 *
	 * `stopBits` :number : (必填项) 支持设置停止位（1:1位停止位 2:2位停止位）
	 *
	 * `dataBits` :number : (必填项) 支持设置数据位(5:5位数据位 6:6位数据位 7:7位数据位 8:8位数据位)
	 *
	 * `parity` :number : (必填项) 支持设置检验位（0:无奇偶校验 1:奇校验 2:偶校验）
	 *
	 * `flowCon` :number : (必填项) 支持设置流控(0:不使用流控 1:硬件流控 2:软件流控)
	 */
	open(params:serialPortPlus_open_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `发送数据`
	 * ========params==========
	 *
	 * `index` :number : (可选项) 打开指定序号。
	 *
	 * `sendType` :string : (可选项) 发送数据类型;(text hex)。
	 *
	 * `data` :JSON : (必填项) 发送内容。
	 */
	send(params:serialPortPlus_send_Params):void

	/**
	 * `关闭串口`
	 * ========params==========
	 *
	 * `index` :JSON : (可选项) 打开指定序号。
	 */
	close(params:serialPortPlus_close_Params):void

}
interface serialPortPlus_getAllDevices_Params {
	/**(可选项) 打开指定序号。*/ 
	index?:JSON,

}

interface serialPortPlus_getAllDeicesPath_Params {
	/**(可选项) 打开指定序号。*/ 
	index?:JSON,

}

interface serialPortPlus_addEventListener_Params {
	/**(可选项) 打开指定序号。*/ 
	index?:number,

	/**(可选项) 接收数据类型;(text hex)。*/ 
	revType?:string,

}

interface serialPortPlus_open_Params {
	/**(可选项) 打开指定序号。*/ 
	index?:number,

	/**(必填项) 端口 （如:/dev/ttyS2)。*/ 
	port:string,

	/**(必填项) 波特率（0,50,75,110,134,150,200,300,600,1200,1800,2400,4800,9600,19200,38400,57600,115200,230400,460800,500000,576000,921600,1000000,1152000,1500000,2000000,2500000,3000000,3500000,4000000）*/ 
	baudRate:number,

	/**(必填项) 支持设置停止位（1:1位停止位 2:2位停止位）*/ 
	stopBits:number,

	/**(必填项) 支持设置数据位(5:5位数据位 6:6位数据位 7:7位数据位 8:8位数据位)*/ 
	dataBits:number,

	/**(必填项) 支持设置检验位（0:无奇偶校验 1:奇校验 2:偶校验）*/ 
	parity:number,

	/**(必填项) 支持设置流控(0:不使用流控 1:硬件流控 2:软件流控)*/ 
	flowCon:number,

}

interface serialPortPlus_send_Params {
	/**(可选项) 打开指定序号。*/ 
	index?:number,

	/**(可选项) 发送数据类型;(text hex)。*/ 
	sendType?:string,

	/**(必填项) 发送内容。*/ 
	data:JSON,

}

interface serialPortPlus_close_Params {
	/**(可选项) 打开指定序号。*/ 
	index?:JSON,

}

interface takePicCutOut {
	/**
	 * `打开身份证裁剪界面`
	 * ========params==========
	 *
	 * `isCardFront` :boolean : （可选项）身份证正面还是背面。(true:正面 false:背面)
	 *
	 * `isAlbumImport` :boolean : （可选项）是否显示导入图片按钮。(true:显示 false:不显示)
	 */
	openIDCardCut(params:takePicCutOut_openIDCardCut_Params, callback?: (ret:JSON) => void):void

	/**
	 * `打开卡片裁剪界面`
	 * ========params==========
	 *
	 * `isAlbumImport` :boolean : （可选项）是否显示导入图片按钮。(true:显示 false:不显示)
	 */
	openCardCut(params:takePicCutOut_openCardCut_Params, callback?: (ret:JSON) => void):void

	/**
	 * `打开自定义裁剪界面`
	 * ========params==========
	 *
	 * `isAlbumImport` :boolean : （可选项）是否显示导入图片按钮。(true:显示 false:不显示)
	 */
	openCustomCut(params:takePicCutOut_openCustomCut_Params, callback?: (ret:JSON) => void):void

	/**
	 * `打开护照裁剪界面`
	 * ========params==========
	 *
	 * `isAlbumImport` :boolean : （可选项）是否显示导入图片按钮。(true:显示 false:不显示)
	 */
	openPassportCut(params:takePicCutOut_openPassportCut_Params, callback?: (ret:JSON) => void):void

}
interface takePicCutOut_openIDCardCut_Params {
	/**（可选项）身份证正面还是背面。(true:正面 false:背面)*/ 
	isCardFront?:boolean,

	/**（可选项）是否显示导入图片按钮。(true:显示 false:不显示)*/ 
	isAlbumImport?:boolean,

}

interface takePicCutOut_openCardCut_Params {
	/**（可选项）是否显示导入图片按钮。(true:显示 false:不显示)*/ 
	isAlbumImport?:boolean,

}

interface takePicCutOut_openCustomCut_Params {
	/**（可选项）是否显示导入图片按钮。(true:显示 false:不显示)*/ 
	isAlbumImport?:boolean,

}

interface takePicCutOut_openPassportCut_Params {
	/**（可选项）是否显示导入图片按钮。(true:显示 false:不显示)*/ 
	isAlbumImport?:boolean,

}

interface shortCut {
	/** 为当前app添加快捷方式*/ 
	showLaunch():void

}
interface weChatCamera {
	/**
	 * `录制视频`
	 * ========params==========
	 *
	 * `minDuration` :number : （必填项）允许拍摄的最小时长；
	 *
	 * `maxDuration` :number : （必填项）允许拍摄的最大时长，时长越大，产生的视频文件越大；
	 *
	 * `isBackCamera` :boolean : （可选项）是否默认后置摄像头: true 后置摄像头 false 前置摄像头
	 *
	 * `isOpenCapture` :boolean : （可选项）是否开启单点拍照功能: true 打开 false 关闭
	 *
	 * `isOpenRecord` :boolean : （可选项）是否开启长按录像功能: true 打开 false 关闭
	 *
	 * `recordTips` :string : （可选项）录制视频界面文字提示。
	 */
	record(params:weChatCamera_record_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 获取视频存放文件夹大小*/ 
	getCacheSize(callback?: (ret:JSON, err:JSON) => void):void

	/** 清除存放视频文件夹所有视频*/ 
	clearCache(callback?: (ret:JSON, err:JSON) => void):void

}
interface weChatCamera_record_Params {
	/**（必填项）允许拍摄的最小时长；*/ 
	minDuration:number,

	/**（必填项）允许拍摄的最大时长，时长越大，产生的视频文件越大；*/ 
	maxDuration:number,

	/**（可选项）是否默认后置摄像头: true 后置摄像头 false 前置摄像头*/ 
	isBackCamera?:boolean,

	/**（可选项）是否开启单点拍照功能: true 打开 false 关闭*/ 
	isOpenCapture?:boolean,

	/**（可选项）是否开启长按录像功能: true 打开 false 关闭*/ 
	isOpenRecord?:boolean,

	/**（可选项）录制视频界面文字提示。*/ 
	recordTips?:string,

}

interface aliyunStsOss {
	/**
	 * `获取sts鉴权临时secret（可用自身的请求替代）`
	 * ========params==========
	 *
	 * `url` :string : （必选项）获取stsToken的请求的地址
	 *
	 * `type` :string : （可选项）请求方式 POST 或 GET
	 *
	 * `data` :JSON : （可选项）发送到服务器的数据
	 */
	getStsToken(params:aliyunStsOss_getStsToken_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `初始化oss对象。`
	 * ========params==========
	 *
	 * `endpoint` :string : （可选项）阿里云OSS服务在各个区域的地址，如使用CDN加速并有自定义endpoint须填
	 *
	 * `accessKeyId` :string : （必选项）从阿里云获取的accessKeyId
	 *
	 * `accessKeySecret` :string : （必选项）从阿里云获取的accessKeySecret
	 *
	 * `securityToken` :string : （必选项）从阿里云获取的securityToken
	 */
	initConfig(params:aliyunStsOss_initConfig_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `初始化oss对象。（本文档推荐使用）`
	 * ========params==========
	 *
	 * `url` :string : （必选项）获取stsToken的请求的地址
	 *
	 * `type` :string : （可选项）请求方式 POST 或 GET
	 *
	 * `data` :JSON : （可选项）发送到服务器的数据
	 *
	 * `endpoint` :string : （可选项）阿里云OSS服务在各个区域的地址，如使用CDN加速并有自定义endpoint须填
	 */
	init(params:aliyunStsOss_init_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `文件上传，通过NSURL上传一个文件`
	 * ========params==========
	 *
	 * `bucketName` :string : （必选项）Bucket名称
	 *
	 * `objectKey` :string : （必选项）Object名称，包含文件最终命名。如："folder/subfolder/file"
	 *
	 * `file` :string : （必选项）要上传的文件，支持fs://、cache://等文件路径协议及真实路径。
	 *
	 * `type` :any : （可选项）上传类型：0同步；1异步。
	 */
	upload(params:aliyunStsOss_upload_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `文件断点续传，通过NSURL上传一个文件`
	 * ========params==========
	 *
	 * `bucketName` :string : （必选项）Bucket名称
	 *
	 * `objectKey` :string : （必选项）Object名称，包含文件最终命名。如："folder/subfolder/file"
	 *
	 * `file` :string : （必选项）要上传的文件，支持fs://、cache://等文件路径协议及真实路径。
	 */
	resumableUpload(params:aliyunStsOss_resumableUpload_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `下载文件`
	 * ========params==========
	 *
	 * `bucketName` :string : （必选项）Bucket名称
	 *
	 * `objectKey` :string : （必选项）Object名称，包含文件最终命名。如："folder/subfolder/file"
	 *
	 * `path` :string : （必选项）要上传的文件，支持fs://、cache://等文件路径协议及真实路径。
	 *
	 * `type` :any : （可选项）上传类型：0同步；1异步。
	 */
	download(params:aliyunStsOss_download_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `删除文件`
	 * ========params==========
	 *
	 * `bucketName` :string : （必选项）Bucket名称
	 *
	 * `objectKey` :string : （必选项）Object名称，包含文件最终命名。如："folder/subfolder/file"
	 */
	deleteObject(params:aliyunStsOss_deleteObject_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `签名URL授予第三方访问（私有读的情况下使用，亦可获取文件的正确访问地址使用）`
	 * ========params==========
	 *
	 * `bucketName` :string : （必选项）Bucket名称
	 *
	 * `objectKey` :string : （必选项）Object名称，包含文件最终命名。如："folder/subfolder/file"
	 *
	 * `type` :any : （可选项）公开私有类型0：公开；1：私有
	 *
	 * `interval` :any : （可选项）过期时间秒
	 */
	signAccessObjectURL(params:aliyunStsOss_signAccessObjectURL_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface aliyunStsOss_getStsToken_Params {
	/**（必选项）获取stsToken的请求的地址*/ 
	url:string,

	/**（可选项）请求方式 POST 或 GET*/ 
	type?:string,

	/**（可选项）发送到服务器的数据*/ 
	data?:JSON,

}

interface aliyunStsOss_initConfig_Params {
	/**（可选项）阿里云OSS服务在各个区域的地址，如使用CDN加速并有自定义endpoint须填*/ 
	endpoint?:string,

	/**（必选项）从阿里云获取的accessKeyId*/ 
	accessKeyId:string,

	/**（必选项）从阿里云获取的accessKeySecret*/ 
	accessKeySecret:string,

	/**（必选项）从阿里云获取的securityToken*/ 
	securityToken:string,

}

interface aliyunStsOss_init_Params {
	/**（必选项）获取stsToken的请求的地址*/ 
	url:string,

	/**（可选项）请求方式 POST 或 GET*/ 
	type?:string,

	/**（可选项）发送到服务器的数据*/ 
	data?:JSON,

	/**（可选项）阿里云OSS服务在各个区域的地址，如使用CDN加速并有自定义endpoint须填*/ 
	endpoint?:string,

}

interface aliyunStsOss_upload_Params {
	/**（必选项）Bucket名称*/ 
	bucketName:string,

	/**（必选项）Object名称，包含文件最终命名。如："folder/subfolder/file"*/ 
	objectKey:string,

	/**（必选项）要上传的文件，支持fs://、cache://等文件路径协议及真实路径。*/ 
	file:string,

	/**（可选项）上传类型：0同步；1异步。*/ 
	type?:any,

}

interface aliyunStsOss_resumableUpload_Params {
	/**（必选项）Bucket名称*/ 
	bucketName:string,

	/**（必选项）Object名称，包含文件最终命名。如："folder/subfolder/file"*/ 
	objectKey:string,

	/**（必选项）要上传的文件，支持fs://、cache://等文件路径协议及真实路径。*/ 
	file:string,

}

interface aliyunStsOss_download_Params {
	/**（必选项）Bucket名称*/ 
	bucketName:string,

	/**（必选项）Object名称，包含文件最终命名。如："folder/subfolder/file"*/ 
	objectKey:string,

	/**（必选项）要上传的文件，支持fs://、cache://等文件路径协议及真实路径。*/ 
	path:string,

	/**（可选项）上传类型：0同步；1异步。*/ 
	type?:any,

}

interface aliyunStsOss_deleteObject_Params {
	/**（必选项）Bucket名称*/ 
	bucketName:string,

	/**（必选项）Object名称，包含文件最终命名。如："folder/subfolder/file"*/ 
	objectKey:string,

}

interface aliyunStsOss_signAccessObjectURL_Params {
	/**（必选项）Bucket名称*/ 
	bucketName:string,

	/**（必选项）Object名称，包含文件最终命名。如："folder/subfolder/file"*/ 
	objectKey:string,

	/**（可选项）公开私有类型0：公开；1：私有*/ 
	type?:any,

	/**（可选项）过期时间秒*/ 
	interval?:any,

}

interface mtlFile {
	/** 打开系统文件选择，选择文件后返回路径。注意：由于Android11文件沙盒存储模式，尽量从侧边栏手机图标点击进去，从”最近“、“下载”等其他路径访问可能无法拿到文件真实路径。*/ 
	chooseLocalFiles(callback?: (ret:JSON, err:JSON) => void):void

}
interface readCard {
}
interface epub {
	/**
	 * `打开阅读器`
	 * ========params==========
	 *
	 * `path` :string : epub文件路径，支持fs,widget
	 *
	 * `bookId` :string : 文件存入本地的唯一标识，不同文件标识应为唯一，不同文件不可重复传入
	 *
	 * `currentChapter` :number : （可选项）打开书籍的章节数
	 *
	 * `bg` :string : （可选项）阅读器的背景，支持颜色（rgb，rgba，#）和图片（支持fs,widget）
	 *
	 * `textColor` :string : （可选项）阅读器显示文字颜色
	 *
	 * `textSize` :number : （可选项）阅读器显示文字字体大小
	 */
	open(params:epub_open_Params, callback?: (ret:JSON) => void):void

	/** 添加监听*/ 
	addEventListener():void

	/** 移除添加监听*/ 
	removeEventListener():void

	/**
	 * `设置阅读器的参数`
	 * ========params==========
	 *
	 * `bg` :string : （可选项）阅读器的背景色，支持颜色（rgb，rgba，#）和图片（支持fs,widget）
	 *
	 * `currentChapter` :number : （可选项）打开的章节数
	 *
	 * `textColor` :string : （可选项）文字颜色
	 *
	 * `textSize` :number : （可选项）文字字体大小。重新设置字体大小后，会重新分页，触发分页的事件
	 */
	setValue(params:epub_setValue_Params):void

	/**
	 * `打开指定章节`
	 * ========params==========
	 *
	 * `currentChapter` :number : （可选项）打开的章节数
	 */
	openChapter(params:epub_openChapter_Params):void

	/** 获取当前屏幕亮度值*/ 
	getBrightness():void

	/**
	 * `设置屏幕亮度`
	 * ========params==========
	 *
	 * `brightness` :number : 设置的屏幕的亮度，取值范围：0-100，**在 iOS 平台上设置的是系统屏幕亮度。Android 平台上设置的本应用内的屏幕亮度**
	 */
	setBrightness(params:epub_setBrightness_Params):void

	/**
	 * `根据进度跳转对应章节`
	 * ========params==========
	 *
	 * `progress` :number : 进度值（0-100），可为小数
	 */
	resetWithProgress(params:epub_resetWithProgress_Params):void

	/** 获取全部本地书籍*/ 
	getAllbooks():void

	/**
	 * `删除一本书籍`
	 * ========params==========
	 *
	 * `bookId` :any : 书记唯一标识符
	 */
	deleteBookWithBook(params:epub_deleteBookWithBook_Params):void

	/**
	 * ` 设置夜间模式`
	 * ========params==========
	 *
	 * `isNightMode` :boolean : 是否开启夜间模式
	 */
	setNightMode(params:epub_setNightMode_Params):void

	/** 关闭阅读器*/ 
	close():void

}
interface epub_open_Params {
	/**epub文件路径，支持fs,widget*/ 
	path:string,

	/**文件存入本地的唯一标识，不同文件标识应为唯一，不同文件不可重复传入*/ 
	bookId:string,

	/**（可选项）打开书籍的章节数*/ 
	currentChapter?:number,

	/**（可选项）阅读器的背景，支持颜色（rgb，rgba，#）和图片（支持fs,widget）*/ 
	bg?:string,

	/**（可选项）阅读器显示文字颜色*/ 
	textColor?:string,

	/**（可选项）阅读器显示文字字体大小*/ 
	textSize?:number,

}

interface epub_setValue_Params {
	/**（可选项）阅读器的背景色，支持颜色（rgb，rgba，#）和图片（支持fs,widget）*/ 
	bg?:string,

	/**（可选项）打开的章节数*/ 
	currentChapter?:number,

	/**（可选项）文字颜色*/ 
	textColor?:string,

	/**（可选项）文字字体大小。重新设置字体大小后，会重新分页，触发分页的事件*/ 
	textSize?:number,

}

interface epub_openChapter_Params {
	/**（可选项）打开的章节数*/ 
	currentChapter?:number,

}

interface epub_setBrightness_Params {
	/**设置的屏幕的亮度，取值范围：0-100，**在 iOS 平台上设置的是系统屏幕亮度。Android 平台上设置的本应用内的屏幕亮度***/ 
	brightness:number,

}

interface epub_resetWithProgress_Params {
	/**进度值（0-100），可为小数*/ 
	progress:number,

}

interface epub_deleteBookWithBook_Params {
	/**书记唯一标识符*/ 
	bookId:any,

}

interface epub_setNightMode_Params {
	/**是否开启夜间模式*/ 
	isNightMode:boolean,

}

interface checkpush {
}
interface fAppInfo {
	/** 获取版本信息*/ 
	getVersionInfo(callback?: (ret:JSON, err:JSON) => void):void

}
interface signature {
	/**
	 * `将字符串进行 AES 加密（加密模式和填充模式分别为：CBC/PKCS7Padding；初始iv为：{0xA,1,0xB,5,4,0xF,7,9,0x17,3,1,6,8,0xC,0xD,91}，加密等级位数：aes-256-cbc）`
	 * ========params==========
	 *
	 * `data` :string : 要加密的字符串
	 *
	 * `key` :string : aes 加密算法使用的 key
	 */
	aes(params:signature_aes_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `将字符串进行 AES 解密（加密模式和填充模式分别为：CBC/PKCS7Padding；初始iv为：{0xA,1,0xB,5,4,0xF,7,9,0x17,3,1,6,8,0xC,0xD,91}，加密等级位数：aes-256-cbc）`
	 * ========params==========
	 *
	 * `data` :string : 要解密的字符串
	 *
	 * `key` :string : aes 解密算法使用的 key
	 */
	aesDecode(params:signature_aesDecode_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取rsa密钥对, **此接口仅支持 Android 平台**`
	 * ========params==========
	 *
	 * `keyLength` :number : 秘钥长度（512~2048）
	 *
	 * `ret` :JSON : null
	 */
	rsaKeyPair(params:signature_rsaKeyPair_Params):void

	/**
	 * `rsa加密`
	 * ========params==========
	 *
	 * `data` :string : 要加密的字符串
	 *
	 * `publicKey` :string : 加密所需公钥，**注意：在android平台上直接传 encoded（字符串），在 iOS 平台上需传公钥文件（.der 格式）的地址路径（仅支持本地路径fs://、widget://）**
	 *
	 * `ret` :JSON : null
	 *
	 * `err` :JSON : null
	 */
	rsa(params:signature_rsa_Params):void

	/**
	 * `rsa解密`
	 * ========params==========
	 *
	 * `data` :string : 要解密的字符串
	 *
	 * `privateKey` :string : 解密所需私钥，**注意：在android平台上直接传私钥 encoded（字符串），在 iOS 平台上需传私钥文件（.p12 格式）的地址路径（仅支持本地路径fs://、widget://）**
	 *
	 * `password` :string : 使用 openssl 命令生成密钥对时所输入的私钥文件提取密码 **仅 iOS 平台需要**
	 *
	 * `ret` :JSON : null
	 *
	 * `err` :JSON : null
	 */
	rsaDecode(params:signature_rsaDecode_Params):void

	/**
	 * `将字符串进行 AES 加密（加密模式和填充模式分别为：ECB/PKCS7Padding；数据块：256位；字符集：utf8）`
	 * ========params==========
	 *
	 * `data` :string : 要加密的字符串
	 *
	 * `key` :string : aes 加密算法使用的 key
	 *
	 * `encoding` :number : 输出字符串的编码；0：base64，1：hex
	 */
	aesECB(params:signature_aesECB_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `将字符串进行 AES 解密（加密模式和填充模式分别为：ECB/PKCS7Padding；数据块：256位；字符集：utf8）`
	 * ========params==========
	 *
	 * `data` :string : 要解密的字符串
	 *
	 * `key` :string : aes 解密算法使用的 key
	 *
	 * `encoding` :number : 输入字符串的编码；本接口会先对要解密的内容进行一次此字段传入类型解码，需要和aesECB或aesECBSync接口传入一致；0：base64，1：hex
	 */
	aesDecodeECB(params:signature_aesDecodeECB_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `将字符串进行 DES 加密（加密模式和填充模式分别为：ECB/PKCS5Padding）`
	 * ========params==========
	 *
	 * `data` :string : 要加密的字符串
	 *
	 * `key` :string : des 加密算法使用的 key
	 */
	desECB(params:signature_desECB_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `将字符串进行 DES 解密（加密模式和填充模式分别为：ECB/PKCS5Padding）`
	 * ========params==========
	 *
	 * `data` :string : 要解密的字符串
	 *
	 * `key` :string : des 解密算法使用的 key
	 */
	desDecodeECB(params:signature_desDecodeECB_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `将字符串进行 AES 加密（加密模式和填充模式分别为：CBC/PKCS7Padding；加密等级位数：aes-128-cbc）`
	 * ========params==========
	 *
	 * `data` :string : 要加密的字符串
	 *
	 * `key` :string : aes 加密算法使用的 key
	 *
	 * `iv` :string : aes 加密算法使用的偏移量
	 */
	aesCBC(params:signature_aesCBC_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 将字符串进行 AES 解密（加密模式和填充模式分别为：CBC/PKCS7Padding；加密等级位数：aes-128-cbc）*/ 
	aesDecodeCBC():void

	/**
	 * `将文件进行 AES 加密解密（填充模式为：PKCS7Padding；加密等级位数：aes-256-cbc`
	 * ========params==========
	 *
	 * `action` :string : 指明加密解密功能
	 *
	 * `path` :string : 要加密/解密的文件地址，要求本地路径（fs://）
	 *
	 * `key` :string : aes 加密/解密算法使用的 key
	 *
	 * `iv` :string : aes 加密/解密算法使用的 iv
	 *
	 * `savePath` :string : （可选项）加密/解密后的文件保存路径，要求本地路径（fs://），
	 */
	aesFile(params:signature_aesFile_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `将字符串进行 AES 加密（本加密过程为同步），加密模式和填充模式分别为：CBC/PKCS7Padding；初始iv为：{0xA,1,0xB,5,4,0xF,7,9,0x17,3,1,6,8,0xC,0xD,91}；加密等级位数：aes-256-cbc`
	 * ========params==========
	 *
	 * `data` :string : 要加密的字符串
	 *
	 * `key` :string : aes 加密算法使用的 key
	 *
	 * `value` :string : 加密后的字符串
	 */
	aesSync(params:signature_aesSync_Params):void

	/**
	 * `将字符串进行 AES 解密（本解密过程为同步），加密模式和填充模式分别为：CBC/PKCS7Padding；初始iv为：{0xA,1,0xB,5,4,0xF,7,9,0x17,3,1,6,8,0xC,0xD,91}；加密等级位数：aes-256-cbc`
	 * ========params==========
	 *
	 * `data` :string : 要解密的字符串
	 *
	 * `key` :string : aes 解密算法使用的 key
	 *
	 * `value` :string : 解密后的字符串
	 */
	aesDecodeSync(params:signature_aesDecodeSync_Params):void

	/**
	 * `获取rsa密钥对（同步），**此接口仅支持 Android 平台**`
	 * ========params==========
	 *
	 * `keyLength` :number : 秘钥长度（512~2048）
	 *
	 * `ret` :JSON : null
	 */
	rsaKeyPairSync(params:signature_rsaKeyPairSync_Params):void

	/**
	 * `rsa加密 （本加密为同步）`
	 * ========params==========
	 *
	 * `data` :string : 要加密的字符串
	 *
	 * `publicKey` :string : 加密所需公钥，**注意：在android平台上直接传 encoded（字符串），在 iOS 平台上需传公钥文件（.der 格式）的地址路径（仅支持本地路径fs://、widget://）**
	 *
	 * `value` :string : 加密后的字符串
	 */
	rsaSync(params:signature_rsaSync_Params):void

	/**
	 * `rsa解密 (同步)`
	 * ========params==========
	 *
	 * `data` :string : 要解密的字符串
	 *
	 * `privateKey` :string : 解密所需私钥，**注意：在android平台上直接传私钥 encoded（字符串），在 iOS 平台上需传私钥文件（.p12 格式）的地址路径（仅支持本地路径fs://、widget://）**
	 *
	 * `password` :string : 使用 openssl 命令生成密钥对时所输入的私钥文件提取密码 **仅 iOS 平台需要**
	 *
	 * `value` :string : 解密后的字符串
	 */
	rsaDecodeSync(params:signature_rsaDecodeSync_Params):void

	/**
	 * `将字符串进行 AES 加密（本加密过程为同步），加密模式和填充模式分别为：ECB/PKCS7Padding；数据块：256位；字符集：utf8`
	 * ========params==========
	 *
	 * `data` :string : 要加密的字符串
	 *
	 * `key` :string : aes 加密算法使用的 key
	 *
	 * `encoding` :number : 输出字符串的编码；0：base64，1：hex
	 *
	 * `value` :string : 加密后的字符串
	 */
	aesECBSync(params:signature_aesECBSync_Params):void

	/**
	 * `将字符串进行 AES 解密（本解密过程为同步），加密模式和填充模式分别为：WCB/PKCS7Padding；数据块：256位；字符集：utf8`
	 * ========params==========
	 *
	 * `data` :string : 要解密的字符串
	 *
	 * `key` :string : aes 解密算法使用的 key
	 *
	 * `encoding` :number : 输入字符串的编码；本接口会先对要解密的内容进行一次此字段传入类型解码，需要和aesECB或aesECBSync接口传入一致；0：base64，1：hex
	 *
	 * `value` :string : 解密后的字符串
	 */
	aesDecodeECBSync(params:signature_aesDecodeECBSync_Params):void

	/**
	 * `将字符串进行 DES 加密（本加密过程为同步），加密模式和填充模式分别为：ECB/PKCS5Padding`
	 * ========params==========
	 *
	 * `data` :string : 要加密的字符串
	 *
	 * `key` :string : des 加密算法使用的 key
	 *
	 * `value` :string : 加密后的字符串
	 */
	desECBSync(params:signature_desECBSync_Params):void

	/**
	 * `将字符串进行 DES 解密（本解密过程为同步），加密模式和填充模式分别为：ECB/PKCS5Padding`
	 * ========params==========
	 *
	 * `data` :string : 要解密的字符串
	 *
	 * `key` :string : des 解密算法使用的 key
	 *
	 * `value` :string : 解密后的字符串
	 */
	desDecodeECBSync(params:signature_desDecodeECBSync_Params):void

	/**
	 * `将字符串进行 AES 加密（加密模式和填充模式分别为：CBC/PKCS7Padding；加密等级位数：aes-128-cbc）`
	 * ========params==========
	 *
	 * `data` :string : 要加密的字符串
	 *
	 * `key` :string : aes 加密算法使用的 key
	 *
	 * `iv` :string : aes 加密算法使用的偏移量
	 *
	 * `value` :string : 加密后的字符串
	 */
	aesCBCSync(params:signature_aesCBCSync_Params):void

	/** 将字符串进行 AES 解密（加密模式和填充模式分别为：CBC/PKCS7Padding；加密等级位数：aes-128-cbc）*/ 
	aesDecodeCBCSync():void

	/**
	 * `将文件进行 AES 加密解密（填充模式为：PKCS7Padding；加密等级位数：aes-256-cbc`
	 * ========params==========
	 *
	 * `action` :string : 指明加密解密功能
	 *
	 * `path` :string : 要加密/解密的文件地址，要求本地路径（fs://）
	 *
	 * `key` :string : aes 加密/解密算法使用的 key
	 *
	 * `iv` :string : aes 加密/解密算法使用的 iv
	 *
	 * `savePath` :string : （可选项）加密/解密后的文件保存路径，要求本地路径（fs://），
	 *
	 * `value` :string : AES 加密/解密后的文件绝对路径
	 */
	aesFileSync(params:signature_aesFileSync_Params):void

}
interface signature_aes_Params {
	/**要加密的字符串*/ 
	data:string,

	/**aes 加密算法使用的 key*/ 
	key:string,

}

interface signature_aesDecode_Params {
	/**要解密的字符串*/ 
	data:string,

	/**aes 解密算法使用的 key*/ 
	key:string,

}

interface signature_rsaKeyPair_Params {
	/**秘钥长度（512~2048）*/ 
	keyLength:number,

	/**null*/ 
	ret:JSON,

}

interface signature_rsa_Params {
	/**要加密的字符串*/ 
	data:string,

	/**加密所需公钥，**注意：在android平台上直接传 encoded（字符串），在 iOS 平台上需传公钥文件（.der 格式）的地址路径（仅支持本地路径fs://、widget://）***/ 
	publicKey:string,

	/**null*/ 
	ret:JSON,

	/**null*/ 
	err:JSON,

}

interface signature_rsaDecode_Params {
	/**要解密的字符串*/ 
	data:string,

	/**解密所需私钥，**注意：在android平台上直接传私钥 encoded（字符串），在 iOS 平台上需传私钥文件（.p12 格式）的地址路径（仅支持本地路径fs://、widget://）***/ 
	privateKey:string,

	/**使用 openssl 命令生成密钥对时所输入的私钥文件提取密码 **仅 iOS 平台需要***/ 
	password:string,

	/**null*/ 
	ret:JSON,

	/**null*/ 
	err:JSON,

}

interface signature_aesECB_Params {
	/**要加密的字符串*/ 
	data:string,

	/**aes 加密算法使用的 key*/ 
	key:string,

	/**输出字符串的编码；0：base64，1：hex*/ 
	encoding:number,

}

interface signature_aesDecodeECB_Params {
	/**要解密的字符串*/ 
	data:string,

	/**aes 解密算法使用的 key*/ 
	key:string,

	/**输入字符串的编码；本接口会先对要解密的内容进行一次此字段传入类型解码，需要和aesECB或aesECBSync接口传入一致；0：base64，1：hex*/ 
	encoding:number,

}

interface signature_desECB_Params {
	/**要加密的字符串*/ 
	data:string,

	/**des 加密算法使用的 key*/ 
	key:string,

}

interface signature_desDecodeECB_Params {
	/**要解密的字符串*/ 
	data:string,

	/**des 解密算法使用的 key*/ 
	key:string,

}

interface signature_aesCBC_Params {
	/**要加密的字符串*/ 
	data:string,

	/**aes 加密算法使用的 key*/ 
	key:string,

	/**aes 加密算法使用的偏移量*/ 
	iv:string,

}

interface signature_aesFile_Params {
	/**指明加密解密功能*/ 
	action:string,

	/**要加密/解密的文件地址，要求本地路径（fs://）*/ 
	path:string,

	/**aes 加密/解密算法使用的 key*/ 
	key:string,

	/**aes 加密/解密算法使用的 iv*/ 
	iv:string,

	/**（可选项）加密/解密后的文件保存路径，要求本地路径（fs://），*/ 
	savePath?:string,

}

interface signature_aesSync_Params {
	/**要加密的字符串*/ 
	data:string,

	/**aes 加密算法使用的 key*/ 
	key:string,

	/**加密后的字符串*/ 
	value:string,

}

interface signature_aesDecodeSync_Params {
	/**要解密的字符串*/ 
	data:string,

	/**aes 解密算法使用的 key*/ 
	key:string,

	/**解密后的字符串*/ 
	value:string,

}

interface signature_rsaKeyPairSync_Params {
	/**秘钥长度（512~2048）*/ 
	keyLength:number,

	/**null*/ 
	ret:JSON,

}

interface signature_rsaSync_Params {
	/**要加密的字符串*/ 
	data:string,

	/**加密所需公钥，**注意：在android平台上直接传 encoded（字符串），在 iOS 平台上需传公钥文件（.der 格式）的地址路径（仅支持本地路径fs://、widget://）***/ 
	publicKey:string,

	/**加密后的字符串*/ 
	value:string,

}

interface signature_rsaDecodeSync_Params {
	/**要解密的字符串*/ 
	data:string,

	/**解密所需私钥，**注意：在android平台上直接传私钥 encoded（字符串），在 iOS 平台上需传私钥文件（.p12 格式）的地址路径（仅支持本地路径fs://、widget://）***/ 
	privateKey:string,

	/**使用 openssl 命令生成密钥对时所输入的私钥文件提取密码 **仅 iOS 平台需要***/ 
	password:string,

	/**解密后的字符串*/ 
	value:string,

}

interface signature_aesECBSync_Params {
	/**要加密的字符串*/ 
	data:string,

	/**aes 加密算法使用的 key*/ 
	key:string,

	/**输出字符串的编码；0：base64，1：hex*/ 
	encoding:number,

	/**加密后的字符串*/ 
	value:string,

}

interface signature_aesDecodeECBSync_Params {
	/**要解密的字符串*/ 
	data:string,

	/**aes 解密算法使用的 key*/ 
	key:string,

	/**输入字符串的编码；本接口会先对要解密的内容进行一次此字段传入类型解码，需要和aesECB或aesECBSync接口传入一致；0：base64，1：hex*/ 
	encoding:number,

	/**解密后的字符串*/ 
	value:string,

}

interface signature_desECBSync_Params {
	/**要加密的字符串*/ 
	data:string,

	/**des 加密算法使用的 key*/ 
	key:string,

	/**加密后的字符串*/ 
	value:string,

}

interface signature_desDecodeECBSync_Params {
	/**要解密的字符串*/ 
	data:string,

	/**des 解密算法使用的 key*/ 
	key:string,

	/**解密后的字符串*/ 
	value:string,

}

interface signature_aesCBCSync_Params {
	/**要加密的字符串*/ 
	data:string,

	/**aes 加密算法使用的 key*/ 
	key:string,

	/**aes 加密算法使用的偏移量*/ 
	iv:string,

	/**加密后的字符串*/ 
	value:string,

}

interface signature_aesFileSync_Params {
	/**指明加密解密功能*/ 
	action:string,

	/**要加密/解密的文件地址，要求本地路径（fs://）*/ 
	path:string,

	/**aes 加密/解密算法使用的 key*/ 
	key:string,

	/**aes 加密/解密算法使用的 iv*/ 
	iv:string,

	/**（可选项）加密/解密后的文件保存路径，要求本地路径（fs://），*/ 
	savePath?:string,

	/**AES 加密/解密后的文件绝对路径*/ 
	value:string,

}

interface kmTimer {
	/**
	 * `启动定时器`
	 * ========params==========
	 *
	 * `event` :string : 允许自定义事件
	 *
	 * `delay` :any : 延迟执行时间（秒）
	 *
	 * `interval` :any : 循环执行间隔（秒），仅crycle=true有效
	 *
	 * `crycle` :boolean : 是否循环执行
	 */
	start(params:kmTimer_start_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `修改循环执行时间间隔`
	 * ========params==========
	 *
	 * `event` :string : 允许自定义事件
	 *
	 * `interval` :any : 循环执行间隔（秒），仅crycle=true有效
	 */
	setInterval(params:kmTimer_setInterval_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `关闭定时器`
	 * ========params==========
	 *
	 * `event` :string : 允许自定义事件。
	 */
	stop(params:kmTimer_stop_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface kmTimer_start_Params {
	/**允许自定义事件*/ 
	event:string,

	/**延迟执行时间（秒）*/ 
	delay:any,

	/**循环执行间隔（秒），仅crycle=true有效*/ 
	interval:any,

	/**是否循环执行*/ 
	crycle:boolean,

}

interface kmTimer_setInterval_Params {
	/**允许自定义事件*/ 
	event:string,

	/**循环执行间隔（秒），仅crycle=true有效*/ 
	interval:any,

}

interface kmTimer_stop_Params {
	/**允许自定义事件。*/ 
	event:string,

}

interface djyPrinter {
}
interface selectFile {
	/** 打开文件选择器*/ 
	open(callback?: (ret:JSON) => void):void

}
interface whjpdf {
	/** 打开pdf预览操作界面*/ 
	startActivity():void

}
interface codeLog {
	/** 创建指定类别的日志，并写入日志内容*/ 
	writeLog(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `查询日志列表，可以指定类别和时段等筛选条件。时段条件要精确到秒，查询时段为多天时，可以只传入日期。如查询2017年4月10日一天的，类别为info的日志，指定的筛选条件为：`
	 * ========params==========
	 *
	 * `tag` :string : （可选项）日志类别名称
	 *
	 * `startTime` :string : （可选项） 开始时间，日期格式为 yyyy-MM-dd HH:mm:ss或者yyyy-MM-dd
	 *
	 * `endTime` :string : （可选项） 结束时间，日期格式为 yyyy-MM-dd HH:mm:ss或者yyyy-MM-dd
	 */
	getLogList(params:codeLog_getLogList_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `批量删除指定时间段，指定类型日志。时段条件要精确到秒，查询时段为多天时，可以只传入日期。注意：删除后无法恢复，操作需谨慎。`
	 * ========params==========
	 *
	 * `tag` :string : （可选项）日志类型名称
	 *
	 * `startTime` :string : （可选项）开始时间，日期格式为 yyyy-MM-dd HH:mm:ss或者yyyy-MM-dd
	 *
	 * `endTime` :string : （可选项）结束时间，日期格式为 yyyy-MM-dd HH:mm:ss或者yyyy-MM-dd
	 */
	deleteLogs(params:codeLog_deleteLogs_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface codeLog_getLogList_Params {
	/**（可选项）日志类别名称*/ 
	tag?:string,

	/**（可选项） 开始时间，日期格式为 yyyy-MM-dd HH:mm:ss或者yyyy-MM-dd*/ 
	startTime?:string,

	/**（可选项） 结束时间，日期格式为 yyyy-MM-dd HH:mm:ss或者yyyy-MM-dd*/ 
	endTime?:string,

}

interface codeLog_deleteLogs_Params {
	/**（可选项）日志类型名称*/ 
	tag?:string,

	/**（可选项）开始时间，日期格式为 yyyy-MM-dd HH:mm:ss或者yyyy-MM-dd*/ 
	startTime?:string,

	/**（可选项）结束时间，日期格式为 yyyy-MM-dd HH:mm:ss或者yyyy-MM-dd*/ 
	endTime?:string,

}

interface androidTTS {
	/**
	 * `初始化`
	 * ========params==========
	 *
	 * `language` :string : （可选项）支持语言
	 */
	init(params:androidTTS_init_Params, callback?: (ret:JSON) => void):void

	/**
	 * `朗读`
	 * ========params==========
	 *
	 * `text` :string : （可选项）文本
	 */
	speak(params:androidTTS_speak_Params):void

	/** 停止朗读*/ 
	stop():void

	/** 关闭释放资源*/ 
	shutdown():void

}
interface androidTTS_init_Params {
	/**（可选项）支持语言*/ 
	language?:string,

}

interface androidTTS_speak_Params {
	/**（可选项）文本*/ 
	text?:string,

}

interface xpCheck {
	/** 检查本机是否装了xposed框架。*/ 
	check():void

}
interface inShare {
	/**
	 * `分享多张图片到其他应用（要求用户有安装该应用并且已登录账户，才可分享成功）`
	 * ========params==========
	 *
	 * `imgPaths` :string : 要分享的图片的路径由“,”(逗号)分隔组成的字符串；要求本地路径,相对路径如：fs://、cache://，绝对路径如：var/mobile/Containers/Data/Application/...
	 *
	 * `sendPattern` :string : （可选项）分享打开其他应用的模式
	 *
	 * `app` :string : （可选项）模块提供了几个常用的分享应用。若本参数不为空则模块忽略 packageName 和 activityName 参数。
	 *
	 * `packageName` :string : （app 参数为空时 必需）分享应用的 包名（android）/bundleId（ios）。
	 *
	 * `activityName` :string : （可选项）指定分享到应用的具体页面，比如 分享到"QQ好友"。当 sendPattern 参数为“ONLY”,而 app 参数为空时 必需传该参数。**仅Android有效**
	 *
	 * `description` :string : （可选项）对分享的描述，只在个别情况下有效，比如：分享图片到“微信朋友圈”时。
	 *
	 * `dialogTitle` :string : （可选项）设置分享选择列表的标题，当sendPattern 不为“ONLY”时有用，若不设置该参数 则用户在“始终”和“仅此一次”的方式中选择始终分享应用后，再次分享时将直接分享到上次已经选择的应用。**仅Android有效，且部分机型不支持**（如 华为Honor 6A）
	 *
	 * `forResult` :boolean : （可选项）是否采用startActivityForResult的方式打开其他应用（采用该方式打开分享完成后会在回调的ret 中返回resultCode值）。**仅Android有效**
	 *
	 * `imgSetType` :any : （可选项）用于设置图片的添加方式。**仅ios有效**
	 *
	 * `needDecodePath` :boolean : （可选项）是否将图片路径转换为绝对路径，当所传 imgPaths 参数为类似“fs://cache/xx.png”的相对路径时，须设置为true。**仅ios有效**
	 */
	shareImgsTo(params:inShare_shareImgsTo_Params, callback?: (ret:JSON) => void):void

	/**
	 * `主要用于分享文本内容到其他应用（要求用户有安装该应用并且已登录账户，才可分享成功）`
	 * ========params==========
	 *
	 * `content` :string : 要分享的文本内容。
	 *
	 * `urlScheme` :string : （可选项）当 sendPattern 参数为“ONLY” 时，ios 通过urlScheme去打开应用（只是打开应用 不做分享操作，可以事先将分享内容复制到系统剪切板让用户自己粘贴）。**仅ios有效**
	 *
	 * `sendPattern` :string : （可选项）分享打开其他应用的模式
	 *
	 * `app` :string : （可选项）模块提供了几个常用的分享应用。若本参数不为空则模块忽略 packageName activityName 和 urlScheme参数。
	 *
	 * `packageName` :string : （app 参数为空时 必需）分享应用的 包名（android）/bundleId（ios）。
	 *
	 * `activityName` :string : （可选项）指定分享到应用的具体页面，比如 分享到"QQ好友"。当 sendPattern 参数为“ONLY”,而 app 参数为空时 必需传该参数。**仅Android有效**
	 *
	 * `dialogTitle` :string : （可选项）设置分享选择列表的标题，当sendPattern 不为“ONLY”时有用，若不设置该参数 则用户在“始终”和“仅此一次”的方式中选择始终分享应用后，再次分享时将直接分享到上次已经选择的应用。**仅Android有效，且部分机型不支持**（如 华为Honor 6A）
	 *
	 * `forResult` :boolean : （可选项）是否采用startActivityForResult的方式打开其他应用（采用该方式打开分享完成后会在回调的ret 中返回resultCode值）。**仅Android有效**
	 */
	shareTextTo(params:inShare_shareTextTo_Params, callback?: (ret:JSON) => void):void

	/**
	 * `用于**Android**手机中获取当前已安装的支持多图/文本分享的应用信息（包名/支持分享类型的页面类路径）`
	 * ========params==========
	 *
	 * `type` :string : 支持类型
	 */
	getSupportedApp(params:inShare_getSupportedApp_Params, callback?: (ret:JSON) => void):void

}
interface inShare_shareImgsTo_Params {
	/**要分享的图片的路径由“,”(逗号)分隔组成的字符串；要求本地路径,相对路径如：fs://、cache://，绝对路径如：var/mobile/Containers/Data/Application/...*/ 
	imgPaths:string,

	/**（可选项）分享打开其他应用的模式*/ 
	sendPattern?:string,

	/**（可选项）模块提供了几个常用的分享应用。若本参数不为空则模块忽略 packageName 和 activityName 参数。*/ 
	app?:string,

	/**（app 参数为空时 必需）分享应用的 包名（android）/bundleId（ios）。*/ 
	packageName:string,

	/**（可选项）指定分享到应用的具体页面，比如 分享到"QQ好友"。当 sendPattern 参数为“ONLY”,而 app 参数为空时 必需传该参数。**仅Android有效***/ 
	activityName?:string,

	/**（可选项）对分享的描述，只在个别情况下有效，比如：分享图片到“微信朋友圈”时。*/ 
	description?:string,

	/**（可选项）设置分享选择列表的标题，当sendPattern 不为“ONLY”时有用，若不设置该参数 则用户在“始终”和“仅此一次”的方式中选择始终分享应用后，再次分享时将直接分享到上次已经选择的应用。**仅Android有效，且部分机型不支持**（如 华为Honor 6A）*/ 
	dialogTitle?:string,

	/**（可选项）是否采用startActivityForResult的方式打开其他应用（采用该方式打开分享完成后会在回调的ret 中返回resultCode值）。**仅Android有效***/ 
	forResult?:boolean,

	/**（可选项）用于设置图片的添加方式。**仅ios有效***/ 
	imgSetType?:any,

	/**（可选项）是否将图片路径转换为绝对路径，当所传 imgPaths 参数为类似“fs://cache/xx.png”的相对路径时，须设置为true。**仅ios有效***/ 
	needDecodePath?:boolean,

}

interface inShare_shareTextTo_Params {
	/**要分享的文本内容。*/ 
	content:string,

	/**（可选项）当 sendPattern 参数为“ONLY” 时，ios 通过urlScheme去打开应用（只是打开应用 不做分享操作，可以事先将分享内容复制到系统剪切板让用户自己粘贴）。**仅ios有效***/ 
	urlScheme?:string,

	/**（可选项）分享打开其他应用的模式*/ 
	sendPattern?:string,

	/**（可选项）模块提供了几个常用的分享应用。若本参数不为空则模块忽略 packageName activityName 和 urlScheme参数。*/ 
	app?:string,

	/**（app 参数为空时 必需）分享应用的 包名（android）/bundleId（ios）。*/ 
	packageName:string,

	/**（可选项）指定分享到应用的具体页面，比如 分享到"QQ好友"。当 sendPattern 参数为“ONLY”,而 app 参数为空时 必需传该参数。**仅Android有效***/ 
	activityName?:string,

	/**（可选项）设置分享选择列表的标题，当sendPattern 不为“ONLY”时有用，若不设置该参数 则用户在“始终”和“仅此一次”的方式中选择始终分享应用后，再次分享时将直接分享到上次已经选择的应用。**仅Android有效，且部分机型不支持**（如 华为Honor 6A）*/ 
	dialogTitle?:string,

	/**（可选项）是否采用startActivityForResult的方式打开其他应用（采用该方式打开分享完成后会在回调的ret 中返回resultCode值）。**仅Android有效***/ 
	forResult?:boolean,

}

interface inShare_getSupportedApp_Params {
	/**支持类型*/ 
	type:string,

}

interface setJump {
	/** 打开对应设置页面*/ 
	open():void

	/** 是否开启推送通知*/ 
	isUserNotificationEnable():void

}
interface brightness {
}
interface ScreenWake {
	/** 唤醒点亮屏幕。*/ 
	addScreenWake():void

}
interface recordForMP3 {
	/** 查看是否有麦克风访问权限（仅ios支持, android 调用api.hasPermission()进行判断）*/ 
	getAuthorizationStatus():void

	/** 请求访问麦克风权限 （仅ios支持；android调用 api.requestPermission()去请求权限）*/ 
	requestAuthorization():void

	/**
	 * `开始录音`
	 * ========params==========
	 *
	 * `channel` :number : （可选项）声道支持
	 *
	 * `sampleRates` :number : （可选项）采样率
	 *
	 * `format` :string : （可选项）录制的音频格式 (Android 不支持该参数)
	 *
	 * `savePath` :string : 保存路径 （仅支持 fs://，box://, 注意：android 11后fs://路径访问受限，建议使用box://路径）
	 */
	startRecord(params:recordForMP3_startRecord_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 获取当前/实时音量*/ 
	getVolume():void

	/** 添加音量监听者*/ 
	addVolumeListener():void

	/** 恢复录音，暂仅支持iOS端*/ 
	resumeRecord():void

	/** 暂停录音，仅支持 iOS 端*/ 
	pauseRecord():void

	/** 停止录音*/ 
	stopRecord():void

	/**
	 * `获取文件属性（文件大小和音频时长）`
	 * ========params==========
	 *
	 * `path` :string : 音频的路径 （仅支持 fs://）
	 */
	getAttr(params:recordForMP3_getAttr_Params, callback?: (ret:JSON) => void):void

	/**
	 * `清除缓存目录`
	 * ========params==========
	 *
	 * `path` :string : 缓存目录
	 */
	clearCache(params:recordForMP3_clearCache_Params):void

}
interface recordForMP3_startRecord_Params {
	/**（可选项）声道支持*/ 
	channel?:number,

	/**（可选项）采样率*/ 
	sampleRates?:number,

	/**（可选项）录制的音频格式 (Android 不支持该参数)*/ 
	format?:string,

	/**保存路径 （仅支持 fs://，box://, 注意：android 11后fs://路径访问受限，建议使用box://路径）*/ 
	savePath:string,

}

interface recordForMP3_getAttr_Params {
	/**音频的路径 （仅支持 fs://）*/ 
	path:string,

}

interface recordForMP3_clearCache_Params {
	/**缓存目录*/ 
	path:string,

}

interface gifTools {
	/**
	 * `装截取视频生成GIF动图`
	 * ========params==========
	 *
	 * `length` :number : （可选项）截取视频的长度
	 *
	 * `ret` :JSON : null
	 */
	videoToGif(params:gifTools_videoToGif_Params):void

}
interface gifTools_videoToGif_Params {
	/**（可选项）截取视频的长度*/ 
	length?:number,

	/**null*/ 
	ret:JSON,

}

interface getWebUrl {
	/** 获取当前页链接的Url和标题Title*/ 
	addListener(callback?: (ret:JSON, err:JSON) => void):void

}
interface ftpRequest {
	/** 获取制定路径的目录*/ 
	getCatalog(callback?: (ret:JSON, err:JSON) => void):void

	/** 获取制定路径的目录*/ 
	download(callback?: (ret:JSON, err:JSON) => void):void

	/** 上传文件*/ 
	upload(callback?: (ret:JSON, err:JSON) => void):void

	/** 创建目录，仅支持创建文件夹*/ 
	createFolder(callback?: (ret:JSON, err:JSON) => void):void

	/** 删除目录文件*/ 
	destoryResource(callback?: (ret:JSON, err:JSON) => void):void

}
interface drawingBoard {
	/**
	 * `打开签名画板`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）签名画板的位置及尺寸
	 *
	 * `styles` :JSON : 画板画笔样式配置
	 *
	 * `fixedOn` :string : （可选项）签名画板添加到指定 frame 的名字（只指 frame，传 window 无效）
	 */
	open(params:drawingBoard_open_Params):void

	/**
	 * `保存签名画板截图，**截图大小（宽高：w、h）同 open 时传入的 rect 大小（宽高：w、h）**`
	 * ========params==========
	 *
	 * `savePath` :string : 保存图片路径，要求本地路径（fs://），**iOS 平台不支持 widget 路径**
	 *
	 * `copyToAlbum` :boolean : （可选项）是否将结果同时保存到系统相册
	 *
	 * `overlay` :boolean : （可选项）保存图片时，是否将背景一起保存
	 */
	save(params:drawingBoard_save_Params, callback?: (ret:JSON) => void):void

	/** 关闭签名画板*/ 
	close():void

	/** 隐藏签名画板*/ 
	hide():void

	/** 显示已隐藏的签名画板*/ 
	show():void

	/** 撤销最新画出的笔画线条*/ 
	revoke():void

	/** 恢复刚撤销的笔画线条*/ 
	restore():void

	/** 清空画板上的所有笔画线条*/ 
	clear():void

	/**
	 * `重设画笔样式`
	 * ========params==========
	 *
	 * `color` :string : （可选项）画笔颜色，支持#、rgb、rgba
	 *
	 * `width` :number : 画笔粗细
	 */
	resetBrush(params:drawingBoard_resetBrush_Params):void

}
interface drawingBoard_open_Params {
	/**（可选项）签名画板的位置及尺寸*/ 
	rect?:JSON,

	/**画板画笔样式配置*/ 
	styles:JSON,

	/**（可选项）签名画板添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

}

interface drawingBoard_save_Params {
	/**保存图片路径，要求本地路径（fs://），**iOS 平台不支持 widget 路径***/ 
	savePath:string,

	/**（可选项）是否将结果同时保存到系统相册*/ 
	copyToAlbum?:boolean,

	/**（可选项）保存图片时，是否将背景一起保存*/ 
	overlay?:boolean,

}

interface drawingBoard_resetBrush_Params {
	/**（可选项）画笔颜色，支持#、rgb、rgba*/ 
	color?:string,

	/**画笔粗细*/ 
	width:number,

}

interface oxSocket {
	/** 监听接口*/ 
	addEventListener():void

	/** socket 开启连接*/ 
	open():void

	/** socket 发送消息*/ 
	send():void

	/** socket 关闭*/ 
	close():void

	/** socket 状态获取*/ 
	getState():void

}
interface imageSelect {
}
interface volcWebImage {
	/** 异步打开图片。使用前必须在`config.xml`中配置appID。appID的获取方法见[火山引擎官网控制台](https://zjsms.com/eJJ6k1G/)*/ 
	openPicture():void

	/** 同步打开图片。使用前必须在`config.xml`中配置appID。配置方法见文档描述。*/ 
	openPictureSync():void

	/**
	 * `判断一张图片是否打开`
	 * ========params==========
	 *
	 * `pictureID` :string : 打开图片时获得的图片句柄
	 */
	isOpen(params:volcWebImage_isOpen_Params, callback?: (ret:JSON) => void):void

	/**
	 * `打开图片的同步方法`
	 * ========params==========
	 *
	 * `pictureID` :string : 打开图片时获得的图片句柄
	 */
	isOpenSync(params:volcWebImage_isOpenSync_Params):void

	/**
	 * `关闭图片`
	 * ========params==========
	 *
	 * `pictureID` :string : 打开图片时获得的图片句柄
	 */
	closePicture(params:volcWebImage_closePicture_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `关闭图片的同步方法`
	 * ========params==========
	 *
	 * `pictureID` :JSON : 打开图片时获得的图片句柄
	 */
	closePictureSync(params:volcWebImage_closePictureSync_Params):void

	/** 关闭所有已打开的图片*/ 
	closeAllPictures():void

	/** 关闭所有已打开的图片的同步方法*/ 
	closeAllPicturesSync():void

	/** 获取已打开图片的数量的同步方法*/ 
	numOfOpenedPictureSync():void

}
interface volcWebImage_isOpen_Params {
	/**打开图片时获得的图片句柄*/ 
	pictureID:string,

}

interface volcWebImage_isOpenSync_Params {
	/**打开图片时获得的图片句柄*/ 
	pictureID:string,

}

interface volcWebImage_closePicture_Params {
	/**打开图片时获得的图片句柄*/ 
	pictureID:string,

}

interface volcWebImage_closePictureSync_Params {
	/**打开图片时获得的图片句柄*/ 
	pictureID:JSON,

}

interface m3u8CacheServer {
	/** m3u8视频下载进度监听事件*/ 
	addEventListener():void

	/**
	 * `开始下载`
	 * ========params==========
	 *
	 * `url` :string : （必填项）M3U8下载地址，该地址必须为可解析的地址。不能是直播地址，请开发者自行控制。
	 *
	 * `threadCount` :number : （可选项）ts分片下载线程池最大线程数。
	 *
	 * `headers` :JSON : （可选项）设置ts下载时候的header。
	 */
	start(params:m3u8CacheServer_start_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `暂停下载`
	 * ========params==========
	 *
	 * `url` :string : （必填项）M3U8下载地址，该地址必须为可解析的地址。不能是直播地址，请开发者自行控制。
	 */
	pause(params:m3u8CacheServer_pause_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `是否下载完成`
	 * ========params==========
	 *
	 * `url` :string : （必填项）M3U8下载地址，该地址必须为可解析的地址。不能是直播地址，请开发者自行控制。
	 */
	isDownloadFinish(params:m3u8CacheServer_isDownloadFinish_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取缓存大小`
	 * ========params==========
	 *
	 * `url` :string : （可选项）M3U8下载地址，不传该值则获取所有m3u8缓存的大小。
	 */
	getCacheSize(params:m3u8CacheServer_getCacheSize_Params, callback?: (ret:JSON) => void):void

	/**
	 * `清除缓存文件`
	 * ========params==========
	 *
	 * `url` :string : （可选项）M3U8下载地址，不传该值则清除所有m3u8缓存。
	 */
	clearCache(params:m3u8CacheServer_clearCache_Params, callback?: (ret:JSON) => void):void

	/**
	 * `开启本地服务(可以多次执行，需要在合适的时机执行，保证服务不会挂掉)`
	 * ========params==========
	 *
	 * `port` :number : （可选项）端口。
	 */
	startServer(params:m3u8CacheServer_startServer_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface m3u8CacheServer_start_Params {
	/**（必填项）M3U8下载地址，该地址必须为可解析的地址。不能是直播地址，请开发者自行控制。*/ 
	url:string,

	/**（可选项）ts分片下载线程池最大线程数。*/ 
	threadCount?:number,

	/**（可选项）设置ts下载时候的header。*/ 
	headers?:JSON,

}

interface m3u8CacheServer_pause_Params {
	/**（必填项）M3U8下载地址，该地址必须为可解析的地址。不能是直播地址，请开发者自行控制。*/ 
	url:string,

}

interface m3u8CacheServer_isDownloadFinish_Params {
	/**（必填项）M3U8下载地址，该地址必须为可解析的地址。不能是直播地址，请开发者自行控制。*/ 
	url:string,

}

interface m3u8CacheServer_getCacheSize_Params {
	/**（可选项）M3U8下载地址，不传该值则获取所有m3u8缓存的大小。*/ 
	url?:string,

}

interface m3u8CacheServer_clearCache_Params {
	/**（可选项）M3U8下载地址，不传该值则清除所有m3u8缓存。*/ 
	url?:string,

}

interface m3u8CacheServer_startServer_Params {
	/**（可选项）端口。*/ 
	port?:number,

}

interface floatWebView {
	/**
	 * `创建一个悬浮窗，悬浮窗为一个html网页，该网页有一个floatWebView的对象，包含了功能相同的show，hide，remove，offset，size，noTouch，noLimit，center，canFocus，followTouch，stickSide方法，以及event方法用于和APP交互`
	 * ========params==========
	 *
	 * `name` :string : 悬浮窗的名字
	 *
	 * `url` :string : 悬浮窗html地址，支持http:// 和 widget:// 路径
	 *
	 * `w` :any : （可选项）悬浮窗的宽度
	 *
	 * `h` :any : （可选项）悬浮窗的高度
	 *
	 * `x` :any : （可选项）悬浮窗坐标x方向偏移量
	 *
	 * `y` :any : （可选项）悬浮窗坐标y方向偏移量
	 *
	 * `noTouch` :boolean : （可选项）悬浮窗不可触摸，不能拦截触摸事件
	 *
	 * `noLimit` :boolean : （可选项）悬浮窗不限制在屏幕内
	 *
	 * `center` :boolean : （可选项）悬浮窗居中，默认为false，也就是悬浮窗在左上方
	 *
	 * `followTouch` :boolean : （可选项）悬浮窗是否跟随触摸控制移动
	 *
	 * `stickSide` :boolean : （可选项）悬浮窗是否需要自动贴边，只有在followTouch为true是生效
	 */
	create(params:floatWebView_create_Params, callback?: (ret:JSON) => void):void

	/**
	 * `悬浮窗内执行js代码，效果类似于js的eval方法`
	 * ========params==========
	 *
	 * `name` :string : 需要js代码的悬浮窗的名字
	 *
	 * `jsstring` :string : 需要执行的js代码
	 */
	eval(params:floatWebView_eval_Params):void

	/**
	 * `显示悬浮窗，悬浮窗创建后默认是显示的`
	 * ========params==========
	 *
	 * `name` :string : 需要显示的悬浮窗的名字
	 */
	show(params:floatWebView_show_Params):void

	/**
	 * `隐藏指定悬浮窗`
	 * ========params==========
	 *
	 * `name` :string : 需要隐藏的悬浮窗的名字
	 */
	hide(params:floatWebView_hide_Params):void

	/**
	 * `移除指定悬浮窗`
	 * ========params==========
	 *
	 * `name` :string : 需要移除的悬浮窗的名字
	 */
	remove(params:floatWebView_remove_Params):void

	/**
	 * `设置指定悬浮窗的偏移量`
	 * ========params==========
	 *
	 * `name` :string : 悬浮窗的名字
	 *
	 * `x` :any : 悬浮窗坐标x方向偏移量
	 *
	 * `y` :any : 悬浮窗坐标y方向偏移量
	 */
	offset(params:floatWebView_offset_Params):void

	/**
	 * `设置指定悬浮窗的大小`
	 * ========params==========
	 *
	 * `name` :string : 悬浮窗的名字
	 *
	 * `w` :any : （悬浮窗的宽度
	 *
	 * `h` :any : 悬浮窗的高度
	 */
	size(params:floatWebView_size_Params):void

	/**
	 * `设置指定悬浮窗是否无法触摸`
	 * ========params==========
	 *
	 * `name` :string : 悬浮窗的名字
	 *
	 * `noTouch` :boolean : （可选项）是否无法触摸
	 */
	noTouch(params:floatWebView_noTouch_Params):void

	/**
	 * `设置指定悬浮窗是否可以显示到屏幕外`
	 * ========params==========
	 *
	 * `name` :string : 悬浮窗的名字
	 *
	 * `noLimit` :boolean : （可选项）是否可以显示到屏幕外
	 */
	noLimit(params:floatWebView_noLimit_Params):void

	/**
	 * `设置指定悬浮窗是否居中`
	 * ========params==========
	 *
	 * `name` :string : 悬浮窗的名字
	 *
	 * `center` :boolean : （可选项）是否居中，如果为true，会重置偏移量offset为{x:0,y:0}
	 */
	center(params:floatWebView_center_Params):void

	/**
	 * `设置指定悬浮窗是否可获得焦点，通常获取焦点后，悬浮窗可以和软键盘发生交互，但被覆盖的应用会失去焦点，具体表现例如：游戏将失去背景音乐`
	 * ========params==========
	 *
	 * `name` :string : 悬浮窗的名字
	 *
	 * `canFocus` :boolean : （可选项）是否可获取焦点
	 */
	canFocus(params:floatWebView_canFocus_Params):void

	/**
	 * `设置指定悬浮窗是否跟随触摸移动`
	 * ========params==========
	 *
	 * `name` :string : 悬浮窗的名字
	 *
	 * `followTouch` :boolean : （可选项）是否跟随触摸移动
	 */
	followTouch(params:floatWebView_followTouch_Params):void

	/**
	 * `设置指定悬浮窗是否自动贴边，近在会跟随触摸移动时生效`
	 * ========params==========
	 *
	 * `name` :string : 悬浮窗的名字
	 *
	 * `stickSide` :boolean : （可选项）是否自动贴边
	 */
	stickSide(params:floatWebView_stickSide_Params):void

	/** 悬浮窗给APP发送事件，用于和APP进行交互行为*/ 
	event():void

}
interface floatWebView_create_Params {
	/**悬浮窗的名字*/ 
	name:string,

	/**悬浮窗html地址，支持http:// 和 widget:// 路径*/ 
	url:string,

	/**（可选项）悬浮窗的宽度*/ 
	w?:any,

	/**（可选项）悬浮窗的高度*/ 
	h?:any,

	/**（可选项）悬浮窗坐标x方向偏移量*/ 
	x?:any,

	/**（可选项）悬浮窗坐标y方向偏移量*/ 
	y?:any,

	/**（可选项）悬浮窗不可触摸，不能拦截触摸事件*/ 
	noTouch?:boolean,

	/**（可选项）悬浮窗不限制在屏幕内*/ 
	noLimit?:boolean,

	/**（可选项）悬浮窗居中，默认为false，也就是悬浮窗在左上方*/ 
	center?:boolean,

	/**（可选项）悬浮窗是否跟随触摸控制移动*/ 
	followTouch?:boolean,

	/**（可选项）悬浮窗是否需要自动贴边，只有在followTouch为true是生效*/ 
	stickSide?:boolean,

}

interface floatWebView_eval_Params {
	/**需要js代码的悬浮窗的名字*/ 
	name:string,

	/**需要执行的js代码*/ 
	jsstring:string,

}

interface floatWebView_show_Params {
	/**需要显示的悬浮窗的名字*/ 
	name:string,

}

interface floatWebView_hide_Params {
	/**需要隐藏的悬浮窗的名字*/ 
	name:string,

}

interface floatWebView_remove_Params {
	/**需要移除的悬浮窗的名字*/ 
	name:string,

}

interface floatWebView_offset_Params {
	/**悬浮窗的名字*/ 
	name:string,

	/**悬浮窗坐标x方向偏移量*/ 
	x:any,

	/**悬浮窗坐标y方向偏移量*/ 
	y:any,

}

interface floatWebView_size_Params {
	/**悬浮窗的名字*/ 
	name:string,

	/**（悬浮窗的宽度*/ 
	w:any,

	/**悬浮窗的高度*/ 
	h:any,

}

interface floatWebView_noTouch_Params {
	/**悬浮窗的名字*/ 
	name:string,

	/**（可选项）是否无法触摸*/ 
	noTouch?:boolean,

}

interface floatWebView_noLimit_Params {
	/**悬浮窗的名字*/ 
	name:string,

	/**（可选项）是否可以显示到屏幕外*/ 
	noLimit?:boolean,

}

interface floatWebView_center_Params {
	/**悬浮窗的名字*/ 
	name:string,

	/**（可选项）是否居中，如果为true，会重置偏移量offset为{x:0,y:0}*/ 
	center?:boolean,

}

interface floatWebView_canFocus_Params {
	/**悬浮窗的名字*/ 
	name:string,

	/**（可选项）是否可获取焦点*/ 
	canFocus?:boolean,

}

interface floatWebView_followTouch_Params {
	/**悬浮窗的名字*/ 
	name:string,

	/**（可选项）是否跟随触摸移动*/ 
	followTouch?:boolean,

}

interface floatWebView_stickSide_Params {
	/**悬浮窗的名字*/ 
	name:string,

	/**（可选项）是否自动贴边*/ 
	stickSide?:boolean,

}

interface headphone {
	/** 设置耳机插拔事件监听者*/ 
	addHeadphonePluggedListener(callback?: (ret:JSON) => void):void

	/**
	 * `设置音量`
	 * ========params==========
	 *
	 * `volume` :number : （可选项）音量大小，取值范围：0-1
	 *
	 * `type` :string : （可选项）音量类型 （**在 iOS 平台本参数无效**）
	 */
	setVolume(params:headphone_setVolume_Params):void

	/**
	 * `获取当前音量`
	 * ========params==========
	 *
	 * `type` :string : （可选项）音量类型 （**在 iOS 平台本参数无效**）
	 */
	getVolume(params:headphone_getVolume_Params, callback?: (ret:JSON) => void):void

}
interface headphone_setVolume_Params {
	/**（可选项）音量大小，取值范围：0-1*/ 
	volume?:number,

	/**（可选项）音量类型 （**在 iOS 平台本参数无效**）*/ 
	type?:string,

}

interface headphone_getVolume_Params {
	/**（可选项）音量类型 （**在 iOS 平台本参数无效**）*/ 
	type?:string,

}

interface floatNowTimer {
	/** 隐藏时钟视图*/ 
	hideTimeView(callback?: (ret:JSON, err:JSON) => void):void

	/** 显示时钟视图*/ 
	showTimeView(callback?: (ret:JSON, err:JSON) => void):void

	/** 关闭时钟视图*/ 
	closeTimeView(callback?: (ret:JSON, err:JSON) => void):void

	/** 时钟进入悬浮状态*/ 
	startPIP():void

	/** 时钟退出悬浮状态*/ 
	stopPIP():void

	/**
	 * `更新时钟样式`
	 * ========params==========
	 *
	 * `backgroundColor` :string : 悬浮按钮背景色
	 *
	 * `textFontColor` :string : 时钟文字颜色
	 *
	 * `textFontSize` :JSON : 时钟文字大小
	 */
	updateStyle(params:floatNowTimer_updateStyle_Params):void

}
interface floatNowTimer_updateStyle_Params {
	/**悬浮按钮背景色*/ 
	backgroundColor:string,

	/**时钟文字颜色*/ 
	textFontColor:string,

	/**时钟文字大小*/ 
	textFontSize:JSON,

}

interface baiduBos {
	/**
	 * `上传分块文件`
	 * ========params==========
	 *
	 * `accessKey` :string : （必填项）在百度云申请的accessKey。[见：安全认证 / Access Key]
	 *
	 * `secretAccessKey` :string : （必填项）在百度云申请的secretAccessKey。[见：安全认证 / Access Key]
	 *
	 * `endpointBos` :string : （必填项）百度云Bucket节点地址[见：BJ bj.bcebos.com | GZ hk-2.bcebos.com | SU su.bcebos.com]
	 *
	 * `token` :string : （可选项）STS 方式实现移动端的鉴权，STS的详细介绍请参考[临时授权访问](https://cloud.baidu.com/doc/BOS/API.html#.E4.B8.B4.E6.97.B6.E6.8E.88.E6.9D.83.E8.AE.BF.E9.97.AE)
	 *
	 * `bucketName` :string : （必填项）在百度bos申请的bucketName
	 *
	 * `url` :string : （必填项）上传文件本地路径。[支持fs:// widget://]。
	 *
	 * `objectKey` :string : （必填项）存储到Bucket的路径及文件名称。
	 *
	 * `maxConnections` :number : （可选项）最大连接数
	 *
	 * `connectionTimeoutInMillis` :number : （可选项）连接超时事件
	 *
	 * `socketTimeoutInMillis` :number : （可选项）socket连接超时时间
	 *
	 * `contentType` :string : （可选项）Content-Type
	 *
	 * `uploadId` :string : （可选项）上一次的上传id，用于断点续传。
	 */
	uploadPart(params:baiduBos_uploadPart_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取所有已上传的分块信息`
	 * ========params==========
	 *
	 * `accessKey` :string : （必填项）在百度云申请的accessKey。[见：安全认证 / Access Key]
	 *
	 * `secretAccessKey` :string : （必填项）在百度云申请的secretAccessKey。[见：安全认证 / Access Key]
	 *
	 * `endpointBos` :string : （必填项）百度云Bucket节点地址[见：BJ bj.bcebos.com | GZ hk-2.bcebos.com | SU su.bcebos.com]
	 *
	 * `token` :string : （可选项）STS 方式实现移动端的鉴权，STS的详细介绍请参考[临时授权访问](https://cloud.baidu.com/doc/BOS/API.html#.E4.B8.B4.E6.97.B6.E6.8E.88.E6.9D.83.E8.AE.BF.E9.97.AE)
	 *
	 * `bucketName` :string : （必填项）在百度bos申请的bucketName
	 *
	 * `objectKey` :string : （必填项）存储到Bucket的路径及文件名称。
	 *
	 * `maxParts` :number : （可选项）每次获取最大分块上传事件的数目
	 *
	 * `partNumberMarker` :number : （可选项）若想获取更多已上传的分块信息，可以使用PartNumberMarker参数分次读取
	 *
	 * `uploadId` :string : （可选项）上传id。
	 */
	listParts(params:baiduBos_listParts_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `取消分块上传`
	 * ========params==========
	 *
	 * `accessKey` :string : （必填项）在百度云申请的accessKey。[见：安全认证 / Access Key]
	 *
	 * `secretAccessKey` :string : （必填项）在百度云申请的secretAccessKey。[见：安全认证 / Access Key]
	 *
	 * `endpointBos` :string : （必填项）百度云Bucket节点地址[见：BJ bj.bcebos.com | GZ hk-2.bcebos.com | SU su.bcebos.com]
	 *
	 * `token` :string : （可选项）STS 方式实现移动端的鉴权，STS的详细介绍请参考[临时授权访问](https://cloud.baidu.com/doc/BOS/API.html#.E4.B8.B4.E6.97.B6.E6.8E.88.E6.9D.83.E8.AE.BF.E9.97.AE)
	 *
	 * `bucketName` :string : （必填项）在百度bos申请的bucketName
	 *
	 * `objectKey` :string : （必填项）存储到Bucket的路径及文件名称。
	 *
	 * `uploadId` :string : （可选项）上传id。
	 */
	abortMultipartUpload(params:baiduBos_abortMultipartUpload_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `删除文件`
	 * ========params==========
	 *
	 * `accessKey` :string : （必填项）在百度云申请的accessKey。[见：安全认证 / Access Key]
	 *
	 * `secretAccessKey` :string : （必填项）在百度云申请的secretAccessKey。[见：安全认证 / Access Key]
	 *
	 * `endpointBos` :string : （必填项）百度云Bucket节点地址[见：BJ bj.bcebos.com | GZ hk-2.bcebos.com | SU su.bcebos.com]
	 *
	 * `token` :string : （可选项）STS 方式实现移动端的鉴权，STS的详细介绍请参考[临时授权访问](https://cloud.baidu.com/doc/BOS/API.html#.E4.B8.B4.E6.97.B6.E6.8E.88.E6.9D.83.E8.AE.BF.E9.97.AE)
	 *
	 * `bucketName` :string : （必填项）在百度bos申请的bucketName
	 *
	 * `objectKey` :string : （必填项）存储到Bucket的路径及文件名称。
	 */
	deleteObject(params:baiduBos_deleteObject_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface baiduBos_uploadPart_Params {
	/**（必填项）在百度云申请的accessKey。[见：安全认证 / Access Key]*/ 
	accessKey:string,

	/**（必填项）在百度云申请的secretAccessKey。[见：安全认证 / Access Key]*/ 
	secretAccessKey:string,

	/**（必填项）百度云Bucket节点地址[见：BJ bj.bcebos.com | GZ hk-2.bcebos.com | SU su.bcebos.com]*/ 
	endpointBos:string,

	/**（可选项）STS 方式实现移动端的鉴权，STS的详细介绍请参考[临时授权访问](https://cloud.baidu.com/doc/BOS/API.html#.E4.B8.B4.E6.97.B6.E6.8E.88.E6.9D.83.E8.AE.BF.E9.97.AE)*/ 
	token?:string,

	/**（必填项）在百度bos申请的bucketName*/ 
	bucketName:string,

	/**（必填项）上传文件本地路径。[支持fs:// widget://]。*/ 
	url:string,

	/**（必填项）存储到Bucket的路径及文件名称。*/ 
	objectKey:string,

	/**（可选项）最大连接数*/ 
	maxConnections?:number,

	/**（可选项）连接超时事件*/ 
	connectionTimeoutInMillis?:number,

	/**（可选项）socket连接超时时间*/ 
	socketTimeoutInMillis?:number,

	/**（可选项）Content-Type*/ 
	contentType?:string,

	/**（可选项）上一次的上传id，用于断点续传。*/ 
	uploadId?:string,

}

interface baiduBos_listParts_Params {
	/**（必填项）在百度云申请的accessKey。[见：安全认证 / Access Key]*/ 
	accessKey:string,

	/**（必填项）在百度云申请的secretAccessKey。[见：安全认证 / Access Key]*/ 
	secretAccessKey:string,

	/**（必填项）百度云Bucket节点地址[见：BJ bj.bcebos.com | GZ hk-2.bcebos.com | SU su.bcebos.com]*/ 
	endpointBos:string,

	/**（可选项）STS 方式实现移动端的鉴权，STS的详细介绍请参考[临时授权访问](https://cloud.baidu.com/doc/BOS/API.html#.E4.B8.B4.E6.97.B6.E6.8E.88.E6.9D.83.E8.AE.BF.E9.97.AE)*/ 
	token?:string,

	/**（必填项）在百度bos申请的bucketName*/ 
	bucketName:string,

	/**（必填项）存储到Bucket的路径及文件名称。*/ 
	objectKey:string,

	/**（可选项）每次获取最大分块上传事件的数目*/ 
	maxParts?:number,

	/**（可选项）若想获取更多已上传的分块信息，可以使用PartNumberMarker参数分次读取*/ 
	partNumberMarker?:number,

	/**（可选项）上传id。*/ 
	uploadId?:string,

}

interface baiduBos_abortMultipartUpload_Params {
	/**（必填项）在百度云申请的accessKey。[见：安全认证 / Access Key]*/ 
	accessKey:string,

	/**（必填项）在百度云申请的secretAccessKey。[见：安全认证 / Access Key]*/ 
	secretAccessKey:string,

	/**（必填项）百度云Bucket节点地址[见：BJ bj.bcebos.com | GZ hk-2.bcebos.com | SU su.bcebos.com]*/ 
	endpointBos:string,

	/**（可选项）STS 方式实现移动端的鉴权，STS的详细介绍请参考[临时授权访问](https://cloud.baidu.com/doc/BOS/API.html#.E4.B8.B4.E6.97.B6.E6.8E.88.E6.9D.83.E8.AE.BF.E9.97.AE)*/ 
	token?:string,

	/**（必填项）在百度bos申请的bucketName*/ 
	bucketName:string,

	/**（必填项）存储到Bucket的路径及文件名称。*/ 
	objectKey:string,

	/**（可选项）上传id。*/ 
	uploadId?:string,

}

interface baiduBos_deleteObject_Params {
	/**（必填项）在百度云申请的accessKey。[见：安全认证 / Access Key]*/ 
	accessKey:string,

	/**（必填项）在百度云申请的secretAccessKey。[见：安全认证 / Access Key]*/ 
	secretAccessKey:string,

	/**（必填项）百度云Bucket节点地址[见：BJ bj.bcebos.com | GZ hk-2.bcebos.com | SU su.bcebos.com]*/ 
	endpointBos:string,

	/**（可选项）STS 方式实现移动端的鉴权，STS的详细介绍请参考[临时授权访问](https://cloud.baidu.com/doc/BOS/API.html#.E4.B8.B4.E6.97.B6.E6.8E.88.E6.9D.83.E8.AE.BF.E9.97.AE)*/ 
	token?:string,

	/**（必填项）在百度bos申请的bucketName*/ 
	bucketName:string,

	/**（必填项）存储到Bucket的路径及文件名称。*/ 
	objectKey:string,

}

interface msSQL {
	/**
	 * `连接数据库`
	 * ========params==========
	 *
	 * `url` :string : 数据库的连接IP和端口。
	 *
	 * `user` :string : 登陆数据库的用户
	 *
	 * `pwd` :string : 登陆数据库的密码
	 *
	 * `dateBase` :string : 数据库库名
	 */
	connect(params:msSQL_connect_Params, callback?: (ret:JSON) => void):void

	/**
	 * `查询数据`
	 * ========params==========
	 *
	 * `sql` :string : sql语句。
	 */
	query(params:msSQL_query_Params, callback?: (ret:JSON) => void):void

	/**
	 * `修改 更新 删除`
	 * ========params==========
	 *
	 * `sql` :string : sql语句。
	 */
	update(params:msSQL_update_Params, callback?: (ret:JSON) => void):void

	/** 关闭数据库连接*/ 
	close():void

}
interface msSQL_connect_Params {
	/**数据库的连接IP和端口。*/ 
	url:string,

	/**登陆数据库的用户*/ 
	user:string,

	/**登陆数据库的密码*/ 
	pwd:string,

	/**数据库库名*/ 
	dateBase:string,

}

interface msSQL_query_Params {
	/**sql语句。*/ 
	sql:string,

}

interface msSQL_update_Params {
	/**sql语句。*/ 
	sql:string,

}

interface readId {
	/**     打开文件扫描器*/ 
	readOaId():void

}
interface webSocket2018 {
	/** 监听事件，收消息也是在这里处理。*/ 
	addEventListener():void

	/**
	 * `连接服务器。`
	 * ========params==========
	 *
	 * `url` :string : （必填）后台webSocket服务器地址。
	 */
	open(params:webSocket2018_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `发送消息`
	 * ========params==========
	 *
	 * `msg` :string : （必填）发送信息。
	 */
	send(params:webSocket2018_send_Params):void

	/** 连接服务器。*/ 
	close():void

}
interface webSocket2018_open_Params {
	/**（必填）后台webSocket服务器地址。*/ 
	url:string,

}

interface webSocket2018_send_Params {
	/**（必填）发送信息。*/ 
	msg:string,

}

interface broadcastList {
	/** 打开支持录屏直播的 App 列表页面*/ 
	open():void

}
interface moviePlayer {
	/**
	 * `打开一个自带界面的视频播放器，本播放器为全屏横屏显示，支持屏幕随设备自动旋转。用户单击播放器时，会弹出 foot 和 head 导航条，再次单击则关闭之。`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `texts` :JSON : （可选项）聊天输入框模块可配置的文本
	 *
	 * `centerPlayBtn` :JSON : （可选项）视频未播放或者视频暂停时在视频播放器中间显示（不传不显示）
	 *
	 * `styles` :JSON : （可选项）模块的样式设置
	 *
	 * `path` :string : （可选项）文档的路径，支持网络和本地（fs://）路径，**在 android 平台上不支持 widget**
	 *
	 * `showBack` :boolean : （可选项）竖屏时是否显示返回按钮 同时支持竖屏是否显示顶部导航条
	 *
	 * `isShowControlView` :boolean : （可选项）是否显示工具条
	 *
	 * `autoPlay` :boolean : （可选项）打开时是否自动播放
	 *
	 * `coverImg` :boolean : （可选项）封面图路径，播放器打开尚未播放时的封面图，要求本地路径（widget://、fs://）
	 *
	 * `scalingMode` :string : （可选项）视频播放时的拉伸方式  **仅支持iOS**
	 *
	 * `autorotation` :boolean : （可选项）视频播放页面是否支持自动旋转（横竖屏），若为 false 则手动点击右下角按钮旋转
	 *
	 * `useGestureControl` :boolean : （可选项）视频播放页面是否使用手势控制 (亮度，声音，快进快退) **注意:iOS如果此参数为false,则不能拖动进度条，
	 *
	 * `seekBarDragable` :boolean : （可选项） 播放进度条是否可以拖动
	 *
	 * `videoDirection` :string : （可选项）视频方向 ，前端开发者若要使用竖屏视频竖屏全屏播放，可传入portrait实现需求，类似抖音
	 *
	 * `isShowStatusBar` :boolean : （可选项）footer和header在视频打开时是否显示
	 *
	 * `tabLayoutUse` :boolean : （可选项）是否是在tabLayout中使用，如在tabLayout中使用全屏后不可在播放控件上添加任何其他控件，不推荐在tabLayout中使用（仅android支持）
	 *
	 * `landscapeFullscreen` :boolean : （可选项）横屏模式下是否设置全屏，如设true全屏恢复竖屏后会取消全屏，会影响到应用全屏模式以及沉浸式模式。（仅android支持）
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	open(params:moviePlayer_open_Params, callback?: (ret:JSON) => void):void

	/** 显示视频播放视图*/ 
	show():void

	/** 隐藏视频播放视图*/ 
	hide():void

	/** 关闭播放器*/ 
	close():void

	/** 暂停播放器*/ 
	pause():void

	/** 播放*/ 
	play():void

	/** 重新播放指定播放地址*/ 
	replay():void

	/** 判断当前是否为全屏*/ 
	isFullscreen():void

	/** 判断当前播放状态*/ 
	isPlaying():void

	/** 播放器监听事件*/ 
	addEventListener():void

	/** 该方法需要在点击back按键是调用，back键监听事件需要前端处理*/ 
	onBack():void

	/** footer和header是否显示*/ 
	setShowOrHideControlView():void

	/** 该方法用于app退入后台后调用（通过监听pause事件，仅支持Android）*/ 
	onPause():void

	/** 该方法用于从后台恢复时调用（通过监听resume事件，仅支持Android）*/ 
	onResume():void

	/** 获取当前播放位置该方法需要在视频准备结束后调用*/ 
	getCurrentPosition():void

	/** 获取播放总时长（仅支持Android）该方法需要在视频准备结束后调用*/ 
	getDuration():void

	/** 跳转到指定播放位置*/ 
	seekTo():void

	/**
	 * `视频截图`
	 * ========params==========
	 *
	 * `time` :number : 指定位置(单位为秒)
	 *
	 * `isAblum` :boolean : （可选项）是否保存相册
	 *
	 * `name` :boolean : （必选项）图片名
	 *
	 * `ret` :JSON : null
	 */
	videoCapture(params:moviePlayer_videoCapture_Params):void

	/**
	 * `设置CustomButton的隐藏与显示`
	 * ========params==========
	 *
	 * `isShow` :boolean : 是否显示
	 *
	 * `array` :Array : 需要显示或隐藏的按钮编号的数组
	 */
	setCustomButtons(params:moviePlayer_setCustomButtons_Params):void

	/**
	 * `设置进度条是否能拖动`
	 * ========params==========
	 *
	 * `seekBarDragable` :boolean : 进度条能否拖动
	 */
	setSeekBarDragable(params:moviePlayer_setSeekBarDragable_Params):void

}
interface moviePlayer_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**（可选项）聊天输入框模块可配置的文本*/ 
	texts?:JSON,

	/**（可选项）视频未播放或者视频暂停时在视频播放器中间显示（不传不显示）*/ 
	centerPlayBtn?:JSON,

	/**（可选项）模块的样式设置*/ 
	styles?:JSON,

	/**（可选项）文档的路径，支持网络和本地（fs://）路径，**在 android 平台上不支持 widget***/ 
	path?:string,

	/**（可选项）竖屏时是否显示返回按钮 同时支持竖屏是否显示顶部导航条*/ 
	showBack?:boolean,

	/**（可选项）是否显示工具条*/ 
	isShowControlView?:boolean,

	/**（可选项）打开时是否自动播放*/ 
	autoPlay?:boolean,

	/**（可选项）封面图路径，播放器打开尚未播放时的封面图，要求本地路径（widget://、fs://）*/ 
	coverImg?:boolean,

	/**（可选项）视频播放时的拉伸方式  **仅支持iOS***/ 
	scalingMode?:string,

	/**（可选项）视频播放页面是否支持自动旋转（横竖屏），若为 false 则手动点击右下角按钮旋转*/ 
	autorotation?:boolean,

	/**（可选项）视频播放页面是否使用手势控制 (亮度，声音，快进快退) **注意:iOS如果此参数为false,则不能拖动进度条，*/ 
	useGestureControl?:boolean,

	/**（可选项） 播放进度条是否可以拖动*/ 
	seekBarDragable?:boolean,

	/**（可选项）视频方向 ，前端开发者若要使用竖屏视频竖屏全屏播放，可传入portrait实现需求，类似抖音*/ 
	videoDirection?:string,

	/**（可选项）footer和header在视频打开时是否显示*/ 
	isShowStatusBar?:boolean,

	/**（可选项）是否是在tabLayout中使用，如在tabLayout中使用全屏后不可在播放控件上添加任何其他控件，不推荐在tabLayout中使用（仅android支持）*/ 
	tabLayoutUse?:boolean,

	/**（可选项）横屏模式下是否设置全屏，如设true全屏恢复竖屏后会取消全屏，会影响到应用全屏模式以及沉浸式模式。（仅android支持）*/ 
	landscapeFullscreen?:boolean,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface moviePlayer_videoCapture_Params {
	/**指定位置(单位为秒)*/ 
	time:number,

	/**（可选项）是否保存相册*/ 
	isAblum?:boolean,

	/**（必选项）图片名*/ 
	name:boolean,

	/**null*/ 
	ret:JSON,

}

interface moviePlayer_setCustomButtons_Params {
	/**是否显示*/ 
	isShow:boolean,

	/**需要显示或隐藏的按钮编号的数组*/ 
	array:Array,

}

interface moviePlayer_setSeekBarDragable_Params {
	/**进度条能否拖动*/ 
	seekBarDragable:boolean,

}

interface TCSuperPlayer {
	/**
	 * `设置验证`
	 * ========params==========
	 *
	 * `licenceURL` :string : 腾讯直播平台申请的 url
	 *
	 * `licenceKey` :string : 腾讯直播平台申请的 key
	 */
	setLicence(params:TCSuperPlayer_setLicence_Params):void

	/**
	 * `配置播放器视图。`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）视频播放器的位置及大小
	 *
	 * `isShowDanmu` :boolean : （可选项）全屏状态下是否显示弹幕开关按钮，仅Android支持
	 *
	 * `isShowSnapshot` :boolean : （可选项）全屏状态下是否显示截屏按钮
	 *
	 * `isShowMoreButton` :boolean : （可选项）全屏状态下是否显示更多按钮
	 *
	 * `isShowPipBtn` :boolean : （可选项）非全屏状态下是否显示画中画按钮，仅支持iOS端
	 *
	 * `isShowWindowLayoutTop` :boolean : （可选项）半屏状态下是否显示播放区域顶部导航条
	 *
	 * `isShowBackBtn` :boolean : （可选项）半屏状态下是否显示播放区域顶部返回按钮，返回按钮在顶部导航条内的布局中
	 *
	 * `fixedOn` :string : （可选项）模块添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）预览窗口是否随所属 window 或 frame 滚动
	 */
	configPlayerView(params:TCSuperPlayer_configPlayerView_Params):void

	/**
	 * `重设播放器位置和大小`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）预览窗口的位置及大小
	 */
	resizePlayerView(params:TCSuperPlayer_resizePlayerView_Params):void

	/** 初始化播放器*/ 
	initPlayer():void

	/** 隐藏播放试图的 `frame`*/ 
	hidePlayerView():void

	/** 恢复显示播放试图的 `frame`*/ 
	showPlayerView():void

	/** 关闭播放器。仅对引擎 2.0 方式打开的模块有效。通过 AVM 标签打开的播放器先调用pause接口暂停，然后前端代码自行隐藏即可。*/ 
	closePlayer():void

	/**
	 * `播放自定义视频`
	 * ========params==========
	 *
	 * `title` :string : 视频标题
	 *
	 * `videoURL` :string : 视频的URL，与 multiVideoURLs 互斥
	 *
	 * `multiVideoURLs` :Array : 高清、标清、超清等视频资源组成的数组，与 videoURL 互斥
	 *
	 * `dynamicWaterConfig` :JSON : 动态水印相关配置,不设置此参数则不显示动态水印
	 *
	 * `defaultPlayIndex` :number : （可选项） multiVideoURLs 有值时表示默认播放的视频的索引
	 */
	playWithUrl(params:TCSuperPlayer_playWithUrl_Params):void

	/**
	 * `播放腾讯云视频`
	 * ========params==========
	 *
	 * `title` :string : 视频标题
	 *
	 * `appId` :string : AppId 用于腾讯云点播 File ID 播放及腾讯云直播时移功能
	 *
	 * `fileId` :string : 云点播 File ID
	 *
	 * `psign` :string : （可选项）防盗链签名，若不传表示播放非防盗链视频资源
	 *
	 * `dynamicWaterConfig` :JSON : 动态水印相关配置,不设置此参数则不显示动态水印
	 */
	playWithTCloud(params:TCSuperPlayer_playWithTCloud_Params):void

	/** 全屏播放*/ 
	setPlayerFullScreen():void

	/** 事件监听*/ 
	addPlayerListener():void

	/** 重置player*/ 
	resetPlayer():void

	/** 暂停播放*/ 
	pausePlayer():void

	/** 恢复播放*/ 
	resumePlayer():void

	/**
	 * `跳转到指定位置播放`
	 * ========params==========
	 *
	 * `toTime` :number : 跳转到指定位置，单位秒
	 */
	seekToTime(params:TCSuperPlayer_seekToTime_Params):void

	/**
	 * `设置打点。在播放长视频时，打点信息有助于观众找到感兴趣的点。使用 [修改媒体文件属性](https://cloud.tencent.com/document/product/266/31762)API，通过 AddKeyFrameDescs.N 参数可以为视频设置打点信息。调用后，播放器的界面会增加新的元素。`
	 * ========params==========
	 *
	 * `frameDescList` :Array : 打点信息
	 */
	setKeyFrameDescList(params:TCSuperPlayer_setKeyFrameDescList_Params):void

	/** 获取打点信息*/ 
	getKeyFrameDescList():void

	/** 获取播放状态*/ 
	getPlayerState():void

	/**
	 * `设置封面图`
	 * ========params==========
	 *
	 * `coverImage` :string : 封面图本地路径
	 */
	setCoverImage(params:TCSuperPlayer_setCoverImage_Params):void

	/**
	 * `设置循环播放`
	 * ========params==========
	 *
	 * `loop` :boolean : 是否循环播放
	 */
	setLoop(params:TCSuperPlayer_setLoop_Params):void

	/**
	 * `起始播放时间，用于从上次位置开播`
	 * ========params==========
	 *
	 * `startTime` :number : 播放位置
	 */
	setStartTime(params:TCSuperPlayer_setStartTime_Params):void

	/** 获取播放总时长*/ 
	getPlayDuration():void

	/** 获取当前播放位置*/ 
	getCurrentTime():void

	/** 开启小窗（浮动窗）播放模式*/ 
	playFenestrule():void

	/** 从小窗播放模式切换回普通播放模式*/ 
	backFramePlay():void

	/** 从普通播放模式切换到小窗播放模式*/ 
	backFenestrulePlay():void

	/** 关闭小窗（浮动窗）播放模式*/ 
	closeFenestrulePlay():void

	/** 添加小窗播放的相关事件监听*/ 
	addFenestruleListener():void

	/** 隐藏全屏播放时的弹幕按钮，仅Android支持*/ 
	hideDanmu():void

	/** 添加下载监听*/ 
	addDownLoadListener():void

	/**
	 * `开始下载，开始下载有 URL 和 Fileid 两种方式。如果传了url就以url方式下载，Fileid方式需要appId、fileId`
	 * ========params==========
	 *
	 * `url` :string : 视频url地址
	 *
	 * `appId` :string : AppId 用于腾讯云点播 File ID 播放及腾讯云直播时移功能
	 *
	 * `fileId` :string : 云点播 File ID
	 *
	 * `psign` :string : （可选项）防盗链签名，若不传表示播放非防盗链视频资源
	 *
	 * `quality` :string : （可选项） 下载清晰度，
	 */
	startDownLoad(params:TCSuperPlayer_startDownLoad_Params):void

	/**
	 * `停止下载视频，执行结果会在下载监听中的eventType为downloadStop回调`
	 * ========params==========
	 *
	 * `downloadMediaInfo` :JSON : 下载监听中返回的downloadMediaInfo对象
	 */
	stopDownload(params:TCSuperPlayer_stopDownload_Params):void

	/** 隐藏全屏播放时的弹幕按钮，仅Android支持*/ 
	hideDanmu():void

	/** 获取下载列表*/ 
	getDownloadList():void

	/**
	 * `是否显示动态水印；在playWithUrl或playWithTCloud中设置dynamicWaterConfig才会显示动态水印`
	 * ========params==========
	 *
	 * `isShow` :boolean : 是否显示，true:显示；false:隐藏
	 */
	isShowDynamicWater(params:TCSuperPlayer_isShowDynamicWater_Params):void

}
interface TCSuperPlayer_setLicence_Params {
	/**腾讯直播平台申请的 url*/ 
	licenceURL:string,

	/**腾讯直播平台申请的 key*/ 
	licenceKey:string,

}

interface TCSuperPlayer_configPlayerView_Params {
	/**（可选项）视频播放器的位置及大小*/ 
	rect?:JSON,

	/**（可选项）全屏状态下是否显示弹幕开关按钮，仅Android支持*/ 
	isShowDanmu?:boolean,

	/**（可选项）全屏状态下是否显示截屏按钮*/ 
	isShowSnapshot?:boolean,

	/**（可选项）全屏状态下是否显示更多按钮*/ 
	isShowMoreButton?:boolean,

	/**（可选项）非全屏状态下是否显示画中画按钮，仅支持iOS端*/ 
	isShowPipBtn?:boolean,

	/**（可选项）半屏状态下是否显示播放区域顶部导航条*/ 
	isShowWindowLayoutTop?:boolean,

	/**（可选项）半屏状态下是否显示播放区域顶部返回按钮，返回按钮在顶部导航条内的布局中*/ 
	isShowBackBtn?:boolean,

	/**（可选项）模块添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）预览窗口是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface TCSuperPlayer_resizePlayerView_Params {
	/**（可选项）预览窗口的位置及大小*/ 
	rect?:JSON,

}

interface TCSuperPlayer_playWithUrl_Params {
	/**视频标题*/ 
	title:string,

	/**视频的URL，与 multiVideoURLs 互斥*/ 
	videoURL:string,

	/**高清、标清、超清等视频资源组成的数组，与 videoURL 互斥*/ 
	multiVideoURLs:Array,

	/**动态水印相关配置,不设置此参数则不显示动态水印*/ 
	dynamicWaterConfig:JSON,

	/**（可选项） multiVideoURLs 有值时表示默认播放的视频的索引*/ 
	defaultPlayIndex?:number,

}

interface TCSuperPlayer_playWithTCloud_Params {
	/**视频标题*/ 
	title:string,

	/**AppId 用于腾讯云点播 File ID 播放及腾讯云直播时移功能*/ 
	appId:string,

	/**云点播 File ID*/ 
	fileId:string,

	/**（可选项）防盗链签名，若不传表示播放非防盗链视频资源*/ 
	psign?:string,

	/**动态水印相关配置,不设置此参数则不显示动态水印*/ 
	dynamicWaterConfig:JSON,

}

interface TCSuperPlayer_seekToTime_Params {
	/**跳转到指定位置，单位秒*/ 
	toTime:number,

}

interface TCSuperPlayer_setKeyFrameDescList_Params {
	/**打点信息*/ 
	frameDescList:Array,

}

interface TCSuperPlayer_setCoverImage_Params {
	/**封面图本地路径*/ 
	coverImage:string,

}

interface TCSuperPlayer_setLoop_Params {
	/**是否循环播放*/ 
	loop:boolean,

}

interface TCSuperPlayer_setStartTime_Params {
	/**播放位置*/ 
	startTime:number,

}

interface TCSuperPlayer_startDownLoad_Params {
	/**视频url地址*/ 
	url:string,

	/**AppId 用于腾讯云点播 File ID 播放及腾讯云直播时移功能*/ 
	appId:string,

	/**云点播 File ID*/ 
	fileId:string,

	/**（可选项）防盗链签名，若不传表示播放非防盗链视频资源*/ 
	psign?:string,

	/**（可选项） 下载清晰度，*/ 
	quality?:string,

}

interface TCSuperPlayer_stopDownload_Params {
	/**下载监听中返回的downloadMediaInfo对象*/ 
	downloadMediaInfo:JSON,

}

interface TCSuperPlayer_isShowDynamicWater_Params {
	/**是否显示，true:显示；false:隐藏*/ 
	isShow:boolean,

}

interface vrPlayer {
	/** 监听手机不支持某互动类型（运动｜触摸｜运动&触摸）*/ 
	addEventListener(callback?: (ret:JSON) => void):void

	/**
	 * `播放vr视频`
	 * ========params==========
	 *
	 * `rect` :JSON : （必填项）模块的位置及尺寸
	 *
	 * `fixedOn` :string : （可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window
	 *
	 * `fixed` :boolean : （（可选项）模块是否随所属 Window 或 Frame 滚动
	 *
	 * `url` :string : （必填项）视频资源地址，支持fs://、widget://(在 android 平台上不支持 widget)、http:// (暂仅支持mp4，请开发者自行控制)
	 *
	 * `interactive` :number : （可选项）设置视频的互动类型（0：运动 1：触摸 2：运动&触摸）
	 *
	 * `display` :number : （可选项）设置视频显示类型（0：正常 1：双镜头）
	 *
	 * `projection` :number : （可选项）设置视频投影类型（0：球体 1：圆顶180 2：圆顶230 3：圆顶向上180 4：圆顶向上230 5：立体 6:平面铺满 7:平面剪裁 8:平面全铺）
	 */
	openVrPlayer(params:vrPlayer_openVrPlayer_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `设置视频的互动`
	 * ========params==========
	 *
	 * `interactive` :number : （可选项）设置视频的互动类型（0：运动 1：触摸 2：运动&触摸）
	 */
	switchInteractive(params:vrPlayer_switchInteractive_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `设置视频的显示模式`
	 * ========params==========
	 *
	 * `display` :number : （可选项）设置视频显示类型（0：正常 1：双镜头）
	 */
	switchDisplay(params:vrPlayer_switchDisplay_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `设置视频的影像模式`
	 * ========params==========
	 *
	 * `projection` :number : （可选项）设置视频投影类型（0：球体 1：圆顶180 2：圆顶230 3：圆顶向上180 4：圆顶向上230 5：立体 6:平面铺满 7:平面剪裁 8:平面全铺）
	 */
	switchProjection(params:vrPlayer_switchProjection_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 关闭*/ 
	closeVrPlayer(callback?: (ret:JSON, err:JSON) => void):void

	/** 获取视频的时长*/ 
	getDuration(callback?: (ret:JSON) => void):void

	/** 获取已经播放的时长*/ 
	getCurrentPosition(callback?: (ret:JSON) => void):void

	/**
	 * `设置播放进度位置(请根据视频最大时长进行参数控制传入)`
	 * ========params==========
	 *
	 * `process` :number : （必填项）设置视频需要播放的时长
	 */
	seekTo(params:vrPlayer_seekTo_Params):void

}
interface vrPlayer_openVrPlayer_Params {
	/**（必填项）模块的位置及尺寸*/ 
	rect:JSON,

	/**（可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window*/ 
	fixedOn?:string,

	/**（（可选项）模块是否随所属 Window 或 Frame 滚动*/ 
	fixed?:boolean,

	/**（必填项）视频资源地址，支持fs://、widget://(在 android 平台上不支持 widget)、http:// (暂仅支持mp4，请开发者自行控制)*/ 
	url:string,

	/**（可选项）设置视频的互动类型（0：运动 1：触摸 2：运动&触摸）*/ 
	interactive?:number,

	/**（可选项）设置视频显示类型（0：正常 1：双镜头）*/ 
	display?:number,

	/**（可选项）设置视频投影类型（0：球体 1：圆顶180 2：圆顶230 3：圆顶向上180 4：圆顶向上230 5：立体 6:平面铺满 7:平面剪裁 8:平面全铺）*/ 
	projection?:number,

}

interface vrPlayer_switchInteractive_Params {
	/**（可选项）设置视频的互动类型（0：运动 1：触摸 2：运动&触摸）*/ 
	interactive?:number,

}

interface vrPlayer_switchDisplay_Params {
	/**（可选项）设置视频显示类型（0：正常 1：双镜头）*/ 
	display?:number,

}

interface vrPlayer_switchProjection_Params {
	/**（可选项）设置视频投影类型（0：球体 1：圆顶180 2：圆顶230 3：圆顶向上180 4：圆顶向上230 5：立体 6:平面铺满 7:平面剪裁 8:平面全铺）*/ 
	projection?:number,

}

interface vrPlayer_seekTo_Params {
	/**（必填项）设置视频需要播放的时长*/ 
	process:number,

}

interface monitorFilesChange {
	/**
	 * `文件监听（文件里面内容改变的监听）`
	 * ========params==========
	 *
	 * `path` :string : 监听的文件的路径；支持fs://
	 */
	fileListener(params:monitorFilesChange_fileListener_Params, callback?: (ret:JSON) => void):void

	/**
	 * `文件夹监听（文件夹里面的文件增加还是减少）（仅iOS支持）`
	 * ========params==========
	 *
	 * `path` :string : 监听的文件夹的路径；支持fs://
	 */
	folderListener(params:monitorFilesChange_folderListener_Params, callback?: (ret:JSON) => void):void

	/** 取消监听（仅android支持）*/ 
	stopListener():void

}
interface monitorFilesChange_fileListener_Params {
	/**监听的文件的路径；支持fs://*/ 
	path:string,

}

interface monitorFilesChange_folderListener_Params {
	/**监听的文件夹的路径；支持fs://*/ 
	path:string,

}

interface dlna {
	/** 搜索设备*/ 
	startSearch():void

	/** 停止搜索*/ 
	stopSearch():void

	/** 投屏事件监听*/ 
	addEventListener():void

	/**
	 * `开始投屏`
	 * ========params==========
	 *
	 * `xh` :number : （必填项）设备序号(扫描设备返回结果序号)。
	 *
	 * `url` :string : （必填项）需要播放视频的视频地址(仅支持http协议的mp4类型视频，请开发者自行控制传入值)。
	 */
	startDLNA(params:dlna_startDLNA_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 退出投屏*/ 
	stopDLNA(callback?: (ret:JSON, err:JSON) => void):void

	/** 暂停播放*/ 
	pause(callback?: (ret:JSON, err:JSON) => void):void

	/** 开始播放*/ 
	resume(callback?: (ret:JSON, err:JSON) => void):void

	/** 获取视频总时长*/ 
	getDuration(callback?: (ret:JSON, err:JSON) => void):void

	/** 获取播放视频时长*/ 
	getPosition(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `设置进度`
	 * ========params==========
	 *
	 * `process` :number : （必填项）需要跳转的进度值(单位是秒)。
	 */
	seek(params:dlna_seek_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `设置音量`
	 * ========params==========
	 *
	 * `volume` :number : （必填项）设置视频音量(0-100)。
	 */
	volume(params:dlna_volume_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `切换视频地址`
	 * ========params==========
	 *
	 * `url` :string : （必填项）需要播放视频的视频地址(仅支持http协议的mp4类型视频，请开发者自行控制传入值)。
	 */
	playUrl(params:dlna_playUrl_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface dlna_startDLNA_Params {
	/**（必填项）设备序号(扫描设备返回结果序号)。*/ 
	xh:number,

	/**（必填项）需要播放视频的视频地址(仅支持http协议的mp4类型视频，请开发者自行控制传入值)。*/ 
	url:string,

}

interface dlna_seek_Params {
	/**（必填项）需要跳转的进度值(单位是秒)。*/ 
	process:number,

}

interface dlna_volume_Params {
	/**（必填项）设置视频音量(0-100)。*/ 
	volume:number,

}

interface dlna_playUrl_Params {
	/**（必填项）需要播放视频的视频地址(仅支持http协议的mp4类型视频，请开发者自行控制传入值)。*/ 
	url:string,

}

interface encryption {
	/** TEA解密*/ 
	decryptTea():void

	/**
	 * `XTEA加密`
	 * ========params==========
	 *
	 * `content` :string : 需要加密的数据  (长度必须为8，且必须为字母或数字)
	 *
	 * `key` :string : 用来加密的key（长度必须为16，且必须为字母或数字）（仅android支持）
	 *
	 * `ret` :JSON : null
	 */
	encryptionxTea(params:encryption_encryptionxTea_Params):void

	/**
	 * `XTEA解密`
	 * ========params==========
	 *
	 * `content` :string : 需要解密的数据
	 *
	 * `key` :string : 用来加密的key（长度必须为16，且必须为字母或数字）（仅android支持）
	 *
	 * `ret` :JSON : null
	 */
	decryptxTea(params:encryption_decryptxTea_Params):void

	/**
	 * `XXTEA加密`
	 * ========params==========
	 *
	 * `content` :string : 需要加密的数据
	 *
	 * `key` :string : 加密的Key
	 *
	 * `ret` :JSON : null
	 */
	encryptionxxTea(params:encryption_encryptionxxTea_Params):void

	/**
	 * `XXTEA解密`
	 * ========params==========
	 *
	 * `content` :string : 需要解密的数据
	 *
	 * `key` :string : 解密的Key
	 *
	 * `ret` :JSON : null
	 */
	decryptxxTea(params:encryption_decryptxxTea_Params):void

}
interface encryption_encryptionxTea_Params {
	/**需要加密的数据  (长度必须为8，且必须为字母或数字)*/ 
	content:string,

	/**用来加密的key（长度必须为16，且必须为字母或数字）（仅android支持）*/ 
	key:string,

	/**null*/ 
	ret:JSON,

}

interface encryption_decryptxTea_Params {
	/**需要解密的数据*/ 
	content:string,

	/**用来加密的key（长度必须为16，且必须为字母或数字）（仅android支持）*/ 
	key:string,

	/**null*/ 
	ret:JSON,

}

interface encryption_encryptionxxTea_Params {
	/**需要加密的数据*/ 
	content:string,

	/**加密的Key*/ 
	key:string,

	/**null*/ 
	ret:JSON,

}

interface encryption_decryptxxTea_Params {
	/**需要解密的数据*/ 
	content:string,

	/**解密的Key*/ 
	key:string,

	/**null*/ 
	ret:JSON,

}

interface playText {
	/**
	 * `播放文本`
	 * ========params==========
	 *
	 * `text` :string : 语音播放内容文本。
	 *
	 * `rate` :number : 播放速率
	 */
	play(params:playText_play_Params):void

	/** 继续播放文本*/ 
	continuePlay():void

	/** 停止播放*/ 
	stopPlay():void

	/** 暂停播放文本*/ 
	pausePlay():void

	/** 获取播放状态*/ 
	playState(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `监听事件`
	 * ========params==========
	 *
	 * `name` :string : 事件名称。
	 */
	addEventListener(params:playText_addEventListener_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface playText_play_Params {
	/**语音播放内容文本。*/ 
	text:string,

	/**播放速率*/ 
	rate:number,

}

interface playText_addEventListener_Params {
	/**事件名称。*/ 
	name:string,

}

interface codeTools {
	/**
	 * `二维码/条形码图片解码，iOS不支持条形码图片解码`
	 * ========params==========
	 *
	 * `path` :string : （可选项）要识别的图片路径，要求本地路径（fs://、widget://）
	 */
	decodeImg(params:codeTools_decodeImg_Params, callback?: (ret:JSON) => void):void

	/**
	 * `将字符串生成二维码/条形码图片，`
	 * ========params==========
	 *
	 * `type` :string : （可选项）生成图片的类型，默认值：'qr_image'
	 *
	 * `content` :string : 所要生成的二维码/条形码字符串，**当 type 为 bar_image 时，该值只能为数字字符串**
	 *
	 * `saveToAlbum` :boolean : （可选项）扫描的二维码/条形码图片是否自动保存到相册
	 *
	 * `saveImg` :JSON : （可选项）扫描的二维码/条形码图片保存所需要的参数，若不传则不保存
	 */
	encodeImg(params:codeTools_encodeImg_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface codeTools_decodeImg_Params {
	/**（可选项）要识别的图片路径，要求本地路径（fs://、widget://）*/ 
	path?:string,

}

interface codeTools_encodeImg_Params {
	/**（可选项）生成图片的类型，默认值：'qr_image'*/ 
	type?:string,

	/**所要生成的二维码/条形码字符串，**当 type 为 bar_image 时，该值只能为数字字符串***/ 
	content:string,

	/**（可选项）扫描的二维码/条形码图片是否自动保存到相册*/ 
	saveToAlbum?:boolean,

	/**（可选项）扫描的二维码/条形码图片保存所需要的参数，若不传则不保存*/ 
	saveImg?:JSON,

}

interface yyWebImage {
	/**
	 * `渐进式加载图片`
	 * ========params==========
	 *
	 * `rect` :string : （必填项）视频资源地址，支持http://
	 */
	openWebP(params:yyWebImage_openWebP_Params):void

	/**
	 * `普通URL加载图片`
	 * ========params==========
	 *
	 * `rect` :string : （必填项）视频资源地址，支持http:// 和本地路径
	 */
	openPictureWithURL(params:yyWebImage_openPictureWithURL_Params):void

	/** 渐进式加载图片*/ 
	closePicture():void

	/** 图片是否打开*/ 
	isOpen(callback?: (ret:JSON) => void):void

}
interface yyWebImage_openWebP_Params {
	/**（必填项）视频资源地址，支持http://*/ 
	rect:string,

}

interface yyWebImage_openPictureWithURL_Params {
	/**（必填项）视频资源地址，支持http:// 和本地路径*/ 
	rect:string,

}

interface qiniuKodo {
	/**
	 * `上传文件`
	 * ========params==========
	 *
	 * `token` :string : (可选项)上传文件所需的签名，从服务端获取的上传token
	 *
	 * `objectKey` :string : 文件存储在云上的命名，如：test.jpg
	 *
	 * `filePath` :string : 上传对象，需上传本地文件路径，支持fs://、widget://等文件路径协议及真实路径
	 */
	putObject(params:qiniuKodo_putObject_Params, callback?: (ret:JSON) => void):void

}
interface qiniuKodo_putObject_Params {
	/**(可选项)上传文件所需的签名，从服务端获取的上传token*/ 
	token?:string,

	/**文件存储在云上的命名，如：test.jpg*/ 
	objectKey:string,

	/**上传对象，需上传本地文件路径，支持fs://、widget://等文件路径协议及真实路径*/ 
	filePath:string,

}

interface apkInstall {
	/**
	 * `安卓apk安装`
	 * ========params==========
	 *
	 * `apkPath` :string : 安装包路径，支持fs路径以及安卓原生路径
	 */
	install(params:apkInstall_install_Params):void

	/**
	 * `卸载应用`
	 * ========params==========
	 *
	 * `packageName` :string : 要卸载应用的包名
	 */
	unInstall(params:apkInstall_unInstall_Params):void

}
interface apkInstall_install_Params {
	/**安装包路径，支持fs路径以及安卓原生路径*/ 
	apkPath:string,

}

interface apkInstall_unInstall_Params {
	/**要卸载应用的包名*/ 
	packageName:string,

}

interface phoneInfoMore {
	/** 获取手机基本信息*/ 
	getBaseInfo(callback?: (ret:JSON, err:JSON) => void):void

	/** 获取手机MAC地址(新)*/ 
	getMacAddressNew(callback?: (ret:JSON, err:JSON) => void):void

	/** 判断是否是模拟器*/ 
	isEmulator(callback?: (ret:JSON, err:JSON) => void):void

}
interface moduleAppList {
	/**
	 * `获取已安装的应用列表`
	 * ========params==========
	 *
	 * `isFilterSystemApp` :boolean : true 或 false（默认true）
	 *
	 * `isAppIcon` :boolean : true 或 false（默认true）
	 */
	getAppList(params:moduleAppList_getAppList_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface moduleAppList_getAppList_Params {
	/**true 或 false（默认true）*/ 
	isFilterSystemApp:boolean,

	/**true 或 false（默认true）*/ 
	isAppIcon:boolean,

}

interface tencentUGCUpload {
}
interface webServer {
	/**
	 * `开启服务。`
	 * ========params==========
	 *
	 * `serverDirectory` :string : 供其他设备访问操作的目录，如：fs://
	 *
	 * `allowedFileExtensions` :Array : （可选项）允许操作的文件后缀名，如["doc","docx","xls","xlsx","txt","pdf"]。若不传表示所有文件
	 *
	 * `title` :string : 标题
	 *
	 * `footer` :string : 脚标
	 *
	 * `prologue` :string : 序
	 */
	start(params:webServer_start_Params, callback?: (ret:JSON) => void):void

	/** 停止服务*/ 
	stop():void

	/**
	 * `添加监听`
	 * ========params==========
	 *
	 * `target` :string : 事件名称
	 */
	addEventListener(params:webServer_addEventListener_Params, callback?: (ret:JSON) => void):void

}
interface webServer_start_Params {
	/**供其他设备访问操作的目录，如：fs://*/ 
	serverDirectory:string,

	/**（可选项）允许操作的文件后缀名，如["doc","docx","xls","xlsx","txt","pdf"]。若不传表示所有文件*/ 
	allowedFileExtensions?:Array,

	/**标题*/ 
	title:string,

	/**脚标*/ 
	footer:string,

	/**序*/ 
	prologue:string,

}

interface webServer_addEventListener_Params {
	/**事件名称*/ 
	target:string,

}

interface downloadManager2 {
	/** 下载。*/ 
	download(callback?: (ret:JSON) => void):void

}
interface playModule {
	/**
	 * `初始化视频播放配置`
	 * ========params==========
	 *
	 * `ttf` :string : （可选项）设置标题显示文字字体文件路径，仅支持widget://
	 *
	 * `logo` :any : （可选项）右上角设置logo(图片类型：png)；支持fs://,widget://
	 *
	 * `background` :any : （可选项）视频播放前的图片显示(图片类型：jpg,png,gif)；支持fs://,widget://
	 *
	 * `FullScreenViewIsFont` :boolean : （可选项）全屏view是否显示最上层,true:是|false:否，仅ios有效（为fasle时可通过openframe自定义按钮在播放器上层；注意，未开启沉侵式的App请不要设置该参数。）
	 *
	 * `isShowBottomBtn` :boolean : （可选项）全屏时是否隐藏手机底部虚拟键，仅Android有效。
	 *
	 * `isMultiWindow` :boolean : （可选项）是否开启多窗口模式(true 开启 false 不开启)。
	 *
	 * `loading` :any : （可选项）加载中的gif动画图片接口(图片类型：gif)；支持fs://,widget://
	 *
	 * `logoLeftTop` :any : （可选项）左上角设置logo(图片类型：png)；支持fs://,widget://
	 *
	 * `logoLeftBottom` :any : （可选项）左下角设置logo(图片类型：png)；支持fs://,widget://
	 *
	 * `logoRightBottom` :any : （可选项）右下角设置logo(图片类型：png)；支持fs://,widget://
	 */
	init(params:playModule_init_Params):void

	/**
	 * `播放本地视频、网络视频、rtmp直播流等`
	 * ========params==========
	 *
	 * `rect` :JSON : （必填项）模块的位置及尺寸
	 *
	 * `fixedOn` :string : （可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window
	 *
	 * `fixed` :boolean : （（可选项）模块是否随所属 Window 或 Frame 滚动
	 *
	 * `url` :string : （必填项）视频资源地址，支持fs://、widget://(在 android 平台上不支持 widget)、rtmp://、http://
	 *
	 * `title` :string : （可选项）不填时标题默认显示url地址
	 *
	 * `defaultBtn` :boolean : （可选项）设置本次播放是否显示默认自带的播放控制按钮
	 *
	 * `enableFull` :boolean : （可选项）本次播放视频是否全屏播放，当为true时将直接全屏播放视频，x,y,w,h,fixedOn,fixed值不会生效。
	 *
	 * `enableFullAutoClose` :boolean : （可选项）默认全屏时播放时，返回按钮和退出全屏点击时是否关闭播放器(true:关闭 false:不关闭)
	 *
	 * `isTopView` :boolean : （可选项）是否显示顶部标题栏
	 *
	 * `isFullBtn` :boolean : （可选项）小窗口是否显示进入全屏按钮
	 *
	 * `isBackBtn` :boolean : （可选项）小窗口是否显示返回按钮
	 *
	 * `scalingMode` :boolean : （可选项）视频播放显示铺满模式（1:无缩放, 2:适应大小模式, 3:充满可视范围，可能会被裁剪, 4:缩放到充满视图）
	 *
	 * `fullscreenMode` :string : （可选项）设置全屏按钮控制全屏显示模式是横屏还是竖屏 竖屏:PORTRAIT ; 横屏:LANDSCAPE
	 *
	 * `isShowProcessView` :boolean : （可选项）是否显示进度条 (显示:true ; 不显示:false)【备注:直播流自动默认为false】
	 *
	 * `isShowTimeLable` :boolean : （可选项）是否显示播放时间 (显示:true ; 不显示:false)
	 *
	 * `isLive` :boolean : （可选项）是否直播视频源 （直播：true；点播：false）
	 *
	 * `isSmallOpenGesture` :boolean : （可选项）窗口播放时是否开启手势控制音量，亮度和进度 （开启：true；不开启：false）
	 *
	 * `isOpenGesture` :boolean : （可选项）全屏时是否开启手势控制音量，亮度和进度 （开启：true；不开启：false）
	 *
	 * `process` :number : （必填项）设置视频需要播放的时长
	 *
	 * `isAutoPlay` :boolean : （可选项）是否自动播放 (自动播放:true ; 不自动播放:false)
	 *
	 * `isPlayMusic` :boolean : （可选项）是否仅播放音频 (仅播放音频:true ; 视频播放:false)
	 *
	 * `isLoop` :boolean : （可选项）是否循环播放 (循环播放:true ; 禁止循环播放:false)
	 *
	 * `urlDatas` :Array : （可选项）清晰度按钮的自定义(数组内容大于1条记录，清晰度切换按钮才会显示，不支持直播链接的组装切换，不能和url接口参数同时存在)。
	 *
	 * `isSmallShowQxd` :boolean : （可选项）是否窗口时显示清晰度选择按钮 (数组内容大于1条记录，清晰度切换按钮才会显示；显示:true ; 不显示:false)
	 *
	 * `isMute` :boolean : （可选项）是否静音播放 (开启静音:true ; 关闭静音:false)
	 *
	 * `isShowDanmu` :boolean : （可选项）是否开启弹幕功能 (开启:true ; 不开启:false)
	 *
	 * `isLocalCache` :boolean : （可选项）是否本地缓存视频,音频;直播类不能缓存,开发者自行控制;(备注:缓存文件在cache://文件目录下,如果直播乱开启改参数会导致播放异常). (开启:true ; 不开启:false)
	 *
	 * `isShowFenxiang` :boolean : （可选项）全屏是否显示分享按钮 (显示:true ; 隐藏:false)
	 *
	 * `isShowMore` :boolean : （可选项）全屏是否显示更多按钮 (显示:true ; 隐藏:false)
	 *
	 * `isShowTouping` :boolean : （可选项）全屏是否显示投屏按钮 (显示:true ; 隐藏:false)
	 *
	 * `isShowXuanji` :boolean : （可选项）是否显示选集按钮 (显示:true ; 隐藏:false)
	 *
	 * `isShowNext` :boolean : （可选项）是否显示下一集按钮 (显示:true ; 隐藏:false)
	 *
	 * `isShowPre` :boolean : （可选项）是否显示上一集按钮 (显示:true ; 隐藏:false)
	 *
	 * `isSmallImmerse` :boolean : （可选项）窗口播放顶部控制栏是否沉侵式 (显示:true ; 隐藏:false)
	 *
	 * `isLongShowBackBtn` :boolean : （可选项）窗口模式下是否长时间显示返回按钮 (显示:true ; 隐藏:false)
	 *
	 * `isSmallShowFenxiang` :boolean : （可选项）窗口是否显示分享按钮 (显示:true ; 隐藏:false)
	 *
	 * `isSmallShowMore` :boolean : （可选项）窗口是否显示更多按钮 (显示:true ; 隐藏:false)
	 *
	 * `isSmallShowTouping` :boolean : （可选项）窗口是否显示投屏按钮 (显示:true ; 隐藏:false)
	 *
	 * `isOpenDanmu` :boolean : （可选项）是否打开弹幕功能 (打开:true ; 关闭:false)
	 *
	 * `singlePageModule` :boolean : （可选项）是否打开单页面播放模式。（当设置为true时，本页面播放器的接口只能在当前页面调用，不能跨页面；同时本页面开启多窗口模式无效）
	 *
	 * `isShowNetworkSpeed` :boolean : （可选项）是否在缓冲的时候显示网速
	 *
	 * `background` :any : （可选项）视频播放前的图片显示(图片类型：jpg,png,gif)；支持fs://,widget://
	 *
	 * `placeholderText` :string : （可选项）发送弹幕输入框默认提示内容。
	 *
	 * `isShowLock` :boolean : （可选项）全屏下是否显示锁屏按钮(true 显示 false 不显示)。
	 *
	 * `freeProcess` :number : （必填项）设置可免费播放时长,当免费播放完后触发播放异常事件，错误码5721
	 */
	play(params:playModule_play_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `同一个页面，已经调用play接口后，切换视频地址时调用（前提条件，同一界面已经调用过play接口）。`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 *
	 * `url` :string : （必填项）视频资源地址，支持fs://、widget://(在 android 平台上不支持 widget)、rtmp://、http://
	 *
	 * `title` :string : （可选项）不填时标题默认显示url播放文件名
	 *
	 * `defaultBtn` :boolean : （可选项）设置本次播放是否显示默认自带的播放控制按钮
	 *
	 * `isLive` :boolean : （可选项）是否直播视频源 （直播：true；点播：false）
	 *
	 * `isSmallOpenGesture` :boolean : （可选项）窗口播放时是否开启手势控制音量，亮度和进度 （开启：true；不开启：false）
	 *
	 * `isOpenGesture` :boolean : （可选项）全屏时是否开启手势控制音量，亮度和进度 （开启：true；不开启：false）
	 *
	 * `process` :number : （必填项）设置视频需要播放的时长
	 *
	 * `isAutoPlay` :boolean : （可选项）是否自动播放 (自动播放:true ; 不自动播放:false)
	 *
	 * `isLoop` :boolean : （可选项）是否循环播放 (循环播放:true ; 禁止循环播放:false)
	 *
	 * `isShowProcessView` :boolean : （可选项）是否显示进度条 (显示:true ; 不显示:false)【备注:直播流自动默认为false】
	 *
	 * `isShowTimeLable` :boolean : （可选项）是否显示播放时间 (显示:true ; 不显示:false)
	 *
	 * `urlDatas` :Array : （可选项）清晰度按钮的自定义(数组内容大于1条记录，清晰度切换按钮才会显示，不支持直播链接的组装切换，不能和url接口参数同时存在)。
	 *
	 * `isSmallShowQxd` :boolean : （可选项）是否窗口时显示清晰度选择按钮 (数组内容大于1条记录，清晰度切换按钮才会显示；显示:true ; 不显示:false)
	 *
	 * `isMute` :boolean : （可选项）是否静音播放 (开启静音:true ; 关闭静音:false)
	 *
	 * `isShowDanmu` :boolean : （可选项）是否开启弹幕功能 (开启:true ; 不开启:false)
	 *
	 * `isLocalCache` :boolean : （可选项）是否本地缓存视频,音频;直播类不能缓存,开发者自行控制;(备注:缓存文件在cache://文件目录下,如果直播乱开启改参数会导致播放异常). (开启:true ; 不开启:false)
	 *
	 * `isShowFenxiang` :boolean : （可选项）全屏是否显示分享按钮 (显示:true ; 隐藏:false)
	 *
	 * `isShowMore` :boolean : （可选项）全屏是否显示更多按钮 (显示:true ; 隐藏:false)
	 *
	 * `isShowTouping` :boolean : （可选项）全屏是否显示投屏按钮 (显示:true ; 隐藏:false)
	 *
	 * `isShowXuanji` :boolean : （可选项）是否显示选集按钮 (显示:true ; 隐藏:false)
	 *
	 * `isShowNext` :boolean : （可选项）是否显示下一集按钮 (显示:true ; 隐藏:false)
	 *
	 * `isShowPre` :boolean : （可选项）是否显示上一集按钮 (显示:true ; 隐藏:false)
	 *
	 * `isSmallImmerse` :boolean : （可选项）窗口播放顶部控制栏是否沉侵式 (显示:true ; 隐藏:false)
	 *
	 * `isLongShowBackBtn` :boolean : （可选项）窗口模式下是否长时间显示返回按钮 (显示:true ; 隐藏:false)
	 *
	 * `isSmallShowFenxiang` :boolean : （可选项）窗口是否显示分享按钮 (显示:true ; 隐藏:false)
	 *
	 * `isSmallShowMore` :boolean : （可选项）窗口是否显示更多按钮 (显示:true ; 隐藏:false)
	 *
	 * `isSmallShowTouping` :boolean : （可选项）窗口是否显示投屏按钮 (显示:true ; 隐藏:false)
	 *
	 * `isOpenDanmu` :boolean : （可选项）是否打开弹幕功能 (打开:true ; 关闭:false)
	 *
	 * `isShowNetworkSpeed` :boolean : （可选项）是否在缓冲的时候显示网速
	 *
	 * `freeProcess` :number : （必填项）设置可免费播放时长,当免费播放完后触发播放异常事件，错误码5721
	 */
	playUrl(params:playModule_playUrl_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `暂停播放`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 */
	pause(params:playModule_pause_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `暂停后开始播放`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 */
	start(params:playModule_start_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `停止播放`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 */
	stop(params:playModule_stop_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取视频的时长`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 */
	getDuration(params:playModule_getDuration_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取已经播放的时长`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 */
	getCurrentPosition(params:playModule_getCurrentPosition_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `全屏播放`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 */
	full(params:playModule_full_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `退出全屏`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 */
	unfull(params:playModule_unfull_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `视频播放完监听事件`
	 * ========params==========
	 *
	 * `name` :string : 监听事件名称,可以设置的播放界面监听类型有：playEnd(播放结束),playError(播放异常),pause(暂停),play(播放),backBtn(小窗口返回按钮),full(进入全屏按钮),unfull(退出全屏按钮),click(视频区域点击监听),bufferingStart(缓冲开始),bufferingEnd(缓冲结束), onPrepared(视频准备完成),onChangeQxd(清晰度改变), fenxiangClick(分析按钮), moreClick(更多按钮), toupingClick(投屏按钮), xuanjiClick(选集按钮), nextClick(下一集按钮), preClick(上一级按钮), sendDanmuMessage(发送弹幕输入框发送内容),danmuClick(弹幕开关按钮点击)
	 */
	addEventListener(params:playModule_addEventListener_Params, callback?: (ret:JSON) => void):void

	/**
	 * `获取是否全屏播放状态`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 */
	isFullScreen(params:playModule_isFullScreen_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `设置播放进度位置(请根据视频最大时长进行参数控制传入)`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 *
	 * `process` :number : （必填项）设置视频需要播放的时长
	 */
	seekTo(params:playModule_seekTo_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `设置播音量`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 *
	 * `volume` :number : （必填项）0-100
	 */
	setVolume(params:playModule_setVolume_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `隐藏播放器`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 */
	hidePlayer(params:playModule_hidePlayer_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `显示播放器`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 */
	showPlayer(params:playModule_showPlayer_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `倍速播放`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 *
	 * `speed` :number : （必填项）设置视频播放倍速(取值范围 0.1-1.9)
	 */
	setSpeed(params:playModule_setSpeed_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 清除页面所有打开的播放器接口(执行该接口后，返回index会归零)*/ 
	cleanPlayers():void

	/**
	 * `更新清晰度选择列表地址(必须和play或者playUrl接口传的数组长度一致)。`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 *
	 * `urlDatas` :Array : （可选项）清晰度按钮的自定义(数组内容大于1条记录，清晰度切换按钮才会显示，不支持直播链接的组装切换，不能和url接口参数同时存在)。
	 */
	updateUrlDatas(params:playModule_updateUrlDatas_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `发送一条弹幕信息`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 *
	 * `text` :string : （必填项）弹幕文字内容
	 *
	 * `color` :string : （可选项）弹幕文字显示颜色代码
	 *
	 * `textSize` :number : （可选项）弹幕文字大小
	 */
	sendDanmu(params:playModule_sendDanmu_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `发送多条弹幕信息。`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 *
	 * `isLoop` :boolean : （可选项）天际的全部数据是否循环播放(循环:true，不循环:false)
	 *
	 * `data` :Array : （必填项）多条弹幕信息记录。
	 */
	sendDanmuList(params:playModule_sendDanmuList_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取音轨数量。`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 */
	getAudioTrack(params:playModule_getAudioTrack_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `设置音轨(原音|伴音)[仅对多音轨有效]`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 *
	 * `trackId` :number : （可选项）音轨序号(双音轨>1:原音 2伴音)
	 */
	setAudioTrack(params:playModule_setAudioTrack_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `静音开关切换`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 *
	 * `isMute` :boolean : （可选项）是否静音(开启静音:true 关闭静音:false)
	 */
	setMute(params:playModule_setMute_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `截图`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 */
	takeSnapshot(params:playModule_takeSnapshot_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取当前播放速率`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 */
	getCurrentSpeed(params:playModule_getCurrentSpeed_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface playModule_init_Params {
	/**（可选项）设置标题显示文字字体文件路径，仅支持widget://*/ 
	ttf?:string,

	/**（可选项）右上角设置logo(图片类型：png)；支持fs://,widget://*/ 
	logo?:any,

	/**（可选项）视频播放前的图片显示(图片类型：jpg,png,gif)；支持fs://,widget://*/ 
	background?:any,

	/**（可选项）全屏view是否显示最上层,true:是|false:否，仅ios有效（为fasle时可通过openframe自定义按钮在播放器上层；注意，未开启沉侵式的App请不要设置该参数。）*/ 
	FullScreenViewIsFont?:boolean,

	/**（可选项）全屏时是否隐藏手机底部虚拟键，仅Android有效。*/ 
	isShowBottomBtn?:boolean,

	/**（可选项）是否开启多窗口模式(true 开启 false 不开启)。*/ 
	isMultiWindow?:boolean,

	/**（可选项）加载中的gif动画图片接口(图片类型：gif)；支持fs://,widget://*/ 
	loading?:any,

	/**（可选项）左上角设置logo(图片类型：png)；支持fs://,widget://*/ 
	logoLeftTop?:any,

	/**（可选项）左下角设置logo(图片类型：png)；支持fs://,widget://*/ 
	logoLeftBottom?:any,

	/**（可选项）右下角设置logo(图片类型：png)；支持fs://,widget://*/ 
	logoRightBottom?:any,

}

interface playModule_play_Params {
	/**（必填项）模块的位置及尺寸*/ 
	rect:JSON,

	/**（可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window*/ 
	fixedOn?:string,

	/**（（可选项）模块是否随所属 Window 或 Frame 滚动*/ 
	fixed?:boolean,

	/**（必填项）视频资源地址，支持fs://、widget://(在 android 平台上不支持 widget)、rtmp://、http://*/ 
	url:string,

	/**（可选项）不填时标题默认显示url地址*/ 
	title?:string,

	/**（可选项）设置本次播放是否显示默认自带的播放控制按钮*/ 
	defaultBtn?:boolean,

	/**（可选项）本次播放视频是否全屏播放，当为true时将直接全屏播放视频，x,y,w,h,fixedOn,fixed值不会生效。*/ 
	enableFull?:boolean,

	/**（可选项）默认全屏时播放时，返回按钮和退出全屏点击时是否关闭播放器(true:关闭 false:不关闭)*/ 
	enableFullAutoClose?:boolean,

	/**（可选项）是否显示顶部标题栏*/ 
	isTopView?:boolean,

	/**（可选项）小窗口是否显示进入全屏按钮*/ 
	isFullBtn?:boolean,

	/**（可选项）小窗口是否显示返回按钮*/ 
	isBackBtn?:boolean,

	/**（可选项）视频播放显示铺满模式（1:无缩放, 2:适应大小模式, 3:充满可视范围，可能会被裁剪, 4:缩放到充满视图）*/ 
	scalingMode?:boolean,

	/**（可选项）设置全屏按钮控制全屏显示模式是横屏还是竖屏 竖屏:PORTRAIT ; 横屏:LANDSCAPE*/ 
	fullscreenMode?:string,

	/**（可选项）是否显示进度条 (显示:true ; 不显示:false)【备注:直播流自动默认为false】*/ 
	isShowProcessView?:boolean,

	/**（可选项）是否显示播放时间 (显示:true ; 不显示:false)*/ 
	isShowTimeLable?:boolean,

	/**（可选项）是否直播视频源 （直播：true；点播：false）*/ 
	isLive?:boolean,

	/**（可选项）窗口播放时是否开启手势控制音量，亮度和进度 （开启：true；不开启：false）*/ 
	isSmallOpenGesture?:boolean,

	/**（可选项）全屏时是否开启手势控制音量，亮度和进度 （开启：true；不开启：false）*/ 
	isOpenGesture?:boolean,

	/**（必填项）设置视频需要播放的时长*/ 
	process:number,

	/**（可选项）是否自动播放 (自动播放:true ; 不自动播放:false)*/ 
	isAutoPlay?:boolean,

	/**（可选项）是否仅播放音频 (仅播放音频:true ; 视频播放:false)*/ 
	isPlayMusic?:boolean,

	/**（可选项）是否循环播放 (循环播放:true ; 禁止循环播放:false)*/ 
	isLoop?:boolean,

	/**（可选项）清晰度按钮的自定义(数组内容大于1条记录，清晰度切换按钮才会显示，不支持直播链接的组装切换，不能和url接口参数同时存在)。*/ 
	urlDatas?:Array,

	/**（可选项）是否窗口时显示清晰度选择按钮 (数组内容大于1条记录，清晰度切换按钮才会显示；显示:true ; 不显示:false)*/ 
	isSmallShowQxd?:boolean,

	/**（可选项）是否静音播放 (开启静音:true ; 关闭静音:false)*/ 
	isMute?:boolean,

	/**（可选项）是否开启弹幕功能 (开启:true ; 不开启:false)*/ 
	isShowDanmu?:boolean,

	/**（可选项）是否本地缓存视频,音频;直播类不能缓存,开发者自行控制;(备注:缓存文件在cache://文件目录下,如果直播乱开启改参数会导致播放异常). (开启:true ; 不开启:false)*/ 
	isLocalCache?:boolean,

	/**（可选项）全屏是否显示分享按钮 (显示:true ; 隐藏:false)*/ 
	isShowFenxiang?:boolean,

	/**（可选项）全屏是否显示更多按钮 (显示:true ; 隐藏:false)*/ 
	isShowMore?:boolean,

	/**（可选项）全屏是否显示投屏按钮 (显示:true ; 隐藏:false)*/ 
	isShowTouping?:boolean,

	/**（可选项）是否显示选集按钮 (显示:true ; 隐藏:false)*/ 
	isShowXuanji?:boolean,

	/**（可选项）是否显示下一集按钮 (显示:true ; 隐藏:false)*/ 
	isShowNext?:boolean,

	/**（可选项）是否显示上一集按钮 (显示:true ; 隐藏:false)*/ 
	isShowPre?:boolean,

	/**（可选项）窗口播放顶部控制栏是否沉侵式 (显示:true ; 隐藏:false)*/ 
	isSmallImmerse?:boolean,

	/**（可选项）窗口模式下是否长时间显示返回按钮 (显示:true ; 隐藏:false)*/ 
	isLongShowBackBtn?:boolean,

	/**（可选项）窗口是否显示分享按钮 (显示:true ; 隐藏:false)*/ 
	isSmallShowFenxiang?:boolean,

	/**（可选项）窗口是否显示更多按钮 (显示:true ; 隐藏:false)*/ 
	isSmallShowMore?:boolean,

	/**（可选项）窗口是否显示投屏按钮 (显示:true ; 隐藏:false)*/ 
	isSmallShowTouping?:boolean,

	/**（可选项）是否打开弹幕功能 (打开:true ; 关闭:false)*/ 
	isOpenDanmu?:boolean,

	/**（可选项）是否打开单页面播放模式。（当设置为true时，本页面播放器的接口只能在当前页面调用，不能跨页面；同时本页面开启多窗口模式无效）*/ 
	singlePageModule?:boolean,

	/**（可选项）是否在缓冲的时候显示网速*/ 
	isShowNetworkSpeed?:boolean,

	/**（可选项）视频播放前的图片显示(图片类型：jpg,png,gif)；支持fs://,widget://*/ 
	background?:any,

	/**（可选项）发送弹幕输入框默认提示内容。*/ 
	placeholderText?:string,

	/**（可选项）全屏下是否显示锁屏按钮(true 显示 false 不显示)。*/ 
	isShowLock?:boolean,

	/**（必填项）设置可免费播放时长,当免费播放完后触发播放异常事件，错误码5721*/ 
	freeProcess:number,

}

interface playModule_playUrl_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

	/**（必填项）视频资源地址，支持fs://、widget://(在 android 平台上不支持 widget)、rtmp://、http://*/ 
	url:string,

	/**（可选项）不填时标题默认显示url播放文件名*/ 
	title?:string,

	/**（可选项）设置本次播放是否显示默认自带的播放控制按钮*/ 
	defaultBtn?:boolean,

	/**（可选项）是否直播视频源 （直播：true；点播：false）*/ 
	isLive?:boolean,

	/**（可选项）窗口播放时是否开启手势控制音量，亮度和进度 （开启：true；不开启：false）*/ 
	isSmallOpenGesture?:boolean,

	/**（可选项）全屏时是否开启手势控制音量，亮度和进度 （开启：true；不开启：false）*/ 
	isOpenGesture?:boolean,

	/**（必填项）设置视频需要播放的时长*/ 
	process:number,

	/**（可选项）是否自动播放 (自动播放:true ; 不自动播放:false)*/ 
	isAutoPlay?:boolean,

	/**（可选项）是否循环播放 (循环播放:true ; 禁止循环播放:false)*/ 
	isLoop?:boolean,

	/**（可选项）是否显示进度条 (显示:true ; 不显示:false)【备注:直播流自动默认为false】*/ 
	isShowProcessView?:boolean,

	/**（可选项）是否显示播放时间 (显示:true ; 不显示:false)*/ 
	isShowTimeLable?:boolean,

	/**（可选项）清晰度按钮的自定义(数组内容大于1条记录，清晰度切换按钮才会显示，不支持直播链接的组装切换，不能和url接口参数同时存在)。*/ 
	urlDatas?:Array,

	/**（可选项）是否窗口时显示清晰度选择按钮 (数组内容大于1条记录，清晰度切换按钮才会显示；显示:true ; 不显示:false)*/ 
	isSmallShowQxd?:boolean,

	/**（可选项）是否静音播放 (开启静音:true ; 关闭静音:false)*/ 
	isMute?:boolean,

	/**（可选项）是否开启弹幕功能 (开启:true ; 不开启:false)*/ 
	isShowDanmu?:boolean,

	/**（可选项）是否本地缓存视频,音频;直播类不能缓存,开发者自行控制;(备注:缓存文件在cache://文件目录下,如果直播乱开启改参数会导致播放异常). (开启:true ; 不开启:false)*/ 
	isLocalCache?:boolean,

	/**（可选项）全屏是否显示分享按钮 (显示:true ; 隐藏:false)*/ 
	isShowFenxiang?:boolean,

	/**（可选项）全屏是否显示更多按钮 (显示:true ; 隐藏:false)*/ 
	isShowMore?:boolean,

	/**（可选项）全屏是否显示投屏按钮 (显示:true ; 隐藏:false)*/ 
	isShowTouping?:boolean,

	/**（可选项）是否显示选集按钮 (显示:true ; 隐藏:false)*/ 
	isShowXuanji?:boolean,

	/**（可选项）是否显示下一集按钮 (显示:true ; 隐藏:false)*/ 
	isShowNext?:boolean,

	/**（可选项）是否显示上一集按钮 (显示:true ; 隐藏:false)*/ 
	isShowPre?:boolean,

	/**（可选项）窗口播放顶部控制栏是否沉侵式 (显示:true ; 隐藏:false)*/ 
	isSmallImmerse?:boolean,

	/**（可选项）窗口模式下是否长时间显示返回按钮 (显示:true ; 隐藏:false)*/ 
	isLongShowBackBtn?:boolean,

	/**（可选项）窗口是否显示分享按钮 (显示:true ; 隐藏:false)*/ 
	isSmallShowFenxiang?:boolean,

	/**（可选项）窗口是否显示更多按钮 (显示:true ; 隐藏:false)*/ 
	isSmallShowMore?:boolean,

	/**（可选项）窗口是否显示投屏按钮 (显示:true ; 隐藏:false)*/ 
	isSmallShowTouping?:boolean,

	/**（可选项）是否打开弹幕功能 (打开:true ; 关闭:false)*/ 
	isOpenDanmu?:boolean,

	/**（可选项）是否在缓冲的时候显示网速*/ 
	isShowNetworkSpeed?:boolean,

	/**（必填项）设置可免费播放时长,当免费播放完后触发播放异常事件，错误码5721*/ 
	freeProcess:number,

}

interface playModule_pause_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

}

interface playModule_start_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

}

interface playModule_stop_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

}

interface playModule_getDuration_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

}

interface playModule_getCurrentPosition_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

}

interface playModule_full_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

}

interface playModule_unfull_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

}

interface playModule_addEventListener_Params {
	/**监听事件名称,可以设置的播放界面监听类型有：playEnd(播放结束),playError(播放异常),pause(暂停),play(播放),backBtn(小窗口返回按钮),full(进入全屏按钮),unfull(退出全屏按钮),click(视频区域点击监听),bufferingStart(缓冲开始),bufferingEnd(缓冲结束), onPrepared(视频准备完成),onChangeQxd(清晰度改变), fenxiangClick(分析按钮), moreClick(更多按钮), toupingClick(投屏按钮), xuanjiClick(选集按钮), nextClick(下一集按钮), preClick(上一级按钮), sendDanmuMessage(发送弹幕输入框发送内容),danmuClick(弹幕开关按钮点击)*/ 
	name:string,

}

interface playModule_isFullScreen_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

}

interface playModule_seekTo_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

	/**（必填项）设置视频需要播放的时长*/ 
	process:number,

}

interface playModule_setVolume_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

	/**（必填项）0-100*/ 
	volume:number,

}

interface playModule_hidePlayer_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

}

interface playModule_showPlayer_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

}

interface playModule_setSpeed_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

	/**（必填项）设置视频播放倍速(取值范围 0.1-1.9)*/ 
	speed:number,

}

interface playModule_updateUrlDatas_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

	/**（可选项）清晰度按钮的自定义(数组内容大于1条记录，清晰度切换按钮才会显示，不支持直播链接的组装切换，不能和url接口参数同时存在)。*/ 
	urlDatas?:Array,

}

interface playModule_sendDanmu_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

	/**（必填项）弹幕文字内容*/ 
	text:string,

	/**（可选项）弹幕文字显示颜色代码*/ 
	color?:string,

	/**（可选项）弹幕文字大小*/ 
	textSize?:number,

}

interface playModule_sendDanmuList_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

	/**（可选项）天际的全部数据是否循环播放(循环:true，不循环:false)*/ 
	isLoop?:boolean,

	/**（必填项）多条弹幕信息记录。*/ 
	data:Array,

}

interface playModule_getAudioTrack_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

}

interface playModule_setAudioTrack_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

	/**（可选项）音轨序号(双音轨>1:原音 2伴音)*/ 
	trackId?:number,

}

interface playModule_setMute_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

	/**（可选项）是否静音(开启静音:true 关闭静音:false)*/ 
	isMute?:boolean,

}

interface playModule_takeSnapshot_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

}

interface playModule_getCurrentSpeed_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

}

interface circleMenu {
}
interface docInteraction {
}
interface appUtils {
	/** 调取页面到前台*/ 
	bringAppToFront(callback?: (ret:JSON, err:JSON) => void):void

	/** 关闭页面管理者。*/ 
	stopPageManager(callback?: (ret:JSON, err:JSON) => void):void

	/** 开机启动,设置为开机自动启动需要手机授权开机自动启动权限。*/ 
	openStart(callback?: (ret:JSON, err:JSON) => void):void

	/** 获取手机应用*/ 
	getApps(callback?: (ret:JSON, err:JSON) => void):void

	/** 应用退到后台*/ 
	moveAppToBack(callback?: (ret:JSON, err:JSON) => void):void

	/** 获取状态栏高度*/ 
	getStateViewHeight(callback?: (ret:JSON, err:JSON) => void):void

	/** 获取底部虚拟按键高度*/ 
	getBottomViewHeight(callback?: (ret:JSON, err:JSON) => void):void

	/** 跳转应用市场评价*/ 
	toEvaluate(callback?: (ret:JSON, err:JSON) => void):void

	/** 获取已安装的应用市场*/ 
	getInstallAppStores(callback?: (ret:JSON, err:JSON) => void):void

	/** 创建快捷方式*/ 
	addShortcut(callback?: (ret:JSON, err:JSON) => void):void

	/** 添加悬浮框*/ 
	addFloadWindow(callback?: (ret:JSON, err:JSON) => void):void

	/** 移除悬浮框*/ 
	removeFloadWindow(callback?: (ret:JSON, err:JSON) => void):void

	/** 检测悬浮框权限，权限未开启则只能在应用内显示*/ 
	checkFloadPermission(callback?: (ret:JSON, err:JSON) => void):void

	/** 添加gps开关监听*/ 
	setGpsListener(callback?: (ret:JSON, err:JSON) => void):void

	/** 获取gps状态*/ 
	getGpsStatus(callback?: (ret:JSON, err:JSON) => void):void

	/** 检查通知权限*/ 
	checkNotificationPermission(callback?: (ret:JSON, err:JSON) => void):void

	/** 跳转应用详情页面，可进行权限设置*/ 
	gotoAppDetail(callback?: (ret:JSON, err:JSON) => void):void

	/** 跳转系统设置页面*/ 
	gotoSysSetPage(callback?: (ret:JSON, err:JSON) => void):void

	/** 获取设备信息*/ 
	getDeviceInfo(callback?: (ret:JSON, err:JSON) => void):void

	/** 获取设备信号*/ 
	getDeviceDbm(callback?: (ret:JSON, err:JSON) => void):void

	/** 获取屏幕宽高*/ 
	getScreenSize(callback?: (ret:JSON, err:JSON) => void):void

	/** 获取sim卡信息*/ 
	getSimInfo(callback?: (ret:JSON, err:JSON) => void):void

	/** 判断是否为系统应用*/ 
	isSystemApp(callback?: (ret:JSON, err:JSON) => void):void

	/** 获取应用签名*/ 
	getSignature(callback?: (ret:JSON, err:JSON) => void):void

	/** 设置壁纸*/ 
	setWallpaper(callback?: (ret:JSON, err:JSON) => void):void

	/** 安装应用包*/ 
	installApk():void

	/** 卸载应用*/ 
	unInstallApk():void

}
interface codeScan {
	/** 二维码,条形码扫描*/ 
	scan(callback?: (ret:JSON) => void):void

	/** 获取条形码base64图片*/ 
	getBarCode(callback?: (ret:JSON) => void):void

	/** 获取二维码base64图片*/ 
	getQRCode(callback?: (ret:JSON) => void):void

}
interface jumpbrowser {
}
interface QCloudCOS {
	/** 初始化模块,在调用其他接口之前Android必须先调用此接口,初始化接口只需要调用一次;*/ 
	init():void

	/**
	 * `上传文件`
	 * ========params==========
	 *
	 * `path` :string : 文件路径fs
	 *
	 * `bucket` :string : 存储桶名称
	 *
	 * `object` :string : （可选项）授予被授权者读写权限。格式同grantRead参数。
	 */
	beginUpload(params:QCloudCOS_beginUpload_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `取消上传`
	 * ========params==========
	 *
	 * `object` :string : 上传文件（对象）的文件名，也是对象的key
	 */
	abortUpload(params:QCloudCOS_abortUpload_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 取请求者名下的所有存储空间列表*/ 
	getService(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `复制文件`
	 * ========params==========
	 *
	 * `bucket` :string : 目的存储桶名
	 *
	 * `object` :string : 目的文件名
	 *
	 * `sourceBucket` :string : 复制的源文件所在的存储桶名，需要是公有读或者在当前账号有权限
	 *
	 * `sourceObject` :number : 复制的源文件的文件名
	 *
	 * `sourceAPPID` :string : 复制的源文件的APPID
	 *
	 * `sourceRegion` :string : 复制的源文件所在的区域
	 */
	copyObject(params:QCloudCOS_copyObject_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `创建存储桶`
	 * ========params==========
	 *
	 * `bucket` :string : 存储桶名
	 *
	 * `accessControlList` :Array : （可选项）授予被授权者子账号完全控制。子账号读的权限。数组中第一个值是主账号ID 第二个值是子账号ID,数组不传主账号授权
	 */
	putBucket(params:QCloudCOS_putBucket_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `列举存储桶内的内容`
	 * ========params==========
	 *
	 * `bucket` :string : 存储桶名，格式为 <bucketName>-<APPID> ,例如 testBucket-1253653367
	 *
	 * `prefix` :string : （可选项）前缀匹配，用来规定返回的文件前缀地址
	 *
	 * `delimiter` :string : （可选项）定界符为一个符号，如果有 Prefix，则将 Prefix 到 delimiter 之间的相同路径归为一类，定义为 Common Prefix，然后列出所有 Common Prefix。如果没有 Prefix，则从路径起点开始。可以将其理解为结束的符号，例如如果想要结尾是 A 的结果，那么将delimiter设置为 A 即可。
	 *
	 * `encodingType` :string : （可选项）规定返回值的编码方式，可选值：url
	 *
	 * `marker` :string : （可选项）默认以 UTF-8 二进制顺序列出条目，所有列出条目从 marker 开始
	 *
	 * `maxKeys` :number : （可选项）单次返回的最大条目数量，
	 */
	getBucket(params:QCloudCOS_getBucket_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 获取存储桶的 ACL（Access Control List）*/ 
	getBucketACL():void

	/**
	 * `设置存储桶的 ACL（Access Control List）`
	 * ========params==========
	 *
	 * `bucket` :string : 存储桶名，格式为 <bucketName>-<APPID> ,例如 testBucket-1253653367
	 *
	 * `accessControlList` :Array : （可选项）授予被授权者子账号完全控制。子账号读的权限。数组中第一个值是主账号ID 第二个值是子账号ID,数组不传主账号授权
	 */
	putBucketACL(params:QCloudCOS_putBucketACL_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取存储桶的 CORS(跨域访问)设置`
	 * ========params==========
	 *
	 * `bucket` :string : 存储桶名，格式为 <bucketName>-<APPID> ,例如 testBucket-1253653367
	 */
	getBucketCORS(params:QCloudCOS_getBucketCORS_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `设置存储桶的 CORS（跨域访问）`
	 * ========params==========
	 *
	 * `bucket` :string : 存储桶名，格式为 <bucketName>-<APPID> ,例如 testBucket-1253653367
	 *
	 * `rules` :Array<JSON> : 放置 CORS 的数组
	 */
	putBucketCORS(params:QCloudCOS_putBucketCORS_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `删除存储桶 CORS 设置`
	 * ========params==========
	 *
	 * `bucket` :string : 存储桶名，格式为 <bucketName>-<APPID> ,例如 testBucket-1253653367
	 */
	deleteBucketCORS(params:QCloudCOS_deleteBucketCORS_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取存储桶的地域信息`
	 * ========params==========
	 *
	 * `bucket` :string : 存储桶名，格式为 <bucketName>-<APPID> ,例如 testBucket-1253653367
	 */
	getBucketLocation(params:QCloudCOS_getBucketLocation_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `查询 Bucket 是否存在`
	 * ========params==========
	 *
	 * `bucket` :string : 存储桶名，格式为 <bucketName>-<APPID> ,例如 testBucket-1253653367
	 */
	headBucket(params:QCloudCOS_headBucket_Params, callback?: (ret:JSON) => void):void

	/**
	 * `- 类型：字符串类型`
	 * ========params==========
	 *
	 * `bucket` :string : 存储桶名，格式为 <bucketName>-<APPID> ,例如 testBucket-1253653367
	 */
	deleteBucketLifeCycle(params:QCloudCOS_deleteBucketLifeCycle_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `简单上传仅限于小文件（20MB以下）`
	 * ========params==========
	 *
	 * `path` :string : 文件路径，支持、fs
	 *
	 * `bucket` :string : 存储桶名,格式为<bucketName>-<APPID> ,例如 testBucket-1253653367
	 *
	 * `object` :Array : （可选项）授予被授权者子账号完全控制。子账号读的权限。数组中第一个值是主账号ID 第二个值是子账号ID,数组不传主账号授权
	 */
	putObject(params:QCloudCOS_putObject_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `下载Object文件`
	 * ========params==========
	 *
	 * `bucket` :string : 存储桶名,格式为<bucketName>-<APPID> ,例如 testBucket-1253653367
	 *
	 * `object` :string : 对象名
	 *
	 * `savePath` :string : 文件下载到本地文件夹的绝对路径(支持fs)
	 *
	 * `localFileName` :string : 下载到本地的文件的名字带有后缀如(4432.jpg)
	 *
	 * `range` :string : （可选项）设置响应头部中的 Content-Encoding 参数
	 */
	getObject(params:QCloudCOS_getObject_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `查询对象的 ACL（Access Control List）`
	 * ========params==========
	 *
	 * `bucket` :string : 存储桶名,格式为<bucketName>-<APPID> ,例如 testBucket-1253653367
	 *
	 * `object` :string : （可选项）指定多版本中的 Version ID
	 */
	getObjectACL(params:QCloudCOS_getObjectACL_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `设置对象的 ACL（Access Control List）`
	 * ========params==========
	 *
	 * `bucket` :string : 存储桶名,格式为<bucketName>-<APPID> ,例如 testBucket-1253653367
	 *
	 * `object` :string : 对象名
	 *
	 * `accessControlList` :Array : （可选项）授予被授权者子账号完全控制。子账号读的权限。数组中第一个值是主账号ID 第二个值是子账号ID,数组不传主账号授权
	 */
	putObjectACL(params:QCloudCOS_putObjectACL_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `Object 跨域访问配置的预请求  调用此接口之前需要先调用,putBucketCORS`
	 * ========params==========
	 *
	 * `bucket` :string : 存储桶名,格式为<bucketName>-<APPID> ,例如 testBucket-1253653367
	 *
	 * `object` :string : 对象键（Key）是对象在存储桶中的唯一标识。例如，在对象的访问域名 bucket1-1250000000.cos.ap-guangzhou.myqcloud.com/doc1/pic1.jpg 中，对象键为 doc1/pic1.jpg。更详细的描述可以参考[对象描述](https://cloud.tencent.com/document/product/436/13324)
	 *
	 * `accessControlRequestMethod	` :string : 模拟跨域访问的请求HTTP方法
	 *
	 * `origin` :string : 模拟跨域访问允许的访问来源，支持通配符 * , 格式为：协议://域名[:端口]如：http://www.qq.com
	 *
	 * `accessControlRequestHeaders` :Array : （可选项）	在发送 OPTIONS 请求时告知服务端，接下来的请求可以使用哪些自定义的 HTTP 请求头部，支持通配符 *
	 */
	optionsObject(params:QCloudCOS_optionsObject_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `删除单个对象`
	 * ========params==========
	 *
	 * `bucket` :string : 存储桶名,格式为<bucketName>-<APPID> ,例如 testBucket-1253653367
	 *
	 * `object` :string : 对象键（Key）是对象在存储桶中的唯一标识。例如，在对象的访问域名 bucket1-1250000000.cos.ap-guangzhou.myqcloud.com/doc1/pic1.jpg 中，对象键为 doc1/pic1.jpg。更详细的描述可以参考[对象描述](https://cloud.tencent.com/document/product/436/13324)
	 */
	deleteObject(params:QCloudCOS_deleteObject_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `删除多个对象`
	 * ========params==========
	 *
	 * `bucket` :string : 存储桶名,格式为<bucketName>-<APPID> ,例如 testBucket-1253653367
	 *
	 * `deleteObjects` :Array : 存放需要删除对象信息的数组
	 */
	deleteMultipleObject(params:QCloudCOS_deleteMultipleObject_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取对象meta信息`
	 * ========params==========
	 *
	 * `bucket` :string : 存储桶名,格式为<bucketName>-<APPID> ,例如 testBucket-1253653367
	 *
	 * `object` :string : （可选项）如果HEAD指定版本的Object,请在该参数中指定versionID（在开启了多版本的情况才有）
	 */
	headObject(params:QCloudCOS_headObject_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface QCloudCOS_beginUpload_Params {
	/**文件路径fs*/ 
	path:string,

	/**存储桶名称*/ 
	bucket:string,

	/**（可选项）授予被授权者读写权限。格式同grantRead参数。*/ 
	object?:string,

}

interface QCloudCOS_abortUpload_Params {
	/**上传文件（对象）的文件名，也是对象的key*/ 
	object:string,

}

interface QCloudCOS_copyObject_Params {
	/**目的存储桶名*/ 
	bucket:string,

	/**目的文件名*/ 
	object:string,

	/**复制的源文件所在的存储桶名，需要是公有读或者在当前账号有权限*/ 
	sourceBucket:string,

	/**复制的源文件的文件名*/ 
	sourceObject:number,

	/**复制的源文件的APPID*/ 
	sourceAPPID:string,

	/**复制的源文件所在的区域*/ 
	sourceRegion:string,

}

interface QCloudCOS_putBucket_Params {
	/**存储桶名*/ 
	bucket:string,

	/**（可选项）授予被授权者子账号完全控制。子账号读的权限。数组中第一个值是主账号ID 第二个值是子账号ID,数组不传主账号授权*/ 
	accessControlList?:Array,

}

interface QCloudCOS_getBucket_Params {
	/**存储桶名，格式为 <bucketName>-<APPID> ,例如 testBucket-1253653367*/ 
	bucket:string,

	/**（可选项）前缀匹配，用来规定返回的文件前缀地址*/ 
	prefix?:string,

	/**（可选项）定界符为一个符号，如果有 Prefix，则将 Prefix 到 delimiter 之间的相同路径归为一类，定义为 Common Prefix，然后列出所有 Common Prefix。如果没有 Prefix，则从路径起点开始。可以将其理解为结束的符号，例如如果想要结尾是 A 的结果，那么将delimiter设置为 A 即可。*/ 
	delimiter?:string,

	/**（可选项）规定返回值的编码方式，可选值：url*/ 
	encodingType?:string,

	/**（可选项）默认以 UTF-8 二进制顺序列出条目，所有列出条目从 marker 开始*/ 
	marker?:string,

	/**（可选项）单次返回的最大条目数量，*/ 
	maxKeys?:number,

}

interface QCloudCOS_putBucketACL_Params {
	/**存储桶名，格式为 <bucketName>-<APPID> ,例如 testBucket-1253653367*/ 
	bucket:string,

	/**（可选项）授予被授权者子账号完全控制。子账号读的权限。数组中第一个值是主账号ID 第二个值是子账号ID,数组不传主账号授权*/ 
	accessControlList?:Array,

}

interface QCloudCOS_getBucketCORS_Params {
	/**存储桶名，格式为 <bucketName>-<APPID> ,例如 testBucket-1253653367*/ 
	bucket:string,

}

interface QCloudCOS_putBucketCORS_Params {
	/**存储桶名，格式为 <bucketName>-<APPID> ,例如 testBucket-1253653367*/ 
	bucket:string,

	/**放置 CORS 的数组*/ 
	rules:Array<JSON>,

}

interface QCloudCOS_deleteBucketCORS_Params {
	/**存储桶名，格式为 <bucketName>-<APPID> ,例如 testBucket-1253653367*/ 
	bucket:string,

}

interface QCloudCOS_getBucketLocation_Params {
	/**存储桶名，格式为 <bucketName>-<APPID> ,例如 testBucket-1253653367*/ 
	bucket:string,

}

interface QCloudCOS_headBucket_Params {
	/**存储桶名，格式为 <bucketName>-<APPID> ,例如 testBucket-1253653367*/ 
	bucket:string,

}

interface QCloudCOS_deleteBucketLifeCycle_Params {
	/**存储桶名，格式为 <bucketName>-<APPID> ,例如 testBucket-1253653367*/ 
	bucket:string,

}

interface QCloudCOS_putObject_Params {
	/**文件路径，支持、fs*/ 
	path:string,

	/**存储桶名,格式为<bucketName>-<APPID> ,例如 testBucket-1253653367*/ 
	bucket:string,

	/**（可选项）授予被授权者子账号完全控制。子账号读的权限。数组中第一个值是主账号ID 第二个值是子账号ID,数组不传主账号授权*/ 
	object?:Array,

}

interface QCloudCOS_getObject_Params {
	/**存储桶名,格式为<bucketName>-<APPID> ,例如 testBucket-1253653367*/ 
	bucket:string,

	/**对象名*/ 
	object:string,

	/**文件下载到本地文件夹的绝对路径(支持fs)*/ 
	savePath:string,

	/**下载到本地的文件的名字带有后缀如(4432.jpg)*/ 
	localFileName:string,

	/**（可选项）设置响应头部中的 Content-Encoding 参数*/ 
	range?:string,

}

interface QCloudCOS_getObjectACL_Params {
	/**存储桶名,格式为<bucketName>-<APPID> ,例如 testBucket-1253653367*/ 
	bucket:string,

	/**（可选项）指定多版本中的 Version ID*/ 
	object?:string,

}

interface QCloudCOS_putObjectACL_Params {
	/**存储桶名,格式为<bucketName>-<APPID> ,例如 testBucket-1253653367*/ 
	bucket:string,

	/**对象名*/ 
	object:string,

	/**（可选项）授予被授权者子账号完全控制。子账号读的权限。数组中第一个值是主账号ID 第二个值是子账号ID,数组不传主账号授权*/ 
	accessControlList?:Array,

}

interface QCloudCOS_optionsObject_Params {
	/**存储桶名,格式为<bucketName>-<APPID> ,例如 testBucket-1253653367*/ 
	bucket:string,

	/**对象键（Key）是对象在存储桶中的唯一标识。例如，在对象的访问域名 bucket1-1250000000.cos.ap-guangzhou.myqcloud.com/doc1/pic1.jpg 中，对象键为 doc1/pic1.jpg。更详细的描述可以参考[对象描述](https://cloud.tencent.com/document/product/436/13324)*/ 
	object:string,

	/**模拟跨域访问的请求HTTP方法*/ 
	accessControlRequestMethod	:string,

	/**模拟跨域访问允许的访问来源，支持通配符 * , 格式为：协议://域名[:端口]如：http://www.qq.com*/ 
	origin:string,

	/**（可选项）	在发送 OPTIONS 请求时告知服务端，接下来的请求可以使用哪些自定义的 HTTP 请求头部，支持通配符 **/ 
	accessControlRequestHeaders?:Array,

}

interface QCloudCOS_deleteObject_Params {
	/**存储桶名,格式为<bucketName>-<APPID> ,例如 testBucket-1253653367*/ 
	bucket:string,

	/**对象键（Key）是对象在存储桶中的唯一标识。例如，在对象的访问域名 bucket1-1250000000.cos.ap-guangzhou.myqcloud.com/doc1/pic1.jpg 中，对象键为 doc1/pic1.jpg。更详细的描述可以参考[对象描述](https://cloud.tencent.com/document/product/436/13324)*/ 
	object:string,

}

interface QCloudCOS_deleteMultipleObject_Params {
	/**存储桶名,格式为<bucketName>-<APPID> ,例如 testBucket-1253653367*/ 
	bucket:string,

	/**存放需要删除对象信息的数组*/ 
	deleteObjects:Array,

}

interface QCloudCOS_headObject_Params {
	/**存储桶名,格式为<bucketName>-<APPID> ,例如 testBucket-1253653367*/ 
	bucket:string,

	/**（可选项）如果HEAD指定版本的Object,请在该参数中指定versionID（在开启了多版本的情况才有）*/ 
	object?:string,

}

interface hwTxtReader {
	/**
	 * `配置阅读相关基础设置，该配置在开打书籍前配置，如不配置则按系统默认设置运行。`
	 * ========params==========
	 *
	 * `switchDuration` :any : （可选项）翻页时间，时间越短翻页速度越快。建议不要太低，不要低于200。
	 *
	 * `margin` :any : （可选项）指定段落间距，建议在加载 文件/数据 前设置。传入时请勿传入px。
	 *
	 * `IsOnVertical` :boolean : （可选项）设置置横向或者竖向显示。
	 *
	 * `IsShowSpecialChar` :boolean : （可选项）英文、数字等特殊字符去除显示特定颜色。
	 */
	configBookView(params:hwTxtReader_configBookView_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `打开TXT书本`
	 * ========params==========
	 *
	 * `filePath` :string : （必须）文件绝对地址，如：storage/emulated/0/BaiduNetdisk/斗破苍穹.txt 或 /storage/emulated/0/BaiduNetdisk/斗破苍穹.txt
	 */
	openBook(params:hwTxtReader_openBook_Params):void

}
interface hwTxtReader_configBookView_Params {
	/**（可选项）翻页时间，时间越短翻页速度越快。建议不要太低，不要低于200。*/ 
	switchDuration?:any,

	/**（可选项）指定段落间距，建议在加载 文件/数据 前设置。传入时请勿传入px。*/ 
	margin?:any,

	/**（可选项）设置置横向或者竖向显示。*/ 
	IsOnVertical?:boolean,

	/**（可选项）英文、数字等特殊字符去除显示特定颜色。*/ 
	IsShowSpecialChar?:boolean,

}

interface hwTxtReader_openBook_Params {
	/**（必须）文件绝对地址，如：storage/emulated/0/BaiduNetdisk/斗破苍穹.txt 或 /storage/emulated/0/BaiduNetdisk/斗破苍穹.txt*/ 
	filePath:string,

}

interface videoTrans {
	/** 获取进度。*/ 
	progress():void

	/** 取消。*/ 
	cancel():void

	/** 清除mp4视频文件本地缓存。*/ 
	clearCache():void

}
interface zySmallVideo {
}
interface keepingAppAlive {
	/** 尽量保活进程不被杀死的方法。*/ 
	startKeepAlive(callback?: (ret:JSON) => void):void

	/** 设置闹钟的时间*/ 
	setAlarm(callback?: (ret:JSON) => void):void

	/** 获取所有的闹钟*/ 
	getAlarm():void

	/**
	 * `移除闹钟`
	 * ========params==========
	 *
	 * `alarmList` :Array : (可选项)需要移除的闹钟的数据；如果无此项，删除所有的闹钟
	 */
	removeAlarm(params:keepingAppAlive_removeAlarm_Params):void

}
interface keepingAppAlive_removeAlarm_Params {
	/**(可选项)需要移除的闹钟的数据；如果无此项，删除所有的闹钟*/ 
	alarmList?:Array,

}

interface inFile {
}
interface screenRecording {
	/**
	 * `显示一个打开录屏功能的按钮`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）按钮的位置及大小
	 *
	 * `fixedOn` :string : （可选项）按钮添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）按钮是否随所属 window 或 frame 滚动
	 *
	 * `buttonImg` :string : （可选项）按钮的图片路径，要求本地路径（widget://、fs://）
	 *
	 * `showsMicrophoneButton` :boolean : （可选项）开始录屏页面是否显示打开/关闭麦克风按钮
	 *
	 * `preferredExtension` :string : （可选项）支持录屏直播的 App 的 bundle ID。broadcastList 模块开的 App 列表，联系 App 的发布方获取其 bundle ID。
	 */
	open(params:screenRecording_open_Params):void

	/** 从屏幕中移除录屏按钮*/ 
	close():void

}
interface screenRecording_open_Params {
	/**（可选项）按钮的位置及大小*/ 
	rect?:JSON,

	/**（可选项）按钮添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）按钮是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

	/**（可选项）按钮的图片路径，要求本地路径（widget://、fs://）*/ 
	buttonImg?:string,

	/**（可选项）开始录屏页面是否显示打开/关闭麦克风按钮*/ 
	showsMicrophoneButton?:boolean,

	/**（可选项）支持录屏直播的 App 的 bundle ID。broadcastList 模块开的 App 列表，联系 App 的发布方获取其 bundle ID。*/ 
	preferredExtension?:string,

}

interface airPlay {
	/**
	 * `打开AirPlay按钮`
	 * ========params==========
	 *
	 * `center` :JSON : （可选项）AirPlay按钮的中心坐标
	 */
	open(params:airPlay_open_Params):void

	/** 关闭AirPlay按钮，注意关闭按钮并不能停止投屏*/ 
	close():void

	/** 隐藏AirPlay按钮*/ 
	hide():void

	/** 显示AirPlay按钮*/ 
	show():void

	/** 监听推送事件*/ 
	addEventlistener():void

}
interface airPlay_open_Params {
	/**（可选项）AirPlay按钮的中心坐标*/ 
	center?:JSON,

}

interface androidShortcut {
	/**
	 * `创建快捷方式`
	 * ========params==========
	 *
	 * `name` :string : 快捷方式名称
	 */
	createShortcut(params:androidShortcut_createShortcut_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface androidShortcut_createShortcut_Params {
	/**快捷方式名称*/ 
	name:string,

}

interface currentApp {
	/** 获取当前系统语言*/ 
	systemLanguage():void

	/** 获取地区*/ 
	localeIdentifier():void

	/** 获取 App 版本信息*/ 
	info():void

	/** 获取当前设备信息*/ 
	deviceInfo():void

}
interface iconToImage {
	/**
	 * `执行转换并保存`
	 * ========params==========
	 *
	 * `fontFile` :string : 字体文件路径，支持ttf格式，相对路径格式，如"../../css/iconfont.ttf"
	 *
	 * `upFile` :string : 更新描述文件保存路径，图片不需要每次都去转换保存，只有发生了变化才更新，绝对路径格式，如"box://image/iconToImageUp.json"
	 *
	 * `fontList` :Array : iconfont图片数组,如没有请写 fontList:[],
	 *
	 * `svgList` :Array : svg图片数组,如没有请写 svgList:[],
	 */
	go(params:iconToImage_go_Params, callback?: (ret:JSON) => void):void

}
interface iconToImage_go_Params {
	/**字体文件路径，支持ttf格式，相对路径格式，如"../../css/iconfont.ttf"*/ 
	fontFile:string,

	/**更新描述文件保存路径，图片不需要每次都去转换保存，只有发生了变化才更新，绝对路径格式，如"box://image/iconToImageUp.json"*/ 
	upFile:string,

	/**iconfont图片数组,如没有请写 fontList:[],*/ 
	fontList:Array,

	/**svg图片数组,如没有请写 svgList:[],*/ 
	svgList:Array,

}

interface photoPicker {
	/** 打开添加相册界面*/ 
	addPhoto(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `删除选取的相册的相册或视频`
	 * ========params==========
	 *
	 * `name` :string : 从相册中选取内容的名字。
	 */
	delectPhoto(params:photoPicker_delectPhoto_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取选取相册或视频的名字和地址`
	 * ========params==========
	 *
	 * `name` :string : 
	 */
	selectInfo(params:photoPicker_selectInfo_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface photoPicker_delectPhoto_Params {
	/**从相册中选取内容的名字。*/ 
	name:string,

}

interface photoPicker_selectInfo_Params {
	/***/ 
	name:string,

}

interface floatWords {
	/** 是否有悬浮权限(安卓会弹出悬浮权限申请界面)*/ 
	canDrawOverlays(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `打开预览视图`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）浏览器窗口的位置和大小，设置margin后，在不同手机上面会保持与父页面的各方向边距一致，而中间区域会自动扩充。建议使用margin布局，可以完美适配带smartBar的手机。**(注意：当fixed设置false时，margin界面布局会异常)**
	 *
	 * `fixedOn` :string : （可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 Window 或 Frame 滚动
	 *
	 * `backgroundColor` :string : （可选项）背景颜色
	 *
	 * `textColor` :string : （可选项）文字颜色
	 *
	 * `textSize` :number : （可选项）文字大小
	 *
	 * `radius` :number : （可选项）圆角
	 *
	 * `text` :string : （必填项）预览提词内容
	 *
	 * `isShowLine` :boolean : （可选项）是否显示中间标准线
	 *
	 * `isAudoPlay` :boolean : （可选项）预览时是否自动播放提词
	 *
	 * `speed` :number : （可选项）每秒显示帧数（1-100）
	 *
	 * `alpha` :number : （可选项）背景透明度（0-100）
	 *
	 * `countDown` :number : （可选项）倒计时开始数
	 */
	openView(params:floatWords_openView_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 隐藏预览视图*/ 
	hideView(callback?: (ret:JSON) => void):void

	/** 显示预览视图*/ 
	showView(callback?: (ret:JSON) => void):void

	/** 关闭预览视图*/ 
	closeView(callback?: (ret:JSON) => void):void

	/** 开始滚动播放*/ 
	startPlay():void

	/** 停止滚动播放*/ 
	stopPlay():void

	/**
	 * `更新样式`
	 * ========params==========
	 *
	 * `backgroundColor` :string : （可选项）背景颜色
	 *
	 * `textColor` :string : （可选项）文字颜色
	 *
	 * `textSize` :JSON : （可选项）文字大小
	 */
	updateStyle(params:floatWords_updateStyle_Params):void

	/**
	 * `更新播放速度`
	 * ========params==========
	 *
	 * `speed` :JSON : （可选项）每秒显示帧数(1-100)
	 */
	updateSpeed(params:floatWords_updateSpeed_Params):void

	/**
	 * `是否显示中间标准线`
	 * ========params==========
	 *
	 * `isShowLine` :JSON : （可选项）是否显示中间标准线
	 */
	setShowLine(params:floatWords_setShowLine_Params):void

	/**
	 * `开启画中画`
	 * ========params==========
	 *
	 * `videoType` :number : （可选项）悬浮窗显示比例(0->1:1 1->3:4 2->4:3 3->9:16 4->16:9)
	 *
	 * `countDown` :number : （可选项）倒计时开始数
	 */
	startPIP(params:floatWords_startPIP_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 停止画中画*/ 
	stopPIP():void

}
interface floatWords_openView_Params {
	/**（可选项）浏览器窗口的位置和大小，设置margin后，在不同手机上面会保持与父页面的各方向边距一致，而中间区域会自动扩充。建议使用margin布局，可以完美适配带smartBar的手机。**(注意：当fixed设置false时，margin界面布局会异常)***/ 
	rect?:JSON,

	/**（可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 Window 或 Frame 滚动*/ 
	fixed?:boolean,

	/**（可选项）背景颜色*/ 
	backgroundColor?:string,

	/**（可选项）文字颜色*/ 
	textColor?:string,

	/**（可选项）文字大小*/ 
	textSize?:number,

	/**（可选项）圆角*/ 
	radius?:number,

	/**（必填项）预览提词内容*/ 
	text:string,

	/**（可选项）是否显示中间标准线*/ 
	isShowLine?:boolean,

	/**（可选项）预览时是否自动播放提词*/ 
	isAudoPlay?:boolean,

	/**（可选项）每秒显示帧数（1-100）*/ 
	speed?:number,

	/**（可选项）背景透明度（0-100）*/ 
	alpha?:number,

	/**（可选项）倒计时开始数*/ 
	countDown?:number,

}

interface floatWords_updateStyle_Params {
	/**（可选项）背景颜色*/ 
	backgroundColor?:string,

	/**（可选项）文字颜色*/ 
	textColor?:string,

	/**（可选项）文字大小*/ 
	textSize?:JSON,

}

interface floatWords_updateSpeed_Params {
	/**（可选项）每秒显示帧数(1-100)*/ 
	speed?:JSON,

}

interface floatWords_setShowLine_Params {
	/**（可选项）是否显示中间标准线*/ 
	isShowLine?:JSON,

}

interface floatWords_startPIP_Params {
	/**（可选项）悬浮窗显示比例(0->1:1 1->3:4 2->4:3 3->9:16 4->16:9)*/ 
	videoType?:number,

	/**（可选项）倒计时开始数*/ 
	countDown?:number,

}

interface changeIcon {
}
interface netTime {
	/** 同步获取时间(时间戳)。如果无网络，返回的是0*/ 
	getTime():void

}
interface scrollVideoBd {
	/** 滑动播放器监听*/ 
	addEventListener():void

	/**
	 * `打开滑动播放器`
	 * ========params==========
	 *
	 * `rect` :JSON : （必填项）模块的位置及尺寸
	 *
	 * `fixedOn` :string : （可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window
	 *
	 * `fixed` :boolean : （（可选项）模块是否随所属 Window 或 Frame 滚动
	 *
	 * `userData` :any : （必填项）视频播放列表（最少传入1条记录）。
	 *
	 * `position` :number : （可选项）指定从播放列表中的第几条开始播放。
	 *
	 * `orientation` :number : （可选项）播放列表滑动方向(0:垂直滑动 1:水平滑动)。
	 *
	 * `options` :JSON : （可选项）设置播放器内核配置项(与userData内部options配置互斥)。
	 */
	openScrollVideo(params:scrollVideoBd_openScrollVideo_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 隐藏滑动播放器*/ 
	hideScrollVideo(callback?: (ret:JSON, err:JSON) => void):void

	/** 显示滑动播放器*/ 
	showScrollVideo():void

	/** 关闭滑动播放器*/ 
	closeScrollVideo(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `更新当前播放器样式`
	 * ========params==========
	 *
	 * `isClean` :boolean : （可选项）更新样式时是否清空原来存在的按钮。(true:清空 false:不清空)
	 *
	 * `styles` :any : （必填项）当前播放器播放的按钮样式更新。
	 */
	updateVideoStyle(params:scrollVideoBd_updateVideoStyle_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `添加一条记录`
	 * ========params==========
	 *
	 * `uid` :string : （必填项）播放ID
	 *
	 * `imageUrl` :string : （必填项）播放前的预览图片
	 *
	 * `videoUrl` :any : （必填项）播放的视频地址(支持http,https)
	 *
	 * `isLocalCache` :boolean : （可选项）是否本地缓存视频,音频;直播类不能缓存,开发者自行控制;(备注:iOS虽然缓存在本地了,但是不能完全离线播放;缓存文件在cache://文件目录下). (开启:true ; 不开启:false)
	 *
	 * `scalingMode` :number : （可选项）视频播放显示铺满模式（1:无缩放, 2:适应大小模式, 3:充满可视范围，可能会被裁剪, 4:缩放到充满视图）
	 *
	 * `placeholderColor` :string : （可选项）背景图的背景色。
	 *
	 * `placeholderImage` :string : （可选项）背景图未加载时显示的图片,当该值存在时，placeholderColor无效。
	 *
	 * `imageType` :number : （可选项）背景图渲染类型 0:图片拉伸填充(图片可能会变形) 1:图片拉伸至完全显示(图片不会变形) 2:图片拉伸至完全铺满填充(图片不会变形)
	 *
	 * `options` :JSON : （可选项）设置播放器内核配置项
	 *
	 * `styles` :any : （可选项）当前播放器播放的按钮样式更新。
	 */
	addVideoData(params:scrollVideoBd_addVideoData_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 暂停当前视频播放*/ 
	pause(callback?: (ret:JSON, err:JSON) => void):void

	/** 暂停后恢复播放当前视频*/ 
	play(callback?: (ret:JSON, err:JSON) => void):void

	/** 是否播放状态*/ 
	isPlaying():void

	/** 获取播放item总数*/ 
	itemCount():void

	/** 获取视频的时长*/ 
	getDuration():void

	/** 获取已经播放的时长*/ 
	getCurrentPosition():void

	/**
	 * `设置音量`
	 * ========params==========
	 *
	 * `volume` :number : （可选项）播放视频音量0-100。
	 */
	setVolume(params:scrollVideoBd_setVolume_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 删除当前播放item(当删除到最后剩余1条记录的时候就不能删除了)*/ 
	delCurrentItem(callback?: (ret:JSON, err:JSON) => void):void

	/** 获取已经缓存的时长*/ 
	getBufferPercentage():void

	/**
	 * `设置播放进度`
	 * ========params==========
	 *
	 * `process` :JSON : （可选项）播放视频进度值。
	 */
	seekTo(params:scrollVideoBd_seekTo_Params):void

	/**
	 * `播放指定序号视频`
	 * ========params==========
	 *
	 * `position` :number : （可选项）播放指定列表中序号视频。
	 */
	playSpecifiedItem(params:scrollVideoBd_playSpecifiedItem_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `添加多条记录`
	 * ========params==========
	 *
	 * `userData` :any : （必填项）视频播放列表（最少传入1条记录）。
	 */
	addVideoDatas(params:scrollVideoBd_addVideoDatas_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `控制按钮的显示和隐藏`
	 * ========params==========
	 *
	 * `tag` :number : （必填项）视图中按钮的tag值。
	 *
	 * `isShow` :boolean : （可选项）视图中按钮是否显示。
	 */
	setShowByTag(params:scrollVideoBd_setShowByTag_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `控制音乐图标是否暂停`
	 * ========params==========
	 *
	 * `tag` :number : （必填项）视图中按钮的tag值。
	 *
	 * `isRuning` :boolean : （可选项）音乐图标是否旋转。
	 */
	setMusicByTag(params:scrollVideoBd_setMusicByTag_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface scrollVideoBd_openScrollVideo_Params {
	/**（必填项）模块的位置及尺寸*/ 
	rect:JSON,

	/**（可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window*/ 
	fixedOn?:string,

	/**（（可选项）模块是否随所属 Window 或 Frame 滚动*/ 
	fixed?:boolean,

	/**（必填项）视频播放列表（最少传入1条记录）。*/ 
	userData:any,

	/**（可选项）指定从播放列表中的第几条开始播放。*/ 
	position?:number,

	/**（可选项）播放列表滑动方向(0:垂直滑动 1:水平滑动)。*/ 
	orientation?:number,

	/**（可选项）设置播放器内核配置项(与userData内部options配置互斥)。*/ 
	options?:JSON,

}

interface scrollVideoBd_updateVideoStyle_Params {
	/**（可选项）更新样式时是否清空原来存在的按钮。(true:清空 false:不清空)*/ 
	isClean?:boolean,

	/**（必填项）当前播放器播放的按钮样式更新。*/ 
	styles:any,

}

interface scrollVideoBd_addVideoData_Params {
	/**（必填项）播放ID*/ 
	uid:string,

	/**（必填项）播放前的预览图片*/ 
	imageUrl:string,

	/**（必填项）播放的视频地址(支持http,https)*/ 
	videoUrl:any,

	/**（可选项）是否本地缓存视频,音频;直播类不能缓存,开发者自行控制;(备注:iOS虽然缓存在本地了,但是不能完全离线播放;缓存文件在cache://文件目录下). (开启:true ; 不开启:false)*/ 
	isLocalCache?:boolean,

	/**（可选项）视频播放显示铺满模式（1:无缩放, 2:适应大小模式, 3:充满可视范围，可能会被裁剪, 4:缩放到充满视图）*/ 
	scalingMode?:number,

	/**（可选项）背景图的背景色。*/ 
	placeholderColor?:string,

	/**（可选项）背景图未加载时显示的图片,当该值存在时，placeholderColor无效。*/ 
	placeholderImage?:string,

	/**（可选项）背景图渲染类型 0:图片拉伸填充(图片可能会变形) 1:图片拉伸至完全显示(图片不会变形) 2:图片拉伸至完全铺满填充(图片不会变形)*/ 
	imageType?:number,

	/**（可选项）设置播放器内核配置项*/ 
	options?:JSON,

	/**（可选项）当前播放器播放的按钮样式更新。*/ 
	styles?:any,

}

interface scrollVideoBd_setVolume_Params {
	/**（可选项）播放视频音量0-100。*/ 
	volume?:number,

}

interface scrollVideoBd_seekTo_Params {
	/**（可选项）播放视频进度值。*/ 
	process?:JSON,

}

interface scrollVideoBd_playSpecifiedItem_Params {
	/**（可选项）播放指定列表中序号视频。*/ 
	position?:number,

}

interface scrollVideoBd_addVideoDatas_Params {
	/**（必填项）视频播放列表（最少传入1条记录）。*/ 
	userData:any,

}

interface scrollVideoBd_setShowByTag_Params {
	/**（必填项）视图中按钮的tag值。*/ 
	tag:number,

	/**（可选项）视图中按钮是否显示。*/ 
	isShow?:boolean,

}

interface scrollVideoBd_setMusicByTag_Params {
	/**（必填项）视图中按钮的tag值。*/ 
	tag:number,

	/**（可选项）音乐图标是否旋转。*/ 
	isRuning?:boolean,

}

interface promotionLink {
	/** 读取apk中的渠道字符串，前提是开发者已在服务器中用上文方法将字符串写入apk，此时本接口将返回写入apk的字符串，否则本接口将返回"null"。*/ 
	getChannelStr():void

}
interface arcColorPicker {
}
interface tencentOSS {
	/**
	 * `初始化`
	 * ========params==========
	 *
	 * `appid` :string : （必填项）在腾讯云创建“创建存储桶”名称后面跟随的固定id串,如：tyousan-1252112920,其中"1252112920"就是appid值。
	 *
	 * `secretId` :string : （必填项）在腾讯云申请的secretId。[见：[API密钥管理](https://console.cloud.tencent.com/cam/capi)]
	 *
	 * `secretKey` :string : （必填项）在腾讯云申请的secretKey。[见：[API密钥管理](https://console.cloud.tencent.com/cam/capi)]
	 *
	 * `region` :string : （必填项）腾讯云存储桶节点地址[ap-beijing-1,ap-beijing,ap-shanghai,ap-guangzhou,ap-guangzhou-2,ap-chengdu,ap-singapore,ap-hongkong,na-toronto,eu-frankfurt,cn-north,cn-south,cn-east,cn-southwest,sg]
	 */
	initUploadService(params:tencentOSS_initUploadService_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `上传文件`
	 * ========params==========
	 *
	 * `bucketName` :string : （必填项）存储桶名称。如：tyousan-1252112920,其中"tyousan"就是bucketName值。
	 *
	 * `cosPath` :string : （必填项）存储在腾讯云远端路径，即存储到 COS 上的绝对路径
	 *
	 * `srcPath` :string : （必填项）本地文件的绝对路径.(支持fs:// widget://)
	 */
	uploadFile(params:tencentOSS_uploadFile_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `下载文件`
	 * ========params==========
	 *
	 * `bucketName` :string : （必填项）存储桶名称。如：tyousan-1252112920,其中"tyousan"就是bucketName值。
	 *
	 * `cosPath` :string : （必填项）存储在腾讯云远端路径，即存储到 COS 上的绝对路径
	 *
	 * `srcPath` :string : （必填项）下载到本地的文件夹路径.(支持fs://)
	 */
	downloadFile(params:tencentOSS_downloadFile_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface tencentOSS_initUploadService_Params {
	/**（必填项）在腾讯云创建“创建存储桶”名称后面跟随的固定id串,如：tyousan-1252112920,其中"1252112920"就是appid值。*/ 
	appid:string,

	/**（必填项）在腾讯云申请的secretId。[见：[API密钥管理](https://console.cloud.tencent.com/cam/capi)]*/ 
	secretId:string,

	/**（必填项）在腾讯云申请的secretKey。[见：[API密钥管理](https://console.cloud.tencent.com/cam/capi)]*/ 
	secretKey:string,

	/**（必填项）腾讯云存储桶节点地址[ap-beijing-1,ap-beijing,ap-shanghai,ap-guangzhou,ap-guangzhou-2,ap-chengdu,ap-singapore,ap-hongkong,na-toronto,eu-frankfurt,cn-north,cn-south,cn-east,cn-southwest,sg]*/ 
	region:string,

}

interface tencentOSS_uploadFile_Params {
	/**（必填项）存储桶名称。如：tyousan-1252112920,其中"tyousan"就是bucketName值。*/ 
	bucketName:string,

	/**（必填项）存储在腾讯云远端路径，即存储到 COS 上的绝对路径*/ 
	cosPath:string,

	/**（必填项）本地文件的绝对路径.(支持fs:// widget://)*/ 
	srcPath:string,

}

interface tencentOSS_downloadFile_Params {
	/**（必填项）存储桶名称。如：tyousan-1252112920,其中"tyousan"就是bucketName值。*/ 
	bucketName:string,

	/**（必填项）存储在腾讯云远端路径，即存储到 COS 上的绝对路径*/ 
	cosPath:string,

	/**（必填项）下载到本地的文件夹路径.(支持fs://)*/ 
	srcPath:string,

}

interface recordScreen {
	/** 检查权限，然后请求创建一个录屏请求，系统会弹出一个询问框，用户授权后才可以进行录制和截屏*/ 
	init(callback?: (ret:JSON) => void):void

	/**
	 * `开始录屏，需要在init后调用`
	 * ========params==========
	 *
	 * `path` :string : 录制的视频存放的路径
	 *
	 * `width` :any : 视频分辨率-宽
	 *
	 * `height` :any : 视频分辨率-高
	 *
	 * `dpi` :any : DPI
	 *
	 * `bitrate` :any : 比特率
	 *
	 * `fps` :any : FPS
	 *
	 * `orientation` :any : 视频方向，指顺时针旋转的角度，可选值：0、90、180、270
	 */
	start(params:recordScreen_start_Params, callback?: (ret:JSON) => void):void

	/** 停止录屏，需要在init后调用*/ 
	stop(callback?: (ret:JSON) => void):void

	/** 暂停录屏，需要在init后调用，且录屏正在进行*/ 
	pause():void

	/** 继续录屏，需要在init后调用，且录屏处于暂停*/ 
	resume():void

	/** 释放录屏进程，下次录屏，需要再次调用init然后询问用户操作*/ 
	release(callback?: (ret:JSON) => void):void

	/**
	 * `截屏，需要在init后调用`
	 * ========params==========
	 *
	 * `path` :string : 截屏的图片存放的路径
	 *
	 * `width` :any : 图片分辨率-宽
	 *
	 * `height` :any : 图片分辨率-高
	 *
	 * `dpi` :any : DPI
	 */
	imgCapture(params:recordScreen_imgCapture_Params, callback?: (ret:JSON) => void):void

}
interface recordScreen_start_Params {
	/**录制的视频存放的路径*/ 
	path:string,

	/**视频分辨率-宽*/ 
	width:any,

	/**视频分辨率-高*/ 
	height:any,

	/**DPI*/ 
	dpi:any,

	/**比特率*/ 
	bitrate:any,

	/**FPS*/ 
	fps:any,

	/**视频方向，指顺时针旋转的角度，可选值：0、90、180、270*/ 
	orientation?:any,

}

interface recordScreen_imgCapture_Params {
	/**截屏的图片存放的路径*/ 
	path:string,

	/**图片分辨率-宽*/ 
	width:any,

	/**图片分辨率-高*/ 
	height:any,

	/**DPI*/ 
	dpi:any,

}

interface AppStoreGrade {
	/** App 内评分*/ 
	grade():void

	/** 跳转到 App Store 评分*/ 
	skipAppStoreGrade():void

}
interface magnifier {
	/**
	 * `打开一个放大镜并指定其所在 frame`
	 * ========params==========
	 *
	 * `fixedOn` :number : （可选项）放大镜大小
	 *
	 * `scale` :number : （可选项）放大镜放大倍数
	 *
	 * `borderWidth` :number : （可选项）放大镜边框粗细
	 *
	 * `borderColor` :string : （可选项）放大镜边框颜色，支持rgb、rgba、#
	 *
	 * `touchMove` :boolean : （可选项）是否可拖动（仅android支持）
	 *
	 * `point` :JSON : （可选项）放大镜位置
	 */
	open(params:magnifier_open_Params):void

	/** 关闭放大镜*/ 
	close():void

	/**
	 * `将放大镜移动到某个位置`
	 * ========params==========
	 *
	 * `point` :JSON : （可选项）放大镜位置
	 */
	moveTo(params:magnifier_moveTo_Params):void

}
interface magnifier_open_Params {
	/**（可选项）放大镜大小*/ 
	fixedOn?:number,

	/**（可选项）放大镜放大倍数*/ 
	scale?:number,

	/**（可选项）放大镜边框粗细*/ 
	borderWidth?:number,

	/**（可选项）放大镜边框颜色，支持rgb、rgba、#*/ 
	borderColor?:string,

	/**（可选项）是否可拖动（仅android支持）*/ 
	touchMove?:boolean,

	/**（可选项）放大镜位置*/ 
	point?:JSON,

}

interface magnifier_moveTo_Params {
	/**（可选项）放大镜位置*/ 
	point?:JSON,

}

interface downloadManager {
}
interface vtingPlayer {
	/**
	 * `播放网络音频，支持m3u8纯音频播放`
	 * ========params==========
	 *
	 * `url` :string : 音频资源地址
	 */
	play(params:vtingPlayer_play_Params, callback?: (ret:JSON) => void):void

	/** 暂停播放*/ 
	pause():void

	/** 停止播放*/ 
	stop():void

	/**
	 * `设置播放位置`
	 * ========params==========
	 *
	 * `progress` :number : 播放位置百分比，取值范围：0-100
	 */
	setProgress(params:vtingPlayer_setProgress_Params):void

	/**
	 * `设置当前播放内容锁屏显示信息`
	 * ========params==========
	 *
	 * `title` :string : （可选项）显示标题。
	 *
	 * `artist` :string : （可选项）显示作者。
	 *
	 * `zhuanji` :string : （可选项）显示专辑名。
	 */
	nowPlaying(params:vtingPlayer_nowPlaying_Params):void

}
interface vtingPlayer_play_Params {
	/**音频资源地址*/ 
	url:string,

}

interface vtingPlayer_setProgress_Params {
	/**播放位置百分比，取值范围：0-100*/ 
	progress:number,

}

interface vtingPlayer_nowPlaying_Params {
	/**（可选项）显示标题。*/ 
	title?:string,

	/**（可选项）显示作者。*/ 
	artist?:string,

	/**（可选项）显示专辑名。*/ 
	zhuanji?:string,

}

interface easyVideoCompression {
	/**
	 * `传入视频压缩倍数及压缩动画显隐参数`
	 * ========params==========
	 *
	 * `cpRatio` :string : null
	 */
	easyCompression(params:easyVideoCompression_easyCompression_Params, callback?: (ret:JSON) => void):void

	/** 无需传值及返回值*/ 
	easyClearCache():void

}
interface easyVideoCompression_easyCompression_Params {
	/**null*/ 
	cpRatio:string,

}

interface cameraView {
}
interface getFile {
	/** 打开Android手机文件浏览器*/ 
	open(callback?: (ret:JSON) => void):void

}
interface planNotify {
	/** 打开自定义通知*/ 
	open(callback?: (ret:JSON, err:JSON) => void):void

	/** 关闭自定义通知*/ 
	close(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `计划提醒通知`
	 * ========params==========
	 *
	 * `notifyId` :number : 通知id，可根据此id关闭通知。id相同仅显示最后一个通知，id不同分别展示
	 *
	 * `localId` :string : 本地行程id
	 *
	 * `tripId` :string : 行程id
	 *
	 * `title` :string : 计划title
	 *
	 * `content` :string : 计划内容
	 *
	 * `extra` :string : （可选项）附加内容
	 */
	planRemind(params:planNotify_planRemind_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `取消提醒`
	 * ========params==========
	 *
	 * `notifyId` :number : 通知id，planRemind 接口中返回notifyId
	 */
	cancleRemind(params:planNotify_cancleRemind_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 设置计划提醒通知中【将此事项标记已完成】点击监听*/ 
	setFinishPlanListener(callback?: (ret:JSON, err:JSON) => void):void

	/** 取消计划提醒通知中【将此事项标记已完成】点击监听*/ 
	cancleFinishPlanListener(callback?: (ret:JSON, err:JSON) => void):void

}
interface planNotify_planRemind_Params {
	/**通知id，可根据此id关闭通知。id相同仅显示最后一个通知，id不同分别展示*/ 
	notifyId:number,

	/**本地行程id*/ 
	localId:string,

	/**行程id*/ 
	tripId:string,

	/**计划title*/ 
	title:string,

	/**计划内容*/ 
	content:string,

	/**（可选项）附加内容*/ 
	extra?:string,

}

interface planNotify_cancleRemind_Params {
	/**通知id，planRemind 接口中返回notifyId*/ 
	notifyId:number,

}

interface dvMonitor {
	/** 注册设备监听事件*/ 
	addListener():void

	/** 移除设备监听*/ 
	removeListener():void

}
interface audioCover {
}
interface mobtools {
}
interface imageCrop {
}
interface APKCheck {
	/** 检测设备是否root*/ 
	isRoot():void

	/** 应用是否运行在模拟器中*/ 
	isEmulator():void

	/** 是否存在应用多开*/ 
	hasDoubleApK():void

	/** 检测某个应用是否安装*/ 
	isAppInstalled(callback?: (ret:JSON) => void):void

}
interface ACScanner {
	/**
	 * `打开扫描控件`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）扫描器的位置及尺寸，**在安卓平台宽高比须跟屏幕宽高比一致，否则摄像头可视区域的图像可能出现少许变形；w和h属性最好使用api.winWidth和api.winHeight,这样不会导致变形，也不会出现手机必须要在一定的距离上才能扫描出来的现象**
	 *
	 * `scanAnim` :JSON : （可选项）扫描动画配置
	 *
	 * `scanType` :number : （可选项）扫描码类型
	 *
	 * `sound` :string : （可选项）扫描结束后的提示音文件路径，要求本地路径（fs://、widget://），endSound为true时有效**为保证兼容性，推荐使用 wav 格式的短音频文件**
	 *
	 * `scanInterval` :number : （可选项）连续扫描间隔；单位：秒
	 *
	 * `scanStill` :boolean : （可选项）是否连续扫描；
	 *
	 * `isDrawQRCodeRect` :boolean : (可选项) 是否开启二维码自动对焦
	 *
	 * `cameraDirection` :string : (可选项) 摄像头方向
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	openScan(params:ACScanner_openScan_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 关闭扫描控件*/ 
	closeScan(callback?: (ret:JSON, err:JSON) => void):void

	/** 显示控件，打开以后有效*/ 
	show(callback?: (ret:JSON, err:JSON) => void):void

	/** 隐藏控件，打开以后有效*/ 
	hide(callback?: (ret:JSON, err:JSON) => void):void

	/** 开关灯*/ 
	flash(callback?: (ret:JSON, err:JSON) => void):void

	/** 生成二维码*/ 
	encodeQR(callback?: (ret:JSON, err:JSON) => void):void

	/** 解码二维码*/ 
	decodeQR(callback?: (ret:JSON, err:JSON) => void):void

}
interface ACScanner_openScan_Params {
	/**（可选项）扫描器的位置及尺寸，**在安卓平台宽高比须跟屏幕宽高比一致，否则摄像头可视区域的图像可能出现少许变形；w和h属性最好使用api.winWidth和api.winHeight,这样不会导致变形，也不会出现手机必须要在一定的距离上才能扫描出来的现象***/ 
	rect?:JSON,

	/**（可选项）扫描动画配置*/ 
	scanAnim?:JSON,

	/**（可选项）扫描码类型*/ 
	scanType?:number,

	/**（可选项）扫描结束后的提示音文件路径，要求本地路径（fs://、widget://），endSound为true时有效**为保证兼容性，推荐使用 wav 格式的短音频文件***/ 
	sound?:string,

	/**（可选项）连续扫描间隔；单位：秒*/ 
	scanInterval?:number,

	/**（可选项）是否连续扫描；*/ 
	scanStill?:boolean,

	/**(可选项) 是否开启二维码自动对焦*/ 
	isDrawQRCodeRect?:boolean,

	/**(可选项) 摄像头方向*/ 
	cameraDirection?:string,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface videoRecorder {
	/**
	 * `打开录像机`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `size` :JSON : （可选项）录制的视频大小。暂仅支持iOS
	 *
	 * `fps` :number : （可选项）帧率，暂仅支持iOS平台
	 *
	 * `quality` :string : （可选项）录像视频质量
	 *
	 * `orientation` :string : （可选项）录制的视频的方向
	 *
	 * `saveToAlbum` :boolean : （可选项）录制的视频是否自动保存到系统相册（系统媒体库）
	 *
	 * `save` :JSON : （可选项）录制的视频保存信息配置
	 *
	 * `camera` :string : （可选项）摄像头
	 *
	 * `isAudio` :boolean : （可选项）是否开启麦克风录取音频（此参数仅支持iOS）
	 *
	 * `fixedOn` :string : （可选项）模块添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	open(params:videoRecorder_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `设置摄像头方向，请在调用 start 接口之前调用`
	 * ========params==========
	 *
	 * `target` :string : （可选项）设置方向的对象
	 *
	 * `orientation` :string : （可选项）录制的视频的方向
	 */
	setOrientation(params:videoRecorder_setOrientation_Params):void

	/**
	 * `开始录像`
	 * ========params==========
	 *
	 * `timer` :number : （可选项）视频录制倒计时计时器，单位为秒（s)，亦可通过 stop 接口停止录像
	 *
	 * `save` :JSON : （可选项）录制的视频保存信息配置，若本参数不传，则以open 接口内的 save参数为准
	 *
	 * `audioUrl` :string : （可选项）视频背景音乐地址，支持widget、fs
	 *
	 * `isMute` :boolean : （可选项）是否静音录制
	 */
	start(params:videoRecorder_start_Params):void

	/** 停止录像*/ 
	stop():void

	/** 关闭录像机*/ 
	close():void

	/** 显示已隐藏的录像机*/ 
	show():void

	/** 隐藏录像机，并没有从内存里清除*/ 
	hide():void

	/**
	 * `重设拍摄区域的大小和位置`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）重设模块的位置及尺寸
	 */
	setRect(params:videoRecorder_setRect_Params):void

	/** 获取录像机当前缩放数值*/ 
	getZoom():void

	/**
	 * `设置视图大小，若为 2 则表示远视图被放大一倍`
	 * ========params==========
	 *
	 * `zoom` :number : （可选项）设置的焦距大小（视图被放大的倍数），取值范围：大于 1.0
	 */
	setZoom(params:videoRecorder_setZoom_Params):void

	/** 获取当前闪关灯状态*/ 
	getFlashlight():void

	/**
	 * `设置闪关灯，在 iOS 平台上，前置摄像头打开时不支持操作闪光灯`
	 * ========params==========
	 *
	 * `flashlight` :string : （可选项）闪光灯类型
	 */
	setFlashlight(params:videoRecorder_setFlashlight_Params):void

	/** 获取当前占用的摄像头*/ 
	getCamera():void

	/**
	 * `设置前置/后置摄像头`
	 * ========params==========
	 *
	 * `camera` :string : （可选项）摄像头
	 *
	 * `animation` :boolean : （可选项）切换摄像头时是否带动画效果，本参数暂仅支持iOS平台
	 */
	setCamera(params:videoRecorder_setCamera_Params):void

	/**
	 * `设置当前录像机对焦模式，配合 setFocusRegion 接口使用`
	 * ========params==========
	 *
	 * `focusMode` :string : （可选项）对焦模式
	 */
	setFocusMode(params:videoRecorder_setFocusMode_Params):void

	/**
	 * `设置当前录像机对焦区域，需要跟 setFocusMode 接口同时使用。`
	 * ========params==========
	 *
	 * `region` :JSON : （可选项）焦点坐标（在录像区域内的坐标，原点在该区域左上角，往右为x轴，下为y轴）
	 */
	setFocusRegion(params:videoRecorder_setFocusRegion_Params):void

	/**
	 * `设置当前录像机对焦提示框样式`
	 * ========params==========
	 *
	 * `box` :string : （可选项）对焦提示框样式配置，该提示框是一个空心的正方形框。当调用setFocusRegion接口时，如果 animation 参数为 true，该提示框的显示与隐藏会有动画。
	 *
	 * `icon` :string : （可选项）自定义的提示框图标路径，要求本地路径（支持fs://、widget://协议），图标大小为：80*80
	 *
	 * `autoHide` :number : （可选项）设置对焦提示框自动隐藏时间，当为 -1 时，不自动隐藏，需调用 hideFocusBox 接口手动隐藏
	 *
	 * `animation` :boolean : （可选项）设置对焦提示框显示和隐藏时是否使用动画
	 */
	setFocusBox(params:videoRecorder_setFocusBox_Params):void

	/** 隐藏对焦提示框*/ 
	hideFocusBox():void

	/**
	 * `事件监听`
	 * ========params==========
	 *
	 * `name` :string : 监听的事件类型
	 */
	addEventListener(params:videoRecorder_addEventListener_Params, callback?: (ret:JSON) => void):void

	/** 开始录像后的监听，此接口只适用于android；*/ 
	startCallback():void

	/**
	 * `拍照`
	 * ========params==========
	 *
	 * `album` :boolean : （可选项）照片是否保存到相册，需要申请相关权限
	 *
	 * `path` :string : （可选项）拍照保存地址，需要写明后缀名jpg，如：fs://abc.jpg
	 *
	 * `quality` :any : （可选项）照片质量，取值 0-1.0
	 */
	takePhoto(params:videoRecorder_takePhoto_Params, callback?: (ret:JSON) => void):void

	/**
	 * `对录制视频截图，本接口暂仅支持iOS端`
	 * ========params==========
	 *
	 * `album` :boolean : （可选项）照片是否保存到相册，需要申请相关权限
	 *
	 * `path` :string : （可选项）拍照保存地址，需要写明后缀名jpg，如：fs://abc.jpg
	 */
	videoShot(params:videoRecorder_videoShot_Params, callback?: (ret:JSON) => void):void

	/** 获取当前设备方向*/ 
	getDeviceOrientation():void

	/**
	 * `视频音频合成，本接口仅支持iOS端`
	 * ========params==========
	 *
	 * `videoUrl` :string : （可选项）视频路径，支持widget、fs
	 *
	 * `audioUrl` :string : （可选项）视频背景音乐地址，支持widget、fs
	 */
	compose(params:videoRecorder_compose_Params, callback?: (ret:JSON) => void):void

}
interface videoRecorder_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**（可选项）录制的视频大小。暂仅支持iOS*/ 
	size?:JSON,

	/**（可选项）帧率，暂仅支持iOS平台*/ 
	fps?:number,

	/**（可选项）录像视频质量*/ 
	quality?:string,

	/**（可选项）录制的视频的方向*/ 
	orientation?:string,

	/**（可选项）录制的视频是否自动保存到系统相册（系统媒体库）*/ 
	saveToAlbum?:boolean,

	/**（可选项）录制的视频保存信息配置*/ 
	save?:JSON,

	/**（可选项）摄像头*/ 
	camera?:string,

	/**（可选项）是否开启麦克风录取音频（此参数仅支持iOS）*/ 
	isAudio?:boolean,

	/**（可选项）模块添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface videoRecorder_setOrientation_Params {
	/**（可选项）设置方向的对象*/ 
	target?:string,

	/**（可选项）录制的视频的方向*/ 
	orientation?:string,

}

interface videoRecorder_start_Params {
	/**（可选项）视频录制倒计时计时器，单位为秒（s)，亦可通过 stop 接口停止录像*/ 
	timer?:number,

	/**（可选项）录制的视频保存信息配置，若本参数不传，则以open 接口内的 save参数为准*/ 
	save?:JSON,

	/**（可选项）视频背景音乐地址，支持widget、fs*/ 
	audioUrl?:string,

	/**（可选项）是否静音录制*/ 
	isMute?:boolean,

}

interface videoRecorder_setRect_Params {
	/**（可选项）重设模块的位置及尺寸*/ 
	rect?:JSON,

}

interface videoRecorder_setZoom_Params {
	/**（可选项）设置的焦距大小（视图被放大的倍数），取值范围：大于 1.0*/ 
	zoom?:number,

}

interface videoRecorder_setFlashlight_Params {
	/**（可选项）闪光灯类型*/ 
	flashlight?:string,

}

interface videoRecorder_setCamera_Params {
	/**（可选项）摄像头*/ 
	camera?:string,

	/**（可选项）切换摄像头时是否带动画效果，本参数暂仅支持iOS平台*/ 
	animation?:boolean,

}

interface videoRecorder_setFocusMode_Params {
	/**（可选项）对焦模式*/ 
	focusMode?:string,

}

interface videoRecorder_setFocusRegion_Params {
	/**（可选项）焦点坐标（在录像区域内的坐标，原点在该区域左上角，往右为x轴，下为y轴）*/ 
	region?:JSON,

}

interface videoRecorder_setFocusBox_Params {
	/**（可选项）对焦提示框样式配置，该提示框是一个空心的正方形框。当调用setFocusRegion接口时，如果 animation 参数为 true，该提示框的显示与隐藏会有动画。*/ 
	box?:string,

	/**（可选项）自定义的提示框图标路径，要求本地路径（支持fs://、widget://协议），图标大小为：80*80*/ 
	icon?:string,

	/**（可选项）设置对焦提示框自动隐藏时间，当为 -1 时，不自动隐藏，需调用 hideFocusBox 接口手动隐藏*/ 
	autoHide?:number,

	/**（可选项）设置对焦提示框显示和隐藏时是否使用动画*/ 
	animation?:boolean,

}

interface videoRecorder_addEventListener_Params {
	/**监听的事件类型*/ 
	name:string,

}

interface videoRecorder_takePhoto_Params {
	/**（可选项）照片是否保存到相册，需要申请相关权限*/ 
	album?:boolean,

	/**（可选项）拍照保存地址，需要写明后缀名jpg，如：fs://abc.jpg*/ 
	path?:string,

	/**（可选项）照片质量，取值 0-1.0*/ 
	quality?:any,

}

interface videoRecorder_videoShot_Params {
	/**（可选项）照片是否保存到相册，需要申请相关权限*/ 
	album?:boolean,

	/**（可选项）拍照保存地址，需要写明后缀名jpg，如：fs://abc.jpg*/ 
	path?:string,

}

interface videoRecorder_compose_Params {
	/**（可选项）视频路径，支持widget、fs*/ 
	videoUrl?:string,

	/**（可选项）视频背景音乐地址，支持widget、fs*/ 
	audioUrl?:string,

}

interface huaweiObs {
	/** 服务初始化*/ 
	init():void

	/**
	 * `流式上传对象`
	 * ========params==========
	 *
	 * `bucket` :string : 文件存储桶的名称，如：module-wkz
	 *
	 * `objectKey` :string : 文件存储在云上的命名，如：test/test.jpg，云会自动创建test文件夹，以便存储文件
	 *
	 * `uploadType` :number : 上传的类型
	 *
	 * `uploadFile` :string : 上传对象，uploadType为1时传入字符串，uploadType为2时传入网络地址，uploadType为3时需上传本地文件路径，要求本地路径（fs://、widget://）
	 */
	putData(params:huaweiObs_putData_Params, callback?: (ret:JSON) => void):void

	/**
	 * `上传文件`
	 * ========params==========
	 *
	 * `bucket` :string : 文件存储桶的名称，如：module-wkz
	 *
	 * `objectKey` :string : 文件存储在云上的命名，如：test/test.jpg，云会自动创建test文件夹，以便存储文件
	 *
	 * `uploadFile` :string : 上传对象，需上传本地文件路径，要求本地路径（fs://、widget://）
	 */
	putFile(params:huaweiObs_putFile_Params, callback?: (ret:JSON) => void):void

	/**
	 * `下载文件`
	 * ========params==========
	 *
	 * `bucket` :string : 文件存储桶的名称，如：module-wkz
	 *
	 * `objectKey` :string : 文件存储在云上的命名，如：test/test.jpg
	 *
	 * `downloadFile` :string : 文件下载后的路径, 如：test.jpg
	 */
	downloadObject(params:huaweiObs_downloadObject_Params, callback?: (ret:JSON) => void):void

	/**
	 * `删除文件`
	 * ========params==========
	 *
	 * `bucket` :string : 文件存储桶的名称，如：module-wkz
	 *
	 * `objectKey` :string : 文件存储在云上的命名，如：test/test.jpg
	 */
	deleteObject(params:huaweiObs_deleteObject_Params, callback?: (ret:JSON) => void):void

	/**
	 * `多文件删除`
	 * ========params==========
	 *
	 * `bucket` :string : 文件存储桶的名称，如：module-wkz
	 *
	 * `objectKeys` :Array : 数组内部为文件在华为云上的命名
	 */
	deletesObject(params:huaweiObs_deletesObject_Params, callback?: (ret:JSON) => void):void

	/**
	 * `复制文件`
	 * ========params==========
	 *
	 * `srcBucket` :string : 目标文件存储桶的名称，如：module-wkz
	 *
	 * `srcObjectKey` :string : 目标文件存储在云上的命名，如：test/test1.jpg
	 *
	 * `dstBucket` :string : 复制文件存储桶的名称，如：module-wkz
	 *
	 * `dstObjectKey` :string : 复制文件存储在云上的命名，如：test/test2.jpg
	 */
	copyObject(params:huaweiObs_copyObject_Params, callback?: (ret:JSON) => void):void

}
interface huaweiObs_putData_Params {
	/**文件存储桶的名称，如：module-wkz*/ 
	bucket:string,

	/**文件存储在云上的命名，如：test/test.jpg，云会自动创建test文件夹，以便存储文件*/ 
	objectKey:string,

	/**上传的类型*/ 
	uploadType:number,

	/**上传对象，uploadType为1时传入字符串，uploadType为2时传入网络地址，uploadType为3时需上传本地文件路径，要求本地路径（fs://、widget://）*/ 
	uploadFile:string,

}

interface huaweiObs_putFile_Params {
	/**文件存储桶的名称，如：module-wkz*/ 
	bucket:string,

	/**文件存储在云上的命名，如：test/test.jpg，云会自动创建test文件夹，以便存储文件*/ 
	objectKey:string,

	/**上传对象，需上传本地文件路径，要求本地路径（fs://、widget://）*/ 
	uploadFile:string,

}

interface huaweiObs_downloadObject_Params {
	/**文件存储桶的名称，如：module-wkz*/ 
	bucket:string,

	/**文件存储在云上的命名，如：test/test.jpg*/ 
	objectKey:string,

	/**文件下载后的路径, 如：test.jpg*/ 
	downloadFile:string,

}

interface huaweiObs_deleteObject_Params {
	/**文件存储桶的名称，如：module-wkz*/ 
	bucket:string,

	/**文件存储在云上的命名，如：test/test.jpg*/ 
	objectKey:string,

}

interface huaweiObs_deletesObject_Params {
	/**文件存储桶的名称，如：module-wkz*/ 
	bucket:string,

	/**数组内部为文件在华为云上的命名*/ 
	objectKeys:Array,

}

interface huaweiObs_copyObject_Params {
	/**目标文件存储桶的名称，如：module-wkz*/ 
	srcBucket:string,

	/**目标文件存储在云上的命名，如：test/test1.jpg*/ 
	srcObjectKey:string,

	/**复制文件存储桶的名称，如：module-wkz*/ 
	dstBucket:string,

	/**复制文件存储在云上的命名，如：test/test2.jpg*/ 
	dstObjectKey:string,

}

interface startupObject {
	/** 获取手机卡运营商信息、网络信息和信号强度信息*/ 
	startup(callback?: (ret:JSON, err:JSON) => void):void

}
interface vtb {
	/** 获取视频首帧封面*/ 
	getFirstImage(callback?: (ret:JSON) => void):void

	/** 视频生成gif动画*/ 
	getGif():void

}
interface aliCloudOss {
	/**
	 * `初始化sdk （调用优先级最高，只需要调用一次）`
	 * ========params==========
	 *
	 * `accessKey` :string : （可选项）从阿里云获取的accessKeyId
	 *
	 * `secretKey` :string : （可选项）从阿里云获取的accessKeySecret
	 *
	 * `endpoint` :string : （可选项）阿里云OSS服务在各个区域的地址，如：[https://oss-cn-shenzhen.aliyuncs.com](https://help.aliyun.com/document_detail/31837.html)
	 */
	init(params:aliCloudOss_init_Params, callback?: (ret:JSON) => void):void

	/**
	 * `上传文件`
	 * ========params==========
	 *
	 * `bucket` :string : 文件存储桶的名称，如：module-wkz
	 *
	 * `objectKey` :string : 文件存储在云上的命名，如：test/test.jpg，云会自动创建test文件夹，以便存储文件
	 *
	 * `filePath` :string : 上传对象，需上传本地文件路径，支持fs://、widget://等文件路径协议及真实路径
	 */
	putObject(params:aliCloudOss_putObject_Params, callback?: (ret:JSON) => void):void

	/**
	 * `下载文件`
	 * ========params==========
	 *
	 * `bucket` :string : 文件存储桶的名称，如：module-wkz
	 *
	 * `objectKey` :string : 文件存储在云上的命名，如：test/test.jpg
	 *
	 * `filePath` :string : 文件下载后的路径, 如：test.jpg
	 *
	 * `xOssProcess` :string : （可选项）下载图片时对图片进行处理的命令, 如：[image/circle,r_100](https://help.aliyun.com/document_detail/44686.html)
	 */
	downloadObject(params:aliCloudOss_downloadObject_Params, callback?: (ret:JSON) => void):void

	/**
	 * `删除文件`
	 * ========params==========
	 *
	 * `bucket` :string : 文件存储桶的名称，如：module-wkz
	 *
	 * `objectKey` :string : 文件存储在云上的命名，如：test/test.jpg
	 */
	deleteObject(params:aliCloudOss_deleteObject_Params, callback?: (ret:JSON) => void):void

	/**
	 * `复制文件`
	 * ========params==========
	 *
	 * `srcBucket` :string : 目标文件存储桶的名称，如：module-wkz
	 *
	 * `srcObjectKey` :string : 目标文件存储在云上的命名，如：test/test1.jpg
	 *
	 * `dstBucket` :string : 复制文件存储桶的名称，如：module-wkz
	 *
	 * `dstObjectKey` :string : 复制文件存储在云上的命名，如：test/test2.jpg
	 */
	copyObject(params:aliCloudOss_copyObject_Params, callback?: (ret:JSON) => void):void

}
interface aliCloudOss_init_Params {
	/**（可选项）从阿里云获取的accessKeyId*/ 
	accessKey?:string,

	/**（可选项）从阿里云获取的accessKeySecret*/ 
	secretKey?:string,

	/**（可选项）阿里云OSS服务在各个区域的地址，如：[https://oss-cn-shenzhen.aliyuncs.com](https://help.aliyun.com/document_detail/31837.html)*/ 
	endpoint?:string,

}

interface aliCloudOss_putObject_Params {
	/**文件存储桶的名称，如：module-wkz*/ 
	bucket:string,

	/**文件存储在云上的命名，如：test/test.jpg，云会自动创建test文件夹，以便存储文件*/ 
	objectKey:string,

	/**上传对象，需上传本地文件路径，支持fs://、widget://等文件路径协议及真实路径*/ 
	filePath:string,

}

interface aliCloudOss_downloadObject_Params {
	/**文件存储桶的名称，如：module-wkz*/ 
	bucket:string,

	/**文件存储在云上的命名，如：test/test.jpg*/ 
	objectKey:string,

	/**文件下载后的路径, 如：test.jpg*/ 
	filePath:string,

	/**（可选项）下载图片时对图片进行处理的命令, 如：[image/circle,r_100](https://help.aliyun.com/document_detail/44686.html)*/ 
	xOssProcess?:string,

}

interface aliCloudOss_deleteObject_Params {
	/**文件存储桶的名称，如：module-wkz*/ 
	bucket:string,

	/**文件存储在云上的命名，如：test/test.jpg*/ 
	objectKey:string,

}

interface aliCloudOss_copyObject_Params {
	/**目标文件存储桶的名称，如：module-wkz*/ 
	srcBucket:string,

	/**目标文件存储在云上的命名，如：test/test1.jpg*/ 
	srcObjectKey:string,

	/**复制文件存储桶的名称，如：module-wkz*/ 
	dstBucket:string,

	/**复制文件存储在云上的命名，如：test/test2.jpg*/ 
	dstObjectKey:string,

}

interface openAppStore {
	/**
	 * `在app内打开应用`
	 * ========params==========
	 *
	 * `appID` :string : 应用的唯一标示（可在iTunes上查看）
	 */
	inApp(params:openAppStore_inApp_Params):void

	/**
	 * `在AppStore里面打开应用`
	 * ========params==========
	 *
	 * `appID` :string : 应用的唯一标示（可在iTunes上查看）
	 */
	appStore(params:openAppStore_appStore_Params):void

}
interface openAppStore_inApp_Params {
	/**应用的唯一标示（可在iTunes上查看）*/ 
	appID:string,

}

interface openAppStore_appStore_Params {
	/**应用的唯一标示（可在iTunes上查看）*/ 
	appID:string,

}

interface dkplayer {
	/**
	 * `打开播放器`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `coverImg` :string : （可选项）播放器的封面
	 *
	 * `url` :string : 播放地址
	 *
	 * `title` :string : （可选项）播放器的标题
	 *
	 * `autoPlay` :boolean : （可选项）是否自动播放视频
	 *
	 * `enableFull` :boolean : （可选项）是否全屏播放
	 *
	 * `isLive` :boolean : （可选项）是否是直播
	 *
	 * `animation` :boolean : （可选项）打开播放器是否使用动画
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 */
	open(params:dkplayer_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `设置播放地址`
	 * ========params==========
	 *
	 * `url` :string : 播放地址
	 *
	 * `title` :string : 播放标题，默认为url地址
	 *
	 * `autoPlay` :boolean : （可选项）是否自动播放视频
	 */
	setUrl(params:dkplayer_setUrl_Params):void

	/** 开始播放*/ 
	start():void

}
interface dkplayer_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**（可选项）播放器的封面*/ 
	coverImg?:string,

	/**播放地址*/ 
	url:string,

	/**（可选项）播放器的标题*/ 
	title?:string,

	/**（可选项）是否自动播放视频*/ 
	autoPlay?:boolean,

	/**（可选项）是否全屏播放*/ 
	enableFull?:boolean,

	/**（可选项）是否是直播*/ 
	isLive?:boolean,

	/**（可选项）打开播放器是否使用动画*/ 
	animation?:boolean,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

}

interface dkplayer_setUrl_Params {
	/**播放地址*/ 
	url:string,

	/**播放标题，默认为url地址*/ 
	title:string,

	/**（可选项）是否自动播放视频*/ 
	autoPlay?:boolean,

}

interface netAudio {
	/** 播放网络音频时，清除本地缓存*/ 
	expungeCache():void

}
interface scanner {
}
interface iap {
}
interface shareTool {
}
interface imageEXIF {
	/**
	 * `获取EXIF信息`
	 * ========params==========
	 *
	 * `path` :string : 图片路径，（android 不支持widget://）
	 *
	 * `tag` :string : EXIF 信息标记；iOS不支持此参数
	 */
	getValue(params:imageEXIF_getValue_Params, callback?: (ret:JSON) => void):void

	/**
	 * `设置EXIF信息`
	 * ========params==========
	 *
	 * `path` :string : 图片路径，（android不支持widget://）
	 *
	 * `tag` :string : EXIF值；iOS不支持此参数
	 *
	 * `exif` :any : 图片exif信息；仅支持iOS
	 *
	 * `gps` :any : 图片gps信息；仅支持iOS
	 */
	setValue(params:imageEXIF_setValue_Params, callback?: (ret:JSON) => void):void

	/** 列举所有属性，iOS不支持*/ 
	listAll(callback?: (ret:JSON) => void):void

}
interface imageEXIF_getValue_Params {
	/**图片路径，（android 不支持widget://）*/ 
	path:string,

	/**EXIF 信息标记；iOS不支持此参数*/ 
	tag:string,

}

interface imageEXIF_setValue_Params {
	/**图片路径，（android不支持widget://）*/ 
	path:string,

	/**EXIF值；iOS不支持此参数*/ 
	tag:string,

	/**图片exif信息；仅支持iOS*/ 
	exif:any,

	/**图片gps信息；仅支持iOS*/ 
	gps:any,

}

interface plateRecognize {
	/**
	 * `打开离线车牌识别页面`
	 * ========params==========
	 *
	 * `rect` :JSON : (可选项）播放器的位置及长宽
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（ios：只指 frame，传 window 无效）(android可以是frame或者Window，但是在全屏的时候，需要挂在Window上或者frame是全屏)
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	open(params:plateRecognize_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭离线车牌识别页面*/ 
	close():void

	/** 隐藏离线车牌识别页面*/ 
	hide():void

	/** 显示离线车牌识别页面*/ 
	show():void

	/**
	 * `识别本地图片`
	 * ========params==========
	 *
	 * `path` :string : 识别图片本地路径，支持fs、widget （android仅支持横向jpeg图片）
	 */
	recognizePateWithImage(params:plateRecognize_recognizePateWithImage_Params, callback?: (ret:JSON) => void):void

}
interface plateRecognize_open_Params {
	/**(可选项）播放器的位置及长宽*/ 
	rect?:JSON,

	/**（可选项）模块视图添加到指定 frame 的名字（ios：只指 frame，传 window 无效）(android可以是frame或者Window，但是在全屏的时候，需要挂在Window上或者frame是全屏)*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface plateRecognize_recognizePateWithImage_Params {
	/**识别图片本地路径，支持fs、widget （android仅支持横向jpeg图片）*/ 
	path:string,

}

interface yxsConversation {
	/**
	 * `导航栏隐藏显示控制`
	 * ========params==========
	 *
	 * `show` :boolean : （可选项）是否显示导航栏
	 */
	navibarShow(params:yxsConversation_navibarShow_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `设置开机时间`
	 * ========params==========
	 *
	 * `date` :string : 开机时间，格式yyyy-MM-dd HH:mm:ss
	 */
	setPowerOn(params:yxsConversation_setPowerOn_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `设置关机时间`
	 * ========params==========
	 *
	 * `date` :string : 关机时间，格式yyyy-MM-dd HH:mm:ss
	 */
	setPowerOff(params:yxsConversation_setPowerOff_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 取消开机时间*/ 
	cancelPowerOn(callback?: (ret:JSON, err:JSON) => void):void

	/** 取消关机时间*/ 
	cancelPowerOff(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `设置系统时间`
	 * ========params==========
	 *
	 * `date` :string : 时间，格式yyyy-MM-dd HH:mm:ss
	 */
	setSysTime(params:yxsConversation_setSysTime_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 截屏，调用此接口系统会进行截屏，并将照片存放到内置SD卡根目录下/Screenshots文件夹中*/ 
	screenshot(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `补光灯管理`
	 * ========params==========
	 *
	 * `open` :boolean : 打开或关闭补光灯
	 */
	flashControl(params:yxsConversation_flashControl_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `开关锁`
	 * ========params==========
	 *
	 * `open` :boolean : 打开或关闭锁
	 */
	lockControl(params:yxsConversation_lockControl_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface yxsConversation_navibarShow_Params {
	/**（可选项）是否显示导航栏*/ 
	show?:boolean,

}

interface yxsConversation_setPowerOn_Params {
	/**开机时间，格式yyyy-MM-dd HH:mm:ss*/ 
	date:string,

}

interface yxsConversation_setPowerOff_Params {
	/**关机时间，格式yyyy-MM-dd HH:mm:ss*/ 
	date:string,

}

interface yxsConversation_setSysTime_Params {
	/**时间，格式yyyy-MM-dd HH:mm:ss*/ 
	date:string,

}

interface yxsConversation_flashControl_Params {
	/**打开或关闭补光灯*/ 
	open:boolean,

}

interface yxsConversation_lockControl_Params {
	/**打开或关闭锁*/ 
	open:boolean,

}

interface wallPaper {
}
interface zyPlayVideo {
}
interface webDAV {
	/**  初始化*/ 
	init():void

	/** 设置网盘登录信息*/ 
	setCredentials():void

	/**  创建目录*/ 
	createDirectory():void

	/**  是否存在（iOS不支持）*/ 
	exists():void

	/**  获取某文件夹/目录下全部文件名（iOS不支持）*/ 
	list():void

	/**  下载文件*/ 
	get(callback?: (ret:JSON) => void):void

	/**  上传文件*/ 
	put(callback?: (ret:JSON) => void):void

	/**  移动、重命名文件*/ 
	move(callback?: (ret:JSON) => void):void

	/**  删除文件*/ 
	delete(callback?: (ret:JSON) => void):void

}
interface moduleKeyBoard {
}
interface checkappexist {
	/** 检测当前手机是否安装某个软件*/ 
	checkAppExist():void

}
interface miracast {
	/** 搜索设备*/ 
	startSearch():void

	/**
	 * `开始投屏`
	 * ========params==========
	 *
	 * `uuid` :string : 设备的uuid
	 */
	start(params:miracast_start_Params):void

	/** 结束投屏*/ 
	end():void

	/** 暂停播放*/ 
	paush():void

	/** 播放*/ 
	play():void

	/**
	 * `设置播放进度`
	 * ========params==========
	 *
	 * `seek` :number : （可选项）播放进度，单位是秒
	 */
	seekChanged(params:miracast_seekChanged_Params):void

	/**
	 * `设置音量`
	 * ========params==========
	 *
	 * `volume` :number : （可选项）音量，取值范围：0-100
	 */
	volumeChange(params:miracast_volumeChange_Params):void

	/**
	 * `播放切集`
	 * ========params==========
	 *
	 * `url` :string : 播放地址的url
	 *
	 * `id` :string : 视频id（仅android支持）
	 *
	 * `name` :string : 名称（仅android支持）
	 */
	playTheURL(params:miracast_playTheURL_Params):void

	/** 设置监听*/ 
	addListener():void

}
interface miracast_start_Params {
	/**设备的uuid*/ 
	uuid:string,

}

interface miracast_seekChanged_Params {
	/**（可选项）播放进度，单位是秒*/ 
	seek?:number,

}

interface miracast_volumeChange_Params {
	/**（可选项）音量，取值范围：0-100*/ 
	volume?:number,

}

interface miracast_playTheURL_Params {
	/**播放地址的url*/ 
	url:string,

	/**视频id（仅android支持）*/ 
	id:string,

	/**名称（仅android支持）*/ 
	name:string,

}

interface gifHandle {
	/**
	 * `GIF动图生成`
	 * ========params==========
	 *
	 * `loopCount` :number : （可选项）循环次数
	 *
	 * `ret` :JSON : null
	 */
	decodeGif(params:gifHandle_decodeGif_Params):void

	/**
	 * `GIF动图解析`
	 * ========params==========
	 *
	 * `ret` :JSON : null
	 */
	encodeGif(params:gifHandle_encodeGif_Params):void

}
interface gifHandle_decodeGif_Params {
	/**（可选项）循环次数*/ 
	loopCount?:number,

	/**null*/ 
	ret:JSON,

}

interface gifHandle_encodeGif_Params {
	/**null*/ 
	ret:JSON,

}

interface openSet {
	/**
	 * `打开系统设置页面`
	 * ========params==========
	 *
	 * `id` :any : （必填）要打开的设置页面编号
	 */
	open(params:openSet_open_Params):void

}
interface openSet_open_Params {
	/**（必填）要打开的设置页面编号*/ 
	id:any,

}

interface imageMerge {
	/**
	 * `获取图片宽高`
	 * ========params==========
	 *
	 * `path` :string : 本地图片路径，支持fs://、widget
	 */
	getImageWidthAndHeight(params:imageMerge_getImageWidthAndHeight_Params, callback?: (ret:JSON) => void):void

	/**
	 * `多张图片叠加合成一张图片`
	 * ========params==========
	 *
	 * `images` :Array : 所要叠加的图片组成的数组
	 *
	 * `width` :number : （可选项）结果图的宽度
	 *
	 * `height` :number : （可选项）结果图的高度
	 */
	overlay(params:imageMerge_overlay_Params, callback?: (ret:JSON) => void):void

	/**
	 * `多张图片上下拼接成一张长图`
	 * ========params==========
	 *
	 * `images` :Array : 所要叠加的图片路径组成的数组，要求本地路径（fs://、widget://）
	 *
	 * `width` :number : （可选项）结果图的宽度
	 */
	longImage(params:imageMerge_longImage_Params, callback?: (ret:JSON) => void):void

	/**
	 * `图片上添加文字`
	 * ========params==========
	 *
	 * `path` :string : 需要添加文字的图片路径
	 *
	 * `textPoint` :JSON : （可选项）添加文字相对于图片的起始坐标
	 *
	 * `text` :string : 图片上添加的文本
	 *
	 * `textColor` :string : （可选项）文本字体颜色
	 *
	 * `textFont` :string : （可选项）文本字体大小
	 */
	addText(params:imageMerge_addText_Params, callback?: (ret:JSON) => void):void

}
interface imageMerge_getImageWidthAndHeight_Params {
	/**本地图片路径，支持fs://、widget*/ 
	path:string,

}

interface imageMerge_overlay_Params {
	/**所要叠加的图片组成的数组*/ 
	images:Array,

	/**（可选项）结果图的宽度*/ 
	width?:number,

	/**（可选项）结果图的高度*/ 
	height?:number,

}

interface imageMerge_longImage_Params {
	/**所要叠加的图片路径组成的数组，要求本地路径（fs://、widget://）*/ 
	images:Array,

	/**（可选项）结果图的宽度*/ 
	width?:number,

}

interface imageMerge_addText_Params {
	/**需要添加文字的图片路径*/ 
	path:string,

	/**（可选项）添加文字相对于图片的起始坐标*/ 
	textPoint?:JSON,

	/**图片上添加的文本*/ 
	text:string,

	/**（可选项）文本字体颜色*/ 
	textColor?:string,

	/**（可选项）文本字体大小*/ 
	textFont?:string,

}

interface HmacSHA256 {
}
interface internationalization {
}
interface AppGroup {
	/**
	 * `根据组 ID 设置共享数据`
	 * ========params==========
	 *
	 * `groupId` :string : 组 ID
	 *
	 * `key` :string : 设置数据的 Key
	 *
	 * `value` :string : 设置的数据，注意要传基本数据类型，如果是数组这样的，其包含的元素也都必须是基本数据类型
	 */
	setValueForKey(params:AppGroup_setValueForKey_Params):void

	/**
	 * `根据组 ID 和 key 获取共享数据`
	 * ========params==========
	 *
	 * `groupId` :string : 组 ID
	 *
	 * `key` :string : 获取数据的 Key
	 */
	getValueForKey(params:AppGroup_getValueForKey_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据组 ID 和 key 移除共享数据`
	 * ========params==========
	 *
	 * `groupId` :string : 组 ID
	 *
	 * `key` :string : 要获取的数据的 Key
	 */
	removeValueForKey(params:AppGroup_removeValueForKey_Params):void

	/**
	 * `根据组 ID 获取之前设置的所有共享数据`
	 * ========params==========
	 *
	 * `groupId` :string : 组 ID
	 */
	valueRepresentation(params:AppGroup_valueRepresentation_Params, callback?: (ret:JSON) => void):void

	/** 根据组 ID 设置默认数据*/ 
	registerDefaults():void

	/**
	 * `根据组ID 获取共享文件的路径`
	 * ========params==========
	 *
	 * `groupId` :string : 组 ID
	 */
	getGroupURL(params:AppGroup_getGroupURL_Params, callback?: (ret:JSON) => void):void

}
interface AppGroup_setValueForKey_Params {
	/**组 ID*/ 
	groupId:string,

	/**设置数据的 Key*/ 
	key:string,

	/**设置的数据，注意要传基本数据类型，如果是数组这样的，其包含的元素也都必须是基本数据类型*/ 
	value:string,

}

interface AppGroup_getValueForKey_Params {
	/**组 ID*/ 
	groupId:string,

	/**获取数据的 Key*/ 
	key:string,

}

interface AppGroup_removeValueForKey_Params {
	/**组 ID*/ 
	groupId:string,

	/**要获取的数据的 Key*/ 
	key:string,

}

interface AppGroup_valueRepresentation_Params {
	/**组 ID*/ 
	groupId:string,

}

interface AppGroup_getGroupURL_Params {
	/**组 ID*/ 
	groupId:string,

}

interface AsyncSocket {
	/**
	 * `开启服务`
	 * ========params==========
	 *
	 * `charset` :string : （可选项）编码格式，仅支持 Android 平台，iOS仅支持UTF-8
	 *
	 * `port` :number : （可选项）端口号
	 *
	 * `decollator` :string : （可选项）包头和包体数据之间的分割符
	 */
	startServer(params:AsyncSocket_startServer_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 停止服务*/ 
	stopServer():void

	/**
	 * `目标客户端是否已经链接`
	 * ========params==========
	 *
	 * `IP` :string : 目标客户端的 IP 地址
	 *
	 * `port` :number : 目标客户端的端口号
	 */
	isClientConnected(params:AsyncSocket_isClientConnected_Params, callback?: (ret:JSON) => void):void

	/**
	 * `目标客户端是否已断开链接`
	 * ========params==========
	 *
	 * `IP` :string : 目标客户端的 IP 地址
	 *
	 * `port` :number : 目标客户端的端口号
	 */
	isClientDisconnected(params:AsyncSocket_isClientDisconnected_Params, callback?: (ret:JSON) => void):void

	/** 获取接收 IP 和端口号*/ 
	getAddress(callback?: (ret:JSON, err:JSON) => void):void

	/** 监听有客户端连接事件*/ 
	clientConnectListener():void

	/** 监听客户端发送来数据的事件*/ 
	serverReceiveDataListener():void

	/**
	 * `发送数据到客户端`
	 * ========params==========
	 *
	 * `data` :string : 发送的字符串，如果是文件则传文件路径（本地路径）
	 *
	 * `type` :string : （可选项）发送到数据类型
	 *
	 * `decollator` :string : （可选项）发送数据时封包的包头和包体分割符，
	 *
	 * `IP` :string : 目标客户端的 IP 地址
	 *
	 * `port` :number : 目标客户端的端口号
	 *
	 * `ret` :JSON : null
	 *
	 * `err` :JSON : null
	 */
	sendToClient(params:AsyncSocket_sendToClient_Params):void

	/**
	 * `链接服务端`
	 * ========params==========
	 *
	 * `IP` :string : 要断开的客户端的 IP 地址
	 *
	 * `port` :number : 要断开的客户端的端口号
	 *
	 * `decollator` :string : （可选项）包头和包体数据之间的分割符
	 *
	 * `ret` :JSON : null
	 *
	 * `err` :JSON : null
	 */
	connectServer(params:AsyncSocket_connectServer_Params):void

	/** 断开链接服务端*/ 
	disconnectServer():void

	/** 是否已跟服务端链接*/ 
	isServerConnected():void

	/** 是否跟服务端端开链接*/ 
	isServerDisconnected():void

	/** 监听与服务端断开链接 （Android暂不支持）*/ 
	serverDisonnectListener():void

	/** 客户端收到消息监听*/ 
	clientReceiveDataListener():void

	/**
	 * `发送数据到服务端`
	 * ========params==========
	 *
	 * `data` :string : 发送的字符串，如果是文件则传文件路径（本地路径）
	 *
	 * `type` :string : （可选项）发送到数据类型
	 *
	 * `decollator` :string : （可选项）发送数据时封包的包头和包体分割符，(Android 可以为一个特殊字符)
	 *
	 * `ret` :JSON : null
	 *
	 * `err` :JSON : null
	 */
	sendToServer(params:AsyncSocket_sendToServer_Params):void

}
interface AsyncSocket_startServer_Params {
	/**（可选项）编码格式，仅支持 Android 平台，iOS仅支持UTF-8*/ 
	charset?:string,

	/**（可选项）端口号*/ 
	port?:number,

	/**（可选项）包头和包体数据之间的分割符*/ 
	decollator?:string,

}

interface AsyncSocket_isClientConnected_Params {
	/**目标客户端的 IP 地址*/ 
	IP:string,

	/**目标客户端的端口号*/ 
	port:number,

}

interface AsyncSocket_isClientDisconnected_Params {
	/**目标客户端的 IP 地址*/ 
	IP:string,

	/**目标客户端的端口号*/ 
	port:number,

}

interface AsyncSocket_sendToClient_Params {
	/**发送的字符串，如果是文件则传文件路径（本地路径）*/ 
	data:string,

	/**（可选项）发送到数据类型*/ 
	type?:string,

	/**（可选项）发送数据时封包的包头和包体分割符，*/ 
	decollator?:string,

	/**目标客户端的 IP 地址*/ 
	IP:string,

	/**目标客户端的端口号*/ 
	port:number,

	/**null*/ 
	ret:JSON,

	/**null*/ 
	err:JSON,

}

interface AsyncSocket_connectServer_Params {
	/**要断开的客户端的 IP 地址*/ 
	IP:string,

	/**要断开的客户端的端口号*/ 
	port:number,

	/**（可选项）包头和包体数据之间的分割符*/ 
	decollator?:string,

	/**null*/ 
	ret:JSON,

	/**null*/ 
	err:JSON,

}

interface AsyncSocket_sendToServer_Params {
	/**发送的字符串，如果是文件则传文件路径（本地路径）*/ 
	data:string,

	/**（可选项）发送到数据类型*/ 
	type?:string,

	/**（可选项）发送数据时封包的包头和包体分割符，(Android 可以为一个特殊字符)*/ 
	decollator?:string,

	/**null*/ 
	ret:JSON,

	/**null*/ 
	err:JSON,

}

interface oxHlsCache {
	/** 监听接口*/ 
	addEventListener():void

	/** 开始下载任务*/ 
	start():void

	/** 暂停下载*/ 
	pause():void

	/** 删除缓存*/ 
	delCacheUrl():void

	/** 是否下载完成*/ 
	isFinish():void

	/** 获取缓存地址*/ 
	getCacheUrl():void

	/** 获取缓存大小  (ios有效)*/ 
	getCachedSize():void

	/** 停止所有任务*/ 
	stopAllTasks():void

	/** 清理缓存*/ 
	clearCache():void

	/** 启动服务*/ 
	startServer():void

	/** 停止服务*/ 
	stopServer():void

}
interface runBackground {
}
interface db {
	/**
	 * `获取指定目录下的子文件`
	 * ========params==========
	 *
	 * `directory` :string : （可选项）目录路径，不传时使用 db 模块的默认路径。支持 fs://、widget://等协议（如fs://user.db）
	 */
	subfile(params:db_subfile_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `打开数据库，若数据库不存在则创建数据库。`
	 * ========params==========
	 *
	 * `name` :string : 数据库名称
	 *
	 * `path` :string : （可选项）数据库所在路径，不传时使用默认创建的路径。支持 fs://、widget://等协议（如fs://user.db）
	 */
	openDatabase(params:db_openDatabase_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `关闭数据库`
	 * ========params==========
	 *
	 * `name` :string : 数据库名称
	 */
	closeDatabase(params:db_closeDatabase_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `执行事务操作语句`
	 * ========params==========
	 *
	 * `name` :string : 数据库名称
	 *
	 * `operation` :string : 事务操作类型，取值范围如下：
	 */
	transaction(params:db_transaction_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `执行 sql`
	 * ========params==========
	 *
	 * `name` :string : 数据库名称
	 *
	 * `sql` :string : sql 语句
	 */
	executeSql(params:db_executeSql_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `查询sql`
	 * ========params==========
	 *
	 * `name` :string : 数据库名称
	 *
	 * `sql` :string : sql语句
	 */
	selectSql(params:db_selectSql_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取指定目录下的子文件`
	 * ========params==========
	 *
	 * `directory` :string : （可选项）目录路径，不传时使用 db 模块的默认路径。支持 fs://、widget://等协议（如fs://user.db）
	 */
	subfileSync(params:db_subfileSync_Params):JSON;

	/**
	 * `打开数据库，若数据库不存在则创建数据库（同步接口）。`
	 * ========params==========
	 *
	 * `name` :string : 数据库名称
	 *
	 * `path` :string : （可选项）数据库所在路径，不传时使用默认创建的路径。支持 fs://、widget://等协议（如fs://user.db）
	 */
	openDatabaseSync(params:db_openDatabaseSync_Params):JSON;

	/**
	 * `关闭数据库（同步接口）`
	 * ========params==========
	 *
	 * `name` :string : 数据库名称
	 */
	closeDatabaseSync(params:db_closeDatabaseSync_Params):JSON;

	/**
	 * `执行事务操作语句（同步接口）`
	 * ========params==========
	 *
	 * `name` :string : 数据库名称
	 *
	 * `operation` :string : 事务操作类型，取值范围如下：
	 */
	transactionSync(params:db_transactionSync_Params):JSON;

	/**
	 * `执行 sql（同步接口）`
	 * ========params==========
	 *
	 * `name` :string : 数据库名称
	 *
	 * `sql` :string : sql 语句
	 */
	executeSqlSync(params:db_executeSqlSync_Params):JSON;

	/**
	 * `查询 sql（同步接口）`
	 * ========params==========
	 *
	 * `name` :string : 数据库名称
	 *
	 * `sql` :string : sql语句
	 */
	selectSqlSync(params:db_selectSqlSync_Params):JSON;

}
interface db_subfile_Params {
	/**（可选项）目录路径，不传时使用 db 模块的默认路径。支持 fs://、widget://等协议（如fs://user.db）*/ 
	directory?:string,

}

interface db_openDatabase_Params {
	/**数据库名称*/ 
	name:string,

	/**（可选项）数据库所在路径，不传时使用默认创建的路径。支持 fs://、widget://等协议（如fs://user.db）*/ 
	path?:string,

}

interface db_closeDatabase_Params {
	/**数据库名称*/ 
	name:string,

}

interface db_transaction_Params {
	/**数据库名称*/ 
	name:string,

	/**事务操作类型，取值范围如下：*/ 
	operation:string,

}

interface db_executeSql_Params {
	/**数据库名称*/ 
	name:string,

	/**sql 语句*/ 
	sql:string,

}

interface db_selectSql_Params {
	/**数据库名称*/ 
	name:string,

	/**sql语句*/ 
	sql:string,

}

interface db_subfileSync_Params {
	/**（可选项）目录路径，不传时使用 db 模块的默认路径。支持 fs://、widget://等协议（如fs://user.db）*/ 
	directory?:string,

}

interface db_openDatabaseSync_Params {
	/**数据库名称*/ 
	name:string,

	/**（可选项）数据库所在路径，不传时使用默认创建的路径。支持 fs://、widget://等协议（如fs://user.db）*/ 
	path?:string,

}

interface db_closeDatabaseSync_Params {
	/**数据库名称*/ 
	name:string,

}

interface db_transactionSync_Params {
	/**数据库名称*/ 
	name:string,

	/**事务操作类型，取值范围如下：*/ 
	operation:string,

}

interface db_executeSqlSync_Params {
	/**数据库名称*/ 
	name:string,

	/**sql 语句*/ 
	sql:string,

}

interface db_selectSqlSync_Params {
	/**数据库名称*/ 
	name:string,

	/**sql语句*/ 
	sql:string,

}

interface FNRecordMp3 {
	/**
	 * `初始化录音`
	 * ========params==========
	 *
	 * `path` :string : 生成的mp3路径；支持fs:// （仅支持iOS）
	 *
	 * `fileDir` :string : 存放mp3文件的路径，文件夹路径；支持fs，原生路径，例：'fs://record/' 注意结尾必须要有'/' （仅支持安卓）
	 */
	open(params:FNRecordMp3_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `开始录音`
	 * ========params==========
	 *
	 * `afterSecond` :number : 延时多少秒开始录音
	 */
	start(params:FNRecordMp3_start_Params, callback?: (ret:JSON) => void):void

	/**
	 * `停止录音`
	 * ========params==========
	 *
	 * `second` :number : 多少秒以内的录音不保存（仅ios支持）
	 */
	stop(params:FNRecordMp3_stop_Params, callback?: (ret:JSON) => void):void

	/** 暂停录音 （仅支持安卓）*/ 
	pause(callback?: (ret:JSON) => void):void

	/** 恢复录音/继续录音 （仅支持安卓）*/ 
	continue(callback?: (ret:JSON) => void):void

	/** 获取当前/实时音量 （仅安卓支持）*/ 
	getVolume(callback?: (ret:JSON) => void):void

	/** 添加事件监听者 （仅支持安卓）*/ 
	addEventListener(callback?: (ret:JSON) => void):void

}
interface FNRecordMp3_open_Params {
	/**生成的mp3路径；支持fs:// （仅支持iOS）*/ 
	path:string,

	/**存放mp3文件的路径，文件夹路径；支持fs，原生路径，例：'fs://record/' 注意结尾必须要有'/' （仅支持安卓）*/ 
	fileDir:string,

}

interface FNRecordMp3_start_Params {
	/**延时多少秒开始录音*/ 
	afterSecond:number,

}

interface FNRecordMp3_stop_Params {
	/**多少秒以内的录音不保存（仅ios支持）*/ 
	second:number,

}

interface miniVR {
	/**
	 * `跳转到vr视频播放。`
	 * ========params==========
	 *
	 * `url` :string : （必填）视频文件地址。仅支持m3u8在线播放。
	 *
	 * `mode` :number : （可选项）播放模式，默认是0，0是普通模式 1是单眼模式 2是双眼模式。
	 */
	openVideo(params:miniVR_openVideo_Params, callback?: (ret:JSON) => void):void

}
interface miniVR_openVideo_Params {
	/**（必填）视频文件地址。仅支持m3u8在线播放。*/ 
	url:string,

	/**（可选项）播放模式，默认是0，0是普通模式 1是单眼模式 2是双眼模式。*/ 
	mode?:number,

}

interface oxImageEditer {
	/** 打开编辑页面*/ 
	open():void

	/** 清除缓存*/ 
	clearCache():void

}
interface GifImage {
	/**
	 * `在指定页面显示一张 GIF 图片`
	 * ========params==========
	 *
	 * `path` :string : 本地图片路径，支持fs://、widget://
	 *
	 * `rect` :JSON : （可选项）GIF 图片显示区域的位置及大小
	 *
	 * `fixedOn` :string : （可选项）模块添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）预览窗口是否随所属 window 或 frame 滚动
	 */
	open(params:GifImage_open_Params):void

	/**
	 * `关闭打开的 Gif 图片`
	 * ========params==========
	 *
	 * `ID` :string : Gif 图片的 ID
	 */
	close(params:GifImage_close_Params):void

	/**
	 * `显示打开的 Gif 图片`
	 * ========params==========
	 *
	 * `ID` :string : Gif 图片的 ID
	 */
	show(params:GifImage_show_Params):void

	/**
	 * `隐藏打开的 Gif 图片`
	 * ========params==========
	 *
	 * `ID` :string : Gif 图片的 ID
	 */
	hide(params:GifImage_hide_Params):void

	/**
	 * `重设指定 GIF 图片的位置和大小`
	 * ========params==========
	 *
	 * `ID` :string : 重设的 Gif 图片的 ID
	 *
	 * `rect` :JSON : （可选项）GIF 图片显示区域的位置及大小
	 */
	reset(params:GifImage_reset_Params):void

}
interface GifImage_open_Params {
	/**本地图片路径，支持fs://、widget://*/ 
	path:string,

	/**（可选项）GIF 图片显示区域的位置及大小*/ 
	rect?:JSON,

	/**（可选项）模块添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）预览窗口是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface GifImage_close_Params {
	/**Gif 图片的 ID*/ 
	ID:string,

}

interface GifImage_show_Params {
	/**Gif 图片的 ID*/ 
	ID:string,

}

interface GifImage_hide_Params {
	/**Gif 图片的 ID*/ 
	ID:string,

}

interface GifImage_reset_Params {
	/**重设的 Gif 图片的 ID*/ 
	ID:string,

	/**（可选项）GIF 图片显示区域的位置及大小*/ 
	rect?:JSON,

}

interface acMqtt {
	/**
	 * `连接`
	 * ========params==========
	 *
	 * `host` :string : 主机名或IP地址,android 例：’tcp://127.0.0.1‘
	 *
	 * `port` :string : 端口
	 *
	 * `clean` :boolean : （可选项）服务器是否应放弃先前的会话信息
	 *
	 * `auth` :boolean : （可选项）指定应该使用用户和传递参数进行身份验证
	 *
	 * `keepalive` :number : （可选项）保持活动状态的时间间隔，单位秒
	 *
	 * `clientId` :string : 客户端标识符
	 *
	 * `user` :string : 用户名
	 *
	 * `pass` :string : 密码
	 *
	 * `willTopic` :string : null
	 *
	 * `will` :boolean : （可选项）离线是否发送
	 *
	 * `willMsg` :string : null
	 *
	 * `willQos` :number : null
	 *
	 * `protocolLevel` :boolean : （可选项）指示服务器是否应使用retainFlag发布离线消息
	 */
	connect(params:acMqtt_connect_Params, callback?: (ret:JSON) => void):void

	/**
	 * `发送数据`
	 * ========params==========
	 *
	 * `data` :string : 发送数据，长度范围为0到268,435,455-4-_lengthof-topic_个字节。
	 *
	 * `topic` :string : 发布数据的主题
	 *
	 * `qosLevel` :boolean : （可选项）服务器是否应使用retainFlag发布消息,如果为true，则将数据存储在MQTT代理上，直到被retainFlag = true的下一次发布覆盖为止
	 */
	sendData(params:acMqtt_sendData_Params):void

	/** 断开连接*/ 
	disconnect():void

	/**
	 * `订阅主题`
	 * ========params==========
	 *
	 * `topic` :string : 订阅主题
	 *
	 * `qosLevel` :number : null
	 */
	subscribeTopic(params:acMqtt_subscribeTopic_Params):void

	/**
	 * `取消订阅主题`
	 * ========params==========
	 *
	 * `topic` :string : 订阅主题
	 */
	unsubscribeTopic(params:acMqtt_unsubscribeTopic_Params):void

	/** 添加监听*/ 
	addEventListener():void

}
interface acMqtt_connect_Params {
	/**主机名或IP地址,android 例：’tcp://127.0.0.1‘*/ 
	host:string,

	/**端口*/ 
	port:string,

	/**（可选项）服务器是否应放弃先前的会话信息*/ 
	clean?:boolean,

	/**（可选项）指定应该使用用户和传递参数进行身份验证*/ 
	auth?:boolean,

	/**（可选项）保持活动状态的时间间隔，单位秒*/ 
	keepalive?:number,

	/**客户端标识符*/ 
	clientId:string,

	/**用户名*/ 
	user:string,

	/**密码*/ 
	pass:string,

	/**null*/ 
	willTopic:string,

	/**（可选项）离线是否发送*/ 
	will?:boolean,

	/**null*/ 
	willMsg:string,

	/**null*/ 
	willQos:number,

	/**（可选项）指示服务器是否应使用retainFlag发布离线消息*/ 
	protocolLevel?:boolean,

}

interface acMqtt_sendData_Params {
	/**发送数据，长度范围为0到268,435,455-4-_lengthof-topic_个字节。*/ 
	data:string,

	/**发布数据的主题*/ 
	topic:string,

	/**（可选项）服务器是否应使用retainFlag发布消息,如果为true，则将数据存储在MQTT代理上，直到被retainFlag = true的下一次发布覆盖为止*/ 
	qosLevel?:boolean,

}

interface acMqtt_subscribeTopic_Params {
	/**订阅主题*/ 
	topic:string,

	/**null*/ 
	qosLevel:number,

}

interface acMqtt_unsubscribeTopic_Params {
	/**订阅主题*/ 
	topic:string,

}

interface walletCards {
	/** 添加卡片*/ 
	add():void

}
interface chromeDebug {
}
interface FNScanner {
	/**
	 * `打开自带默认 UI 效果的二维码/条形码扫描页面，本界面相当于打开一个 window 窗口，其界面内容不支持自定义`
	 * ========params==========
	 *
	 * `sound` :string : （可选项）扫描结束后的提示音文件路径，要求本地路径（fs://、widget://），**为保证兼容性，推荐使用 wav 格式的短音频文件**
	 *
	 * `autorotation` :boolean : （可选项）扫描页面是否自动旋转（横竖屏）
	 *
	 * `saveToAlbum` :boolean : （可选项）扫描的二维码/条形码图片是否自动保存到相册
	 *
	 * `verticalLineColor` :string : (可选项) 字符串类型；竖屏时扫描线的颜色,支持支持rgb、rgba、#；
	 *
	 * `landscapeLineColor` :string : (可选项) 字符串类型；横屏时扫描线的颜色,支持支持rgb、rgba、#； (android不支持，android的横竖屏是一个颜色)
	 *
	 * `hintText` :string : (可选项) 字符串类型；二维码/条形码界面扫码界面底下的文字
	 *
	 * `albumText` :string : (可选项) 相册按钮文字
	 *
	 * `lightText` :string : (可选项) 灯光开启文字
	 *
	 * `closeText` :string : (可选项) 灯光关闭文字
	 *
	 * `isAlbum` :boolean : (可选项) 是否隐藏相册按钮
	 *
	 * `isLight` :boolean : (可选项) 是否隐藏闪光灯按钮
	 *
	 * `isPush` :boolean : (可选项) 页面跳转是否改为push，本参数仅支持iOS
	 *
	 * `font` :JSON : （可选项）文字样式
	 *
	 * `saveImg` :JSON : （可选项）扫描的二维码/条形码图片保存所需要的参数，若不传则不保存
	 *
	 * `isDrawQRCodeRect` :boolean : (可选项) 是否开启二维码自动对焦
	 *
	 * `qRCodeRectWidth` :number : (可选项) 二维码自动对焦框宽度 (android不支持)
	 *
	 * `qRCodeRectColor` :any : (可选项) 二维码自动对焦框颜色，支持 rgb、rgba、#； (android不支持)
	 *
	 * `isGBK` :boolean : (可选项) 是否GBK编码，如出现中文乱码，可能是用GBK编码带中文的数据生成二维码导致，此时就需要设置为true，此参数仅支持iOS，此参数在1.1.9（包含）版本以后弃用，请使用encoding参数
	 *
	 * `encoding` :number : (可选项) 编码类型
	 *
	 * `isEdit` :boolean : (可选项) 从相册选取图片后是否打开编辑页面（仅iOS支持）
	 *
	 * `cameraDirection` :string : (可选项) 摄像头方向
	 */
	open(params:FNScanner_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `打开二维码/条码扫描器`
	 * ========params==========
	 *
	 * `sound` :string : （可选项）扫描结束后的提示音文件路径，要求本地路径（fs://、widget://），**为保证兼容性，推荐使用 wav 格式的短音频文件**
	 *
	 * `autorotation` :boolean : （可选项）扫描页面是否自动旋转（横竖屏）
	 *
	 * `saveToAlbum` :boolean : （可选项）扫描的二维码/条形码图片是否自动保存到相册
	 *
	 * `verticalLineColor` :string : (可选项) 字符串类型；竖屏时扫描线的颜色,支持支持rgb、rgba、#；仅android有效
	 *
	 * `saveImg` :JSON : （可选项）扫描的二维码/条形码图片保存所需要的参数，若不传则不保存
	 *
	 * `hintText` :string : (可选项) 字符串类型；二维码/条形码界面扫码界面底下的文字(ios不支持)
	 *
	 * `font` :JSON : （可选项）文字样式
	 *
	 * `isAlbum` :boolean : (可选项) 是否隐藏相册按钮
	 *
	 * `isPush` :boolean : (可选项) 页面跳转是否改为push，本参数仅支持iOS
	 *
	 * `isDrawQRCodeRect` :boolean : (可选项) 是否开启二维码自动对焦
	 *
	 * `qRCodeRectWidth` :number : (可选项) 二维码自动对焦框宽度 (android不支持)
	 *
	 * `qRCodeRectColor` :any : (可选项) 二维码自动对焦框颜色，支持 rgb、rgba、#； (android不支持)
	 *
	 * `isLight` :boolean : (可选项) 是否隐藏闪光灯按钮
	 *
	 * `isGBK` :boolean : (可选项) 是否GBK编码，如出现中文乱码，可能是用GBK编码带中文的数据生成二维码导致，此时就需要设置为true，此参数仅支持iOS，此参数在1.1.9（包含）版本以后弃用，请使用encoding参数
	 *
	 * `encoding` :number : (可选项) 编码类型
	 *
	 * `cameraDirection` :string : (可选项) 摄像头方向
	 */
	openScanner(params:FNScanner_openScanner_Params, callback?: (ret:JSON) => void):void

	/**
	 * `打开可自定义的二维码/条形码扫描器`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）扫描器的位置及尺寸，**在安卓平台宽高比须跟屏幕宽高比一致，否则摄像头可视区域的图像可能出现少许变形；w和h属性最好使用api.winWidth和api.winHeight,这样不会导致变形，也不会出现手机必须要在一定的距离上才能扫描出来的现象**
	 *
	 * `rectOfInterest` :JSON : （可选项）在扫码区域上的扫码识别区域，**仅在iOS平台有效**
	 *
	 * `sound` :string : （可选项）扫描结束后的提示音文件路径，要求本地路径（fs://、widget://），**为保证兼容性，推荐使用 wav 格式的短音频文件**
	 *
	 * `autorotation` :boolean : （可选项）扫描页面是否自动旋转（横竖屏）
	 *
	 * `saveToAlbum` :boolean : （可选项）扫描的二维码/条形码图片是否自动保存到相册
	 *
	 * `saveImg` :JSON : （可选项）扫描的二维码/条形码图片保存所需要的参数，若不传则不保存
	 *
	 * `interval` :number : （可选项）连续扫描间隔；
	 *
	 * `isDrawQRCodeRect` :boolean : (可选项) 是否开启二维码自动对焦
	 *
	 * `qRCodeRectWidth` :number : (可选项) 二维码自动对焦框宽度 (android不支持)
	 *
	 * `qRCodeRectColor` :any : (可选项) 二维码自动对焦框颜色，支持 rgb、rgba、#； (android不支持)
	 *
	 * `isGBK` :boolean : (可选项) 是否GBK编码，如出现中文乱码，可能是用GBK编码带中文的数据生成二维码导致，此时就需要设置为true，此参数仅支持iOS，此参数在1.1.9（包含）版本以后弃用，请使用encoding参数
	 *
	 * `encoding` :number : (可选项) 编码类型
	 *
	 * `cameraDirection` :string : (可选项) 摄像头方向
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	openView(params:FNScanner_openView_Params, callback?: (ret:JSON) => void):void

	/**
	 * `重设可自定义的二维码/条形码扫描器的大小和位置`
	 * ========params==========
	 *
	 * `x` :number : （可选项）模块左上角的 x 坐标（相对于所属的 Window 或 Frame）
	 *
	 * `y` :number : （可选项）模块左上角的 y 坐标（相对于所属的 Window 或 Frame）
	 *
	 * `w` :number : （可选项）模块的宽度
	 *
	 * `h` :number : （可选项）模块的高度
	 */
	setFrame(params:FNScanner_setFrame_Params):void

	/** 关闭自定义大小的二维码/条码扫描器*/ 
	closeView():void

	/**
	 * `二维码/条形码图片解码`
	 * ========params==========
	 *
	 * `sound` :string : （可选项）扫描结束后的提示音文件路径，要求本地路径（fs://、widget://），**为保证兼容性，推荐使用  wav 格式的短音频文件**
	 *
	 * `path` :string : （可选项）要识别的图片路径，要求本地路径（fs://、widget://），**若不传则打开系统相册**
	 */
	decodeImg(params:FNScanner_decodeImg_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `将字符串生成二维码/条形码图片`
	 * ========params==========
	 *
	 * `type` :string : （可选项）生成图片的类型，默认值：'qr_image'
	 *
	 * `content` :string : 所要生成的二维码/条形码字符串，**当 type 为 bar_image 时，该值只能为数字字符串**
	 *
	 * `saveToAlbum` :boolean : （可选项）扫描的二维码/条形码图片是否自动保存到相册
	 *
	 * `saveImg` :JSON : （可选项）扫描的二维码/条形码图片保存所需要的参数，若不传则不保存
	 */
	encodeImg(params:FNScanner_encodeImg_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `打开/关闭闪光灯（在Android上，已打开扫码视图时有效）`
	 * ========params==========
	 *
	 * `status` :string : （可选项）打开/关闭闪光灯，默认值：'off'
	 */
	switchLight(params:FNScanner_switchLight_Params):void

	/** 通知当前本模块app进入回到前台。此时模块会进行一些资源的恢复操作，防止照相机回来之后黑屏*/ 
	onResume():void

	/** 通知当前本模块app进入后台。此时模块会进行一些资源的暂停存储操作，防止照相机回来之后黑屏*/ 
	onPause():void

}
interface FNScanner_open_Params {
	/**（可选项）扫描结束后的提示音文件路径，要求本地路径（fs://、widget://），**为保证兼容性，推荐使用 wav 格式的短音频文件***/ 
	sound?:string,

	/**（可选项）扫描页面是否自动旋转（横竖屏）*/ 
	autorotation?:boolean,

	/**（可选项）扫描的二维码/条形码图片是否自动保存到相册*/ 
	saveToAlbum?:boolean,

	/**(可选项) 字符串类型；竖屏时扫描线的颜色,支持支持rgb、rgba、#；*/ 
	verticalLineColor?:string,

	/**(可选项) 字符串类型；横屏时扫描线的颜色,支持支持rgb、rgba、#； (android不支持，android的横竖屏是一个颜色)*/ 
	landscapeLineColor?:string,

	/**(可选项) 字符串类型；二维码/条形码界面扫码界面底下的文字*/ 
	hintText?:string,

	/**(可选项) 相册按钮文字*/ 
	albumText?:string,

	/**(可选项) 灯光开启文字*/ 
	lightText?:string,

	/**(可选项) 灯光关闭文字*/ 
	closeText?:string,

	/**(可选项) 是否隐藏相册按钮*/ 
	isAlbum?:boolean,

	/**(可选项) 是否隐藏闪光灯按钮*/ 
	isLight?:boolean,

	/**(可选项) 页面跳转是否改为push，本参数仅支持iOS*/ 
	isPush?:boolean,

	/**（可选项）文字样式*/ 
	font?:JSON,

	/**（可选项）扫描的二维码/条形码图片保存所需要的参数，若不传则不保存*/ 
	saveImg?:JSON,

	/**(可选项) 是否开启二维码自动对焦*/ 
	isDrawQRCodeRect?:boolean,

	/**(可选项) 二维码自动对焦框宽度 (android不支持)*/ 
	qRCodeRectWidth?:number,

	/**(可选项) 二维码自动对焦框颜色，支持 rgb、rgba、#； (android不支持)*/ 
	qRCodeRectColor?:any,

	/**(可选项) 是否GBK编码，如出现中文乱码，可能是用GBK编码带中文的数据生成二维码导致，此时就需要设置为true，此参数仅支持iOS，此参数在1.1.9（包含）版本以后弃用，请使用encoding参数*/ 
	isGBK?:boolean,

	/**(可选项) 编码类型*/ 
	encoding?:number,

	/**(可选项) 从相册选取图片后是否打开编辑页面（仅iOS支持）*/ 
	isEdit?:boolean,

	/**(可选项) 摄像头方向*/ 
	cameraDirection?:string,

}

interface FNScanner_openScanner_Params {
	/**（可选项）扫描结束后的提示音文件路径，要求本地路径（fs://、widget://），**为保证兼容性，推荐使用 wav 格式的短音频文件***/ 
	sound?:string,

	/**（可选项）扫描页面是否自动旋转（横竖屏）*/ 
	autorotation?:boolean,

	/**（可选项）扫描的二维码/条形码图片是否自动保存到相册*/ 
	saveToAlbum?:boolean,

	/**(可选项) 字符串类型；竖屏时扫描线的颜色,支持支持rgb、rgba、#；仅android有效*/ 
	verticalLineColor?:string,

	/**（可选项）扫描的二维码/条形码图片保存所需要的参数，若不传则不保存*/ 
	saveImg?:JSON,

	/**(可选项) 字符串类型；二维码/条形码界面扫码界面底下的文字(ios不支持)*/ 
	hintText?:string,

	/**（可选项）文字样式*/ 
	font?:JSON,

	/**(可选项) 是否隐藏相册按钮*/ 
	isAlbum?:boolean,

	/**(可选项) 页面跳转是否改为push，本参数仅支持iOS*/ 
	isPush?:boolean,

	/**(可选项) 是否开启二维码自动对焦*/ 
	isDrawQRCodeRect?:boolean,

	/**(可选项) 二维码自动对焦框宽度 (android不支持)*/ 
	qRCodeRectWidth?:number,

	/**(可选项) 二维码自动对焦框颜色，支持 rgb、rgba、#； (android不支持)*/ 
	qRCodeRectColor?:any,

	/**(可选项) 是否隐藏闪光灯按钮*/ 
	isLight?:boolean,

	/**(可选项) 是否GBK编码，如出现中文乱码，可能是用GBK编码带中文的数据生成二维码导致，此时就需要设置为true，此参数仅支持iOS，此参数在1.1.9（包含）版本以后弃用，请使用encoding参数*/ 
	isGBK?:boolean,

	/**(可选项) 编码类型*/ 
	encoding?:number,

	/**(可选项) 摄像头方向*/ 
	cameraDirection?:string,

}

interface FNScanner_openView_Params {
	/**（可选项）扫描器的位置及尺寸，**在安卓平台宽高比须跟屏幕宽高比一致，否则摄像头可视区域的图像可能出现少许变形；w和h属性最好使用api.winWidth和api.winHeight,这样不会导致变形，也不会出现手机必须要在一定的距离上才能扫描出来的现象***/ 
	rect?:JSON,

	/**（可选项）在扫码区域上的扫码识别区域，**仅在iOS平台有效***/ 
	rectOfInterest?:JSON,

	/**（可选项）扫描结束后的提示音文件路径，要求本地路径（fs://、widget://），**为保证兼容性，推荐使用 wav 格式的短音频文件***/ 
	sound?:string,

	/**（可选项）扫描页面是否自动旋转（横竖屏）*/ 
	autorotation?:boolean,

	/**（可选项）扫描的二维码/条形码图片是否自动保存到相册*/ 
	saveToAlbum?:boolean,

	/**（可选项）扫描的二维码/条形码图片保存所需要的参数，若不传则不保存*/ 
	saveImg?:JSON,

	/**（可选项）连续扫描间隔；*/ 
	interval?:number,

	/**(可选项) 是否开启二维码自动对焦*/ 
	isDrawQRCodeRect?:boolean,

	/**(可选项) 二维码自动对焦框宽度 (android不支持)*/ 
	qRCodeRectWidth?:number,

	/**(可选项) 二维码自动对焦框颜色，支持 rgb、rgba、#； (android不支持)*/ 
	qRCodeRectColor?:any,

	/**(可选项) 是否GBK编码，如出现中文乱码，可能是用GBK编码带中文的数据生成二维码导致，此时就需要设置为true，此参数仅支持iOS，此参数在1.1.9（包含）版本以后弃用，请使用encoding参数*/ 
	isGBK?:boolean,

	/**(可选项) 编码类型*/ 
	encoding?:number,

	/**(可选项) 摄像头方向*/ 
	cameraDirection?:string,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface FNScanner_setFrame_Params {
	/**（可选项）模块左上角的 x 坐标（相对于所属的 Window 或 Frame）*/ 
	x?:number,

	/**（可选项）模块左上角的 y 坐标（相对于所属的 Window 或 Frame）*/ 
	y?:number,

	/**（可选项）模块的宽度*/ 
	w?:number,

	/**（可选项）模块的高度*/ 
	h?:number,

}

interface FNScanner_decodeImg_Params {
	/**（可选项）扫描结束后的提示音文件路径，要求本地路径（fs://、widget://），**为保证兼容性，推荐使用  wav 格式的短音频文件***/ 
	sound?:string,

	/**（可选项）要识别的图片路径，要求本地路径（fs://、widget://），**若不传则打开系统相册***/ 
	path?:string,

}

interface FNScanner_encodeImg_Params {
	/**（可选项）生成图片的类型，默认值：'qr_image'*/ 
	type?:string,

	/**所要生成的二维码/条形码字符串，**当 type 为 bar_image 时，该值只能为数字字符串***/ 
	content:string,

	/**（可选项）扫描的二维码/条形码图片是否自动保存到相册*/ 
	saveToAlbum?:boolean,

	/**（可选项）扫描的二维码/条形码图片保存所需要的参数，若不传则不保存*/ 
	saveImg?:JSON,

}

interface FNScanner_switchLight_Params {
	/**（可选项）打开/关闭闪光灯，默认值：'off'*/ 
	status?:string,

}

interface oxPlayer {
	/** 监听统一接口 取消原来的api.addEventListener*/ 
	addEventListener():void

	/** 指定区域显示播放器,点播，可分集播放*/ 
	fixdPlay():void

	/** 指定区域显示播放器,直播*/ 
	fixzPlay():void

	/** 是否全屏*/ 
	isFull():void

	/** 退出全屏*/ 
	exitFullScreen():void

	/** 进入全屏*/ 
	enterFullScreen():void

	/** 是否锁屏  fixdPlay fixePlay 有效*/ 
	isLock():void

	/** 添加 弹幕*/ 
	addDanmaku():void

	/** vip页面*/ 
	showVipView():void

	/** 退出vip页面*/ 
	hideVipView():void

	/** 搜索投屏设备*/ 
	startDlnaSearch():void

	/** 推送投屏视频*/ 
	startDlnaPush():void

	/** 停止投屏*/ 
	stopDlnaPush():void

	/** 更新一条记录*/ 
	updateDataAtIndex():void

	/** 更新所有记录*/ 
	updateAll():void

	/** m3u8下载开始*/ 
	hlsStartDownload():void

	/** m3u8停止下载*/ 
	hlsStopDownload():void

	/** m3u8移除缓存*/ 
	hlsRemoveDownload():void

	/** 全屏点播,仿抖音 可上下滑动切换视频*/ 
	dbPlay():void

	/** 全屏直播,仿抖音*/ 
	zbPlay():void

	/** 封面 视频预加载接口*/ 
	addCacheDatas():void

	/**  初始化穿山甲draw广告*/ 
	initTTDrawAd():void

	/** 添加穿山甲draw广告位*/ 
	addTTDrawAd():void

	/** 穿山甲广告插入到索引位置*/ 
	insertTTDrawAd():void

	/** dbPlay接口播放最后一个视频时 追加 数据*/ 
	addDataAfter():void

	/** dbPlay下拉刷新时更新 数据*/ 
	addDataBefore():void

	/** dbPlay下拉刷新时添加 数据 放在数组前*/ 
	insertDataBefore():void

	/** 当前视频动态 添加控件 调用dbPlay  zbPlay时此接口生效*/ 
	addStyle():void

	/** 当前视频 动态更新组件 样式 调用dbPlay  zbPlay时此接口生效*/ 
	updateStyles():void

	/** 当前视频 动态更新视频用户信息 比如 评论数 分享数 等 更新 调用dbPlay  zbPlay时此接口生效*/ 
	updateUserInfo():void

	/** dbPlay停止上下拉刷新*/ 
	stopFresh():void

	/** 控制红包*/ 
	hongbaoAction():void

	/** 设置红包进度 code ==16 返回小视频播放进度 可调用此方法*/ 
	setHBProgress():void

	/** 添加控件 dbPlay  zbPlay不随屏滚动控件 fixdPlay fixzPlay 动态添加控件*/ 
	addComponent():void

	/** 动态更新组件 dbPlay  zbPlay不随屏滚动控件 fixdPlay fixzPlay 动态添加控件*/ 
	updateComponent():void

	/** 播放下一条记录*/ 
	next():void

	/** 播放上一条记录*/ 
	prev():void

	/** 播放索引视频*/ 
	playIndex():void

	/** 开始播放*/ 
	start():void

	/** 停止播放*/ 
	pause():void

	/** 重新播放*/ 
	replay():void

	/** 视频时长*/ 
	duration():void

	/** 指定位置播放*/ 
	seekTo():void

	/** 播放位置*/ 
	position():void

	/** 截屏*/ 
	screenShot():void

	/** 移除播放器*/ 
	remove():void

	/** 显示播放器*/ 
	showPlay():void

	/** 隐藏播放器*/ 
	hidePlay():void

	/** 设置音量*/ 
	setVolume():void

	/** 设置倍速*/ 
	setSpeed():void

	/** 清理缓存*/ 
	clearCache():void

	/** 设置视频适应 0 :自动调节 默认  1自适应 2 全屏*/ 
	setScreenScaleType():void

	/** 设置ijk参数*/ 
	setOptionValue():void

	/** 设置ijk参数*/ 
	setOptionIntValue():void

}
interface recMp3 {
	/** 开始录音*/ 
	start():void

}
interface generateVideo {
	/** 开始合并*/ 
	start(callback?: (ret:JSON) => void):void

}
interface voiceMag {
}
interface playModuleAli {
	/**
	 * `初始化视频播放配置`
	 * ========params==========
	 *
	 * `ttf` :string : （可选项）设置标题显示文字字体文件路径，仅支持widget://
	 *
	 * `logo` :any : （可选项）右上角设置logo(图片类型：png)；支持fs://,widget://
	 *
	 * `background` :any : （可选项）视频播放前的图片显示(图片类型：jpg,png,gif)；支持fs://,widget://
	 *
	 * `FullScreenViewIsFont` :boolean : （可选项）全屏view是否显示最上层,true:是|false:否，仅ios有效（为fasle时可通过openframe自定义按钮在播放器上层；注意，未开启沉侵式的App请不要设置该参数。）
	 *
	 * `isShowBottomBtn` :boolean : （可选项）全屏时是否隐藏手机底部虚拟键，仅Android有效。
	 *
	 * `isMultiWindow` :boolean : （可选项）是否开启多窗口模式(true 开启 false 不开启)。
	 *
	 * `loading` :any : （可选项）加载中的gif动画图片接口(图片类型：gif)；支持fs://,widget://
	 *
	 * `logoLeftTop` :any : （可选项）左上角设置logo(图片类型：png)；支持fs://,widget://
	 *
	 * `logoLeftBottom` :any : （可选项）左下角设置logo(图片类型：png)；支持fs://,widget://
	 *
	 * `logoRightBottom` :any : （可选项）右下角设置logo(图片类型：png)；支持fs://,widget://
	 */
	init(params:playModuleAli_init_Params):void

	/**
	 * `播放本地视频、网络视频、rtmp直播流等`
	 * ========params==========
	 *
	 * `rect` :JSON : （必填项）模块的位置及尺寸
	 *
	 * `fixedOn` :string : （可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window
	 *
	 * `fixed` :boolean : （（可选项）模块是否随所属 Window 或 Frame 滚动
	 *
	 * `url` :string : （必填项）视频资源地址，支持fs://、widget://(在 android 平台上不支持 widget)、rtmp://、http://
	 *
	 * `title` :string : （可选项）不填时标题默认显示url地址
	 *
	 * `defaultBtn` :boolean : （可选项）设置本次播放是否显示默认自带的播放控制按钮
	 *
	 * `enableFull` :boolean : （可选项）本次播放视频是否全屏播放，当为true时将直接全屏播放视频，x,y,w,h,fixedOn,fixed值不会生效。
	 *
	 * `enableFullAutoClose` :boolean : （可选项）默认全屏时播放时，返回按钮和退出全屏点击时是否关闭播放器(true:关闭 false:不关闭)
	 *
	 * `isTopView` :boolean : （可选项）是否显示顶部标题栏
	 *
	 * `isFullBtn` :boolean : （可选项）小窗口是否显示进入全屏按钮
	 *
	 * `isBackBtn` :boolean : （可选项）小窗口是否显示返回按钮
	 *
	 * `scalingMode` :boolean : （可选项）视频播放显示铺满模式（1:无缩放, 2:适应大小模式, 3:充满可视范围，可能会被裁剪, 4:缩放到充满视图）
	 *
	 * `fullscreenMode` :string : （可选项）设置全屏按钮控制全屏显示模式是横屏还是竖屏 竖屏:PORTRAIT ; 横屏:LANDSCAPE
	 *
	 * `isShowProcessView` :boolean : （可选项）是否显示进度条 (显示:true ; 不显示:false)【备注:直播流自动默认为false】
	 *
	 * `isShowTimeLable` :boolean : （可选项）是否显示播放时间 (显示:true ; 不显示:false)
	 *
	 * `isLive` :boolean : （可选项）是否直播视频源 （直播：true；点播：false）
	 *
	 * `isSmallOpenGesture` :boolean : （可选项）窗口播放时是否开启手势控制音量，亮度和进度 （开启：true；不开启：false）
	 *
	 * `isOpenGesture` :boolean : （可选项）全屏时是否开启手势控制音量，亮度和进度 （开启：true；不开启：false）
	 *
	 * `process` :number : （必填项）设置视频需要播放的时长
	 *
	 * `isAutoPlay` :boolean : （可选项）是否自动播放 (自动播放:true ; 不自动播放:false)
	 *
	 * `isPlayMusic` :boolean : （可选项）是否仅播放音频 (仅播放音频:true ; 视频播放:false)
	 *
	 * `isLoop` :boolean : （可选项）是否循环播放 (循环播放:true ; 禁止循环播放:false)
	 *
	 * `urlDatas` :Array : （可选项）清晰度按钮的自定义(数组内容大于1条记录，清晰度切换按钮才会显示，不支持直播链接的组装切换，不能和url接口参数同时存在)。
	 *
	 * `isSmallShowQxd` :boolean : （可选项）是否窗口时显示清晰度选择按钮 (数组内容大于1条记录，清晰度切换按钮才会显示；显示:true ; 不显示:false)
	 *
	 * `isMute` :boolean : （可选项）是否静音播放 (开启静音:true ; 关闭静音:false)
	 *
	 * `isShowDanmu` :boolean : （可选项）是否开启弹幕功能 (开启:true ; 不开启:false)
	 *
	 * `isLocalCache` :boolean : （可选项）是否本地缓存视频,音频;直播类不能缓存,开发者自行控制;(备注:缓存文件在cache://文件目录下,如果直播乱开启改参数会导致播放异常). (开启:true ; 不开启:false)
	 *
	 * `isShowFenxiang` :boolean : （可选项）全屏是否显示分享按钮 (显示:true ; 隐藏:false)
	 *
	 * `isShowMore` :boolean : （可选项）全屏是否显示更多按钮 (显示:true ; 隐藏:false)
	 *
	 * `isShowTouping` :boolean : （可选项）全屏是否显示投屏按钮 (显示:true ; 隐藏:false)
	 *
	 * `isShowXuanji` :boolean : （可选项）是否显示选集按钮 (显示:true ; 隐藏:false)
	 *
	 * `isShowNext` :boolean : （可选项）是否显示下一集按钮 (显示:true ; 隐藏:false)
	 *
	 * `isShowPre` :boolean : （可选项）是否显示上一集按钮 (显示:true ; 隐藏:false)
	 *
	 * `isSmallImmerse` :boolean : （可选项）窗口播放顶部控制栏是否沉侵式 (显示:true ; 隐藏:false)
	 *
	 * `isLongShowBackBtn` :boolean : （可选项）窗口模式下是否长时间显示返回按钮 (显示:true ; 隐藏:false)
	 *
	 * `isSmallShowFenxiang` :boolean : （可选项）窗口是否显示分享按钮 (显示:true ; 隐藏:false)
	 *
	 * `isSmallShowMore` :boolean : （可选项）窗口是否显示更多按钮 (显示:true ; 隐藏:false)
	 *
	 * `isSmallShowTouping` :boolean : （可选项）窗口是否显示投屏按钮 (显示:true ; 隐藏:false)
	 *
	 * `isOpenDanmu` :boolean : （可选项）是否打开弹幕功能 (打开:true ; 关闭:false)
	 *
	 * `singlePageModule` :boolean : （可选项）是否打开单页面播放模式。（当设置为true时，本页面播放器的接口只能在当前页面调用，不能跨页面；同时本页面开启多窗口模式无效）
	 *
	 * `isShowNetworkSpeed` :boolean : （可选项）是否在缓冲的时候显示网速
	 *
	 * `background` :any : （可选项）视频播放前的图片显示(图片类型：jpg,png,gif)；支持fs://,widget://
	 *
	 * `placeholderText` :string : （可选项）发送弹幕输入框默认提示内容。
	 *
	 * `isShowLock` :boolean : （可选项）全屏下是否显示锁屏按钮(true 显示 false 不显示)。
	 *
	 * `freeProcess` :number : （必填项）设置可免费播放时长,当免费播放完后触发播放异常事件，错误码5721
	 */
	play(params:playModuleAli_play_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `同一个页面，已经调用play接口后，切换视频地址时调用（前提条件，同一界面已经调用过play接口）。`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 *
	 * `url` :string : （必填项）视频资源地址，支持fs://、widget://(在 android 平台上不支持 widget)、rtmp://、http://
	 *
	 * `title` :string : （可选项）不填时标题默认显示url播放文件名
	 *
	 * `defaultBtn` :boolean : （可选项）设置本次播放是否显示默认自带的播放控制按钮
	 *
	 * `isLive` :boolean : （可选项）是否直播视频源 （直播：true；点播：false）
	 *
	 * `isSmallOpenGesture` :boolean : （可选项）窗口播放时是否开启手势控制音量，亮度和进度 （开启：true；不开启：false）
	 *
	 * `isOpenGesture` :boolean : （可选项）全屏时是否开启手势控制音量，亮度和进度 （开启：true；不开启：false）
	 *
	 * `process` :number : （必填项）设置视频需要播放的时长
	 *
	 * `isAutoPlay` :boolean : （可选项）是否自动播放 (自动播放:true ; 不自动播放:false)
	 *
	 * `isLoop` :boolean : （可选项）是否循环播放 (循环播放:true ; 禁止循环播放:false)
	 *
	 * `isShowProcessView` :boolean : （可选项）是否显示进度条 (显示:true ; 不显示:false)【备注:直播流自动默认为false】
	 *
	 * `isShowTimeLable` :boolean : （可选项）是否显示播放时间 (显示:true ; 不显示:false)
	 *
	 * `urlDatas` :Array : （可选项）清晰度按钮的自定义(数组内容大于1条记录，清晰度切换按钮才会显示，不支持直播链接的组装切换，不能和url接口参数同时存在)。
	 *
	 * `isSmallShowQxd` :boolean : （可选项）是否窗口时显示清晰度选择按钮 (数组内容大于1条记录，清晰度切换按钮才会显示；显示:true ; 不显示:false)
	 *
	 * `isMute` :boolean : （可选项）是否静音播放 (开启静音:true ; 关闭静音:false)
	 *
	 * `isShowDanmu` :boolean : （可选项）是否开启弹幕功能 (开启:true ; 不开启:false)
	 *
	 * `isLocalCache` :boolean : （可选项）是否本地缓存视频,音频;直播类不能缓存,开发者自行控制;(备注:缓存文件在cache://文件目录下,如果直播乱开启改参数会导致播放异常). (开启:true ; 不开启:false)
	 *
	 * `isShowFenxiang` :boolean : （可选项）全屏是否显示分享按钮 (显示:true ; 隐藏:false)
	 *
	 * `isShowMore` :boolean : （可选项）全屏是否显示更多按钮 (显示:true ; 隐藏:false)
	 *
	 * `isShowTouping` :boolean : （可选项）全屏是否显示投屏按钮 (显示:true ; 隐藏:false)
	 *
	 * `isShowXuanji` :boolean : （可选项）是否显示选集按钮 (显示:true ; 隐藏:false)
	 *
	 * `isShowNext` :boolean : （可选项）是否显示下一集按钮 (显示:true ; 隐藏:false)
	 *
	 * `isShowPre` :boolean : （可选项）是否显示上一集按钮 (显示:true ; 隐藏:false)
	 *
	 * `isSmallImmerse` :boolean : （可选项）窗口播放顶部控制栏是否沉侵式 (显示:true ; 隐藏:false)
	 *
	 * `isLongShowBackBtn` :boolean : （可选项）窗口模式下是否长时间显示返回按钮 (显示:true ; 隐藏:false)
	 *
	 * `isSmallShowFenxiang` :boolean : （可选项）窗口是否显示分享按钮 (显示:true ; 隐藏:false)
	 *
	 * `isSmallShowMore` :boolean : （可选项）窗口是否显示更多按钮 (显示:true ; 隐藏:false)
	 *
	 * `isSmallShowTouping` :boolean : （可选项）窗口是否显示投屏按钮 (显示:true ; 隐藏:false)
	 *
	 * `isOpenDanmu` :boolean : （可选项）是否打开弹幕功能 (打开:true ; 关闭:false)
	 *
	 * `isShowNetworkSpeed` :boolean : （可选项）是否在缓冲的时候显示网速
	 *
	 * `freeProcess` :number : （必填项）设置可免费播放时长,当免费播放完后触发播放异常事件，错误码5721
	 */
	playUrl(params:playModuleAli_playUrl_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `暂停播放`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 */
	pause(params:playModuleAli_pause_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `暂停后开始播放`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 */
	start(params:playModuleAli_start_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `停止播放`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 */
	stop(params:playModuleAli_stop_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取视频的时长`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 */
	getDuration(params:playModuleAli_getDuration_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取已经播放的时长`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 */
	getCurrentPosition(params:playModuleAli_getCurrentPosition_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `全屏播放`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 */
	full(params:playModuleAli_full_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `退出全屏`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 */
	unfull(params:playModuleAli_unfull_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `视频播放完监听事件`
	 * ========params==========
	 *
	 * `name` :string : 监听事件名称,可以设置的播放界面监听类型有：playEnd(播放结束),playError(播放异常),pause(暂停),play(播放),backBtn(小窗口返回按钮),full(进入全屏按钮),unfull(退出全屏按钮),click(视频区域点击监听),bufferingStart(缓冲开始),bufferingEnd(缓冲结束), onPrepared(视频准备完成),onChangeQxd(清晰度改变), fenxiangClick(分析按钮), moreClick(更多按钮), toupingClick(投屏按钮), xuanjiClick(选集按钮), nextClick(下一集按钮), preClick(上一级按钮), sendDanmuMessage(发送弹幕输入框发送内容),danmuClick(弹幕开关按钮点击)
	 */
	addEventListener(params:playModuleAli_addEventListener_Params, callback?: (ret:JSON) => void):void

	/**
	 * `获取是否全屏播放状态`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 */
	isFullScreen(params:playModuleAli_isFullScreen_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `设置播放进度位置(请根据视频最大时长进行参数控制传入)`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 *
	 * `process` :number : （必填项）设置视频需要播放的时长
	 */
	seekTo(params:playModuleAli_seekTo_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `设置播音量`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 *
	 * `volume` :number : （必填项）0-100
	 */
	setVolume(params:playModuleAli_setVolume_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `隐藏播放器`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 */
	hidePlayer(params:playModuleAli_hidePlayer_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `显示播放器`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 */
	showPlayer(params:playModuleAli_showPlayer_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `倍速播放`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 *
	 * `speed` :number : （必填项）设置视频播放倍速(取值范围 0.1-1.9)
	 */
	setSpeed(params:playModuleAli_setSpeed_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 清除页面所有打开的播放器接口(执行该接口后，返回index会归零)*/ 
	cleanPlayers():void

	/**
	 * `更新清晰度选择列表地址(必须和play或者playUrl接口传的数组长度一致)。`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 *
	 * `urlDatas` :Array : （可选项）清晰度按钮的自定义(数组内容大于1条记录，清晰度切换按钮才会显示，不支持直播链接的组装切换，不能和url接口参数同时存在)。
	 */
	updateUrlDatas(params:playModuleAli_updateUrlDatas_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `发送一条弹幕信息`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 *
	 * `text` :string : （必填项）弹幕文字内容
	 *
	 * `color` :string : （可选项）弹幕文字显示颜色代码
	 *
	 * `textSize` :number : （可选项）弹幕文字大小
	 */
	sendDanmu(params:playModuleAli_sendDanmu_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `发送多条弹幕信息。`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 *
	 * `isLoop` :boolean : （可选项）天际的全部数据是否循环播放(循环:true，不循环:false)
	 *
	 * `data` :Array : （必填项）多条弹幕信息记录。
	 */
	sendDanmuList(params:playModuleAli_sendDanmuList_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `静音开关切换`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 *
	 * `isMute` :boolean : （可选项）是否静音(开启静音:true 关闭静音:false)
	 */
	setMute(params:playModuleAli_setMute_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `截图`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 */
	takeSnapshot(params:playModuleAli_takeSnapshot_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取当前播放速率`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放器序号
	 */
	getCurrentSpeed(params:playModuleAli_getCurrentSpeed_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface playModuleAli_init_Params {
	/**（可选项）设置标题显示文字字体文件路径，仅支持widget://*/ 
	ttf?:string,

	/**（可选项）右上角设置logo(图片类型：png)；支持fs://,widget://*/ 
	logo?:any,

	/**（可选项）视频播放前的图片显示(图片类型：jpg,png,gif)；支持fs://,widget://*/ 
	background?:any,

	/**（可选项）全屏view是否显示最上层,true:是|false:否，仅ios有效（为fasle时可通过openframe自定义按钮在播放器上层；注意，未开启沉侵式的App请不要设置该参数。）*/ 
	FullScreenViewIsFont?:boolean,

	/**（可选项）全屏时是否隐藏手机底部虚拟键，仅Android有效。*/ 
	isShowBottomBtn?:boolean,

	/**（可选项）是否开启多窗口模式(true 开启 false 不开启)。*/ 
	isMultiWindow?:boolean,

	/**（可选项）加载中的gif动画图片接口(图片类型：gif)；支持fs://,widget://*/ 
	loading?:any,

	/**（可选项）左上角设置logo(图片类型：png)；支持fs://,widget://*/ 
	logoLeftTop?:any,

	/**（可选项）左下角设置logo(图片类型：png)；支持fs://,widget://*/ 
	logoLeftBottom?:any,

	/**（可选项）右下角设置logo(图片类型：png)；支持fs://,widget://*/ 
	logoRightBottom?:any,

}

interface playModuleAli_play_Params {
	/**（必填项）模块的位置及尺寸*/ 
	rect:JSON,

	/**（可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window*/ 
	fixedOn?:string,

	/**（（可选项）模块是否随所属 Window 或 Frame 滚动*/ 
	fixed?:boolean,

	/**（必填项）视频资源地址，支持fs://、widget://(在 android 平台上不支持 widget)、rtmp://、http://*/ 
	url:string,

	/**（可选项）不填时标题默认显示url地址*/ 
	title?:string,

	/**（可选项）设置本次播放是否显示默认自带的播放控制按钮*/ 
	defaultBtn?:boolean,

	/**（可选项）本次播放视频是否全屏播放，当为true时将直接全屏播放视频，x,y,w,h,fixedOn,fixed值不会生效。*/ 
	enableFull?:boolean,

	/**（可选项）默认全屏时播放时，返回按钮和退出全屏点击时是否关闭播放器(true:关闭 false:不关闭)*/ 
	enableFullAutoClose?:boolean,

	/**（可选项）是否显示顶部标题栏*/ 
	isTopView?:boolean,

	/**（可选项）小窗口是否显示进入全屏按钮*/ 
	isFullBtn?:boolean,

	/**（可选项）小窗口是否显示返回按钮*/ 
	isBackBtn?:boolean,

	/**（可选项）视频播放显示铺满模式（1:无缩放, 2:适应大小模式, 3:充满可视范围，可能会被裁剪, 4:缩放到充满视图）*/ 
	scalingMode?:boolean,

	/**（可选项）设置全屏按钮控制全屏显示模式是横屏还是竖屏 竖屏:PORTRAIT ; 横屏:LANDSCAPE*/ 
	fullscreenMode?:string,

	/**（可选项）是否显示进度条 (显示:true ; 不显示:false)【备注:直播流自动默认为false】*/ 
	isShowProcessView?:boolean,

	/**（可选项）是否显示播放时间 (显示:true ; 不显示:false)*/ 
	isShowTimeLable?:boolean,

	/**（可选项）是否直播视频源 （直播：true；点播：false）*/ 
	isLive?:boolean,

	/**（可选项）窗口播放时是否开启手势控制音量，亮度和进度 （开启：true；不开启：false）*/ 
	isSmallOpenGesture?:boolean,

	/**（可选项）全屏时是否开启手势控制音量，亮度和进度 （开启：true；不开启：false）*/ 
	isOpenGesture?:boolean,

	/**（必填项）设置视频需要播放的时长*/ 
	process:number,

	/**（可选项）是否自动播放 (自动播放:true ; 不自动播放:false)*/ 
	isAutoPlay?:boolean,

	/**（可选项）是否仅播放音频 (仅播放音频:true ; 视频播放:false)*/ 
	isPlayMusic?:boolean,

	/**（可选项）是否循环播放 (循环播放:true ; 禁止循环播放:false)*/ 
	isLoop?:boolean,

	/**（可选项）清晰度按钮的自定义(数组内容大于1条记录，清晰度切换按钮才会显示，不支持直播链接的组装切换，不能和url接口参数同时存在)。*/ 
	urlDatas?:Array,

	/**（可选项）是否窗口时显示清晰度选择按钮 (数组内容大于1条记录，清晰度切换按钮才会显示；显示:true ; 不显示:false)*/ 
	isSmallShowQxd?:boolean,

	/**（可选项）是否静音播放 (开启静音:true ; 关闭静音:false)*/ 
	isMute?:boolean,

	/**（可选项）是否开启弹幕功能 (开启:true ; 不开启:false)*/ 
	isShowDanmu?:boolean,

	/**（可选项）是否本地缓存视频,音频;直播类不能缓存,开发者自行控制;(备注:缓存文件在cache://文件目录下,如果直播乱开启改参数会导致播放异常). (开启:true ; 不开启:false)*/ 
	isLocalCache?:boolean,

	/**（可选项）全屏是否显示分享按钮 (显示:true ; 隐藏:false)*/ 
	isShowFenxiang?:boolean,

	/**（可选项）全屏是否显示更多按钮 (显示:true ; 隐藏:false)*/ 
	isShowMore?:boolean,

	/**（可选项）全屏是否显示投屏按钮 (显示:true ; 隐藏:false)*/ 
	isShowTouping?:boolean,

	/**（可选项）是否显示选集按钮 (显示:true ; 隐藏:false)*/ 
	isShowXuanji?:boolean,

	/**（可选项）是否显示下一集按钮 (显示:true ; 隐藏:false)*/ 
	isShowNext?:boolean,

	/**（可选项）是否显示上一集按钮 (显示:true ; 隐藏:false)*/ 
	isShowPre?:boolean,

	/**（可选项）窗口播放顶部控制栏是否沉侵式 (显示:true ; 隐藏:false)*/ 
	isSmallImmerse?:boolean,

	/**（可选项）窗口模式下是否长时间显示返回按钮 (显示:true ; 隐藏:false)*/ 
	isLongShowBackBtn?:boolean,

	/**（可选项）窗口是否显示分享按钮 (显示:true ; 隐藏:false)*/ 
	isSmallShowFenxiang?:boolean,

	/**（可选项）窗口是否显示更多按钮 (显示:true ; 隐藏:false)*/ 
	isSmallShowMore?:boolean,

	/**（可选项）窗口是否显示投屏按钮 (显示:true ; 隐藏:false)*/ 
	isSmallShowTouping?:boolean,

	/**（可选项）是否打开弹幕功能 (打开:true ; 关闭:false)*/ 
	isOpenDanmu?:boolean,

	/**（可选项）是否打开单页面播放模式。（当设置为true时，本页面播放器的接口只能在当前页面调用，不能跨页面；同时本页面开启多窗口模式无效）*/ 
	singlePageModule?:boolean,

	/**（可选项）是否在缓冲的时候显示网速*/ 
	isShowNetworkSpeed?:boolean,

	/**（可选项）视频播放前的图片显示(图片类型：jpg,png,gif)；支持fs://,widget://*/ 
	background?:any,

	/**（可选项）发送弹幕输入框默认提示内容。*/ 
	placeholderText?:string,

	/**（可选项）全屏下是否显示锁屏按钮(true 显示 false 不显示)。*/ 
	isShowLock?:boolean,

	/**（必填项）设置可免费播放时长,当免费播放完后触发播放异常事件，错误码5721*/ 
	freeProcess:number,

}

interface playModuleAli_playUrl_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

	/**（必填项）视频资源地址，支持fs://、widget://(在 android 平台上不支持 widget)、rtmp://、http://*/ 
	url:string,

	/**（可选项）不填时标题默认显示url播放文件名*/ 
	title?:string,

	/**（可选项）设置本次播放是否显示默认自带的播放控制按钮*/ 
	defaultBtn?:boolean,

	/**（可选项）是否直播视频源 （直播：true；点播：false）*/ 
	isLive?:boolean,

	/**（可选项）窗口播放时是否开启手势控制音量，亮度和进度 （开启：true；不开启：false）*/ 
	isSmallOpenGesture?:boolean,

	/**（可选项）全屏时是否开启手势控制音量，亮度和进度 （开启：true；不开启：false）*/ 
	isOpenGesture?:boolean,

	/**（必填项）设置视频需要播放的时长*/ 
	process:number,

	/**（可选项）是否自动播放 (自动播放:true ; 不自动播放:false)*/ 
	isAutoPlay?:boolean,

	/**（可选项）是否循环播放 (循环播放:true ; 禁止循环播放:false)*/ 
	isLoop?:boolean,

	/**（可选项）是否显示进度条 (显示:true ; 不显示:false)【备注:直播流自动默认为false】*/ 
	isShowProcessView?:boolean,

	/**（可选项）是否显示播放时间 (显示:true ; 不显示:false)*/ 
	isShowTimeLable?:boolean,

	/**（可选项）清晰度按钮的自定义(数组内容大于1条记录，清晰度切换按钮才会显示，不支持直播链接的组装切换，不能和url接口参数同时存在)。*/ 
	urlDatas?:Array,

	/**（可选项）是否窗口时显示清晰度选择按钮 (数组内容大于1条记录，清晰度切换按钮才会显示；显示:true ; 不显示:false)*/ 
	isSmallShowQxd?:boolean,

	/**（可选项）是否静音播放 (开启静音:true ; 关闭静音:false)*/ 
	isMute?:boolean,

	/**（可选项）是否开启弹幕功能 (开启:true ; 不开启:false)*/ 
	isShowDanmu?:boolean,

	/**（可选项）是否本地缓存视频,音频;直播类不能缓存,开发者自行控制;(备注:缓存文件在cache://文件目录下,如果直播乱开启改参数会导致播放异常). (开启:true ; 不开启:false)*/ 
	isLocalCache?:boolean,

	/**（可选项）全屏是否显示分享按钮 (显示:true ; 隐藏:false)*/ 
	isShowFenxiang?:boolean,

	/**（可选项）全屏是否显示更多按钮 (显示:true ; 隐藏:false)*/ 
	isShowMore?:boolean,

	/**（可选项）全屏是否显示投屏按钮 (显示:true ; 隐藏:false)*/ 
	isShowTouping?:boolean,

	/**（可选项）是否显示选集按钮 (显示:true ; 隐藏:false)*/ 
	isShowXuanji?:boolean,

	/**（可选项）是否显示下一集按钮 (显示:true ; 隐藏:false)*/ 
	isShowNext?:boolean,

	/**（可选项）是否显示上一集按钮 (显示:true ; 隐藏:false)*/ 
	isShowPre?:boolean,

	/**（可选项）窗口播放顶部控制栏是否沉侵式 (显示:true ; 隐藏:false)*/ 
	isSmallImmerse?:boolean,

	/**（可选项）窗口模式下是否长时间显示返回按钮 (显示:true ; 隐藏:false)*/ 
	isLongShowBackBtn?:boolean,

	/**（可选项）窗口是否显示分享按钮 (显示:true ; 隐藏:false)*/ 
	isSmallShowFenxiang?:boolean,

	/**（可选项）窗口是否显示更多按钮 (显示:true ; 隐藏:false)*/ 
	isSmallShowMore?:boolean,

	/**（可选项）窗口是否显示投屏按钮 (显示:true ; 隐藏:false)*/ 
	isSmallShowTouping?:boolean,

	/**（可选项）是否打开弹幕功能 (打开:true ; 关闭:false)*/ 
	isOpenDanmu?:boolean,

	/**（可选项）是否在缓冲的时候显示网速*/ 
	isShowNetworkSpeed?:boolean,

	/**（必填项）设置可免费播放时长,当免费播放完后触发播放异常事件，错误码5721*/ 
	freeProcess:number,

}

interface playModuleAli_pause_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

}

interface playModuleAli_start_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

}

interface playModuleAli_stop_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

}

interface playModuleAli_getDuration_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

}

interface playModuleAli_getCurrentPosition_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

}

interface playModuleAli_full_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

}

interface playModuleAli_unfull_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

}

interface playModuleAli_addEventListener_Params {
	/**监听事件名称,可以设置的播放界面监听类型有：playEnd(播放结束),playError(播放异常),pause(暂停),play(播放),backBtn(小窗口返回按钮),full(进入全屏按钮),unfull(退出全屏按钮),click(视频区域点击监听),bufferingStart(缓冲开始),bufferingEnd(缓冲结束), onPrepared(视频准备完成),onChangeQxd(清晰度改变), fenxiangClick(分析按钮), moreClick(更多按钮), toupingClick(投屏按钮), xuanjiClick(选集按钮), nextClick(下一集按钮), preClick(上一级按钮), sendDanmuMessage(发送弹幕输入框发送内容),danmuClick(弹幕开关按钮点击)*/ 
	name:string,

}

interface playModuleAli_isFullScreen_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

}

interface playModuleAli_seekTo_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

	/**（必填项）设置视频需要播放的时长*/ 
	process:number,

}

interface playModuleAli_setVolume_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

	/**（必填项）0-100*/ 
	volume:number,

}

interface playModuleAli_hidePlayer_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

}

interface playModuleAli_showPlayer_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

}

interface playModuleAli_setSpeed_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

	/**（必填项）设置视频播放倍速(取值范围 0.1-1.9)*/ 
	speed:number,

}

interface playModuleAli_updateUrlDatas_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

	/**（可选项）清晰度按钮的自定义(数组内容大于1条记录，清晰度切换按钮才会显示，不支持直播链接的组装切换，不能和url接口参数同时存在)。*/ 
	urlDatas?:Array,

}

interface playModuleAli_sendDanmu_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

	/**（必填项）弹幕文字内容*/ 
	text:string,

	/**（可选项）弹幕文字显示颜色代码*/ 
	color?:string,

	/**（可选项）弹幕文字大小*/ 
	textSize?:number,

}

interface playModuleAli_sendDanmuList_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

	/**（可选项）天际的全部数据是否循环播放(循环:true，不循环:false)*/ 
	isLoop?:boolean,

	/**（必填项）多条弹幕信息记录。*/ 
	data:Array,

}

interface playModuleAli_setMute_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

	/**（可选项）是否静音(开启静音:true 关闭静音:false)*/ 
	isMute?:boolean,

}

interface playModuleAli_takeSnapshot_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

}

interface playModuleAli_getCurrentSpeed_Params {
	/**（可选项）播放器序号*/ 
	index?:number,

}

interface appGray {
	/** 开启哀悼日全局灰*/ 
	openGray(callback?: (ret:JSON, err:JSON) => void):void

	/** 关闭哀悼日全局灰*/ 
	closeGray(callback?: (ret:JSON, err:JSON) => void):void

}
interface httpServer {
	/**
	 * `开启HTTP服务，开启指定端口，指定手机文件路径为根目录供网页访问。`
	 * ========params==========
	 *
	 * `www` :any : （必填项）开启服务的真实文件路径。
	 *
	 * `port` :number : 开启服务的端口号，默认：2633；取值范围0到65535
	 */
	start(params:httpServer_start_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 关闭HTTP服务。*/ 
	stop(callback?: (ret:JSON, err:JSON) => void):void

	/** 异步获取IP。*/ 
	getIp(callback?: (ret:JSON, err:JSON) => void):void

	/** 网页请求后的监听接口。网页被加载或者POST或者GET请求后，监听接口收到数据，并对数据开始处理保存响应等操作，最后可以用response或者responseSync接口作出当次请求的响应。*/ 
	addEventListener(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `异步请求响应接口（addEventListener收到带参数监听，就会进入30秒等待响应，如果不写响应代码，则该请求30秒后回调页面400）`
	 * ========params==========
	 *
	 * `sid` :any : （必填项）
	 *
	 * `data` :any : （必填项）
	 */
	response(params:httpServer_response_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 同步获取IP；*/ 
	ipSync():void

	/** 同步获取端口；*/ 
	portSync():void

	/** 同步获取当前提供访问的真实文件路径；*/ 
	wwwSync():void

	/** 同步获取当前服务的开启状态；*/ 
	runSync():void

	/**
	 * `同步请求响应接口（addEventListener收到带参数监听，就会进入30秒等待响应，如果不写响应代码，则该请求30秒后回调页面400）;`
	 * ========params==========
	 *
	 * `sid` :any : （必填项）
	 *
	 * `data` :any : （必填项）
	 */
	responseSync(params:httpServer_responseSync_Params):void

}
interface httpServer_start_Params {
	/**（必填项）开启服务的真实文件路径。*/ 
	www:any,

	/**开启服务的端口号，默认：2633；取值范围0到65535*/ 
	port:number,

}

interface httpServer_response_Params {
	/**（必填项）*/ 
	sid:any,

	/**（必填项）*/ 
	data:any,

}

interface httpServer_responseSync_Params {
	/**（必填项）*/ 
	sid:any,

	/**（必填项）*/ 
	data:any,

}

interface liveAudioPlayer {
	/**
	 * `播放网络音频，支持m3u8纯音频播放`
	 * ========params==========
	 *
	 * `url` :string : 音频资源地址。
	 */
	play(params:liveAudioPlayer_play_Params, callback?: (ret:JSON) => void):void

	/** 停止播放*/ 
	stop():void

}
interface liveAudioPlayer_play_Params {
	/**音频资源地址。*/ 
	url:string,

}

interface waterImageMark {
}
interface imageTool {
}
interface scrollVideo {
	/** 滑动播放器监听*/ 
	addEventListener():void

	/**
	 * `打开滑动播放器`
	 * ========params==========
	 *
	 * `rect` :JSON : （必填项）模块的位置及尺寸
	 *
	 * `fixedOn` :string : （可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window
	 *
	 * `fixed` :boolean : （（可选项）模块是否随所属 Window 或 Frame 滚动
	 *
	 * `userData` :any : （必填项）视频播放列表（最少传入1条记录）。
	 *
	 * `position` :number : （可选项）指定从播放列表中的第几条开始播放。
	 */
	openScrollVideo(params:scrollVideo_openScrollVideo_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 隐藏滑动播放器*/ 
	hideScrollVideo(callback?: (ret:JSON, err:JSON) => void):void

	/** 显示滑动播放器*/ 
	showScrollVideo():void

	/** 关闭滑动播放器*/ 
	closeScrollVideo(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `更新当前播放器样式`
	 * ========params==========
	 *
	 * `styles` :any : （必填项）当前播放器播放的按钮样式更新。
	 */
	updateVideoStyle(params:scrollVideo_updateVideoStyle_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `添加一条记录`
	 * ========params==========
	 *
	 * `uid` :string : （必填项）播放ID
	 *
	 * `imageUrl` :string : （必填项）播放前的预览图片
	 *
	 * `videoUrl` :any : （必填项）播放的视频地址(支持http,https)
	 *
	 * `isLocalCache` :boolean : （可选项）是否本地缓存视频,音频;直播类不能缓存,开发者自行控制;(备注:iOS虽然缓存在本地了,但是不能完全离线播放;缓存文件在cache://文件目录下). (开启:true ; 不开启:false)
	 *
	 * `scalingMode` :number : （可选项）视频播放显示铺满模式（1:无缩放, 2:适应大小模式, 3:充满可视范围，可能会被裁剪, 4:缩放到充满视图）
	 *
	 * `placeholderColor` :string : （可选项）背景图的背景色。
	 *
	 * `placeholderImage` :string : （可选项）背景图未加载时显示的图片,当该值存在时，placeholderColor无效。
	 *
	 * `imageType` :number : （可选项）背景图渲染类型 0:图片拉伸填充(图片可能会变形) 1:图片拉伸至完全显示(图片不会变形) 2:图片拉伸至完全铺满填充(图片不会变形)
	 *
	 * `styles` :any : （可选项）当前播放器播放的按钮样式更新。
	 */
	addVideoData(params:scrollVideo_addVideoData_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 暂停当前视频播放*/ 
	pause(callback?: (ret:JSON, err:JSON) => void):void

	/** 暂停后恢复播放当前视频*/ 
	play(callback?: (ret:JSON, err:JSON) => void):void

	/** 是否播放状态*/ 
	isPlaying():void

	/** 获取播放item总数*/ 
	itemCount():void

	/** 获取视频的时长*/ 
	getDuration():void

	/** 获取已经播放的时长*/ 
	getCurrentPosition():void

	/**
	 * `设置音量`
	 * ========params==========
	 *
	 * `volume` :number : （可选项）播放视频音量0-100。
	 */
	setVolume(params:scrollVideo_setVolume_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 删除当前播放item(当删除到最后剩余1条记录的时候就不能删除了)*/ 
	delCurrentItem(callback?: (ret:JSON, err:JSON) => void):void

	/** 获取已经缓存的时长*/ 
	getBufferPercentage():void

	/**
	 * `设置播放进度`
	 * ========params==========
	 *
	 * `process` :JSON : （可选项）播放视频进度值。
	 */
	seekTo(params:scrollVideo_seekTo_Params):void

	/**
	 * `播放指定序号视频`
	 * ========params==========
	 *
	 * `position` :number : （可选项）播放指定列表中序号视频。
	 */
	playSpecifiedItem(params:scrollVideo_playSpecifiedItem_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `添加多条记录`
	 * ========params==========
	 *
	 * `userData` :any : （必填项）视频播放列表（最少传入1条记录）。
	 */
	addVideoDatas(params:scrollVideo_addVideoDatas_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface scrollVideo_openScrollVideo_Params {
	/**（必填项）模块的位置及尺寸*/ 
	rect:JSON,

	/**（可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window*/ 
	fixedOn?:string,

	/**（（可选项）模块是否随所属 Window 或 Frame 滚动*/ 
	fixed?:boolean,

	/**（必填项）视频播放列表（最少传入1条记录）。*/ 
	userData:any,

	/**（可选项）指定从播放列表中的第几条开始播放。*/ 
	position?:number,

}

interface scrollVideo_updateVideoStyle_Params {
	/**（必填项）当前播放器播放的按钮样式更新。*/ 
	styles:any,

}

interface scrollVideo_addVideoData_Params {
	/**（必填项）播放ID*/ 
	uid:string,

	/**（必填项）播放前的预览图片*/ 
	imageUrl:string,

	/**（必填项）播放的视频地址(支持http,https)*/ 
	videoUrl:any,

	/**（可选项）是否本地缓存视频,音频;直播类不能缓存,开发者自行控制;(备注:iOS虽然缓存在本地了,但是不能完全离线播放;缓存文件在cache://文件目录下). (开启:true ; 不开启:false)*/ 
	isLocalCache?:boolean,

	/**（可选项）视频播放显示铺满模式（1:无缩放, 2:适应大小模式, 3:充满可视范围，可能会被裁剪, 4:缩放到充满视图）*/ 
	scalingMode?:number,

	/**（可选项）背景图的背景色。*/ 
	placeholderColor?:string,

	/**（可选项）背景图未加载时显示的图片,当该值存在时，placeholderColor无效。*/ 
	placeholderImage?:string,

	/**（可选项）背景图渲染类型 0:图片拉伸填充(图片可能会变形) 1:图片拉伸至完全显示(图片不会变形) 2:图片拉伸至完全铺满填充(图片不会变形)*/ 
	imageType?:number,

	/**（可选项）当前播放器播放的按钮样式更新。*/ 
	styles?:any,

}

interface scrollVideo_setVolume_Params {
	/**（可选项）播放视频音量0-100。*/ 
	volume?:number,

}

interface scrollVideo_seekTo_Params {
	/**（可选项）播放视频进度值。*/ 
	process?:JSON,

}

interface scrollVideo_playSpecifiedItem_Params {
	/**（可选项）播放指定列表中序号视频。*/ 
	position?:number,

}

interface scrollVideo_addVideoDatas_Params {
	/**（必填项）视频播放列表（最少传入1条记录）。*/ 
	userData:any,

}

interface floatVideo {
	/** 是否有显示悬浮窗口的权限。（同步方法）返回true有权限，返回false没有权限。*/ 
	hasPermission():void

	/**
	 * `打开安卓"设置"(Settings)界面`
	 * ========params==========
	 *
	 * `pkg` :string : （可选项）APP的包名，比如com.apicloud.app.book，大多数情况下都是设置自己APP的包名，所以不必带这个参数，用默认的就好。
	 */
	openSettings(params:floatVideo_openSettings_Params):void

	/**
	 * `设置悬浮窗口属性。`
	 * ========params==========
	 *
	 * `x` :number : （可选项）x坐标。
	 *
	 * `y` :number : （可选项）y坐标。
	 *
	 * `w` :number : （可选项）窗口宽度。
	 *
	 * `h` :number : （可选项）窗口高度。
	 *
	 * `url` :string : （必填）播放视频的url,支持网络和本地，支持m3u8。
	 *
	 * `currentPosition` :number : （可选项）从这个位置开始播。（毫秒）
	 *
	 * `clickBack` :boolean : （可选项）是否开启点击返回到App。（个人建议关闭，有时候只是想移动窗口，却被误判为点击事件了。）
	 */
	setWinAttr(params:floatVideo_setWinAttr_Params, callback?: (ret:JSON) => void):void

	/** 显示窗口。（显示之前至少调用一次setWinAttr来设置参数）*/ 
	show():void

	/** 隐藏窗口。*/ 
	hide():void

	/** 获取视频播放位置。（同步方法）*/ 
	getCurrentPosition():void

}
interface floatVideo_openSettings_Params {
	/**（可选项）APP的包名，比如com.apicloud.app.book，大多数情况下都是设置自己APP的包名，所以不必带这个参数，用默认的就好。*/ 
	pkg?:string,

}

interface floatVideo_setWinAttr_Params {
	/**（可选项）x坐标。*/ 
	x?:number,

	/**（可选项）y坐标。*/ 
	y?:number,

	/**（可选项）窗口宽度。*/ 
	w?:number,

	/**（可选项）窗口高度。*/ 
	h?:number,

	/**（必填）播放视频的url,支持网络和本地，支持m3u8。*/ 
	url:string,

	/**（可选项）从这个位置开始播。（毫秒）*/ 
	currentPosition?:number,

	/**（可选项）是否开启点击返回到App。（个人建议关闭，有时候只是想移动窗口，却被误判为点击事件了。）*/ 
	clickBack?:boolean,

}

interface HeartRate {
	/**
	 * `开始获取心率值`
	 * ========params==========
	 *
	 * `rect` :JSON : 画面展示尺寸 （仅支持安卓）
	 *
	 * `fixedOn` :string : （可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 Window 或 Frame 滚动
	 */
	open(params:HeartRate_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭心率获取（仅android支持）*/ 
	close(callback?: (ret:JSON, err:JSON) => void):void

}
interface HeartRate_open_Params {
	/**画面展示尺寸 （仅支持安卓）*/ 
	rect:JSON,

	/**（可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 Window 或 Frame 滚动*/ 
	fixed?:boolean,

}

interface FNQRcreate {
	/**
	 * `二维码/条形码图片解码`
	 * ========params==========
	 *
	 * `sound` :string : （可选项）扫描结束后的提示音文件路径，要求本地路径（fs://、widget://），**为保证兼容性，推荐使用  wav 格式的短音频文件**
	 *
	 * `path` :string : （可选项）要识别的图片路径，要求本地路径（fs://、widget://），**若不传则打开系统相册**
	 */
	decodeImg(params:FNQRcreate_decodeImg_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `将字符串生成二维码/条形码图片`
	 * ========params==========
	 *
	 * `type` :string : （可选项）生成图片的类型，默认值：'qr_image'
	 *
	 * `content` :string : 所要生成的二维码/条形码字符串，**当 type 为 bar_image 时，该值只能为数字字符串**
	 *
	 * `saveToAlbum` :boolean : （可选项）扫描的二维码/条形码图片是否自动保存到相册
	 *
	 * `saveImg` :JSON : （可选项）扫描的二维码/条形码图片保存所需要的参数，若不传则不保存
	 */
	encodeImg(params:FNQRcreate_encodeImg_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface FNQRcreate_decodeImg_Params {
	/**（可选项）扫描结束后的提示音文件路径，要求本地路径（fs://、widget://），**为保证兼容性，推荐使用  wav 格式的短音频文件***/ 
	sound?:string,

	/**（可选项）要识别的图片路径，要求本地路径（fs://、widget://），**若不传则打开系统相册***/ 
	path?:string,

}

interface FNQRcreate_encodeImg_Params {
	/**（可选项）生成图片的类型，默认值：'qr_image'*/ 
	type?:string,

	/**所要生成的二维码/条形码字符串，**当 type 为 bar_image 时，该值只能为数字字符串***/ 
	content:string,

	/**（可选项）扫描的二维码/条形码图片是否自动保存到相册*/ 
	saveToAlbum?:boolean,

	/**（可选项）扫描的二维码/条形码图片保存所需要的参数，若不传则不保存*/ 
	saveImg?:JSON,

}

interface exifInterface {
	/**
	 * `设置图片的经纬度属性`
	 * ========params==========
	 *
	 * `picPath` :string : （必填项）图片的路径，仅支持jpeg,jgp文件格式(ios支持fs://,widget://;[安卓支持fs://])。
	 *
	 * `latitude` :number : （可选项）经度。
	 *
	 * `longitude` :number : （可选项）纬度。
	 */
	setExifInfo(params:exifInterface_setExifInfo_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取图片的属性`
	 * ========params==========
	 *
	 * `picPath` :string : （必填项）图片的路径，仅支持jpeg,jgp文件格式(ios支持fs://,widget://;安卓支持fs://)。
	 */
	getExifInfo(params:exifInterface_getExifInfo_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `旋转图片`
	 * ========params==========
	 *
	 * `picPath` :string : （必填项）图片的路径，仅支持jpeg,jgp文件格式(ios支持fs://,widget://;安卓支持fs://)。
	 *
	 * `degrees` :number : （可选项）需要旋转图片的角度。(取值范围 90,180,270)。
	 */
	setDegreeExif(params:exifInterface_setDegreeExif_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface exifInterface_setExifInfo_Params {
	/**（必填项）图片的路径，仅支持jpeg,jgp文件格式(ios支持fs://,widget://;[安卓支持fs://])。*/ 
	picPath:string,

	/**（可选项）经度。*/ 
	latitude?:number,

	/**（可选项）纬度。*/ 
	longitude?:number,

}

interface exifInterface_getExifInfo_Params {
	/**（必填项）图片的路径，仅支持jpeg,jgp文件格式(ios支持fs://,widget://;安卓支持fs://)。*/ 
	picPath:string,

}

interface exifInterface_setDegreeExif_Params {
	/**（必填项）图片的路径，仅支持jpeg,jgp文件格式(ios支持fs://,widget://;安卓支持fs://)。*/ 
	picPath:string,

	/**（可选项）需要旋转图片的角度。(取值范围 90,180,270)。*/ 
	degrees?:number,

}

interface mtlNFC {
	/** 打开NFC，读取卡片信息。设备NFC功能打开后，应用在前台时调用此方法可以读取卡片信息返回。*/ 
	init(callback?: (ret:JSON, err:JSON) => void):void

	/** 使用完毕后需要调用此方法关闭*/ 
	unInit():void

	/** 设置提示文案*/ 
	setTips():void

}
interface mdReader {
}
interface officePreview {
	/** 打开文档预览*/ 
	open():void

	/** 显示浏览器*/ 
	show():void

}
interface FNQRscan {
	/**
	 * `打开自带默认 UI 效果的二维码/条形码扫描页面，本界面相当于打开一个 window 窗口，其界面内容不支持自定义`
	 * ========params==========
	 *
	 * `sound` :string : （可选项）扫描结束后的提示音文件路径，要求本地路径（fs://、widget://），**为保证兼容性，推荐使用 wav 格式的短音频文件**
	 *
	 * `autorotation` :boolean : （可选项）扫描页面是否自动旋转（横竖屏）
	 *
	 * `saveToAlbum` :boolean : （可选项）扫描的二维码/条形码图片是否自动保存到相册
	 *
	 * `verticalLineColor` :string : (可选项) 字符串类型；竖屏时扫描线的颜色,支持支持rgb、rgba、#；
	 *
	 * `landscapeLineColor` :string : (可选项) 字符串类型；横屏时扫描线的颜色,支持支持rgb、rgba、#； (android不支持，android的横竖屏是一个颜色)
	 *
	 * `hintText` :string : (可选项) 字符串类型；二维码/条形码界面扫码界面底下的文字
	 *
	 * `albumText` :string : (可选项) 相册按钮文字
	 *
	 * `lightText` :string : (可选项) 灯光开启文字
	 *
	 * `closeText` :string : (可选项) 灯光关闭文字
	 *
	 * `isAlbum` :boolean : (可选项) 是否隐藏相册按钮
	 *
	 * `font` :JSON : （可选项）文字样式
	 *
	 * `saveImg` :JSON : （可选项）扫描的二维码/条形码图片保存所需要的参数，若不传则不保存
	 */
	open(params:FNQRscan_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `打开二维码/条码扫描器`
	 * ========params==========
	 *
	 * `sound` :string : （可选项）扫描结束后的提示音文件路径，要求本地路径（fs://、widget://），**为保证兼容性，推荐使用 wav 格式的短音频文件**
	 *
	 * `autorotation` :boolean : （可选项）扫描页面是否自动旋转（横竖屏）
	 *
	 * `saveToAlbum` :boolean : （可选项）扫描的二维码/条形码图片是否自动保存到相册
	 *
	 * `verticalLineColor` :string : (可选项) 字符串类型；竖屏时扫描线的颜色,支持支持rgb、rgba、#；仅android有效
	 *
	 * `saveImg` :JSON : （可选项）扫描的二维码/条形码图片保存所需要的参数，若不传则不保存
	 *
	 * `hintText` :string : (可选项) 字符串类型；二维码/条形码界面扫码界面底下的文字(ios不支持)
	 *
	 * `font` :JSON : （可选项）文字样式
	 *
	 * `isAlbum` :boolean : (可选项) 是否隐藏相册按钮
	 */
	openScanner(params:FNQRscan_openScanner_Params, callback?: (ret:JSON) => void):void

	/**
	 * `打开可自定义的二维码/条形码扫描器`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）扫描器的位置及尺寸，**在安卓平台宽高比须跟屏幕宽高比一致，否则摄像头可视区域的图像可能出现少许变形；w和h属性最好使用api.winWidth和api.winHeight,这样不会导致变形，也不会出现手机必须要在一定的距离上才能扫描出来的现象**
	 *
	 * `rectOfInterest` :JSON : （可选项）在扫码区域上的扫码识别区域，**仅在iOS平台有效**
	 *
	 * `sound` :string : （可选项）扫描结束后的提示音文件路径，要求本地路径（fs://、widget://），**为保证兼容性，推荐使用 wav 格式的短音频文件**
	 *
	 * `autorotation` :boolean : （可选项）扫描页面是否自动旋转（横竖屏）
	 *
	 * `saveToAlbum` :boolean : （可选项）扫描的二维码/条形码图片是否自动保存到相册
	 *
	 * `saveImg` :JSON : （可选项）扫描的二维码/条形码图片保存所需要的参数，若不传则不保存
	 *
	 * `interval` :number : （可选项）连续扫描间隔；android不支持此参数
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	openView(params:FNQRscan_openView_Params, callback?: (ret:JSON) => void):void

	/**
	 * `重设可自定义的二维码/条形码扫描器的大小和位置`
	 * ========params==========
	 *
	 * `x` :number : （可选项）模块左上角的 x 坐标（相对于所属的 Window 或 Frame）
	 *
	 * `y` :number : （可选项）模块左上角的 y 坐标（相对于所属的 Window 或 Frame）
	 *
	 * `w` :number : （可选项）模块的宽度
	 *
	 * `h` :number : （可选项）模块的高度
	 */
	setFrame(params:FNQRscan_setFrame_Params):void

	/** 关闭自定义大小的二维码/条码扫描器*/ 
	closeView():void

	/**
	 * `打开/关闭闪光灯（在Android上，已打开扫码视图时有效）`
	 * ========params==========
	 *
	 * `status` :string : （可选项）打开/关闭闪光灯，默认值：'off'
	 */
	switchLight(params:FNQRscan_switchLight_Params):void

	/** 通知当前本模块app进入回到前台。此时模块会进行一些资源的恢复操作，防止照相机回来之后黑屏*/ 
	onResume():void

	/** 通知当前本模块app进入后台。此时模块会进行一些资源的暂停存储操作，防止照相机回来之后黑屏*/ 
	onPause():void

}
interface FNQRscan_open_Params {
	/**（可选项）扫描结束后的提示音文件路径，要求本地路径（fs://、widget://），**为保证兼容性，推荐使用 wav 格式的短音频文件***/ 
	sound?:string,

	/**（可选项）扫描页面是否自动旋转（横竖屏）*/ 
	autorotation?:boolean,

	/**（可选项）扫描的二维码/条形码图片是否自动保存到相册*/ 
	saveToAlbum?:boolean,

	/**(可选项) 字符串类型；竖屏时扫描线的颜色,支持支持rgb、rgba、#；*/ 
	verticalLineColor?:string,

	/**(可选项) 字符串类型；横屏时扫描线的颜色,支持支持rgb、rgba、#； (android不支持，android的横竖屏是一个颜色)*/ 
	landscapeLineColor?:string,

	/**(可选项) 字符串类型；二维码/条形码界面扫码界面底下的文字*/ 
	hintText?:string,

	/**(可选项) 相册按钮文字*/ 
	albumText?:string,

	/**(可选项) 灯光开启文字*/ 
	lightText?:string,

	/**(可选项) 灯光关闭文字*/ 
	closeText?:string,

	/**(可选项) 是否隐藏相册按钮*/ 
	isAlbum?:boolean,

	/**（可选项）文字样式*/ 
	font?:JSON,

	/**（可选项）扫描的二维码/条形码图片保存所需要的参数，若不传则不保存*/ 
	saveImg?:JSON,

}

interface FNQRscan_openScanner_Params {
	/**（可选项）扫描结束后的提示音文件路径，要求本地路径（fs://、widget://），**为保证兼容性，推荐使用 wav 格式的短音频文件***/ 
	sound?:string,

	/**（可选项）扫描页面是否自动旋转（横竖屏）*/ 
	autorotation?:boolean,

	/**（可选项）扫描的二维码/条形码图片是否自动保存到相册*/ 
	saveToAlbum?:boolean,

	/**(可选项) 字符串类型；竖屏时扫描线的颜色,支持支持rgb、rgba、#；仅android有效*/ 
	verticalLineColor?:string,

	/**（可选项）扫描的二维码/条形码图片保存所需要的参数，若不传则不保存*/ 
	saveImg?:JSON,

	/**(可选项) 字符串类型；二维码/条形码界面扫码界面底下的文字(ios不支持)*/ 
	hintText?:string,

	/**（可选项）文字样式*/ 
	font?:JSON,

	/**(可选项) 是否隐藏相册按钮*/ 
	isAlbum?:boolean,

}

interface FNQRscan_openView_Params {
	/**（可选项）扫描器的位置及尺寸，**在安卓平台宽高比须跟屏幕宽高比一致，否则摄像头可视区域的图像可能出现少许变形；w和h属性最好使用api.winWidth和api.winHeight,这样不会导致变形，也不会出现手机必须要在一定的距离上才能扫描出来的现象***/ 
	rect?:JSON,

	/**（可选项）在扫码区域上的扫码识别区域，**仅在iOS平台有效***/ 
	rectOfInterest?:JSON,

	/**（可选项）扫描结束后的提示音文件路径，要求本地路径（fs://、widget://），**为保证兼容性，推荐使用 wav 格式的短音频文件***/ 
	sound?:string,

	/**（可选项）扫描页面是否自动旋转（横竖屏）*/ 
	autorotation?:boolean,

	/**（可选项）扫描的二维码/条形码图片是否自动保存到相册*/ 
	saveToAlbum?:boolean,

	/**（可选项）扫描的二维码/条形码图片保存所需要的参数，若不传则不保存*/ 
	saveImg?:JSON,

	/**（可选项）连续扫描间隔；android不支持此参数*/ 
	interval?:number,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface FNQRscan_setFrame_Params {
	/**（可选项）模块左上角的 x 坐标（相对于所属的 Window 或 Frame）*/ 
	x?:number,

	/**（可选项）模块左上角的 y 坐标（相对于所属的 Window 或 Frame）*/ 
	y?:number,

	/**（可选项）模块的宽度*/ 
	w?:number,

	/**（可选项）模块的高度*/ 
	h?:number,

}

interface FNQRscan_switchLight_Params {
	/**（可选项）打开/关闭闪光灯，默认值：'off'*/ 
	status?:string,

}

interface sharePics {
	/** 分享图片数组以及文字*/ 
	shareToTimeLine():void

}
interface easyCamera {
	/** 调用系统相机拍照或者录制视频*/ 
	openCamera(callback?: (ret:JSON) => void):void

}
interface cameraWeibo {
	/**
	 * `打开固定 UI 的相机页面`
	 * ========params==========
	 *
	 * `save` :JSON : （可选项）拍摄的图片、视频保存信息
	 *
	 * `album` :boolean : （可选项）拍照成功后是否将所拍结果存入系统相册
	 *
	 * `quality` :string : （可选项）拍摄质量
	 */
	open(params:cameraWeibo_open_Params, callback?: (ret:JSON) => void):void

	/** 取消/关闭拍照页面*/ 
	cancel():void

}
interface cameraWeibo_open_Params {
	/**（可选项）拍摄的图片、视频保存信息*/ 
	save?:JSON,

	/**（可选项）拍照成功后是否将所拍结果存入系统相册*/ 
	album?:boolean,

	/**（可选项）拍摄质量*/ 
	quality?:string,

}

interface socketManager {
}
interface appControl {
}
interface screenCapture {
	/** 是否正在录屏*/ 
	isCaptured():void

	/**
	 * `监听录屏状态改变事件`
	 * ========params==========
	 *
	 * `user` :string : 用户ID
	 */
	addCaptureListener(params:screenCapture_addCaptureListener_Params, callback?: (ret:JSON) => void):void

	/** 移除监听*/ 
	removeCaptureListener():void

}
interface screenCapture_addCaptureListener_Params {
	/**用户ID*/ 
	user:string,

}

interface blurredView {
}
interface exportExcel {
	/**
	 * `创建workbook`
	 * ========params==========
	 *
	 * `fileName` :JSON : （必填项）保存excel文件名称
	 */
	createWorkbook(params:exportExcel_createWorkbook_Params):void

	/**
	 * `创建sheet`
	 * ========params==========
	 *
	 * `sheetName` :JSON : （可选项）sheet名称
	 */
	createSheet(params:exportExcel_createSheet_Params):void

	/**
	 * `设置列宽`
	 * ========params==========
	 *
	 * `col` :number : （可选项）需要设置宽度的列
	 *
	 * `width` :JSON : （可选项）列宽度值
	 */
	setColumnSize(params:exportExcel_setColumnSize_Params):void

	/**
	 * `设置行高`
	 * ========params==========
	 *
	 * `row` :number : （可选项）需要设置宽度的行
	 *
	 * `width` :JSON : （可选项）行高度值
	 */
	setRowSize(params:exportExcel_setRowSize_Params):void

	/**
	 * `写入String`
	 * ========params==========
	 *
	 * `row` :number : （可选项）行
	 *
	 * `col` :number : （可选项）列
	 *
	 * `data` :string : （可选项）需要写入的内容
	 *
	 * `style` :JSON : （可选项）单元格样式
	 *
	 * `merge` :JSON : （可选项）单元格合并
	 */
	writeString(params:exportExcel_writeString_Params):void

	/**
	 * `写入Int`
	 * ========params==========
	 *
	 * `row` :number : （可选项）行
	 *
	 * `col` :number : （可选项）列
	 *
	 * `data` :number : （可选项）需要写入的内容
	 *
	 * `style` :JSON : （可选项）单元格样式
	 *
	 * `merge` :JSON : （可选项）单元格合并
	 */
	writeInt(params:exportExcel_writeInt_Params):void

	/**
	 * `写入Double`
	 * ========params==========
	 *
	 * `row` :number : （可选项）行
	 *
	 * `col` :number : （可选项）列
	 *
	 * `data` :any : （可选项）需要写入的内容
	 *
	 * `style` :JSON : （可选项）单元格样式
	 *
	 * `merge` :JSON : （可选项）单元格合并
	 */
	writeDouble(params:exportExcel_writeDouble_Params):void

	/**
	 * `写入公式`
	 * ========params==========
	 *
	 * `row` :number : （可选项）行
	 *
	 * `col` :number : （可选项）列
	 *
	 * `data` :string : （可选项）需要写入的内容
	 *
	 * `style` :JSON : （可选项）单元格样式
	 */
	writeFormula(params:exportExcel_writeFormula_Params):void

	/**
	 * `写入图片`
	 * ========params==========
	 *
	 * `row` :number : （可选项）行
	 *
	 * `col` :number : （可选项）列
	 *
	 * `data` :string : （可选项）需要写入的内容
	 */
	writeImage(params:exportExcel_writeImage_Params):void

	/** 关闭workbook(关闭后才算完全执行写入xls逻辑)*/ 
	closeWorkbook():void

}
interface exportExcel_createWorkbook_Params {
	/**（必填项）保存excel文件名称*/ 
	fileName:JSON,

}

interface exportExcel_createSheet_Params {
	/**（可选项）sheet名称*/ 
	sheetName?:JSON,

}

interface exportExcel_setColumnSize_Params {
	/**（可选项）需要设置宽度的列*/ 
	col?:number,

	/**（可选项）列宽度值*/ 
	width?:JSON,

}

interface exportExcel_setRowSize_Params {
	/**（可选项）需要设置宽度的行*/ 
	row?:number,

	/**（可选项）行高度值*/ 
	width?:JSON,

}

interface exportExcel_writeString_Params {
	/**（可选项）行*/ 
	row?:number,

	/**（可选项）列*/ 
	col?:number,

	/**（可选项）需要写入的内容*/ 
	data?:string,

	/**（可选项）单元格样式*/ 
	style?:JSON,

	/**（可选项）单元格合并*/ 
	merge?:JSON,

}

interface exportExcel_writeInt_Params {
	/**（可选项）行*/ 
	row?:number,

	/**（可选项）列*/ 
	col?:number,

	/**（可选项）需要写入的内容*/ 
	data?:number,

	/**（可选项）单元格样式*/ 
	style?:JSON,

	/**（可选项）单元格合并*/ 
	merge?:JSON,

}

interface exportExcel_writeDouble_Params {
	/**（可选项）行*/ 
	row?:number,

	/**（可选项）列*/ 
	col?:number,

	/**（可选项）需要写入的内容*/ 
	data?:any,

	/**（可选项）单元格样式*/ 
	style?:JSON,

	/**（可选项）单元格合并*/ 
	merge?:JSON,

}

interface exportExcel_writeFormula_Params {
	/**（可选项）行*/ 
	row?:number,

	/**（可选项）列*/ 
	col?:number,

	/**（可选项）需要写入的内容*/ 
	data?:string,

	/**（可选项）单元格样式*/ 
	style?:JSON,

}

interface exportExcel_writeImage_Params {
	/**（可选项）行*/ 
	row?:number,

	/**（可选项）列*/ 
	col?:number,

	/**（可选项）需要写入的内容*/ 
	data?:string,

}

interface logger {
}
interface qiniuUpfile {
}
interface moduleTVKeyApi {
	/** 创建并使用模块接口*/ 
	onstart():void

}
interface moduleBusQrcode {
}
interface nativeDialog {
	/**
	 * `打开win页面`
	 * ========params==========
	 *
	 * `url` :string : 页面路径,支持任意协议的路径，如标准的content://，res://，https://，以及APICloud扩展的widget://，fs://
	 *
	 * `name` :string : 页面名称 **iOS必传**
	 *
	 * `animated` :boolean : 是否需要过渡动画 **仅ios有效**
	 */
	openWin(params:nativeDialog_openWin_Params):void

	/**
	 * `以modal方式打开页面 **仅ios**`
	 * ========params==========
	 *
	 * `url` :string : 页面路径,支持任意协议的路径，如标准的content://，res://，https://，以及APICloud扩展的widget://，fs://
	 *
	 * `name` :string : 页面名称 **iOS必传**
	 *
	 * `style` :number : modal的呈现方式（modalPresentationStyle），取值范围：-2、 0 ～ 7
	 *
	 * `animated` :boolean : 是否需要过渡动画 **仅ios有效**
	 */
	openModal(params:nativeDialog_openModal_Params):void

	/**
	 * `ios 关闭当前打开的modal页面 **仅ios**`
	 * ========params==========
	 *
	 * `animated` :boolean : 是否需要过渡动画
	 */
	closeModal(params:nativeDialog_closeModal_Params):void

}
interface nativeDialog_openWin_Params {
	/**页面路径,支持任意协议的路径，如标准的content://，res://，https://，以及APICloud扩展的widget://，fs://*/ 
	url:string,

	/**页面名称 **iOS必传***/ 
	name:string,

	/**是否需要过渡动画 **仅ios有效***/ 
	animated:boolean,

}

interface nativeDialog_openModal_Params {
	/**页面路径,支持任意协议的路径，如标准的content://，res://，https://，以及APICloud扩展的widget://，fs://*/ 
	url:string,

	/**页面名称 **iOS必传***/ 
	name:string,

	/**modal的呈现方式（modalPresentationStyle），取值范围：-2、 0 ～ 7*/ 
	style:number,

	/**是否需要过渡动画 **仅ios有效***/ 
	animated:boolean,

}

interface nativeDialog_closeModal_Params {
	/**是否需要过渡动画*/ 
	animated:boolean,

}

interface mqtt {
	/**     建立MQTT连接*/ 
	startmqtt():void

	/**     断开MQTT连接*/ 
	stopmqtt():void

	/**     发送指令*/ 
	publish():void

	/**     增加订阅的通道*/ 
	subscribe():void

	/**     移除订阅的通道*/ 
	unsubscribe():void

}
interface IdCardModule {
}
interface m3u8Download {
	/**
	 * `m3u8视频下载监听事件`
	 * ========params==========
	 *
	 * `videoId` :string : （可选项）视频ID，当不传某一个唯一的视频ID时，该监听会返回所有视频下载信息，当设置具体的视频ID时，只返回设置的视频ID的下载信息。
	 */
	addEventListener(params:m3u8Download_addEventListener_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `开始下载`
	 * ========params==========
	 *
	 * `videoId` :string : （必填项）视频唯一的ID。
	 *
	 * `url` :string : （必填项）M3U8下载地址，该地址必须为可解析的地址。不能是直播地址，请开发者自行控制。
	 */
	start(params:m3u8Download_start_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `暂停下载`
	 * ========params==========
	 *
	 * `videoId` :string : （必填项）视频唯一的ID。
	 */
	pause(params:m3u8Download_pause_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `恢复下载`
	 * ========params==========
	 *
	 * `videoId` :string : （必填项）视频唯一的ID。
	 */
	resume(params:m3u8Download_resume_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `是否下载完成`
	 * ========params==========
	 *
	 * `videoId` :string : （必填项）视频唯一的ID。
	 */
	isDownloadFinish(params:m3u8Download_isDownloadFinish_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取缓存大小`
	 * ========params==========
	 *
	 * `videoId` :string : （可选项）视频唯一的ID,不填则获取模块所有缓存视频文件夹大小。
	 */
	getCacheSize(params:m3u8Download_getCacheSize_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `清除缓存文件`
	 * ========params==========
	 *
	 * `videoId` :string : （可选项）视频唯一的ID,不填则清除模块所有缓存视频文件夹大小。
	 */
	clearCache(params:m3u8Download_clearCache_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface m3u8Download_addEventListener_Params {
	/**（可选项）视频ID，当不传某一个唯一的视频ID时，该监听会返回所有视频下载信息，当设置具体的视频ID时，只返回设置的视频ID的下载信息。*/ 
	videoId?:string,

}

interface m3u8Download_start_Params {
	/**（必填项）视频唯一的ID。*/ 
	videoId:string,

	/**（必填项）M3U8下载地址，该地址必须为可解析的地址。不能是直播地址，请开发者自行控制。*/ 
	url:string,

}

interface m3u8Download_pause_Params {
	/**（必填项）视频唯一的ID。*/ 
	videoId:string,

}

interface m3u8Download_resume_Params {
	/**（必填项）视频唯一的ID。*/ 
	videoId:string,

}

interface m3u8Download_isDownloadFinish_Params {
	/**（必填项）视频唯一的ID。*/ 
	videoId:string,

}

interface m3u8Download_getCacheSize_Params {
	/**（可选项）视频唯一的ID,不填则获取模块所有缓存视频文件夹大小。*/ 
	videoId?:string,

}

interface m3u8Download_clearCache_Params {
	/**（可选项）视频唯一的ID,不填则清除模块所有缓存视频文件夹大小。*/ 
	videoId?:string,

}

interface lottie {
	/** 展示AE动画*/ 
	loadAnim(callback?: (ret:JSON, err:JSON) => void):void

	/** 重新加载动画*/ 
	reloadAnim(callback?: (ret:JSON, err:JSON) => void):void

	/** 隐藏*/ 
	hide(callback?: (ret:JSON, err:JSON) => void):void

	/** 显示*/ 
	show(callback?: (ret:JSON, err:JSON) => void):void

	/** 移除*/ 
	remove(callback?: (ret:JSON, err:JSON) => void):void

}
interface compressVideo {
	/** 选取本地视频。注意:对于iOS，在选取视频确定时，系统会自带出现正在压缩提示，此处系统并未真正进行压缩，如需要压缩请使用compressVideo方法。对于Android，该方法会调用系统自带文件管理器进行选择文件，开发者可根据用户选择完成后返回的文件路径自行判断选择的文件是否是视频文件。*/ 
	selectVideo(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `传入视频路径压缩视频`
	 * ========params==========
	 *
	 * `path` :string : (必填)需要压缩的视频文件路径，该参数可传入调用selectVideo方法返回的视频文件路径(path)，或可传入开发者自行获取到的的视频文件路径。
	 *
	 * `quality` :string : (可选项)对压缩视频的质量要求，取值:l、m、h , 其中 l 为最差画质，m 为中度画质，h 为略高画质
	 */
	compressVideo(params:compressVideo_compressVideo_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface compressVideo_compressVideo_Params {
	/**(必填)需要压缩的视频文件路径，该参数可传入调用selectVideo方法返回的视频文件路径(path)，或可传入开发者自行获取到的的视频文件路径。*/ 
	path:string,

	/**(可选项)对压缩视频的质量要求，取值:l、m、h , 其中 l 为最差画质，m 为中度画质，h 为略高画质*/ 
	quality?:string,

}

interface imageRotation {
	/**
	 * `获取图片宽高`
	 * ========params==========
	 *
	 * `path` :string : 本地图片路径，支持fs://、widget
	 */
	getImageWidthAndHeight(params:imageRotation_getImageWidthAndHeight_Params, callback?: (ret:JSON) => void):void

	/**
	 * `iOS设备拍摄的照片在 Android 或 Windows 等其它设备上查看，往往方向不对。可通过本接口纠正后再传到其它设备查看。`
	 * ========params==========
	 *
	 * `path` :string : 要处理的图片，要求本地路径（fs://、widget://）
	 */
	fixOrientation(params:imageRotation_fixOrientation_Params, callback?: (ret:JSON) => void):void

	/**
	 * `安装指定方向旋转/镜像图片`
	 * ========params==========
	 *
	 * `path` :string : 要旋转的图片，要求本地路径（fs://、widget://）
	 *
	 * `orientation` :string : （可选项）旋转方向
	 */
	rotateImage(params:imageRotation_rotateImage_Params, callback?: (ret:JSON) => void):void

	/**
	 * `按照指定角度旋转图片`
	 * ========params==========
	 *
	 * `path` :string : 要旋转的图片，要求本地路径（fs://、widget://）
	 *
	 * `degree` :number : （可选项）顺时针旋转的角度，[-360,360]
	 */
	rotatedImageByDegree(params:imageRotation_rotatedImageByDegree_Params, callback?: (ret:JSON) => void):void

}
interface imageRotation_getImageWidthAndHeight_Params {
	/**本地图片路径，支持fs://、widget*/ 
	path:string,

}

interface imageRotation_fixOrientation_Params {
	/**要处理的图片，要求本地路径（fs://、widget://）*/ 
	path:string,

}

interface imageRotation_rotateImage_Params {
	/**要旋转的图片，要求本地路径（fs://、widget://）*/ 
	path:string,

	/**（可选项）旋转方向*/ 
	orientation?:string,

}

interface imageRotation_rotatedImageByDegree_Params {
	/**要旋转的图片，要求本地路径（fs://、widget://）*/ 
	path:string,

	/**（可选项）顺时针旋转的角度，[-360,360]*/ 
	degree?:number,

}

interface weChatVideo {
	/** 打开视频录制界面*/ 
	open():void

	/** 清除视频的缓存*/ 
	clearCache():void

}
interface selectPic {
	/**
	 * `showPics使用此方法调用相机或相册的选择`
	 * ========params==========
	 *
	 * `maxNum` :number : （必填项） 设置个数需要大于0
	 */
	showPics(params:selectPic_showPics_Params, callback?: (ret:JSON) => void):void

}
interface selectPic_showPics_Params {
	/**（必填项） 设置个数需要大于0*/ 
	maxNum:number,

}

interface videoPlayer {
	/**
	 * `打开一个自带界面的视频播放器，本播放器为全屏横屏显示，支持屏幕随设备自动旋转。用户单击播放器时，会弹出 foot 和 head 导航条，再次单击则关闭之。**仅 setPath 接口对本接口打开的播放器有效**`
	 * ========params==========
	 *
	 * `texts` :JSON : （可选项）聊天输入框模块可配置的文本
	 *
	 * `styles` :JSON : （可选项）模块的样式设置
	 *
	 * `lockBtn` :JSON : 锁屏按钮配置
	 *
	 * `path` :string : （可选项）文档的路径，支持网络和本地（fs://）路径，**在 android 平台上不支持 widget**
	 *
	 * `autoPlay` :boolean : （可选项）打开时是否自动播放
	 *
	 * `coverImg` :string : （可选项）封面图路径，播放器打开尚未播放时的封面图，要求本地路径（widget://、fs://）
	 *
	 * `autorotation` :boolean : （可选项）视频播放页面是否支持自动旋转（横竖屏），若为 false 则手动点击右下角按钮旋转
	 *
	 * `audio` :string : （可选项）缩放模式 **该参数仅支持iOS**
	 *
	 * `seekBarDragable` :boolean : （可选项） 播放进度条是否可以拖动
	 *
	 * `hideStatusBar` :boolean : （可选项） 是否隐藏状态栏（该参数仅支持android）
	 *
	 * `isFull` :boolean : （可选项）是否全屏
	 */
	play(params:videoPlayer_play_Params, callback?: (ret:JSON) => void):void

	/**
	 * `打开一个视频播放器（类似一个frame）`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `bg` :string : （可选项）字符串类型；视频背景颜色，支持#、rgb、rgba (在切换视屏为了防止闪屏,请根据自己的视频调节颜色)
	 *
	 * `path` :string : （可选项）文档的路径，支持网络和本地（fs://）路径，**在 android 平台上不支持 widget**
	 *
	 * `autoPlay` :boolean : （可选项）打开时是否自动播放
	 *
	 * `scalingMode` :string : （可选项）缩放模式 **该参数仅支持ios**
	 *
	 * `coverImg` :boolean : （可选项）封面图路径，播放器打开尚未播放时的封面图，要求本地路径（widget://、fs://）
	 *
	 * `loop` :boolean : （可选项）是否循环播放  **该参数仅支持ios**
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	open(params:videoPlayer_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `设置音/视频的文件路径，**对 open 和 play 打开的视频播放器有效。**`
	 * ========params==========
	 *
	 * `path` :string : 文档的路径，支持网络和本地（fs://）路径，**在 android 平台上不支持 widget**
	 *
	 * `bg` :string : （可选项）字符串类型；视频背景颜色，支持#、rgb、rgba (在切换视屏为了防止闪屏,请根据自己的视频调节颜色)
	 *
	 * `coverImg` :boolean : （可选项）封面图路径，播放器打开尚未播放时的封面图，要求本地路径（widget://、fs://）
	 *
	 * `title` :string : （可选项）当设置 play 接口打开的视频时，本参数表示设置该视频的标题，本参数仅对 play 接口有效
	 */
	setPath(params:videoPlayer_setPath_Params, callback?: (ret:JSON) => void):void

	/** 开始播放，**只对 open 和 openPlay 接口打开的视频播放器有效***/ 
	start():void

	/** 暂停播放，**只对 open 和 openPlay 接口打开的视频播放器有效***/ 
	pause():void

	/** 停止播放，**仅对 open 打开的视频播放器有效***/ 
	stop():void

	/** 关闭播放器 ，**对 open、openPlay、play 打开的视频播放器均有效***/ 
	close():void

	/** 显示视频播放视图，**仅对 open 和 openPlay 打开的视频播放器有效***/ 
	show():void

	/** 隐藏视频播放视图，**仅对 open 和 openPlay 打开的视频播放器有效***/ 
	hide():void

	/** 全屏播放（横屏模式），**仅对open打开的播放器有效***/ 
	fullScreen():void

	/** 取消全屏播放，**仅对open打开的播放器有效***/ 
	cancelFullScreen():void

	/**
	 * `快进，**仅对open打开的播放器有效**`
	 * ========params==========
	 *
	 * `seconds` :number : 快进的秒数
	 */
	forward(params:videoPlayer_forward_Params):void

	/**
	 * `快退，**仅对open打开的播放器有效**`
	 * ========params==========
	 *
	 * `seconds` :number : 快退的秒数
	 */
	rewind(params:videoPlayer_rewind_Params):void

	/**
	 * `跳转，**仅对open打开的播放器有效**`
	 * ========params==========
	 *
	 * `seconds` :number : 跳转到音视频播放的秒数
	 */
	seekTo(params:videoPlayer_seekTo_Params):void

	/**
	 * `设置屏幕亮度，**对open、openPlay、play打开的播放器有效**`
	 * ========params==========
	 *
	 * `brightness` :number : （可选项）设置的屏幕的亮度，取值范围：0-100，**在 iOS 平台上设置的是系统屏幕亮度。Android 平台上设置的本应用内的屏幕亮度**
	 */
	setBrightness(params:videoPlayer_setBrightness_Params):void

	/** 获取当前屏幕亮度值，**对open、openPlay、play打开的播放器有效***/ 
	getBrightness(callback?: (ret:JSON) => void):void

	/**
	 * `设置音量，**对open、openPlay、play打开的播放器有效**`
	 * ========params==========
	 *
	 * `volume` :number : （可选项）音量大小，取值范围：0-1
	 */
	setVolume(params:videoPlayer_setVolume_Params):void

	/** 获取当前播放音量，**对open、openPlay、play打开的播放器有效***/ 
	getVolume(callback?: (ret:JSON) => void):void

	/** 添加动作监听(当全屏或者fixed为true且页面不能被左右滑动时有效)，**对open打开的播放器有效***/ 
	addEventListener(callback?: (ret:JSON) => void):void

	/**
	 * `移除动作监听，**对open打开的播放器有效**`
	 * ========params==========
	 *
	 * `name` :string : （可选项）所要移除的监听的动作名称
	 */
	removeEventListener(params:videoPlayer_removeEventListener_Params):void

	/**
	 * `设置视频播放器位置、尺寸，以及是否全屏，**对open打开的播放器有效**`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `fullscreen` :boolean : （可选项）模块的位置及尺寸是否全屏（true不显示状态栏，false显示状态栏）
	 */
	setRect(params:videoPlayer_setRect_Params):void

	/** 该方法需要在监听到物理按键时调用（只对 openPlay 接口打开的播放器有效，暂仅支持 android）*/ 
	onBack():void

	/** 判断当前窗口是否全屏（只对 openPlay 接口打开的播放器有效）*/ 
	isFullscreen():void

	/** 该方法需要在 pause 事件中调用（只对 openPlay 接口打开的播放器有效，仅支持android）*/ 
	onPause():void

	/** 该方法需要在resume事件中调用（只对 openPlay 接口打开的播放器有效，仅支持android）*/ 
	onResume():void

	/** 判断自定义按钮是否被选中 **注意:只对openPlay接口打开的播放器有效***/ 
	customBtnIsSelected(callback?: (ret:JSON) => void):void

	/**
	 * `设置自定义按钮被选中 **注意:只对openPlay接口打开的播放器有效**`
	 * ========params==========
	 *
	 * `index` :number : （可选项）用户自定义按钮的点击index，从右到左排列
	 */
	setCustomBtnSelected(params:videoPlayer_setCustomBtnSelected_Params):void

	/**
	 * `设置自定义按钮被取消 **只对openPlay接口打开的播放器有效**`
	 * ========params==========
	 *
	 * `index` :number : （可选项）用户自定义按钮的点击index，从右到左排列
	 */
	setCustomBtnCancelSelected(params:videoPlayer_setCustomBtnCancelSelected_Params):void

	/**
	 * `设置自定义按钮是否隐藏 **只对 openPlay 接口打开的播放器有效**`
	 * ========params==========
	 *
	 * `index` :number : （可选项）用户自定义按钮的点击index，从右到左排列
	 *
	 * `visible` :boolean : 是否显示
	 */
	setCustomBtnVisible(params:videoPlayer_setCustomBtnVisible_Params):void

	/**
	 * `获取指定视频的制定时刻的截图`
	 * ========params==========
	 *
	 * `videoUrl` :string : 视频地址，支持本地(widget://和fs:// android仅支持fs://)和网络视频
	 *
	 * `time` :number : 指定位置(单位为秒)
	 *
	 * `isAblum` :boolean : （可选项）是否保存相册
	 *
	 * `name` :boolean : （必选项）图片名
	 *
	 * `ret` :JSON : null
	 */
	videoCapture(params:videoPlayer_videoCapture_Params):void

}
interface videoPlayer_play_Params {
	/**（可选项）聊天输入框模块可配置的文本*/ 
	texts?:JSON,

	/**（可选项）模块的样式设置*/ 
	styles?:JSON,

	/**锁屏按钮配置*/ 
	lockBtn:JSON,

	/**（可选项）文档的路径，支持网络和本地（fs://）路径，**在 android 平台上不支持 widget***/ 
	path?:string,

	/**（可选项）打开时是否自动播放*/ 
	autoPlay?:boolean,

	/**（可选项）封面图路径，播放器打开尚未播放时的封面图，要求本地路径（widget://、fs://）*/ 
	coverImg?:string,

	/**（可选项）视频播放页面是否支持自动旋转（横竖屏），若为 false 则手动点击右下角按钮旋转*/ 
	autorotation?:boolean,

	/**（可选项）缩放模式 **该参数仅支持iOS***/ 
	audio?:string,

	/**（可选项） 播放进度条是否可以拖动*/ 
	seekBarDragable?:boolean,

	/**（可选项） 是否隐藏状态栏（该参数仅支持android）*/ 
	hideStatusBar?:boolean,

	/**（可选项）是否全屏*/ 
	isFull?:boolean,

}

interface videoPlayer_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**（可选项）字符串类型；视频背景颜色，支持#、rgb、rgba (在切换视屏为了防止闪屏,请根据自己的视频调节颜色)*/ 
	bg?:string,

	/**（可选项）文档的路径，支持网络和本地（fs://）路径，**在 android 平台上不支持 widget***/ 
	path?:string,

	/**（可选项）打开时是否自动播放*/ 
	autoPlay?:boolean,

	/**（可选项）缩放模式 **该参数仅支持ios***/ 
	scalingMode?:string,

	/**（可选项）封面图路径，播放器打开尚未播放时的封面图，要求本地路径（widget://、fs://）*/ 
	coverImg?:boolean,

	/**（可选项）是否循环播放  **该参数仅支持ios***/ 
	loop?:boolean,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface videoPlayer_setPath_Params {
	/**文档的路径，支持网络和本地（fs://）路径，**在 android 平台上不支持 widget***/ 
	path:string,

	/**（可选项）字符串类型；视频背景颜色，支持#、rgb、rgba (在切换视屏为了防止闪屏,请根据自己的视频调节颜色)*/ 
	bg?:string,

	/**（可选项）封面图路径，播放器打开尚未播放时的封面图，要求本地路径（widget://、fs://）*/ 
	coverImg?:boolean,

	/**（可选项）当设置 play 接口打开的视频时，本参数表示设置该视频的标题，本参数仅对 play 接口有效*/ 
	title?:string,

}

interface videoPlayer_forward_Params {
	/**快进的秒数*/ 
	seconds:number,

}

interface videoPlayer_rewind_Params {
	/**快退的秒数*/ 
	seconds:number,

}

interface videoPlayer_seekTo_Params {
	/**跳转到音视频播放的秒数*/ 
	seconds:number,

}

interface videoPlayer_setBrightness_Params {
	/**（可选项）设置的屏幕的亮度，取值范围：0-100，**在 iOS 平台上设置的是系统屏幕亮度。Android 平台上设置的本应用内的屏幕亮度***/ 
	brightness?:number,

}

interface videoPlayer_setVolume_Params {
	/**（可选项）音量大小，取值范围：0-1*/ 
	volume?:number,

}

interface videoPlayer_removeEventListener_Params {
	/**（可选项）所要移除的监听的动作名称*/ 
	name?:string,

}

interface videoPlayer_setRect_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**（可选项）模块的位置及尺寸是否全屏（true不显示状态栏，false显示状态栏）*/ 
	fullscreen?:boolean,

}

interface videoPlayer_setCustomBtnSelected_Params {
	/**（可选项）用户自定义按钮的点击index，从右到左排列*/ 
	index?:number,

}

interface videoPlayer_setCustomBtnCancelSelected_Params {
	/**（可选项）用户自定义按钮的点击index，从右到左排列*/ 
	index?:number,

}

interface videoPlayer_setCustomBtnVisible_Params {
	/**（可选项）用户自定义按钮的点击index，从右到左排列*/ 
	index?:number,

	/**是否显示*/ 
	visible:boolean,

}

interface videoPlayer_videoCapture_Params {
	/**视频地址，支持本地(widget://和fs:// android仅支持fs://)和网络视频*/ 
	videoUrl:string,

	/**指定位置(单位为秒)*/ 
	time:number,

	/**（可选项）是否保存相册*/ 
	isAblum?:boolean,

	/**（必选项）图片名*/ 
	name:boolean,

	/**null*/ 
	ret:JSON,

}

interface jsskeNFC {
	/** 判断nfc是否开启*/ 
	isOpen(callback?: (ret:JSON, err:JSON) => void):void

	/** 初始化nfc工具*/ 
	init(callback?: (ret:JSON, err:JSON) => void):void

	/** 读取一次身份证信息*/ 
	findIDCard(callback?: (ret:JSON, err:JSON) => void):void

	/** 打开设备nfc设置页面*/ 
	toNfcSetting(callback?: (ret:JSON, err:JSON) => void):void

	/** 停止识别*/ 
	endFind(callback?: (ret:JSON, err:JSON) => void):void

}
interface timer {
	/**
	 * `开启计时器。开启计时器后，如果开启循坏(isLoop设为true)，模块会在delay毫秒后回调callback，以后会间隔period毫秒回调callback，如果关闭循坏(isLoop设为false)，模块只会在delay毫秒后回调callback一次，之后不再会回调。开发者可将要定时执行的js代码放到callback函数中执行。`
	 * ========params==========
	 *
	 * `delay` :any : 延时执行回调的时间，单位毫秒.
	 *
	 * `isLoop` :boolean : 是否循环执行回调.开启计时器后，如果开启循坏(isLoop设为true)，模块会在delay毫秒后回调callback，以后会间隔period毫秒回调callback，如果关闭循坏(isLoop设为false)，模块只会在delay毫秒后回调callback一次，之后不再会回调。开发者可将要定时执行的js代码放到callback函数中执行。
	 *
	 * `period` :any : 间隔执行回调的时间，单位毫秒。只有在isLoop为true时有效.
	 */
	startTimer(params:timer_startTimer_Params, callback?: (ret:JSON) => void):void

	/** 停止计时器，startTimer和stopTimer应一 一对应，调用startTimer后应在适当地方调用stopTimer停止计时器。*/ 
	stopTimer():void

}
interface timer_startTimer_Params {
	/**延时执行回调的时间，单位毫秒.*/ 
	delay:any,

	/**是否循环执行回调.开启计时器后，如果开启循坏(isLoop设为true)，模块会在delay毫秒后回调callback，以后会间隔period毫秒回调callback，如果关闭循坏(isLoop设为false)，模块只会在delay毫秒后回调callback一次，之后不再会回调。开发者可将要定时执行的js代码放到callback函数中执行。*/ 
	isLoop:boolean,

	/**间隔执行回调的时间，单位毫秒。只有在isLoop为true时有效.*/ 
	period:any,

}

interface cnKeyBoard {
	/** 在页面上添加车牌专用输入框，弹出专用键盘。*/ 
	openKeyboard(callback?: (ret:JSON, err:JSON) => void):void

}
interface appManagerPlus {
	/** 获取Android手机上所有应用的信息，包括应用图标、名字、包名、版本号等。获取到的应用图标保存在本地，可通过fs路径或Android原生路径获取图标。img标签用Android原生路径显示图片的方法：img标签的src属性设置为： "file://"+ Android原生路径。见示例代码。该接口为耗时接口，开发者调用该接口后可做等待提示，增加用户体验。*/ 
	getInstalledApplications(callback?: (ret:JSON) => void):void

	/** 打开系统安装应用(apk)界面*/ 
	installApp(callback?: (ret:JSON) => void):void

	/** 静默安装应用，手机需要Root且调用该方法后应用请求获取root权限(弹框方式弹出)，用户同意获取root权限后方可进行静默安装。*/ 
	installSilent(callback?: (ret:JSON) => void):void

	/** 打开系统卸载应用界面*/ 
	unInstallApp(callback?: (ret:JSON) => void):void

	/** 静默卸载应用，手机需要Root且调用该方法后应用请求获取root权限(弹框方式弹出)，用户同意获取root权限后方可进行静默卸载。*/ 
	unInstallSilent(callback?: (ret:JSON) => void):void

	/** 判断应用是否已经安装到手机上，可根据包名或或者应用名称判断，但应用名判断可能不准确，因为Android上允许有多个同名的应用(但他们的包名不会相同)，而包名是应用在手机上的唯一标识，所以用包名判断绝对准确，建议用包名。该方法为耗时方法。*/ 
	isInstalled(callback?: (ret:JSON) => void):void

	/** 判断应用是否是系统应用。*/ 
	isSystemApp(callback?: (ret:JSON) => void):void

	/** 获取应用的缓存大小、数据大小、应用本身大小。类似在手机设置中的应用管理中的“应用详情”页中的信息。该方法为耗时方法。*/ 
	getAppSize(callback?: (ret:JSON) => void):void

	/** 打开指定应用的默认页面，类似用户从桌面直接点击应用图标打开应用。调用该方法前需判断传入的应用是否已经安装(调用isInstalled方法)*/ 
	jumpToApp(callback?: (ret:JSON) => void):void

	/** 监听Android上应用的安装卸载，包括其他应用的安装、卸载、升级，本接口不能监听自身的安装、卸载和升级。如要监听自身的升级可参考本模块的isVersionChanged接口。本接口监听后立即返回，当有其他应用安装、卸载、升级时再次触发回调。开发者可在应用安装后启动应用，或者进行其他操作。注意：本应用(调用该接口的应用)还在运行时才能监听到应用的安装卸载，如果本应用被系统杀掉或刚开机未启动，则不能监听到应用的安装卸载*/ 
	registerAppReceiver():void

	/** 用于判断是否已经升级到新版本，本接口根据Android应用的版本号(versionCode)是否增大来判断，对应于云编译上编译正式版本的Android version code 。所以热更新如果没有改变版本号，该接口会返回false状态。注意：该接口要在新版本(已经升级的版本)中调用才有效，且要求旧版本也调用过该接口，开发者可在应用启动时调用该接口判断是否版本已经升级，如果是 可以给用户弹出“升级成功”的提示，增加用户体验。*/ 
	isVersionChanged():void

}
interface imageXWebImage {
	/** 异步打开图片。使用前必须在`config.xml`中配置appID。appID的获取方法见[字节企业服务平台](https://www.byteoc.com/docs/508/68469/)*/ 
	openPicture():void

	/** 同步打开图片。使用前必须在`config.xml`中配置appID。配置方法见文档描述。*/ 
	openPictureSync():void

	/**
	 * `判断一张图片是否打开`
	 * ========params==========
	 *
	 * `pictureID` :string : 打开图片时获得的图片句柄
	 */
	isOpen(params:imageXWebImage_isOpen_Params, callback?: (ret:JSON) => void):void

	/**
	 * `打开图片的同步方法`
	 * ========params==========
	 *
	 * `pictureID` :string : 打开图片时获得的图片句柄
	 */
	isOpenSync(params:imageXWebImage_isOpenSync_Params):void

	/**
	 * `关闭图片`
	 * ========params==========
	 *
	 * `pictureID` :string : 打开图片时获得的图片句柄
	 */
	closePicture(params:imageXWebImage_closePicture_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `关闭图片的同步方法`
	 * ========params==========
	 *
	 * `pictureID` :JSON : 打开图片时获得的图片句柄
	 */
	closePictureSync(params:imageXWebImage_closePictureSync_Params):void

	/** 关闭所有已打开的图片*/ 
	closeAllPictures():void

	/** 关闭所有已打开的图片的同步方法*/ 
	closeAllPicturesSync():void

	/** 获取已打开图片的数量的同步方法*/ 
	numOfOpenedPictureSync():void

}
interface imageXWebImage_isOpen_Params {
	/**打开图片时获得的图片句柄*/ 
	pictureID:string,

}

interface imageXWebImage_isOpenSync_Params {
	/**打开图片时获得的图片句柄*/ 
	pictureID:string,

}

interface imageXWebImage_closePicture_Params {
	/**打开图片时获得的图片句柄*/ 
	pictureID:string,

}

interface imageXWebImage_closePictureSync_Params {
	/**打开图片时获得的图片句柄*/ 
	pictureID:JSON,

}

interface chromellqDebug {
}
interface recordVideo {
}
interface mediaCollector {
	/**
	 * `打开相机`
	 * ========params==========
	 *
	 * `imagePath` :string : 图片保存路径，要求本地路径（fs://），暂仅支持iOS端
	 *
	 * `watermark` :JSON : （可选项）图片水印字符串，不传则不显示水印
	 *
	 * `videoPath` :string : 图片保存路径，要求本地路径（fs://），暂仅支持iOS端
	 *
	 * `recordSecond` :number : （可选项）拍摄视频时的视频时长
	 *
	 * `shootMode` :number : （可选项）拍摄模式
	 *
	 * `isEditImage` :boolean : （可选项）拍照完成后是否显示画笔按钮
	 */
	openCamera(params:mediaCollector_openCamera_Params, callback?: (ret:JSON) => void):void

	/** 打开预览页面*/ 
	openPreview():void

	/**
	 * `编辑图片`
	 * ========params==========
	 *
	 * `image` :string : 要编辑的图片的路径，要求本地路径（fs:// box://）
	 *
	 * `imagePath` :string : 图片保存路径，要求本地路径（fs:// box://）
	 *
	 * `watermark` :JSON : （可选项）图片水印字符串，不传则不显示水印
	 */
	imageEdit(params:mediaCollector_imageEdit_Params, callback?: (ret:JSON) => void):void

}
interface mediaCollector_openCamera_Params {
	/**图片保存路径，要求本地路径（fs://），暂仅支持iOS端*/ 
	imagePath:string,

	/**（可选项）图片水印字符串，不传则不显示水印*/ 
	watermark?:JSON,

	/**图片保存路径，要求本地路径（fs://），暂仅支持iOS端*/ 
	videoPath:string,

	/**（可选项）拍摄视频时的视频时长*/ 
	recordSecond?:number,

	/**（可选项）拍摄模式*/ 
	shootMode?:number,

	/**（可选项）拍照完成后是否显示画笔按钮*/ 
	isEditImage?:boolean,

}

interface mediaCollector_imageEdit_Params {
	/**要编辑的图片的路径，要求本地路径（fs:// box://）*/ 
	image:string,

	/**图片保存路径，要求本地路径（fs:// box://）*/ 
	imagePath:string,

	/**（可选项）图片水印字符串，不传则不显示水印*/ 
	watermark?:JSON,

}

interface musicPlayer {
	/** 播放器状态监听*/ 
	addEventListener():void

	/**
	 * `开启音乐播放服务`
	 * ========params==========
	 *
	 * `musics` :Array : （必填项）模块的位置及尺寸
	 *
	 * `notifyStyle` :JSON : （必填项）Android通知栏UI样式设置
	 *
	 * `currentIndex` :number : （必填项）指定从数组序号开始播放
	 */
	startService(params:musicPlayer_startService_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 停止音乐播放服务*/ 
	stopService():void

	/**
	 * `添加音乐数据`
	 * ========params==========
	 *
	 * `data` :Array : （必填项）待播放音乐信息
	 */
	addMusicData(params:musicPlayer_addMusicData_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `指定播放音乐`
	 * ========params==========
	 *
	 * `index` :number : （可选项）需要播放的id（二选一）
	 *
	 * `other` :string : （可选项）自定义的id（二选一）
	 */
	selectMusicItem(params:musicPlayer_selectMusicItem_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 获取正在播放的音频信息*/ 
	getCurrentMusic():void

	/** 获取视频总进度*/ 
	getDuration():void

	/** 获取已经播放进度*/ 
	getCurrentPosition():void

	/** 是否正在播放音频*/ 
	isPlaying():void

	/** 切换播放模式*/ 
	playerMode():void

	/** 播放上一条*/ 
	playerPre():void

	/** 暂停后播放*/ 
	playerPlay():void

	/** 暂停播放*/ 
	playerPause():void

	/** 播放下一条*/ 
	playerNext():void

	/** 随机播放*/ 
	playerRandom():void

	/**
	 * `设置播放进度`
	 * ========params==========
	 *
	 * `seek` :JSON : （必填项）设置音乐播放进度
	 */
	playerSeek(params:musicPlayer_playerSeek_Params):void

	/**
	 * `设置倍速`
	 * ========params==========
	 *
	 * `speed` :JSON : （必填项）设置倍速值(0.5-2.0)
	 */
	playerSpeed(params:musicPlayer_playerSpeed_Params):void

	/**
	 * `打开全屏音乐播放界面(悬浮App最上层)`
	 * ========params==========
	 *
	 * `isShowMode` :boolean : （可选项）是否显示模式切换按钮
	 *
	 * `isShowDownload` :boolean : （可选项）是否显示下载按钮
	 *
	 * `isShowFenxiang` :boolean : （可选项）是否显示分享按钮
	 *
	 * `isShowPinglun` :boolean : （可选项）是否显示评论按钮
	 *
	 * `isShowSetting` :boolean : （可选项）是否显示设置按钮
	 *
	 * `isShowDanmu` :boolean : （可选项）是否显示弹幕按钮
	 *
	 * `nameTextSize` :number : （可选项）name文字大小
	 *
	 * `nameTextColor` :number : （可选项）name文字颜色
	 *
	 * `singerTextSize` :number : （可选项）singer文字大小
	 *
	 * `singerTextColor` :number : （可选项）singer文字颜色
	 *
	 * `backgroundColor` :number : （可选项）背景颜色
	 */
	openMaxView(params:musicPlayer_openMaxView_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 隐藏全屏音乐播放界面*/ 
	hideMaxView(callback?: (ret:JSON, err:JSON) => void):void

	/** 显示全屏音乐播放界面*/ 
	showMaxView(callback?: (ret:JSON, err:JSON) => void):void

	/** 关闭全屏音乐播放界面*/ 
	closeMaxView(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `发送一条弹幕信息`
	 * ========params==========
	 *
	 * `text` :string : （必填项）弹幕文字内容
	 *
	 * `color` :string : （可选项）弹幕文字显示颜色代码
	 */
	sendDanmu(params:musicPlayer_sendDanmu_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `发送多条弹幕信息。`
	 * ========params==========
	 *
	 * `isLoop` :boolean : （可选项）天际的全部数据是否循环播放(循环:true，不循环:false)
	 *
	 * `data` :Array : （必填项）多条弹幕信息记录。
	 */
	sendDanmuList(params:musicPlayer_sendDanmuList_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `打开Min音乐播放界面(悬浮App最上层)`
	 * ========params==========
	 *
	 * `rect` :JSON : （必填项）悬浮窗口UI播放的位置及尺寸
	 *
	 * `isMaxFont` :boolean : （可选项）是否悬浮显示到最上层
	 *
	 * `fixedOn` :string : （可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window(isMaxFont为false有效)
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 Window 或 Frame 滚动(isMaxFont为false有效)
	 *
	 * `isShowText` :boolean : （可选项）是否name和singer信息
	 *
	 * `nameTextSize` :number : （可选项）name文字大小
	 *
	 * `nameTextColor` :number : （可选项）name文字颜色
	 *
	 * `singerTextSize` :number : （可选项）singer文字大小
	 *
	 * `singerTextColor` :number : （可选项）singer文字颜色
	 *
	 * `backgroundColor` :number : （可选项）背景颜色
	 */
	openMinView(params:musicPlayer_openMinView_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 隐藏Min音乐播放界面*/ 
	hideMinView(callback?: (ret:JSON, err:JSON) => void):void

	/** 显示Min音乐播放界面*/ 
	showMinView(callback?: (ret:JSON, err:JSON) => void):void

	/** 关闭Min音乐播放界面*/ 
	closeMinView(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `打开底部按钮(不是App最上层)`
	 * ========params==========
	 *
	 * `rect` :JSON : （必填项）位置及尺寸
	 *
	 * `fixedOn` :string : （可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window
	 *
	 * `fixed` :boolean : （（可选项）模块是否随所属 Window 或 Frame 滚动
	 *
	 * `backgroundColor` :number : （可选项）背景色
	 */
	openFootButton(params:musicPlayer_openFootButton_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 隐藏底部按钮*/ 
	hideFootButton(callback?: (ret:JSON, err:JSON) => void):void

	/** 显示底部按钮*/ 
	showFootButton(callback?: (ret:JSON, err:JSON) => void):void

	/** 关闭底部按钮*/ 
	closeFootButton(callback?: (ret:JSON, err:JSON) => void):void

}
interface musicPlayer_startService_Params {
	/**（必填项）模块的位置及尺寸*/ 
	musics:Array,

	/**（必填项）Android通知栏UI样式设置*/ 
	notifyStyle:JSON,

	/**（必填项）指定从数组序号开始播放*/ 
	currentIndex:number,

}

interface musicPlayer_addMusicData_Params {
	/**（必填项）待播放音乐信息*/ 
	data:Array,

}

interface musicPlayer_selectMusicItem_Params {
	/**（可选项）需要播放的id（二选一）*/ 
	index?:number,

	/**（可选项）自定义的id（二选一）*/ 
	other?:string,

}

interface musicPlayer_playerSeek_Params {
	/**（必填项）设置音乐播放进度*/ 
	seek:JSON,

}

interface musicPlayer_playerSpeed_Params {
	/**（必填项）设置倍速值(0.5-2.0)*/ 
	speed:JSON,

}

interface musicPlayer_openMaxView_Params {
	/**（可选项）是否显示模式切换按钮*/ 
	isShowMode?:boolean,

	/**（可选项）是否显示下载按钮*/ 
	isShowDownload?:boolean,

	/**（可选项）是否显示分享按钮*/ 
	isShowFenxiang?:boolean,

	/**（可选项）是否显示评论按钮*/ 
	isShowPinglun?:boolean,

	/**（可选项）是否显示设置按钮*/ 
	isShowSetting?:boolean,

	/**（可选项）是否显示弹幕按钮*/ 
	isShowDanmu?:boolean,

	/**（可选项）name文字大小*/ 
	nameTextSize?:number,

	/**（可选项）name文字颜色*/ 
	nameTextColor?:number,

	/**（可选项）singer文字大小*/ 
	singerTextSize?:number,

	/**（可选项）singer文字颜色*/ 
	singerTextColor?:number,

	/**（可选项）背景颜色*/ 
	backgroundColor?:number,

}

interface musicPlayer_sendDanmu_Params {
	/**（必填项）弹幕文字内容*/ 
	text:string,

	/**（可选项）弹幕文字显示颜色代码*/ 
	color?:string,

}

interface musicPlayer_sendDanmuList_Params {
	/**（可选项）天际的全部数据是否循环播放(循环:true，不循环:false)*/ 
	isLoop?:boolean,

	/**（必填项）多条弹幕信息记录。*/ 
	data:Array,

}

interface musicPlayer_openMinView_Params {
	/**（必填项）悬浮窗口UI播放的位置及尺寸*/ 
	rect:JSON,

	/**（可选项）是否悬浮显示到最上层*/ 
	isMaxFont?:boolean,

	/**（可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window(isMaxFont为false有效)*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 Window 或 Frame 滚动(isMaxFont为false有效)*/ 
	fixed?:boolean,

	/**（可选项）是否name和singer信息*/ 
	isShowText?:boolean,

	/**（可选项）name文字大小*/ 
	nameTextSize?:number,

	/**（可选项）name文字颜色*/ 
	nameTextColor?:number,

	/**（可选项）singer文字大小*/ 
	singerTextSize?:number,

	/**（可选项）singer文字颜色*/ 
	singerTextColor?:number,

	/**（可选项）背景颜色*/ 
	backgroundColor?:number,

}

interface musicPlayer_openFootButton_Params {
	/**（必填项）位置及尺寸*/ 
	rect:JSON,

	/**（可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window*/ 
	fixedOn?:string,

	/**（（可选项）模块是否随所属 Window 或 Frame 滚动*/ 
	fixed?:boolean,

	/**（可选项）背景色*/ 
	backgroundColor?:number,

}

interface rUHF {
	/**
	 * `开始识别标签`
	 * ========params==========
	 *
	 * `action` :any : （可选项）0单步识别；1单标签循环识别
	 */
	readUHF(params:rUHF_readUHF_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 停止识别标签*/ 
	stopUHF(callback?: (ret:JSON, err:JSON) => void):void

	/** 销毁UHF*/ 
	destroyUHF(callback?: (ret:JSON, err:JSON) => void):void

}
interface rUHF_readUHF_Params {
	/**（可选项）0单步识别；1单标签循环识别*/ 
	action?:any,

}

interface ytylive {
	/** 开始视频推流，video_url为推地址url，video_name为推流实例名称，如果使用第三方推流服务，则推流地址跟推流实例名称需要到第三方平台获取，如果自建直播服务器，则使用自建服务器的推流地址跟实例名称。*/ 
	startVideo(callback?: (ret:JSON) => void):void

}
interface acVRPlayer {
	/**
	 * `打开播放器界面`
	 * ========params==========
	 *
	 * `rect` :JSON : (可选项）播放器的位置及长宽
	 *
	 * `path` :string : 播放视频路径
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（ios：只指 frame，传 window 无效）(android可以是frame或者Window，但是在全屏的时候，需要挂在Window上或者frame是全屏)
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	open(params:acVRPlayer_open_Params):void

	/** 开始播放*/ 
	play():void

	/** 暂停播放*/ 
	pause():void

	/** 关闭播放器*/ 
	close():void

	/** 显示视频播放视图*/ 
	show():void

	/** 隐藏视频播放视图*/ 
	hide():void

	/**
	 * `进度跳转（仅iOS支持）`
	 * ========params==========
	 *
	 * `progress` :number : 要跳转的时间（秒）
	 */
	seekToProgress(params:acVRPlayer_seekToProgress_Params):void

	/** 添加监听*/ 
	addPlayerListener():void

}
interface acVRPlayer_open_Params {
	/**(可选项）播放器的位置及长宽*/ 
	rect?:JSON,

	/**播放视频路径*/ 
	path:string,

	/**（可选项）模块视图添加到指定 frame 的名字（ios：只指 frame，传 window 无效）(android可以是frame或者Window，但是在全屏的时候，需要挂在Window上或者frame是全屏)*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface acVRPlayer_seekToProgress_Params {
	/**要跳转的时间（秒）*/ 
	progress:number,

}

interface imageBrowser {
}
interface realNetwork {
}
interface pdfReader {
	/**
	 * `打开一个 pdf 格式的文档`
	 * ========params==========
	 *
	 * `path` :string : 文档的路径，支持 widget://、fs://、http:// 等本地和网络协议
	 *
	 * `hidden` :JSON : 界面元素的隐藏显示属性配置，仅支持 iOS 平台
	 *
	 * `androidHidden` :JSON : （可选项）界面元素的隐藏显示属性配置，仅支持 Android 平台
	 *
	 * `backBtn` :JSON : （可选项）返回按钮配置，若不传，则显示默认按钮
	 *
	 * `showLoading` :boolean : （可选项）未成功打开文件之前是否显示加载提示框
	 *
	 * `index` :number : （可选项）打开指定页的页码，从1开始
	 */
	open(params:pdfReader_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `打开pdf文档视图`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `path` :string : 文档的路径，支持 widget://、fs://、http:// 等本地和网络协议
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 *
	 * `showLoading` :boolean : （可选项）未成功打开文件之前是否显示加载提示框
	 *
	 * `index` :number : （可选项）打开指定页的页码，从1开始
	 */
	openView(params:pdfReader_openView_Params, callback?: (ret:JSON) => void):void

	/** 隐藏文档视图*/ 
	hideView():void

	/** 显示文档视图*/ 
	showView():void

	/** 关闭文档视图*/ 
	closeView():void

	/** 清除缓存到本地的文件，**本接口只清除本模块缓存的数据，若要清除本app缓存的所有数据这调用api.clearCache***/ 
	clearCache():void

	/**
	 * `打开pdf文档视图，调用此接口为长图显示`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `path` :string : 文档的路径，支持 widget://、fs://、http:// 等本地和网络协议
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 *
	 * `showLoading` :boolean : （可选项）未成功打开文件之前是否显示加载提示框
	 */
	openPdfView(params:pdfReader_openPdfView_Params, callback?: (ret:JSON) => void):void

	/** 关闭长图pdf试图*/ 
	closePdfView():void

	/** 在指定中心点缩放*/ 
	zoomCenteredTo():void

}
interface pdfReader_open_Params {
	/**文档的路径，支持 widget://、fs://、http:// 等本地和网络协议*/ 
	path:string,

	/**界面元素的隐藏显示属性配置，仅支持 iOS 平台*/ 
	hidden:JSON,

	/**（可选项）界面元素的隐藏显示属性配置，仅支持 Android 平台*/ 
	androidHidden?:JSON,

	/**（可选项）返回按钮配置，若不传，则显示默认按钮*/ 
	backBtn?:JSON,

	/**（可选项）未成功打开文件之前是否显示加载提示框*/ 
	showLoading?:boolean,

	/**（可选项）打开指定页的页码，从1开始*/ 
	index?:number,

}

interface pdfReader_openView_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**文档的路径，支持 widget://、fs://、http:// 等本地和网络协议*/ 
	path:string,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

	/**（可选项）未成功打开文件之前是否显示加载提示框*/ 
	showLoading?:boolean,

	/**（可选项）打开指定页的页码，从1开始*/ 
	index?:number,

}

interface pdfReader_openPdfView_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**文档的路径，支持 widget://、fs://、http:// 等本地和网络协议*/ 
	path:string,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

	/**（可选项）未成功打开文件之前是否显示加载提示框*/ 
	showLoading?:boolean,

}

interface aemail {
	/** 类型：字符串*/ 
	sendEmail():void

}
interface videoPicture {
	/**
	 * `打开轮播播放器`
	 * ========params==========
	 *
	 * `rect` :JSON : （必填项）模块的位置及尺寸
	 *
	 * `fixedOn` :string : （可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window
	 *
	 * `fixed` :boolean : （（可选项）模块是否随所属 Window 或 Frame 滚动
	 *
	 * `data` :JSON : （必填项）带视频轮播显示列表。
	 */
	openCarousel(params:videoPicture_openCarousel_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 隐藏轮播播放器*/ 
	hideCarousel(callback?: (ret:JSON, err:JSON) => void):void

	/** 显示轮播播放器*/ 
	showCarousel():void

	/** 关闭轮播播放器*/ 
	closeCarousel(callback?: (ret:JSON, err:JSON) => void):void

}
interface videoPicture_openCarousel_Params {
	/**（必填项）模块的位置及尺寸*/ 
	rect:JSON,

	/**（可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window*/ 
	fixedOn?:string,

	/**（（可选项）模块是否随所属 Window 或 Frame 滚动*/ 
	fixed?:boolean,

	/**（必填项）带视频轮播显示列表。*/ 
	data:JSON,

}

interface customNotification {
	/** 发送一条通知*/ 
	sendNotification():void

	/** 更新通知*/ 
	updateNotification():void

}
interface brightnessUtil {
}
interface imageTools {
	/** 图片压缩，png图片会改变图片大小。Android端1.0.4版本压缩jpg采用鲁班压缩，压缩会改变原图的分辨率*/ 
	compression(callback?: (ret:JSON) => void):void

	/** 图片旋转*/ 
	orientation(callback?: (ret:JSON) => void):void

	/** 设置图片圆角*/ 
	cornerRadius(callback?: (ret:JSON) => void):void

	/** 改变图片大小*/ 
	changeSize(callback?: (ret:JSON) => void):void

	/** 图片压缩（不支持 gif 压缩）*/ 
	compressLocalImage(callback?: (ret:JSON) => void):void

}
interface imageFilter {
	/**
	 * `打开图片过滤器`
	 * ========params==========
	 *
	 * `imgPath` :string : 原图片路径，支持fs，widget等本地协议
	 */
	open(params:imageFilter_open_Params):void

	/**
	 * `设置图片滤镜效果`
	 * ========params==========
	 *
	 * `type` :string : （可选项）要设置的图片滤镜效果，详情参考[滤镜效果](!Constant)
	 *
	 * `value` :number : （可选项）要设置的图片滤镜效果程度，取值范围1-100
	 *
	 * `id` :number : 要操作的图片的id
	 */
	filter(params:imageFilter_filter_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `保存最终处理结果`
	 * ========params==========
	 *
	 * `album` :boolean : （可选项）是否保存到系统相册
	 *
	 * `imgPath` :string : （可选项）保存的图片路径，若路径不存在文件夹则创建此目录
	 *
	 * `imgName` :string : （可选项）保存的图片名字，支持png和jpg格式，若不指定格式，则默认png
	 *
	 * `id` :number : 要操作的图片的id
	 */
	save(params:imageFilter_save_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `图片压缩处理`
	 * ========params==========
	 *
	 * `img` :string : 要压缩图片的路径，支持widget、fs等本地路径
	 *
	 * `isClarityimg` :boolean : (可选项) 图片背景是否透明 仅支持iOS
	 *
	 * `quality` :number : （可选项）压缩程度，取值范围：0-1,当isClarityimg参数为false时有效
	 *
	 * `scale` :number : （可选项）压缩后的图片缩放比例，取值范围大于0，
	 *
	 * `size` :any : （可选项）压缩后的图片的大小
	 *
	 * `save` :any : （可选项）压缩后的图片保存位置
	 */
	compress(params:imageFilter_compress_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取指定路径下的图片信息`
	 * ========params==========
	 *
	 * `path` :string : 目标图片的路径，支持fs等本地路径
	 */
	getAttr(params:imageFilter_getAttr_Params, callback?: (ret:JSON) => void):void

}
interface imageFilter_open_Params {
	/**原图片路径，支持fs，widget等本地协议*/ 
	imgPath:string,

}

interface imageFilter_filter_Params {
	/**（可选项）要设置的图片滤镜效果，详情参考[滤镜效果](!Constant)*/ 
	type?:string,

	/**（可选项）要设置的图片滤镜效果程度，取值范围1-100*/ 
	value?:number,

	/**要操作的图片的id*/ 
	id:number,

}

interface imageFilter_save_Params {
	/**（可选项）是否保存到系统相册*/ 
	album?:boolean,

	/**（可选项）保存的图片路径，若路径不存在文件夹则创建此目录*/ 
	imgPath?:string,

	/**（可选项）保存的图片名字，支持png和jpg格式，若不指定格式，则默认png*/ 
	imgName?:string,

	/**要操作的图片的id*/ 
	id:number,

}

interface imageFilter_compress_Params {
	/**要压缩图片的路径，支持widget、fs等本地路径*/ 
	img:string,

	/**(可选项) 图片背景是否透明 仅支持iOS*/ 
	isClarityimg?:boolean,

	/**（可选项）压缩程度，取值范围：0-1,当isClarityimg参数为false时有效*/ 
	quality?:number,

	/**（可选项）压缩后的图片缩放比例，取值范围大于0，*/ 
	scale?:number,

	/**（可选项）压缩后的图片的大小*/ 
	size?:any,

	/**（可选项）压缩后的图片保存位置*/ 
	save?:any,

}

interface imageFilter_getAttr_Params {
	/**目标图片的路径，支持fs等本地路径*/ 
	path:string,

}

interface ttsModule {
}
interface mobilePhone {
}
interface photoBrowserTodayNew {
	/**
	 * `打开图片浏览器。`
	 * ========params==========
	 *
	 * `images` :Array<JSON> : （必填项）要显示的图片url数组,图片数量应大于等于1。支持 fs://、widget://、http://、https://格式
	 *
	 * `texts` :Array<JSON> : （可选项）要显示的图片描述字符串数组，images和texts一 一对应，即images中的第一个元素对应texts中的第一个元素，以此类推。字符串数量应等于图片数量，如大于图片数量，则模块从左往右选取数量等于图片数量的那些字符串，如小于图片数量，则剩下的描述字符串模块会自动用空字符串("")补全。参数visibility中的textArea为true时，该字段才有效。
	 *
	 * `frame` :string : 必填项，要将该模块添加到哪个frame显示，一般本模块需要全屏显示（除去手机状态栏，即除去手机顶部的状态栏，其他区域都用来显示本模块），所以frame的区域建议为除去手机顶部状态栏的其他区域。沉浸式模式下，建议将状态栏的背景色设置成黑色(#000000)，以便与本模块的背景色保持一致。
	 *
	 * `visibility` :JSON : （可选项）用于设置功能按钮是否显示，当input为2时，此时点击伪输入框弹出真正的评论输入框，要想图片不跟随键盘上移，则在config.xml中配置如下参数：<br/><preference name="softInputMode" value="pan"/>
	 *
	 * `textHeight` :JSON : （可选项）用于设置文字描述区域高度所占的百分比，公式如下：<br/>
	 *
	 * `start` :any : （可选项）用于设置从第几张图片开始显示，默认1，该值从1计数，而不是0。
	 *
	 * `count` :any : （可选项）用于设置评论按钮上的红色评论数量，默认0，>0时显示红色数量, <=0时不显示红色数量; 大于999时显示"999+"
	 *
	 * `status` :boolean : （可选项）用于设置是否收藏，默认false不收藏。
	 *
	 * `publisher` :string : （可选项）用于设置发布人头像，为空或不传时头像不显示，支持 fs://、widget://、http://、https://格式
	 *
	 * `virtualInputHint` :string : （可选项）用于设置伪输入框的提示文字，默认"写评论..."；参数visibility中的input为1或2时，该字段才有效。
	 *
	 * `realInputHint` :string : （可选项）用于设置可输入评论内容的输入框的提示文字，默认"优质评论将会被优先展示"；参数visibility中的input为2时，该字段才有效。
	 */
	open(params:photoBrowserTodayNew_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `设置评论数量。应在调用open方法后调用该方法`
	 * ========params==========
	 *
	 * `count` :any : （可选项）用于设置评论按钮上的红色评论数量，默认0，>0时显示红色数量, <=0时不显示红色数量; 大于999时显示"999+"
	 */
	setCommentCount(params:photoBrowserTodayNew_setCommentCount_Params, callback?: (ret:JSON) => void):void

	/**
	 * `设置收藏状态。应在调用open方法后调用该方法`
	 * ========params==========
	 *
	 * `status` :boolean : （可选项）用于设置收藏状态，默认false不收藏。
	 */
	setFavorite(params:photoBrowserTodayNew_setFavorite_Params, callback?: (ret:JSON) => void):void

	/** 清除缓存到本地的网络图片，本接口只清除本模块缓存的数据，若要清除本 app 缓存的所有数据则调用 api.clearCache。清除缓存后保存图片会失败，所以开发者要在适当的时候清除缓存或不清除缓存。*/ 
	clearCache():void

	/** 关闭图片浏览器，open和close应一 一对应，调用open后应在适当时候调用close。*/ 
	close():void

}
interface photoBrowserTodayNew_open_Params {
	/**（必填项）要显示的图片url数组,图片数量应大于等于1。支持 fs://、widget://、http://、https://格式*/ 
	images:Array<JSON>,

	/**（可选项）要显示的图片描述字符串数组，images和texts一 一对应，即images中的第一个元素对应texts中的第一个元素，以此类推。字符串数量应等于图片数量，如大于图片数量，则模块从左往右选取数量等于图片数量的那些字符串，如小于图片数量，则剩下的描述字符串模块会自动用空字符串("")补全。参数visibility中的textArea为true时，该字段才有效。*/ 
	texts?:Array<JSON>,

	/**必填项，要将该模块添加到哪个frame显示，一般本模块需要全屏显示（除去手机状态栏，即除去手机顶部的状态栏，其他区域都用来显示本模块），所以frame的区域建议为除去手机顶部状态栏的其他区域。沉浸式模式下，建议将状态栏的背景色设置成黑色(#000000)，以便与本模块的背景色保持一致。*/ 
	frame:string,

	/**（可选项）用于设置功能按钮是否显示，当input为2时，此时点击伪输入框弹出真正的评论输入框，要想图片不跟随键盘上移，则在config.xml中配置如下参数：<br/><preference name="softInputMode" value="pan"/>*/ 
	visibility?:JSON,

	/**（可选项）用于设置文字描述区域高度所占的百分比，公式如下：<br/>*/ 
	textHeight?:JSON,

	/**（可选项）用于设置从第几张图片开始显示，默认1，该值从1计数，而不是0。*/ 
	start?:any,

	/**（可选项）用于设置评论按钮上的红色评论数量，默认0，>0时显示红色数量, <=0时不显示红色数量; 大于999时显示"999+"*/ 
	count?:any,

	/**（可选项）用于设置是否收藏，默认false不收藏。*/ 
	status?:boolean,

	/**（可选项）用于设置发布人头像，为空或不传时头像不显示，支持 fs://、widget://、http://、https://格式*/ 
	publisher?:string,

	/**（可选项）用于设置伪输入框的提示文字，默认"写评论..."；参数visibility中的input为1或2时，该字段才有效。*/ 
	virtualInputHint?:string,

	/**（可选项）用于设置可输入评论内容的输入框的提示文字，默认"优质评论将会被优先展示"；参数visibility中的input为2时，该字段才有效。*/ 
	realInputHint?:string,

}

interface photoBrowserTodayNew_setCommentCount_Params {
	/**（可选项）用于设置评论按钮上的红色评论数量，默认0，>0时显示红色数量, <=0时不显示红色数量; 大于999时显示"999+"*/ 
	count?:any,

}

interface photoBrowserTodayNew_setFavorite_Params {
	/**（可选项）用于设置收藏状态，默认false不收藏。*/ 
	status?:boolean,

}

interface dUserAgent {
}
interface qrScanner {
	/** 打开二维码扫描器*/ 
	openScanner():void

	/**
	 * `将字符串生成二维码图片`
	 * ========params==========
	 *
	 * `content` :string : 所要生成的二维码字符串
	 */
	encodeImg(params:qrScanner_encodeImg_Params, callback?: (ret:JSON) => void):void

}
interface qrScanner_encodeImg_Params {
	/**所要生成的二维码字符串*/ 
	content:string,

}

interface notifyMrg {
	/** 获取当前所有通知*/ 
	getActiveNotifications(callback?: (ret:JSON, err:JSON) => void):void

	/** 删除所有通知*/ 
	cancelAllNotifications(callback?: (ret:JSON, err:JSON) => void):void

	/** 收到通知监听触发*/ 
	onNotificationPosted(callback?: (ret:JSON, err:JSON) => void):void

	/** 删除通知监听*/ 
	onNotificationRemoved(callback?: (ret:JSON, err:JSON) => void):void

	/** 删除指定通知*/ 
	cancelNotification(callback?: (ret:JSON, err:JSON) => void):void

}
interface networkAddress {
	/** 获取手机网络ip*/ 
	get():void

	/** 判断网络是否连接*/ 
	isNetConnected():void

	/** 获取连接的网络类型*/ 
	getNetworkType():void

	/** 添加网速监听*/ 
	netWorkSpeedListener():void

	/** 停止网速监听*/ 
	stopNetWorkSpeedListener():void

}
interface speedPlayer {
	/** 打开一个直播或点播*/ 
	open():void

	/** 关闭播放器并释放内存*/ 
	close():void

	/** 继续播放*/ 
	resume():void

	/** 设置视频地址及标题，开始播放位置*/ 
	setPath():void

	/**
	 * `设置视频区域大小。`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）视频区域的位置及尺寸
	 */
	setRect(params:speedPlayer_setRect_Params):void

	/** 重播*/ 
	replay():void

	/**
	 * `设置视频播放位置`
	 * ========params==========
	 *
	 * `pos` :any : （可选项）视频播放开始位置，单位：秒。
	 */
	seek(params:speedPlayer_seek_Params):void

	/** 获取视频播放的位置*/ 
	getCurrent():void

	/** 获取视频总时长*/ 
	getDuration():void

	/** 设置视频播放倍数*/ 
	setRate():void

	/** 获取视频播放的倍速*/ 
	getRate():void

	/** 全屏显示*/ 
	fullscreen():void

	/** 取消全屏显示*/ 
	cancelFullscreen():void

	/** 获取音量*/ 
	getVol():void

	/** 设置音量*/ 
	setVol():void

	/** 获取亮度*/ 
	getBrightness():void

	/** 设置亮度*/ 
	setBrightness():void

	/** 继续播放*/ 
	start():void

}
interface speedPlayer_setRect_Params {
	/**（可选项）视频区域的位置及尺寸*/ 
	rect?:JSON,

}

interface speedPlayer_seek_Params {
	/**（可选项）视频播放开始位置，单位：秒。*/ 
	pos?:any,

}

interface apk {
	/** 获取apk的包名。*/ 
	getPackageName():void

	/** 获取apk的签名。*/ 
	getSign():void

	/** 获取meta-data数据。*/ 
	getMeta():void

}
interface snKVStorage {
	/**
	 * `设置字符串数据，数据会存储到本地文件系统。`
	 * ========params==========
	 *
	 * `key` :string : 键
	 *
	 * `value` :string : 值
	 */
	setString(params:snKVStorage_setString_Params):void

	/**
	 * `设置整型数据，数据会存储到本地文件系统。`
	 * ========params==========
	 *
	 * `key` :string : 键
	 *
	 * `value` :any : 值
	 */
	setInt(params:snKVStorage_setInt_Params):void

	/**
	 * `设置浮点型数据，数据会存储到本地文件系统。`
	 * ========params==========
	 *
	 * `key` :string : 键
	 *
	 * `value` :any : 值
	 */
	setDouble(params:snKVStorage_setDouble_Params):void

	/**
	 * `设置布尔数据，数据会存储到本地文件系统。`
	 * ========params==========
	 *
	 * `key` :string : 键
	 *
	 * `value` :boolean : 值
	 */
	setBool(params:snKVStorage_setBool_Params):void

	/**
	 * `设置对象数据，数据会存储到本地文件系统。`
	 * ========params==========
	 *
	 * `key` :string : 键
	 *
	 * `value` :JSON : 值
	 */
	setObject(params:snKVStorage_setObject_Params):void

	/**
	 * `设置数组数据，数据会存储到本地文件系统。`
	 * ========params==========
	 *
	 * `key` :string : 键
	 *
	 * `value` :Array<JSON> : 值
	 */
	setArray(params:snKVStorage_setArray_Params):void

	/**
	 * `获取字符串数据`
	 * ========params==========
	 *
	 * `key` :string : 键
	 */
	getString(params:snKVStorage_getString_Params):void

	/**
	 * `获取整型数据`
	 * ========params==========
	 *
	 * `key` :string : 键
	 */
	getInt(params:snKVStorage_getInt_Params):void

	/**
	 * `获取浮点型数据`
	 * ========params==========
	 *
	 * `key` :string : 键
	 */
	getDouble(params:snKVStorage_getDouble_Params):void

	/**
	 * `获取布尔数据`
	 * ========params==========
	 *
	 * `key` :string : 键
	 */
	getBool(params:snKVStorage_getBool_Params):void

	/**
	 * `设置对象数据`
	 * ========params==========
	 *
	 * `key` :string : 键
	 */
	getObject(params:snKVStorage_getObject_Params):void

	/**
	 * `获取数组数据`
	 * ========params==========
	 *
	 * `key` :string : 键
	 */
	getArray(params:snKVStorage_getArray_Params):void

	/**
	 * `检查是否有kv`
	 * ========params==========
	 *
	 * `key` :string : 键
	 */
	has(params:snKVStorage_has_Params):void

	/**
	 * `删除单个kv`
	 * ========params==========
	 *
	 * `key` :string : 键
	 */
	removeKey(params:snKVStorage_removeKey_Params):void

	/**
	 * `删除多个kv`
	 * ========params==========
	 *
	 * `keys` :string : 键
	 */
	removeKeys(params:snKVStorage_removeKeys_Params):void

	/** 清除kv*/ 
	clear():void

}
interface snKVStorage_setString_Params {
	/**键*/ 
	key:string,

	/**值*/ 
	value:string,

}

interface snKVStorage_setInt_Params {
	/**键*/ 
	key:string,

	/**值*/ 
	value:any,

}

interface snKVStorage_setDouble_Params {
	/**键*/ 
	key:string,

	/**值*/ 
	value:any,

}

interface snKVStorage_setBool_Params {
	/**键*/ 
	key:string,

	/**值*/ 
	value:boolean,

}

interface snKVStorage_setObject_Params {
	/**键*/ 
	key:string,

	/**值*/ 
	value:JSON,

}

interface snKVStorage_setArray_Params {
	/**键*/ 
	key:string,

	/**值*/ 
	value:Array<JSON>,

}

interface snKVStorage_getString_Params {
	/**键*/ 
	key:string,

}

interface snKVStorage_getInt_Params {
	/**键*/ 
	key:string,

}

interface snKVStorage_getDouble_Params {
	/**键*/ 
	key:string,

}

interface snKVStorage_getBool_Params {
	/**键*/ 
	key:string,

}

interface snKVStorage_getObject_Params {
	/**键*/ 
	key:string,

}

interface snKVStorage_getArray_Params {
	/**键*/ 
	key:string,

}

interface snKVStorage_has_Params {
	/**键*/ 
	key:string,

}

interface snKVStorage_removeKey_Params {
	/**键*/ 
	key:string,

}

interface snKVStorage_removeKeys_Params {
	/**键*/ 
	keys:string,

}

interface photoStream {
	/**
	 * `打开照片墙页面`
	 * ========params==========
	 *
	 * `close` :string : 是否显示关闭按钮
	 *
	 * `bgColor` :string : 背景色
	 *
	 * `butTextColor` :string : 关闭按钮字体颜色
	 *
	 * `butPressColor` :string : 关闭按钮按下字体颜色
	 *
	 * `files` :Array : 照片墙中的图片数组，支持jpg与png格式的的图片，如果未构造图片数组，则默认图片显示
	 */
	openPSV(params:photoStream_openPSV_Params):void

}
interface photoStream_openPSV_Params {
	/**是否显示关闭按钮*/ 
	close:string,

	/**背景色*/ 
	bgColor:string,

	/**关闭按钮字体颜色*/ 
	butTextColor:string,

	/**关闭按钮按下字体颜色*/ 
	butPressColor:string,

	/**照片墙中的图片数组，支持jpg与png格式的的图片，如果未构造图片数组，则默认图片显示*/ 
	files:Array,

}

interface playRtsp {
	/**
	 * `初始化设置`
	 * ========params==========
	 *
	 * `doubleClick` :boolean : （可选项）是否双机视频播放界面进行横屏切换。
	 *
	 * `isLocked` :boolean : （可选项）是否锁住屏幕，锁住屏幕后，执行全屏和退出全屏接口会无效。
	 */
	init(params:playRtsp_init_Params, callback?: (ret:JSON) => void):void

	/**
	 * `播放rtsp://格式直播流`
	 * ========params==========
	 *
	 * `rect` :JSON : （必填项）悬浮窗口UI播放的位置及尺寸
	 *
	 * `fixedOn` :string : （可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window
	 *
	 * `fixed` :boolean : （（可选项）模块是否随所属 Window 或 Frame 滚动
	 *
	 * `url` :string : （必填项）视频资源地址，仅支持rtsp://
	 *
	 * `options` :Array : （可选项）vlc配置(请自行根据vlc配置规则配置安卓和iOS的参数)
	 */
	play(params:playRtsp_play_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 暂停播放*/ 
	pause():void

	/** 暂停后开始播放*/ 
	start():void

	/** 停止播放*/ 
	stop():void

	/** 获取是否全屏播放状态*/ 
	isFullScreen(callback?: (ret:JSON) => void):void

	/** 全屏播放*/ 
	full():void

	/** 退出全屏*/ 
	unfull():void

	/**
	 * `设置音量大小（1、ios设置的是系统音量，请退出播放后，将音量进行恢复操作。2、安卓设置的是视频音量，和安卓系统的本身音量大小有关。）`
	 * ========params==========
	 *
	 * `volume` :number : （必填项）设置音量(0-100)
	 */
	setVolume(params:playRtsp_setVolume_Params):void

	/**
	 * `切换视频播放地址`
	 * ========params==========
	 *
	 * `url` :string : （必填项）视频资源地址，仅支持rtsp://
	 */
	playUrl(params:playRtsp_playUrl_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 截图*/ 
	saveSnap(callback?: (ret:JSON, err:JSON) => void):void

	/** 播放器事件监听*/ 
	addEventListener(callback?: (ret:JSON) => void):void

	/** 隐藏播放器*/ 
	hide():void

	/** 隐藏后显示播放器*/ 
	show():void

}
interface playRtsp_init_Params {
	/**（可选项）是否双机视频播放界面进行横屏切换。*/ 
	doubleClick?:boolean,

	/**（可选项）是否锁住屏幕，锁住屏幕后，执行全屏和退出全屏接口会无效。*/ 
	isLocked?:boolean,

}

interface playRtsp_play_Params {
	/**（必填项）悬浮窗口UI播放的位置及尺寸*/ 
	rect:JSON,

	/**（可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window*/ 
	fixedOn?:string,

	/**（（可选项）模块是否随所属 Window 或 Frame 滚动*/ 
	fixed?:boolean,

	/**（必填项）视频资源地址，仅支持rtsp://*/ 
	url:string,

	/**（可选项）vlc配置(请自行根据vlc配置规则配置安卓和iOS的参数)*/ 
	options?:Array,

}

interface playRtsp_setVolume_Params {
	/**（必填项）设置音量(0-100)*/ 
	volume:number,

}

interface playRtsp_playUrl_Params {
	/**（必填项）视频资源地址，仅支持rtsp://*/ 
	url:string,

}

interface moduleCrop {
}
interface marketScore {
}
interface UIPhotoViewer {
	/**
	 * `打开图片浏览器`
	 * ========params==========
	 *
	 * `images` :Array : 要读取的图片路径组成的数组，图片路径支持 fs://、http:// 协议
	 *
	 * `activeIndex` :number : （可选项）当前要显示的图片在图片路径数组中的索引
	 *
	 * `placeholderImg` :string : （可选项）当加载网络图片时显示的占位图路径，要求本地图片路径（widget://、fs://）
	 *
	 * `bgColor` :string : （可选项）图片浏览器背景色，支持 rgb、rgba、#
	 *
	 * `zoomEnabled` :boolean : （可选项）是否打开缩放手势识别功能（随手势放大缩小图片）
	 *
	 * `mode` :number : （可选项）图片的现实模式；1：为图片原本大小 2：图片宽度等比例放大到宽等于屏幕款;android不支持此参数
	 *
	 * `gestureClose` :boolean : （可选项）手势关闭，上划或下划关闭控件
	 *
	 * `atime` :number : （可选项）打开关闭动画的执行时间，传0无动画
	 *
	 * `isBigGig` :boolean : （可选项）是否有大gif图片，如果网络图片中存在比较大的gif图片，比如一张gif图包含300张图片，将会照成内存溢出产生崩溃，将此参数设置成为true，包含超过50张的gif图模块内部将处理成包含50张以下图片的gif图，此参数仅支持iOS
	 *
	 * `rotateBtn` :JSON : （可选项）预览图片时的旋转按钮
	 */
	open(params:UIPhotoViewer_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭图片浏览器*/ 
	close():void

	/** 隐藏图片浏览器*/ 
	hide():void

	/** 显示图片浏览器*/ 
	show():void

	/**
	 * `设置当前显示图片`
	 * ========params==========
	 *
	 * `index` :number : （可选项）当前要显示的图片在图片路径数组中的索引
	 */
	setIndex(params:UIPhotoViewer_setIndex_Params):void

	/** 获取当前图片在图片路径数组内的索引*/ 
	getIndex():void

	/**
	 * `获取指定图片在本地的绝对路径`
	 * ========params==========
	 *
	 * `index` :number : 指定图片在图片数组中的索引
	 */
	getImage(params:UIPhotoViewer_getImage_Params, callback?: (ret:JSON) => void):void

	/**
	 * `设置指定位置的图片，**若设置的是网络图片加载成功或失败会给 open 接口回调该加载事件**`
	 * ========params==========
	 *
	 * `index` :number : （可选项）指定图片在图片数组中的索引
	 *
	 * `image` :string : 要设置的图片路径，支持本地和网络路径（fs://、http://）
	 */
	setImage(params:UIPhotoViewer_setImage_Params):void

	/**
	 * `往已打开的图片浏览器里添加图片（拼接在最后）`
	 * ========params==========
	 *
	 * `images` :Array : 要拼接的图片路径组成的数组，图片路径支持 fs://、http:// 协议
	 */
	appendImage(params:UIPhotoViewer_appendImage_Params):void

	/**
	 * `删除指定位置的图片`
	 * ========params==========
	 *
	 * `index` :number : （可选项）删除的指定图片在图片数组中的索引
	 */
	deleteImage(params:UIPhotoViewer_deleteImage_Params):void

	/** 清除缓存到本地的网络图片，**本接口只清除本模块缓存的数据，若要清除本 app 缓存的所有数据则调用 api.clearCache***/ 
	clearCache():void

}
interface UIPhotoViewer_open_Params {
	/**要读取的图片路径组成的数组，图片路径支持 fs://、http:// 协议*/ 
	images:Array,

	/**（可选项）当前要显示的图片在图片路径数组中的索引*/ 
	activeIndex?:number,

	/**（可选项）当加载网络图片时显示的占位图路径，要求本地图片路径（widget://、fs://）*/ 
	placeholderImg?:string,

	/**（可选项）图片浏览器背景色，支持 rgb、rgba、#*/ 
	bgColor?:string,

	/**（可选项）是否打开缩放手势识别功能（随手势放大缩小图片）*/ 
	zoomEnabled?:boolean,

	/**（可选项）图片的现实模式；1：为图片原本大小 2：图片宽度等比例放大到宽等于屏幕款;android不支持此参数*/ 
	mode?:number,

	/**（可选项）手势关闭，上划或下划关闭控件*/ 
	gestureClose?:boolean,

	/**（可选项）打开关闭动画的执行时间，传0无动画*/ 
	atime?:number,

	/**（可选项）是否有大gif图片，如果网络图片中存在比较大的gif图片，比如一张gif图包含300张图片，将会照成内存溢出产生崩溃，将此参数设置成为true，包含超过50张的gif图模块内部将处理成包含50张以下图片的gif图，此参数仅支持iOS*/ 
	isBigGig?:boolean,

	/**（可选项）预览图片时的旋转按钮*/ 
	rotateBtn?:JSON,

}

interface UIPhotoViewer_setIndex_Params {
	/**（可选项）当前要显示的图片在图片路径数组中的索引*/ 
	index?:number,

}

interface UIPhotoViewer_getImage_Params {
	/**指定图片在图片数组中的索引*/ 
	index:number,

}

interface UIPhotoViewer_setImage_Params {
	/**（可选项）指定图片在图片数组中的索引*/ 
	index?:number,

	/**要设置的图片路径，支持本地和网络路径（fs://、http://）*/ 
	image:string,

}

interface UIPhotoViewer_appendImage_Params {
	/**要拼接的图片路径组成的数组，图片路径支持 fs://、http:// 协议*/ 
	images:Array,

}

interface UIPhotoViewer_deleteImage_Params {
	/**（可选项）删除的指定图片在图片数组中的索引*/ 
	index?:number,

}

interface keepAlive {
	/**
	 * `sdk 初始化`
	 * ========params==========
	 *
	 * `interval` :any : （必填）心跳间隔时间s（单位秒）
	 */
	initSdk(params:keepAlive_initSdk_Params, callback?: (ret:JSON) => void):void

	/** 心跳监听*/ 
	setEventListener(callback?: (ret:JSON) => void):void

}
interface keepAlive_initSdk_Params {
	/**（必填）心跳间隔时间s（单位秒）*/ 
	interval:any,

}

interface androidPdfReader {
	/**
	 * `打开一个 pdf 格式的文档`
	 * ========params==========
	 *
	 * `path` :string : 文档的路径，支持 fs://、http:// 等本地和网络协议
	 */
	open(params:androidPdfReader_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `打开pdf文档视图`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `path` :string : 文档的路径，支持 fs://、http:// 等本地和网络协议, 暂不支持（widget://）
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	openView(params:androidPdfReader_openView_Params, callback?: (ret:JSON) => void):void

	/** 隐藏文档视图*/ 
	hideView():void

	/** 显示文档视图*/ 
	showView():void

	/** 关闭文档视图*/ 
	closeView():void

	/** 清除缓存到本地的文件，**本接口只清除本模块缓存的数据，若要清除本app缓存的所有数据这调用api.clearCache***/ 
	clearCache():void

}
interface androidPdfReader_open_Params {
	/**文档的路径，支持 fs://、http:// 等本地和网络协议*/ 
	path:string,

}

interface androidPdfReader_openView_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**文档的路径，支持 fs://、http:// 等本地和网络协议, 暂不支持（widget://）*/ 
	path:string,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface shareAction {
	/**
	 * `打开分享对话框`
	 * ========params==========
	 *
	 * `text` :string : （可选项）要分享的文本信息，**在iOS端，当type为image时，本参数会被忽略**
	 *
	 * `type` :string : （可选项）分享文件的类型（iOS系统微信不支持纯文字的分享）
	 *
	 * `path` :string : （可选项）要分享的路径，若是‘file’或‘audio’类型，要求本地路径（fs://、widget://），若是url类型，需要有效的网址。若 images 不为空则模块忽略本参数。**Android 平台不支持 widget:// 路径**
	 *
	 * `images` :Array : （可选项）分享的图片路径组成的数组，仅当 type 为 image 时有效；要求本地路径（fs://、widget://）。若本参数不为空则模块忽略 path 参数。**android 仅支持fs://路径**
	 *
	 * `thumbnail` :string : （可选项）分享时的缩略图；要求本地路径（fs://、widget://）。若不传则不显示。**仅支持 iOS 平台**
	 *
	 * `arrowRect` :JSON : （可选项）iPad中显示时，箭头指向的位置，只iPad有效
	 *
	 * `arrowDirection` :string : （可选项）iPad中显示时，箭头指向的方向，只iPad有效
	 *
	 * `contentSize` :JSON : （可选项）iPad中显示时，对话框大小，只iPad有效，iOS不支持
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 */
	share(params:shareAction_share_Params):void

	/** 分享文本到系统分享控件（通过系统分享控件分享到目标APP）*/ 
	shareText():void

	/**
	 * `打开分享对话框，分享图片到目标 APP **android多图片分享（即images参数）功能，会在android 7.0+ 并且在编译版本（targetVersion）为26时会出现一些兼容性问题，推荐使用share接口分享图片**`
	 * ========params==========
	 *
	 * `images` :Array : 要分享图片的路径组成的数组，要求本地路径（widget://、fs://）**Android 平台不支持 widget://**
	 *
	 * `text` :string : （可选项）要分享的文本信息，**仅支持 android 端**
	 *
	 * `iPad` :JSON : （可选项）iPad 上分享控件的样式配置，若不传则在iPad上显示默认样式
	 */
	shareImage(params:shareAction_shareImage_Params):void

	/**
	 * `打开分享对话框，分享文件`
	 * ========params==========
	 *
	 * `path` :string : 要分享的文件路径，要求本地路径（fs://、widget://），**Android 平台不支持 widget:// 路径**
	 *
	 * `text` :string : （可选项）要分享的文本信息**仅支持 android 端**
	 *
	 * `iPad` :JSON : （可选项）iPad 上分享控件的样式配置，若不传则在iPad上显示默认样式
	 */
	shareFile(params:shareAction_shareFile_Params):void

	/**
	 * `打开分享对话框，分享音频文件`
	 * ========params==========
	 *
	 * `path` :string : 要分享的音频路径，要求本地路径（fs://、widget://），**Android 平台不支持 widget:// 路径**
	 *
	 * `text` :string : （可选项）要分享的文本信息**仅支持 android 端**
	 *
	 * `iPad` :JSON : （可选项）iPad 上分享控件的样式配置
	 */
	shareAudio(params:shareAction_shareAudio_Params):void

	/**
	 * `打开分享对话框，分享Url`
	 * ========params==========
	 *
	 * `url` :string : 要分享的有效网址
	 *
	 * `text` :string : （可选项）要分享的文本信息
	 *
	 * `thumbnail` :string : （可选项）分享时的缩略图；要求本地路径（fs://、widget://）。若不传则不显示。**仅支持 iOS 平台**
	 *
	 * `iPad` :JSON : （可选项）iPad 上分享控件的样式配置，若不传则在iPad上显示默认样式
	 */
	shareUrl(params:shareAction_shareUrl_Params):void

	/**
	 * `获取所有支持分享的app的信息 **（注意：该方法仅支持android）**`
	 * ========params==========
	 *
	 * `type` :string : （可选项）支持分享的类型
	 *
	 * `ret` :JSON : null
	 */
	getSupportSharedAppInfos(params:shareAction_getSupportSharedAppInfos_Params):void

}
interface shareAction_share_Params {
	/**（可选项）要分享的文本信息，**在iOS端，当type为image时，本参数会被忽略***/ 
	text?:string,

	/**（可选项）分享文件的类型（iOS系统微信不支持纯文字的分享）*/ 
	type?:string,

	/**（可选项）要分享的路径，若是‘file’或‘audio’类型，要求本地路径（fs://、widget://），若是url类型，需要有效的网址。若 images 不为空则模块忽略本参数。**Android 平台不支持 widget:// 路径***/ 
	path?:string,

	/**（可选项）分享的图片路径组成的数组，仅当 type 为 image 时有效；要求本地路径（fs://、widget://）。若本参数不为空则模块忽略 path 参数。**android 仅支持fs://路径***/ 
	images?:Array,

	/**（可选项）分享时的缩略图；要求本地路径（fs://、widget://）。若不传则不显示。**仅支持 iOS 平台***/ 
	thumbnail?:string,

	/**（可选项）iPad中显示时，箭头指向的位置，只iPad有效*/ 
	arrowRect?:JSON,

	/**（可选项）iPad中显示时，箭头指向的方向，只iPad有效*/ 
	arrowDirection?:string,

	/**（可选项）iPad中显示时，对话框大小，只iPad有效，iOS不支持*/ 
	contentSize?:JSON,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

}

interface shareAction_shareImage_Params {
	/**要分享图片的路径组成的数组，要求本地路径（widget://、fs://）**Android 平台不支持 widget://***/ 
	images:Array,

	/**（可选项）要分享的文本信息，**仅支持 android 端***/ 
	text?:string,

	/**（可选项）iPad 上分享控件的样式配置，若不传则在iPad上显示默认样式*/ 
	iPad?:JSON,

}

interface shareAction_shareFile_Params {
	/**要分享的文件路径，要求本地路径（fs://、widget://），**Android 平台不支持 widget:// 路径***/ 
	path:string,

	/**（可选项）要分享的文本信息**仅支持 android 端***/ 
	text?:string,

	/**（可选项）iPad 上分享控件的样式配置，若不传则在iPad上显示默认样式*/ 
	iPad?:JSON,

}

interface shareAction_shareAudio_Params {
	/**要分享的音频路径，要求本地路径（fs://、widget://），**Android 平台不支持 widget:// 路径***/ 
	path:string,

	/**（可选项）要分享的文本信息**仅支持 android 端***/ 
	text?:string,

	/**（可选项）iPad 上分享控件的样式配置*/ 
	iPad?:JSON,

}

interface shareAction_shareUrl_Params {
	/**要分享的有效网址*/ 
	url:string,

	/**（可选项）要分享的文本信息*/ 
	text?:string,

	/**（可选项）分享时的缩略图；要求本地路径（fs://、widget://）。若不传则不显示。**仅支持 iOS 平台***/ 
	thumbnail?:string,

	/**（可选项）iPad 上分享控件的样式配置，若不传则在iPad上显示默认样式*/ 
	iPad?:JSON,

}

interface shareAction_getSupportSharedAppInfos_Params {
	/**（可选项）支持分享的类型*/ 
	type?:string,

	/**null*/ 
	ret:JSON,

}

interface easyVideoPlayer {
}
interface acReplay {
	/** 开始录屏（调用iOS acReplayKi SDK，录屏结束后会弹出回放的预览页面，在预览中可以选择保存视频到相册中、放弃、或者分享出去）*/ 
	startReplay():void

	/** 停止录屏*/ 
	stopReplay():void

}
interface aliOSS {
	/**
	 * `初始化 调用其它接口之前必须先初始化，支持`明文模式`、`自签名模式`、`STS鉴权模式` ，明文模式鉴权必须设置 accessKeyId 和 accessKeySecret，此方式建议只在本地测试时使用，正式环境请使用自签名模式或 STS 鉴权模式。`
	 * ========params==========
	 *
	 * `accessKeyId` :string : （可选项）从阿里云获取的 accessKeyId
	 *
	 * `accessKeySecret` :string : （可选项）从阿里云获取的 accessKeySecret
	 *
	 * `endpoint` :string : OSS 区域地址，如：`https://oss-cn-beijing.aliyuncs.com`
	 *
	 * `bucketName` :string : Bucket 名称，该参数设置默认操作的 Bucket。如您有多个 Bucket 要操作，使用其它方法时有参数可动态改变 Bucket。
	 *
	 * `params` :any : （可选项）自签名/STS 鉴权模式时向 signUrl/stsUrl 发送（POST 方式）的自定义数据，注：只支持一级 JSON，并且不能包含键为 content 的字段。
	 *
	 * `headers` :any : （可选项）自签名/STS 鉴权模式时向 signUrl/stsUrl 发送（POST 方式）的自定义头信息。
	 *
	 * `timeout` :any : （可选项）连接超时，默认 15 秒
	 *
	 * `socketTimeout` :any : （可选项）传输文件最大允许时间，默认 15 秒
	 *
	 * `concurrent` :any : （可选项）最大并发请求数，默认 5 个
	 *
	 * `retry` :any : （可选项）失败后最大重试次数，默认 2 次
	 *
	 * `signUrl` :string : （可选项）自签名 URL 地址，POST 请求，使用自签名模式时设置。该地址接收名为 content 的参数，按阿里云自签名算法返回加签后的字符串即可。
	 *
	 * `stsUrl` :string : （可选项）STS 鉴权地址，POST 请求，使用 STS 鉴权模式时设置。该地址访问后需返回如下格式的 JSON 字符串（参数名称必须和下面的一致） ：
	 */
	init(params:aliOSS_init_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `文件上传`
	 * ========params==========
	 *
	 * `file` :string : 要上传的文件，支持 fs://、cache://等文件路径协议及真实路径。
	 *
	 * `name` :string : 上传 OSS 后保存的文件名
	 *
	 * `bucketName` :string : （可选项）上传至的 Bucket 名称，如不设置将使用初始化时的默认 Bucket。该参数用于操作多个 Bucket 时，动态改变目标 Bucket。
	 *
	 * `verify` :string : （可选项）文件完整性检验，目前只支持参数 CRC。
	 */
	upload(params:aliOSS_upload_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `断点续传`
	 * ========params==========
	 *
	 * `file` :string : 要上传的文件，支持 fs://、cache://等文件路径协议及真实路径。
	 *
	 * `name` :string : 上传 OSS 后保存的文件名
	 *
	 * `bucketName` :string : （可选项）上传至的 Bucket 名称，如不设置将使用初始化时的默认 Bucket。该参数用于操作多个 Bucket 时，动态改变目标 Bucket。
	 *
	 * `verify` :string : （可选项）文件完整性检验，目前只支持参数 CRC。
	 */
	resumableUpload(params:aliOSS_resumableUpload_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `下载文件，当下载图片并且传入 process 参数时可以处理图片。`
	 * ========params==========
	 *
	 * `objectKey` :string : 待下载的阿里 OSS 文件名
	 *
	 * `saveAs` :string : 下载到本地保存的文件名，支持 fs://,cache://等文件路径协议及真实路径。
	 *
	 * `process` :string : （可选项）下载图片时对图片进行处理的命令。处理命令参见阿里文档：[图片处理](https://help.aliyun.com/document_detail/44686.html?spm=5176.doc44686.6.933.I5FsuS)
	 *
	 * `bucketName` :string : （可选项）目标 Bucket 名称，如不设置将使用初始化时的默认 Bucket。该参数用于操作多个 Bucket 时，动态改变目标 Bucket。
	 *
	 * `verify` :string : （可选项）文件完整性检验，目前只支持参数 CRC。
	 */
	getObject(params:aliOSS_getObject_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取文件元信息`
	 * ========params==========
	 *
	 * `objectKey` :string : 阿里云 OSS 文件名
	 *
	 * `bucketName` :string : （可选项）目标 Bucket 名称，如不设置将使用初始化时的默认 Bucket。该参数用于操作多个 Bucket 时，动态改变目标 Bucket。
	 */
	getHead(params:aliOSS_getHead_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `判断文件是否存在于 OSS 服务器`
	 * ========params==========
	 *
	 * `objectKey` :string : 阿里云 OSS 文件名
	 *
	 * `bucketName` :string : （可选项）目标 Bucket 名称，如不设置将使用初始化时的默认 Bucket。该参数用于操作多个 Bucket 时，动态改变目标 Bucket。
	 */
	exist(params:aliOSS_exist_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `删除 OSS 服务器中的文件，要求对 Bucket 有写权限。注：删除时并不会对文件存在与否进行检测，即文件不存在于 OSS 服务器中也会返回成功。`
	 * ========params==========
	 *
	 * `objectKey` :string : 阿里云 OSS 文件名
	 *
	 * `bucketName` :string : （可选项）目标 Bucket 名称，如不设置将使用初始化时的默认 Bucket。该参数用于操作多个 Bucket 时，动态改变目标 Bucket。
	 */
	delete(params:aliOSS_delete_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取 OSS 服务器中的文件列表。`
	 * ========params==========
	 *
	 * `prefix` :string : （可选项）文件名前辍，即以该参数开始的文件才会被返回。设置后可以用于获取某个目录下的文件。注：返回的文件名仍然包含该前辍。
	 *
	 * `maxKeys` :number : （可选项）文件最大数量限制。默认为 100，阿里限制不能超过 1000。
	 *
	 * `marker` :string : （可选项）获取文件列表时的起始偏移位置。该参数的值由第一次使用该方法后返回，通过循环调用该接口并设置此参数，可实现分页。
	 *
	 * `current` :boolean : （可选项）只获取请求路径下的文件及文件夹，文件夹将排在前边，其只含 `key`, `isDir`属性。
	 *
	 * `bucketName` :string : （可选项）目标 Bucket 名称，如不设置将使用初始化时的默认 Bucket。该参数用于操作多个 Bucket 时，动态改变目标 Bucket。
	 */
	listObjects(params:aliOSS_listObjects_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `复制 OSS 服务器内文件。不能复制超过 1G 的文件，不能在不同数据中心间复制。`
	 * ========params==========
	 *
	 * `bucketName` :string : （可选项）源 Bucket 名称。默认为接口初始化时的 Bucket。
	 *
	 * `objectKey` :string : 源文件。
	 *
	 * `toBucketName` :string : （可选项）目标 Bucket 名称。默认和源 Bucket 相同。
	 *
	 * `toObjectKey` :string : 复制后保存的文件名。
	 */
	copy(params:aliOSS_copy_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 新建 Bucket，需要相应权限。*/ 
	createBucket():void

	/**
	 * `文档预览，支持 ppt、xls、doc、pdf 等格式文档进行在线预览，具体配置及开通请参考[阿里云智能媒体管理（IMM）](https://help.aliyun.com/document_detail/99384.html)`
	 * ========params==========
	 *
	 * `bucketName` :string : （可选项）目标 Bucket 名称，如不设置将使用初始化时的默认 Bucket。该参数用于操作多个 Bucket 时，动态改变目标 Bucket。
	 *
	 * `objectKey` :string : 要预览的文件，需是阿里云支持的文件类型。
	 *
	 * `expired` :any : 链接失效秒数，默认 3600 秒。
	 *
	 * `copy` :any : （可选项）指定预览文件是否能够复制文档内容。
	 */
	previewDoc(params:aliOSS_previewDoc_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `人脸识别，具体配置及开通请参考[阿里云智能媒体管理（IMM）](https://help.aliyun.com/document_detail/99384.html)`
	 * ========params==========
	 *
	 * `bucketName` :string : （可选项）目标 Bucket 名称，如不设置将使用初始化时的默认 Bucket。该参数用于操作多个 Bucket 时，动态改变目标 Bucket。
	 *
	 * `objectKey` :string : 要识别的文件，需是阿里云支持的图片类型。
	 */
	detectFace(params:aliOSS_detectFace_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `图片内容识别、打标，识别图片中的元素，可识别图片中的场景、食物、交通工具等，[具体参考](https://help.aliyun.com/document_detail/64791.html)，具体配置及开通请参考[阿里云智能媒体管理（IMM）](https://help.aliyun.com/document_detail/99384.html)`
	 * ========params==========
	 *
	 * `bucketName` :string : （可选项）目标 Bucket 名称，如不设置将使用初始化时的默认 Bucket。该参数用于操作多个 Bucket 时，动态改变目标 Bucket。
	 *
	 * `objectKey` :string : 要处理的文件，需是阿里云支持的图片类型。
	 */
	tagImage(params:aliOSS_tagImage_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `授权第三方访问，可授权第三方访问文件。`
	 * ========params==========
	 *
	 * `bucketName` :string : （可选项）目标 Bucket 名称，如不设置将使用初始化时的默认 Bucket。该参数用于操作多个 Bucket 时，动态改变目标 Bucket。
	 *
	 * `objectKey` :string : 要授权访问的文件。
	 *
	 * `expired` :any : （可选项）链接失效时间，单位：秒，默认 3600 秒
	 *
	 * `process` :string : （可选项）文件为图片时对图片的处理（如缩放等），具体参数请参考[阿里云文档](https://help.aliyun.com/document_detail/44686.html)。
	 */
	url(params:aliOSS_url_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `文件重命名。`
	 * ========params==========
	 *
	 * `bucketName` :string : （可选项）目标 Bucket 名称，如不设置将使用初始化时的默认 Bucket。该参数用于操作多个 Bucket 时，动态改变目标 Bucket。
	 *
	 * `name` :string : 原文件名。
	 *
	 * `newName` :string : 新文件名。
	 */
	rename(params:aliOSS_rename_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `创建文件夹。`
	 * ========params==========
	 *
	 * `bucketName` :string : （可选项）目标 Bucket 名称，如不设置将使用初始化时的默认 Bucket。该参数用于操作多个 Bucket 时，动态改变目标 Bucket。
	 *
	 * `name` :string : 文件夹名称。
	 */
	createFolder(params:aliOSS_createFolder_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface aliOSS_init_Params {
	/**（可选项）从阿里云获取的 accessKeyId*/ 
	accessKeyId?:string,

	/**（可选项）从阿里云获取的 accessKeySecret*/ 
	accessKeySecret?:string,

	/**OSS 区域地址，如：`https://oss-cn-beijing.aliyuncs.com`*/ 
	endpoint:string,

	/**Bucket 名称，该参数设置默认操作的 Bucket。如您有多个 Bucket 要操作，使用其它方法时有参数可动态改变 Bucket。*/ 
	bucketName:string,

	/**（可选项）自签名/STS 鉴权模式时向 signUrl/stsUrl 发送（POST 方式）的自定义数据，注：只支持一级 JSON，并且不能包含键为 content 的字段。*/ 
	params?:any,

	/**（可选项）自签名/STS 鉴权模式时向 signUrl/stsUrl 发送（POST 方式）的自定义头信息。*/ 
	headers?:any,

	/**（可选项）连接超时，默认 15 秒*/ 
	timeout?:any,

	/**（可选项）传输文件最大允许时间，默认 15 秒*/ 
	socketTimeout?:any,

	/**（可选项）最大并发请求数，默认 5 个*/ 
	concurrent?:any,

	/**（可选项）失败后最大重试次数，默认 2 次*/ 
	retry?:any,

	/**（可选项）自签名 URL 地址，POST 请求，使用自签名模式时设置。该地址接收名为 content 的参数，按阿里云自签名算法返回加签后的字符串即可。*/ 
	signUrl?:string,

	/**（可选项）STS 鉴权地址，POST 请求，使用 STS 鉴权模式时设置。该地址访问后需返回如下格式的 JSON 字符串（参数名称必须和下面的一致） ：*/ 
	stsUrl?:string,

}

interface aliOSS_upload_Params {
	/**要上传的文件，支持 fs://、cache://等文件路径协议及真实路径。*/ 
	file:string,

	/**上传 OSS 后保存的文件名*/ 
	name:string,

	/**（可选项）上传至的 Bucket 名称，如不设置将使用初始化时的默认 Bucket。该参数用于操作多个 Bucket 时，动态改变目标 Bucket。*/ 
	bucketName?:string,

	/**（可选项）文件完整性检验，目前只支持参数 CRC。*/ 
	verify?:string,

}

interface aliOSS_resumableUpload_Params {
	/**要上传的文件，支持 fs://、cache://等文件路径协议及真实路径。*/ 
	file:string,

	/**上传 OSS 后保存的文件名*/ 
	name:string,

	/**（可选项）上传至的 Bucket 名称，如不设置将使用初始化时的默认 Bucket。该参数用于操作多个 Bucket 时，动态改变目标 Bucket。*/ 
	bucketName?:string,

	/**（可选项）文件完整性检验，目前只支持参数 CRC。*/ 
	verify?:string,

}

interface aliOSS_getObject_Params {
	/**待下载的阿里 OSS 文件名*/ 
	objectKey:string,

	/**下载到本地保存的文件名，支持 fs://,cache://等文件路径协议及真实路径。*/ 
	saveAs:string,

	/**（可选项）下载图片时对图片进行处理的命令。处理命令参见阿里文档：[图片处理](https://help.aliyun.com/document_detail/44686.html?spm=5176.doc44686.6.933.I5FsuS)*/ 
	process?:string,

	/**（可选项）目标 Bucket 名称，如不设置将使用初始化时的默认 Bucket。该参数用于操作多个 Bucket 时，动态改变目标 Bucket。*/ 
	bucketName?:string,

	/**（可选项）文件完整性检验，目前只支持参数 CRC。*/ 
	verify?:string,

}

interface aliOSS_getHead_Params {
	/**阿里云 OSS 文件名*/ 
	objectKey:string,

	/**（可选项）目标 Bucket 名称，如不设置将使用初始化时的默认 Bucket。该参数用于操作多个 Bucket 时，动态改变目标 Bucket。*/ 
	bucketName?:string,

}

interface aliOSS_exist_Params {
	/**阿里云 OSS 文件名*/ 
	objectKey:string,

	/**（可选项）目标 Bucket 名称，如不设置将使用初始化时的默认 Bucket。该参数用于操作多个 Bucket 时，动态改变目标 Bucket。*/ 
	bucketName?:string,

}

interface aliOSS_delete_Params {
	/**阿里云 OSS 文件名*/ 
	objectKey:string,

	/**（可选项）目标 Bucket 名称，如不设置将使用初始化时的默认 Bucket。该参数用于操作多个 Bucket 时，动态改变目标 Bucket。*/ 
	bucketName?:string,

}

interface aliOSS_listObjects_Params {
	/**（可选项）文件名前辍，即以该参数开始的文件才会被返回。设置后可以用于获取某个目录下的文件。注：返回的文件名仍然包含该前辍。*/ 
	prefix?:string,

	/**（可选项）文件最大数量限制。默认为 100，阿里限制不能超过 1000。*/ 
	maxKeys?:number,

	/**（可选项）获取文件列表时的起始偏移位置。该参数的值由第一次使用该方法后返回，通过循环调用该接口并设置此参数，可实现分页。*/ 
	marker?:string,

	/**（可选项）只获取请求路径下的文件及文件夹，文件夹将排在前边，其只含 `key`, `isDir`属性。*/ 
	current?:boolean,

	/**（可选项）目标 Bucket 名称，如不设置将使用初始化时的默认 Bucket。该参数用于操作多个 Bucket 时，动态改变目标 Bucket。*/ 
	bucketName?:string,

}

interface aliOSS_copy_Params {
	/**（可选项）源 Bucket 名称。默认为接口初始化时的 Bucket。*/ 
	bucketName?:string,

	/**源文件。*/ 
	objectKey:string,

	/**（可选项）目标 Bucket 名称。默认和源 Bucket 相同。*/ 
	toBucketName?:string,

	/**复制后保存的文件名。*/ 
	toObjectKey:string,

}

interface aliOSS_previewDoc_Params {
	/**（可选项）目标 Bucket 名称，如不设置将使用初始化时的默认 Bucket。该参数用于操作多个 Bucket 时，动态改变目标 Bucket。*/ 
	bucketName?:string,

	/**要预览的文件，需是阿里云支持的文件类型。*/ 
	objectKey:string,

	/**链接失效秒数，默认 3600 秒。*/ 
	expired:any,

	/**（可选项）指定预览文件是否能够复制文档内容。*/ 
	copy?:any,

}

interface aliOSS_detectFace_Params {
	/**（可选项）目标 Bucket 名称，如不设置将使用初始化时的默认 Bucket。该参数用于操作多个 Bucket 时，动态改变目标 Bucket。*/ 
	bucketName?:string,

	/**要识别的文件，需是阿里云支持的图片类型。*/ 
	objectKey:string,

}

interface aliOSS_tagImage_Params {
	/**（可选项）目标 Bucket 名称，如不设置将使用初始化时的默认 Bucket。该参数用于操作多个 Bucket 时，动态改变目标 Bucket。*/ 
	bucketName?:string,

	/**要处理的文件，需是阿里云支持的图片类型。*/ 
	objectKey:string,

}

interface aliOSS_url_Params {
	/**（可选项）目标 Bucket 名称，如不设置将使用初始化时的默认 Bucket。该参数用于操作多个 Bucket 时，动态改变目标 Bucket。*/ 
	bucketName?:string,

	/**要授权访问的文件。*/ 
	objectKey:string,

	/**（可选项）链接失效时间，单位：秒，默认 3600 秒*/ 
	expired?:any,

	/**（可选项）文件为图片时对图片的处理（如缩放等），具体参数请参考[阿里云文档](https://help.aliyun.com/document_detail/44686.html)。*/ 
	process?:string,

}

interface aliOSS_rename_Params {
	/**（可选项）目标 Bucket 名称，如不设置将使用初始化时的默认 Bucket。该参数用于操作多个 Bucket 时，动态改变目标 Bucket。*/ 
	bucketName?:string,

	/**原文件名。*/ 
	name:string,

	/**新文件名。*/ 
	newName:string,

}

interface aliOSS_createFolder_Params {
	/**（可选项）目标 Bucket 名称，如不设置将使用初始化时的默认 Bucket。该参数用于操作多个 Bucket 时，动态改变目标 Bucket。*/ 
	bucketName?:string,

	/**文件夹名称。*/ 
	name:string,

}

interface systemTool {
	/** 获取系统字体*/ 
	getSystemFont():void

	/** 获取系统的CPU*/ 
	getCPU():void

	/** 获取系统的内存*/ 
	getMemory():void

	/** 获取系统的密码*/ 
	passCode():void

}
interface imageClip {
}
interface wxShortVideo {
	/**
	 * `打开`
	 * ========params==========
	 *
	 * `album` :boolean : 是否保存到相册（仅iOS支持）
	 *
	 * `save` :JSON : 文件保存配置
	 *
	 * `maxTime` :number : （可选项）最大录制时间（s）（仅android支持）
	 *
	 * `minTime` :number : （可选项）最小录制时间（s）（仅android支持）
	 */
	open(params:wxShortVideo_open_Params, callback?: (ret:JSON) => void):void

}
interface wxShortVideo_open_Params {
	/**是否保存到相册（仅iOS支持）*/ 
	album:boolean,

	/**文件保存配置*/ 
	save:JSON,

	/**（可选项）最大录制时间（s）（仅android支持）*/ 
	maxTime?:number,

	/**（可选项）最小录制时间（s）（仅android支持）*/ 
	minTime?:number,

}

interface tools {
	/**
	 * `分享内容`
	 * ========params==========
	 *
	 * `to` :string : （必须）分享的目标平台
	 *
	 * `picurl` :Array : （必须）[图片1,图片2,图片3....]  微信朋友圈,好友,QQ空间,QQ好友最多9张 (微博只能1张图)
	 *
	 * `content` :boolean : （可选项,在IOS上才有效） 在IOS 11及以上没有办法直接绕过系统分享对框,必须将此处设为true 就先调用系统对话框来让用户选择分享到哪个用户,如选择微信,再调用微信的专用分享页去选择分享到朋友圈或是好友 (微博,QQ也都一样,这个是系统限制)
	 */
	share(params:tools_share_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface tools_share_Params {
	/**（必须）分享的目标平台*/ 
	to:string,

	/**（必须）[图片1,图片2,图片3....]  微信朋友圈,好友,QQ空间,QQ好友最多9张 (微博只能1张图)*/ 
	picurl:Array,

	/**（可选项,在IOS上才有效） 在IOS 11及以上没有办法直接绕过系统分享对框,必须将此处设为true 就先调用系统对话框来让用户选择分享到哪个用户,如选择微信,再调用微信的专用分享页去选择分享到朋友圈或是好友 (微博,QQ也都一样,这个是系统限制)*/ 
	content?:boolean,

}

interface AppleReader {
	/**
	 * `初始化语音播报器`
	 * ========params==========
	 *
	 * `content` :string : 要朗读的文字
	 */
	initReader(params:AppleReader_initReader_Params, callback?: (ret:JSON) => void):void

	/** 获取朗读器信息*/ 
	getReader():void

	/**
	 * `配置朗读器参数`
	 * ========params==========
	 *
	 * `speechRate` :number : （可选项）朗读的语速
	 *
	 * `pitchMultiplier` :number : （可选项）朗读的音高，取值范围：0.5-2
	 *
	 * `volume` :number : （可选项）朗读的音量，取值范围：0-1
	 *
	 * `preUtteranceDelay` :number : （可选项）朗读的前停顿时间，单位秒
	 *
	 * `postUtteranceDelay` :number : （可选项）朗读的后停顿时间，单位秒
	 *
	 * `languageCode` :string : （可选项）朗读的语言
	 */
	config(params:AppleReader_config_Params):void

	/** 开始朗读*/ 
	start():void

	/** 暂停朗读*/ 
	pause():void

	/** 继续朗读*/ 
	continue():void

	/** 停止朗读*/ 
	stop():void

}
interface AppleReader_initReader_Params {
	/**要朗读的文字*/ 
	content:string,

}

interface AppleReader_config_Params {
	/**（可选项）朗读的语速*/ 
	speechRate?:number,

	/**（可选项）朗读的音高，取值范围：0.5-2*/ 
	pitchMultiplier?:number,

	/**（可选项）朗读的音量，取值范围：0-1*/ 
	volume?:number,

	/**（可选项）朗读的前停顿时间，单位秒*/ 
	preUtteranceDelay?:number,

	/**（可选项）朗读的后停顿时间，单位秒*/ 
	postUtteranceDelay?:number,

	/**（可选项）朗读的语言*/ 
	languageCode?:string,

}

interface gifSlim {
	/**
	 * `缩减gif图片数量`
	 * ========params==========
	 *
	 * `ret` :JSON : null
	 */
	slim(params:gifSlim_slim_Params):void

	/**
	 * `获取gif图片数量`
	 * ========params==========
	 *
	 * `ret` :JSON : null
	 */
	getGifCount(params:gifSlim_getGifCount_Params):void

}
interface gifSlim_slim_Params {
	/**null*/ 
	ret:JSON,

}

interface gifSlim_getGifCount_Params {
	/**null*/ 
	ret:JSON,

}

interface dbPlus {
	/**
	 * `获取指定目录下的子文件`
	 * ========params==========
	 *
	 * `directory` :string : （可选项）目录路径，不传时使用 dbPlus 模块的默认路径。支持 fs://、widget://等协议（如fs://user.db）
	 */
	subfile(params:dbPlus_subfile_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `打开数据库，若数据库不存在则创建数据库。`
	 * ========params==========
	 *
	 * `name` :string : （必填项）数据库名称
	 *
	 * `path` :string : （可选项）数据库所在路径，不传时使用默认创建的路径。支持 fs://、widget://等协议（如fs://user.db）
	 *
	 * `password` :string : （必填项）数据库密码
	 */
	openDatabase(params:dbPlus_openDatabase_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `关闭数据库`
	 * ========params==========
	 *
	 * `name` :string : （必填项）数据库名称
	 */
	closeDatabase(params:dbPlus_closeDatabase_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `执行事务操作语句`
	 * ========params==========
	 *
	 * `name` :string : （必填项）数据库名称
	 *
	 * `operation` :string : （必填项）事务操作类型，取值范围如下：
	 */
	transaction(params:dbPlus_transaction_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `执行 sql`
	 * ========params==========
	 *
	 * `name` :string : （必填项）数据库名称
	 *
	 * `sql` :string : （必填项）sql 语句
	 */
	executeSql(params:dbPlus_executeSql_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `查询sql`
	 * ========params==========
	 *
	 * `name` :string : （必填项）数据库名称
	 *
	 * `sql` :string : （必填项）sql语句
	 */
	selectSql(params:dbPlus_selectSql_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `更改数据库密码`
	 * ========params==========
	 *
	 * `name` :string : （必填项）数据库名称
	 *
	 * `password` :string : （必填项）数据库新密码
	 */
	updatePassword(params:dbPlus_updatePassword_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取指定目录下的子文件`
	 * ========params==========
	 *
	 * `directory` :JSON : （可选项）目录路径，不传时使用 dbPlus 模块的默认路径。支持 fs://、widget://等协议（如fs://user.db）
	 */
	subfileSync(params:dbPlus_subfileSync_Params):void

	/**
	 * `打开数据库，若数据库不存在则创建数据库。`
	 * ========params==========
	 *
	 * `name` :string : （必填项）数据库名称
	 *
	 * `path` :string : （可选项）数据库所在路径，不传时使用默认创建的路径。支持 fs://、widget://等协议（如fs://user.db）
	 *
	 * `password` :JSON : （必填项）数据库密码
	 */
	openDatabaseSync(params:dbPlus_openDatabaseSync_Params):void

	/**
	 * `关闭数据库`
	 * ========params==========
	 *
	 * `name` :JSON : （必填项）数据库名称
	 */
	closeDatabaseSync(params:dbPlus_closeDatabaseSync_Params):void

	/**
	 * `执行事务操作语句`
	 * ========params==========
	 *
	 * `name` :string : （必填项）数据库名称
	 *
	 * `operation` :JSON : （必填项）事务操作类型，取值范围如下：
	 */
	transactionSync(params:dbPlus_transactionSync_Params):void

	/**
	 * `执行 sql`
	 * ========params==========
	 *
	 * `name` :string : （必填项）数据库名称
	 *
	 * `sql` :JSON : （必填项）sql 语句
	 */
	executeSqlSync(params:dbPlus_executeSqlSync_Params):void

	/**
	 * `查询 sql`
	 * ========params==========
	 *
	 * `name` :string : （必填项）数据库名称
	 *
	 * `sql` :JSON : （必填项）sql语句
	 */
	selectSqlSync(params:dbPlus_selectSqlSync_Params):void

}
interface dbPlus_subfile_Params {
	/**（可选项）目录路径，不传时使用 dbPlus 模块的默认路径。支持 fs://、widget://等协议（如fs://user.db）*/ 
	directory?:string,

}

interface dbPlus_openDatabase_Params {
	/**（必填项）数据库名称*/ 
	name:string,

	/**（可选项）数据库所在路径，不传时使用默认创建的路径。支持 fs://、widget://等协议（如fs://user.db）*/ 
	path?:string,

	/**（必填项）数据库密码*/ 
	password:string,

}

interface dbPlus_closeDatabase_Params {
	/**（必填项）数据库名称*/ 
	name:string,

}

interface dbPlus_transaction_Params {
	/**（必填项）数据库名称*/ 
	name:string,

	/**（必填项）事务操作类型，取值范围如下：*/ 
	operation:string,

}

interface dbPlus_executeSql_Params {
	/**（必填项）数据库名称*/ 
	name:string,

	/**（必填项）sql 语句*/ 
	sql:string,

}

interface dbPlus_selectSql_Params {
	/**（必填项）数据库名称*/ 
	name:string,

	/**（必填项）sql语句*/ 
	sql:string,

}

interface dbPlus_updatePassword_Params {
	/**（必填项）数据库名称*/ 
	name:string,

	/**（必填项）数据库新密码*/ 
	password:string,

}

interface dbPlus_subfileSync_Params {
	/**（可选项）目录路径，不传时使用 dbPlus 模块的默认路径。支持 fs://、widget://等协议（如fs://user.db）*/ 
	directory?:JSON,

}

interface dbPlus_openDatabaseSync_Params {
	/**（必填项）数据库名称*/ 
	name:string,

	/**（可选项）数据库所在路径，不传时使用默认创建的路径。支持 fs://、widget://等协议（如fs://user.db）*/ 
	path?:string,

	/**（必填项）数据库密码*/ 
	password:JSON,

}

interface dbPlus_closeDatabaseSync_Params {
	/**（必填项）数据库名称*/ 
	name:JSON,

}

interface dbPlus_transactionSync_Params {
	/**（必填项）数据库名称*/ 
	name:string,

	/**（必填项）事务操作类型，取值范围如下：*/ 
	operation:JSON,

}

interface dbPlus_executeSqlSync_Params {
	/**（必填项）数据库名称*/ 
	name:string,

	/**（必填项）sql 语句*/ 
	sql:JSON,

}

interface dbPlus_selectSqlSync_Params {
	/**（必填项）数据库名称*/ 
	name:string,

	/**（必填项）sql语句*/ 
	sql:JSON,

}

interface mam {
}
interface mcm {
}
interface msm {
	/** 获取认证信息*/ 
	getAuthInfo(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `证书申请`
	 * ========params==========
	 *
	 * `email` :string : 邮箱，不能为空
	 *
	 * `name` :string : 姓名
	 *
	 * `group` :string : 分组
	 *
	 * `description` :string : 申请说明
	 *
	 * `photo` :string : 证件照
	 */
	certApply(params:msm_certApply_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `认证码验证`
	 * ========params==========
	 *
	 * `authCode` :string : 认证码，不能为空
	 */
	certVerify(params:msm_certVerify_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `登录`
	 * ========params==========
	 *
	 * `userName` :string : 用户名，不能为空
	 *
	 * `password` :string : 密码，不能为空
	 */
	login(params:msm_login_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface msm_certApply_Params {
	/**邮箱，不能为空*/ 
	email:string,

	/**姓名*/ 
	name:string,

	/**分组*/ 
	group:string,

	/**申请说明*/ 
	description:string,

	/**证件照*/ 
	photo:string,

}

interface msm_certVerify_Params {
	/**认证码，不能为空*/ 
	authCode:string,

}

interface msm_login_Params {
	/**用户名，不能为空*/ 
	userName:string,

	/**密码，不能为空*/ 
	password:string,

}

interface push {
}
interface dropDownMenu {
	/**
	 * `打开菜单`
	 * ========params==========
	 *
	 * `rect` :JSON : （必填项）模块的位置及尺寸
	 *
	 * `fixedOn` :string : （可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 Window 或 Frame 滚动
	 *
	 * `data` :Array : （必填项）模块九宫格按钮图标和名称
	 *
	 * `textUnselectedColor` :boolean : （可选项）设置默认字体颜色代码
	 *
	 * `textSelectedColor` :string : （可选项）设置选中字体颜色代码
	 *
	 * `dropDownCheckedColor` :string : （可选项）设置列表选中后右侧颜色代码(仅iOS有效)
	 *
	 * `dropDownChecked` :string : （可选项）设置列表选中后右侧图标资源路径(支持fs:// widget://)（仅Android有效）
	 *
	 * `dropDownSelectedIcon` :string : （可选项）设置顶部列表选中后图标资源路径(支持fs:// widget://)
	 *
	 * `dropDownUnselectedIcon` :string : （可选项）设置顶部列表未选中图标资源路径(支持fs:// widget://)
	 */
	openMenu(params:dropDownMenu_openMenu_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 隐藏菜单*/ 
	hideMenu(callback?: (ret:JSON, err:JSON) => void):void

	/** 显示菜单*/ 
	showMenu():void

	/** 关闭菜单*/ 
	closeMenu(callback?: (ret:JSON, err:JSON) => void):void

}
interface dropDownMenu_openMenu_Params {
	/**（必填项）模块的位置及尺寸*/ 
	rect:JSON,

	/**（可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 Window 或 Frame 滚动*/ 
	fixed?:boolean,

	/**（必填项）模块九宫格按钮图标和名称*/ 
	data:Array,

	/**（可选项）设置默认字体颜色代码*/ 
	textUnselectedColor?:boolean,

	/**（可选项）设置选中字体颜色代码*/ 
	textSelectedColor?:string,

	/**（可选项）设置列表选中后右侧颜色代码(仅iOS有效)*/ 
	dropDownCheckedColor?:string,

	/**（可选项）设置列表选中后右侧图标资源路径(支持fs:// widget://)（仅Android有效）*/ 
	dropDownChecked?:string,

	/**（可选项）设置顶部列表选中后图标资源路径(支持fs:// widget://)*/ 
	dropDownSelectedIcon?:string,

	/**（可选项）设置顶部列表未选中图标资源路径(支持fs:// widget://)*/ 
	dropDownUnselectedIcon?:string,

}

interface NVNavigationBar {
	/**
	 * `打开`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `styles` :JSON : 模块样式配置
	 *
	 * `items` :Array<JSON> : 按钮项数据
	 *
	 * `selectedIndex` :number : （可选项）被选中的导航项的下标，不传表示不选中任何 item
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : 是否将模块视图固定到窗口上，不跟随窗口上下滚动
	 *
	 * `id` :string : 导航条的id
	 */
	open(params:NVNavigationBar_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `关闭`
	 * ========params==========
	 *
	 * `id` :string : 导航条的id
	 */
	close(params:NVNavigationBar_close_Params):void

	/**
	 * `隐藏`
	 * ========params==========
	 *
	 * `id` :string : 导航条的id
	 *
	 * `animation` :boolean : （可选项）显示是否添加动画（淡入淡出的动画）
	 *
	 * `orientation` :string : （可选项）动画的方向(top，bottom，left，right)
	 */
	hide(params:NVNavigationBar_hide_Params):void

	/**
	 * `显示`
	 * ========params==========
	 *
	 * `id` :string : null
	 *
	 * `animation` :boolean : （可选项）显示是否添加动画（淡入淡出的动画）
	 *
	 * `orientation` :string : （可选项）动画的方向(top，bottom，left，right)
	 */
	show(params:NVNavigationBar_show_Params):void

	/**
	 * `设置选中项`
	 * ========params==========
	 *
	 * `id` :string : 导航条的id
	 *
	 * `index` :number : 被选中的导航项的下标
	 *
	 * `selected` :boolean : 选中/取消选中
	 */
	setSelected(params:NVNavigationBar_setSelected_Params, callback?: (ret:JSON) => void):void

	/**
	 * `插入子项`
	 * ========params==========
	 *
	 * `id` :string : 导航条的id
	 *
	 * `index` :number : 插入的导航项的下标
	 *
	 * `item` :JSON : 按钮项数据
	 */
	insertItem(params:NVNavigationBar_insertItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `删除子项`
	 * ========params==========
	 *
	 * `id` :string : 导航条的id
	 *
	 * `index` :number : 要删除的导航项的下标
	 */
	deleteItem(params:NVNavigationBar_deleteItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `更新子项`
	 * ========params==========
	 *
	 * `id` :string : 导航条的id
	 *
	 * `index` :number : 更新的导航项的下标
	 *
	 * `item` :JSON : 按钮项数据
	 */
	updateItem(params:NVNavigationBar_updateItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `更新所有子项`
	 * ========params==========
	 *
	 * `id` :string : 导航条的id
	 *
	 * `items` :Array<JSON> : 按钮项数据
	 */
	update(params:NVNavigationBar_update_Params, callback?: (ret:JSON) => void):void

}
interface NVNavigationBar_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**模块样式配置*/ 
	styles:JSON,

	/**按钮项数据*/ 
	items:Array<JSON>,

	/**（可选项）被选中的导航项的下标，不传表示不选中任何 item*/ 
	selectedIndex?:number,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**是否将模块视图固定到窗口上，不跟随窗口上下滚动*/ 
	fixed:boolean,

	/**导航条的id*/ 
	id:string,

}

interface NVNavigationBar_close_Params {
	/**导航条的id*/ 
	id:string,

}

interface NVNavigationBar_hide_Params {
	/**导航条的id*/ 
	id:string,

	/**（可选项）显示是否添加动画（淡入淡出的动画）*/ 
	animation?:boolean,

	/**（可选项）动画的方向(top，bottom，left，right)*/ 
	orientation?:string,

}

interface NVNavigationBar_show_Params {
	/**null*/ 
	id:string,

	/**（可选项）显示是否添加动画（淡入淡出的动画）*/ 
	animation?:boolean,

	/**（可选项）动画的方向(top，bottom，left，right)*/ 
	orientation?:string,

}

interface NVNavigationBar_setSelected_Params {
	/**导航条的id*/ 
	id:string,

	/**被选中的导航项的下标*/ 
	index:number,

	/**选中/取消选中*/ 
	selected:boolean,

}

interface NVNavigationBar_insertItem_Params {
	/**导航条的id*/ 
	id:string,

	/**插入的导航项的下标*/ 
	index:number,

	/**按钮项数据*/ 
	item:JSON,

}

interface NVNavigationBar_deleteItem_Params {
	/**导航条的id*/ 
	id:string,

	/**要删除的导航项的下标*/ 
	index:number,

}

interface NVNavigationBar_updateItem_Params {
	/**导航条的id*/ 
	id:string,

	/**更新的导航项的下标*/ 
	index:number,

	/**按钮项数据*/ 
	item:JSON,

}

interface NVNavigationBar_update_Params {
	/**导航条的id*/ 
	id:string,

	/**按钮项数据*/ 
	items:Array<JSON>,

}

interface scrollRotation {
}
interface arcMenu {
	/**
	 * `控件显示在最上层（仅android支持）`
	 * ========params==========
	 *
	 * `id` :number : 要操作的控件id
	 */
	bringToFront(params:arcMenu_bringToFront_Params):void

}
interface arcMenu_bringToFront_Params {
	/**要操作的控件id*/ 
	id:number,

}

interface circularMenu {
}
interface tuberBar {
}
interface sideMenu {
	/**
	 * `隐藏菜单`
	 * ========params==========
	 *
	 * `id` :number : 要操作的菜单的id，不可为空
	 */
	hidden(params:sideMenu_hidden_Params):void

	/** 显示菜单*/ 
	show():void

	/** 关闭菜单*/ 
	close():void

}
interface sideMenu_hidden_Params {
	/**要操作的菜单的id，不可为空*/ 
	id:number,

}

interface navigationMenu {
}
interface navigationBar {
}
interface actionButton {
}
interface tabBarMenu {
}
interface bubbleMenu {
	/**
	 * `打开菜单`
	 * ========params==========
	 *
	 * `style` :JSON : （可选项）气泡样式设置
	 *
	 * `centerX` :number : （可选项）气泡菜单箭头点的坐标
	 *
	 * `centerY` :number : （可选项）气泡菜单箭头点的坐标
	 *
	 * `btnArray` :Array : 按钮的信息组成的数组
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 */
	open(params:bubbleMenu_open_Params, callback?: (ret:JSON) => void):void

	/** 隐藏菜单，只是隐藏，还在内存里没有清除*/ 
	hide():void

	/** 显示菜单*/ 
	show():void

	/** 关闭菜单，意味着从内存里清除*/ 
	close():void

	/** 添加对菜单状态的监听*/ 
	addEventListener():void

	/** 取消对菜单状态的监听*/ 
	cancelEventListener():void

}
interface bubbleMenu_open_Params {
	/**（可选项）气泡样式设置*/ 
	style?:JSON,

	/**（可选项）气泡菜单箭头点的坐标*/ 
	centerX?:number,

	/**（可选项）气泡菜单箭头点的坐标*/ 
	centerY?:number,

	/**按钮的信息组成的数组*/ 
	btnArray:Array,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

}

interface NVTabBarAnimation {
	/**
	 * `打开模块并显示`
	 * ========params==========
	 *
	 * `styles` :JSON : 模块样式配置
	 *
	 * `items` :number : 导航条子项配置，子项条数不能超过 5
	 *
	 * `selectedIndex` :number : （可选项）默认值为选中状态的按钮的索引，若不传则默认无选中项
	 */
	open(params:NVTabBarAnimation_open_Params, callback?: (ret:JSON) => void):void

	/** 隐藏模块（并没有从内存清除）*/ 
	hide():void

	/** 显示已隐藏的模块*/ 
	show():void

	/** 关闭模块，并从内存里清除*/ 
	close():void

	/**
	 * `设置按钮右上角的徽章`
	 * ========params==========
	 *
	 * `index` :number : null
	 *
	 * `badge` :string : null
	 */
	setBadge(params:NVTabBarAnimation_setBadge_Params):void

	/**
	 * `设置按钮 item 的属性`
	 * ========params==========
	 *
	 * `index` :number : （可选项）要设置的子项的索引
	 *
	 * `selected` :boolean : （可选项）要设置的子项按钮的选中状态，true：选中状态|false：非选中状态
	 *
	 * `icon` :JSON : （可选项）要设置的子项按钮的 icon 静态图标，若不传则显示原值
	 *
	 * `animationIcons` :JSON : （可选项）要设置的子项按钮的 icon 动态图标，若不传则显示原值
	 *
	 * `title` :JSON : （可选项）子项标题设置，若不传则显示原值
	 */
	setItemAttr(params:NVTabBarAnimation_setItemAttr_Params):void

	/** 将已经打开的模块置为最上层显示*/ 
	bringToFront():void

}
interface NVTabBarAnimation_open_Params {
	/**模块样式配置*/ 
	styles:JSON,

	/**导航条子项配置，子项条数不能超过 5*/ 
	items:number,

	/**（可选项）默认值为选中状态的按钮的索引，若不传则默认无选中项*/ 
	selectedIndex?:number,

}

interface NVTabBarAnimation_setBadge_Params {
	/**null*/ 
	index:number,

	/**null*/ 
	badge:string,

}

interface NVTabBarAnimation_setItemAttr_Params {
	/**（可选项）要设置的子项的索引*/ 
	index?:number,

	/**（可选项）要设置的子项按钮的选中状态，true：选中状态|false：非选中状态*/ 
	selected?:boolean,

	/**（可选项）要设置的子项按钮的 icon 静态图标，若不传则显示原值*/ 
	icon?:JSON,

	/**（可选项）要设置的子项按钮的 icon 动态图标，若不传则显示原值*/ 
	animationIcons?:JSON,

	/**（可选项）子项标题设置，若不传则显示原值*/ 
	title?:JSON,

}

interface MNActionButton {
}
interface MNRotationMenu {
	/** 清除缓存到本地的网络图片，**本接口只清除本模块缓存的数据，若要清除本app缓存的所有数据这调用api.clearCache***/ 
	clearCache():void

}
interface MNPopups {
}
interface stackMenu {
}
interface MNNavigationMenu {
}
interface MNStack {
}
interface NVTabBar {
	/**
	 * `打开模块并显示`
	 * ========params==========
	 *
	 * `styles` :JSON : 模块样式配置
	 *
	 * `items` :Array : 导航条子项配置，子项条数不能超过 5
	 *
	 * `cursorInOptions` :JSON : 选中项的游标(如当前激活状态的item底部显示5pt高度的色块) 若不传，该字段无效
	 *
	 * `selectedIndex` :number : （可选项）默认值为选中状态的按钮的索引，若不传则默认无选中项
	 *
	 * `enableDoubleClick` :boolean : 使能双击事件，默认：false
	 *
	 * `enableLongPressClick` :boolean : 是否使用长按事件，默认：false
	 */
	open(params:NVTabBar_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `隐藏模块（并没有从内存清除）`
	 * ========params==========
	 *
	 * `animation` :boolean : （可选项）显示是否添加动画（淡入淡出的动画）
	 */
	hide(params:NVTabBar_hide_Params):void

	/**
	 * `显示已隐藏的模块`
	 * ========params==========
	 *
	 * `animation` :boolean : （可选项）显示是否添加动画（淡入淡出的动画）
	 */
	show(params:NVTabBar_show_Params):void

	/** 关闭模块，并从内存里清除*/ 
	close():void

	/**
	 * `设置按钮右上角的徽章`
	 * ========params==========
	 *
	 * `index` :number : null
	 *
	 * `badge` :string : null
	 *
	 * `horizentalPadding` :number : null
	 */
	setBadge(params:NVTabBar_setBadge_Params):void

	/**
	 * `设置按钮的选中状态`
	 * ========params==========
	 *
	 * `index` :number : （可选项）要设置的子项的索引
	 *
	 * `selected` :boolean : （可选项）要设置的子项按钮的状态
	 *
	 * `icons` :Array : （可选项）设置子按钮的多图联播效果（gif图效果），若不传本参数则默认显示open接口内配置的图片
	 *
	 * `interval` :number : （可选项）动画帧之间的时间间隔（单位:毫秒 ms）
	 *
	 * `animatedRepetitions` :number : （可选项）设置动画重复次数（android仅支持循环一次和无线循环，即该参数只对1和0有效）
	 */
	setSelect(params:NVTabBar_setSelect_Params):void

	/** 将已经打开的模块置为最上层显示*/ 
	bringToFront():void

	/**
	 * `改变模块背景`
	 * ========params==========
	 *
	 * `bg` :number : （可选项）字符串类型；模块背景，支持 rgb、rgba、#、img
	 */
	changeBackground(params:NVTabBar_changeBackground_Params):void

}
interface NVTabBar_open_Params {
	/**模块样式配置*/ 
	styles:JSON,

	/**导航条子项配置，子项条数不能超过 5*/ 
	items:Array,

	/**选中项的游标(如当前激活状态的item底部显示5pt高度的色块) 若不传，该字段无效*/ 
	cursorInOptions:JSON,

	/**（可选项）默认值为选中状态的按钮的索引，若不传则默认无选中项*/ 
	selectedIndex?:number,

	/**使能双击事件，默认：false*/ 
	enableDoubleClick:boolean,

	/**是否使用长按事件，默认：false*/ 
	enableLongPressClick:boolean,

}

interface NVTabBar_hide_Params {
	/**（可选项）显示是否添加动画（淡入淡出的动画）*/ 
	animation?:boolean,

}

interface NVTabBar_show_Params {
	/**（可选项）显示是否添加动画（淡入淡出的动画）*/ 
	animation?:boolean,

}

interface NVTabBar_setBadge_Params {
	/**null*/ 
	index:number,

	/**null*/ 
	badge:string,

	/**null*/ 
	horizentalPadding:number,

}

interface NVTabBar_setSelect_Params {
	/**（可选项）要设置的子项的索引*/ 
	index?:number,

	/**（可选项）要设置的子项按钮的状态*/ 
	selected?:boolean,

	/**（可选项）设置子按钮的多图联播效果（gif图效果），若不传本参数则默认显示open接口内配置的图片*/ 
	icons?:Array,

	/**（可选项）动画帧之间的时间间隔（单位:毫秒 ms）*/ 
	interval?:number,

	/**（可选项）设置动画重复次数（android仅支持循环一次和无线循环，即该参数只对1和0有效）*/ 
	animatedRepetitions?:number,

}

interface NVTabBar_changeBackground_Params {
	/**（可选项）字符串类型；模块背景，支持 rgb、rgba、#、img*/ 
	bg?:number,

}

interface pullMenu {
}
interface tabBar {
}
interface columnBar {
	/**
	 * `打开栏目导航`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）浏览器窗口的位置和大小，设置margin后，在不同手机上面会保持与父页面的各方向边距一致，而中间区域会自动扩充。建议使用margin布局，可以完美适配带smartBar的手机。
	 *
	 * `fixedOn` :string : （可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window
	 *
	 * `fixed` :boolean : （（可选项）模块是否随所属 Window 或 Frame 滚动
	 *
	 * `allData` :Array : （必填项）导航条上所有选择项的集合;(数组内菜单名建议2-4个字为最佳效果)
	 *
	 * `showData` :Array : （必填项）导航条上显示的选择项的集合(数组内菜单名建议2-4个字为最佳效果)
	 *
	 * `maxShow` :any : （可选项）导航条上最多显示的选择项的个数.
	 *
	 * `isExpand` :any : （可选项）是否支持可扩展的功能,(0:不开启扩展，1:开启扩展).
	 *
	 * `showedLable` :boolean : （可选项）扩展栏目的已展示栏目标题
	 *
	 * `addLable` :boolean : （可选项）扩展栏目的可添加栏目标题
	 */
	open(params:columnBar_open_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `设置当前选中项`
	 * ========params==========
	 *
	 * `index` :any : （可选项）当前选中项的序号值。（备注：改值需要通过open接口返回的shows数组位置索引进行控制）。
	 */
	setCurrentItem(params:columnBar_setCurrentItem_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 隐藏导航菜单*/ 
	hide(callback?: (ret:JSON, err:JSON) => void):void

	/** 显示导航菜单*/ 
	show(callback?: (ret:JSON, err:JSON) => void):void

	/** 监听栏目item被点击*/ 
	onItemClick():void

	/** 监听栏目显示数据发生变化*/ 
	onDataChange():void

	/** 在扩展界面添加item时超过open设置的最大值数时回调*/ 
	outNumberMax():void

	/** 关闭导航菜单*/ 
	close(callback?: (ret:JSON, err:JSON) => void):void

}
interface columnBar_open_Params {
	/**（可选项）浏览器窗口的位置和大小，设置margin后，在不同手机上面会保持与父页面的各方向边距一致，而中间区域会自动扩充。建议使用margin布局，可以完美适配带smartBar的手机。*/ 
	rect?:JSON,

	/**（可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window*/ 
	fixedOn?:string,

	/**（（可选项）模块是否随所属 Window 或 Frame 滚动*/ 
	fixed?:boolean,

	/**（必填项）导航条上所有选择项的集合;(数组内菜单名建议2-4个字为最佳效果)*/ 
	allData:Array,

	/**（必填项）导航条上显示的选择项的集合(数组内菜单名建议2-4个字为最佳效果)*/ 
	showData:Array,

	/**（可选项）导航条上最多显示的选择项的个数.*/ 
	maxShow?:any,

	/**（可选项）是否支持可扩展的功能,(0:不开启扩展，1:开启扩展).*/ 
	isExpand?:any,

	/**（可选项）扩展栏目的已展示栏目标题*/ 
	showedLable?:boolean,

	/**（可选项）扩展栏目的可添加栏目标题*/ 
	addLable?:boolean,

}

interface columnBar_setCurrentItem_Params {
	/**（可选项）当前选中项的序号值。（备注：改值需要通过open接口返回的shows数组位置索引进行控制）。*/ 
	index?:any,

}

interface gesturePassword {
	/** 打开模块，此模块为任意绘制，开发时按照需求进行调用，本接口只返回用户输入的密码*/ 
	open(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `打开设置密码界面，根据要求进行相应提示。`
	 * ========params==========
	 *
	 * `rect` :JSON : 模块的位置及尺寸
	 *
	 * `bgColor` :string : （必须项）模块背景颜色，支持十六进制颜色系，如：#FFFFFF
	 *
	 * `color` :string : （必须项）元素触摸下的颜色，支持十六进制颜色系，如：#FFFFFF
	 *
	 * `unTouchColor` :string : （必须项）元素常态下的颜色，支持十六进制颜色系，如：#FFFFFF
	 *
	 * `saveInLocal` :number : 是否本机存储密码
	 *
	 * `pointDistance` :number : 每个触点元素之间的间隔
	 *
	 * `columns` :number : 每行（列）显示几个触摸圈元素
	 *
	 * `minLength` :number : 密码组成的元素最小数量
	 *
	 * `fixedOn` :string : 模块依附于当前 window
	 *
	 * `fixed` :boolean : 是否将模块视图固定到窗口上，不跟随窗口上下滚动，可为空
	 */
	openSetPassword(params:gesturePassword_openSetPassword_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `验证密码，可以验证之前保存在本地密码，也可以验证指定密码。`
	 * ========params==========
	 *
	 * `rect` :JSON : 模块的位置及尺寸
	 *
	 * `bgColor` :string : （必须项）模块背景颜色，支持十六进制颜色系，如：#FFFFFF
	 *
	 * `color` :string : （必须项）元素触摸下的颜色，支持十六进制颜色系，如：#FFFFFF
	 *
	 * `unTouchColor` :string : （必须项）元素常态下的颜色，支持十六进制颜色系，如：#FFFFFF
	 *
	 * `pointDistance` :number : 每个触点元素之间的间隔
	 *
	 * `columns` :number : 每行（列）显示几个触摸圈元素
	 *
	 * `mode` :number : 1表示和本机保存的密码进行匹对，2表示和指定的密码匹对
	 *
	 * `comparePassword` :string : 指定匹对的密码
	 *
	 * `fixedOn` :string : 模块依附于当前 window
	 *
	 * `fixed` :boolean : 是否将模块视图固定到窗口上，不跟随窗口上下滚动，可为空
	 */
	openCheckPassword(params:gesturePassword_openCheckPassword_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 关闭模块，并且释放。*/ 
	close(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `设置当前输入密码的所有元素的颜色。`
	 * ========params==========
	 *
	 * `color` :string : （必须项）元素以及指引线颜色，支持十六进制颜色系，如：#FFFFFF
	 */
	setTempColor(params:gesturePassword_setTempColor_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 本机是否已经设置了密码。*/ 
	isSettedPassword(callback?: (ret:JSON, err:JSON) => void):void

	/** 清空本地存储的密码。*/ 
	clearLocalPwd(callback?: (ret:JSON, err:JSON) => void):void

}
interface gesturePassword_openSetPassword_Params {
	/**模块的位置及尺寸*/ 
	rect:JSON,

	/**（必须项）模块背景颜色，支持十六进制颜色系，如：#FFFFFF*/ 
	bgColor:string,

	/**（必须项）元素触摸下的颜色，支持十六进制颜色系，如：#FFFFFF*/ 
	color:string,

	/**（必须项）元素常态下的颜色，支持十六进制颜色系，如：#FFFFFF*/ 
	unTouchColor:string,

	/**是否本机存储密码*/ 
	saveInLocal:number,

	/**每个触点元素之间的间隔*/ 
	pointDistance:number,

	/**每行（列）显示几个触摸圈元素*/ 
	columns:number,

	/**密码组成的元素最小数量*/ 
	minLength:number,

	/**模块依附于当前 window*/ 
	fixedOn:string,

	/**是否将模块视图固定到窗口上，不跟随窗口上下滚动，可为空*/ 
	fixed:boolean,

}

interface gesturePassword_openCheckPassword_Params {
	/**模块的位置及尺寸*/ 
	rect:JSON,

	/**（必须项）模块背景颜色，支持十六进制颜色系，如：#FFFFFF*/ 
	bgColor:string,

	/**（必须项）元素触摸下的颜色，支持十六进制颜色系，如：#FFFFFF*/ 
	color:string,

	/**（必须项）元素常态下的颜色，支持十六进制颜色系，如：#FFFFFF*/ 
	unTouchColor:string,

	/**每个触点元素之间的间隔*/ 
	pointDistance:number,

	/**每行（列）显示几个触摸圈元素*/ 
	columns:number,

	/**1表示和本机保存的密码进行匹对，2表示和指定的密码匹对*/ 
	mode:number,

	/**指定匹对的密码*/ 
	comparePassword:string,

	/**模块依附于当前 window*/ 
	fixedOn:string,

	/**是否将模块视图固定到窗口上，不跟随窗口上下滚动，可为空*/ 
	fixed:boolean,

}

interface gesturePassword_setTempColor_Params {
	/**（必须项）元素以及指引线颜色，支持十六进制颜色系，如：#FFFFFF*/ 
	color:string,

}

interface UIPullRefreshDrop {
	/** 配置下拉刷新样式*/ 
	setCustomRefreshHeaderInfo():void

	/** 手动开始下拉刷新的加载状态，**下拉刷新状态亦可通过用户手势下拉到阈值自动触发***/ 
	refreshHeaderLoading():void

	/** 手动停止下拉刷新的加载状态*/ 
	refreshHeaderLoadDone():void

}
interface doubleBarChart {
	/**
	 * `打开柱状图视图`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `yAxis` :JSON : 双柱状图的 Y 轴配置
	 *
	 * `data` :Array : 双柱状图关键结点的数据
	 *
	 * `styles` :any : （可选项）模块视图内元素样式配置
	 *
	 * `showData` :boolean : （可选项）是否显示每条柱子上的数据（数据样式通y轴标注字体样式）
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	open(params:doubleBarChart_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `重新加载数据`
	 * ========params==========
	 *
	 * `id` :number : 要刷新的模块的 id
	 *
	 * `type` :string : 更新数据的方式
	 *
	 * `data` :Array : 双柱状图关键结点的数据
	 */
	reloadData(params:doubleBarChart_reloadData_Params, callback?: (ret:JSON) => void):void

	/**
	 * `关闭柱状图（从内存里清除）`
	 * ========params==========
	 *
	 * `id` :number : 要关闭的模块的 id
	 */
	close(params:doubleBarChart_close_Params):void

	/**
	 * `隐藏柱状图视图，并未从内存里清除，可调用 show 接口显示该视图`
	 * ========params==========
	 *
	 * `id` :number : 要隐藏的模块的 id
	 */
	hide(params:doubleBarChart_hide_Params):void

	/**
	 * `显示已隐藏的柱状图视图`
	 * ========params==========
	 *
	 * `id` :number : 要显示的模块的 id
	 */
	show(params:doubleBarChart_show_Params):void

	/**
	 * `滚动到指定索引的条目，`
	 * ========params==========
	 *
	 * `id` :number : 模块的 id，用于区分模块的多个实例
	 *
	 * `index` :number : （可选项）指定的条目的索引，不可大于总条目数减去每屏显示个数，从0开始
	 *
	 * `animation` :boolean : （可选项）滚动时是否带有动画效果
	 */
	scrollTo(params:doubleBarChart_scrollTo_Params):void

}
interface doubleBarChart_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**双柱状图的 Y 轴配置*/ 
	yAxis:JSON,

	/**双柱状图关键结点的数据*/ 
	data:Array,

	/**（可选项）模块视图内元素样式配置*/ 
	styles?:any,

	/**（可选项）是否显示每条柱子上的数据（数据样式通y轴标注字体样式）*/ 
	showData?:boolean,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface doubleBarChart_reloadData_Params {
	/**要刷新的模块的 id*/ 
	id:number,

	/**更新数据的方式*/ 
	type:string,

	/**双柱状图关键结点的数据*/ 
	data:Array,

}

interface doubleBarChart_close_Params {
	/**要关闭的模块的 id*/ 
	id:number,

}

interface doubleBarChart_hide_Params {
	/**要隐藏的模块的 id*/ 
	id:number,

}

interface doubleBarChart_show_Params {
	/**要显示的模块的 id*/ 
	id:number,

}

interface doubleBarChart_scrollTo_Params {
	/**模块的 id，用于区分模块的多个实例*/ 
	id:number,

	/**（可选项）指定的条目的索引，不可大于总条目数减去每屏显示个数，从0开始*/ 
	index?:number,

	/**（可选项）滚动时是否带有动画效果*/ 
	animation?:boolean,

}

interface UICircleSlider {
	/**
	 * `打开 UICircleSlider`
	 * ========params==========
	 *
	 * `position` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `styles` :JSON : （可选项）模块的样式配置
	 *
	 * `anticlockwise` :boolean : （可选项）是否为逆时针  注意：Android 系统暂不支持设置逆时针方向
	 *
	 * `anchorLowestPoint` :boolean : （可选项）铆点（起点、对照点）是否为最低点（六点钟位置），否则为最高点（十二点钟位置）
	 *
	 * `startAngle` :number : （可选项）弧形选择器起点针对铆点的角度，配合
	 *
	 * `duringAngle` :number : （可选项）弧形选择器大小（起点到终点的角度）
	 *
	 * `value` :number : （可选项）开始时的默认值
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 */
	open(params:UICircleSlider_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭模块*/ 
	close():void

	/** 显示模块*/ 
	show():void

	/** 隐藏模块*/ 
	hide():void

	/** 获取 UICircleSlider 的值*/ 
	getValue():void

	/**
	 * `设置 UICircleSlider 的值`
	 * ========params==========
	 *
	 * `value` :number : 要设置的值，
	 */
	setValue(params:UICircleSlider_setValue_Params):void

	/**
	 * `设置轨道的颜色`
	 * ========params==========
	 *
	 * `color` :string : 要设置的颜色，支持rgb、rgba、#
	 */
	setTrackColor(params:UICircleSlider_setTrackColor_Params):void

	/**
	 * `设置划过的轨道的颜色`
	 * ========params==========
	 *
	 * `color` :string : 要设置的颜色，支持rgb、rgba、#
	 */
	setTintColor(params:UICircleSlider_setTintColor_Params):void

	/**
	 * `设置滑块的颜色`
	 * ========params==========
	 *
	 * `color` :string : 要设置的颜色，支持rgb、rgba、#
	 */
	setThumbColor(params:UICircleSlider_setThumbColor_Params):void

	/**
	 * `设置轨道的颜色`
	 * ========params==========
	 *
	 * `img` :string : 要设置的滑块图片路径，要求本地路径（widget://、fs://）
	 */
	setThumbImg(params:UICircleSlider_setThumbImg_Params):void

	/**
	 * `打开 UICircleSlider`
	 * ========params==========
	 *
	 * `name` :string : （可选项）监听事件名称
	 */
	addEventListener(params:UICircleSlider_addEventListener_Params, callback?: (ret:JSON) => void):void

}
interface UICircleSlider_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	position?:JSON,

	/**（可选项）模块的样式配置*/ 
	styles?:JSON,

	/**（可选项）是否为逆时针  注意：Android 系统暂不支持设置逆时针方向*/ 
	anticlockwise?:boolean,

	/**（可选项）铆点（起点、对照点）是否为最低点（六点钟位置），否则为最高点（十二点钟位置）*/ 
	anchorLowestPoint?:boolean,

	/**（可选项）弧形选择器起点针对铆点的角度，配合*/ 
	startAngle?:number,

	/**（可选项）弧形选择器大小（起点到终点的角度）*/ 
	duringAngle?:number,

	/**（可选项）开始时的默认值*/ 
	value?:number,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

}

interface UICircleSlider_setValue_Params {
	/**要设置的值，*/ 
	value:number,

}

interface UICircleSlider_setTrackColor_Params {
	/**要设置的颜色，支持rgb、rgba、#*/ 
	color:string,

}

interface UICircleSlider_setTintColor_Params {
	/**要设置的颜色，支持rgb、rgba、#*/ 
	color:string,

}

interface UICircleSlider_setThumbColor_Params {
	/**要设置的颜色，支持rgb、rgba、#*/ 
	color:string,

}

interface UICircleSlider_setThumbImg_Params {
	/**要设置的滑块图片路径，要求本地路径（widget://、fs://）*/ 
	img:string,

}

interface UICircleSlider_addEventListener_Params {
	/**（可选项）监听事件名称*/ 
	name?:string,

}

interface customSelector {
}
interface photoNews_tt {
	/** 关闭模块*/ 
	close():void

	/** 关闭模块*/ 
	clearCache():void

}
interface UIPullRefresh {
	/** 配置下拉刷新样式*/ 
	setCustomRefreshHeaderInfo():void

	/** 手动开始下拉刷新的加载状态，**下拉刷新状态亦可通过用户下拉到阈值自动触发***/ 
	refreshHeaderLoading():void

	/** 手动停止下拉刷新的加载状态*/ 
	refreshHeaderLoadDone():void

}
interface suspensionWindow {
	/** 初始化*/ 
	init():void

	/** - 类型：JSON对象*/ 
	getAppOps():void

	/** 创建一个悬浮窗口*/ 
	createWindow(callback?: (ret:JSON) => void):void

	/** 显示悬浮窗*/ 
	show():void

	/** 更新悬浮窗*/ 
	updateWindow():void

}
interface dtCarKeyBoard {
	/**
	 * `打开 dtCarKeyBoard 模块，该模块依附于keywindow之上，打开后，点击键盘上方空白处，会隐藏键盘。`
	 * ========params==========
	 *
	 * `defaultPlate` :string : （可选项）默认车牌号码，长度在0-8之间，否则不生效，如果长度等于8，则是新能源车牌号
	 *
	 * `defaultIndex` :any : （可选项）键盘输入的初始位置索引，该数据范围：新能源在0-7之间，否则在0-6之间，该范围以外的数将会被强制更改为0
	 *
	 * `isEnergy` :boolean : （可选项）是否输入新能源车牌号
	 *
	 * `showInput` :boolean : （可选项）是否在键盘上显示输入栏，输入栏可以动态切换新能源
	 *
	 * `tintColor` :string : （可选项）键盘上的输入栏的相对色调，如果showInput=false，则不生效
	 *
	 * `autoHide` :boolean : （可选项）车牌号输入完成后，是否自动检测车牌号的正确性，如果车牌合法，则自动隐藏键盘
	 */
	open(params:dtCarKeyBoard_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭键盘*/ 
	close():void

	/** 显示键盘*/ 
	show():void

	/** 隐藏键盘*/ 
	hide():void

}
interface dtCarKeyBoard_open_Params {
	/**（可选项）默认车牌号码，长度在0-8之间，否则不生效，如果长度等于8，则是新能源车牌号*/ 
	defaultPlate?:string,

	/**（可选项）键盘输入的初始位置索引，该数据范围：新能源在0-7之间，否则在0-6之间，该范围以外的数将会被强制更改为0*/ 
	defaultIndex?:any,

	/**（可选项）是否输入新能源车牌号*/ 
	isEnergy?:boolean,

	/**（可选项）是否在键盘上显示输入栏，输入栏可以动态切换新能源*/ 
	showInput?:boolean,

	/**（可选项）键盘上的输入栏的相对色调，如果showInput=false，则不生效*/ 
	tintColor?:string,

	/**（可选项）车牌号输入完成后，是否自动检测车牌号的正确性，如果车牌合法，则自动隐藏键盘*/ 
	autoHide?:boolean,

}

interface soundIndicator {
	/**
	 * `打开模块`
	 * ========params==========
	 *
	 * `sID` :string : （可选项）模块的id，同一个页面支持打开多个模块，通过此ID执行其它操作
	 *
	 * `center` :JSON : （可选项）指示器锚点坐标
	 *
	 * `height` :number : （可选项）模块高度
	 *
	 * `strip` :JSON : （可选项）指示条配置
	 *
	 * `alphas` :Array : （可选项）单条指示器每个指示条的透明度组成的数组。本数组顺序同 orientation 指示的方向。
	 *
	 * `gradientColors` :Array : （可选项）单条指示器每个指示条的顶部和底部色值配置组成的数组，模块会将两色值渐变处理，渐变色分界点是从上往下30%的位置。本数组顺序同 orientation 指示的方向。
	 *
	 * `orientation` :string : （可选项）指示波传递方向
	 *
	 * `bg` :string : （可选项）录音标识的背景色，支持 rgb，rgba，#
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	open(params:soundIndicator_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `关闭soundIndicator按钮，注意关闭按钮并不能停止投屏`
	 * ========params==========
	 *
	 * `sID` :string : 模块的id
	 */
	close(params:soundIndicator_close_Params):void

	/**
	 * `隐藏soundIndicator按钮`
	 * ========params==========
	 *
	 * `sID` :string : 模块的id
	 */
	hide(params:soundIndicator_hide_Params):void

	/**
	 * `显示soundIndicator按钮`
	 * ========params==========
	 *
	 * `sID` :string : 模块的id
	 */
	show(params:soundIndicator_show_Params):void

	/**
	 * `设置振幅值`
	 * ========params==========
	 *
	 * `sID` :string : 模块的id
	 *
	 * `value` :number : 波动振幅，0-100
	 */
	setValue(params:soundIndicator_setValue_Params):void

}
interface soundIndicator_open_Params {
	/**（可选项）模块的id，同一个页面支持打开多个模块，通过此ID执行其它操作*/ 
	sID?:string,

	/**（可选项）指示器锚点坐标*/ 
	center?:JSON,

	/**（可选项）模块高度*/ 
	height?:number,

	/**（可选项）指示条配置*/ 
	strip?:JSON,

	/**（可选项）单条指示器每个指示条的透明度组成的数组。本数组顺序同 orientation 指示的方向。*/ 
	alphas?:Array,

	/**（可选项）单条指示器每个指示条的顶部和底部色值配置组成的数组，模块会将两色值渐变处理，渐变色分界点是从上往下30%的位置。本数组顺序同 orientation 指示的方向。*/ 
	gradientColors?:Array,

	/**（可选项）指示波传递方向*/ 
	orientation?:string,

	/**（可选项）录音标识的背景色，支持 rgb，rgba，#*/ 
	bg?:string,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface soundIndicator_close_Params {
	/**模块的id*/ 
	sID:string,

}

interface soundIndicator_hide_Params {
	/**模块的id*/ 
	sID:string,

}

interface soundIndicator_show_Params {
	/**模块的id*/ 
	sID:string,

}

interface soundIndicator_setValue_Params {
	/**模块的id*/ 
	sID:string,

	/**波动振幅，0-100*/ 
	value:number,

}

interface miCalendar {
	/**
	 * `打开日历`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `currentDateTitle` :JSON : (可选项)当前日期的位置和尺寸
	 *
	 * `styles` :JSON : （可选项）模块各部分的样式
	 *
	 * `specialDate` :Array : （可选项）需要标记的特殊假期数组
	 *
	 * `isLunarCalendar` :boolean : （可选项）是否显示农历
	 *
	 * `scrollEnabled` :boolean : （可选项）是否允许左右滑动切换
	 *
	 * `isToday` :boolean : （可选项）日期选中后，设备当前日期样式是否消失，设置为true后，日期选中后，设备当前日期样式消失，选中设备当前日期后，样式显示为选中日期样式
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	open(params:miCalendar_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `设置特殊日期`
	 * ========params==========
	 *
	 * `specialDates` :Array : 需要标记的特殊假期数组，格式为：yyyy-MM-dd
	 */
	setSpecialDates(params:miCalendar_setSpecialDates_Params):void

	/**
	 * `取消已设置的特殊假期状态`
	 * ========params==========
	 *
	 * `specialDates` :Array : 需要取消的特殊假期组成的数组，格式为：yyyy-MM-dd
	 */
	cancelSpecialDates(params:miCalendar_cancelSpecialDates_Params):void

	/** 关闭日历*/ 
	close():void

	/** 显示日历*/ 
	show():void

	/** 隐藏日历*/ 
	hide():void

	/** 显示下个月*/ 
	nextMonth():void

	/** 显示上个月*/ 
	prevMonth():void

	/**
	 * `设置选中日期(可通过此接口实现翻页效果)`
	 * ========params==========
	 *
	 * `date` :string : （可选项）选中日期，格式为：yyyy-MM-dd
	 *
	 * `ignoreSelected` :boolean : （可选项）选中日期是否忽略选中日期样式（open -> styles -> date -> selectedColor、selectedBg）
	 */
	setDate(params:miCalendar_setDate_Params, callback?: (ret:JSON) => void):void

}
interface miCalendar_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**(可选项)当前日期的位置和尺寸*/ 
	currentDateTitle?:JSON,

	/**（可选项）模块各部分的样式*/ 
	styles?:JSON,

	/**（可选项）需要标记的特殊假期数组*/ 
	specialDate?:Array,

	/**（可选项）是否显示农历*/ 
	isLunarCalendar?:boolean,

	/**（可选项）是否允许左右滑动切换*/ 
	scrollEnabled?:boolean,

	/**（可选项）日期选中后，设备当前日期样式是否消失，设置为true后，日期选中后，设备当前日期样式消失，选中设备当前日期后，样式显示为选中日期样式*/ 
	isToday?:boolean,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface miCalendar_setSpecialDates_Params {
	/**需要标记的特殊假期数组，格式为：yyyy-MM-dd*/ 
	specialDates:Array,

}

interface miCalendar_cancelSpecialDates_Params {
	/**需要取消的特殊假期组成的数组，格式为：yyyy-MM-dd*/ 
	specialDates:Array,

}

interface miCalendar_setDate_Params {
	/**（可选项）选中日期，格式为：yyyy-MM-dd*/ 
	date?:string,

	/**（可选项）选中日期是否忽略选中日期样式（open -> styles -> date -> selectedColor、selectedBg）*/ 
	ignoreSelected?:boolean,

}

interface zjCartList {
	/**
	 * `打开并初始化 zjCartList 模块`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `data` :Array : 列表的数据源
	 *
	 * `rightBtns` :Array : （可选项）列表项向左滑动露出的按钮组，**建议：配置列表每项的通用按钮，用此参数；配置某一项的特定按钮，可在 `data` 数组的指定项传入 `rightBtns` 参数**
	 *
	 * `bounces` :boolean : （可选项）是否开启弹动，android 平台不支持本参数
	 *
	 * `styles` :string : （可选项）模块各部分的样式
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `showScrollBar` :boolean : （可选项）是否显示滚动条
	 */
	open(params:zjCartList_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭购物车列表模块*/ 
	close():void

	/** 显示购物车列表模块*/ 
	show():void

	/** 隐藏购物车列表模块*/ 
	hide():void

	/**
	 * `选中商品`
	 * ========params==========
	 *
	 * `item` :Array : （可选项）选中商品，如果不传递此参数则默认选中全部商品
	 */
	selectItem(params:zjCartList_selectItem_Params, callback?: (ret:JSON) => void):void

	/** 获取已选中的商品数据*/ 
	getSelectedItem():void

	/**
	 * `取消选中商品`
	 * ========params==========
	 *
	 * `item` :Array : （可选项）要取消选中的商品ID，如果不传递此参数则默认取消选中全部商品
	 */
	cancelSelectItem(params:zjCartList_cancelSelectItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `刷新列表数据，刷新数据后之前的选中状态会被清空，需要重新设置选中`
	 * ========params==========
	 *
	 * `data` :Array : （可选项）列表的数据源，**若不传或传空，仅收起下拉刷新组件**
	 */
	reloadData(params:zjCartList_reloadData_Params, callback?: (ret:JSON) => void):void

	/**
	 * `设置下拉刷新，**通过 reloadData 收起下拉刷新组件**`
	 * ========params==========
	 *
	 * `loadingImg` :string : 下拉刷新时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）
	 *
	 * `bgColor` :string : （可选项）下拉刷新区域的背景色，支持 rgb、rgba、#
	 *
	 * `textColor` :string : （可选项）提示文字颜色，支持 rgb、rgba、#
	 *
	 * `textDown` :string : （可选项）下拉提示文字
	 *
	 * `textUp` :string : （可选项）松开提示文字
	 *
	 * `loadingText` :string : （可选项）提示文字
	 *
	 * `lastUpdateText` :string : （可选项）提示文字
	 *
	 * `showTime` :boolean : （可选项）是否显示刷新时间
	 */
	setRefreshHeader(params:zjCartList_setRefreshHeader_Params):void

}
interface zjCartList_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**列表的数据源*/ 
	data:Array,

	/**（可选项）列表项向左滑动露出的按钮组，**建议：配置列表每项的通用按钮，用此参数；配置某一项的特定按钮，可在 `data` 数组的指定项传入 `rightBtns` 参数***/ 
	rightBtns?:Array,

	/**（可选项）是否开启弹动，android 平台不支持本参数*/ 
	bounces?:boolean,

	/**（可选项）模块各部分的样式*/ 
	styles?:string,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）是否显示滚动条*/ 
	showScrollBar?:boolean,

}

interface zjCartList_selectItem_Params {
	/**（可选项）选中商品，如果不传递此参数则默认选中全部商品*/ 
	item?:Array,

}

interface zjCartList_cancelSelectItem_Params {
	/**（可选项）要取消选中的商品ID，如果不传递此参数则默认取消选中全部商品*/ 
	item?:Array,

}

interface zjCartList_reloadData_Params {
	/**（可选项）列表的数据源，**若不传或传空，仅收起下拉刷新组件***/ 
	data?:Array,

}

interface zjCartList_setRefreshHeader_Params {
	/**下拉刷新时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）*/ 
	loadingImg:string,

	/**（可选项）下拉刷新区域的背景色，支持 rgb、rgba、#*/ 
	bgColor?:string,

	/**（可选项）提示文字颜色，支持 rgb、rgba、#*/ 
	textColor?:string,

	/**（可选项）下拉提示文字*/ 
	textDown?:string,

	/**（可选项）松开提示文字*/ 
	textUp?:string,

	/**（可选项）提示文字*/ 
	loadingText?:string,

	/**（可选项）提示文字*/ 
	lastUpdateText?:string,

	/**（可选项）是否显示刷新时间*/ 
	showTime?:boolean,

}

interface UIListMeeting {
	/**
	 * `打开 UIListMeeting 模块`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `data` :Array : 列表的数据源，**开发者可以在本参数内自定义添加唯一的键值对信息（如：uid: '1001'），供 getIndex 使用**
	 *
	 * `rightBtns` :Array : （可选项）列表项向左滑动露出的按钮组，按钮从右往左排列。**注意：配置列表每项的通用按钮，用此参数；若配置某一项的特定按钮，可在 `data` 数组的指定项传入 `rightBtns` 参数**
	 *
	 * `bounces` :boolean : （可选项）是否开启弹动，android 平台不支持本参数
	 *
	 * `styles` :string : （可选项）模块每项的样式
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `showScrollBar` :boolean : （可选项）是否显示滚动条
	 */
	open(params:UIListMeeting_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `重设 UIListMeeting 模块的位置和大小（rect）`
	 * ========params==========
	 *
	 * `id` :number : (可选项) 要重设的模块的 id,当id不传的时候就重设当前打开的模块。
	 *
	 * `rect` :JSON : 要重设的模块的位置及尺寸
	 */
	resetRect(params:UIListMeeting_resetRect_Params):void

	/**
	 * `关闭数据列表模块`
	 * ========params==========
	 *
	 * `id` :number : (可选项)要关闭的模块的 id ,当id不传的时候就关闭当前打开的模块。
	 */
	close(params:UIListMeeting_close_Params):void

	/**
	 * `显示 UIListMeeting 模块`
	 * ========params==========
	 *
	 * `id` :number : (可选项)要显示的模块的 id ,当id不传的时候就显示当前打开的模块。
	 */
	show(params:UIListMeeting_show_Params):void

	/**
	 * `隐藏 UIListMeeting 模块`
	 * ========params==========
	 *
	 * `id` :number : (可选项)要隐藏的模块的 id ,当id不传的时候就隐藏当前打开的模块。
	 */
	hide(params:UIListMeeting_hide_Params):void

	/**
	 * `根据开发者自定义的唯一标识（open 接口的 data 参数中自定义的唯一标识）查找列表项对应的数据`
	 * ========params==========
	 *
	 * `id` :number : (可选项)列表项对应的模块的 id ,当id不传的时候就设置当前打开的模块。
	 *
	 * `key` :string : 调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 key
	 *
	 * `value` :string : 调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 value
	 */
	getIndex(params:UIListMeeting_getIndex_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据列表项的索引获取对应的数据`
	 * ========params==========
	 *
	 * `id` :number : (可选项)列表项的索引对应的模块的 id ,当id不传的时候就设置当前打开的模块。
	 *
	 * `index` :number : （可选项）列表项的索引
	 */
	getDataByIndex(params:UIListMeeting_getDataByIndex_Params, callback?: (ret:JSON) => void):void

	/**
	 * `设置侧滑显示出来的按钮`
	 * ========params==========
	 *
	 * `id` :number : (可选项)列表项侧滑露出的按钮组的模块的 id,当id不传的时候就设置当前打开的模块。
	 *
	 * `index` :number : （可选项）列表项的索引
	 *
	 * `btns` :Array : （可选项）列表项侧滑露出的按钮组
	 */
	setSwipeBtns(params:UIListMeeting_setSwipeBtns_Params, callback?: (ret:JSON) => void):void

	/**
	 * `刷新列表数据`
	 * ========params==========
	 *
	 * `id` :number : (可选项)要刷新列表的模块的 id,当id不传的时候就刷新当前打开的模块。
	 *
	 * `data` :Array : （可选项）列表的数据源，**若不传或传空，仅收起下拉刷新组件**
	 */
	reloadData(params:UIListMeeting_reloadData_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引删除某一条列表的数据`
	 * ========params==========
	 *
	 * `id` :number : (可选项)索引删除某一条列表的模块的 id,当id不传的时候就设置当前打开的模块。
	 *
	 * `index` :number : （可选项）数据列表的索引
	 */
	deleteItem(params:UIListMeeting_deleteItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引更新某一条列表的数据`
	 * ========params==========
	 *
	 * `id` :number : (可选项)根据索引更新某一条列表的模块的 id,当id不传的时候就设置当前打开的模块。
	 *
	 * `index` :number : （可选项）数据列表的索引
	 *
	 * `data` :JSON : 列表的数据源
	 */
	updateItem(params:UIListMeeting_updateItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引向某一条列表插入数据`
	 * ========params==========
	 *
	 * `id` :number : (可选项)根据索引更新某一条列表的模块的 id,当id不传的时候就设置当前打开的模块。
	 *
	 * `index` :number : （可选项）数据列表的索引
	 *
	 * `data` :JSON : 列表的数据源
	 */
	insertItem(params:UIListMeeting_insertItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `向列表末端追加数据`
	 * ========params==========
	 *
	 * `data` :Array : 列表的数据源，**若不传或传空，仅收起上拉加载组件**
	 */
	appendData(params:UIListMeeting_appendData_Params, callback?: (ret:JSON) => void):void

	/** 获取当前列表的总数据量*/ 
	getCount(callback?: (ret:JSON) => void):void

	/**
	 * `设置下拉刷新，**通过 reloadData 收起下拉刷新组件**`
	 * ========params==========
	 *
	 * `id` :number : (可选项)要下拉刷新的模块的 id,当id不传的时候就设置当前打开的模块。
	 *
	 * `loadingImg` :string : 下拉刷新时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）
	 *
	 * `bgColor` :string : （可选项）下拉刷新区域的背景色，支持 rgb、rgba、#
	 *
	 * `textColor` :string : （可选项）提示文字颜色，支持 rgb、rgba、#
	 *
	 * `textDown` :string : （可选项）下拉提示文字
	 *
	 * `textUp` :string : （可选项）松开提示文字
	 *
	 * `showTime` :boolean : （可选项）是否显示刷新时间
	 */
	setRefreshHeader(params:UIListMeeting_setRefreshHeader_Params):void

	/**
	 * `设置上拉加载，**通过 appendData 收起上拉加载组件**`
	 * ========params==========
	 *
	 * `loadingImg` :string : 上拉加载时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）
	 *
	 * `bgColor` :string : （可选项）上拉加载区域的背景色，支持 rgb、rgba、#
	 *
	 * `textColor` :string : （可选项）提示文字颜色，支持 rgb、rgba、#
	 *
	 * `textUp` :string : （可选项）上拉提示文字
	 *
	 * `textDown` :string : （可选项）松开提示文字
	 *
	 * `showTime` :boolean : （可选项）是否显示刷新时间
	 */
	setRefreshFooter(params:UIListMeeting_setRefreshFooter_Params):void

}
interface UIListMeeting_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**列表的数据源，**开发者可以在本参数内自定义添加唯一的键值对信息（如：uid: '1001'），供 getIndex 使用***/ 
	data:Array,

	/**（可选项）列表项向左滑动露出的按钮组，按钮从右往左排列。**注意：配置列表每项的通用按钮，用此参数；若配置某一项的特定按钮，可在 `data` 数组的指定项传入 `rightBtns` 参数***/ 
	rightBtns?:Array,

	/**（可选项）是否开启弹动，android 平台不支持本参数*/ 
	bounces?:boolean,

	/**（可选项）模块每项的样式*/ 
	styles?:string,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）是否显示滚动条*/ 
	showScrollBar?:boolean,

}

interface UIListMeeting_resetRect_Params {
	/**(可选项) 要重设的模块的 id,当id不传的时候就重设当前打开的模块。*/ 
	id?:number,

	/**要重设的模块的位置及尺寸*/ 
	rect:JSON,

}

interface UIListMeeting_close_Params {
	/**(可选项)要关闭的模块的 id ,当id不传的时候就关闭当前打开的模块。*/ 
	id?:number,

}

interface UIListMeeting_show_Params {
	/**(可选项)要显示的模块的 id ,当id不传的时候就显示当前打开的模块。*/ 
	id?:number,

}

interface UIListMeeting_hide_Params {
	/**(可选项)要隐藏的模块的 id ,当id不传的时候就隐藏当前打开的模块。*/ 
	id?:number,

}

interface UIListMeeting_getIndex_Params {
	/**(可选项)列表项对应的模块的 id ,当id不传的时候就设置当前打开的模块。*/ 
	id?:number,

	/**调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 key*/ 
	key:string,

	/**调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 value*/ 
	value:string,

}

interface UIListMeeting_getDataByIndex_Params {
	/**(可选项)列表项的索引对应的模块的 id ,当id不传的时候就设置当前打开的模块。*/ 
	id?:number,

	/**（可选项）列表项的索引*/ 
	index?:number,

}

interface UIListMeeting_setSwipeBtns_Params {
	/**(可选项)列表项侧滑露出的按钮组的模块的 id,当id不传的时候就设置当前打开的模块。*/ 
	id?:number,

	/**（可选项）列表项的索引*/ 
	index?:number,

	/**（可选项）列表项侧滑露出的按钮组*/ 
	btns?:Array,

}

interface UIListMeeting_reloadData_Params {
	/**(可选项)要刷新列表的模块的 id,当id不传的时候就刷新当前打开的模块。*/ 
	id?:number,

	/**（可选项）列表的数据源，**若不传或传空，仅收起下拉刷新组件***/ 
	data?:Array,

}

interface UIListMeeting_deleteItem_Params {
	/**(可选项)索引删除某一条列表的模块的 id,当id不传的时候就设置当前打开的模块。*/ 
	id?:number,

	/**（可选项）数据列表的索引*/ 
	index?:number,

}

interface UIListMeeting_updateItem_Params {
	/**(可选项)根据索引更新某一条列表的模块的 id,当id不传的时候就设置当前打开的模块。*/ 
	id?:number,

	/**（可选项）数据列表的索引*/ 
	index?:number,

	/**列表的数据源*/ 
	data:JSON,

}

interface UIListMeeting_insertItem_Params {
	/**(可选项)根据索引更新某一条列表的模块的 id,当id不传的时候就设置当前打开的模块。*/ 
	id?:number,

	/**（可选项）数据列表的索引*/ 
	index?:number,

	/**列表的数据源*/ 
	data:JSON,

}

interface UIListMeeting_appendData_Params {
	/**列表的数据源，**若不传或传空，仅收起上拉加载组件***/ 
	data:Array,

}

interface UIListMeeting_setRefreshHeader_Params {
	/**(可选项)要下拉刷新的模块的 id,当id不传的时候就设置当前打开的模块。*/ 
	id?:number,

	/**下拉刷新时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）*/ 
	loadingImg:string,

	/**（可选项）下拉刷新区域的背景色，支持 rgb、rgba、#*/ 
	bgColor?:string,

	/**（可选项）提示文字颜色，支持 rgb、rgba、#*/ 
	textColor?:string,

	/**（可选项）下拉提示文字*/ 
	textDown?:string,

	/**（可选项）松开提示文字*/ 
	textUp?:string,

	/**（可选项）是否显示刷新时间*/ 
	showTime?:boolean,

}

interface UIListMeeting_setRefreshFooter_Params {
	/**上拉加载时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）*/ 
	loadingImg:string,

	/**（可选项）上拉加载区域的背景色，支持 rgb、rgba、#*/ 
	bgColor?:string,

	/**（可选项）提示文字颜色，支持 rgb、rgba、#*/ 
	textColor?:string,

	/**（可选项）上拉提示文字*/ 
	textUp?:string,

	/**（可选项）松开提示文字*/ 
	textDown?:string,

	/**（可选项）是否显示刷新时间*/ 
	showTime?:boolean,

}

interface UIListView {
	/**
	 * `打开 UIListView 模块`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `data` :Array : 列表的数据源，**开发者可以自定义唯一的键值对信息（如：uid: '1001'），供 getIndex 使用**
	 *
	 * `rightBtns` :Array : （可选项）列表项向左滑动露出的按钮组，**建议：配置列表每项的通用按钮，用此参数；配置某一项的特定按钮，可在 `data` 数组的指定项传入 `rightBtns` 参数**
	 *
	 * `bounces` :boolean : （可选项）是否开启弹动，android 平台不支持本参数
	 *
	 * `styles` :string : （可选项）模块各部分的样式
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `showScrollBar` :boolean : （可选项）是否显示滚动条
	 */
	open(params:UIListView_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭数据列表模块*/ 
	close():void

	/** 显示 UIListView 模块*/ 
	show():void

	/** 隐藏 UIListView 模块*/ 
	hide():void

	/**
	 * `设置列表的纵坐标和高度`
	 * ========params==========
	 *
	 * `y` :number : （可选项）模块的纵坐标
	 *
	 * `h` :number : （可选项）模块的高度
	 */
	setAttr(params:UIListView_setAttr_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据开发者自定义的唯一标识（open 接口的 data 参数中自定义的唯一标识）查找列表项对应的数据`
	 * ========params==========
	 *
	 * `key` :string : 调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 key
	 *
	 * `value` :string : 调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 value
	 */
	getIndex(params:UIListView_getIndex_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据列表项的索引获取对应的数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）列表项的索引
	 */
	getDataByIndex(params:UIListView_getDataByIndex_Params, callback?: (ret:JSON) => void):void

	/**
	 * `设置侧滑显示出来的按钮`
	 * ========params==========
	 *
	 * `index` :number : （可选项）列表项的索引
	 *
	 * `btns` :Array : （可选项）列表项侧滑露出的按钮组
	 */
	setSwipeBtns(params:UIListView_setSwipeBtns_Params, callback?: (ret:JSON) => void):void

	/**
	 * `刷新列表数据`
	 * ========params==========
	 *
	 * `data` :Array : （可选项）列表的数据源，**若不传或传空，仅收起下拉刷新组件**
	 */
	reloadData(params:UIListView_reloadData_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引删除某一条列表的数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）数据列表的索引
	 */
	deleteItem(params:UIListView_deleteItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引更新某一条列表的数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）数据列表的索引
	 *
	 * `data` :JSON : 列表的数据源
	 */
	updateItem(params:UIListView_updateItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引向某一条列表插入数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）数据列表的索引
	 *
	 * `data` :JSON : 列表的数据源
	 */
	insertItem(params:UIListView_insertItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `向列表末端追加数据`
	 * ========params==========
	 *
	 * `data` :Array : 列表的数据源，**若不传或传空，仅收起上拉加载组件**
	 */
	appendData(params:UIListView_appendData_Params, callback?: (ret:JSON) => void):void

	/** 获取当前列表的总数据量*/ 
	getCount():void

	/**
	 * `设置下拉刷新，**通过 reloadData 收起下拉刷新组件**`
	 * ========params==========
	 *
	 * `loadingImg` :string : 下拉刷新时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）
	 *
	 * `bgColor` :string : （可选项）下拉刷新区域的背景色，支持 rgb、rgba、#
	 *
	 * `textColor` :string : （可选项）提示文字颜色，支持 rgb、rgba、#
	 *
	 * `textDown` :string : （可选项）下拉提示文字
	 *
	 * `textUp` :string : （可选项）松开提示文字
	 *
	 * `loadingText` :string : （可选项）提示文字
	 *
	 * `lastUpdateText` :string : （可选项）提示文字
	 *
	 * `showTime` :boolean : （可选项）是否显示刷新时间
	 */
	setRefreshHeader(params:UIListView_setRefreshHeader_Params):void

	/**
	 * `设置上拉加载，**通过 appendData 收起上拉加载组件**`
	 * ========params==========
	 *
	 * `loadingImg` :string : 上拉加载时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）
	 *
	 * `bgColor` :string : （可选项）上拉加载区域的背景色，支持 rgb、rgba、#
	 *
	 * `textColor` :string : （可选项）提示文字颜色，支持 rgb、rgba、#
	 *
	 * `textUp` :string : （可选项）上拉提示文字
	 *
	 * `textDown` :string : （可选项）松开提示文字
	 *
	 * `loadingText` :string : （可选项）提示文字
	 *
	 * `lastUpdateText` :string : （可选项）提示文字
	 *
	 * `showTime` :boolean : （可选项）是否显示刷新时间
	 */
	setRefreshFooter(params:UIListView_setRefreshFooter_Params):void

}
interface UIListView_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**列表的数据源，**开发者可以自定义唯一的键值对信息（如：uid: '1001'），供 getIndex 使用***/ 
	data:Array,

	/**（可选项）列表项向左滑动露出的按钮组，**建议：配置列表每项的通用按钮，用此参数；配置某一项的特定按钮，可在 `data` 数组的指定项传入 `rightBtns` 参数***/ 
	rightBtns?:Array,

	/**（可选项）是否开启弹动，android 平台不支持本参数*/ 
	bounces?:boolean,

	/**（可选项）模块各部分的样式*/ 
	styles?:string,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）是否显示滚动条*/ 
	showScrollBar?:boolean,

}

interface UIListView_setAttr_Params {
	/**（可选项）模块的纵坐标*/ 
	y?:number,

	/**（可选项）模块的高度*/ 
	h?:number,

}

interface UIListView_getIndex_Params {
	/**调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 key*/ 
	key:string,

	/**调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 value*/ 
	value:string,

}

interface UIListView_getDataByIndex_Params {
	/**（可选项）列表项的索引*/ 
	index?:number,

}

interface UIListView_setSwipeBtns_Params {
	/**（可选项）列表项的索引*/ 
	index?:number,

	/**（可选项）列表项侧滑露出的按钮组*/ 
	btns?:Array,

}

interface UIListView_reloadData_Params {
	/**（可选项）列表的数据源，**若不传或传空，仅收起下拉刷新组件***/ 
	data?:Array,

}

interface UIListView_deleteItem_Params {
	/**（可选项）数据列表的索引*/ 
	index?:number,

}

interface UIListView_updateItem_Params {
	/**（可选项）数据列表的索引*/ 
	index?:number,

	/**列表的数据源*/ 
	data:JSON,

}

interface UIListView_insertItem_Params {
	/**（可选项）数据列表的索引*/ 
	index?:number,

	/**列表的数据源*/ 
	data:JSON,

}

interface UIListView_appendData_Params {
	/**列表的数据源，**若不传或传空，仅收起上拉加载组件***/ 
	data:Array,

}

interface UIListView_setRefreshHeader_Params {
	/**下拉刷新时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）*/ 
	loadingImg:string,

	/**（可选项）下拉刷新区域的背景色，支持 rgb、rgba、#*/ 
	bgColor?:string,

	/**（可选项）提示文字颜色，支持 rgb、rgba、#*/ 
	textColor?:string,

	/**（可选项）下拉提示文字*/ 
	textDown?:string,

	/**（可选项）松开提示文字*/ 
	textUp?:string,

	/**（可选项）提示文字*/ 
	loadingText?:string,

	/**（可选项）提示文字*/ 
	lastUpdateText?:string,

	/**（可选项）是否显示刷新时间*/ 
	showTime?:boolean,

}

interface UIListView_setRefreshFooter_Params {
	/**上拉加载时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）*/ 
	loadingImg:string,

	/**（可选项）上拉加载区域的背景色，支持 rgb、rgba、#*/ 
	bgColor?:string,

	/**（可选项）提示文字颜色，支持 rgb、rgba、#*/ 
	textColor?:string,

	/**（可选项）上拉提示文字*/ 
	textUp?:string,

	/**（可选项）松开提示文字*/ 
	textDown?:string,

	/**（可选项）提示文字*/ 
	loadingText?:string,

	/**（可选项）提示文字*/ 
	lastUpdateText?:string,

	/**（可选项）是否显示刷新时间*/ 
	showTime?:boolean,

}

interface slipList {
}
interface pbTouTiao {
	/**
	 * `打开图文信息模块`
	 * ========params==========
	 *
	 * `hidden` :JSON : 界面元素的隐藏显示属性配置
	 *
	 * `textStyles` :JSON : 图片描述样式配置
	 */
	open(params:pbTouTiao_open_Params, callback?: (ret:JSON) => void):void

	/** 清除缓存到本地的网络图片，**本接口只清除本模块缓存的数据，若要清除本 app 缓存的所有数据则调用 api.clearCache***/ 
	clearCache():void

}
interface pbTouTiao_open_Params {
	/**界面元素的隐藏显示属性配置*/ 
	hidden:JSON,

	/**图片描述样式配置*/ 
	textStyles:JSON,

}

interface compass {
	/**
	 * `打开控件`
	 * ========params==========
	 *
	 * `rect` :JSON : 控件位置
	 *
	 * `bgStyle` :JSON : （可选项）背景相关设置
	 *
	 * `angleTextStyle` :JSON : （可选项）外环角度文字设置，不设置则不显示
	 *
	 * `scaleStyle` :JSON : （可选项）刻度相关设置，不设置则不显示
	 *
	 * `nsStyle` :JSON : （可选项）南北相关设置，不设置则不显示
	 *
	 * `directionStyle` :JSON : （可选项）方向箭头设置，此方向固定指向北，不设置则不显示
	 *
	 * `pointStyle` :JSON : （可选项）与正前方角度指针，与正前方固定角度，不设置则不显示
	 *
	 * `centerTextStyle` :JSON : （可选项）中心加角度数显示，不设置则不显示
	 *
	 * `autoChange` :boolean : （可选项）是否自动跟随方向改变改变
	 *
	 * `interval` :boolean : （可选项）刷新频率，当autoChange为true时有效 单位ms
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）是否将模块视图固定到窗口上（不跟随窗口上下滚动）
	 */
	open(params:compass_open_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `开始获取方向传感器数据，可单独调用`
	 * ========params==========
	 *
	 * `autoChange` :boolean : （可选项）如果有控件是否跟随数据同步
	 *
	 * `interval` :boolean : （可选项）控件刷新频率（非返回频率），当autoChange为true时有效 单位ms
	 */
	startSensor(params:compass_startSensor_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 停止传感器*/ 
	stopSensor(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `控件设置方向，可配合autoChange为false时使用`
	 * ========params==========
	 *
	 * `angle` :number : （可选项）方向
	 */
	setDirectionAngle(params:compass_setDirectionAngle_Params):void

	/**
	 * `设置指针角度，需要已经支持指针显示`
	 * ========params==========
	 *
	 * `angle` :number : 指针角度
	 */
	setPointAngle(params:compass_setPointAngle_Params):void

	/** 显示*/ 
	show():void

	/** 隐藏*/ 
	hide():void

	/** 关闭*/ 
	close():void

}
interface compass_open_Params {
	/**控件位置*/ 
	rect:JSON,

	/**（可选项）背景相关设置*/ 
	bgStyle?:JSON,

	/**（可选项）外环角度文字设置，不设置则不显示*/ 
	angleTextStyle?:JSON,

	/**（可选项）刻度相关设置，不设置则不显示*/ 
	scaleStyle?:JSON,

	/**（可选项）南北相关设置，不设置则不显示*/ 
	nsStyle?:JSON,

	/**（可选项）方向箭头设置，此方向固定指向北，不设置则不显示*/ 
	directionStyle?:JSON,

	/**（可选项）与正前方角度指针，与正前方固定角度，不设置则不显示*/ 
	pointStyle?:JSON,

	/**（可选项）中心加角度数显示，不设置则不显示*/ 
	centerTextStyle?:JSON,

	/**（可选项）是否自动跟随方向改变改变*/ 
	autoChange?:boolean,

	/**（可选项）刷新频率，当autoChange为true时有效 单位ms*/ 
	interval?:boolean,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）是否将模块视图固定到窗口上（不跟随窗口上下滚动）*/ 
	fixed?:boolean,

}

interface compass_startSensor_Params {
	/**（可选项）如果有控件是否跟随数据同步*/ 
	autoChange?:boolean,

	/**（可选项）控件刷新频率（非返回频率），当autoChange为true时有效 单位ms*/ 
	interval?:boolean,

}

interface compass_setDirectionAngle_Params {
	/**（可选项）方向*/ 
	angle?:number,

}

interface compass_setPointAngle_Params {
	/**指针角度*/ 
	angle:number,

}

interface scrollPicture {
}
interface musicNotify {
}
interface listContact {
}
interface UIListContactsSelect {
	/**
	 * `打开列表`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `specialGroupTitle` :string : （可选项）特殊分组标题
	 *
	 * `categarys` :Array : 类别数据
	 *
	 * `singleSelect` :boolean : 是否支持单选 （只有在选择模式下有效，即showListSelect({selected:true})）
	 *
	 * `contacts` :Array : 列表数据源
	 *
	 * `rightBtns` :Array : （可选项）列表项向左滑动露出的按钮组
	 *
	 * `styles` :string : （可选项）模块头部的样式
	 *
	 * `alphabeticalIndexStyles` :JSON : （可选项）右侧索引点击时中心显示的样式
	 *
	 * `backgroundColor` :boolean : （可选项）默认选中的人员是否禁用
	 *
	 * `bounces` :boolean : （可选项）是否弹动
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 */
	open(params:UIListContactsSelect_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭列表模块*/ 
	close():void

	/** 隐藏列表模块，并没有从内存里清除*/ 
	hide():void

	/** 显示已隐藏的列表模块*/ 
	show():void

	/**
	 * `刷新列表数据`
	 * ========params==========
	 *
	 * `contacts` :JSON : 列表数据源
	 */
	reloadData(params:UIListContactsSelect_reloadData_Params):void

	/** 是否显示搜索输入框*/ 
	setInputBarVisible():void

	/** 是否显示类别面板*/ 
	setCategaryPanelVisible():void

	/** 是否切入选择模式（列表右侧出现选择框）*/ 
	showListSelect():void

}
interface UIListContactsSelect_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**（可选项）特殊分组标题*/ 
	specialGroupTitle?:string,

	/**类别数据*/ 
	categarys:Array,

	/**是否支持单选 （只有在选择模式下有效，即showListSelect({selected:true})）*/ 
	singleSelect:boolean,

	/**列表数据源*/ 
	contacts:Array,

	/**（可选项）列表项向左滑动露出的按钮组*/ 
	rightBtns?:Array,

	/**（可选项）模块头部的样式*/ 
	styles?:string,

	/**（可选项）右侧索引点击时中心显示的样式*/ 
	alphabeticalIndexStyles?:JSON,

	/**（可选项）默认选中的人员是否禁用*/ 
	backgroundColor?:boolean,

	/**（可选项）是否弹动*/ 
	bounces?:boolean,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

}

interface UIListContactsSelect_reloadData_Params {
	/**列表数据源*/ 
	contacts:JSON,

}

interface UIListGroup {
	/**
	 * `打开`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `data` :Array : 列表的数据源，**开发者可以自定义唯一的键值对信息（如：uid: '1001'），供 getIndex 使用**
	 *
	 * `rightBtns` :Array : （可选项）列表项向左滑动露出的按钮组
	 *
	 * `styles` :string : （可选项）模块各部分的样式
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `showScrollBar` :boolean : （可选项）是否显示滚动条
	 */
	open(params:UIListGroup_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭数据列表模块*/ 
	close():void

	/** 显示*/ 
	show():void

	/** 隐藏*/ 
	hide():void

	/**
	 * `根据开发者自定义的唯一标识（open 接口的 data 参数中自定义的唯一标识）查找列表项对应的数据`
	 * ========params==========
	 *
	 * `key` :string : 调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 key
	 *
	 * `value` :string : 调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 value
	 */
	getIndex(params:UIListGroup_getIndex_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据列表项的索引获取对应的数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）列表项的索引
	 */
	getDataByIndex(params:UIListGroup_getDataByIndex_Params, callback?: (ret:JSON) => void):void

	/**
	 * `刷新列表数据`
	 * ========params==========
	 *
	 * `data` :Array : （可选项）列表的数据源，**若不传或传空，仅收起下拉刷新组件**
	 */
	reloadData(params:UIListGroup_reloadData_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引删除某一条列表的数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）数据列表的索引
	 */
	deleteItem(params:UIListGroup_deleteItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引更新某一条列表的数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）数据列表的索引
	 *
	 * `data` :JSON : 列表的数据源
	 */
	updateItem(params:UIListGroup_updateItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引向某一条列表插入数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）数据列表的索引
	 *
	 * `data` :Array : 列表的数据源
	 */
	insertItem(params:UIListGroup_insertItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `向列表末端追加数据`
	 * ========params==========
	 *
	 * `data` :Array : 列表的数据源，**若不传或传空，仅收起上拉加载组件**
	 */
	appendData(params:UIListGroup_appendData_Params, callback?: (ret:JSON) => void):void

	/** 获取当前列表的总数据量*/ 
	getCount():void

	/**
	 * `设置下拉刷新，**通过 reloadData 收起下拉刷新组件**`
	 * ========params==========
	 *
	 * `style` :JSON : 下拉刷新的样式配置
	 */
	setRefreshHeader(params:UIListGroup_setRefreshHeader_Params):void

	/**
	 * `设置上拉加载，**通过 appendData 收起上拉加载组件**`
	 * ========params==========
	 *
	 * `bgColor` :string : （可选项）上拉加载区域的背景色，支持 rgb、rgba、#
	 */
	setRefreshFooter(params:UIListGroup_setRefreshFooter_Params):void

	/** 停止上拉加载*/ 
	stopRefresh():void

}
interface UIListGroup_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**列表的数据源，**开发者可以自定义唯一的键值对信息（如：uid: '1001'），供 getIndex 使用***/ 
	data:Array,

	/**（可选项）列表项向左滑动露出的按钮组*/ 
	rightBtns?:Array,

	/**（可选项）模块各部分的样式*/ 
	styles?:string,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）是否显示滚动条*/ 
	showScrollBar?:boolean,

}

interface UIListGroup_getIndex_Params {
	/**调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 key*/ 
	key:string,

	/**调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 value*/ 
	value:string,

}

interface UIListGroup_getDataByIndex_Params {
	/**（可选项）列表项的索引*/ 
	index?:number,

}

interface UIListGroup_reloadData_Params {
	/**（可选项）列表的数据源，**若不传或传空，仅收起下拉刷新组件***/ 
	data?:Array,

}

interface UIListGroup_deleteItem_Params {
	/**（可选项）数据列表的索引*/ 
	index?:number,

}

interface UIListGroup_updateItem_Params {
	/**（可选项）数据列表的索引*/ 
	index?:number,

	/**列表的数据源*/ 
	data:JSON,

}

interface UIListGroup_insertItem_Params {
	/**（可选项）数据列表的索引*/ 
	index?:number,

	/**列表的数据源*/ 
	data:Array,

}

interface UIListGroup_appendData_Params {
	/**列表的数据源，**若不传或传空，仅收起上拉加载组件***/ 
	data:Array,

}

interface UIListGroup_setRefreshHeader_Params {
	/**下拉刷新的样式配置*/ 
	style:JSON,

}

interface UIListGroup_setRefreshFooter_Params {
	/**（可选项）上拉加载区域的背景色，支持 rgb、rgba、#*/ 
	bgColor?:string,

}

interface iosDialog4A {
	/**
	 * `弹出alert对话框`
	 * ========params==========
	 *
	 * `title` :string : 弹窗标题
	 *
	 * `msg` :string : 弹窗显示的内容
	 *
	 * `btnText` :string : 按钮上的文字
	 */
	alert(params:iosDialog4A_alert_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `confirm确认对话框`
	 * ========params==========
	 *
	 * `title` :string : 弹窗标题
	 *
	 * `msg` :string : 弹窗显示的内容
	 *
	 * `rigthBtnText` :string : 右边按钮文字
	 *
	 * `leftBtnText` :string : 左边按钮文字
	 */
	confirm(params:iosDialog4A_confirm_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `弹出带有输入框的dialog`
	 * ========params==========
	 *
	 * `title` :string : 弹窗标题
	 *
	 * `rigthBtnText` :string : 右边按钮文字
	 *
	 * `leftBtnText` :string : 左边按钮文字
	 *
	 * `inputType` :string : 输入文字的类型
	 */
	prompt(params:iosDialog4A_prompt_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `弹出actionsheet选择器`
	 * ========params==========
	 *
	 * `title` :string : actionsheet标题
	 *
	 * `cancel` :string : 最下面取消按钮文字
	 *
	 * `titleSize` :number : title文字大小
	 *
	 * `cancelSize` :number : cancel文字大小
	 *
	 * `buttons` :Array : 按钮
	 */
	actionsheet(params:iosDialog4A_actionsheet_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `弹出三级联动选择器`
	 * ========params==========
	 *
	 * `title` :string : 选择器的title
	 *
	 * `datas` :Array : 选择器数据（可选）
	 *
	 * `level` :any : 第三项的默认选中位置（可选）
	 */
	picker(params:iosDialog4A_picker_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface iosDialog4A_alert_Params {
	/**弹窗标题*/ 
	title:string,

	/**弹窗显示的内容*/ 
	msg:string,

	/**按钮上的文字*/ 
	btnText:string,

}

interface iosDialog4A_confirm_Params {
	/**弹窗标题*/ 
	title:string,

	/**弹窗显示的内容*/ 
	msg:string,

	/**右边按钮文字*/ 
	rigthBtnText:string,

	/**左边按钮文字*/ 
	leftBtnText:string,

}

interface iosDialog4A_prompt_Params {
	/**弹窗标题*/ 
	title:string,

	/**右边按钮文字*/ 
	rigthBtnText:string,

	/**左边按钮文字*/ 
	leftBtnText:string,

	/**输入文字的类型*/ 
	inputType:string,

}

interface iosDialog4A_actionsheet_Params {
	/**actionsheet标题*/ 
	title:string,

	/**最下面取消按钮文字*/ 
	cancel:string,

	/**title文字大小*/ 
	titleSize:number,

	/**cancel文字大小*/ 
	cancelSize:number,

	/**按钮*/ 
	buttons:Array,

}

interface iosDialog4A_picker_Params {
	/**选择器的title*/ 
	title:string,

	/**选择器数据（可选）*/ 
	datas?:Array,

	/**第三项的默认选中位置（可选）*/ 
	level?:any,

}

interface UIListCard {
	/**
	 * `打开列表`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `contacts` :Array : 列表数据源
	 *
	 * `styles` :JSON : （可选项）列表样式设置
	 *
	 * `indicator` :boolean : （可选项）是否显示字母索引
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 */
	open(params:UIListCard_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭列表模块*/ 
	close():void

	/** 隐藏列表模块，并没有从内存里清除*/ 
	hide():void

	/** 显示已隐藏的列表模块*/ 
	show():void

	/**
	 * `刷新列表数据`
	 * ========params==========
	 *
	 * `contacts` :JSON : 列表数据源
	 */
	reloadData(params:UIListCard_reloadData_Params):void

	/**
	 * `向列表末端追加数据`
	 * ========params==========
	 *
	 * `data` :Array : 列表的数据源，**若不传或传空，仅收起上拉加载组件**
	 */
	appendData(params:UIListCard_appendData_Params, callback?: (ret:JSON) => void):void

}
interface UIListCard_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**列表数据源*/ 
	contacts:Array,

	/**（可选项）列表样式设置*/ 
	styles?:JSON,

	/**（可选项）是否显示字母索引*/ 
	indicator?:boolean,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

}

interface UIListCard_reloadData_Params {
	/**列表数据源*/ 
	contacts:JSON,

}

interface UIListCard_appendData_Params {
	/**列表的数据源，**若不传或传空，仅收起上拉加载组件***/ 
	data:Array,

}

interface UIListInformation {
	/**
	 * `打开列表`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `contacts` :string : 列表数据源
	 *
	 * `rightBtns` :Array : （可选项）列表项向左滑动露出的按钮组，**建议：配置列表每项的通用按钮，用此参数；配置某一项的特定按钮，可在 `data` 数组的指定项传入 `rightBtns` 参数**
	 *
	 * `styles` :string : （可选项）模块头部的样式
	 *
	 * `rightButtonInfo` :any : （可选项）列表右边按钮相关设置，设置后点击将会弹出扇形页面，不传将不会弹出
	 *
	 * `backgroundColor` :string : （可选项）模块背景色
	 *
	 * `bounces` :boolean : （可选项）是否弹动
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 */
	open(params:UIListInformation_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭列表模块*/ 
	close():void

	/** 隐藏列表模块，并没有从内存里清除*/ 
	hide():void

	/** 显示已隐藏的列表模块*/ 
	show():void

	/**
	 * `根据开发者自定义的唯一标识（open 接口的 data 参数中自定义的唯一标识）查找列表项对应的数据`
	 * ========params==========
	 *
	 * `key` :string : 调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 key
	 *
	 * `value` :string : 调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 value
	 */
	getIndex(params:UIListInformation_getIndex_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据列表项的索引获取对应的数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）列表项的索引
	 */
	getDataByIndex(params:UIListInformation_getDataByIndex_Params, callback?: (ret:JSON) => void):void

	/**
	 * `刷新列表数据`
	 * ========params==========
	 *
	 * `contacts` :Array : （可选项）列表的数据源
	 */
	reloadData(params:UIListInformation_reloadData_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引删除某一条列表的数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）数据列表的索引
	 */
	deleteItem(params:UIListInformation_deleteItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引更新某一条列表的数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）数据列表的索引
	 *
	 * `contacts` :JSON : 列表的数据源
	 */
	updateItem(params:UIListInformation_updateItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `向列表末端追加数据`
	 * ========params==========
	 *
	 * `contacts` :Array : 列表的数据源，**若不传或传空，仅收起上拉加载组件**
	 */
	appendData(params:UIListInformation_appendData_Params, callback?: (ret:JSON) => void):void

	/**
	 * `设置下拉刷新，**通过 reloadData 收起下拉刷新组件**`
	 * ========params==========
	 *
	 * `loadingImg` :string : 下拉刷新时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）
	 *
	 * `bgColor` :string : （可选项）下拉刷新区域的背景色，支持 rgb、rgba、#
	 *
	 * `textColor` :string : （可选项）提示文字颜色，支持 rgb、rgba、#
	 *
	 * `textDown` :string : （可选项）下拉提示文字
	 *
	 * `textUp` :string : （可选项）松开提示文字
	 */
	setRefreshHeader(params:UIListInformation_setRefreshHeader_Params):void

	/**
	 * `设置上拉加载，**通过 appendData 收起上拉加载组件**`
	 * ========params==========
	 *
	 * `loadingImg` :string : 上拉加载时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）
	 *
	 * `bgColor` :string : （可选项）上拉加载区域的背景色，支持 rgb、rgba、#
	 */
	setRefreshFooter(params:UIListInformation_setRefreshFooter_Params):void

	/** 设置列表模式*/ 
	setListMode():void

	/** 获取列表模式*/ 
	getListMode():void

	/**
	 * `排序`
	 * ========params==========
	 *
	 * `sort` :number : （可选项）排序；0:正序,1:倒序
	 */
	sort(params:UIListInformation_sort_Params):void

	/**
	 * `恢复取消排序`
	 * ========params==========
	 *
	 * `isSort` :boolean : （可选项）是否排序
	 */
	cancelOrder(params:UIListInformation_cancelOrder_Params):void

	/** 关闭菜单(前端在push到下一个页面时，需要调用此接口)*/ 
	closeMenu():void

	/**
	 * `设置列表项样式`
	 * ========params==========
	 *
	 * `of` :number : （可选项）设置哪一项
	 *
	 * `styles` :JSON : （可选项）列表项样式
	 */
	setStyle(params:UIListInformation_setStyle_Params):void

	/** 取消设置列表项样式*/ 
	cancelStyle():void

}
interface UIListInformation_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**列表数据源*/ 
	contacts:string,

	/**（可选项）列表项向左滑动露出的按钮组，**建议：配置列表每项的通用按钮，用此参数；配置某一项的特定按钮，可在 `data` 数组的指定项传入 `rightBtns` 参数***/ 
	rightBtns?:Array,

	/**（可选项）模块头部的样式*/ 
	styles?:string,

	/**（可选项）列表右边按钮相关设置，设置后点击将会弹出扇形页面，不传将不会弹出*/ 
	rightButtonInfo?:any,

	/**（可选项）模块背景色*/ 
	backgroundColor?:string,

	/**（可选项）是否弹动*/ 
	bounces?:boolean,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

}

interface UIListInformation_getIndex_Params {
	/**调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 key*/ 
	key:string,

	/**调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 value*/ 
	value:string,

}

interface UIListInformation_getDataByIndex_Params {
	/**（可选项）列表项的索引*/ 
	index?:number,

}

interface UIListInformation_reloadData_Params {
	/**（可选项）列表的数据源*/ 
	contacts?:Array,

}

interface UIListInformation_deleteItem_Params {
	/**（可选项）数据列表的索引*/ 
	index?:number,

}

interface UIListInformation_updateItem_Params {
	/**（可选项）数据列表的索引*/ 
	index?:number,

	/**列表的数据源*/ 
	contacts:JSON,

}

interface UIListInformation_appendData_Params {
	/**列表的数据源，**若不传或传空，仅收起上拉加载组件***/ 
	contacts:Array,

}

interface UIListInformation_setRefreshHeader_Params {
	/**下拉刷新时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）*/ 
	loadingImg:string,

	/**（可选项）下拉刷新区域的背景色，支持 rgb、rgba、#*/ 
	bgColor?:string,

	/**（可选项）提示文字颜色，支持 rgb、rgba、#*/ 
	textColor?:string,

	/**（可选项）下拉提示文字*/ 
	textDown?:string,

	/**（可选项）松开提示文字*/ 
	textUp?:string,

}

interface UIListInformation_setRefreshFooter_Params {
	/**上拉加载时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）*/ 
	loadingImg:string,

	/**（可选项）上拉加载区域的背景色，支持 rgb、rgba、#*/ 
	bgColor?:string,

}

interface UIListInformation_sort_Params {
	/**（可选项）排序；0:正序,1:倒序*/ 
	sort?:number,

}

interface UIListInformation_cancelOrder_Params {
	/**（可选项）是否排序*/ 
	isSort?:boolean,

}

interface UIListInformation_setStyle_Params {
	/**（可选项）设置哪一项*/ 
	of?:number,

	/**（可选项）列表项样式*/ 
	styles?:JSON,

}

interface UICustomPicker {
	/**
	 * `打开自定义选择器`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `styles` :JSON : （可选项）模块各部分的样式
	 *
	 * `data` :JSON : 自定义选择器的标签和内容取值范围；若数组长度大于1，则显示多个选择器实例，彼此仍是一个整体，各个实例宽度 = 模块整体宽度（w）/ 实例个数
	 *
	 * `disableSelect` :JSON : （可选项）设置不可选项，与 data 对应，若不传则不设置不可选项
	 *
	 * `rows` :number : （可选项）滚动内容时可见的内容行数，只接受大于1的奇整数。
	 *
	 * `autoHide` :boolean : （可选项）选中内容时，上下选项是否自动隐藏
	 *
	 * `loop` :boolean : （可选项）是否循环滚动。如果内容的取值范围的个数小于rows参数的值，那么无论loop设置为true或是false，均不可循环滚动
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	open(params:UICustomPicker_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `关闭自定义选择器`
	 * ========params==========
	 *
	 * `id` :number : 模块的 id，用于区分模块的多个实例
	 */
	close(params:UICustomPicker_close_Params):void

	/**
	 * `显示自定义选择器`
	 * ========params==========
	 *
	 * `id` :number : 模块的 id，用于区分模块的多个实例
	 */
	show(params:UICustomPicker_show_Params):void

	/**
	 * `隐藏自定义选择器`
	 * ========params==========
	 *
	 * `id` :number : 模块的 id，用于区分模块的多个实例
	 */
	hide(params:UICustomPicker_hide_Params):void

	/**
	 * `设置自定义选择器当前选中的内容`
	 * ========params==========
	 *
	 * `id` :number : 模块 id，用于区分多个模块实例
	 *
	 * `data` :Array : 设置选择器选中项的内容组成的数组，数组某一项为空或不传，表示不改变对应列的值
	 */
	setValue(params:UICustomPicker_setValue_Params):void

	/**
	 * `刷新数据源`
	 * ========params==========
	 *
	 * `id` :number : 制定刷新的模块id
	 *
	 * `data` :JSON : 刷新自定义选择器的标签和内容；本数组长度必须和 open 接口内 data 参数数组长度一致，传空则表示不刷新该元素对应的列。如：[{*****},'',{*******}]，表示不刷新第二列选择器
	 */
	refreshData(params:UICustomPicker_refreshData_Params):void

}
interface UICustomPicker_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**（可选项）模块各部分的样式*/ 
	styles?:JSON,

	/**自定义选择器的标签和内容取值范围；若数组长度大于1，则显示多个选择器实例，彼此仍是一个整体，各个实例宽度 = 模块整体宽度（w）/ 实例个数*/ 
	data:JSON,

	/**（可选项）设置不可选项，与 data 对应，若不传则不设置不可选项*/ 
	disableSelect?:JSON,

	/**（可选项）滚动内容时可见的内容行数，只接受大于1的奇整数。*/ 
	rows?:number,

	/**（可选项）选中内容时，上下选项是否自动隐藏*/ 
	autoHide?:boolean,

	/**（可选项）是否循环滚动。如果内容的取值范围的个数小于rows参数的值，那么无论loop设置为true或是false，均不可循环滚动*/ 
	loop?:boolean,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface UICustomPicker_close_Params {
	/**模块的 id，用于区分模块的多个实例*/ 
	id:number,

}

interface UICustomPicker_show_Params {
	/**模块的 id，用于区分模块的多个实例*/ 
	id:number,

}

interface UICustomPicker_hide_Params {
	/**模块的 id，用于区分模块的多个实例*/ 
	id:number,

}

interface UICustomPicker_setValue_Params {
	/**模块 id，用于区分多个模块实例*/ 
	id:number,

	/**设置选择器选中项的内容组成的数组，数组某一项为空或不传，表示不改变对应列的值*/ 
	data:Array,

}

interface UICustomPicker_refreshData_Params {
	/**制定刷新的模块id*/ 
	id:number,

	/**刷新自定义选择器的标签和内容；本数组长度必须和 open 接口内 data 参数数组长度一致，传空则表示不刷新该元素对应的列。如：[{*****},'',{*******}]，表示不刷新第二列选择器*/ 
	data:JSON,

}

interface payPasswordPlus {
	/**
	 * `打开密码输入框`
	 * ========params==========
	 *
	 * `title` :string : （可选项）默认标题。
	 *
	 * `isTwoValidation` :string : （可选项）标题2 (isTwoValidation:true有效)。
	 *
	 * `textColor` :string : （可选项）标题颜色。
	 *
	 * `textSize` :number : （可选项）标题字体大小。
	 *
	 * `isOpenShuffle` :boolean : （可选项）是否开启打乱数字的位置(开启:true,关闭:false)。
	 *
	 * `isShowClose` :boolean : （可选项）是否显示关闭按钮(显示:true,不显示:false)。
	 */
	showInput(params:payPasswordPlus_showInput_Params, callback?: (ret:JSON) => void):void

}
interface payPasswordPlus_showInput_Params {
	/**（可选项）默认标题。*/ 
	title?:string,

	/**（可选项）标题2 (isTwoValidation:true有效)。*/ 
	isTwoValidation?:string,

	/**（可选项）标题颜色。*/ 
	textColor?:string,

	/**（可选项）标题字体大小。*/ 
	textSize?:number,

	/**（可选项）是否开启打乱数字的位置(开启:true,关闭:false)。*/ 
	isOpenShuffle?:boolean,

	/**（可选项）是否显示关闭按钮(显示:true,不显示:false)。*/ 
	isShowClose?:boolean,

}

interface slider {
}
interface calendar {
}
interface UIListBook {
	/**
	 * `打开 UIListBook 模块`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `data` :Array : 列表的数据源，**开发者可以自定义唯一的键值对信息（如：uid: '1001'），供 getIndex 使用**
	 *
	 * `rightBtns` :Array : （可选项）列表项向左滑动露出的按钮组，**建议：配置列表每项的通用按钮，用此参数；配置某一项的特定按钮，可在 `data` 数组的指定项传入 `rightBtns` 参数**
	 *
	 * `bounces` :boolean : （可选项）是否开启弹动，android 平台不支持本参数
	 *
	 * `styles` :string : （可选项）模块各部分的样式
	 *
	 * `rightButtonInfo` :any : （可选项）列表右边按钮相关设置，设置后点击将会弹出扇形页面，不传将不会弹出
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `showScrollBar` :boolean : （可选项）是否显示滚动条
	 */
	open(params:UIListBook_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭数据列表模块*/ 
	close():void

	/** 显示 UIListBook 模块*/ 
	show():void

	/** 隐藏 UIListBook 模块*/ 
	hide():void

	/**
	 * `设置列表的纵坐标和高度`
	 * ========params==========
	 *
	 * `y` :number : （可选项）模块的纵坐标
	 *
	 * `h` :number : （可选项）模块的高度
	 */
	setAttr(params:UIListBook_setAttr_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据开发者自定义的唯一标识（open 接口的 data 参数中自定义的唯一标识）查找列表项对应的数据（此接口仅支持iOS）`
	 * ========params==========
	 *
	 * `key` :string : 调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 key
	 *
	 * `value` :string : 调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 value
	 */
	getIndex(params:UIListBook_getIndex_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据列表项的索引获取对应的数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）列表项的索引
	 */
	getDataByIndex(params:UIListBook_getDataByIndex_Params, callback?: (ret:JSON) => void):void

	/**
	 * `设置侧滑显示出来的按钮`
	 * ========params==========
	 *
	 * `index` :number : （可选项）列表项的索引
	 *
	 * `btns` :Array : （可选项）列表项侧滑露出的按钮组
	 */
	setSwipeBtns(params:UIListBook_setSwipeBtns_Params, callback?: (ret:JSON) => void):void

	/**
	 * `刷新列表数据`
	 * ========params==========
	 *
	 * `data` :Array : （可选项）列表的数据源，**若不传或传空，仅收起下拉刷新组件**
	 */
	reloadData(params:UIListBook_reloadData_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引删除某一条列表的数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）数据列表的索引
	 */
	deleteItem(params:UIListBook_deleteItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引更新某一条列表的数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）数据列表的索引
	 *
	 * `data` :JSON : 列表的数据源
	 */
	updateItem(params:UIListBook_updateItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `向列表追加数据`
	 * ========params==========
	 *
	 * `data` :Array : 列表的数据源，**若不传或传空，仅收起上拉加载组件**
	 */
	appendData(params:UIListBook_appendData_Params, callback?: (ret:JSON) => void):void

	/** 获取当前列表的总数据量*/ 
	getCount():void

	/**
	 * `设置下拉刷新，**通过 reloadData 收起下拉刷新组件**`
	 * ========params==========
	 *
	 * `loadingImg` :string : 下拉刷新时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）
	 *
	 * `bgColor` :string : （可选项）下拉刷新区域的背景色，支持 rgb、rgba、#
	 *
	 * `textColor` :string : （可选项）提示文字颜色，支持 rgb、rgba、#
	 *
	 * `textDown` :string : （可选项）下拉提示文字
	 *
	 * `textUp` :string : （可选项）松开提示文字
	 *
	 * `loadingText` :string : （可选项）提示文字
	 */
	setRefreshHeader(params:UIListBook_setRefreshHeader_Params):void

	/**
	 * `设置上拉加载，**通过 appendData 收起上拉加载组件**`
	 * ========params==========
	 *
	 * `loadingImg` :string : 上拉加载时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）
	 *
	 * `bgColor` :string : （可选项）上拉加载区域的背景色，支持 rgb、rgba、#
	 *
	 * `textColor` :string : （可选项）提示文字颜色，支持 rgb、rgba、#
	 *
	 * `textUp` :string : （可选项）上拉提示文字
	 *
	 * `textDown` :string : （可选项）（仅ios支持）松开提示文字
	 *
	 * `loadingText` :string : （可选项）（仅ios支持）提示文字
	 */
	setRefreshFooter(params:UIListBook_setRefreshFooter_Params):void

	/**
	 * `排序`
	 * ========params==========
	 *
	 * `sort` :number : （可选项）排序；0:正序,1:倒序
	 */
	sort(params:UIListBook_sort_Params):void

	/**
	 * `恢复取消排序`
	 * ========params==========
	 *
	 * `isSort` :boolean : （可选项）是否排序
	 */
	cancelOrder(params:UIListBook_cancelOrder_Params):void

	/** 关闭右边弹窗（跳转其他页面时需调用此接口关闭弹窗，此接口仅支持iOS）*/ 
	closeMenu():void

	/**
	 * `设置列表项样式（分组时间不可同时设置）`
	 * ========params==========
	 *
	 * `of` :number : （可选项）设置哪一项
	 *
	 * `styles` :JSON : （可选项）列表项样式
	 */
	setStyle(params:UIListBook_setStyle_Params):void

	/** 取消设置列表项样式*/ 
	cancelStyle():void

}
interface UIListBook_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**列表的数据源，**开发者可以自定义唯一的键值对信息（如：uid: '1001'），供 getIndex 使用***/ 
	data:Array,

	/**（可选项）列表项向左滑动露出的按钮组，**建议：配置列表每项的通用按钮，用此参数；配置某一项的特定按钮，可在 `data` 数组的指定项传入 `rightBtns` 参数***/ 
	rightBtns?:Array,

	/**（可选项）是否开启弹动，android 平台不支持本参数*/ 
	bounces?:boolean,

	/**（可选项）模块各部分的样式*/ 
	styles?:string,

	/**（可选项）列表右边按钮相关设置，设置后点击将会弹出扇形页面，不传将不会弹出*/ 
	rightButtonInfo?:any,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）是否显示滚动条*/ 
	showScrollBar?:boolean,

}

interface UIListBook_setAttr_Params {
	/**（可选项）模块的纵坐标*/ 
	y?:number,

	/**（可选项）模块的高度*/ 
	h?:number,

}

interface UIListBook_getIndex_Params {
	/**调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 key*/ 
	key:string,

	/**调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 value*/ 
	value:string,

}

interface UIListBook_getDataByIndex_Params {
	/**（可选项）列表项的索引*/ 
	index?:number,

}

interface UIListBook_setSwipeBtns_Params {
	/**（可选项）列表项的索引*/ 
	index?:number,

	/**（可选项）列表项侧滑露出的按钮组*/ 
	btns?:Array,

}

interface UIListBook_reloadData_Params {
	/**（可选项）列表的数据源，**若不传或传空，仅收起下拉刷新组件***/ 
	data?:Array,

}

interface UIListBook_deleteItem_Params {
	/**（可选项）数据列表的索引*/ 
	index?:number,

}

interface UIListBook_updateItem_Params {
	/**（可选项）数据列表的索引*/ 
	index?:number,

	/**列表的数据源*/ 
	data:JSON,

}

interface UIListBook_appendData_Params {
	/**列表的数据源，**若不传或传空，仅收起上拉加载组件***/ 
	data:Array,

}

interface UIListBook_setRefreshHeader_Params {
	/**下拉刷新时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）*/ 
	loadingImg:string,

	/**（可选项）下拉刷新区域的背景色，支持 rgb、rgba、#*/ 
	bgColor?:string,

	/**（可选项）提示文字颜色，支持 rgb、rgba、#*/ 
	textColor?:string,

	/**（可选项）下拉提示文字*/ 
	textDown?:string,

	/**（可选项）松开提示文字*/ 
	textUp?:string,

	/**（可选项）提示文字*/ 
	loadingText?:string,

}

interface UIListBook_setRefreshFooter_Params {
	/**上拉加载时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）*/ 
	loadingImg:string,

	/**（可选项）上拉加载区域的背景色，支持 rgb、rgba、#*/ 
	bgColor?:string,

	/**（可选项）提示文字颜色，支持 rgb、rgba、#*/ 
	textColor?:string,

	/**（可选项）上拉提示文字*/ 
	textUp?:string,

	/**（可选项）（仅ios支持）松开提示文字*/ 
	textDown?:string,

	/**（可选项）（仅ios支持）提示文字*/ 
	loadingText?:string,

}

interface UIListBook_sort_Params {
	/**（可选项）排序；0:正序,1:倒序*/ 
	sort?:number,

}

interface UIListBook_cancelOrder_Params {
	/**（可选项）是否排序*/ 
	isSort?:boolean,

}

interface UIListBook_setStyle_Params {
	/**（可选项）设置哪一项*/ 
	of?:number,

	/**（可选项）列表项样式*/ 
	styles?:JSON,

}

interface UISelector {
}
interface addressSel {
	/**
	 * `input方法将view添加到页面中`
	 * ========params==========
	 *
	 * `x` :any : 以左上角为原点 x轴偏移量。
	 *
	 * `y` :any : 以左上角为原点 y轴偏移量。
	 *
	 * `w` :any : view 宽度 。
	 *
	 * `h` :any : view 高度 。
	 *
	 * `type` :any : 类型
	 */
	input(params:addressSel_input_Params, callback?: (ret:JSON) => void):void

	/** 隐藏view，已调用input情况下可调用此方法隐藏*/ 
	hide():void

	/** 显示隐藏的view，调用input，hide 的情况下将原view对象重新显示，节省内存，无需重新创建*/ 
	show():void

	/** 在不使用此view的情况下销毁释放内存*/ 
	destroy():void

	/** type为多级的情况下调用此方法一级一级返回，当返回到省级的时候返回返回值继续操作；例：type=2时用户点击省级选择进入市级选择，点击android回退键或者头部返回键调用该方法返回省级，再点击返回返回值back=true，在回调中继续操作。*/ 
	back():void

}
interface addressSel_input_Params {
	/**以左上角为原点 x轴偏移量。*/ 
	x:any,

	/**以左上角为原点 y轴偏移量。*/ 
	y:any,

	/**view 宽度 。*/ 
	w:any,

	/**view 高度 。*/ 
	h:any,

	/**类型*/ 
	type:any,

}

interface wmVideoRecorder {
	/** 调用系统相机录制视频*/ 
	recordVedios(callback?: (ret:JSON) => void):void

}
interface photoBrowserWeiBo {
	/** 清除缓存到本地的网络图片，**本接口只清除本模块缓存的数据，若要清除本 app 缓存的所有数据则调用 api.clearCache***/ 
	clearCache():void

}
interface dragList {
	/**
	 * `打开列表页面`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `datas` :Array : 列表数据
	 *
	 * `itemSize` :JSON : （可选项）内容框大小设置
	 *
	 * `styles` :JSON : （可选项）模块各部分的样式
	 *
	 * `column` :number : （可选项）每行多少列（仅android支持）
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）是否将模块视图固定到窗口上（不跟随窗口上下滚动）
	 */
	open(params:dragList_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭列表页面*/ 
	close():void

	/** 隐藏列表页面*/ 
	hide():void

	/** 显示列表页面*/ 
	show():void

	/**
	 * `打开/关闭编辑状态`
	 * ========params==========
	 *
	 * `isEditing` :boolean : （可选项）打开/关闭编辑状态；true：打开，false：关闭
	 */
	edit(params:dragList_edit_Params):void

	/**
	 * `删除某一内容`
	 * ========params==========
	 *
	 * `index` :number : 删除的内容
	 */
	delete(params:dragList_delete_Params):void

}
interface dragList_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**列表数据*/ 
	datas:Array,

	/**（可选项）内容框大小设置*/ 
	itemSize?:JSON,

	/**（可选项）模块各部分的样式*/ 
	styles?:JSON,

	/**（可选项）每行多少列（仅android支持）*/ 
	column?:number,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）是否将模块视图固定到窗口上（不跟随窗口上下滚动）*/ 
	fixed?:boolean,

}

interface dragList_edit_Params {
	/**（可选项）打开/关闭编辑状态；true：打开，false：关闭*/ 
	isEditing?:boolean,

}

interface dragList_delete_Params {
	/**删除的内容*/ 
	index:number,

}

interface pullRefreshLoop {
	/** 配置下拉刷新样式*/ 
	setCustomRefreshHeaderInfo():void

	/** 手动开始下拉刷新的加载状态，**下拉刷新状态亦可通过用户下拉到阈值自动触发***/ 
	refreshHeaderLoading():void

	/** 手动停止下拉刷新的加载状态*/ 
	refreshHeaderLoadDone():void

}
interface UIPullRefreshRiding {
	/** 配置下拉刷新样式*/ 
	setCustomRefreshHeaderInfo():void

	/** 手动开始下拉刷新的加载状态，**下拉刷新状态亦可通过用户下拉到阈值自动触发***/ 
	refreshHeaderLoading():void

	/** 手动停止下拉刷新的加载状态*/ 
	refreshHeaderLoadDone():void

}
interface passwordKeyboard {
	/**
	 * `数字字母键盘（仅iOS支持）`
	 * ========params==========
	 *
	 * `rect` :JSON : 键盘尺寸
	 *
	 * `bgColor` :string : (可选项)；键盘背景颜色
	 *
	 * `dataNumber` :number : (可选项)；允许输入框输入密码的位数
	 *
	 * `style` :JSON : （可选项）键盘按钮设置
	 */
	openDigitalLetter(params:passwordKeyboard_openDigitalLetter_Params, callback?: (ret:JSON) => void):void

	/** 关闭数字字母键盘（仅iOS支持）*/ 
	closeDigitalLetter():void

	/**
	 * `数字键盘`
	 * ========params==========
	 *
	 * `rect` :JSON : 键盘尺寸（仅iOS支持）
	 *
	 * `bgColor` :string : 键盘背景颜色
	 *
	 * `style` :JSON : （可选项）键盘按钮设置（仅iOS支持）
	 */
	openDigital(params:passwordKeyboard_openDigital_Params, callback?: (ret:JSON) => void):void

	/** 关闭数字键盘*/ 
	closeDigital():void

	/**
	 * `打开数字符号键盘（仅iOS支持）`
	 * ========params==========
	 *
	 * `rect` :JSON : 键盘尺寸
	 *
	 * `bgColor` :string : 键盘背景颜色
	 *
	 * `style` :JSON : （可选项）键盘按钮设置
	 */
	openDigitalSymbol(params:passwordKeyboard_openDigitalSymbol_Params, callback?: (ret:JSON) => void):void

	/** 关闭数字符号键盘（仅iOS支持）*/ 
	closeDigitalSymbol():void

}
interface passwordKeyboard_openDigitalLetter_Params {
	/**键盘尺寸*/ 
	rect:JSON,

	/**(可选项)；键盘背景颜色*/ 
	bgColor?:string,

	/**(可选项)；允许输入框输入密码的位数*/ 
	dataNumber?:number,

	/**（可选项）键盘按钮设置*/ 
	style?:JSON,

}

interface passwordKeyboard_openDigital_Params {
	/**键盘尺寸（仅iOS支持）*/ 
	rect:JSON,

	/**键盘背景颜色*/ 
	bgColor:string,

	/**（可选项）键盘按钮设置（仅iOS支持）*/ 
	style?:JSON,

}

interface passwordKeyboard_openDigitalSymbol_Params {
	/**键盘尺寸*/ 
	rect:JSON,

	/**键盘背景颜色*/ 
	bgColor:string,

	/**（可选项）键盘按钮设置*/ 
	style?:JSON,

}

interface dtSelector {
	/**
	 * `打开 dtSelector 模块`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `arrowImage` :string : （可选项）每个选择器右边的箭头图片，要求本地路径（fs://、widget://），支持png，jpg格式的图片
	 *
	 * `arrowSelectImage` :string : （可选项）每个选择器右边的箭头被选中的图片，需对arrowImage设置后才有效，要求本地路径（fs://、widget://），支持png，jpg格式的图片
	 *
	 * `itemCount` :number : （可选值）下拉选择器项的数量
	 *
	 * `cover` :boolean : （可选项）下拉的列表是否覆盖在整个选择器的下方
	 *
	 * `datas` :Array : 数据源，多层次数据结构，可无限添加层级，设置itemCount层数即可
	 *
	 * `styles` :JSON : （可选项）模块各部分的样式
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）是否将模块视图固定到窗口上（不跟随窗口上下滚动），如果被其他视图遮挡，请将此值设置为true
	 */
	open(params:dtSelector_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭数据列表模块*/ 
	close():void

	/** 显示dtSelector模块*/ 
	show():void

	/** ##示例代码*/ 
	hide():void

	/**
	 * `加载新的数据`
	 * ========params==========
	 *
	 * `datas` :Array : 数据源，多层次数据结构，可无限添加层级，设置itemCount层数即可
	 */
	reloadDatas(params:dtSelector_reloadDatas_Params):void

}
interface dtSelector_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**（可选项）每个选择器右边的箭头图片，要求本地路径（fs://、widget://），支持png，jpg格式的图片*/ 
	arrowImage?:string,

	/**（可选项）每个选择器右边的箭头被选中的图片，需对arrowImage设置后才有效，要求本地路径（fs://、widget://），支持png，jpg格式的图片*/ 
	arrowSelectImage?:string,

	/**（可选值）下拉选择器项的数量*/ 
	itemCount?:number,

	/**（可选项）下拉的列表是否覆盖在整个选择器的下方*/ 
	cover?:boolean,

	/**数据源，多层次数据结构，可无限添加层级，设置itemCount层数即可*/ 
	datas:Array,

	/**（可选项）模块各部分的样式*/ 
	styles?:JSON,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）是否将模块视图固定到窗口上（不跟随窗口上下滚动），如果被其他视图遮挡，请将此值设置为true*/ 
	fixed?:boolean,

}

interface dtSelector_reloadDatas_Params {
	/**数据源，多层次数据结构，可无限添加层级，设置itemCount层数即可*/ 
	datas:Array,

}

interface UICityList {
	/**
	 * `打开城市列表模块`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `topCitys` :Array : （可选项）热门城市数据源，若本参数不为空，则忽略 resource中的 topCitys。若不传或传空，则模块会自动读取 resource 中的 topCitys 数据
	 *
	 * `resource` :string : 城市列表的数据源文件路径（支持 https、http、widget、fs 路径协议），数据源文件必须为`.json`文件。城市的JSON数据会在callback时按原格式返回。若为 json 文件则必须是标准的 [json格式](http://www.bejson.com)，否则会报错。
	 */
	open(params:UICityList_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭城市列表*/ 
	close():void

	/** 显示城市列表*/ 
	show():void

	/** 隐藏城市列表*/ 
	hide():void

}
interface UICityList_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**（可选项）热门城市数据源，若本参数不为空，则忽略 resource中的 topCitys。若不传或传空，则模块会自动读取 resource 中的 topCitys 数据*/ 
	topCitys?:Array,

	/**城市列表的数据源文件路径（支持 https、http、widget、fs 路径协议），数据源文件必须为`.json`文件。城市的JSON数据会在callback时按原格式返回。若为 json 文件则必须是标准的 [json格式](http://www.bejson.com)，否则会报错。*/ 
	resource:string,

}

interface shakeView {
}
interface photoBrowserQQ {
	/** 清除缓存到本地的网络图片，**本接口只清除本模块缓存的数据，若要清除本 app 缓存的所有数据则调用 api.clearCache***/ 
	clearCache():void

}
interface barChart {
}
interface dialogBox {
	/**
	 * `弹出 alert 样式的对话框`
	 * ========params==========
	 *
	 * `texts` :string : （可选项）alert 对话框模块可配置的文本
	 *
	 * `styles` :number : alert 对话框样式配置
	 *
	 * `tapClose` :boolean : （可选项）是否点击遮罩层关闭该对话框
	 *
	 * `animation` :boolean : 是否再打开或关闭对话框时使用动画
	 */
	alert(params:dialogBox_alert_Params, callback?: (ret:JSON) => void):void

	/**
	 * `弹出 sendMessage 样式的对话框`
	 * ========params==========
	 *
	 * `texts` :JSON : （可选项）sendMessage 对话框模块可配置的文本
	 *
	 * `styles` :number : sendMessage 对话框样式配置
	 *
	 * `tapClose` :boolean : （可选项）是否点击遮罩层关闭该对话框
	 *
	 * `animation` :boolean : 是否再打开或关闭对话框时使用动画
	 */
	sendMessage(params:dialogBox_sendMessage_Params, callback?: (ret:JSON) => void):void

	/**
	 * `弹出 scene 样式的对话框`
	 * ========params==========
	 *
	 * `rect` :JSON : scene 对话框的尺寸配置, 上下左右居中对齐
	 *
	 * `texts` :JSON : （可选项）scene对话框模块可配置的文本
	 *
	 * `styles` :JSON : scene 对话框样式设置
	 *
	 * `optionDatas` :Array : （可选项）场景事件选项数据源，若为空则不显示
	 *
	 * `tapClose` :boolean : （可选项）是否点击遮罩层关闭该对话框
	 *
	 * `animation` :boolean : 是否再打开或关闭对话框时使用动画
	 */
	scene(params:dialogBox_scene_Params, callback?: (ret:JSON) => void):void

	/**
	 * `弹出 evaluation 样式的对话框`
	 * ========params==========
	 *
	 * `styles` :number : evaluation 对话框样式配置
	 *
	 * `texts` :JSON : （可选项）evaluation 对话框模块可配置的文本
	 *
	 * `tapClose` :boolean : （可选项）是否点击遮罩层关闭该对话框
	 *
	 * `animation` :boolean : 是否再打开或关闭对话框时使用动画
	 */
	evaluation(params:dialogBox_evaluation_Params, callback?: (ret:JSON) => void):void

	/**
	 * `弹出 raffle 样式的对话框`
	 * ========params==========
	 *
	 * `texts` :JSON : （可选项）raffle 对话框模块可配置的文本
	 *
	 * `styles` :string : raffle 对话框样式设置
	 *
	 * `tapClose` :boolean : （可选项）是否点击遮罩层关闭该对话框
	 *
	 * `animation` :boolean : 是否再打开或关闭对话框时使用动画
	 */
	raffle(params:dialogBox_raffle_Params, callback?: (ret:JSON) => void):void

	/**
	 * `弹出 taskPlan 样式的对话框`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）taskPlan 对话框的宽度配置
	 *
	 * `texts` :JSON : （可选项）taskPlan 对话框模块可配置的文本
	 *
	 * `styles` :JSON : taskPlan 对话框样式设置
	 *
	 * `tapClose` :boolean : （可选项）是否点击遮罩层关闭该对话框
	 *
	 * `animation` :boolean : 是否再打开或关闭对话框时使用动画
	 */
	taskPlan(params:dialogBox_taskPlan_Params, callback?: (ret:JSON) => void):void

	/** 弹出 receipt 样式的对话框*/ 
	receipt():void

	/** 弹出 tips 样式的对话框*/ 
	tips():void

	/** 弹出 discount 样式的对话框*/ 
	discount():void

	/**
	 * `弹出 share 样式的对话框`
	 * ========params==========
	 *
	 * `rect` :JSON : 对话框的宽高设置
	 *
	 * `items` :Array<JSON> : 对话框数据
	 *
	 * `styles` :JSON : 对话框样式设置
	 *
	 * `tapClose` :boolean : （可选项）是否点击遮罩层关闭该对话框
	 *
	 * `animation` :boolean : 是否再打开或关闭对话框时使用动画
	 *
	 * `ret` :JSON : null
	 */
	share(params:dialogBox_share_Params):void

	/**
	 * `弹出 actionMenu 样式的对话框`
	 * ========params==========
	 *
	 * `rect` :JSON : 对话框的宽高设置
	 *
	 * `texts` :JSON : （可选项）取消按钮的文本设置
	 *
	 * `items` :Array<JSON> : 对话框内子按钮配置，多出屏幕的按钮可左右拖动查看，按钮和标题所占区域在弹框区域上下居中显示
	 *
	 * `styles` :string : 对话框样式设置
	 *
	 * `isCuttingLine` :boolean : (可选项)是否显示分割线
	 *
	 * `tapClose` :boolean : （可选项）是否点击遮罩层关闭该对话框
	 *
	 * `animation` :boolean : 是否再打开或关闭对话框时使用动画
	 *
	 * `ret` :JSON : null
	 */
	actionMenu(params:dialogBox_actionMenu_Params):void

	/**
	 * `打开一个带输入框的弹出框`
	 * ========params==========
	 *
	 * `keyboardType` :string : （可选项）输入框获取焦点时，弹出的键盘类型；
	 *
	 * `texts` :JSON : （可选项）input 对话框模块可配置的文本
	 *
	 * `styles` :JSON : input 对话框样式配置
	 *
	 * `tapClose` :boolean : （可选项）是否点击遮罩层关闭该对话框
	 *
	 * `animation` :boolean : 是否再打开或关闭对话框时使用动画
	 */
	input(params:dialogBox_input_Params, callback?: (ret:JSON) => void):void

	/**
	 * `弹出 amount 样式的对话框`
	 * ========params==========
	 *
	 * `texts` :JSON : （可选项）amount 对话框模块可配置的文本
	 *
	 * `styles` :JSON : sendMessage 对话框样式配置
	 *
	 * `tapClose` :boolean : （可选项）是否点击遮罩层关闭该对话框
	 *
	 * `animation` :boolean : 是否再打开或关闭对话框时使用动画
	 *
	 * `decimal` :boolean : （可选项）是否支持小数输入，若为true，则弹出可输入小数的键盘，用户点击'+'或'-'当前数字增减步幅为当前数字的最小单位，如当前值为1.1，则点击'+'或'-'会增加减少0.1，当前值为1.11，则随之增减0.01
	 */
	amount(params:dialogBox_amount_Params, callback?: (ret:JSON) => void):void

	/**
	 * `弹出 list 样式的对话框`
	 * ========params==========
	 *
	 * `texts` :JSON : （可选项）amount 对话框模块可配置的文本
	 *
	 * `listTitles` :Array : 对话框内的列表每条 title 文本字符串组成的数组，超出该列表显示区域的可上下拖动查看
	 *
	 * `styles` :JSON : list 对话框样式配置
	 *
	 * `tapClose` :boolean : （可选项）是否点击遮罩层关闭该对话框
	 *
	 * `animation` :boolean : 是否再打开或关闭对话框时使用动画
	 */
	list(params:dialogBox_list_Params, callback?: (ret:JSON) => void):void

	/**
	 * `打开一个可加载 web 页面的弹框`
	 * ========params==========
	 *
	 * `texts` :JSON : （可选项）input 对话框模块可配置的文本
	 *
	 * `path` :string : 要加载的页面地址 支持(http:// widget://)
	 *
	 * `styles` :JSON : input 对话框样式配置
	 *
	 * `tapClose` :boolean : （可选项）是否点击遮罩层关闭该对话框
	 *
	 * `animation` :boolean : 是否再打开或关闭对话框时使用动画
	 */
	webView(params:dialogBox_webView_Params, callback?: (ret:JSON) => void):void

	/**
	 * `打开一个警告对话框`
	 * ========params==========
	 *
	 * `msg` :string : （可选项）popupAlert 对话框模块可配置的文本
	 *
	 * `styles` :JSON : popupAlert 对话框样式配置
	 *
	 * `tapClose` :boolean : （可选项）是否点击遮罩层关闭该对话框
	 */
	popupAlert(params:dialogBox_popupAlert_Params, callback?: (ret:JSON) => void):void

	/**
	 * `打开一个确认对话框`
	 * ========params==========
	 *
	 * `msg` :string : （可选项）confirm 对话框模块可配置的文本
	 *
	 * `styles` :JSON : confirm 对话框样式配置
	 *
	 * `tapClose` :boolean : 是否可以取消（点击遮罩，android系统点击回退是否取消对话框）
	 */
	confirm(params:dialogBox_confirm_Params, callback?: (ret:JSON) => void):void

	/**
	 * `关闭弹出的对话框`
	 * ========params==========
	 *
	 * `dialogName` :string : 上面所列各种对话框的样式名(接口)
	 */
	close(params:dialogBox_close_Params):void

	/**
	 * `打开一个带输入框的弹出框`
	 * ========params==========
	 *
	 * `keyboardType` :string : （可选项）输入框获取焦点时，弹出的键盘类型；
	 *
	 * `texts` :JSON : （可选项）input 对话框模块可配置的文本
	 *
	 * `styles` :JSON : input 对话框样式配置
	 *
	 * `tapClose` :boolean : （可选项）是否点击遮罩层关闭该对话框
	 */
	inputbox(params:dialogBox_inputbox_Params, callback?: (ret:JSON) => void):void

	/**
	 * `弹出 multiLineMenu 样式的对话框，与actionMenu对话框功能一致，区别在于该对话框支持多行`
	 * ========params==========
	 *
	 * `rect` :JSON : 对话框的宽高设置
	 *
	 * `texts` :JSON : （可选项）取消按钮的文本设置
	 *
	 * `items` :Array<JSON> : 对话框内子按钮配置，多出屏幕的按钮可左右拖动查看，按钮和标题所占区域在弹框区域上下居中显示
	 *
	 * `styles` :string : 对话框样式设置
	 *
	 * `isCuttingLine` :boolean : (可选项)是否显示分割线
	 *
	 * `tapClose` :boolean : （可选项）是否点击遮罩层关闭该对话框
	 *
	 * `animation` :boolean : 是否再打开或关闭对话框时使用动画
	 *
	 * `ret` :JSON : null
	 */
	multiLineMenu(params:dialogBox_multiLineMenu_Params):void

}
interface dialogBox_alert_Params {
	/**（可选项）alert 对话框模块可配置的文本*/ 
	texts?:string,

	/**alert 对话框样式配置*/ 
	styles:number,

	/**（可选项）是否点击遮罩层关闭该对话框*/ 
	tapClose?:boolean,

	/**是否再打开或关闭对话框时使用动画*/ 
	animation:boolean,

}

interface dialogBox_sendMessage_Params {
	/**（可选项）sendMessage 对话框模块可配置的文本*/ 
	texts?:JSON,

	/**sendMessage 对话框样式配置*/ 
	styles:number,

	/**（可选项）是否点击遮罩层关闭该对话框*/ 
	tapClose?:boolean,

	/**是否再打开或关闭对话框时使用动画*/ 
	animation:boolean,

}

interface dialogBox_scene_Params {
	/**scene 对话框的尺寸配置, 上下左右居中对齐*/ 
	rect:JSON,

	/**（可选项）scene对话框模块可配置的文本*/ 
	texts?:JSON,

	/**scene 对话框样式设置*/ 
	styles:JSON,

	/**（可选项）场景事件选项数据源，若为空则不显示*/ 
	optionDatas?:Array,

	/**（可选项）是否点击遮罩层关闭该对话框*/ 
	tapClose?:boolean,

	/**是否再打开或关闭对话框时使用动画*/ 
	animation:boolean,

}

interface dialogBox_evaluation_Params {
	/**evaluation 对话框样式配置*/ 
	styles:number,

	/**（可选项）evaluation 对话框模块可配置的文本*/ 
	texts?:JSON,

	/**（可选项）是否点击遮罩层关闭该对话框*/ 
	tapClose?:boolean,

	/**是否再打开或关闭对话框时使用动画*/ 
	animation:boolean,

}

interface dialogBox_raffle_Params {
	/**（可选项）raffle 对话框模块可配置的文本*/ 
	texts?:JSON,

	/**raffle 对话框样式设置*/ 
	styles:string,

	/**（可选项）是否点击遮罩层关闭该对话框*/ 
	tapClose?:boolean,

	/**是否再打开或关闭对话框时使用动画*/ 
	animation:boolean,

}

interface dialogBox_taskPlan_Params {
	/**（可选项）taskPlan 对话框的宽度配置*/ 
	rect?:JSON,

	/**（可选项）taskPlan 对话框模块可配置的文本*/ 
	texts?:JSON,

	/**taskPlan 对话框样式设置*/ 
	styles:JSON,

	/**（可选项）是否点击遮罩层关闭该对话框*/ 
	tapClose?:boolean,

	/**是否再打开或关闭对话框时使用动画*/ 
	animation:boolean,

}

interface dialogBox_share_Params {
	/**对话框的宽高设置*/ 
	rect:JSON,

	/**对话框数据*/ 
	items:Array<JSON>,

	/**对话框样式设置*/ 
	styles:JSON,

	/**（可选项）是否点击遮罩层关闭该对话框*/ 
	tapClose?:boolean,

	/**是否再打开或关闭对话框时使用动画*/ 
	animation:boolean,

	/**null*/ 
	ret:JSON,

}

interface dialogBox_actionMenu_Params {
	/**对话框的宽高设置*/ 
	rect:JSON,

	/**（可选项）取消按钮的文本设置*/ 
	texts?:JSON,

	/**对话框内子按钮配置，多出屏幕的按钮可左右拖动查看，按钮和标题所占区域在弹框区域上下居中显示*/ 
	items:Array<JSON>,

	/**对话框样式设置*/ 
	styles:string,

	/**(可选项)是否显示分割线*/ 
	isCuttingLine?:boolean,

	/**（可选项）是否点击遮罩层关闭该对话框*/ 
	tapClose?:boolean,

	/**是否再打开或关闭对话框时使用动画*/ 
	animation:boolean,

	/**null*/ 
	ret:JSON,

}

interface dialogBox_input_Params {
	/**（可选项）输入框获取焦点时，弹出的键盘类型；*/ 
	keyboardType?:string,

	/**（可选项）input 对话框模块可配置的文本*/ 
	texts?:JSON,

	/**input 对话框样式配置*/ 
	styles:JSON,

	/**（可选项）是否点击遮罩层关闭该对话框*/ 
	tapClose?:boolean,

	/**是否再打开或关闭对话框时使用动画*/ 
	animation:boolean,

}

interface dialogBox_amount_Params {
	/**（可选项）amount 对话框模块可配置的文本*/ 
	texts?:JSON,

	/**sendMessage 对话框样式配置*/ 
	styles:JSON,

	/**（可选项）是否点击遮罩层关闭该对话框*/ 
	tapClose?:boolean,

	/**是否再打开或关闭对话框时使用动画*/ 
	animation:boolean,

	/**（可选项）是否支持小数输入，若为true，则弹出可输入小数的键盘，用户点击'+'或'-'当前数字增减步幅为当前数字的最小单位，如当前值为1.1，则点击'+'或'-'会增加减少0.1，当前值为1.11，则随之增减0.01*/ 
	decimal?:boolean,

}

interface dialogBox_list_Params {
	/**（可选项）amount 对话框模块可配置的文本*/ 
	texts?:JSON,

	/**对话框内的列表每条 title 文本字符串组成的数组，超出该列表显示区域的可上下拖动查看*/ 
	listTitles:Array,

	/**list 对话框样式配置*/ 
	styles:JSON,

	/**（可选项）是否点击遮罩层关闭该对话框*/ 
	tapClose?:boolean,

	/**是否再打开或关闭对话框时使用动画*/ 
	animation:boolean,

}

interface dialogBox_webView_Params {
	/**（可选项）input 对话框模块可配置的文本*/ 
	texts?:JSON,

	/**要加载的页面地址 支持(http:// widget://)*/ 
	path:string,

	/**input 对话框样式配置*/ 
	styles:JSON,

	/**（可选项）是否点击遮罩层关闭该对话框*/ 
	tapClose?:boolean,

	/**是否再打开或关闭对话框时使用动画*/ 
	animation:boolean,

}

interface dialogBox_popupAlert_Params {
	/**（可选项）popupAlert 对话框模块可配置的文本*/ 
	msg?:string,

	/**popupAlert 对话框样式配置*/ 
	styles:JSON,

	/**（可选项）是否点击遮罩层关闭该对话框*/ 
	tapClose?:boolean,

}

interface dialogBox_confirm_Params {
	/**（可选项）confirm 对话框模块可配置的文本*/ 
	msg?:string,

	/**confirm 对话框样式配置*/ 
	styles:JSON,

	/**是否可以取消（点击遮罩，android系统点击回退是否取消对话框）*/ 
	tapClose:boolean,

}

interface dialogBox_close_Params {
	/**上面所列各种对话框的样式名(接口)*/ 
	dialogName:string,

}

interface dialogBox_inputbox_Params {
	/**（可选项）输入框获取焦点时，弹出的键盘类型；*/ 
	keyboardType?:string,

	/**（可选项）input 对话框模块可配置的文本*/ 
	texts?:JSON,

	/**input 对话框样式配置*/ 
	styles:JSON,

	/**（可选项）是否点击遮罩层关闭该对话框*/ 
	tapClose?:boolean,

}

interface dialogBox_multiLineMenu_Params {
	/**对话框的宽高设置*/ 
	rect:JSON,

	/**（可选项）取消按钮的文本设置*/ 
	texts?:JSON,

	/**对话框内子按钮配置，多出屏幕的按钮可左右拖动查看，按钮和标题所占区域在弹框区域上下居中显示*/ 
	items:Array<JSON>,

	/**对话框样式设置*/ 
	styles:string,

	/**(可选项)是否显示分割线*/ 
	isCuttingLine?:boolean,

	/**（可选项）是否点击遮罩层关闭该对话框*/ 
	tapClose?:boolean,

	/**是否再打开或关闭对话框时使用动画*/ 
	animation:boolean,

	/**null*/ 
	ret:JSON,

}

interface UIAlert {
	/** 邀请对话框*/ 
	invite(callback?: (ret:JSON) => void):void

	/**
	 * `在屏幕中间显示一个提示图片`
	 * ========params==========
	 *
	 * `imagePath` :string : 图片路径（支持widget:// fs://）
	 *
	 * `imageW` :number : 图片宽度
	 *
	 * `imageH` :number : 图片高度
	 *
	 * `mask` :string : 遮罩颜色
	 *
	 * `showAPNG` :boolean : 显示APNG图片
	 */
	popImage(params:UIAlert_popImage_Params, callback?: (ret:JSON) => void):void

	/**
	 * `列表选择对话框`
	 * ========params==========
	 *
	 * `title` :string : 列表标题
	 *
	 * `datas` :JSON : 列表数据
	 *
	 * `styles` :JSON : 对话框样式
	 *
	 * `mask` :string : 对话框遮罩颜色
	 *
	 * `selectedIndex` :number : 默认选中项
	 */
	selectedList(params:UIAlert_selectedList_Params, callback?: (ret:JSON) => void):void

	/**
	 * `提示对话框`
	 * ========params==========
	 *
	 * `imagePath` :string : 图片路径（支持widget:// fs://）
	 *
	 * `content` :string : 提示内容
	 *
	 * `btnTitle` :string : 底部按钮标题
	 *
	 * `styles` :JSON : 对话框样式设置
	 *
	 * `mask` :string : 对话框遮罩颜色
	 */
	showTips(params:UIAlert_showTips_Params, callback?: (ret:JSON) => void):void

	/**
	 * `price对话框`
	 * ========params==========
	 *
	 * `styles` :JSON : 对话框样式设置
	 *
	 * `mask` :string : 对话框遮罩颜色
	 */
	price(params:UIAlert_price_Params, callback?: (ret:JSON) => void):void

	/**
	 * `提示对话框`
	 * ========params==========
	 *
	 * `styles` :JSON : 对话框样式设置
	 *
	 * `mask` :string : 对话框遮罩颜色
	 */
	hint(params:UIAlert_hint_Params, callback?: (ret:JSON) => void):void

	/**
	 * `支付成功对话框`
	 * ========params==========
	 *
	 * `styles` :JSON : 对话框样式设置
	 *
	 * `mask` :string : 对话框遮罩颜色
	 */
	paySuccess(params:UIAlert_paySuccess_Params, callback?: (ret:JSON) => void):void

	/**
	 * `支付对话框`
	 * ========params==========
	 *
	 * `styles` :JSON : 对话框样式设置
	 *
	 * `payItems` :Array<JSON> : 付款项
	 *
	 * `mask` :string : 对话框遮罩颜色
	 */
	payDialog(params:UIAlert_payDialog_Params, callback?: (ret:JSON) => void):void

	/** 关闭对话框*/ 
	close():void

}
interface UIAlert_popImage_Params {
	/**图片路径（支持widget:// fs://）*/ 
	imagePath:string,

	/**图片宽度*/ 
	imageW:number,

	/**图片高度*/ 
	imageH:number,

	/**遮罩颜色*/ 
	mask:string,

	/**显示APNG图片*/ 
	showAPNG:boolean,

}

interface UIAlert_selectedList_Params {
	/**列表标题*/ 
	title:string,

	/**列表数据*/ 
	datas:JSON,

	/**对话框样式*/ 
	styles:JSON,

	/**对话框遮罩颜色*/ 
	mask:string,

	/**默认选中项*/ 
	selectedIndex:number,

}

interface UIAlert_showTips_Params {
	/**图片路径（支持widget:// fs://）*/ 
	imagePath:string,

	/**提示内容*/ 
	content:string,

	/**底部按钮标题*/ 
	btnTitle:string,

	/**对话框样式设置*/ 
	styles:JSON,

	/**对话框遮罩颜色*/ 
	mask:string,

}

interface UIAlert_price_Params {
	/**对话框样式设置*/ 
	styles:JSON,

	/**对话框遮罩颜色*/ 
	mask:string,

}

interface UIAlert_hint_Params {
	/**对话框样式设置*/ 
	styles:JSON,

	/**对话框遮罩颜色*/ 
	mask:string,

}

interface UIAlert_paySuccess_Params {
	/**对话框样式设置*/ 
	styles:JSON,

	/**对话框遮罩颜色*/ 
	mask:string,

}

interface UIAlert_payDialog_Params {
	/**对话框样式设置*/ 
	styles:JSON,

	/**付款项*/ 
	payItems:Array<JSON>,

	/**对话框遮罩颜色*/ 
	mask:string,

}

interface kLoading {
	/**
	 * `显示加载框`
	 * ========params==========
	 *
	 * `type` :any : （必选项）加载的效果，值的范围0-22，超过的默认为0，效果参照模块效果图
	 *
	 * `size` :any : （可选项） 加载框的大小
	 *
	 * `color` :string : （可选项）加载效果的颜色，值为6位数的颜色，例如 #ffffff
	 */
	show(params:kLoading_show_Params):void

	/** 关闭加载框*/ 
	hide():void

	/** 当需要更改加载的类型时，可以先调用destory来销毁之前的动画类型*/ 
	destory():void

}
interface kLoading_show_Params {
	/**（必选项）加载的效果，值的范围0-22，超过的默认为0，效果参照模块效果图*/ 
	type:any,

	/**（可选项） 加载框的大小*/ 
	size?:any,

	/**（可选项）加载效果的颜色，值为6位数的颜色，例如 #ffffff*/ 
	color?:string,

}

interface UISwitchButton {
	/**
	 * `打开按钮`
	 * ========params==========
	 *
	 * `id` :string : 按钮的id
	 *
	 * `state` :boolean : 开关状态
	 *
	 * `rect` :JSON : 按钮的宽高及位置设置
	 *
	 * `styles` :JSON : 按钮样式的设计
	 *
	 * `fixed` :boolean : 是否将按钮固定到窗口或frame上，是否跟随窗口上下滚动，可为空
	 *
	 * `fixedOn` :string : （可选项）按钮固定到指定 frame 的名字（只指 frame，传 window 无效）
	 */
	open(params:UISwitchButton_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `隐藏按钮`
	 * ========params==========
	 *
	 * `id` :string : 按钮的id
	 */
	hide(params:UISwitchButton_hide_Params):void

	/**
	 * `显示按钮`
	 * ========params==========
	 *
	 * `id` :string : 按钮的id
	 */
	show(params:UISwitchButton_show_Params):void

	/**
	 * `打开`
	 * ========params==========
	 *
	 * `id` :string : 按钮的id
	 */
	turnOn(params:UISwitchButton_turnOn_Params):void

	/** 关闭*/ 
	turnOff():void

	/**
	 * `获取按钮的开关状态`
	 * ========params==========
	 *
	 * `id` :string : 按钮的id
	 */
	getState(params:UISwitchButton_getState_Params, callback?: (ret:JSON) => void):void

	/**
	 * `关闭按钮`
	 * ========params==========
	 *
	 * `id` :string : 按钮的id
	 */
	close(params:UISwitchButton_close_Params):void

}
interface UISwitchButton_open_Params {
	/**按钮的id*/ 
	id:string,

	/**开关状态*/ 
	state:boolean,

	/**按钮的宽高及位置设置*/ 
	rect:JSON,

	/**按钮样式的设计*/ 
	styles:JSON,

	/**是否将按钮固定到窗口或frame上，是否跟随窗口上下滚动，可为空*/ 
	fixed:boolean,

	/**（可选项）按钮固定到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

}

interface UISwitchButton_hide_Params {
	/**按钮的id*/ 
	id:string,

}

interface UISwitchButton_show_Params {
	/**按钮的id*/ 
	id:string,

}

interface UISwitchButton_turnOn_Params {
	/**按钮的id*/ 
	id:string,

}

interface UISwitchButton_getState_Params {
	/**按钮的id*/ 
	id:string,

}

interface UISwitchButton_close_Params {
	/**按钮的id*/ 
	id:string,

}

interface UIScrollPromptView {
	/**
	 * `打开模块`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `data` :JSON : 模块的图片路径数组，及说明文字数组
	 *
	 * `styles` :string : （可选项）模块各部分的样式
	 *
	 * `placeholderImg` :string : （可选项）网络图片未加载完毕时，模块显示的占位图片，要求本地路径（fs://、widget://）
	 *
	 * `contentMode` :string : （可选项）图片填充模式
	 *
	 * `interval` :number : （可选项）图片轮换时间间隔，单位是秒（s）
	 *
	 * `auto` :boolean : （可选项）图片是否自动播放
	 *
	 * `loop` :boolean : （可选项）图片是否循环播放
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	open(params:UIScrollPromptView_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭模块*/ 
	close():void

	/** 显示模块*/ 
	show():void

	/** 隐藏模块*/ 
	hide():void

	/**
	 * `指定当前项`
	 * ========params==========
	 *
	 * `index` :number : （可选项）索引值
	 */
	setCurrentIndex(params:UIScrollPromptView_setCurrentIndex_Params):void

	/**
	 * `更新模块数据`
	 * ========params==========
	 *
	 * `data` :JSON : 模块的图片路径数组，及说明文字数组
	 */
	reloadData(params:UIScrollPromptView_reloadData_Params):void

	/**
	 * `事件监听`
	 * ========params==========
	 *
	 * `name` :string : 监听的事件名称，取值范围：'scroll'（图片滚动事件）
	 */
	addEventListener(params:UIScrollPromptView_addEventListener_Params, callback?: (ret:JSON) => void):void

	/** 清除缓存到本地的网络图片，**本接口只清除本模块缓存的数据，若要清除 app 缓存的所有数据则调用api.clearCache***/ 
	clearCache():void

}
interface UIScrollPromptView_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**模块的图片路径数组，及说明文字数组*/ 
	data:JSON,

	/**（可选项）模块各部分的样式*/ 
	styles?:string,

	/**（可选项）网络图片未加载完毕时，模块显示的占位图片，要求本地路径（fs://、widget://）*/ 
	placeholderImg?:string,

	/**（可选项）图片填充模式*/ 
	contentMode?:string,

	/**（可选项）图片轮换时间间隔，单位是秒（s）*/ 
	interval?:number,

	/**（可选项）图片是否自动播放*/ 
	auto?:boolean,

	/**（可选项）图片是否循环播放*/ 
	loop?:boolean,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface UIScrollPromptView_setCurrentIndex_Params {
	/**（可选项）索引值*/ 
	index?:number,

}

interface UIScrollPromptView_reloadData_Params {
	/**模块的图片路径数组，及说明文字数组*/ 
	data:JSON,

}

interface UIScrollPromptView_addEventListener_Params {
	/**监听的事件名称，取值范围：'scroll'（图片滚动事件）*/ 
	name:string,

}

interface iOSDialog {
	/**
	 * `类似iOS的底部弹出列表选择`
	 * ========params==========
	 *
	 * `title` :string : 底部弹出框的标题
	 *
	 * `items` :Array : 每个列表项的标题
	 */
	actionSheetDialog(params:iOSDialog_actionSheetDialog_Params, callback?: (ret:JSON) => void):void

	/**
	 * `类似iOS的弹出框，可选择显示一个或者两个按钮`
	 * ========params==========
	 *
	 * `title` :string : (可选)弹出框的标题
	 *
	 * `msg` :string : 弹出框显示的文字
	 *
	 * `positive` :string : （可选）确定按钮的标题
	 *
	 * `negative` :string : （可选）取消按钮的标题
	 */
	alertDialog(params:iOSDialog_alertDialog_Params, callback?: (ret:JSON) => void):void

}
interface iOSDialog_actionSheetDialog_Params {
	/**底部弹出框的标题*/ 
	title:string,

	/**每个列表项的标题*/ 
	items:Array,

}

interface iOSDialog_alertDialog_Params {
	/**(可选)弹出框的标题*/ 
	title?:string,

	/**弹出框显示的文字*/ 
	msg:string,

	/**（可选）确定按钮的标题*/ 
	positive?:string,

	/**（可选）取消按钮的标题*/ 
	negative?:string,

}

interface UIChatUnit {
	/** 打开聊天输入框*/ 
	open(callback?: (ret:JSON) => void):void

	/** 录音面板监听*/ 
	recordPanelListener():void

	/** 点击选择收礼人监听  **注意:仅在isGroupChat为true的情况下有效***/ 
	giftsToolListener():void

	/**
	 * `设置礼物数据`
	 * ========params==========
	 *
	 * `styles` :JSON : （可选项）附加功能面板按钮样式配置
	 *
	 * `buttons` :Array : 附加功能面板按钮信息集合，可分页显示
	 */
	setGiftDatas(params:UIChatUnit_setGiftDatas_Params, callback?: (ret:JSON) => void):void

	/**
	 * `更新礼物信息（在群聊情况下选择群成员返回后可使用该方法更新头像及昵称）`
	 * ========params==========
	 *
	 * `avaterPath` :string : （可选项）送礼人的头像(支持 widget:// & fs://)
	 *
	 * `nickText` :string : （可选项）收礼人的昵称
	 */
	updateGiftInfo(params:UIChatUnit_updateGiftInfo_Params):void

	/** 关闭聊天输入框*/ 
	close():void

	/** 显示聊天输入框*/ 
	show():void

	/** 隐藏聊天输入框*/ 
	hide():void

	/** 弹出键盘*/ 
	popupKeyboard():void

	/** 收起键盘*/ 
	closeKeyboard():void

	/** 收起录音面板*/ 
	hideRecordPanel():void

	/**
	 * `获取或设置聊天输入框的内容`
	 * ========params==========
	 *
	 * `msg` :string : （可选项）聊天输入框的内容，若不传则返回输入框的值
	 */
	value(params:UIChatUnit_value_Params, callback?: (ret:JSON) => void):void

	/**
	 * `向聊天输入框的指定位置插入内容`
	 * ========params==========
	 *
	 * `index` :number : （可选项）待插入内容的起始位置。**注意：中文，全角符号均占一个字符长度；索引从0开始，0表示插入到最前面，1表示插入到第一个字符后面，2表示插入到第二个字符后面，以此类推。**
	 *
	 * `msg` :string : （可选项）要插入的内容
	 */
	insertValue(params:UIChatUnit_insertValue_Params):void

	/**
	 * `添加输入框相关事件的监听`
	 * ========params==========
	 *
	 * `name` :string : 监听的事件类型
	 */
	chatBoxListener(params:UIChatUnit_chatBoxListener_Params, callback?: (ret:JSON) => void):void

	/** 清空输入框文本*/ 
	clearText():void

	/** 重置模块*/ 
	reset():void

	/** 显示礼物面板*/ 
	showGiftPanel():void

	/** 显示录音面板*/ 
	showRecordPanel():void

	/** 获取当前可见的panel*/ 
	getCurrentVisiblePanel():void

	/** 设置所有按钮可用/不可用*/ 
	setEnableAllBtns():void

}
interface UIChatUnit_setGiftDatas_Params {
	/**（可选项）附加功能面板按钮样式配置*/ 
	styles?:JSON,

	/**附加功能面板按钮信息集合，可分页显示*/ 
	buttons:Array,

}

interface UIChatUnit_updateGiftInfo_Params {
	/**（可选项）送礼人的头像(支持 widget:// & fs://)*/ 
	avaterPath?:string,

	/**（可选项）收礼人的昵称*/ 
	nickText?:string,

}

interface UIChatUnit_value_Params {
	/**（可选项）聊天输入框的内容，若不传则返回输入框的值*/ 
	msg?:string,

}

interface UIChatUnit_insertValue_Params {
	/**（可选项）待插入内容的起始位置。**注意：中文，全角符号均占一个字符长度；索引从0开始，0表示插入到最前面，1表示插入到第一个字符后面，2表示插入到第二个字符后面，以此类推。***/ 
	index?:number,

	/**（可选项）要插入的内容*/ 
	msg?:string,

}

interface UIChatUnit_chatBoxListener_Params {
	/**监听的事件类型*/ 
	name:string,

}

interface UIMultiSelector {
	/**
	 * `打开选择器`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `text` :JSON : （可选项）模块相应文字设置
	 *
	 * `max` :number : （可选项）最多允许同时选中的项数；当值为 0 时可选中所有项，若本字段值大于0则全选项不显示；当值为其它时，选择超过 max 的选项，选项选择无效且回调 ret-> eventType 返回 “overflow”
	 *
	 * `singleSelection` :boolean : （可选项）是否为单选框；参数值为 true 时，忽略参数 max，模块呈 “单选项” 模式状态，即选择第二项将自动取消前一项的已选中状态
	 *
	 * `styles` :JSON : （可选项）模块的样式设置
	 *
	 * `animation` :boolean : （可选项）打开关闭时是否显示滑入滑出动画
	 *
	 * `maskClose` :boolean : （可选项）用户点击遮罩层（选择器以外的区域）时，是否关闭选择器
	 *
	 * `items` :Array<JSON> : 选择器的数据
	 */
	open(params:UIMultiSelector_open_Params, callback?: (ret:JSON) => void):void

	/** 显示已隐藏的选择器*/ 
	show():void

	/** 隐藏选择器（并未从内存清除）*/ 
	hide():void

	/** 关闭选择器（从内存清除）*/ 
	close():void

}
interface UIMultiSelector_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**（可选项）模块相应文字设置*/ 
	text?:JSON,

	/**（可选项）最多允许同时选中的项数；当值为 0 时可选中所有项，若本字段值大于0则全选项不显示；当值为其它时，选择超过 max 的选项，选项选择无效且回调 ret-> eventType 返回 “overflow”*/ 
	max?:number,

	/**（可选项）是否为单选框；参数值为 true 时，忽略参数 max，模块呈 “单选项” 模式状态，即选择第二项将自动取消前一项的已选中状态*/ 
	singleSelection?:boolean,

	/**（可选项）模块的样式设置*/ 
	styles?:JSON,

	/**（可选项）打开关闭时是否显示滑入滑出动画*/ 
	animation?:boolean,

	/**（可选项）用户点击遮罩层（选择器以外的区域）时，是否关闭选择器*/ 
	maskClose?:boolean,

	/**选择器的数据*/ 
	items:Array<JSON>,

}

interface button {
}
interface mtlCitySelect {
	/**
	 * `打开城市选择器`
	 * ========params==========
	 *
	 * `city` :string : （可选项）默认城市
	 *
	 * `resouceType` :string : （可选项）自定义数据源
	 */
	chooseCity(params:mtlCitySelect_chooseCity_Params, callback?: (ret:JSON) => void):void

}
interface mtlCitySelect_chooseCity_Params {
	/**（可选项）默认城市*/ 
	city?:string,

	/**（可选项）自定义数据源*/ 
	resouceType?:string,

}

interface brokenLine {
}
interface UIPieChart {
	/**
	 * `**注意:请保证 所有数值加起来不为0 否则无实际意义 **`
	 * ========params==========
	 *
	 * `x` :number : （可选项）圆心坐标
	 *
	 * `y` :number : （可选项）圆心坐标
	 *
	 * `radius` :number : （可选项）圆半径
	 *
	 * `type` :string : （可选项）饼图样式
	 *
	 * `isAnimated` :boolean : （可选项）是否带动画
	 *
	 * `center` :JSON : （可选项）饼形图中间标题样式设置(仅圆环样式下有效)
	 *
	 * `elements` :Array : 模块字典对象组成的数组
	 *
	 * `fixedOn` :string : （可选项）添加到哪个frame，与fixed一起使用
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	open(params:UIPieChart_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `刷新展示数据`
	 * ========params==========
	 *
	 * `id` :number : 操作的视图的id
	 *
	 * `elements` :Array : 模块字典对象组成的数组
	 */
	reloadData(params:UIPieChart_reloadData_Params, callback?: (ret:JSON) => void):void

	/** 重设模块视图的位置大小*/ 
	setFrame():void

	/**
	 * `关闭饼图`
	 * ========params==========
	 *
	 * `id` :number : 要关闭的饼图的id
	 */
	close(params:UIPieChart_close_Params):void

	/**
	 * `隐藏饼图`
	 * ========params==========
	 *
	 * `id` :number : 要隐藏的饼图的id
	 */
	hide(params:UIPieChart_hide_Params):void

	/**
	 * `显示已隐藏的饼形图`
	 * ========params==========
	 *
	 * `id` :number : 要显示的饼图的id
	 */
	show(params:UIPieChart_show_Params):void

}
interface UIPieChart_open_Params {
	/**（可选项）圆心坐标*/ 
	x?:number,

	/**（可选项）圆心坐标*/ 
	y?:number,

	/**（可选项）圆半径*/ 
	radius?:number,

	/**（可选项）饼图样式*/ 
	type?:string,

	/**（可选项）是否带动画*/ 
	isAnimated?:boolean,

	/**（可选项）饼形图中间标题样式设置(仅圆环样式下有效)*/ 
	center?:JSON,

	/**模块字典对象组成的数组*/ 
	elements:Array,

	/**（可选项）添加到哪个frame，与fixed一起使用*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface UIPieChart_reloadData_Params {
	/**操作的视图的id*/ 
	id:number,

	/**模块字典对象组成的数组*/ 
	elements:Array,

}

interface UIPieChart_close_Params {
	/**要关闭的饼图的id*/ 
	id:number,

}

interface UIPieChart_hide_Params {
	/**要隐藏的饼图的id*/ 
	id:number,

}

interface UIPieChart_show_Params {
	/**要显示的饼图的id*/ 
	id:number,

}

interface groupList {
}
interface thwartwiseBarChart {
	/**
	 * `打开横排柱状图模块，当数据条数超过当前显示区域时，可上下滑动查看`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `data` :Array : 横排柱形图关键结点的数据，数据排列方式为从下而上
	 *
	 * `styles` :any : （可选项）模块视图内元素样式设置
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	open(params:thwartwiseBarChart_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `重新加载数据，当数据条数超过当前显示区域时，可上下滑动查看`
	 * ========params==========
	 *
	 * `id` :number : 要刷新数据的模块的 id
	 *
	 * `data` :Array : 横排柱形图关键结点的数据，数据排列方式为从下而上
	 */
	reloadData(params:thwartwiseBarChart_reloadData_Params, callback?: (ret:JSON) => void):void

	/**
	 * `关闭柱状图，并从内存里清除`
	 * ========params==========
	 *
	 * `id` :number : 要关闭的模块的 id
	 */
	close(params:thwartwiseBarChart_close_Params):void

	/**
	 * `隐藏柱状图视图，并没有从内存里清除，可调用 show 接口显示`
	 * ========params==========
	 *
	 * `id` :number : 要隐藏的模块的 id
	 */
	hide(params:thwartwiseBarChart_hide_Params):void

	/**
	 * `显示已隐藏的柱状图视图`
	 * ========params==========
	 *
	 * `id` :number : 要显示的模块的 id
	 */
	show(params:thwartwiseBarChart_show_Params):void

}
interface thwartwiseBarChart_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**横排柱形图关键结点的数据，数据排列方式为从下而上*/ 
	data:Array,

	/**（可选项）模块视图内元素样式设置*/ 
	styles?:any,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface thwartwiseBarChart_reloadData_Params {
	/**要刷新数据的模块的 id*/ 
	id:number,

	/**横排柱形图关键结点的数据，数据排列方式为从下而上*/ 
	data:Array,

}

interface thwartwiseBarChart_close_Params {
	/**要关闭的模块的 id*/ 
	id:number,

}

interface thwartwiseBarChart_hide_Params {
	/**要隐藏的模块的 id*/ 
	id:number,

}

interface thwartwiseBarChart_show_Params {
	/**要显示的模块的 id*/ 
	id:number,

}

interface doubleSlider {
	/**
	 * `打开doubleSlider`
	 * ========params==========
	 *
	 * `orientation` :string : （可选项）滑动控件的朝向：vertical | horizontal
	 *
	 * `animation` :boolean : （可选项）当值发生改变时，如 click 事件，是否为滑块的移动显示动画
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸(底部滑杆)
	 *
	 * `bubble` :JSON : 提示气泡设置
	 *
	 * `handler` :JSON : 滑块设置
	 *
	 * `bar` :JSON : 滑动条设置
	 *
	 * `value` :JSON : 滑动控件的值设置
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）是否将模块视图固定到窗口上，不跟随窗口上下滚动
	 *
	 * `frequency` :string : （可选项）滑动时回调函数触发的频率
	 */
	open(params:doubleSlider_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `设置doubleSlider的值`
	 * ========params==========
	 *
	 * `id` :number : 指定滑动控件的唯一标识，当 open 成功后返回
	 *
	 * `value` :JSON : 要设置的值
	 */
	setValue(params:doubleSlider_setValue_Params):void

	/**
	 * `锁定doubleSlider的值`
	 * ========params==========
	 *
	 * `id` :string : 指定滑动控件的唯一标识，当 open 成功后返回
	 *
	 * `lock` :boolean : （可选项）是否锁定指定模块
	 */
	lock(params:doubleSlider_lock_Params):void

	/**
	 * `关闭doubleSlider`
	 * ========params==========
	 *
	 * `id` :string : 指定滑动控件的唯一标识，当 open 成功后返回
	 */
	close(params:doubleSlider_close_Params):void

	/** 显示双向滑动条*/ 
	show():void

	/** 隐藏双向滑动条*/ 
	hide():void

	/** 若滑动选择器配置显示了气泡，通过调用此接口可自定义气泡显示内容，此时模块会忽略选择器的气泡显示的当前值（open -> bubble 配置显示的内容-------prefix + 当前值 + suffix）。*/ 
	setBubble():void

}
interface doubleSlider_open_Params {
	/**（可选项）滑动控件的朝向：vertical | horizontal*/ 
	orientation?:string,

	/**（可选项）当值发生改变时，如 click 事件，是否为滑块的移动显示动画*/ 
	animation?:boolean,

	/**（可选项）模块的位置及尺寸(底部滑杆)*/ 
	rect?:JSON,

	/**提示气泡设置*/ 
	bubble:JSON,

	/**滑块设置*/ 
	handler:JSON,

	/**滑动条设置*/ 
	bar:JSON,

	/**滑动控件的值设置*/ 
	value:JSON,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）是否将模块视图固定到窗口上，不跟随窗口上下滚动*/ 
	fixed?:boolean,

	/**（可选项）滑动时回调函数触发的频率*/ 
	frequency?:string,

}

interface doubleSlider_setValue_Params {
	/**指定滑动控件的唯一标识，当 open 成功后返回*/ 
	id:number,

	/**要设置的值*/ 
	value:JSON,

}

interface doubleSlider_lock_Params {
	/**指定滑动控件的唯一标识，当 open 成功后返回*/ 
	id:string,

	/**（可选项）是否锁定指定模块*/ 
	lock?:boolean,

}

interface doubleSlider_close_Params {
	/**指定滑动控件的唯一标识，当 open 成功后返回*/ 
	id:string,

}

interface UIChatBar {
	/** 打开聊天输入框*/ 
	open(callback?: (ret:JSON) => void):void

	/** 关闭聊天输入框*/ 
	close():void

	/** 显示聊天输入框*/ 
	show():void

	/** 隐藏聊天输入框*/ 
	hide():void

	/**
	 * `弹出自定义、附加功能面板`
	 * ========params==========
	 *
	 * `target` :string : 操作的面板类型，取值范围如下：
	 */
	popupBoard(params:UIChatBar_popupBoard_Params):void

	/** 收起自定义、附加功能面板*/ 
	closeBoard():void

	/** 弹出键盘*/ 
	popupKeyboard():void

	/** 收起键盘*/ 
	closeKeyboard():void

	/**
	 * `获取或设置聊天输入框的内容`
	 * ========params==========
	 *
	 * `msg` :string : （可选项）聊天输入框的内容，若不传则返回输入框的值
	 */
	value(params:UIChatBar_value_Params, callback?: (ret:JSON) => void):void

	/**
	 * `向聊天输入框的指定位置插入内容`
	 * ========params==========
	 *
	 * `index` :number : （可选项）待插入内容的起始位置。**注意：中文，全角符号均占一个字符长度；索引从0开始，0表示插入到最前面，1表示插入到第一个字符后面，2表示插入到第二个字符后面，以此类推。**
	 *
	 * `msg` :string : （可选项）要插入的内容
	 */
	insertValue(params:UIChatBar_insertValue_Params):void

	/**
	 * `事件监听`
	 * ========params==========
	 *
	 * `target` :string : 事件的目标对象
	 *
	 * `name` :string : 监听的事件类型
	 */
	addEventListener(params:UIChatBar_addEventListener_Params, callback?: (ret:JSON) => void):void

	/**
	 * `重设聊天输入框的占位提示文本`
	 * ========params==========
	 *
	 * `placeholder` :string : （可选项）占位提示文本，若不传或传空则表示清空占位提示内容
	 */
	setPlaceholder(params:UIChatBar_setPlaceholder_Params):void

	/**
	 * `重新加载（刷新）附加功能面板，**open时必须添加附加功能按钮及其面板参数**`
	 * ========params==========
	 *
	 * `extras` :JSON : （可选项）点击附加功能按钮，打开的附加功能面板的按钮样式，配合 extrasBtn 一起使用，若 extrasBtn 参数内 normalImg 属性不传则此参数可不传
	 */
	reloadExtraBoard(params:UIChatBar_reloadExtraBoard_Params):void

}
interface UIChatBar_popupBoard_Params {
	/**操作的面板类型，取值范围如下：*/ 
	target:string,

}

interface UIChatBar_value_Params {
	/**（可选项）聊天输入框的内容，若不传则返回输入框的值*/ 
	msg?:string,

}

interface UIChatBar_insertValue_Params {
	/**（可选项）待插入内容的起始位置。**注意：中文，全角符号均占一个字符长度；索引从0开始，0表示插入到最前面，1表示插入到第一个字符后面，2表示插入到第二个字符后面，以此类推。***/ 
	index?:number,

	/**（可选项）要插入的内容*/ 
	msg?:string,

}

interface UIChatBar_addEventListener_Params {
	/**事件的目标对象*/ 
	target:string,

	/**监听的事件类型*/ 
	name:string,

}

interface UIChatBar_setPlaceholder_Params {
	/**（可选项）占位提示文本，若不传或传空则表示清空占位提示内容*/ 
	placeholder?:string,

}

interface UIChatBar_reloadExtraBoard_Params {
	/**（可选项）点击附加功能按钮，打开的附加功能面板的按钮样式，配合 extrasBtn 一起使用，若 extrasBtn 参数内 normalImg 属性不传则此参数可不传*/ 
	extras?:JSON,

}

interface UIAlbumSelector {
	/** 判断当前 App 访问系统相册权限*/ 
	authorizationStatus():void

	/**
	 * `打开多媒体资源选择器，打开后会全屏显示`
	 * ========params==========
	 *
	 * `maxAlert` :JSON : （可选项）超出设置的最大选取数时的提示
	 *
	 * `type` :string : （可选项）显示图片或视频
	 *
	 * `selectedAll` :boolean : （可选项）当type为all时，视频和图片能不能同时选中，仅当type为all时本参数有意义。若为false则非首选资源类型元素上置有遮罩层变为不可选状态（仅iOS支持）
	 *
	 * `selectedNumber` :boolean : （可选项）照片选中状态是否显示数字，设置为true后注意selected（选中图标）不建议使用模块默认图片（仅iOS支持）
	 *
	 * `styles` :JSON : （可选项）模块各部分的样式配置
	 */
	open(params:UIAlbumSelector_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `扫描系统多媒体资源，可以通过 Web 代码自定义多选界面。`
	 * ========params==========
	 *
	 * `type` :string : 返回的资源种类；默认：'all'
	 *
	 * `count` :number : （可选项）每次返回的资源数量，剩余资源可用 fetch 接口遍历（仅iOS支持，android返回所有资源）
	 *
	 * `sort` :JSON : （可选项）图片排序方式
	 *
	 * `thumbnail` :JSON : （可选项）返回的缩略图配置，**建议本图片不要设置过大** 若已有缩略图，则使用已有的缩略图。若要重新生成缩略图，可先调用清除缓存接口 clearCache()。（仅iOS支持，android获取系统缩略图）
	 */
	scan(params:UIAlbumSelector_scan_Params, callback?: (ret:JSON) => void):void

	/**
	 * `获取系统多媒体资源的分组`
	 * ========params==========
	 *
	 * `type` :string : 返回的资源种类；默认：'all'
	 *
	 * `thumbnail` :JSON : （可选项）返回的分组的缩略图配置，**建议本图片不要设置过大** 若已有缩略图，则使用已有的缩略图。若要重新生成缩略图，可先调用清除缓存接口 clearCache()。（仅iOS支持，android获取系统缩略图）
	 */
	scanGroups(params:UIAlbumSelector_scanGroups_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据分组id，扫描系统多媒体资源。（android根据分组name返回）`
	 * ========params==========
	 *
	 * `groupId` :string : 分组id（仅iOS支持）
	 *
	 * `groupName` :string : 分组名称（仅android支持）
	 *
	 * `type` :string : 分组类型；默认：'all'
	 *
	 * `count` :number : （可选项）每次返回的资源数量，剩余资源可用 fetchGroup 接口遍历（仅iOS支持，android返回全部资源）
	 *
	 * `sort` :JSON : （可选项）图片排序方式
	 *
	 * `thumbnail` :JSON : （可选项）返回的缩略图配置，**建议本图片不要设置过大** 若已有缩略图，则使用已有的缩略图。若要重新生成缩略图，可先调用清除缓存接口 clearCache()。（仅iOS支持，android返回系统缩略图）
	 */
	scanByGroupId(params:UIAlbumSelector_scanByGroupId_Params, callback?: (ret:JSON) => void):void

	/**
	 * `视频路径转化（仅iOS支持）`
	 * ========params==========
	 *
	 * `path` :string : 要转换的视频路径
	 */
	transVideoPath(params:UIAlbumSelector_transVideoPath_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 清除本模块缓存到沙盒的图片、视频，**本接口只清除本模块缓存的数据，若要清除本 app 缓存的所有数据则调用 api.clearCache***/ 
	clearCache():void

}
interface UIAlbumSelector_open_Params {
	/**（可选项）超出设置的最大选取数时的提示*/ 
	maxAlert?:JSON,

	/**（可选项）显示图片或视频*/ 
	type?:string,

	/**（可选项）当type为all时，视频和图片能不能同时选中，仅当type为all时本参数有意义。若为false则非首选资源类型元素上置有遮罩层变为不可选状态（仅iOS支持）*/ 
	selectedAll?:boolean,

	/**（可选项）照片选中状态是否显示数字，设置为true后注意selected（选中图标）不建议使用模块默认图片（仅iOS支持）*/ 
	selectedNumber?:boolean,

	/**（可选项）模块各部分的样式配置*/ 
	styles?:JSON,

}

interface UIAlbumSelector_scan_Params {
	/**返回的资源种类；默认：'all'*/ 
	type:string,

	/**（可选项）每次返回的资源数量，剩余资源可用 fetch 接口遍历（仅iOS支持，android返回所有资源）*/ 
	count?:number,

	/**（可选项）图片排序方式*/ 
	sort?:JSON,

	/**（可选项）返回的缩略图配置，**建议本图片不要设置过大** 若已有缩略图，则使用已有的缩略图。若要重新生成缩略图，可先调用清除缓存接口 clearCache()。（仅iOS支持，android获取系统缩略图）*/ 
	thumbnail?:JSON,

}

interface UIAlbumSelector_scanGroups_Params {
	/**返回的资源种类；默认：'all'*/ 
	type:string,

	/**（可选项）返回的分组的缩略图配置，**建议本图片不要设置过大** 若已有缩略图，则使用已有的缩略图。若要重新生成缩略图，可先调用清除缓存接口 clearCache()。（仅iOS支持，android获取系统缩略图）*/ 
	thumbnail?:JSON,

}

interface UIAlbumSelector_scanByGroupId_Params {
	/**分组id（仅iOS支持）*/ 
	groupId:string,

	/**分组名称（仅android支持）*/ 
	groupName:string,

	/**分组类型；默认：'all'*/ 
	type:string,

	/**（可选项）每次返回的资源数量，剩余资源可用 fetchGroup 接口遍历（仅iOS支持，android返回全部资源）*/ 
	count?:number,

	/**（可选项）图片排序方式*/ 
	sort?:JSON,

	/**（可选项）返回的缩略图配置，**建议本图片不要设置过大** 若已有缩略图，则使用已有的缩略图。若要重新生成缩略图，可先调用清除缓存接口 clearCache()。（仅iOS支持，android返回系统缩略图）*/ 
	thumbnail?:JSON,

}

interface UIAlbumSelector_transVideoPath_Params {
	/**要转换的视频路径*/ 
	path:string,

}

interface UIAlbum {
	/**
	 * `打开图片资源选择器，打开后会全屏显示`
	 * ========params==========
	 *
	 * `max` :number : （可选项）最多选择几张图片
	 *
	 * `styles` :JSON : （可选项）模块各部分的样式
	 */
	open(params:UIAlbum_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭图片资源选择器*/ 
	close():void

	/**
	 * `将相册图片地址转换为可以直接使用的本地路径地址（临时文件夹的绝对路径），**相册图片会被拷贝到临时文件夹，调用 api.clearCache 接口可清除该临时图片文件**`
	 * ========params==========
	 *
	 * `path` :string : 要转换的图片路径（在相册库的绝对路径）
	 */
	transPath(params:UIAlbum_transPath_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 请求相册权限*/ 
	requestAlbumPermissions():void

}
interface UIAlbum_open_Params {
	/**（可选项）最多选择几张图片*/ 
	max?:number,

	/**（可选项）模块各部分的样式*/ 
	styles?:JSON,

}

interface UIAlbum_transPath_Params {
	/**要转换的图片路径（在相册库的绝对路径）*/ 
	path:string,

}

interface UIWebBrowser {
	/**
	 * `打开模块`
	 * ========params==========
	 *
	 * `path` :string : 打开的页面所加载的 html 文件路径，支持本地、网络协议（http://、fs://、widget://）
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `button` :JSON : （可选项）模块上的控制按钮配置，本参数可不传，若不传则不显示控制按钮
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	open(params:UIWebBrowser_open_Params, callback?: (ret:JSON) => void):void

	/** 隐藏模块*/ 
	hide():void

	/** 显示已隐藏的模块*/ 
	show():void

	/** 关闭模块*/ 
	close():void

	/**
	 * `重设模块的 rect`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `animation` :boolean : （可选项）重设 rect 时，是否带动画效果
	 */
	setRect(params:UIWebBrowser_setRect_Params):void

	/** 设置按钮选中/取消状态*/ 
	setSelected():void

}
interface UIWebBrowser_open_Params {
	/**打开的页面所加载的 html 文件路径，支持本地、网络协议（http://、fs://、widget://）*/ 
	path:string,

	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**（可选项）模块上的控制按钮配置，本参数可不传，若不传则不显示控制按钮*/ 
	button?:JSON,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface UIWebBrowser_setRect_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**（可选项）重设 rect 时，是否带动画效果*/ 
	animation?:boolean,

}

interface noticeView {
	/**
	 * `打开notiveView轮播公告`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `style` :JSON : （可选项）模块的样式
	 *
	 * `icon` :JSON : （可选项）模块左侧图片样式
	 *
	 * `message` :JSON : （可选项）模块轮播公告内容文字样式
	 *
	 * `line` :JSON : （可选项）模块内分割线样式
	 *
	 * `right` :JSON : （可选项）模块右侧文字按钮样式
	 *
	 * `data` :JSON : （可选项）轮播公告的数据源
	 *
	 * `Interval` :number : （可选项）模块公告的轮播频率；单位：s
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 */
	open(params:noticeView_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `向列表末端追加数据`
	 * ========params==========
	 *
	 * `data` :JSON : （可选项）公告的数据源
	 */
	appendData(params:noticeView_appendData_Params):void

	/**
	 * `刷新列表数据`
	 * ========params==========
	 *
	 * `data` :JSON : （可选项）公告的数据源
	 */
	reloadData(params:noticeView_reloadData_Params):void

}
interface noticeView_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**（可选项）模块的样式*/ 
	style?:JSON,

	/**（可选项）模块左侧图片样式*/ 
	icon?:JSON,

	/**（可选项）模块轮播公告内容文字样式*/ 
	message?:JSON,

	/**（可选项）模块内分割线样式*/ 
	line?:JSON,

	/**（可选项）模块右侧文字按钮样式*/ 
	right?:JSON,

	/**（可选项）轮播公告的数据源*/ 
	data?:JSON,

	/**（可选项）模块公告的轮播频率；单位：s*/ 
	Interval?:number,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

}

interface noticeView_appendData_Params {
	/**（可选项）公告的数据源*/ 
	data?:JSON,

}

interface noticeView_reloadData_Params {
	/**（可选项）公告的数据源*/ 
	data?:JSON,

}

interface UIListSearch {
	/**
	 * `打开列表模块`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `contacts` :Array : 列表数据源
	 *
	 * `label` :JSON : （可选项）底部标签配置，若不传则不显示底部标签。此参数即将废弃，用labels参数替代，若传了labels参数，label参数将被忽略。
	 *
	 * `labels` :Array<JSON> : （可选项）底部标签配置，若不传则不显示底部标签。
	 *
	 * `labelEnabled` :boolean : （可选项）底部标签是否可以点击交互，若设置为能点击，点击后会回调label的索引及内容。
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 */
	open(params:UIListSearch_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭数据列表模块，从内存里清除*/ 
	close():void

	/** 显示已隐藏的列表模块*/ 
	show():void

	/** 隐藏列表模块，并未从内存里清除*/ 
	hide():void

	/**
	 * `刷新列表数据`
	 * ========params==========
	 *
	 * `contacts` :Array : 列表数据源
	 *
	 * `label` :JSON : （可选项）底部标签配置，若不传则不显示底部标签。此参数即将废弃，用labels参数替代，若传了labels参数，label参数将被忽略。
	 *
	 * `labels` :Array<JSON> : （可选项）底部标签配置，若不传则不显示底部标签。
	 */
	reloadData(params:UIListSearch_reloadData_Params):void

}
interface UIListSearch_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**列表数据源*/ 
	contacts:Array,

	/**（可选项）底部标签配置，若不传则不显示底部标签。此参数即将废弃，用labels参数替代，若传了labels参数，label参数将被忽略。*/ 
	label?:JSON,

	/**（可选项）底部标签配置，若不传则不显示底部标签。*/ 
	labels?:Array<JSON>,

	/**（可选项）底部标签是否可以点击交互，若设置为能点击，点击后会回调label的索引及内容。*/ 
	labelEnabled?:boolean,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

}

interface UIListSearch_reloadData_Params {
	/**列表数据源*/ 
	contacts:Array,

	/**（可选项）底部标签配置，若不传则不显示底部标签。此参数即将废弃，用labels参数替代，若传了labels参数，label参数将被忽略。*/ 
	label?:JSON,

	/**（可选项）底部标签配置，若不传则不显示底部标签。*/ 
	labels?:Array<JSON>,

}

interface cityPicker {
	/**
	 * `打开城市选择器`
	 * ========params==========
	 *
	 * `province` :string : （可选项）默认选择省份
	 */
	chooseCity(params:cityPicker_chooseCity_Params, callback?: (ret:JSON) => void):void

}
interface cityPicker_chooseCity_Params {
	/**（可选项）默认选择省份*/ 
	province?:string,

}

interface keyboard {
	/**
	 * `打开自定义的数字键盘界面。键盘的默认高度为203。位置的设置请自己进行处理。`
	 * ========params==========
	 *
	 * `x` :number : （必填项）模块左上角的 x 坐标（相对于所属的 Window 或 Frame）
	 *
	 * `y` :number : （必填项）模块左上角的 y 坐标（相对于所属的 Window 或 Frame）
	 *
	 * `dotLable` :string : （可选项）自定义数字键盘dot显示文本
	 *
	 * `fixedOn` :string : （可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window
	 *
	 * `fixed` :boolean : （（可选项）模块是否随所属 Window 或 Frame 滚动
	 */
	openKeyboard(params:keyboard_openKeyboard_Params, callback?: (ret:JSON) => void):void

	/** 隐藏数字键盘*/ 
	hiddenKeyboard(callback?: (ret:JSON, err:JSON) => void):void

	/** 显示被隐藏的数字键盘*/ 
	showKeyboard(callback?: (ret:JSON, err:JSON) => void):void

	/** 关闭打开的数字键盘*/ 
	closeKeyboard(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `打开自定义的文本编辑框，(注意：目前暂时只支持从文本最后删除和插入，不支持文本中进行插入和删除)。`
	 * ========params==========
	 *
	 * `x` :number : （必填项）模块左上角的 x 坐标（相对于所属的 Window 或 Frame）
	 *
	 * `y` :number : （必填项）模块左上角的 y 坐标（相对于所属的 Window 或 Frame）
	 *
	 * `w` :number : （可选项）模块的宽度；默认：所属的 Window 或 Frame 的宽度
	 *
	 * `h` :number : （可选项）模块的高度；默认：所属的 Window 或 Frame 的高度
	 *
	 * `fixedOn` :string : （可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window
	 *
	 * `fixed` :boolean : （（可选项）模块是否随所属 Window 或 Frame 滚动
	 *
	 * `message` :string : （可选项）默认要显示的文本消息内容。
	 *
	 * `placeholder` :string : （可选项）当内容为空时显示的文本提示内容。
	 */
	openEditText(params:keyboard_openEditText_Params, callback?: (ret:JSON) => void):void

	/**
	 * `打开自定义的26位字母键盘界面。键盘的默认高度为203。位置的设置请自己进行处理。`
	 * ========params==========
	 *
	 * `x` :number : （必填项）模块左上角的 x 坐标（相对于所属的 Window 或 Frame）
	 *
	 * `y` :number : （必填项）模块左上角的 y 坐标（相对于所属的 Window 或 Frame）
	 *
	 * `fixedOn` :string : （可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window
	 *
	 * `fixed` :string : （可选项）alt键按切换后左下角显示文字
	 *
	 * `returnLabel` :string : （可选项）右下角键按显示文字
	 *
	 * `spaceLabel` :string : （可选项）空格键按钮显示文字
	 *
	 * `charDefault` :Array : （必须项）默认显示在键盘上的信息，长度必须位26，可为小写26字母
	 *
	 * `charShift` :Array : （必须项）点击shift按钮切换在键盘上的信息，长度必须位26，可为大写26字母
	 *
	 * `charAlt` :Array : （必须项）点击alt按钮切换在键盘上的信息，长度必须位26，可为数字和特殊符号集合
	 */
	openCustomKeyboard(params:keyboard_openCustomKeyboard_Params, callback?: (ret:JSON) => void):void

	/** 隐藏字母键盘*/ 
	hiddenCustomKeyboard(callback?: (ret:JSON, err:JSON) => void):void

	/** 显示被隐藏的字母键盘*/ 
	showCustomKeyboard(callback?: (ret:JSON, err:JSON) => void):void

	/** 关闭打开的字母键盘*/ 
	closeCustomKeyboard(callback?: (ret:JSON, err:JSON) => void):void

}
interface keyboard_openKeyboard_Params {
	/**（必填项）模块左上角的 x 坐标（相对于所属的 Window 或 Frame）*/ 
	x:number,

	/**（必填项）模块左上角的 y 坐标（相对于所属的 Window 或 Frame）*/ 
	y:number,

	/**（可选项）自定义数字键盘dot显示文本*/ 
	dotLable?:string,

	/**（可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window*/ 
	fixedOn?:string,

	/**（（可选项）模块是否随所属 Window 或 Frame 滚动*/ 
	fixed?:boolean,

}

interface keyboard_openEditText_Params {
	/**（必填项）模块左上角的 x 坐标（相对于所属的 Window 或 Frame）*/ 
	x:number,

	/**（必填项）模块左上角的 y 坐标（相对于所属的 Window 或 Frame）*/ 
	y:number,

	/**（可选项）模块的宽度；默认：所属的 Window 或 Frame 的宽度*/ 
	w?:number,

	/**（可选项）模块的高度；默认：所属的 Window 或 Frame 的高度*/ 
	h?:number,

	/**（可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window*/ 
	fixedOn?:string,

	/**（（可选项）模块是否随所属 Window 或 Frame 滚动*/ 
	fixed?:boolean,

	/**（可选项）默认要显示的文本消息内容。*/ 
	message?:string,

	/**（可选项）当内容为空时显示的文本提示内容。*/ 
	placeholder?:string,

}

interface keyboard_openCustomKeyboard_Params {
	/**（必填项）模块左上角的 x 坐标（相对于所属的 Window 或 Frame）*/ 
	x:number,

	/**（必填项）模块左上角的 y 坐标（相对于所属的 Window 或 Frame）*/ 
	y:number,

	/**（可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window*/ 
	fixedOn?:string,

	/**（可选项）alt键按切换后左下角显示文字*/ 
	fixed?:string,

	/**（可选项）右下角键按显示文字*/ 
	returnLabel?:string,

	/**（可选项）空格键按钮显示文字*/ 
	spaceLabel?:string,

	/**（必须项）默认显示在键盘上的信息，长度必须位26，可为小写26字母*/ 
	charDefault:Array,

	/**（必须项）点击shift按钮切换在键盘上的信息，长度必须位26，可为大写26字母*/ 
	charShift:Array,

	/**（必须项）点击alt按钮切换在键盘上的信息，长度必须位26，可为数字和特殊符号集合*/ 
	charAlt:Array,

}

interface UIChatInput {
	/** 打开聊天输入框*/ 
	open(callback?: (ret:JSON) => void):void

	/** 关闭聊天输入框*/ 
	close():void

	/** 显示聊天输入框*/ 
	show():void

	/** 隐藏聊天输入框*/ 
	hide():void

	/**
	 * `弹出表情、附加功能面板`
	 * ========params==========
	 *
	 * `target` :string : 操作的面板类型，取值范围如下：
	 */
	popupBoard(params:UIChatInput_popupBoard_Params):void

	/** 收起表情、附加功能面板*/ 
	closeBoard():void

	/** 弹出键盘*/ 
	popupKeyboard():void

	/** 收起键盘*/ 
	closeKeyboard():void

	/**
	 * `获取或设置聊天输入框的内容`
	 * ========params==========
	 *
	 * `msg` :string : （可选项）聊天输入框的内容，若不传则返回输入框的值
	 */
	value(params:UIChatInput_value_Params, callback?: (ret:JSON) => void):void

	/**
	 * `向聊天输入框的指定位置插入内容`
	 * ========params==========
	 *
	 * `index` :number : （可选项）待插入内容的起始位置。**注意：中文，全角符号均占一个字符长度；索引从0开始，0表示插入到最前面，1表示插入到第一个字符后面，2表示插入到第二个字符后面，以此类推。**
	 *
	 * `msg` :string : （可选项）要插入的内容
	 */
	insertValue(params:UIChatInput_insertValue_Params):void

	/**
	 * `事件监听`
	 * ========params==========
	 *
	 * `target` :string : 事件的目标对象
	 *
	 * `name` :string : 监听的事件类型
	 */
	addEventListener(params:UIChatInput_addEventListener_Params, callback?: (ret:JSON) => void):void

	/**
	 * `重设聊天输入框的占位提示文本`
	 * ========params==========
	 *
	 * `placeholder` :string : （可选项）占位提示文本，若不传或传空则表示清空占位提示内容
	 */
	setPlaceholder(params:UIChatInput_setPlaceholder_Params):void

	/**
	 * `重新加载（刷新）附加功能面板，**open时必须添加附加功能按钮及其面板参数**`
	 * ========params==========
	 *
	 * `extras` :JSON : （可选项）点击附加功能按钮，打开的附加功能面板的按钮样式，配合 extrasBtn 一起使用，若 extrasBtn 参数内 normalImg 属性不传则此参数可不传
	 */
	reloadExtraBoard(params:UIChatInput_reloadExtraBoard_Params):void

	/**
	 * `切换输入区域`
	 * ========params==========
	 *
	 * `type` :string : 输入区域类型
	 */
	switchInputArea(params:UIChatInput_switchInputArea_Params):void

	/** 设置切换（输入框/录音按钮）按钮的图标*/ 
	setSwitchBtnIcon():void

}
interface UIChatInput_popupBoard_Params {
	/**操作的面板类型，取值范围如下：*/ 
	target:string,

}

interface UIChatInput_value_Params {
	/**（可选项）聊天输入框的内容，若不传则返回输入框的值*/ 
	msg?:string,

}

interface UIChatInput_insertValue_Params {
	/**（可选项）待插入内容的起始位置。**注意：中文，全角符号均占一个字符长度；索引从0开始，0表示插入到最前面，1表示插入到第一个字符后面，2表示插入到第二个字符后面，以此类推。***/ 
	index?:number,

	/**（可选项）要插入的内容*/ 
	msg?:string,

}

interface UIChatInput_addEventListener_Params {
	/**事件的目标对象*/ 
	target:string,

	/**监听的事件类型*/ 
	name:string,

}

interface UIChatInput_setPlaceholder_Params {
	/**（可选项）占位提示文本，若不传或传空则表示清空占位提示内容*/ 
	placeholder?:string,

}

interface UIChatInput_reloadExtraBoard_Params {
	/**（可选项）点击附加功能按钮，打开的附加功能面板的按钮样式，配合 extrasBtn 一起使用，若 extrasBtn 参数内 normalImg 属性不传则此参数可不传*/ 
	extras?:JSON,

}

interface UIChatInput_switchInputArea_Params {
	/**输入区域类型*/ 
	type:string,

}

interface frameTree {
	/**
	 * `打开 frame 并加入树管理`
	 * ========params==========
	 *
	 * `name` :string : frame 名字
	 *
	 * `url` :string : 页面地址，可以为本地文件路径，支持相对路径和绝对路径，以及 widget://、fs://等协议路径，也可以为远程地址
	 *
	 * `rect` :JSON : （可选项）frame 的位置和大小
	 *
	 * `fixedOn` :string : （可选项）父节点frame，如果不写或者""就是win，这样打开的frame就在第1层。想在当前frame打开子frame，可传递api.frameName
	 *
	 * `offsetX` :number : （可选项）绑定相对于父节点的x坐标，添加此参数将忽略rect中的x值
	 *
	 * `offsetY` :number : （可选项）绑定相对于父节点的y坐标，添加此参数将忽略rect中的y值
	 *
	 * `preload` :boolean : （可选项）是否预加载，true会在同层级的底层打开，不会影响前面的frame，如果同层级还没有frame，那么即使true也会看到的
	 */
	openFrame(params:frameTree_openFrame_Params):void

	/**
	 * `关闭 frame 并关闭所有子 frame`
	 * ========params==========
	 *
	 * `name` :string : frame 名字
	 */
	closeFrame(params:frameTree_closeFrame_Params):void

	/**
	 * `在同层中移动显示顺序，子frame也会相应变动`
	 * ========params==========
	 *
	 * `from` :string : 待调整显示顺序的 frame 名字
	 *
	 * `to` :string : （可选项）frame 名字，不传时调整 from 对应 frame 到本层级的最高层，否则调整 from 对应 frame 到此 frame 前面，特殊参数"~frameTreeMin~"，调整 from 对应 frame 到本层级的最低层
	 */
	FrameTo(params:frameTree_FrameTo_Params):void

	/**
	 * `设置 frame 属性，没写的参数和api.setFrameAttr一样,参见[//docs.apicloud.com/Client-API/api#41](//docs.apicloud.com/Client-API/api#41)`
	 * ========params==========
	 *
	 * `name` :string : frame 名字
	 *
	 * `rect` :JSON : （可选项）frame 的位置和大小
	 *
	 * `offsetX` :number : （可选项）绑定相对于父节点的x坐标，添加此参数将忽略rect中的x值
	 *
	 * `offsetY` :number : （可选项）绑定相对于父节点的y坐标，添加此参数将忽略rect中的y值
	 */
	setFrameAttr(params:frameTree_setFrameAttr_Params):void

	/**
	 * `设置 frame 的xy是否绑定到父节点，通过本模块openFrame的 frame 是默认绑定的`
	 * ========params==========
	 *
	 * `name` :string : 待调整绑定的 frame 名字
	 *
	 * `bindX` :boolean : （可选项）是否绑定到父节点的x坐标，如true父节点的x变动时 name 对应 frame 的x也会相应变动，反之则反
	 *
	 * `bindY` :boolean : （可选项）是否绑定到父节点的y坐标，如true父节点的y变动时 name 对应 frame 的y也会相应变动，反之则反
	 *
	 * `x` :number : （可选项）name 对应 frame 的x相对于窗口的坐标改变，这个只是修正了对象内部值，不会立即有所变化，而且也不影响子 frame ，这个只是用来配合frameTree.setFrameAttr时用
	 *
	 * `y` :number : （可选项）name 对应 frame 的y相对于窗口的坐标改变，这个只是修正了对象内部值，不会立即有所变化，而且也不影响子 frame ，这个只是用来配合frameTree.setFrameAttr时用
	 */
	setFrameBind(params:frameTree_setFrameBind_Params):void

	/** 刷新树层级显示，一般不用调用这个函数，如果发现显示层次混乱了就调用一下。*/ 
	update():void

}
interface frameTree_openFrame_Params {
	/**frame 名字*/ 
	name:string,

	/**页面地址，可以为本地文件路径，支持相对路径和绝对路径，以及 widget://、fs://等协议路径，也可以为远程地址*/ 
	url:string,

	/**（可选项）frame 的位置和大小*/ 
	rect?:JSON,

	/**（可选项）父节点frame，如果不写或者""就是win，这样打开的frame就在第1层。想在当前frame打开子frame，可传递api.frameName*/ 
	fixedOn?:string,

	/**（可选项）绑定相对于父节点的x坐标，添加此参数将忽略rect中的x值*/ 
	offsetX?:number,

	/**（可选项）绑定相对于父节点的y坐标，添加此参数将忽略rect中的y值*/ 
	offsetY?:number,

	/**（可选项）是否预加载，true会在同层级的底层打开，不会影响前面的frame，如果同层级还没有frame，那么即使true也会看到的*/ 
	preload?:boolean,

}

interface frameTree_closeFrame_Params {
	/**frame 名字*/ 
	name:string,

}

interface frameTree_FrameTo_Params {
	/**待调整显示顺序的 frame 名字*/ 
	from:string,

	/**（可选项）frame 名字，不传时调整 from 对应 frame 到本层级的最高层，否则调整 from 对应 frame 到此 frame 前面，特殊参数"~frameTreeMin~"，调整 from 对应 frame 到本层级的最低层*/ 
	to?:string,

}

interface frameTree_setFrameAttr_Params {
	/**frame 名字*/ 
	name:string,

	/**（可选项）frame 的位置和大小*/ 
	rect?:JSON,

	/**（可选项）绑定相对于父节点的x坐标，添加此参数将忽略rect中的x值*/ 
	offsetX?:number,

	/**（可选项）绑定相对于父节点的y坐标，添加此参数将忽略rect中的y值*/ 
	offsetY?:number,

}

interface frameTree_setFrameBind_Params {
	/**待调整绑定的 frame 名字*/ 
	name:string,

	/**（可选项）是否绑定到父节点的x坐标，如true父节点的x变动时 name 对应 frame 的x也会相应变动，反之则反*/ 
	bindX?:boolean,

	/**（可选项）是否绑定到父节点的y坐标，如true父节点的y变动时 name 对应 frame 的y也会相应变动，反之则反*/ 
	bindY?:boolean,

	/**（可选项）name 对应 frame 的x相对于窗口的坐标改变，这个只是修正了对象内部值，不会立即有所变化，而且也不影响子 frame ，这个只是用来配合frameTree.setFrameAttr时用*/ 
	x?:number,

	/**（可选项）name 对应 frame 的y相对于窗口的坐标改变，这个只是修正了对象内部值，不会立即有所变化，而且也不影响子 frame ，这个只是用来配合frameTree.setFrameAttr时用*/ 
	y?:number,

}

interface UIAlbumBrowser {
	/**
	 * `打开多媒体资源选择器，打开后会全屏显示.`
	 * ========params==========
	 *
	 * `includeHiddenPicture` :boolean : （可选项）是否包括用户隐藏的照片
	 *
	 * `max` :number : （可选项）最多选择几张图片
	 *
	 * `type` :string : （可选项）显示图片或显示图片和视频
	 *
	 * `isOpenPreview` :boolean : （可选项）显是否打开预览界面
	 *
	 * `classify` :boolean : （可选项）是否将图片分类显示，为 true 时，会首先跳转到相册分类列表页面，false时打开第一个分组的详情。(仅对iOS有效)
	 *
	 * `selectedAll` :boolean : （可选项）当type为all时，视频和图片能不能同时选中，参考微信，仅当type为all时本参数有意义
	 *
	 * `styles` :JSON : （可选项）模块各部分的样式
	 *
	 * `rotation` :boolean : 屏幕是否旋转（横屏），为 true 时可以横竖屏旋转，false 时禁止横屏
	 *
	 * `alertTitle` :string : （可选项）超过设置的选中图片的数量时的提示框内容
	 *
	 * `alertBtnTitle` :string : （可选项）超过设置的选中图片的数量时的提示框按钮名称（仅iOS支持）
	 *
	 * `videoTimeFilter` :number : （可选项）视频时间长度超过此参数,禁止选取
	 */
	open(params:UIAlbumBrowser_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `打开图片选择器，打开后会全屏显示`
	 * ========params==========
	 *
	 * `max` :number : （可选项）最多选择几张图片
	 *
	 * `maxPrompt` :string : （可选项）超过最多选择的图片数时弹出的提示语
	 *
	 * `showCamera` :boolean : 是否显示相机
	 *
	 * `selectedPaths` :Array : （可选项）默认选中图片的路径组成的数组 (需传入path参数，用相机拍照后需传入assetPath参数)
	 *
	 * `styles` :JSON : （可选项）模块各部分的样式
	 *
	 * `isSystemCamera` :boolean : （可选项）拍照时是否调用系统相机
	 *
	 * `animation` :boolean : （可选项）点击下一步按钮时是否有动画
	 */
	imagePicker(params:UIAlbumBrowser_imagePicker_Params, callback?: (ret:JSON) => void):void

	/** 针对imagePicker接口关闭*/ 
	closePicker():void

	/** 请求相册权限*/ 
	requestAlbumPermissions():void

	/**
	 * `扫描系统多媒体资源，可以通过 Web 代码自定义多选界面。**注意：页面展示的图片建议使用缩略图，一次显示的图片不宜过多（1至2屏）**`
	 * ========params==========
	 *
	 * `type` :string : 返回的资源种类；默认：'all'
	 *
	 * `count` :number : （可选项）每次返回的资源数量，剩余资源可用 fetch 接口遍历
	 *
	 * `sort` :JSON : （可选项）图片排序方式
	 *
	 * `thumbnail` :JSON : （可选项）返回的缩略图配置，**建议本图片不要设置过大** 若已有缩略图，则使用已有的缩略图。若要重新生成缩略图，可先调用清除缓存接口api.clearCache()。
	 */
	scan(params:UIAlbumBrowser_scan_Params, callback?: (ret:JSON) => void):void

	/** 获取指定数量的多媒体资源，没有更多资源则返回空数组，**必须配合 scan 接口的 count 参数一起使用**。*/ 
	fetch():void

	/**
	 * `扫描系统多媒体资源的分组，可以通过 Web 代码自定义多选界面。`
	 * ========params==========
	 *
	 * `type` :string : 返回的资源种类；默认：'all'(iOS不支持)
	 *
	 * `thumbnail` :JSON : （可选项）返回的缩略图配置，**建议本图片不要设置过大** 若已有缩略图，则使用已有的缩略图。若要重新生成缩略图，可先调用清除缓存接口api.clearCache()。
	 */
	scanGroups(params:UIAlbumBrowser_scanGroups_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据分组id，扫描系统多媒体资源，可以通过 Web 代码自定义多选界面。**注意：页面展示的图片建议使用缩略图，一次显示的图片不宜过多（1至2屏）**`
	 * ========params==========
	 *
	 * `groupId` :string : 分组id；
	 *
	 * `type` :string : 分组类型；默认：'all'
	 *
	 * `count` :number : （可选项）每次返回的资源数量，剩余资源可用 fetchGroup 接口遍历
	 *
	 * `sort` :JSON : （可选项）图片排序方式
	 *
	 * `thumbnail` :JSON : （可选项）返回的缩略图配置，**建议本图片不要设置过大** 若已有缩略图，则使用已有的缩略图。若要重新生成缩略图，可先调用清除缓存接口api.clearCache()。
	 */
	scanByGroupId(params:UIAlbumBrowser_scanByGroupId_Params, callback?: (ret:JSON) => void):void

	/** 从分组中获取指定数量的多媒体资源，没有更多资源则返回空数组，**必须配合 scanByGroupId 接口的 count 参数一起使用**。*/ 
	fetchGroup():void

	/**
	 * `将相册图片地址转换为可以直接使用的本地路径地址（临时文件夹的绝对路径），**相册图片会被拷贝到临时文件夹，调用 api.clearCache 接口可清除该临时图片文件**`
	 * ========params==========
	 *
	 * `path` :string : 要转换的图片路径（在相册库的绝对路径）
	 *
	 * `quality` :string : 视频质量（android此参数为图片的quality，不支持视频）(iOS不支持)
	 *
	 * `scale` :number : 图片质量  (iOS不支持)
	 */
	transPath(params:UIAlbumBrowser_transPath_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `视频路径转化，**直接获取的路径需经本接口转换后才能使用（播放、上传等）**`
	 * ========params==========
	 *
	 * `path` :string : 要转换的视频路径（在相册库的绝对路径）
	 *
	 * `isSave` :boolean : 是否保存在沙盒 （仅支持iOS）
	 */
	transVideoPath(params:UIAlbumBrowser_transVideoPath_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `iOS在scan接口里面可以获取到时长.所以可以不用管.`
	 * ========params==========
	 *
	 * `path` :string : 视频资源路径（在相册库的绝对路径,另外支持 fs:// widget://路径）
	 */
	getVideoDuration(params:UIAlbumBrowser_getVideoDuration_Params, callback?: (ret:JSON) => void):void

	/**
	 * `以 frame 形式打开一个图片预览区域`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `groupId` :string : (可选项)要打开的相册分组 ID
	 *
	 * `selectedPaths` :Array : （可选项）图片预览区域默认选中图片的路径组成的数组
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	openGroup(params:UIAlbumBrowser_openGroup_Params, callback?: (ret:JSON) => void):void

	/** 关闭打开的相册分组预览区域*/ 
	closeGroup():void

	/**
	 * `通过分组ID改变预览区域显示的分组图片`
	 * ========params==========
	 *
	 * `groupId` :string : 要改变的相册分组 ID
	 *
	 * `selectedPaths` :Array : （可选项）图片预览区域默认选中图片的路径组成的数组
	 */
	changeGroup(params:UIAlbumBrowser_changeGroup_Params):void

	/**
	 * `以 frame 形式打开一个图片预览区域`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `groupId` :string : (可选项)要打开的相册分组 ID
	 *
	 * `max` :number : （可选项）最多选择几张图片，超过max则用户点击选中按钮只返回eventType为max的事件回调，不会执行选中操作（点击的图片还是未选中状态）
	 *
	 * `type` :string : （可选项）显示图片或显示图片和视频
	 *
	 * `styles` :JSON : 
	 *
	 * `videoPreview` :boolean : （可选项）选中视频资源时，是否进入预览页面，若为false则直接callback相关信息
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	openAlbum(params:UIAlbumBrowser_openAlbum_Params, callback?: (ret:JSON) => void):void

	/** 关闭 openAlbum 打开的相册预览区域*/ 
	closeAlbum():void

	/**
	 * `批量将相册图片地址转换为可以直接使用的本地路径地址（临时文件夹的绝对路径），**相册图片会被拷贝到临时文件夹，调用 api.clearCache 接口可清除该临时图片文件**`
	 * ========params==========
	 *
	 * `path` :Array : 要转换的图片路径（在相册库的绝对路径）
	 */
	batchTransPath(params:UIAlbumBrowser_batchTransPath_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取图片信息`
	 * ========params==========
	 *
	 * `imagePath` :string : 图片路径支持fs://,widget://;
	 */
	getImgInfo(params:UIAlbumBrowser_getImgInfo_Params, callback?: (ret:JSON) => void):void

}
interface UIAlbumBrowser_open_Params {
	/**（可选项）是否包括用户隐藏的照片*/ 
	includeHiddenPicture?:boolean,

	/**（可选项）最多选择几张图片*/ 
	max?:number,

	/**（可选项）显示图片或显示图片和视频*/ 
	type?:string,

	/**（可选项）显是否打开预览界面*/ 
	isOpenPreview?:boolean,

	/**（可选项）是否将图片分类显示，为 true 时，会首先跳转到相册分类列表页面，false时打开第一个分组的详情。(仅对iOS有效)*/ 
	classify?:boolean,

	/**（可选项）当type为all时，视频和图片能不能同时选中，参考微信，仅当type为all时本参数有意义*/ 
	selectedAll?:boolean,

	/**（可选项）模块各部分的样式*/ 
	styles?:JSON,

	/**屏幕是否旋转（横屏），为 true 时可以横竖屏旋转，false 时禁止横屏*/ 
	rotation:boolean,

	/**（可选项）超过设置的选中图片的数量时的提示框内容*/ 
	alertTitle?:string,

	/**（可选项）超过设置的选中图片的数量时的提示框按钮名称（仅iOS支持）*/ 
	alertBtnTitle?:string,

	/**（可选项）视频时间长度超过此参数,禁止选取*/ 
	videoTimeFilter?:number,

}

interface UIAlbumBrowser_imagePicker_Params {
	/**（可选项）最多选择几张图片*/ 
	max?:number,

	/**（可选项）超过最多选择的图片数时弹出的提示语*/ 
	maxPrompt?:string,

	/**是否显示相机*/ 
	showCamera:boolean,

	/**（可选项）默认选中图片的路径组成的数组 (需传入path参数，用相机拍照后需传入assetPath参数)*/ 
	selectedPaths?:Array,

	/**（可选项）模块各部分的样式*/ 
	styles?:JSON,

	/**（可选项）拍照时是否调用系统相机*/ 
	isSystemCamera?:boolean,

	/**（可选项）点击下一步按钮时是否有动画*/ 
	animation?:boolean,

}

interface UIAlbumBrowser_scan_Params {
	/**返回的资源种类；默认：'all'*/ 
	type:string,

	/**（可选项）每次返回的资源数量，剩余资源可用 fetch 接口遍历*/ 
	count?:number,

	/**（可选项）图片排序方式*/ 
	sort?:JSON,

	/**（可选项）返回的缩略图配置，**建议本图片不要设置过大** 若已有缩略图，则使用已有的缩略图。若要重新生成缩略图，可先调用清除缓存接口api.clearCache()。*/ 
	thumbnail?:JSON,

}

interface UIAlbumBrowser_scanGroups_Params {
	/**返回的资源种类；默认：'all'(iOS不支持)*/ 
	type:string,

	/**（可选项）返回的缩略图配置，**建议本图片不要设置过大** 若已有缩略图，则使用已有的缩略图。若要重新生成缩略图，可先调用清除缓存接口api.clearCache()。*/ 
	thumbnail?:JSON,

}

interface UIAlbumBrowser_scanByGroupId_Params {
	/**分组id；*/ 
	groupId:string,

	/**分组类型；默认：'all'*/ 
	type:string,

	/**（可选项）每次返回的资源数量，剩余资源可用 fetchGroup 接口遍历*/ 
	count?:number,

	/**（可选项）图片排序方式*/ 
	sort?:JSON,

	/**（可选项）返回的缩略图配置，**建议本图片不要设置过大** 若已有缩略图，则使用已有的缩略图。若要重新生成缩略图，可先调用清除缓存接口api.clearCache()。*/ 
	thumbnail?:JSON,

}

interface UIAlbumBrowser_transPath_Params {
	/**要转换的图片路径（在相册库的绝对路径）*/ 
	path:string,

	/**视频质量（android此参数为图片的quality，不支持视频）(iOS不支持)*/ 
	quality:string,

	/**图片质量  (iOS不支持)*/ 
	scale:number,

}

interface UIAlbumBrowser_transVideoPath_Params {
	/**要转换的视频路径（在相册库的绝对路径）*/ 
	path:string,

	/**是否保存在沙盒 （仅支持iOS）*/ 
	isSave:boolean,

}

interface UIAlbumBrowser_getVideoDuration_Params {
	/**视频资源路径（在相册库的绝对路径,另外支持 fs:// widget://路径）*/ 
	path:string,

}

interface UIAlbumBrowser_openGroup_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**(可选项)要打开的相册分组 ID*/ 
	groupId?:string,

	/**（可选项）图片预览区域默认选中图片的路径组成的数组*/ 
	selectedPaths?:Array,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface UIAlbumBrowser_changeGroup_Params {
	/**要改变的相册分组 ID*/ 
	groupId:string,

	/**（可选项）图片预览区域默认选中图片的路径组成的数组*/ 
	selectedPaths?:Array,

}

interface UIAlbumBrowser_openAlbum_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**(可选项)要打开的相册分组 ID*/ 
	groupId?:string,

	/**（可选项）最多选择几张图片，超过max则用户点击选中按钮只返回eventType为max的事件回调，不会执行选中操作（点击的图片还是未选中状态）*/ 
	max?:number,

	/**（可选项）显示图片或显示图片和视频*/ 
	type?:string,

	/***/ 
	styles:JSON,

	/**（可选项）选中视频资源时，是否进入预览页面，若为false则直接callback相关信息*/ 
	videoPreview?:boolean,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface UIAlbumBrowser_batchTransPath_Params {
	/**要转换的图片路径（在相册库的绝对路径）*/ 
	path:Array,

}

interface UIAlbumBrowser_getImgInfo_Params {
	/**图片路径支持fs://,widget://;*/ 
	imagePath:string,

}

interface circleProgress {
	/** 显示圆形进度条窗口*/ 
	open():void

	/** 关闭圆形进度条窗口*/ 
	close():void

	/** 设置进度条进度。*/ 
	setProgress():void

	/** 显示圆形进度条窗口*/ 
	show():void

	/** 隐藏圆形进度条窗口*/ 
	hide():void

}
interface UIListContactsPlus {
	/**
	 * `打开列表`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `contacts` :Array : 列表数据源
	 *
	 * `rightBtns` :Array : （可选项）列表项向左滑动露出的按钮组
	 *
	 * `styles` :string : （可选项）模块头部的样式
	 *
	 * `alphabeticalIndexStyles` :JSON : （可选项）右侧索引点击时中心显示的样式
	 *
	 * `backgroundColor` :string : （可选项）模块背景色
	 *
	 * `bounces` :boolean : （可选项）是否弹动
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 */
	open(params:UIListContactsPlus_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭列表模块*/ 
	close():void

	/** 隐藏列表模块，并没有从内存里清除*/ 
	hide():void

	/** 显示已隐藏的列表模块*/ 
	show():void

	/**
	 * `刷新列表数据`
	 * ========params==========
	 *
	 * `contacts` :JSON : 列表数据源
	 */
	reloadData(params:UIListContactsPlus_reloadData_Params):void

}
interface UIListContactsPlus_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**列表数据源*/ 
	contacts:Array,

	/**（可选项）列表项向左滑动露出的按钮组*/ 
	rightBtns?:Array,

	/**（可选项）模块头部的样式*/ 
	styles?:string,

	/**（可选项）右侧索引点击时中心显示的样式*/ 
	alphabeticalIndexStyles?:JSON,

	/**（可选项）模块背景色*/ 
	backgroundColor?:string,

	/**（可选项）是否弹动*/ 
	bounces?:boolean,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

}

interface UIListContactsPlus_reloadData_Params {
	/**列表数据源*/ 
	contacts:JSON,

}

interface liveUI {
	/**
	 * `打开直播UI界面`
	 * ========params==========
	 *
	 * `uid` :string : （必填项）主播用户id
	 *
	 * `name` :string : （可选项）主播名称
	 *
	 * `roomName` :string : （可选项）直播房间名称
	 *
	 * `headpic` :string : （可选项）主播用户的头像地址（图片不存在时有默认头像，请用圆形图片），支持http:// fs://、widget:// 协议。
	 *
	 * `starpic` :string : （可选项）主播等级图标（图片不存在时有默认等级图标，请用圆形图片），支持http:// fs://、widget:// 协议。
	 *
	 * `isDanmu` :boolean : （可选项）是否开启弹幕。(true:开启弹幕 false:关闭弹幕)
	 *
	 * `isShowGuanZhuBtn` :boolean : （可选项）是否显示关注按钮 。
	 *
	 * `memberCounts` :number : （可选项）观看人数 。
	 *
	 * `userList` :Array : （必填项）观众用户列表
	 *
	 * `messageList` :Array : （必填项）用户消息列表
	 *
	 * `fixedOn` :string : （可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 Window 或 Frame 滚动
	 */
	openLiveUI(params:liveUI_openLiveUI_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `添加观众用户加入接口`
	 * ========params==========
	 *
	 * `uid` :string : （必填项）用户id
	 *
	 * `nickname` :string : （必填项）用户名称
	 *
	 * `headpic` :string : （可选项）用户头像（图片不存在时有默认头像，请用圆形图片），支持http:// fs:// widget://
	 *
	 * `starpic` :string : （可选项）用户等级图片（图片不存在时有默认等级图片，请用圆形图片），支持http:// fs:// widget://
	 *
	 * `isJoinView` :boolean : （可选项）是否隐藏登场消息框
	 *
	 * `backgroundPic` :string : （可选项）登场消息框背景图片（图片不存在时有默认背景图片），支持http:// fs:// widget://
	 *
	 * `startnum` :number : （可选项）用户等级
	 *
	 * `nicknameColor` :string : （可选项）用户名称字体颜色
	 *
	 * `message` :string : （可选项）登场消息内容
	 *
	 * `messageColor` :string : （可选项）登场消息内容字体颜色
	 */
	addUserInfo(params:liveUI_addUserInfo_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `批量添加观众用户加入接口`
	 * ========params==========
	 *
	 * `userList` :Array : （必填项）加入观众用户列表
	 */
	addUserInfoList(params:liveUI_addUserInfoList_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `仅设置显示置观众人数，和观众列表纪录数无关`
	 * ========params==========
	 *
	 * `memberCounts` :number : （必填项）观看人数。
	 */
	setMemberCounts(params:liveUI_setMemberCounts_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `是否显示关注按钮`
	 * ========params==========
	 *
	 * `isShowGuanZhuBtn` :boolean : （可选项）是否显示关注按钮。
	 */
	isShowGuanZhuBtn(params:liveUI_isShowGuanZhuBtn_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `观看用户退出`
	 * ========params==========
	 *
	 * `uid` :string : （可选项）用户id。
	 */
	delUserInfo(params:liveUI_delUserInfo_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `发送弹幕消息`
	 * ========params==========
	 *
	 * `nickname` :string : （必填项）用户名称
	 *
	 * `nicknameColor` :string : （可选项）用户名称字体颜色
	 *
	 * `headpic` :string : （可选项）用户头像（图片不存在时有有默认头像，请用圆形图片），支持http:// fs:// widget://
	 *
	 * `starpic` :string : （可选项）等级图标(图片不存在时有默认等级图标，请用圆形图片)，支持http:// fs:// widget://
	 *
	 * `message` :string : （必填项）弹幕消息内容
	 *
	 * `messageColor` :string : （可选项）弹幕消息内容字体颜色
	 */
	showDanmu(params:liveUI_showDanmu_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `消息列表显示消息信息`
	 * ========params==========
	 *
	 * `uid` :string : （必填项）用户id
	 *
	 * `startnum` :number : （可选项）用户等级
	 *
	 * `nickname` :string : （必填项）用户名称
	 *
	 * `nicknameColor` :string : （可选项）用户名称字体颜色
	 *
	 * `message` :string : （必填项）发送消息内容
	 *
	 * `messageColor` :string : （可选项）发送消息内容字体颜色
	 */
	showMessage(params:liveUI_showMessage_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `批量添加消息列表显示消息信息`
	 * ========params==========
	 *
	 * `messageList` :Array : （必填项）用户消息列表
	 */
	showMessageList(params:liveUI_showMessageList_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `显示直播系统消息`
	 * ========params==========
	 *
	 * `title` :string : （必填项）用户名称
	 *
	 * `titleColor` :string : （可选项）用户名称字体颜色
	 *
	 * `message` :string : （必填项）系统消息内容
	 *
	 * `messageColor` :string : （可选项）系统消息内容字体颜色
	 */
	showSystemMessage(params:liveUI_showSystemMessage_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 清空消息列表*/ 
	clearMessage(callback?: (ret:JSON, err:JSON) => void):void

	/** 隐藏直播ui*/ 
	hiddenLiveUI(callback?: (ret:JSON, err:JSON) => void):void

	/** 显示直播ui*/ 
	showLiveUI(callback?: (ret:JSON, err:JSON) => void):void

	/** 关闭直播ui*/ 
	closeLiveUI(callback?: (ret:JSON, err:JSON) => void):void

}
interface liveUI_openLiveUI_Params {
	/**（必填项）主播用户id*/ 
	uid:string,

	/**（可选项）主播名称*/ 
	name?:string,

	/**（可选项）直播房间名称*/ 
	roomName?:string,

	/**（可选项）主播用户的头像地址（图片不存在时有默认头像，请用圆形图片），支持http:// fs://、widget:// 协议。*/ 
	headpic?:string,

	/**（可选项）主播等级图标（图片不存在时有默认等级图标，请用圆形图片），支持http:// fs://、widget:// 协议。*/ 
	starpic?:string,

	/**（可选项）是否开启弹幕。(true:开启弹幕 false:关闭弹幕)*/ 
	isDanmu?:boolean,

	/**（可选项）是否显示关注按钮 。*/ 
	isShowGuanZhuBtn?:boolean,

	/**（可选项）观看人数 。*/ 
	memberCounts?:number,

	/**（必填项）观众用户列表*/ 
	userList:Array,

	/**（必填项）用户消息列表*/ 
	messageList:Array,

	/**（可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 Window 或 Frame 滚动*/ 
	fixed?:boolean,

}

interface liveUI_addUserInfo_Params {
	/**（必填项）用户id*/ 
	uid:string,

	/**（必填项）用户名称*/ 
	nickname:string,

	/**（可选项）用户头像（图片不存在时有默认头像，请用圆形图片），支持http:// fs:// widget://*/ 
	headpic?:string,

	/**（可选项）用户等级图片（图片不存在时有默认等级图片，请用圆形图片），支持http:// fs:// widget://*/ 
	starpic?:string,

	/**（可选项）是否隐藏登场消息框*/ 
	isJoinView?:boolean,

	/**（可选项）登场消息框背景图片（图片不存在时有默认背景图片），支持http:// fs:// widget://*/ 
	backgroundPic?:string,

	/**（可选项）用户等级*/ 
	startnum?:number,

	/**（可选项）用户名称字体颜色*/ 
	nicknameColor?:string,

	/**（可选项）登场消息内容*/ 
	message?:string,

	/**（可选项）登场消息内容字体颜色*/ 
	messageColor?:string,

}

interface liveUI_addUserInfoList_Params {
	/**（必填项）加入观众用户列表*/ 
	userList:Array,

}

interface liveUI_setMemberCounts_Params {
	/**（必填项）观看人数。*/ 
	memberCounts:number,

}

interface liveUI_isShowGuanZhuBtn_Params {
	/**（可选项）是否显示关注按钮。*/ 
	isShowGuanZhuBtn?:boolean,

}

interface liveUI_delUserInfo_Params {
	/**（可选项）用户id。*/ 
	uid?:string,

}

interface liveUI_showDanmu_Params {
	/**（必填项）用户名称*/ 
	nickname:string,

	/**（可选项）用户名称字体颜色*/ 
	nicknameColor?:string,

	/**（可选项）用户头像（图片不存在时有有默认头像，请用圆形图片），支持http:// fs:// widget://*/ 
	headpic?:string,

	/**（可选项）等级图标(图片不存在时有默认等级图标，请用圆形图片)，支持http:// fs:// widget://*/ 
	starpic?:string,

	/**（必填项）弹幕消息内容*/ 
	message:string,

	/**（可选项）弹幕消息内容字体颜色*/ 
	messageColor?:string,

}

interface liveUI_showMessage_Params {
	/**（必填项）用户id*/ 
	uid:string,

	/**（可选项）用户等级*/ 
	startnum?:number,

	/**（必填项）用户名称*/ 
	nickname:string,

	/**（可选项）用户名称字体颜色*/ 
	nicknameColor?:string,

	/**（必填项）发送消息内容*/ 
	message:string,

	/**（可选项）发送消息内容字体颜色*/ 
	messageColor?:string,

}

interface liveUI_showMessageList_Params {
	/**（必填项）用户消息列表*/ 
	messageList:Array,

}

interface liveUI_showSystemMessage_Params {
	/**（必填项）用户名称*/ 
	title:string,

	/**（可选项）用户名称字体颜色*/ 
	titleColor?:string,

	/**（必填项）系统消息内容*/ 
	message:string,

	/**（可选项）系统消息内容字体颜色*/ 
	messageColor?:string,

}

interface constactOperate {
	/**
	 * `input方法将view添加到页面中`
	 * ========params==========
	 *
	 * `x` :any : 以左上角为原点 x轴偏移量。
	 *
	 * `y` :any : 以左上角为原点 y轴偏移量。
	 *
	 * `w` :any : view 宽度 。
	 *
	 * `h` :any : view 高度 。
	 *
	 * `type` :any : 类型 1、单选 2、多选
	 *
	 * `notice` :string : 用户禁用权限或无联系人提示语 。
	 */
	input(params:constactOperate_input_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 隐藏view，已调用input情况下可调用此方法隐藏*/ 
	hide():void

	/** 显示隐藏的view，调用input，hide 的情况下将原view对象重新显示，节省内存，无需重新创建*/ 
	show():void

	/** 在不使用此联系人view的情况下销毁释放内存*/ 
	destroy():void

	/** input type=2的情况下多选返回多个联系人的数据*/ 
	getSelect():void

}
interface constactOperate_input_Params {
	/**以左上角为原点 x轴偏移量。*/ 
	x:any,

	/**以左上角为原点 y轴偏移量。*/ 
	y:any,

	/**view 宽度 。*/ 
	w:any,

	/**view 高度 。*/ 
	h:any,

	/**类型 1、单选 2、多选*/ 
	type:any,

	/**用户禁用权限或无联系人提示语 。*/ 
	notice:string,

}

interface UIChartline {
	/** 打开曲线图*/ 
	open():void

	/** 关闭曲线图窗口*/ 
	close():void

	/** 刷新曲线数据。*/ 
	reloadData():void

	/** 显示曲线图窗口*/ 
	show():void

	/** 隐藏曲线图窗口*/ 
	hide():void

}
interface panorama {
	/**
	 * `打开全景展示视图`
	 * ========params==========
	 *
	 * `x` :number : （可选项）模块左上角的 x 坐标（相对于所属的 Window 或 Frame）
	 *
	 * `y` :number : （可选项）模块左上角的 y 坐标（相对于所属的 Window 或 Frame）
	 *
	 * `w` :number : （可选项）模块的宽度
	 *
	 * `h` :number : （可选项）模块的高度
	 *
	 * `imgPath` :string : 要展示的 360 度全景图片的路径
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 */
	open(params:panorama_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `打开全景展示视图，**本接口暂仅支持 iOS 平台**`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `imgPaths` :Array : 要展示的全景图片的路径组成的数组，图片顺序为：前后左右上下
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）是否将模块视图固定到窗口上（不跟随窗口上下滚动）
	 */
	openCubic(params:panorama_openCubic_Params, callback?: (ret:JSON) => void):void

	/**
	 * `关闭全景展示视图`
	 * ========params==========
	 *
	 * `id` :number : 要关闭的视图的id
	 */
	close(params:panorama_close_Params):void

	/**
	 * `隐藏全景展示视图。隐藏视图，并没有从内存里清除`
	 * ========params==========
	 *
	 * `id` :number : 要关闭的视图的id
	 */
	hide(params:panorama_hide_Params):void

	/**
	 * `显示全景展示视图，显示已隐藏的视图`
	 * ========params==========
	 *
	 * `id` :number : 要关闭的视图的 id
	 */
	show(params:panorama_show_Params):void

}
interface panorama_open_Params {
	/**（可选项）模块左上角的 x 坐标（相对于所属的 Window 或 Frame）*/ 
	x?:number,

	/**（可选项）模块左上角的 y 坐标（相对于所属的 Window 或 Frame）*/ 
	y?:number,

	/**（可选项）模块的宽度*/ 
	w?:number,

	/**（可选项）模块的高度*/ 
	h?:number,

	/**要展示的 360 度全景图片的路径*/ 
	imgPath:string,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

}

interface panorama_openCubic_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**要展示的全景图片的路径组成的数组，图片顺序为：前后左右上下*/ 
	imgPaths:Array,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）是否将模块视图固定到窗口上（不跟随窗口上下滚动）*/ 
	fixed?:boolean,

}

interface panorama_close_Params {
	/**要关闭的视图的id*/ 
	id:number,

}

interface panorama_hide_Params {
	/**要关闭的视图的id*/ 
	id:number,

}

interface panorama_show_Params {
	/**要关闭的视图的 id*/ 
	id:number,

}

interface UIInput {
	/**
	 * `打开输入框，**注意：调用 open 接口的元素，不能加 tapmode 属性**`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `styles` :JSON : （可选项）模块各部分的样式
	 *
	 * `maxRows` :number : （可选项）支持显示最大行数，文本内容超过此行数时，上下滚动显示。是否支持换行，传大于1的数时表示支持，**注意：取值大于1（多行显示时），不触发 search 事件回调**
	 *
	 * `maxStringLength` :number : （可选项）输入框允许输入的最大字符串长度
	 *
	 * `autoFocus` :boolean : （可选项）打开时是否弹出键盘
	 *
	 * `placeholder` :string : （可选项）输入框的占位提示文本
	 *
	 * `keyboardType` :string : （可选项）输入框获取焦点时，弹出的键盘类型；
	 *
	 * `alignment` :string : （可选项）文本对齐方式
	 *
	 * `isCenterVertical` :boolean : 输入文本是否上下居中
	 *
	 * `inputType` :string : (可选项) 判断输入框输入的是密码还是文字
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	open(params:UIInput_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `重设输入框的位置`
	 * ========params==========
	 *
	 * `id` :number : 需要设置的输入框id
	 *
	 * `position` :JSON : （可选项）模块的位置
	 */
	resetPosition(params:UIInput_resetPosition_Params):void

	/** 关闭输入框*/ 
	close():void

	/** 显示输入框*/ 
	show():void

	/** 隐藏输入框*/ 
	hide():void

	/**
	 * `获取或设置输入框的内容`
	 * ========params==========
	 *
	 * `id` :number : 输入框id
	 *
	 * `msg` :string : （可选项）输入框的内容，若不传则返回输入框的值
	 */
	value(params:UIInput_value_Params, callback?: (ret:JSON) => void):void

	/**
	 * `向输入框的指定位置插入内容`
	 * ========params==========
	 *
	 * `id` :number : 输入框id
	 *
	 * `index` :number : （可选项）插入内容的起始位置。**注意：中文，全角符号均占一个字符长度；索引从0开始，0表示插入到最前面，1表示插入到第一个字符后面，2表示插入到第二个字符后面，以此类推。**
	 *
	 * `msg` :string : （可选项）要插入的内容
	 */
	insertValue(params:UIInput_insertValue_Params):void

	/** 弹出键盘*/ 
	popupKeyboard():void

	/** 收起键盘*/ 
	closeKeyboard():void

	/**
	 * `事件监听`
	 * ========params==========
	 *
	 * `id` :number : 输入框id
	 *
	 * `name` :string : 监听的事件类型
	 */
	addEventListener(params:UIInput_addEventListener_Params, callback?: (ret:JSON) => void):void

	/**
	 * `获取当前光标所在位置`
	 * ========params==========
	 *
	 * `id` :number : 输入框id
	 */
	getSelectedRange(params:UIInput_getSelectedRange_Params, callback?: (ret:JSON) => void):void

}
interface UIInput_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**（可选项）模块各部分的样式*/ 
	styles?:JSON,

	/**（可选项）支持显示最大行数，文本内容超过此行数时，上下滚动显示。是否支持换行，传大于1的数时表示支持，**注意：取值大于1（多行显示时），不触发 search 事件回调***/ 
	maxRows?:number,

	/**（可选项）输入框允许输入的最大字符串长度*/ 
	maxStringLength?:number,

	/**（可选项）打开时是否弹出键盘*/ 
	autoFocus?:boolean,

	/**（可选项）输入框的占位提示文本*/ 
	placeholder?:string,

	/**（可选项）输入框获取焦点时，弹出的键盘类型；*/ 
	keyboardType?:string,

	/**（可选项）文本对齐方式*/ 
	alignment?:string,

	/**输入文本是否上下居中*/ 
	isCenterVertical:boolean,

	/**(可选项) 判断输入框输入的是密码还是文字*/ 
	inputType?:string,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface UIInput_resetPosition_Params {
	/**需要设置的输入框id*/ 
	id:number,

	/**（可选项）模块的位置*/ 
	position?:JSON,

}

interface UIInput_value_Params {
	/**输入框id*/ 
	id:number,

	/**（可选项）输入框的内容，若不传则返回输入框的值*/ 
	msg?:string,

}

interface UIInput_insertValue_Params {
	/**输入框id*/ 
	id:number,

	/**（可选项）插入内容的起始位置。**注意：中文，全角符号均占一个字符长度；索引从0开始，0表示插入到最前面，1表示插入到第一个字符后面，2表示插入到第二个字符后面，以此类推。***/ 
	index?:number,

	/**（可选项）要插入的内容*/ 
	msg?:string,

}

interface UIInput_addEventListener_Params {
	/**输入框id*/ 
	id:number,

	/**监听的事件类型*/ 
	name:string,

}

interface UIInput_getSelectedRange_Params {
	/**输入框id*/ 
	id:number,

}

interface keyBoardMgr {
	/** 隐藏键盘。*/ 
	hideKeyBoard():void

	/** 针对某个输入框显示键盘，使某个输入框能够输入文字。需要调用该方法后，再用js使input获取焦点(因为弹出键盘需要一段时间，所以input获取焦点需要用setTimeout延时执行，如示例代码所示)，进而使input能够输入文字。对于安卓手机，弹出键盘后点击键盘以外的区域，部分手机能够关闭键盘，而部分手机不能关闭键盘(此时可通过键盘自带关闭按钮关闭)；对于苹果手机，弹出键盘后点击键盘以外的区域，都能够关闭键盘。*/ 
	showKeyBoard():void

	/** 添加监听键盘弹出隐藏事件。添加监听后，该模块会异步回调onKeyBoardChanged方法，onKeyBoardChanged方法由开发者自行实现。详见onKeyBoardChanged方法说明。不使用该监听事件后开发者应调用removeKBListener方法移除监听事件。*/ 
	addKBListener():void

	/** 移除监听键盘弹出隐藏事件。调用addKBListener方法后开发者应在适当时候调用removeKBListener方法移除监听事件。*/ 
	removeKBListener():void

	/** 监听input输入框的内容变化，该方法为纯js实现，可以当做拓展本模块的功能。*/ 
	onTextChanged():void

}
interface UIActionRecord {
	/** 打开语音输入面板*/ 
	recordAudio():void

}
interface periodSelector {
}
interface toastmoduleforjs {
	/**
	 * `显示Success类型消息`
	 * ========params==========
	 *
	 * `msg` :string : 显示的消息内容
	 *
	 * `duration` :number : （可选项）显示的时间长短。可选值为0和1，0代表显示时间较短，1代表显示时间较长，默认值为0。
	 */
	showSuccessMsg(params:toastmoduleforjs_showSuccessMsg_Params):void

	/**
	 * `显示Error类型消息`
	 * ========params==========
	 *
	 * `msg` :string : 显示的消息内容
	 *
	 * `duration` :number : （可选项）Toast显示时间的长短。可选值为0和1，0代表显示时间较短，1代表显示时间较长，默认值为0。
	 */
	showErrorMsg(params:toastmoduleforjs_showErrorMsg_Params):void

	/**
	 * `显示Info类型消息`
	 * ========params==========
	 *
	 * `msg` :string : 显示的消息内容
	 *
	 * `duration` :number : （可选项）Toast显示时间的长短。可选值为0和1，0代表显示时间较短，1代表显示时间较长，默认值为0。
	 */
	showInfoMsg(params:toastmoduleforjs_showInfoMsg_Params):void

	/**
	 * `显示Warning类型消息`
	 * ========params==========
	 *
	 * `msg` :string : 显示的消息内容
	 *
	 * `duration` :number : （可选项）Toast显示时间的长短。可选值为0和1，0代表显示时间较短，1代表显示时间较长，默认值为0。
	 */
	showWarningMsg(params:toastmoduleforjs_showWarningMsg_Params):void

	/**
	 * `显示Normal类型消息`
	 * ========params==========
	 *
	 * `msg` :string : 显示的消息内容
	 *
	 * `duration` :number : （可选项）Toast显示时间的长短。可选值为0和1，0代表显示时间较短，1代表显示时间较长，默认值为0。
	 */
	showNormalMsg(params:toastmoduleforjs_showNormalMsg_Params):void

}
interface toastmoduleforjs_showSuccessMsg_Params {
	/**显示的消息内容*/ 
	msg:string,

	/**（可选项）显示的时间长短。可选值为0和1，0代表显示时间较短，1代表显示时间较长，默认值为0。*/ 
	duration?:number,

}

interface toastmoduleforjs_showErrorMsg_Params {
	/**显示的消息内容*/ 
	msg:string,

	/**（可选项）Toast显示时间的长短。可选值为0和1，0代表显示时间较短，1代表显示时间较长，默认值为0。*/ 
	duration?:number,

}

interface toastmoduleforjs_showInfoMsg_Params {
	/**显示的消息内容*/ 
	msg:string,

	/**（可选项）Toast显示时间的长短。可选值为0和1，0代表显示时间较短，1代表显示时间较长，默认值为0。*/ 
	duration?:number,

}

interface toastmoduleforjs_showWarningMsg_Params {
	/**显示的消息内容*/ 
	msg:string,

	/**（可选项）Toast显示时间的长短。可选值为0和1，0代表显示时间较短，1代表显示时间较长，默认值为0。*/ 
	duration?:number,

}

interface toastmoduleforjs_showNormalMsg_Params {
	/**显示的消息内容*/ 
	msg:string,

	/**（可选项）Toast显示时间的长短。可选值为0和1，0代表显示时间较短，1代表显示时间较长，默认值为0。*/ 
	duration?:number,

}

interface kLine {
	/**
	 * `显示K线模块`
	 * ========params==========
	 *
	 * `x` :any : （可选项）数字类型；模块左上角的 x 坐标（相对于所属的 Window 或 Frame）；默认：0。
	 *
	 * `y` :any : （可选项）数字类型；模块左上角的 y 坐标（相对于所属的 Window 或 Frame）；默认：0。
	 *
	 * `w` :any : （可选项）数字类型；模块的宽度；默认：所属的 Window 或 Frame 的宽度。
	 *
	 * `h` :any : （可选项）数字类型；模块的高度；默认：所属的 Window 或 Frame 的高度。
	 *
	 * `option` :JSON : null
	 */
	open(params:kLine_open_Params):void

	/**
	 * `设置option`
	 * ========params==========
	 *
	 * `option` :JSON : 内部字段定义，参考open的option参数描述
	 */
	setOption(params:kLine_setOption_Params):void

	/**
	 * `设置k线数据源`
	 * ========params==========
	 *
	 * `datas` :Array : k线数据数组，时间新的数据必须是排在前面。
	 */
	setDatas(params:kLine_setDatas_Params):void

	/**
	 * `更新currentPrice stopProfit stopLoss或者追加k线新数据，如当前是1分钟k线，您可能过了1分钟，会从数据库拉下来1个k线数据（1分钟一条数据），需要把这个数据追加到k线当中`
	 * ========params==========
	 *
	 * `currentPrice` :string : （可选项）currentPrice的值。
	 *
	 * `stopLoss` :string : （可选项）stopLoss的值。
	 *
	 * `stopProfit` :string : （可选项）stopProfit的值。
	 *
	 * `datas` :Array : （可选项）追加新的K线数据。
	 */
	setPrice(params:kLine_setPrice_Params):void

	/** 关闭K线模块*/ 
	close(callback?: (ret:JSON, err:JSON) => void):void

	/** 获取当前K线模块的图像，调用此方法前，必须调用open或者setOption方法，设置了模块的option，并且调用setDatas设置了数据源*/ 
	getImage(callback?: (ret:JSON, err:JSON) => void):void

	/** 显示K线模块（如果当前隐藏了）*/ 
	show(callback?: (ret:JSON, err:JSON) => void):void

	/** 隐藏K线模块*/ 
	hide(callback?: (ret:JSON, err:JSON) => void):void

}
interface kLine_open_Params {
	/**（可选项）数字类型；模块左上角的 x 坐标（相对于所属的 Window 或 Frame）；默认：0。*/ 
	x?:any,

	/**（可选项）数字类型；模块左上角的 y 坐标（相对于所属的 Window 或 Frame）；默认：0。*/ 
	y?:any,

	/**（可选项）数字类型；模块的宽度；默认：所属的 Window 或 Frame 的宽度。*/ 
	w?:any,

	/**（可选项）数字类型；模块的高度；默认：所属的 Window 或 Frame 的高度。*/ 
	h?:any,

	/**null*/ 
	option:JSON,

}

interface kLine_setOption_Params {
	/**内部字段定义，参考open的option参数描述*/ 
	option:JSON,

}

interface kLine_setDatas_Params {
	/**k线数据数组，时间新的数据必须是排在前面。*/ 
	datas:Array,

}

interface kLine_setPrice_Params {
	/**（可选项）currentPrice的值。*/ 
	currentPrice?:string,

	/**（可选项）stopLoss的值。*/ 
	stopLoss?:string,

	/**（可选项）stopProfit的值。*/ 
	stopProfit?:string,

	/**（可选项）追加新的K线数据。*/ 
	datas?:Array,

}

interface cxChatbox {
	/** 打开聊天输入框*/ 
	open(callback?: (ret:JSON) => void):void

	/** 表情面板上附件按钮点击事件的监听，**仅当 open 接口内 tools->face 参数有值时，本接口有效***/ 
	faceListener(callback?: (ret:JSON) => void):void

	/** 选择图片相关功能事件的监听，**仅当 open 接口内 tools->image 参数有值时，本接口有效***/ 
	imageListener(callback?: (ret:JSON) => void):void

	/** @相关功能事件的监听，**仅当 open 接口内 tools->at 参数有值时，本接口有效***/ 
	atListener(callback?: (ret:JSON) => void):void

	/** 关闭聊天输入框*/ 
	close():void

	/** 显示聊天输入框*/ 
	show():void

	/** 隐藏聊天输入框*/ 
	hide():void

	/** 弹出键盘（仅iOS支持）*/ 
	popupKeyboard():void

	/** 收起键盘（仅iOS支持）*/ 
	closeKeyboard():void

	/**
	 * `获取或设置聊天输入框的内容`
	 * ========params==========
	 *
	 * `msg` :string : （可选项）聊天输入框的内容，若不传则返回输入框的值
	 */
	value(params:cxChatbox_value_Params, callback?: (ret:JSON) => void):void

	/**
	 * `向聊天输入框的指定位置插入内容`
	 * ========params==========
	 *
	 * `index` :number : （可选项）待插入内容的起始位置。**注意：中文，全角符号均占一个字符长度；索引从0开始，0表示插入到最前面，1表示插入到第一个字符后面，2表示插入到第二个字符后面，以此类推。**
	 *
	 * `msg` :string : （可选项）要插入的内容
	 */
	insertValue(params:cxChatbox_insertValue_Params):void

	/** 清空输入框文本*/ 
	clearText():void

}
interface cxChatbox_value_Params {
	/**（可选项）聊天输入框的内容，若不传则返回输入框的值*/ 
	msg?:string,

}

interface cxChatbox_insertValue_Params {
	/**（可选项）待插入内容的起始位置。**注意：中文，全角符号均占一个字符长度；索引从0开始，0表示插入到最前面，1表示插入到第一个字符后面，2表示插入到第二个字符后面，以此类推。***/ 
	index?:number,

	/**（可选项）要插入的内容*/ 
	msg?:string,

}

interface inputField {
}
interface timeSelector {
}
interface fourStageLinkage {
}
interface payPasswordInput {
	/** 打开密码输入框*/ 
	showInput(callback?: (ret:JSON) => void):void

}
interface loadingLabel {
}
interface photoBrowserWeiXin {
	/** 清除缓存到本地的网络图片，**本接口只清除本模块缓存的数据，若要清除本 app 缓存的所有数据则调用 api.clearCache***/ 
	clearCache():void

}
interface slidingList {
}
interface UIActionSelector {
}
interface UIBlurEffect {
	/**
	 * `添加一个模块视图`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `alpha` :number : （可选项）透明度
	 *
	 * `type` :string : （可选项）模糊类型
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）是否将模块视图固定到窗口上（不跟随窗口上下滚动）
	 */
	open(params:UIBlurEffect_open_Params):void

	/** 关闭模块视图*/ 
	close():void

	/** 显示模块视图*/ 
	show():void

	/** 隐藏模块视图*/ 
	hide():void

}
interface UIBlurEffect_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**（可选项）透明度*/ 
	alpha?:number,

	/**（可选项）模糊类型*/ 
	type?:string,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）是否将模块视图固定到窗口上（不跟随窗口上下滚动）*/ 
	fixed?:boolean,

}

interface floatModule {
	/** 打开悬浮窗口*/ 
	openFloat():void

	/** 隐藏悬浮窗口*/ 
	hide():void

	/** 显示悬浮窗口*/ 
	show():void

	/** 关闭悬浮窗口*/ 
	close():void

	/** 改变播放状态*/ 
	changeState():void

}
interface zyPatternLock {
}
interface searchBar {
}
interface UIListCheck {
	/**
	 * `打开列表`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `isRadio` :boolean : （可选项）是否是单选 **注意:该参数在contacts里面的selected都为false时有效**
	 *
	 * `contacts` :Array : 列表数据源
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 */
	open(params:UIListCheck_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭列表模块*/ 
	close():void

	/** 隐藏列表模块，并没有从内存里清除*/ 
	hide():void

	/** 显示已隐藏的列表模块*/ 
	show():void

	/**
	 * `刷新列表数据`
	 * ========params==========
	 *
	 * `contacts` :JSON : 列表数据源
	 */
	reloadData(params:UIListCheck_reloadData_Params):void

	/**
	 * `设置选中的联系人`
	 * ========params==========
	 *
	 * `selected` :boolean : （可选项）设置/取消选中状态
	 *
	 * `contacts` :Array : 要设置为选中状态的联系人id组成的数组
	 */
	setSelected(params:UIListCheck_setSelected_Params):void

	/** 获取所有当前选中的联系人信息，**同步接口***/ 
	getSelectedSync():JSON;

}
interface UIListCheck_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**（可选项）是否是单选 **注意:该参数在contacts里面的selected都为false时有效***/ 
	isRadio?:boolean,

	/**列表数据源*/ 
	contacts:Array,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

}

interface UIListCheck_reloadData_Params {
	/**列表数据源*/ 
	contacts:JSON,

}

interface UIListCheck_setSelected_Params {
	/**（可选项）设置/取消选中状态*/ 
	selected?:boolean,

	/**要设置为选中状态的联系人id组成的数组*/ 
	contacts:Array,

}

interface UIScrollPlayer {
	/**
	 * `打开播放器`
	 * ========params==========
	 *
	 * `rect` :JSON : 模块的位置及尺寸
	 *
	 * `videos` :Array<JSON> : 视频列表
	 *
	 * `buttons` :Array<JSON> : （可选项）悬浮在视频上方按钮，videos中item中不设置buttons则按此参数展示
	 *
	 * `index` :number : （可选项）页面打开时默认播放视频的下标
	 *
	 * `autoPlay` :boolean : （可选项）视频是否自动播放，设置为false后所有视频都不自动播放
	 *
	 * `scalingMode` :number : （可选项）视频填充方式
	 *
	 * `imgScaleType` :number : （可选项）封面图填充方式
	 *
	 * `isLooping` :boolean : （可选项）是否循环播放
	 *
	 * `fixedOn` :string : （可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 Window 或 Frame 滚动
	 */
	open(params:UIScrollPlayer_open_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 隐藏播放器*/ 
	hide():void

	/** 显示播放器*/ 
	show():void

	/** 关闭播放器*/ 
	close():void

	/**
	 * `添加视频`
	 * ========params==========
	 *
	 * `videos` :Array<JSON> : 视频列表
	 */
	add(params:UIScrollPlayer_add_Params):void

	/** 暂停当前视频播放*/ 
	pause():void

	/** 暂停后播放视频（iOS此接口只支持暂停后播放视频，若open接口设置autoPlay为fasle或者视频停止后开始播放调用startPlay接口）*/ 
	play():void

	/**
	 * `播放视频`
	 * ========params==========
	 *
	 * `index` :number : （可选项）播放视频下标
	 */
	startPlay(params:UIScrollPlayer_startPlay_Params):void

	/** 滑动播放器监听*/ 
	addEventListener():void

	/** 添加视频悬浮按钮监听事件*/ 
	addButtonsListener():void

}
interface UIScrollPlayer_open_Params {
	/**模块的位置及尺寸*/ 
	rect:JSON,

	/**视频列表*/ 
	videos:Array<JSON>,

	/**（可选项）悬浮在视频上方按钮，videos中item中不设置buttons则按此参数展示*/ 
	buttons?:Array<JSON>,

	/**（可选项）页面打开时默认播放视频的下标*/ 
	index?:number,

	/**（可选项）视频是否自动播放，设置为false后所有视频都不自动播放*/ 
	autoPlay?:boolean,

	/**（可选项）视频填充方式*/ 
	scalingMode?:number,

	/**（可选项）封面图填充方式*/ 
	imgScaleType?:number,

	/**（可选项）是否循环播放*/ 
	isLooping?:boolean,

	/**（可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 Window 或 Frame 滚动*/ 
	fixed?:boolean,

}

interface UIScrollPlayer_add_Params {
	/**视频列表*/ 
	videos:Array<JSON>,

}

interface UIScrollPlayer_startPlay_Params {
	/**（可选项）播放视频下标*/ 
	index?:number,

}

interface UILineChart {
}
interface UIPartCircleProgress {
	/** 显示圆形进度条窗口*/ 
	open():void

	/** 关闭圆形进度条窗口*/ 
	close():void

	/** 设置进度条进度。*/ 
	setProgress():void

	/** 设置进度条中显示内容*/ 
	setTitles():void

	/** 设置进度条进度监听*/ 
	setProgressListener():void

	/** 显示圆形进度条窗口*/ 
	show():void

	/** 隐藏圆形进度条窗口*/ 
	hide():void

	/** 给标题添加点击事件*/ 
	addClickListenner():void

}
interface hintChatBox {
}
interface UIMediaScanner {
	/**
	 * `打开多媒体资源选择器，打开后会全屏显示`
	 * ========params==========
	 *
	 * `type` :string : 返回的资源种类；默认：'all'
	 *
	 * `column` :number : （可选项）图片显示的列数，须大于1
	 *
	 * `classify` :boolean : （可选项）是否将图片分类显示（为 true 时，会首先跳转到相册分类列表页面）
	 *
	 * `max` :number : （可选项）最多选择几张图片
	 *
	 * `sort` :JSON : （可选项）图片排序方式
	 *
	 * `texts` :JSON : （可选项）模块各部分的文字内容
	 *
	 * `styles` :JSON : （可选项）模块各部分的样式
	 *
	 * `scrollToBottom` :JSON : （可选项）打开媒体资源界面后间隔一段时间开始自动滚动到底部设置
	 *
	 * `exchange` :boolean : 是否交换‘确定’和‘取消’按钮的位置（默认‘取消’按钮在右边，‘确定’按钮在左边）
	 *
	 * `rotation` :boolean : 屏幕是否旋转（横屏），为 true 时可以横竖屏旋转，false 时禁止横屏
	 *
	 * `showPreview` :boolean : 是否支持返回预览事件
	 *
	 * `showBrowser` :boolean : 是否支持打开已选图片预览效果
	 */
	open(params:UIMediaScanner_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `扫描系统多媒体资源，可以通过 Web 代码自定义多选界面。**注意：页面展示的图片建议使用缩略图，一次显示的图片不宜过多（1至2屏）**`
	 * ========params==========
	 *
	 * `type` :string : 返回的资源种类；默认：'all'
	 *
	 * `count` :number : （可选项）每次返回的资源数量；
	 *
	 * `sort` :JSON : （可选项）图片排序方式
	 *
	 * `thumbnail` :JSON : （可选项）返回的缩略图配置，**建议本图片不要设置过大** 若已有缩略图，则使用已有的缩略图。若要重新生成缩略图，可先调用清除缓存接口api.clearCache()。
	 *
	 * `showGroup` :boolean : （可选项）是否返回图片所在分组名，本参数对 android 平台无效
	 */
	scan(params:UIMediaScanner_scan_Params, callback?: (ret:JSON) => void):void

	/** 获取指定数量的多媒体资源，没有更多资源则返回空数组，**必须配合 scan 接口的 count 参数一起使用**。*/ 
	fetch():void

	/**
	 * `将系统相册媒体资源地址转换为可以直接使用的本地路径地址（临时文件夹的绝对路径），**媒体资源会被拷贝到临时文件夹，调用 api.clearCache 接口可清除该临时图片文件**`
	 * ========params==========
	 *
	 * `path` :string : （可选项）返回数据类型，指定返回图片地址或图片经过 base64 编码后的字符串
	 *
	 * `scale` :JSON : （可选项）从本地相册拷贝图片到缓存目录时对图片的压缩处理，若不传则取内部字段中的默认值
	 */
	transPath(params:UIMediaScanner_transPath_Params, callback?: (ret:JSON) => void):void

	/**
	 * `- 类型：字符串`
	 * ========params==========
	 *
	 * `path` :string : 视频资源路径（在相册库的绝对路径,另外支持 fs:// widget://路径）
	 */
	getVideoDuration(params:UIMediaScanner_getVideoDuration_Params, callback?: (ret:JSON) => void):void

}
interface UIMediaScanner_open_Params {
	/**返回的资源种类；默认：'all'*/ 
	type:string,

	/**（可选项）图片显示的列数，须大于1*/ 
	column?:number,

	/**（可选项）是否将图片分类显示（为 true 时，会首先跳转到相册分类列表页面）*/ 
	classify?:boolean,

	/**（可选项）最多选择几张图片*/ 
	max?:number,

	/**（可选项）图片排序方式*/ 
	sort?:JSON,

	/**（可选项）模块各部分的文字内容*/ 
	texts?:JSON,

	/**（可选项）模块各部分的样式*/ 
	styles?:JSON,

	/**（可选项）打开媒体资源界面后间隔一段时间开始自动滚动到底部设置*/ 
	scrollToBottom?:JSON,

	/**是否交换‘确定’和‘取消’按钮的位置（默认‘取消’按钮在右边，‘确定’按钮在左边）*/ 
	exchange:boolean,

	/**屏幕是否旋转（横屏），为 true 时可以横竖屏旋转，false 时禁止横屏*/ 
	rotation:boolean,

	/**是否支持返回预览事件*/ 
	showPreview:boolean,

	/**是否支持打开已选图片预览效果*/ 
	showBrowser:boolean,

}

interface UIMediaScanner_scan_Params {
	/**返回的资源种类；默认：'all'*/ 
	type:string,

	/**（可选项）每次返回的资源数量；*/ 
	count?:number,

	/**（可选项）图片排序方式*/ 
	sort?:JSON,

	/**（可选项）返回的缩略图配置，**建议本图片不要设置过大** 若已有缩略图，则使用已有的缩略图。若要重新生成缩略图，可先调用清除缓存接口api.clearCache()。*/ 
	thumbnail?:JSON,

	/**（可选项）是否返回图片所在分组名，本参数对 android 平台无效*/ 
	showGroup?:boolean,

}

interface UIMediaScanner_transPath_Params {
	/**（可选项）返回数据类型，指定返回图片地址或图片经过 base64 编码后的字符串*/ 
	path?:string,

	/**（可选项）从本地相册拷贝图片到缓存目录时对图片的压缩处理，若不传则取内部字段中的默认值*/ 
	scale?:JSON,

}

interface UIMediaScanner_getVideoDuration_Params {
	/**视频资源路径（在相册库的绝对路径,另外支持 fs:// widget://路径）*/ 
	path:string,

}

interface addressView {
	/** 打开模块初始化操作，可以自定义初始化省市区数据。调用show接口显示界面。*/ 
	open():void

	/** 打开选择界面*/ 
	show(callback?: (ret:JSON, err:JSON) => void):void

}
interface citySelect {
	/**
	 * `打开城市选择器`
	 * ========params==========
	 *
	 * `city` :string : （可选项）默认城市
	 *
	 * `resouceType` :string : （可选项）自定义数据源
	 */
	startSelectCity(params:citySelect_startSelectCity_Params, callback?: (ret:JSON) => void):void

}
interface citySelect_startSelectCity_Params {
	/**（可选项）默认城市*/ 
	city?:string,

	/**（可选项）自定义数据源*/ 
	resouceType?:string,

}

interface screenTaskUI {
	/**
	 * `开启锁屏显示，刷新ui数据。（需要手动打开应用【锁屏显示】权限）`
	 * ========params==========
	 *
	 * `already` :number : （可选项）已完成巡点（进度条分子）
	 *
	 * `total` :number : （可选项）总巡点（进度条分母）
	 *
	 * `alreadyTextSize` :number : （可选项）进度条分子文字大小（包括"/"）
	 *
	 * `totalTextSize` :number : （可选项）进度条分母文字大小
	 *
	 * `defaultCirleColor` :string : （可选项）进度条背景色,支持rgb,rgba
	 *
	 * `alreadyCircleColor` :string : （可选项）进度条进度颜色,支持rgb,rgba
	 *
	 * `topText ` :string : （可选项）应巡点文本（包括 ’应巡点：‘）
	 *
	 * `bottomText` :string : （可选项）距离文本（包括 ’距离：‘）
	 *
	 * `topTextColor` :string : （可选项）应巡点文本颜色,支持rgb,rgba
	 *
	 * `bottomTextColor` :string : （可选项）距离文本颜色,支持rgb,rgba
	 *
	 * `topTextSize` :string : （可选项）应巡点文本大小
	 *
	 * `bottomTextSize` :string : （可选项）距离文本大小
	 */
	start(params:screenTaskUI_start_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 关闭锁屏界面*/ 
	close():void

}
interface screenTaskUI_start_Params {
	/**（可选项）已完成巡点（进度条分子）*/ 
	already?:number,

	/**（可选项）总巡点（进度条分母）*/ 
	total?:number,

	/**（可选项）进度条分子文字大小（包括"/"）*/ 
	alreadyTextSize?:number,

	/**（可选项）进度条分母文字大小*/ 
	totalTextSize?:number,

	/**（可选项）进度条背景色,支持rgb,rgba*/ 
	defaultCirleColor?:string,

	/**（可选项）进度条进度颜色,支持rgb,rgba*/ 
	alreadyCircleColor?:string,

	/**（可选项）应巡点文本（包括 ’应巡点：‘）*/ 
	topText ?:string,

	/**（可选项）距离文本（包括 ’距离：‘）*/ 
	bottomText?:string,

	/**（可选项）应巡点文本颜色,支持rgb,rgba*/ 
	topTextColor?:string,

	/**（可选项）距离文本颜色,支持rgb,rgba*/ 
	bottomTextColor?:string,

	/**（可选项）应巡点文本大小*/ 
	topTextSize?:string,

	/**（可选项）距离文本大小*/ 
	bottomTextSize?:string,

}

interface beautifulPicker {
	/** 打开日期对话框*/ 
	date():void

}
interface UIPullRefreshMotive {
	/** 配置下拉刷新样式*/ 
	setCustomRefreshHeaderInfo():void

	/** 手动开始下拉刷新的加载状态，**下拉刷新状态亦可通过用户下拉到阈值自动触发***/ 
	refreshHeaderLoading():void

	/** 手动停止下拉刷新的加载状态*/ 
	refreshHeaderLoadDone():void

}
interface pieChart {
	/**
	 * `**注意:请保证 所有数值加起来不为0 否则无实际意义 **`
	 * ========params==========
	 *
	 * `x` :number : （可选项）圆心坐标
	 *
	 * `y` :number : （可选项）圆心坐标
	 *
	 * `radius` :number : （可选项）圆半径
	 *
	 * `center` :JSON : （可选项）饼形图中间标题样式设置
	 *
	 * `elements` :Array : 模块字典对象组成的数组
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	open(params:pieChart_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `刷新展示数据`
	 * ========params==========
	 *
	 * `id` :number : 操作的视图的id
	 *
	 * `elements` :Array : 模块字典对象组成的数组
	 */
	reloadData(params:pieChart_reloadData_Params, callback?: (ret:JSON) => void):void

	/**
	 * `重设模块视图的位置大小`
	 * ========params==========
	 *
	 * `id` :number : 操作的视图的id
	 *
	 * `x` :number : （可选项）圆心坐标
	 *
	 * `y` :number : （可选项）圆心坐标
	 *
	 * `radius` :number : （可选项）圆半径
	 *
	 * `anim` :boolean : （可选项）改变模块视图大小时是否添加变化过程的动画
	 */
	setFrame(params:pieChart_setFrame_Params):void

	/**
	 * `关闭饼图`
	 * ========params==========
	 *
	 * `id` :number : 要关闭的饼图的id
	 */
	close(params:pieChart_close_Params):void

	/**
	 * `隐藏饼图`
	 * ========params==========
	 *
	 * `id` :number : 要隐藏的饼图的id
	 */
	hide(params:pieChart_hide_Params):void

	/**
	 * `显示已隐藏的饼形图`
	 * ========params==========
	 *
	 * `id` :number : 要显示的饼图的id
	 */
	show(params:pieChart_show_Params):void

}
interface pieChart_open_Params {
	/**（可选项）圆心坐标*/ 
	x?:number,

	/**（可选项）圆心坐标*/ 
	y?:number,

	/**（可选项）圆半径*/ 
	radius?:number,

	/**（可选项）饼形图中间标题样式设置*/ 
	center?:JSON,

	/**模块字典对象组成的数组*/ 
	elements:Array,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface pieChart_reloadData_Params {
	/**操作的视图的id*/ 
	id:number,

	/**模块字典对象组成的数组*/ 
	elements:Array,

}

interface pieChart_setFrame_Params {
	/**操作的视图的id*/ 
	id:number,

	/**（可选项）圆心坐标*/ 
	x?:number,

	/**（可选项）圆心坐标*/ 
	y?:number,

	/**（可选项）圆半径*/ 
	radius?:number,

	/**（可选项）改变模块视图大小时是否添加变化过程的动画*/ 
	anim?:boolean,

}

interface pieChart_close_Params {
	/**要关闭的饼图的id*/ 
	id:number,

}

interface pieChart_hide_Params {
	/**要隐藏的饼图的id*/ 
	id:number,

}

interface pieChart_show_Params {
	/**要显示的饼图的id*/ 
	id:number,

}

interface UIScrollPicture {
	/**
	 * `打开模块`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `data` :JSON : 模块的图片路径数组，及说明文字数组
	 *
	 * `styles` :string : （可选项）模块各部分的样式
	 *
	 * `placeholderImg` :string : （可选项）网络图片未加载完毕时，模块显示的占位图片，要求本地路径（fs://、widget://）
	 *
	 * `contentMode` :string : （可选项）图片填充模式
	 *
	 * `cornerRadius` :number : （可选项）图片的圆角半径
	 *
	 * `scrollerCorner` :number : （可选项）滑动视图的圆角半径
	 *
	 * `interval` :number : （可选项）图片轮换时间间隔，单位是秒（s）
	 *
	 * `auto` :boolean : （可选项）图片是否自动播放
	 *
	 * `loop` :boolean : （可选项）图片是否循环播放
	 *
	 * `touchWait` :boolean : （可选项）触摸停止自动播放
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	open(params:UIScrollPicture_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `关闭模块`
	 * ========params==========
	 *
	 * `mIndex` :number : （可选项）模块索引值
	 */
	close(params:UIScrollPicture_close_Params):void

	/**
	 * `显示模块`
	 * ========params==========
	 *
	 * `mIndex` :number : （可选项）模块索引值
	 */
	show(params:UIScrollPicture_show_Params):void

	/**
	 * `隐藏模块`
	 * ========params==========
	 *
	 * `mIndex` :number : （可选项）模块索引值
	 */
	hide(params:UIScrollPicture_hide_Params):void

	/**
	 * `指定当前项`
	 * ========params==========
	 *
	 * `mIndex` :number : （可选项）模块索引值
	 *
	 * `index` :number : （可选项）索引值
	 */
	setCurrentIndex(params:UIScrollPicture_setCurrentIndex_Params):void

	/**
	 * `更新模块数据`
	 * ========params==========
	 *
	 * `mIndex` :number : （可选项）模块索引值
	 *
	 * `data` :JSON : 模块的图片路径数组，及说明文字数组
	 */
	reloadData(params:UIScrollPicture_reloadData_Params):void

	/**
	 * `事件监听`
	 * ========params==========
	 *
	 * `name` :string : 监听的事件名称，取值范围：'scroll'（图片滚动事件）
	 */
	addEventListener(params:UIScrollPicture_addEventListener_Params, callback?: (ret:JSON) => void):void

	/** 清除缓存到本地的网络图片，**本接口只清除本模块缓存的数据，若要清除本 app 缓存的所有数据则调用 api.clearCache***/ 
	clearCache():void

}
interface UIScrollPicture_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**模块的图片路径数组，及说明文字数组*/ 
	data:JSON,

	/**（可选项）模块各部分的样式*/ 
	styles?:string,

	/**（可选项）网络图片未加载完毕时，模块显示的占位图片，要求本地路径（fs://、widget://）*/ 
	placeholderImg?:string,

	/**（可选项）图片填充模式*/ 
	contentMode?:string,

	/**（可选项）图片的圆角半径*/ 
	cornerRadius?:number,

	/**（可选项）滑动视图的圆角半径*/ 
	scrollerCorner?:number,

	/**（可选项）图片轮换时间间隔，单位是秒（s）*/ 
	interval?:number,

	/**（可选项）图片是否自动播放*/ 
	auto?:boolean,

	/**（可选项）图片是否循环播放*/ 
	loop?:boolean,

	/**（可选项）触摸停止自动播放*/ 
	touchWait?:boolean,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface UIScrollPicture_close_Params {
	/**（可选项）模块索引值*/ 
	mIndex?:number,

}

interface UIScrollPicture_show_Params {
	/**（可选项）模块索引值*/ 
	mIndex?:number,

}

interface UIScrollPicture_hide_Params {
	/**（可选项）模块索引值*/ 
	mIndex?:number,

}

interface UIScrollPicture_setCurrentIndex_Params {
	/**（可选项）模块索引值*/ 
	mIndex?:number,

	/**（可选项）索引值*/ 
	index?:number,

}

interface UIScrollPicture_reloadData_Params {
	/**（可选项）模块索引值*/ 
	mIndex?:number,

	/**模块的图片路径数组，及说明文字数组*/ 
	data:JSON,

}

interface UIScrollPicture_addEventListener_Params {
	/**监听的事件名称，取值范围：'scroll'（图片滚动事件）*/ 
	name:string,

}

interface UIInputBox {
	/** 打开聊天输入框*/ 
	open(callback?: (ret:JSON) => void):void

	/** 关闭聊天输入框*/ 
	close():void

	/** 显示聊天输入框*/ 
	show():void

	/** 隐藏聊天输入框*/ 
	hide():void

	/** 弹出表情*/ 
	popupBoard():void

	/** 收起表情*/ 
	closeBoard():void

	/** 弹出键盘*/ 
	popupKeyboard():void

	/** 收起键盘*/ 
	closeKeyboard():void

	/**
	 * `获取或设置聊天输入框的内容`
	 * ========params==========
	 *
	 * `msg` :string : （可选项）聊天输入框的内容，若不传则返回输入框的值
	 */
	value(params:UIInputBox_value_Params, callback?: (ret:JSON) => void):void

	/**
	 * `向聊天输入框的指定位置插入内容`
	 * ========params==========
	 *
	 * `index` :number : （可选项）待插入内容的起始位置。**注意：中文，全角符号均占一个字符长度；索引从0开始，0表示插入到最前面，1表示插入到第一个字符后面，2表示插入到第二个字符后面，以此类推。**
	 *
	 * `msg` :string : （可选项）要插入的内容
	 */
	insertValue(params:UIInputBox_insertValue_Params):void

	/** 事件监听 （输入区域，输入框及两侧按钮区域）*/ 
	addEventListener():void

	/**
	 * `重设聊天输入框的占位提示文本`
	 * ========params==========
	 *
	 * `placeholder` :string : （可选项）占位提示文本，若不传或传空则表示清空占位提示内容
	 */
	setPlaceholder(params:UIInputBox_setPlaceholder_Params):void

}
interface UIInputBox_value_Params {
	/**（可选项）聊天输入框的内容，若不传则返回输入框的值*/ 
	msg?:string,

}

interface UIInputBox_insertValue_Params {
	/**（可选项）待插入内容的起始位置。**注意：中文，全角符号均占一个字符长度；索引从0开始，0表示插入到最前面，1表示插入到第一个字符后面，2表示插入到第二个字符后面，以此类推。***/ 
	index?:number,

	/**（可选项）要插入的内容*/ 
	msg?:string,

}

interface UIInputBox_setPlaceholder_Params {
	/**（可选项）占位提示文本，若不传或传空则表示清空占位提示内容*/ 
	placeholder?:string,

}

interface listViewEntity {
	/**
	 * `打开 listViewEntity 模块`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `data` :Array : 列表的数据源，**开发者可以自定义唯一的键值对信息（如：uid: '1001'），供 getIndex 使用**
	 *
	 * `rightBtns` :Array : （可选项）列表项向左滑动露出的按钮组，**建议：配置列表每项的通用按钮，用此参数；配置某一项的特定按钮，可在 `data` 数组的指定项传入 `rightBtns` 参数**
	 *
	 * `bounces` :boolean : （可选项）是否开启弹动，android 平台不支持本参数
	 *
	 * `styles` :string : （可选项）模块各部分的样式
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `showScrollBar` :boolean : （可选项）是否显示滚动条
	 */
	open(params:listViewEntity_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭数据列表模块*/ 
	close():void

	/** 显示 listViewEntity 模块*/ 
	show():void

	/** 隐藏 listViewEntity 模块*/ 
	hide():void

	/**
	 * `设置列表的纵坐标和高度`
	 * ========params==========
	 *
	 * `y` :number : （可选项）模块的纵坐标
	 *
	 * `h` :number : （可选项）模块的高度
	 */
	setAttr(params:listViewEntity_setAttr_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据开发者自定义的唯一标识（open 接口的 data 参数中自定义的唯一标识）查找列表项对应的数据`
	 * ========params==========
	 *
	 * `key` :string : 调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 key
	 *
	 * `value` :string : 调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 value
	 */
	getIndex(params:listViewEntity_getIndex_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据列表项的索引获取对应的数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）列表项的索引
	 */
	getDataByIndex(params:listViewEntity_getDataByIndex_Params, callback?: (ret:JSON) => void):void

	/**
	 * `设置侧滑显示出来的按钮`
	 * ========params==========
	 *
	 * `index` :number : （可选项）列表项的索引
	 *
	 * `btns` :Array : （可选项）列表项侧滑露出的按钮组
	 */
	setSwipeBtns(params:listViewEntity_setSwipeBtns_Params, callback?: (ret:JSON) => void):void

	/**
	 * `刷新列表数据`
	 * ========params==========
	 *
	 * `data` :Array : （可选项）列表的数据源，**若不传或传空，仅收起下拉刷新组件**
	 */
	reloadData(params:listViewEntity_reloadData_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引删除某一条列表的数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）数据列表的索引
	 */
	deleteItem(params:listViewEntity_deleteItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引更新某一条列表的数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）数据列表的索引
	 *
	 * `data` :JSON : 列表的数据源
	 */
	updateItem(params:listViewEntity_updateItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引向某一条列表插入数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）数据列表的索引
	 *
	 * `data` :JSON : 列表的数据源
	 */
	insertItem(params:listViewEntity_insertItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `向列表末端追加数据`
	 * ========params==========
	 *
	 * `data` :Array : 列表的数据源，**若不传或传空，仅收起上拉加载组件**
	 */
	appendData(params:listViewEntity_appendData_Params, callback?: (ret:JSON) => void):void

	/** 获取当前列表的总数据量*/ 
	getCount():void

	/**
	 * `设置下拉刷新，**通过 reloadData 收起下拉刷新组件**`
	 * ========params==========
	 *
	 * `loadingImg` :string : 下拉刷新时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）
	 *
	 * `bgColor` :string : （可选项）下拉刷新区域的背景色，支持 rgb、rgba、#
	 *
	 * `textColor` :string : （可选项）提示文字颜色，支持 rgb、rgba、#
	 *
	 * `textDown` :string : （可选项）下拉提示文字
	 *
	 * `textUp` :string : （可选项）松开提示文字
	 *
	 * `loadingText` :string : （可选项）提示文字
	 *
	 * `lastUpdateText` :string : （可选项）提示文字
	 *
	 * `showTime` :boolean : （可选项）是否显示刷新时间
	 */
	setRefreshHeader(params:listViewEntity_setRefreshHeader_Params):void

	/**
	 * `设置上拉加载，**通过 appendData 收起上拉加载组件**`
	 * ========params==========
	 *
	 * `loadingImg` :string : 上拉加载时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）
	 *
	 * `bgColor` :string : （可选项）上拉加载区域的背景色，支持 rgb、rgba、#
	 *
	 * `textColor` :string : （可选项）提示文字颜色，支持 rgb、rgba、#
	 *
	 * `textUp` :string : （可选项）上拉提示文字
	 *
	 * `textDown` :string : （可选项）松开提示文字
	 *
	 * `loadingText` :string : （可选项）提示文字
	 *
	 * `lastUpdateText` :string : （可选项）提示文字
	 *
	 * `showTime` :boolean : （可选项）是否显示刷新时间
	 */
	setRefreshFooter(params:listViewEntity_setRefreshFooter_Params):void

}
interface listViewEntity_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**列表的数据源，**开发者可以自定义唯一的键值对信息（如：uid: '1001'），供 getIndex 使用***/ 
	data:Array,

	/**（可选项）列表项向左滑动露出的按钮组，**建议：配置列表每项的通用按钮，用此参数；配置某一项的特定按钮，可在 `data` 数组的指定项传入 `rightBtns` 参数***/ 
	rightBtns?:Array,

	/**（可选项）是否开启弹动，android 平台不支持本参数*/ 
	bounces?:boolean,

	/**（可选项）模块各部分的样式*/ 
	styles?:string,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）是否显示滚动条*/ 
	showScrollBar?:boolean,

}

interface listViewEntity_setAttr_Params {
	/**（可选项）模块的纵坐标*/ 
	y?:number,

	/**（可选项）模块的高度*/ 
	h?:number,

}

interface listViewEntity_getIndex_Params {
	/**调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 key*/ 
	key:string,

	/**调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 value*/ 
	value:string,

}

interface listViewEntity_getDataByIndex_Params {
	/**（可选项）列表项的索引*/ 
	index?:number,

}

interface listViewEntity_setSwipeBtns_Params {
	/**（可选项）列表项的索引*/ 
	index?:number,

	/**（可选项）列表项侧滑露出的按钮组*/ 
	btns?:Array,

}

interface listViewEntity_reloadData_Params {
	/**（可选项）列表的数据源，**若不传或传空，仅收起下拉刷新组件***/ 
	data?:Array,

}

interface listViewEntity_deleteItem_Params {
	/**（可选项）数据列表的索引*/ 
	index?:number,

}

interface listViewEntity_updateItem_Params {
	/**（可选项）数据列表的索引*/ 
	index?:number,

	/**列表的数据源*/ 
	data:JSON,

}

interface listViewEntity_insertItem_Params {
	/**（可选项）数据列表的索引*/ 
	index?:number,

	/**列表的数据源*/ 
	data:JSON,

}

interface listViewEntity_appendData_Params {
	/**列表的数据源，**若不传或传空，仅收起上拉加载组件***/ 
	data:Array,

}

interface listViewEntity_setRefreshHeader_Params {
	/**下拉刷新时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）*/ 
	loadingImg:string,

	/**（可选项）下拉刷新区域的背景色，支持 rgb、rgba、#*/ 
	bgColor?:string,

	/**（可选项）提示文字颜色，支持 rgb、rgba、#*/ 
	textColor?:string,

	/**（可选项）下拉提示文字*/ 
	textDown?:string,

	/**（可选项）松开提示文字*/ 
	textUp?:string,

	/**（可选项）提示文字*/ 
	loadingText?:string,

	/**（可选项）提示文字*/ 
	lastUpdateText?:string,

	/**（可选项）是否显示刷新时间*/ 
	showTime?:boolean,

}

interface listViewEntity_setRefreshFooter_Params {
	/**上拉加载时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）*/ 
	loadingImg:string,

	/**（可选项）上拉加载区域的背景色，支持 rgb、rgba、#*/ 
	bgColor?:string,

	/**（可选项）提示文字颜色，支持 rgb、rgba、#*/ 
	textColor?:string,

	/**（可选项）上拉提示文字*/ 
	textUp?:string,

	/**（可选项）松开提示文字*/ 
	textDown?:string,

	/**（可选项）提示文字*/ 
	loadingText?:string,

	/**（可选项）提示文字*/ 
	lastUpdateText?:string,

	/**（可选项）是否显示刷新时间*/ 
	showTime?:boolean,

}

interface mtlCityPicker {
	/**
	 * `打开城市选择器`
	 * ========params==========
	 *
	 * `province` :string : （可选项）默认选择省份
	 *
	 * `resource` :string : （可选项）选择器的数据源文件路径，要求本地路径（widget://、fs://)
	 */
	chooseCity(params:mtlCityPicker_chooseCity_Params, callback?: (ret:JSON) => void):void

}
interface mtlCityPicker_chooseCity_Params {
	/**（可选项）默认选择省份*/ 
	province?:string,

	/**（可选项）选择器的数据源文件路径，要求本地路径（widget://、fs://)*/ 
	resource?:string,

}

interface superKeyboard {
	/** 打开模块。*/ 
	open(callback?: (ret:JSON, err:JSON) => void):void

	/** 关闭键盘。*/ 
	close(callback?: (ret:JSON, err:JSON) => void):void

	/** 获取模块宽度。*/ 
	getWidth(callback?: (ret:JSON, err:JSON) => void):void

}
interface mtlGestureUnlock {
	/**
	 * `打开设置手势密码页面`
	 * ========params==========
	 *
	 * `animate` :boolean : （可选项）打开和关闭设置密码页面是否带动画效果
	 *
	 * `isOri` :boolean : （可选项）是否为横屏显示
	 */
	create(params:mtlGestureUnlock_create_Params, callback?: (ret:JSON) => void):void

	/**
	 * `打开验证手势密码页面`
	 * ========params==========
	 *
	 * `animate` :boolean : （可选项）打开和关闭验证密码页面是否带动画效果
	 *
	 * `track` :boolean : （可选项）是否显示手势轨迹
	 *
	 * `user` :JSON : （可选项）用户信息，不传则不显示(暂仅支持iOS)
	 */
	validate(params:mtlGestureUnlock_validate_Params, callback?: (ret:JSON) => void):void

	/** 删除设置的手势密码*/ 
	delete():void

	/** 获取设置的手势密码*/ 
	gesturesPassword():void

}
interface mtlGestureUnlock_create_Params {
	/**（可选项）打开和关闭设置密码页面是否带动画效果*/ 
	animate?:boolean,

	/**（可选项）是否为横屏显示*/ 
	isOri?:boolean,

}

interface mtlGestureUnlock_validate_Params {
	/**（可选项）打开和关闭验证密码页面是否带动画效果*/ 
	animate?:boolean,

	/**（可选项）是否显示手势轨迹*/ 
	track?:boolean,

	/**（可选项）用户信息，不传则不显示(暂仅支持iOS)*/ 
	user?:JSON,

}

interface watermark {
	/** 添加水印，此接口仅添加一个水印*/ 
	addWatermark():void

	/** 添加水印,此接口会将水印铺满整页，此接口建议rotate为-45。且此接口iOS与android样式有一定差距 如不符合要求建议使用addWatermark自行铺满。*/ 
	addAllPageWatermark():void

	/** 移除水印*/ 
	removeWatermark():void

}
interface UICoverFlowS {
	/**
	 * `打开 UICoverFlowS`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `styles` :JSON : 图片流的整体样式设置
	 *
	 * `index` :number : （可选项）初始选中的图片索引值，从 0 开始
	 *
	 * `reflect` :boolean : （可选项）图片是否显示倒影
	 *
	 * `isOpenAutoScroll` :boolean : （可选项）轮播图是否开启无限自动轮播
	 *
	 * `autoTime` :number : （可选项）自动轮播间隔时间（秒）
	 *
	 * `images` :Array<JSON> : 为图片流指定数据
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）是否将模块视图固定到窗口上，不跟随窗口上下滚动
	 */
	open(params:UICoverFlowS_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `滚动到指定条目`
	 * ========params==========
	 *
	 * `index` :number : 滚动的指定位置索引
	 *
	 * `id` :number : 轮播图对应id
	 */
	setIndex(params:UICoverFlowS_setIndex_Params):void

	/** 关闭 UICoverFlowS*/ 
	close():void

	/** 隐藏显示的 coverFlow*/ 
	hide():void

	/** 显示已隐藏的 UICoverFlowS*/ 
	show():void

}
interface UICoverFlowS_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**图片流的整体样式设置*/ 
	styles:JSON,

	/**（可选项）初始选中的图片索引值，从 0 开始*/ 
	index?:number,

	/**（可选项）图片是否显示倒影*/ 
	reflect?:boolean,

	/**（可选项）轮播图是否开启无限自动轮播*/ 
	isOpenAutoScroll?:boolean,

	/**（可选项）自动轮播间隔时间（秒）*/ 
	autoTime?:number,

	/**为图片流指定数据*/ 
	images:Array<JSON>,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）是否将模块视图固定到窗口上，不跟随窗口上下滚动*/ 
	fixed?:boolean,

}

interface UICoverFlowS_setIndex_Params {
	/**滚动的指定位置索引*/ 
	index:number,

	/**轮播图对应id*/ 
	id:number,

}

interface UIGraph {
	/**
	 * `打开贝塞尔曲线模块`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `yAxis` :JSON : 曲线图的y轴信息
	 *
	 * `data` :Array : 曲线关键结点的数据
	 *
	 * `styles` :JSON : （可选项）模块各部分的样式
	 *
	 * `showNode` :boolean : （可选项）是否默认显示结点
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	open(params:UIGraph_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `关闭曲线图模块`
	 * ========params==========
	 *
	 * `id` :number : 模块的 id，用于区分模块的多个实例
	 */
	close(params:UIGraph_close_Params):void

	/**
	 * `显示曲线图模块`
	 * ========params==========
	 *
	 * `id` :number : 模块的 id，用于区分模块的多个实例
	 */
	show(params:UIGraph_show_Params):void

	/**
	 * `隐藏曲线图模块`
	 * ========params==========
	 *
	 * `id` :number : 模块的 id，用于区分模块的多个实例
	 */
	hide(params:UIGraph_hide_Params):void

	/**
	 * `更新曲线图的数据`
	 * ========params==========
	 *
	 * `id` :number : 模块 id，用于区分多个模块实例
	 *
	 * `xScale` :number : 曲线x轴缩放比例
	 *
	 * `type` :string : 更新数据的方式
	 *
	 * `data` :Array : 要更新的数据
	 */
	reloadData(params:UIGraph_reloadData_Params):void

}
interface UIGraph_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**曲线图的y轴信息*/ 
	yAxis:JSON,

	/**曲线关键结点的数据*/ 
	data:Array,

	/**（可选项）模块各部分的样式*/ 
	styles?:JSON,

	/**（可选项）是否默认显示结点*/ 
	showNode?:boolean,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface UIGraph_close_Params {
	/**模块的 id，用于区分模块的多个实例*/ 
	id:number,

}

interface UIGraph_show_Params {
	/**模块的 id，用于区分模块的多个实例*/ 
	id:number,

}

interface UIGraph_hide_Params {
	/**模块的 id，用于区分模块的多个实例*/ 
	id:number,

}

interface UIGraph_reloadData_Params {
	/**模块 id，用于区分多个模块实例*/ 
	id:number,

	/**曲线x轴缩放比例*/ 
	xScale:number,

	/**更新数据的方式*/ 
	type:string,

	/**要更新的数据*/ 
	data:Array,

}

interface addressBook {
	/**
	 * `打开文档预览`
	 * ========params==========
	 *
	 * `data` :JSON : 组织架构数据
	 */
	open(params:addressBook_open_Params, callback?: (ret:JSON) => void):void

}
interface addressBook_open_Params {
	/**组织架构数据*/ 
	data:JSON,

}

interface guide {
	/**
	 * `打开图片导航`
	 * ========params==========
	 *
	 * `imgs` :string : （可选项）当前页面分页控件数图片地址（widget:// fs:// 相对路径都是支持），尺寸图片建议30 × 30。
	 *
	 * `btnColor` :string : （可选项）关闭按钮背景颜色(00FFFF)。
	 *
	 * `btnLabel` :string : （可选项）关闭按钮文字,默认马上体验。
	 *
	 * `btnW` :number : （可选项）关闭按钮宽，默认120。
	 *
	 * `btnH` :number : （可选项）关闭按钮文字高，默认33。
	 *
	 * `time` :string : （可选项）导航页消失的时间，以秒为单位。
	 *
	 * `hideStatusBar` :boolean : （可选）是否隐藏状态栏，默认值为true(隐藏状态栏)
	 */
	openGuidePage(params:guide_openGuidePage_Params):void

	/**
	 * `打开视频导航`
	 * ========params==========
	 *
	 * `path` :string : 导航视频本地地址（widget:// fs:// 相对路径都是支持）。
	 *
	 * `time` :string : （可选项）导航页消失的时间。
	 *
	 * `hideStatusBar` :boolean : （可选）是否隐藏状态栏，默认值为true(隐藏状态栏)
	 */
	openGuideVideo(params:guide_openGuideVideo_Params):void

	/**
	 * `打开循环视频导航`
	 * ========params==========
	 *
	 * `path` :string : 导航视频本地地址（widget:// fs:// 相对路径都是支持）。
	 *
	 * `borderColor` :string : 进入按钮边缘颜色，默认值是#FFFFFF（白色）。
	 *
	 * `titleColor` :string : 进入按钮字体颜色，默认值是#FFFFFF（白色）。
	 *
	 * `title` :string : 进入按钮文字，默认值字符串为 进入应用。
	 *
	 * `hideStatusBar` :boolean : （可选）是否隐藏状态栏，默认值为true(隐藏状态栏)
	 */
	openGuideRepeatVideo(params:guide_openGuideRepeatVideo_Params):void

}
interface guide_openGuidePage_Params {
	/**（可选项）当前页面分页控件数图片地址（widget:// fs:// 相对路径都是支持），尺寸图片建议30 × 30。*/ 
	imgs?:string,

	/**（可选项）关闭按钮背景颜色(00FFFF)。*/ 
	btnColor?:string,

	/**（可选项）关闭按钮文字,默认马上体验。*/ 
	btnLabel?:string,

	/**（可选项）关闭按钮宽，默认120。*/ 
	btnW?:number,

	/**（可选项）关闭按钮文字高，默认33。*/ 
	btnH?:number,

	/**（可选项）导航页消失的时间，以秒为单位。*/ 
	time?:string,

	/**（可选）是否隐藏状态栏，默认值为true(隐藏状态栏)*/ 
	hideStatusBar?:boolean,

}

interface guide_openGuideVideo_Params {
	/**导航视频本地地址（widget:// fs:// 相对路径都是支持）。*/ 
	path:string,

	/**（可选项）导航页消失的时间。*/ 
	time?:string,

	/**（可选）是否隐藏状态栏，默认值为true(隐藏状态栏)*/ 
	hideStatusBar?:boolean,

}

interface guide_openGuideRepeatVideo_Params {
	/**导航视频本地地址（widget:// fs:// 相对路径都是支持）。*/ 
	path:string,

	/**进入按钮边缘颜色，默认值是#FFFFFF（白色）。*/ 
	borderColor:string,

	/**进入按钮字体颜色，默认值是#FFFFFF（白色）。*/ 
	titleColor:string,

	/**进入按钮文字，默认值字符串为 进入应用。*/ 
	title:string,

	/**（可选）是否隐藏状态栏，默认值为true(隐藏状态栏)*/ 
	hideStatusBar?:boolean,

}

interface soundWave {
	/**
	 * `打开模块`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 *
	 * `numberOfWaves` :number : （可选项）副波条数
	 *
	 * `mainWaveWidth` :number : （可选项）主波波线粗细
	 *
	 * `decorativeWavesWidth` :number : （可选项）副波波线粗细
	 *
	 * `phaseShift` :number : （可选项）波浪线波动速度。
	 *
	 * `bgColor` :string : （可选项）背景色，支持rgb、rgba、#
	 *
	 * `waveColor` :string : （可选项）主波浪线颜色(副波线色根据此色取不同的alpha获取)，支持rgb、rgba、#
	 */
	open(params:soundWave_open_Params):void

	/** 关闭soundWave按钮，注意关闭按钮并不能停止投屏*/ 
	close():void

	/** 隐藏soundWave按钮*/ 
	hide():void

	/** 显示soundWave按钮*/ 
	show():void

	/**
	 * `设置波动振幅`
	 * ========params==========
	 *
	 * `level` :number : 波动振幅，0-1
	 */
	setLevel(params:soundWave_setLevel_Params):void

}
interface soundWave_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

	/**（可选项）副波条数*/ 
	numberOfWaves?:number,

	/**（可选项）主波波线粗细*/ 
	mainWaveWidth?:number,

	/**（可选项）副波波线粗细*/ 
	decorativeWavesWidth?:number,

	/**（可选项）波浪线波动速度。*/ 
	phaseShift?:number,

	/**（可选项）背景色，支持rgb、rgba、#*/ 
	bgColor?:string,

	/**（可选项）主波浪线颜色(副波线色根据此色取不同的alpha获取)，支持rgb、rgba、#*/ 
	waveColor?:string,

}

interface soundWave_setLevel_Params {
	/**波动振幅，0-1*/ 
	level:number,

}

interface videoEdit {
	/**
	 * `打开视频剪辑页面`
	 * ========params==========
	 *
	 * `path` :string : 剪辑的视频本地路径,支持fs://，widget://（android仅支持fs以及原生路径）
	 *
	 * `maxDuration` :number : （可选项）剪辑后的最大时长，单位：s
	 *
	 * `styles` :JSON : （可选项）模块各部分的样式配置
	 *
	 * `ret` :any : null
	 */
	open(params:videoEdit_open_Params):void

	/** 关闭视频剪辑页面*/ 
	close():void

}
interface videoEdit_open_Params {
	/**剪辑的视频本地路径,支持fs://，widget://（android仅支持fs以及原生路径）*/ 
	path:string,

	/**（可选项）剪辑后的最大时长，单位：s*/ 
	maxDuration?:number,

	/**（可选项）模块各部分的样式配置*/ 
	styles?:JSON,

	/**null*/ 
	ret:any,

}

interface UIDatePickerTool {
	/**
	 * `打开选择器`
	 * ========params==========
	 *
	 * `rowHeight` :number : （可选项）设置选择器的行高
	 *
	 * `styles` :JSON : （可选项）模块各部分的样式
	 */
	open(params:UIDatePickerTool_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭选择器*/ 
	close():void

	/** 隐藏选择器*/ 
	hide():void

	/** 显示已隐藏的选择器*/ 
	show():void

}
interface UIDatePickerTool_open_Params {
	/**（可选项）设置选择器的行高*/ 
	rowHeight?:number,

	/**（可选项）模块各部分的样式*/ 
	styles?:JSON,

}

interface UIButton {
	/**
	 * `使按钮在视图最顶层显示`
	 * ========params==========
	 *
	 * `id ` :number : 操作按钮模块的 id
	 */
	bringToFront(params:UIButton_bringToFront_Params):void

}
interface UIButton_bringToFront_Params {
	/**操作按钮模块的 id*/ 
	id :number,

}

interface labelDragSort {
	/**
	 * `打开`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `styles` :JSON : （可选项）模块各部分的样式
	 *
	 * `labelArray` :Array : 所有标签文字数组
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）是否将模块视图固定到窗口上，不跟随窗口上下滚动
	 */
	open(params:labelDragSort_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `再次添加标签`
	 * ========params==========
	 *
	 * `labelArray` :Array : 所有标签文字数组
	 */
	addLabel(params:labelDragSort_addLabel_Params, callback?: (ret:JSON) => void):void

	/** 开始编辑*/ 
	startEdit():void

	/** 关闭*/ 
	close():void

	/** 显示*/ 
	show():void

	/** 隐藏*/ 
	hide():void

	/** 编辑完成*/ 
	finishEdit(callback?: (ret:JSON) => void):void

	/** 删除标签*/ 
	deleteLabel(callback?: (ret:JSON) => void):void

}
interface labelDragSort_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**（可选项）模块各部分的样式*/ 
	styles?:JSON,

	/**所有标签文字数组*/ 
	labelArray:Array,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）是否将模块视图固定到窗口上，不跟随窗口上下滚动*/ 
	fixed?:boolean,

}

interface labelDragSort_addLabel_Params {
	/**所有标签文字数组*/ 
	labelArray:Array,

}

interface UIAlertView {
	/**
	 * `弹出 alert 样式的对话框`
	 * ========params==========
	 *
	 * `texts` :string : （可选项）alert 对话框模块可配置的文本
	 *
	 * `styles` :number : alert 对话框样式配置
	 */
	alert(params:UIAlertView_alert_Params, callback?: (ret:JSON) => void):void

	/**
	 * `弹出 自动消失 样式的对话框`
	 * ========params==========
	 *
	 * `width` :number : （可选项）宽度，image有值才会生效，否则弹窗宽度适应文字长度
	 *
	 * `time` :number : （可选项）自动消失时间
	 *
	 * `content` :string : （可选项）文本内容
	 *
	 * `image` :string : （可选项）图片路径，支持fs、widget
	 */
	disappeal(params:UIAlertView_disappeal_Params):void

	/**
	 * `弹出 input 样式的对话框`
	 * ========params==========
	 *
	 * `placeholder` :string : （可选项）输入框提示文本
	 *
	 * `max` :number : （可选项）编辑框最大行数 大于行数则滚动
	 *
	 * `texts` :string : （可选项）alert 对话框模块可配置的文本
	 *
	 * `styles` :number : alert 对话框样式配置
	 */
	input(params:UIAlertView_input_Params, callback?: (ret:JSON) => void):void

	/**
	 * `弹出 广告 样式的对话框`
	 * ========params==========
	 *
	 * `size` :JSON : （可选项）显示图片的大小
	 *
	 * `image` :string : （可选项）图片路径，支持fs、widget
	 */
	advertisement(params:UIAlertView_advertisement_Params, callback?: (ret:JSON) => void):void

	/**
	 * `弹出 下载 样式的对话框`
	 * ========params==========
	 *
	 * `image` :string : （可选项）图片路径，支持fs、widget
	 *
	 * `title` :string : （可选项）标题
	 *
	 * `titleColor` :string : （可选项）文字颜色，支持#、rgb、rgba
	 *
	 * `progressColor` :string : （可选项）进度条颜色，支持#、rgb、rgba
	 *
	 * `titleSize` :number : （可选项）标题文字大小
	 */
	down(params:UIAlertView_down_Params):void

	/**
	 * `更新下载样式的对话框进度条数据`
	 * ========params==========
	 *
	 * `seconds` :number : （可选项）进度
	 */
	update(params:UIAlertView_update_Params):void

	/** 关闭弹出的对话框*/ 
	close():void

}
interface UIAlertView_alert_Params {
	/**（可选项）alert 对话框模块可配置的文本*/ 
	texts?:string,

	/**alert 对话框样式配置*/ 
	styles:number,

}

interface UIAlertView_disappeal_Params {
	/**（可选项）宽度，image有值才会生效，否则弹窗宽度适应文字长度*/ 
	width?:number,

	/**（可选项）自动消失时间*/ 
	time?:number,

	/**（可选项）文本内容*/ 
	content?:string,

	/**（可选项）图片路径，支持fs、widget*/ 
	image?:string,

}

interface UIAlertView_input_Params {
	/**（可选项）输入框提示文本*/ 
	placeholder?:string,

	/**（可选项）编辑框最大行数 大于行数则滚动*/ 
	max?:number,

	/**（可选项）alert 对话框模块可配置的文本*/ 
	texts?:string,

	/**alert 对话框样式配置*/ 
	styles:number,

}

interface UIAlertView_advertisement_Params {
	/**（可选项）显示图片的大小*/ 
	size?:JSON,

	/**（可选项）图片路径，支持fs、widget*/ 
	image?:string,

}

interface UIAlertView_down_Params {
	/**（可选项）图片路径，支持fs、widget*/ 
	image?:string,

	/**（可选项）标题*/ 
	title?:string,

	/**（可选项）文字颜色，支持#、rgb、rgba*/ 
	titleColor?:string,

	/**（可选项）进度条颜色，支持#、rgb、rgba*/ 
	progressColor?:string,

	/**（可选项）标题文字大小*/ 
	titleSize?:number,

}

interface UIAlertView_update_Params {
	/**（可选项）进度*/ 
	seconds?:number,

}

interface handlock {
	/**
	 * `设置手势密码`
	 * ========params==========
	 *
	 * `titleName` :string : （可选项）默认为空,为空时没有标题栏，目前不支持设置标题栏颜色，如颜色不适用建议隐藏标题栏。
	 */
	set(params:handlock_set_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `修改手势密码，先验证原密码，后设置新密码`
	 * ========params==========
	 *
	 * `titleName` :string : （可选项）默认为空,为空时没有标题栏，目前不支持设置标题栏颜色，如颜色不适用建议隐藏标题栏。
	 *
	 * `handPassword` :string : 已设置的密码，例如：1,2,3,4,5,6。
	 */
	modify(params:handlock_modify_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `取消手势密码`
	 * ========params==========
	 *
	 * `titleName` :string : （可选项）默认为空,为空时没有标题栏，目前不支持设置标题栏颜色，如颜色不适用建议隐藏标题栏。
	 *
	 * `handPassword` :string : 已设置的密码，例如：1,2,3,4,5,6。
	 */
	cancel(params:handlock_cancel_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `解锁手势密码`
	 * ========params==========
	 *
	 * `titleName` :string : （可选项）默认为空,为空时没有标题栏，目前不支持设置标题栏颜色，如颜色不适用建议隐藏标题栏。
	 *
	 * `handPassword` :string : 已设置的密码，例如：1,2,3,4,5,6。
	 */
	unlock(params:handlock_unlock_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface handlock_set_Params {
	/**（可选项）默认为空,为空时没有标题栏，目前不支持设置标题栏颜色，如颜色不适用建议隐藏标题栏。*/ 
	titleName?:string,

}

interface handlock_modify_Params {
	/**（可选项）默认为空,为空时没有标题栏，目前不支持设置标题栏颜色，如颜色不适用建议隐藏标题栏。*/ 
	titleName?:string,

	/**已设置的密码，例如：1,2,3,4,5,6。*/ 
	handPassword:string,

}

interface handlock_cancel_Params {
	/**（可选项）默认为空,为空时没有标题栏，目前不支持设置标题栏颜色，如颜色不适用建议隐藏标题栏。*/ 
	titleName?:string,

	/**已设置的密码，例如：1,2,3,4,5,6。*/ 
	handPassword:string,

}

interface handlock_unlock_Params {
	/**（可选项）默认为空,为空时没有标题栏，目前不支持设置标题栏颜色，如颜色不适用建议隐藏标题栏。*/ 
	titleName?:string,

	/**已设置的密码，例如：1,2,3,4,5,6。*/ 
	handPassword:string,

}

interface matrixLock {
}
interface mtlPhotoPicker {
	/** 添加水印，此接口仅添加一个水印*/ 
	chooseImage():void

	/** 选取视频*/ 
	chooseVideo():void

	/** 图片预览*/ 
	previewImage():void

}
interface divisionalLineChart {
	/**
	 * `打开折线图视图`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `bg` :string : （可选项）模块背景色，支持rgb、rgba、#
	 *
	 * `coordinate` :JSON : （可选项）折线图的坐标系配置
	 *
	 * `shadow` :Array : （可选项）阴影内容样式配置信息组成的数组
	 *
	 * `data` :Array : 折线的数据信息
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : 是否将模块视图固定到窗口上，不跟随窗口上下滚动，可为空
	 */
	open(params:divisionalLineChart_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `刷新指定 id 的折线数据`
	 * ========params==========
	 *
	 * `id` :number : 要刷新的模块的 id
	 *
	 * `type` :string : 更新数据的方式
	 *
	 * `data` :Array : 折线的数据信息
	 */
	reloadData(params:divisionalLineChart_reloadData_Params, callback?: (ret:JSON) => void):void

	/**
	 * `更新阴影区域`
	 * ========params==========
	 *
	 * `id` :number : 要更新阴影的模块的 id
	 *
	 * `shadow` :Array : （可选项）阴影内容样式配置信息
	 */
	updateShadow(params:divisionalLineChart_updateShadow_Params, callback?: (ret:JSON) => void):void

	/**
	 * `关闭折线图视图，并从内存里清除`
	 * ========params==========
	 *
	 * `id` :number : 要关闭的模块的 id
	 */
	close(params:divisionalLineChart_close_Params, callback?: (ret:JSON) => void):void

	/** 隐藏折线图视图，并未从内存清除，可调用 show 接口显示该模块*/ 
	hide():void

	/** 显示已隐藏的折线图模块*/ 
	show():void

}
interface divisionalLineChart_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**（可选项）模块背景色，支持rgb、rgba、#*/ 
	bg?:string,

	/**（可选项）折线图的坐标系配置*/ 
	coordinate?:JSON,

	/**（可选项）阴影内容样式配置信息组成的数组*/ 
	shadow?:Array,

	/**折线的数据信息*/ 
	data:Array,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**是否将模块视图固定到窗口上，不跟随窗口上下滚动，可为空*/ 
	fixed:boolean,

}

interface divisionalLineChart_reloadData_Params {
	/**要刷新的模块的 id*/ 
	id:number,

	/**更新数据的方式*/ 
	type:string,

	/**折线的数据信息*/ 
	data:Array,

}

interface divisionalLineChart_updateShadow_Params {
	/**要更新阴影的模块的 id*/ 
	id:number,

	/**（可选项）阴影内容样式配置信息*/ 
	shadow?:Array,

}

interface divisionalLineChart_close_Params {
	/**要关闭的模块的 id*/ 
	id:number,

}

interface UICoverFlow {
	/** 清除缓存到本地的网络图片，**本接口只清除本模块缓存的数据，若要清除本app缓存的所有数据这调用api.clearCache***/ 
	clearCache():void

}
interface WXPhotoPicker {
	/** 请求相册权限（仅iOS支持）*/ 
	requestAlbumPermissions():void

	/**
	 * `打开多媒体资源选择器，打开后会全屏显示。`
	 * ========params==========
	 *
	 * `max` :number : （可选项）最多选择几张图片
	 *
	 * `styles` :JSON : （可选项）模块各部分的样式
	 *
	 * `alert` :JSON : （可选项）超过设置的选中的数量时的提示框样式
	 *
	 * `videoTimeFilter` :number : （可选项）选取视频的截取时长，单位秒。（仅iOS支持）
	 *
	 * `isCache` :boolean : （可选项）是否本地缓存图片，若为false，返回的资源路径均为相册ID，不存在本地沙盒路径中，thumbPath不返回，仅支持iOS
	 *
	 * `type` :string : 返回的资源种类；默认：'all'
	 *
	 * `isShowOriginal` :boolean : （可选项）是否显示原图按钮，若为false，不显示原图按钮并且返回的图片默认为原图路径
	 *
	 * `canEdit` :boolean : （可选项）照片、视频是否可以编辑，若为true，则显示编辑按钮，此参数仅支持iOS
	 */
	open(params:WXPhotoPicker_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `扫描系统多媒体资源，可以通过 Web 代码自定义多选界面。**注意：页面展示的图片使用缩略图，一次显示的图片不宜过多（1至2屏）**`
	 * ========params==========
	 *
	 * `type` :string : 返回的资源种类；默认：'all'
	 *
	 * `count` :number : （可选项）每次返回的资源数量，剩余资源可用 fetch 接口遍历（仅iOS支持，android返回所有资源）
	 *
	 * `sort` :JSON : （可选项）图片排序方式
	 *
	 * `isCache` :boolean : （可选项）是否本地缓存图片，若为false，thumbPath字段将不返回，仅支持iOS
	 */
	scan(params:WXPhotoPicker_scan_Params, callback?: (ret:JSON) => void):void

	/** 获取指定数量的多媒体资源，没有更多资源则返回空数组，**必须配合 scan 接口的 count 参数一起使用**。（仅IOS支持）*/ 
	fetch():void

	/**
	 * `扫描系统多媒体资源的分组，可以通过 Web 代码自定义多选界面。`
	 * ========params==========
	 *
	 * `type` :string : 返回的资源种类；默认：'all'
	 */
	scanGroups(params:WXPhotoPicker_scanGroups_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据分组id，扫描系统多媒体资源，可以通过 Web 代码自定义多选界面。**注意：页面展示的图片建议使用缩略图，一次显示的图片不宜过多（1至2屏）,本接口需先掉用scanGroups接口，否则无效**`
	 * ========params==========
	 *
	 * `groupId` :string : 分组id
	 *
	 * `type` :string : 分组类型；默认：'all'
	 *
	 * `count` :number : （可选项）每次返回的资源数量，剩余资源可用 fetchGroup 接口遍历（仅iOS支持）
	 *
	 * `page` :number : （可选项）第几页（仅android支持）
	 *
	 * `pageSize` :number : （可选项）每页个数（仅android支持）
	 *
	 * `sort` :JSON : （可选项）图片排序方式
	 *
	 * `isCache` :boolean : （可选项）是否本地缓存图片，若为false，thumbPath字段将不返回，仅支持iOS
	 */
	scanByGroupId(params:WXPhotoPicker_scanByGroupId_Params, callback?: (ret:JSON) => void):void

	/** 从分组中获取指定数量的多媒体资源，没有更多资源则返回空数组，**必须配合 scanByGroupId 接口的 count 参数一起使用**。（仅iOS支持）*/ 
	fetchGroup():void

	/**
	 * `将相册图片地址转换为可以直接使用的本地路径地址（临时文件夹的绝对路径），**相册图片会被拷贝到临时文件夹，调用 api.clearCache 接口可清除该临时图片文件**（仅iOS支持）`
	 * ========params==========
	 *
	 * `path` :string : 要转换的图片路径（在iOS端为在相册库的ID）
	 *
	 * `scale` :number : 图片质量
	 */
	transPath(params:WXPhotoPicker_transPath_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `视频路径转化，**iOS端直接获取的路径需经本接口转换后才能使用（播放、上传等）**（仅iOS支持）`
	 * ========params==========
	 *
	 * `path` :string : 要转换的视频路径（在相册库的绝对路径）
	 */
	transVideoPath(params:WXPhotoPicker_transVideoPath_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `以 frame 形式打开一个图片预览区域`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `groupId` :string : (可选项)要打开的相册分组 ID
	 *
	 * `isCache` :boolean : （可选项）是否本地缓存图片，若为false，thumbPath字段将不返回，仅支持iOS
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	openGroup(params:WXPhotoPicker_openGroup_Params, callback?: (ret:JSON) => void):void

	/** 关闭打开的相册分组预览区域*/ 
	closeGroup():void

	/**
	 * `通过分组ID改变预览区域显示的分组图片`
	 * ========params==========
	 *
	 * `groupId` :string : 要改变的相册分组 ID
	 */
	changeGroup(params:WXPhotoPicker_changeGroup_Params):void

	/**
	 * `获取视频长度`
	 * ========params==========
	 *
	 * `path` :string : 视频本地路径（支持 fs:// widget://路径）
	 */
	getVideoDuration(params:WXPhotoPicker_getVideoDuration_Params, callback?: (ret:JSON) => void):void

	/**
	 * `设置多媒体资源选择器文字语言`
	 * ========params==========
	 *
	 * `language` :string : （可选项）定制播放器文字语言
	 */
	setLanguage(params:WXPhotoPicker_setLanguage_Params):void

}
interface WXPhotoPicker_open_Params {
	/**（可选项）最多选择几张图片*/ 
	max?:number,

	/**（可选项）模块各部分的样式*/ 
	styles?:JSON,

	/**（可选项）超过设置的选中的数量时的提示框样式*/ 
	alert?:JSON,

	/**（可选项）选取视频的截取时长，单位秒。（仅iOS支持）*/ 
	videoTimeFilter?:number,

	/**（可选项）是否本地缓存图片，若为false，返回的资源路径均为相册ID，不存在本地沙盒路径中，thumbPath不返回，仅支持iOS*/ 
	isCache?:boolean,

	/**返回的资源种类；默认：'all'*/ 
	type:string,

	/**（可选项）是否显示原图按钮，若为false，不显示原图按钮并且返回的图片默认为原图路径*/ 
	isShowOriginal?:boolean,

	/**（可选项）照片、视频是否可以编辑，若为true，则显示编辑按钮，此参数仅支持iOS*/ 
	canEdit?:boolean,

}

interface WXPhotoPicker_scan_Params {
	/**返回的资源种类；默认：'all'*/ 
	type:string,

	/**（可选项）每次返回的资源数量，剩余资源可用 fetch 接口遍历（仅iOS支持，android返回所有资源）*/ 
	count?:number,

	/**（可选项）图片排序方式*/ 
	sort?:JSON,

	/**（可选项）是否本地缓存图片，若为false，thumbPath字段将不返回，仅支持iOS*/ 
	isCache?:boolean,

}

interface WXPhotoPicker_scanGroups_Params {
	/**返回的资源种类；默认：'all'*/ 
	type:string,

}

interface WXPhotoPicker_scanByGroupId_Params {
	/**分组id*/ 
	groupId:string,

	/**分组类型；默认：'all'*/ 
	type:string,

	/**（可选项）每次返回的资源数量，剩余资源可用 fetchGroup 接口遍历（仅iOS支持）*/ 
	count?:number,

	/**（可选项）第几页（仅android支持）*/ 
	page?:number,

	/**（可选项）每页个数（仅android支持）*/ 
	pageSize?:number,

	/**（可选项）图片排序方式*/ 
	sort?:JSON,

	/**（可选项）是否本地缓存图片，若为false，thumbPath字段将不返回，仅支持iOS*/ 
	isCache?:boolean,

}

interface WXPhotoPicker_transPath_Params {
	/**要转换的图片路径（在iOS端为在相册库的ID）*/ 
	path:string,

	/**图片质量*/ 
	scale:number,

}

interface WXPhotoPicker_transVideoPath_Params {
	/**要转换的视频路径（在相册库的绝对路径）*/ 
	path:string,

}

interface WXPhotoPicker_openGroup_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**(可选项)要打开的相册分组 ID*/ 
	groupId?:string,

	/**（可选项）是否本地缓存图片，若为false，thumbPath字段将不返回，仅支持iOS*/ 
	isCache?:boolean,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface WXPhotoPicker_changeGroup_Params {
	/**要改变的相册分组 ID*/ 
	groupId:string,

}

interface WXPhotoPicker_getVideoDuration_Params {
	/**视频本地路径（支持 fs:// widget://路径）*/ 
	path:string,

}

interface WXPhotoPicker_setLanguage_Params {
	/**（可选项）定制播放器文字语言*/ 
	language?:string,

}

interface popupMenu {
}
interface editDialog {
	/**
	 * `打开编辑框`
	 * ========params==========
	 *
	 * `rect` :JSON : （必填项）模块的位置及尺寸
	 *
	 * `fixedOn` :string : （可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 Window 或 Frame 滚动
	 *
	 * `fontSize` :number : （可选项）字体大小。(建议16-18)
	 *
	 * `fontColor` :string : （可选项）字体颜色。
	 *
	 * `inputType` :number : （可选项）键盘类型 (0:正常|1:数字|2:email|3:url|4:密码)。
	 *
	 * `inputHint` :string : （可选项）提示文字。
	 *
	 * `defaultText` :string : （可选项）默认显示文字。
	 *
	 * `maxNum` :number : （可选项）最大字数(如果为0,或者缺省长度无限制,并且不回调onNum事件方法)。
	 */
	openEditText(params:editDialog_openEditText_Params, callback?: (ret:JSON) => void):void

	/**
	 * `隐藏编辑框`
	 * ========params==========
	 *
	 * `index` :number : （可选项）需要操作的编辑框序号。
	 */
	hideEditText(params:editDialog_hideEditText_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `显示编辑框`
	 * ========params==========
	 *
	 * `index` :number : （可选项）需要操作的编辑框序号。
	 */
	showEditText(params:editDialog_showEditText_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `关闭编辑框`
	 * ========params==========
	 *
	 * `index` :number : （可选项）需要操作的编辑框序号。
	 */
	closeEditText(params:editDialog_closeEditText_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `插入数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）需要操作的编辑框序号。
	 *
	 * `data` :number : （必填项）需要插入到编辑框的数据。
	 */
	insertData(params:editDialog_insertData_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `清除所有数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）需要操作的编辑框序号。
	 */
	cleanAll(params:editDialog_cleanAll_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取编辑输入框内所有数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）需要操作的编辑框序号。
	 */
	getContent(params:editDialog_getContent_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface editDialog_openEditText_Params {
	/**（必填项）模块的位置及尺寸*/ 
	rect:JSON,

	/**（可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 Window 或 Frame 滚动*/ 
	fixed?:boolean,

	/**（可选项）字体大小。(建议16-18)*/ 
	fontSize?:number,

	/**（可选项）字体颜色。*/ 
	fontColor?:string,

	/**（可选项）键盘类型 (0:正常|1:数字|2:email|3:url|4:密码)。*/ 
	inputType?:number,

	/**（可选项）提示文字。*/ 
	inputHint?:string,

	/**（可选项）默认显示文字。*/ 
	defaultText?:string,

	/**（可选项）最大字数(如果为0,或者缺省长度无限制,并且不回调onNum事件方法)。*/ 
	maxNum?:number,

}

interface editDialog_hideEditText_Params {
	/**（可选项）需要操作的编辑框序号。*/ 
	index?:number,

}

interface editDialog_showEditText_Params {
	/**（可选项）需要操作的编辑框序号。*/ 
	index?:number,

}

interface editDialog_closeEditText_Params {
	/**（可选项）需要操作的编辑框序号。*/ 
	index?:number,

}

interface editDialog_insertData_Params {
	/**（可选项）需要操作的编辑框序号。*/ 
	index?:number,

	/**（必填项）需要插入到编辑框的数据。*/ 
	data:number,

}

interface editDialog_cleanAll_Params {
	/**（可选项）需要操作的编辑框序号。*/ 
	index?:number,

}

interface editDialog_getContent_Params {
	/**（可选项）需要操作的编辑框序号。*/ 
	index?:number,

}

interface UIDatePickerS {
	/**
	 * `打开选择器`
	 * ========params==========
	 *
	 * `rowHeight` :number : （可选项）设置选择器的行高
	 *
	 * `styles` :JSON : （可选项）模块各部分的样式
	 */
	open(params:UIDatePickerS_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭选择器*/ 
	close():void

	/** 隐藏选择器*/ 
	hide():void

	/** 显示已隐藏的选择器*/ 
	show():void

}
interface UIDatePickerS_open_Params {
	/**（可选项）设置选择器的行高*/ 
	rowHeight?:number,

	/**（可选项）模块各部分的样式*/ 
	styles?:JSON,

}

interface UIVividLine {
	/**
	 * `打开折线图视图`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `styles` :JSON : （可选项）折线图样式配置
	 *
	 * `datas` :Array : 折线的数据信息
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : 是否将模块视图固定到窗口上，不跟随窗口上下滚动，可为空
	 */
	open(params:UIVividLine_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `刷新折线数据`
	 * ========params==========
	 *
	 * `id` :number : 操作视图的 id
	 *
	 * `datas` :Array : 折线的数据信息
	 */
	reloadData(params:UIVividLine_reloadData_Params):void

	/**
	 * `往现有数据拼接新数据`
	 * ========params==========
	 *
	 * `id` :number : 操作视图的 id
	 *
	 * `datas` :Array : 折线的数据信息
	 *
	 * `orientation` :string : （可选项）拼接数据的方向，取值范围：right，left
	 */
	appendData(params:UIVividLine_appendData_Params):void

	/**
	 * `关闭折线图视图，并从内存里清空`
	 * ========params==========
	 *
	 * `id` :number : 操作视图的 id
	 */
	close(params:UIVividLine_close_Params):void

	/**
	 * `隐藏折线图视图，并没有从内存里清空`
	 * ========params==========
	 *
	 * `id` :number : 操作视图的 id
	 */
	hide(params:UIVividLine_hide_Params):void

	/**
	 * `显示已隐藏的折线图视图`
	 * ========params==========
	 *
	 * `id` :number : 操作视图的 id
	 */
	show(params:UIVividLine_show_Params):void

}
interface UIVividLine_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**（可选项）折线图样式配置*/ 
	styles?:JSON,

	/**折线的数据信息*/ 
	datas:Array,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**是否将模块视图固定到窗口上，不跟随窗口上下滚动，可为空*/ 
	fixed:boolean,

}

interface UIVividLine_reloadData_Params {
	/**操作视图的 id*/ 
	id:number,

	/**折线的数据信息*/ 
	datas:Array,

}

interface UIVividLine_appendData_Params {
	/**操作视图的 id*/ 
	id:number,

	/**折线的数据信息*/ 
	datas:Array,

	/**（可选项）拼接数据的方向，取值范围：right，left*/ 
	orientation?:string,

}

interface UIVividLine_close_Params {
	/**操作视图的 id*/ 
	id:number,

}

interface UIVividLine_hide_Params {
	/**操作视图的 id*/ 
	id:number,

}

interface UIVividLine_show_Params {
	/**操作视图的 id*/ 
	id:number,

}

interface gestureUnlock {
	/**
	 * `打开手势解锁/设置页面`
	 * ========params==========
	 *
	 * `rect` :JSON : (可选项）手势解锁/设置页面的位置及长宽
	 *
	 * `password` :string : （可选项）用户设置的手势密码，手势解锁时必须设置此参数
	 *
	 * `type` :string : （可选项）页面类型
	 *
	 * `showArrowDirection` :boolean : （可选项）是否显示指示手势划过的方向箭头
	 *
	 * `styles` :JSON : （可选项）手势解锁/设置页面样式设置
	 *
	 * `fixedOn` :string : （可选项）添加到哪个frame，与fixed一起使用
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	open(params:gestureUnlock_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭手势解锁/设置页面*/ 
	close():void

	/** 隐藏手势解锁/设置页面*/ 
	hide():void

	/** 显示已隐藏的手势解锁/设置页面*/ 
	show():void

}
interface gestureUnlock_open_Params {
	/**(可选项）手势解锁/设置页面的位置及长宽*/ 
	rect?:JSON,

	/**（可选项）用户设置的手势密码，手势解锁时必须设置此参数*/ 
	password?:string,

	/**（可选项）页面类型*/ 
	type?:string,

	/**（可选项）是否显示指示手势划过的方向箭头*/ 
	showArrowDirection?:boolean,

	/**（可选项）手势解锁/设置页面样式设置*/ 
	styles?:JSON,

	/**（可选项）添加到哪个frame，与fixed一起使用*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface UIAdaptiveInput {
	/** 打开输入框*/ 
	open(callback?: (ret:JSON) => void):void

	/**
	 * `事件监听`
	 * ========params==========
	 *
	 * `name` :string : 监听的事件类型
	 */
	addEventListener(params:UIAdaptiveInput_addEventListener_Params, callback?: (ret:JSON) => void):void

	/**
	 * `关闭指定输入框`
	 * ========params==========
	 *
	 * `id` :string : 所操作模块的 ID
	 */
	close(params:UIAdaptiveInput_close_Params):void

	/**
	 * `显示输入框`
	 * ========params==========
	 *
	 * `id` :string : 所操作模块的 ID
	 */
	show(params:UIAdaptiveInput_show_Params):void

	/**
	 * `隐藏输入框，并没有从内存里清除`
	 * ========params==========
	 *
	 * `id` :string : 所操作模块的 ID
	 */
	hide(params:UIAdaptiveInput_hide_Params):void

	/**
	 * `弹出键盘`
	 * ========params==========
	 *
	 * `id` :string : 所操作模块的 ID
	 */
	becomeFirstResponder(params:UIAdaptiveInput_becomeFirstResponder_Params):void

	/**
	 * `隐藏键盘`
	 * ========params==========
	 *
	 * `id` :string : 所操作模块的 ID
	 */
	resignFirstResponder(params:UIAdaptiveInput_resignFirstResponder_Params):void

	/**
	 * `设置输入框内的文字`
	 * ========params==========
	 *
	 * `id` :string : 所操作模块的 ID
	 *
	 * `value` :string : （可选项）要设置的输入框内的文字内容
	 */
	setValue(params:UIAdaptiveInput_setValue_Params):void

	/**
	 * `获取当前输入框内的文字`
	 * ========params==========
	 *
	 * `id` :string : 所操作模块的 ID
	 */
	getValue(params:UIAdaptiveInput_getValue_Params, callback?: (ret:JSON) => void):void

	/**
	 * `向当前输入框内指定位置插入字符串`
	 * ========params==========
	 *
	 * `id` :string : 所操作模块的 ID
	 *
	 * `index` :number : （可选项）插入当前输入框内字符串的位置
	 *
	 * `value` :string : （可选项）要设置的输入框内的文字内容
	 */
	insertValue(params:UIAdaptiveInput_insertValue_Params):void

}
interface UIAdaptiveInput_addEventListener_Params {
	/**监听的事件类型*/ 
	name:string,

}

interface UIAdaptiveInput_close_Params {
	/**所操作模块的 ID*/ 
	id:string,

}

interface UIAdaptiveInput_show_Params {
	/**所操作模块的 ID*/ 
	id:string,

}

interface UIAdaptiveInput_hide_Params {
	/**所操作模块的 ID*/ 
	id:string,

}

interface UIAdaptiveInput_becomeFirstResponder_Params {
	/**所操作模块的 ID*/ 
	id:string,

}

interface UIAdaptiveInput_resignFirstResponder_Params {
	/**所操作模块的 ID*/ 
	id:string,

}

interface UIAdaptiveInput_setValue_Params {
	/**所操作模块的 ID*/ 
	id:string,

	/**（可选项）要设置的输入框内的文字内容*/ 
	value?:string,

}

interface UIAdaptiveInput_getValue_Params {
	/**所操作模块的 ID*/ 
	id:string,

}

interface UIAdaptiveInput_insertValue_Params {
	/**所操作模块的 ID*/ 
	id:string,

	/**（可选项）插入当前输入框内字符串的位置*/ 
	index?:number,

	/**（可选项）要设置的输入框内的文字内容*/ 
	value?:string,

}

interface UIChatTools {
	/** 打开聊天输入框*/ 
	open(callback?: (ret:JSON) => void):void

	/**
	 * `设置附加功能按钮，**仅当 open 接口内 tools->append 参数有值时，本接口有效**`
	 * ========params==========
	 *
	 * `styles` :JSON : （可选项）附加功能面板按钮样式配置
	 *
	 * `buttons` :Array : 附加功能面板按钮信息集合，可分页显示
	 */
	setAppendButton(params:UIChatTools_setAppendButton_Params, callback?: (ret:JSON) => void):void

	/**
	 * `表情面板相关功能事件的监听，**仅当 open 接口内 tools->face 参数有值时，本接口有效**`
	 * ========params==========
	 *
	 * `name` :string : 事件的目标对象
	 */
	faceListener(params:UIChatTools_faceListener_Params, callback?: (ret:JSON) => void):void

	/**
	 * `添加表情包，**仅当 open 接口内 tools->face 参数有值时，本接口有效**`
	 * ========params==========
	 *
	 * `path` :string : 表情包文件夹路径，表情包格式规范要求同 open 内附加表情包格式规范一致
	 */
	addFace(params:UIChatTools_addFace_Params, callback?: (ret:JSON) => void):void

	/** 选择图片相关功能事件的监听，**仅当 open 接口内 tools->image 参数有值时，本接口有效***/ 
	imageListener(callback?: (ret:JSON) => void):void

	/** 用户点击工具栏内某个按钮事件的监听*/ 
	toolsListener():void

	/** 录音相关功能事件的监听，**仅当 open 接口内 tools->recorder 参数有值时，本接口有效***/ 
	recorderListener(callback?: (ret:JSON) => void):void

	/** 开始录音后开启录音计时器，使录音页面计时器开始计时。**本接口仅能在 recorderListener 监听 target 为 talkback/record，name 为 press/start 时的监听回调函数内调用***/ 
	startTimer():void

	/** 关闭聊天输入框*/ 
	close():void

	/** 显示聊天输入框*/ 
	show():void

	/** 隐藏聊天输入框*/ 
	hide():void

	/** 弹出键盘*/ 
	popupKeyboard():void

	/** 收起键盘*/ 
	closeKeyboard():void

	/**
	 * `弹出表情、附加功能面板`
	 * ========params==========
	 *
	 * `target` :string : 操作的面板类型，取值范围如下：
	 */
	popupBoard(params:UIChatTools_popupBoard_Params):void

	/** 收起表情、附加功能面板*/ 
	closeBoard():void

	/**
	 * `获取或设置聊天输入框的内容`
	 * ========params==========
	 *
	 * `msg` :string : （可选项）聊天输入框的内容，若不传则返回输入框的值
	 */
	value(params:UIChatTools_value_Params, callback?: (ret:JSON) => void):void

	/**
	 * `向聊天输入框的指定位置插入内容`
	 * ========params==========
	 *
	 * `index` :number : （可选项）待插入内容的起始位置。**注意：中文，全角符号均占一个字符长度；索引从0开始，0表示插入到最前面，1表示插入到第一个字符后面，2表示插入到第二个字符后面，以此类推。**
	 *
	 * `msg` :string : （可选项）要插入的内容
	 */
	insertValue(params:UIChatTools_insertValue_Params):void

	/**
	 * `添加输入框相关事件的监听`
	 * ========params==========
	 *
	 * `name` :string : 监听的事件类型
	 */
	chatBoxListener(params:UIChatTools_chatBoxListener_Params, callback?: (ret:JSON) => void):void

	/** 清空输入框文本*/ 
	clearText():void

	/** 取消录音*/ 
	cancelRecord():void

	/** 设置光标位置*/ 
	setCursorPosition():void

}
interface UIChatTools_setAppendButton_Params {
	/**（可选项）附加功能面板按钮样式配置*/ 
	styles?:JSON,

	/**附加功能面板按钮信息集合，可分页显示*/ 
	buttons:Array,

}

interface UIChatTools_faceListener_Params {
	/**事件的目标对象*/ 
	name:string,

}

interface UIChatTools_addFace_Params {
	/**表情包文件夹路径，表情包格式规范要求同 open 内附加表情包格式规范一致*/ 
	path:string,

}

interface UIChatTools_popupBoard_Params {
	/**操作的面板类型，取值范围如下：*/ 
	target:string,

}

interface UIChatTools_value_Params {
	/**（可选项）聊天输入框的内容，若不传则返回输入框的值*/ 
	msg?:string,

}

interface UIChatTools_insertValue_Params {
	/**（可选项）待插入内容的起始位置。**注意：中文，全角符号均占一个字符长度；索引从0开始，0表示插入到最前面，1表示插入到第一个字符后面，2表示插入到第二个字符后面，以此类推。***/ 
	index?:number,

	/**（可选项）要插入的内容*/ 
	msg?:string,

}

interface UIChatTools_chatBoxListener_Params {
	/**监听的事件类型*/ 
	name:string,

}

interface xinyanIDVerification {
}
interface citySelector {
	/**
	 * `打开城市选择器`
	 * ========params==========
	 *
	 * `y` :number : （可选项）选择器视图上边缘距离所依附窗口顶部的距离
	 *
	 * `height` :number : （可选项）选择器的高度，小于244无效
	 *
	 * `titleHeight` :number : （可选项）标题栏高度
	 *
	 * `cancelImg` :string : （可选项）取消按钮的背景图片的路径，要求本地路径（fs、widget）
	 *
	 * `enterImg` :string : （可选项）确定按钮的背景图片的路径（本地），要求本地路径（fs、widget）
	 *
	 * `titleImg` :string : （可选项）选择器顶端导航条背景图片的路径（本地），要求本地路径（fs、widget）
	 *
	 * `bgImg` :string : （可选项）选择器背景图片的路径（本地），要求本地路径（fs、widget）
	 *
	 * `fontColor` :string : （可选项）选择器字体颜色
	 *
	 * `selectedColor` :string : （可选项）选中字体颜色
	 *
	 * `anim` :boolean : （可选项）是否添加弹出动画
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 */
	open(params:citySelector_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `隐藏选择器`
	 * ========params==========
	 *
	 * `anim` :boolean : （可选项）是否添加动画
	 */
	hide(params:citySelector_hide_Params):void

	/** 显示选择器，从屏幕外移动到屏幕内*/ 
	show():void

	/** 关闭选择器，意味着从内存里清除*/ 
	close():void

}
interface citySelector_open_Params {
	/**（可选项）选择器视图上边缘距离所依附窗口顶部的距离*/ 
	y?:number,

	/**（可选项）选择器的高度，小于244无效*/ 
	height?:number,

	/**（可选项）标题栏高度*/ 
	titleHeight?:number,

	/**（可选项）取消按钮的背景图片的路径，要求本地路径（fs、widget）*/ 
	cancelImg?:string,

	/**（可选项）确定按钮的背景图片的路径（本地），要求本地路径（fs、widget）*/ 
	enterImg?:string,

	/**（可选项）选择器顶端导航条背景图片的路径（本地），要求本地路径（fs、widget）*/ 
	titleImg?:string,

	/**（可选项）选择器背景图片的路径（本地），要求本地路径（fs、widget）*/ 
	bgImg?:string,

	/**（可选项）选择器字体颜色*/ 
	fontColor?:string,

	/**（可选项）选中字体颜色*/ 
	selectedColor?:string,

	/**（可选项）是否添加弹出动画*/ 
	anim?:boolean,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

}

interface citySelector_hide_Params {
	/**（可选项）是否添加动画*/ 
	anim?:boolean,

}

interface paymentDialog {
	/**
	 * `打开输入框`
	 * ========params==========
	 *
	 * `style` :JSON : null
	 */
	show(params:paymentDialog_show_Params, callback?: (ret:JSON) => void):void

}
interface paymentDialog_show_Params {
	/**null*/ 
	style:JSON,

}

interface UIListContacts {
	/**
	 * `打开列表`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `contacts` :Array : 列表数据源
	 *
	 * `headHidden` :boolean : （可选项）是否隐藏头像和名字后面的职务标签（position）
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 */
	open(params:UIListContacts_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭列表模块*/ 
	close():void

	/** 隐藏列表模块，并没有从内存里清除*/ 
	hide():void

	/** 显示已隐藏的列表模块*/ 
	show():void

	/**
	 * `刷新列表数据`
	 * ========params==========
	 *
	 * `contacts` :JSON : 列表数据源
	 */
	reloadData(params:UIListContacts_reloadData_Params):void

}
interface UIListContacts_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**列表数据源*/ 
	contacts:Array,

	/**（可选项）是否隐藏头像和名字后面的职务标签（position）*/ 
	headHidden?:boolean,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

}

interface UIListContacts_reloadData_Params {
	/**列表数据源*/ 
	contacts:JSON,

}

interface UILoading {
	/** 打开 flower 样式的加载提示框。此样式接口封装了一种常见的“旋转菊花”型加载提示框，开发者只需自定义此加载提示框的位置及尺寸即可。同一个页面可打开多个该样式加载提示框，用 id 区分。*/ 
	flower():void

	/** 打开关键帧样式的加载提示框。该样式的加载提示框以播放一组关键帧图片的形式来呈现加载过程，该图片数组可通过 content 参数配置。*/ 
	keyFrame():void

	/**
	 * `关闭打开的加载提示框`
	 * ========params==========
	 *
	 * `id` :number : 关闭 flower 接口打开的 id 号对应加载提示框
	 *
	 * `isGradual` :boolean : （可选项）是否渐变消失 ；
	 */
	closeFlower(params:UILoading_closeFlower_Params):void

	/**
	 * `关闭打开的加载提示框`
	 * ========params==========
	 *
	 * `isGradual` :boolean : （可选项）是否渐变消失 ；
	 */
	closeKeyFrame(params:UILoading_closeKeyFrame_Params):void

}
interface UILoading_closeFlower_Params {
	/**关闭 flower 接口打开的 id 号对应加载提示框*/ 
	id:number,

	/**（可选项）是否渐变消失 ；*/ 
	isGradual?:boolean,

}

interface UILoading_closeKeyFrame_Params {
	/**（可选项）是否渐变消失 ；*/ 
	isGradual?:boolean,

}

interface UIPopupsPicker {
	/**
	 * `打开选择器`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸(底部滑杆)
	 *
	 * `resource` :string : 城市列表的数据源文件路径（支持widget、fs 路径协议），数据源文件必须为`.json`文件。城市的JSON数据会在callback时按原格式返回。若为 json 文件则必须是标准的 [json格式](http://www.bejson.com)，否则会报错。
	 */
	open(params:UIPopupsPicker_open_Params, callback?: (ret:JSON) => void):void

	/** 隐藏选择器*/ 
	hide():void

	/** 显示选择器*/ 
	show():void

	/** 关闭选择器*/ 
	close():void

}
interface UIPopupsPicker_open_Params {
	/**（可选项）模块的位置及尺寸(底部滑杆)*/ 
	rect?:JSON,

	/**城市列表的数据源文件路径（支持widget、fs 路径协议），数据源文件必须为`.json`文件。城市的JSON数据会在callback时按原格式返回。若为 json 文件则必须是标准的 [json格式](http://www.bejson.com)，否则会报错。*/ 
	resource:string,

}

interface multiSelector {
}
interface welcomePage {
	/**
	 * `打开welcomePage`
	 * ========params==========
	 *
	 * `isFullscreen` :boolean : （可选项）是否全屏(全屏不显示状态栏)
	 *
	 * `AnimationType` :string : （可选项）动画类型  'Default'  默认, 'DepthPage'  深入浅出, 'Cube'  立方体, 'Rotate'  旋转,'Accordion'  左右折叠, 'InRightUp'   右上角进入, 'InRightDown'  右下角进入, 'ZoomOutPage'  淡入淡出。
	 *
	 * `imgs` :Array : 导航图片（支持 widget:// fs://  不支持相对路径）。
	 *
	 * `setting` :JSON : （可选项）导航页相关设置。
	 */
	openWelcomePage(params:welcomePage_openWelcomePage_Params, callback?: (ret:JSON) => void):void

	/**
	 * `重新设置是否打开导航页`
	 * ========params==========
	 *
	 * `setWelcome` :boolean : （必选项）false 表示设置启动页为未打开状态  true 反之
	 */
	setWelcome(params:welcomePage_setWelcome_Params, callback?: (ret:JSON) => void):void

}
interface welcomePage_openWelcomePage_Params {
	/**（可选项）是否全屏(全屏不显示状态栏)*/ 
	isFullscreen?:boolean,

	/**（可选项）动画类型  'Default'  默认, 'DepthPage'  深入浅出, 'Cube'  立方体, 'Rotate'  旋转,'Accordion'  左右折叠, 'InRightUp'   右上角进入, 'InRightDown'  右下角进入, 'ZoomOutPage'  淡入淡出。*/ 
	AnimationType?:string,

	/**导航图片（支持 widget:// fs://  不支持相对路径）。*/ 
	imgs:Array,

	/**（可选项）导航页相关设置。*/ 
	setting?:JSON,

}

interface welcomePage_setWelcome_Params {
	/**（必选项）false 表示设置启动页为未打开状态  true 反之*/ 
	setWelcome:boolean,

}

interface zjListView {
	/**
	 * `打开 zjListView 模块`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `data` :Array : 列表的数据源，**开发者可以自定义唯一的键值对信息（如：uid: '1001'），供 getIndex 使用**
	 *
	 * `rightBtns` :Array : （可选项）列表项向左滑动露出的按钮组，**建议：配置列表每项的通用按钮，用此参数；配置某一项的特定按钮，可在 `data` 数组的指定项传入 `rightBtns` 参数**
	 *
	 * `bounces` :boolean : （可选项）是否开启弹动，android 平台不支持本参数
	 *
	 * `styles` :string : （可选项）模块各部分的样式
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `showScrollBar` :boolean : （可选项）是否显示滚动条
	 */
	open(params:zjListView_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `定位到指定位置`
	 * ========params==========
	 *
	 * `index` :number : （可选项）要定位到的cell序号，从0开始；如果传入数据大于列表总数则跳转到底部
	 */
	toIndex(params:zjListView_toIndex_Params):void

	/** 关闭数据列表模块*/ 
	close():void

	/** 显示 zjListView 模块*/ 
	show():void

	/** 隐藏 zjListView 模块*/ 
	hide():void

	/**
	 * `设置列表的纵坐标和高度`
	 * ========params==========
	 *
	 * `y` :number : （可选项）模块的纵坐标
	 *
	 * `h` :number : （可选项）模块的高度
	 */
	setAttr(params:zjListView_setAttr_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据开发者自定义的唯一标识（open 接口的 data 参数中自定义的唯一标识）查找列表项对应的数据`
	 * ========params==========
	 *
	 * `key` :string : 调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 key
	 *
	 * `value` :string : 调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 value
	 */
	getIndex(params:zjListView_getIndex_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据列表项的索引获取对应的数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）列表项的索引
	 */
	getDataByIndex(params:zjListView_getDataByIndex_Params, callback?: (ret:JSON) => void):void

	/**
	 * `设置侧滑显示出来的按钮`
	 * ========params==========
	 *
	 * `index` :number : （可选项）列表项的索引
	 *
	 * `btns` :Array : （可选项）列表项侧滑露出的按钮组
	 */
	setSwipeBtns(params:zjListView_setSwipeBtns_Params, callback?: (ret:JSON) => void):void

	/**
	 * `刷新列表数据`
	 * ========params==========
	 *
	 * `data` :Array : （可选项）列表的数据源，**若不传或传空，仅收起下拉刷新组件**
	 */
	reloadData(params:zjListView_reloadData_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引删除某一条列表的数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）数据列表的索引
	 */
	deleteItem(params:zjListView_deleteItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引更新某一条列表的数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）数据列表的索引
	 *
	 * `data` :JSON : 列表的数据源
	 */
	updateItem(params:zjListView_updateItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引向某一条列表插入数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）数据列表的索引
	 *
	 * `data` :JSON : 列表的数据源
	 */
	insertItem(params:zjListView_insertItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `向列表末端追加数据`
	 * ========params==========
	 *
	 * `data` :Array : 列表的数据源，**若不传或传空，仅收起上拉加载组件**
	 */
	appendData(params:zjListView_appendData_Params, callback?: (ret:JSON) => void):void

	/** 获取当前列表的总数据量*/ 
	getCount():void

	/**
	 * `设置下拉刷新，**通过 reloadData 收起下拉刷新组件**`
	 * ========params==========
	 *
	 * `loadingImg` :string : 下拉刷新时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）
	 *
	 * `bgColor` :string : （可选项）下拉刷新区域的背景色，支持 rgb、rgba、#
	 *
	 * `textColor` :string : （可选项）提示文字颜色，支持 rgb、rgba、#
	 *
	 * `textDown` :string : （可选项）下拉提示文字
	 *
	 * `textUp` :string : （可选项）松开提示文字
	 *
	 * `loadingText` :string : （可选项）提示文字
	 *
	 * `lastUpdateText` :string : （可选项）提示文字
	 *
	 * `showTime` :boolean : （可选项）是否显示刷新时间
	 */
	setRefreshHeader(params:zjListView_setRefreshHeader_Params):void

	/**
	 * `设置上拉加载，**通过 appendData 收起上拉加载组件**`
	 * ========params==========
	 *
	 * `loadingImg` :string : 上拉加载时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）
	 *
	 * `bgColor` :string : （可选项）上拉加载区域的背景色，支持 rgb、rgba、#
	 *
	 * `textColor` :string : （可选项）提示文字颜色，支持 rgb、rgba、#
	 *
	 * `textUp` :string : （可选项）上拉提示文字
	 *
	 * `textDown` :string : （可选项）松开提示文字
	 *
	 * `loadingText` :string : （可选项）提示文字
	 *
	 * `lastUpdateText` :string : （可选项）提示文字
	 *
	 * `showTime` :boolean : （可选项）是否显示刷新时间
	 */
	setRefreshFooter(params:zjListView_setRefreshFooter_Params):void

}
interface zjListView_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**列表的数据源，**开发者可以自定义唯一的键值对信息（如：uid: '1001'），供 getIndex 使用***/ 
	data:Array,

	/**（可选项）列表项向左滑动露出的按钮组，**建议：配置列表每项的通用按钮，用此参数；配置某一项的特定按钮，可在 `data` 数组的指定项传入 `rightBtns` 参数***/ 
	rightBtns?:Array,

	/**（可选项）是否开启弹动，android 平台不支持本参数*/ 
	bounces?:boolean,

	/**（可选项）模块各部分的样式*/ 
	styles?:string,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）是否显示滚动条*/ 
	showScrollBar?:boolean,

}

interface zjListView_toIndex_Params {
	/**（可选项）要定位到的cell序号，从0开始；如果传入数据大于列表总数则跳转到底部*/ 
	index?:number,

}

interface zjListView_setAttr_Params {
	/**（可选项）模块的纵坐标*/ 
	y?:number,

	/**（可选项）模块的高度*/ 
	h?:number,

}

interface zjListView_getIndex_Params {
	/**调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 key*/ 
	key:string,

	/**调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 value*/ 
	value:string,

}

interface zjListView_getDataByIndex_Params {
	/**（可选项）列表项的索引*/ 
	index?:number,

}

interface zjListView_setSwipeBtns_Params {
	/**（可选项）列表项的索引*/ 
	index?:number,

	/**（可选项）列表项侧滑露出的按钮组*/ 
	btns?:Array,

}

interface zjListView_reloadData_Params {
	/**（可选项）列表的数据源，**若不传或传空，仅收起下拉刷新组件***/ 
	data?:Array,

}

interface zjListView_deleteItem_Params {
	/**（可选项）数据列表的索引*/ 
	index?:number,

}

interface zjListView_updateItem_Params {
	/**（可选项）数据列表的索引*/ 
	index?:number,

	/**列表的数据源*/ 
	data:JSON,

}

interface zjListView_insertItem_Params {
	/**（可选项）数据列表的索引*/ 
	index?:number,

	/**列表的数据源*/ 
	data:JSON,

}

interface zjListView_appendData_Params {
	/**列表的数据源，**若不传或传空，仅收起上拉加载组件***/ 
	data:Array,

}

interface zjListView_setRefreshHeader_Params {
	/**下拉刷新时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）*/ 
	loadingImg:string,

	/**（可选项）下拉刷新区域的背景色，支持 rgb、rgba、#*/ 
	bgColor?:string,

	/**（可选项）提示文字颜色，支持 rgb、rgba、#*/ 
	textColor?:string,

	/**（可选项）下拉提示文字*/ 
	textDown?:string,

	/**（可选项）松开提示文字*/ 
	textUp?:string,

	/**（可选项）提示文字*/ 
	loadingText?:string,

	/**（可选项）提示文字*/ 
	lastUpdateText?:string,

	/**（可选项）是否显示刷新时间*/ 
	showTime?:boolean,

}

interface zjListView_setRefreshFooter_Params {
	/**上拉加载时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）*/ 
	loadingImg:string,

	/**（可选项）上拉加载区域的背景色，支持 rgb、rgba、#*/ 
	bgColor?:string,

	/**（可选项）提示文字颜色，支持 rgb、rgba、#*/ 
	textColor?:string,

	/**（可选项）上拉提示文字*/ 
	textUp?:string,

	/**（可选项）松开提示文字*/ 
	textDown?:string,

	/**（可选项）提示文字*/ 
	loadingText?:string,

	/**（可选项）提示文字*/ 
	lastUpdateText?:string,

	/**（可选项）是否显示刷新时间*/ 
	showTime?:boolean,

}

interface UISlider {
}
interface swipeCaptcha {
	/**
	 * `打开模块`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `styles` :JSON : 模块样式设置
	 *
	 * `imgPath` :string : 背景图片（支持 widget:// & fs:// & https:// 协议路径）
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）是否将模块视图固定到窗口上，不跟随窗口上下滚动
	 */
	open(params:swipeCaptcha_open_Params, callback?: (ret:JSON) => void):void

	/** 重新验证*/ 
	reset():void

	/** 关闭模块*/ 
	close():void

	/** 显示*/ 
	show():void

	/** 隐藏*/ 
	hide():void

}
interface swipeCaptcha_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**模块样式设置*/ 
	styles:JSON,

	/**背景图片（支持 widget:// & fs:// & https:// 协议路径）*/ 
	imgPath:string,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）是否将模块视图固定到窗口上，不跟随窗口上下滚动*/ 
	fixed?:boolean,

}

interface orderList {
}
interface dMultiScreen {
}
interface UILinkageSelector {
	/**
	 * `打开选择器`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸)
	 *
	 * `resource` :string : 城市列表的数据源文件路径（支持widget、fs 路径协议），数据源文件必须为`.json`文件。城市的JSON数据会在callback时按原格式返回。若为 json 文件则必须是标准的 [json格式](http://www.bejson.com)，否则会报错。
	 */
	open(params:UILinkageSelector_open_Params):void

	/** 确定事件*/ 
	confirm():void

	/** 隐藏选择器*/ 
	hide():void

	/** 显示选择器*/ 
	show():void

	/** 关闭选择器*/ 
	close():void

}
interface UILinkageSelector_open_Params {
	/**（可选项）模块的位置及尺寸)*/ 
	rect?:JSON,

	/**城市列表的数据源文件路径（支持widget、fs 路径协议），数据源文件必须为`.json`文件。城市的JSON数据会在callback时按原格式返回。若为 json 文件则必须是标准的 [json格式](http://www.bejson.com)，否则会报错。*/ 
	resource:string,

}

interface UIListUpload {
	/**
	 * `打开 UIListUpLoad 模块`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `data` :Array : 列表的数据源，**开发者可以自定义唯一的键值对信息（如：uid: '1001'），供 getIndex 使用**
	 *
	 * `rightBtns` :Array : （可选项）列表项向左滑动露出的按钮组，**建议：配置列表每项的通用按钮，用此参数；配置某一项的特定按钮，可在 `data` 数组的指定项传入 `rightBtns` 参数**
	 *
	 * `bounces` :boolean : （可选项）是否开启弹动，android 平台不支持本参数
	 *
	 * `styles` :string : （可选项）模块各部分的样式
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `showScrollBar` :boolean : （可选项）是否显示滚动条
	 */
	open(params:UIListUpload_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `更新header文本`
	 * ========params==========
	 *
	 * `text` :string : 需要更新的文本
	 */
	updateHeaderText(params:UIListUpload_updateHeaderText_Params):void

	/** 关闭数据列表模块*/ 
	close():void

	/** 显示 UIListView 模块*/ 
	show():void

	/** 隐藏 UIListView 模块*/ 
	hide():void

	/**
	 * `设置列表的纵坐标和高度`
	 * ========params==========
	 *
	 * `y` :number : （可选项）模块的纵坐标
	 *
	 * `h` :number : （可选项）模块的高度
	 */
	setAttr(params:UIListUpload_setAttr_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据开发者自定义的唯一标识（open 接口的 data 参数中自定义的唯一标识）查找列表项对应的数据`
	 * ========params==========
	 *
	 * `key` :string : 调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 key
	 *
	 * `value` :string : 调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 value
	 */
	getIndex(params:UIListUpload_getIndex_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据列表项的索引获取对应的数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）列表项的索引
	 */
	getDataByIndex(params:UIListUpload_getDataByIndex_Params, callback?: (ret:JSON) => void):void

	/**
	 * `设置侧滑显示出来的按钮`
	 * ========params==========
	 *
	 * `index` :number : （可选项）列表项的索引
	 *
	 * `btns` :Array : （可选项）列表项侧滑露出的按钮组
	 */
	setSwipeBtns(params:UIListUpload_setSwipeBtns_Params, callback?: (ret:JSON) => void):void

	/**
	 * `刷新列表数据`
	 * ========params==========
	 *
	 * `data` :Array : （可选项）列表的数据源，**若不传或传空，仅收起下拉刷新组件**
	 */
	reloadData(params:UIListUpload_reloadData_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引删除某一条列表的数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）数据列表的索引
	 */
	deleteItem(params:UIListUpload_deleteItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引更新某一条列表的数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）数据列表的索引
	 *
	 * `data` :JSON : 列表的数据源
	 */
	updateItem(params:UIListUpload_updateItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引向某一条列表插入数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）数据列表的索引
	 *
	 * `data` :JSON : 列表的数据源
	 */
	insertItem(params:UIListUpload_insertItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `向列表末端追加数据`
	 * ========params==========
	 *
	 * `data` :Array : 列表的数据源，**若不传或传空，仅收起上拉加载组件**
	 */
	appendData(params:UIListUpload_appendData_Params, callback?: (ret:JSON) => void):void

	/** 获取当前列表的总数据量*/ 
	getCount():void

	/**
	 * `设置下拉刷新，**通过 reloadData 收起下拉刷新组件**`
	 * ========params==========
	 *
	 * `style` :JSON : 下拉刷新的样式配置
	 */
	setRefreshHeader(params:UIListUpload_setRefreshHeader_Params):void

	/**
	 * `设置上拉加载，**通过 appendData 收起上拉加载组件**`
	 * ========params==========
	 *
	 * `loadingImg` :string : 上拉加载时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）
	 *
	 * `bgColor` :string : （可选项）上拉加载区域的背景色，支持 rgb、rgba、#
	 *
	 * `textColor` :string : （可选项）提示文字颜色，支持 rgb、rgba、#
	 *
	 * `textUp` :string : （可选项）上拉提示文字
	 *
	 * `textDown` :string : （可选项）松开提示文字
	 *
	 * `loadingText` :string : （可选项）提示文字
	 *
	 * `lastUpdateText` :string : （可选项）提示文字
	 *
	 * `showTime` :boolean : （可选项）是否显示刷新时间
	 */
	setRefreshFooter(params:UIListUpload_setRefreshFooter_Params):void

	/** 停止刷新(仅Android有效)*/ 
	stopRefresh():void

}
interface UIListUpload_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**列表的数据源，**开发者可以自定义唯一的键值对信息（如：uid: '1001'），供 getIndex 使用***/ 
	data:Array,

	/**（可选项）列表项向左滑动露出的按钮组，**建议：配置列表每项的通用按钮，用此参数；配置某一项的特定按钮，可在 `data` 数组的指定项传入 `rightBtns` 参数***/ 
	rightBtns?:Array,

	/**（可选项）是否开启弹动，android 平台不支持本参数*/ 
	bounces?:boolean,

	/**（可选项）模块各部分的样式*/ 
	styles?:string,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）是否显示滚动条*/ 
	showScrollBar?:boolean,

}

interface UIListUpload_updateHeaderText_Params {
	/**需要更新的文本*/ 
	text:string,

}

interface UIListUpload_setAttr_Params {
	/**（可选项）模块的纵坐标*/ 
	y?:number,

	/**（可选项）模块的高度*/ 
	h?:number,

}

interface UIListUpload_getIndex_Params {
	/**调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 key*/ 
	key:string,

	/**调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 value*/ 
	value:string,

}

interface UIListUpload_getDataByIndex_Params {
	/**（可选项）列表项的索引*/ 
	index?:number,

}

interface UIListUpload_setSwipeBtns_Params {
	/**（可选项）列表项的索引*/ 
	index?:number,

	/**（可选项）列表项侧滑露出的按钮组*/ 
	btns?:Array,

}

interface UIListUpload_reloadData_Params {
	/**（可选项）列表的数据源，**若不传或传空，仅收起下拉刷新组件***/ 
	data?:Array,

}

interface UIListUpload_deleteItem_Params {
	/**（可选项）数据列表的索引*/ 
	index?:number,

}

interface UIListUpload_updateItem_Params {
	/**（可选项）数据列表的索引*/ 
	index?:number,

	/**列表的数据源*/ 
	data:JSON,

}

interface UIListUpload_insertItem_Params {
	/**（可选项）数据列表的索引*/ 
	index?:number,

	/**列表的数据源*/ 
	data:JSON,

}

interface UIListUpload_appendData_Params {
	/**列表的数据源，**若不传或传空，仅收起上拉加载组件***/ 
	data:Array,

}

interface UIListUpload_setRefreshHeader_Params {
	/**下拉刷新的样式配置*/ 
	style:JSON,

}

interface UIListUpload_setRefreshFooter_Params {
	/**上拉加载时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）*/ 
	loadingImg:string,

	/**（可选项）上拉加载区域的背景色，支持 rgb、rgba、#*/ 
	bgColor?:string,

	/**（可选项）提示文字颜色，支持 rgb、rgba、#*/ 
	textColor?:string,

	/**（可选项）上拉提示文字*/ 
	textUp?:string,

	/**（可选项）松开提示文字*/ 
	textDown?:string,

	/**（可选项）提示文字*/ 
	loadingText?:string,

	/**（可选项）提示文字*/ 
	lastUpdateText?:string,

	/**（可选项）是否显示刷新时间*/ 
	showTime?:boolean,

}

interface UIMediaControl {
	/**
	 * `打开媒体控制控件`
	 * ========params==========
	 *
	 * `rect` :JSON : 预览控件位置
	 *
	 * `bgClolor` :string : 视图的背景颜色 ；（仅支持iOS）
	 *
	 * `leftBtnRect` :JSON : 上一曲按钮的位置和大小 ；（仅支持iOS）
	 *
	 * `rightBtnRect` :JSON : 下一曲按钮的位置和大小 ；（仅支持iOS）
	 *
	 * `playBtnRect` :JSON : 播放按钮的位置和大小 ；（仅支持iOS）
	 *
	 * `playBtnStatus` :boolean : 播放按钮的状态播放还是暂停 ；（仅支持iOS）
	 *
	 * `closeBtnRect` :JSON : 关闭按钮的位置和大小 ；（仅支持iOS）
	 *
	 * `leftBtnImagePath` :string : 上一曲按钮的背景图片路径；支持widget://和fs:// ；（仅支持iOS）
	 *
	 * `rightBtnImagePath` :string : 下一曲按钮的背景图片路径；支持widget://和fs:// ；（仅支持iOS）
	 *
	 * `playBtnImagePath` :string : 播放按钮（播放状态）的背景图片路径；支持widget://和fs:// ；（仅支持iOS）
	 *
	 * `pauseBtnImagePath` :string : 播放按钮（暂停状态）的背景图片路径；支持widget://和fs:// ；（仅支持iOS）
	 *
	 * `closeBtnImagePath` :string : 关闭的背景图片路径；支持widget://和fs:// ；（仅支持iOS）
	 *
	 * `slider` :JSON : 滑块参数设置 ；（仅支持iOS）
	 *
	 * `leftTimeLab` :JSON : 左边时间  ；（仅支持iOS）
	 *
	 * `rightTimeLab` :JSON : 右边时间 ；（仅支持iOS）
	 *
	 * `currentProgress` :number : （可选项）当前进度（秒）
	 *
	 * `total` :number : 总时长（秒）
	 *
	 * `isDrag` :boolean : 是否可以拖拽 ；（仅支持iOS）
	 *
	 * `bubleSize` :number : （可选项）滑块大小（仅android支持）
	 */
	openView(params:UIMediaControl_openView_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 关闭媒体控制控件*/ 
	closeView(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `更换播放状态`
	 * ========params==========
	 *
	 * `state` :string : 要切换为的状态
	 */
	changePlayState(params:UIMediaControl_changePlayState_Params):void

	/**
	 * `更换播放进度`
	 * ========params==========
	 *
	 * `currentProgress` :number : （可选项）当前进度（秒）
	 *
	 * `total` :number : （可选项）总时长（秒）
	 */
	updateProgress(params:UIMediaControl_updateProgress_Params):void

}
interface UIMediaControl_openView_Params {
	/**预览控件位置*/ 
	rect:JSON,

	/**视图的背景颜色 ；（仅支持iOS）*/ 
	bgClolor:string,

	/**上一曲按钮的位置和大小 ；（仅支持iOS）*/ 
	leftBtnRect:JSON,

	/**下一曲按钮的位置和大小 ；（仅支持iOS）*/ 
	rightBtnRect:JSON,

	/**播放按钮的位置和大小 ；（仅支持iOS）*/ 
	playBtnRect:JSON,

	/**播放按钮的状态播放还是暂停 ；（仅支持iOS）*/ 
	playBtnStatus:boolean,

	/**关闭按钮的位置和大小 ；（仅支持iOS）*/ 
	closeBtnRect:JSON,

	/**上一曲按钮的背景图片路径；支持widget://和fs:// ；（仅支持iOS）*/ 
	leftBtnImagePath:string,

	/**下一曲按钮的背景图片路径；支持widget://和fs:// ；（仅支持iOS）*/ 
	rightBtnImagePath:string,

	/**播放按钮（播放状态）的背景图片路径；支持widget://和fs:// ；（仅支持iOS）*/ 
	playBtnImagePath:string,

	/**播放按钮（暂停状态）的背景图片路径；支持widget://和fs:// ；（仅支持iOS）*/ 
	pauseBtnImagePath:string,

	/**关闭的背景图片路径；支持widget://和fs:// ；（仅支持iOS）*/ 
	closeBtnImagePath:string,

	/**滑块参数设置 ；（仅支持iOS）*/ 
	slider:JSON,

	/**左边时间  ；（仅支持iOS）*/ 
	leftTimeLab:JSON,

	/**右边时间 ；（仅支持iOS）*/ 
	rightTimeLab:JSON,

	/**（可选项）当前进度（秒）*/ 
	currentProgress?:number,

	/**总时长（秒）*/ 
	total:number,

	/**是否可以拖拽 ；（仅支持iOS）*/ 
	isDrag:boolean,

	/**（可选项）滑块大小（仅android支持）*/ 
	bubleSize?:number,

}

interface UIMediaControl_changePlayState_Params {
	/**要切换为的状态*/ 
	state:string,

}

interface UIMediaControl_updateProgress_Params {
	/**（可选项）当前进度（秒）*/ 
	currentProgress?:number,

	/**（可选项）总时长（秒）*/ 
	total?:number,

}

interface selectList {
}
interface applause {
	/**
	 * `显示鼓掌动画按钮`
	 * ========params==========
	 *
	 * `rect` :JSON : （必填项）鼓掌按钮的位置及尺寸
	 *
	 * `placeholderImg` :string : （必填项）鼓掌按钮图片路径（支持 fs://、widget://）。
	 *
	 * `iamges` :Array : （必填项）鼓掌后飘动的图形图片路径（支持 fs://、widget://）。
	 *
	 * `isShowNum` :boolean : （可选项）是否显示鼓掌的数量。
	 *
	 * `applauseNum` :number : （可选项）鼓掌的起始数。
	 *
	 * `fixedOn` :string : （可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window
	 *
	 * `fixed` :boolean : （（可选项）模块是否随所属 Window 或 Frame 滚动
	 */
	showAppLause(params:applause_showAppLause_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 点击鼓掌动画按钮*/ 
	clickAppLause(callback?: (ret:JSON, err:JSON) => void):void

}
interface applause_showAppLause_Params {
	/**（必填项）鼓掌按钮的位置及尺寸*/ 
	rect:JSON,

	/**（必填项）鼓掌按钮图片路径（支持 fs://、widget://）。*/ 
	placeholderImg:string,

	/**（必填项）鼓掌后飘动的图形图片路径（支持 fs://、widget://）。*/ 
	iamges:Array,

	/**（可选项）是否显示鼓掌的数量。*/ 
	isShowNum?:boolean,

	/**（可选项）鼓掌的起始数。*/ 
	applauseNum?:number,

	/**（可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window*/ 
	fixedOn?:string,

	/**（（可选项）模块是否随所属 Window 或 Frame 滚动*/ 
	fixed?:boolean,

}

interface UIPullRefreshFlash {
	/** 配置下拉刷新样式*/ 
	setCustomRefreshHeaderInfo():void

	/** 手动开始下拉刷新的加载状态，**下拉刷新状态亦可通过用户下拉到阈值自动触发***/ 
	refreshHeaderLoading():void

	/** 手动停止下拉刷新的加载状态*/ 
	refreshHeaderLoadDone():void

}
interface UIListArrow {
	/**
	 * `打开 UIListArrow 模块`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `data` :Array : 列表的数据源，**开发者可以自定义唯一的键值对信息（如：uid: '1001'），供 getIndex 使用**
	 *
	 * `rightBtns` :Array : （可选项）列表项向左滑动露出的按钮组，**建议：配置列表每项的通用按钮，用此参数；配置某一项的特定按钮，可在 `data` 数组的指定项传入 `rightBtns` 参数**
	 *
	 * `bounces` :boolean : （可选项）是否开启弹动，**android 平台暂不支持，且默认false**
	 *
	 * `styles` :string : （可选项）模块各部分的样式
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `showScrollBar` :boolean : （可选项）是否显示滚动条
	 */
	open(params:UIListArrow_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭数据列表模块*/ 
	close():void

	/** 显示 UIListBadge 模块*/ 
	show():void

	/** 隐藏 UIListBadge 模块*/ 
	hide():void

	/**
	 * `设置列表的纵坐标和高度`
	 * ========params==========
	 *
	 * `y` :number : （可选项）模块的纵坐标
	 *
	 * `h` :number : （可选项）模块的高度
	 */
	setAttr(params:UIListArrow_setAttr_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据开发者自定义的唯一标识（open 接口的 data 参数中自定义的唯一标识）查找列表项对应的数据`
	 * ========params==========
	 *
	 * `key` :string : 调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 key
	 *
	 * `value` :string : 调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 value
	 */
	getIndex(params:UIListArrow_getIndex_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据列表项的索引获取对应的数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）列表项的索引
	 */
	getDataByIndex(params:UIListArrow_getDataByIndex_Params, callback?: (ret:JSON) => void):void

	/**
	 * `设置侧滑显示出来的按钮`
	 * ========params==========
	 *
	 * `index` :number : （可选项）列表项的索引
	 *
	 * `btns` :Array : （可选项）列表项侧滑露出的按钮组
	 */
	setSwipeBtns(params:UIListArrow_setSwipeBtns_Params, callback?: (ret:JSON) => void):void

	/**
	 * `刷新列表数据`
	 * ========params==========
	 *
	 * `data` :Array : （可选项）列表的数据源，**若不传或传空，仅收起下拉刷新组件**
	 */
	reloadData(params:UIListArrow_reloadData_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引删除某一条列表的数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）数据列表的索引
	 */
	deleteItem(params:UIListArrow_deleteItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引更新某一条列表的数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）数据列表的索引
	 *
	 * `data` :JSON : 列表的数据源
	 */
	updateItem(params:UIListArrow_updateItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引向某一条列表插入数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）数据列表的索引
	 *
	 * `data` :JSON : 列表的数据源
	 */
	insertItem(params:UIListArrow_insertItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `向列表末端追加数据`
	 * ========params==========
	 *
	 * `data` :Array : 列表的数据源，**若不传或传空，仅收起上拉加载组件**
	 */
	appendData(params:UIListArrow_appendData_Params, callback?: (ret:JSON) => void):void

	/** 获取当前列表的总数据量*/ 
	getCount():void

	/**
	 * `设置下拉刷新，**通过 reloadData 收起下拉刷新组件**`
	 * ========params==========
	 *
	 * `style` :JSON : 下拉刷新的样式配置
	 */
	setRefreshHeader(params:UIListArrow_setRefreshHeader_Params):void

	/**
	 * `设置上拉加载，**通过 appendData 收起上拉加载组件**`
	 * ========params==========
	 *
	 * `loadingImg` :string : 上拉加载时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）
	 *
	 * `bgColor` :string : （可选项）上拉加载区域的背景色，支持 rgb、rgba、#
	 *
	 * `textColor` :string : （可选项）提示文字颜色，支持 rgb、rgba、#
	 *
	 * `textUp` :string : （可选项）上拉提示文字
	 *
	 * `textDown` :string : （可选项）松开提示文字
	 *
	 * `loadingText` :string : （可选项）提示文字
	 *
	 * `lastUpdateText` :string : （可选项）提示文字
	 *
	 * `showTime` :boolean : （可选项）是否显示刷新时间
	 */
	setRefreshFooter(params:UIListArrow_setRefreshFooter_Params):void

}
interface UIListArrow_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**列表的数据源，**开发者可以自定义唯一的键值对信息（如：uid: '1001'），供 getIndex 使用***/ 
	data:Array,

	/**（可选项）列表项向左滑动露出的按钮组，**建议：配置列表每项的通用按钮，用此参数；配置某一项的特定按钮，可在 `data` 数组的指定项传入 `rightBtns` 参数***/ 
	rightBtns?:Array,

	/**（可选项）是否开启弹动，**android 平台暂不支持，且默认false***/ 
	bounces?:boolean,

	/**（可选项）模块各部分的样式*/ 
	styles?:string,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）是否显示滚动条*/ 
	showScrollBar?:boolean,

}

interface UIListArrow_setAttr_Params {
	/**（可选项）模块的纵坐标*/ 
	y?:number,

	/**（可选项）模块的高度*/ 
	h?:number,

}

interface UIListArrow_getIndex_Params {
	/**调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 key*/ 
	key:string,

	/**调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 value*/ 
	value:string,

}

interface UIListArrow_getDataByIndex_Params {
	/**（可选项）列表项的索引*/ 
	index?:number,

}

interface UIListArrow_setSwipeBtns_Params {
	/**（可选项）列表项的索引*/ 
	index?:number,

	/**（可选项）列表项侧滑露出的按钮组*/ 
	btns?:Array,

}

interface UIListArrow_reloadData_Params {
	/**（可选项）列表的数据源，**若不传或传空，仅收起下拉刷新组件***/ 
	data?:Array,

}

interface UIListArrow_deleteItem_Params {
	/**（可选项）数据列表的索引*/ 
	index?:number,

}

interface UIListArrow_updateItem_Params {
	/**（可选项）数据列表的索引*/ 
	index?:number,

	/**列表的数据源*/ 
	data:JSON,

}

interface UIListArrow_insertItem_Params {
	/**（可选项）数据列表的索引*/ 
	index?:number,

	/**列表的数据源*/ 
	data:JSON,

}

interface UIListArrow_appendData_Params {
	/**列表的数据源，**若不传或传空，仅收起上拉加载组件***/ 
	data:Array,

}

interface UIListArrow_setRefreshHeader_Params {
	/**下拉刷新的样式配置*/ 
	style:JSON,

}

interface UIListArrow_setRefreshFooter_Params {
	/**上拉加载时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）*/ 
	loadingImg:string,

	/**（可选项）上拉加载区域的背景色，支持 rgb、rgba、#*/ 
	bgColor?:string,

	/**（可选项）提示文字颜色，支持 rgb、rgba、#*/ 
	textColor?:string,

	/**（可选项）上拉提示文字*/ 
	textUp?:string,

	/**（可选项）松开提示文字*/ 
	textDown?:string,

	/**（可选项）提示文字*/ 
	loadingText?:string,

	/**（可选项）提示文字*/ 
	lastUpdateText?:string,

	/**（可选项）是否显示刷新时间*/ 
	showTime?:boolean,

}

interface waveProgress {
	/**
	 * `显示波纹进度UI`
	 * ========params==========
	 *
	 * `fixedOn` :string : 将视图添加到指定的frame上面,非必填
	 *
	 * `fixed` :string : 提供fixed参数，控制视图是否随着frame内容的移动而跟着移动,非必填
	 *
	 * `r` :number : 半径,非必填
	 *
	 * `centerX` :number : 圆心X轴坐标,非必填
	 *
	 * `centerY` :number : 圆心Y轴坐标,非必填
	 *
	 * `speed` :any : 波纹流动速度,浮点型，非必填
	 *
	 * `progress` :number : 波纹进度值，非必填
	 *
	 * `firstFillColor` :string : 前填充色
	 *
	 * `secondFillColor` :string : 海浪波纹填充色
	 */
	showWave(params:waveProgress_showWave_Params):void

	/** 关闭波型UI*/ 
	closeWave():void

	/** 显示已隐藏的波型UI*/ 
	show():void

	/** 隐藏波型UI*/ 
	hide():void

	/**
	 * `设置波型UI进度值`
	 * ========params==========
	 *
	 * `progress` :number : 波纹进度值，非必填
	 */
	setProgress(params:waveProgress_setProgress_Params):void

}
interface waveProgress_showWave_Params {
	/**将视图添加到指定的frame上面,非必填*/ 
	fixedOn:string,

	/**提供fixed参数，控制视图是否随着frame内容的移动而跟着移动,非必填*/ 
	fixed:string,

	/**半径,非必填*/ 
	r:number,

	/**圆心X轴坐标,非必填*/ 
	centerX:number,

	/**圆心Y轴坐标,非必填*/ 
	centerY:number,

	/**波纹流动速度,浮点型，非必填*/ 
	speed:any,

	/**波纹进度值，非必填*/ 
	progress:number,

	/**前填充色*/ 
	firstFillColor:string,

	/**海浪波纹填充色*/ 
	secondFillColor:string,

}

interface waveProgress_setProgress_Params {
	/**波纹进度值，非必填*/ 
	progress:number,

}

interface messageList {
}
interface UISearchBar {
	/**
	 * `打开搜索页面`
	 * ========params==========
	 *
	 * `placeholder` :string : （可选项）搜索框的占位提示文本
	 *
	 * `historyCount` :number : （可选项）历史记录条数
	 *
	 * `dataBase` :string : （可选项）历史记录存储库名，以区分同一个 app 多个不同页面的数据
	 *
	 * `showRecordBtn` :boolean : （可选项）是否显示录音按钮
	 *
	 * `texts` :JSON : （可选项）模块各部分的文本
	 *
	 * `styles` :JSON : （可选项）模块各部分的样式
	 */
	open(params:UISearchBar_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭搜索页面*/ 
	close():void

	/**
	 * `设置搜索框的文字`
	 * ========params==========
	 *
	 * `text` :string : （可选项）搜索框内的文字，若不传或传空则清空搜索框内容
	 */
	setText(params:UISearchBar_setText_Params):void

	/** 清空当前搜索历史记录*/ 
	clearHistory():void

}
interface UISearchBar_open_Params {
	/**（可选项）搜索框的占位提示文本*/ 
	placeholder?:string,

	/**（可选项）历史记录条数*/ 
	historyCount?:number,

	/**（可选项）历史记录存储库名，以区分同一个 app 多个不同页面的数据*/ 
	dataBase?:string,

	/**（可选项）是否显示录音按钮*/ 
	showRecordBtn?:boolean,

	/**（可选项）模块各部分的文本*/ 
	texts?:JSON,

	/**（可选项）模块各部分的样式*/ 
	styles?:JSON,

}

interface UISearchBar_setText_Params {
	/**（可选项）搜索框内的文字，若不传或传空则清空搜索框内容*/ 
	text?:string,

}

interface overviewList {
}
interface sliderButton {
	/** 监听滑动到右边的事件*/ 
	addEventListener():void

	/**
	 * `打开滑动按钮`
	 * ========params==========
	 *
	 * `rect` :JSON : （必填项）模块的位置及尺寸
	 *
	 * `fixedOn` :string : （可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window
	 *
	 * `fixed` :boolean : （（可选项）模块是否随所属 Window 或 Frame 滚动
	 *
	 * `labelText` :string : （可选项）滑块上的文字。
	 *
	 * `labelFontSize` :number : （可选项）滑块上的文字字体大小。
	 *
	 * `labelTextColor` :string : （可选项）滑块上的文字颜色。
	 *
	 * `borderColor` :string : （可选项）滑块边框颜色。
	 *
	 * `dotColor` :string : （可选项）滑块上面的圆形按钮颜色。
	 *
	 * `skateColor` :string : （可选项）滑块按钮背景色。
	 */
	openSlideBtn(params:sliderButton_openSlideBtn_Params, callback?: (ret:JSON) => void):void

	/** 隐藏滑动按钮*/ 
	hideSlideBtn(callback?: (ret:JSON, err:JSON) => void):void

	/** 显示滑块按钮*/ 
	showSlideBtn(callback?: (ret:JSON, err:JSON) => void):void

	/** 关闭滑块按钮*/ 
	closeSlideBtn(callback?: (ret:JSON, err:JSON) => void):void

}
interface sliderButton_openSlideBtn_Params {
	/**（必填项）模块的位置及尺寸*/ 
	rect:JSON,

	/**（可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window*/ 
	fixedOn?:string,

	/**（（可选项）模块是否随所属 Window 或 Frame 滚动*/ 
	fixed?:boolean,

	/**（可选项）滑块上的文字。*/ 
	labelText?:string,

	/**（可选项）滑块上的文字字体大小。*/ 
	labelFontSize?:number,

	/**（可选项）滑块上的文字颜色。*/ 
	labelTextColor?:string,

	/**（可选项）滑块边框颜色。*/ 
	borderColor?:string,

	/**（可选项）滑块上面的圆形按钮颜色。*/ 
	dotColor?:string,

	/**（可选项）滑块按钮背景色。*/ 
	skateColor?:string,

}

interface floatButton {
	/** 悬浮按钮点击事件监听*/ 
	setOnClickListener():void

	/**
	 * `打开悬浮按钮`
	 * ========params==========
	 *
	 * `rect` :JSON : （必填项）模块的位置及尺寸
	 *
	 * `lineColor` :string : 悬浮按钮边框颜色(如：#ff00ff)
	 *
	 * `btnPic` :string : （可选项）悬浮按钮图标。支持fs:// widget://(支持png,jpg,gif,[备注：安卓设置gif动图时lineColor会失效])
	 *
	 * `isRound` :boolean : 按钮是否进行圆形处理(true:圆形处理 false:不进行圆形处理)
	 */
	openButton(params:floatButton_openButton_Params, callback?: (ret:JSON) => void):void

	/** 隐藏悬浮按钮*/ 
	hidenButton():void

	/** 显示悬浮按钮*/ 
	showButton():void

	/** 关闭悬浮按钮*/ 
	closeButton():void

	/**
	 * `修改悬浮按钮图片`
	 * ========params==========
	 *
	 * `btnPic` :string : （可选项）悬浮按钮图标。支持fs:// widget://(支持png,jpg,gif,[备注：安卓设置gif动图时lineColor会失效])
	 */
	updateButtonPic(params:floatButton_updateButtonPic_Params, callback?: (ret:JSON) => void):void

	/** 开启旋转动画*/ 
	startAnimation():void

	/** 停止旋转动画*/ 
	stopAnimation():void

	/** 开启移动*/ 
	startMove():void

	/** 停止移动*/ 
	stopMove():void

	/** 停止移动*/ 
	stopMove():void

}
interface floatButton_openButton_Params {
	/**（必填项）模块的位置及尺寸*/ 
	rect:JSON,

	/**悬浮按钮边框颜色(如：#ff00ff)*/ 
	lineColor:string,

	/**（可选项）悬浮按钮图标。支持fs:// widget://(支持png,jpg,gif,[备注：安卓设置gif动图时lineColor会失效])*/ 
	btnPic?:string,

	/**按钮是否进行圆形处理(true:圆形处理 false:不进行圆形处理)*/ 
	isRound:boolean,

}

interface floatButton_updateButtonPic_Params {
	/**（可选项）悬浮按钮图标。支持fs:// widget://(支持png,jpg,gif,[备注：安卓设置gif动图时lineColor会失效])*/ 
	btnPic?:string,

}

interface mtlOpenFile {
	/** 打开本地文件*/ 
	openLocalFile():void

}
interface UISliderButton {
	/**
	 * `打开滑动解锁页面`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `text` :string : （可选项）滑块文字
	 *
	 * `styles` :JSON : （可选项）模块各部分的样式
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）是否将模块视图固定到窗口上（不跟随窗口上下滚动）
	 */
	open(params:UISliderButton_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭滑动解锁页面*/ 
	close():void

	/** 隐藏滑动解锁页面*/ 
	hide():void

	/** 显示滑动解锁页面*/ 
	show():void

}
interface UISliderButton_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**（可选项）滑块文字*/ 
	text?:string,

	/**（可选项）模块各部分的样式*/ 
	styles?:JSON,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）是否将模块视图固定到窗口上（不跟随窗口上下滚动）*/ 
	fixed?:boolean,

}

interface arcProgress {
}
interface lineChart {
}
interface sunmiT2Screen {
	/** 初始化副屏*/ 
	screenInit(callback?: (ret:JSON) => void):void

	/** 显示欢迎*/ 
	showWelcome(callback?: (ret:JSON) => void):void

	/**
	 * `显示文本`
	 * ========params==========
	 *
	 * `title` :null : null
	 *
	 * `content` :string : （必填项）显示数据
	 */
	showText(params:sunmiT2Screen_showText_Params, callback?: (ret:JSON) => void):void

	/**
	 * `显示清单`
	 * ========params==========
	 *
	 * `json` :JSON : （必填项）显示数据
	 */
	showMenu(params:sunmiT2Screen_showMenu_Params, callback?: (ret:JSON) => void):void

	/**
	 * `显示图片`
	 * ========params==========
	 *
	 * `img` :string : （必填项）显示数据
	 */
	showImg(params:sunmiT2Screen_showImg_Params, callback?: (ret:JSON) => void):void

	/**
	 * `显示轮播图片`
	 * ========params==========
	 *
	 * `imgs` :Array : （必填项）显示数据
	 */
	showImgs(params:sunmiT2Screen_showImgs_Params, callback?: (ret:JSON) => void):void

	/**
	 * `显示单个视频`
	 * ========params==========
	 *
	 * `PathVideo` :string : （必填项）显示数据
	 */
	showVideo(params:sunmiT2Screen_showVideo_Params, callback?: (ret:JSON) => void):void

	/** 显示轮播视频*/ 
	showVideos(callback?: (ret:JSON) => void):void

	/**
	 * `显示单个图片清单`
	 * ========params==========
	 *
	 * `json` :null : null
	 *
	 * `img` :string : （必填项）显示数据
	 */
	imageLists(params:sunmiT2Screen_imageLists_Params, callback?: (ret:JSON) => void):void

	/**
	 * `显示单个视频清单`
	 * ========params==========
	 *
	 * `json` :null : null
	 *
	 * `video` :string : （必填项）显示数据
	 */
	videoLists(params:sunmiT2Screen_videoLists_Params, callback?: (ret:JSON) => void):void

	/**
	 * `显示轮播图清单`
	 * ========params==========
	 *
	 * `json` :null : null
	 *
	 * `imgs` :Array : （必填项）显示数据
	 */
	imagesLists(params:sunmiT2Screen_imagesLists_Params, callback?: (ret:JSON) => void):void

	/** 显示轮播视频清单*/ 
	videosLists(callback?: (ret:JSON) => void):void

	/** 退出副屏*/ 
	exitScreen(callback?: (ret:JSON) => void):void

	/** 清除缓存*/ 
	cachefile(callback?: (ret:JSON) => void):void

}
interface sunmiT2Screen_showText_Params {
	/**null*/ 
	title:null,

	/**（必填项）显示数据*/ 
	content:string,

}

interface sunmiT2Screen_showMenu_Params {
	/**（必填项）显示数据*/ 
	json:JSON,

}

interface sunmiT2Screen_showImg_Params {
	/**（必填项）显示数据*/ 
	img:string,

}

interface sunmiT2Screen_showImgs_Params {
	/**（必填项）显示数据*/ 
	imgs:Array,

}

interface sunmiT2Screen_showVideo_Params {
	/**（必填项）显示数据*/ 
	PathVideo:string,

}

interface sunmiT2Screen_imageLists_Params {
	/**null*/ 
	json:null,

	/**（必填项）显示数据*/ 
	img:string,

}

interface sunmiT2Screen_videoLists_Params {
	/**null*/ 
	json:null,

	/**（必填项）显示数据*/ 
	video:string,

}

interface sunmiT2Screen_imagesLists_Params {
	/**null*/ 
	json:null,

	/**（必填项）显示数据*/ 
	imgs:Array,

}

interface goodsList {
}
interface licencePlatekeyboard {
	/** 打开*/ 
	open():void

	/** 关闭*/ 
	close():void

	/** 显示*/ 
	show():void

	/** 隐藏*/ 
	hide():void

	/** 更换键盘类型*/ 
	changeType():void

}
interface listView {
}
interface fluttering {
	/**
	 * `配置飘动动画`
	 * ========params==========
	 *
	 * `original` :JSON : 图标飘动动画的起点位置坐标
	 *
	 * `terminal` :JSON : 图标飘动动画的终点位置坐标
	 *
	 * `duration` :number : （可选项）飘屏动画的持续时间，单位：秒（s）
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 */
	config(params:fluttering_config_Params, callback?: (ret:JSON) => void):void

	/**
	 * `开始飘动（飘动的动画路径随机产生）`
	 * ========params==========
	 *
	 * `size` :number : （可选项）本次飘动的图标的大小
	 *
	 * `path` :string : （可选项）本次飘动图片的路径，支持本地路径（fs://、widget://）
	 */
	flutter(params:fluttering_flutter_Params):void

}
interface fluttering_config_Params {
	/**图标飘动动画的起点位置坐标*/ 
	original:JSON,

	/**图标飘动动画的终点位置坐标*/ 
	terminal:JSON,

	/**（可选项）飘屏动画的持续时间，单位：秒（s）*/ 
	duration?:number,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

}

interface fluttering_flutter_Params {
	/**（可选项）本次飘动的图标的大小*/ 
	size?:number,

	/**（可选项）本次飘动图片的路径，支持本地路径（fs://、widget://）*/ 
	path?:string,

}

interface fillInput {
	/**
	 * `打开输入框，**注意：调用 open 接口的元素，不能加 tapmode 属性**`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `styles` :JSON : （可选项）模块各部分的样式
	 *
	 * `passwordOrCode` :any : （可选项）自动填充密码或者验证码
	 *
	 * `maxRows` :number : （可选项）支持显示最大行数，文本内容超过此行数时，上下滚动显示。是否支持换行，传大于1的数时表示支持，**注意：取值大于1（多行显示时），不触发 search 事件回调**
	 *
	 * `maxStringLength` :number : （可选项）输入框允许输入的最大字符串长度
	 *
	 * `autoFocus` :boolean : （可选项）打开时是否弹出键盘
	 *
	 * `placeholder` :string : （可选项）输入框的占位提示文本
	 *
	 * `keyboardType` :string : （可选项）输入框获取焦点时，弹出的键盘类型；
	 *
	 * `alignment` :string : （可选项）文本对齐方式
	 *
	 * `isCenterVertical` :boolean : 输入文本是否上下居中
	 *
	 * `inputType` :string : (可选项) 判断输入框输入的是密码还是文字
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	open(params:fillInput_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `重设输入框的位置`
	 * ========params==========
	 *
	 * `id` :number : 需要设置的输入框id
	 *
	 * `position` :JSON : （可选项）模块的位置
	 */
	resetPosition(params:fillInput_resetPosition_Params):void

	/** 关闭输入框*/ 
	close():void

	/** 显示输入框*/ 
	show():void

	/** 隐藏输入框*/ 
	hide():void

	/**
	 * `获取或设置输入框的内容`
	 * ========params==========
	 *
	 * `id` :number : 输入框id
	 *
	 * `msg` :string : （可选项）输入框的内容，若不传则返回输入框的值
	 */
	value(params:fillInput_value_Params, callback?: (ret:JSON) => void):void

	/**
	 * `向输入框的指定位置插入内容`
	 * ========params==========
	 *
	 * `id` :number : 输入框id
	 *
	 * `index` :number : （可选项）插入内容的起始位置。**注意：中文，全角符号均占一个字符长度；索引从0开始，0表示插入到最前面，1表示插入到第一个字符后面，2表示插入到第二个字符后面，以此类推。**
	 *
	 * `msg` :string : （可选项）要插入的内容
	 */
	insertValue(params:fillInput_insertValue_Params):void

	/** 弹出键盘*/ 
	popupKeyboard():void

	/** 收起键盘*/ 
	closeKeyboard():void

	/**
	 * `事件监听`
	 * ========params==========
	 *
	 * `id` :number : 输入框id
	 *
	 * `name` :string : 监听的事件类型
	 */
	addEventListener(params:fillInput_addEventListener_Params, callback?: (ret:JSON) => void):void

	/**
	 * `获取当前光标所在位置`
	 * ========params==========
	 *
	 * `id` :number : 输入框id
	 */
	getSelectedRange(params:fillInput_getSelectedRange_Params, callback?: (ret:JSON) => void):void

}
interface fillInput_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**（可选项）模块各部分的样式*/ 
	styles?:JSON,

	/**（可选项）自动填充密码或者验证码*/ 
	passwordOrCode?:any,

	/**（可选项）支持显示最大行数，文本内容超过此行数时，上下滚动显示。是否支持换行，传大于1的数时表示支持，**注意：取值大于1（多行显示时），不触发 search 事件回调***/ 
	maxRows?:number,

	/**（可选项）输入框允许输入的最大字符串长度*/ 
	maxStringLength?:number,

	/**（可选项）打开时是否弹出键盘*/ 
	autoFocus?:boolean,

	/**（可选项）输入框的占位提示文本*/ 
	placeholder?:string,

	/**（可选项）输入框获取焦点时，弹出的键盘类型；*/ 
	keyboardType?:string,

	/**（可选项）文本对齐方式*/ 
	alignment?:string,

	/**输入文本是否上下居中*/ 
	isCenterVertical:boolean,

	/**(可选项) 判断输入框输入的是密码还是文字*/ 
	inputType?:string,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface fillInput_resetPosition_Params {
	/**需要设置的输入框id*/ 
	id:number,

	/**（可选项）模块的位置*/ 
	position?:JSON,

}

interface fillInput_value_Params {
	/**输入框id*/ 
	id:number,

	/**（可选项）输入框的内容，若不传则返回输入框的值*/ 
	msg?:string,

}

interface fillInput_insertValue_Params {
	/**输入框id*/ 
	id:number,

	/**（可选项）插入内容的起始位置。**注意：中文，全角符号均占一个字符长度；索引从0开始，0表示插入到最前面，1表示插入到第一个字符后面，2表示插入到第二个字符后面，以此类推。***/ 
	index?:number,

	/**（可选项）要插入的内容*/ 
	msg?:string,

}

interface fillInput_addEventListener_Params {
	/**输入框id*/ 
	id:number,

	/**监听的事件类型*/ 
	name:string,

}

interface fillInput_getSelectedRange_Params {
	/**输入框id*/ 
	id:number,

}

interface UIListBadge {
	/**
	 * `打开 UIListBadge 模块`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `data` :Array : 列表的数据源，**开发者可以自定义唯一的键值对信息（如：uid: '1001'），供 getIndex 使用**
	 *
	 * `rightBtns` :Array : （可选项）列表项向左滑动露出的按钮组，**建议：配置列表每项的通用按钮，用此参数；配置某一项的特定按钮，可在 `data` 数组的指定项传入 `rightBtns` 参数**
	 *
	 * `bounces` :boolean : （可选项）是否开启弹动，**android 平台暂不支持，且默认false**
	 *
	 * `styles` :string : （可选项）模块各部分的样式
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `showScrollBar` :boolean : （可选项）是否显示滚动条
	 */
	open(params:UIListBadge_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭数据列表模块*/ 
	close():void

	/** 显示 UIListBadge 模块*/ 
	show():void

	/** 隐藏 UIListBadge 模块*/ 
	hide():void

	/**
	 * `设置列表的纵坐标和高度`
	 * ========params==========
	 *
	 * `y` :number : （可选项）模块的纵坐标
	 *
	 * `h` :number : （可选项）模块的高度
	 */
	setAttr(params:UIListBadge_setAttr_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据开发者自定义的唯一标识（open 接口的 data 参数中自定义的唯一标识）查找列表项对应的数据`
	 * ========params==========
	 *
	 * `key` :string : 调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 key
	 *
	 * `value` :string : 调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 value
	 */
	getIndex(params:UIListBadge_getIndex_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据列表项的索引获取对应的数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）列表项的索引
	 */
	getDataByIndex(params:UIListBadge_getDataByIndex_Params, callback?: (ret:JSON) => void):void

	/**
	 * `设置侧滑显示出来的按钮`
	 * ========params==========
	 *
	 * `index` :number : （可选项）列表项的索引
	 *
	 * `btns` :Array : （可选项）列表项侧滑露出的按钮组
	 */
	setSwipeBtns(params:UIListBadge_setSwipeBtns_Params, callback?: (ret:JSON) => void):void

	/**
	 * `刷新列表数据`
	 * ========params==========
	 *
	 * `data` :Array : （可选项）列表的数据源，**若不传或传空，仅收起下拉刷新组件**
	 */
	reloadData(params:UIListBadge_reloadData_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引删除某一条列表的数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）数据列表的索引
	 */
	deleteItem(params:UIListBadge_deleteItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引更新某一条列表的数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）数据列表的索引
	 *
	 * `data` :JSON : 列表的数据源
	 */
	updateItem(params:UIListBadge_updateItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引向某一条列表插入数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）数据列表的索引
	 *
	 * `data` :JSON : 列表的数据源
	 */
	insertItem(params:UIListBadge_insertItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `向列表末端追加数据`
	 * ========params==========
	 *
	 * `data` :Array : 列表的数据源，**若不传或传空，仅收起上拉加载组件**
	 */
	appendData(params:UIListBadge_appendData_Params, callback?: (ret:JSON) => void):void

	/** 获取当前列表的总数据量*/ 
	getCount():void

	/**
	 * `设置下拉刷新，**通过 reloadData 收起下拉刷新组件**`
	 * ========params==========
	 *
	 * `style` :JSON : 下拉刷新的样式配置
	 */
	setRefreshHeader(params:UIListBadge_setRefreshHeader_Params):void

	/**
	 * `设置上拉加载，**通过 appendData 收起上拉加载组件**`
	 * ========params==========
	 *
	 * `loadingImg` :string : 上拉加载时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）
	 *
	 * `bgColor` :string : （可选项）上拉加载区域的背景色，支持 rgb、rgba、#
	 *
	 * `textColor` :string : （可选项）提示文字颜色，支持 rgb、rgba、#
	 *
	 * `textUp` :string : （可选项）上拉提示文字
	 *
	 * `textDown` :string : （可选项）松开提示文字
	 *
	 * `loadingText` :string : （可选项）提示文字
	 *
	 * `lastUpdateText` :string : （可选项）提示文字
	 *
	 * `showTime` :boolean : （可选项）是否显示刷新时间
	 */
	setRefreshFooter(params:UIListBadge_setRefreshFooter_Params):void

}
interface UIListBadge_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**列表的数据源，**开发者可以自定义唯一的键值对信息（如：uid: '1001'），供 getIndex 使用***/ 
	data:Array,

	/**（可选项）列表项向左滑动露出的按钮组，**建议：配置列表每项的通用按钮，用此参数；配置某一项的特定按钮，可在 `data` 数组的指定项传入 `rightBtns` 参数***/ 
	rightBtns?:Array,

	/**（可选项）是否开启弹动，**android 平台暂不支持，且默认false***/ 
	bounces?:boolean,

	/**（可选项）模块各部分的样式*/ 
	styles?:string,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）是否显示滚动条*/ 
	showScrollBar?:boolean,

}

interface UIListBadge_setAttr_Params {
	/**（可选项）模块的纵坐标*/ 
	y?:number,

	/**（可选项）模块的高度*/ 
	h?:number,

}

interface UIListBadge_getIndex_Params {
	/**调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 key*/ 
	key:string,

	/**调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 value*/ 
	value:string,

}

interface UIListBadge_getDataByIndex_Params {
	/**（可选项）列表项的索引*/ 
	index?:number,

}

interface UIListBadge_setSwipeBtns_Params {
	/**（可选项）列表项的索引*/ 
	index?:number,

	/**（可选项）列表项侧滑露出的按钮组*/ 
	btns?:Array,

}

interface UIListBadge_reloadData_Params {
	/**（可选项）列表的数据源，**若不传或传空，仅收起下拉刷新组件***/ 
	data?:Array,

}

interface UIListBadge_deleteItem_Params {
	/**（可选项）数据列表的索引*/ 
	index?:number,

}

interface UIListBadge_updateItem_Params {
	/**（可选项）数据列表的索引*/ 
	index?:number,

	/**列表的数据源*/ 
	data:JSON,

}

interface UIListBadge_insertItem_Params {
	/**（可选项）数据列表的索引*/ 
	index?:number,

	/**列表的数据源*/ 
	data:JSON,

}

interface UIListBadge_appendData_Params {
	/**列表的数据源，**若不传或传空，仅收起上拉加载组件***/ 
	data:Array,

}

interface UIListBadge_setRefreshHeader_Params {
	/**下拉刷新的样式配置*/ 
	style:JSON,

}

interface UIListBadge_setRefreshFooter_Params {
	/**上拉加载时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）*/ 
	loadingImg:string,

	/**（可选项）上拉加载区域的背景色，支持 rgb、rgba、#*/ 
	bgColor?:string,

	/**（可选项）提示文字颜色，支持 rgb、rgba、#*/ 
	textColor?:string,

	/**（可选项）上拉提示文字*/ 
	textUp?:string,

	/**（可选项）松开提示文字*/ 
	textDown?:string,

	/**（可选项）提示文字*/ 
	loadingText?:string,

	/**（可选项）提示文字*/ 
	lastUpdateText?:string,

	/**（可选项）是否显示刷新时间*/ 
	showTime?:boolean,

}

interface UIBarChart {
	/**
	 * `打开柱状图视图`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `yAxis` :JSON : 柱状图的y轴信息
	 *
	 * `data` :Array : 柱状图关键结点的数据
	 *
	 * `text` :JSON : （可选项）X、Y轴说明文字配置
	 *
	 * `styles` :any : （可选项）模块视图内元素样式设置
	 *
	 * `showData` :boolean : （可选项）点击柱状图，是否显示该条目数据
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	open(params:UIBarChart_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `重新加载数据`
	 * ========params==========
	 *
	 * `id` :number : 模块的 id，用于区分模块的多个实例
	 *
	 * `type` :string : 更新数据的方式
	 *
	 * `data` :Array : 要更新的数据
	 */
	reloadData(params:UIBarChart_reloadData_Params, callback?: (ret:JSON) => void):void

	/**
	 * `关闭柱状图`
	 * ========params==========
	 *
	 * `id` :number : 模块的 id，用于区分模块的多个实例
	 */
	close(params:UIBarChart_close_Params):void

	/**
	 * `隐藏柱状图视图`
	 * ========params==========
	 *
	 * `id` :number : 模块的 id，用于区分模块的多个实例
	 */
	hide(params:UIBarChart_hide_Params):void

	/**
	 * `显示已隐藏的柱状图视图`
	 * ========params==========
	 *
	 * `id` :number : 模块的 id，用于区分模块的多个实例
	 */
	show(params:UIBarChart_show_Params):void

	/**
	 * `滚动到指定索引的条目，`
	 * ========params==========
	 *
	 * `id` :number : 模块的 id，用于区分模块的多个实例
	 *
	 * `index` :number : （可选项）指定的条目的索引，不可大于总条目数减去每屏显示个数，从0开始
	 *
	 * `animation` :boolean : （可选项）滚动时是否带有动画效果
	 */
	scrollTo(params:UIBarChart_scrollTo_Params):void

}
interface UIBarChart_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**柱状图的y轴信息*/ 
	yAxis:JSON,

	/**柱状图关键结点的数据*/ 
	data:Array,

	/**（可选项）X、Y轴说明文字配置*/ 
	text?:JSON,

	/**（可选项）模块视图内元素样式设置*/ 
	styles?:any,

	/**（可选项）点击柱状图，是否显示该条目数据*/ 
	showData?:boolean,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface UIBarChart_reloadData_Params {
	/**模块的 id，用于区分模块的多个实例*/ 
	id:number,

	/**更新数据的方式*/ 
	type:string,

	/**要更新的数据*/ 
	data:Array,

}

interface UIBarChart_close_Params {
	/**模块的 id，用于区分模块的多个实例*/ 
	id:number,

}

interface UIBarChart_hide_Params {
	/**模块的 id，用于区分模块的多个实例*/ 
	id:number,

}

interface UIBarChart_show_Params {
	/**模块的 id，用于区分模块的多个实例*/ 
	id:number,

}

interface UIBarChart_scrollTo_Params {
	/**模块的 id，用于区分模块的多个实例*/ 
	id:number,

	/**（可选项）指定的条目的索引，不可大于总条目数减去每屏显示个数，从0开始*/ 
	index?:number,

	/**（可选项）滚动时是否带有动画效果*/ 
	animation?:boolean,

}

interface imageDragSort {
	/**
	 * `打开`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `styles` :JSON : （可选项）模块各部分的样式
	 *
	 * `imgArray` :Array : 所有图片路径组成的数组,图片路径是本地路径,支持fs://、widget://
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）是否将模块视图固定到窗口上，不跟随窗口上下滚动
	 */
	open(params:imageDragSort_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `再次添加图片`
	 * ========params==========
	 *
	 * `imgArray` :Array : 所有图片路径组成的数组,图片路径是本地路径,支持fs://、widget://(所有图片的数量不要超过30张)
	 */
	addImage(params:imageDragSort_addImage_Params, callback?: (ret:JSON) => void):void

	/** 开始编辑*/ 
	startEdit():void

	/** 关闭*/ 
	close():void

	/** 显示*/ 
	show():void

	/** 隐藏*/ 
	hide():void

	/** 取消编辑状态*/ 
	cancleEditState(callback?: (ret:JSON) => void):void

}
interface imageDragSort_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**（可选项）模块各部分的样式*/ 
	styles?:JSON,

	/**所有图片路径组成的数组,图片路径是本地路径,支持fs://、widget://*/ 
	imgArray:Array,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）是否将模块视图固定到窗口上，不跟随窗口上下滚动*/ 
	fixed?:boolean,

}

interface imageDragSort_addImage_Params {
	/**所有图片路径组成的数组,图片路径是本地路径,支持fs://、widget://(所有图片的数量不要超过30张)*/ 
	imgArray:Array,

}

interface hikvision {
	/** 打开实时监控*/ 
	open():void

	/** 二维码扫描*/ 
	qrCode():void

	/** 开始播放实时监控画面*/ 
	start():void

	/** 暂停播放实时监控画面*/ 
	pause():void

	/** 关闭实时监控*/ 
	close():void

	/** 显示实时监控界面*/ 
	show():void

	/** 隐藏实时监控界面*/ 
	hide():void

	/** 停止播放实时监控画面*/ 
	stop():void

}
interface UILinkedPicker {
}
interface pdfPlus {
	/**
	 * `打开一个上下滑动的pdf查看视图`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）位置参数
	 *
	 * `path` :string : 文档的路径，支持 widget://、fs://
	 *
	 * `backGroundColor` :string : 当前视图背景色
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）是否将模块视图固定到窗口上，不跟随窗口上下滚动
	 */
	openPdfViewer(params:pdfPlus_openPdfViewer_Params, callback?: (ret:JSON) => void):void

	/** 隐藏上下滑动的pdf查看视图*/ 
	hidePdfViewer():void

	/** 显示上下滑动的pdf查看视图*/ 
	showPdfViewer():void

	/** 关闭上下滑动的pdf查看视图*/ 
	closePdfViewer():void

	/**
	 * `打开一个左右翻页的pdf查看视图`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）位置参数
	 *
	 * `path` :string : 文档的路径，支持 widget://、fs://
	 *
	 * `index` :number : （可选项）打开指定页的页码，从1开始
	 *
	 * `backGroundColor` :string : 当前视图背景色
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）是否将模块视图固定到窗口上，不跟随窗口上下滚动
	 */
	openPdfPage(params:pdfPlus_openPdfPage_Params, callback?: (ret:JSON) => void):void

	/** 隐藏左右翻页的pdf查看视图*/ 
	hidePdfPage():void

	/** 显示左右翻页的pdf查看视图*/ 
	showPdfPage():void

	/** 关闭左右翻页的pdf查看视图*/ 
	closePdfPage():void

}
interface pdfPlus_openPdfViewer_Params {
	/**（可选项）位置参数*/ 
	rect?:JSON,

	/**文档的路径，支持 widget://、fs://*/ 
	path:string,

	/**当前视图背景色*/ 
	backGroundColor:string,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）是否将模块视图固定到窗口上，不跟随窗口上下滚动*/ 
	fixed?:boolean,

}

interface pdfPlus_openPdfPage_Params {
	/**（可选项）位置参数*/ 
	rect?:JSON,

	/**文档的路径，支持 widget://、fs://*/ 
	path:string,

	/**（可选项）打开指定页的页码，从1开始*/ 
	index?:number,

	/**当前视图背景色*/ 
	backGroundColor:string,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）是否将模块视图固定到窗口上，不跟随窗口上下滚动*/ 
	fixed?:boolean,

}

interface chatBox {
}
interface UIListContactsCheck {
	/**
	 * `打开列表`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `contacts` :Array : 列表数据源
	 *
	 * `styles` :string : （可选项）模块头部的样式
	 *
	 * `backgroundColor` :string : （可选项）模块背景色
	 *
	 * `bounces` :boolean : （可选项）是否弹动
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 */
	open(params:UIListContactsCheck_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭列表模块*/ 
	close():void

	/** 隐藏列表模块，并没有从内存里清除*/ 
	hide():void

	/** 显示已隐藏的列表模块*/ 
	show():void

	/**
	 * `刷新列表数据`
	 * ========params==========
	 *
	 * `contacts` :JSON : 列表数据源
	 */
	reloadData(params:UIListContactsCheck_reloadData_Params):void

}
interface UIListContactsCheck_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**列表数据源*/ 
	contacts:Array,

	/**（可选项）模块头部的样式*/ 
	styles?:string,

	/**（可选项）模块背景色*/ 
	backgroundColor?:string,

	/**（可选项）是否弹动*/ 
	bounces?:boolean,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

}

interface UIListContactsCheck_reloadData_Params {
	/**列表数据源*/ 
	contacts:JSON,

}

interface UIActionProgress {
	/**
	 * `弹出进度条展示区域`
	 * ========params==========
	 *
	 * `maskBg` :string : （可选项）遮罩层配置，若不传则无遮罩层；支持rgb、rgba、#，如rgba(0,0,0,0.4)
	 *
	 * `styles` :JSON : （可选项）弹出进度条样式配置
	 *
	 * `data` :JSON : 进度条区域的数据配置
	 */
	open(params:UIActionProgress_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `设置数据`
	 * ========params==========
	 *
	 * `data` :JSON : 进度条区域的数据配置
	 */
	setData(params:UIActionProgress_setData_Params):void

	/** 关闭模块*/ 
	close():void

	/** 隐藏模块，并没有从内存里清除*/ 
	hide():void

	/** 显示已隐藏的模块*/ 
	show():void

	/** 获取当前进度条的值*/ 
	getValue():void

}
interface UIActionProgress_open_Params {
	/**（可选项）遮罩层配置，若不传则无遮罩层；支持rgb、rgba、#，如rgba(0,0,0,0.4)*/ 
	maskBg?:string,

	/**（可选项）弹出进度条样式配置*/ 
	styles?:JSON,

	/**进度条区域的数据配置*/ 
	data:JSON,

}

interface UIActionProgress_setData_Params {
	/**进度条区域的数据配置*/ 
	data:JSON,

}

interface gridSlide {
	/**
	 * `打开九宫格菜单`
	 * ========params==========
	 *
	 * `rect` :JSON : （必填项）模块的位置及尺寸
	 *
	 * `background` :string : 页面背景色(如：#ff00ff)
	 *
	 * `rows` :number : （可选项）九宫格需要展示的行数。
	 *
	 * `cols` :number : （可选项）九宫格需要展示的列数。
	 *
	 * `isShowDot` :boolean : （可选项）是否显示底部dot圆点按钮
	 *
	 * `fixedOn` :string : （可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 Window 或 Frame 滚动
	 *
	 * `data` :Array : （必填项）模块九宫格按钮图标和名称
	 *
	 * `defaultIcon` :string : （可选项）设置icon图标不存在是的默认图片(支持fs:// widget://)。
	 */
	openMenu(params:gridSlide_openMenu_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 隐藏菜单*/ 
	hideMenu(callback?: (ret:JSON, err:JSON) => void):void

	/** 显示菜单*/ 
	showMenu():void

	/** 关闭菜单*/ 
	closeMenu(callback?: (ret:JSON, err:JSON) => void):void

}
interface gridSlide_openMenu_Params {
	/**（必填项）模块的位置及尺寸*/ 
	rect:JSON,

	/**页面背景色(如：#ff00ff)*/ 
	background:string,

	/**（可选项）九宫格需要展示的行数。*/ 
	rows?:number,

	/**（可选项）九宫格需要展示的列数。*/ 
	cols?:number,

	/**（可选项）是否显示底部dot圆点按钮*/ 
	isShowDot?:boolean,

	/**（可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 Window 或 Frame 滚动*/ 
	fixed?:boolean,

	/**（必填项）模块九宫格按钮图标和名称*/ 
	data:Array,

	/**（可选项）设置icon图标不存在是的默认图片(支持fs:// widget://)。*/ 
	defaultIcon?:string,

}

interface UIPickerView {
	/**
	 * `打开选择器模块`
	 * ========params==========
	 *
	 * `styles` :JSON : （可选项）模块各部分的样式配置
	 *
	 * `mask` :string : （可选项）上部遮罩层配置，支持rgb、rgba、#；（仅ios支持）
	 *
	 * `animation` :boolean : （可选项）打开/关闭（显示/隐藏）时是否带动画效果（300毫秒）
	 *
	 * `checked` :Array : 默认当前选中数据的 ID 组成的数组，如：['001','001','001',]
	 *
	 * `datas` :Array : 模块数据源，可以是 `json` 文件的路径，也可以把数据源直接传给模块
	 *
	 * `cyclic` :boolean : （可选项）是否可循环滑动
	 */
	open(params:UIPickerView_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `更改当前模块的数据源`
	 * ========params==========
	 *
	 * `datas` :Array : 模块数据源，可以是 `json` 文件的路径，也可以把数据源直接传给模块
	 */
	changeData(params:UIPickerView_changeData_Params, callback?: (ret:JSON) => void):void

	/**
	 * `关闭模块（从内存里清除）`
	 * ========params==========
	 *
	 * `animation` :boolean : （可选项）是否带动画效果（300毫秒）
	 */
	close(params:UIPickerView_close_Params, callback?: (ret:JSON) => void):void

	/**
	 * `显示已隐藏的模块`
	 * ========params==========
	 *
	 * `animation` :boolean : （可选项）是否带动画效果（300毫秒）
	 */
	show(params:UIPickerView_show_Params, callback?: (ret:JSON) => void):void

	/**
	 * `隐藏模块`
	 * ========params==========
	 *
	 * `animation` :boolean : （可选项）是否带动画效果（300毫秒）
	 */
	hide(params:UIPickerView_hide_Params, callback?: (ret:JSON) => void):void

	/** 获取当前选中项的数据*/ 
	getChecked():void

	/**
	 * `设置选中项`
	 * ========params==========
	 *
	 * `checked` :Array : 设置选中项的 ID 组成的数组，如：['001','001','001']
	 */
	setChecked(params:UIPickerView_setChecked_Params, callback?: (ret:JSON) => void):void

}
interface UIPickerView_open_Params {
	/**（可选项）模块各部分的样式配置*/ 
	styles?:JSON,

	/**（可选项）上部遮罩层配置，支持rgb、rgba、#；（仅ios支持）*/ 
	mask?:string,

	/**（可选项）打开/关闭（显示/隐藏）时是否带动画效果（300毫秒）*/ 
	animation?:boolean,

	/**默认当前选中数据的 ID 组成的数组，如：['001','001','001',]*/ 
	checked:Array,

	/**模块数据源，可以是 `json` 文件的路径，也可以把数据源直接传给模块*/ 
	datas:Array,

	/**（可选项）是否可循环滑动*/ 
	cyclic?:boolean,

}

interface UIPickerView_changeData_Params {
	/**模块数据源，可以是 `json` 文件的路径，也可以把数据源直接传给模块*/ 
	datas:Array,

}

interface UIPickerView_close_Params {
	/**（可选项）是否带动画效果（300毫秒）*/ 
	animation?:boolean,

}

interface UIPickerView_show_Params {
	/**（可选项）是否带动画效果（300毫秒）*/ 
	animation?:boolean,

}

interface UIPickerView_hide_Params {
	/**（可选项）是否带动画效果（300毫秒）*/ 
	animation?:boolean,

}

interface UIPickerView_setChecked_Params {
	/**设置选中项的 ID 组成的数组，如：['001','001','001']*/ 
	checked:Array,

}

interface guaidWindow {
}
interface UIActionDialog {
	/**
	 * `打开日期选择器`
	 * ========params==========
	 *
	 * `styles` :JSON : （可选项）模块各部分的样式配置
	 *
	 * `mask` :string : （可选项）上部遮罩层配置，支持rgb、rgba、#；
	 *
	 * `selected` :string : 默认当前选中日期，如：2019-5-28
	 *
	 * `animation` :boolean : （可选项）打开/关闭（显示/隐藏）时是否带动画效果（300毫秒）
	 */
	datePicker(params:UIActionDialog_datePicker_Params, callback?: (ret:JSON) => void):void

	/**
	 * `打开支付选择器`
	 * ========params==========
	 *
	 * `styles` :JSON : （可选项）模块各部分的样式配置
	 *
	 * `mask` :string : （可选项）上部遮罩层配置，支持rgb、rgba、#；
	 *
	 * `animation` :boolean : （可选项）打开/关闭（显示/隐藏）时是否带动画效果（300毫秒）
	 */
	goPay(params:UIActionDialog_goPay_Params, callback?: (ret:JSON) => void):void

	/**
	 * `打开支付选择器`
	 * ========params==========
	 *
	 * `styles` :JSON : （可选项）模块各部分的样式配置
	 *
	 * `datas` :Array : 选择项数据源
	 *
	 * `mask` :string : （可选项）上部遮罩层配置，支持rgb、rgba、#；
	 *
	 * `selected` :string : 默认当前选中项的下标
	 *
	 * `animation` :boolean : （可选项）打开/关闭（显示/隐藏）时是否带动画效果（300毫秒）
	 */
	pay(params:UIActionDialog_pay_Params, callback?: (ret:JSON) => void):void

	/**
	 * `打开支付选择器`
	 * ========params==========
	 *
	 * `styles` :JSON : （可选项）模块各部分的样式配置
	 *
	 * `datas` :Array : 选择项数据源
	 *
	 * `mask` :string : （可选项）上部遮罩层配置，支持rgb、rgba、#；
	 *
	 * `animation` :boolean : （可选项）打开/关闭（显示/隐藏）时是否带动画效果（300毫秒）
	 */
	payBy(params:UIActionDialog_payBy_Params, callback?: (ret:JSON) => void):void

	/**
	 * `打开支付选择器`
	 * ========params==========
	 *
	 * `styles` :JSON : （可选项）模块各部分的样式配置
	 *
	 * `datas` :Array : 选择项数据源
	 *
	 * `mask` :string : （可选项）上部遮罩层配置，支持rgb、rgba、#；
	 *
	 * `index` :string : 默认当前选中项的下标
	 *
	 * `animation` :boolean : （可选项）打开/关闭（显示/隐藏）时是否带动画效果（300毫秒）
	 */
	payFor(params:UIActionDialog_payFor_Params, callback?: (ret:JSON) => void):void

	/**
	 * `显示已隐藏的模块 **仅支持ios**`
	 * ========params==========
	 *
	 * `animation` :boolean : （可选项）是否带动画效果（300毫秒）
	 */
	show(params:UIActionDialog_show_Params):void

	/**
	 * `隐藏对话框 **仅支持ios**`
	 * ========params==========
	 *
	 * `animation` :boolean : （可选项）是否带动画效果（300毫秒）
	 */
	hide(params:UIActionDialog_hide_Params):void

	/**
	 * `关闭模块（从内存里清除）`
	 * ========params==========
	 *
	 * `animation` :boolean : （可选项）是否带动画效果（300毫秒）
	 */
	close(params:UIActionDialog_close_Params):void

}
interface UIActionDialog_datePicker_Params {
	/**（可选项）模块各部分的样式配置*/ 
	styles?:JSON,

	/**（可选项）上部遮罩层配置，支持rgb、rgba、#；*/ 
	mask?:string,

	/**默认当前选中日期，如：2019-5-28*/ 
	selected:string,

	/**（可选项）打开/关闭（显示/隐藏）时是否带动画效果（300毫秒）*/ 
	animation?:boolean,

}

interface UIActionDialog_goPay_Params {
	/**（可选项）模块各部分的样式配置*/ 
	styles?:JSON,

	/**（可选项）上部遮罩层配置，支持rgb、rgba、#；*/ 
	mask?:string,

	/**（可选项）打开/关闭（显示/隐藏）时是否带动画效果（300毫秒）*/ 
	animation?:boolean,

}

interface UIActionDialog_pay_Params {
	/**（可选项）模块各部分的样式配置*/ 
	styles?:JSON,

	/**选择项数据源*/ 
	datas:Array,

	/**（可选项）上部遮罩层配置，支持rgb、rgba、#；*/ 
	mask?:string,

	/**默认当前选中项的下标*/ 
	selected:string,

	/**（可选项）打开/关闭（显示/隐藏）时是否带动画效果（300毫秒）*/ 
	animation?:boolean,

}

interface UIActionDialog_payBy_Params {
	/**（可选项）模块各部分的样式配置*/ 
	styles?:JSON,

	/**选择项数据源*/ 
	datas:Array,

	/**（可选项）上部遮罩层配置，支持rgb、rgba、#；*/ 
	mask?:string,

	/**（可选项）打开/关闭（显示/隐藏）时是否带动画效果（300毫秒）*/ 
	animation?:boolean,

}

interface UIActionDialog_payFor_Params {
	/**（可选项）模块各部分的样式配置*/ 
	styles?:JSON,

	/**选择项数据源*/ 
	datas:Array,

	/**（可选项）上部遮罩层配置，支持rgb、rgba、#；*/ 
	mask?:string,

	/**默认当前选中项的下标*/ 
	index:string,

	/**（可选项）打开/关闭（显示/隐藏）时是否带动画效果（300毫秒）*/ 
	animation?:boolean,

}

interface UIActionDialog_show_Params {
	/**（可选项）是否带动画效果（300毫秒）*/ 
	animation?:boolean,

}

interface UIActionDialog_hide_Params {
	/**（可选项）是否带动画效果（300毫秒）*/ 
	animation?:boolean,

}

interface UIActionDialog_close_Params {
	/**（可选项）是否带动画效果（300毫秒）*/ 
	animation?:boolean,

}

interface UIPersonalCenter {
	/**
	 * `打开个人中心`
	 * ========params==========
	 *
	 * `y ` :number : （可选项）个人中心视图上边距屏幕位置
	 *
	 * `h ` :number : （可选项）视图的高，不可小于230
	 *
	 * `data` :JSON : 模块数据配置
	 *
	 * `styles` :JSON : 模块样式配置
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	open(params:UIPersonalCenter_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `刷新个人中心显示数据`
	 * ========params==========
	 *
	 * `data` :JSON : 模块数据配置
	 */
	updateValue(params:UIPersonalCenter_updateValue_Params):void

	/** 关闭个人中心*/ 
	close():void

	/** 获取选中按钮*/ 
	getSelect():void

	/**
	 * `设置选中按钮`
	 * ========params==========
	 *
	 * `index` :number : （可选项）底部菜单按钮选中项的索引
	 */
	setSelect(params:UIPersonalCenter_setSelect_Params):void

	/** 显示个人中心*/ 
	show():void

	/** 隐藏个人中心*/ 
	hide():void

}
interface UIPersonalCenter_open_Params {
	/**（可选项）个人中心视图上边距屏幕位置*/ 
	y ?:number,

	/**（可选项）视图的高，不可小于230*/ 
	h ?:number,

	/**模块数据配置*/ 
	data:JSON,

	/**模块样式配置*/ 
	styles:JSON,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface UIPersonalCenter_updateValue_Params {
	/**模块数据配置*/ 
	data:JSON,

}

interface UIPersonalCenter_setSelect_Params {
	/**（可选项）底部菜单按钮选中项的索引*/ 
	index?:number,

}

interface UIChatBox {
	/** 打开聊天输入框*/ 
	open(callback?: (ret:JSON) => void):void

	/** 关闭聊天输入框*/ 
	close():void

	/** 显示聊天输入框*/ 
	show():void

	/** 隐藏聊天输入框*/ 
	hide():void

	/**
	 * `弹出表情、附加功能面板`
	 * ========params==========
	 *
	 * `target` :string : 操作的面板类型，取值范围如下：
	 */
	popupBoard(params:UIChatBox_popupBoard_Params):void

	/** 收起表情、附加功能面板*/ 
	closeBoard():void

	/** 弹出键盘*/ 
	popupKeyboard():void

	/** 收起键盘*/ 
	closeKeyboard():void

	/**
	 * `获取或设置聊天输入框的内容`
	 * ========params==========
	 *
	 * `msg` :string : （可选项）聊天输入框的内容，若不传则返回输入框的值
	 */
	value(params:UIChatBox_value_Params, callback?: (ret:JSON) => void):void

	/**
	 * `向聊天输入框的指定位置插入内容`
	 * ========params==========
	 *
	 * `index` :number : （可选项）待插入内容的起始位置。**注意：中文，全角符号均占一个字符长度；索引从0开始，0表示插入到最前面，1表示插入到第一个字符后面，2表示插入到第二个字符后面，以此类推。**
	 *
	 * `msg` :string : （可选项）要插入的内容
	 */
	insertValue(params:UIChatBox_insertValue_Params):void

	/**
	 * `事件监听`
	 * ========params==========
	 *
	 * `target` :string : 事件的目标对象
	 *
	 * `name` :string : 监听的事件类型
	 */
	addEventListener(params:UIChatBox_addEventListener_Params, callback?: (ret:JSON) => void):void

	/**
	 * `重设聊天输入框的占位提示文本`
	 * ========params==========
	 *
	 * `placeholder` :string : （可选项）占位提示文本，若不传或传空则表示清空占位提示内容
	 */
	setPlaceholder(params:UIChatBox_setPlaceholder_Params):void

	/**
	 * `重新加载（刷新）附加功能面板，**open时必须添加附加功能按钮及其面板参数**`
	 * ========params==========
	 *
	 * `extras` :JSON : （可选项）点击附加功能按钮，打开的附加功能面板的按钮样式，配合 extrasBtn 一起使用，若 extrasBtn 参数内 normalImg 属性不传则此参数可不传
	 */
	reloadExtraBoard(params:UIChatBox_reloadExtraBoard_Params):void

	/** 取消录音*/ 
	cancelRecord():void

	/**
	 * `这只面板的背景颜色`
	 * ========params==========
	 *
	 * `color` :string : 面板背景色
	 */
	setInputBarBgColor(params:UIChatBox_setInputBarBgColor_Params):void

}
interface UIChatBox_popupBoard_Params {
	/**操作的面板类型，取值范围如下：*/ 
	target:string,

}

interface UIChatBox_value_Params {
	/**（可选项）聊天输入框的内容，若不传则返回输入框的值*/ 
	msg?:string,

}

interface UIChatBox_insertValue_Params {
	/**（可选项）待插入内容的起始位置。**注意：中文，全角符号均占一个字符长度；索引从0开始，0表示插入到最前面，1表示插入到第一个字符后面，2表示插入到第二个字符后面，以此类推。***/ 
	index?:number,

	/**（可选项）要插入的内容*/ 
	msg?:string,

}

interface UIChatBox_addEventListener_Params {
	/**事件的目标对象*/ 
	target:string,

	/**监听的事件类型*/ 
	name:string,

}

interface UIChatBox_setPlaceholder_Params {
	/**（可选项）占位提示文本，若不传或传空则表示清空占位提示内容*/ 
	placeholder?:string,

}

interface UIChatBox_reloadExtraBoard_Params {
	/**（可选项）点击附加功能按钮，打开的附加功能面板的按钮样式，配合 extrasBtn 一起使用，若 extrasBtn 参数内 normalImg 属性不传则此参数可不传*/ 
	extras?:JSON,

}

interface UIChatBox_setInputBarBgColor_Params {
	/**面板背景色*/ 
	color:string,

}

interface douYinSlidePlayer {
	/**
	 * `打开滑动播放器`
	 * ========params==========
	 *
	 * `rect` :JSON : （必填项）模块的位置及尺寸
	 *
	 * `fixedOn` :string : （可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window
	 *
	 * `fixed` :boolean : （（可选项）模块是否随所属 Window 或 Frame 滚动
	 *
	 * `videos` :JSON : （必填项）视频播放列表（最少传入1条记录）。
	 */
	openPlayer(params:douYinSlidePlayer_openPlayer_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 设置播放器的事件监听，需要在openPlayer回调成功后调用。*/ 
	addEventListener():void

	/** 隐藏滑动播放器*/ 
	hidePlayer(callback?: (ret:JSON, err:JSON) => void):void

	/** 显示滑动播放器*/ 
	showPlayer():void

	/** 关闭滑动播放器*/ 
	closePlayer(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `重置播放器数据`
	 * ========params==========
	 *
	 * `videos` :JSON : （必填项）视频播放列表（最少传入1条记录）。
	 */
	setVideoDatas(params:douYinSlidePlayer_setVideoDatas_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `添加分页数据`
	 * ========params==========
	 *
	 * `videos` :JSON : （必填项）视频播放列表（最少传入1条记录）。
	 */
	addVideoDatas(params:douYinSlidePlayer_addVideoDatas_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `根据ID删除播放数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）需要删除数据的序号。
	 */
	delVideoByIndex(params:douYinSlidePlayer_delVideoByIndex_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `设置当前页的点赞数量。`
	 * ========params==========
	 *
	 * `likeCountStr` :string : （必填项）点赞数量，字符串类型，若点赞数量过大，可将数量转为字符串，如1.5W等。本参数最大字符数量为5，即本字符串不能超过5个字符。
	 */
	setLikeCount(params:douYinSlidePlayer_setLikeCount_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `设置当前页的评论数量。`
	 * ========params==========
	 *
	 * `commonCountStr` :string : （必填项）评论数量，字符串类型，若评论数量过大，可将数量转为字符串，如1.5W等。本参数最大字符数量为5，即本字符串不能超过5个字符。
	 */
	setCommonCount(params:douYinSlidePlayer_setCommonCount_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `设置当前页的分享数量。`
	 * ========params==========
	 *
	 * `shareCountStr` :string : （必填项）分享数量，字符串类型，若分享数量过大，可将数量转为字符串，如1.5W等。本参数最大字符数量为5，即本字符串不能超过5个字符。
	 */
	setShareCount(params:douYinSlidePlayer_setShareCount_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 播放已暂停的视频。*/ 
	play(callback?: (ret:JSON, err:JSON) => void):void

	/** 暂停已播放的视频。*/ 
	pause(callback?: (ret:JSON, err:JSON) => void):void

	/** 清楚播放器缓存数据。*/ 
	clearCache(callback?: (ret:JSON, err:JSON) => void):void

	/** 播放下一个视频。*/ 
	playNext(callback?: (ret:JSON, err:JSON) => void):void

	/** 播放上一个视频。*/ 
	playPrevious(callback?: (ret:JSON, err:JSON) => void):void

}
interface douYinSlidePlayer_openPlayer_Params {
	/**（必填项）模块的位置及尺寸*/ 
	rect:JSON,

	/**（可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window*/ 
	fixedOn?:string,

	/**（（可选项）模块是否随所属 Window 或 Frame 滚动*/ 
	fixed?:boolean,

	/**（必填项）视频播放列表（最少传入1条记录）。*/ 
	videos:JSON,

}

interface douYinSlidePlayer_setVideoDatas_Params {
	/**（必填项）视频播放列表（最少传入1条记录）。*/ 
	videos:JSON,

}

interface douYinSlidePlayer_addVideoDatas_Params {
	/**（必填项）视频播放列表（最少传入1条记录）。*/ 
	videos:JSON,

}

interface douYinSlidePlayer_delVideoByIndex_Params {
	/**（可选项）需要删除数据的序号。*/ 
	index?:number,

}

interface douYinSlidePlayer_setLikeCount_Params {
	/**（必填项）点赞数量，字符串类型，若点赞数量过大，可将数量转为字符串，如1.5W等。本参数最大字符数量为5，即本字符串不能超过5个字符。*/ 
	likeCountStr:string,

}

interface douYinSlidePlayer_setCommonCount_Params {
	/**（必填项）评论数量，字符串类型，若评论数量过大，可将数量转为字符串，如1.5W等。本参数最大字符数量为5，即本字符串不能超过5个字符。*/ 
	commonCountStr:string,

}

interface douYinSlidePlayer_setShareCount_Params {
	/**（必填项）分享数量，字符串类型，若分享数量过大，可将数量转为字符串，如1.5W等。本参数最大字符数量为5，即本字符串不能超过5个字符。*/ 
	shareCountStr:string,

}

interface UIAddressBook {
	/**
	 * `打开列表`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `bgColor` :JSON : 背景颜色
	 *
	 * `contacts` :Array : 列表数据源
	 *
	 * `checkBox` :boolean : （可选项）是否显示复选框
	 *
	 * `singleCheck` :boolean : （可选项）是否显示为单选
	 *
	 * `bounces` :boolean : （可选项）列表是否有弹动效果
	 *
	 * `coverInfo` :boolean : （可选项）是否遮盖部分信息，该状态时，遮盖姓，以及联系方式第三位以后，最多四位			字符
	 *
	 * `manage` :boolean : （可选项）是否为成员管理，当为成员管理状态时，群主标志位于姓名之后，userType参		数为1时，在更多按钮前显示未进群标志
	 *
	 * `moreIcon` :string : （可选项）更多按钮图标地址，仅支持本地路径（fs://和widget://）
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 */
	open(params:UIAddressBook_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭列表模块*/ 
	close():void

	/** 隐藏列表模块，并没有从内存里清除*/ 
	hide():void

	/** 显示已隐藏的列表模块*/ 
	show():void

	/**
	 * `刷新列表数据`
	 * ========params==========
	 *
	 * `contacts` :Array : 列表数据源
	 */
	reloadData(params:UIAddressBook_reloadData_Params):void

	/**
	 * `设置选中的联系人`
	 * ========params==========
	 *
	 * `selected` :boolean : （可选项）设置/取消选中状态
	 *
	 * `contacts` :Array : 要设置为选中状态的联系人id组成的数组
	 */
	setSelected(params:UIAddressBook_setSelected_Params):void

	/** 获取所有当前选中的联系人信息，**同步接口***/ 
	getSelectedSync():JSON;

	/**
	 * `设置列表尺寸`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `animation` :boolean : （可选项）改变 rect 时，是否带动画效果，暂仅支持 iOS 平台
	 */
	setRect(params:UIAddressBook_setRect_Params):void

}
interface UIAddressBook_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**背景颜色*/ 
	bgColor:JSON,

	/**列表数据源*/ 
	contacts:Array,

	/**（可选项）是否显示复选框*/ 
	checkBox?:boolean,

	/**（可选项）是否显示为单选*/ 
	singleCheck?:boolean,

	/**（可选项）列表是否有弹动效果*/ 
	bounces?:boolean,

	/**（可选项）是否遮盖部分信息，该状态时，遮盖姓，以及联系方式第三位以后，最多四位			字符*/ 
	coverInfo?:boolean,

	/**（可选项）是否为成员管理，当为成员管理状态时，群主标志位于姓名之后，userType参		数为1时，在更多按钮前显示未进群标志*/ 
	manage?:boolean,

	/**（可选项）更多按钮图标地址，仅支持本地路径（fs://和widget://）*/ 
	moreIcon?:string,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

}

interface UIAddressBook_reloadData_Params {
	/**列表数据源*/ 
	contacts:Array,

}

interface UIAddressBook_setSelected_Params {
	/**（可选项）设置/取消选中状态*/ 
	selected?:boolean,

	/**要设置为选中状态的联系人id组成的数组*/ 
	contacts:Array,

}

interface UIAddressBook_setRect_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**（可选项）改变 rect 时，是否带动画效果，暂仅支持 iOS 平台*/ 
	animation?:boolean,

}

interface sphereCloud {
	/**
	 * `打开标签控件`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `styles` :JSON : （可选项）样式配置
	 *
	 * `data` :Array<JSON> : 显示的数据元素及样式组成的数组
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	open(params:sphereCloud_open_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `刷新整个数据源`
	 * ========params==========
	 *
	 * `id` :string : 控件 ID，open 接口成功打开后返回
	 *
	 * `data` :Array<JSON> : 显示的数据元素及样式组成的数组
	 */
	update(params:sphereCloud_update_Params):void

	/**
	 * `刷新指定item`
	 * ========params==========
	 *
	 * `id` :string : 控件 ID，open 接口成功打开后返回
	 *
	 * `item` :JSON : 显示的数据元素及样式组成的数组
	 */
	updateItem(params:sphereCloud_updateItem_Params):void

	/**
	 * `关闭模块`
	 * ========params==========
	 *
	 * `id` :string : 控件 ID，open 接口成功打开后返回
	 */
	close(params:sphereCloud_close_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `监听模块相关事件`
	 * ========params==========
	 *
	 * `id` :string : 控件 ID，open 接口成功打开后返回
	 *
	 * `target` :string : （可选项）监听的事件类型
	 */
	addEventListener(params:sphereCloud_addEventListener_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `隐藏模块视图`
	 * ========params==========
	 *
	 * `id` :string : 控件 ID，open 接口成功打开后返回
	 */
	hide(params:sphereCloud_hide_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `显示模块视图`
	 * ========params==========
	 *
	 * `id` :string : 控件 ID，open 接口成功打开后返回
	 */
	show(params:sphereCloud_show_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface sphereCloud_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**（可选项）样式配置*/ 
	styles?:JSON,

	/**显示的数据元素及样式组成的数组*/ 
	data:Array<JSON>,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface sphereCloud_update_Params {
	/**控件 ID，open 接口成功打开后返回*/ 
	id:string,

	/**显示的数据元素及样式组成的数组*/ 
	data:Array<JSON>,

}

interface sphereCloud_updateItem_Params {
	/**控件 ID，open 接口成功打开后返回*/ 
	id:string,

	/**显示的数据元素及样式组成的数组*/ 
	item:JSON,

}

interface sphereCloud_close_Params {
	/**控件 ID，open 接口成功打开后返回*/ 
	id:string,

}

interface sphereCloud_addEventListener_Params {
	/**控件 ID，open 接口成功打开后返回*/ 
	id:string,

	/**（可选项）监听的事件类型*/ 
	target?:string,

}

interface sphereCloud_hide_Params {
	/**控件 ID，open 接口成功打开后返回*/ 
	id:string,

}

interface sphereCloud_show_Params {
	/**控件 ID，open 接口成功打开后返回*/ 
	id:string,

}

interface UICalendar {
	/**
	 * `打开日历`
	 * ========params==========
	 *
	 * `multipleSelect` :boolean : （可选项）是否可以多选日期
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `styles` :JSON : （可选项）模块各部分的样式
	 *
	 * `specialDate` :Array : （可选项）需要标记的特殊日期数组
	 *
	 * `switchMode` :string : （可选项）月份的切换方式
	 *
	 * `isBefore` :boolean : （可选项）今天以前的日期是否置灰不可选
	 *
	 * `isAfter` :boolean : （可选项）今天以后的日期是否置灰不可选
	 *
	 * `showTodayStyle` :boolean : （可选项）当天日期是否使用特殊格式显示（仅android有效）
	 *
	 * `canScroll` :boolean : 是否可以滚动 (注意：只有在switchMode为none 并且改参数为true时可以滚动)
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	open(params:UICalendar_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `设置特殊日期`
	 * ========params==========
	 *
	 * `id` :number : 日历视图id
	 *
	 * `specialDates` :Array : 需要标记的特殊日期数组，格式为：yyyy-MM-dd
	 */
	setSpecialDates(params:UICalendar_setSpecialDates_Params):void

	/**
	 * `取消已设置的特殊日期状态`
	 * ========params==========
	 *
	 * `id` :number : 日历视图id
	 *
	 * `specialDates` :Array : 需要取消的特殊日期组成的数组，格式为：yyyy-MM-dd
	 */
	cancelSpecialDates(params:UICalendar_cancelSpecialDates_Params):void

	/**
	 * `关闭日历`
	 * ========params==========
	 *
	 * `id` :number : 日历视图id
	 */
	close(params:UICalendar_close_Params):void

	/**
	 * `显示日历`
	 * ========params==========
	 *
	 * `id` :number : 日历视图id
	 */
	show(params:UICalendar_show_Params):void

	/**
	 * `隐藏日历`
	 * ========params==========
	 *
	 * `id` :number : 日历视图id
	 */
	hide(params:UICalendar_hide_Params):void

	/**
	 * `显示下个月`
	 * ========params==========
	 *
	 * `id` :number : 日历视图id
	 */
	nextMonth(params:UICalendar_nextMonth_Params, callback?: (ret:JSON) => void):void

	/**
	 * `显示上个月`
	 * ========params==========
	 *
	 * `id` :number : 日历视图id
	 */
	prevMonth(params:UICalendar_prevMonth_Params, callback?: (ret:JSON) => void):void

	/**
	 * `显示下一年`
	 * ========params==========
	 *
	 * `id` :number : 日历视图id
	 */
	nextYear(params:UICalendar_nextYear_Params, callback?: (ret:JSON) => void):void

	/**
	 * `显示上一年`
	 * ========params==========
	 *
	 * `id` :number : 日历视图id
	 */
	prevYear(params:UICalendar_prevYear_Params, callback?: (ret:JSON) => void):void

	/**
	 * `设置选中日期（不支持日期多选模式）`
	 * ========params==========
	 *
	 * `id` :number : 日历视图id
	 *
	 * `date` :string : （可选项）选中日期，格式为：yyyy-MM-dd
	 *
	 * `ignoreSelected` :boolean : （可选项）选中日期是否忽略选中日期样式（open -> styles -> date -> selectedColor、selectedBg）
	 */
	setDate(params:UICalendar_setDate_Params, callback?: (ret:JSON) => void):void

	/**
	 * `翻到指定的页`
	 * ========params==========
	 *
	 * `id` :number : 日历视图id
	 *
	 * `date` :string : 选中日期，格式为：yyyy-MM
	 */
	turnPage(params:UICalendar_turnPage_Params):void

}
interface UICalendar_open_Params {
	/**（可选项）是否可以多选日期*/ 
	multipleSelect?:boolean,

	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**（可选项）模块各部分的样式*/ 
	styles?:JSON,

	/**（可选项）需要标记的特殊日期数组*/ 
	specialDate?:Array,

	/**（可选项）月份的切换方式*/ 
	switchMode?:string,

	/**（可选项）今天以前的日期是否置灰不可选*/ 
	isBefore?:boolean,

	/**（可选项）今天以后的日期是否置灰不可选*/ 
	isAfter?:boolean,

	/**（可选项）当天日期是否使用特殊格式显示（仅android有效）*/ 
	showTodayStyle?:boolean,

	/**是否可以滚动 (注意：只有在switchMode为none 并且改参数为true时可以滚动)*/ 
	canScroll:boolean,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface UICalendar_setSpecialDates_Params {
	/**日历视图id*/ 
	id:number,

	/**需要标记的特殊日期数组，格式为：yyyy-MM-dd*/ 
	specialDates:Array,

}

interface UICalendar_cancelSpecialDates_Params {
	/**日历视图id*/ 
	id:number,

	/**需要取消的特殊日期组成的数组，格式为：yyyy-MM-dd*/ 
	specialDates:Array,

}

interface UICalendar_close_Params {
	/**日历视图id*/ 
	id:number,

}

interface UICalendar_show_Params {
	/**日历视图id*/ 
	id:number,

}

interface UICalendar_hide_Params {
	/**日历视图id*/ 
	id:number,

}

interface UICalendar_nextMonth_Params {
	/**日历视图id*/ 
	id:number,

}

interface UICalendar_prevMonth_Params {
	/**日历视图id*/ 
	id:number,

}

interface UICalendar_nextYear_Params {
	/**日历视图id*/ 
	id:number,

}

interface UICalendar_prevYear_Params {
	/**日历视图id*/ 
	id:number,

}

interface UICalendar_setDate_Params {
	/**日历视图id*/ 
	id:number,

	/**（可选项）选中日期，格式为：yyyy-MM-dd*/ 
	date?:string,

	/**（可选项）选中日期是否忽略选中日期样式（open -> styles -> date -> selectedColor、selectedBg）*/ 
	ignoreSelected?:boolean,

}

interface UICalendar_turnPage_Params {
	/**日历视图id*/ 
	id:number,

	/**选中日期，格式为：yyyy-MM*/ 
	date:string,

}

interface maskView {
	/** 界面按钮监听*/ 
	addEventListener():void

	/**
	 * `打开遮罩视图`
	 * ========params==========
	 *
	 * `rect` :JSON : （必填项）模块的位置及尺寸
	 *
	 * `fixedOn` :string : （可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 Window 或 Frame 滚动
	 *
	 * `background` :string : （可选项）遮罩背景色 如:#80addf。
	 *
	 * `alpha` :number : （可选项）遮罩背景色透明度(0-100)。
	 *
	 * `radius` :string : （可选项）遮罩四个角的圆角。
	 *
	 * `cornerTopLeft` :boolean : （可选项）左上角为圆角。
	 *
	 * `cornerTopRight` :boolean : （可选项）右上角为圆角。
	 *
	 * `cornerBottomLeft` :boolean : （可选项）右下角为圆角。
	 *
	 * `cornerBottomRight` :boolean : （可选项）右下角为圆角。
	 *
	 * `animationType` :string : （可选项）入场动画>0:无动画 1:从底部进入 2:从顶部进入 3:从右侧进入 4:从左侧进入。
	 *
	 * `isBindPage` :boolean : （可选项）是否绑定 Window 或 Frame, 为true时就需要传 fixedOn and fixed 生效
	 *
	 * `styles` :any : （必填项）视频播放列表（最少传入1条记录）。
	 */
	openMaskView(params:maskView_openMaskView_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `隐藏遮罩样式`
	 * ========params==========
	 *
	 * `index` :number : （可选项）需要操作遮罩视图的序号id
	 */
	hideMaskView(params:maskView_hideMaskView_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `显示遮罩样式`
	 * ========params==========
	 *
	 * `index` :number : （可选项）需要操作遮罩视图的序号id
	 */
	showMaskView(params:maskView_showMaskView_Params, callback?: (ret:JSON) => void):void

	/**
	 * `关闭遮罩样式`
	 * ========params==========
	 *
	 * `index` :number : （可选项）需要操作遮罩视图的序号id
	 */
	closeMaskView(params:maskView_closeMaskView_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `更新当前遮罩样式`
	 * ========params==========
	 *
	 * `index` :number : （可选项）需要操作遮罩视图的序号id
	 *
	 * `styles` :any : （必填项）当前播放器播放的按钮样式更新。
	 */
	updateMaskStyle(params:maskView_updateMaskStyle_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `把遮罩更新到指定的frame层级(id=-1无效)`
	 * ========params==========
	 *
	 * `index` :number : （可选项）需要操作遮罩视图的序号id
	 *
	 * `fixedOn` :string : （可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 Window 或 Frame 滚动
	 */
	bringFrameToFront(params:maskView_bringFrameToFront_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface maskView_openMaskView_Params {
	/**（必填项）模块的位置及尺寸*/ 
	rect:JSON,

	/**（可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 Window 或 Frame 滚动*/ 
	fixed?:boolean,

	/**（可选项）遮罩背景色 如:#80addf。*/ 
	background?:string,

	/**（可选项）遮罩背景色透明度(0-100)。*/ 
	alpha?:number,

	/**（可选项）遮罩四个角的圆角。*/ 
	radius?:string,

	/**（可选项）左上角为圆角。*/ 
	cornerTopLeft?:boolean,

	/**（可选项）右上角为圆角。*/ 
	cornerTopRight?:boolean,

	/**（可选项）右下角为圆角。*/ 
	cornerBottomLeft?:boolean,

	/**（可选项）右下角为圆角。*/ 
	cornerBottomRight?:boolean,

	/**（可选项）入场动画>0:无动画 1:从底部进入 2:从顶部进入 3:从右侧进入 4:从左侧进入。*/ 
	animationType?:string,

	/**（可选项）是否绑定 Window 或 Frame, 为true时就需要传 fixedOn and fixed 生效*/ 
	isBindPage?:boolean,

	/**（必填项）视频播放列表（最少传入1条记录）。*/ 
	styles:any,

}

interface maskView_hideMaskView_Params {
	/**（可选项）需要操作遮罩视图的序号id*/ 
	index?:number,

}

interface maskView_showMaskView_Params {
	/**（可选项）需要操作遮罩视图的序号id*/ 
	index?:number,

}

interface maskView_closeMaskView_Params {
	/**（可选项）需要操作遮罩视图的序号id*/ 
	index?:number,

}

interface maskView_updateMaskStyle_Params {
	/**（可选项）需要操作遮罩视图的序号id*/ 
	index?:number,

	/**（必填项）当前播放器播放的按钮样式更新。*/ 
	styles:any,

}

interface maskView_bringFrameToFront_Params {
	/**（可选项）需要操作遮罩视图的序号id*/ 
	index?:number,

	/**（可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 Window 或 Frame 滚动*/ 
	fixed?:boolean,

}

interface UIChatField {
	/** 打开聊天输入框*/ 
	open(callback?: (ret:JSON) => void):void

	/** 设置工具条监听事件*/ 
	setToolbarListener():void

	/**
	 * `更新礼物信息（在群聊情况下选择群成员返回后可使用该方法更新头像及昵称）`
	 * ========params==========
	 *
	 * `avaterPath` :string : （可选项）送礼人的头像(支持 widget:// & fs://)
	 *
	 * `nickText` :string : （可选项）收礼人的昵称
	 */
	updateGiftInfo(params:UIChatField_updateGiftInfo_Params):void

	/** 关闭聊天输入框*/ 
	close():void

	/** 显示聊天输入框*/ 
	show():void

	/** 隐藏聊天输入框*/ 
	hide():void

	/** 弹出键盘*/ 
	popupKeyboard():void

	/** 收起键盘*/ 
	closeKeyboard():void

	/** 收起录音面板*/ 
	hideRecordPanel():void

	/**
	 * `获取或设置聊天输入框的内容`
	 * ========params==========
	 *
	 * `msg` :string : （可选项）聊天输入框的内容，若不传则返回输入框的值
	 */
	value(params:UIChatField_value_Params, callback?: (ret:JSON) => void):void

	/**
	 * `向聊天输入框的指定位置插入内容`
	 * ========params==========
	 *
	 * `index` :number : （可选项）待插入内容的起始位置。**注意：中文，全角符号均占一个字符长度；索引从0开始，0表示插入到最前面，1表示插入到第一个字符后面，2表示插入到第二个字符后面，以此类推。**
	 *
	 * `msg` :string : （可选项）要插入的内容
	 */
	insertValue(params:UIChatField_insertValue_Params):void

	/**
	 * `添加输入框相关事件的监听`
	 * ========params==========
	 *
	 * `name` :string : 监听的事件类型
	 */
	chatBoxListener(params:UIChatField_chatBoxListener_Params, callback?: (ret:JSON) => void):void

	/** 清空输入框文本*/ 
	clearText():void

	/** 重置模块*/ 
	reset():void

	/** 显示礼物面板*/ 
	showGiftPanel():void

	/** 获取当前可见的panel*/ 
	getCurrentVisiblePanel():void

	/** 设置所有按钮可用/不可用*/ 
	setEnableAllBtns():void

	/** 取消录音*/ 
	cancelRecord():void

	/** 点击遮罩层事件监听*/ 
	addMaskViewClickListener():void

}
interface UIChatField_updateGiftInfo_Params {
	/**（可选项）送礼人的头像(支持 widget:// & fs://)*/ 
	avaterPath?:string,

	/**（可选项）收礼人的昵称*/ 
	nickText?:string,

}

interface UIChatField_value_Params {
	/**（可选项）聊天输入框的内容，若不传则返回输入框的值*/ 
	msg?:string,

}

interface UIChatField_insertValue_Params {
	/**（可选项）待插入内容的起始位置。**注意：中文，全角符号均占一个字符长度；索引从0开始，0表示插入到最前面，1表示插入到第一个字符后面，2表示插入到第二个字符后面，以此类推。***/ 
	index?:number,

	/**（可选项）要插入的内容*/ 
	msg?:string,

}

interface UIChatField_chatBoxListener_Params {
	/**监听的事件类型*/ 
	name:string,

}

interface UIListEdit {
	/**
	 * `打开 UIListEdit 模块`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `data` :Array : 列表的数据源，**开发者可以自定义唯一的键值对信息（如：uid: '1001'），供 getIndex 使用**
	 *
	 * `topData` :JSON : （可选项）列表顶部的数据源
	 *
	 * `rightBtns` :Array : （可选项）列表项向左滑动露出的按钮组，**建议：配置列表每项的通用按钮，用此参数；配置某一项的特定按钮，可在 `data` 数组的指定项传入 `rightBtns` 参数**
	 *
	 * `bounces` :boolean : （可选项）是否开启弹动，android 平台不支持本参数
	 *
	 * `styles` :string : （可选项）模块各部分的样式
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `showScrollBar` :boolean : （可选项）是否显示滚动条
	 */
	open(params:UIListEdit_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭数据列表模块*/ 
	close():void

	/** 显示 UIListEdit 模块*/ 
	show():void

	/** 隐藏 UIListEdit 模块*/ 
	hide():void

	/** 隐藏顶部分组的内容*/ 
	cancelTopData():void

	/**
	 * `重新设置列表顶部分组数据`
	 * ========params==========
	 *
	 * `topData` :JSON : （可选项）列表顶部的数据源
	 */
	resetTopData(params:UIListEdit_resetTopData_Params):void

	/**
	 * `重新设置列表项向左滑动露出的按钮组（如果有顶部分组，则不包含这一部分）`
	 * ========params==========
	 *
	 * `rightBtns` :Array : （可选项）列表项向左滑动露出的按钮组
	 */
	resetRightBtn(params:UIListEdit_resetRightBtn_Params):void

	/**
	 * `根据开发者自定义的唯一标识（open 接口的 data 参数中自定义的唯一标识）查找列表项对应的数据`
	 * ========params==========
	 *
	 * `key` :string : 调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 key
	 *
	 * `value` :string : 调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 value
	 */
	getIndex(params:UIListEdit_getIndex_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据列表项的索引获取对应的数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）列表项的索引
	 */
	getDataByIndex(params:UIListEdit_getDataByIndex_Params, callback?: (ret:JSON) => void):void

	/**
	 * `设置侧滑显示出来的按钮`
	 * ========params==========
	 *
	 * `index` :number : （可选项）列表项的索引
	 *
	 * `btns` :Array : （可选项）列表项侧滑露出的按钮组
	 */
	setSwipeBtns(params:UIListEdit_setSwipeBtns_Params, callback?: (ret:JSON) => void):void

	/**
	 * `刷新列表数据`
	 * ========params==========
	 *
	 * `data` :Array : （可选项）列表的数据源，**若不传或传空，仅收起下拉刷新组件**
	 */
	reloadData(params:UIListEdit_reloadData_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引删除某一条列表的数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）数据列表的索引
	 */
	deleteItem(params:UIListEdit_deleteItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引更新某一条列表的数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）数据列表的索引
	 *
	 * `data` :JSON : 列表的数据源
	 */
	updateItem(params:UIListEdit_updateItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引向某一条列表插入数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）数据列表的索引
	 *
	 * `data` :JSON : 列表的数据源
	 */
	insertItem(params:UIListEdit_insertItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `向列表末端追加数据`
	 * ========params==========
	 *
	 * `data` :Array : 列表的数据源，**若不传或传空，仅收起上拉加载组件**
	 */
	appendData(params:UIListEdit_appendData_Params, callback?: (ret:JSON) => void):void

	/** 获取当前列表的总数据量*/ 
	getCount():void

	/** 设置列表模式*/ 
	setListMode():void

	/** 获取列表模式*/ 
	getListMode():void

	/** 获取选中的项的索引*/ 
	getSelectedIndexs():void

	/**
	 * `设置下拉刷新，**通过 reloadData 收起下拉刷新组件**`
	 * ========params==========
	 *
	 * `loadingImg` :string : 下拉刷新时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）
	 *
	 * `bgColor` :string : （可选项）下拉刷新区域的背景色，支持 rgb、rgba、#
	 *
	 * `textColor` :string : （可选项）提示文字颜色，支持 rgb、rgba、#
	 *
	 * `textDown` :string : （可选项）下拉提示文字
	 *
	 * `textUp` :string : （可选项）松开提示文字
	 *
	 * `loadingText` :string : （可选项）提示文字
	 *
	 * `lastUpdateText` :string : （可选项）提示文字
	 *
	 * `showTime` :boolean : （可选项）是否显示刷新时间
	 */
	setRefreshHeader(params:UIListEdit_setRefreshHeader_Params):void

	/**
	 * `设置上拉加载，**通过 appendData 收起上拉加载组件**`
	 * ========params==========
	 *
	 * `loadingImg` :string : 上拉加载时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）
	 *
	 * `bgColor` :string : （可选项）上拉加载区域的背景色，支持 rgb、rgba、#
	 *
	 * `textColor` :string : （可选项）提示文字颜色，支持 rgb、rgba、#
	 *
	 * `textUp` :string : （可选项）上拉提示文字
	 *
	 * `textDown` :string : （可选项）松开提示文字
	 *
	 * `loadingText` :string : （可选项）提示文字
	 *
	 * `lastUpdateText` :string : （可选项）提示文字
	 *
	 * `showTime` :boolean : （可选项）是否显示刷新时间
	 */
	setRefreshFooter(params:UIListEdit_setRefreshFooter_Params):void

	/**
	 * `重新设置列表位置大小及样式`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `styles` :string : （可选项）模块各部分的样式
	 */
	reset(params:UIListEdit_reset_Params):void

	/** 全选*/ 
	allSelected():void

	/** 取消全选全选*/ 
	cancleSelected():void

}
interface UIListEdit_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**列表的数据源，**开发者可以自定义唯一的键值对信息（如：uid: '1001'），供 getIndex 使用***/ 
	data:Array,

	/**（可选项）列表顶部的数据源*/ 
	topData?:JSON,

	/**（可选项）列表项向左滑动露出的按钮组，**建议：配置列表每项的通用按钮，用此参数；配置某一项的特定按钮，可在 `data` 数组的指定项传入 `rightBtns` 参数***/ 
	rightBtns?:Array,

	/**（可选项）是否开启弹动，android 平台不支持本参数*/ 
	bounces?:boolean,

	/**（可选项）模块各部分的样式*/ 
	styles?:string,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）是否显示滚动条*/ 
	showScrollBar?:boolean,

}

interface UIListEdit_resetTopData_Params {
	/**（可选项）列表顶部的数据源*/ 
	topData?:JSON,

}

interface UIListEdit_resetRightBtn_Params {
	/**（可选项）列表项向左滑动露出的按钮组*/ 
	rightBtns?:Array,

}

interface UIListEdit_getIndex_Params {
	/**调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 key*/ 
	key:string,

	/**调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 value*/ 
	value:string,

}

interface UIListEdit_getDataByIndex_Params {
	/**（可选项）列表项的索引*/ 
	index?:number,

}

interface UIListEdit_setSwipeBtns_Params {
	/**（可选项）列表项的索引*/ 
	index?:number,

	/**（可选项）列表项侧滑露出的按钮组*/ 
	btns?:Array,

}

interface UIListEdit_reloadData_Params {
	/**（可选项）列表的数据源，**若不传或传空，仅收起下拉刷新组件***/ 
	data?:Array,

}

interface UIListEdit_deleteItem_Params {
	/**（可选项）数据列表的索引*/ 
	index?:number,

}

interface UIListEdit_updateItem_Params {
	/**（可选项）数据列表的索引*/ 
	index?:number,

	/**列表的数据源*/ 
	data:JSON,

}

interface UIListEdit_insertItem_Params {
	/**（可选项）数据列表的索引*/ 
	index?:number,

	/**列表的数据源*/ 
	data:JSON,

}

interface UIListEdit_appendData_Params {
	/**列表的数据源，**若不传或传空，仅收起上拉加载组件***/ 
	data:Array,

}

interface UIListEdit_setRefreshHeader_Params {
	/**下拉刷新时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）*/ 
	loadingImg:string,

	/**（可选项）下拉刷新区域的背景色，支持 rgb、rgba、#*/ 
	bgColor?:string,

	/**（可选项）提示文字颜色，支持 rgb、rgba、#*/ 
	textColor?:string,

	/**（可选项）下拉提示文字*/ 
	textDown?:string,

	/**（可选项）松开提示文字*/ 
	textUp?:string,

	/**（可选项）提示文字*/ 
	loadingText?:string,

	/**（可选项）提示文字*/ 
	lastUpdateText?:string,

	/**（可选项）是否显示刷新时间*/ 
	showTime?:boolean,

}

interface UIListEdit_setRefreshFooter_Params {
	/**上拉加载时显示的小箭头图标的本地路径，要求本地路径（fs://、widget://）*/ 
	loadingImg:string,

	/**（可选项）上拉加载区域的背景色，支持 rgb、rgba、#*/ 
	bgColor?:string,

	/**（可选项）提示文字颜色，支持 rgb、rgba、#*/ 
	textColor?:string,

	/**（可选项）上拉提示文字*/ 
	textUp?:string,

	/**（可选项）松开提示文字*/ 
	textDown?:string,

	/**（可选项）提示文字*/ 
	loadingText?:string,

	/**（可选项）提示文字*/ 
	lastUpdateText?:string,

	/**（可选项）是否显示刷新时间*/ 
	showTime?:boolean,

}

interface UIListEdit_reset_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**（可选项）模块各部分的样式*/ 
	styles?:string,

}

interface ruler {
	/**
	 * `打开尺子`
	 * ========params==========
	 *
	 * `rect` :JSON : （必填项）模块的位置及尺寸
	 *
	 * `fixedOn` :string : （可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 Window 或 Frame 滚动
	 *
	 * `rulerCount` :number : （可选项）尺子的总刻度
	 *
	 * `currentValue` :number : （可选项）尺子的当前刻度值
	 */
	openRuler(params:ruler_openRuler_Params, callback?: (ret:JSON) => void):void

	/**
	 * `隐藏尺子`
	 * ========params==========
	 *
	 * `index` :number : （可选项）刻度尺视图序号
	 */
	hideRuler(params:ruler_hideRuler_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `显示尺子`
	 * ========params==========
	 *
	 * `index` :number : （可选项）刻度尺视图序号
	 */
	showRuler(params:ruler_showRuler_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `关闭尺子`
	 * ========params==========
	 *
	 * `index` :number : （可选项）刻度尺视图序号
	 */
	closeRuler(params:ruler_closeRuler_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface ruler_openRuler_Params {
	/**（必填项）模块的位置及尺寸*/ 
	rect:JSON,

	/**（可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 Window 或 Frame 滚动*/ 
	fixed?:boolean,

	/**（可选项）尺子的总刻度*/ 
	rulerCount?:number,

	/**（可选项）尺子的当前刻度值*/ 
	currentValue?:number,

}

interface ruler_hideRuler_Params {
	/**（可选项）刻度尺视图序号*/ 
	index?:number,

}

interface ruler_showRuler_Params {
	/**（可选项）刻度尺视图序号*/ 
	index?:number,

}

interface ruler_closeRuler_Params {
	/**（可选项）刻度尺视图序号*/ 
	index?:number,

}

interface keyboardView {
	/**
	 * `设置键盘顶部按钮监听事件`
	 * ========params==========
	 *
	 * `height` :number : （可选项）键盘顶部按钮布局高度。
	 *
	 * `backgroundColor` :string : （可选项）顶部布局背景颜色代码。
	 *
	 * `lineColor` :string : （可选项）顶部横线颜色代码。
	 *
	 * `data` :Array : （必填项）顶部按钮id和图标
	 */
	addKeyboardListener(params:keyboardView_addKeyboardListener_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 移除键盘顶部按钮监听事件*/ 
	removeKeyboardListener(callback?: (ret:JSON, err:JSON) => void):void

}
interface keyboardView_addKeyboardListener_Params {
	/**（可选项）键盘顶部按钮布局高度。*/ 
	height?:number,

	/**（可选项）顶部布局背景颜色代码。*/ 
	backgroundColor?:string,

	/**（可选项）顶部横线颜色代码。*/ 
	lineColor?:string,

	/**（必填项）顶部按钮id和图标*/ 
	data:Array,

}

interface kLineChart {
	/** 在指定位置创建一个自定义的View，用于绘制K线图，默认打开loading状态*/ 
	createView(callback?: (ret:JSON) => void):void

	/** 添加数据*/ 
	addFooterData():void

	/** 确认数据加载完成，取消loading状态。在addFooterData调用后调用此方法。*/ 
	loadComplete():void

	/** 确认数据加载完成，取消loading状态。在addFooterData调用后调用此方法。*/ 
	loadEnd():void

}
interface graph {
}
interface UIDatePicker {
	/**
	 * `打开选择器`
	 * ========params==========
	 *
	 * `type` :string : 选择器类型
	 *
	 * `date` :string : （可选项）设置当前时间，格式yyyy-MM-dd HH:mm:ss
	 *
	 * `minDate` :string : （可选项）能够选择的最小时间，格式yyyy-MM-dd HH:mm:ss
	 *
	 * `maxDate` :string : （可选项）能够选择的最大时间，格式yyyy-MM-dd HH:mm:ss
	 *
	 * `title` :string : （可选项）显示在选择器上面的标题；
	 *
	 * `titleStyle` :null : null
	 *
	 * `titleImage` :string : （可选项）显示在选择器上面的标题图片，支持widget://，fs://；与title互斥，只能存在一个
	 *
	 * `rowHeight` :number : （可选项）设置选择器的行高
	 *
	 * `styles` :JSON : （可选项）模块各部分的样式
	 *
	 * `cyclic` :boolean : （可选项）是否可循环滑动
	 *
	 * `hideIndicator` :boolean : （可选项）是否隐藏单位（年月日时分秒）
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	open(params:UIDatePicker_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭选择器*/ 
	close():void

	/** 隐藏选择器*/ 
	hide():void

	/** 显示已隐藏的选择器*/ 
	show():void

}
interface UIDatePicker_open_Params {
	/**选择器类型*/ 
	type:string,

	/**（可选项）设置当前时间，格式yyyy-MM-dd HH:mm:ss*/ 
	date?:string,

	/**（可选项）能够选择的最小时间，格式yyyy-MM-dd HH:mm:ss*/ 
	minDate?:string,

	/**（可选项）能够选择的最大时间，格式yyyy-MM-dd HH:mm:ss*/ 
	maxDate?:string,

	/**（可选项）显示在选择器上面的标题；*/ 
	title?:string,

	/**null*/ 
	titleStyle:null,

	/**（可选项）显示在选择器上面的标题图片，支持widget://，fs://；与title互斥，只能存在一个*/ 
	titleImage?:string,

	/**（可选项）设置选择器的行高*/ 
	rowHeight?:number,

	/**（可选项）模块各部分的样式*/ 
	styles?:JSON,

	/**（可选项）是否可循环滑动*/ 
	cyclic?:boolean,

	/**（可选项）是否隐藏单位（年月日时分秒）*/ 
	hideIndicator?:boolean,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface customToast {
}
interface goodAd {
	/** 启动页广告*/ 
	launch(callback?: (ret:JSON) => void):void

	/** 广告展示窗*/ 
	dialog():void

	/** 初始化穿山甲广告 appId 应用id*/ 
	initTTAd():void

	/** 穿山甲开屏广告*/ 
	addTTSplashAd():void

	/** 移除广告开屏广告*/ 
	removeTTSplashAd():void

	/** 穿山甲Banner广告*/ 
	addTTBannerAd():void

	/** 移除穿山甲Banner广告*/ 
	removeTTBannerAd():void

}
interface waterBallProgress {
	/**
	 * `打开进度指示器`
	 * ========params==========
	 *
	 * `rect` :number : （可选项）模块位置和大小配置，若不传则取内部字段默认值
	 *
	 * `ball` :JSON : （可选项）中间水球样式配置，若不传则取内部字段默认值
	 *
	 * `annulus` :JSON : （可选项）外部环形样式配置，若不传则不显示外部环形
	 *
	 * `labels` :Array : （可选项）加载指示器上的提示文字配置，若不传则不显示，本参数为一个数组，可配置显示多个提示文字
	 *
	 * `progress` :number : （可选项）当前的进度，取值范围：0-100
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : 是否将模块视图固定到窗口上，不跟随窗口上下滚动，可为空
	 */
	open(params:waterBallProgress_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭模块*/ 
	close():void

	/** 隐藏已经打开并显示的模块，并未从内存里清除*/ 
	hide():void

	/** 显示已隐藏的模块*/ 
	show():void

	/**
	 * `设置进度值及提示文字`
	 * ========params==========
	 *
	 * `progress` :number : （可选项）设置的值
	 *
	 * `labels` :Array : （可选项）加载指示器上的提示文字更新，若不传则不显示，本参数为一个数组，可配置显示多个提示文字，起顺序与 open 接口内的 labels 一一对应，若为空则保持原值不变
	 */
	setProgress(params:waterBallProgress_setProgress_Params):void

}
interface waterBallProgress_open_Params {
	/**（可选项）模块位置和大小配置，若不传则取内部字段默认值*/ 
	rect?:number,

	/**（可选项）中间水球样式配置，若不传则取内部字段默认值*/ 
	ball?:JSON,

	/**（可选项）外部环形样式配置，若不传则不显示外部环形*/ 
	annulus?:JSON,

	/**（可选项）加载指示器上的提示文字配置，若不传则不显示，本参数为一个数组，可配置显示多个提示文字*/ 
	labels?:Array,

	/**（可选项）当前的进度，取值范围：0-100*/ 
	progress?:number,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**是否将模块视图固定到窗口上，不跟随窗口上下滚动，可为空*/ 
	fixed:boolean,

}

interface waterBallProgress_setProgress_Params {
	/**（可选项）设置的值*/ 
	progress?:number,

	/**（可选项）加载指示器上的提示文字更新，若不传则不显示，本参数为一个数组，可配置显示多个提示文字，起顺序与 open 接口内的 labels 一一对应，若为空则保持原值不变*/ 
	labels?:Array,

}

interface mwChatView {
	/**
	 * `打开`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `data` :Array : 列表的数据源，**开发者可以自定义唯一的键值对信息（如：uid: '1001'），供 getIndex 使用**
	 *
	 * `styles` :string : （可选项）模块各部分的样式。 **注：BubbleImage 为必传项且所指路径不能为空**
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `showScrollBar` :boolean : （可选项）是否显示滚动条
	 */
	open(params:mwChatView_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭数据列表模块*/ 
	close():void

	/** 显示*/ 
	show():void

	/** 隐藏*/ 
	hide():void

	/**
	 * `根据开发者自定义的唯一标识（open 接口的 data 参数中自定义的唯一标识）查找列表项对应的数据`
	 * ========params==========
	 *
	 * `key` :string : 调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 key
	 *
	 * `value` :string : 调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 value
	 */
	getIndex(params:mwChatView_getIndex_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据列表项的索引获取对应的数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）列表项的索引
	 */
	getDataByIndex(params:mwChatView_getDataByIndex_Params, callback?: (ret:JSON) => void):void

	/**
	 * `刷新列表数据`
	 * ========params==========
	 *
	 * `data` :Array : （可选项）列表的数据源，**若不传或传空，仅收起下拉刷新组件**
	 */
	reloadData(params:mwChatView_reloadData_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引删除某一条列表的数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）数据列表的索引
	 */
	deleteItem(params:mwChatView_deleteItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引更新某一条列表的数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）数据列表的索引
	 *
	 * `data` :JSON : 列表的数据源
	 */
	updateItem(params:mwChatView_updateItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引向某一条列表插入数据  注:**当index为0时顶部填充数据**`
	 * ========params==========
	 *
	 * `index` :number : （可选项）数据列表的索引
	 *
	 * `animation` :boolean : （可选项）是否展示动画
	 *
	 * `data` :Array<JSON> : 列表的数据源
	 */
	insertItem(params:mwChatView_insertItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `向列表末端追加数据`
	 * ========params==========
	 *
	 * `forceScrollToBottom` :boolean : （可选项）true 强制滚动到底部，false，如果列表已经在最底部会继续滚动，如果列表在其他位置则不滚动
	 *
	 * `data` :Array : 列表的数据源，**若不传或传空，仅收起上拉加载组件**
	 */
	appendData(params:mwChatView_appendData_Params, callback?: (ret:JSON) => void):void

	/**
	 * `滚动到对应索引位置`
	 * ========params==========
	 *
	 * `index` :number : （可选项）数据列表的索引
	 *
	 * `y` :number : （可选项）模块的纵坐标
	 *
	 * `h` :number : （可选项）模块的高度
	 *
	 * `marginBottom` :number : （可选项）模块底部间距
	 */
	scrollToIndex(params:mwChatView_scrollToIndex_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface mwChatView_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**列表的数据源，**开发者可以自定义唯一的键值对信息（如：uid: '1001'），供 getIndex 使用***/ 
	data:Array,

	/**（可选项）模块各部分的样式。 **注：BubbleImage 为必传项且所指路径不能为空***/ 
	styles?:string,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）是否显示滚动条*/ 
	showScrollBar?:boolean,

}

interface mwChatView_getIndex_Params {
	/**调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 key*/ 
	key:string,

	/**调用 open 接口时，data 参数传入的开发者自定义的唯一标识的 value*/ 
	value:string,

}

interface mwChatView_getDataByIndex_Params {
	/**（可选项）列表项的索引*/ 
	index?:number,

}

interface mwChatView_reloadData_Params {
	/**（可选项）列表的数据源，**若不传或传空，仅收起下拉刷新组件***/ 
	data?:Array,

}

interface mwChatView_deleteItem_Params {
	/**（可选项）数据列表的索引*/ 
	index?:number,

}

interface mwChatView_updateItem_Params {
	/**（可选项）数据列表的索引*/ 
	index?:number,

	/**列表的数据源*/ 
	data:JSON,

}

interface mwChatView_insertItem_Params {
	/**（可选项）数据列表的索引*/ 
	index?:number,

	/**（可选项）是否展示动画*/ 
	animation?:boolean,

	/**列表的数据源*/ 
	data:Array<JSON>,

}

interface mwChatView_appendData_Params {
	/**（可选项）true 强制滚动到底部，false，如果列表已经在最底部会继续滚动，如果列表在其他位置则不滚动*/ 
	forceScrollToBottom?:boolean,

	/**列表的数据源，**若不传或传空，仅收起上拉加载组件***/ 
	data:Array,

}

interface mwChatView_scrollToIndex_Params {
	/**（可选项）数据列表的索引*/ 
	index?:number,

	/**（可选项）模块的纵坐标*/ 
	y?:number,

	/**（可选项）模块的高度*/ 
	h?:number,

	/**（可选项）模块底部间距*/ 
	marginBottom?:number,

}

interface coverFlow {
}
interface photoBrowserTouTiaoPlus {
	/**
	 * `打开图文信息模块`
	 * ========params==========
	 *
	 * `hidden` :JSON : （可选项）界面元素的隐藏显示属性配置，默认值见内部字段
	 *
	 * `textStyles` :JSON : （可选项）图片描述样式配置，若不传则描述文字按照1.0.0方式显示
	 */
	open(params:photoBrowserTouTiaoPlus_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `设置模块数据`
	 * ========params==========
	 *
	 * `images` :Array : 图片路径数组数据，支持 fs://，以及网络路径 http://，https://
	 *
	 * `texts` :Array : （可选项）描述数据
	 *
	 * `publisher` :string : （可选项）发布者按钮图标，位于头部右侧从右数第二个按钮。支持 widget://、fs://、http://、https:// 路径格式的图片。
	 *
	 * `comment` :number : （可选项）评论角标数值，值为 0 时角标无效
	 *
	 * `favorite` :boolean : （可选项）收藏状态，值为 true 时显示 active 指定的图标。
	 */
	setData(params:photoBrowserTouTiaoPlus_setData_Params):void

	/** 清除缓存到本地的网络图片，**本接口只清除本模块缓存的数据，若要清除本 app 缓存的所有数据则调用 api.clearCache***/ 
	clearCache():void

}
interface photoBrowserTouTiaoPlus_open_Params {
	/**（可选项）界面元素的隐藏显示属性配置，默认值见内部字段*/ 
	hidden?:JSON,

	/**（可选项）图片描述样式配置，若不传则描述文字按照1.0.0方式显示*/ 
	textStyles?:JSON,

}

interface photoBrowserTouTiaoPlus_setData_Params {
	/**图片路径数组数据，支持 fs://，以及网络路径 http://，https://*/ 
	images:Array,

	/**（可选项）描述数据*/ 
	texts?:Array,

	/**（可选项）发布者按钮图标，位于头部右侧从右数第二个按钮。支持 widget://、fs://、http://、https:// 路径格式的图片。*/ 
	publisher?:string,

	/**（可选项）评论角标数值，值为 0 时角标无效*/ 
	comment?:number,

	/**（可选项）收藏状态，值为 true 时显示 active 指定的图标。*/ 
	favorite?:boolean,

}

interface personalCenter {
	/**
	 * `打开个人中心`
	 * ========params==========
	 *
	 * `y ` :number : （可选项）个人中心视图上边距屏幕位置
	 *
	 * `h ` :number : （可选项）视图的高，不可小于220
	 *
	 * `imgPath` :string : 头像图片的路径（如果为网络路径,图片会被缓存到本地），支持http，https，widget，file，fs协议
	 *
	 * `placeholderImg` :string : （可选项）头像占位图片的路径，支持仅widget，file，fs本地协议
	 *
	 * `userName ` :string : （可选项）用户名
	 *
	 * `userNameSize ` :number : （可选项）用户名字体大小
	 *
	 * `userColor` :string : （可选项）用户名和积分字体颜色
	 *
	 * `subTitle ` :string : （可选项）用户名下边的小标题
	 *
	 * `subTitleSize ` :string : （可选项）用户名下边的小标题字体大小
	 *
	 * `subTitleColor` :string : （可选项）用户名下边的小标题字体颜色
	 *
	 * `showLeftBtn` :boolean : （可选项）是否显示左上交修改按钮
	 *
	 * `showRightBtn` :boolean : （可选项）是否显示右上角设置按钮
	 *
	 * `buttonTitle` :JSON : （可选项）顶部两边按钮的标题文字，当 showLeftBtn、showRightBtn 为 true 时本参数有效
	 *
	 * `modButton` :JSON : （可选项）修改按钮参数
	 *
	 * `btnArray` :Array : （可选项）下边按钮的参数信息
	 *
	 * `clearBtn` :boolean : （可选项）是否将个人中心下边按钮清除
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	open(params:personalCenter_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `刷新个人中心显示数据`
	 * ========params==========
	 *
	 * `userName ` :string : （可选项）用户名
	 *
	 * `subTile ` :string : (可选项)用户名下的小标题
	 *
	 * `imgPath` :string : (可选项)头像地址，若为不传则不刷新
	 *
	 * `btnArray` :Array : （可选项）下边按钮显示的数据，不传则不刷新
	 */
	updateValue(params:personalCenter_updateValue_Params):void

	/** 关闭个人中心*/ 
	close():void

	/** 设置选中按钮*/ 
	setSelect():void

	/** 显示个人中心*/ 
	show():void

	/** 隐藏个人中心*/ 
	hide():void

}
interface personalCenter_open_Params {
	/**（可选项）个人中心视图上边距屏幕位置*/ 
	y ?:number,

	/**（可选项）视图的高，不可小于220*/ 
	h ?:number,

	/**头像图片的路径（如果为网络路径,图片会被缓存到本地），支持http，https，widget，file，fs协议*/ 
	imgPath:string,

	/**（可选项）头像占位图片的路径，支持仅widget，file，fs本地协议*/ 
	placeholderImg?:string,

	/**（可选项）用户名*/ 
	userName ?:string,

	/**（可选项）用户名字体大小*/ 
	userNameSize ?:number,

	/**（可选项）用户名和积分字体颜色*/ 
	userColor?:string,

	/**（可选项）用户名下边的小标题*/ 
	subTitle ?:string,

	/**（可选项）用户名下边的小标题字体大小*/ 
	subTitleSize ?:string,

	/**（可选项）用户名下边的小标题字体颜色*/ 
	subTitleColor?:string,

	/**（可选项）是否显示左上交修改按钮*/ 
	showLeftBtn?:boolean,

	/**（可选项）是否显示右上角设置按钮*/ 
	showRightBtn?:boolean,

	/**（可选项）顶部两边按钮的标题文字，当 showLeftBtn、showRightBtn 为 true 时本参数有效*/ 
	buttonTitle?:JSON,

	/**（可选项）修改按钮参数*/ 
	modButton?:JSON,

	/**（可选项）下边按钮的参数信息*/ 
	btnArray?:Array,

	/**（可选项）是否将个人中心下边按钮清除*/ 
	clearBtn?:boolean,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface personalCenter_updateValue_Params {
	/**（可选项）用户名*/ 
	userName ?:string,

	/**(可选项)用户名下的小标题*/ 
	subTile ?:string,

	/**(可选项)头像地址，若为不传则不刷新*/ 
	imgPath?:string,

	/**（可选项）下边按钮显示的数据，不传则不刷新*/ 
	btnArray?:Array,

}

interface UIListGoods {
	/**
	 * `打开 模块`
	 * ========params==========
	 *
	 * `rect` :JSON : （可选项）模块的位置及尺寸
	 *
	 * `data` :Array : 列表的数据源，
	 *
	 * `bounces` :boolean : （可选项）是否开启弹动，android 平台不支持本参数
	 *
	 * `styles` :JSON : （可选项）模块各部分的样式
	 *
	 * `backgroundColor` :string : （可选项）模块的背景色，支持 rgb，rgba，#
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `showScrollBar` :boolean : （可选项）是否显示滚动条
	 */
	open(params:UIListGoods_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭数据列表模块*/ 
	close():void

	/** 显示 UIListView 模块*/ 
	show():void

	/** 隐藏 UIListView 模块*/ 
	hide():void

	/**
	 * `刷新列表数据`
	 * ========params==========
	 *
	 * `data` :Array : （可选项）列表的数据源
	 */
	reloadData(params:UIListGoods_reloadData_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引更新某一条列表的数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）数据列表的索引
	 *
	 * `data` :JSON : 列表的数据源
	 */
	updateItem(params:UIListGoods_updateItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据索引向某一条列表插入数据`
	 * ========params==========
	 *
	 * `index` :number : （可选项）数据列表的索引
	 *
	 * `data` :JSON : 列表的数据源
	 */
	insertItem(params:UIListGoods_insertItem_Params, callback?: (ret:JSON) => void):void

	/**
	 * `向列表末端追加数据`
	 * ========params==========
	 *
	 * `data` :Array : 列表的数据源
	 */
	appendData(params:UIListGoods_appendData_Params, callback?: (ret:JSON) => void):void

}
interface UIListGoods_open_Params {
	/**（可选项）模块的位置及尺寸*/ 
	rect?:JSON,

	/**列表的数据源，*/ 
	data:Array,

	/**（可选项）是否开启弹动，android 平台不支持本参数*/ 
	bounces?:boolean,

	/**（可选项）模块各部分的样式*/ 
	styles?:JSON,

	/**（可选项）模块的背景色，支持 rgb，rgba，#*/ 
	backgroundColor?:string,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）是否显示滚动条*/ 
	showScrollBar?:boolean,

}

interface UIListGoods_reloadData_Params {
	/**（可选项）列表的数据源*/ 
	data?:Array,

}

interface UIListGoods_updateItem_Params {
	/**（可选项）数据列表的索引*/ 
	index?:number,

	/**列表的数据源*/ 
	data:JSON,

}

interface UIListGoods_insertItem_Params {
	/**（可选项）数据列表的索引*/ 
	index?:number,

	/**列表的数据源*/ 
	data:JSON,

}

interface UIListGoods_appendData_Params {
	/**列表的数据源*/ 
	data:Array,

}

interface photoBrowserTouTiao {
	/**
	 * `打开图文信息模块`
	 * ========params==========
	 *
	 * `hidden` :JSON : （可选项）界面元素的隐藏显示属性配置，默认值见内部字段
	 *
	 * `textStyles` :JSON : （可选项）图片描述样式配置，若不传则描述文字按照1.0.0方式显示
	 */
	open(params:photoBrowserTouTiao_open_Params, callback?: (ret:JSON) => void):void

	/**
	 * `设置模块数据`
	 * ========params==========
	 *
	 * `images` :Array : 图片路径数组数据，支持 fs://，以及网络路径 http://，https://
	 *
	 * `texts` :Array : （可选项）描述数据
	 *
	 * `publisher` :string : （可选项）发布者按钮图标，位于头部右侧从右数第二个按钮。支持 widget://、fs://、http://、https:// 路径格式的图片。
	 *
	 * `comment` :number : （可选项）评论角标数值，值为 0 时角标无效
	 *
	 * `favorite` :boolean : （可选项）收藏状态，值为 true 时显示 active 指定的图标。
	 */
	setData(params:photoBrowserTouTiao_setData_Params):void

	/** 清除缓存到本地的网络图片，**本接口只清除本模块缓存的数据，若要清除本 app 缓存的所有数据则调用 api.clearCache***/ 
	clearCache():void

	/** 刷新界面接口，本接口仅支持 ios 平台*/ 
	refreshUI():void

}
interface photoBrowserTouTiao_open_Params {
	/**（可选项）界面元素的隐藏显示属性配置，默认值见内部字段*/ 
	hidden?:JSON,

	/**（可选项）图片描述样式配置，若不传则描述文字按照1.0.0方式显示*/ 
	textStyles?:JSON,

}

interface photoBrowserTouTiao_setData_Params {
	/**图片路径数组数据，支持 fs://，以及网络路径 http://，https://*/ 
	images:Array,

	/**（可选项）描述数据*/ 
	texts?:Array,

	/**（可选项）发布者按钮图标，位于头部右侧从右数第二个按钮。支持 widget://、fs://、http://、https:// 路径格式的图片。*/ 
	publisher?:string,

	/**（可选项）评论角标数值，值为 0 时角标无效*/ 
	comment?:number,

	/**（可选项）收藏状态，值为 true 时显示 active 指定的图标。*/ 
	favorite?:boolean,

}

interface cityList {
}
interface moduleScanCode {
	/** 绑定一个服务*/ 
	bindScannerService(callback?: (ret:JSON) => void):void

	/** 注册一个广播用来接收扫描到的条码值*/ 
	registerReceiver(callback?: (ret:JSON) => void):void

	/** 开启手持的红外线扫描头*/ 
	startScanner(callback?: (ret:JSON) => void):void

	/** 关闭手持的红外线扫描头*/ 
	stopScanner(callback?: (ret:JSON) => void):void

}
interface cxgBluetoothSerial {
	/** 获取当前的蓝牙状态*/ 
	isEnabledBluetooth(callback?: (ret:JSON, err:JSON) => void):void

	/** 打开蓝牙*/ 
	openBluetooth(callback?: (ret:JSON, err:JSON) => void):void

	/** 关闭蓝牙*/ 
	closeBluetooth(callback?: (ret:JSON, err:JSON) => void):void

	/** 监听蓝牙的状态变化， 多次返回*/ 
	listenBluetoothStatus(callback?: (ret:JSON, err:JSON) => void):void

	/** 获取已经配对的设备*/ 
	bondedDevices(callback?: (ret:JSON, err:JSON) => void):void

	/** 是否正在搜索设备*/ 
	isScanning(callback?: (ret:JSON, err:JSON) => void):void

	/** 扫描周边设备*/ 
	scan(callback?: (ret:JSON, err:JSON) => void):void

	/** 停止扫描周边设备*/ 
	stopScan(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `连接到设备`
	 * ========params==========
	 *
	 * `address` :string : 蓝牙设备的地址
	 */
	connect(params:cxgBluetoothSerial_connect_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 断开连接*/ 
	disconnect(callback?: (ret:JSON, err:JSON) => void):void

	/** 获取已经连接的设备*/ 
	connectedDevice(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `发送数据`
	 * ========params==========
	 *
	 * `data` :string : 需要发送的字符串
	 */
	sendData(params:cxgBluetoothSerial_sendData_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `读取数据，多次返回`
	 * ========params==========
	 *
	 * `bufferSize` :number : 数据读取 buffer 的大小, 一般无需设置
	 */
	readData(params:cxgBluetoothSerial_readData_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface cxgBluetoothSerial_connect_Params {
	/**蓝牙设备的地址*/ 
	address:string,

}

interface cxgBluetoothSerial_sendData_Params {
	/**需要发送的字符串*/ 
	data:string,

}

interface cxgBluetoothSerial_readData_Params {
	/**数据读取 buffer 的大小, 一般无需设置*/ 
	bufferSize:number,

}

interface pingModule {
}
interface magnetometer {
	/** 检查设备是否有磁力感应*/ 
	checkUp(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `打开磁力感应`
	 * ========params==========
	 *
	 * `time` :string : （必选）采集信息间隔时间，以秒为单位。
	 */
	startListener(params:magnetometer_startListener_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 关闭磁力感应*/ 
	stopListener():void

}
interface magnetometer_startListener_Params {
	/**（必选）采集信息间隔时间，以秒为单位。*/ 
	time:string,

}

interface androidTouch {
	/** 开始指纹识别*/ 
	touch():void

	/** 取消指纹识别*/ 
	touchCancel():void

}
interface cvVibrate {
	/** Peek振动*/ 
	Peek(callback?: (ret:JSON, err:JSON) => void):void

	/** Pop振动*/ 
	Pop(callback?: (ret:JSON, err:JSON) => void):void

	/** 三次连续振动*/ 
	Three(callback?: (ret:JSON, err:JSON) => void):void

	/** 长振动*/ 
	Long(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `自定义时长振动模式（**仅安卓支持自定义时长振动，IOS是支持自定义时间间歇振动**）`
	 * ========params==========
	 *
	 * `time` :number : （必填项）振动的总时长，到时间后停止振动。
	 */
	Custom(params:cvVibrate_Custom_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 停止振动*/ 
	stopVibrate(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `根据系统SoundID选择播放手机铃声（系统设置静音时不播放铃声）`
	 * ========params==========
	 *
	 * `SoundID` :number : （必填项）系统铃声id。
	 *
	 * `time` :number : （必填项）铃声播放振动的总时长，到时间后停止振动。
	 *
	 * `duration` :number : （选填项）铃声循环间隔，调节循环次数。（time存在时必填项）
	 */
	ringTone(params:cvVibrate_ringTone_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface cvVibrate_Custom_Params {
	/**（必填项）振动的总时长，到时间后停止振动。*/ 
	time:number,

}

interface cvVibrate_ringTone_Params {
	/**（必填项）系统铃声id。*/ 
	SoundID:number,

	/**（必填项）铃声播放振动的总时长，到时间后停止振动。*/ 
	time:number,

	/**（选填项）铃声循环间隔，调节循环次数。（time存在时必填项）*/ 
	duration:number,

}

interface checkproxys {
}
interface lockScreen {
	/** 打开屏幕自动锁屏*/ 
	autoLockScreen(callback?: (ret:JSON, err:JSON) => void):void

	/** 关闭屏幕自动锁屏*/ 
	unlockScreen(callback?: (ret:JSON, err:JSON) => void):void

}
interface level {
	/** 开启*/ 
	start():void

	/** 关闭*/ 
	stop():void

}
interface accelerometer {
	/** 检查设备是否有加速度传感器*/ 
	checkUp(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `打开加速度传感器`
	 * ========params==========
	 *
	 * `time` :string : （必选）采集信息间隔时间，以秒为单位。
	 */
	startListener(params:accelerometer_startListener_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 关闭加速度传感器*/ 
	stopListener():void

}
interface accelerometer_startListener_Params {
	/**（必选）采集信息间隔时间，以秒为单位。*/ 
	time:string,

}

interface BoyFatBle {
	/** 初始化蓝牙4.0管理器*/ 
	initBle():void

	/**
	 * `开始搜索蓝牙4.0设备，当扫描到相应设备后,会自动停止扫描,未扫描到设备若要停止、调用 stopScan 接口`
	 * ========params==========
	 *
	 * `deviceName` :string : (必传)需要扫描的设备名字
	 */
	scan(params:BoyFatBle_scan_Params, callback?: (ret:JSON) => void):void

	/** 判断是否正在扫描*/ 
	isScanning():void

	/** 停止搜索附近的蓝牙设备*/ 
	stopScan():void

	/**
	 * `获取临时体重,获取锁定体重,获取impedance值`
	 * ========params==========
	 *
	 * `scanRecord` :string : 广播数据包数据    **注意:iOS无需此参数**
	 *
	 * `type` :number : 取值为1 或者是2,分别代表TYPE_W62 =1  TYPE_59 =2
	 */
	handleScanRecord(params:BoyFatBle_handleScanRecord_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `返回获取数据`
	 * ========params==========
	 *
	 * `Weight` :number : 体重单位kg
	 *
	 * `Height` :number : 身高单位cm
	 *
	 * `age` :number : 年龄
	 *
	 * `gender` :number : 0 女 1男
	 *
	 * `impedance` :number : impedance
	 */
	invokeLoease(params:BoyFatBle_invokeLoease_Params, callback?: (ret:JSON) => void):void

	/**
	 * `修改称重单位`
	 * ========params==========
	 *
	 * `unit` :number : 称重单位
	 */
	sentCommandToWeightScaleUnit(params:BoyFatBle_sentCommandToWeightScaleUnit_Params, callback?: (ret:JSON) => void):void

}
interface BoyFatBle_scan_Params {
	/**(必传)需要扫描的设备名字*/ 
	deviceName:string,

}

interface BoyFatBle_handleScanRecord_Params {
	/**广播数据包数据    **注意:iOS无需此参数***/ 
	scanRecord:string,

	/**取值为1 或者是2,分别代表TYPE_W62 =1  TYPE_59 =2*/ 
	type:number,

}

interface BoyFatBle_invokeLoease_Params {
	/**体重单位kg*/ 
	Weight:number,

	/**身高单位cm*/ 
	Height:number,

	/**年龄*/ 
	age:number,

	/**0 女 1男*/ 
	gender:number,

	/**impedance*/ 
	impedance:number,

}

interface BoyFatBle_sentCommandToWeightScaleUnit_Params {
	/**称重单位*/ 
	unit:number,

}

interface bluetooth {
}
interface posScanner {
	/** 开始监听扫描枪*/ 
	startListenKeyboardScan():void

	/** 停止扫描枪的监听*/ 
	stopListenKeyboardScan():void

}
interface DVContacts {
	/** 打开系统通讯录界面，选择单个联系人，返回已选的联系人信息*/ 
	openContactsUI():void

	/** 获取所有联系人*/ 
	allContacts():void

	/**
	 * `向通讯录添加一个联系人，所有参数不可同时为空。添加`
	 * ========params==========
	 *
	 * `image` :string : （可选项）联系人头像，支持widget://、fs://
	 *
	 * `lastName` :string : （可选项）联系人姓氏
	 *
	 * `firstName` :string : （可选项）联系人名字
	 *
	 * `middleName` :string : （可选项）联系人中间名
	 *
	 * `prefix` :string : （可选项）联系人名称前缀
	 *
	 * `suffix` :string : （可选项）联系人名称后缀
	 *
	 * `company` :string : （可选项）联系人公司
	 *
	 * `title` :string : （可选项）联系人职位
	 *
	 * `phones` :Array : （可选项）联系人电话组成的数组
	 *
	 * `address` :Array : （可选项）联系人地址
	 *
	 * `url` :Array : （可选项）URL
	 *
	 * `emails` :Array : （可选项）邮箱
	 *
	 * `dates` :Array : （可选项）日期
	 *
	 * `contactRelation` :Array : （可选项）关联人
	 *
	 * `socialProfiles` :Array : （可选项）社交资料
	 *
	 * `instantMessageAddresses` :Array : （可选项）即时信息
	 *
	 * `note` :string : （可选项）联系人备注
	 */
	add(params:DVContacts_add_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `从通讯录删除一个或多个联系人`
	 * ========params==========
	 *
	 * `ids` :Array : 联系人的 id 组成的数组，若传入的 id 不存在，则忽略此id
	 */
	delete(params:DVContacts_delete_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `根据 id 更新通讯录的联系人信息`
	 * ========params==========
	 *
	 * `id` :string : 联系人的id
	 *
	 * `image` :string : （可选项）联系人头像，支持widget://、fs://
	 *
	 * `lastName` :string : （可选项）联系人姓氏
	 *
	 * `firstName` :string : （可选项）联系人名字
	 *
	 * `middleName` :string : （可选项）联系人中间名
	 *
	 * `prefix` :string : （可选项）联系人名称前缀
	 *
	 * `suffix` :string : （可选项）联系人名称后缀
	 *
	 * `company` :string : （可选项）联系人公司
	 *
	 * `title` :string : （可选项）联系人职位
	 *
	 * `phones` :Array : （可选项）联系人电话组成的数组
	 *
	 * `address` :Array : （可选项）联系人地址
	 *
	 * `url` :Array : （可选项）URL
	 *
	 * `emails` :Array : （可选项）邮箱
	 *
	 * `dates` :Array : （可选项）日期
	 *
	 * `contactRelation` :Array : （可选项）关联人【仅ios支持】
	 *
	 * `socialProfiles` :Array : （可选项）社交资料【仅ios支持】
	 *
	 * `instantMessageAddresses` :Array : （可选项）即时信息
	 *
	 * `note` :string : （可选项）联系人备注
	 */
	update(params:DVContacts_update_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `根据联系人 id 查找联系人`
	 * ========params==========
	 *
	 * `ids` :Array : 联系人 id 组成的数组，若 id 不存在则不处理
	 */
	query(params:DVContacts_query_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `根据关键字从通讯录查找联系人`
	 * ========params==========
	 *
	 * `keyword` :string : 要查询的关键字 **注意：仅搜索 lastName 和 firstName 包含的关键字**
	 */
	queryByKeyword(params:DVContacts_queryByKeyword_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `创建分组`
	 * ========params==========
	 *
	 * `groupName` :string : 分组名
	 */
	createGroup(params:DVContacts_createGroup_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `删除分组，只删除分组，不删除其中的联系人`
	 * ========params==========
	 *
	 * `groupId` :any : 分组 id
	 */
	deleteGroup(params:DVContacts_deleteGroup_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 获取所有分组信息*/ 
	queryGroups(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `根据分组 id 查找联系人`
	 * ========params==========
	 *
	 * `groupId` :number : （可选项）要查找的分组 id
	 */
	queryByGroupId(params:DVContacts_queryByGroupId_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `根据 id 移动联系人至指定分组`
	 * ========params==========
	 *
	 * `id` :any : 联系人 id
	 *
	 * `groupId` :any : 联系人的分组 id；若分组不存在则不移动分组
	 */
	move(params:DVContacts_move_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `根据 id 从指定分组删除`
	 * ========params==========
	 *
	 * `id` :any : 联系人 id
	 *
	 * `groupId` :any : 联系人的分组 id；若分组不存在则不从分组删除
	 */
	deleteFromGroup(params:DVContacts_deleteFromGroup_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `根据页码查找指定数量的联系人`
	 * ========params==========
	 *
	 * `count` :number : （可选项）每页联系人的数量，若不传则返回全部联系人，**不建议不传本参数**
	 *
	 * `pageIndex` :number : （可选项）联系人的分页索引
	 */
	queryByPage(params:DVContacts_queryByPage_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 打开系统通讯录界面，选择单个联系人，返回已选的联系人信息手机号码*/ 
	openPhonesUI():void

}
interface DVContacts_add_Params {
	/**（可选项）联系人头像，支持widget://、fs://*/ 
	image?:string,

	/**（可选项）联系人姓氏*/ 
	lastName?:string,

	/**（可选项）联系人名字*/ 
	firstName?:string,

	/**（可选项）联系人中间名*/ 
	middleName?:string,

	/**（可选项）联系人名称前缀*/ 
	prefix?:string,

	/**（可选项）联系人名称后缀*/ 
	suffix?:string,

	/**（可选项）联系人公司*/ 
	company?:string,

	/**（可选项）联系人职位*/ 
	title?:string,

	/**（可选项）联系人电话组成的数组*/ 
	phones?:Array,

	/**（可选项）联系人地址*/ 
	address?:Array,

	/**（可选项）URL*/ 
	url?:Array,

	/**（可选项）邮箱*/ 
	emails?:Array,

	/**（可选项）日期*/ 
	dates?:Array,

	/**（可选项）关联人*/ 
	contactRelation?:Array,

	/**（可选项）社交资料*/ 
	socialProfiles?:Array,

	/**（可选项）即时信息*/ 
	instantMessageAddresses?:Array,

	/**（可选项）联系人备注*/ 
	note?:string,

}

interface DVContacts_delete_Params {
	/**联系人的 id 组成的数组，若传入的 id 不存在，则忽略此id*/ 
	ids:Array,

}

interface DVContacts_update_Params {
	/**联系人的id*/ 
	id:string,

	/**（可选项）联系人头像，支持widget://、fs://*/ 
	image?:string,

	/**（可选项）联系人姓氏*/ 
	lastName?:string,

	/**（可选项）联系人名字*/ 
	firstName?:string,

	/**（可选项）联系人中间名*/ 
	middleName?:string,

	/**（可选项）联系人名称前缀*/ 
	prefix?:string,

	/**（可选项）联系人名称后缀*/ 
	suffix?:string,

	/**（可选项）联系人公司*/ 
	company?:string,

	/**（可选项）联系人职位*/ 
	title?:string,

	/**（可选项）联系人电话组成的数组*/ 
	phones?:Array,

	/**（可选项）联系人地址*/ 
	address?:Array,

	/**（可选项）URL*/ 
	url?:Array,

	/**（可选项）邮箱*/ 
	emails?:Array,

	/**（可选项）日期*/ 
	dates?:Array,

	/**（可选项）关联人【仅ios支持】*/ 
	contactRelation?:Array,

	/**（可选项）社交资料【仅ios支持】*/ 
	socialProfiles?:Array,

	/**（可选项）即时信息*/ 
	instantMessageAddresses?:Array,

	/**（可选项）联系人备注*/ 
	note?:string,

}

interface DVContacts_query_Params {
	/**联系人 id 组成的数组，若 id 不存在则不处理*/ 
	ids:Array,

}

interface DVContacts_queryByKeyword_Params {
	/**要查询的关键字 **注意：仅搜索 lastName 和 firstName 包含的关键字***/ 
	keyword:string,

}

interface DVContacts_createGroup_Params {
	/**分组名*/ 
	groupName:string,

}

interface DVContacts_deleteGroup_Params {
	/**分组 id*/ 
	groupId:any,

}

interface DVContacts_queryByGroupId_Params {
	/**（可选项）要查找的分组 id*/ 
	groupId?:number,

}

interface DVContacts_move_Params {
	/**联系人 id*/ 
	id:any,

	/**联系人的分组 id；若分组不存在则不移动分组*/ 
	groupId:any,

}

interface DVContacts_deleteFromGroup_Params {
	/**联系人 id*/ 
	id:any,

	/**联系人的分组 id；若分组不存在则不从分组删除*/ 
	groupId:any,

}

interface DVContacts_queryByPage_Params {
	/**（可选项）每页联系人的数量，若不传则返回全部联系人，**不建议不传本参数***/ 
	count?:number,

	/**（可选项）联系人的分页索引*/ 
	pageIndex?:number,

}

interface cellphone {
	/** 获取信息*/ 
	getInfo():void

	/**
	 * `网络测速`
	 * ========params==========
	 *
	 * `testUrl` :string : 一个文件的下载地址
	 */
	netSpeed(params:cellphone_netSpeed_Params, callback?: (ret:JSON) => void):void

	/** 停止网络测速*/ 
	stopMeasur():void

	/** 开始网络测速*/ 
	startMeasur():void

	/** 当前网速*/ 
	currentSpeed():void

}
interface cellphone_netSpeed_Params {
	/**一个文件的下载地址*/ 
	testUrl:string,

}

interface decibel {
	/**
	 * `获取周围环境的分贝值（dB）。`
	 * ========params==========
	 *
	 * `repeat` :boolean : （选填）是否持续地返回分贝值。默认是false,只返回一次结果。
	 *
	 * `interval` :number : （选填）repeat为true才有效，返回的时间间隔，单位毫秒ms
	 */
	getDecibel(params:decibel_getDecibel_Params, callback?: (ret:JSON) => void):void

	/** 停止返回分贝值，只有设repeat为true，才有必要调这个停止。*/ 
	stop():void

}
interface decibel_getDecibel_Params {
	/**（选填）是否持续地返回分贝值。默认是false,只返回一次结果。*/ 
	repeat:boolean,

	/**（选填）repeat为true才有效，返回的时间间隔，单位毫秒ms*/ 
	interval:number,

}

interface rotationVector {
}
interface linearAcceleration {
}
interface gravitySensor {
}
interface seblePrinter {
	/** 搜索小票打印机蓝牙接口*/ 
	init():void

	/**
	 * `连接小票打印机接口`
	 * ========params==========
	 *
	 * `id` :number : 默认值为0，填写init接口返回的id。
	 */
	connect(params:seblePrinter_connect_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `以html网络文件形式打印小票`
	 * ========params==========
	 *
	 * `url` :string : 打印小票的html文件的网络地址。
	 *
	 * `alignment` :number : 对齐方式
	 *
	 * `maxWidth` :number : 最大宽度
	 */
	print(params:seblePrinter_print_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 以html本地文件形式打印小票接口*/ 
	printLocal():void

	/**
	 * `以字符串形式打印小票接口`
	 * ========params==========
	 *
	 * `printString` :Array : 打印小票的数据。里面为字典类型。
	 */
	printString(params:seblePrinter_printString_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface seblePrinter_connect_Params {
	/**默认值为0，填写init接口返回的id。*/ 
	id:number,

}

interface seblePrinter_print_Params {
	/**打印小票的html文件的网络地址。*/ 
	url:string,

	/**对齐方式*/ 
	alignment:number,

	/**最大宽度*/ 
	maxWidth:number,

}

interface seblePrinter_printString_Params {
	/**打印小票的数据。里面为字典类型。*/ 
	printString:Array,

}

interface statusBarTools {
	/** 获取信息*/ 
	getStatusBarInfo():void

}
interface lightSensitive {
	/** 开始检测光感*/ 
	start():void

	/** 结束检测光感*/ 
	end():void

}
interface music {
	/**
	 * `扫描 Music 内的音频文件`
	 * ========params==========
	 *
	 * `thumbnail` :JSON : 返回的缩略图(若不存在则返回空)大小，若不传本参数则不返回缩略图，注意返回缩略图会降低读取速度
	 *
	 * `iCloud` :boolean : 是否包含 iCloud 音乐
	 */
	scanMusic(params:music_scanMusic_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `将音乐库的音频文件拷贝到沙盒`
	 * ========params==========
	 *
	 * `url` :string : 音乐库音频文件路径，如：ipod-library://item/item.mp3?id=4559289265963493915
	 *
	 * `savePath` :string : （可选项）保存路径，要求本地路径（fs://），如：fs://music/m1.mp3
	 */
	copyToSandbox(params:music_copyToSandbox_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 取消音乐库的音频文件拷贝到沙盒*/ 
	cancelCopyToSandbox(callback?: (ret:JSON) => void):void

	/**
	 * `清空缓存`
	 * ========params==========
	 *
	 * `url` :string : 清空的缓存的目标
	 */
	cleanCach(params:music_cleanCach_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `弹出系统自带选择音频页面`
	 * ========params==========
	 *
	 * `multiple` :string : 是否多选
	 *
	 * `showsCloudItems` :string : 是否显示云端资源
	 *
	 * `thumbnail` :JSON : 返回的缩略图(若不存在则返回空)大小，若不传本参数则不返回缩略图，注意返回缩略图会降低读取速度
	 */
	presentMusic(params:music_presentMusic_Params, callback?: (ret:JSON) => void):void

}
interface music_scanMusic_Params {
	/**返回的缩略图(若不存在则返回空)大小，若不传本参数则不返回缩略图，注意返回缩略图会降低读取速度*/ 
	thumbnail:JSON,

	/**是否包含 iCloud 音乐*/ 
	iCloud:boolean,

}

interface music_copyToSandbox_Params {
	/**音乐库音频文件路径，如：ipod-library://item/item.mp3?id=4559289265963493915*/ 
	url:string,

	/**（可选项）保存路径，要求本地路径（fs://），如：fs://music/m1.mp3*/ 
	savePath?:string,

}

interface music_cleanCach_Params {
	/**清空的缓存的目标*/ 
	url:string,

}

interface music_presentMusic_Params {
	/**是否多选*/ 
	multiple:string,

	/**是否显示云端资源*/ 
	showsCloudItems:string,

	/**返回的缩略图(若不存在则返回空)大小，若不传本参数则不返回缩略图，注意返回缩略图会降低读取速度*/ 
	thumbnail:JSON,

}

interface zNFC {
	/**
	 * `读取NDEF格式的NFC标签`
	 * ========params==========
	 *
	 * `style` :JSON : （可选项）模块各部分的样式,不传递本参数则选用模块默认UI布局方案
	 */
	readNDEF(params:zNFC_readNDEF_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `写入数据至NDEF格式的NFC标签`
	 * ========params==========
	 *
	 * `style` :JSON : （可选项）模块各部分的样式,不传递本参数则选用模块默认UI布局方案
	 *
	 * `data` :string : （可选项）要写入的数据【 如：'这是一条测试数据'】，不传将写入空字符串（空字符串可以达到清空内容的功能）
	 */
	writeNDEF(params:zNFC_writeNDEF_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface zNFC_readNDEF_Params {
	/**（可选项）模块各部分的样式,不传递本参数则选用模块默认UI布局方案*/ 
	style?:JSON,

}

interface zNFC_writeNDEF_Params {
	/**（可选项）模块各部分的样式,不传递本参数则选用模块默认UI布局方案*/ 
	style?:JSON,

	/**（可选项）要写入的数据【 如：'这是一条测试数据'】，不传将写入空字符串（空字符串可以达到清空内容的功能）*/ 
	data?:string,

}

interface spputil {
	/** 初始化*/ 
	init(callback?: (ret:JSON) => void):void

	/** 扫描附近蓝牙设备，会自动停止*/ 
	scan():void

	/** 是否在扫描*/ 
	isScanning():void

	/** 停止扫描*/ 
	stopScan():void

	/**
	 * `连接指定外围设备`
	 * ========params==========
	 *
	 * `address` :string : 要连接的外围设备的 MAC地址。
	 */
	connect(params:spputil_connect_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 断开连接*/ 
	disconnect(callback?: (ret:JSON, err:JSON) => void):void

	/** 设备是否连接*/ 
	isConnected(callback?: (ret:JSON) => void):void

	/**
	 * `发送数据`
	 * ========params==========
	 *
	 * `sendData` :string : 发送的数据。
	 *
	 * `isHex` :boolean : 是否是HEX数据
	 */
	send(params:spputil_send_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `接收数据`
	 * ========params==========
	 *
	 * `isHex` :boolean : 是否是HEX数据
	 */
	receive(params:spputil_receive_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface spputil_connect_Params {
	/**要连接的外围设备的 MAC地址。*/ 
	address:string,

}

interface spputil_send_Params {
	/**发送的数据。*/ 
	sendData:string,

	/**是否是HEX数据*/ 
	isHex:boolean,

}

interface spputil_receive_Params {
	/**是否是HEX数据*/ 
	isHex:boolean,

}

interface callrecords {
}
interface moduleEasyWiFi {
}
interface ipAddr {
	/** 获取ip地址*/ 
	getIp():void

}
interface telephoneInfo {
	/** 得到手机通讯所有相关信息*/ 
	getTelephoneInfos(callback?: (ret:JSON) => void):void

	/** 得到设备信息*/ 
	getDeviceInfo(callback?: (ret:JSON) => void):void

	/** 得到SIM卡信息*/ 
	getSimInfo(callback?: (ret:JSON) => void):void

	/** 得到网络信息*/ 
	getNetworkInfo(callback?: (ret:JSON) => void):void

	/** 得到电话相关状态信息*/ 
	getPhoneStateInfo(callback?: (ret:JSON) => void):void

}
interface leidenSDK {
}
interface ipa {
	/** 获取BundleID。*/ 
	getBundleID():void

	/** 获取BundleVersion。(就是APICloud云编译时IOS version code里面填的值。测试版因为不用填，默认是正式版上一次打包保留下的值，正式版打包就正对应你当时填的值。)*/ 
	getBundleVersion():void

	/** 获取app的完整信息。*/ 
	getAppInfo():void

}
interface iAd {
	/** 判断用户是否限制广告追踪*/ 
	adTrackingEnable():void

	/** 请求获取广告ID权限*/ 
	adRequest():void

	/**
	 * `获取 IDFA`
	 * ========params==========
	 *
	 * `lowerCase` :boolean : （可选项）是否返回小写
	 */
	getIDFA(params:iAd_getIDFA_Params, callback?: (ret:JSON) => void):void

}
interface iAd_getIDFA_Params {
	/**（可选项）是否返回小写*/ 
	lowerCase?:boolean,

}

interface androidNfc {
}
interface multiScreen {
	/** 打开模块，在指定的显示器上显示网页和轮播图片*/ 
	open(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `在指定的显示器的上显示内容`
	 * ========params==========
	 *
	 * `screenIndex` :number : 屏幕序号，主屏幕序号为0，其他屏幕序号依次递增。 双屏机器的副屏序号一般为1。
	 */
	show(params:multiScreen_show_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `隐藏指定显示器上显示的页面`
	 * ========params==========
	 *
	 * `screenIndex` :number : 屏幕序号，主屏幕序号为0，其他屏幕序号依次递增。 双屏机器的副屏序号一般为1。
	 */
	hide(params:multiScreen_hide_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 获取当前设备所有显示器的信息列表，返回的数组项的序号即为显示器序号。*/ 
	getScreenList(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `调用指定显示器上显示的HTML中的js函数`
	 * ========params==========
	 *
	 * `screenIndex` :number : （可选项）屏幕序号，默认值为-1，表示最后一个屏幕，即双屏机器的副屏。
	 *
	 * `name` :string : 要调用的 js 函数名字
	 *
	 * `param` :JSON : （可选项）传递给要调用的 js 函数的参数
	 */
	invokeJsFunc(params:multiScreen_invokeJsFunc_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface multiScreen_show_Params {
	/**屏幕序号，主屏幕序号为0，其他屏幕序号依次递增。 双屏机器的副屏序号一般为1。*/ 
	screenIndex:number,

}

interface multiScreen_hide_Params {
	/**屏幕序号，主屏幕序号为0，其他屏幕序号依次递增。 双屏机器的副屏序号一般为1。*/ 
	screenIndex:number,

}

interface multiScreen_invokeJsFunc_Params {
	/**（可选项）屏幕序号，默认值为-1，表示最后一个屏幕，即双屏机器的副屏。*/ 
	screenIndex?:number,

	/**要调用的 js 函数名字*/ 
	name:string,

	/**（可选项）传递给要调用的 js 函数的参数*/ 
	param?:JSON,

}

interface gyro {
	/** 检查设备是否有陀螺仪*/ 
	checkUp(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `打开重力感应`
	 * ========params==========
	 *
	 * `time` :string : （必选）采集信息间隔时间，以秒为单位。
	 */
	startListener(params:gyro_startListener_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 关闭重力感应*/ 
	stopListener():void

}
interface gyro_startListener_Params {
	/**（必选）采集信息间隔时间，以秒为单位。*/ 
	time:string,

}

interface socketServerClient {
	/**
	 * `开启服务`
	 * ========params==========
	 *
	 * `charset` :string : (可选项)编码格式，仅支持 Android 平台
	 *
	 * `port` :number : （可选项）端口号
	 *
	 * `heart` :JSON : （可选项）心跳设置
	 *
	 * `send` :JSON : （可选项）发送包设置
	 *
	 * `receive` :JSON : （可选项）接收包设置
	 *
	 * `single` :boolean : （可选项）是否以单例模式打开服务
	 */
	startServer(params:socketServerClient_startServer_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 停止服务*/ 
	stopServer():void

	/**
	 * `发送消息`
	 * ========params==========
	 *
	 * `id` :number : 客户端id，客户端连接到服务端时，在服务端的startServer回调中获取需要自己保存，clientId以供发送消息时使用。
	 *
	 * `data` :string : 发送消息的数据
	 *
	 * `single` :boolean : （可选项）单例模式下操作
	 *
	 * `ret` :JSON : null
	 *
	 * `err` :JSON : null
	 */
	sendMessage(params:socketServerClient_sendMessage_Params):void

	/**
	 * `获取接收ip、端口号`
	 * ========params==========
	 *
	 * `single` :boolean : （可选项）单例模式下操作
	 *
	 * `ret` :JSON : null
	 *
	 * `err` :JSON : null
	 */
	getAddress(params:socketServerClient_getAddress_Params):void

	/**
	 * `开启文件服务，返回链接地址，可通过返回地址下载文件`
	 * ========params==========
	 *
	 * `filePath` :string : 文件目录 支持fs目录以及绝对路径
	 *
	 * `port` :number : （可选项）端口号
	 *
	 * `single` :boolean : （可选项）以单例模式开启服务
	 *
	 * `ret` :JSON : null
	 *
	 * `err` :JSON : null
	 */
	startHttpFileServer(params:socketServerClient_startHttpFileServer_Params):void

	/**
	 * `停止文件服务，关闭后不可通过http下载此设备文件`
	 * ========params==========
	 *
	 * `single` :boolean : （可选项）单例模式下操作
	 *
	 * `ret` :JSON : null
	 *
	 * `err` :JSON : null
	 */
	stopHttpFileServer(params:socketServerClient_stopHttpFileServer_Params):void

	/**
	 * `创建客户端链接到服务端`
	 * ========params==========
	 *
	 * `ip` :string : 服务端的ip地址，startServer之后可以通过服务端的getAddress方法获取
	 *
	 * `port` :number : 服务端的端口号，可以通过服务端的getAddress获取
	 *
	 * `ret` :JSON : null
	 *
	 * `err` :JSON : null
	 */
	clientConnect(params:socketServerClient_clientConnect_Params):void

	/**
	 * `发送消息`
	 * ========params==========
	 *
	 * `data` :string : 发送消息的数据
	 *
	 * `ret` :JSON : null
	 *
	 * `err` :JSON : null
	 */
	clientSend(params:socketServerClient_clientSend_Params):void

}
interface socketServerClient_startServer_Params {
	/**(可选项)编码格式，仅支持 Android 平台*/ 
	charset?:string,

	/**（可选项）端口号*/ 
	port?:number,

	/**（可选项）心跳设置*/ 
	heart?:JSON,

	/**（可选项）发送包设置*/ 
	send?:JSON,

	/**（可选项）接收包设置*/ 
	receive?:JSON,

	/**（可选项）是否以单例模式打开服务*/ 
	single?:boolean,

}

interface socketServerClient_sendMessage_Params {
	/**客户端id，客户端连接到服务端时，在服务端的startServer回调中获取需要自己保存，clientId以供发送消息时使用。*/ 
	id:number,

	/**发送消息的数据*/ 
	data:string,

	/**（可选项）单例模式下操作*/ 
	single?:boolean,

	/**null*/ 
	ret:JSON,

	/**null*/ 
	err:JSON,

}

interface socketServerClient_getAddress_Params {
	/**（可选项）单例模式下操作*/ 
	single?:boolean,

	/**null*/ 
	ret:JSON,

	/**null*/ 
	err:JSON,

}

interface socketServerClient_startHttpFileServer_Params {
	/**文件目录 支持fs目录以及绝对路径*/ 
	filePath:string,

	/**（可选项）端口号*/ 
	port?:number,

	/**（可选项）以单例模式开启服务*/ 
	single?:boolean,

	/**null*/ 
	ret:JSON,

	/**null*/ 
	err:JSON,

}

interface socketServerClient_stopHttpFileServer_Params {
	/**（可选项）单例模式下操作*/ 
	single?:boolean,

	/**null*/ 
	ret:JSON,

	/**null*/ 
	err:JSON,

}

interface socketServerClient_clientConnect_Params {
	/**服务端的ip地址，startServer之后可以通过服务端的getAddress方法获取*/ 
	ip:string,

	/**服务端的端口号，可以通过服务端的getAddress获取*/ 
	port:number,

	/**null*/ 
	ret:JSON,

	/**null*/ 
	err:JSON,

}

interface socketServerClient_clientSend_Params {
	/**发送消息的数据*/ 
	data:string,

	/**null*/ 
	ret:JSON,

	/**null*/ 
	err:JSON,

}

interface accelerometerSensor {
}
interface proximity {
	/** 打开接近传感器*/ 
	open():void

	/** 关闭接近传感器*/ 
	close():void

}
interface simInfoImp {
	/**   获取当前手机号码*/ 
	getPhoneNumber():void

}
interface vibrate {
	/** Peek振动*/ 
	vibratePeek():void

	/** Pop振动*/ 
	vibratePop():void

	/** 三次连续振动*/ 
	vibrateThree():void

	/**
	 * `自定义时长振动模式`
	 * ========params==========
	 *
	 * `time` :number : （必填项）振动的总时长，到时间后停止振动。
	 */
	vibrateCustom(params:vibrate_vibrateCustom_Params, callback?: (ret:JSON) => void):void

	/** 停止振动*/ 
	stopVibrate():void

}
interface vibrate_vibrateCustom_Params {
	/**（必填项）振动的总时长，到时间后停止振动。*/ 
	time:number,

}

interface moduleElectronicScale {
	/** 开启通讯秤连接*/ 
	openSerialPort(callback?: (ret:JSON) => void):void

	/** 开启和通信秤通信*/ 
	startCommunication():void

	/** 获取计重商品的重量值*/ 
	getValues(callback?: (ret:JSON) => void):void

}
interface simpleBle {
	/** ios系统需要调用此方法初始化，android则不需要*/ 
	init():void

	/** 判断当前设备是否支持蓝牙功能*/ 
	isSupport():void

	/** 打开蓝牙*/ 
	open():void

	/** 关闭蓝牙*/ 
	close():void

	/** 判断蓝牙开关状态*/ 
	isOpen():void

	/** 打开蓝牙设置界面*/ 
	openBleSetting():void

	/** 蓝牙开关状态监听 **此接口只需要调用一次，后面状态改变回调会调用***/ 
	setStateListener():void

}
interface reminder {
	/** 请求访问提醒权限*/ 
	requestAuth():void

	/**
	 * ` 添加提醒`
	 * ========params==========
	 *
	 * `title` :string : 提醒的标题
	 *
	 * `notes` :string : 提醒的描述
	 *
	 * `location` :string : （可选项）地点
	 *
	 * `calendarIdentifier` :string : （可选项）提醒所在分类
	 *
	 * `startTime` :string : （可选项）开始时间
	 *
	 * `completionDate` :string : （可选项）结束时间
	 */
	addReminder(params:reminder_addReminder_Params, callback?: (ret:JSON) => void):void

	/** 获取所有的提醒*/ 
	getAllReminders():void

	/** 通过分类的 ID 获取提醒*/ 
	getRemindersById():void

	/** 删除提醒*/ 
	removeReminder():void

	/** 更新提醒*/ 
	updateReminder():void

}
interface reminder_addReminder_Params {
	/**提醒的标题*/ 
	title:string,

	/**提醒的描述*/ 
	notes:string,

	/**（可选项）地点*/ 
	location?:string,

	/**（可选项）提醒所在分类*/ 
	calendarIdentifier?:string,

	/**（可选项）开始时间*/ 
	startTime?:string,

	/**（可选项）结束时间*/ 
	completionDate?:string,

}

interface calendarMemo {
	/**
	 * `判断是否有访问提醒事项的权限`
	 * ========params==========
	 *
	 * `entityType` :string : （可选项）判断是提醒还是日历的权限状态
	 */
	remindersAuth(params:calendarMemo_remindersAuth_Params, callback?: (ret:JSON) => void):void

	/** 请求访问日历权限*/ 
	requestAuth():void

	/**
	 * `添加事件`
	 * ========params==========
	 *
	 * `identifier` :string : （可选项）事件（行程）所在分类的 ID，仅支持 iOS 端
	 *
	 * `title` :string : 事件的标题
	 *
	 * `description` :string : 事件的描述
	 *
	 * `location` :string : （可选）地点
	 *
	 * `startTime` :string : 开始时间
	 *
	 * `endTime` :string : 结束时间
	 */
	addEvent(params:calendarMemo_addEvent_Params, callback?: (ret:JSON) => void):void

	/** 删除事件*/ 
	removeEvent():void

	/** 更新事件*/ 
	updateEvent():void

	/** 	获取所有的事件*/ 
	getAllEvent():void

	/** 通过id获取事件*/ 
	getEventById():void

}
interface calendarMemo_remindersAuth_Params {
	/**（可选项）判断是提醒还是日历的权限状态*/ 
	entityType?:string,

}

interface calendarMemo_addEvent_Params {
	/**（可选项）事件（行程）所在分类的 ID，仅支持 iOS 端*/ 
	identifier?:string,

	/**事件的标题*/ 
	title:string,

	/**事件的描述*/ 
	description:string,

	/**（可选）地点*/ 
	location?:string,

	/**开始时间*/ 
	startTime:string,

	/**结束时间*/ 
	endTime:string,

}

interface lpapiModule {
	/**
	 * `- 类型：字符串`
	 * ========params==========
	 *
	 * `name` :string : （可选项）打印机型号，不指定表示获取所有型号的打印机。
	 */
	getAllPrinters(params:lpapiModule_getAllPrinters_Params):void

	/**
	 * `连接目标打印机`
	 * ========params==========
	 *
	 * `name` :string : 要连接的目标打印机名称，打印机名称可以通过getAllPrinters来获取；
	 */
	openPrinter(params:lpapiModule_openPrinter_Params, callback?: (ret:JSON) => void):void

	/** 连接目标打印机*/ 
	closePrinter():void

	/** 连接目标打印机*/ 
	isPrinterOpened():void

	/** 获取打印机相关信息（打印机连接后有效）*/ 
	getPrinterInfo():void

	/**
	 * `打印图片url或者base64格式的图片；`
	 * ========params==========
	 *
	 * `image` :string : base64格式图片或者图片url路径；
	 */
	printImage(params:lpapiModule_printImage_Params):void

	/** 打印图片url或者base64格式的图片；*/ 
	startJob():void

	/** 打印图片url或者base64格式的图片；*/ 
	commitJob():void

	/** 设置打印项的水平对齐方式，0：居左对齐，1：水平居中对齐，2：居右对齐；*/ 
	setItemHorizontalAlignment():void

	/** 设置打印项的垂直对齐方式，0：垂直居上，1：垂直居中对齐，2：垂直居下对齐；*/ 
	setItemVerticalAlignment():void

	/** 设置后续打印项的旋转角度，*/ 
	setItemOrientation():void

	/** 打印字符串*/ 
	drawText():void

	/** 打印图片url或者base64图片；*/ 
	drawImage():void

}
interface lpapiModule_getAllPrinters_Params {
	/**（可选项）打印机型号，不指定表示获取所有型号的打印机。*/ 
	name?:string,

}

interface lpapiModule_openPrinter_Params {
	/**要连接的目标打印机名称，打印机名称可以通过getAllPrinters来获取；*/ 
	name:string,

}

interface lpapiModule_printImage_Params {
	/**base64格式图片或者图片url路径；*/ 
	image:string,

}

interface easyNFC {
	/** 检测设备是否支持NFC*/ 
	isSupported():void

	/** 开始读NFC标签，等待NFC标签靠近手机，靠近手机后自动开始读取，读取信息完成后异步返回结果*/ 
	startRead(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `开始写NFC标签，等待NFC标签靠近手机，靠近手机后自动开始写入，写入数据完成后异步返回结果`
	 * ========params==========
	 *
	 * `text` :string : 要写入NFC标签的文本，如“你好，NFC！”
	 */
	startWrite(params:easyNFC_startWrite_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 停止所有读写操作。调用该方法后，由startRead和startWrite初始的读写都将被停止，不再等待NFC标签靠近手机*/ 
	stop():void

}
interface easyNFC_startWrite_Params {
	/**要写入NFC标签的文本，如“你好，NFC！”*/ 
	text:string,

}

interface contact {
}
interface mobileNFC {
	/** 当前设备是否支持 NFC 功能*/ 
	available():void

	/** 添加识别 NDEF 结果的监听*/ 
	addEventListener():void

	/**
	 * `开始识别 NDEF`
	 * ========params==========
	 *
	 * `title` :string : （可选项）验证弹框的提示语
	 *
	 * `multiple` :boolean : （可选项）是否支持多次自动识别
	 */
	begin(params:mobileNFC_begin_Params):void

	/** 停止识别 NDEF*/ 
	invalidate():void

	/** 开始读取 NDEF 数据。**注意本接口仅支持iOS13以上设备。***/ 
	read():void

	/**
	 * `写 NDEF 数据。**注意本接口仅支持iOS13以上设备。**`
	 * ========params==========
	 *
	 * `type` :string : 载体的类型
	 *
	 * `identifier` :string : 载体的标识
	 *
	 * `payload` :string : 载体中的未解析数据
	 *
	 * `typeNameFormat` :number : （可选项）载体的类型名称格式
	 */
	write(params:mobileNFC_write_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 打开NFC，读取ISO14443、ISO15693卡片信息。*/ 
	readTag(callback?: (ret:JSON, err:JSON) => void):void

	/** 设置提示文案*/ 
	setTips():void

	/** 关闭读取*/ 
	stopReadTag():void

}
interface mobileNFC_begin_Params {
	/**（可选项）验证弹框的提示语*/ 
	title?:string,

	/**（可选项）是否支持多次自动识别*/ 
	multiple?:boolean,

}

interface mobileNFC_write_Params {
	/**载体的类型*/ 
	type:string,

	/**载体的标识*/ 
	identifier:string,

	/**载体中的未解析数据*/ 
	payload:string,

	/**（可选项）载体的类型名称格式*/ 
	typeNameFormat?:number,

}

interface ywble {
	/** 判断当前蓝牙是否开启（仅android支持）*/ 
	isBleOpen():void

	/** 开启蓝牙（仅android支持）*/ 
	openBle():void

	/** 扫描蓝牙*/ 
	scan():void

	/** 停止扫描蓝牙*/ 
	stopScan():void

	/**
	 * `连接蓝牙`
	 * ========params==========
	 *
	 * `id` :any : scan接口返回（iOS为identifier，Android为mac）
	 */
	connect(params:ywble_connect_Params, callback?: (ret:JSON) => void):void

	/** 断开连接*/ 
	disconnect():void

	/**
	 * `向设备写入数据`
	 * ========params==========
	 *
	 * `data` :any : 写入的数据（base64字符串）
	 */
	writeData(params:ywble_writeData_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 收到数据监听*/ 
	addDataListener(callback?: (ret:JSON) => void):void

}
interface ywble_connect_Params {
	/**scan接口返回（iOS为identifier，Android为mac）*/ 
	id:any,

}

interface ywble_writeData_Params {
	/**写入的数据（base64字符串）*/ 
	data:any,

}

interface sunmiT1Printer {
	/** 开启打印服务*/ 
	startService(callback?: (ret:JSON) => void):void

	/** 初始化打印机*/ 
	printerInit(callback?: (ret:JSON) => void):void

	/** 打印机自检*/ 
	printerSelfChecking(callback?: (ret:JSON) => void):void

	/**
	 * `设置打印数据并打印`
	 * ========params==========
	 *
	 * `data` :JSON : （必填项）打印数据
	 */
	printData(params:sunmiT1Printer_printData_Params, callback?: (ret:JSON) => void):void

	/** 走纸*/ 
	lineWrap(callback?: (ret:JSON) => void):void

	/** 停止打印服务*/ 
	stopService(callback?: (ret:JSON) => void):void

	/** 打开钱箱*/ 
	openMoney(callback?: (ret:JSON) => void):void

	/** 切纸*/ 
	cutPaper(callback?: (ret:JSON) => void):void

	/** 打开钱箱次数*/ 
	openMoneyCount(callback?: (ret:JSON) => void):void

	/** 获取USB设备信息*/ 
	openUSB(callback?: (ret:JSON) => void):void

	/** 获取品牌名*/ 
	openBrand(callback?: (ret:JSON) => void):void

	/** 注册广播(监听硬件拔插)*/ 
	openFilter(callback?: (ret:JSON) => void):void

	/** 解除广播*/ 
	closeFilter(callback?: (ret:JSON) => void):void

	/** 获取USB类型(支持同步和异步返回)*/ 
	Usb(callback?: (ret:JSON) => void):void

}
interface sunmiT1Printer_printData_Params {
	/**（必填项）打印数据*/ 
	data:JSON,

}

interface touchID {
	/** 当前设备是否支持指纹识别功能*/ 
	isValid():void

	/** 取消认证*/ 
	cancelVerify():void

	/** 弹出验证界面，验证用户指纹(android无UI界面)*/ 
	verify(callback?: (ret:JSON) => void):void

}
interface fvvSerialPort {
	/** 获取设备列表 - 异步*/ 
	getAllDeviceList():void

	/** 获取设备列表 - 同步*/ 
	getAllDeviceListSync():void

	/** 获取所有设备路径 - 异步*/ 
	getAllDevicePath():void

	/** 获取设备路径 - 同步*/ 
	getAllDevicePathSync():void

	/** 设置串口波特率，可不设置，默认9600*/ 
	setBaudRate():void

	/** 设置串口停止位，可不设置*/ 
	setStopBits():void

	/** 设置串口数据位，可不设置*/ 
	setDataBits():void

	/** 设置串口校验，可不设置*/ 
	setParity():void

	/** 设置串口流控，可不设置*/ 
	setFlowCon():void

	/** 打开串口*/ 
	open():void

	/** 关闭串口*/ 
	close():void

	/** 获取串口打开状态*/ 
	isOpen():void

	/** 发送消息*/ 
	send():void

	/** 设置接收消息类型*/ 
	setReceiveType():void

	/** 设置发送消息类型*/ 
	setSendType():void

}
interface cilicoScan {
	/** 扫码得到结果*/ 
	scan(callback?: (ret:JSON, err:JSON) => void):void

}
interface cxgBluetooth {
	/** 获取当前的蓝牙状态*/ 
	isEnabledBluetooth(callback?: (ret:JSON, err:JSON) => void):void

	/** 打开蓝牙*/ 
	openBluetooth(callback?: (ret:JSON, err:JSON) => void):void

	/** 关闭蓝牙*/ 
	closeBluetooth(callback?: (ret:JSON, err:JSON) => void):void

	/** 监听蓝牙的状态变化， 多次返回*/ 
	listenBluetoothStatus(callback?: (ret:JSON, err:JSON) => void):void

	/** 获取已经配对的设备*/ 
	bondedDevices(callback?: (ret:JSON, err:JSON) => void):void

	/** 是否正在搜索设备*/ 
	isScanning(callback?: (ret:JSON, err:JSON) => void):void

	/** 扫描周边设备*/ 
	scan(callback?: (ret:JSON, err:JSON) => void):void

	/** 停止扫描周边设备*/ 
	stopScan(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `作为客户端连接到设备，回调函数多次返回`
	 * ========params==========
	 *
	 * `address` :string : 蓝牙设备的地址
	 *
	 * `UUID` :string : 蓝牙服务UUID
	 */
	connect(params:cxgBluetooth_connect_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `断开连接`
	 * ========params==========
	 *
	 * `address` :string : 蓝牙设备的地址
	 *
	 * `UUID` :string : 蓝牙服务UUID
	 */
	disconnect(params:cxgBluetooth_disconnect_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `发送数据`
	 * ========params==========
	 *
	 * `address` :string : 蓝牙设备的地址
	 *
	 * `UUID` :string : 蓝牙服务UUID
	 *
	 * `data` :string : 需要发送的字符串
	 *
	 * `isHex` :boolean : 是否为HEX格式
	 *
	 * `charset` :string : v1.1.0添加 发送字符串时的编码格式, 默认UTF-8
	 */
	sendData(params:cxgBluetooth_sendData_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `设置读取数据回调，多次返回`
	 * ========params==========
	 *
	 * `address` :string : 蓝牙设备的地址
	 *
	 * `UUID` :string : 蓝牙服务UUID
	 *
	 * `bufferSize` :number : 单次数据读取 buffer 的大小
	 *
	 * `isReturnHex` :boolean : 是否返回HEX格式的数据
	 *
	 * `isNoReturnData` :number : 是否不返回数据, 接收了但是不返回前端
	 *
	 * `returnStrCharset` :string : v1.1.0添加 接收数据时, 解析字符串使用的编码格式, 默认UTF-8
	 */
	setReadDataCallback(params:cxgBluetooth_setReadDataCallback_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 同步已连接的客户端数据, 用于刷新页面初始化*/ 
	syncClientsInfo(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `开启蓝牙服务, 多次返回`
	 * ========params==========
	 *
	 * `isNewStartServer` :string : 蓝牙服务UUID
	 */
	startServer(params:cxgBluetooth_startServer_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `停止蓝牙服务`
	 * ========params==========
	 *
	 * `isRemove` :string : 蓝牙服务UUID
	 */
	stopServer(params:cxgBluetooth_stopServer_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 服务端主动断开连接*/ 
	disconnectServerClient(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `发送数据`
	 * ========params==========
	 *
	 * `address` :string : 蓝牙服务UUID
	 *
	 * `data` :string : 需要发送的字符串
	 *
	 * `isHex` :boolean : 是否为HEX格式
	 *
	 * `charset` :string : v1.1.0添加 发送字符串时编码格式, 默认UTF-8
	 */
	sendDataServerClient(params:cxgBluetooth_sendDataServerClient_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `读取数据回调，多次返回`
	 * ========params==========
	 *
	 * `bufferSize` :number : 单次数据读取 buffer 的大小
	 *
	 * `isReturnHex` :boolean : 是否返回HEX格式的数据
	 *
	 * `isNoReturnData` :number : 是否不返回数据, 接收了但是不返回前端
	 *
	 * `returnStrCharset` :string : v1.1.0添加 接收数据时, 解析字符串使用的编码格式, 默认UTF-8
	 */
	setReadDataCallbackServerClient(params:cxgBluetooth_setReadDataCallbackServerClient_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 同步服务端数据,用于刷新页面初始化*/ 
	syncServersInfo(callback?: (ret:JSON, err:JSON) => void):void

}
interface cxgBluetooth_connect_Params {
	/**蓝牙设备的地址*/ 
	address:string,

	/**蓝牙服务UUID*/ 
	UUID:string,

}

interface cxgBluetooth_disconnect_Params {
	/**蓝牙设备的地址*/ 
	address:string,

	/**蓝牙服务UUID*/ 
	UUID:string,

}

interface cxgBluetooth_sendData_Params {
	/**蓝牙设备的地址*/ 
	address:string,

	/**蓝牙服务UUID*/ 
	UUID:string,

	/**需要发送的字符串*/ 
	data:string,

	/**是否为HEX格式*/ 
	isHex:boolean,

	/**v1.1.0添加 发送字符串时的编码格式, 默认UTF-8*/ 
	charset:string,

}

interface cxgBluetooth_setReadDataCallback_Params {
	/**蓝牙设备的地址*/ 
	address:string,

	/**蓝牙服务UUID*/ 
	UUID:string,

	/**单次数据读取 buffer 的大小*/ 
	bufferSize:number,

	/**是否返回HEX格式的数据*/ 
	isReturnHex:boolean,

	/**是否不返回数据, 接收了但是不返回前端*/ 
	isNoReturnData:number,

	/**v1.1.0添加 接收数据时, 解析字符串使用的编码格式, 默认UTF-8*/ 
	returnStrCharset:string,

}

interface cxgBluetooth_startServer_Params {
	/**蓝牙服务UUID*/ 
	isNewStartServer:string,

}

interface cxgBluetooth_stopServer_Params {
	/**蓝牙服务UUID*/ 
	isRemove:string,

}

interface cxgBluetooth_sendDataServerClient_Params {
	/**蓝牙服务UUID*/ 
	address:string,

	/**需要发送的字符串*/ 
	data:string,

	/**是否为HEX格式*/ 
	isHex:boolean,

	/**v1.1.0添加 发送字符串时编码格式, 默认UTF-8*/ 
	charset:string,

}

interface cxgBluetooth_setReadDataCallbackServerClient_Params {
	/**单次数据读取 buffer 的大小*/ 
	bufferSize:number,

	/**是否返回HEX格式的数据*/ 
	isReturnHex:boolean,

	/**是否不返回数据, 接收了但是不返回前端*/ 
	isNoReturnData:number,

	/**v1.1.0添加 接收数据时, 解析字符串使用的编码格式, 默认UTF-8*/ 
	returnStrCharset:string,

}

interface ble2 {
	/** 蓝牙是否可用，建议使用蓝牙其他功能前检查蓝牙可用性*/ 
	isBleEnable():void

	/** 打开蓝牙，当isBleEnable回调false时，可调用该接口打开蓝牙*/ 
	openBle():void

	/** 扫描附近蓝牙设备，扫描到相应蓝牙设备才可以进行connect等操作*/ 
	startScanBle(callback?: (ret:JSON) => void):void

	/** 停止扫描蓝牙设备*/ 
	stopScanBle():void

	/**
	 * `连接蓝牙设备，进行读写操作前调用该接口`
	 * ========params==========
	 *
	 * `name` :string : 要连接的蓝牙设备名称，来自startScanBle接口回调中的name参数
	 */
	connect(params:ble2_connect_Params, callback?: (ret:JSON) => void):void

	/**
	 * `读取蓝牙设备数据`
	 * ========params==========
	 *
	 * `name` :string : 要读取蓝牙设备名称，要与已连接的蓝牙设备名称相同
	 */
	read(params:ble2_read_Params, callback?: (ret:JSON) => void):void

	/** 停止读取数据*/ 
	stopRead():void

	/**
	 * `向蓝牙设备写入数据，调用该接口之前，要先调用过read接口`
	 * ========params==========
	 *
	 * `name` :string : 要写入的蓝牙设备名称，要与已连接的蓝牙设备名称相同
	 *
	 * `write` :string : 要写入的数据
	 */
	write(params:ble2_write_Params):void

}
interface ble2_connect_Params {
	/**要连接的蓝牙设备名称，来自startScanBle接口回调中的name参数*/ 
	name:string,

}

interface ble2_read_Params {
	/**要读取蓝牙设备名称，要与已连接的蓝牙设备名称相同*/ 
	name:string,

}

interface ble2_write_Params {
	/**要写入的蓝牙设备名称，要与已连接的蓝牙设备名称相同*/ 
	name:string,

	/**要写入的数据*/ 
	write:string,

}

interface bleToken {
	/** 扫描蓝牙设备*/ 
	scan():void

	/**
	 * `连接蓝牙设备`
	 * ========params==========
	 *
	 * `deviceName` :string : 要连接的蓝牙设备名称
	 *
	 * `auth` :string : 要连接的蓝牙设备的授权码，默认为12345678
	 */
	connect(params:bleToken_connect_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 断开蓝牙设备连接*/ 
	disConnect():void

	/** 枚举应用*/ 
	enumApps():void

	/**
	 * `获取应用，进行以下操作前要先获取到应用`
	 * ========params==========
	 *
	 * `appName` :string : 应用名称
	 */
	getApp(params:bleToken_getApp_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `登录`
	 * ========params==========
	 *
	 * `password` :string : 登录密码
	 */
	login(params:bleToken_login_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 注销登录*/ 
	logout():void

	/** 创建容器，名称根据SDK的随机数接口生成一个32位的随机数（转换成16进制字符串）*/ 
	createContainer():void

	/**
	 * `生成密钥对，RSA加密模式`
	 * ========params==========
	 *
	 * `containerName` :string : 容器名称
	 */
	genKeyPair(params:bleToken_genKeyPair_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 枚举容器*/ 
	getContainers():void

	/**
	 * `导出公钥`
	 * ========params==========
	 *
	 * `containerName` :string : 容器名称
	 */
	exportPublicKeyBlob(params:bleToken_exportPublicKeyBlob_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `签名`
	 * ========params==========
	 *
	 * `containerName` :string : 容器名称
	 *
	 * `data` :string : 要签名的数据
	 */
	signatures(params:bleToken_signatures_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 获取蓝牙设备信息*/ 
	getDeviceInfo():void

}
interface bleToken_connect_Params {
	/**要连接的蓝牙设备名称*/ 
	deviceName:string,

	/**要连接的蓝牙设备的授权码，默认为12345678*/ 
	auth:string,

}

interface bleToken_getApp_Params {
	/**应用名称*/ 
	appName:string,

}

interface bleToken_login_Params {
	/**登录密码*/ 
	password:string,

}

interface bleToken_genKeyPair_Params {
	/**容器名称*/ 
	containerName:string,

}

interface bleToken_exportPublicKeyBlob_Params {
	/**容器名称*/ 
	containerName:string,

}

interface bleToken_signatures_Params {
	/**容器名称*/ 
	containerName:string,

	/**要签名的数据*/ 
	data:string,

}

interface smsrecords {
}
interface strongApp {
	/** 开启保活机制*/ 
	start(callback?: (ret:JSON, err:JSON) => void):void

}
interface systemCompass {
	/** 打开指南针定位*/ 
	start():void

	/** 停止指南针定位*/ 
	stop():void

	/** 添加指南针监听*/ 
	addCompassListener():void

}
interface smsListener {
	/** 注册短信监听*/ 
	registerSmsListener():void

	/** 注销短信监听*/ 
	unRegisterSmsListener():void

}
interface gyroscopeSensor {
}
interface cameraColor {
	/**
	 * `打开相机页面`
	 * ========params==========
	 *
	 * `rect` :JSON : (可选项）相机位置及长宽
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）
	 *
	 * `fixed` :boolean : （可选项）模块是否随所属 window 或 frame 滚动
	 */
	open(params:cameraColor_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭相机页面*/ 
	close():void

	/** 隐藏相机页面*/ 
	hide():void

	/** 显示相机页面*/ 
	show():void

}
interface cameraColor_open_Params {
	/**(可选项）相机位置及长宽*/ 
	rect?:JSON,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame，传 window 无效）*/ 
	fixedOn?:string,

	/**（可选项）模块是否随所属 window 或 frame 滚动*/ 
	fixed?:boolean,

}

interface appSettings {
	/** 检查 APP 是否开启了通知权限。（iPhone4s上没有允许通知的按钮，所以检测是否打开了通知权限一直是打开状态。）*/ 
	checkNotification():void

	/**
	 * `打开 APP 的设置页面`
	 * ========params==========
	 *
	 * `type` :string : **<span style="color:#FF0000;">由于 iOS7 及以下版本不支持打开 APP 的设置页面，而只能打开系统的设置页面，故此参数用来指定 iOS7 及以下版本打开哪一项系统设置页，默认打开系统通知中心设置页。 iOS8 及以上版本不受此参数影响。</span>**
	 */
	open(params:appSettings_open_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface appSettings_open_Params {
	/****<span style="color:#FF0000;">由于 iOS7 及以下版本不支持打开 APP 的设置页面，而只能打开系统的设置页面，故此参数用来指定 iOS7 及以下版本打开哪一项系统设置页，默认打开系统通知中心设置页。 iOS8 及以上版本不受此参数影响。</span>***/ 
	type:string,

}

interface broadcast {
	/**
	 * `发送广播`
	 * ========params==========
	 *
	 * `data` :JSON : 要发送的内容
	 *
	 * `target` :string : （可选）要发送给应用的包名
	 */
	send(params:broadcast_send_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface broadcast_send_Params {
	/**要发送的内容*/ 
	data:JSON,

	/**（可选）要发送给应用的包名*/ 
	target?:string,

}

interface torch {
	/** 打开手机筒*/ 
	openTorch():void

	/** 关闭手机筒*/ 
	closeTorch():void

}
interface altimeter {
	/** 判断当前设备是否支持气压计*/ 
	isSupported():void

	/** 开始获取海拔、气压值*/ 
	startRelativeAltitudeUpdates():void

}
interface miitMsa {
	/** 获取驱动信息*/ 
	getDeviceId(callback?: (ret:JSON) => void):void

}
interface sunmiPrinter {
	/** 开启打印服务*/ 
	startService(callback?: (ret:JSON, err:JSON) => void):void

	/** 初始化打印机*/ 
	printerInit(callback?: (ret:JSON, err:JSON) => void):void

	/** 打印机自检*/ 
	printerSelfChecking(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `设置打印数据`
	 * ========params==========
	 *
	 * `data` :Array : （必输项）打印数据。
	 */
	printData(params:sunmiPrinter_printData_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 走纸行数*/ 
	lineWrap(callback?: (ret:JSON, err:JSON) => void):void

	/** 停止打印服务*/ 
	stopService(callback?: (ret:JSON, err:JSON) => void):void

	/** 双屏通信监听*/ 
	DSKernelListener():void

	/** 检查连接*/ 
	checkConnection():void

	/**
	 * `显示图片文件到副屏(多文件或者单文件,描述信息)`
	 * ========params==========
	 *
	 * `message` :string : （可选项）描述信息。
	 *
	 * `data` :Array : （必输项）这个是要显示的图片的本地路径信息。(支持：fs://)。
	 */
	sendDSKernelFile(params:sunmiPrinter_sendDSKernelFile_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `显示文字到副屏(标题，内容，二维码)`
	 * ========params==========
	 *
	 * `title` :string : （可选项）标题。
	 *
	 * `content` :string : （可选项）内容。
	 *
	 * `QRCodeImage` :string : （可选项）二维码图片文件路径(支持：fs://)。
	 */
	sendDSKernelText(params:sunmiPrinter_sendDSKernelText_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `全屏结算清单（14寸屏）`
	 * ========params==========
	 *
	 * `data` :Array : （必填项）清单内容(具体字段请参考商米接口文档)。
	 */
	sendBalanceList(params:sunmiPrinter_sendBalanceList_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `全屏含图片结算清单（14寸屏）`
	 * ========params==========
	 *
	 * `pics` :Array : （必填项）图片内容(支持fs://)。
	 */
	sendPicAndBalanceList(params:sunmiPrinter_sendPicAndBalanceList_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface sunmiPrinter_printData_Params {
	/**（必输项）打印数据。*/ 
	data:Array,

}

interface sunmiPrinter_sendDSKernelFile_Params {
	/**（可选项）描述信息。*/ 
	message?:string,

	/**（必输项）这个是要显示的图片的本地路径信息。(支持：fs://)。*/ 
	data:Array,

}

interface sunmiPrinter_sendDSKernelText_Params {
	/**（可选项）标题。*/ 
	title?:string,

	/**（可选项）内容。*/ 
	content?:string,

	/**（可选项）二维码图片文件路径(支持：fs://)。*/ 
	QRCodeImage?:string,

}

interface sunmiPrinter_sendBalanceList_Params {
	/**（必填项）清单内容(具体字段请参考商米接口文档)。*/ 
	data:Array,

}

interface sunmiPrinter_sendPicAndBalanceList_Params {
	/**（必填项）图片内容(支持fs://)。*/ 
	pics:Array,

}

interface clipBoard {
}
interface wifiMgr {
	/** 获取当前已连接的wifi的信息，由于ios的安全机制，ios只能获取ssid、bssid和ipAddr。对于Android 9.0及以上的版本，要想能够获取ssid(ssid就是wifi名字)必须进行以下2步操作。第一：必须打开手机的gps，目前手机只能手动打开gps，开发者可用代码打开手机设置中gps开关的界面引导用户打开gps，有关打开gps的功能请参考模块store中的gps模块。第二：在apicloud的"云编译"界面编译时注意给app设置"位置"权限(在"平台"两个字右边的安卓小机器人图片所在的方框内可以设置 位置权限)。Android9.0及以上除了ssid外的其他信息不需要打开gps就能获取。*/ 
	getCurWifiInfo():void

	/** 获取wifi开关当前状态*/ 
	getWifiState():void

	/** 打开wifi开关*/ 
	openWifi():void

	/** 关闭wifi*/ 
	closeWifi():void

	/** 打开手机自带“设置”界面*/ 
	toWifiSettingView():void

	/** 扫描获取附近的wifi列表，开发者可自行定时扫描获取，如间隔1秒扫描一次。*/ 
	scanWifis():void

	/** 获取已配置wifi列表。*/ 
	getConfiguredNetworks():void

	/** 连接指定的wifi。如果要连接的wifi是已配置过的(已保存有密码且密码正确，getConfiguredNetworks方法可获取)，则只需传入ssid，不需传入pwd和capabilities；如果要连接的wifi是没配置过的无密码保护类型的wifi，则只需传入ssid和capabilities，不需传入pwd。*/ 
	connect(callback?: (ret:JSON) => void):void

	/** 断开当前连接的wifi。*/ 
	disConnect():void

	/** 清除指定的wifi网络(清除密码)，要清除的wifi必须是已配置过的(getConfiguredNetworks方法可获取的)。当Android系统版本小于6.0时，该方法可以无条件(无条件是指相对于系统版本大于等于6.0的系统)清除指定的wifi网络(同样是已配置过的wifi);当Android系统版本大于等于6.0时，根据Google在Android6.0上的变动(官方文档说明https://developer.android.com/about/versions/marshmallow/android-6.0-changes.html#behavior-network，如下文)， Android6.0及以上版本不能清除由非本应用创建的wifi连接，即本应用可以调用该方法清除由connect方法创建的wifi连接，由其他应用或用户在系统wifi设置界面手动连接的wifi，调用该方法都不能清除成功。*/ 
	removeNetwork(callback?: (ret:JSON) => void):void

	/** 禁用指定的wifi网络，要禁用的wifi必须是已配置过的(getConfiguredNetworks方法可获取)。*/ 
	disableNetwork(callback?: (ret:JSON) => void):void

	/** 获取指定wifi的密码，手机需要Root且调用该方法后应用请求获取root权限(弹框方式弹出)，用户同意获取root权限后方可获取密码。*/ 
	getWifiPassword(callback?: (ret:JSON) => void):void

	/** 获取当前网络类型，可用于判断当前手机网络是wifi还是手机流量。*/ 
	getConnectionType():void

	/** 监听wifi开关状态。调用该方法立即返回是否监听成功，即立即回调callback(ret)方法，当wifi开关状态变化时会回调onWifiStateChanged(state)方法，开发者需要自己实现onWifiStateChanged(state)方法。该方法需与removeWifiStateListener方法成对出现，在适当的时候移除监听，即有添加就有移除。*/ 
	addWifiStateListener():void

	/** 移除wifi开关状态的监听。调用addWifiStateListener方法后，需在适当的时候移除监听，即有添加就有移除。*/ 
	removeWifiStateListener():void

	/** 监听网络状态。调用该方法立即返回是否监听成功，即立即回调callback(ret)方法，当网络状态变化时会回调onNetChanged(state)方法，开发者需要自己实现onNetChanged(state)方法。该方法需与removeNetChangedListener方法成对出现，在适当的时候移除监听，即有添加就有移除。*/ 
	addNetChangedListener():void

	/** 移除网络状态的监听。调用addNetChangedListener方法后，需在适当的时候移除监听，即有添加就有移除。*/ 
	removeNetChangedListener():void

}
interface ScreenWake {
	/** 唤醒点亮屏幕。*/ 
	addScreenWake():void

}
interface spModule {
}
interface yunnex {
	/**
	 * `调用打印`
	 * ========params==========
	 *
	 * `content` :Array<JSON> : （必选项）按照从上到下打印次序，逐行插入打印数组
	 */
	openPrinter(params:yunnex_openPrinter_Params, callback?: (ret:JSON) => void):void

}
interface yunnex_openPrinter_Params {
	/**（必选项）按照从上到下打印次序，逐行插入打印数组*/ 
	content:Array<JSON>,

}

interface wifiProxy {
	/**
	 * `设置wifi代理`
	 * ========params==========
	 *
	 * `host` :string : （必填）代理服务器ip地址。
	 *
	 * `port` :number : （必填）代理服务器端口。
	 */
	setWifiProxy(params:wifiProxy_setWifiProxy_Params, callback?: (ret:JSON) => void):void

	/** 移除wifi代理设置*/ 
	removeWifiProxy():void

}
interface wifiProxy_setWifiProxy_Params {
	/**（必填）代理服务器ip地址。*/ 
	host:string,

	/**（必填）代理服务器端口。*/ 
	port:number,

}

interface lightSensor {
}
interface gpsState {
}
interface memoryInfo {
	/** 得到android的总内存大小信息*/ 
	getMemoryInfo(callback?: (ret:JSON) => void):void

	/** 得到手机RAM信息*/ 
	getRamInfo(callback?: (ret:JSON) => void):void

	/** 得到手机ROM信息*/ 
	getRomInfo(callback?: (ret:JSON) => void):void

	/** 得到手机SDCard信息*/ 
	getSdCardInfo(callback?: (ret:JSON, err:JSON) => void):void

}
interface contacts {
	/** 打开系统通讯录界面，选择单个联系人，返回已选的联系人信息*/ 
	select(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `向通讯录添加一个联系人，所有参数不可同时为空。`
	 * ========params==========
	 *
	 * `groupId` :number : （可选项）分组 id，若不传则表示未分组
	 *
	 * `lastName` :string : （可选项）联系人姓氏
	 *
	 * `firstName` :string : （可选项）联系人名字
	 *
	 * `middleName` :string : （可选项）联系人中间名
	 *
	 * `prefix` :string : （可选项）联系人名称前缀
	 *
	 * `suffix` :string : （可选项）联系人名称后缀
	 *
	 * `phones` :Array : （可选项）联系人电话组成的数组
	 *
	 * `email` :string : （可选项）联系人邮箱
	 *
	 * `company` :string : （可选项）联系人公司
	 *
	 * `title` :string : （可选项）联系人职位
	 *
	 * `address` :JSON : （可选项）联系人地址
	 *
	 * `note` :string : （可选项）联系人备注
	 */
	add(params:contacts_add_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `从通讯录删除一个或多个联系人`
	 * ========params==========
	 *
	 * `ids` :Array : 联系人的 id 组成的数组，若传入的 id 不存在，则忽略此id
	 */
	delete(params:contacts_delete_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `根据 id 更新通讯录的联系人信息`
	 * ========params==========
	 *
	 * `id` :number : 联系人 id
	 *
	 * `lastName` :string : （可选项）联系人的姓氏
	 *
	 * `firstName` :string : （可选项）联系人名字
	 *
	 * `middleName` :string : （可选项）联系人中间名
	 *
	 * `prefix` :string : （可选项）联系人名称前缀
	 *
	 * `suffix` :string : （可选项）联系人名称后缀
	 *
	 * `phones` :Array : （可选项）联系人电话组成的数组，**注意：若本参数不为空，则重置已存在的所有电话及其标签**
	 *
	 * `email` :string : （可选项）联系人邮箱
	 *
	 * `company` :string : （可选项）联系人公司
	 *
	 * `title` :string : （可选项）联系人职位
	 *
	 * `address` :JSON : （可选项）联系人地址
	 *
	 * `note` :string : （可选项）联系人备注
	 */
	update(params:contacts_update_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `根据 id 移动联系人至指定分组`
	 * ========params==========
	 *
	 * `id` :number : 联系人 id
	 *
	 * `groupId` :number : 联系人的分组 id；若分组不存在则不移动分组
	 */
	move(params:contacts_move_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `根据联系人 id 查找联系人`
	 * ========params==========
	 *
	 * `ids` :Array : 联系人 id 组成的数组，若 id 不存在则不处理
	 */
	query(params:contacts_query_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `根据关键字从通讯录查找联系人`
	 * ========params==========
	 *
	 * `keyword` :string : 要查询的关键字 **注意：仅搜索 lastName 和 firstName 包含的关键字**
	 */
	queryByKeyword(params:contacts_queryByKeyword_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `根据页码查找指定数量的联系人`
	 * ========params==========
	 *
	 * `count` :number : （可选项）每页联系人的数量，若不传则返回全部联系人，**不建议不传本参数**
	 *
	 * `pageIndex` :number : （可选项）联系人的分页索引
	 *
	 * `isSort` :number : （可选项）是否排序返回
	 */
	queryByPage(params:contacts_queryByPage_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `创建分组`
	 * ========params==========
	 *
	 * `groupName` :string : 分组名
	 */
	createGroup(params:contacts_createGroup_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `删除分组，只删除分组，不删除其中的联系人`
	 * ========params==========
	 *
	 * `groupId` :number : 分组 id
	 */
	deleteGroup(params:contacts_deleteGroup_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 获取所有分组信息*/ 
	queryGroups(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `根据分组 id 查找联系人`
	 * ========params==========
	 *
	 * `groupId` :number : （可选项）要查找的分组 id
	 */
	queryByGroupId(params:contacts_queryByGroupId_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** **注意:该接口仅适用于 iOS9 以上系统，iOS9 以下及 android 系统请使用 queryByPage 接口***/ 
	allContacts(callback?: (ret:JSON, err:JSON) => void):void

}
interface contacts_add_Params {
	/**（可选项）分组 id，若不传则表示未分组*/ 
	groupId?:number,

	/**（可选项）联系人姓氏*/ 
	lastName?:string,

	/**（可选项）联系人名字*/ 
	firstName?:string,

	/**（可选项）联系人中间名*/ 
	middleName?:string,

	/**（可选项）联系人名称前缀*/ 
	prefix?:string,

	/**（可选项）联系人名称后缀*/ 
	suffix?:string,

	/**（可选项）联系人电话组成的数组*/ 
	phones?:Array,

	/**（可选项）联系人邮箱*/ 
	email?:string,

	/**（可选项）联系人公司*/ 
	company?:string,

	/**（可选项）联系人职位*/ 
	title?:string,

	/**（可选项）联系人地址*/ 
	address?:JSON,

	/**（可选项）联系人备注*/ 
	note?:string,

}

interface contacts_delete_Params {
	/**联系人的 id 组成的数组，若传入的 id 不存在，则忽略此id*/ 
	ids:Array,

}

interface contacts_update_Params {
	/**联系人 id*/ 
	id:number,

	/**（可选项）联系人的姓氏*/ 
	lastName?:string,

	/**（可选项）联系人名字*/ 
	firstName?:string,

	/**（可选项）联系人中间名*/ 
	middleName?:string,

	/**（可选项）联系人名称前缀*/ 
	prefix?:string,

	/**（可选项）联系人名称后缀*/ 
	suffix?:string,

	/**（可选项）联系人电话组成的数组，**注意：若本参数不为空，则重置已存在的所有电话及其标签***/ 
	phones?:Array,

	/**（可选项）联系人邮箱*/ 
	email?:string,

	/**（可选项）联系人公司*/ 
	company?:string,

	/**（可选项）联系人职位*/ 
	title?:string,

	/**（可选项）联系人地址*/ 
	address?:JSON,

	/**（可选项）联系人备注*/ 
	note?:string,

}

interface contacts_move_Params {
	/**联系人 id*/ 
	id:number,

	/**联系人的分组 id；若分组不存在则不移动分组*/ 
	groupId:number,

}

interface contacts_query_Params {
	/**联系人 id 组成的数组，若 id 不存在则不处理*/ 
	ids:Array,

}

interface contacts_queryByKeyword_Params {
	/**要查询的关键字 **注意：仅搜索 lastName 和 firstName 包含的关键字***/ 
	keyword:string,

}

interface contacts_queryByPage_Params {
	/**（可选项）每页联系人的数量，若不传则返回全部联系人，**不建议不传本参数***/ 
	count?:number,

	/**（可选项）联系人的分页索引*/ 
	pageIndex?:number,

	/**（可选项）是否排序返回*/ 
	isSort?:number,

}

interface contacts_createGroup_Params {
	/**分组名*/ 
	groupName:string,

}

interface contacts_deleteGroup_Params {
	/**分组 id*/ 
	groupId:number,

}

interface contacts_queryByGroupId_Params {
	/**（可选项）要查找的分组 id*/ 
	groupId?:number,

}

interface nfc {
	/** 判断设备是否支持NFC(iOS请在初始化之前进行验证)*/ 
	readingAvailable(callback?: (ret:JSON, err:JSON) => void):void

	/** 识别结果监听(Android模式设置此参数可以达到整个App内拦截，不会弹出手机类其他应用)*/ 
	addEventListener():void

	/** 移除NFC数据监听*/ 
	removeEventListener():void

	/**
	 * `配置读写标签界面UI元素（不执行本接口则选用模块默认UI布局方案）`
	 * ========params==========
	 *
	 * `isDebug` :boolean : 开启调试模式时，不支持nfc的手机可以打开界面看UI效果(Android有效)。
	 *
	 * `backgroundColor` :string : 页面背景色(Android有效)
	 *
	 * `title` :JSON : 顶部标题样式配置(Android有效)
	 *
	 * `center` :JSON : 页面中间提示内容样式配置(Android有效)
	 *
	 * `alertMessages` :JSON : iOS提示信息多语言配置(iOS有效)
	 */
	initPageConfig(params:nfc_initPageConfig_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `写NFC标签文本或者16进制数据`
	 * ========params==========
	 *
	 * `isOnlyFirst` :boolean : （可选项）是否仅解析一次 (单次:true 多次:false)(设置为true时，请参考监听返回错误代码204对逻辑进行处理)(仅iOS有效)
	 *
	 * `type` :string : （必填项）写入数据类型(text,byte)。
	 *
	 * `mimeType` :string : （必填项）mimeType(byte时有效)。
	 *
	 * `data` :string : （必填项）要写入NFC的字符串内容。
	 *
	 * `isTag` :boolean : （可选项）是否是ISO14443,ISO15693,ISO18092类型卡数据写入(仅iOS有效)
	 */
	writeText(params:nfc_writeText_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `读NFC标签文本数据`
	 * ========params==========
	 *
	 * `isOnlyFirst` :boolean : （可选项）是否仅解析一次 (单次:true 多次:false)(设置为true时，请参考监听返回错误代码204对逻辑进行处理)(仅iOS有效)
	 *
	 * `isParseContent` :boolean : （可选项）是否自动解析结果resultJson (解析:true 不解析:false)(仅iOS有效)
	 *
	 * `isTag` :boolean : （可选项）是否是ISO14443,ISO15693,ISO18092类型卡读取(仅iOS有效)
	 */
	readText(params:nfc_readText_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface nfc_initPageConfig_Params {
	/**开启调试模式时，不支持nfc的手机可以打开界面看UI效果(Android有效)。*/ 
	isDebug:boolean,

	/**页面背景色(Android有效)*/ 
	backgroundColor:string,

	/**顶部标题样式配置(Android有效)*/ 
	title:JSON,

	/**页面中间提示内容样式配置(Android有效)*/ 
	center:JSON,

	/**iOS提示信息多语言配置(iOS有效)*/ 
	alertMessages:JSON,

}

interface nfc_writeText_Params {
	/**（可选项）是否仅解析一次 (单次:true 多次:false)(设置为true时，请参考监听返回错误代码204对逻辑进行处理)(仅iOS有效)*/ 
	isOnlyFirst?:boolean,

	/**（必填项）写入数据类型(text,byte)。*/ 
	type:string,

	/**（必填项）mimeType(byte时有效)。*/ 
	mimeType:string,

	/**（必填项）要写入NFC的字符串内容。*/ 
	data:string,

	/**（可选项）是否是ISO14443,ISO15693,ISO18092类型卡数据写入(仅iOS有效)*/ 
	isTag?:boolean,

}

interface nfc_readText_Params {
	/**（可选项）是否仅解析一次 (单次:true 多次:false)(设置为true时，请参考监听返回错误代码204对逻辑进行处理)(仅iOS有效)*/ 
	isOnlyFirst?:boolean,

	/**（可选项）是否自动解析结果resultJson (解析:true 不解析:false)(仅iOS有效)*/ 
	isParseContent?:boolean,

	/**（可选项）是否是ISO14443,ISO15693,ISO18092类型卡读取(仅iOS有效)*/ 
	isTag?:boolean,

}

interface mediaScanner {
}
interface ble {
	/** 判断是否有访问蓝牙的权限*/ 
	sysAuth(callback?: (ret:JSON) => void):void

	/** 调整系统设置页面*/ 
	settings():void

	/** 初始化蓝牙4.0管理器*/ 
	initManager():void

	/**
	 * `开始搜索蓝牙4.0设备，模块内部会不断的扫描更新附近的蓝牙4.0设备信息，可通过 getPeripheral 接口来获取扫描到的设备信息。若要停止扫描则调用 stopScan 接口`
	 * ========params==========
	 *
	 * `serviceUUIDs` :Array : （可选项）要扫描的蓝牙4.0设备的服务（service）的 UUID（字符串） 组成的数组，若不传则扫描附近的所有支持蓝牙4.0的设备
	 *
	 * `clean` :boolean : （可选项）扫描前是否清空已搜索到的记录在本地的外围设备信息
	 */
	scan(params:ble_scan_Params, callback?: (ret:JSON) => void):void

	/** 经典蓝牙扫描方式，可通过 getPeripheral 接口来获取扫描到的设备信息，扫描结束后会自动停止。注意仅单例模式下才能正常调用此方法*/ 
	discovery():void

	/** 获取当前扫描到的所有外围设备信息*/ 
	getPeripheral():void

	/**
	 * `获取当前扫描到的所有外围设备的 rssi`
	 * ========params==========
	 *
	 * `peripheralUUID` :string : 要获取rssi值的外围设备的 UUID
	 */
	getPeripheralRssi(params:ble_getPeripheralRssi_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 判断是否正在扫描*/ 
	isScanning():void

	/** 停止搜索附近的蓝牙设备*/ 
	stopScan():void

	/**
	 * `连接指定外围设备。iOS端无超时判断，android端默认有30秒超时判断`
	 * ========params==========
	 *
	 * `peripheralUUID` :string : 要连接的外围设备的 UUID
	 */
	connect(params:ble_connect_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `断开与指定外围设备的连接`
	 * ========params==========
	 *
	 * `peripheralUUID` :string : 要断开连接的外围设备的 UUID
	 */
	disconnect(params:ble_disconnect_Params, callback?: (ret:JSON) => void):void

	/**
	 * `判断与指定外围设备是否为连接状态`
	 * ========params==========
	 *
	 * `peripheralUUID` :string : 指定外围设备的 UUID
	 */
	isConnected(params:ble_isConnected_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据 UUID 找到所有匹配的蓝牙外围设备信息**Android 平台暂不支持本接口**`
	 * ========params==========
	 *
	 * `peripheralUUIDs` :string : 指定的蓝牙外围设备的 UUID 组成的数组
	 */
	retrievePeripheral(params:ble_retrievePeripheral_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据指定的服务，找到当前系统处于连接状态的蓝牙中包含这个服务的所有蓝牙外围设备信息**Andaroid 平台暂不支持本接口**`
	 * ========params==========
	 *
	 * `serviceUUIDs` :Array : 指定的蓝牙4.0设备的服务（service）的 UUID（字符串） 组成的数组
	 */
	retrieveConnectedPeripheral(params:ble_retrieveConnectedPeripheral_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据指定的外围设备 UUID 获取该外围设备的所有服务`
	 * ========params==========
	 *
	 * `peripheralUUID` :string : 指定的蓝牙外围设备的 UUID
	 */
	discoverService(params:ble_discoverService_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `根据指定的外围设备 UUID 及其服务 UUID 获取该外围设备的所有特征（Characteristic）`
	 * ========params==========
	 *
	 * `serviceUUID` :string : 指定的服务的 UUID
	 *
	 * `peripheralUUID` :string : 指定的蓝牙外围设备的 UUID
	 */
	discoverCharacteristics(params:ble_discoverCharacteristics_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `根据指定的外围设备 UUID 及其服务 UUID 和特征 UUID 获取该外围设备的所有描述符（Descriptor）`
	 * ========params==========
	 *
	 * `peripheralUUID` :string : 指定的蓝牙外围设备的 UUID
	 *
	 * `serviceUUID` :string : 指定的服务的 UUID
	 *
	 * `characteristicUUID` :string : 指定的特征的 UUID
	 */
	discoverDescriptorsForCharacteristic(params:ble_discoverDescriptorsForCharacteristic_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `根据指定的外围设备 UUID 及其服务 UUID 和特征 UUID 监听数据回发`
	 * ========params==========
	 *
	 * `peripheralUUID` :string : 指定的蓝牙外围设备的 UUID
	 *
	 * `serviceUUID` :string : 指定的服务的 UUID
	 *
	 * `characteristicUUID` :string : 指定的特征的 UUID
	 */
	setNotify(params:ble_setNotify_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 停止监听数据。调用setNotify接口后开始监听数据，不需要继续监听时调用disconnect断开链接，在iOS 平台上还需要调用此接口来停止监听。*/ 
	stopNotify():void

	/**
	 * `根据指定的外围设备 UUID 及其服务 UUID 和特征 UUID 读取数据`
	 * ========params==========
	 *
	 * `peripheralUUID` :string : 指定的蓝牙外围设备的 UUID
	 *
	 * `serviceUUID` :string : 指定的服务的 UUID
	 *
	 * `characteristicUUID` :string : 指定的特征的 UUID
	 */
	readValueForCharacteristic(params:ble_readValueForCharacteristic_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `根据指定的外围设备 UUID 及其服务 UUID 和特征 UUID 及其描述符获取数据`
	 * ========params==========
	 *
	 * `peripheralUUID` :string : 指定的蓝牙外围设备的 UUID
	 *
	 * `serviceUUID` :string : 指定的服务的 UUID
	 *
	 * `characteristicUUID` :string : 指定的特征的 UUID
	 *
	 * `descriptorUUID` :string : 指定的描述符的 UUID
	 */
	readValueForDescriptor(params:ble_readValueForDescriptor_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `根据指定的外围设备 UUID 及其服务 UUID 和特征 UUID 写数据`
	 * ========params==========
	 *
	 * `peripheralUUID` :string : 指定的蓝牙外围设备的 UUID
	 *
	 * `serviceUUID` :string : 指定的服务的 UUID
	 *
	 * `characteristicUUID` :string : 指定的特征的 UUID
	 *
	 * `value` :string : 要写入的数据 ，十六进制的字符串
	 *
	 * `writeType` :string : （可选项）写入数据时的类型
	 */
	writeValueForCharacteristic(params:ble_writeValueForCharacteristic_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `根据指定的外围设备 UUID 及其服务 UUID 和特征 UUID 及其描述符发送数据`
	 * ========params==========
	 *
	 * `peripheralUUID` :string : 指定的蓝牙外围设备的 UUID
	 *
	 * `serviceUUID` :string : 指定的服务的 UUID
	 *
	 * `characteristicUUID` :string : 指定的特征的 UUID
	 *
	 * `descriptorUUID` :string : 指定的描述符的 UUID
	 *
	 * `value` :string : 要发送的数据，十六进制的字符串
	 */
	writeValueForDescriptor(params:ble_writeValueForDescriptor_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `连接多台外围设备`
	 * ========params==========
	 *
	 * `peripheralUUIDs` :Array : 要连接的外围设备的 UUID 字符串组成的数组
	 */
	connectPeripherals(params:ble_connectPeripherals_Params, callback?: (ret:JSON) => void):void

	/**
	 * `根据指定的外围设备 UUID 及其服务 UUID 和特征 UUID 监听数据`
	 * ========params==========
	 *
	 * `peripheralUUID` :string : 指定的蓝牙外围设备的 UUID
	 *
	 * `serviceUUID` :string : 指定的服务的 UUID
	 *
	 * `characteristicUUID` :string : 指定的特征的 UUID
	 */
	setSimpleNotify(params:ble_setSimpleNotify_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 获取模块当前缓存的所监听蓝牙设备的所有数据*/ 
	getAllSimpleNotifyData():void

	/** 清空模块当前缓存的所监听蓝牙设备的所有数据*/ 
	clearAllSimpleNotifyData():void

	/** 清空已搜索到的记录在本地的外围设备信息。建议在没有连接的情况下调用，否则与外围设备相关的一系列接口均会失效*/ 
	clean():void

	/** 打开蓝牙*/ 
	openBluetooth():void

	/** 设置蓝牙状态监听*/ 
	setBluetoothListener():void

	/** 取消蓝牙状态监听*/ 
	removeBlueToothListener():void

	/** targetsdk为31时用于申请Android12设备上所需要的蓝牙权限*/ 
	requestBlePermission():void

	/**
	 * `当发现指定的蓝牙服务后，通过设置mtu提高对方发送数据的容量。注意由于Android系统不同厂商定制化差异以及手机ble版本不同，mtu可设置的最大值不统一;mtu设置成功之后，需要等待几秒钟等待设备更新设置之后再进行其他操作。`
	 * ========params==========
	 *
	 * `peripheralUUID` :string : 指定的蓝牙外围设备的 UUID
	 *
	 * `mtu` :number : 指定要修改的mtu的值，默认为20
	 */
	setMtu(params:ble_setMtu_Params, callback?: (ret:JSON) => void):void

}
interface ble_scan_Params {
	/**（可选项）要扫描的蓝牙4.0设备的服务（service）的 UUID（字符串） 组成的数组，若不传则扫描附近的所有支持蓝牙4.0的设备*/ 
	serviceUUIDs?:Array,

	/**（可选项）扫描前是否清空已搜索到的记录在本地的外围设备信息*/ 
	clean?:boolean,

}

interface ble_getPeripheralRssi_Params {
	/**要获取rssi值的外围设备的 UUID*/ 
	peripheralUUID:string,

}

interface ble_connect_Params {
	/**要连接的外围设备的 UUID*/ 
	peripheralUUID:string,

}

interface ble_disconnect_Params {
	/**要断开连接的外围设备的 UUID*/ 
	peripheralUUID:string,

}

interface ble_isConnected_Params {
	/**指定外围设备的 UUID*/ 
	peripheralUUID:string,

}

interface ble_retrievePeripheral_Params {
	/**指定的蓝牙外围设备的 UUID 组成的数组*/ 
	peripheralUUIDs:string,

}

interface ble_retrieveConnectedPeripheral_Params {
	/**指定的蓝牙4.0设备的服务（service）的 UUID（字符串） 组成的数组*/ 
	serviceUUIDs:Array,

}

interface ble_discoverService_Params {
	/**指定的蓝牙外围设备的 UUID*/ 
	peripheralUUID:string,

}

interface ble_discoverCharacteristics_Params {
	/**指定的服务的 UUID*/ 
	serviceUUID:string,

	/**指定的蓝牙外围设备的 UUID*/ 
	peripheralUUID:string,

}

interface ble_discoverDescriptorsForCharacteristic_Params {
	/**指定的蓝牙外围设备的 UUID*/ 
	peripheralUUID:string,

	/**指定的服务的 UUID*/ 
	serviceUUID:string,

	/**指定的特征的 UUID*/ 
	characteristicUUID:string,

}

interface ble_setNotify_Params {
	/**指定的蓝牙外围设备的 UUID*/ 
	peripheralUUID:string,

	/**指定的服务的 UUID*/ 
	serviceUUID:string,

	/**指定的特征的 UUID*/ 
	characteristicUUID:string,

}

interface ble_readValueForCharacteristic_Params {
	/**指定的蓝牙外围设备的 UUID*/ 
	peripheralUUID:string,

	/**指定的服务的 UUID*/ 
	serviceUUID:string,

	/**指定的特征的 UUID*/ 
	characteristicUUID:string,

}

interface ble_readValueForDescriptor_Params {
	/**指定的蓝牙外围设备的 UUID*/ 
	peripheralUUID:string,

	/**指定的服务的 UUID*/ 
	serviceUUID:string,

	/**指定的特征的 UUID*/ 
	characteristicUUID:string,

	/**指定的描述符的 UUID*/ 
	descriptorUUID:string,

}

interface ble_writeValueForCharacteristic_Params {
	/**指定的蓝牙外围设备的 UUID*/ 
	peripheralUUID:string,

	/**指定的服务的 UUID*/ 
	serviceUUID:string,

	/**指定的特征的 UUID*/ 
	characteristicUUID:string,

	/**要写入的数据 ，十六进制的字符串*/ 
	value:string,

	/**（可选项）写入数据时的类型*/ 
	writeType?:string,

}

interface ble_writeValueForDescriptor_Params {
	/**指定的蓝牙外围设备的 UUID*/ 
	peripheralUUID:string,

	/**指定的服务的 UUID*/ 
	serviceUUID:string,

	/**指定的特征的 UUID*/ 
	characteristicUUID:string,

	/**指定的描述符的 UUID*/ 
	descriptorUUID:string,

	/**要发送的数据，十六进制的字符串*/ 
	value:string,

}

interface ble_connectPeripherals_Params {
	/**要连接的外围设备的 UUID 字符串组成的数组*/ 
	peripheralUUIDs:Array,

}

interface ble_setSimpleNotify_Params {
	/**指定的蓝牙外围设备的 UUID*/ 
	peripheralUUID:string,

	/**指定的服务的 UUID*/ 
	serviceUUID:string,

	/**指定的特征的 UUID*/ 
	characteristicUUID:string,

}

interface ble_setMtu_Params {
	/**指定的蓝牙外围设备的 UUID*/ 
	peripheralUUID:string,

	/**指定要修改的mtu的值，默认为20*/ 
	mtu:number,

}

interface deviceInfo {
	/** 得到系统版本*/ 
	getRelease(callback?: (ret:JSON) => void):void

	/** 得到设备品牌*/ 
	getBrand(callback?: (ret:JSON) => void):void

	/** 得到手机型号*/ 
	getModel(callback?: (ret:JSON) => void):void

	/** 得到设备版本号*/ 
	getId(callback?: (ret:JSON) => void):void

	/** 得到设备显示版本包*/ 
	getDisplay(callback?: (ret:JSON) => void):void

	/** 得到产品名称*/ 
	getProduct(callback?: (ret:JSON) => void):void

	/** 得到设备制造商*/ 
	getManufacturer(callback?: (ret:JSON) => void):void

	/** 得到设备驱动名称*/ 
	getDevice(callback?: (ret:JSON) => void):void

	/** 得到设备硬件名称*/ 
	getHardware(callback?: (ret:JSON) => void):void

	/** 得到设备唯一标识*/ 
	getFingerprint(callback?: (ret:JSON) => void):void

	/** 得到串口序列号*/ 
	getSerial(callback?: (ret:JSON) => void):void

	/** 得到设备版本类型*/ 
	getType(callback?: (ret:JSON) => void):void

	/** 得到设备标签*/ 
	getTags(callback?: (ret:JSON) => void):void

	/** 得到设备主机地址*/ 
	getHost(callback?: (ret:JSON) => void):void

	/** 得到设备用户名*/ 
	getUser(callback?: (ret:JSON) => void):void

	/** 得到固件开发版本代号*/ 
	getCodename(callback?: (ret:JSON) => void):void

	/** 得到源码控制版本号*/ 
	getIncremental(callback?: (ret:JSON) => void):void

	/** 得到设备基板名称*/ 
	getBoard(callback?: (ret:JSON) => void):void

	/** 得到设备引导程序版本号*/ 
	getBootloader(callback?: (ret:JSON) => void):void

	/** 得到Build时间*/ 
	getTime(callback?: (ret:JSON) => void):void

	/** 得到系统的API级别*/ 
	getSdkInt(callback?: (ret:JSON) => void):void

}
interface playText {
	/**
	 * `播放文本`
	 * ========params==========
	 *
	 * `text` :string : 语音播放内容文本。
	 *
	 * `rate` :number : 播放速率
	 */
	play(params:playText_play_Params):void

	/** 继续播放文本*/ 
	continuePlay():void

	/** 停止播放*/ 
	stopPlay():void

	/** 暂停播放文本*/ 
	pausePlay():void

	/** 获取播放状态*/ 
	playState(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `监听事件`
	 * ========params==========
	 *
	 * `name` :string : 事件名称。
	 */
	addEventListener(params:playText_addEventListener_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface playText_play_Params {
	/**语音播放内容文本。*/ 
	text:string,

	/**播放速率*/ 
	rate:number,

}

interface playText_addEventListener_Params {
	/**事件名称。*/ 
	name:string,

}

interface flashLight {
	/** 打开手电筒*/ 
	open():void

	/** 关闭手电筒*/ 
	close():void

}
interface moduleJiaBo {
	/** 搜索蓝牙*/ 
	discoveryDevice(callback?: (ret:JSON, err:JSON) => void):void

}
interface xwScanner {
	/** 打开自带UI扫码功能*/ 
	openScanner(callback?: (ret:JSON) => void):void

}
interface mySettingInfo {
	/**
	 * `启动系统常用的设置页面的接口`
	 * ========params==========
	 *
	 * `index` :number : （可选项）要获取的应用类型，值大于14的只有Android有效
	 */
	settingInt(params:mySettingInfo_settingInt_Params):void

}
interface mySettingInfo_settingInt_Params {
	/**（可选项）要获取的应用类型，值大于14的只有Android有效*/ 
	index?:number,

}

interface vibration {
	/**
	 * `振动`
	 * ========params==========
	 *
	 * `time` :number : 数字的单位是毫秒，表示振动的时间
	 */
	vibrate(params:vibration_vibrate_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `连续振动`
	 * ========params==========
	 *
	 * `time` :Array : 数字的单位是毫秒，表示打开或关闭振动器的一系列时间长度
	 *
	 * `times` :number : 重复模式的索引
	 */
	vibrates(params:vibration_vibrates_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 取消振动*/ 
	cancel():void

}
interface vibration_vibrate_Params {
	/**数字的单位是毫秒，表示振动的时间*/ 
	time:number,

}

interface vibration_vibrates_Params {
	/**数字的单位是毫秒，表示打开或关闭振动器的一系列时间长度*/ 
	time:Array,

	/**重复模式的索引*/ 
	times:number,

}

interface FNSettings {
	/**
	 * `设置屏幕旋转模式`
	 * ========params==========
	 *
	 * `mode` :string : （可选项）屏幕旋转模式
	 */
	setScreenRotationMode(params:FNSettings_setScreenRotationMode_Params):void

	/** 获取屏幕旋转模式*/ 
	getScreenRotationMode():void

	/**
	 * `设置屏幕亮度模式`
	 * ========params==========
	 *
	 * `mode` :string : （可选项）屏幕亮度模式
	 */
	setScreenBrightnessMode(params:FNSettings_setScreenBrightnessMode_Params):void

	/** 获取屏幕亮度模式*/ 
	getScreenBrightnessMode():void

}
interface FNSettings_setScreenRotationMode_Params {
	/**（可选项）屏幕旋转模式*/ 
	mode?:string,

}

interface FNSettings_setScreenBrightnessMode_Params {
	/**（可选项）屏幕亮度模式*/ 
	mode?:string,

}

interface manageStorage {
	/** 申请所有文件读写权限*/ 
	requestAllFilePermission():void

	/** 判断是否已授予所有文件权限*/ 
	hasAllFilePermission():void

	/** 获取当前targetSdkVersion，targetSdkVersion为30或以上时 即android11以上才可能会需要获取所有文件权限*/ 
	getTargetVersion():void

	/** 获取当前系统版本*/ 
	getDeviceVersion():void

	/** 获取外部存储私有空间总大小*/ 
	getTotalBytes():void

	/** 获取外部存储私有空间可用大小*/ 
	getFreeBytes():void

	/** 整理外部私有存储空间，弹框提示用户操作*/ 
	manageStorage():void

	/** 清理外部存储空间，弹框提示用户操作,需要在已经获取所有文件权限操作*/ 
	clearStorage():void

}
interface moduleSMSListening {
	/** 获取所有联系人方法。返回json数组数据。*/ 
	getCon():void

	/** 查询历史短信，返回json数组。*/ 
	getMsg():void

	/** 启动短信监听程序，启动后新收到的短信回自动获取并返回。获取短信后自动停止监听，如需要再次监听需要再次调用此方法。如一只为收到短信，则系统会自动回收，无需手动关闭监听程序。备注：由于目前手机具有短信验证码保护功能，可导致无法获取新收到的短信验证码*/ 
	startListening():void

}
interface blePrintHaier {
	/** 初始化蓝牙4.0管理器*/ 
	initManager():void

	/**
	 * `开始搜索蓝牙4.0设备，模块内部会不断的扫描更新附近的蓝牙4.0设备信息，可通过 getPeripheral 接口来获取扫描到的设备信息。若要停止扫描则调用 stopScan 接口`
	 * ========params==========
	 *
	 * `serviceUUIDs` :Array : （可选项）要扫描的蓝牙4.0设备的服务（service）的 UUID（字符串） 组成的数组，若不传则扫描附近的所有支持蓝牙4.0的设备
	 *
	 * `clean` :boolean : （可选项）扫描前是否清空已搜索到的记录在本地的外围设备信息
	 */
	scan(params:blePrintHaier_scan_Params, callback?: (ret:JSON) => void):void

	/** 获取当前扫描到的所有外围设备信息*/ 
	getPeripheral():void

	/** 判断是否正在扫描*/ 
	isScanning():void

	/**
	 * `连接指定外围设备。iOS端无超时判断，android端默认有30秒超时判断`
	 * ========params==========
	 *
	 * `peripheralUUID` :string : 要连接的外围设备的 UUID
	 */
	connect(params:blePrintHaier_connect_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `断开与指定外围设备的连接`
	 * ========params==========
	 *
	 * `peripheralUUID` :string : 要断开连接的外围设备的 UUID
	 */
	disconnect(params:blePrintHaier_disconnect_Params, callback?: (ret:JSON) => void):void

	/**
	 * `判断与指定外围设备是否为连接状态`
	 * ========params==========
	 *
	 * `peripheralUUID` :string : 描述：指定外围设备的 UUID。
	 */
	isConnected(params:blePrintHaier_isConnected_Params, callback?: (ret:JSON) => void):void

}
interface blePrintHaier_scan_Params {
	/**（可选项）要扫描的蓝牙4.0设备的服务（service）的 UUID（字符串） 组成的数组，若不传则扫描附近的所有支持蓝牙4.0的设备*/ 
	serviceUUIDs?:Array,

	/**（可选项）扫描前是否清空已搜索到的记录在本地的外围设备信息*/ 
	clean?:boolean,

}

interface blePrintHaier_connect_Params {
	/**要连接的外围设备的 UUID*/ 
	peripheralUUID:string,

}

interface blePrintHaier_disconnect_Params {
	/**要断开连接的外围设备的 UUID*/ 
	peripheralUUID:string,

}

interface blePrintHaier_isConnected_Params {
	/**描述：指定外围设备的 UUID。*/ 
	peripheralUUID:string,

}

interface aIMEI {
	/** 获取IMEI。*/ 
	getIMEI():void

	/** 是否有权限。*/ 
	hasPermission():void

}
interface customKeyboard {
	/**
	 * `打开`
	 * ========params==========
	 *
	 * `keyboardImage` :JSON : 键盘区域的图片
	 *
	 * `click` :JSON : (可选项)键盘区域点击效果样式配置
	 *
	 * `toolBar` :JSON : (可选项)工具栏配置，不传则不显示工具栏
	 */
	setKeyboard(params:customKeyboard_setKeyboard_Params, callback?: (ret:JSON) => void):void

	/**
	 * `改变键盘图片`
	 * ========params==========
	 *
	 * `keyboardImage` :JSON : 键盘区域的图片
	 */
	changeKeyboard(params:customKeyboard_changeKeyboard_Params):void

	/**
	 * `刷新工具栏`
	 * ========params==========
	 *
	 * `toolBar` :JSON : (可选项)工具栏配置，不传则不显示工具栏
	 */
	changeToolBar(params:customKeyboard_changeToolBar_Params):void

	/** 监听键盘点击事件*/ 
	addClickListener():void

	/** 键盘上部工具栏按钮点击事件监听*/ 
	addToolBarListener():void

	/** 关闭*/ 
	close():void

	/** 显示*/ 
	show():void

	/** 隐藏*/ 
	hide():void

}
interface customKeyboard_setKeyboard_Params {
	/**键盘区域的图片*/ 
	keyboardImage:JSON,

	/**(可选项)键盘区域点击效果样式配置*/ 
	click?:JSON,

	/**(可选项)工具栏配置，不传则不显示工具栏*/ 
	toolBar?:JSON,

}

interface customKeyboard_changeKeyboard_Params {
	/**键盘区域的图片*/ 
	keyboardImage:JSON,

}

interface customKeyboard_changeToolBar_Params {
	/**(可选项)工具栏配置，不传则不显示工具栏*/ 
	toolBar?:JSON,

}

interface isSimulator {
	/** 判断当前设备是否是虚拟设备*/ 
	isSimulator():void

}
interface usbSerial {
	/** 获取设备串口列表*/ 
	examine():void

	/** 打开串口并接收异步RX数据*/ 
	openRead():void

	/** 向串口发送数据*/ 
	sendPort():void

	/** 关闭打开的串口*/ 
	close():void

}
interface brightness2016 {
	/**
	 * `设置系统屏幕亮度。`
	 * ========params==========
	 *
	 * `brightness` :number : 表示亮度，取值范围：0--255 暗->亮
	 */
	setBrightness(params:brightness2016_setBrightness_Params):void

	/** 获取系统屏幕亮度。*/ 
	getBrightness(callback?: (ret:JSON) => void):void

	/**
	 * `设置当前App屏幕亮度。`
	 * ========params==========
	 *
	 * `brightness` :number : 表示亮度，取值范围：0--255 暗->亮
	 */
	setAppBrightness(params:brightness2016_setAppBrightness_Params):void

}
interface brightness2016_setBrightness_Params {
	/**表示亮度，取值范围：0--255 暗->亮*/ 
	brightness:number,

}

interface brightness2016_setAppBrightness_Params {
	/**表示亮度，取值范围：0--255 暗->亮*/ 
	brightness:number,

}

interface bgnWiFi {
	/**
	 * `添加一个WiFi网络`
	 * ========params==========
	 *
	 * `ssid` :string : （必填项）网络SSID值。
	 *
	 * `password` :string : （可选项）密码。
	 *
	 * `type` :string : （可选项）网络类型值。选项范围【WEP、PSK、EAP】
	 */
	addNetwork(params:bgnWiFi_addNetwork_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `连接一个WiFi网络`
	 * ========params==========
	 *
	 * `ssid` :string : （必填项）网络SSID值。
	 */
	connect(params:bgnWiFi_connect_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `断开当前WiFi网络连接`
	 * ========params==========
	 *
	 * `ret` :JSON : null
	 *
	 * `err` :JSON : null
	 */
	disconnect(params:bgnWiFi_disconnect_Params):void

	/** 返回当前保存的所有wifi网络的密码，**该功需要具有root权限***/ 
	getPassword(callback?: (ret:JSON, err:JSON) => void):void

	/** 获取当前连接wifi网络的信息*/ 
	getWifiInfo(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `判断当前wifi是否连接成功的`
	 * ========params==========
	 *
	 * `ret` :JSON : null
	 *
	 * `err` :JSON : null
	 */
	isConnected(params:bgnWiFi_isConnected_Params):void

	/**
	 * `获取WiFi打开状态`
	 * ========params==========
	 *
	 * `ret` :JSON : null
	 *
	 * `err` :JSON : null
	 */
	isWifiEnabled(params:bgnWiFi_isWifiEnabled_Params):void

	/**
	 * `删除指定wifi网络`
	 * ========params==========
	 *
	 * `ssid` :string : （必填项）网络SSID值。
	 *
	 * `ret` :JSON : null
	 *
	 * `err` :JSON : null
	 */
	removeNetwork(params:bgnWiFi_removeNetwork_Params):void

	/**
	 * `设置WiFi状态 enabled为true表示打开WiFi,false表示关闭WiFi`
	 * ========params==========
	 *
	 * `enabled` :boolean : （必填项）true||false。
	 *
	 * `ret` :JSON : null
	 *
	 * `err` :JSON : null
	 */
	setWifiEnabled(params:bgnWiFi_setWifiEnabled_Params):void

	/**
	 * `开始扫描附近WiFi热点`
	 * ========params==========
	 *
	 * `ret` :JSON : null
	 *
	 * `err` :JSON : null
	 */
	startScan(params:bgnWiFi_startScan_Params):void

}
interface bgnWiFi_addNetwork_Params {
	/**（必填项）网络SSID值。*/ 
	ssid:string,

	/**（可选项）密码。*/ 
	password?:string,

	/**（可选项）网络类型值。选项范围【WEP、PSK、EAP】*/ 
	type?:string,

}

interface bgnWiFi_connect_Params {
	/**（必填项）网络SSID值。*/ 
	ssid:string,

}

interface bgnWiFi_disconnect_Params {
	/**null*/ 
	ret:JSON,

	/**null*/ 
	err:JSON,

}

interface bgnWiFi_isConnected_Params {
	/**null*/ 
	ret:JSON,

	/**null*/ 
	err:JSON,

}

interface bgnWiFi_isWifiEnabled_Params {
	/**null*/ 
	ret:JSON,

	/**null*/ 
	err:JSON,

}

interface bgnWiFi_removeNetwork_Params {
	/**（必填项）网络SSID值。*/ 
	ssid:string,

	/**null*/ 
	ret:JSON,

	/**null*/ 
	err:JSON,

}

interface bgnWiFi_setWifiEnabled_Params {
	/**（必填项）true||false。*/ 
	enabled:boolean,

	/**null*/ 
	ret:JSON,

	/**null*/ 
	err:JSON,

}

interface bgnWiFi_startScan_Params {
	/**null*/ 
	ret:JSON,

	/**null*/ 
	err:JSON,

}

interface cpuInfo {
	/** 得到CPU汇总信息*/ 
	getCpuInfo(callback?: (ret:JSON) => void):void

	/** 得到CPU最大频率（KHZ）*/ 
	getCpuMaxFreq(callback?: (ret:JSON) => void):void

	/** 得到CPU最小频率（KHZ）*/ 
	getMinFreq(callback?: (ret:JSON) => void):void

	/** 得到CPU当前频率（KHZ）*/ 
	getCurrentFreq(callback?: (ret:JSON) => void):void

}
interface shareBySystem {
	/**
	 * `分享文本或链接`
	 * ========params==========
	 *
	 * `text` :string : （必填项）需要分享的文本或链接
	 *
	 * `paths` :string : ： （必填项）需要分享的图片,支持widget://,fs://,cache://协议及远程图片地址
	 *
	 * `filename` :string : ： （可选项）若path地址为远程地址，可通过此参数设置文件的别名，注意：别名并不会更改远程网络文件的文件后缀
	 *
	 * `path` :string : ： （必填项）需要分享的图片,支持widget://,fs://,cache://协议及远程图片地址
	 *
	 * `filename` :string : ： （可选项）若path地址为远程地址，可通过此参数设置文件的别名，注意：别名并不会更改远程网络文件的文件后缀
	 *
	 * `path` :string : ： （必填项）需要分享的图片,支持widget://,fs://,cache://协议及远程图片地址
	 */
	openShareText(params:shareBySystem_openShareText_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface shareBySystem_openShareText_Params {
	/**（必填项）需要分享的文本或链接*/ 
	text:string,

	/**： （必填项）需要分享的图片,支持widget://,fs://,cache://协议及远程图片地址*/ 
	paths:string,

	/**： （可选项）若path地址为远程地址，可通过此参数设置文件的别名，注意：别名并不会更改远程网络文件的文件后缀*/ 
	filename?:string,

	/**： （必填项）需要分享的图片,支持widget://,fs://,cache://协议及远程图片地址*/ 
	path:string,

	/**： （可选项）若path地址为远程地址，可通过此参数设置文件的别名，注意：别名并不会更改远程网络文件的文件后缀*/ 
	filename?:string,

	/**： （必填项）需要分享的图片,支持widget://,fs://,cache://协议及远程图片地址*/ 
	path:string,

}

interface DVTorch {
	/** 切换闪光灯开关*/ 
	toggle():void

	/** 打开闪光灯*/ 
	open():void

	/** 关闭闪光灯*/ 
	close():void

}
interface gps {
	/** 获取定位服务开关状态。在Android上定位服务分3种，1、同时使用网络和GPS定位；2、仅使用GPS定位；3、仅使用网络定位。在iOS的设置界面上设置定位服务时只有一个开关，即打开和关闭定位服务。所以该接口的返回值需要把iOS和Android两个平台分开处理，请开发者注意。*/ 
	getGpsState():void

	/** 打开系统自带的gps设置界面，用户可在此界面打开或关闭gps*/ 
	openGpsSettingView():void

}
interface screen {
	/** 安卓端禁止截屏、录屏；ios端监听截屏和录屏，回调自行处理。*/ 
	banRecord():void

	/** 安卓端恢复截屏和录屏功能；IOS端移除录屏和截屏监听。*/ 
	close():void

}
interface wwprint {
	/**
	 * `打印默认标签模板。`
	 * ========params==========
	 *
	 * `msg` :string : 按照文档描述传入对应的xml，即可完成默认打印。
	 */
	printDefault(params:wwprint_printDefault_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 关闭连接。断开与打印机的连接。参数无，回调无。*/ 
	close():void

	/**
	 * `创建一张标签模板。`
	 * ========params==========
	 *
	 * `width` :any : 标签的宽度 数值类型 计算方式：标签的实际宽度（毫米）*8
	 *
	 * `height` :any : 标签的高度 数值类型：计算方式上同
	 *
	 * `angle` :any : 旋转角度。
	 */
	createPrintLabel(params:wwprint_createPrintLabel_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `往创建的标签上面添加元素。可以是文字，二维码，条码，线条，图片。`
	 * ========params==========
	 *
	 * `content` :string : 打印内容 类型是String （文字，二维码，条码，图片的base64编码）
	 *
	 * `positionX` :any : 在标签上面的X坐标
	 *
	 * `positionY` :any : 在标签上面的y坐标
	 *
	 * `width` :any : 所占标签的宽度 单位为象素
	 *
	 * `height` :any : 所占标签的高度  单位为象素
	 *
	 * `fountSize` :any : 文字类型时候的字体大小
	 *
	 * `degrees` :any : 元素旋转角度。
	 *
	 * `contentType` :string : 指定内容的类型  详情见补充说明。
	 */
	addPrintLabel(params:wwprint_addPrintLabel_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 提交一张创建的标签。此方法无参数，回调可以不加。只有在创建完成之后提交才有效，否则会回调模板为创建，如果没有设置回调，将不会有任何返回信息。*/ 
	submitLabel(callback?: (ret:JSON, err:JSON) => void):void

	/** 自定义方法打印。无参数，不需要状态可以不设置回调。只有在设置蓝牙连接对象和自定义模板创建并提交之后才有用。*/ 
	print():void

	/**
	 * `设置蓝牙连接对象。如果不需要返回结果，可以不用设置回调方法。`
	 * ========params==========
	 *
	 * `name` :string : null
	 */
	setBluetoothDevice(params:wwprint_setBluetoothDevice_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 获取搜索到的蓝牙设备。多个设备以“，”分割。无参数。*/ 
	getBluetoothDeviceList(callback?: (ret:JSON, err:JSON) => void):void

	/** 无参数。主要是清理之前创建的标签模板。如果不调用，则之前创建的标签将会被保存，直到该对象消失。*/ 
	clean(callback?: (ret:JSON, err:JSON) => void):void

}
interface wwprint_printDefault_Params {
	/**按照文档描述传入对应的xml，即可完成默认打印。*/ 
	msg:string,

}

interface wwprint_createPrintLabel_Params {
	/**标签的宽度 数值类型 计算方式：标签的实际宽度（毫米）*8*/ 
	width:any,

	/**标签的高度 数值类型：计算方式上同*/ 
	height:any,

	/**旋转角度。*/ 
	angle:any,

}

interface wwprint_addPrintLabel_Params {
	/**打印内容 类型是String （文字，二维码，条码，图片的base64编码）*/ 
	content:string,

	/**在标签上面的X坐标*/ 
	positionX:any,

	/**在标签上面的y坐标*/ 
	positionY:any,

	/**所占标签的宽度 单位为象素*/ 
	width:any,

	/**所占标签的高度  单位为象素*/ 
	height:any,

	/**文字类型时候的字体大小*/ 
	fountSize:any,

	/**元素旋转角度。*/ 
	degrees:any,

	/**指定内容的类型  详情见补充说明。*/ 
	contentType:string,

}

interface wwprint_setBluetoothDevice_Params {
	/**null*/ 
	name:string,

}

interface wifi {
	/**
	 * `扫描连接wifi`
	 * ========params==========
	 *
	 * `ssid` :string : （可选项）wifi名称，填写此参数将自动连接此wifi
	 *
	 * `password` :string : （可选项）自动连接wifi的密码
	 *
	 * `label` :string : （可选项）自动连接wifi的副标题
	 */
	scanWifi(params:wifi_scanWifi_Params, callback?: (ret:JSON) => void):void

}
interface wifi_scanWifi_Params {
	/**（可选项）wifi名称，填写此参数将自动连接此wifi*/ 
	ssid?:string,

	/**（可选项）自动连接wifi的密码*/ 
	password?:string,

	/**（可选项）自动连接wifi的副标题*/ 
	label?:string,

}

interface sensor {
	/** 得到单个传感器信息*/ 
	getInfo():void

	/** 得到所有安卓手机支持的传感器信息*/ 
	getInfos(callback?: (ret:JSON) => void):void

}
interface phoneInfo {
}
interface crManager {
	/**
	 * `判断是否有访问日历\提醒的权限`
	 * ========params==========
	 *
	 * `entityType` :string : （可选项）指定操作对象是日历还是提醒
	 */
	authorizationStatus(params:crManager_authorizationStatus_Params, callback?: (ret:JSON) => void):void

	/**
	 * `请求访问日历\提醒权限`
	 * ========params==========
	 *
	 * `entityType` :string : （可选项）指定操作对象是日历还是提醒
	 */
	requestAuth(params:crManager_requestAuth_Params, callback?: (ret:JSON) => void):void

	/**
	 * `添加日历、提醒行程分类`
	 * ========params==========
	 *
	 * `entityType` :string : （可选项）指定操作对象是日历还是提醒
	 *
	 * `title` :string : 新的分类的标题
	 *
	 * `color` :string : 分类的颜色，支持rgb、rgba、#
	 */
	addCalendar(params:crManager_addCalendar_Params, callback?: (ret:JSON) => void):void

	/**
	 * `移除日历、提醒行程分类`
	 * ========params==========
	 *
	 * `identifier` :string : 行程分类的 ID
	 */
	removeCalendar(params:crManager_removeCalendar_Params, callback?: (ret:JSON) => void):void

	/**
	 * `修改指定的日历、提醒行程分类`
	 * ========params==========
	 *
	 * `identifier` :string : 行程分类的 ID
	 *
	 * `title` :string : 新的分类的标题
	 *
	 * `color` :string : 分类的颜色，支持rgb、rgba、#
	 */
	updateCalendar(params:crManager_updateCalendar_Params, callback?: (ret:JSON) => void):void

}
interface crManager_authorizationStatus_Params {
	/**（可选项）指定操作对象是日历还是提醒*/ 
	entityType?:string,

}

interface crManager_requestAuth_Params {
	/**（可选项）指定操作对象是日历还是提醒*/ 
	entityType?:string,

}

interface crManager_addCalendar_Params {
	/**（可选项）指定操作对象是日历还是提醒*/ 
	entityType?:string,

	/**新的分类的标题*/ 
	title:string,

	/**分类的颜色，支持rgb、rgba、#*/ 
	color:string,

}

interface crManager_removeCalendar_Params {
	/**行程分类的 ID*/ 
	identifier:string,

}

interface crManager_updateCalendar_Params {
	/**行程分类的 ID*/ 
	identifier:string,

	/**新的分类的标题*/ 
	title:string,

	/**分类的颜色，支持rgb、rgba、#*/ 
	color:string,

}

interface statusBar {
	/** 获取当前设备的状态栏高度*/ 
	getStatusBarHeight(callback?: (ret:JSON) => void):void

}
interface smartConfigCheyw {
	/** 得到Ssid、Bssid的值*/ 
	getSsid():void

	/**
	 * `开始配置网络`
	 * ========params==========
	 *
	 * `ssid` :string : ssid的值
	 *
	 * `password` :string : wifi密码
	 *
	 * `Bssid` :string : Bssid的值
	 */
	startConfirm(params:smartConfigCheyw_startConfirm_Params, callback?: (ret:JSON) => void):void

	/**
	 * `配置成功之后发送指令`
	 * ========params==========
	 *
	 * `ip` :string : （可选项）ip地址
	 *
	 * `port` :string : （可选项）端口
	 *
	 * `sendStr` :string : 根据硬件要求传参数,发送的命令。
	 */
	sendCommand(params:smartConfigCheyw_sendCommand_Params, callback?: (ret:JSON) => void):void

}
interface smartConfigCheyw_startConfirm_Params {
	/**ssid的值*/ 
	ssid:string,

	/**wifi密码*/ 
	password:string,

	/**Bssid的值*/ 
	Bssid:string,

}

interface smartConfigCheyw_sendCommand_Params {
	/**（可选项）ip地址*/ 
	ip?:string,

	/**（可选项）端口*/ 
	port?:string,

	/**根据硬件要求传参数,发送的命令。*/ 
	sendStr:string,

}

interface ipAddress {
	/**
	 * `获取ip地址`
	 * ========params==========
	 *
	 * `isNetIp` :boolean : （可选项）是否获取ipv6的地址，(默认false，获取ipv4地址。仅ios有效)
	 */
	getIp(params:ipAddress_getIp_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface ipAddress_getIp_Params {
	/**（可选项）是否获取ipv6的地址，(默认false，获取ipv4地址。仅ios有效)*/ 
	isNetIp?:boolean,

}

interface simInfo {
}
interface moduleBarcodeScales {
	/**
	 * `初始化条码秤`
	 * ========params==========
	 *
	 * `scalseIp` :null : null
	 *
	 * `port` :string : （必填项）显示数据
	 */
	initBarcodeScales(params:moduleBarcodeScales_initBarcodeScales_Params, callback?: (ret:JSON) => void):void

	/**
	 * `发送PLU格式.txt文本`
	 * ========params==========
	 *
	 * `textPath` :string : （必填项）显示数据
	 */
	sendDatas(params:moduleBarcodeScales_sendDatas_Params, callback?: (ret:JSON) => void):void

	/** 断开条码秤连接*/ 
	disconnect(callback?: (ret:JSON) => void):void

}
interface moduleBarcodeScales_initBarcodeScales_Params {
	/**null*/ 
	scalseIp:null,

	/**（必填项）显示数据*/ 
	port:string,

}

interface moduleBarcodeScales_sendDatas_Params {
	/**（必填项）显示数据*/ 
	textPath:string,

}

interface mobileSignal {
	/** 获取手机卡运营商信息、网络信息和信号强度信息*/ 
	getSignal(callback?: (ret:JSON, err:JSON) => void):void

}
interface jpgInfoManager {
	/**
	 * `获取图片信息`
	 * ========params==========
	 *
	 * `imagePath` :string : 图片路径支持fs://,widget://;
	 */
	getImgInfo(params:jpgInfoManager_getImgInfo_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface jpgInfoManager_getImgInfo_Params {
	/**图片路径支持fs://,widget://;*/ 
	imagePath:string,

}

interface pedometer {
	/**  开始计步*/ 
	startCount():void

	/** 停止计步*/ 
	stopCount():void

	/** 获取当前统计的步数*****/ 
	getSteps():void

	/**
	 * `获取步数`
	 * ========params==========
	 *
	 * `startTime` :string : 开始日期
	 *
	 * `endTime` :string : 结束日期（结束日期和开始日期之间的差值不得超过三天，如果超过三天，按三天来算。）
	 *
	 * `count` :number : （可选项）获取最近数据的数量，默认为0,0代表最多数量.
	 *
	 * `remove` :boolean : （可选项）是否移除人为添加的步行数据
	 */
	getStepCount(params:pedometer_getStepCount_Params):void

}
interface pedometer_getStepCount_Params {
	/**开始日期*/ 
	startTime:string,

	/**结束日期（结束日期和开始日期之间的差值不得超过三天，如果超过三天，按三天来算。）*/ 
	endTime:string,

	/**（可选项）获取最近数据的数量，默认为0,0代表最多数量.*/ 
	count?:number,

	/**（可选项）是否移除人为添加的步行数据*/ 
	remove?:boolean,

}

interface smartPeak {
	/**  检查Service是否运行*/ 
	isServiceRunning():void

	/** 开启扫描服务*/ 
	startScanService():void

	/** 停止扫描服务*/ 
	stopScanService():void

	/** 开始扫描*/ 
	startScan():void

	/** 停止扫描*/ 
	stopScan():void

	/** 注册获取条码数据的广播接收者;*/ 
	registerGetBarCodeDataListener():void

	/** 注销条码获取广播*/ 
	unRegisterGetBarCodeDataListener():void

}
interface orientationSensor {
}
interface hardwareInfo {
	/** 获取设备所有网卡的IP和MAC地址列表*/ 
	getIpMacAddrList(callback?: (ret:JSON, err:JSON) => void):void

	/** 获取当前设备cpu使用率，cpu核心数，cpu最大速度，cpu最小速度，app内存占用大小*/ 
	getPerformanceInfo(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `根据传入参数的不同获得的字符串格式响应改变，默认为小写并且没有横线。`
	 * ========params==========
	 *
	 * `lower` :any : 默认GUID为小写，如果传入false则为大写
	 *
	 * `line` :any : 默认GUID中包含横线，如果传入false则无横线
	 */
	generateGuid(params:hardwareInfo_generateGuid_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `doPingTest主要是用来检测当前设备和指定的IP或者域名之间是否畅通，类似我们在windows常用的ping命令，异步回调函数可以获得ping的反馈信息。`
	 * ========params==========
	 *
	 * `host` :string : IP地址字符串。
	 */
	doPingTest(params:hardwareInfo_doPingTest_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** clearAppCache可以清空当前app缓存。*/ 
	clearAppCache():void

	/** clearAppData可以清空当前app数据（app会强制退出）。*/ 
	clearAppData():void

}
interface hardwareInfo_generateGuid_Params {
	/**默认GUID为小写，如果传入false则为大写*/ 
	lower:any,

	/**默认GUID中包含横线，如果传入false则无横线*/ 
	line:any,

}

interface hardwareInfo_doPingTest_Params {
	/**IP地址字符串。*/ 
	host:string,

}

interface modulePrinter {
	/** 获取小票机USB动态权限*/ 
	requestPermission(callback?: (ret:JSON) => void):void

	/**
	 * `初始化小票打印机`
	 * ========params==========
	 *
	 * `type` :null : null
	 *
	 * `isinstruction` :null : null
	 *
	 * `isbox` :null : null
	 *
	 * `mPrinterIp` :null : null
	 *
	 * `port` :string : （必填项）显示数据
	 */
	initPrint(params:modulePrinter_initPrint_Params, callback?: (ret:JSON) => void):void

	/**
	 * `打印小票`
	 * ========params==========
	 *
	 * `data` :JSON : （必填项）显示数据
	 */
	printData(params:modulePrinter_printData_Params, callback?: (ret:JSON) => void):void

	/** 使用小票机打开钱箱需要先调用获取权限接口然后初始化再打开钱箱*/ 
	openCashBox(callback?: (ret:JSON) => void):void

}
interface modulePrinter_initPrint_Params {
	/**null*/ 
	type:null,

	/**null*/ 
	isinstruction:null,

	/**null*/ 
	isbox:null,

	/**null*/ 
	mPrinterIp:null,

	/**（必填项）显示数据*/ 
	port:string,

}

interface modulePrinter_printData_Params {
	/**（必填项）显示数据*/ 
	data:JSON,

}

interface mtlNFC {
	/** 打开NFC，读取卡片信息。设备NFC功能打开后，应用在前台时调用此方法可以读取卡片信息返回。*/ 
	init(callback?: (ret:JSON) => void):void

	/** 使用完毕后需要调用此方法关闭*/ 
	unInit():void

}
interface proximitySensor {
}
interface compassLeveler {
	/** 打开指南针水平仪页面*/ 
	openCL():void

}
interface smsModule {
	/**
	 * `发送短信`
	 * ========params==========
	 *
	 * `numbers` :Array : 电话号码
	 *
	 * `text` :string : 发送短信的内容
	 *
	 * `silent` :boolean : （可选项）是否后台发送，只支持Android
	 */
	sms(params:smsModule_sms_Params, callback?: (ret:JSON) => void):void

	/**
	 * `跳转短信 App 并发送短信，仅支持 iOS 端`
	 * ========params==========
	 *
	 * `number` :string : 电话号码
	 *
	 * `text` :string : 发送短信的内容
	 */
	send(params:smsModule_send_Params):void

}
interface smsModule_sms_Params {
	/**电话号码*/ 
	numbers:Array,

	/**发送短信的内容*/ 
	text:string,

	/**（可选项）是否后台发送，只支持Android*/ 
	silent?:boolean,

}

interface smsModule_send_Params {
	/**电话号码*/ 
	number:string,

	/**发送短信的内容*/ 
	text:string,

}

interface openApp {
	/**
	 * `判断当前设备是否安装微信客户端`
	 * ========params==========
	 *
	 * `package` :string : （必填项）Android应用的包名
	 *
	 * `url` :string : （可选项）Android应用对于的下面网页地址
	 */
	openAppMarket(params:openApp_openAppMarket_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface openApp_openAppMarket_Params {
	/**（必填项）Android应用的包名*/ 
	package:string,

	/**（可选项）Android应用对于的下面网页地址*/ 
	url?:string,

}

interface cameraTool {
}
interface zjPrinter {
}
interface moduleLabelPrinter {
	/** 获取打印机设备权限*/ 
	requestPermission(callback?: (ret:JSON) => void):void

	/** 获取打印机设备信息*/ 
	printerUsb(callback?: (ret:JSON) => void):void

	/** 初始化*/ 
	initPrint(callback?: (ret:JSON) => void):void

	/**
	 * `打印标签`
	 * ========params==========
	 *
	 * `data` :JSON : （必填项）打印数据
	 */
	printerLabel(params:moduleLabelPrinter_printerLabel_Params, callback?: (ret:JSON) => void):void

	/** 断开蓝牙连接*/ 
	disconnect(callback?: (ret:JSON) => void):void

	/** 扫描蓝牙设备*/ 
	ScanBluetooth(callback?: (ret:JSON) => void):void

}
interface moduleLabelPrinter_printerLabel_Params {
	/**（必填项）打印数据*/ 
	data:JSON,

}

interface displayInfo {
	/** 得到逻辑密度*/ 
	getDensity(callback?: (ret:JSON) => void):void

	/** 得到屏幕密度*/ 
	getDensityDpi(callback?: (ret:JSON) => void):void

	/** 得到绝对高度*/ 
	getHeightPixels(callback?: (ret:JSON) => void):void

	/** 得到比例因子*/ 
	getScaledDensity(callback?: (ret:JSON) => void):void

	/** 得到绝对宽度*/ 
	getWidthPixels(callback?: (ret:JSON) => void):void

	/** 得到X尺寸屏幕每英寸的确切物理像素*/ 
	getXdpi(callback?: (ret:JSON) => void):void

	/** 得到Y尺寸屏幕每英寸的确切物理像素*/ 
	getYdpi(callback?: (ret:JSON) => void):void

}
interface sunmiV2Printer {
	/** 开启打印服务*/ 
	startService(callback?: (ret:JSON, err:JSON) => void):void

	/** 停止打印服务*/ 
	stopService(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `打印文字`
	 * ========params==========
	 *
	 * `text` :string : 要打印文字
	 *
	 * `size` :any : 字体大小
	 *
	 * `size` :any : 字体大小
	 *
	 * `isBole` :boolean : 粗体
	 *
	 * `isUnderLine` :boolean : 下划线
	 */
	printText(params:sunmiV2Printer_printText_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 打印数据*/ 
	printData(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `走纸`
	 * ========params==========
	 *
	 * `n` :any : 走纸行数
	 */
	lineWrap(params:sunmiV2Printer_lineWrap_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface sunmiV2Printer_printText_Params {
	/**要打印文字*/ 
	text:string,

	/**字体大小*/ 
	size:any,

	/**字体大小*/ 
	size:any,

	/**粗体*/ 
	isBole:boolean,

	/**下划线*/ 
	isUnderLine:boolean,

}

interface sunmiV2Printer_lineWrap_Params {
	/**走纸行数*/ 
	n:any,

}

interface myAppInfo {
	/**
	 * `读取手机应用基本信息的接口`
	 * ========params==========
	 *
	 * `isSys` :number : （可选项）要获取的应用类型
	 */
	getAppInfo(params:myAppInfo_getAppInfo_Params, callback?: (ret:JSON) => void):void

}
interface myAppInfo_getAppInfo_Params {
	/**（可选项）要获取的应用类型*/ 
	isSys?:number,

}

interface connectWifi {
}
interface vibrateUtil {
	/** 普通短震，ios中为 3D Touch 中 Peek 震动触感*/ 
	shortPeek():void

	/** 普通短震，ios中为3D Touch 按压弹出触感*/ 
	shortPop():void

	/** 连续震动三次，ios中为3D Touch 按压弹出触感*/ 
	threable():void

	/** 长震动*/ 
	longVibrate():void

	/** 多次间隔震动*/ 
	intervalVibrate():void

	/** 终止震动*/ 
	vibrateCancle():void

}
interface blesdk {
	/** 开始扫描周围的蓝牙设备,并返回扫描到的设备卡号*/ 
	startScan(callback?: (ret:JSON, err:JSON) => void):void

}
interface callRecord {
	/** 获取通话记录*/ 
	openCallRecord(callback?: (ret:JSON) => void):void

}
interface fileChooser {
	/**
	 * `打开`
	 * ========params==========
	 *
	 * `fileType` :null : 允许打开的文件类型，字符串'all',表示打开全部类型，或者传入允许打开类型的字符串数组；字符串'native_path'表示本地打开预览文件，预览文件路径由url字段传入。
	 *
	 * `url` :string : （可选项）本地打开预览文件本地路径，支持fs、widget，fileType为'native_path'时此参数生效
	 *
	 * `ret` :JSON : null
	 */
	startFile(params:fileChooser_startFile_Params):void

}
interface fileChooser_startFile_Params {
	/**允许打开的文件类型，字符串'all',表示打开全部类型，或者传入允许打开类型的字符串数组；字符串'native_path'表示本地打开预览文件，预览文件路径由url字段传入。*/ 
	fileType:null,

	/**（可选项）本地打开预览文件本地路径，支持fs、widget，fileType为'native_path'时此参数生效*/ 
	url?:string,

	/**null*/ 
	ret:JSON,

}

interface moduleSMS {
}
interface posPrinter {
	/**
	 * `获取蓝牙打印机列表`
	 * ========params==========
	 *
	 * `status` :string : （可选项）表示要获取绑定的设备还是搜索周边所有蓝牙设备
	 */
	getBluetoothPrinters(params:posPrinter_getBluetoothPrinters_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `绑定蓝牙打印机`
	 * ========params==========
	 *
	 * `address` :string : （必填项）蓝牙打印机 MAC 地址
	 *
	 * `pin` :string : （可选项）绑定蓝牙设备时需要输入的pin码
	 */
	createBondToPrinter(params:posPrinter_createBondToPrinter_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 获取USB打印机列表*/ 
	getUsbPrinters(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `将指定的蓝牙打印机解除绑定`
	 * ========params==========
	 *
	 * `address` :string : （必填项）要解除绑定的蓝牙打印机 MAC 地址
	 */
	removeBondToPrinter(params:posPrinter_removeBondToPrinter_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `将打印内容发送到指定地址的打印机（蓝牙打印机为MAC地址，网口打印机为IP地址），支持多机打印`
	 * ========params==========
	 *
	 * `taskList` :Array<JSON> : （必填项）打印机、打印内容、重复打印次数组成的JSON对象数组
	 *
	 * `ret` :JSON : null
	 *
	 * `err` :JSON : null
	 */
	printOnSpecifiedPrinters(params:posPrinter_printOnSpecifiedPrinters_Params):void

	/**
	 * `将打印内容发送到指定地址的打印机（蓝牙打印机为MAC地址，网口打印机为IP地址），支持多机打印`
	 * ========params==========
	 *
	 * `taskList` :Array<JSON> : （必填项）打印机、打印内容、重复打印次数组成的JSON对象数组
	 *
	 * `ret` :JSON : null
	 *
	 * `err` :JSON : null
	 */
	print(params:posPrinter_print_Params):void

	/**
	 * `向指定打印机发送 ESC/POS 指令（不了解ESC/POS指令慎用）`
	 * ========params==========
	 *
	 * `printerAddr` :string : （必填项）蓝牙打印机地址（可通过getBluetoothPrinters获取）、IP打印机地址、USB打印机地址（可通过getUsbPrinters获取）
	 *
	 * `decCmd` :Array<JSON> : （必填项）以十进制数字组成的 ESC/POS 指令数组
	 *
	 * `ret` :JSON : null
	 *
	 * `err` :JSON : null
	 */
	sendEscCommandToPrinter(params:posPrinter_sendEscCommandToPrinter_Params):void

	/**
	 * `获取打印机状态(usb打印机此命令无效)`
	 * ========params==========
	 *
	 * `printerAddr` :string : （必填项）打印机Mac地址或IP地址
	 */
	getPrinterStatus(params:posPrinter_getPrinterStatus_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface posPrinter_getBluetoothPrinters_Params {
	/**（可选项）表示要获取绑定的设备还是搜索周边所有蓝牙设备*/ 
	status?:string,

}

interface posPrinter_createBondToPrinter_Params {
	/**（必填项）蓝牙打印机 MAC 地址*/ 
	address:string,

	/**（可选项）绑定蓝牙设备时需要输入的pin码*/ 
	pin?:string,

}

interface posPrinter_removeBondToPrinter_Params {
	/**（必填项）要解除绑定的蓝牙打印机 MAC 地址*/ 
	address:string,

}

interface posPrinter_printOnSpecifiedPrinters_Params {
	/**（必填项）打印机、打印内容、重复打印次数组成的JSON对象数组*/ 
	taskList:Array<JSON>,

	/**null*/ 
	ret:JSON,

	/**null*/ 
	err:JSON,

}

interface posPrinter_print_Params {
	/**（必填项）打印机、打印内容、重复打印次数组成的JSON对象数组*/ 
	taskList:Array<JSON>,

	/**null*/ 
	ret:JSON,

	/**null*/ 
	err:JSON,

}

interface posPrinter_sendEscCommandToPrinter_Params {
	/**（必填项）蓝牙打印机地址（可通过getBluetoothPrinters获取）、IP打印机地址、USB打印机地址（可通过getUsbPrinters获取）*/ 
	printerAddr:string,

	/**（必填项）以十进制数字组成的 ESC/POS 指令数组*/ 
	decCmd:Array<JSON>,

	/**null*/ 
	ret:JSON,

	/**null*/ 
	err:JSON,

}

interface posPrinter_getPrinterStatus_Params {
	/**（必填项）打印机Mac地址或IP地址*/ 
	printerAddr:string,

}

interface myListeningInfo {
	/** 启动监听*/ 
	start():void

}
interface bluePrinter {
	/** 扫描小票打印机蓝牙*/ 
	scan():void

	/**
	 * `连接小票打印机`
	 * ========params==========
	 *
	 * `id` :any : scan接口返回的id
	 */
	connect(params:bluePrinter_connect_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `添加单行标题`
	 * ========params==========
	 *
	 * `string` :any : 标题内容
	 *
	 * `alignment` :number : 文字对齐方式
	 *
	 * `font` :number : 字号
	 */
	appendTitle(params:bluePrinter_appendTitle_Params):void

	/**
	 * `添加单行信息(左标题，右实际值)`
	 * ========params==========
	 *
	 * `title` :any : 标题
	 *
	 * `value` :any : 实际值
	 *
	 * `offset` :number : 实际值偏移量
	 *
	 * `font` :number : 字号
	 */
	appendText(params:bluePrinter_appendText_Params):void

	/**
	 * `添加单行信息(三列，例如：名称、数量、单价)`
	 * ========params==========
	 *
	 * `left` :any : 左标题
	 *
	 * `middle` :any : 中间标题
	 *
	 * `right` :any : 右标题
	 */
	appendTextThree(params:bluePrinter_appendTextThree_Params):void

	/**
	 * `添加条形码`
	 * ========params==========
	 *
	 * `string` :any : 条形码信息
	 *
	 * `alignment` :number : 文字对齐方式
	 *
	 * `maxWidth` :number : 最大宽度
	 */
	appendBarCode(params:bluePrinter_appendBarCode_Params):void

	/**
	 * `添加二维码`
	 * ========params==========
	 *
	 * `string` :any : 二维码信息
	 *
	 * `alignment` :number : 文字对齐方式
	 *
	 * `size` :number : 二维码大小，取值范围 1 <= size <= 16
	 */
	appendQRCode(params:bluePrinter_appendQRCode_Params):void

	/**
	 * `添加底部信息`
	 * ========params==========
	 *
	 * `string` :any : 底部信息
	 */
	appendFooter(params:bluePrinter_appendFooter_Params):void

	/** 添加一条分割线*/ 
	appendSeperatorLine():void

	/** 清除所有添加打印信息*/ 
	appendCleare():void

	/** 以字符串形式打印小票*/ 
	printString(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `以html本地文件形式打印小票**1.0.3版本（含）遗弃该接口**`
	 * ========params==========
	 *
	 * `path` :string : html本地地址（支持fs、widget）。
	 *
	 * `alignment` :number : 对齐方式
	 *
	 * `maxWidth` :number : 最大宽度
	 */
	printHtml(params:bluePrinter_printHtml_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface bluePrinter_connect_Params {
	/**scan接口返回的id*/ 
	id:any,

}

interface bluePrinter_appendTitle_Params {
	/**标题内容*/ 
	string:any,

	/**文字对齐方式*/ 
	alignment:number,

	/**字号*/ 
	font:number,

}

interface bluePrinter_appendText_Params {
	/**标题*/ 
	title:any,

	/**实际值*/ 
	value:any,

	/**实际值偏移量*/ 
	offset:number,

	/**字号*/ 
	font:number,

}

interface bluePrinter_appendTextThree_Params {
	/**左标题*/ 
	left:any,

	/**中间标题*/ 
	middle:any,

	/**右标题*/ 
	right:any,

}

interface bluePrinter_appendBarCode_Params {
	/**条形码信息*/ 
	string:any,

	/**文字对齐方式*/ 
	alignment:number,

	/**最大宽度*/ 
	maxWidth:number,

}

interface bluePrinter_appendQRCode_Params {
	/**二维码信息*/ 
	string:any,

	/**文字对齐方式*/ 
	alignment:number,

	/**二维码大小，取值范围 1 <= size <= 16*/ 
	size:number,

}

interface bluePrinter_appendFooter_Params {
	/**底部信息*/ 
	string:any,

}

interface bluePrinter_printHtml_Params {
	/**html本地地址（支持fs、widget）。*/ 
	path:string,

	/**对齐方式*/ 
	alignment:number,

	/**最大宽度*/ 
	maxWidth:number,

}

interface mobileSensor {
	/** 手机加速度传感器，持续返回结果。*/ 
	getAccelerometer(callback?: (ret:JSON, err:JSON) => void):void

}
interface btsppiot {
}
interface systemGyro {
	/** 检查设备是否有陀螺仪*/ 
	isGyroAvailable():void

	/**
	 * `打开陀螺仪`
	 * ========params==========
	 *
	 * `interval` :string : （可选项）间隔时间，单位秒（仅iOS支持）
	 */
	open(params:systemGyro_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭陀螺仪*/ 
	close():void

}
interface systemGyro_open_Params {
	/**（可选项）间隔时间，单位秒（仅iOS支持）*/ 
	interval?:string,

}

interface seriesCamera {
	/**
	 * `打开相机`
	 * ========params==========
	 *
	 * `max` :number : （可选项）最多可采集图片数
	 *
	 * `quality` :number : （可选项）图片质量，取值范围[0,100]
	 *
	 * `canEdit` :number : （可选项）是否启用相册图片和预览图片编辑裁剪功能
	 */
	open(params:seriesCamera_open_Params, callback?: (ret:JSON) => void):void

}
interface seriesCamera_open_Params {
	/**（可选项）最多可采集图片数*/ 
	max?:number,

	/**（可选项）图片质量，取值范围[0,100]*/ 
	quality?:number,

	/**（可选项）是否启用相册图片和预览图片编辑裁剪功能*/ 
	canEdit?:number,

}

interface printBleWifi {
	/** 初始化蓝牙*/ 
	initBlue(callback?: (ret:JSON) => void):void

	/** 蓝牙是否打开*/ 
	isOpen(callback?: (ret:JSON) => void):void

	/** 蓝牙配对历史*/ 
	hostoryBlue(callback?: (ret:JSON) => void):void

	/** 扫描蓝牙*/ 
	scanBlue(callback?: (ret:JSON) => void):void

	/** 连接蓝牙设备*/ 
	connectBlue():void

	/** 关闭扫描*/ 
	disscanBlue():void

	/** 判断WIFI打印机是否连接成功*/ 
	isWifiConnect(callback?: (ret:JSON) => void):void

	/** 连接wifi打印机*/ 
	openWifiPrint():void

	/** 添加单行标题*/ 
	appendTitle():void

	/** 加单行信息(左标题，右实际值)*/ 
	appendText():void

	/** 添加单行信息(三列，例如：名称、数量、单价)*/ 
	appendTextTree():void

	/** 添加条形码*/ 
	appendBarCode():void

	/** 添加二维码*/ 
	appendQRCode():void

	/** 添加底部信息*/ 
	appendFooter():void

	/** 添加一条分割线*/ 
	appendSeperatorLine(callback?: (ret:JSON) => void):void

	/** 清除所有添加打印信息*/ 
	appendClear(callback?: (ret:JSON) => void):void

	/** 添加图片*/ 
	appendImage():void

	/** 打印小票*/ 
	print(callback?: (ret:JSON) => void):void

	/** 打印当前页*/ 
	printCurrentPage(callback?: (ret:JSON) => void):void

	/** 获取条形码base64图片*/ 
	getBarCode(callback?: (ret:JSON) => void):void

	/** 获取二维码base64图片*/ 
	getQRCode(callback?: (ret:JSON) => void):void

}
interface appVersionUpdate {
}
interface magneticFieldSensor {
}
interface gpsListener {
	/**
	 * `查询监听GPS开关状态`
	 * ========params==========
	 *
	 * `addGpsChange` :boolean : （可选项）是否持续监听GPS状态；默认true
	 */
	addGpsListener(params:gpsListener_addGpsListener_Params, callback?: (ret:JSON) => void):void

	/** 移除GPS状态监听*/ 
	removeGpsListener():void

	/** 打开GPS设置页面*/ 
	openGpsSetting():void

}
interface gpsListener_addGpsListener_Params {
	/**（可选项）是否持续监听GPS状态；默认true*/ 
	addGpsChange?:boolean,

}

interface toBackground {
	/** Android App一键进入后台运行，进入后台后用户可通过任务栏重新进入界面，且保留应用原来的界面。*/ 
	runBackground():void

}
interface btmodule {
}
interface wifiSSID {
	/** 获取当前设备连接的WIFI的SSID*/ 
	getSsid(callback?: (ret:JSON, err:JSON) => void):void

}
interface tencentTrtcVoiceRoom {
}
interface hanvonVehicleCard {
	/**
	 * `对行驶证图片进行识别。`
	 * ========params==========
	 *
	 * `path` :string : 源图片路径，支持fs://、widget://等文件路径协议。
	 *
	 * `cropped` :boolean : （可选）切图版：true； 普通版：false。
	 *
	 * `https` :boolean : （可选）https：true； http：false。
	 *
	 * `cropPath` :boolean : （可选）在cropped为true时才有效。为true返回切割图路径和切割图经base64编码的字符串，为false只返回切割图经base64编码的字符串
	 */
	vehiclecardImage(params:hanvonVehicleCard_vehiclecardImage_Params, callback?: (ret:JSON) => void):void

	/** 清除保存的切割图。*/ 
	clearCache():void

}
interface hanvonVehicleCard_vehiclecardImage_Params {
	/**源图片路径，支持fs://、widget://等文件路径协议。*/ 
	path:string,

	/**（可选）切图版：true； 普通版：false。*/ 
	cropped?:boolean,

	/**（可选）https：true； http：false。*/ 
	https?:boolean,

	/**（可选）在cropped为true时才有效。为true返回切割图路径和切割图经base64编码的字符串，为false只返回切割图经base64编码的字符串*/ 
	cropPath?:boolean,

}

interface mwTencentRTC {
	/** 手动注册*/ 
	registerApp(callback?: (ret:JSON) => void):void

	/**
	 * `登录`
	 * ========params==========
	 *
	 * `userName` :string : 用户名
	 *
	 * `userSig` :string : 签名
	 */
	loginRTC(params:mwTencentRTC_loginRTC_Params, callback?: (ret:JSON) => void):void

	/**
	 * `加入房间 roomID 不存在时会自动创建房间`
	 * ========params==========
	 *
	 * `roomID` :string : 房间id
	 *
	 * `privateMapKey` :string : 房间加密的key
	 *
	 * `role` :string : 角色
	 */
	joinRoom(params:mwTencentRTC_joinRoom_Params, callback?: (ret:JSON) => void):void

	/**
	 * `退出房间`
	 * ========params==========
	 *
	 * `roomID` :string : 房间id
	 *
	 * `privateMapKey` :string : 房间加密的key
	 *
	 * `role` :string : 角色
	 */
	quitRoom(params:mwTencentRTC_quitRoom_Params, callback?: (ret:JSON) => void):void

}
interface mwTencentRTC_loginRTC_Params {
	/**用户名*/ 
	userName:string,

	/**签名*/ 
	userSig:string,

}

interface mwTencentRTC_joinRoom_Params {
	/**房间id*/ 
	roomID:string,

	/**房间加密的key*/ 
	privateMapKey:string,

	/**角色*/ 
	role:string,

}

interface mwTencentRTC_quitRoom_Params {
	/**房间id*/ 
	roomID:string,

	/**房间加密的key*/ 
	privateMapKey:string,

	/**角色*/ 
	role:string,

}

interface yunxinIM {
	/** 登陆*/ 
	login(callback?: (ret:JSON, err:JSON) => void):void

	/** 自动登陆，启动APP如果已经保存了用户帐号和令牌,建议使用这个登录方式*/ 
	autoLogin():void

	/** 退出登陆*/ 
	logout(callback?: (ret:JSON, err:JSON) => void):void

	/** 当前登录状态*/ 
	isLogined(callback?: (ret:JSON) => void):void

	/** 获取当前登录帐号，当前登录帐号,如果没有登录成功,这个地方会返回空字符串''（仅iOS支持）*/ 
	currentAccount():void

	/** 账号相关监听*/ 
	addAccountListen(callback?: (ret:JSON) => void):void

	/** 移除账号相关监听（仅android支持）*/ 
	removeAccountListen():void

	/**
	 * `踢其他客户端下线（仅 android支持）`
	 * ========params==========
	 *
	 * `client` :number : 要踢下线的客户端
	 */
	kickOtherClient(params:yunxinIM_kickOtherClient_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 从本地获取用户资料*/ 
	localUserInfo(callback?: (ret:JSON) => void):void

	/** 是否打开本地数据（仅android支持）*/ 
	openLocalCache(callback?: (ret:JSON) => void):void

	/** 从云信服务器批量获取用户资料，需要将用户信息交给云信托管，此接口才有效。调用此接口，不会触发 onUserInfoChanged 回调，该接口会将获取到的用户信息缓存在本地，所以需要避免此接口的滥调，导致存储过多无用数据到本地而撑爆缓存：如在聊天室请求请求每个聊天室用户数据将造成缓存过大而影响程序性能，本接口一次最多支持 150 个用户信息获取*/ 
	fetchUserInfos(callback?: (ret:JSON, err:JSON) => void):void

	/** 修改自己的用户资料*/ 
	updateMyUserInfo(callback?: (ret:JSON, err:JSON) => void):void

	/** 上传头像*/ 
	upload(callback?: (ret:JSON, err:JSON) => void):void

	/** 文件资源下载*/ 
	download(callback?: (ret:JSON, err:JSON) => void):void

	/** 取消上传/下载任务*/ 
	cancelTask():void

	/**
	 * `发送文本消息`
	 * ========params==========
	 *
	 * `sessionId` :string : 会话ID
	 *
	 * `chatType` :number : （可选项）会话类型
	 *
	 * `text` :string : 发送的消息
	 *
	 * `from` :string : （可选项）消息来源
	 *
	 * `ext` :JSON : （可选项）扩展信息，需要保证可以转换为 JSON，长度限制 1K
	 *
	 * `reSend` :boolean : （可选项）如果失败后是否重发（仅android支持）
	 */
	sendText(params:yunxinIM_sendText_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `发送图片消息`
	 * ========params==========
	 *
	 * `sessionId` :string : 会话ID
	 *
	 * `chatType` :number : （可选项）会话类型
	 *
	 * `path` :string : 要发送的图片的路径，要求本地路径（fs://、widget://）（android仅支持fs路径）
	 *
	 * `displayName` :string : （可选项）文件展示名
	 *
	 * `compressQuality` :number : （可选项）压缩参数，可传入0.0-1.0的值，如果传入非法参数，则按照 0.5 进行压缩（仅iOS支持）
	 *
	 * `from` :string : （可选项）消息来源
	 *
	 * `ext` :JSON : （可选项）扩展信息，需要保证可以转换为 JSON，长度限制 1K
	 *
	 * `reSend` :boolean : （可选项）如果失败后是否重发（仅android支持）
	 */
	sendImage(params:yunxinIM_sendImage_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `发送语音消息`
	 * ========params==========
	 *
	 * `sessionId` :string : 会话ID
	 *
	 * `chatType` :number : （可选项）会话类型
	 *
	 * `path` :string : 要发送的语音的路径，要求本地路径（fs://、widget://）（android仅支持fs路径）
	 *
	 * `duration` :number : （可选项）语音时长，毫秒为单位
	 *
	 * `from` :string : （可选项）消息来源
	 *
	 * `ext` :JSON : （可选项）扩展信息，需要保证可以转换为 JSON，长度限制 1K
	 *
	 * `reSend` :boolean : （可选项）如果失败后是否重发（仅android支持）
	 */
	sendVoice(params:yunxinIM_sendVoice_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `发送视频消息`
	 * ========params==========
	 *
	 * `sessionId` :string : 会话ID
	 *
	 * `chatType` :number : （可选项）会话类型
	 *
	 * `path` :string : 要发送的视频的路径，要求本地路径（fs://、widget://）
	 *
	 * `displayName` :string : 视频展示名
	 *
	 * `duration` :number : （可选项）视频时长，毫秒为单位
	 *
	 * `width` :number : 视频宽度（仅android支持）
	 *
	 * `height` :number : 视频高度（仅android支持）
	 *
	 * `from` :string : （可选项）消息来源
	 *
	 * `ext` :JSON : （可选项）扩展信息，需要保证可以转换为 JSON，长度限制 1K
	 *
	 * `reSend` :boolean : （可选项）如果失败后是否重发（仅android支持）
	 */
	sendVideo(params:yunxinIM_sendVideo_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `发送文件消息`
	 * ========params==========
	 *
	 * `sessionId` :string : 会话ID
	 *
	 * `chatType` :number : （可选项）会话类型
	 *
	 * `path` :string : 要发送的文件的路径，要求本地路径（fs://、widget://）
	 *
	 * `displayName` :string : 文件显示名
	 *
	 * `extension` :string : 文件拓展名（仅iOS支持）
	 *
	 * `from` :string : （可选项）消息来源
	 *
	 * `ext` :JSON : （可选项）扩展信息，需要保证可以转换为 JSON，长度限制 1K
	 *
	 * `reSend` :boolean : （可选项）如果失败后是否重发（仅android支持）
	 */
	sendFile(params:yunxinIM_sendFile_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `发送位置消息`
	 * ========params==========
	 *
	 * `sessionId` :string : 会话ID
	 *
	 * `chatType` :number : （可选项）会话类型
	 *
	 * `address` :string : 要发送的地址
	 *
	 * `latitude` :number : 纬度
	 *
	 * `longitude` :number : 经度
	 *
	 * `from` :string : （可选项）消息来源
	 *
	 * `ext` :JSON : （可选项）扩展信息，需要保证可以转换为 JSON，长度限制 1K
	 *
	 * `reSend` :boolean : （可选项）如果失败后是否重发（仅android支持）
	 */
	sendLocation(params:yunxinIM_sendLocation_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `发送提示消息`
	 * ========params==========
	 *
	 * `sessionId` :string : 会话ID
	 *
	 * `chatType` :number : （可选项）会话类型
	 *
	 * `text` :string : 要发送的消息（仅iOS支持）
	 *
	 * `from` :string : （可选项）消息来源
	 *
	 * `ext` :JSON : （可选项）扩展信息，需要保证可以转换为 JSON，长度限制 1K
	 *
	 * `reSend` :boolean : （可选项）如果失败后是否重发（仅android支持）
	 */
	sendTip(params:yunxinIM_sendTip_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `消息取消发送，只能取消正在发送中的消息（如大文件发送），通常配合异步发送消息接口，接口返回值成功时消息的状态为发送失败状态（仅iOS支持）`
	 * ========params==========
	 *
	 * `sessionId` :string : 会话ID
	 *
	 * `chatType` :number : （可选项）会话类型
	 *
	 * `messageId` :string : 消息Id
	 */
	cancelSendingMessage(params:yunxinIM_cancelSendingMessage_Params, callback?: (ret:JSON) => void):void

	/**
	 * `消息重发（仅iOS支持）`
	 * ========params==========
	 *
	 * `sessionId` :string : 会话ID
	 *
	 * `chatType` :number : （可选项）会话类型
	 *
	 * `messageId` :string : 消息Id
	 */
	resendMessage(params:yunxinIM_resendMessage_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `消息转发，除了通知消息之外，其他类型消息均支持转发给其他会话，`
	 * ========params==========
	 *
	 * `sessionId` :string : 会话ID
	 *
	 * `toSessionId` :string : 转发到ID
	 *
	 * `chatType` :number : （可选项）会话类型
	 *
	 * `toChatType` :number : （可选项）转发到的会话类型
	 *
	 * `messageId` :string : 消息Id，
	 *
	 * `reSend` :boolean : （可选项）如果失败后是否重发（仅android支持）
	 */
	forwardMessage(params:yunxinIM_forwardMessage_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `消息撤回，允许用户撤回一定时间内发送过的消息，允许撤回时长默认2分钟，可在网易云信控制台配置`
	 * ========params==========
	 *
	 * `sessionId` :string : 会话ID
	 *
	 * `chatType` :number : （可选项）会话类型
	 *
	 * `messageId` :string : 消息Id
	 */
	revokeMessage(params:yunxinIM_revokeMessage_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `单聊消息已读回执，在会话界面中调用发送已读回执的接口并传入当前会话的最后一条消息，即表示这之前的消息本方都已读`
	 * ========params==========
	 *
	 * `sessionId` :string : 会话ID
	 *
	 * `chatType` :number : （可选项）会话类型
	 *
	 * `messageId` :string : 当前会话的最后一条消息Id
	 */
	sendMessageReceipt(params:yunxinIM_sendMessageReceipt_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `群聊消息已读回执，群消息已读回执功能，需要联系商务顾问申请开通后才能使用。同时，使用该功能时需要将群成员控制在100人以内。需要config配置teamReceiptEnabled为true（仅iOS支持）`
	 * ========params==========
	 *
	 * `sessionId` :string : 会话ID
	 *
	 * `chatType` :number : （可选项）会话类型
	 *
	 * `messageIds` :Array : 条消息Id数组
	 *
	 * `sessionId` :string : 会话ID
	 *
	 * `chatType` :number : （可选项）会话类型
	 *
	 * `messageIds` :Array : 条消息Id数组
	 */
	sendTeamMessageReceipts(params:yunxinIM_sendTeamMessageReceipts_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `群聊消息已读回执，群消息已读回执功能，需要联系商务顾问申请开通后才能使用。同时，使用该功能时需要将群成员控制在100人以内。需要config配置teamReceiptEnabled为true（仅iOS支持）`
	 * ========params==========
	 *
	 * `sessionId` :string : 会话ID
	 *
	 * `chatType` :number : （可选项）会话类型
	 *
	 * `messageIds` :Array : 条消息Id数组
	 *
	 * `sessionId` :string : 会话ID
	 *
	 * `chatType` :number : （可选项）会话类型
	 *
	 * `messageIds` :Array : 条消息Id数组
	 */
	sendTeamMessageReceipts(params:yunxinIM_sendTeamMessageReceipts_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 消息相关监听*/ 
	addMessageListen():void

	/** 获取所有最近会话*/ 
	allRecentSessions():void

	/**
	 * `创建最近会话`
	 * ========params==========
	 *
	 * `sessionId` :string : 会话ID（仅iOS支持）
	 *
	 * `messageId` :string : 当前会话的最后一条消息Id
	 *
	 * `chatType` :number : （可选项）会话类型（仅iOS支持）
	 */
	creatRecentSession(params:yunxinIM_creatRecentSession_Params):void

	/**
	 * `删除最近会话`
	 * ========params==========
	 *
	 * `sessionId` :string : 会话ID（如果不通知观察者 android端需要未allRecentSessions接口最近一次返回数据中会话 ID）
	 *
	 * `sessionType` :number : 会话类型；0：P2P，1：Team，2：ChatRoom，3：Ysf，5：SUPER_TEAM（android端通知观察者时需要）
	 *
	 * `notifyOb` :boolean : （可选项）是否通知观察者（仅android支持）
	 */
	deleteRecentSession(params:yunxinIM_deleteRecentSession_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `更新最近会话的本地扩展（仅iOS支持）`
	 * ========params==========
	 *
	 * `sessionId` :string : 会话ID
	 */
	updateRecentLocalExt(params:yunxinIM_updateRecentLocalExt_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 获取会话未读消息数*/ 
	allUnreadCount():void

	/**
	 * `设置一个会话里所有消息置为已读（仅iOS支持）`
	 * ========params==========
	 *
	 * `sessionId` :string : 会话ID
	 *
	 * `chatType` :number : （可选项）会话类型
	 */
	markAllMessagesReadInSession(params:yunxinIM_markAllMessagesReadInSession_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `删除服务器端最近会话`
	 * ========params==========
	 *
	 * `sessions` :Array : 会话列表
	 */
	deleteRemoteSessions(params:yunxinIM_deleteRemoteSessions_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `从本地db读取一个会话里某条消息之前的若干条的消息`
	 * ========params==========
	 *
	 * `sessionId` :string : 会话ID
	 *
	 * `chatType` :number : （可选项）会话类型
	 *
	 * `messageId` :string : 消息Id（android端此消息必须为上次获取结果中消息或pullMessageHistory接口上次获取结果中id，
	 *
	 * `direction` :string : （可选项）查询方向（仅android支持）
	 *
	 * `limit` :number : （可选项）查询条数（仅android支持）
	 *
	 * `asc` :boolean : （可选项）是否已time为排序字段（仅android支持）
	 */
	messagesInSession(params:yunxinIM_messagesInSession_Params, callback?: (ret:JSON) => void):void

	/**
	 * `从服务器拉取消息历史记录。该接口查询方向为从后往前。（仅android支持）`
	 * ========params==========
	 *
	 * `messageId` :string : （可选项）从这条消息往前获取（此消息必须为上次获取的消息id）
	 *
	 * `sessionId` :string : 会话ID
	 *
	 * `chatType` :number : （可选项）会话类型
	 *
	 * `limit` :number : （可选项）获取多少条消息，最大值为100
	 *
	 * `persist` :boolean : （可选项）获取的漫游消息记录，是否保存到本地消息数据库
	 *
	 * `persistClear` :boolean : （可选项）是否保存清除记录之前的消息到本地数据库
	 */
	pullMessageHistory(params:yunxinIM_pullMessageHistory_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `根据消息Id获取消息`
	 * ========params==========
	 *
	 * `sessionId` :string : 会话ID（仅iOS支持）
	 *
	 * `chatType` :number : （可选项）会话类型（仅IOS支持）
	 *
	 * `messageIds` :Array : 消息Id数组
	 */
	messagesInSessionWithMessageIds(params:yunxinIM_messagesInSessionWithMessageIds_Params, callback?: (ret:JSON) => void):void

	/**
	 * `删除某条消息`
	 * ========params==========
	 *
	 * `sessionId` :string : 会话ID（仅iOS支持）
	 *
	 * `chatType` :number : （可选项）会话类型（仅iOS支持）
	 *
	 * `messageId` :string : 消息Id
	 */
	deleteMessage(params:yunxinIM_deleteMessage_Params):void

	/**
	 * `删除某个会话的所有消息`
	 * ========params==========
	 *
	 * `sessionId` :string : 会话ID
	 *
	 * `chatType` :number : （可选项）会话类型
	 *
	 * `removeSession` :boolean : （可选项）是否移除对应最近会话，设置为 true 时将同时删除最近会话信息（仅iOS支持）
	 *
	 * `removeTable` :boolean : （可选项）是否删除消息表，默认情况下云信采用标记的方式进行消息删除，如果设置为 true，将一并移除对应的消息表，进而减少消息表数量，加快 I/O（仅iOS支持）
	 */
	deleteAllmessagesInSession(params:yunxinIM_deleteAllmessagesInSession_Params):void

	/**
	 * `删除所有会话消息（仅iOS支持）`
	 * ========params==========
	 *
	 * `removeSession` :boolean : （可选项）是否移除对应最近会话，设置为 true 时将同时删除最近会话信息
	 *
	 * `removeTable` :boolean : （可选项）是否删除消息表，默认情况下云信采用标记的方式进行消息删除，如果设置为 true，将一并移除对应的消息表，进而减少消息表数量，加快 I/O
	 */
	deleteAllMessages(params:yunxinIM_deleteAllMessages_Params):void

	/** 会话相关监听*/ 
	addSessionListen(callback?: (ret:JSON) => void):void

	/** 移除会话相关监听（仅android支持）*/ 
	removeSessionListen():void

	/** 获取好友列表*/ 
	myFriends():void

	/**
	 * `处理好友关系`
	 * ========params==========
	 *
	 * `userId` :string : 目标用户ID
	 *
	 * `operation` :number : （可选项）操作类型
	 *
	 * `message` :string : 附言
	 */
	requestFriend(params:yunxinIM_requestFriend_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `删除好友`
	 * ========params==========
	 *
	 * `userId` :string : 好友Id
	 *
	 * `removeAlias` :boolean : （可选项）是否同时删除备注
	 */
	deleteFriend(params:yunxinIM_deleteFriend_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `判断是否是我的好友`
	 * ========params==========
	 *
	 * `userId` :string : 用户Id
	 */
	isMyFriend(params:yunxinIM_isMyFriend_Params, callback?: (ret:JSON) => void):void

	/** 获取黑名单中的用户列表*/ 
	myBlackList():void

	/**
	 * `添加用户到黑名单`
	 * ========params==========
	 *
	 * `userId` :string : 用户Id
	 */
	addToBlackList(params:yunxinIM_addToBlackList_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `将用户从黑名单移除`
	 * ========params==========
	 *
	 * `userId` :string : 用户Id
	 */
	removeFromBlackList(params:yunxinIM_removeFromBlackList_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `判断用户是否已被拉黑`
	 * ========params==========
	 *
	 * `userId` :string : 用户Id
	 */
	isUserInBlackList(params:yunxinIM_isUserInBlackList_Params, callback?: (ret:JSON) => void):void

	/** 获取免打扰列表*/ 
	myMuteUserList():void

	/**
	 * `设置免打扰`
	 * ========params==========
	 *
	 * `userId` :string : 用户Id
	 *
	 * `isNotify` :boolean : （可选项）是否免打扰
	 */
	setMute(params:yunxinIM_setMute_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `判断是否免打扰`
	 * ========params==========
	 *
	 * `userId` :string : 用户Id
	 */
	isMute(params:yunxinIM_isMute_Params, callback?: (ret:JSON) => void):void

	/**
	 * `用户检索（仅iOS支持）`
	 * ========params==========
	 *
	 * `searchContent` :string : 搜索文本
	 *
	 * `ignoreingCase` :boolean : （可选项）忽略大小写
	 *
	 * `searchRange` :number : （可选项）搜索文本的搜索范围
	 *
	 * `searchContentOption` :number : （可选项）搜索文本的搜索范围
	 */
	searchUser(params:yunxinIM_searchUser_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 好友相关监听*/ 
	addFriendListen(callback?: (ret:JSON) => void):void

	/** 移除好友相关监听（仅iOS支持）*/ 
	removeFriendListen():void

	/**
	 * `通过用户id获取用户信息（仅android支持）`
	 * ========params==========
	 *
	 * `userIds` :Array : 用户id数组
	 */
	getUserInfoList(params:yunxinIM_getUserInfoList_Params, callback?: (ret:JSON) => void):void

	/**
	 * `获取本地存储的系统通知（本接口配合limit参数采取分页获取）`
	 * ========params==========
	 *
	 * `limit` :number : 最大获取数
	 *
	 * `offset` :number : 数据库查询偏移量（仅android支持）
	 */
	fetchSystemNotifications(params:yunxinIM_fetchSystemNotifications_Params, callback?: (ret:JSON) => void):void

	/** 获取未读系统消息数*/ 
	allNotificationsUnreadCount():void

	/** 标记所有系统消息为已读*/ 
	markAllNotificationsAsRead():void

	/** 删除所有系统消息*/ 
	deleteAllNotifications():void

	/** 通知相关监听*/ 
	addNotificationListen(callback?: (ret:JSON) => void):void

	/** 移除通知相关监听（仅android支持）*/ 
	removeNotificationListen():void

	/**
	 * `创建群组`
	 * ========params==========
	 *
	 * `users` :Array : 用户ID列表
	 *
	 * `option` :JSON : 创建群选项
	 */
	createTeam(params:yunxinIM_createTeam_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 从本地获取所有群组*/ 
	allMyTeams():void

	/**
	 * `解散群组`
	 * ========params==========
	 *
	 * `teamId` :string : 群组ID
	 */
	dismissTeam(params:yunxinIM_dismissTeam_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `申请加入群组`
	 * ========params==========
	 *
	 * `teamId` :string : 群组ID
	 *
	 * `message` :string : （可选项）申请消息
	 */
	applyToTeam(params:yunxinIM_applyToTeam_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `通过申请(仅限高级群)`
	 * ========params==========
	 *
	 * `teamId` :string : 群组ID
	 *
	 * `userId` :string : 申请的用户 ID
	 */
	passApplyToTeam(params:yunxinIM_passApplyToTeam_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `拒绝申请(仅限高级群)`
	 * ========params==========
	 *
	 * `teamId` :string : 群组ID
	 *
	 * `userId` :string : 申请的用户 ID
	 *
	 * `reason` :string : （可选项）拒绝理由
	 */
	rejectApplyToTeam(params:yunxinIM_rejectApplyToTeam_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `邀请加入群组`
	 * ========params==========
	 *
	 * `teamId` :string : 群组ID
	 *
	 * `users` :Array : 用户ID列表
	 *
	 * `postscript` :string : （可选项）邀请附言
	 *
	 * `attach` :string : （可选项）扩展消息
	 */
	invitationToTeam(params:yunxinIM_invitationToTeam_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `接受入群邀请(仅限高级群)`
	 * ========params==========
	 *
	 * `teamId` :string : 群组ID
	 *
	 * `invitorId` :string : 邀请者 ID
	 */
	acceptInviteWithTeam(params:yunxinIM_acceptInviteWithTeam_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `拒绝入群邀请(仅限高级群)`
	 * ========params==========
	 *
	 * `teamId` :string : 群组ID
	 *
	 * `invitorId` :string : 邀请者 ID
	 *
	 * `reason` :string : （可选项）拒绝原因
	 */
	rejectInviteWithTeam(params:yunxinIM_rejectInviteWithTeam_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `从群组内移除成员`
	 * ========params==========
	 *
	 * `teamId` :string : 群组ID
	 *
	 * `users` :string : 需要移除的用户ID列表
	 */
	kickUsersFromTeam(params:yunxinIM_kickUsersFromTeam_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `退出群组`
	 * ========params==========
	 *
	 * `teamId` :string : 群组ID
	 */
	quitTeam(params:yunxinIM_quitTeam_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取群组成员，绝大多数情况这个请求都是从本地读取缓存并同步返回，但是由于群成员信息量较大， SDK 采取的是登录后延迟拉取的策略，考虑到用户网络等问题, SDK 有可能没有及时缓存群成员信息,那么这个请求将是个带网络请求的异步操作(增量请求)。 同时这个接口会去请求本地没有缓存的群用户的资料信息，但不会触发 onUserInfoChanged 回调`
	 * ========params==========
	 *
	 * `teamId` :string : 群组ID
	 */
	fetchTeamMembers(params:yunxinIM_fetchTeamMembers_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取单个群成员信息，返回本地缓存的群成员信息，如果本地没有相应数据则返回空`
	 * ========params==========
	 *
	 * `teamId` :string : 群组ID
	 *
	 * `userId` :string : 用户ID
	 */
	teamMember(params:yunxinIM_teamMember_Params, callback?: (ret:JSON) => void):void

	/**
	 * `更新成员群昵称`
	 * ========params==========
	 *
	 * `teamId` :string : 群组ID
	 *
	 * `userId` :string : 群成员ID
	 *
	 * `newNick` :string : 新的群成员昵称
	 */
	updateUserNick(params:yunxinIM_updateUserNick_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `根据群组ID判断是否是我所在的群`
	 * ========params==========
	 *
	 * `teamId` :string : 群组ID
	 */
	isMyTeam(params:yunxinIM_isMyTeam_Params, callback?: (ret:JSON) => void):void

	/**
	 * `移交群主`
	 * ========params==========
	 *
	 * `teamId` :string : 群组ID
	 *
	 * `newOwnerId` :string : 新群主ID
	 *
	 * `isLeave` :boolean : （可选项）是否同时离开群组
	 */
	transferManagerWithTeam(params:yunxinIM_transferManagerWithTeam_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `添加管理员`
	 * ========params==========
	 *
	 * `teamId` :string : 群组ID
	 *
	 * `users` :Array : 需要添加为管理员的用户ID列表
	 */
	addManagersToTeam(params:yunxinIM_addManagersToTeam_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `移除管理员`
	 * ========params==========
	 *
	 * `teamId` :string : 群组ID
	 *
	 * `users` :Array : 需要添加为管理员的用户ID列表
	 */
	removeManagersFromTeam(params:yunxinIM_removeManagersFromTeam_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `禁言指定成员`
	 * ========params==========
	 *
	 * `teamId` :string : 群组ID
	 *
	 * `userId` :string : 用户ID
	 *
	 * `isMute` :boolean : （可选项）是否禁言
	 */
	muteUserFromTeam(params:yunxinIM_muteUserFromTeam_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `禁言全体普通成员`
	 * ========params==========
	 *
	 * `teamId` :string : 群组ID
	 *
	 * `isMute` :boolean : （可选项）是否禁言
	 */
	muteAllFromTeam(params:yunxinIM_muteAllFromTeam_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `获取群内被禁言的成员列表，绝大多数情况这个请求都是从本地读取缓存并同步返回，但是由于群成员信息量较大， SDK 采取的是登录后延迟拉取的策略，考虑到用户网络等问题, SDK 有可能没有及时缓存群成员信息,那么这个请求将是个带网络请求的异步操作(增量请求)。同时这个接口会去请求本地没有缓存的群用户的资料信息，但不会触发 onUserInfoChanged 回调`
	 * ========params==========
	 *
	 * `teamId` :string : 群组ID
	 */
	fetchTeamMutedMembers(params:yunxinIM_fetchTeamMutedMembers_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `更新群组名称`
	 * ========params==========
	 *
	 * `teamId` :string : 群组ID
	 *
	 * `teamName` :string : 群组名称
	 */
	updateTeamName(params:yunxinIM_updateTeamName_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `更新群组头像`
	 * ========params==========
	 *
	 * `teamId` :string : 群组ID
	 *
	 * `teamAvatarUrl` :string : 群组头像 Url
	 */
	updateTeamAvatar(params:yunxinIM_updateTeamAvatar_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `更新群介绍`
	 * ========params==========
	 *
	 * `teamId` :string : 群组ID
	 *
	 * `intro` :string : 群介绍
	 */
	updateTeamIntro(params:yunxinIM_updateTeamIntro_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `更新群公告`
	 * ========params==========
	 *
	 * `teamId` :string : 群组ID
	 *
	 * `announcement` :string : 群公告
	 */
	updateTeamAnnouncement(params:yunxinIM_updateTeamAnnouncement_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `更新群组验证方式`
	 * ========params==========
	 *
	 * `teamId` :string : 群组ID
	 *
	 * `joinMode` :number : 验证方式
	 */
	updateTeamJoinMode(params:yunxinIM_updateTeamJoinMode_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `更新群组被邀请人验证方式`
	 * ========params==========
	 *
	 * `teamId` :string : 群组ID
	 *
	 * `beInviteMode` :number : 邀请方式
	 */
	updateTeamBeInviteMode(params:yunxinIM_updateTeamBeInviteMode_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `更新群组邀请他人方式`
	 * ========params==========
	 *
	 * `teamId` :string : 群组ID
	 *
	 * `inviteMode` :number : 邀请方式
	 */
	updateTeamInviteMode(params:yunxinIM_updateTeamInviteMode_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `更改群组更新信息的权限`
	 * ========params==========
	 *
	 * `teamId` :string : 群组ID
	 *
	 * `infoMode` :number : 群信息修改权限
	 */
	updateTeamUpdateInfoMode(params:yunxinIM_updateTeamUpdateInfoMode_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `更改群组更新自定义字段的权限`
	 * ========params==========
	 *
	 * `teamId` :string : 群组ID
	 *
	 * `clientCustomMode` :number : 修改谁有权限更新群组自定义字段
	 */
	updateTeamUpdateClientCustomMode(params:yunxinIM_updateTeamUpdateClientCustomMode_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `更新群自定义信息`
	 * ========params==========
	 *
	 * `teamId` :string : 群组ID
	 *
	 * `customInfo` :string : 群自定义信息
	 */
	updateTeamCustomInfo(params:yunxinIM_updateTeamCustomInfo_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `修改群通知状态`
	 * ========params==========
	 *
	 * `teamId` :string : 群组ID
	 *
	 * `notifyState` :number : 群通知状态
	 */
	updateTeamNotifyState(params:yunxinIM_updateTeamNotifyState_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `查询群通知状态`
	 * ========params==========
	 *
	 * `teamId` :string : 群组ID
	 */
	fetchTeamNotifyState(params:yunxinIM_fetchTeamNotifyState_Params, callback?: (ret:JSON) => void):void

	/** 群组相关监听*/ 
	addTeamListen(callback?: (ret:JSON) => void):void

	/** 移除群组相关监听（仅android支持）*/ 
	removeTeamListen():void

}
interface yunxinIM_kickOtherClient_Params {
	/**要踢下线的客户端*/ 
	client:number,

}

interface yunxinIM_sendText_Params {
	/**会话ID*/ 
	sessionId:string,

	/**（可选项）会话类型*/ 
	chatType?:number,

	/**发送的消息*/ 
	text:string,

	/**（可选项）消息来源*/ 
	from?:string,

	/**（可选项）扩展信息，需要保证可以转换为 JSON，长度限制 1K*/ 
	ext?:JSON,

	/**（可选项）如果失败后是否重发（仅android支持）*/ 
	reSend?:boolean,

}

interface yunxinIM_sendImage_Params {
	/**会话ID*/ 
	sessionId:string,

	/**（可选项）会话类型*/ 
	chatType?:number,

	/**要发送的图片的路径，要求本地路径（fs://、widget://）（android仅支持fs路径）*/ 
	path:string,

	/**（可选项）文件展示名*/ 
	displayName?:string,

	/**（可选项）压缩参数，可传入0.0-1.0的值，如果传入非法参数，则按照 0.5 进行压缩（仅iOS支持）*/ 
	compressQuality?:number,

	/**（可选项）消息来源*/ 
	from?:string,

	/**（可选项）扩展信息，需要保证可以转换为 JSON，长度限制 1K*/ 
	ext?:JSON,

	/**（可选项）如果失败后是否重发（仅android支持）*/ 
	reSend?:boolean,

}

interface yunxinIM_sendVoice_Params {
	/**会话ID*/ 
	sessionId:string,

	/**（可选项）会话类型*/ 
	chatType?:number,

	/**要发送的语音的路径，要求本地路径（fs://、widget://）（android仅支持fs路径）*/ 
	path:string,

	/**（可选项）语音时长，毫秒为单位*/ 
	duration?:number,

	/**（可选项）消息来源*/ 
	from?:string,

	/**（可选项）扩展信息，需要保证可以转换为 JSON，长度限制 1K*/ 
	ext?:JSON,

	/**（可选项）如果失败后是否重发（仅android支持）*/ 
	reSend?:boolean,

}

interface yunxinIM_sendVideo_Params {
	/**会话ID*/ 
	sessionId:string,

	/**（可选项）会话类型*/ 
	chatType?:number,

	/**要发送的视频的路径，要求本地路径（fs://、widget://）*/ 
	path:string,

	/**视频展示名*/ 
	displayName:string,

	/**（可选项）视频时长，毫秒为单位*/ 
	duration?:number,

	/**视频宽度（仅android支持）*/ 
	width:number,

	/**视频高度（仅android支持）*/ 
	height:number,

	/**（可选项）消息来源*/ 
	from?:string,

	/**（可选项）扩展信息，需要保证可以转换为 JSON，长度限制 1K*/ 
	ext?:JSON,

	/**（可选项）如果失败后是否重发（仅android支持）*/ 
	reSend?:boolean,

}

interface yunxinIM_sendFile_Params {
	/**会话ID*/ 
	sessionId:string,

	/**（可选项）会话类型*/ 
	chatType?:number,

	/**要发送的文件的路径，要求本地路径（fs://、widget://）*/ 
	path:string,

	/**文件显示名*/ 
	displayName:string,

	/**文件拓展名（仅iOS支持）*/ 
	extension:string,

	/**（可选项）消息来源*/ 
	from?:string,

	/**（可选项）扩展信息，需要保证可以转换为 JSON，长度限制 1K*/ 
	ext?:JSON,

	/**（可选项）如果失败后是否重发（仅android支持）*/ 
	reSend?:boolean,

}

interface yunxinIM_sendLocation_Params {
	/**会话ID*/ 
	sessionId:string,

	/**（可选项）会话类型*/ 
	chatType?:number,

	/**要发送的地址*/ 
	address:string,

	/**纬度*/ 
	latitude:number,

	/**经度*/ 
	longitude:number,

	/**（可选项）消息来源*/ 
	from?:string,

	/**（可选项）扩展信息，需要保证可以转换为 JSON，长度限制 1K*/ 
	ext?:JSON,

	/**（可选项）如果失败后是否重发（仅android支持）*/ 
	reSend?:boolean,

}

interface yunxinIM_sendTip_Params {
	/**会话ID*/ 
	sessionId:string,

	/**（可选项）会话类型*/ 
	chatType?:number,

	/**要发送的消息（仅iOS支持）*/ 
	text:string,

	/**（可选项）消息来源*/ 
	from?:string,

	/**（可选项）扩展信息，需要保证可以转换为 JSON，长度限制 1K*/ 
	ext?:JSON,

	/**（可选项）如果失败后是否重发（仅android支持）*/ 
	reSend?:boolean,

}

interface yunxinIM_cancelSendingMessage_Params {
	/**会话ID*/ 
	sessionId:string,

	/**（可选项）会话类型*/ 
	chatType?:number,

	/**消息Id*/ 
	messageId:string,

}

interface yunxinIM_resendMessage_Params {
	/**会话ID*/ 
	sessionId:string,

	/**（可选项）会话类型*/ 
	chatType?:number,

	/**消息Id*/ 
	messageId:string,

}

interface yunxinIM_forwardMessage_Params {
	/**会话ID*/ 
	sessionId:string,

	/**转发到ID*/ 
	toSessionId:string,

	/**（可选项）会话类型*/ 
	chatType?:number,

	/**（可选项）转发到的会话类型*/ 
	toChatType?:number,

	/**消息Id，*/ 
	messageId:string,

	/**（可选项）如果失败后是否重发（仅android支持）*/ 
	reSend?:boolean,

}

interface yunxinIM_revokeMessage_Params {
	/**会话ID*/ 
	sessionId:string,

	/**（可选项）会话类型*/ 
	chatType?:number,

	/**消息Id*/ 
	messageId:string,

}

interface yunxinIM_sendMessageReceipt_Params {
	/**会话ID*/ 
	sessionId:string,

	/**（可选项）会话类型*/ 
	chatType?:number,

	/**当前会话的最后一条消息Id*/ 
	messageId:string,

}

interface yunxinIM_sendTeamMessageReceipts_Params {
	/**会话ID*/ 
	sessionId:string,

	/**（可选项）会话类型*/ 
	chatType?:number,

	/**条消息Id数组*/ 
	messageIds:Array,

	/**会话ID*/ 
	sessionId:string,

	/**（可选项）会话类型*/ 
	chatType?:number,

	/**条消息Id数组*/ 
	messageIds:Array,

}

interface yunxinIM_sendTeamMessageReceipts_Params {
	/**会话ID*/ 
	sessionId:string,

	/**（可选项）会话类型*/ 
	chatType?:number,

	/**条消息Id数组*/ 
	messageIds:Array,

	/**会话ID*/ 
	sessionId:string,

	/**（可选项）会话类型*/ 
	chatType?:number,

	/**条消息Id数组*/ 
	messageIds:Array,

}

interface yunxinIM_creatRecentSession_Params {
	/**会话ID（仅iOS支持）*/ 
	sessionId:string,

	/**当前会话的最后一条消息Id*/ 
	messageId:string,

	/**（可选项）会话类型（仅iOS支持）*/ 
	chatType?:number,

}

interface yunxinIM_deleteRecentSession_Params {
	/**会话ID（如果不通知观察者 android端需要未allRecentSessions接口最近一次返回数据中会话 ID）*/ 
	sessionId:string,

	/**会话类型；0：P2P，1：Team，2：ChatRoom，3：Ysf，5：SUPER_TEAM（android端通知观察者时需要）*/ 
	sessionType:number,

	/**（可选项）是否通知观察者（仅android支持）*/ 
	notifyOb?:boolean,

}

interface yunxinIM_updateRecentLocalExt_Params {
	/**会话ID*/ 
	sessionId:string,

}

interface yunxinIM_markAllMessagesReadInSession_Params {
	/**会话ID*/ 
	sessionId:string,

	/**（可选项）会话类型*/ 
	chatType?:number,

}

interface yunxinIM_deleteRemoteSessions_Params {
	/**会话列表*/ 
	sessions:Array,

}

interface yunxinIM_messagesInSession_Params {
	/**会话ID*/ 
	sessionId:string,

	/**（可选项）会话类型*/ 
	chatType?:number,

	/**消息Id（android端此消息必须为上次获取结果中消息或pullMessageHistory接口上次获取结果中id，*/ 
	messageId:string,

	/**（可选项）查询方向（仅android支持）*/ 
	direction?:string,

	/**（可选项）查询条数（仅android支持）*/ 
	limit?:number,

	/**（可选项）是否已time为排序字段（仅android支持）*/ 
	asc?:boolean,

}

interface yunxinIM_pullMessageHistory_Params {
	/**（可选项）从这条消息往前获取（此消息必须为上次获取的消息id）*/ 
	messageId?:string,

	/**会话ID*/ 
	sessionId:string,

	/**（可选项）会话类型*/ 
	chatType?:number,

	/**（可选项）获取多少条消息，最大值为100*/ 
	limit?:number,

	/**（可选项）获取的漫游消息记录，是否保存到本地消息数据库*/ 
	persist?:boolean,

	/**（可选项）是否保存清除记录之前的消息到本地数据库*/ 
	persistClear?:boolean,

}

interface yunxinIM_messagesInSessionWithMessageIds_Params {
	/**会话ID（仅iOS支持）*/ 
	sessionId:string,

	/**（可选项）会话类型（仅IOS支持）*/ 
	chatType?:number,

	/**消息Id数组*/ 
	messageIds:Array,

}

interface yunxinIM_deleteMessage_Params {
	/**会话ID（仅iOS支持）*/ 
	sessionId:string,

	/**（可选项）会话类型（仅iOS支持）*/ 
	chatType?:number,

	/**消息Id*/ 
	messageId:string,

}

interface yunxinIM_deleteAllmessagesInSession_Params {
	/**会话ID*/ 
	sessionId:string,

	/**（可选项）会话类型*/ 
	chatType?:number,

	/**（可选项）是否移除对应最近会话，设置为 true 时将同时删除最近会话信息（仅iOS支持）*/ 
	removeSession?:boolean,

	/**（可选项）是否删除消息表，默认情况下云信采用标记的方式进行消息删除，如果设置为 true，将一并移除对应的消息表，进而减少消息表数量，加快 I/O（仅iOS支持）*/ 
	removeTable?:boolean,

}

interface yunxinIM_deleteAllMessages_Params {
	/**（可选项）是否移除对应最近会话，设置为 true 时将同时删除最近会话信息*/ 
	removeSession?:boolean,

	/**（可选项）是否删除消息表，默认情况下云信采用标记的方式进行消息删除，如果设置为 true，将一并移除对应的消息表，进而减少消息表数量，加快 I/O*/ 
	removeTable?:boolean,

}

interface yunxinIM_requestFriend_Params {
	/**目标用户ID*/ 
	userId:string,

	/**（可选项）操作类型*/ 
	operation?:number,

	/**附言*/ 
	message:string,

}

interface yunxinIM_deleteFriend_Params {
	/**好友Id*/ 
	userId:string,

	/**（可选项）是否同时删除备注*/ 
	removeAlias?:boolean,

}

interface yunxinIM_isMyFriend_Params {
	/**用户Id*/ 
	userId:string,

}

interface yunxinIM_addToBlackList_Params {
	/**用户Id*/ 
	userId:string,

}

interface yunxinIM_removeFromBlackList_Params {
	/**用户Id*/ 
	userId:string,

}

interface yunxinIM_isUserInBlackList_Params {
	/**用户Id*/ 
	userId:string,

}

interface yunxinIM_setMute_Params {
	/**用户Id*/ 
	userId:string,

	/**（可选项）是否免打扰*/ 
	isNotify?:boolean,

}

interface yunxinIM_isMute_Params {
	/**用户Id*/ 
	userId:string,

}

interface yunxinIM_searchUser_Params {
	/**搜索文本*/ 
	searchContent:string,

	/**（可选项）忽略大小写*/ 
	ignoreingCase?:boolean,

	/**（可选项）搜索文本的搜索范围*/ 
	searchRange?:number,

	/**（可选项）搜索文本的搜索范围*/ 
	searchContentOption?:number,

}

interface yunxinIM_getUserInfoList_Params {
	/**用户id数组*/ 
	userIds:Array,

}

interface yunxinIM_fetchSystemNotifications_Params {
	/**最大获取数*/ 
	limit:number,

	/**数据库查询偏移量（仅android支持）*/ 
	offset:number,

}

interface yunxinIM_createTeam_Params {
	/**用户ID列表*/ 
	users:Array,

	/**创建群选项*/ 
	option:JSON,

}

interface yunxinIM_dismissTeam_Params {
	/**群组ID*/ 
	teamId:string,

}

interface yunxinIM_applyToTeam_Params {
	/**群组ID*/ 
	teamId:string,

	/**（可选项）申请消息*/ 
	message?:string,

}

interface yunxinIM_passApplyToTeam_Params {
	/**群组ID*/ 
	teamId:string,

	/**申请的用户 ID*/ 
	userId:string,

}

interface yunxinIM_rejectApplyToTeam_Params {
	/**群组ID*/ 
	teamId:string,

	/**申请的用户 ID*/ 
	userId:string,

	/**（可选项）拒绝理由*/ 
	reason?:string,

}

interface yunxinIM_invitationToTeam_Params {
	/**群组ID*/ 
	teamId:string,

	/**用户ID列表*/ 
	users:Array,

	/**（可选项）邀请附言*/ 
	postscript?:string,

	/**（可选项）扩展消息*/ 
	attach?:string,

}

interface yunxinIM_acceptInviteWithTeam_Params {
	/**群组ID*/ 
	teamId:string,

	/**邀请者 ID*/ 
	invitorId:string,

}

interface yunxinIM_rejectInviteWithTeam_Params {
	/**群组ID*/ 
	teamId:string,

	/**邀请者 ID*/ 
	invitorId:string,

	/**（可选项）拒绝原因*/ 
	reason?:string,

}

interface yunxinIM_kickUsersFromTeam_Params {
	/**群组ID*/ 
	teamId:string,

	/**需要移除的用户ID列表*/ 
	users:string,

}

interface yunxinIM_quitTeam_Params {
	/**群组ID*/ 
	teamId:string,

}

interface yunxinIM_fetchTeamMembers_Params {
	/**群组ID*/ 
	teamId:string,

}

interface yunxinIM_teamMember_Params {
	/**群组ID*/ 
	teamId:string,

	/**用户ID*/ 
	userId:string,

}

interface yunxinIM_updateUserNick_Params {
	/**群组ID*/ 
	teamId:string,

	/**群成员ID*/ 
	userId:string,

	/**新的群成员昵称*/ 
	newNick:string,

}

interface yunxinIM_isMyTeam_Params {
	/**群组ID*/ 
	teamId:string,

}

interface yunxinIM_transferManagerWithTeam_Params {
	/**群组ID*/ 
	teamId:string,

	/**新群主ID*/ 
	newOwnerId:string,

	/**（可选项）是否同时离开群组*/ 
	isLeave?:boolean,

}

interface yunxinIM_addManagersToTeam_Params {
	/**群组ID*/ 
	teamId:string,

	/**需要添加为管理员的用户ID列表*/ 
	users:Array,

}

interface yunxinIM_removeManagersFromTeam_Params {
	/**群组ID*/ 
	teamId:string,

	/**需要添加为管理员的用户ID列表*/ 
	users:Array,

}

interface yunxinIM_muteUserFromTeam_Params {
	/**群组ID*/ 
	teamId:string,

	/**用户ID*/ 
	userId:string,

	/**（可选项）是否禁言*/ 
	isMute?:boolean,

}

interface yunxinIM_muteAllFromTeam_Params {
	/**群组ID*/ 
	teamId:string,

	/**（可选项）是否禁言*/ 
	isMute?:boolean,

}

interface yunxinIM_fetchTeamMutedMembers_Params {
	/**群组ID*/ 
	teamId:string,

}

interface yunxinIM_updateTeamName_Params {
	/**群组ID*/ 
	teamId:string,

	/**群组名称*/ 
	teamName:string,

}

interface yunxinIM_updateTeamAvatar_Params {
	/**群组ID*/ 
	teamId:string,

	/**群组头像 Url*/ 
	teamAvatarUrl:string,

}

interface yunxinIM_updateTeamIntro_Params {
	/**群组ID*/ 
	teamId:string,

	/**群介绍*/ 
	intro:string,

}

interface yunxinIM_updateTeamAnnouncement_Params {
	/**群组ID*/ 
	teamId:string,

	/**群公告*/ 
	announcement:string,

}

interface yunxinIM_updateTeamJoinMode_Params {
	/**群组ID*/ 
	teamId:string,

	/**验证方式*/ 
	joinMode:number,

}

interface yunxinIM_updateTeamBeInviteMode_Params {
	/**群组ID*/ 
	teamId:string,

	/**邀请方式*/ 
	beInviteMode:number,

}

interface yunxinIM_updateTeamInviteMode_Params {
	/**群组ID*/ 
	teamId:string,

	/**邀请方式*/ 
	inviteMode:number,

}

interface yunxinIM_updateTeamUpdateInfoMode_Params {
	/**群组ID*/ 
	teamId:string,

	/**群信息修改权限*/ 
	infoMode:number,

}

interface yunxinIM_updateTeamUpdateClientCustomMode_Params {
	/**群组ID*/ 
	teamId:string,

	/**修改谁有权限更新群组自定义字段*/ 
	clientCustomMode:number,

}

interface yunxinIM_updateTeamCustomInfo_Params {
	/**群组ID*/ 
	teamId:string,

	/**群自定义信息*/ 
	customInfo:string,

}

interface yunxinIM_updateTeamNotifyState_Params {
	/**群组ID*/ 
	teamId:string,

	/**群通知状态*/ 
	notifyState:number,

}

interface yunxinIM_fetchTeamNotifyState_Params {
	/**群组ID*/ 
	teamId:string,

}

interface chivoxLongman {
	/**  初始化引擎*/ 
	initEngine():void

	/** 销毁引擎*/ 
	destroyEngine():void

	/** 开始录音*/ 
	startRecord():void

	/** 停止录音*/ 
	stopRecord():void

}
interface jdKepler {
	/** 初始化sdk。 此接口仅支持Android。*/ 
	init():void

	/** 登录授权*/ 
	login():void

	/** 取消授权*/ 
	cancelAuth():void

	/**
	 * `通过URL打开任意商品页面`
	 * ========params==========
	 *
	 * `url` :string : （可选项）页面url
	 *
	 * `jumpType` :any : （可选项）跳转类型 1代表present 2代表push
	 */
	openPage(params:jdKepler_openPage_Params):void

	/**
	 * `通过SKU打开Kepler单品页`
	 * ========params==========
	 *
	 * `sku` :string : 商品SKU
	 *
	 * `jumpType` :any : （可选项）跳转类型 1代表present 2代表push
	 */
	openDetail(params:jdKepler_openDetail_Params):void

	/**
	 * `打开订单列表`
	 * ========params==========
	 *
	 * `jumpType` :any : （可选项）跳转类型 1代表present 2代表push
	 */
	openOrderList(params:jdKepler_openOrderList_Params):void

	/**
	 * `打开导航页`
	 * ========params==========
	 *
	 * `jumpType` :any : （可选项）跳转类型 1代表present 2代表push
	 */
	openNav(params:jdKepler_openNav_Params):void

	/**
	 * `根据搜索关键字打开搜索结果页`
	 * ========params==========
	 *
	 * `searchKey` :string : 搜索关键字
	 *
	 * `jumpType` :any : （可选项）跳转类型 1代表present 2代表push
	 */
	openSearch(params:jdKepler_openSearch_Params):void

	/**
	 * `打开购物车界面`
	 * ========params==========
	 *
	 * `jumpType` :any : （可选项）跳转类型 1代表present 2代表push
	 */
	openShoppingCart(params:jdKepler_openShoppingCart_Params):void

	/**
	 * `添加到购物车`
	 * ========params==========
	 *
	 * `sku` :string : 商品sku
	 *
	 * `num` :string : （可选项）商品数量
	 */
	addToCart(params:jdKepler_addToCart_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface jdKepler_openPage_Params {
	/**（可选项）页面url*/ 
	url?:string,

	/**（可选项）跳转类型 1代表present 2代表push*/ 
	jumpType?:any,

}

interface jdKepler_openDetail_Params {
	/**商品SKU*/ 
	sku:string,

	/**（可选项）跳转类型 1代表present 2代表push*/ 
	jumpType?:any,

}

interface jdKepler_openOrderList_Params {
	/**（可选项）跳转类型 1代表present 2代表push*/ 
	jumpType?:any,

}

interface jdKepler_openNav_Params {
	/**（可选项）跳转类型 1代表present 2代表push*/ 
	jumpType?:any,

}

interface jdKepler_openSearch_Params {
	/**搜索关键字*/ 
	searchKey:string,

	/**（可选项）跳转类型 1代表present 2代表push*/ 
	jumpType?:any,

}

interface jdKepler_openShoppingCart_Params {
	/**（可选项）跳转类型 1代表present 2代表push*/ 
	jumpType?:any,

}

interface jdKepler_addToCart_Params {
	/**商品sku*/ 
	sku:string,

	/**（可选项）商品数量*/ 
	num?:string,

}

interface SAMIDCard {
	/** 获取扫描模块状态*/ 
	getSAMStatus(callback?: (ret:JSON, err:JSON) => void):void

	/** 获取模块编码SAMID即安全模块编号*/ 
	getSAMID(callback?: (ret:JSON, err:JSON) => void):void

	/** 读取一次身份证信息*/ 
	findIDCard(callback?: (ret:JSON, err:JSON) => void):void

	/** 一直读取身份信息，直到读取到身份证*/ 
	findIDCardKeep(callback?: (ret:JSON, err:JSON) => void):void

	/** 停止一直读取身份信息*/ 
	stopFindIDCardKeep(callback?: (ret:JSON, err:JSON) => void):void

}
interface qupaiLive {
	/**
	 * `初始化sdk`
	 * ========params==========
	 *
	 * `appKey` :string : （必输项）申请的appKey，通过开发控制台上注册得到，进入「控制台」，点击进入应用管理中我的应用选项可查看。
	 *
	 * `appsecret` :string : （必输项）申请的appsecret，通过开发控制台上注册得到，进入「控制台」，点击进入应用管理中我的应用选项可查看。
	 *
	 * `space` :string : （必输项）存储目录 建议使用uid cid之类的信息，space是发布推流为每一个用户设置的一个流名，同时也作为直播回放的空间名称，建议设置为用户的uuid（最大支持32位，如获取的uuid大于32位请自行处理）。例如：A用户的uuid是110001，在paas平台的空间中为A用户生成一个110001的文件夹存放A用户上传的内容。。
	 */
	init(params:qupaiLive_init_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `创建直播`
	 * ========params==========
	 *
	 * `domain` :any : （必填项）获取趣拍平台上的“访问域名”；
	 */
	createLive(params:qupaiLive_createLive_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `开始直播`
	 * ========params==========
	 *
	 * `x` :number : （必填项）模块左上角的 x 坐标（相对于所属的 Window 或 Frame）；
	 *
	 * `y` :number : （必填项）模块左上角的 y 坐标（相对于所属的 Window 或 Frame）；默认：0
	 *
	 * `w` :number : （可选项）模块的宽度；默认：所属的 Window 或 Frame 的宽度
	 *
	 * `h` :number : （可选项）模块的高度；默认：所属的 Window 或 Frame 的高度
	 *
	 * `watermask` :string : （可选项）水印图片路径，仅支持widget://
	 *
	 * `maxBitrate` :number : （可选项）最大码率 （单位：bps）
	 *
	 * `bestBitrate` :number : （可选项）最优码率 （单位：bps）
	 *
	 * `minBitrate` :number : （可选项）最小码率 （单位：bps）
	 *
	 * `audioBitrate` :number : （可选项）音频码率（建议设置为32000)
	 *
	 * `cameraFront` :boolean : （可选项）设置前置摄像头或后置摄像头
	 *
	 * `videoResolution` :number : （可选项）分辨率(仅Android有效) 取值范围:240 360 480 540 720 1080
	 *
	 * `videoWidth` :number : （可选项）分辨率宽(仅iOS专用)；
	 *
	 * `videoHeight` :number : （可选项）分辨率高(仅iOS专用)；
	 *
	 * `fixedOn` :string : （可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window
	 *
	 * `fixed` :boolean : （（可选项）模块是否随所属 Window 或 Frame 滚动
	 */
	startLive(params:qupaiLive_startLive_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 美颜开关*/ 
	skin():void

	/** 闪光灯开关*/ 
	flash():void

	/** 切换摄像头*/ 
	camera():void

	/** 断开直播链接*/ 
	disconnect():void

	/** 关闭直播*/ 
	stop():void

}
interface qupaiLive_init_Params {
	/**（必输项）申请的appKey，通过开发控制台上注册得到，进入「控制台」，点击进入应用管理中我的应用选项可查看。*/ 
	appKey:string,

	/**（必输项）申请的appsecret，通过开发控制台上注册得到，进入「控制台」，点击进入应用管理中我的应用选项可查看。*/ 
	appsecret:string,

	/**（必输项）存储目录 建议使用uid cid之类的信息，space是发布推流为每一个用户设置的一个流名，同时也作为直播回放的空间名称，建议设置为用户的uuid（最大支持32位，如获取的uuid大于32位请自行处理）。例如：A用户的uuid是110001，在paas平台的空间中为A用户生成一个110001的文件夹存放A用户上传的内容。。*/ 
	space:string,

}

interface qupaiLive_createLive_Params {
	/**（必填项）获取趣拍平台上的“访问域名”；*/ 
	domain:any,

}

interface qupaiLive_startLive_Params {
	/**（必填项）模块左上角的 x 坐标（相对于所属的 Window 或 Frame）；*/ 
	x:number,

	/**（必填项）模块左上角的 y 坐标（相对于所属的 Window 或 Frame）；默认：0*/ 
	y:number,

	/**（可选项）模块的宽度；默认：所属的 Window 或 Frame 的宽度*/ 
	w?:number,

	/**（可选项）模块的高度；默认：所属的 Window 或 Frame 的高度*/ 
	h?:number,

	/**（可选项）水印图片路径，仅支持widget://*/ 
	watermask?:string,

	/**（可选项）最大码率 （单位：bps）*/ 
	maxBitrate?:number,

	/**（可选项）最优码率 （单位：bps）*/ 
	bestBitrate?:number,

	/**（可选项）最小码率 （单位：bps）*/ 
	minBitrate?:number,

	/**（可选项）音频码率（建议设置为32000)*/ 
	audioBitrate?:number,

	/**（可选项）设置前置摄像头或后置摄像头*/ 
	cameraFront?:boolean,

	/**（可选项）分辨率(仅Android有效) 取值范围:240 360 480 540 720 1080*/ 
	videoResolution?:number,

	/**（可选项）分辨率宽(仅iOS专用)；*/ 
	videoWidth?:number,

	/**（可选项）分辨率高(仅iOS专用)；*/ 
	videoHeight?:number,

	/**（可选项）模块所属 Frame 的名字，若不传则模块归属于当前 Window*/ 
	fixedOn?:string,

	/**（（可选项）模块是否随所属 Window 或 Frame 滚动*/ 
	fixed?:boolean,

}

interface aliyunPush {
	/** 启动信息统计*/ 
	onAppStart():void

	/** 打开推送通道 **全量推送场景下，打开推送通道存在2-3小时延迟。其他场景实时生效***/ 
	turnOnPushChannel():void

	/** 关闭推送通道 **全量推送场景下，关闭推送通道存在2-3小时延迟。其他场景实时生效***/ 
	turnOffPushChannel():void

	/**
	 * `设置通知声音`
	 * ========params==========
	 *
	 * `soundPath` :string : 声音文件路径（仅支持fs:// & android系统本地路径）
	 */
	setNotificationSoundFilePath(params:aliyunPush_setNotificationSoundFilePath_Params):void

	/**
	 * `设置通知声音`
	 * ========params==========
	 *
	 * `startHour` :number : 免打扰的起始时间（小时）
	 *
	 * `startMinute` :number : 免打扰的起始时间（分钟）
	 *
	 * `endHour` :number : 免打扰的结束时间（小时）
	 *
	 * `endMinute` :number : 免打扰的结束时间（分钟）
	 */
	setDoNotDisturb(params:aliyunPush_setDoNotDisturb_Params, callback?: (ret:JSON) => void):void

	/** 清空所有通知*/ 
	clearNotifications():void

	/** 关闭免打扰模式*/ 
	closeDoNotDisturbMode():void

	/** 将设备与电话号绑定 **为提高信息的到达率和实效性，扩展推送的使用场景，我们推出了推送与短信的融合通知模式。开发者可以设置在一定时间内，如果用户未收到或未点击推送，通过短信补发通知用户，具体方案可参考：[推送短信融合](https://help.aliyun.com/document_detail/57008.html?spm=a2c4g.11186623.2.86.68aa2055470BjB)***/ 
	bindPhoneNumber():void

	/** 解除当前设备与电话号的绑定关系*/ 
	unbindPhoneNumber():void

	/** 获取设备ID*/ 
	getDeviceId():void

	/**
	 * `将应用内账号和推送通道相关联，可以实现按账号的定点消息推送；设备只能绑定一个账号，同一账号可以绑定到多个设备；同一设备更换绑定账号时无需进行解绑，重新调用绑定账号接口即可覆盖生效；若业务场景需要先解绑后绑定，在解绑账号成功回调中进行绑定绑定操作，以此保证执行的顺序性；账户名设置支持64字节。`
	 * ========params==========
	 *
	 * `account` :string : 绑定账号名
	 */
	bindAccount(params:aliyunPush_bindAccount_Params, callback?: (ret:JSON) => void):void

	/** 将应用内账号和推送通道取消关联。*/ 
	unbindAccount():void

	/**
	 * `绑定标签到指定目标；支持向设备、账号和别名绑定标签，绑定类型由参数target指定；绑定标签在10分钟内生效；App最多支持绑定1万个标签【请谨慎使用，避免标签绑定达到上限】，单个标签最大支持128字符。`
	 * ========params==========
	 *
	 * `target` :number : 目标类型
	 *
	 * `tags` :Array : 标签
	 *
	 * `alias` :string : 别名（仅当target = 3时生效）
	 */
	bindTag(params:aliyunPush_bindTag_Params, callback?: (ret:JSON) => void):void

	/**
	 * `解绑指定目标标签；支持解绑设备、账号和别名标签，解绑类型由参数target指定；解绑标签在10分钟内生效；解绑标签不等同于删除标签，目前不支持标签的删除。`
	 * ========params==========
	 *
	 * `target` :number : 目标类型
	 *
	 * `tags` :Array : 标签
	 *
	 * `alias` :string : 别名（仅当target = 3时生效）
	 */
	unbindTag(params:aliyunPush_unbindTag_Params, callback?: (ret:JSON) => void):void

	/** 查询目标绑定标签，当前仅支持查询设备标签；查询结果可从callback的data中获取；标签绑定成功且生效（10分钟内）后即可查询。*/ 
	listTags():void

	/**
	 * `设备添加别名；单个设备最多添加128个别名，且同一别名最多添加到128个设备；别名支持128字节。`
	 * ========params==========
	 *
	 * `alias` :string : 别名
	 */
	addAlias(params:aliyunPush_addAlias_Params, callback?: (ret:JSON) => void):void

	/**
	 * `删除设备别名；支持删除指定别名和删除全部别名（alias为nil or length = 0）。`
	 * ========params==========
	 *
	 * `alias` :string : 别名
	 */
	removeAlias(params:aliyunPush_removeAlias_Params, callback?: (ret:JSON) => void):void

	/** 查询设备别名；查询结果可从callback的data中获取。*/ 
	listAliases():void

	/** 获取设备deviceToken*/ 
	deviceToken():void

	/**
	 * `同步角标数到服务端`
	 * ========params==========
	 *
	 * `badgeNum` :string : 角标数，取值范围[0,99999]
	 */
	syncBadgeNum(params:aliyunPush_syncBadgeNum_Params, callback?: (ret:JSON) => void):void

	/** 监听消息或通知事件*/ 
	addEventlistener():void

	/**
	 * `阿里云推送（YonBuilder专用）`
	 * ========params==========
	 *
	 * `callbaseName` :string : 方法名称
	 */
	receivePush(params:aliyunPush_receivePush_Params, callback?: (ret:JSON) => void):void

	/**
	 * `获取离线推送数据（YonBuilder专用）`
	 * ========params==========
	 *
	 * `type` :number : 获取消息类型； 0：离线消息，1：离线通知，2：所有离线数据
	 */
	getOffLinePush(params:aliyunPush_getOffLinePush_Params, callback?: (ret:JSON) => void):void

	/** 获取deviceToken（YonBuilder专用）*/ 
	getDeviceToken(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `同步角标数到服务端（YonBuilder专用）`
	 * ========params==========
	 *
	 * `badgeNum` :number : 角标数，取值范围[0,99999]
	 */
	setBadgeAutoIncrement(params:aliyunPush_setBadgeAutoIncrement_Params, callback?: (ret:JSON, err:JSON) => void):void

}
interface aliyunPush_setNotificationSoundFilePath_Params {
	/**声音文件路径（仅支持fs:// & android系统本地路径）*/ 
	soundPath:string,

}

interface aliyunPush_setDoNotDisturb_Params {
	/**免打扰的起始时间（小时）*/ 
	startHour:number,

	/**免打扰的起始时间（分钟）*/ 
	startMinute:number,

	/**免打扰的结束时间（小时）*/ 
	endHour:number,

	/**免打扰的结束时间（分钟）*/ 
	endMinute:number,

}

interface aliyunPush_bindAccount_Params {
	/**绑定账号名*/ 
	account:string,

}

interface aliyunPush_bindTag_Params {
	/**目标类型*/ 
	target:number,

	/**标签*/ 
	tags:Array,

	/**别名（仅当target = 3时生效）*/ 
	alias:string,

}

interface aliyunPush_unbindTag_Params {
	/**目标类型*/ 
	target:number,

	/**标签*/ 
	tags:Array,

	/**别名（仅当target = 3时生效）*/ 
	alias:string,

}

interface aliyunPush_addAlias_Params {
	/**别名*/ 
	alias:string,

}

interface aliyunPush_removeAlias_Params {
	/**别名*/ 
	alias:string,

}

interface aliyunPush_syncBadgeNum_Params {
	/**角标数，取值范围[0,99999]*/ 
	badgeNum:string,

}

interface aliyunPush_receivePush_Params {
	/**方法名称*/ 
	callbaseName:string,

}

interface aliyunPush_getOffLinePush_Params {
	/**获取消息类型； 0：离线消息，1：离线通知，2：所有离线数据*/ 
	type:number,

}

interface aliyunPush_setBadgeAutoIncrement_Params {
	/**角标数，取值范围[0,99999]*/ 
	badgeNum:number,

}

interface ajAnalytics {
	/** 初始化sdk并配置必要参数*/ 
	init():void

	/** 记录自定义事件*/ 
	onEvent():void

}
interface sunlogin {
	/**
	 * `登录服务器。`
	 * ========params==========
	 *
	 * `appId` :number : （必填）注册向日葵分配的appId。
	 *
	 * `appKey` :string : （必填）注册向日葵分配的appKey。
	 */
	login(params:sunlogin_login_Params, callback?: (ret:JSON) => void):void

	/** 创建会话。(如果控制端断开了连接，就要重用调用这个方法，产生新的会话才能重新连接上。)*/ 
	createSession():void

	/** 关闭会话。*/ 
	closeSession():void

	/** 退出登录。*/ 
	logout():void

	/** 监听服务状态变化。*/ 
	setListener():void

}
interface sunlogin_login_Params {
	/**（必填）注册向日葵分配的appId。*/ 
	appId:number,

	/**（必填）注册向日葵分配的appKey。*/ 
	appKey:string,

}

interface liuLiangQianBao {
	/**
	 * `打开流量钱包`
	 * ========params==========
	 *
	 * `customId` :string : 在流量钱包申请到的开发者 id
	 *
	 * `appId` :string : 在流量钱包申请到的 appid
	 *
	 * `appSecret` :string : 在流量钱包申请到的 secret
	 *
	 * `requestKey` :string : 在流量钱包申请到的请求密钥
	 *
	 * `skinType` :string : （可选项）皮肤类型
	 */
	open(params:liuLiangQianBao_open_Params):void

}
interface liuLiangQianBao_open_Params {
	/**在流量钱包申请到的开发者 id*/ 
	customId:string,

	/**在流量钱包申请到的 appid*/ 
	appId:string,

	/**在流量钱包申请到的 secret*/ 
	appSecret:string,

	/**在流量钱包申请到的请求密钥*/ 
	requestKey:string,

	/**（可选项）皮肤类型*/ 
	skinType?:string,

}

interface alibaichuan {
	/**     初始化模块信息，打开页面require完成就去执行*/ 
	initTaeSDK():void

	/**     打开手淘授权登陆*/ 
	showLogin():void

	/**     获取已经登陆的用户的相关信息*/ 
	getUserInfo():void

	/**     退出登陆*/ 
	logout():void

	/**
	 * `    通过itemid打开宝贝，以下是正常使用，如果需要使用高佣转链功能，请参考[问题集锦](http://community.apicloud.com/bbs/forum.php?mod=viewthread&tid=59901&extra=)`
	 * ========params==========
	 *
	 * `clientType` :any : 表示唤端类型：taobao---唤起淘宝客户端；tmall---唤起天猫客户端
	 *
	 * `backUrl` :string : 小把手，唤端返回的scheme，(如果不传默认将不展示小把手；如果想展示小把手，可以自己传入自定义的scheme，或者传入百川提供的默认scheme："alisdk://")
	 *
	 * `nativeOpenFailedMode` :string : 目前原阿里系页面需要拉回手机淘宝、未安装手机淘宝，默认会跳转到对应的应用下载页。媒体可以根据需要自定义唤起手淘的失败处理方式，目前提供“降级H5应用內打开” 和 “跳转应用下载页”。注：降级H5应用內打开，由于安全策略升级，暂不支持完成整个电商交易流程，请悉知。
	 *
	 * `pid` :string : [获取pid](https://baichuan.bbs.taobao.com/detail.html?spm=a3c0d.7998981.0.0.536e2f45hTCymq&postId=7927184)
	 *
	 * `itemid` :string : 宝贝的id，itemid为打开宝贝详情后，看到浏览器里有id一项，如"https://item.taobao.com/item.htm?id=45535180986",这里的id就是itemid
	 *
	 * `ret` :any : null
	 *
	 * `err` :any : null
	 */
	showTaokeItemById(params:alibaichuan_showTaokeItemById_Params):void

	/**
	 * `    通过URL打开宝贝详情，此方法主要以url的自带佣金为准，当然也可传入高佣转链的隐藏参数，[传送门](http://community.apicloud.com/bbs/forum.php?mod=viewthread&tid=59901&extra=)`
	 * ========params==========
	 *
	 * `url` :string : 商品URL地址, 或者优惠券地址
	 *
	 * `clientType` :any : 表示唤端类型：taobao---唤起淘宝客户端；tmall---唤起天猫客户端
	 *
	 * `backUrl` :string : 小把手，唤端返回的scheme，(如果不传默认将不展示小把手；如果想展示小把手，可以自己传入自定义的scheme，或者传入百川提供的默认scheme："alisdk://")
	 *
	 * `nativeOpenFailedMode` :string : 目前原阿里系页面需要拉回手机淘宝、未安装手机淘宝，默认会跳转到对应的应用下载页。媒体可以根据需要自定义唤起手淘的失败处理方式，目前提供“降级H5应用內打开” 和 “跳转应用下载页”。注：降级H5应用內打开，由于安全策略升级，暂不支持完成整个电商交易流程，请悉知。
	 *
	 * `pid` :string : [获取pid](https://baichuan.bbs.taobao.com/detail.html?spm=a3c0d.7998981.0.0.536e2f45hTCymq&postId=7927184)
	 *
	 * `ret` :any : null
	 *
	 * `err` :any : null
	 */
	showDetailByURL(params:alibaichuan_showDetailByURL_Params):void

	/**     打开我的购物车*/ 
	openMyCart():void

	/**
	 * `    打开我的订单`
	 * ========params==========
	 *
	 * `status` :number : 默认跳转页面, 0：全部；1：待付款；2：待发货；3：待收货；4：待评价。 若传入的不是这几个数字，则跳转到“全部”页面且“allOrder”失效
	 *
	 * `isAllOrder` :boolean : true：显示全部订单，建议填true，不管status传什么都填true
	 *
	 * `clientType` :any : 表示唤端类型：taobao---唤起淘宝客户端；tmall---唤起天猫客户端
	 *
	 * `backUrl` :string : 小把手，唤端返回的scheme，(如果不传默认将不展示小把手；如果想展示小把手，可以自己传入自定义的scheme，或者传入百川提供的默认scheme："alisdk://")
	 *
	 * `nativeOpenFailedMode` :string : 目前原阿里系页面需要拉回手机淘宝、未安装手机淘宝，默认会跳转到对应的应用下载页。媒体可以根据需要自定义唤起手淘的失败处理方式，目前提供“降级H5应用內打开” 和 “跳转应用下载页”。注：降级H5应用內打开，由于安全策略升级，暂不支持完成整个电商交易流程，请悉知。
	 *
	 * `pid` :string : [获取pid](https://baichuan.bbs.taobao.com/detail.html?spm=a3c0d.7998981.0.0.536e2f45hTCymq&postId=7927184)
	 *
	 * `pageType` :string : 此功能阿里暂未支持，待支持后可以在这里传人pageType：如商品详情“detail”，购物车“cart”，具体看官方的更新：2-(2)-b [传送门](https://baichuan.taobao.com/docs/doc.htm?spm=a3c0d.7629140.0.0.67e6be48UBr2Br&treeId=129&articleId=118122&docType=1)
	 *
	 * `ret` :JSON : null
	 *
	 * `err` :JSON : null
	 */
	myOrdersPage(params:alibaichuan_myOrdersPage_Params):void

	/**
	 * `    打开商家店铺`
	 * ========params==========
	 *
	 * `shopid` :string : 商家店铺ID
	 *
	 * `clientType` :any : 表示唤端类型：taobao---唤起淘宝客户端；tmall---唤起天猫客户端
	 *
	 * `backUrl` :string : 小把手，唤端返回的scheme，(如果不传默认将不展示小把手；如果想展示小把手，可以自己传入自定义的scheme，或者传入百川提供的默认scheme："alisdk://")
	 *
	 * `nativeOpenFailedMode` :string : 目前原阿里系页面需要拉回手机淘宝、未安装手机淘宝，默认会跳转到对应的应用下载页。媒体可以根据需要自定义唤起手淘的失败处理方式，目前提供“降级H5应用內打开” 和 “跳转应用下载页”。注：降级H5应用內打开，由于安全策略升级，暂不支持完成整个电商交易流程，请悉知。
	 *
	 * `pid` :string : [获取pid](https://baichuan.bbs.taobao.com/detail.html?spm=a3c0d.7998981.0.0.536e2f45hTCymq&postId=7927184)
	 *
	 * `sellerId` :string : 卖家ID，淘宝联盟-联盟产品-单品店铺推广-店铺推广里的user_number_id：如“https://handuyishe.tmall.com/shop/view_shop.htm?user_number_id=263817957&ali_trackid=2%3Amm_112712463_17294774_66324446%3A1568700525_248_1572113213”
	 *
	 * `ret` :JSON : null
	 *
	 * `err` :JSON : null
	 */
	openShopPage(params:alibaichuan_openShopPage_Params):void

	/**
	 * `    设置渠道信息（如果有特殊渠道专享价，需要设置，默认不要使用），初始化完成后调用才能生效`
	 * ========params==========
	 *
	 * `typeName` :string : 渠道类型（默认为：0）
	 *
	 * `channelName` :string : 渠道名称（默认为空：""）
	 *
	 * `ret` :JSON : null
	 *
	 * `err` :JSON : null
	 */
	setChannel(params:alibaichuan_setChannel_Params):void

	/**
	 * `    设置isv版本，提供isvcode全局接口，设置isv的版本 ，默认1.0.0，初始化完成后调用才能生效`
	 * ========params==========
	 *
	 * `isvVersion` :string : isvVersion (默认1.0.0)
	 *
	 * `ret` :JSON : null
	 *
	 * `err` :JSON : null
	 */
	setISVVersion(params:alibaichuan_setISVVersion_Params):void

	/**
	 * `    设置是否使用同步淘客打点。true：使用淘客同步打点；false：关闭同步打点，使用异步打点；注意：初始化完成后调用才能生效.`
	 * ========params==========
	 *
	 * `isSyncForTaoke` :boolean : 设置是否使用同步淘客打点。true：使用淘客同步打点；false：关闭同步打点，使用异步打点；
	 *
	 * `ret` :JSON : null
	 *
	 * `err` :JSON : null
	 */
	setSyncForTaoke(params:alibaichuan_setSyncForTaoke_Params):void

}
interface alibaichuan_showTaokeItemById_Params {
	/**表示唤端类型：taobao---唤起淘宝客户端；tmall---唤起天猫客户端*/ 
	clientType:any,

	/**小把手，唤端返回的scheme，(如果不传默认将不展示小把手；如果想展示小把手，可以自己传入自定义的scheme，或者传入百川提供的默认scheme："alisdk://")*/ 
	backUrl:string,

	/**目前原阿里系页面需要拉回手机淘宝、未安装手机淘宝，默认会跳转到对应的应用下载页。媒体可以根据需要自定义唤起手淘的失败处理方式，目前提供“降级H5应用內打开” 和 “跳转应用下载页”。注：降级H5应用內打开，由于安全策略升级，暂不支持完成整个电商交易流程，请悉知。*/ 
	nativeOpenFailedMode:string,

	/**[获取pid](https://baichuan.bbs.taobao.com/detail.html?spm=a3c0d.7998981.0.0.536e2f45hTCymq&postId=7927184)*/ 
	pid:string,

	/**宝贝的id，itemid为打开宝贝详情后，看到浏览器里有id一项，如"https://item.taobao.com/item.htm?id=45535180986",这里的id就是itemid*/ 
	itemid:string,

	/**null*/ 
	ret:any,

	/**null*/ 
	err:any,

}

interface alibaichuan_showDetailByURL_Params {
	/**商品URL地址, 或者优惠券地址*/ 
	url:string,

	/**表示唤端类型：taobao---唤起淘宝客户端；tmall---唤起天猫客户端*/ 
	clientType:any,

	/**小把手，唤端返回的scheme，(如果不传默认将不展示小把手；如果想展示小把手，可以自己传入自定义的scheme，或者传入百川提供的默认scheme："alisdk://")*/ 
	backUrl:string,

	/**目前原阿里系页面需要拉回手机淘宝、未安装手机淘宝，默认会跳转到对应的应用下载页。媒体可以根据需要自定义唤起手淘的失败处理方式，目前提供“降级H5应用內打开” 和 “跳转应用下载页”。注：降级H5应用內打开，由于安全策略升级，暂不支持完成整个电商交易流程，请悉知。*/ 
	nativeOpenFailedMode:string,

	/**[获取pid](https://baichuan.bbs.taobao.com/detail.html?spm=a3c0d.7998981.0.0.536e2f45hTCymq&postId=7927184)*/ 
	pid:string,

	/**null*/ 
	ret:any,

	/**null*/ 
	err:any,

}

interface alibaichuan_myOrdersPage_Params {
	/**默认跳转页面, 0：全部；1：待付款；2：待发货；3：待收货；4：待评价。 若传入的不是这几个数字，则跳转到“全部”页面且“allOrder”失效*/ 
	status:number,

	/**true：显示全部订单，建议填true，不管status传什么都填true*/ 
	isAllOrder:boolean,

	/**表示唤端类型：taobao---唤起淘宝客户端；tmall---唤起天猫客户端*/ 
	clientType:any,

	/**小把手，唤端返回的scheme，(如果不传默认将不展示小把手；如果想展示小把手，可以自己传入自定义的scheme，或者传入百川提供的默认scheme："alisdk://")*/ 
	backUrl:string,

	/**目前原阿里系页面需要拉回手机淘宝、未安装手机淘宝，默认会跳转到对应的应用下载页。媒体可以根据需要自定义唤起手淘的失败处理方式，目前提供“降级H5应用內打开” 和 “跳转应用下载页”。注：降级H5应用內打开，由于安全策略升级，暂不支持完成整个电商交易流程，请悉知。*/ 
	nativeOpenFailedMode:string,

	/**[获取pid](https://baichuan.bbs.taobao.com/detail.html?spm=a3c0d.7998981.0.0.536e2f45hTCymq&postId=7927184)*/ 
	pid:string,

	/**此功能阿里暂未支持，待支持后可以在这里传人pageType：如商品详情“detail”，购物车“cart”，具体看官方的更新：2-(2)-b [传送门](https://baichuan.taobao.com/docs/doc.htm?spm=a3c0d.7629140.0.0.67e6be48UBr2Br&treeId=129&articleId=118122&docType=1)*/ 
	pageType:string,

	/**null*/ 
	ret:JSON,

	/**null*/ 
	err:JSON,

}

interface alibaichuan_openShopPage_Params {
	/**商家店铺ID*/ 
	shopid:string,

	/**表示唤端类型：taobao---唤起淘宝客户端；tmall---唤起天猫客户端*/ 
	clientType:any,

	/**小把手，唤端返回的scheme，(如果不传默认将不展示小把手；如果想展示小把手，可以自己传入自定义的scheme，或者传入百川提供的默认scheme："alisdk://")*/ 
	backUrl:string,

	/**目前原阿里系页面需要拉回手机淘宝、未安装手机淘宝，默认会跳转到对应的应用下载页。媒体可以根据需要自定义唤起手淘的失败处理方式，目前提供“降级H5应用內打开” 和 “跳转应用下载页”。注：降级H5应用內打开，由于安全策略升级，暂不支持完成整个电商交易流程，请悉知。*/ 
	nativeOpenFailedMode:string,

	/**[获取pid](https://baichuan.bbs.taobao.com/detail.html?spm=a3c0d.7998981.0.0.536e2f45hTCymq&postId=7927184)*/ 
	pid:string,

	/**卖家ID，淘宝联盟-联盟产品-单品店铺推广-店铺推广里的user_number_id：如“https://handuyishe.tmall.com/shop/view_shop.htm?user_number_id=263817957&ali_trackid=2%3Amm_112712463_17294774_66324446%3A1568700525_248_1572113213”*/ 
	sellerId:string,

	/**null*/ 
	ret:JSON,

	/**null*/ 
	err:JSON,

}

interface alibaichuan_setChannel_Params {
	/**渠道类型（默认为：0）*/ 
	typeName:string,

	/**渠道名称（默认为空：""）*/ 
	channelName:string,

	/**null*/ 
	ret:JSON,

	/**null*/ 
	err:JSON,

}

interface alibaichuan_setISVVersion_Params {
	/**isvVersion (默认1.0.0)*/ 
	isvVersion:string,

	/**null*/ 
	ret:JSON,

	/**null*/ 
	err:JSON,

}

interface alibaichuan_setSyncForTaoke_Params {
	/**设置是否使用同步淘客打点。true：使用淘客同步打点；false：关闭同步打点，使用异步打点；*/ 
	isSyncForTaoke:boolean,

	/**null*/ 
	ret:JSON,

	/**null*/ 
	err:JSON,

}

interface x5ac {
	/**
	 * `首先需要初始化远端主机IP，通过传入远端主机IP，以便后续与该主机进行通信。`
	 * ========params==========
	 *
	 * `targetIP` :string : 远端主机IP
	 */
	connect(params:x5ac_connect_Params, callback?: (ret:JSON) => void):void

	/**
	 * `校验动态密码是否正确。`
	 * ========params==========
	 *
	 * `checkSecret` :string : 输入密码
	 */
	checkDynamicSecret(params:x5ac_checkDynamicSecret_Params, callback?: (ret:JSON) => void):void

	/** 通知A模块进入待机状态。*/ 
	notifyToWait():void

	/**
	 * `人脸识别是否成功，需通知A模块。`
	 * ========params==========
	 *
	 * `success` :boolean : 需通知A模块。
	 */
	recognizeFace(params:x5ac_recognizeFace_Params, callback?: (ret:JSON) => void):void

	/**
	 * `可视通话开门，需传入相应的token给A模块验证。`
	 * ========params==========
	 *
	 * `token` :string : 传入token
	 */
	videoCallToOpen(params:x5ac_videoCallToOpen_Params, callback?: (ret:JSON) => void):void

	/** 释放资源*/ 
	release():void

	/** 设置开门结果的监听器：*/ 
	listenOpenStatus():void

	/** 通联微信支付接口*/ 
	listenKeyValue():void

}
interface x5ac_connect_Params {
	/**远端主机IP*/ 
	targetIP:string,

}

interface x5ac_checkDynamicSecret_Params {
	/**输入密码*/ 
	checkSecret:string,

}

interface x5ac_recognizeFace_Params {
	/**需通知A模块。*/ 
	success:boolean,

}

interface x5ac_videoCallToOpen_Params {
	/**传入token*/ 
	token:string,

}

interface vinOCR {
	/**
	 * `开启识别控件`
	 * ========params==========
	 *
	 * `devcode` :string : 授权开发码
	 *
	 * `currentType` :number : （可选项）识别类型
	 */
	openView(params:vinOCR_openView_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 关闭识别控件*/ 
	closeView():void

}
interface vinOCR_openView_Params {
	/**授权开发码*/ 
	devcode:string,

	/**（可选项）识别类型*/ 
	currentType?:number,

}

interface braintreeApplePay {
	/** 判断手机是否支持 Apple Pay 功能*/ 
	isSupportPayments():void

	/** 判断手机是否已加载有可用的支付卡片*/ 
	canMakePayments():void

	/** 跳转到钱包设置添加银行卡、信用卡*/ 
	addCard():void

	/**
	 * `初始化`
	 * ========params==========
	 *
	 * `token` :string : 从服务器获取的token
	 */
	initWithToken(params:braintreeApplePay_initWithToken_Params, callback?: (ret:JSON) => void):void

	/**
	 * `发起支付请求`
	 * ========params==========
	 *
	 * `countryCode` :string : The merchant's ISO country code.
	 *
	 * `currencyCode` :string : Currency code for this payment.
	 *
	 * `merchantIdentifier` :string : Identifies the merchant, as previously agreed with Apple.  Must match one of the merchant identifiers in the application's entitlement.
	 *
	 * `items` :Array : 商品列表
	 */
	paymentRequest(params:braintreeApplePay_paymentRequest_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 获取 nonce 监听，成功获取 nonce 后开始发到服务器端扣款*/ 
	didAuthorizePaymentListener(callback?: (ret:JSON, err:JSON) => void):void

	/** 监听完成事件*/ 
	didFinishListener():void

	/**
	 * `设置苹果支付状态`
	 * ========params==========
	 *
	 * `status` :string : 支付状态
	 */
	setApplePayStatus(params:braintreeApplePay_setApplePayStatus_Params):void

}
interface braintreeApplePay_initWithToken_Params {
	/**从服务器获取的token*/ 
	token:string,

}

interface braintreeApplePay_paymentRequest_Params {
	/**The merchant's ISO country code.*/ 
	countryCode:string,

	/**Currency code for this payment.*/ 
	currencyCode:string,

	/**Identifies the merchant, as previously agreed with Apple.  Must match one of the merchant identifiers in the application's entitlement.*/ 
	merchantIdentifier:string,

	/**商品列表*/ 
	items:Array,

}

interface braintreeApplePay_setApplePayStatus_Params {
	/**支付状态*/ 
	status:string,

}

interface superFile {
	/** sdk 初始化 （暂仅支持Android）自模块1.0.7后需要调用该方法进行初始化*/ 
	init():void

	/**
	 * `打开文件`
	 * ========params==========
	 *
	 * `path` :string : (必选项) 文件路径 android支持fs或者绝对路径
	 */
	open(params:superFile_open_Params):void

	/** 打开文件*/ 
	openView():void

	/** 隐藏窗口*/ 
	hide():void

	/** 显示窗口*/ 
	show():void

	/** 关闭窗口*/ 
	close():void

}
interface superFile_open_Params {
	/**(必选项) 文件路径 android支持fs或者绝对路径*/ 
	path:string,

}

interface easyAR {
	/**
	 * `以 window 的方式打开一个摄像头界面`
	 * ========params==========
	 *
	 * `key` :string : 在 EasyAR 平台申请创建的 key。注意是跟包名绑定的。
	 *
	 * `sources` :Array : 设定的照片及其对应的视频
	 */
	open(params:easyAR_open_Params, callback?: (ret:JSON) => void):void

	/** 关闭模块*/ 
	close():void

}
interface easyAR_open_Params {
	/**在 EasyAR 平台申请创建的 key。注意是跟包名绑定的。*/ 
	key:string,

	/**设定的照片及其对应的视频*/ 
	sources:Array,

}

interface hotsspAds {
}
interface vlcPlayer {
	/**
	 * `打开播放器界面`
	 * ========params==========
	 *
	 * `rect` :JSON : (可选项）播放器的位置及长宽
	 *
	 * `texts` :JSON : （可选项）顶部标题文字
	 *
	 * `styles` :JSON : （可选项）模块的样式设置
	 *
	 * `path` :string : 视频资源地址,支持网络和本地路径（fs://，widget://）
	 *
	 * `autoPlay` :boolean : （可选项）打开时是否自动播放
	 *
	 * `isAutorotate` :boolean : （可选项）是否支持自动转屏；为false isFullBtn自动为false
	 *
	 * `isShowProcessView` :boolean : （可选项）是否显示进度条 (显示:true ; 不显示:false)【备注:直播流自动 默认为false】
	 *
	 * `isShowTimeLable` :boolean : （可选项）是否显示播放时间 (显示:true ; 不显示:false)备注:直播流自动 默认为false】
	 *
	 * `isLive` :boolean : （可选项）是否直播视频源 （直播：true；点播：false）
	 *
	 * `enableFull` :boolean : （可选项）本次播放视频是否全屏播放，当为true时将直接全屏播放视频，x,y,w,h,fixedOn,fixed值不会生效。
	 *
	 * `isFullBtn` :boolean : （可选项）小窗口是否显示进入全屏按钮
	 *
	 * `isBackBtn` :boolean : （可选项）窗口播放时是否开启手势控制音量，亮度和进度 （开启：true；不开启：false）
	 *
	 * `isOpenGesture` :boolean : （可选项）全屏时是否开启手势控制音量，亮度和进度 （开启：true；不开启 - ：false）
	 *
	 * `coverImg` :boolean : （可选项）封面图路径，播放器打开尚未播放时的封面图，要求本地路径（widget://、fs://）
	 *
	 * `audio` :boolean : （可选项）播放的资源是否是音频文件，若是则开始播放后不移除封面图 coverImg
	 */
	open(params:vlcPlayer_open_Params):void

	/**
	 * `设置视频的文件路径`
	 * ========params==========
	 *
	 * `path` :string : 视频资源地址,支持网络和本地路径（fs://，widget://）
	 *
	 * `coverImg` :boolean : （可选项）封面图路径，播放器打开尚未播放时的封面图，要求本地路径（widget://、fs://）
	 *
	 * `title` :string : （可选项）当设置 play 接口打开的视频时，本参数表示设置该视频的标题，本参数仅对 play 接口有效
	 *
	 * `audio` :boolean : （可选项）播放的资源是否是音频文件，若是则开始播放后不移除封面图 coverImg
	 */
	setPath(params:vlcPlayer_setPath_Params):void

	/** 重新播放*/ 
	replay():void

	/** 开始播放*/ 
	play():void

	/** 暂停播放*/ 
	pause():void

	/** 关闭播放器*/ 
	close():void

	/** 显示视频播放视图*/ 
	show():void

	/** 隐藏视频播放视图*/ 
	hide():void

	/**
	 * `添加监听`
	 * ========params==========
	 *
	 * `name` :string : （可选项）所要监听的动作名称
	 */
	addEventListener(params:vlcPlayer_addEventListener_Params, callback?: (ret:JSON) => void):void

	/**
	 * `移除动作监听`
	 * ========params==========
	 *
	 * `name` :string : （可选项）所要移除的监听的动作名称
	 */
	removeEventListener(params:vlcPlayer_removeEventListener_Params):void

	/** 全屏播放（横屏模式）*/ 
	fullScreen():void

	/** 取消全屏播放*/ 
	cancelFullScreen():void

	/**
	 * `快进`
	 * ========params==========
	 *
	 * `seconds` :number : 快进的秒数
	 */
	forward(params:vlcPlayer_forward_Params):void

	/**
	 * `快退`
	 * ========params==========
	 *
	 * `seconds` :number : 快退的秒数
	 */
	rewind(params:vlcPlayer_rewind_Params):void

	/**
	 * `跳转`
	 * ========params==========
	 *
	 * `seconds` :number : 跳转到音视频播放的秒数
	 */
	seekTo(params:vlcPlayer_seekTo_Params):void

	/**
	 * `设置屏幕亮度`
	 * ========params==========
	 *
	 * `brightness` :number : （可选项）设置的屏幕的亮度，取值范围：0-100，**在 iOS 平台上设置的是系统屏幕亮度。Android 平台上设置的本应用内的屏幕亮度**
	 */
	setBrightness(params:vlcPlayer_setBrightness_Params):void

	/** 获取当前屏幕亮度值*/ 
	getBrightness():void

	/**
	 * `设置音量`
	 * ========params==========
	 *
	 * `volume` :number : （可选项）音量大小，取值范围：0-1
	 */
	setVolume(params:vlcPlayer_setVolume_Params):void

	/** 获取当前播放音量*/ 
	getVolume():void

	/** 获取视频的时长*/ 
	getDuration():void

	/** 获取已经播放的时长*/ 
	getCurrentPosition():void

	/** 获取是否全屏播放状态*/ 
	isFullScreen():void

}
interface vlcPlayer_open_Params {
	/**(可选项）播放器的位置及长宽*/ 
	rect?:JSON,

	/**（可选项）顶部标题文字*/ 
	texts?:JSON,

	/**（可选项）模块的样式设置*/ 
	styles?:JSON,

	/**视频资源地址,支持网络和本地路径（fs://，widget://）*/ 
	path:string,

	/**（可选项）打开时是否自动播放*/ 
	autoPlay?:boolean,

	/**（可选项）是否支持自动转屏；为false isFullBtn自动为false*/ 
	isAutorotate?:boolean,

	/**（可选项）是否显示进度条 (显示:true ; 不显示:false)【备注:直播流自动 默认为false】*/ 
	isShowProcessView?:boolean,

	/**（可选项）是否显示播放时间 (显示:true ; 不显示:false)备注:直播流自动 默认为false】*/ 
	isShowTimeLable?:boolean,

	/**（可选项）是否直播视频源 （直播：true；点播：false）*/ 
	isLive?:boolean,

	/**（可选项）本次播放视频是否全屏播放，当为true时将直接全屏播放视频，x,y,w,h,fixedOn,fixed值不会生效。*/ 
	enableFull?:boolean,

	/**（可选项）小窗口是否显示进入全屏按钮*/ 
	isFullBtn?:boolean,

	/**（可选项）窗口播放时是否开启手势控制音量，亮度和进度 （开启：true；不开启：false）*/ 
	isBackBtn?:boolean,

	/**（可选项）全屏时是否开启手势控制音量，亮度和进度 （开启：true；不开启 - ：false）*/ 
	isOpenGesture?:boolean,

	/**（可选项）封面图路径，播放器打开尚未播放时的封面图，要求本地路径（widget://、fs://）*/ 
	coverImg?:boolean,

	/**（可选项）播放的资源是否是音频文件，若是则开始播放后不移除封面图 coverImg*/ 
	audio?:boolean,

}

interface vlcPlayer_setPath_Params {
	/**视频资源地址,支持网络和本地路径（fs://，widget://）*/ 
	path:string,

	/**（可选项）封面图路径，播放器打开尚未播放时的封面图，要求本地路径（widget://、fs://）*/ 
	coverImg?:boolean,

	/**（可选项）当设置 play 接口打开的视频时，本参数表示设置该视频的标题，本参数仅对 play 接口有效*/ 
	title?:string,

	/**（可选项）播放的资源是否是音频文件，若是则开始播放后不移除封面图 coverImg*/ 
	audio?:boolean,

}

interface vlcPlayer_addEventListener_Params {
	/**（可选项）所要监听的动作名称*/ 
	name?:string,

}

interface vlcPlayer_removeEventListener_Params {
	/**（可选项）所要移除的监听的动作名称*/ 
	name?:string,

}

interface vlcPlayer_forward_Params {
	/**快进的秒数*/ 
	seconds:number,

}

interface vlcPlayer_rewind_Params {
	/**快退的秒数*/ 
	seconds:number,

}

interface vlcPlayer_seekTo_Params {
	/**跳转到音视频播放的秒数*/ 
	seconds:number,

}

interface vlcPlayer_setBrightness_Params {
	/**（可选项）设置的屏幕的亮度，取值范围：0-100，**在 iOS 平台上设置的是系统屏幕亮度。Android 平台上设置的本应用内的屏幕亮度***/ 
	brightness?:number,

}

interface vlcPlayer_setVolume_Params {
	/**（可选项）音量大小，取值范围：0-1*/ 
	volume?:number,

}

interface aliBC {
	/** 初始化SDK（调用优先级最高,只需要调用一次）*/ 
	asyncInit(callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `设置SDK 淘客打点策略（sdk默认采用淘客同步打点）`
	 * ========params==========
	 *
	 * `isSyncForTaoke` :boolean : （可选项）设置是否使用同步淘客打点。true:使用淘客同步打点；false:关闭同步打点,使用异步打点。
	 */
	setSyncForTaoke(params:aliBC_setSyncForTaoke_Params, callback?: (ret:JSON) => void):void

	/** 开启接口免授权模式*/ 
	setIsAuthVip():void

	/**
	 * `设置App标识字段,可用于区分使用本SDK的具体三方App`
	 * ========params==========
	 *
	 * `code` :string : null
	 *
	 * `ret` :JSON : 返回值  **仅Android有返回**
	 */
	setIsvCode(params:aliBC_setIsvCode_Params):void

	/**
	 * `设置三方App版本,可用于标识App版本`
	 * ========params==========
	 *
	 * `version` :string : null
	 */
	setIsvVersion(params:aliBC_setIsvVersion_Params):void

	/**
	 * `设置三方App名字,可用于标识App名字（**仅iOS有效**）`
	 * ========params==========
	 *
	 * `name` :string : null
	 */
	setIsvAppName(params:aliBC_setIsvAppName_Params):void

	/**
	 * `设置淘客全局参数`
	 * ========params==========
	 *
	 * `pid` :string : 淘客pid,获取流程参考:[http://baichuan.taobao.com/portal/doc?articleId=220](http://baichuan.taobao.com/portal/doc?articleId=220)
	 *
	 * `adzoneId` :string : (可选项)淘宝联盟adzoneId。**高佣转链/跨店结算 功能所需**, 如果走adzoneId的方式分佣打点，需要在extraParams中显式传入taokeAppkey，否则打点失败。[功能介绍](http://baichuan.taobao.com/support/announcementDetail.htm?spm=0.0.0.0.VkfdrC&id=25274)
	 *
	 * `extraParams` :JSON : (可选项)adzoneId参数不为空时需要此参数，
	 */
	setTaokeParams(params:aliBC_setTaokeParams_Params, callback?: (ret:JSON) => void):void

	/**
	 * `设置渠道信息（如果有渠道专享价,需要设置）`
	 * ========params==========
	 *
	 * `typeName` :string : （可选项）设置渠道类型
	 *
	 * `channelName` :string : （可选项）设置渠道名称
	 */
	setChannel(params:aliBC_setChannel_Params):void

	/** 授权登录*/ 
	showLogin(callback?: (ret:JSON, err:JSON) => void):void

	/** 注销*/ 
	logout(callback?: (ret:JSON, err:JSON) => void):void

	/** 获取用户信息*/ 
	getUserInfo(callback?: (ret:JSON) => void):void

	/**
	 * `打开淘宝商品详情页（**注意：现在百川强制跳转手淘，如果没跳手淘而是打开的H5页面 则不能成功购买和加入购物车**）`
	 * ========params==========
	 *
	 * `itemId` :string : 商品id。支持itemId和openItemId的商品（如:37196464781L,AAHd5d-HAAeGwJedwSnHktBI）,必填,不允许为null
	 *
	 * `openType` :string : (可选项)打开页面的方式
	 *
	 * `linkKey` :string : (可选项)当打开页面的方式（openType）为native时,设置拉起手淘or天猫。（不传则走百川默认设置,建议传值）
	 *
	 * `pid` :string : 淘客pid,获取流程参考:[http://baichuan.taobao.com/portal/doc?articleId=220](http://baichuan.taobao.com/portal/doc?articleId=220)
	 *
	 * `adzoneId` :string : (可选项)淘宝联盟adzoneId。**高佣转链/跨店结算 功能所需**, 如果走adzoneId的方式分佣打点，需要在extraParams中显式传入taokeAppkey，否则打点失败。[功能介绍](http://baichuan.taobao.com/support/announcementDetail.htm?spm=0.0.0.0.VkfdrC&id=25274)
	 *
	 * `extraParams` :JSON : (可选项)adzoneId参数不为空时需要此参数，
	 *
	 * `backUrl` :string : 用于打开手淘时的 “返回（小把手）” 的点击返回，目前**ios传空字符串，android传config.xml文件中配置的urlScheme(即tbopen+appkey)**
	 *
	 * `degradeUrl` :string : 降级url，如果唤端失败且设置了降级url，则加载该url
	 *
	 * `failModeType` :string : 用于控制没安装手淘或者没检测到手淘的时候的打开页面逻辑
	 *
	 * `pageClose` :boolean : (可选项) 购买商品支付成功后是否关闭淘宝页面。true:关闭,false:不关闭。**仅在Android H5页面生效**
	 *
	 * `trackParams` :JSON : (可选项)自定义参数（暂时没发现啥用，但百川有就保留了）
	 */
	showDetailPage(params:aliBC_showDetailPage_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `打开淘宝加入购物车页面(**该接口暂未开放**)`
	 * ========params==========
	 *
	 * `code` :string : 打开页面的控制参数
	 */
	showAddCartPage(params:aliBC_showAddCartPage_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `打开我的订单页面(**该接口暂未开放**)`
	 * ========params==========
	 *
	 * `code` :string : 打开页面的控制参数
	 *
	 * `orderStatus` :any : 默认跳转页面。0:全部；1:待付款；2:待发货；3:待收货；4:待评价
	 *
	 * `allOrder` :boolean : false 进行订单分域（只展示通过当前app下单的订单）,true 显示所有订单
	 */
	showMyOrders(params:aliBC_showMyOrders_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `打开我的购物车（**该接口暂不稳定，请注意测试；如不能打开可以使用showPageByUrl 传url为https://market.m.taobao.com/app/dinamic/h5-tb-cart-old/index.html实现**）`
	 * ========params==========
	 *
	 * `openType` :string : (可选项)打开页面的方式:拉起手淘/天猫 和 h5打开页面,默认值:h5
	 *
	 * `linkKey` :string : (可选项)当打开页面的方式（openType）为native时,设置拉起手淘or天猫。（不传则走百川默认设置,建议传值）
	 *
	 * `pid` :string : 淘客pid,获取流程参考:[http://baichuan.taobao.com/portal/doc?articleId=220](http://baichuan.taobao.com/portal/doc?articleId=220)
	 *
	 * `adzoneId` :string : (可选项)淘宝联盟adzoneId。**高佣转链/跨店结算 功能所需**, 如果走adzoneId的方式分佣打点，需要在extraParams中显式传入taokeAppkey，否则打点失败。[功能介绍](http://baichuan.taobao.com/support/announcementDetail.htm?spm=0.0.0.0.VkfdrC&id=25274)
	 *
	 * `extraParams` :JSON : (可选项)adzoneId参数不为空时需要此参数，
	 *
	 * `backUrl` :string : 用于打开手淘时的 “返回（小把手）” 的点击返回，目前**ios传空字符串，android传config.xml文件中配置的urlScheme(即tbopen+appkey)**
	 *
	 * `degradeUrl` :string : 降级url，如果唤端失败且设置了降级url，则加载该url
	 *
	 * `failModeType` :string : 用于控制没安装手淘或者没检测到手淘的时候的打开页面逻辑
	 *
	 * `pageClose` :boolean : (可选项) 购买商品支付成功后是否关闭淘宝页面。true:关闭,false:不关闭。**仅在Android H5页面生效**
	 *
	 * `trackParams` :JSON : (可选项)自定义参数（暂时没发现啥用，但百川有就保留了）
	 */
	showMyCarts(params:aliBC_showMyCarts_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `打开淘宝店铺页面`
	 * ========params==========
	 *
	 * `shopId` :string : 店铺id,支持明文id
	 *
	 * `openType` :string : (可选项)打开页面的方式:拉起手淘/天猫 和 h5打开页面,默认值:h5
	 *
	 * `linkKey` :string : (可选项)当打开页面的方式（openType）为native时,设置拉起手淘or天猫。（不传则走百川默认设置,建议传值）
	 *
	 * `pid` :string : 淘客pid,获取流程参考:[http://baichuan.taobao.com/portal/doc?articleId=220](http://baichuan.taobao.com/portal/doc?articleId=220)
	 *
	 * `adzoneId` :string : (可选项)淘宝联盟adzoneId。**高佣转链/跨店结算 功能所需**, 如果走adzoneId的方式分佣打点，需要在extraParams中显式传入taokeAppkey，否则打点失败。[功能介绍](http://baichuan.taobao.com/support/announcementDetail.htm?spm=0.0.0.0.VkfdrC&id=25274)
	 *
	 * `extraParams` :JSON : 需要在extraParams中显式传入sellerId，否则同步打点转链失败，
	 *
	 * `backUrl` :string : 用于打开手淘时的 “返回（小把手）” 的点击返回，目前**ios传空字符串，android传config.xml文件中配置的urlScheme(即tbopen+appkey)**
	 *
	 * `degradeUrl` :string : 降级url，如果唤端失败且设置了降级url，则加载该url
	 *
	 * `failModeType` :string : 用于控制没安装手淘或者没检测到手淘的时候的打开页面逻辑
	 *
	 * `pageClose` :boolean : (可选项) 购买商品支付成功后是否关闭淘宝页面。true:关闭,false:不关闭。**仅在Android H5页面生效**
	 *
	 * `trackParams` :JSON : (可选项)自定义参数（暂时没发现啥用，但百川有就保留了）
	 */
	showShopPage(params:aliBC_showShopPage_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `打开url展示页面。(**注意 打开淘系地址会跳转手淘，具体页面打开逻辑需要自己多测试！！！**)`
	 * ========params==========
	 *
	 * `url` :string : url
	 *
	 * `openType` :string : (可选项)打开页面的方式:拉起手淘/天猫 和 h5打开页面,默认值:h5
	 *
	 * `linkKey` :string : (可选项)当打开页面的方式（openType）为native时,设置拉起手淘or天猫。（不传则走百川默认设置,建议传值）
	 *
	 * `pid` :string : 淘客pid,获取流程参考:[http://baichuan.taobao.com/portal/doc?articleId=220](http://baichuan.taobao.com/portal/doc?articleId=220)
	 *
	 * `adzoneId` :string : (可选项)淘宝联盟adzoneId。**高佣转链/跨店结算 功能所需**, 如果走adzoneId的方式分佣打点，需要在extraParams中显式传入taokeAppkey，否则打点失败。[功能介绍](http://baichuan.taobao.com/support/announcementDetail.htm?spm=0.0.0.0.VkfdrC&id=25274)
	 *
	 * `extraParams` :JSON : (可选项)adzoneId参数不为空时需要此参数，
	 *
	 * `backUrl` :string : 用于打开手淘时的 “返回（小把手）” 的点击返回，目前**ios传空字符串，android传config.xml文件中配置的urlScheme(即tbopen+appkey)**
	 *
	 * `degradeUrl` :string : 降级url，如果唤端失败且设置了降级url，则加载该url
	 *
	 * `failModeType` :string : 用于控制没安装手淘或者没检测到手淘的时候的打开页面逻辑
	 *
	 * `pageClose` :boolean : (可选项) 购买商品支付成功后是否关闭淘宝页面。true:关闭,false:不关闭。**仅在Android H5页面生效**
	 *
	 * `trackParams` :JSON : (可选项)自定义参数（暂时没发现啥用，但百川有就保留了）
	 */
	showPageByUrl(params:aliBC_showPageByUrl_Params, callback?: (ret:JSON, err:JSON) => void):void

	/**
	 * `使用外部webview方式,打开url展示页面。(**注意 打开淘系地址会跳转手淘，具体页面打开逻辑需要自己多测试！！！**)`
	 * ========params==========
	 *
	 * `url` :string : url
	 *
	 * `hookUrl` :string : 要拦截的url （当页面中跳转的链接包含hookUrl字段时 进行拦截,如:ios下传"tbopen://"可以阻止目前的二合一页面跳转手淘）
	 *
	 * `rect` :JSON : （可选项）frame 的位置和大小。
	 *
	 * `fixedOn` :string : （可选项）模块视图添加到指定 frame 的名字（只指 frame,传 window 无效）
	 *
	 * `fixed` :boolean : 是否将模块视图固定到窗口上,不跟随窗口上下滚动,可为空
	 *
	 * `jsObjectName` :string : (可选项) 注入到h5页面的全局window属性对象名称,可与addJsToPage配合使用。
	 *
	 * `openType` :string : (可选项)打开页面的方式:拉起手淘/天猫 和 h5打开页面,默认值:h5
	 *
	 * `linkKey` :string : (可选项)当打开页面的方式（openType）为native时,设置拉起手淘or天猫。（不传则走百川默认设置,建议传值）
	 *
	 * `pid` :string : 淘客pid,获取流程参考:[http://baichuan.taobao.com/portal/doc?articleId=220](http://baichuan.taobao.com/portal/doc?articleId=220)
	 *
	 * `adzoneId` :string : (可选项)淘宝联盟adzoneId。**高佣转链/跨店结算 功能所需**, 如果走adzoneId的方式分佣打点，需要在extraParams中显式传入taokeAppkey，否则打点失败。[功能介绍](http://baichuan.taobao.com/support/announcementDetail.htm?spm=0.0.0.0.VkfdrC&id=25274)
	 *
	 * `extraParams` :JSON : (可选项)adzoneId参数不为空时需要此参数，
	 *
	 * `backUrl` :string : 用于打开手淘时的 “返回（小把手）” 的点击返回，目前**ios传空字符串，android传config.xml文件中配置的urlScheme(即tbopen+appkey)**
	 *
	 * `degradeUrl` :string : 降级url，如果唤端失败且设置了降级url，则加载该url
	 *
	 * `failModeType` :string : 用于控制没安装手淘或者没检测到手淘的时候的打开页面逻辑
	 */
	showPageByUrlWeb(params:aliBC_showPageByUrlWeb_Params, callback?: (ret:JSON, err:JSON) => void):void

	/** 监听页面加载完成后返回页面的title和url。*/ 
	addPageFinListener(callback?: (ret:JSON) => void):void

	/** 对页面shouldStartLoadWithRequest时进行监听,返回页面的title和跳转的url。*/ 
	addLoadingListener(callback?: (ret:JSON) => void):void

	/**
	 * `在当前打开的淘宝页面加载完成后注入一段js脚本到H5页面。`
	 * ========params==========
	 *
	 * `javaScript` :string : javaScript脚本
	 *
	 * `appointUrl` :string : (可选项)指定Js脚本注入到的页面
	 *
	 * `delay` :any : (可选项)延时执行js脚本的时间,单位为 s（秒）
	 *
	 * `once` :boolean : (可选项)回调成功一次后是否清除对Javascript函数的引用,便于内存回收。通常为false。
	 */
	addJsToPage(params:aliBC_addJsToPage_Params, callback?: (ret:JSON) => void):void

	/**
	 * `移除页面加载完成的监听和js脚本`
	 * ========params==========
	 *
	 * `name` :string : (可选项) 移除的类型,javaScript脚本/PageFinListener/loadingListener。
	 */
	removeJsListener(params:aliBC_removeJsListener_Params):void

	/** 控制当前外部的webview回退*/ 
	webGoBack():void

	/** 从视图中移除当前通过showxxxWeb打开的百川页面。*/ 
	removeWeb():void

	/**
	 * `设置要拦截的url。(**当使用外部webview方式打开百川页面时 有效**)`
	 * ========params==========
	 *
	 * `hookUrl` :string : 要拦截的url （当页面跳转的链接包含hookUrl字段时 进行拦截,**若 不传/为空 则清除已有拦截**）
	 */
	setHookUrl(params:aliBC_setHookUrl_Params, callback?: (ret:JSON) => void):void

	/**
	 * `获取配置文件config.xml中的feature配置参数（**同步返回**）`
	 * ========params==========
	 *
	 * `featureName` :string : feature的name字段
	 *
	 * `paramName` :string : 对应param的name字段
	 */
	getFeature(params:aliBC_getFeature_Params):void

}
interface aliBC_setSyncForTaoke_Params {
	/**（可选项）设置是否使用同步淘客打点。true:使用淘客同步打点；false:关闭同步打点,使用异步打点。*/ 
	isSyncForTaoke?:boolean,

}

interface aliBC_setIsvCode_Params {
	/**null*/ 
	code:string,

	/**返回值  **仅Android有返回***/ 
	ret:JSON,

}

interface aliBC_setIsvVersion_Params {
	/**null*/ 
	version:string,

}

interface aliBC_setIsvAppName_Params {
	/**null*/ 
	name:string,

}

interface aliBC_setTaokeParams_Params {
	/**淘客pid,获取流程参考:[http://baichuan.taobao.com/portal/doc?articleId=220](http://baichuan.taobao.com/portal/doc?articleId=220)*/ 
	pid:string,

	/**(可选项)淘宝联盟adzoneId。**高佣转链/跨店结算 功能所需**, 如果走adzoneId的方式分佣打点，需要在extraParams中显式传入taokeAppkey，否则打点失败。[功能介绍](http://baichuan.taobao.com/support/announcementDetail.htm?spm=0.0.0.0.VkfdrC&id=25274)*/ 
	adzoneId?:string,

	/**(可选项)adzoneId参数不为空时需要此参数，*/ 
	extraParams?:JSON,

}

interface aliBC_setChannel_Params {
	/**（可选项）设置渠道类型*/ 
	typeName?:string,

	/**（可选项）设置渠道名称*/ 
	channelName?:string,

}

interface aliBC_showDetailPage_Params {
	/**商品id。支持itemId和openItemId的商品（如:37196464781L,AAHd5d-HAAeGwJedwSnHktBI）,必填,不允许为null*/ 
	itemId:string,

	/**(可选项)打开页面的方式*/ 
	openType?:string,

	/**(可选项)当打开页面的方式（openType）为native时,设置拉起手淘or天猫。（不传则走百川默认设置,建议传值）*/ 
	linkKey?:string,

	/**淘客pid,获取流程参考:[http://baichuan.taobao.com/portal/doc?articleId=220](http://baichuan.taobao.com/portal/doc?articleId=220)*/ 
	pid:string,

	/**(可选项)淘宝联盟adzoneId。**高佣转链/跨店结算 功能所需**, 如果走adzoneId的方式分佣打点，需要在extraParams中显式传入taokeAppkey，否则打点失败。[功能介绍](http://baichuan.taobao.com/support/announcementDetail.htm?spm=0.0.0.0.VkfdrC&id=25274)*/ 
	adzoneId?:string,

	/**(可选项)adzoneId参数不为空时需要此参数，*/ 
	extraParams?:JSON,

	/**用于打开手淘时的 “返回（小把手）” 的点击返回，目前**ios传空字符串，android传config.xml文件中配置的urlScheme(即tbopen+appkey)***/ 
	backUrl:string,

	/**降级url，如果唤端失败且设置了降级url，则加载该url*/ 
	degradeUrl:string,

	/**用于控制没安装手淘或者没检测到手淘的时候的打开页面逻辑*/ 
	failModeType:string,

	/**(可选项) 购买商品支付成功后是否关闭淘宝页面。true:关闭,false:不关闭。**仅在Android H5页面生效***/ 
	pageClose?:boolean,

	/**(可选项)自定义参数（暂时没发现啥用，但百川有就保留了）*/ 
	trackParams?:JSON,

}

interface aliBC_showAddCartPage_Params {
	/**打开页面的控制参数*/ 
	code:string,

}

interface aliBC_showMyOrders_Params {
	/**打开页面的控制参数*/ 
	code:string,

	/**默认跳转页面。0:全部；1:待付款；2:待发货；3:待收货；4:待评价*/ 
	orderStatus:any,

	/**false 进行订单分域（只展示通过当前app下单的订单）,true 显示所有订单*/ 
	allOrder:boolean,

}

interface aliBC_showMyCarts_Params {
	/**(可选项)打开页面的方式:拉起手淘/天猫 和 h5打开页面,默认值:h5*/ 
	openType?:string,

	/**(可选项)当打开页面的方式（openType）为native时,设置拉起手淘or天猫。（不传则走百川默认设置,建议传值）*/ 
	linkKey?:string,

	/**淘客pid,获取流程参考:[http://baichuan.taobao.com/portal/doc?articleId=220](http://baichuan.taobao.com/portal/doc?articleId=220)*/ 
	pid:string,

	/**(可选项)淘宝联盟adzoneId。**高佣转链/跨店结算 功能所需**, 如果走adzoneId的方式分佣打点，需要在extraParams中显式传入taokeAppkey，否则打点失败。[功能介绍](http://baichuan.taobao.com/support/announcementDetail.htm?spm=0.0.0.0.VkfdrC&id=25274)*/ 
	adzoneId?:string,

	/**(可选项)adzoneId参数不为空时需要此参数，*/ 
	extraParams?:JSON,

	/**用于打开手淘时的 “返回（小把手）” 的点击返回，目前**ios传空字符串，android传config.xml文件中配置的urlScheme(即tbopen+appkey)***/ 
	backUrl:string,

	/**降级url，如果唤端失败且设置了降级url，则加载该url*/ 
	degradeUrl:string,

	/**用于控制没安装手淘或者没检测到手淘的时候的打开页面逻辑*/ 
	failModeType:string,

	/**(可选项) 购买商品支付成功后是否关闭淘宝页面。true:关闭,false:不关闭。**仅在Android H5页面生效***/ 
	pageClose?:boolean,

	/**(可选项)自定义参数（暂时没发现啥用，但百川有就保留了）*/ 
	trackParams?:JSON,

}

interface aliBC_showShopPage_Params {
	/**店铺id,支持明文id*/ 
	shopId:string,

	/**(可选项)打开页面的方式:拉起手淘/天猫 和 h5打开页面,默认值:h5*/ 
	openType?:string,

	/**(可选项)当打开页面的方式（openType）为native时,设置拉起手淘or天猫。（不传则走百川默认设置,建议传值）*/ 
	linkKey?:string,

	/**淘客pid,获取流程参考:[http://baichuan.taobao.com/portal/doc?articleId=220](http://baichuan.taobao.com/portal/doc?articleId=220)*/ 
	pid:string,

	/**(可选项)淘宝联盟adzoneId。**高佣转链/跨店结算 功能所需**, 如果走adzoneId的方式分佣打点，需要在extraParams中显式传入taokeAppkey，否则打点失败。[功能介绍](http://baichuan.taobao.com/support/announcementDetail.htm?spm=0.0.0.0.VkfdrC&id=25274)*/ 
	adzoneId?:string,

	/**需要在extraParams中显式传入sellerId，否则同步打点转链失败，*/ 
	extraParams:JSON,

	/**用于打开手淘时的 “返回（小把手）” 的点击返回，目前**ios传空字符串，android传config.xml文件中配置的urlScheme(即tbopen+appkey)***/ 
	backUrl:string,

	/**降级url，如果唤端失败且设置了降级url，则加载该url*/ 
	degradeUrl:string,

	/**用于控制没安装手淘或者没检测到手淘的时候的打开页面逻辑*/ 
	failModeType:string,

	/**(可选项) 购买商品支付成功后是否关闭淘宝页面。true:关闭,false:不关闭。**仅在Android H5页面生效***/ 
	pageClose?:boolean,

	/**(可选项)自定义参数（暂时没发现啥用，但百川有就保留了）*/ 
	trackParams?:JSON,

}

interface aliBC_showPageByUrl_Params {
	/**url*/ 
	url:string,

	/**(可选项)打开页面的方式:拉起手淘/天猫 和 h5打开页面,默认值:h5*/ 
	openType?:string,

	/**(可选项)当打开页面的方式（openType）为native时,设置拉起手淘or天猫。（不传则走百川默认设置,建议传值）*/ 
	linkKey?:string,

	/**淘客pid,获取流程参考:[http://baichuan.taobao.com/portal/doc?articleId=220](http://baichuan.taobao.com/portal/doc?articleId=220)*/ 
	pid:string,

	/**(可选项)淘宝联盟adzoneId。**高佣转链/跨店结算 功能所需**, 如果走adzoneId的方式分佣打点，需要在extraParams中显式传入taokeAppkey，否则打点失败。[功能介绍](http://baichuan.taobao.com/support/announcementDetail.htm?spm=0.0.0.0.VkfdrC&id=25274)*/ 
	adzoneId?:string,

	/**(可选项)adzoneId参数不为空时需要此参数，*/ 
	extraParams?:JSON,

	/**用于打开手淘时的 “返回（小把手）” 的点击返回，目前**ios传空字符串，android传config.xml文件中配置的urlScheme(即tbopen+appkey)***/ 
	backUrl:string,

	/**降级url，如果唤端失败且设置了降级url，则加载该url*/ 
	degradeUrl:string,

	/**用于控制没安装手淘或者没检测到手淘的时候的打开页面逻辑*/ 
	failModeType:string,

	/**(可选项) 购买商品支付成功后是否关闭淘宝页面。true:关闭,false:不关闭。**仅在Android H5页面生效***/ 
	pageClose?:boolean,

	/**(可选项)自定义参数（暂时没发现啥用，但百川有就保留了）*/ 
	trackParams?:JSON,

}

interface aliBC_showPageByUrlWeb_Params {
	/**url*/ 
	url:string,

	/**要拦截的url （当页面中跳转的链接包含hookUrl字段时 进行拦截,如:ios下传"tbopen://"可以阻止目前的二合一页面跳转手淘）*/ 
	hookUrl:string,

	/**（可选项）frame 的位置和大小。*/ 
	rect?:JSON,

	/**（可选项）模块视图添加到指定 frame 的名字（只指 frame,传 w