/// <reference path="./modules.d.ts"/>

declare namespace api {
	/**应用的 ID，可以在网站控制台概览里面查看，字符串类型*/ 
	const appId:string; 

	/**应用在桌面显示名称，字符串类型*/ 
	const appName:string; 

	/**应用版本号，字符串类型*/ 
	const appVersion:string; 

	/**系统类型，字符串类型*/ 
	const systemType:string; 

	/**手机平台的系统版本，字符串类型*/ 
	const systemVersion:string; 

	/**引擎版本信息，字符串类型*/ 
	const version:string; 

	/**当前系统语言，字符串类型*/ 
	const language:string; 

	/**设备唯一标识，字符串类型*/ 
	const deviceId:string; 

	/**iOS中用于推送的DeviceToken，如果未添加相关推送模块，或者云编译的mobileprovision证书未开启推送功能，则可能会返回空字符串，字符串类型*/ 
	const deviceToken:string; 

	/**设备型号，字符串类型*/ 
	const deviceModel:string; 

	/**设备名称，字符串类型*/ 
	const deviceName:string; 

	/**设备类型，字符串类型*/ 
	const uiMode:string; 

	/**当前运行平台，字符串类型*/ 
	const platform:string; 

	/**运营商名称，若未获取到则返回none，字符串类型*/ 
	const operator:string; 

	/**当前网络连接类型，如 2g、3g、4g、wifi 等，字符串类型*/ 
	const connectionType:string; 

	/**应用是否全屏，布尔类型，只支持iOS*/ 
	const fullScreen:boolean; 

	/**屏幕分辨率宽，数字类型*/ 
	const screenWidth:number; 

	/**屏幕分辨率高，数字类型*/ 
	const screenHeight:number; 

	/**当前 window 名称，字符串类型*/ 
	const winName:string; 

	/**当前 window 宽度，数字类型*/ 
	const winWidth:number; 

	/**当前 window 高度，数字类型*/ 
	const winHeight:number; 

	/**frame 名称，字符串类型*/ 
	const frameName:string; 

	/**frame 宽度，数字类型*/ 
	const frameWidth:number; 

	/**frame 高度，数字类型*/ 
	const frameHeight:number; 

	/**页面不被其它内容（如状态栏）遮住的区域，JSON对象*/ 
	const safeArea:JSON; 

	/**页面参数，JSON 对象类型*/ 
	const pageParam:JSON; 

	/**widget 参数，JSON 对象类型*/ 
	const wgtParam:JSON; 

	/**当应用被第三方应用打开时，传递过来的参数，字符串类型*/ 
	const appParam:string; 

	/**当前应用状态栏是否支持沉浸式效果，布尔类型*/ 
	const statusBarAppearance:boolean; 

	/**widget:		//协议对应的真实目录，即 widget 网页包的根目录，字符串类型*/ 
	const wgtRootDir:string; 

	/**fs:	//协议对应地真实目录，字符串类型*/ 
	const fsDir:string; 

	/**cache://协议对应的真实目录，字符串类型*/ 
	const cacheDir:string; 

	/**box://协议对应的真实目录，字符串类型*/ 
	const boxDir:string; 

	/**获取config.xml配置的debug字段的值。*/ 
	const debug:any; 

	/**渠道号，字符串类型*/ 
	const channel:string; 

	/**设备是否越狱，布尔类型*/ 
	const jailbreak:boolean; 

	/**使用WKWebView加载页面时，若配置了WKWebView渲染进程崩溃后刷新当前页面，则刷新后该属性值为true。只支持iOS，布尔类型*/ 
	const isRecoveryMode:boolean; 

	interface api_openWin_Params {
		/**window名字*/ 
		name: string;

		/**页面地址，可以为本地文件路径，支持相对路径和绝对路径，以及 widget://、fs://等协议路径，也可以为远程地址。 当data参数不为空时，url将做为baseUrl，data中的html引用的资源文件根路径以该url为基础。*/ 
		url: string;

		/**（可选项）页面加载的数据内容，可以为html片段或者整张html文件的数据*/ 
		data: string;

		/**（可选项）请求头*/ 
		headers: JSON;

		/**（可选项）设置该window是否为单例对象。若设置为单例对象，当调用closeWin方法关闭时，window将只是从屏幕移除而不会被销毁，下次再打开时将直接使用已存在的window，而不会再重新创建。*/ 
		singleInstance: boolean;

		/**（可选项）是否使用原生引擎来加载页面，页面必须是使用avm框架语法生成。*/ 
		avm: boolean;

		/**（可选项）是否使用WKWebView来加载页面。参考[WKWebView介绍](https://community.apicloud.com/bbs/thread-151904-1-1.html)。*/ 
		useWKWebView: boolean;

		/**（可选项）设置是否可以在本地页面中访问本地或远程资源，为保证代码安全，在开启全局加密情况下默认禁止访问。只在useWKWebView参数为true时有效。*/ 
		allowAccessFromFile: boolean;

		/**（可选项）是否可以通过手势来进行历史记录前进后退，只在useWKWebView参数为true时有效。*/ 
		historyGestureEnabled: boolean;

		/**（可选项）是否自动同步WKWebView外部如ajax产生的Cookie到WKWebView中，只在useWKWebView参数为true时有效。*/ 
		syncCookie: boolean;

		/**（可选项）页面参数，新页面中可以通过 api.pageParam 获取*/ 
		pageParam: JSON;

		/**（可选项）页面是否弹动。注意如果页面使用了上拉、下拉刷新等功能，该属性可能会被刷新组件重新设置。*/ 
		bounces: boolean;

		/**（可选项）背景色，支持图片和颜色，格式为 #fff、#ffffff、rgba(r,g,b,a)等，图片路径支持 fs://、widget://等 APICloud 自定义文件路径协议，同时支持相对路径*/ 
		bgColor: string;

		/**（可选项）当点击状态栏，页面是否滚动到顶部。若当前屏幕上不止一个页面的 scrollToTop 属性为 true，则所有的都不会起作用。只 iOS 有效*/ 
		scrollToTop: boolean;

		/**（可选项）页面内容超出后是否可以滚动，只支持iOS*/ 
		scrollEnabled: boolean;

		/**（可选项）是否显示垂直滚动条*/ 
		vScrollBarEnabled: boolean;

		/**（可选项）是否显示水平滚动条*/ 
		hScrollBarEnabled: boolean;

		/**（可选项）页面是否可以缩放*/ 
		scaleEnabled: boolean;

		/**（可选项）是否隐藏原生navigationBar控件，该字段只 iOS 有效*/ 
		hideTopBar: boolean;

		/**（可选项）是否隐藏原生tabBar控件，该字段只 iOS 有效*/ 
		hideBottomBar: boolean;

		/**（可选项）是否支持滑动返回。iOS7.0及以上系统中，在新打开的页面中向右滑动，可以返回到上一个页面，该字段只 iOS 有效*/ 
		slidBackEnabled: boolean;

		/**（可选项）当支持滑动返回时，设置手指在页面右滑的有效作用区域。取值范围（full:整个页面范围都可以右滑返回，edge:在页面左边缘右滑才可以返回），该字段只iOS有效*/ 
		slidBackType: string;

		/**（可选项）动画参数，不传时使用默认动画*/ 
		animation: JSON;

		/**（可选项）页面加载进度配置信息，若不传则无加载进度效果*/ 
		progress: JSON;

		/**（可选项）window 显示延迟时间，适用于将被打开的 window 中可能需要打开有耗时操作的模块时，可延迟 window 展示到屏幕的时间，保持 UI 的整体性*/ 
		delay: number;

		/**（可选项）页面已经打开时，是否重新加载页面，重新加载页面后 apiready 方法将会被执行*/ 
		reload: boolean;

		/**（可选项）是否允许长按页面时弹出选择菜单*/ 
		allowEdit: boolean;

		/**（可选项）当键盘弹出时，输入框被盖住时，当前页面的调整方式，只iOS有效，Android请在 [config.xml](/APICloud/技术专题/app-config-manual) 里面配置并云编译使用*/ 
		softInputMode: string;

		/**（可选项）收起键盘的方式，只iOS有效。*/ 
		softInputDismissMode: Array;

		/**（可选项）是否显示键盘上方的工具条。只支持iOS*/ 
		softInputBarEnabled: boolean;

		/**（可选项）设置页面滚动到头部或尾部时，显示回弹阴影效果的模式，仅Android有效。*/ 
		overScrollMode: string;

		/**（可选项）是否允许iOS 11及以上系统中页面元素默认的拖拽行为。只支持iOS*/ 
		dragAndDrop: boolean;

		/**（可选项）是否隐藏虚拟home键。设置为true时，虚拟home键会在屏幕没有触摸操作时自动隐藏，触摸后又会显示出来。只支持iOS*/ 
		hideHomeIndicator: boolean;

		/**（可选项）设置使用默认下拉刷新类型，取值范围：pull、swipe*/ 
		defaultRefreshHeader: string;

		/**（可选项）设置使用自定义下拉刷新模块的名称，设置后可以使用 api.setCustomRefreshHeaderInfo 方法来使用自定义下拉刷新组件*/ 
		customRefreshHeader: string;

	}
	/**
	 * `打开window`
	 * ========params==========
	 *
	 * `name` :string : window名字
	 *
	 * `url` :string : 页面地址，可以为本地文件路径，支持相对路径和绝对路径，以及 widget://、fs://等协议路径，也可以为远程地址。 当data参数不为空时，url将做为baseUrl，data中的html引用的资源文件根路径以该url为基础。
	 *
	 * `data` :string : （可选项）页面加载的数据内容，可以为html片段或者整张html文件的数据
	 *
	 * `headers` :JSON : （可选项）请求头
	 *
	 * `singleInstance` :boolean : （可选项）设置该window是否为单例对象。若设置为单例对象，当调用closeWin方法关闭时，window将只是从屏幕移除而不会被销毁，下次再打开时将直接使用已存在的window，而不会再重新创建。
	 *
	 * `avm` :boolean : （可选项）是否使用原生引擎来加载页面，页面必须是使用avm框架语法生成。
	 *
	 * `useWKWebView` :boolean : （可选项）是否使用WKWebView来加载页面。参考[WKWebView介绍](https://community.apicloud.com/bbs/thread-151904-1-1.html)。
	 *
	 * `allowAccessFromFile` :boolean : （可选项）设置是否可以在本地页面中访问本地或远程资源，为保证代码安全，在开启全局加密情况下默认禁止访问。只在useWKWebView参数为true时有效。
	 *
	 * `historyGestureEnabled` :boolean : （可选项）是否可以通过手势来进行历史记录前进后退，只在useWKWebView参数为true时有效。
	 *
	 * `syncCookie` :boolean : （可选项）是否自动同步WKWebView外部如ajax产生的Cookie到WKWebView中，只在useWKWebView参数为true时有效。
	 *
	 * `pageParam` :JSON : （可选项）页面参数，新页面中可以通过 api.pageParam 获取
	 *
	 * `bounces` :boolean : （可选项）页面是否弹动。注意如果页面使用了上拉、下拉刷新等功能，该属性可能会被刷新组件重新设置。
	 *
	 * `bgColor` :string : （可选项）背景色，支持图片和颜色，格式为 #fff、#ffffff、rgba(r,g,b,a)等，图片路径支持 fs://、widget://等 APICloud 自定义文件路径协议，同时支持相对路径
	 *
	 * `scrollToTop` :boolean : （可选项）当点击状态栏，页面是否滚动到顶部。若当前屏幕上不止一个页面的 scrollToTop 属性为 true，则所有的都不会起作用。只 iOS 有效
	 *
	 * `scrollEnabled` :boolean : （可选项）页面内容超出后是否可以滚动，只支持iOS
	 *
	 * `vScrollBarEnabled` :boolean : （可选项）是否显示垂直滚动条
	 *
	 * `hScrollBarEnabled` :boolean : （可选项）是否显示水平滚动条
	 *
	 * `scaleEnabled` :boolean : （可选项）页面是否可以缩放
	 *
	 * `hideTopBar` :boolean : （可选项）是否隐藏原生navigationBar控件，该字段只 iOS 有效
	 *
	 * `hideBottomBar` :boolean : （可选项）是否隐藏原生tabBar控件，该字段只 iOS 有效
	 *
	 * `slidBackEnabled` :boolean : （可选项）是否支持滑动返回。iOS7.0及以上系统中，在新打开的页面中向右滑动，可以返回到上一个页面，该字段只 iOS 有效
	 *
	 * `slidBackType` :string : （可选项）当支持滑动返回时，设置手指在页面右滑的有效作用区域。取值范围（full:整个页面范围都可以右滑返回，edge:在页面左边缘右滑才可以返回），该字段只iOS有效
	 *
	 * `animation` :JSON : （可选项）动画参数，不传时使用默认动画
	 *
	 * `progress` :JSON : （可选项）页面加载进度配置信息，若不传则无加载进度效果
	 *
	 * `delay` :number : （可选项）window 显示延迟时间，适用于将被打开的 window 中可能需要打开有耗时操作的模块时，可延迟 window 展示到屏幕的时间，保持 UI 的整体性
	 *
	 * `reload` :boolean : （可选项）页面已经打开时，是否重新加载页面，重新加载页面后 apiready 方法将会被执行
	 *
	 * `allowEdit` :boolean : （可选项）是否允许长按页面时弹出选择菜单
	 *
	 * `softInputMode` :string : （可选项）当键盘弹出时，输入框被盖住时，当前页面的调整方式，只iOS有效，Android请在 [config.xml](/APICloud/技术专题/app-config-manual) 里面配置并云编译使用
	 *
	 * `softInputDismissMode` :Array : （可选项）收起键盘的方式，只iOS有效。
	 *
	 * `softInputBarEnabled` :boolean : （可选项）是否显示键盘上方的工具条。只支持iOS
	 *
	 * `overScrollMode` :string : （可选项）设置页面滚动到头部或尾部时，显示回弹阴影效果的模式，仅Android有效。
	 *
	 * `dragAndDrop` :boolean : （可选项）是否允许iOS 11及以上系统中页面元素默认的拖拽行为。只支持iOS
	 *
	 * `hideHomeIndicator` :boolean : （可选项）是否隐藏虚拟home键。设置为true时，虚拟home键会在屏幕没有触摸操作时自动隐藏，触摸后又会显示出来。只支持iOS
	 *
	 * `defaultRefreshHeader` :string : （可选项）设置使用默认下拉刷新类型，取值范围：pull、swipe
	 *
	 * `customRefreshHeader` :string : （可选项）设置使用自定义下拉刷新模块的名称，设置后可以使用 api.setCustomRefreshHeaderInfo 方法来使用自定义下拉刷新组件
	 */
	function openWin(option: api_openWin_Params):void;

	interface api_closeWin_Params {
		/**（可选项）window 名字，不传时关闭当前 window，为 root 时无效*/ 
		name: string;

		/**（可选项）动画参数，不传时使用默认动画*/ 
		animation: JSON;

	}
	/**
	 * `关闭 window`
	 * ========params==========
	 *
	 * `name` :string : （可选项）window 名字，不传时关闭当前 window，为 root 时无效
	 *
	 * `animation` :JSON : （可选项）动画参数，不传时使用默认动画
	 */
	function closeWin(option: api_closeWin_Params):void;

	interface api_closeToWin_Params {
		/**window 名字*/ 
		name: string;

		/**（可选项）动画参数，不传时使用默认动画*/ 
		animation: JSON;

	}
	/**
	 * `关闭到指定 window，最上面显示的 window 到指定 name 的 window 间的所有 window 都会被关闭。`
	 * ========params==========
	 *
	 * `name` :string : window 名字
	 *
	 * `animation` :JSON : （可选项）动画参数，不传时使用默认动画
	 */
	function closeToWin(option: api_closeToWin_Params):void;

	interface api_windows_ret {
		/** window名字，字符串类型*/ 
		name: string;

		/** window中的子window，如drawerLayout中的leftPane和rightPane，JSON对象数组类型*/ 
		children: Array<JSON>;

	}
	function windows():Array<api_windows_ret>

	interface api_setWinAttr_Params {
		/**（可选项）页面是否弹动*/ 
		bounces: boolean;

		/**（可选项）背景色，支持图片和颜色，格式为#fff、#ffffff、rgba(r,g,b,a)等，图片路径支持fs://、widget://等APICloud自定义文件路径协议，同时支持相对路径*/ 
		bgColor: string;

		/**（可选项）当点击状态栏，页面是否滚动到顶部。若当前屏幕上不止一个页面的scrollToTop属性为true，则所有的都不会起作用。只iOS有效*/ 
		scrollToTop: boolean;

		/**（可选项）页面内容超出后是否可以滚动，只支持iOS*/ 
		scrollEnabled: boolean;

		/**（可选项）是否显示垂直滚动条*/ 
		vScrollBarEnabled: boolean;

		/**（可选项）是否显示水平滚动条*/ 
		hScrollBarEnabled: boolean;

		/**（可选项）页面是否可以缩放*/ 
		scaleEnabled: boolean;

		/**（可选项）是否支持滑动返回。iOS7.0及以上系统中，在新打开的页面中向右滑动，可以返回到上一个页面，该字段只iOS有效*/ 
		slidBackEnabled: boolean;

		/**（可选项）是否隐藏虚拟home键。设置为true时，虚拟home键会在屏幕没有触摸操作时自动隐藏，触摸后又会显示出来。只支持iOS*/ 
		hideHomeIndicator: boolean;

		/**（可选项）是否允许长按页面时弹出选择菜单*/ 
		allowEdit: boolean;

		/**（可选项）当键盘弹出时，输入框被盖住时，当前页面的调整方式；只iOS有效，Android请在 [config.xml](/APICloud/技术专题/app-config-manual) 里面配置并云编译使用*/ 
		softInputMode: string;

	}
	/**
	 * `设置 window 属性`
	 * ========params==========
	 *
	 * `bounces` :boolean : （可选项）页面是否弹动
	 *
	 * `bgColor` :string : （可选项）背景色，支持图片和颜色，格式为#fff、#ffffff、rgba(r,g,b,a)等，图片路径支持fs://、widget://等APICloud自定义文件路径协议，同时支持相对路径
	 *
	 * `scrollToTop` :boolean : （可选项）当点击状态栏，页面是否滚动到顶部。若当前屏幕上不止一个页面的scrollToTop属性为true，则所有的都不会起作用。只iOS有效
	 *
	 * `scrollEnabled` :boolean : （可选项）页面内容超出后是否可以滚动，只支持iOS
	 *
	 * `vScrollBarEnabled` :boolean : （可选项）是否显示垂直滚动条
	 *
	 * `hScrollBarEnabled` :boolean : （可选项）是否显示水平滚动条
	 *
	 * `scaleEnabled` :boolean : （可选项）页面是否可以缩放
	 *
	 * `slidBackEnabled` :boolean : （可选项）是否支持滑动返回。iOS7.0及以上系统中，在新打开的页面中向右滑动，可以返回到上一个页面，该字段只iOS有效
	 *
	 * `hideHomeIndicator` :boolean : （可选项）是否隐藏虚拟home键。设置为true时，虚拟home键会在屏幕没有触摸操作时自动隐藏，触摸后又会显示出来。只支持iOS
	 *
	 * `allowEdit` :boolean : （可选项）是否允许长按页面时弹出选择菜单
	 *
	 * `softInputMode` :string : （可选项）当键盘弹出时，输入框被盖住时，当前页面的调整方式；只iOS有效，Android请在 [config.xml](/APICloud/技术专题/app-config-manual) 里面配置并云编译使用
	 */
	function setWinAttr(option: api_setWinAttr_Params):void;

	interface api_openFrame_Params {
		/**frame 名字*/ 
		name: string;

		/**页面地址，可以为本地文件路径，支持相对路径和绝对路径，以及 widget://、fs://等协议路径，也可以为远程地址。 当data参数不为空时，url将做为baseUrl，data中的html引用的资源文件根路径以该url为基础。*/ 
		url: string;

		/**（可选项）页面加载的数据内容，可以为html片段或者整张html文件的数据*/ 
		data: string;

		/**（可选项）请求头*/ 
		headers: JSON;

		/**（可选项）是否使用原生引擎来加载页面，页面必须是使用avm框架语法生成。*/ 
		avm: boolean;

		/**（可选项）是否使用WKWebView来加载页面。参考[WKWebView介绍](https://community.apicloud.com/bbs/thread-151904-1-1.html)。*/ 
		useWKWebView: boolean;

		/**（可选项）设置是否可以在本地页面中访问本地或远程资源，为保证代码安全，在开启全局加密情况下默认禁止访问。只在useWKWebView参数为true时有效。*/ 
		allowAccessFromFile: boolean;

		/**（可选项）是否可以通过手势来进行历史记录前进后退，只在useWKWebView参数为true时有效。*/ 
		historyGestureEnabled: boolean;

		/**（可选项）是否自动同步WKWebView外部如ajax产生的Cookie到WKWebView中，只在useWKWebView参数为true时有效。*/ 
		syncCookie: boolean;

		/**（可选项）页面参数，在新页面通过 api.pageParam 获取*/ 
		pageParam: JSON;

		/**（可选项）页面是否弹动。注意如果页面使用了上拉、下拉刷新等功能，该属性可能会被刷新组件重新设置。*/ 
		bounces: boolean;

		/**（可选项）背景色，支持图片和颜色，格式为#fff、#ffffff、rgba(r,g,b,a)等，图片路径支持fs://、widget://等 APICloud 自定义文件路径协议，同时支持相对路径*/ 
		bgColor: string;

		/**（可选项）当点击状态栏，页面是否滚动到顶部。若当前屏幕上不止一个页面的 scrollToTop 属性为 true，则所有的都不会起作用。只iOS有效*/ 
		scrollToTop: boolean;

		/**（可选项）页面内容超出后是否可以滚动，只支持iOS*/ 
		scrollEnabled: boolean;

		/**（可选项）是否显示垂直滚动条*/ 
		vScrollBarEnabled: boolean;

		/**（可选项）是否显示水平滚动条*/ 
		hScrollBarEnabled: boolean;

		/**（可选项）页面是否可以缩放*/ 
		scaleEnabled: boolean;

		/**（可选项）frame 所要添加到的目标页面。*/ 
		fixedOn: string;

		/**（可选项）设置页面的位置和大小。如果要固定宽高则使用 x、y、w、h 等参数；如果要自适应状态栏高度变化、横竖屏切换等，则需要使用 margin 相关参数，不能使用 w、h 固定宽高。推荐使用 margin 相关参数来布局。*/ 
		rect: JSON;

		/**（可选项）页面加载进度配置信息，若不传则无加载进度效果*/ 
		progress: JSON;

		/**（可选项）页面已经打开时，是否重新加载页面*/ 
		reload: boolean;

		/**（可选项）是否允许长按页面时弹出选择菜单*/ 
		allowEdit: boolean;

		/**（可选项）当键盘弹出时，输入框被盖住时，当前页面的调整方式,只iOS有效，Android请在 [config.xml](/APICloud/技术专题/app-config-manual) 里面配置并云编译使用*/ 
		softInputMode: string;

		/**（可选项）收起键盘的方式，只iOS有效。*/ 
		softInputDismissMode: Array;

		/**（可选项）是否显示键盘上方的工具条。只支持iOS*/ 
		softInputBarEnabled: boolean;

		/**（可选项）设置页面滚动到头部或尾部时，显示回弹阴影效果的模式，仅Android有效。*/ 
		overScrollMode: string;

		/**（可选项）是否允许iOS 11及以上系统中页面元素默认的拖拽行为。只支持iOS*/ 
		dragAndDrop: boolean;

		/**（可选项）动画参数，不传时无动画*/ 
		animation: JSON;

		/**（可选项）设置使用默认下拉刷新类型，取值范围：pull、swipe*/ 
		defaultRefreshHeader: string;

		/**（可选项）设置使用自定义下拉刷新模块的名称，设置后可以使用 api.setCustomRefreshHeaderInfo 方法来使用自定义下拉刷新组件*/ 
		customRefreshHeader: string;

	}
	/**
	 * `打开 frame`
	 * ========params==========
	 *
	 * `name` :string : frame 名字
	 *
	 * `url` :string : 页面地址，可以为本地文件路径，支持相对路径和绝对路径，以及 widget://、fs://等协议路径，也可以为远程地址。 当data参数不为空时，url将做为baseUrl，data中的html引用的资源文件根路径以该url为基础。
	 *
	 * `data` :string : （可选项）页面加载的数据内容，可以为html片段或者整张html文件的数据
	 *
	 * `headers` :JSON : （可选项）请求头
	 *
	 * `avm` :boolean : （可选项）是否使用原生引擎来加载页面，页面必须是使用avm框架语法生成。
	 *
	 * `useWKWebView` :boolean : （可选项）是否使用WKWebView来加载页面。参考[WKWebView介绍](https://community.apicloud.com/bbs/thread-151904-1-1.html)。
	 *
	 * `allowAccessFromFile` :boolean : （可选项）设置是否可以在本地页面中访问本地或远程资源，为保证代码安全，在开启全局加密情况下默认禁止访问。只在useWKWebView参数为true时有效。
	 *
	 * `historyGestureEnabled` :boolean : （可选项）是否可以通过手势来进行历史记录前进后退，只在useWKWebView参数为true时有效。
	 *
	 * `syncCookie` :boolean : （可选项）是否自动同步WKWebView外部如ajax产生的Cookie到WKWebView中，只在useWKWebView参数为true时有效。
	 *
	 * `pageParam` :JSON : （可选项）页面参数，在新页面通过 api.pageParam 获取
	 *
	 * `bounces` :boolean : （可选项）页面是否弹动。注意如果页面使用了上拉、下拉刷新等功能，该属性可能会被刷新组件重新设置。
	 *
	 * `bgColor` :string : （可选项）背景色，支持图片和颜色，格式为#fff、#ffffff、rgba(r,g,b,a)等，图片路径支持fs://、widget://等 APICloud 自定义文件路径协议，同时支持相对路径
	 *
	 * `scrollToTop` :boolean : （可选项）当点击状态栏，页面是否滚动到顶部。若当前屏幕上不止一个页面的 scrollToTop 属性为 true，则所有的都不会起作用。只iOS有效
	 *
	 * `scrollEnabled` :boolean : （可选项）页面内容超出后是否可以滚动，只支持iOS
	 *
	 * `vScrollBarEnabled` :boolean : （可选项）是否显示垂直滚动条
	 *
	 * `hScrollBarEnabled` :boolean : （可选项）是否显示水平滚动条
	 *
	 * `scaleEnabled` :boolean : （可选项）页面是否可以缩放
	 *
	 * `fixedOn` :string : （可选项）frame 所要添加到的目标页面。
	 *
	 * `rect` :JSON : （可选项）设置页面的位置和大小。如果要固定宽高则使用 x、y、w、h 等参数；如果要自适应状态栏高度变化、横竖屏切换等，则需要使用 margin 相关参数，不能使用 w、h 固定宽高。推荐使用 margin 相关参数来布局。
	 *
	 * `progress` :JSON : （可选项）页面加载进度配置信息，若不传则无加载进度效果
	 *
	 * `reload` :boolean : （可选项）页面已经打开时，是否重新加载页面
	 *
	 * `allowEdit` :boolean : （可选项）是否允许长按页面时弹出选择菜单
	 *
	 * `softInputMode` :string : （可选项）当键盘弹出时，输入框被盖住时，当前页面的调整方式,只iOS有效，Android请在 [config.xml](/APICloud/技术专题/app-config-manual) 里面配置并云编译使用
	 *
	 * `softInputDismissMode` :Array : （可选项）收起键盘的方式，只iOS有效。
	 *
	 * `softInputBarEnabled` :boolean : （可选项）是否显示键盘上方的工具条。只支持iOS
	 *
	 * `overScrollMode` :string : （可选项）设置页面滚动到头部或尾部时，显示回弹阴影效果的模式，仅Android有效。
	 *
	 * `dragAndDrop` :boolean : （可选项）是否允许iOS 11及以上系统中页面元素默认的拖拽行为。只支持iOS
	 *
	 * `animation` :JSON : （可选项）动画参数，不传时无动画
	 *
	 * `defaultRefreshHeader` :string : （可选项）设置使用默认下拉刷新类型，取值范围：pull、swipe
	 *
	 * `customRefreshHeader` :string : （可选项）设置使用自定义下拉刷新模块的名称，设置后可以使用 api.setCustomRefreshHeaderInfo 方法来使用自定义下拉刷新组件
	 */
	function openFrame(option: api_openFrame_Params):void;

	interface api_closeFrame_Params {
		/**（可选项）frame 名字，不传时关闭当前 frame*/ 
		name: string;

	}
	/**
	 * `关闭frame`
	 * ========params==========
	 *
	 * `name` :string : （可选项）frame 名字，不传时关闭当前 frame
	 */
	function closeFrame(option: api_closeFrame_Params):void;

	interface api_frames_ret {
		/** frame名字，字符串类型*/ 
		name: string;

		/** 父窗口的名字，如果是frameGroup中的frame，该值为frameGroup的名字，字符串类型*/ 
		parent: string;

	}
	function frames():Array<api_frames_ret>

	interface api_setFrameAttr_Params {
		/**frame 名称*/ 
		name: string;

		/**（可选项）页面是否弹动*/ 
		bounces: boolean;

		/**（可选项）设置本 frame 是否隐藏，设置显示隐藏并不会改变frame在整个窗口系统之间的层级关系。*/ 
		hidden: boolean;

		/**（可选项）背景色，支持图片和颜色，格式为#fff、#ffffff、rgba(r,g,b,a)等，图片路径支持fs://、widget://等 APICloud 自定义文件路径协议，同时支持相对路径*/ 
		bgColor: string;

		/**（可选项）当点击状态栏，页面是否滚动到顶部。若当前屏幕上不止一个页面的 scrollToTop 属性为 true，则所有的都不会起作用。只iOS有效*/ 
		scrollToTop: boolean;

		/**（可选项）页面内容超出后是否可以滚动，只支持iOS*/ 
		scrollEnabled: boolean;

		/**（可选项）是否显示垂直滚动条*/ 
		vScrollBarEnabled: boolean;

		/**（可选项）是否显示水平滚动条*/ 
		hScrollBarEnabled: boolean;

		/**（可选项）页面是否可以缩放*/ 
		scaleEnabled: boolean;

		/**（可选项）是否允许长按页面时弹出选择菜单*/ 
		allowEdit: boolean;

		/**（可选项）窗口区域*/ 
		rect: JSON;

		/**（可选项）当键盘弹出时，输入框被盖住时，当前页面的调整方式,只iOS有效，Android请在 [config.xml](/APICloud/技术专题/app-config-manual) 里面配置并云编译使用*/ 
		softInputMode: string;

	}
	/**
	 * `设置frame属性`
	 * ========params==========
	 *
	 * `name` :string : frame 名称
	 *
	 * `bounces` :boolean : （可选项）页面是否弹动
	 *
	 * `hidden` :boolean : （可选项）设置本 frame 是否隐藏，设置显示隐藏并不会改变frame在整个窗口系统之间的层级关系。
	 *
	 * `bgColor` :string : （可选项）背景色，支持图片和颜色，格式为#fff、#ffffff、rgba(r,g,b,a)等，图片路径支持fs://、widget://等 APICloud 自定义文件路径协议，同时支持相对路径
	 *
	 * `scrollToTop` :boolean : （可选项）当点击状态栏，页面是否滚动到顶部。若当前屏幕上不止一个页面的 scrollToTop 属性为 true，则所有的都不会起作用。只iOS有效
	 *
	 * `scrollEnabled` :boolean : （可选项）页面内容超出后是否可以滚动，只支持iOS
	 *
	 * `vScrollBarEnabled` :boolean : （可选项）是否显示垂直滚动条
	 *
	 * `hScrollBarEnabled` :boolean : （可选项）是否显示水平滚动条
	 *
	 * `scaleEnabled` :boolean : （可选项）页面是否可以缩放
	 *
	 * `allowEdit` :boolean : （可选项）是否允许长按页面时弹出选择菜单
	 *
	 * `rect` :JSON : （可选项）窗口区域
	 *
	 * `softInputMode` :string : （可选项）当键盘弹出时，输入框被盖住时，当前页面的调整方式,只iOS有效，Android请在 [config.xml](/APICloud/技术专题/app-config-manual) 里面配置并云编译使用
	 */
	function setFrameAttr(option: api_setFrameAttr_Params):void;

	interface api_bringFrameToFront_Params {
		/**待调整显示顺序的 frame 名字*/ 
		from: string;

		/**（可选项）frame 名字，不传时调整 from 对应 frame 到最前面，否则调整 from 对应 frame 到此 frame 前面*/ 
		to: string;

	}
	/**
	 * `调整 frame 到前面`
	 * ========params==========
	 *
	 * `from` :string : 待调整显示顺序的 frame 名字
	 *
	 * `to` :string : （可选项）frame 名字，不传时调整 from 对应 frame 到最前面，否则调整 from 对应 frame 到此 frame 前面
	 */
	function bringFrameToFront(option: api_bringFrameToFront_Params):void;

	interface api_sendFrameToBack_Params {
		/**frame 名字*/ 
		from: string;

		/**（可选项）frame 名字，不传时调整 from 对应 frame 到最后面，否则调整 from 对应 frame 到此 frame 后面*/ 
		to: string;

	}
	/**
	 * `调整 frame 到后面`
	 * ========params==========
	 *
	 * `from` :string : frame 名字
	 *
	 * `to` :string : （可选项）frame 名字，不传时调整 from 对应 frame 到最后面，否则调整 from 对应 frame 到此 frame 后面
	 */
	function sendFrameToBack(option: api_sendFrameToBack_Params):void;

	interface api_setFrameClient_Params {
		/**frame 名字*/ 
		frameName: string;

	}
	/**
	 * `设置指定 frame 的页面加载监听，仅在 window 中调用生效，可以对多个 frame 进行监听。`
	 * ========params==========
	 *
	 * `frameName` :string : frame 名字
	 */
	function setFrameClient(option: api_setFrameClient_Params):void;

	interface api_animation_Params {
		/**frame 名字*/ 
		name: string;

		/**（可选项）动画延迟时间，单位毫秒，默认立即开始*/ 
		delay: number;

		/**（可选项）动画过渡时间，单位毫秒*/ 
		duration: number;

		/**（可选项）动画曲线类型，指定动画开始和结束时的快慢*/ 
		curve: string;

		/**（可选项）动画次数，默认不重复，为-1时无限重复*/ 
		repeatCount: number;

		/**（可选项）一次动画结束后是否自动反转动画*/ 
		autoreverse: boolean;

		/**（可选项）整个页面的透明度，介于0 1之间，Android 不支持*/ 
		alpha: number;

		/**（可选项）位置平移参数*/ 
		translation: JSON;

		/**（可选项）页面缩放参数，Android 不支持*/ 
		scale: JSON;

		/**（可选项）页面旋转参数，Android 不支持*/ 
		rotation: JSON;

	}
	/**
	 * `frame 动画，支持平移，缩放，旋转和透明度变化`
	 * ========params==========
	 *
	 * `name` :string : frame 名字
	 *
	 * `delay` :number : （可选项）动画延迟时间，单位毫秒，默认立即开始
	 *
	 * `duration` :number : （可选项）动画过渡时间，单位毫秒
	 *
	 * `curve` :string : （可选项）动画曲线类型，指定动画开始和结束时的快慢
	 *
	 * `repeatCount` :number : （可选项）动画次数，默认不重复，为-1时无限重复
	 *
	 * `autoreverse` :boolean : （可选项）一次动画结束后是否自动反转动画
	 *
	 * `alpha` :number : （可选项）整个页面的透明度，介于0 1之间，Android 不支持
	 *
	 * `translation` :JSON : （可选项）位置平移参数
	 *
	 * `scale` :JSON : （可选项）页面缩放参数，Android 不支持
	 *
	 * `rotation` :JSON : （可选项）页面旋转参数，Android 不支持
	 */
	function animation(option: api_animation_Params):void;

	interface api_openFrameGroup_Params {
		/**frame 组名字*/ 
		name: string;

		/**（可选项）frame 组背景，颜色（#fff,#ffffff,rgba(r,g,b,a)）或图片（支持文件路径协议和相对路径）*/ 
		background: string;

		/**（可选项）frame 组是否能够左右滚动*/ 
		scrollEnabled: boolean;

		/**（可选项）frameGroup 所要添加到的目标页面。*/ 
		fixedOn: string;

		/**（可选项）设置 frameGroup 的位置和大小。如果要固定宽高则使用 x、y、w、h 等参数；如果要自适应状态栏高度变化、横竖屏切换等，则需要使用 margin 相关参数，不能使用 w、h 固定宽高。推荐使用 margin 相关参数来布局。*/ 
		rect: JSON;

		/**（可选项）默认显示的页面索引*/ 
		index: number;

		/**（可选项）预加载的 frame 个数，默认加载当前页后面一个*/ 
		preload: number;

		/**frame 数组*/ 
		frames: Array;

	}
	/**
	 * `打开frame组`
	 * ========params==========
	 *
	 * `name` :string : frame 组名字
	 *
	 * `background` :string : （可选项）frame 组背景，颜色（#fff,#ffffff,rgba(r,g,b,a)）或图片（支持文件路径协议和相对路径）
	 *
	 * `scrollEnabled` :boolean : （可选项）frame 组是否能够左右滚动
	 *
	 * `fixedOn` :string : （可选项）frameGroup 所要添加到的目标页面。
	 *
	 * `rect` :JSON : （可选项）设置 frameGroup 的位置和大小。如果要固定宽高则使用 x、y、w、h 等参数；如果要自适应状态栏高度变化、横竖屏切换等，则需要使用 margin 相关参数，不能使用 w、h 固定宽高。推荐使用 margin 相关参数来布局。
	 *
	 * `index` :number : （可选项）默认显示的页面索引
	 *
	 * `preload` :number : （可选项）预加载的 frame 个数，默认加载当前页后面一个
	 *
	 * `frames` :Array : frame 数组
	 */
	function openFrameGroup(option: api_openFrameGroup_Params):void;

	interface api_closeFrameGroup_Params {
		/**frame 组名字*/ 
		name: string;

	}
	/**
	 * `关闭frame组`
	 * ========params==========
	 *
	 * `name` :string : frame 组名字
	 */
	function closeFrameGroup(option: api_closeFrameGroup_Params):void;

	interface api_setFrameGroupAttr_Params {
		/**frame 组名字*/ 
		name: string;

		/**（可选项）frame 组是否隐藏，设置显示隐藏并不会改变frame组在整个窗口系统之间的层级关系。*/ 
		hidden: boolean;

		/**（可选项）frame 组是否能够左右滚动*/ 
		scrollEnabled: boolean;

		/**（可选项）frame 组区域*/ 
		rect: JSON;

	}
	/**
	 * `设置 frame 组属性`
	 * ========params==========
	 *
	 * `name` :string : frame 组名字
	 *
	 * `hidden` :boolean : （可选项）frame 组是否隐藏，设置显示隐藏并不会改变frame组在整个窗口系统之间的层级关系。
	 *
	 * `scrollEnabled` :boolean : （可选项）frame 组是否能够左右滚动
	 *
	 * `rect` :JSON : （可选项）frame 组区域
	 */
	function setFrameGroupAttr(option: api_setFrameGroupAttr_Params):void;

	interface api_setFrameGroupIndex_Params {
		/**frame 组名字*/ 
		name: string;

		/**frame 索引*/ 
		index: number;

		/**（可选项）是否平滑滚动至目标窗口，即是否带有动画*/ 
		scroll: boolean;

		/**（可选项）是否刷新 frame*/ 
		reload: boolean;

		/**frame 的 url*/ 
		url: string;

	}
	/**
	 * `显示或重新加载指定页面`
	 * ========params==========
	 *
	 * `name` :string : frame 组名字
	 *
	 * `index` :number : frame 索引
	 *
	 * `scroll` :boolean : （可选项）是否平滑滚动至目标窗口，即是否带有动画
	 *
	 * `reload` :boolean : （可选项）是否刷新 frame
	 *
	 * `url` :string : frame 的 url
	 */
	function setFrameGroupIndex(option: api_setFrameGroupIndex_Params):void;

	interface api_openPopoverWin_Params {
		/**（可选项）弹出窗口展示类型*/ 
		style: string;

		/**（可选项）弹出窗口显示的宽度*/ 
		width: number;

		/**（可选项）弹出窗口显示的高度*/ 
		height: number;

		/**（可选项）当style为popover时，箭头指向的位置*/ 
		arrowRect: JSON;

		/**（可选项）当style为popover时，箭头指向的方向*/ 
		arrowDirection: string;

	}
	/**
	 * `打开弹出层窗口，只支持iPad`
	 * ========params==========
	 *
	 * `style` :string : （可选项）弹出窗口展示类型
	 *
	 * `width` :number : （可选项）弹出窗口显示的宽度
	 *
	 * `height` :number : （可选项）弹出窗口显示的高度
	 *
	 * `arrowRect` :JSON : （可选项）当style为popover时，箭头指向的位置
	 *
	 * `arrowDirection` :string : （可选项）当style为popover时，箭头指向的方向
	 */
	function openPopoverWin(option: api_openPopoverWin_Params):void;

	function closePopoverWin():void;

	interface api_openSlidLayout_Params {
		/**（可选项）侧滑类型（left：左侧滑、right：右侧滑、all：左右侧滑）。安卓暂只支持left。*/ 
		type: string;

		/**（可选项）左侧滑时，侧滑 window 停留时露出的宽度。即将废弃，用 slidPaneStyle 中 leftEdge 参数代替*/ 
		leftEdge: number;

		/**（可选项）右侧滑时，侧滑 window 停留时露出的宽度。即将废弃，用 slidPaneStyle 中 rightEdge 参数代替*/ 
		rightEdge: number;

		/**侧滑层 window 样式*/ 
		slidPaneStyle: JSON;

		/**底部固定层 window 样式*/ 
		fixedPaneStyle: JSON;

		/**底部固定层 window*/ 
		fixedPane: JSON;

		/**侧滑层window*/ 
		slidPane: JSON;

	}
	/**
	 * `打开侧滑式布局`
	 * ========params==========
	 *
	 * `type` :string : （可选项）侧滑类型（left：左侧滑、right：右侧滑、all：左右侧滑）。安卓暂只支持left。
	 *
	 * `leftEdge` :number : （可选项）左侧滑时，侧滑 window 停留时露出的宽度。即将废弃，用 slidPaneStyle 中 leftEdge 参数代替
	 *
	 * `rightEdge` :number : （可选项）右侧滑时，侧滑 window 停留时露出的宽度。即将废弃，用 slidPaneStyle 中 rightEdge 参数代替
	 *
	 * `slidPaneStyle` :JSON : 侧滑层 window 样式
	 *
	 * `fixedPaneStyle` :JSON : 底部固定层 window 样式
	 *
	 * `fixedPane` :JSON : 底部固定层 window
	 *
	 * `slidPane` :JSON : 侧滑层window
	 */
	function openSlidLayout(option: api_openSlidLayout_Params):void;

	interface api_openSlidPane_Params {
		/**侧滑类型，left 或 right*/ 
		type: string;

	}
	/**
	 * `向左或右进行侧滑`
	 * ========params==========
	 *
	 * `type` :string : 侧滑类型，left 或 right
	 */
	function openSlidPane(option: api_openSlidPane_Params):void;

	function closeSlidPane():void;

	function lockSlidPane():void;

	function unlockSlidPane():void;

	interface api_openDrawerLayout_Params {
		/**左边侧滑 window*/ 
		leftPane: JSON;

		/**右边侧滑 window*/ 
		rightPane: JSON;

		/**（可选项）是否支持在页面边缘处滑动打开drawerPane*/ 
		slidToOpenPane: boolean;

		/**（可选项）在打开的drawerPane页面，是否支持滑动关闭drawerPane*/ 
		slidToClosePane: boolean;

		/**（可选项）在打开的drawerPane页面，是否支持点击遮罩部分关闭drawerPane*/ 
		tapToClosePane: boolean;

	}
	/**
	 * `打开一个抽屉式侧滑 window，可以从当前 window 的左右边缘滑动拉出侧滑 window。`
	 * ========params==========
	 *
	 * `leftPane` :JSON : 左边侧滑 window
	 *
	 * `rightPane` :JSON : 右边侧滑 window
	 *
	 * `slidToOpenPane` :boolean : （可选项）是否支持在页面边缘处滑动打开drawerPane
	 *
	 * `slidToClosePane` :boolean : （可选项）在打开的drawerPane页面，是否支持滑动关闭drawerPane
	 *
	 * `tapToClosePane` :boolean : （可选项）在打开的drawerPane页面，是否支持点击遮罩部分关闭drawerPane
	 */
	function openDrawerLayout(option: api_openDrawerLayout_Params):void;

	interface api_openDrawerPane_Params {
		/**侧滑类型，left 或 right*/ 
		type: string;

	}
	/**
	 * `打开抽屉式侧滑Pane`
	 * ========params==========
	 *
	 * `type` :string : 侧滑类型，left 或 right
	 */
	function openDrawerPane(option: api_openDrawerPane_Params):void;

	function closeDrawerPane():void;

	interface api_loadData_Params {
		/**（可选项）window 名称，若要跨 window ，该字段必须指定，首页的名称为 root*/ 
		name: string;

		/**（可选项）frame名称*/ 
		frameName: string;

		/**（可选项）做为baseUrl，data中的html引用的资源文件根路径以该url为基础，可以为本地文件路径，支持相对路径和绝对路径，以及 widget://、fs://等协议路径。*/ 
		url: string;

		/**页面加载的数据内容，可以为html片段或者整张html文件的数据*/ 
		data: string;

	}
	/**
	 * `在指定 window 或者 frame 中加载HTML数据，对于 frameGroup 里面的 frame 也有效。`
	 * ========params==========
	 *
	 * `name` :string : （可选项）window 名称，若要跨 window ，该字段必须指定，首页的名称为 root
	 *
	 * `frameName` :string : （可选项）frame名称
	 *
	 * `url` :string : （可选项）做为baseUrl，data中的html引用的资源文件根路径以该url为基础，可以为本地文件路径，支持相对路径和绝对路径，以及 widget://、fs://等协议路径。
	 *
	 * `data` :string : 页面加载的数据内容，可以为html片段或者整张html文件的数据
	 */
	function loadData(option: api_loadData_Params):void;

	interface api_execScript_Params {
		/**（可选项）window 名称，若要跨 window 执行脚本，该字段必须指定，首页的名称为 root*/ 
		name: string;

		/**（可选项）frame名称*/ 
		frameName: string;

		/**js代码*/ 
		script: string;

	}
	/**
	 * `在指定 window 或者 frame 中执行脚本，对于 frameGroup 里面的 frame 也有效，若 name 和 frameName 都未指定，则在当前 window 中执行脚本，具体执行逻辑见补充说明。`
	 * ========params==========
	 *
	 * `name` :string : （可选项）window 名称，若要跨 window 执行脚本，该字段必须指定，首页的名称为 root
	 *
	 * `frameName` :string : （可选项）frame名称
	 *
	 * `script` :string : js代码
	 */
	function execScript(option: api_execScript_Params):void;

	interface api_setBlurEffect_Params {
		/**模糊效果风格样式，传none时表示移除模糊效果*/ 
		style: string;

		/**（可选项）false时表示对当前页面添加模糊效果，true时表示对整个应用窗口添加模糊效果*/ 
		global: boolean;

		/**（可选项）模糊区域透明度，介于0和1之间*/ 
		alpha: number;

		/**（可选项）模糊区域圆角半径*/ 
		borderRadius: number;

		/**（可选项）动画参数，设置模糊渐变效果，只支持iOS 9及以上系统*/ 
		animation: JSON;

		/**（可选项）模糊区域*/ 
		rect: JSON;

	}
	/**
	 * `对当前页面或应用设置模糊效果`
	 * ========params==========
	 *
	 * `style` :string : 模糊效果风格样式，传none时表示移除模糊效果
	 *
	 * `global` :boolean : （可选项）false时表示对当前页面添加模糊效果，true时表示对整个应用窗口添加模糊效果
	 *
	 * `alpha` :number : （可选项）模糊区域透明度，介于0和1之间
	 *
	 * `borderRadius` :number : （可选项）模糊区域圆角半径
	 *
	 * `animation` :JSON : （可选项）动画参数，设置模糊渐变效果，只支持iOS 9及以上系统
	 *
	 * `rect` :JSON : （可选项）模糊区域
	 */
	function setBlurEffect(option: api_setBlurEffect_Params):void;

	interface api_removeLaunchView_Params {
		/**（可选项）动画参数，不传时不使用动画*/ 
		animation: JSON;

	}
	/**
	 * `移除启动图。若 [config.xml](/APICloud/技术专题/app-config-manual) 里面配置 autoLaunch 为 false，则启动图不会自动消失，直到调用此方法移除。`
	 * ========params==========
	 *
	 * `animation` :JSON : （可选项）动画参数，不传时不使用动画
	 */
	function removeLaunchView(option: api_removeLaunchView_Params):void;

	function showLaunchView():void;

	function parseTapmode():void;

	interface api_openTabLayout_Params extends api_openWin_Params {
		/**（可选项）显示在顶部navigationBar上面的标题*/ 
		title: string;

		/**（可选项）是否隐藏顶部navigationBar导航栏，只在传了navigationBar参数时有效*/ 
		hideNavigationBar: boolean;

		/**（可选项）是否隐藏底部tabBar标签栏，只在传了tabBar参数时有效*/ 
		hideTabBar: boolean;

		/**（可选项）顶部navigationBar导航栏配置信息*/ 
		navigationBar: JSON;

		/**（可选项）底部tabBar标签栏配置信息，可以通过监听tabitembtn事件来处理标签栏每项的点击事件*/ 
		tabBar: JSON;

	}
	/**
	 * `打开tabLayout布局`
	 * ========params==========
	 *
	 * `title` :string : （可选项）显示在顶部navigationBar上面的标题
	 *
	 * `hideNavigationBar` :boolean : （可选项）是否隐藏顶部navigationBar导航栏，只在传了navigationBar参数时有效
	 *
	 * `hideTabBar` :boolean : （可选项）是否隐藏底部tabBar标签栏，只在传了tabBar参数时有效
	 *
	 * `navigationBar` :JSON : （可选项）顶部navigationBar导航栏配置信息
	 *
	 * `tabBar` :JSON : （可选项）底部tabBar标签栏配置信息，可以通过监听tabitembtn事件来处理标签栏每项的点击事件
	 */
	function openTabLayout(option: api_openTabLayout_Params extends api_openWin_Params):void;

	interface api_setTabLayoutAttr_Params {
		/**（可选项）显示在顶部navigationBar上面的标题*/ 
		title: string;

		/**（可选项）是否隐藏顶部navigationBar导航栏*/ 
		hideNavigationBar: boolean;

		/**（可选项）是否隐藏底部tabBar标签栏*/ 
		hideTabBar: boolean;

		/**（可选项）显示隐藏navigationBar、tabBar时是否有动画效果。*/ 
		animated: boolean;

	}
	/**
	 * `设置tabLayout属性`
	 * ========params==========
	 *
	 * `title` :string : （可选项）显示在顶部navigationBar上面的标题
	 *
	 * `hideNavigationBar` :boolean : （可选项）是否隐藏顶部navigationBar导航栏
	 *
	 * `hideTabBar` :boolean : （可选项）是否隐藏底部tabBar标签栏
	 *
	 * `animated` :boolean : （可选项）显示隐藏navigationBar、tabBar时是否有动画效果。
	 */
	function setTabLayoutAttr(option: api_setTabLayoutAttr_Params):void;

	interface api_setNavBarAttr_Params {
		/**（可选项）导航栏背景。支持颜色值和图片*/ 
		background: string;

		/**（可选项）导航栏底部阴影线颜色*/ 
		shadow: string;

		/**（可选项）导航栏标题文字颜色*/ 
		color: string;

		/**（可选项）导航栏标题字体大小*/ 
		fontSize: number;

		/**（可选项）导航栏标题文字粗细*/ 
		fontWeight: string;

		/**（可选项）导航栏标题文字字体。只支持iOS。*/ 
		fontFamily: string;

		/**（可选项）是否隐藏默认返回按钮。可以通过监听 navbackbtn 或 keyback 事件来处理返回按钮的点击事件。*/ 
		hideBackButton: boolean;

		/**（可选项）导航栏左边按钮组，左边按钮会替换掉默认的返回按钮，按钮按照数组顺序从左至右显示，按钮建议最多2个，可以通过监听 navitembtn 事件来处理按钮点击事件。*/ 
		leftButtons: Array<JSON>;

		/**（可选项）导航栏右边按钮组。按钮按照数组顺序从右至左显示，按钮建议最多2个，可以通过监听navitembtn事件来处理按钮点击事件。*/ 
		rightButtons: Array<JSON>;

	}
	/**
	 * `设置导航栏属性`
	 * ========params==========
	 *
	 * `background` :string : （可选项）导航栏背景。支持颜色值和图片
	 *
	 * `shadow` :string : （可选项）导航栏底部阴影线颜色
	 *
	 * `color` :string : （可选项）导航栏标题文字颜色
	 *
	 * `fontSize` :number : （可选项）导航栏标题字体大小
	 *
	 * `fontWeight` :string : （可选项）导航栏标题文字粗细
	 *
	 * `fontFamily` :string : （可选项）导航栏标题文字字体。只支持iOS。
	 *
	 * `hideBackButton` :boolean : （可选项）是否隐藏默认返回按钮。可以通过监听 navbackbtn 或 keyback 事件来处理返回按钮的点击事件。
	 *
	 * `leftButtons` :Array<JSON> : （可选项）导航栏左边按钮组，左边按钮会替换掉默认的返回按钮，按钮按照数组顺序从左至右显示，按钮建议最多2个，可以通过监听 navitembtn 事件来处理按钮点击事件。
	 *
	 * `rightButtons` :Array<JSON> : （可选项）导航栏右边按钮组。按钮按照数组顺序从右至左显示，按钮建议最多2个，可以通过监听navitembtn事件来处理按钮点击事件。
	 */
	function setNavBarAttr(option: api_setNavBarAttr_Params):void;

	interface api_getNavBarAttr_ret {
		/** 导航栏是否隐藏，布尔类型。*/ 
		hidden: boolean;

		/** 导航栏高度（不包括为状态栏留出的部分），数字类型。*/ 
		height: number;

	}
	function getNavBarAttr():api_getNavBarAttr_ret

	interface api_setTabBarAttr_Params {
		/**（可选项）设置选中标签栏指定项*/ 
		index: number;

		/**（可选项）标签栏背景。支持颜色值和图片*/ 
		background: string;

		/**（可选项）标签栏顶部阴影线颜色*/ 
		shadow: string;

		/**（可选项）标签栏各项的文字颜色*/ 
		color: string;

		/**（可选项）标签栏各项选中状态下的文字颜色*/ 
		selectedColor: string;

		/**（可选项）标签栏各项文字字体大小*/ 
		fontSize: number;

		/**（可选项）标签栏各项文字粗细*/ 
		fontWeight: string;

		/**（可选项）标签栏各项文字字体。只支持iOS。*/ 
		fontFamily: string;

		/**（可选项）标签栏各项文字距离底部的距离*/ 
		textOffset: number;

	}
	/**
	 * `设置tabBar属性`
	 * ========params==========
	 *
	 * `index` :number : （可选项）设置选中标签栏指定项
	 *
	 * `background` :string : （可选项）标签栏背景。支持颜色值和图片
	 *
	 * `shadow` :string : （可选项）标签栏顶部阴影线颜色
	 *
	 * `color` :string : （可选项）标签栏各项的文字颜色
	 *
	 * `selectedColor` :string : （可选项）标签栏各项选中状态下的文字颜色
	 *
	 * `fontSize` :number : （可选项）标签栏各项文字字体大小
	 *
	 * `fontWeight` :string : （可选项）标签栏各项文字粗细
	 *
	 * `fontFamily` :string : （可选项）标签栏各项文字字体。只支持iOS。
	 *
	 * `textOffset` :number : （可选项）标签栏各项文字距离底部的距离
	 */
	function setTabBarAttr(option: api_setTabBarAttr_Params):void;

	interface api_setTabBarItemAttr_Params {
		/**要设置的指定项的索引*/ 
		index: number;

		/**（可选项）该项的标题文字*/ 
		text: string;

		/**（可选项）该项默认状态下 icon 图标路径*/ 
		iconPath: string;

		/**（可选项）该项选中状态下 icon 图标路径*/ 
		selectedIconPath: string;

		/**（可选项）图片的缩放倍数。显示规则：当 scale 值为 3 时，若设备上面期望显示的图标尺寸为 30*25，则图片实际尺寸需要为 90*75。*/ 
		scale: number;

		/**（可选项）该项的角标信息*/ 
		badge: JSON;

	}
	/**
	 * `设置tabBar指定项的属性`
	 * ========params==========
	 *
	 * `index` :number : 要设置的指定项的索引
	 *
	 * `text` :string : （可选项）该项的标题文字
	 *
	 * `iconPath` :string : （可选项）该项默认状态下 icon 图标路径
	 *
	 * `selectedIconPath` :string : （可选项）该项选中状态下 icon 图标路径
	 *
	 * `scale` :number : （可选项）图片的缩放倍数。显示规则：当 scale 值为 3 时，若设备上面期望显示的图标尺寸为 30*25，则图片实际尺寸需要为 90*75。
	 *
	 * `badge` :JSON : （可选项）该项的角标信息
	 */
	function setTabBarItemAttr(option: api_setTabBarItemAttr_Params):void;

	interface api_installApp_Params {
		/**目标应用的资源文件标识。Android上为apk包的本地路径，如file://xxx.apk；iOS上为应用安装包对应的plist文件地址*/ 
		appUri: string;

	}
	/**
	 * `安装应用，如果是苹果的AppStore应用地址，将会跳转到AppStore应用详情页面`
	 * ========params==========
	 *
	 * `appUri` :string : 目标应用的资源文件标识。Android上为apk包的本地路径，如file://xxx.apk；iOS上为应用安装包对应的plist文件地址
	 */
	function installApp(option: api_installApp_Params):void;

	interface api_uninstallApp_Params {
		/**要卸载的应用的包名*/ 
		packageName: string;

	}
	/**
	 * `卸载应用，只支持Android`
	 * ========params==========
	 *
	 * `packageName` :string : 要卸载的应用的包名
	 */
	function uninstallApp(option: api_uninstallApp_Params):void;

	interface api_openApp_Params {
		/**（可选项）传给目标应用的参数。iOS 平台会将 appParam 里面的值拼接到 iosUrl 后面，比如 iosUrl 为 http://www.baidu.com ，appParam为{"keyword":"APICloud"}，则最后传递给第三方应用的url为http://www.baidu.com?keyword=APICloud*/ 
		appParam: JSON;

		/**（可选项）目标应用的url（iOS平台使用），iOS下必传*/ 
		iosUrl: string;

		/**（可选项）目标应用的包名或 action（Android平台使用），Android下必传*/ 
		androidPkg: string;

		/**（可选项）指定目标应用的响应数据类型，如："text/html"（Android平台使用）*/ 
		mimeType: string;

		/**（可选项）指定目标应用响应的uri（Android平台使用）*/ 
		uri: string;

	}
	/**
	 * `打开手机上其它应用，可以传递参数`
	 * ========params==========
	 *
	 * `appParam` :JSON : （可选项）传给目标应用的参数。iOS 平台会将 appParam 里面的值拼接到 iosUrl 后面，比如 iosUrl 为 http://www.baidu.com ，appParam为{"keyword":"APICloud"}，则最后传递给第三方应用的url为http://www.baidu.com?keyword=APICloud
	 *
	 * `iosUrl` :string : （可选项）目标应用的url（iOS平台使用），iOS下必传
	 *
	 * `androidPkg` :string : （可选项）目标应用的包名或 action（Android平台使用），Android下必传
	 *
	 * `mimeType` :string : （可选项）指定目标应用的响应数据类型，如："text/html"（Android平台使用）
	 *
	 * `uri` :string : （可选项）指定目标应用响应的uri（Android平台使用）
	 */
	function openApp(option: api_openApp_Params):void;

	interface api_appInstalled_Params {
		/**执行结果的返回方式。为false时通过callback返回，为true时直接返回。*/ 
		sync: boolean;

		/**Android 平台为应用包名，iOS 平台为应用定义的 URL Scheme。iOS 中的 URL Scheme 与包名不一样，一个应用只有一个包名，但是可以配置多个 URL Scheme*/ 
		appBundle: string;

	}
	/**
	 * `判断设备上面是否已安装指定应用`
	 * ========params==========
	 *
	 * `sync` :boolean : 执行结果的返回方式。为false时通过callback返回，为true时直接返回。
	 *
	 * `appBundle` :string : Android 平台为应用包名，iOS 平台为应用定义的 URL Scheme。iOS 中的 URL Scheme 与包名不一样，一个应用只有一个包名，但是可以配置多个 URL Scheme
	 */
	function appInstalled(option: api_appInstalled_Params):void;

	function rebootApp():void;

	interface api_openWidget_Params {
		/**（可选项）widget的id*/ 
		id: string;

		/**（可选项）widget的根目录，该目录下面放置有config.xml等文件。通过传入此字段，可以打开放置在任意位置的widget。注意若传了id字段，此字段将被忽略*/ 
		path: string;

		/**（可选项）widget 参数，在新打开的 widget 里面的页面中通过 api.wgtParam 获取*/ 
		wgtParam: JSON;

		/**（可选项）在新打开的 widget 里面的页面中是否支持长按退出，只支持iOS。*/ 
		longPressToExit: boolean;

		/**（可选项）动画参数，不传时使用默认动画*/ 
		animation: JSON;

	}
	/**
	 * `打开 Widget，若此 widget 已经被打开，则会把其调整到最前面显示`
	 * ========params==========
	 *
	 * `id` :string : （可选项）widget的id
	 *
	 * `path` :string : （可选项）widget的根目录，该目录下面放置有config.xml等文件。通过传入此字段，可以打开放置在任意位置的widget。注意若传了id字段，此字段将被忽略
	 *
	 * `wgtParam` :JSON : （可选项）widget 参数，在新打开的 widget 里面的页面中通过 api.wgtParam 获取
	 *
	 * `longPressToExit` :boolean : （可选项）在新打开的 widget 里面的页面中是否支持长按退出，只支持iOS。
	 *
	 * `animation` :JSON : （可选项）动画参数，不传时使用默认动画
	 */
	function openWidget(option: api_openWidget_Params):void;

	interface api_closeWidget_Params {
		/**（可选项）widget 的 ID*/ 
		id: string;

		/**（可选项）返回给上个 widget 的返回值*/ 
		retData: JSON;

		/**（可选项）是否静默退出应用，只在主 widget 中有效。当为 false 时，引擎会弹出对话框询问是否退出应用*/ 
		silent: boolean;

		/**（可选项）动画参数，不传时使用默认动画*/ 
		animation: JSON;

	}
	/**
	 * `关闭指定widget，也可以关闭应用`
	 * ========params==========
	 *
	 * `id` :string : （可选项）widget 的 ID
	 *
	 * `retData` :JSON : （可选项）返回给上个 widget 的返回值
	 *
	 * `silent` :boolean : （可选项）是否静默退出应用，只在主 widget 中有效。当为 false 时，引擎会弹出对话框询问是否退出应用
	 *
	 * `animation` :JSON : （可选项）动画参数，不传时使用默认动画
	 */
	function closeWidget(option: api_closeWidget_Params):void;

	interface api_ajax_Params {
		/**请求地址*/ 
		url: string;

		/**（可选项）是否对url进行编码。默认或传true时，Android将始终对url编码，而iOS只有在url不合法（如存在中文字符）的时候才进行编码。如果url中有特殊字符需要编码的，建议先在js层进行编码，然后此参数传false。*/ 
		encode: boolean;

		/**（可选项）该字段用于传给cancelAjax方法来取消请求，如果传入该字段，请保证各个ajax的tag字段唯一*/ 
		tag: string;

		/**（可选项）异步请求方法类型*/ 
		method: string;

		/**（可选项）是否缓存，若缓存，下次没网络时请求则会使用缓存，仅在get请求有效*/ 
		cache: boolean;

		/**（可选项）超时时间，单位秒*/ 
		timeout: number;

		/**（可选项）返回数据类型。若该字段传json，接收到服务器返回的数据后会尝试将其转换成JSON对象，如果无法转成JSON对象，将返回数据类型错误*/ 
		dataType: string;

		/**（可选项）当响应头里面没有返回字符集编码时，使用此编码来解析数据*/ 
		charset: string;

		/**（可选项）设置请求头数据*/ 
		headers: JSON;

		/**（可选项）是否实时返回上传文件进度*/ 
		report: boolean;

		/**（可选项）是否需要返回所有 response 信息（包括响应头、消息体、状态码），为 true 时，返回的头信息获取方法(ret.headers)，消息体信息获取方法(ret.body)，状态码获取方法(ret.statusCode)*/ 
		returnAll: boolean;

		/**（可选项）POST 数据，method 为 get 时不传。以下字段除了 values 和 files 可以同时使用，其它参数都不能同时使用。*/ 
		data: JSON;

		/**（可选项）用于https请求开启双向认证的情况下，客户端配置p12安全证书设置。*/ 
		certificate: JSON;

		/**（可选项）设置请求安全模式。设置后，若检测到数据有安全风险时将返回“不安全的数据”错误*/ 
		safeMode: string;

		/**（可选项）设置代理请求服务器。*/ 
		proxy: JSON;

	}
	/**
	 * `跨域异步请求，支持标准HTTP协议，支持HTTPS单向/双向认证请求，支持文件上传，支持缓存。`
	 * ========params==========
	 *
	 * `url` :string : 请求地址
	 *
	 * `encode` :boolean : （可选项）是否对url进行编码。默认或传true时，Android将始终对url编码，而iOS只有在url不合法（如存在中文字符）的时候才进行编码。如果url中有特殊字符需要编码的，建议先在js层进行编码，然后此参数传false。
	 *
	 * `tag` :string : （可选项）该字段用于传给cancelAjax方法来取消请求，如果传入该字段，请保证各个ajax的tag字段唯一
	 *
	 * `method` :string : （可选项）异步请求方法类型
	 *
	 * `cache` :boolean : （可选项）是否缓存，若缓存，下次没网络时请求则会使用缓存，仅在get请求有效
	 *
	 * `timeout` :number : （可选项）超时时间，单位秒
	 *
	 * `dataType` :string : （可选项）返回数据类型。若该字段传json，接收到服务器返回的数据后会尝试将其转换成JSON对象，如果无法转成JSON对象，将返回数据类型错误
	 *
	 * `charset` :string : （可选项）当响应头里面没有返回字符集编码时，使用此编码来解析数据
	 *
	 * `headers` :JSON : （可选项）设置请求头数据
	 *
	 * `report` :boolean : （可选项）是否实时返回上传文件进度
	 *
	 * `returnAll` :boolean : （可选项）是否需要返回所有 response 信息（包括响应头、消息体、状态码），为 true 时，返回的头信息获取方法(ret.headers)，消息体信息获取方法(ret.body)，状态码获取方法(ret.statusCode)
	 *
	 * `data` :JSON : （可选项）POST 数据，method 为 get 时不传。以下字段除了 values 和 files 可以同时使用，其它参数都不能同时使用。
	 *
	 * `certificate` :JSON : （可选项）用于https请求开启双向认证的情况下，客户端配置p12安全证书设置。
	 *
	 * `safeMode` :string : （可选项）设置请求安全模式。设置后，若检测到数据有安全风险时将返回“不安全的数据”错误
	 *
	 * `proxy` :JSON : （可选项）设置代理请求服务器。
	 */
	function ajax(option: api_ajax_Params):void;

	interface api_cancelAjax_Params {
		/**请求标识*/ 
		tag: string;

	}
	/**
	 * `取消异步请求`
	 * ========params==========
	 *
	 * `tag` :string : 请求标识
	 */
	function cancelAjax(option: api_cancelAjax_Params):void;

	interface api_download_Params {
		/**下载地址*/ 
		url: string;

		/**（可选项）是否对url进行编码。默认或传true时，Android将始终对url编码，而iOS只有在url不合法（如存在中文字符）的时候才进行编码。如果url中有特殊字符需要编码的，建议先在js层进行编码，然后此参数传false。*/ 
		encode: boolean;

		/**（可选项）存储路径，不传时使用自动创建的路径*/ 
		savePath: string;

		/**（可选项）下载过程是否上报*/ 
		report: boolean;

		/**（可选项）是否使用本地缓存*/ 
		cache: boolean;

		/**（可选项）是否允许断点续传*/ 
		allowResume: boolean;

		/**（可选项）请求方法类型*/ 
		method: string;

		/**（可选项）设置请求头数据*/ 
		headers: JSON;

		/**（可选项）POST 数据，method 为 get 时不传。values 和 body 不能同时使用。*/ 
		data: JSON;

	}
	/**
	 * `下载文件`
	 * ========params==========
	 *
	 * `url` :string : 下载地址
	 *
	 * `encode` :boolean : （可选项）是否对url进行编码。默认或传true时，Android将始终对url编码，而iOS只有在url不合法（如存在中文字符）的时候才进行编码。如果url中有特殊字符需要编码的，建议先在js层进行编码，然后此参数传false。
	 *
	 * `savePath` :string : （可选项）存储路径，不传时使用自动创建的路径
	 *
	 * `report` :boolean : （可选项）下载过程是否上报
	 *
	 * `cache` :boolean : （可选项）是否使用本地缓存
	 *
	 * `allowResume` :boolean : （可选项）是否允许断点续传
	 *
	 * `method` :string : （可选项）请求方法类型
	 *
	 * `headers` :JSON : （可选项）设置请求头数据
	 *
	 * `data` :JSON : （可选项）POST 数据，method 为 get 时不传。values 和 body 不能同时使用。
	 */
	function download(option: api_download_Params):void;

	interface api_cancelDownload_Params {
		/**下载地址*/ 
		url: string;

	}
	/**
	 * `取消文件下载`
	 * ========params==========
	 *
	 * `url` :string : 下载地址
	 */
	function cancelDownload(option: api_cancelDownload_Params):void;

	interface api_imageCache_Params {
		/**图片远程地址*/ 
		url: string;

		/**（可选项）是否对url进行编码。默认或传true时，Android将始终对url编码，而iOS只有在url不合法（如存在中文字符）的时候才进行编码。如果url中有特殊字符需要编码的，建议先在js层进行编码，然后此参数传false。*/ 
		encode: boolean;

		/**（可选项）缓存策略*/ 
		policy: string;

		/**（可选项）使用缩略图，底层将根据当前系统及设备性能，返回最优的缩略图，有利于提高应用运行及渲染效率*/ 
		thumbnail: boolean;

		/**（可选项）标识信息，将在回调中返回*/ 
		tag: string;

	}
	/**
	 * `图片缓存`
	 * ========params==========
	 *
	 * `url` :string : 图片远程地址
	 *
	 * `encode` :boolean : （可选项）是否对url进行编码。默认或传true时，Android将始终对url编码，而iOS只有在url不合法（如存在中文字符）的时候才进行编码。如果url中有特殊字符需要编码的，建议先在js层进行编码，然后此参数传false。
	 *
	 * `policy` :string : （可选项）缓存策略
	 *
	 * `thumbnail` :boolean : （可选项）使用缩略图，底层将根据当前系统及设备性能，返回最优的缩略图，有利于提高应用运行及渲染效率
	 *
	 * `tag` :string : （可选项）标识信息，将在回调中返回
	 */
	function imageCache(option: api_imageCache_Params):void;

	interface api_applyCertificates_Params {
		/**证书信息列表*/ 
		certificates: Array<JSON>;

	}
	/**
	 * `设置全局HTTPS双向认证，客户端P12证书，证书将作用于ajax网络请求，以及openWin、openFrame等加载web页面。此配置与ajax的certificate互斥，即如果ajax配置了certificate，将优先使用ajax出入的certificate。`
	 * ========params==========
	 *
	 * `certificates` :Array<JSON> : 证书信息列表
	 */
	function applyCertificates(option: api_applyCertificates_Params):void;

	interface api_readFile_Params {
		/**执行结果的返回方式。为false时通过callback返回，为true时直接返回。*/ 
		sync: boolean;

		/**文件路径，支持绝对路径和文件路径协议如fs://、widget://等*/ 
		path: string;

	}
	/**
	 * `读取文本文件内容，只支持utf-8编码文本类型文件`
	 * ========params==========
	 *
	 * `sync` :boolean : 执行结果的返回方式。为false时通过callback返回，为true时直接返回。
	 *
	 * `path` :string : 文件路径，支持绝对路径和文件路径协议如fs://、widget://等
	 */
	function readFile(option: api_readFile_Params):void;

	interface api_writeFile_Params {
		/**文件路径，支持绝对路径和文件路径协议如fs://、cache://等，不支持widget://目录，该目录只读*/ 
		path: string;

		/**文件内容*/ 
		data: string;

		/**是否以追加方式写入数据，默认会清除之前文件内容*/ 
		append: boolean;

	}
	/**
	 * `写入内容到文本文件`
	 * ========params==========
	 *
	 * `path` :string : 文件路径，支持绝对路径和文件路径协议如fs://、cache://等，不支持widget://目录，该目录只读
	 *
	 * `data` :string : 文件内容
	 *
	 * `append` :boolean : 是否以追加方式写入数据，默认会清除之前文件内容
	 */
	function writeFile(option: api_writeFile_Params):void;

	interface api_setPrefs_Params {
		/**键*/ 
		key: string;

		/**值*/ 
		value: string;

	}
	/**
	 * `设置偏好数据，数据会存储到本地文件系统。`
	 * ========params==========
	 *
	 * `key` :string : 键
	 *
	 * `value` :string : 值
	 */
	function setPrefs(option: api_setPrefs_Params):void;

	interface api_getPrefs_Params {
		/**执行结果的返回方式。为false时通过callback返回，为true时直接返回。*/ 
		sync: boolean;

		/**键*/ 
		key: string;

	}
	/**
	 * `获取偏好设置值`
	 * ========params==========
	 *
	 * `sync` :boolean : 执行结果的返回方式。为false时通过callback返回，为true时直接返回。
	 *
	 * `key` :string : 键
	 */
	function getPrefs(option: api_getPrefs_Params):void;

	interface api_removePrefs_Params {
		/**键*/ 
		key: string;

	}
	/**
	 * `删除偏好设置值`
	 * ========params==========
	 *
	 * `key` :string : 键
	 */
	function removePrefs(option: api_removePrefs_Params):void;

	interface api_setGlobalData_Params {
		/**键*/ 
		key: string;

		/**值*/ 
		value: string;

	}
	/**
	 * `设置全局数据，数据只存储在内存中，不会存储到本地文件系统。`
	 * ========params==========
	 *
	 * `key` :string : 键
	 *
	 * `value` :string : 值
	 */
	function setGlobalData(option: api_setGlobalData_Params):void;

	interface api_getGlobalData_Params {
		/**键*/ 
		key: string;

	}
	/**
	 * `获取全局数据`
	 * ========params==========
	 *
	 * `key` :string : 键
	 */
	function getGlobalData(option: api_getGlobalData_Params):void;

	interface api_clearCache_Params {
		/**（可选项）清除多少天前的缓存*/ 
		timeThreshold: number;

	}
	/**
	 * `清除缓存，包括cache://目录下的文件、拍照临时文件、网页缓存文件等，清除时可能需要消耗一定时间。`
	 * ========params==========
	 *
	 * `timeThreshold` :number : （可选项）清除多少天前的缓存
	 */
	function clearCache(option: api_clearCache_Params):void;

	interface api_getCacheSize_Params {
		/**执行结果的返回方式。为false时通过callback返回，为true时直接返回。*/ 
		sync: boolean;

	}
	/**
	 * `获取缓存占用空间大小，缓存包括cache://目录下的文件、拍照临时文件以及网页缓存文件等，计算可能需要花费一些时间`
	 * ========params==========
	 *
	 * `sync` :boolean : 执行结果的返回方式。为false时通过callback返回，为true时直接返回。
	 */
	function getCacheSize(option: api_getCacheSize_Params):void;

	interface api_getTotalSpace_Params {
		/**执行结果的返回方式。为false时通过callback返回，为true时直接返回。*/ 
		sync: boolean;

	}
	/**
	 * `获取总存储空间大小`
	 * ========params==========
	 *
	 * `sync` :boolean : 执行结果的返回方式。为false时通过callback返回，为true时直接返回。
	 */
	function getTotalSpace(option: api_getTotalSpace_Params):void;

	interface api_getFreeDiskSpace_Params {
		/**执行结果的返回方式。为false时通过callback返回，为true时直接返回。*/ 
		sync: boolean;

	}
	/**
	 * `获取剩余存储空间大小`
	 * ========params==========
	 *
	 * `sync` :boolean : 执行结果的返回方式。为false时通过callback返回，为true时直接返回。
	 */
	function getFreeDiskSpace(option: api_getFreeDiskSpace_Params):void;

	interface api_loadSecureValue_Params {
		/**执行结果的返回方式。为false时通过callback返回，为true时直接返回。*/ 
		sync: boolean;

		/**键*/ 
		key: string;

	}
	/**
	 * `从加密的key.xml文件中读取指定数据，key.xml文件放置于网页包里面的res目录，配置方式：`
	 * ========params==========
	 *
	 * `sync` :boolean : 执行结果的返回方式。为false时通过callback返回，为true时直接返回。
	 *
	 * `key` :string : 键
	 */
	function loadSecureValue(option: api_loadSecureValue_Params):void;

	interface api_addEventListener_Params {
		name: eventType
	}
	 /** 
	 * 监听事件，支持系统事件和自定义事件
	 *
	 * @params params
	 *
	 * - name: string; 自定义事件或系统事件名称
	 *
	 * - extra: JSON; 附加字段。一些特定事件可能需要提供额外的参数
	 *
	 */
	function addEventListener(params: api_addEventListener_Params, callback:(ret, err) => void):void;

	interface api_removeEventListener_Params {
		/**自定义事件或系统事件名称（详见[事件](!Event)）*/ 
		name: string;

	}
	/**
	 * `移除事件监听`
	 * ========params==========
	 *
	 * `name` :string : 自定义事件或系统事件名称（详见[事件](!Event)）
	 */
	function removeEventListener(option: api_removeEventListener_Params):void;

	interface api_sendEvent_Params {
		/**任意自定义事件的名称，比如：apprunning、appover等*/ 
		name: string;

		/**（可选项）附带的参数。在监听页面的回调里面通过 ret.value 获取。*/ 
		extra: string;

	}
	/**
	 * `将任意一个自定义事件广播出去，该事件可在任意页面通过 addEventListener 监听收到。`
	 * ========params==========
	 *
	 * `name` :string : 任意自定义事件的名称，比如：apprunning、appover等
	 *
	 * `extra` :string : （可选项）附带的参数。在监听页面的回调里面通过 ret.value 获取。
	 */
	function sendEvent(option: api_sendEvent_Params):void;

	interface api_accessNative_Params {
		/**消息名称。*/ 
		name: string;

		/**（可选项）附带的参数。*/ 
		extra: JSON;

	}
	/**
	 * `使用 SuperWebView 时，js 向原生发送消息。此方法只在使用 SuperWebView 时有效。`
	 * ========params==========
	 *
	 * `name` :string : 消息名称。
	 *
	 * `extra` :JSON : （可选项）附带的参数。
	 */
	function accessNative(option: api_accessNative_Params):void;

	interface api_notification_Params {
		/**（可选项）伴随节奏的震动，时间数组，单位：毫秒。iOS平台震动时间为固定值；Android平台节奏为【等待-震动-等待-震动..】，例如[100, 500, 100, 500]表现效果为：等待100毫秒-震动500毫秒-等待100毫秒-震动500毫秒*/ 
		vibrate: Array;

		/**（可选项）提示音，默认为系统设置的提示音。Android支持传入widget协议音频文件，例如：widget://res/horse.mp3；当实现闹钟功能时，iOS只支持widget://路径协议*/ 
		sound: string;

		/**（可选项）设备提示灯是否闪烁*/ 
		light: boolean;

		/**（可选项）弹出通知到状态栏。弹出时是否震动或响铃，可通过设置vibrate，sound等字段配合实现。*/ 
		notify: JSON;

		/**（可选项）设置闹铃。与notify配合使用，即如果设置了闹铃，那么对应的notify将在设定的闹铃时间触发*/ 
		alarm: JSON;

	}
	/**
	 * `向用户发出震动、声音提示、灯光闪烁、手机状态栏通知等提示行为，支持闹钟功能。如果是状态栏通知，当用户点击该通知，页面可以通过监听 noticeclicked 事件获取该通知相关内容。`
	 * ========params==========
	 *
	 * `vibrate` :Array : （可选项）伴随节奏的震动，时间数组，单位：毫秒。iOS平台震动时间为固定值；Android平台节奏为【等待-震动-等待-震动..】，例如[100, 500, 100, 500]表现效果为：等待100毫秒-震动500毫秒-等待100毫秒-震动500毫秒
	 *
	 * `sound` :string : （可选项）提示音，默认为系统设置的提示音。Android支持传入widget协议音频文件，例如：widget://res/horse.mp3；当实现闹钟功能时，iOS只支持widget://路径协议
	 *
	 * `light` :boolean : （可选项）设备提示灯是否闪烁
	 *
	 * `notify` :JSON : （可选项）弹出通知到状态栏。弹出时是否震动或响铃，可通过设置vibrate，sound等字段配合实现。
	 *
	 * `alarm` :JSON : （可选项）设置闹铃。与notify配合使用，即如果设置了闹铃，那么对应的notify将在设定的闹铃时间触发
	 */
	function notification(option: api_notification_Params):void;

	interface api_cancelNotification_Params {
		/**（可选项）调用 notification 方法时返回的 id*/ 
		id: string;

	}
	/**
	 * `取消本应用弹出到状态栏的某个或所有通知，也可以清除设定的闹铃`
	 * ========params==========
	 *
	 * `id` :string : （可选项）调用 notification 方法时返回的 id
	 */
	function cancelNotification(option: api_cancelNotification_Params):void;

	interface api_startLocation_Params {
		/**（可选项）定位精度*/ 
		accuracy: string;

		/**（可选项）位置更新所需最小距离（单位米）*/ 
		filter: number;

		/**（可选项）获取到位置信息后是否自动停止定位*/ 
		autoStop: boolean;

	}
	/**
	 * `调用系统自带定位功能，开始定位`
	 * ========params==========
	 *
	 * `accuracy` :string : （可选项）定位精度
	 *
	 * `filter` :number : （可选项）位置更新所需最小距离（单位米）
	 *
	 * `autoStop` :boolean : （可选项）获取到位置信息后是否自动停止定位
	 */
	function startLocation(option: api_startLocation_Params):void;

	function stopLocation():void;

	function getLocation():void;

	interface api_startSensor_Params {
		/**传感器类型*/ 
		type: string;

	}
	/**
	 * `开启传感器`
	 * ========params==========
	 *
	 * `type` :string : 传感器类型
	 */
	function startSensor(option: api_startSensor_Params):void;

	interface api_stopSensor_Params {
		/**传感器类型（详见[传感器类型](!Constant#b2)常量）*/ 
		type: string;

	}
	/**
	 * `停止传感器`
	 * ========params==========
	 *
	 * `type` :string : 传感器类型（详见[传感器类型](!Constant#b2)常量）
	 */
	function stopSensor(option: api_stopSensor_Params):void;

	interface api_call_Params {
		/**（可选项）打电话类型*/ 
		type: string;

		/**电话号码*/ 
		number: string;

	}
	/**
	 * `拨打电话或进行faceTime`
	 * ========params==========
	 *
	 * `type` :string : （可选项）打电话类型
	 *
	 * `number` :string : 电话号码
	 */
	function call(option: api_call_Params):void;

	interface api_sms_Params {
		/**电话号码*/ 
		numbers: Array;

		/**文本内容*/ 
		text: string;

		/**（可选项）是否后台发送，只支持Android*/ 
		silent: boolean;

	}
	/**
	 * `调用系统短信界面发送短信，或者后台直接发送短信`
	 * ========params==========
	 *
	 * `numbers` :Array : 电话号码
	 *
	 * `text` :string : 文本内容
	 *
	 * `silent` :boolean : （可选项）是否后台发送，只支持Android
	 */
	function sms(option: api_sms_Params):void;

	interface api_mail_Params {
		/**收件人*/ 
		recipients: Array;

		/**邮件主题*/ 
		subject: string;

		/**（可选项）邮件内容*/ 
		body: string;

		/**（可选项）附件地址。支持fs://协议，以及其他模块或者api返回的路径，附件必须是位于设备公共存储空间，系统邮件APP能访问到的存储。*/ 
		attachments: Array;

	}
	/**
	 * `发送邮件`
	 * ========params==========
	 *
	 * `recipients` :Array : 收件人
	 *
	 * `subject` :string : 邮件主题
	 *
	 * `body` :string : （可选项）邮件内容
	 *
	 * `attachments` :Array : （可选项）附件地址。支持fs://协议，以及其他模块或者api返回的路径，附件必须是位于设备公共存储空间，系统邮件APP能访问到的存储。
	 */
	function mail(option: api_mail_Params):void;

	function openContacts():void;

	interface api_setFullScreen_Params {
		/**是否全屏*/ 
		fullScreen: boolean;

		/**在全屏时是否同时隐藏/显示虚拟按键栏。仅对带有虚拟按键栏的Android设备有效。*/ 
		optNav: boolean;

		/**（可选项）状态栏显示隐藏的动画效果，只iOS有效*/ 
		animation: string;

	}
	/**
	 * `设置是否全屏`
	 * ========params==========
	 *
	 * `fullScreen` :boolean : 是否全屏
	 *
	 * `optNav` :boolean : 在全屏时是否同时隐藏/显示虚拟按键栏。仅对带有虚拟按键栏的Android设备有效。
	 *
	 * `animation` :string : （可选项）状态栏显示隐藏的动画效果，只iOS有效
	 */
	function setFullScreen(option: api_setFullScreen_Params):void;

	interface api_setStatusBarStyle_Params {
		/**（可选项）状态栏样式，支持iOS，Android支持小米MIUI6.0及以上手机，魅族Flyme4.0及以上手机，其他Android6.0及以上手机。Android因设备厂商定制差异，频繁切换style不一定生效。*/ 
		style: string;

		/**（可选项）状态栏背景颜色，只 Android 5.0 及以上有效*/ 
		color: string;

		/**（可选项）虚拟按键栏背景颜色，只 Android 5.0 及以上且含虚拟按键栏的设备有效*/ 
		navBarColor: string;

		/**（可选项）是否有动画效果，只iOS有效*/ 
		animated: boolean;

	}
	/**
	 * `设置状态栏样式为白色（适用于深色背景）或黑色（适用于浅色背景），以及设置状态栏背景颜色`
	 * ========params==========
	 *
	 * `style` :string : （可选项）状态栏样式，支持iOS，Android支持小米MIUI6.0及以上手机，魅族Flyme4.0及以上手机，其他Android6.0及以上手机。Android因设备厂商定制差异，频繁切换style不一定生效。
	 *
	 * `color` :string : （可选项）状态栏背景颜色，只 Android 5.0 及以上有效
	 *
	 * `navBarColor` :string : （可选项）虚拟按键栏背景颜色，只 Android 5.0 及以上且含虚拟按键栏的设备有效
	 *
	 * `animated` :boolean : （可选项）是否有动画效果，只iOS有效
	 */
	function setStatusBarStyle(option: api_setStatusBarStyle_Params):void;

	interface api_setScreenOrientation_Params {
		/**旋转屏幕到指定方向，或根据重力感应自动旋转；当前为横屏时，若想只在横屏间根据重力切换，则可以传 auto_landscape，竖屏间切换则传 auto_portrait。*/ 
		orientation: string;

	}
	/**
	 * `设置屏幕旋转方向`
	 * ========params==========
	 *
	 * `orientation` :string : 旋转屏幕到指定方向，或根据重力感应自动旋转；当前为横屏时，若想只在横屏间根据重力切换，则可以传 auto_landscape，竖屏间切换则传 auto_portrait。
	 */
	function setScreenOrientation(option: api_setScreenOrientation_Params):void;

	interface api_setKeepScreenOn_Params {
		/**是否禁止屏幕休眠*/ 
		keepOn: boolean;

	}
	/**
	 * `设置是否禁止屏幕休眠`
	 * ========params==========
	 *
	 * `keepOn` :boolean : 是否禁止屏幕休眠
	 */
	function setKeepScreenOn(option: api_setKeepScreenOn_Params):void;

	function toLauncher():void;

	interface api_setScreenSecure_Params {
		/**是否禁止截屏*/ 
		secure: boolean;

	}
	/**
	 * `设置是否禁止截屏，只支持Android`
	 * ========params==========
	 *
	 * `secure` :boolean : 是否禁止截屏
	 */
	function setScreenSecure(option: api_setScreenSecure_Params):void;

	interface api_setAppIconBadge_Params {
		/**显示在应用图标右上角的数字。为0时表示清除应用图标上显示的数字*/ 
		badge: number;

	}
	/**
	 * `设置应用图标右上角数字，支持所有 iOS 手机，以及部分 Android 手机，如小米和三星的某些型号，不支持的设备，表现结果为调用该接口无任何效果`
	 * ========params==========
	 *
	 * `badge` :number : 显示在应用图标右上角的数字。为0时表示清除应用图标上显示的数字
	 */
	function setAppIconBadge(option: api_setAppIconBadge_Params):void;

	interface api_getPhoneNumber_Params {
		/**执行结果的返回方式。为false时通过callback返回，为true时直接返回。*/ 
		sync: boolean;

	}
	/**
	 * `获取本机电话号码，只支持 Android 部分手机`
	 * ========params==========
	 *
	 * `sync` :boolean : 执行结果的返回方式。为false时通过callback返回，为true时直接返回。
	 */
	function getPhoneNumber(option: api_getPhoneNumber_Params):void;

	interface api_hasPermission_Params {
		/**权限列表。*/ 
		list: Array;

	}
	interface api_hasPermission_ret {
		/** 权限名，字符串类型。*/ 
		name: string;

		/** 是否允许，如果从未请求过该权限或者用户未做出过选择时将返回false，布尔类型。*/ 
		granted: boolean;

		/** 是否从未请求过该权限或者用户未做出过选择，只支持iOS，注意：请求notification权限时无法获取该状态，布尔类型。*/ 
		undetermined: boolean;

		/** 该字段仅photos权限有效，表示访问相册是否有限制，当受限时，应用只能获取到用户在相册选定的那部分资源，只支持iOS 14及以上系统，布尔类型。*/ 
		limited: boolean;

		/** 该字段仅location、locationAlways有效，返回当前是否为模糊定位，只支持iOS 14及以上系统，布尔类型。在iOS 14以上系统中，用户可以选择只对应用授权模糊定位，如果应用对定位精度要求高，则可以在判断为模糊定位后请求locationFullAccuracy权限，系统将弹出开启精准定位弹框，用户可以再次进行选择。*/ 
		reducedAccuracy: boolean;

	}
	/**
	 * `hasPermission提供动态检测应用是否已取得某个或多个权限。`
	 * ========params==========
	 *
	 * `list` :Array : 权限列表。
	 */
	function hasPermission(option: api_hasPermission_Params):Array<api_hasPermission_ret>

	interface api_requestPermission_Params {
		/**权限列表。*/ 
		list: Array;

		/**请求跟踪码，用于回调结果，只支持Android。*/ 
		code: number;

		/**请求locationFullAccuracy权限的意图字段，在云编译界面添加“精确定位（临时）”权限时输入purposeKey及对应的权限使用描述，系统通过purposeKey找到对应的权限使用描述，然后在开启精确定位的弹框中将描述语展示给用户。*/ 
		purposeKey: string;

	}
	/**
	 * `向系统请求某个或多个权限。为帮助您更好的使用该接口，论坛维护了一个[示例](https://community.apicloud.com/bbs/thread-110959-1-1.html)。`
	 * ========params==========
	 *
	 * `list` :Array : 权限列表。
	 *
	 * `code` :number : 请求跟踪码，用于回调结果，只支持Android。
	 *
	 * `purposeKey` :string : 请求locationFullAccuracy权限的意图字段，在云编译界面添加“精确定位（临时）”权限时输入purposeKey及对应的权限使用描述，系统通过purposeKey找到对应的权限使用描述，然后在开启精确定位的弹框中将描述语展示给用户。
	 */
	function requestPermission(option: api_requestPermission_Params):void;

	function getInterfaceStyle():void;

	interface api_setInterfaceStyle_Params {
		/**（可选项）界面风格，取值范围：light、dark*/ 
		style: string;

		/**（可选项）要修改的目标范围，默认只作用于当前 widget，当值为 app 时表示应用内全局设置，取值范围：app、widget*/ 
		target: string;

	}
	/**
	 * `设置用户界面风格，只支持 iOS 13 及以上系统。`
	 * ========params==========
	 *
	 * `style` :string : （可选项）界面风格，取值范围：light、dark
	 *
	 * `target` :string : （可选项）要修改的目标范围，默认只作用于当前 widget，当值为 app 时表示应用内全局设置，取值范围：app、widget
	 */
	function setInterfaceStyle(option: api_setInterfaceStyle_Params):void;

	interface api_alert_Params {
		/**（可选项）标题*/ 
		title: string;

		/**（可选项）内容*/ 
		msg: string;

		/**（可选项）按钮*/ 
		buttons: Array;

	}
	/**
	 * `弹出带一个按钮的对话框，更多按钮的对话框请使用confirm方法`
	 * ========params==========
	 *
	 * `title` :string : （可选项）标题
	 *
	 * `msg` :string : （可选项）内容
	 *
	 * `buttons` :Array : （可选项）按钮
	 */
	function alert(option: api_alert_Params):void;

	interface api_confirm_Params {
		/**（可选项）标题*/ 
		title: string;

		/**（可选项）内容*/ 
		msg: string;

		/**（可选项）按钮标题，若小于两个按钮，会补齐两个按钮；若大于三个按钮，则使用前三个按钮*/ 
		buttons: Array;

	}
	/**
	 * `弹出带两个或三个按钮的confirm对话框`
	 * ========params==========
	 *
	 * `title` :string : （可选项）标题
	 *
	 * `msg` :string : （可选项）内容
	 *
	 * `buttons` :Array : （可选项）按钮标题，若小于两个按钮，会补齐两个按钮；若大于三个按钮，则使用前三个按钮
	 */
	function confirm(option: api_confirm_Params):void;

	interface api_prompt_Params {
		/**（可选项）标题*/ 
		title: string;

		/**（可选项）内容*/ 
		msg: string;

		/**（可选项）输入框里面的默认内容*/ 
		text: string;

		/**（可选项）输入类型，不同输入类型弹出键盘类型不同，取值范围（text、password、number、email、url）*/ 
		type: string;

		/**（可选项）按钮标题，若小于两个按钮，会补齐两个按钮；若大于三个按钮，则使用前三个按钮*/ 
		buttons: Array;

	}
	/**
	 * `弹出带两个或三个按钮和输入框的对话框`
	 * ========params==========
	 *
	 * `title` :string : （可选项）标题
	 *
	 * `msg` :string : （可选项）内容
	 *
	 * `text` :string : （可选项）输入框里面的默认内容
	 *
	 * `type` :string : （可选项）输入类型，不同输入类型弹出键盘类型不同，取值范围（text、password、number、email、url）
	 *
	 * `buttons` :Array : （可选项）按钮标题，若小于两个按钮，会补齐两个按钮；若大于三个按钮，则使用前三个按钮
	 */
	function prompt(option: api_prompt_Params):void;

	interface api_actionSheet_Params {
		/**（可选项）标题*/ 
		title: string;

		/**（可选项）取消按钮标题*/ 
		cancelTitle: string;

		/**（可选项）红色警示按钮标题，一般用于做一些删除之类操作*/ 
		destructiveTitle: string;

		/**（可选项）其它按钮*/ 
		buttons: Array;

		/**（可选项）样式设置，不传时使用默认样式*/ 
		style: JSON;

	}
	/**
	 * `底部弹出框`
	 * ========params==========
	 *
	 * `title` :string : （可选项）标题
	 *
	 * `cancelTitle` :string : （可选项）取消按钮标题
	 *
	 * `destructiveTitle` :string : （可选项）红色警示按钮标题，一般用于做一些删除之类操作
	 *
	 * `buttons` :Array : （可选项）其它按钮
	 *
	 * `style` :JSON : （可选项）样式设置，不传时使用默认样式
	 */
	function actionSheet(option: api_actionSheet_Params):void;

	interface api_showProgress_Params {
		/**（可选项）进度提示框风格*/ 
		style: string;

		/**（可选项）进度提示框动画类型*/ 
		animationType: string;

		/**（可选项）标题*/ 
		title: string;

		/**（可选项）内容*/ 
		text: string;

		/**（可选项）是否模态，模态时整个页面将不可交互*/ 
		modal: boolean;

	}
	/**
	 * `显示进度提示框`
	 * ========params==========
	 *
	 * `style` :string : （可选项）进度提示框风格
	 *
	 * `animationType` :string : （可选项）进度提示框动画类型
	 *
	 * `title` :string : （可选项）标题
	 *
	 * `text` :string : （可选项）内容
	 *
	 * `modal` :boolean : （可选项）是否模态，模态时整个页面将不可交互
	 */
	function showProgress(option: api_showProgress_Params):void;

	function hideProgress():void;

	interface api_toast_Params {
		/**提示消息*/ 
		msg: string;

		/**（可选项）持续时长，单位：毫秒*/ 
		duration: number;

		/**（可选项）弹出位置，顶部、中间或底部*/ 
		location: string;

		/**（可选项）是否是全局的toast。若为false，toast将只在当前window范围可见；若为true，安卓手机上面弹出的位置将会固定在底部区域，同时duration参数被忽略，由系统决定何时关闭。*/ 
		global: boolean;

	}
	/**
	 * `弹出一个定时自动关闭的提示框`
	 * ========params==========
	 *
	 * `msg` :string : 提示消息
	 *
	 * `duration` :number : （可选项）持续时长，单位：毫秒
	 *
	 * `location` :string : （可选项）弹出位置，顶部、中间或底部
	 *
	 * `global` :boolean : （可选项）是否是全局的toast。若为false，toast将只在当前window范围可见；若为true，安卓手机上面弹出的位置将会固定在底部区域，同时duration参数被忽略，由系统决定何时关闭。
	 */
	function toast(option: api_toast_Params):void;

	interface api_openPicker_Params {
		/**拾取器类型*/ 
		type: string;

		/**（可选项）时间格式化字符串，格式yyyy-MM-dd HH:mm*/ 
		date: string;

		/**（可选项）能够选择的最小时间，格式yyyy-MM-dd HH:mm，只iOS有效*/ 
		minDate: string;

		/**（可选项）能够选择的最大时间，格式yyyy-MM-dd HH:mm，只iOS有效*/ 
		maxDate: string;

		/**（可选项）显示在拾取器上面的标题*/ 
		title: string;

		/**（可选项）iPad中显示时，箭头指向的位置，只iPad有效*/ 
		arrowRect: JSON;

		/**（可选项）iPad中显示时，箭头指向的方向，只iPad有效*/ 
		arrowDirection: string;

	}
	/**
	 * `打开时间选择器`
	 * ========params==========
	 *
	 * `type` :string : 拾取器类型
	 *
	 * `date` :string : （可选项）时间格式化字符串，格式yyyy-MM-dd HH:mm
	 *
	 * `minDate` :string : （可选项）能够选择的最小时间，格式yyyy-MM-dd HH:mm，只iOS有效
	 *
	 * `maxDate` :string : （可选项）能够选择的最大时间，格式yyyy-MM-dd HH:mm，只iOS有效
	 *
	 * `title` :string : （可选项）显示在拾取器上面的标题
	 *
	 * `arrowRect` :JSON : （可选项）iPad中显示时，箭头指向的位置，只iPad有效
	 *
	 * `arrowDirection` :string : （可选项）iPad中显示时，箭头指向的方向，只iPad有效
	 */
	function openPicker(option: api_openPicker_Params):void;

	interface api_setRefreshHeaderInfo_Params {
		/**（可选项）是否可见*/ 
		visible: boolean;

		/**（可选项）背景颜色*/ 
		bgColor: string;

		/**（可选项）进度条的颜色，defaultRefreshHeader为swipe时生效。*/ 
		pathColor: string;

		/**（可选项）上拉下拉时的图片地址，defaultRefreshHeader为pull时生效。*/ 
		loadingImg: string;

		/**（可选项）文本颜色，defaultRefreshHeader为pull时生效。*/ 
		textColor: string;

		/**（可选项）普通状态文字描述，defaultRefreshHeader为pull时生效。*/ 
		textDown: string;

		/**（可选项）下拉达到加载状态阈值时文字描述，defaultRefreshHeader为pull时生效。*/ 
		textUp: string;

		/**（可选项）加载状态文字描述，defaultRefreshHeader为pull时生效。*/ 
		textLoading: string;

		/**（可选项）更新时间文字描述，defaultRefreshHeader为pull时生效。*/ 
		textTime: string;

		/**（可选项）是否显示更新时间，defaultRefreshHeader为pull时生效。*/ 
		showTime: boolean;

	}
	/**
	 * `显示默认下拉刷新组件，使用默认下拉刷新组件时会自动重新设置页面的弹动属性。`
	 * ========params==========
	 *
	 * `visible` :boolean : （可选项）是否可见
	 *
	 * `bgColor` :string : （可选项）背景颜色
	 *
	 * `pathColor` :string : （可选项）进度条的颜色，defaultRefreshHeader为swipe时生效。
	 *
	 * `loadingImg` :string : （可选项）上拉下拉时的图片地址，defaultRefreshHeader为pull时生效。
	 *
	 * `textColor` :string : （可选项）文本颜色，defaultRefreshHeader为pull时生效。
	 *
	 * `textDown` :string : （可选项）普通状态文字描述，defaultRefreshHeader为pull时生效。
	 *
	 * `textUp` :string : （可选项）下拉达到加载状态阈值时文字描述，defaultRefreshHeader为pull时生效。
	 *
	 * `textLoading` :string : （可选项）加载状态文字描述，defaultRefreshHeader为pull时生效。
	 *
	 * `textTime` :string : （可选项）更新时间文字描述，defaultRefreshHeader为pull时生效。
	 *
	 * `showTime` :boolean : （可选项）是否显示更新时间，defaultRefreshHeader为pull时生效。
	 */
	function setRefreshHeaderInfo(option: api_setRefreshHeaderInfo_Params):void;

	function setCustomRefreshHeaderInfo():void;

	function refreshHeaderLoading():void;

	function refreshHeaderLoadDone():void;

	interface api_setRefreshFooterInfo_Params {
		/**（可选项）是否可见*/ 
		visible: boolean;

		/**（可选项）背景颜色*/ 
		bgColor: string;

		/**（可选项）上拉下拉时的图片地址，如果传入的是无效的图片地址则不显示图片。*/ 
		loadingImg: string;

		/**（可选项）文本颜色。*/ 
		textColor: string;

		/**（可选项）普通状态时的文字描述。*/ 
		textDown: string;

		/**（可选项）上拉达到加载状态阈值时文字描述。*/ 
		textUp: string;

		/**（可选项）加载状态文字描述。*/ 
		textLoading: string;

		/**（可选项）更新时间文字描述。*/ 
		textTime: string;

		/**（可选项）是否显示更新时间。*/ 
		showTime: boolean;

	}
	/**
	 * `显示上拉加载组件，使用时会自动重新设置页面的弹动属性。`
	 * ========params==========
	 *
	 * `visible` :boolean : （可选项）是否可见
	 *
	 * `bgColor` :string : （可选项）背景颜色
	 *
	 * `loadingImg` :string : （可选项）上拉下拉时的图片地址，如果传入的是无效的图片地址则不显示图片。
	 *
	 * `textColor` :string : （可选项）文本颜色。
	 *
	 * `textDown` :string : （可选项）普通状态时的文字描述。
	 *
	 * `textUp` :string : （可选项）上拉达到加载状态阈值时文字描述。
	 *
	 * `textLoading` :string : （可选项）加载状态文字描述。
	 *
	 * `textTime` :string : （可选项）更新时间文字描述。
	 *
	 * `showTime` :boolean : （可选项）是否显示更新时间。
	 */
	function setRefreshFooterInfo(option: api_setRefreshFooterInfo_Params):void;

	function refreshFooterLoadDone():void;

	interface api_showFloatBox_Params {
		/**（可选项）是否阻止默认行为，若传true，可以在回调方法里面处理悬浮框点击操作。默认的行为：1、在主widget调用该方法无效 2、点击后会弹出退出应用提示*/ 
		preventDefault: boolean;

		/**（可选项）展示在悬浮框中的图片地址*/ 
		iconPath: string;

		/**（可选项）自动消隐时长。在该时长内不发生触摸悬浮框行为，悬浮框自动消隐至半透状态*/ 
		duration: string;

	}
	/**
	 * `展示一个悬浮框，浮动在屏幕上。`
	 * ========params==========
	 *
	 * `preventDefault` :boolean : （可选项）是否阻止默认行为，若传true，可以在回调方法里面处理悬浮框点击操作。默认的行为：1、在主widget调用该方法无效 2、点击后会弹出退出应用提示
	 *
	 * `iconPath` :string : （可选项）展示在悬浮框中的图片地址
	 *
	 * `duration` :string : （可选项）自动消隐时长。在该时长内不发生触摸悬浮框行为，悬浮框自动消隐至半透状态
	 */
	function showFloatBox(option: api_showFloatBox_Params):void;

	interface api_setMenuItems_Params {
		/**自定义菜单项。自定义菜单项会添加到系统默认菜单项的后面。*/ 
		customItems: Array;

		/**（可选项）系统菜单项。如果不传该参数，则会显示系统菜单项，自定义菜单项会添加到系统菜单项后面；如果传空数组，则不显示系统菜单项；如果传了非空数组，则显示传入的系统菜单。注意：不同系统版本的系统默认菜单项可能会有所不同，会存在无法屏蔽某些系统菜单的情况。*/ 
		systemItems: Array;

	}
	/**
	 * `设置选择文字弹出菜单。`
	 * ========params==========
	 *
	 * `customItems` :Array : 自定义菜单项。自定义菜单项会添加到系统默认菜单项的后面。
	 *
	 * `systemItems` :Array : （可选项）系统菜单项。如果不传该参数，则会显示系统菜单项，自定义菜单项会添加到系统菜单项后面；如果传空数组，则不显示系统菜单项；如果传了非空数组，则显示传入的系统菜单。注意：不同系统版本的系统默认菜单项可能会有所不同，会存在无法屏蔽某些系统菜单的情况。
	 */
	function setMenuItems(option: api_setMenuItems_Params):void;

	interface api_screenLayerFilter_Params {
		/**要设置的屏幕区域范围，默认为当前页面区域。*/ 
		region: string;

		/**设置饱和度，通常用于实现黑白等效果，取值范围0~1，0为黑，1为全彩*/ 
		sat: number;

	}
	/**
	 * `设置屏幕滤镜，可实现特殊日子灰白效果。`
	 * ========params==========
	 *
	 * `region` :string : 要设置的屏幕区域范围，默认为当前页面区域。
	 *
	 * `sat` :number : 设置饱和度，通常用于实现黑白等效果，取值范围0~1，0为黑，1为全彩
	 */
	function screenLayerFilter(option: api_screenLayerFilter_Params):void;

	interface api_getPicture_Params {
		/**（可选项）图片源类型，从相册、图片库或相机获取图片*/ 
		sourceType: string;

		/**（可选项）返回图片类型，jpg或png*/ 
		encodingType: string;

		/**（可选项）媒体类型，图片或视频*/ 
		mediaValue: string;

		/**（可选项）返回数据类型，指定返回图片地址或图片经过base64编码后的字符串*/ 
		destinationType: string;

		/**（可选项）选择前置或后置摄像头，取值范围（front、rear），只支持iOS*/ 
		direction: string;

		/**（可选项）是否可以选择图片后进行编辑，支持iOS及部分安卓手机*/ 
		allowEdit: boolean;

		/**（可选项）是否选择图片后进行预览，只支持iOS。*/ 
		preview: boolean;

		/**（可选项）图片质量，只针对jpg格式图片（0-100整数）*/ 
		quality: number;

		/**（可选项）视频质量，调用相机录制视频时该参数生效。取值范围(low、medium、high)，质量越高，录制的视频文件占用存储空间越大。*/ 
		videoQuality: string;

		/**（可选项）压缩后的图片宽度，图片会按比例适配此宽度*/ 
		targetWidth: number;

		/**（可选项）压缩后的图片高度，图片会按比例适配此高度*/ 
		targetHeight: number;

		/**（可选项）拍照或录制视频后是否保存到系统相册目录。注意此处仅是文件系统层面的操作，使用诸如“图库”App仍然有可能查看到。*/ 
		saveToPhotoAlbum: boolean;

		/**（可选项）保存图片到自定义分组相册目录，相册不存在则会进行创建。*/ 
		groupName: string;

	}
	/**
	 * `通过调用系统默认相机或者图库应用，获取图片以及视频媒体文件。`
	 * ========params==========
	 *
	 * `sourceType` :string : （可选项）图片源类型，从相册、图片库或相机获取图片
	 *
	 * `encodingType` :string : （可选项）返回图片类型，jpg或png
	 *
	 * `mediaValue` :string : （可选项）媒体类型，图片或视频
	 *
	 * `destinationType` :string : （可选项）返回数据类型，指定返回图片地址或图片经过base64编码后的字符串
	 *
	 * `direction` :string : （可选项）选择前置或后置摄像头，取值范围（front、rear），只支持iOS
	 *
	 * `allowEdit` :boolean : （可选项）是否可以选择图片后进行编辑，支持iOS及部分安卓手机
	 *
	 * `preview` :boolean : （可选项）是否选择图片后进行预览，只支持iOS。
	 *
	 * `quality` :number : （可选项）图片质量，只针对jpg格式图片（0-100整数）
	 *
	 * `videoQuality` :string : （可选项）视频质量，调用相机录制视频时该参数生效。取值范围(low、medium、high)，质量越高，录制的视频文件占用存储空间越大。
	 *
	 * `targetWidth` :number : （可选项）压缩后的图片宽度，图片会按比例适配此宽度
	 *
	 * `targetHeight` :number : （可选项）压缩后的图片高度，图片会按比例适配此高度
	 *
	 * `saveToPhotoAlbum` :boolean : （可选项）拍照或录制视频后是否保存到系统相册目录。注意此处仅是文件系统层面的操作，使用诸如“图库”App仍然有可能查看到。
	 *
	 * `groupName` :string : （可选项）保存图片到自定义分组相册目录，相册不存在则会进行创建。
	 */
	function getPicture(option: api_getPicture_Params):void;

	interface api_saveMediaToAlbum_Params {
		/**文件路径，支持网络链接地址、fs://、widget://等扩展文件路径协议，本地文件路径必须带有扩展名*/ 
		path: string;

		/**（可选项）保存图片到自定义分组相册目录，相册不存在则会进行创建。*/ 
		groupName: string;

	}
	/**
	 * `保存图片和视频到系统相册`
	 * ========params==========
	 *
	 * `path` :string : 文件路径，支持网络链接地址、fs://、widget://等扩展文件路径协议，本地文件路径必须带有扩展名
	 *
	 * `groupName` :string : （可选项）保存图片到自定义分组相册目录，相册不存在则会进行创建。
	 */
	function saveMediaToAlbum(option: api_saveMediaToAlbum_Params):void;

	interface api_screenCapture_Params {
		/**要截取的屏幕区域范围，默认为当前页面区域。*/ 
		region: string;

		/**数据返回类型。*/ 
		destinationType: string;

	}
	/**
	 * `屏幕截取，可截取整个屏幕、当前页面、avm 页面指定元素等。`
	 * ========params==========
	 *
	 * `region` :string : 要截取的屏幕区域范围，默认为当前页面区域。
	 *
	 * `destinationType` :string : 数据返回类型。
	 */
	function screenCapture(option: api_screenCapture_Params):void;

	interface api_startRecord_Params {
		/**（可选项）文件路径，不传时自动创建路径*/ 
		path: string;

		/**（可选项）音频格式*/ 
		format: string;

	}
	/**
	 * `录制音频`
	 * ========params==========
	 *
	 * `path` :string : （可选项）文件路径，不传时自动创建路径
	 *
	 * `format` :string : （可选项）音频格式
	 */
	function startRecord(option: api_startRecord_Params):void;

	function stopRecord():void;

	interface api_startPlay_Params {
		/**音频地址，支持fs://、widget://等本地文件路径协议，支持网络地址*/ 
		path: string;

	}
	/**
	 * `播放音频，支持 amr 格式。`
	 * ========params==========
	 *
	 * `path` :string : 音频地址，支持fs://、widget://等本地文件路径协议，支持网络地址
	 */
	function startPlay(option: api_startPlay_Params):void;

	function pausePlay():void;

	function stopPlay():void;

	interface api_openVideo_Params {
		/**本地文件路径（支持fs://路径协议）或者网络资源地址*/ 
		url: string;

	}
	/**
	 * `打开系统视频播放器`
	 * ========params==========
	 *
	 * `url` :string : 本地文件路径（支持fs://路径协议）或者网络资源地址
	 */
	function openVideo(option: api_openVideo_Params):void;

	function require(moduleName: 'muPDF'): muPDF;

	function require(moduleName: 'mailUtils'): mailUtils;

	function require(moduleName: 'helper'): helper;

	function require(moduleName: 'phoneStatusOB'): phoneStatusOB;

	function require(moduleName: 'vpnIOS'): vpnIOS;

	function require(moduleName: 'jlLangDetect'): jlLangDetect;

	function require(moduleName: 'fileDetect'): fileDetect;

	function require(moduleName: 'sendMail'): sendMail;

	function require(moduleName: 'audioTrans'): audioTrans;

	function require(moduleName: 'imageHandle'): imageHandle;

	function require(moduleName: 'callLog'): callLog;

	function require(moduleName: 'moduleXdlScan'): moduleXdlScan;

	function require(moduleName: 'QRScan'): QRScan;

	function require(moduleName: 'fs'): fs;

	function require(moduleName: 'checknotification'): checknotification;

	function require(moduleName: 'NSUserDefaults'): NSUserDefaults;

	function require(moduleName: 'cameraQQ'): cameraQQ;

	function require(moduleName: 'preSensor'): preSensor;

	function require(moduleName: 'websocketClient'): websocketClient;

	function require(moduleName: 'AudioSession'): AudioSession;

	function require(moduleName: 'keychain'): keychain;

	function require(moduleName: 'ACTencentCOS'): ACTencentCOS;

	function require(moduleName: 'compactPicture'): compactPicture;

	function require(moduleName: 'moduleAppScore'): moduleAppScore;

	function require(moduleName: 'UIImageEdit'): UIImageEdit;

	function require(moduleName: 'videoKit'): videoKit;

	function require(moduleName: 'lightStyle'): lightStyle;

	function require(moduleName: 'mMarket'): mMarket;

	function require(moduleName: 'musicList'): musicList;

	function require(moduleName: 'switchLoudspeaker'): switchLoudspeaker;

	function require(moduleName: 'UDPSocket'): UDPSocket;

	function require(moduleName: 'imagePalette'): imagePalette;

	function require(moduleName: 'appshortcut'): appshortcut;

	function require(moduleName: 'qiniuStorage'): qiniuStorage;

	function require(moduleName: 'backGroundAudioPlayer'): backGroundAudioPlayer;

	function require(moduleName: 'pictureWatermark'): pictureWatermark;

	function require(moduleName: 'imrCamera'): imrCamera;

	function require(moduleName: 'zyHmsScan'): zyHmsScan;

	function require(moduleName: 'androidEmail'): androidEmail;

	function require(moduleName: 'sqlCipher'): sqlCipher;

	function require(moduleName: 'recentPic'): recentPic;

	function require(moduleName: 'FNImageClip'): FNImageClip;

	function require(moduleName: 'SDWebImage'): SDWebImage;

	function require(moduleName: 'imageCutOut'): imageCutOut;

	function require(moduleName: 'fileBrowser'): fileBrowser;

	function require(moduleName: 'cocoVideo'): cocoVideo;

	function require(moduleName: 'webToImage'): webToImage;

	function require(moduleName: 'zxycamera'): zxycamera;

	function require(moduleName: 'webCapturer'): webCapturer;

	function require(moduleName: 'wifiServer'): wifiServer;

	function require(moduleName: 'trans'): trans;

	function require(moduleName: 'netTools'): netTools;

	function require(moduleName: 'launchImage'): launchImage;

	function require(moduleName: 'presentation'): presentation;

	function require(moduleName: 'phoneListener'): phoneListener;

	function require(moduleName: 'acc5Util'): acc5Util;

	function require(moduleName: 'myTimer'): myTimer;

	function require(moduleName: 'notificationUtil'): notificationUtil;

	function require(moduleName: 'vPlayer'): vPlayer;

	function require(moduleName: 'qn'): qn;

	function require(moduleName: 'micoMqtt'): micoMqtt;

	function require(moduleName: 'bdObjectStorage'): bdObjectStorage;

	function require(moduleName: 'shortcutCreator'): shortcutCreator;

	function require(moduleName: 'ftpServer'): ftpServer;

	function require(moduleName: 'lockControler'): lockControler;

	function require(moduleName: 'zip'): zip;

	function require(moduleName: 'appManage'): appManage;

	function require(moduleName: 'wmVideoRecorder'): wmVideoRecorder;

	function require(moduleName: 'browser'): browser;

	function require(moduleName: 'videoTool'): videoTool;

	function require(moduleName: 'mp3Recorder'): mp3Recorder;

	function require(moduleName: 'widgetPlan'): widgetPlan;

	function require(moduleName: 'volume'): volume;

	function require(moduleName: 'acWebsocket'): acWebsocket;

	function require(moduleName: 'setJumpNew'): setJumpNew;

	function require(moduleName: 'mobcommonlib'): mobcommonlib;

	function require(moduleName: 'makeSharePic'): makeSharePic;

	function require(moduleName: 'tvcontrol'): tvcontrol;

	function require(moduleName: 'wlnotice'): wlnotice;

	function require(moduleName: 'miniAudio'): miniAudio;

	function require(moduleName: 'sysPrintPlus'): sysPrintPlus;

	function require(moduleName: 'phoneInfoPlus'): phoneInfoPlus;

	function require(moduleName: 'ARRuler'): ARRuler;

	function require(moduleName: 'patternLock'): patternLock;

	function require(moduleName: 'soundPlayer'): soundPlayer;

	function require(moduleName: 'xyTimeout'): xyTimeout;

	function require(moduleName: 'netSpeed'): netSpeed;

	function require(moduleName: 'reachability'): reachability;

	function require(moduleName: 'cacheManager'): cacheManager;

	function require(moduleName: 'easyShareImages'): easyShareImages;

	function require(moduleName: 'colorGain'): colorGain;

	function require(moduleName: 'fileScan'): fileScan;

	function require(moduleName: 'videoMerge'): videoMerge;

	function require(moduleName: 'svideo'): svideo;

	function require(moduleName: 'floatView'): floatView;

	function require(moduleName: 'bookReader'): bookReader;

	function require(moduleName: 'softInputMgr'): softInputMgr;

	function require(moduleName: 'screenLock'): screenLock;

	function require(moduleName: 'videoScreenshots'): videoScreenshots;

	function require(moduleName: 'judgeNotification'): judgeNotification;

	function require(moduleName: 'replay'): replay;

	function require(moduleName: 'm3u8Downloader'): m3u8Downloader;

	function require(moduleName: 'audioStreamer'): audioStreamer;

	function require(moduleName: 'hwOBS'): hwOBS;

	function require(moduleName: 'openContacts'): openContacts;

	function require(moduleName: 'sysPrint'): sysPrint;

	function require(moduleName: 'ybxIDCardRead'): ybxIDCardRead;

	function require(moduleName: 'photoBrowser'): photoBrowser;

	function require(moduleName: 'mySqlUtils'): mySqlUtils;

	function require(moduleName: 'MCBluetooth'): MCBluetooth;

	function require(moduleName: 'batteryManager'): batteryManager;

	function require(moduleName: 'mtlPrint'): mtlPrint;

	function require(moduleName: 'UIFoxitPDF'): UIFoxitPDF;

	function require(moduleName: 'myWebSocket'): myWebSocket;

	function require(moduleName: 'imageEdit'): imageEdit;

	function require(moduleName: 'screenClip'): screenClip;

	function require(moduleName: 'sortList'): sortList;

	function require(moduleName: 'iNoRobot'): iNoRobot;

	function require(moduleName: 'sapSso'): sapSso;

	function require(moduleName: 'imageOptim'): imageOptim;

	function require(moduleName: 'yingmeiPrinter'): yingmeiPrinter;

	function require(moduleName: 'audioCombine'): audioCombine;

	function require(moduleName: 'touchDebugger'): touchDebugger;

	function require(moduleName: 'Apple'): Apple;

	function require(moduleName: 'zipModule'): zipModule;

	function require(moduleName: 'baseService'): baseService;

	function require(moduleName: 'photoSelect'): photoSelect;

	function require(moduleName: 'pdfViewer'): pdfViewer;

	function require(moduleName: 'imageColorParser'): imageColorParser;

	function require(moduleName: 'soundDetection'): soundDetection;

	function require(moduleName: 'moduleGaoDeNavi'): moduleGaoDeNavi;

	function require(moduleName: 'uimusic'): uimusic;

	function require(moduleName: 'audioPlayer'): audioPlayer;

	function require(moduleName: 'richText'): richText;

	function require(moduleName: 'cardReader'): cardReader;

	function require(moduleName: 'thumbnailUtil'): thumbnailUtil;

	function require(moduleName: 'checkProxy'): checkProxy;

	function require(moduleName: 'playerCut'): playerCut;

	function require(moduleName: 'editorText'): editorText;

	function require(moduleName: 'fileInfo'): fileInfo;

	function require(moduleName: 'touping'): touping;

	function require(moduleName: 'videoCompression'): videoCompression;

	function require(moduleName: 'mySQL'): mySQL;

	function require(moduleName: 'shootPicture'): shootPicture;

	function require(moduleName: 'mosaic'): mosaic;

	function require(moduleName: 'webSocket'): webSocket;

	function require(moduleName: 'cardcamera'): cardcamera;

	function require(moduleName: 'nativeTimer'): nativeTimer;

	function require(moduleName: 'xxtea'): xxtea;

	function require(moduleName: 'imageClipTools'): imageClipTools;

	function require(moduleName: 'epubReader'): epubReader;

	function require(moduleName: 'LBAirDrop'): LBAirDrop;

	function require(moduleName: 'posterBuilder'): posterBuilder;

	function require(moduleName: 'privacy'): privacy;

	function require(moduleName: 'phoneNumber'): phoneNumber;

	function require(moduleName: 'autoStartUp'): autoStartUp;

	function require(moduleName: 'mobilePrint'): mobilePrint;

	function require(moduleName: 'youboScan'): youboScan;

	function require(moduleName: 'pasteboard'): pasteboard;

	function require(moduleName: 'docReader'): docReader;

	function require(moduleName: 'DRMScreenShot'): DRMScreenShot;

	function require(moduleName: 'hwScanner'): hwScanner;

	function require(moduleName: 'networkIndicator'): networkIndicator;

	function require(moduleName: 'audioRecorder'): audioRecorder;

	function require(moduleName: 'idfa'): idfa;

	function require(moduleName: 'upYun'): upYun;

	function require(moduleName: 'alarmNotification'): alarmNotification;

	function require(moduleName: 'tutu'): tutu;

	function require(moduleName: 'FNPhotograph'): FNPhotograph;

	function require(moduleName: 'appmanager'): appmanager;

	function require(moduleName: 'baseTools'): baseTools;

	function require(moduleName: 'UserDefault'): UserDefault;

	function require(moduleName: 'sunmiT1Screen'): sunmiT1Screen;

	function require(moduleName: 'alarmHelper'): alarmHelper;

	function require(moduleName: 'install'): install;

	function require(moduleName: 'fileReader'): fileReader;

	function require(moduleName: 'aliyunOSS'): aliyunOSS;

	function require(moduleName: 'openAppPlus'): openAppPlus;

	function require(moduleName: 'macauPay'): macauPay;

	function require(moduleName: 'fivegswitcher'): fivegswitcher;

	function require(moduleName: 'pdfTrans'): pdfTrans;

	function require(moduleName: 'iTVBox'): iTVBox;

	function require(moduleName: 'audio'): audio;

	function require(moduleName: 'sunmiPrinterInner'): sunmiPrinterInner;

	function require(moduleName: 'tencentCos'): tencentCos;

	function require(moduleName: 'serialPortPlus'): serialPortPlus;

	function require(moduleName: 'takePicCutOut'): takePicCutOut;

	function require(moduleName: 'shortCut'): shortCut;

	function require(moduleName: 'weChatCamera'): weChatCamera;

	function require(moduleName: 'aliyunStsOss'): aliyunStsOss;

	function require(moduleName: 'mtlFile'): mtlFile;

	function require(moduleName: 'readCard'): readCard;

	function require(moduleName: 'epub'): epub;

	function require(moduleName: 'checkpush'): checkpush;

	function require(moduleName: 'fAppInfo'): fAppInfo;

	function require(moduleName: 'signature'): signature;

	function require(moduleName: 'kmTimer'): kmTimer;

	function require(moduleName: 'djyPrinter'): djyPrinter;

	function require(moduleName: 'selectFile'): selectFile;

	function require(moduleName: 'whjpdf'): whjpdf;

	function require(moduleName: 'codeLog'): codeLog;

	function require(moduleName: 'androidTTS'): androidTTS;

	function require(moduleName: 'xpCheck'): xpCheck;

	function require(moduleName: 'inShare'): inShare;

	function require(moduleName: 'setJump'): setJump;

	function require(moduleName: 'brightness'): brightness;

	function require(moduleName: 'ScreenWake'): ScreenWake;

	function require(moduleName: 'recordForMP3'): recordForMP3;

	function require(moduleName: 'gifTools'): gifTools;

	function require(moduleName: 'getWebUrl'): getWebUrl;

	function require(moduleName: 'ftpRequest'): ftpRequest;

	function require(moduleName: 'drawingBoard'): drawingBoard;

	function require(moduleName: 'oxSocket'): oxSocket;

	function require(moduleName: 'imageSelect'): imageSelect;

	function require(moduleName: 'volcWebImage'): volcWebImage;

	function require(moduleName: 'm3u8CacheServer'): m3u8CacheServer;

	function require(moduleName: 'floatWebView'): floatWebView;

	function require(moduleName: 'headphone'): headphone;

	function require(moduleName: 'floatNowTimer'): floatNowTimer;

	function require(moduleName: 'baiduBos'): baiduBos;

	function require(moduleName: 'msSQL'): msSQL;

	function require(moduleName: 'readId'): readId;

	function require(moduleName: 'webSocket2018'): webSocket2018;

	function require(moduleName: 'broadcastList'): broadcastList;

	function require(moduleName: 'moviePlayer'): moviePlayer;

	function require(moduleName: 'TCSuperPlayer'): TCSuperPlayer;

	function require(moduleName: 'vrPlayer'): vrPlayer;

	function require(moduleName: 'monitorFilesChange'): monitorFilesChange;

	function require(moduleName: 'dlna'): dlna;

	function require(moduleName: 'encryption'): encryption;

	function require(moduleName: 'playText'): playText;

	function require(moduleName: 'codeTools'): codeTools;

	function require(moduleName: 'yyWebImage'): yyWebImage;

	function require(moduleName: 'qiniuKodo'): qiniuKodo;

	function require(moduleName: 'apkInstall'): apkInstall;

	function require(moduleName: 'phoneInfoMore'): phoneInfoMore;

	function require(moduleName: 'moduleAppList'): moduleAppList;

	function require(moduleName: 'tencentUGCUpload'): tencentUGCUpload;

	function require(moduleName: 'webServer'): webServer;

	function require(moduleName: 'downloadManager2'): downloadManager2;

	function require(moduleName: 'playModule'): playModule;

	function require(moduleName: 'circleMenu'): circleMenu;

	function require(moduleName: 'docInteraction'): docInteraction;

	function require(moduleName: 'appUtils'): appUtils;

	function require(moduleName: 'codeScan'): codeScan;

	function require(moduleName: 'jumpbrowser'): jumpbrowser;

	function require(moduleName: 'QCloudCOS'): QCloudCOS;

	function require(moduleName: 'hwTxtReader'): hwTxtReader;

	function require(moduleName: 'videoTrans'): videoTrans;

	function require(moduleName: 'zySmallVideo'): zySmallVideo;

	function require(moduleName: 'keepingAppAlive'): keepingAppAlive;

	function require(moduleName: 'inFile'): inFile;

	function require(moduleName: 'screenRecording'): screenRecording;

	function require(moduleName: 'airPlay'): airPlay;

	function require(moduleName: 'androidShortcut'): androidShortcut;

	function require(moduleName: 'currentApp'): currentApp;

	function require(moduleName: 'iconToImage'): iconToImage;

	function require(moduleName: 'photoPicker'): photoPicker;

	function require(moduleName: 'floatWords'): floatWords;

	function require(moduleName: 'changeIcon'): changeIcon;

	function require(moduleName: 'netTime'): netTime;

	function require(moduleName: 'scrollVideoBd'): scrollVideoBd;

	function require(moduleName: 'promotionLink'): promotionLink;

	function require(moduleName: 'arcColorPicker'): arcColorPicker;

	function require(moduleName: 'tencentOSS'): tencentOSS;

	function require(moduleName: 'recordScreen'): recordScreen;

	function require(moduleName: 'AppStoreGrade'): AppStoreGrade;

	function require(moduleName: 'magnifier'): magnifier;

	function require(moduleName: 'downloadManager'): downloadManager;

	function require(moduleName: 'vtingPlayer'): vtingPlayer;

	function require(moduleName: 'easyVideoCompression'): easyVideoCompression;

	function require(moduleName: 'cameraView'): cameraView;

	function require(moduleName: 'getFile'): getFile;

	function require(moduleName: 'planNotify'): planNotify;

	function require(moduleName: 'dvMonitor'): dvMonitor;

	function require(moduleName: 'audioCover'): audioCover;

	function require(moduleName: 'mobtools'): mobtools;

	function require(moduleName: 'imageCrop'): imageCrop;

	function require(moduleName: 'APKCheck'): APKCheck;

	function require(moduleName: 'ACScanner'): ACScanner;

	function require(moduleName: 'videoRecorder'): videoRecorder;

	function require(moduleName: 'huaweiObs'): huaweiObs;

	function require(moduleName: 'startupObject'): startupObject;

	function require(moduleName: 'vtb'): vtb;

	function require(moduleName: 'aliCloudOss'): aliCloudOss;

	function require(moduleName: 'openAppStore'): openAppStore;

	function require(moduleName: 'dkplayer'): dkplayer;

	function require(moduleName: 'netAudio'): netAudio;

	function require(moduleName: 'scanner'): scanner;

	function require(moduleName: 'iap'): iap;

	function require(moduleName: 'shareTool'): shareTool;

	function require(moduleName: 'imageEXIF'): imageEXIF;

	function require(moduleName: 'plateRecognize'): plateRecognize;

	function require(moduleName: 'yxsConversation'): yxsConversation;

	function require(moduleName: 'wallPaper'): wallPaper;

	function require(moduleName: 'zyPlayVideo'): zyPlayVideo;

	function require(moduleName: 'webDAV'): webDAV;

	function require(moduleName: 'moduleKeyBoard'): moduleKeyBoard;

	function require(moduleName: 'checkappexist'): checkappexist;

	function require(moduleName: 'miracast'): miracast;

	function require(moduleName: 'gifHandle'): gifHandle;

	function require(moduleName: 'openSet'): openSet;

	function require(moduleName: 'imageMerge'): imageMerge;

	function require(moduleName: 'HmacSHA256'): HmacSHA256;

	function require(moduleName: 'internationalization'): internationalization;

	function require(moduleName: 'AppGroup'): AppGroup;

	function require(moduleName: 'AsyncSocket'): AsyncSocket;

	function require(moduleName: 'oxHlsCache'): oxHlsCache;

	function require(moduleName: 'runBackground'): runBackground;

	function require(moduleName: 'db'): db;

	function require(moduleName: 'FNRecordMp3'): FNRecordMp3;

	function require(moduleName: 'miniVR'): miniVR;

	function require(moduleName: 'oxImageEditer'): oxImageEditer;

	function require(moduleName: 'GifImage'): GifImage;

	function require(moduleName: 'acMqtt'): acMqtt;

	function require(moduleName: 'walletCards'): walletCards;

	function require(moduleName: 'chromeDebug'): chromeDebug;

	function require(moduleName: 'FNScanner'): FNScanner;

	function require(moduleName: 'oxPlayer'): oxPlayer;

	function require(moduleName: 'recMp3'): recMp3;

	function require(moduleName: 'generateVideo'): generateVideo;

	function require(moduleName: 'voiceMag'): voiceMag;

	function require(moduleName: 'playModuleAli'): playModuleAli;

	function require(moduleName: 'appGray'): appGray;

	function require(moduleName: 'httpServer'): httpServer;

	function require(moduleName: 'liveAudioPlayer'): liveAudioPlayer;

	function require(moduleName: 'waterImageMark'): waterImageMark;

	function require(moduleName: 'imageTool'): imageTool;

	function require(moduleName: 'scrollVideo'): scrollVideo;

	function require(moduleName: 'floatVideo'): floatVideo;

	function require(moduleName: 'HeartRate'): HeartRate;

	function require(moduleName: 'FNQRcreate'): FNQRcreate;

	function require(moduleName: 'exifInterface'): exifInterface;

	function require(moduleName: 'mtlNFC'): mtlNFC;

	function require(moduleName: 'mdReader'): mdReader;

	function require(moduleName: 'officePreview'): officePreview;

	function require(moduleName: 'FNQRscan'): FNQRscan;

	function require(moduleName: 'sharePics'): sharePics;

	function require(moduleName: 'easyCamera'): easyCamera;

	function require(moduleName: 'cameraWeibo'): cameraWeibo;

	function require(moduleName: 'socketManager'): socketManager;

	function require(moduleName: 'appControl'): appControl;

	function require(moduleName: 'screenCapture'): screenCapture;

	function require(moduleName: 'blurredView'): blurredView;

	function require(moduleName: 'exportExcel'): exportExcel;

	function require(moduleName: 'logger'): logger;

	function require(moduleName: 'qiniuUpfile'): qiniuUpfile;

	function require(moduleName: 'moduleTVKeyApi'): moduleTVKeyApi;

	function require(moduleName: 'moduleBusQrcode'): moduleBusQrcode;

	function require(moduleName: 'nativeDialog'): nativeDialog;

	function require(moduleName: 'mqtt'): mqtt;

	function require(moduleName: 'IdCardModule'): IdCardModule;

	function require(moduleName: 'm3u8Download'): m3u8Download;

	function require(moduleName: 'lottie'): lottie;

	function require(moduleName: 'compressVideo'): compressVideo;

	function require(moduleName: 'imageRotation'): imageRotation;

	function require(moduleName: 'weChatVideo'): weChatVideo;

	function require(moduleName: 'selectPic'): selectPic;

	function require(moduleName: 'videoPlayer'): videoPlayer;

	function require(moduleName: 'jsskeNFC'): jsskeNFC;

	function require(moduleName: 'timer'): timer;

	function require(moduleName: 'cnKeyBoard'): cnKeyBoard;

	function require(moduleName: 'appManagerPlus'): appManagerPlus;

	function require(moduleName: 'imageXWebImage'): imageXWebImage;

	function require(moduleName: 'chromellqDebug'): chromellqDebug;

	function require(moduleName: 'recordVideo'): recordVideo;

	function require(moduleName: 'mediaCollector'): mediaCollector;

	function require(moduleName: 'musicPlayer'): musicPlayer;

	function require(moduleName: 'rUHF'): rUHF;

	function require(moduleName: 'ytylive'): ytylive;

	function require(moduleName: 'acVRPlayer'): acVRPlayer;

	function require(moduleName: 'imageBrowser'): imageBrowser;

	function require(moduleName: 'realNetwork'): realNetwork;

	function require(moduleName: 'pdfReader'): pdfReader;

	function require(moduleName: 'aemail'): aemail;

	function require(moduleName: 'videoPicture'): videoPicture;

	function require(moduleName: 'customNotification'): customNotification;

	function require(moduleName: 'brightnessUtil'): brightnessUtil;

	function require(moduleName: 'imageTools'): imageTools;

	function require(moduleName: 'imageFilter'): imageFilter;

	function require(moduleName: 'ttsModule'): ttsModule;

	function require(moduleName: 'mobilePhone'): mobilePhone;

	function require(moduleName: 'photoBrowserTodayNew'): photoBrowserTodayNew;

	function require(moduleName: 'dUserAgent'): dUserAgent;

	function require(moduleName: 'qrScanner'): qrScanner;

	function require(moduleName: 'notifyMrg'): notifyMrg;

	function require(moduleName: 'networkAddress'): networkAddress;

	function require(moduleName: 'speedPlayer'): speedPlayer;

	function require(moduleName: 'apk'): apk;

	function require(moduleName: 'snKVStorage'): snKVStorage;

	function require(moduleName: 'photoStream'): photoStream;

	function require(moduleName: 'playRtsp'): playRtsp;

	function require(moduleName: 'moduleCrop'): moduleCrop;

	function require(moduleName: 'marketScore'): marketScore;

	function require(moduleName: 'UIPhotoViewer'): UIPhotoViewer;

	function require(moduleName: 'keepAlive'): keepAlive;

	function require(moduleName: 'androidPdfReader'): androidPdfReader;

	function require(moduleName: 'shareAction'): shareAction;

	function require(moduleName: 'easyVideoPlayer'): easyVideoPlayer;

	function require(moduleName: 'acReplay'): acReplay;

	function require(moduleName: 'aliOSS'): aliOSS;

	function require(moduleName: 'systemTool'): systemTool;

	function require(moduleName: 'imageClip'): imageClip;

	function require(moduleName: 'wxShortVideo'): wxShortVideo;

	function require(moduleName: 'tools'): tools;

	function require(moduleName: 'AppleReader'): AppleReader;

	function require(moduleName: 'gifSlim'): gifSlim;

	function require(moduleName: 'dbPlus'): dbPlus;

	function require(moduleName: 'mam'): mam;

	function require(moduleName: 'mcm'): mcm;

	function require(moduleName: 'msm'): msm;

	function require(moduleName: 'push'): push;

	function require(moduleName: 'dropDownMenu'): dropDownMenu;

	function require(moduleName: 'NVNavigationBar'): NVNavigationBar;

	function require(moduleName: 'scrollRotation'): scrollRotation;

	function require(moduleName: 'arcMenu'): arcMenu;

	function require(moduleName: 'circularMenu'): circularMenu;

	function require(moduleName: 'tuberBar'): tuberBar;

	function require(moduleName: 'sideMenu'): sideMenu;

	function require(moduleName: 'navigationMenu'): navigationMenu;

	function require(moduleName: 'navigationBar'): navigationBar;

	function require(moduleName: 'actionButton'): actionButton;

	function require(moduleName: 'tabBarMenu'): tabBarMenu;

	function require(moduleName: 'bubbleMenu'): bubbleMenu;

	function require(moduleName: 'NVTabBarAnimation'): NVTabBarAnimation;

	function require(moduleName: 'MNActionButton'): MNActionButton;

	function require(moduleName: 'MNRotationMenu'): MNRotationMenu;

	function require(moduleName: 'MNPopups'): MNPopups;

	function require(moduleName: 'stackMenu'): stackMenu;

	function require(moduleName: 'MNNavigationMenu'): MNNavigationMenu;

	function require(moduleName: 'MNStack'): MNStack;

	function require(moduleName: 'NVTabBar'): NVTabBar;

	function require(moduleName: 'pullMenu'): pullMenu;

	function require(moduleName: 'tabBar'): tabBar;

	function require(moduleName: 'columnBar'): columnBar;

	function require(moduleName: 'gesturePassword'): gesturePassword;

	function require(moduleName: 'UIPullRefreshDrop'): UIPullRefreshDrop;

	function require(moduleName: 'doubleBarChart'): doubleBarChart;

	function require(moduleName: 'UICircleSlider'): UICircleSlider;

	function require(moduleName: 'customSelector'): customSelector;

	function require(moduleName: 'photoNews_tt'): photoNews_tt;

	function require(moduleName: 'UIPullRefresh'): UIPullRefresh;

	function require(moduleName: 'suspensionWindow'): suspensionWindow;

	function require(moduleName: 'dtCarKeyBoard'): dtCarKeyBoard;

	function require(moduleName: 'soundIndicator'): soundIndicator;

	function require(moduleName: 'miCalendar'): miCalendar;

	function require(moduleName: 'zjCartList'): zjCartList;

	function require(moduleName: 'UIListMeeting'): UIListMeeting;

	function require(moduleName: 'UIListView'): UIListView;

	function require(moduleName: 'slipList'): slipList;

	function require(moduleName: 'pbTouTiao'): pbTouTiao;

	function require(moduleName: 'compass'): compass;

	function require(moduleName: 'scrollPicture'): scrollPicture;

	function require(moduleName: 'musicNotify'): musicNotify;

	function require(moduleName: 'listContact'): listContact;

	function require(moduleName: 'UIListContactsSelect'): UIListContactsSelect;

	function require(moduleName: 'UIListGroup'): UIListGroup;

	function require(moduleName: 'iosDialog4A'): iosDialog4A;

	function require(moduleName: 'UIListCard'): UIListCard;

	function require(moduleName: 'UIListInformation'): UIListInformation;

	function require(moduleName: 'UICustomPicker'): UICustomPicker;

	function require(moduleName: 'payPasswordPlus'): payPasswordPlus;

	function require(moduleName: 'slider'): slider;

	function require(moduleName: 'calendar'): calendar;

	function require(moduleName: 'UIListBook'): UIListBook;

	function require(moduleName: 'UISelector'): UISelector;

	function require(moduleName: 'addressSel'): addressSel;

	function require(moduleName: 'wmVideoRecorder'): wmVideoRecorder;

	function require(moduleName: 'photoBrowserWeiBo'): photoBrowserWeiBo;

	function require(moduleName: 'dragList'): dragList;

	function require(moduleName: 'pullRefreshLoop'): pullRefreshLoop;

	function require(moduleName: 'UIPullRefreshRiding'): UIPullRefreshRiding;

	function require(moduleName: 'passwordKeyboard'): passwordKeyboard;

	function require(moduleName: 'dtSelector'): dtSelector;

	function require(moduleName: 'UICityList'): UICityList;

	function require(moduleName: 'shakeView'): shakeView;

	function require(moduleName: 'photoBrowserQQ'): photoBrowserQQ;

	function require(moduleName: 'barChart'): barChart;

	function require(moduleName: 'dialogBox'): dialogBox;

	function require(moduleName: 'UIAlert'): UIAlert;

	function require(moduleName: 'kLoading'): kLoading;

	function require(moduleName: 'UISwitchButton'): UISwitchButton;

	function require(moduleName: 'UIScrollPromptView'): UIScrollPromptView;

	function require(moduleName: 'iOSDialog'): iOSDialog;

	function require(moduleName: 'UIChatUnit'): UIChatUnit;

	function require(moduleName: 'UIMultiSelector'): UIMultiSelector;

	function require(moduleName: 'button'): button;

	function require(moduleName: 'mtlCitySelect'): mtlCitySelect;

	function require(moduleName: 'brokenLine'): brokenLine;

	function require(moduleName: 'UIPieChart'): UIPieChart;

	function require(moduleName: 'groupList'): groupList;

	function require(moduleName: 'thwartwiseBarChart'): thwartwiseBarChart;

	function require(moduleName: 'doubleSlider'): doubleSlider;

	function require(moduleName: 'UIChatBar'): UIChatBar;

	function require(moduleName: 'UIAlbumSelector'): UIAlbumSelector;

	function require(moduleName: 'UIAlbum'): UIAlbum;

	function require(moduleName: 'UIWebBrowser'): UIWebBrowser;

	function require(moduleName: 'noticeView'): noticeView;

	function require(moduleName: 'UIListSearch'): UIListSearch;

	function require(moduleName: 'cityPicker'): cityPicker;

	function require(moduleName: 'keyboard'): keyboard;

	function require(moduleName: 'UIChatInput'): UIChatInput;

	function require(moduleName: 'frameTree'): frameTree;

	function require(moduleName: 'UIAlbumBrowser'): UIAlbumBrowser;

	function require(moduleName: 'circleProgress'): circleProgress;

	function require(moduleName: 'UIListContactsPlus'): UIListContactsPlus;

	function require(moduleName: 'liveUI'): liveUI;

	function require(moduleName: 'constactOperate'): constactOperate;

	function require(moduleName: 'UIChartline'): UIChartline;

	function require(moduleName: 'panorama'): panorama;

	function require(moduleName: 'UIInput'): UIInput;

	function require(moduleName: 'keyBoardMgr'): keyBoardMgr;

	function require(moduleName: 'UIActionRecord'): UIActionRecord;

	function require(moduleName: 'periodSelector'): periodSelector;

	function require(moduleName: 'toastmoduleforjs'): toastmoduleforjs;

	function require(moduleName: 'kLine'): kLine;

	function require(moduleName: 'cxChatbox'): cxChatbox;

	function require(moduleName: 'inputField'): inputField;

	function require(moduleName: 'timeSelector'): timeSelector;

	function require(moduleName: 'fourStageLinkage'): fourStageLinkage;

	function require(moduleName: 'payPasswordInput'): payPasswordInput;

	function require(moduleName: 'loadingLabel'): loadingLabel;

	function require(moduleName: 'photoBrowserWeiXin'): photoBrowserWeiXin;

	function require(moduleName: 'slidingList'): slidingList;

	function require(moduleName: 'UIActionSelector'): UIActionSelector;

	function require(moduleName: 'UIBlurEffect'): UIBlurEffect;

	function require(moduleName: 'floatModule'): floatModule;

	function require(moduleName: 'zyPatternLock'): zyPatternLock;

	function require(moduleName: 'searchBar'): searchBar;

	function require(moduleName: 'UIListCheck'): UIListCheck;

	function require(moduleName: 'UIScrollPlayer'): UIScrollPlayer;

	function require(moduleName: 'UILineChart'): UILineChart;

	function require(moduleName: 'UIPartCircleProgress'): UIPartCircleProgress;

	function require(moduleName: 'hintChatBox'): hintChatBox;

	function require(moduleName: 'UIMediaScanner'): UIMediaScanner;

	function require(moduleName: 'addressView'): addressView;

	function require(moduleName: 'citySelect'): citySelect;

	function require(moduleName: 'screenTaskUI'): screenTaskUI;

	function require(moduleName: 'beautifulPicker'): beautifulPicker;

	function require(moduleName: 'UIPullRefreshMotive'): UIPullRefreshMotive;

	function require(moduleName: 'pieChart'): pieChart;

	function require(moduleName: 'UIScrollPicture'): UIScrollPicture;

	function require(moduleName: 'UIInputBox'): UIInputBox;

	function require(moduleName: 'listViewEntity'): listViewEntity;

	function require(moduleName: 'mtlCityPicker'): mtlCityPicker;

	function require(moduleName: 'superKeyboard'): superKeyboard;

	function require(moduleName: 'mtlGestureUnlock'): mtlGestureUnlock;

	function require(moduleName: 'watermark'): watermark;

	function require(moduleName: 'UICoverFlowS'): UICoverFlowS;

	function require(moduleName: 'UIGraph'): UIGraph;

	function require(moduleName: 'addressBook'): addressBook;

	function require(moduleName: 'guide'): guide;

	function require(moduleName: 'soundWave'): soundWave;

	function require(moduleName: 'videoEdit'): videoEdit;

	function require(moduleName: 'UIDatePickerTool'): UIDatePickerTool;

	function require(moduleName: 'UIButton'): UIButton;

	function require(moduleName: 'labelDragSort'): labelDragSort;

	function require(moduleName: 'UIAlertView'): UIAlertView;

	function require(moduleName: 'handlock'): handlock;

	function require(moduleName: 'matrixLock'): matrixLock;

	function require(moduleName: 'mtlPhotoPicker'): mtlPhotoPicker;

	function require(moduleName: 'divisionalLineChart'): divisionalLineChart;

	function require(moduleName: 'UICoverFlow'): UICoverFlow;

	function require(moduleName: 'WXPhotoPicker'): WXPhotoPicker;

	function require(moduleName: 'popupMenu'): popupMenu;

	function require(moduleName: 'editDialog'): editDialog;

	function require(moduleName: 'UIDatePickerS'): UIDatePickerS;

	function require(moduleName: 'UIVividLine'): UIVividLine;

	function require(moduleName: 'gestureUnlock'): gestureUnlock;

	function require(moduleName: 'UIAdaptiveInput'): UIAdaptiveInput;

	function require(moduleName: 'UIChatTools'): UIChatTools;

	function require(moduleName: 'xinyanIDVerification'): xinyanIDVerification;

	function require(moduleName: 'citySelector'): citySelector;

	function require(moduleName: 'paymentDialog'): paymentDialog;

	function require(moduleName: 'UIListContacts'): UIListContacts;

	function require(moduleName: 'UILoading'): UILoading;

	function require(moduleName: 'UIPopupsPicker'): UIPopupsPicker;

	function require(moduleName: 'multiSelector'): multiSelector;

	function require(moduleName: 'welcomePage'): welcomePage;

	function require(moduleName: 'zjListView'): zjListView;

	function require(moduleName: 'UISlider'): UISlider;

	function require(moduleName: 'swipeCaptcha'): swipeCaptcha;

	function require(moduleName: 'orderList'): orderList;

	function require(moduleName: 'dMultiScreen'): dMultiScreen;

	function require(moduleName: 'UILinkageSelector'): UILinkageSelector;

	function require(moduleName: 'UIListUpload'): UIListUpload;

	function require(moduleName: 'UIMediaControl'): UIMediaControl;

	function require(moduleName: 'selectList'): selectList;

	function require(moduleName: 'applause'): applause;

	function require(moduleName: 'UIPullRefreshFlash'): UIPullRefreshFlash;

	function require(moduleName: 'UIListArrow'): UIListArrow;

	function require(moduleName: 'waveProgress'): waveProgress;

	function require(moduleName: 'messageList'): messageList;

	function require(moduleName: 'UISearchBar'): UISearchBar;

	function require(moduleName: 'overviewList'): overviewList;

	function require(moduleName: 'sliderButton'): sliderButton;

	function require(moduleName: 'floatButton'): floatButton;

	function require(moduleName: 'mtlOpenFile'): mtlOpenFile;

	function require(moduleName: 'UISliderButton'): UISliderButton;

	function require(moduleName: 'arcProgress'): arcProgress;

	function require(moduleName: 'lineChart'): lineChart;

	function require(moduleName: 'sunmiT2Screen'): sunmiT2Screen;

	function require(moduleName: 'goodsList'): goodsList;

	function require(moduleName: 'licencePlatekeyboard'): licencePlatekeyboard;

	function require(moduleName: 'listView'): listView;

	function require(moduleName: 'fluttering'): fluttering;

	function require(moduleName: 'fillInput'): fillInput;

	function require(moduleName: 'UIListBadge'): UIListBadge;

	function require(moduleName: 'UIBarChart'): UIBarChart;

	function require(moduleName: 'imageDragSort'): imageDragSort;

	function require(moduleName: 'hikvision'): hikvision;

	function require(moduleName: 'UILinkedPicker'): UILinkedPicker;

	function require(moduleName: 'pdfPlus'): pdfPlus;

	function require(moduleName: 'chatBox'): chatBox;

	function require(moduleName: 'UIListContactsCheck'): UIListContactsCheck;

	function require(moduleName: 'UIActionProgress'): UIActionProgress;

	function require(moduleName: 'gridSlide'): gridSlide;

	function require(moduleName: 'UIPickerView'): UIPickerView;

	function require(moduleName: 'guaidWindow'): guaidWindow;

	function require(moduleName: 'UIActionDialog'): UIActionDialog;

	function require(moduleName: 'UIPersonalCenter'): UIPersonalCenter;

	function require(moduleName: 'UIChatBox'): UIChatBox;

	function require(moduleName: 'douYinSlidePlayer'): douYinSlidePlayer;

	function require(moduleName: 'UIAddressBook'): UIAddressBook;

	function require(moduleName: 'sphereCloud'): sphereCloud;

	function require(moduleName: 'UICalendar'): UICalendar;

	function require(moduleName: 'maskView'): maskView;

	function require(moduleName: 'UIChatField'): UIChatField;

	function require(moduleName: 'UIListEdit'): UIListEdit;

	function require(moduleName: 'ruler'): ruler;

	function require(moduleName: 'keyboardView'): keyboardView;

	function require(moduleName: 'kLineChart'): kLineChart;

	function require(moduleName: 'graph'): graph;

	function require(moduleName: 'UIDatePicker'): UIDatePicker;

	function require(moduleName: 'customToast'): customToast;

	function require(moduleName: 'goodAd'): goodAd;

	function require(moduleName: 'waterBallProgress'): waterBallProgress;

	function require(moduleName: 'mwChatView'): mwChatView;

	function require(moduleName: 'coverFlow'): coverFlow;

	function require(moduleName: 'photoBrowserTouTiaoPlus'): photoBrowserTouTiaoPlus;

	function require(moduleName: 'personalCenter'): personalCenter;

	function require(moduleName: 'UIListGoods'): UIListGoods;

	function require(moduleName: 'photoBrowserTouTiao'): photoBrowserTouTiao;

	function require(moduleName: 'cityList'): cityList;

	function require(moduleName: 'moduleScanCode'): moduleScanCode;

	function require(moduleName: 'cxgBluetoothSerial'): cxgBluetoothSerial;

	function require(moduleName: 'pingModule'): pingModule;

	function require(moduleName: 'magnetometer'): magnetometer;

	function require(moduleName: 'androidTouch'): androidTouch;

	function require(moduleName: 'cvVibrate'): cvVibrate;

	function require(moduleName: 'checkproxys'): checkproxys;

	function require(moduleName: 'lockScreen'): lockScreen;

	function require(moduleName: 'level'): level;

	function require(moduleName: 'accelerometer'): accelerometer;

	function require(moduleName: 'BoyFatBle'): BoyFatBle;

	function require(moduleName: 'bluetooth'): bluetooth;

	function require(moduleName: 'posScanner'): posScanner;

	function require(moduleName: 'DVContacts'): DVContacts;

	function require(moduleName: 'cellphone'): cellphone;

	function require(moduleName: 'decibel'): decibel;

	function require(moduleName: 'rotationVector'): rotationVector;

	function require(moduleName: 'linearAcceleration'): linearAcceleration;

	function require(moduleName: 'gravitySensor'): gravitySensor;

	function require(moduleName: 'seblePrinter'): seblePrinter;

	function require(moduleName: 'statusBarTools'): statusBarTools;

	function require(moduleName: 'lightSensitive'): lightSensitive;

	function require(moduleName: 'music'): music;

	function require(moduleName: 'zNFC'): zNFC;

	function require(moduleName: 'spputil'): spputil;

	function require(moduleName: 'callrecords'): callrecords;

	function require(moduleName: 'moduleEasyWiFi'): moduleEasyWiFi;

	function require(moduleName: 'ipAddr'): ipAddr;

	function require(moduleName: 'telephoneInfo'): telephoneInfo;

	function require(moduleName: 'leidenSDK'): leidenSDK;

	function require(moduleName: 'ipa'): ipa;

	function require(moduleName: 'iAd'): iAd;

	function require(moduleName: 'androidNfc'): androidNfc;

	function require(moduleName: 'multiScreen'): multiScreen;

	function require(moduleName: 'gyro'): gyro;

	function require(moduleName: 'socketServerClient'): socketServerClient;

	function require(moduleName: 'accelerometerSensor'): accelerometerSensor;

	function require(moduleName: 'proximity'): proximity;

	function require(moduleName: 'simInfoImp'): simInfoImp;

	function require(moduleName: 'vibrate'): vibrate;

	function require(moduleName: 'moduleElectronicScale'): moduleElectronicScale;

	function require(moduleName: 'simpleBle'): simpleBle;

	function require(moduleName: 'reminder'): reminder;

	function require(moduleName: 'calendarMemo'): calendarMemo;

	function require(moduleName: 'lpapiModule'): lpapiModule;

	function require(moduleName: 'easyNFC'): easyNFC;

	function require(moduleName: 'contact'): contact;

	function require(moduleName: 'mobileNFC'): mobileNFC;

	function require(moduleName: 'ywble'): ywble;

	function require(moduleName: 'sunmiT1Printer'): sunmiT1Printer;

	function require(moduleName: 'touchID'): touchID;

	function require(moduleName: 'fvvSerialPort'): fvvSerialPort;

	function require(moduleName: 'cilicoScan'): cilicoScan;

	function require(moduleName: 'cxgBluetooth'): cxgBluetooth;

	function require(moduleName: 'ble2'): ble2;

	function require(moduleName: 'bleToken'): bleToken;

	function require(moduleName: 'smsrecords'): smsrecords;

	function require(moduleName: 'strongApp'): strongApp;

	function require(moduleName: 'systemCompass'): systemCompass;

	function require(moduleName: 'smsListener'): smsListener;

	function require(moduleName: 'gyroscopeSensor'): gyroscopeSensor;

	function require(moduleName: 'cameraColor'): cameraColor;

	function require(moduleName: 'appSettings'): appSettings;

	function require(moduleName: 'broadcast'): broadcast;

	function require(moduleName: 'torch'): torch;

	function require(moduleName: 'altimeter'): altimeter;

	function require(moduleName: 'miitMsa'): miitMsa;

	function require(moduleName: 'sunmiPrinter'): sunmiPrinter;

	function require(moduleName: 'clipBoard'): clipBoard;

	function require(moduleName: 'wifiMgr'): wifiMgr;

	function require(moduleName: 'ScreenWake'): ScreenWake;

	function require(moduleName: 'spModule'): spModule;

	function require(moduleName: 'yunnex'): yunnex;

	function require(moduleName: 'wifiProxy'): wifiProxy;

	function require(moduleName: 'lightSensor'): lightSensor;

	function require(moduleName: 'gpsState'): gpsState;

	function require(moduleName: 'memoryInfo'): memoryInfo;

	function require(moduleName: 'contacts'): contacts;

	function require(moduleName: 'nfc'): nfc;

	function require(moduleName: 'mediaScanner'): mediaScanner;

	function require(moduleName: 'ble'): ble;

	function require(moduleName: 'deviceInfo'): deviceInfo;

	function require(moduleName: 'playText'): playText;

	function require(moduleName: 'flashLight'): flashLight;

	function require(moduleName: 'moduleJiaBo'): moduleJiaBo;

	function require(moduleName: 'xwScanner'): xwScanner;

	function require(moduleName: 'mySettingInfo'): mySettingInfo;

	function require(moduleName: 'vibration'): vibration;

	function require(moduleName: 'FNSettings'): FNSettings;

	function require(moduleName: 'manageStorage'): manageStorage;

	function require(moduleName: 'moduleSMSListening'): moduleSMSListening;

	function require(moduleName: 'blePrintHaier'): blePrintHaier;

	function require(moduleName: 'aIMEI'): aIMEI;

	function require(moduleName: 'customKeyboard'): customKeyboard;

	function require(moduleName: 'isSimulator'): isSimulator;

	function require(moduleName: 'usbSerial'): usbSerial;

	function require(moduleName: 'brightness2016'): brightness2016;

	function require(moduleName: 'bgnWiFi'): bgnWiFi;

	function require(moduleName: 'cpuInfo'): cpuInfo;

	function require(moduleName: 'shareBySystem'): shareBySystem;

	function require(moduleName: 'DVTorch'): DVTorch;

	function require(moduleName: 'gps'): gps;

	function require(moduleName: 'screen'): screen;

	function require(moduleName: 'wwprint'): wwprint;

	function require(moduleName: 'wifi'): wifi;

	function require(moduleName: 'sensor'): sensor;

	function require(moduleName: 'phoneInfo'): phoneInfo;

	function require(moduleName: 'crManager'): crManager;

	function require(moduleName: 'statusBar'): statusBar;

	function require(moduleName: 'smartConfigCheyw'): smartConfigCheyw;

	function require(moduleName: 'ipAddress'): ipAddress;

	function require(moduleName: 'simInfo'): simInfo;

	function require(moduleName: 'moduleBarcodeScales'): moduleBarcodeScales;

	function require(moduleName: 'mobileSignal'): mobileSignal;

	function require(moduleName: 'jpgInfoManager'): jpgInfoManager;

	function require(moduleName: 'pedometer'): pedometer;

	function require(moduleName: 'smartPeak'): smartPeak;

	function require(moduleName: 'orientationSensor'): orientationSensor;

	function require(moduleName: 'hardwareInfo'): hardwareInfo;

	function require(moduleName: 'modulePrinter'): modulePrinter;

	function require(moduleName: 'mtlNFC'): mtlNFC;

	function require(moduleName: 'proximitySensor'): proximitySensor;

	function require(moduleName: 'compassLeveler'): compassLeveler;

	function require(moduleName: 'smsModule'): smsModule;

	function require(moduleName: 'openApp'): openApp;

	function require(moduleName: 'cameraTool'): cameraTool;

	function require(moduleName: 'zjPrinter'): zjPrinter;

	function require(moduleName: 'moduleLabelPrinter'): moduleLabelPrinter;

	function require(moduleName: 'displayInfo'): displayInfo;

	function require(moduleName: 'sunmiV2Printer'): sunmiV2Printer;

	function require(moduleName: 'myAppInfo'): myAppInfo;

	function require(moduleName: 'connectWifi'): connectWifi;

	function require(moduleName: 'vibrateUtil'): vibrateUtil;

	function require(moduleName: 'blesdk'): blesdk;

	function require(moduleName: 'callRecord'): callRecord;

	function require(moduleName: 'fileChooser'): fileChooser;

	function require(moduleName: 'moduleSMS'): moduleSMS;

	function require(moduleName: 'posPrinter'): posPrinter;

	function require(moduleName: 'myListeningInfo'): myListeningInfo;

	function require(moduleName: 'bluePrinter'): bluePrinter;

	function require(moduleName: 'mobileSensor'): mobileSensor;

	function require(moduleName: 'btsppiot'): btsppiot;

	function require(moduleName: 'systemGyro'): systemGyro;

	function require(moduleName: 'seriesCamera'): seriesCamera;

	function require(moduleName: 'printBleWifi'): printBleWifi;

	function require(moduleName: 'appVersionUpdate'): appVersionUpdate;

	function require(moduleName: 'magneticFieldSensor'): magneticFieldSensor;

	function require(moduleName: 'gpsListener'): gpsListener;

	function require(moduleName: 'toBackground'): toBackground;

	function require(moduleName: 'btmodule'): btmodule;

	function require(moduleName: 'wifiSSID'): wifiSSID;

	function require(moduleName: 'tencentTrtcVoiceRoom'): tencentTrtcVoiceRoom;

	function require(moduleName: 'hanvonVehicleCard'): hanvonVehicleCard;

	function require(moduleName: 'mwTencentRTC'): mwTencentRTC;

	function require(moduleName: 'yunxinIM'): yunxinIM;

	function require(moduleName: 'chivoxLongman'): chivoxLongman;

	function require(moduleName: 'jdKepler'): jdKepler;

	function require(moduleName: 'SAMIDCard'): SAMIDCard;

	function require(moduleName: 'qupaiLive'): qupaiLive;

	function require(moduleName: 'aliyunPush'): aliyunPush;

	function require(moduleName: 'ajAnalytics'): ajAnalytics;

	function require(moduleName: 'sunlogin'): sunlogin;

	function require(moduleName: 'liuLiangQianBao'): liuLiangQianBao;

	function require(moduleName: 'alibaichuan'): alibaichuan;

	function require(moduleName: 'x5ac'): x5ac;

	function require(moduleName: 'vinOCR'): vinOCR;

	function require(moduleName: 'braintreeApplePay'): braintreeApplePay;

	function require(moduleName: 'superFile'): superFile;

	function require(moduleName: 'easyAR'): easyAR;

	function require(moduleName: 'hotsspAds'): hotsspAds;

	function require(moduleName: 'vlcPlayer'): vlcPlayer;

	function require(moduleName: 'aliBC'): aliBC;

	function require(moduleName: 'APSocial'): APSocial;

	function require(moduleName: 'acLive'): acLive;

	function require(moduleName: 'playModuleTx'): playModuleTx;

	function require(moduleName: 'heartRateReceiver'): heartRateReceiver;

	function require(moduleName: 'tencentMTA'): tencentMTA;

	function require(moduleName: 'bTrace'): bTrace;

	function require(moduleName: 'bugout'): bugout;

	function require(moduleName: 'bPlayer'): bPlayer;

	function require(moduleName: 'geTui'): geTui;

	function require(moduleName: 'tencentIMPro'): tencentIMPro;

	function require(moduleName: 'shareinstall'): shareinstall;

	function require(moduleName: 'tpush'): tpush;

	function require(moduleName: 'UIBPlayer'): UIBPlayer;

	function require(moduleName: 'miniVideoRecord'): miniVideoRecord;

	function require(moduleName: 'JGCertificate'): JGCertificate;

	function require(moduleName: 'ACTencentCOS'): ACTencentCOS;

	function require(moduleName: 'txPlayer'): txPlayer;

	function require(moduleName: 'UIEaseIM'): UIEaseIM;

	function require(moduleName: 'uzkJDopen'): uzkJDopen;

	function require(moduleName: 'UIEaseCEC'): UIEaseCEC;

	function require(moduleName: 'wxVoicePlus'): wxVoicePlus;

	function require(moduleName: 'tencentTIC'): tencentTIC;

	function require(moduleName: 'aliSmilePay'): aliSmilePay;

	function require(moduleName: 'Linkedin'): Linkedin;

	function require(moduleName: 'kf5'): kf5;

	function require(moduleName: 'easeCEC'): easeCEC;

	function require(moduleName: 'faceidLive'): faceidLive;

	function require(moduleName: 'mico'): mico;

	function require(moduleName: 'dingding'): dingding;

	function require(moduleName: 'hfLiveMusicPlayer'): hfLiveMusicPlayer;

	function require(moduleName: 'tencentPush'): tencentPush;

	function require(moduleName: 'txMarketing'): txMarketing;

	function require(moduleName: 'acIdcard'): acIdcard;

	function require(moduleName: 'sendSms'): sendSms;

	function require(moduleName: 'voiceRecognizer'): voiceRecognizer;

	function require(moduleName: 'netEaseLive'): netEaseLive;

	function require(moduleName: 'UITencentIm'): UITencentIm;

	function require(moduleName: 'openinstall'): openinstall;

	function require(moduleName: 'UITencentImPublic'): UITencentImPublic;

	function require(moduleName: 'pushGeTuiPlus'): pushGeTuiPlus;

	function require(moduleName: 'kf5sdk'): kf5sdk;

	function require(moduleName: 'tencentTRTC'): tencentTRTC;

	function require(moduleName: 'UIRongCloudWithoutLocation'): UIRongCloudWithoutLocation;

	function require(moduleName: 'alibcTrade'): alibcTrade;

	function require(moduleName: 'netEaseAVChatVideo'): netEaseAVChatVideo;

	function require(moduleName: 'hanvonCloudOcrFormulaReader'): hanvonCloudOcrFormulaReader;

	function require(moduleName: 'mobUms'): mobUms;

	function require(moduleName: 'moduleQubian'): moduleQubian;

	function require(moduleName: 'smssdk'): smssdk;

	function require(moduleName: 'TencentLocation'): TencentLocation;

	function require(moduleName: 'rtcCore'): rtcCore;

	function require(moduleName: 'apsaraShortVideoBase'): apsaraShortVideoBase;

	function require(moduleName: 'aliPayTrade'): aliPayTrade;

	function require(moduleName: 'bgnUITencentOCR'): bgnUITencentOCR;

	function require(moduleName: 'huanxin'): huanxin;

	function require(moduleName: 'Hwork'): Hwork;

	function require(moduleName: 'mtlPush'): mtlPush;

	function require(moduleName: 'oneAPMUEM'): oneAPMUEM;

	function require(moduleName: 'huanxunPay'): huanxunPay;

	function require(moduleName: 'udcreditRecognizer'): udcreditRecognizer;

	function require(moduleName: 'faceidCard'): faceidCard;

	function require(moduleName: 'alivcLivePlayer'): alivcLivePlayer;

	function require(moduleName: 'SPay'): SPay;

	function require(moduleName: 'zyGoogleAd'): zyGoogleAd;

	function require(moduleName: 'yWQGsonModule'): yWQGsonModule;

	function require(moduleName: 'mapLocationBMap'): mapLocationBMap;

	function require(moduleName: 'leCast'): leCast;

	function require(moduleName: 'ijkplayer'): ijkplayer;

	function require(moduleName: 'kiviMakeUp'): kiviMakeUp;

	function require(moduleName: 'meiQia'): meiQia;

	function require(moduleName: 'udeskPlus'): udeskPlus;

	function require(moduleName: 'zyPangolin'): zyPangolin;

	function require(moduleName: 'brightBeacon'): brightBeacon;

	function require(moduleName: 'PLMediaStreaming'): PLMediaStreaming;

	function require(moduleName: 'shanYan'): shanYan;

	function require(moduleName: 'zhiChi'): zhiChi;

	function require(moduleName: 'tencentTrtcVoiceCall'): tencentTrtcVoiceCall;

	function require(moduleName: 'OneSignal'): OneSignal;

	function require(moduleName: 'idCardScan'): idCardScan;

	function require(moduleName: 'ximalaya'): ximalaya;

	function require(moduleName: 'vk'): vk;

	function require(moduleName: 'tencentPlayer'): tencentPlayer;

	function require(moduleName: 'pangleAD'): pangleAD;

	function require(moduleName: 'mogoAdsdomob'): mogoAdsdomob;

	function require(moduleName: 'haierCenter'): haierCenter;

	function require(moduleName: 'kkPlayer'): kkPlayer;

	function require(moduleName: 'tbMobQuhe'): tbMobQuhe;

	function require(moduleName: 'baiduAd'): baiduAd;

	function require(moduleName: 'qCloudVODPlayer'): qCloudVODPlayer;

	function require(moduleName: 'wifiConfig'): wifiConfig;

	function require(moduleName: 'bankCardScan'): bankCardScan;

	function require(moduleName: 'UIEasemob'): UIEasemob;

	function require(moduleName: 'weibo'): weibo;

	function require(moduleName: 'baiduAppx'): baiduAppx;

	function require(moduleName: 'scrollVideoAli'): scrollVideoAli;

	function require(moduleName: 'JDCloudPlayer'): JDCloudPlayer;

	function require(moduleName: 'moveTrack'): moveTrack;

	function require(moduleName: 'aliyunVodPlayer'): aliyunVodPlayer;

	function require(moduleName: 'facebook'): facebook;

	function require(moduleName: 'tencentMath'): tencentMath;

	function require(moduleName: 'tencentAd'): tencentAd;

	function require(moduleName: 'haierFaceId'): haierFaceId;

	function require(moduleName: 'hanvonCloudBcardReader'): hanvonCloudBcardReader;

	function require(moduleName: 'imChat'): imChat;

	function require(moduleName: 'tencentIMSmart'): tencentIMSmart;

	function require(moduleName: 'uscSpeechRecognizer'): uscSpeechRecognizer;

	function require(moduleName: 'gt3geetest'): gt3geetest;

	function require(moduleName: 'jchat'): jchat;

	function require(moduleName: 'Twitter'): Twitter;

	function require(moduleName: 'QQPlus'): QQPlus;

	function require(moduleName: 'aliLivePusher'): aliLivePusher;

	function require(moduleName: 'coinport'): coinport;

	function require(moduleName: 'wxPayPlus'): wxPayPlus;

	function require(moduleName: 'adsDomob'): adsDomob;

	function require(moduleName: 'lelink'): lelink;

	function require(moduleName: 'discuz'): discuz;

	function require(moduleName: 'moduleScanner'): moduleScanner;

	function require(moduleName: 'ksADModule'): ksADModule;

	function require(moduleName: 'qiniuPlayer'): qiniuPlayer;

	function require(moduleName: 'moduleUHF'): moduleUHF;

	function require(moduleName: 'umengAnalytics'): umengAnalytics;

	function require(moduleName: 'sharePlugin'): sharePlugin;

	function require(moduleName: 'baiduPanorama'): baiduPanorama;

	function require(moduleName: 'qupai'): qupai;

	function require(moduleName: 'yjyzVerifyPlus'): yjyzVerifyPlus;

	function require(moduleName: 'easeChat'): easeChat;

	function require(moduleName: 'leCloudLive'): leCloudLive;

	function require(moduleName: 'webBrowser2018'): webBrowser2018;

	function require(moduleName: 'imSiLop'): imSiLop;

	function require(moduleName: 'ydocr'): ydocr;

	function require(moduleName: 'twoBaiDuOcr'): twoBaiDuOcr;

	function require(moduleName: 'txOneSentenceRecognize'): txOneSentenceRecognize;

	function require(moduleName: 'nim'): nim;

	function require(moduleName: 'DouYinPlatform'): DouYinPlatform;

	function require(moduleName: 'IFlyVoice'): IFlyVoice;

	function require(moduleName: 'navigator'): navigator;

	function require(moduleName: 'swiftpassPay'): swiftpassPay;

	function require(moduleName: 'faceUnity'): faceUnity;

	function require(moduleName: 'gensee'): gensee;

	function require(moduleName: 'zyHuaweiAd'): zyHuaweiAd;

	function require(moduleName: 'TXLivePlayer'): TXLivePlayer;

	function require(moduleName: 'duiBa'): duiBa;

	function require(moduleName: 'MobileArk'): MobileArk;

	function require(moduleName: 'wxVoice'): wxVoice;

	function require(moduleName: 'netLocationBMap'): netLocationBMap;

	function require(moduleName: 'baiduSpeechAAR'): baiduSpeechAAR;

	function require(moduleName: 'apibase'): apibase;

	function require(moduleName: 'bgnTencentOCR'): bgnTencentOCR;

	function require(moduleName: 'soundGeneralRecongnitionSdk'): soundGeneralRecongnitionSdk;

	function require(moduleName: 'tencentVodPlayer'): tencentVodPlayer;

	function require(moduleName: 'uscVoiceRecognizer'): uscVoiceRecognizer;

	function require(moduleName: 'zyBaiduFace'): zyBaiduFace;

	function require(moduleName: 'UIBdFace'): UIBdFace;

	function require(moduleName: 'jdVrPlayer'): jdVrPlayer;

	function require(moduleName: 'hanvonCloudNumberReader'): hanvonCloudNumberReader;

	function require(moduleName: 'braintreePay'): braintreePay;

	function require(moduleName: 'cloudwise'): cloudwise;

	function require(moduleName: 'tencentIm'): tencentIm;

	function require(moduleName: 'baiduCloud'): baiduCloud;

	function require(moduleName: 'leBoCast'): leBoCast;

	function require(moduleName: 'taobao'): taobao;

	function require(moduleName: 'duibaSales'): duibaSales;

	function require(moduleName: 'chivox'): chivox;

	function require(moduleName: 'payment'): payment;

	function require(moduleName: 'ezOpen'): ezOpen;

	function require(moduleName: 'ajpushGooglePlay'): ajpushGooglePlay;

	function require(moduleName: 'aliPush'): aliPush;

	function require(moduleName: 'umpush'): umpush;

	function require(moduleName: 'AliMobileAnalytics'): AliMobileAnalytics;

	function require(moduleName: 'ajAuth'): ajAuth;

	function require(moduleName: 'moxiesdk'): moxiesdk;

	function require(moduleName: 'weiXin'): weiXin;

	function require(moduleName: 'aliyunLive'): aliyunLive;

	function require(moduleName: 'recognizeCard'): recognizeCard;

	function require(moduleName: 'iflyAd'): iflyAd;

	function require(moduleName: 'appsflyerSDK'): appsflyerSDK;

	function require(moduleName: 'UIAlivcLivePlayer'): UIAlivcLivePlayer;

	function require(moduleName: 'aliOneLogin'): aliOneLogin;

	function require(moduleName: 'baiduNavigation'): baiduNavigation;

	function require(moduleName: 'iflySpeechPlus'): iflySpeechPlus;

	function require(moduleName: 'googlePay'): googlePay;

	function require(moduleName: 'oxRecorder'): oxRecorder;

	function require(moduleName: 'oxoPlayer'): oxoPlayer;

	function require(moduleName: 'gizWifiSDK'): gizWifiSDK;

	function require(moduleName: 'ffPlayer'): ffPlayer;

	function require(moduleName: 'modulebaidumtj'): modulebaidumtj;

	function require(moduleName: 'IFlyFace'): IFlyFace;

	function require(moduleName: 'rangersAppLog'): rangersAppLog;

	function require(moduleName: 'txShortVideoPlus'): txShortVideoPlus;

	function require(moduleName: 'acXimalaya'): acXimalaya;

	function require(moduleName: 'gtest'): gtest;

	function require(moduleName: 'cardReader'): cardReader;

	function require(moduleName: 'UIPLPlayer'): UIPLPlayer;

	function require(moduleName: 'maketionCardReader'): maketionCardReader;

	function require(moduleName: 'youkuPlayer'): youkuPlayer;

	function require(moduleName: 'aliYunVoice'): aliYunVoice;

	function require(moduleName: 'netEaseAVChat'): netEaseAVChat;

	function require(moduleName: 'csOpenApi'): csOpenApi;

	function require(moduleName: 'yangFan'): yangFan;

	function require(moduleName: 'camera360'): camera360;

	function require(moduleName: 'aliShortVideo'): aliShortVideo;

	function require(moduleName: 'chanceAd'): chanceAd;

	function require(moduleName: 'zhiChiSobot'): zhiChiSobot;

	function require(moduleName: 'speedataUHF'): speedataUHF;

	function require(moduleName: 'iflytekvoiceads'): iflytekvoiceads;

	function require(moduleName: 'aliTrade'): aliTrade;

	function require(moduleName: 'ksAds'): ksAds;

	function require(moduleName: 'bgnMobSMS'): bgnMobSMS;

	function require(moduleName: 'tencentCloudMta'): tencentCloudMta;

	function require(moduleName: 'systemshare'): systemshare;

	function require(moduleName: 'aliShortVideoAPI'): aliShortVideoAPI;

	function require(moduleName: 'HMTAgent'): HMTAgent;

	function require(moduleName: 'xiaoyou'): xiaoyou;

	function require(moduleName: 'zhugeio'): zhugeio;

	function require(moduleName: 'TCloudUpload'): TCloudUpload;

	function require(moduleName: 'ccwork'): ccwork;

	function require(moduleName: 'bdMTJ'): bdMTJ;

	function require(moduleName: 'xGprinterPlus'): xGprinterPlus;

	function require(moduleName: 'tencentTrtcCalling'): tencentTrtcCalling;

	function require(moduleName: 'sinaWeiBo'): sinaWeiBo;

	function require(moduleName: 'yzxVerification'): yzxVerification;

	function require(moduleName: 'oxePlayer'): oxePlayer;

	function require(moduleName: 'tencentMLVB'): tencentMLVB;

	function require(moduleName: 'ipaynowScanner'): ipaynowScanner;

	function require(moduleName: 'kuaixuePlayer'): kuaixuePlayer;

	function require(moduleName: 'mobShare'): mobShare;

	function require(moduleName: 'tingyun'): tingyun;

	function require(moduleName: 'vcloudPlay'): vcloudPlay;

	function require(moduleName: 'mobLink'): mobLink;

	function require(moduleName: 'tencentLive'): tencentLive;

	function require(moduleName: 'wxPay'): wxPay;

	function require(moduleName: 'wx'): wx;

	function require(moduleName: 'ezWifiConfig'): ezWifiConfig;

	function require(moduleName: 'busScan'): busScan;

	function require(moduleName: 'ICBCPay'): ICBCPay;

	function require(moduleName: 'myALiAPIInfo'): myALiAPIInfo;

	function require(moduleName: 'tencentLivePusher'): tencentLivePusher;

	function require(moduleName: 'gAnalytics'): gAnalytics;

	function require(moduleName: 'ottPay'): ottPay;

	function require(moduleName: 'baiduSpeechRecognizer'): baiduSpeechRecognizer;

	function require(moduleName: 'hwFaceRecognition'): hwFaceRecognition;

	function require(moduleName: 'pushRtmpOrVideoPlay'): pushRtmpOrVideoPlay;

	function require(moduleName: 'XYLink'): XYLink;

	function require(moduleName: 'seuicScanner'): seuicScanner;

	function require(moduleName: 'constructionPay'): constructionPay;

	function require(moduleName: 'bcapplepay'): bcapplepay;

	function require(moduleName: 'emasPushPlus'): emasPushPlus;

	function require(moduleName: 'aliphone'): aliphone;

	function require(moduleName: 'baiduMap'): baiduMap;

	function require(moduleName: 'aMapNavigation'): aMapNavigation;

	function require(moduleName: 'txCameraRecord'): txCameraRecord;

	function require(moduleName: 'baiduOCR'): baiduOCR;

	function require(moduleName: 'ciaYi'): ciaYi;

	function require(moduleName: 'indoorLocation'): indoorLocation;

	function require(moduleName: 'jdkUnion'): jdkUnion;

	function require(moduleName: 'rsRecognition'): rsRecognition;

	function require(moduleName: 'aliPhoneAuth'): aliPhoneAuth;

	function require(moduleName: 'mtlMap'): mtlMap;

	function require(moduleName: 'yunfan'): yunfan;

	function require(moduleName: 'quPaiModule'): quPaiModule;

	function require(moduleName: 'agoraLive'): agoraLive;

	function require(moduleName: 'rongCloudCS'): rongCloudCS;

	function require(moduleName: 'miniQuPai'): miniQuPai;

	function require(moduleName: 'adTracking'): adTracking;

	function require(moduleName: 'mapLocationAMap'): mapLocationAMap;

	function require(moduleName: 'googleMap'): googleMap;

	function require(moduleName: 'UDYhy'): UDYhy;

	function require(moduleName: 'anyRTCModule'): anyRTCModule;

	function require(moduleName: 'XLPlayer'): XLPlayer;

	function require(moduleName: 'logCrash'): logCrash;

	function require(moduleName: 'talkFunLive'): talkFunLive;

	function require(moduleName: 'didi'): didi;

	function require(moduleName: 'ArcFace'): ArcFace;

	function require(moduleName: 'mobileMove'): mobileMove;

	function require(moduleName: 'shareMorePic'): shareMorePic;

	function require(moduleName: 'alibaic'): alibaic;

	function require(moduleName: 'UIFaceID'): UIFaceID;

	function require(moduleName: 'wxPlus'): wxPlus;

	function require(moduleName: 'baiduTrace'): baiduTrace;

	function require(moduleName: 'szcaSDK'): szcaSDK;

	function require(moduleName: 'meiQiaPlus'): meiQiaPlus;

	function require(moduleName: 'appsee'): appsee;

	function require(moduleName: 'udesk'): udesk;

	function require(moduleName: 'baichuan'): baichuan;

	function require(moduleName: 'wyLive'): wyLive;

	function require(moduleName: 'huaweiPush'): huaweiPush;

	function require(moduleName: 'analysysAPICloudSDK'): analysysAPICloudSDK;

	function require(moduleName: 'rcIM'): rcIM;

	function require(moduleName: 'BaiduMobAds'): BaiduMobAds;

	function require(moduleName: 'haierIM'): haierIM;

	function require(moduleName: 'TCLitePlayer'): TCLitePlayer;

	function require(moduleName: 'googleAdMob'): googleAdMob;

	function require(moduleName: 'takePicCutOut'): takePicCutOut;

	function require(moduleName: 'baiduFaceLive'): baiduFaceLive;

	function require(moduleName: 'baiduAR'): baiduAR;

	function require(moduleName: 'swLocate'): swLocate;

	function require(moduleName: 'lingYue'): lingYue;

	function require(moduleName: 'jyVerify'): jyVerify;

	function require(moduleName: 'mtlPDA'): mtlPDA;

	function require(moduleName: 'tencentTrtcSmart'): tencentTrtcSmart;

	function require(moduleName: 'STFace'): STFace;

	function require(moduleName: 'speechRecognizer'): speechRecognizer;

	function require(moduleName: 'baiduLocation'): baiduLocation;

	function require(moduleName: 'netLocationAMap'): netLocationAMap;

	function require(moduleName: 'uzkAlibc'): uzkAlibc;

	function require(moduleName: 'BLNetwork'): BLNetwork;

	function require(moduleName: 'KBZPay'): KBZPay;

	function require(moduleName: 'TXLivePlayerV2'): TXLivePlayerV2;

	function require(moduleName: 'TKOpen'): TKOpen;

	function require(moduleName: 'checkpush'): checkpush;

	function require(moduleName: 'klevinAds'): klevinAds;

	function require(moduleName: 'rongCloudIM'): rongCloudIM;

	function require(moduleName: 'hmsAGC'): hmsAGC;

	function require(moduleName: 'ksi'): ksi;

	function require(moduleName: 'moduleShareSMS'): moduleShareSMS;

	function require(moduleName: 'rongCloud2'): rongCloud2;

	function require(moduleName: 'mapleIM'): mapleIM;

	function require(moduleName: 'skype'): skype;

	function require(moduleName: 'dahuatech'): dahuatech;

	function require(moduleName: 'bdTTS'): bdTTS;

	function require(moduleName: 'mobSecVerifyPlus'): mobSecVerifyPlus;

	function require(moduleName: 'AliyunPlayer'): AliyunPlayer;

	function require(moduleName: 'inShare'): inShare;

	function require(moduleName: 'vivoPush'): vivoPush;

	function require(moduleName: 'ccAPI'): ccAPI;

	function require(moduleName: 'uiFaceIDPlus'): uiFaceIDPlus;

	function require(moduleName: 'alipayCardPackage'): alipayCardPackage;

	function require(moduleName: 'mPaaSScanModule'): mPaaSScanModule;

	function require(moduleName: 'tencentAds'): tencentAds;

	function require(moduleName: 'tencentYLH'): tencentYLH;

	function require(moduleName: 'aliPayHK'): aliPayHK;

	function require(moduleName: 'superID'): superID;

	function require(moduleName: 'UIPLShortVideo'): UIPLShortVideo;

	function require(moduleName: 'ccbPay'): ccbPay;

	function require(moduleName: 'tencentLiveRoom'): tencentLiveRoom;

	function require(moduleName: 'xGprinter'): xGprinter;

	function require(moduleName: 'nuanceSpeechRecognizer'): nuanceSpeechRecognizer;

	function require(moduleName: 'smsVerification'): smsVerification;

	function require(moduleName: 'txLiteAV'): txLiteAV;

	function require(moduleName: 'duibaView'): duibaView;

	function require(moduleName: 'txRealTimeRecognizer'): txRealTimeRecognizer;

	function require(moduleName: 'ksAdLive'): ksAdLive;

	function require(moduleName: 'bgnArcFace'): bgnArcFace;

	function require(moduleName: 'adsYoumi'): adsYoumi;

	function require(moduleName: 'libmoorVisitorSdk'): libmoorVisitorSdk;

	function require(moduleName: 'seckenModule'): seckenModule;

	function require(moduleName: 'xiaoyouLight'): xiaoyouLight;

	function require(moduleName: 'videoshare'): videoshare;

	function require(moduleName: 'hanvonCloudTableReader'): hanvonCloudTableReader;

	function require(moduleName: 'wawa'): wawa;

	function require(moduleName: 'haikangVideo'): haikangVideo;

	function require(moduleName: 'baiduSpeechRec'): baiduSpeechRec;

	function require(moduleName: 'zmCert'): zmCert;

	function require(moduleName: 'tencentTrtcVideoCall'): tencentTrtcVideoCall;

	function require(moduleName: 'tyRTCLive'): tyRTCLive;

	function require(moduleName: 'dianYan'): dianYan;

	function require(moduleName: 'sunmiPrint'): sunmiPrint;

	function require(moduleName: 'xinyanOCR'): xinyanOCR;

	function require(moduleName: 'speick'): speick;

	function require(moduleName: 'dongtuStore'): dongtuStore;

	function require(moduleName: 'upyunUpfile'): upyunUpfile;

	function require(moduleName: 'scrollVideoTx'): scrollVideoTx;

	function require(moduleName: 'zjBluetoothPrint'): zjBluetoothPrint;

	function require(moduleName: 'easeimSDK'): easeimSDK;

	function require(moduleName: 'mapNaviAMap'): mapNaviAMap;

	function require(moduleName: 'uSDK'): uSDK;

	function require(moduleName: 'updatethis'): updatethis;

	function require(moduleName: 'alipayGlobal'): alipayGlobal;

	function require(moduleName: 'amapTrack'): amapTrack;

	function require(moduleName: 'moduleQuhe'): moduleQuhe;

	function require(moduleName: 'msspAds'): msspAds;

	function require(moduleName: 'admob'): admob;

	function require(moduleName: 'vcloudLive'): vcloudLive;

	function require(moduleName: 'meChat'): meChat;

	function require(moduleName: 'jd'): jd;

	function require(moduleName: 'camhi'): camhi;

	function require(moduleName: 'acmPush'): acmPush;

	function require(moduleName: 'moblinkpro'): moblinkpro;

	function require(moduleName: 'aliyunTTS'): aliyunTTS;

	function require(moduleName: 'sunmiScan'): sunmiScan;

	function require(moduleName: 'polyVideo'): polyVideo;

	function require(moduleName: 'TouchFaceID'): TouchFaceID;

	function require(moduleName: 'faceVerify'): faceVerify;

	function require(moduleName: 'sharetrace'): sharetrace;

	function require(moduleName: 'tencentRtc'): tencentRtc;

	function require(moduleName: 'bmobPush'): bmobPush;

	function require(moduleName: 'BCEPass'): BCEPass;

	function require(moduleName: 'UIRongCloud'): UIRongCloud;

	function require(moduleName: 'aMap'): aMap;

	function require(moduleName: 'talkingData'): talkingData;

	function require(moduleName: 'JGCertificateIDFA'): JGCertificateIDFA;

	function require(moduleName: 'aMapLocation'): aMapLocation;

	function require(moduleName: 'uPush'): uPush;

	function require(moduleName: 'quPai2017'): quPai2017;

	function require(moduleName: 'googlePush'): googlePush;

	function require(moduleName: 'wxFacePay'): wxFacePay;

	function require(moduleName: 'JShare'): JShare;

	function require(moduleName: 'zhumu'): zhumu;

	function require(moduleName: 'yWQModule'): yWQModule;

	function require(moduleName: 'ySKAuth'): ySKAuth;

	function require(moduleName: 'aliyunNls'): aliyunNls;

	function require(moduleName: 'plPlayer'): plPlayer;

	function require(moduleName: 'arcFacePublic'): arcFacePublic;

	function require(moduleName: 'yixin'): yixin;

	function require(moduleName: 'stripePay'): stripePay;

	function require(moduleName: 'zyBaiduAd'): zyBaiduAd;

	function require(moduleName: 'superPlayer'): superPlayer;

	function require(moduleName: 'omxVideo'): omxVideo;

	function require(moduleName: 'allinPay'): allinPay;

	function require(moduleName: 'geetestModule'): geetestModule;

	function require(moduleName: 'douYinPlayer'): douYinPlayer;

	function require(moduleName: 'fnad'): fnad;

	function require(moduleName: 'ACGeetest'): ACGeetest;

	function require(moduleName: 'mobVerify'): mobVerify;

	function require(moduleName: 'orcidcard'): orcidcard;

	function require(moduleName: 'aUnifyPay'): aUnifyPay;

	function require(moduleName: 'bLocation'): bLocation;

	function require(moduleName: 'txLive'): txLive;

	function require(moduleName: 'UIQiniuShortVideo'): UIQiniuShortVideo;

	function require(moduleName: 'webp'): webp;

	function require(moduleName: 'baiduIdentifyOCR'): baiduIdentifyOCR;

	function require(moduleName: 'mobPush'): mobPush;

	function require(moduleName: 'ydAuth'): ydAuth;

	function require(moduleName: 'gromoreAds'): gromoreAds;

	function require(moduleName: 'aliLivePlayer'): aliLivePlayer;

	function require(moduleName: 'MultipeerConnectivity'): MultipeerConnectivity;

	function require(moduleName: 'paypal'): paypal;

	function require(moduleName: 'xwAds'): xwAds;

	function require(moduleName: 'baiduMTJ'): baiduMTJ;

	function require(moduleName: 'aMapGeoFence'): aMapGeoFence;

	function require(moduleName: 'cchelperCaiHongNoIM'): cchelperCaiHongNoIM;

	function require(moduleName: 'ACUtoVR'): ACUtoVR;

	function require(moduleName: 'mobileIM'): mobileIM;

	function require(moduleName: 'gotyeLiveCore'): gotyeLiveCore;

	function require(moduleName: 'googleAnalytics'): googleAnalytics;

	function require(moduleName: 'youtu'): youtu;

	function require(moduleName: 'tyRTC'): tyRTC;

	function require(moduleName: 'acc5GSJC'): acc5GSJC;

	function require(moduleName: 'skipHWMeeting'): skipHWMeeting;

	function require(moduleName: 'TXLivePusher'): TXLivePusher;

	function require(moduleName: 'BluetoothDelegate'): BluetoothDelegate;

	function require(moduleName: 'APKCheck'): APKCheck;

	function require(moduleName: 'shareSDKPlus'): shareSDKPlus;

	function require(moduleName: 'leShiLive'): leShiLive;

	function require(moduleName: 'wxCardPackage'): wxCardPackage;

	function require(moduleName: 'appleUnionPay'): appleUnionPay;

	function require(moduleName: 'utoVR'): utoVR;

	function require(moduleName: 'moduleEdiMob'): moduleEdiMob;

	function require(moduleName: 'youZan2'): youZan2;

	function require(moduleName: 'ajAuthNoPush'): ajAuthNoPush;

	function require(moduleName: 'aliBCzb'): aliBCzb;

	function require(moduleName: 'osRecognition'): osRecognition;

	function require(moduleName: 'hmsScan'): hmsScan;

	function require(moduleName: 'cBImageRecognize'): cBImageRecognize;

	function require(moduleName: 'easyQRCodeScan'): easyQRCodeScan;

	function require(moduleName: 'esptouch'): esptouch;

	function require(moduleName: 'CPay'): CPay;

	function require(moduleName: 'jVerification'): jVerification;

	function require(moduleName: 'videoClipsRecord'): videoClipsRecord;

	function require(moduleName: 'umengTJ'): umengTJ;

	function require(moduleName: 'baiduLogin'): baiduLogin;

	function require(moduleName: 'mgCard'): mgCard;

	function require(moduleName: 'xinyanIDVerification'): xinyanIDVerification;

	function require(moduleName: 'zyTencentAd'): zyTencentAd;

	function require(moduleName: 'mogoAds'): mogoAds;

	function require(moduleName: 'moduleAppleMap'): moduleAppleMap;

	function require(moduleName: 'xiaoNeng'): xiaoNeng;

	function require(moduleName: 'ajSms'): ajSms;

	function require(moduleName: 'qidaIM'): qidaIM;

	function require(moduleName: 'haierUserCenter'): haierUserCenter;

	function require(moduleName: 'sangfor'): sangfor;

	function require(moduleName: 'emmPlugin'): emmPlugin;

	function require(moduleName: 'arRtc'): arRtc;

	function require(moduleName: 'reportLocation'): reportLocation;

	function require(moduleName: 'UIBaiduOCR'): UIBaiduOCR;

	function require(moduleName: 'dataCollect'): dataCollect;

	function require(moduleName: 'umAnalytics'): umAnalytics;

	function require(moduleName: 'pushGeTui'): pushGeTui;

	function require(moduleName: 'baiduPlayer'): baiduPlayer;

	function require(moduleName: 'alivcLivePusher'): alivcLivePusher;

	function require(moduleName: 'ksAd'): ksAd;

	function require(moduleName: 'UIRongChat'): UIRongChat;

	function require(moduleName: 'xShareTool'): xShareTool;

	function require(moduleName: 'mogoAdsBaidu'): mogoAdsBaidu;

	function require(moduleName: 'alibcthb'): alibcthb;

	function require(moduleName: 'fog2'): fog2;

	function require(moduleName: 'toutiaoAd'): toutiaoAd;

	function require(moduleName: 'txAnalysis'): txAnalysis;

	function require(moduleName: 'mtlIFlyVoice'): mtlIFlyVoice;

	function require(moduleName: 'sensorsAnalyticsAPICloudSDK'): sensorsAnalyticsAPICloudSDK;

	function require(moduleName: 'webBrowser'): webBrowser;

	function require(moduleName: 'mobPushPlus'): mobPushPlus;

	function require(moduleName: 'aplayer'): aplayer;

	function require(moduleName: 'agoraVideo'): agoraVideo;

	function require(moduleName: 'ddkUnion'): ddkUnion;

	function require(moduleName: 'sskCapture'): sskCapture;

	function require(moduleName: 'dongtu'): dongtu;

	function require(moduleName: 'baiduOCRRecognizer'): baiduOCRRecognizer;

	function require(moduleName: 'zyPangolinAd'): zyPangolinAd;

	function require(moduleName: 'bdAR'): bdAR;

	function require(moduleName: 'bdVR'): bdVR;

	function require(moduleName: 'fuQianLa'): fuQianLa;

	function require(moduleName: 'tencentMap'): tencentMap;

	function require(moduleName: 'ajpush'): ajpush;

	function require(moduleName: 'snUIWeex'): snUIWeex;

	function require(moduleName: 'geeTest'): geeTest;

	function require(moduleName: 'oxLivePusher'): oxLivePusher;

	function require(moduleName: 'easylink'): easylink;

	function require(moduleName: 'bmLocation'): bmLocation;

	function require(moduleName: 'jdapp'): jdapp;

	function require(moduleName: 'live2d'): live2d;

	function require(moduleName: 'aliPay'): aliPay;

	function require(moduleName: 'mobSharePlus'): mobSharePlus;

	function require(moduleName: 'unionPay'): unionPay;

	function require(moduleName: 'iscpClient'): iscpClient;

	function require(moduleName: 'wxCard'): wxCard;

	function require(moduleName: 'qiniuLive'): qiniuLive;

	function require(moduleName: 'agoraRtc'): agoraRtc;

	function require(moduleName: 'serialPort'): serialPort;

	function require(moduleName: 'acBugtags'): acBugtags;

	function require(moduleName: 'dwzBaiduFaceLive'): dwzBaiduFaceLive;

	function require(moduleName: 'google'): google;

	function require(moduleName: 'ksisdk'): ksisdk;

	function require(moduleName: 'FaceIdDetect'): FaceIdDetect;

	function require(moduleName: 'rongCloud'): rongCloud;

	function require(moduleName: 'hwMeeting'): hwMeeting;

	function require(moduleName: 'itppayPlus'): itppayPlus;

	function require(moduleName: 'iflyRecognition'): iflyRecognition;

	function require(moduleName: 'onewayAds'): onewayAds;

	function require(moduleName: 'faceidLiveDetect'): faceidLiveDetect;

	function require(moduleName: 'txShortVideo'): txShortVideo;

	function require(moduleName: 'polyvVideo'): polyvVideo;

	function require(moduleName: 'mtlAliyunPush'): mtlAliyunPush;

	function require(moduleName: 'hanvonCloudIdCardReader'): hanvonCloudIdCardReader;

	function require(moduleName: 'qiniuRTC'): qiniuRTC;

	function require(moduleName: 'tslLed'): tslLed;

	function require(moduleName: 'acEsptouch'): acEsptouch;

	function require(moduleName: 'aliTradePlus'): aliTradePlus;

	function require(moduleName: 'scrollVideo'): scrollVideo;

	function require(moduleName: 'mgFace'): mgFace;

	function require(moduleName: 'pingpp'): pingpp;

	function require(moduleName: 'wapsAd'): wapsAd;

	function require(moduleName: 'UITxShortVideo'): UITxShortVideo;

	function require(moduleName: 'clSDKShanYanSDKModule'): clSDKShanYanSDKModule;

	function require(moduleName: 'xinstall'): xinstall;

	function require(moduleName: 'qiniuShortVideo'): qiniuShortVideo;

	function require(moduleName: 'adhub'): adhub;

	function require(moduleName: 'aMapLBS'): aMapLBS;

	function require(moduleName: 'oxVideoRecorder'): oxVideoRecorder;

	function require(moduleName: 'txLivex'): txLivex;

	function require(moduleName: 'tencentPlayers'): tencentPlayers;

	function require(moduleName: 'dxCaptcha'): dxCaptcha;

	function require(moduleName: 'mintegralAds'): mintegralAds;

	function require(moduleName: 'dxWhiteBox'): dxWhiteBox;

	function require(moduleName: 'UIYunxinIM'): UIYunxinIM;

	function require(moduleName: 'tencentTrtcLiveRoom'): tencentTrtcLiveRoom;

	function require(moduleName: 'zhuge'): zhuge;

	function require(moduleName: 'uifaceIDCard'): uifaceIDCard;

	function require(moduleName: 'falconAd'): falconAd;

	function require(moduleName: 'aMapReportLocationG'): aMapReportLocationG;

	function require(moduleName: 'flymePush'): flymePush;

	function require(moduleName: 'beecloud'): beecloud;

	function require(moduleName: 'CCShortVideo'): CCShortVideo;

	function require(moduleName: 'mapnavn'): mapnavn;

	function require(moduleName: 'bLogin'): bLogin;

	function require(moduleName: 'partnerAds'): partnerAds;

	function require(moduleName: 'detuPanoPlayer'): detuPanoPlayer;

	function require(moduleName: 'mogoAdsGDT'): mogoAdsGDT;

	function require(moduleName: 'tunnel'): tunnel;

	function require(moduleName: 'ISBCD'): ISBCD;

	function require(moduleName: 'agoraVoice'): agoraVoice;

	function require(moduleName: 'neteasePlayer'): neteasePlayer;

	function require(moduleName: 'jdPay'): jdPay;

	function require(moduleName: 'cchelperModule'): cchelperModule;

	function require(moduleName: 'pdBot'): pdBot;

	function require(moduleName: 'oppoPush'): oppoPush;

	function require(moduleName: 'weChatCameraPlus'): weChatCameraPlus;

	function require(moduleName: 'jdUnion'): jdUnion;

	function require(moduleName: 'dkSDK'): dkSDK;

	function require(moduleName: 'bdPush'): bdPush;

	function require(moduleName: 'JGsms'): JGsms;

	function require(moduleName: 'smsVerify'): smsVerify;

	function require(moduleName: 'mapleRTC'): mapleRTC;

	function require(moduleName: 'gyPrint'): gyPrint;

	function require(moduleName: 'zhBdFace'): zhBdFace;

	function require(moduleName: 'tencentOralEvaluation'): tencentOralEvaluation;

	function require(moduleName: 'bugTags'): bugTags;

	function require(moduleName: 'sangforvpn'): sangforvpn;

	function require(moduleName: 'bdFace'): bdFace;

	function require(moduleName: 'qq'): qq;

	function require(moduleName: 'appNestAgent'): appNestAgent;

	function require(moduleName: 'zhiChiSobotMall'): zhiChiSobotMall;

	function require(moduleName: 'bvRecognizer'): bvRecognizer;

	function require(moduleName: 'aMapNavi'): aMapNavi;

	function require(moduleName: 'aeetest'): aeetest;

	function require(moduleName: 'baiduTextReader'): baiduTextReader;

	function require(moduleName: 'bMap'): bMap;

	function require(moduleName: 'yyAds'): yyAds;

	function require(moduleName: 'tpnsPushPlus'): tpnsPushPlus;

	function require(moduleName: 'txFlashFileRecognize'): txFlashFileRecognize;

	function require(moduleName: 'sigmobAds'): sigmobAds;

	function require(moduleName: 'NTalker'): NTalker;

	function require(moduleName: 'ttAd'): ttAd;

	function require(moduleName: 'miniQuPaiPlus'): miniQuPaiPlus;

	function require(moduleName: 'telegram'): telegram;

	function require(moduleName: 'openIM'): openIM;

	function require(moduleName: 'mmRFModule'): mmRFModule;

	function require(moduleName: 'IDataScan'): IDataScan;

	function require(moduleName: 'txyunPlayer'): txyunPlayer;

	function require(moduleName: 'zkFinger'): zkFinger;

	function require(moduleName: 'jpushVip'): jpushVip;

	function require(moduleName: 'lBCast'): lBCast;

	function require(moduleName: 'wxSubscribe'): wxSubscribe;

	function require(moduleName: 'upyunQuickLogin'): upyunQuickLogin;

	function require(moduleName: 'iPlat4M'): iPlat4M;

	function require(moduleName: 'adView'): adView;

	function require(moduleName: 'facebookAds'): facebookAds;

	function require(moduleName: 'hkplayer'): hkplayer;

	function require(moduleName: 'UIEaseChat'): UIEaseChat;

	function require(moduleName: 'baiXing'): baiXing;

	function require(moduleName: 'aliPayPlus'): aliPayPlus;

	function require(moduleName: 'recordVideo'): recordVideo;

	function require(moduleName: 'tencentSimpleIM'): tencentSimpleIM;

	function require(moduleName: 'adnetAds'): adnetAds;

	function require(moduleName: 'ytylive'): ytylive;

	function require(moduleName: 'txPush'): txPush;

	function require(moduleName: 'aliPayTradePlus'): aliPayTradePlus;

	function require(moduleName: 'tinyPlayer'): tinyPlayer;

	function require(moduleName: 'facebookLogin'): facebookLogin;

	function require(moduleName: 'youZan'): youZan;

	function require(moduleName: 'xinyanFaceCheck'): xinyanFaceCheck;

	function require(moduleName: 'quickLogin'): quickLogin;

	function require(moduleName: 'customshare'): customshare;

	function require(moduleName: 'ximalayaT'): ximalayaT;

	function require(moduleName: 'moduleYYAds'): moduleYYAds;

	function require(moduleName: 'tencentTrtcMeeting'): tencentTrtcMeeting;

	function require(moduleName: 'txBugly'): txBugly;

	function require(moduleName: 'douyin'): douyin;

	function require(moduleName: 'JMLink'): JMLink;

	function require(moduleName: 'ccVideo'): ccVideo;

	function require(moduleName: 'magicWindow'): magicWindow;

	function require(moduleName: 'mailePointMall'): mailePointMall;

	function require(moduleName: 'leChange'): leChange;

	function require(moduleName: 'daniuPlayer'): daniuPlayer;

	function require(moduleName: 'hkIvms'): hkIvms;

	function require(moduleName: 'faceID'): faceID;

	function require(moduleName: 'tpns'): tpns;

	function require(moduleName: 'aliYunRtVoice'): aliYunRtVoice;

	function require(moduleName: 'aliPushNoUtdId'): aliPushNoUtdId;

	function require(moduleName: 'leCloudPlay'): leCloudPlay;

	function require(moduleName: 'cchelperCaiHongIM'): cchelperCaiHongIM;

	function require(moduleName: 'authorize'): authorize;

	function require(moduleName: 'tencentLivePlayer'): tencentLivePlayer;

	function require(moduleName: 'SPlayer'): SPlayer;

	function require(moduleName: 'itppay'): itppay;

	function require(moduleName: 'citconPay'): citconPay;

	function require(moduleName: 'playRtsp'): playRtsp;

	function require(moduleName: 'qiyuSdk'): qiyuSdk;

	function require(moduleName: 'dwzBytedanceImageX'): dwzBytedanceImageX;

	function require(moduleName: 'iDCardORC'): iDCardORC;

	function require(moduleName: 'ipaynow'): ipaynow;

	function require(moduleName: 'weiboPlus'): weiboPlus;

	function require(moduleName: 'line'): line;

	function require(moduleName: 'txFileRecognizer'): txFileRecognizer;

	function require(moduleName: 'meisheVideo'): meisheVideo;

	function require(moduleName: 'mitt'): mitt;

	function require(moduleName: 'pinke'): pinke;

	function require(moduleName: 'iflyEva'): iflyEva;

	function require(moduleName: 'UIBdOcr'): UIBdOcr;

	function require(moduleName: 'jdFace'): jdFace;

	function require(moduleName: 'tulingapi'): tulingapi;

	function require(moduleName: 'talkFun'): talkFun;

	function require(moduleName: 'aMapNaviPlus'): aMapNaviPlus;

	function require(moduleName: 'hmsAds'): hmsAds;

	function require(moduleName: 'jAnalytics'): jAnalytics;

	function require(moduleName: 'baiduFaceRec'): baiduFaceRec;

	function require(moduleName: 'moduleCard'): moduleCard;

	function require(moduleName: 'aMapReportLocation'): aMapReportLocation;

	function require(moduleName: 'mipush'): mipush;

	function require(moduleName: 'cloudwiseMAgent'): cloudwiseMAgent;

	function require(moduleName: 'wxImageRecognizer'): wxImageRecognizer;

	function require(moduleName: 'detuPanorama'): detuPanorama;

	interface api_historyBack_Params {
		/**（可选项）frame 名称，若不传则表示对当前页面进行操作*/ 
		frameName: string;

		/**（可选项）是否只查询。为 true 时表示只查询是否可以后退，而不进行后退操作*/ 
		query: boolean;

	}
	/**
	 * `当前 window 或者 frame 的 a 标签历史记录后退一页`
	 * ========params==========
	 *
	 * `frameName` :string : （可选项）frame 名称，若不传则表示对当前页面进行操作
	 *
	 * `query` :boolean : （可选项）是否只查询。为 true 时表示只查询是否可以后退，而不进行后退操作
	 */
	function historyBack(option: api_historyBack_Params):void;

	interface api_historyForward_Params {
		/**（可选项）frame 名称，若不传则表示对当前页面进行操作*/ 
		frameName: string;

		/**（可选项）是否只查询。为 true 时表示只查询是否可以前进，而不进行前进操作*/ 
		query: boolean;

	}
	/**
	 * `当前 window 或者 frame 的 a 标签历史记录前进一页`
	 * ========params==========
	 *
	 * `frameName` :string : （可选项）frame 名称，若不传则表示对当前页面进行操作
	 *
	 * `query` :boolean : （可选项）是否只查询。为 true 时表示只查询是否可以前进，而不进行前进操作
	 */
	function historyForward(option: api_historyForward_Params):void;

	interface api_pageUp_Params {
		/**（可选项）是否直接滚动到最顶部*/ 
		top: boolean;

	}
	/**
	 * `页面向上滚动一页`
	 * ========params==========
	 *
	 * `top` :boolean : （可选项）是否直接滚动到最顶部
	 */
	function pageUp(option: api_pageUp_Params):void;

	interface api_pageDown_Params {
		/**（可选项）是否直接滚动到最底部*/ 
		bottom: boolean;

	}
	/**
	 * `页面向下滚动一页`
	 * ========params==========
	 *
	 * `bottom` :boolean : （可选项）是否直接滚动到最底部
	 */
	function pageDown(option: api_pageDown_Params):void;

	interface api_setFocus_Params {
		/**input标签id*/ 
		inputId: string;

		/**是否获取焦点*/ 
		focus: boolean;

	}
	/**
	 * `设置input是否获取焦点`
	 * ========params==========
	 *
	 * `inputId` :string : input标签id
	 *
	 * `focus` :boolean : 是否获取焦点
	 */
	function setFocus(option: api_setFocus_Params):void;

	function agreedPrivacy():void;

            /**
 * `监听网络状态变化事件`
 */ 
            function onNetworkStatusChange():void;
            /**
 * `移除网络状态变化事件的监听函数。`
 */ 
            function offNetworkStatusChange():void;
            /**
 * `监听用户主动截屏事件。用户使用系统截屏按键截屏时触发，只能注册一个监听`
 */ 
            function onUserCaptureScreen():void;
            /**
 * `自定义分享，不提供页面组件，支持将特定信息分享到不同平台，包括友空间消息、友空间动态、微信、QQ。`
 */ 
            function offUserCaptureScreen():void;
            interface getAppInformation_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `获取应用信息。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function getAppInformation(option: getAppInformation_Params):void;
            interface getSystemInfo_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `获取系统信息。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function getSystemInfo(option: getSystemInfo_Params):void;
            interface chooseCity_Params {
            
                        /**默认选择省份（严格按照国家命名传入）'*/
                        province: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `选择省份、城市信息。`
 * ========params==========
 *
 * `province` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function chooseCity(option: chooseCity_Params):void;
            interface commonReplyComponent_Params {
            
                        /**被回复对象的名字'*/
                        replyName: string,
                        /**限定人员范围'*/
                        memberArray: Array,
                        /**空间 id'*/
                        qzId: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `通用的评论组件，支持文字，图片，语音，视频，附件。`
 * ========params==========
 *
 * `replyName` :string : (可选项) 
 *
 * `memberArray` :objectarray : (可选项) 
 *
 * `qzId` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function commonReplyComponent(option: commonReplyComponent_Params):void;
            interface clearStorage_Params {
            
                        /**缓存数据的域'*/
                        domain: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `清理本地数据缓存。`
 * ========params==========
 *
 * `domain` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function clearStorage(option: clearStorage_Params):void;
            interface executeDBOperate_Params {
            
                        /**执行SQL类型(0:建表；1:删表；2:新增数据；3:删除数据；4:更新数据；5:查询数据 6:修改表（友空间6.2.5及以上版本）)'*/
                        executeType: string,
                        /**执行SQL语句(业务方控制该sql安全性，创建表格要求表名字前缀为NCC_)'*/
                        executeSql: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `执行数据库操作、建表、增删改查，SQL语句业务方操作。`
 * ========params==========
 *
 * `executeType` :string : (可选项) 
 *
 * `executeSql` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function executeDBOperate(option: executeDBOperate_Params):void;
            interface getStorage_Params {
            
                        /**缓存数据的 key'*/
                        key: string,
                        /**缓存数据的域'*/
                        domain: string,
                        /**是否开启加密存储。只有异步的 getStorage 接口支持开启加密存储。开启后，将会对 data 使用 AES128 解密，接口回调耗时将会增加。若开启加密存储，setStorage 和 getStorage 需要同时声明 encrypt 的值为 true'*/
                        encrypt: boolean,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `从本地缓存中异步获取指定 key 的内容。`
 * ========params==========
 *
 * `key` :string : (可选项) 
 *
 * `domain` :string : (可选项) 
 *
 * `encrypt` :boolean : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function getStorage(option: getStorage_Params):void;
            interface removeStorage_Params {
            
                        /**缓存数据的 key'*/
                        key: string,
                        /**缓存数据的域'*/
                        domain: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `从本地缓存中移除指定 key。`
 * ========params==========
 *
 * `key` :string : (可选项) 
 *
 * `domain` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function removeStorage(option: removeStorage_Params):void;
            interface setStorage_Params {
            
                        /**缓存数据的key'*/
                        key: string,
                       /**需要存储的内容。只支持基本数据类型、及能够通过 JSON.stringify 序列化的对象。'*/
                        data: any ,
                        /**缓存数据的域'*/
                        domain: string,
                        /**是否开启加密存储。只有异步的 setStorage 接口支持开启加密存储。开启后，将会对 data 使用 AES128 加密，接口回调耗时将会增加。若开启加密存储，setStorage 和 getStorage 需要同时声明 encrypt 的值为 true。此外，由于加密后的数据会比原始数据膨胀1.4倍，因此开启 encrypt 的情况下，单个 key 允许存储的最大数据长度为 0.7MB，所有数据存储上限为 7.1MB'*/
                        encrypt: boolean,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `将数据存储在本地缓存中指定的 key 和 domain 中，会覆盖掉原来该 key 和 domain 对应的数据。`
 * ========params==========
 *
 * `key` :string : (可选项) 
 *
 * `data` :any : (可选项) 
 *
 * `domain` :string : (可选项) 
 *
 * `encrypt` :boolean : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function setStorage(option: setStorage_Params):void;
            interface bindSensor_Params {
            
                        /**要绑定设备的 mac 地址'*/
                        address: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `恩普特搜索蓝牙设备。只 Android 支持。`
 * ========params==========
 *
 * `address` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function bindSensor(option: bindSensor_Params):void;
            interface blueToothConnect_Params {
            
                        /**需要连接的设备标识'*/
                        deviceIndentify: string,
                        /**需要连接的蓝牙设备名字'*/
                        deviceName: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `连接蓝牙打印机。`
 * ========params==========
 *
 * `deviceIndentify` :string : (可选项) 
 *
 * `deviceName` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function blueToothConnect(option: blueToothConnect_Params):void;
            interface blueToothConnectState_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `获得当前蓝牙连接状态，如果当前有连接蓝牙打印机则返回连接的蓝牙打印机信息。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function blueToothConnectState(option: blueToothConnectState_Params):void;
            interface blueToothDisConnect_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `断开当前连接的蓝牙打印机。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function blueToothDisConnect(option: blueToothDisConnect_Params):void;
            interface blueToothPrint_Params {
            
                        /**打印的页数'*/
                        printNum: number,
                        /**打印的内容列表'*/
                        content: Array,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `打印当前连接的蓝牙打印机。`
 * ========params==========
 *
 * `printNum` :number : (可选项) 
 *
 * `content` :objectarray : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function blueToothPrint(option: blueToothPrint_Params):void;
            interface blueToothScan_Params {
            
                        /**持续获取蓝牙扫描信息的回调函数'*/
                        callback():void ,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `获得当前蓝牙连接状态，如果当前有连接蓝牙打印机则返回连接的蓝牙打印机信息。`
 * ========params==========
 *
 * `callback` :function : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function blueToothScan(option: blueToothScan_Params):void;
            interface blueToothStopScan_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `停止扫描蓝牙打印机。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function blueToothStopScan(option: blueToothStopScan_Params):void;
            interface closeConnect_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `关闭映美打印设备连接，调用该方法会关闭与打印机的通信，未发送完的数据会丢失，应当在不需要连接的时候使用。只支持 Android。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function closeConnect(option: closeConnect_Params):void;
            interface collectRev_Params {
            
                        /**采集到转速时回调的函数'*/
                        callback():void ,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `恩普特转速采集。只 Android 支持。`
 * ========params==========
 *
 * `callback` :function : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function collectRev(option: collectRev_Params):void;
            interface collectTmp_Params {
            
                        /**发射率（0~1）'*/
                        emissivity: string,
                        /**采集到温度时回调的函数'*/
                        callback():void ,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `恩普特温度采集。只 Android 支持。`
 * ========params==========
 *
 * `emissivity` :string : (可选项) 
 *
 * `callback` :function : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function collectTmp(option: collectTmp_Params):void;
            interface collectVib_Params {
            
                        /**采集类型'*/
                        collectionType: string,
                        /**是否采集波值'*/
                        savewave: boolean,
                        /**采集到测振时回调的函数'*/
                        callback():void ,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `恩普特测振采集。只 Android 支持。`
 * ========params==========
 *
 * `collectionType` :string : (可选项) 
 *
 * `savewave` :boolean : (可选项) 
 *
 * `callback` :function : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function collectVib(option: collectVib_Params):void;
            interface connectBle_Params {
            
                        /**需要连接的设备 mac 地址'*/
                        address: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `恩普特连接设备。只 Android 支持。`
 * ========params==========
 *
 * `address` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function connectBle(option: connectBle_Params):void;
            interface disconnectBle_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `恩普特断开连接。只 Android 支持。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function disconnectBle(option: disconnectBle_Params):void;
            interface getBindedSensor_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `恩普特获取绑定设备的 macAddress。只 Android 支持。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function getBindedSensor(option: getBindedSensor_Params):void;
            interface getBlueToothState_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `获取蓝牙打开状态。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function getBlueToothState(option: getBlueToothState_Params):void;
            interface getConnectStatus_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `恩普特获取连接状态。只 Android 支持。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function getConnectStatus(option: getConnectStatus_Params):void;
            interface getConnectedDevice_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `获取已连接的映美打印设备信息。sdk 未提供建立连接的接口，打印时可以先调用此方法判断是否已经建立连接，已经建立连接的话可以直接打印。只支持 Android。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function getConnectedDevice(option: getConnectedDevice_Params):void;
            interface isSupportedBLE_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `是否支持蓝牙 BLE。只支持 Android。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function isSupportedBLE(option: isSupportedBLE_Params):void;
            interface printFile_Params {
            
                         /**searchDevices 方法中返回的 deviceInfos 中的任意一个都可以选择'*/
                        deviceInfo: Object,
                        /**打印份数'*/
                        copies: number,
                        /**打印纸张类型，1：热敏  2：标签  3:带孔 （局域网 HTL 打印有效）'*/
                        paperType: number,
                        /**打印宽度， 单位毫米（局域网 HTL 打印有效）'*/
                        paperWidth: number,
                        /**打印高度， 单位毫米（局域网 HTL 打印有效）'*/
                        paperHeight: number,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `打开系统的文件选择器，选择一个文件发送到映美设备打印，只支持图片、html 文件；pdf 需要转成图片后才能打印。打印图片大小不能超过 600K，图片格式为 jpg、png。只支持 Android。`
 * ========params==========
 *
 * `deviceInfo` :object : (可选项) 
 *
 * `copies` :number : (可选项) 
 *
 * `paperType` :number : (可选项) 
 *
 * `paperWidth` :number : (可选项) 
 *
 * `paperHeight` :number : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function printFile(option: printFile_Params):void;
            interface printHTML_Params {
            
                         /**searchDevices 方法中返回的 deviceInfos 中的任意一个都可以选择'*/
                        deviceInfo: Object,
                        /**图片路径'*/
                        path: string,
                        /**打印份数'*/
                        copies: number,
                        /**打印纸张类型，1：热敏  2：标签  3:带孔 （局域网 HTL 打印有效）'*/
                        paperType: number,
                        /**打印宽度， 单位毫米（局域网 HTL 打印有效）'*/
                        paperWidth: number,
                        /**打印高度， 单位毫米（局域网 HTL 打印有效）'*/
                        paperHeight: number,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `打印 html，和映美技术人员确认，CFP-820BW 只支持 wifi 链接打印；支持标准规范的 html 标签，样式只能支持到 IE11 内核，可以打印表格数据以及标准规范排版页面，html 页面的 body 宽度不大于打印机的纸张宽度值，body 宽度的像素最大值等于纸张宽度*打印机 dpi/25.4 打印机的 dpi 值。CFP-820BW 的 dpi 值为 180。只支持 Android。`
 * ========params==========
 *
 * `deviceInfo` :object : (可选项) 
 *
 * `path` :string : (可选项) 
 *
 * `copies` :number : (可选项) 
 *
 * `paperType` :number : (可选项) 
 *
 * `paperWidth` :number : (可选项) 
 *
 * `paperHeight` :number : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function printHTML(option: printHTML_Params):void;
            interface printPicture_Params {
            
                         /**searchDevices 方法中返回的 deviceInfos 中的任意一个都可以选择'*/
                        deviceInfo: Object,
                        /**图片路径'*/
                        path: string,
                        /**打印份数'*/
                        copies: number,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `使用映美打印设备打印图片, 注意图片仅支持 png 和 jpg 格式的，大小有限制，不能超过 600K。只支持 Android。`
 * ========params==========
 *
 * `deviceInfo` :object : (可选项) 
 *
 * `path` :string : (可选项) 
 *
 * `copies` :number : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function printPicture(option: printPicture_Params):void;
            interface registerConnectStatusListener_Params {
            
                        /**当前绑定的传感器连接状态变化时的回调函数'*/
                        callback():void ,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `恩普特连接状态监听。只 Android 支持。`
 * ========params==========
 *
 * `callback` :function : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function registerConnectStatusListener(option: registerConnectStatusListener_Params):void;
            interface releaseBle_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `恩普特释放资源。只 Android 支持。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function releaseBle(option: releaseBle_Params):void;
            interface releaseYmPrinter_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `释放映美打印资源，调用该方法会关闭与打印机的通信，日志写入也会停止。可以在 APP 退出或页面关闭时调用。只支持 Android。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function releaseYmPrinter(option: releaseYmPrinter_Params):void;
            interface searchBleClient_Params {
            
                        /**每次扫描的时长，单位毫秒'*/
                        searchTime: number,
                        /**扫描 BLE 设备的次数'*/
                        searchCount: number,
                        /**搜索到蓝牙设备时的回调函数'*/
                        callback():void ,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `恩普特搜索蓝牙设备。只 Android 支持。`
 * ========params==========
 *
 * `searchTime` :number : (可选项) 
 *
 * `searchCount` :number : (可选项) 
 *
 * `callback` :function : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function searchBleClient(option: searchBleClient_Params):void;
            interface searchDevices_Params {
            
                        /**搜索类型。打印效果 wifi > classic > ble，使用 ble 打印图片数据量较大时可能会出现数据丢包出现打印乱码的现象，搜索不到打印机 wifi 的时候需要扫描打印机上的二维码重新配网'*/
                        type: string,
                        /**搜索超时时间，默认10秒，超出时间后没有搜索到可用设备时需要重新搜索'*/
                        time: number,
                        /**搜索的回调函数'*/
                        callback():void ,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `搜索可用的映美打印设备，需要手机开启蓝牙和位置；使用局域网 wifi，需要先扫描打印机上的二维码，配置网络。只支持 Android。`
 * ========params==========
 *
 * `type` :string : (可选项) 
 *
 * `time` :number : (可选项) 
 *
 * `callback` :function : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function searchDevices(option: searchDevices_Params):void;
            interface stopCollect_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `恩普特停止采集。只 Android 支持。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function stopCollect(option: stopCollect_Params):void;
            interface stopSearch_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `停止搜索映美打印设备。只支持 Android。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function stopSearch(option: stopSearch_Params):void;
            interface getClipboardData_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `获取系统剪贴板的内容。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function getClipboardData(option: getClipboardData_Params):void;
            interface setClipboardData_Params {
            
                        /**剪贴板的内容'*/
                        data: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `设置系统剪贴板的内容。`
 * ========params==========
 *
 * `data` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function setClipboardData(option: setClipboardData_Params):void;
            interface createShortcut_Params {
            
                        /**快捷方式的对应页面的 url'*/
                        url: string,
                        /**快捷方式名称'*/
                        name: string,
                        /**快捷方式图标'*/
                        icon: string,
                        /**快捷方式的对应页面的标题'*/
                        title: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `android 端为轻应用创建桌面快捷方式。`
 * ========params==========
 *
 * `url` :string : (可选项) 
 *
 * `name` :string : (可选项) 
 *
 * `icon` :string : (可选项) 
 *
 * `title` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function createShortcut(option: createShortcut_Params):void;
            interface jumpToSystemSetting_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `跳转到系统设置。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function jumpToSystemSetting(option: jumpToSystemSetting_Params):void;
            interface getNetworkType_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `获取网络类型。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function getNetworkType(option: getNetworkType_Params):void;
            interface rfidConnect_Params {
            
                        /**RFID 连接成功后扫描到标签后的回调函数'*/
                        callback():void ,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `斑马 PDA 连接 RFID 设备，并监听标签数据。只 Android 支持。`
 * ========params==========
 *
 * `callback` :function : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function rfidConnect(option: rfidConnect_Params):void;
            interface rfidDisconnect_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `斑马 PDA 断开连接 RFID 设备。只 Android 支持。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function rfidDisconnect(option: rfidDisconnect_Params):void;
            interface startPDAScan_Params {
            
                        /**PDA 设备扫描成功的回调函数'*/
                        callback():void ,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `开始监听PDA设备扫描。只 Android 支持。`
 * ========params==========
 *
 * `callback` :function : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function startPDAScan(option: startPDAScan_Params):void;
            interface stopPDAScan_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `停止监听 PDA 设备扫描。只 Android 支持。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function stopPDAScan(option: stopPDAScan_Params):void;
            interface zebraPrintImage_Params {
            
                        /**图片数据base64编码后的数组JSON字符串'*/
                        images: string,
                        /**打印设备mac地址'*/
                        serialNumber: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `斑马蓝牙打印图片。`
 * ========params==========
 *
 * `images` :string : (可选项) 
 *
 * `serialNumber` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function zebraPrintImage(option: zebraPrintImage_Params):void;
            interface zebraPrinterList_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `斑马蓝牙打印机扫描设备。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function zebraPrinterList(option: zebraPrinterList_Params):void;
            interface makePhoneCall_Params {
            
                        /**需要拨打的电话号码'*/
                        phoneNumber: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `拨打电话。`
 * ========params==========
 *
 * `phoneNumber` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function makePhoneCall(option: makePhoneCall_Params):void;
            interface mdfChangeCustomScanMode_Params {
            
                        /**切换当前页面扫描方式，0: 单次 1: 连续'*/
                        type: number,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `悬浮扫描页面进行页面级扫描模式切换，可动态设置为单次扫描/连续扫描。`
 * ========params==========
 *
 * `type` :number : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function mdfChangeCustomScanMode(option: mdfChangeCustomScanMode_Params):void;
            interface mdfChangeFlashLightStatus_Params {
            
                        /**自定义扫描页面的闪光灯状态，0: 关闭 1: 开启'*/
                        type: number,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `改变 mdf 悬浮扫描页面的闪光灯状态，可动态设置为开启/关闭。`
 * ========params==========
 *
 * `type` :number : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function mdfChangeFlashLightStatus(option: mdfChangeFlashLightStatus_Params):void;
            interface mdfCustomScanQRCode_Params {
            
                        /**是否隐藏悬浮扫描框，0:显示 1:隐藏'*/
                        hide: number,
                        /**扫描方式，0:单次 1:连续，需调用 callback 参数指定方法开启下次扫描'*/
                        type: number,
                        /**扫描框左边与屏幕左边的间距占屏幕宽度的比例，范围[0, 1]'*/
                        scanLeftRatio: number,
                        /**扫描框顶部与屏幕顶部的间距占屏幕高度的比例，范围[0, 1]'*/
                        scanTopRatio: number,
                        /**扫描框宽度占屏幕宽度的比例，范围[0, 1]'*/
                        scanWidthRatio: number,
                        /**扫描框高度占屏幕高度的比例，范围[0, 1]，为 0 时设置扫描框为正方形，扫描框高度等于扫描框宽度'*/
                        scanHeightRatio: number,
                        /**扫码结果的回调函数，要使连续扫码生效，必须在本方法中调用返回的回调，才会发起下一次扫码'*/
                        callback():void ,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `调用扫一扫功能，对二维码或者条码进行扫描，可定制扫描框的位置和大小。`
 * ========params==========
 *
 * `hide` :number : (可选项) 
 *
 * `type` :number : (可选项) 
 *
 * `scanLeftRatio` :number : (可选项) 
 *
 * `scanTopRatio` :number : (可选项) 
 *
 * `scanWidthRatio` :number : (可选项) 
 *
 * `scanHeightRatio` :number : (可选项) 
 *
 * `callback` :function : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function mdfCustomScanQRCode(option: mdfCustomScanQRCode_Params):void;
            interface scanCode_Params {
            
                        /**是否只能从相机扫码，不允许从相册选择图片'*/
                        onlyFromCamera: boolean,
                        /**扫码类型'*/
                        scanType: Array,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `调起扫码界面进行扫码。`
 * ========params==========
 *
 * `onlyFromCamera` :boolean : (可选项) 
 *
 * `scanType` :stringarray : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function scanCode(option: scanCode_Params):void;
            interface toggleCamera_Params {
            
                        /**设置摄像头状态，0: 关闭 1: 开启'*/
                        type: number,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `自定义扫描页面开关摄像头。`
 * ========params==========
 *
 * `type` :number : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function toggleCamera(option: toggleCamera_Params):void;
            interface vibrateLong_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `使手机发生较长时间的震动（400 ms)。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function vibrateLong(option: vibrateLong_Params):void;
            interface vibrateShort_Params {
            
                        /**震动强度类型，有效值为：heavy、medium、light'*/
                        type: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `使手机发生较短时间的震动（15 ms）。`
 * ========params==========
 *
 * `type` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function vibrateShort(option: vibrateShort_Params):void;
            interface recordAudio_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `提供录音界面以及功能，支持最长 60s 录音，返回经过 base64 编码处理后的音频数据。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function recordAudio(option: recordAudio_Params):void;
            interface addImageWaterMark_Params {
            
                        /**图片路径'*/
                        image: string,
                         /**照片添加水印'*/
                        watermark: Object,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `给图片添加水印。`
 * ========params==========
 *
 * `image` :string : (可选项) 
 *
 * `watermark` :object : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function addImageWaterMark(option: addImageWaterMark_Params):void;
            interface chooseImage_Params {
            
                        /**最多可以选择的图片张数'*/
                        count: number,
                        /**选择图片的来源，album 从相册选图，camera 为使用相机'*/
                        sourceType: Array,
                        /**所选的图片的尺寸，original 为原图，compressed 为压缩图'*/
                        sizeType: Array,
                         /**照片添加水印，只有拍照功能下生效'*/
                        watermark: Object,
                        /**是否需要返回缩略图（gif 图不返回）'*/
                        returnThumbnail: boolean,
                        /**iOS 判断是否启用高清缓存。开启高清缓存策略和 watermark 互为互斥条件，即 1. 当开启高清缓存时，watermark 字段必须为空 2. 当使用 watermark 时，高清缓存必为关闭状态'*/
                        openHdCache: boolean,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `从本地相册选择图片或使用相机拍照。`
 * ========params==========
 *
 * `count` :number : (可选项) 
 *
 * `sourceType` :stringarray : (可选项) 
 *
 * `sizeType` :stringarray : (可选项) 
 *
 * `watermark` :object : (可选项) 
 *
 * `returnThumbnail` :boolean : (可选项) 
 *
 * `openHdCache` :boolean : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function chooseImage(option: chooseImage_Params):void;
            interface chooseImageToServer_Params {
            
                        /**最多可以选择的图片张数'*/
                        count: number,
                        /**选择图片的来源，album 从相册选图，camera 为使用相机'*/
                        sourceType: Array,
                        /**所选的图片的尺寸，original 为原图，compressed 为压缩图'*/
                        sizeType: Array,
                         /**照片添加水印，只有拍照功能下生效'*/
                        watermark: Object,
                        /**租户 ID'*/
                        tenantId: string,
                        /**是不是弱网，0 否，1 是'*/
                        weakNet: number,
                        /**图片压缩质量，0-100，0 表示不压缩'*/
                        quality: number,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `从本地相册选择图片或使用相机拍照，并把文件上传到友空间服务器，返回视频链接地址和信息。`
 * ========params==========
 *
 * `count` :number : (可选项) 
 *
 * `sourceType` :stringarray : (可选项) 
 *
 * `sizeType` :stringarray : (可选项) 
 *
 * `watermark` :object : (可选项) 
 *
 * `tenantId` :string : (可选项) 
 *
 * `weakNet` :number : (可选项) 
 *
 * `quality` :number : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function chooseImageToServer(option: chooseImageToServer_Params):void;
            interface compressLocalImage_Params {
            
                        /**图片数据类型（0 或 1）'*/
                        type: number,
                        /**压缩的级别，支持 0 ~ 3 的整数'*/
                        level: number,
                        /**图片地址或 base64 数据'*/
                        imgData: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `图片压缩（不支持 gif 压缩）。`
 * ========params==========
 *
 * `type` :number : (可选项) 
 *
 * `level` :number : (可选项) 
 *
 * `imgData` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function compressLocalImage(option: compressLocalImage_Params):void;
            interface continuousShooting_Params {
            
                        /**最多可以连拍的图片张数，最多支持 9'*/
                        count: number,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `使用相机拍照连拍多张照片，并把文件上传到友空间服务器，返回图片链接地址和信息。`
 * ========params==========
 *
 * `count` :number : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function continuousShooting(option: continuousShooting_Params):void;
            interface continuousShootingLocal_Params {
            
                        /**连拍数量，取值范围[0,9]'*/
                        count: string,
                        /**图片质量，取值范围[0,100]'*/
                        quality: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `连拍。`
 * ========params==========
 *
 * `count` :string : (可选项) 
 *
 * `quality` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function continuousShootingLocal(option: continuousShootingLocal_Params):void;
            interface deleteBase64Image_Params {
            
                        /**图片的名称'*/
                        name: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `删除本地的 base64 图片。`
 * ========params==========
 *
 * `name` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function deleteBase64Image(option: deleteBase64Image_Params):void;
            interface getBase64Image_Params {
            
                        /**图片的名称'*/
                        name: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `获取本地的 base64 字符串数据。`
 * ========params==========
 *
 * `name` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function getBase64Image(option: getBase64Image_Params):void;
            interface loadImageFromLocal_Params {
            
                        /**图片的文件服务器地址'*/
                        url: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `读取本地已保存的图片，以 base64 流的形式返回。（场景为弱网情况下需要展示图片，服务器图片请求超时则取本地图片）。`
 * ========params==========
 *
 * `url` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function loadImageFromLocal(option: loadImageFromLocal_Params):void;
            interface previewImage_Params {
            
                        /**需要预览的图片链接列表'*/
                        urls: Array,
                        /**是否显示长按菜单'*/
                        showmenu: boolean,
                        /**当前显示图片的链接'*/
                        current: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `预览图片。`
 * ========params==========
 *
 * `urls` :stringarray : (可选项) 
 *
 * `showmenu` :boolean : (可选项) 
 *
 * `current` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function previewImage(option: previewImage_Params):void;
            interface saveBase64Image_Params {
            
                        /**图片的名称'*/
                        name: string,
                        /**图片的 base64 数据'*/
                        base64str: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `将图片的 base64 字符串以图片形式存储到本地。`
 * ========params==========
 *
 * `name` :string : (可选项) 
 *
 * `base64str` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function saveBase64Image(option: saveBase64Image_Params):void;
            interface saveImageToLocal_Params {
            
                        /**图片的文件服务器地址'*/
                        url: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `将服务器的图片数据存储到本地。`
 * ========params==========
 *
 * `url` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function saveImageToLocal(option: saveImageToLocal_Params):void;
            interface chooseVideo_Params {
            
                        /**选择图片的来源，album 从相册选图，camera 为使用相机'*/
                        sourceType: Array,
                        /**拍摄视频最长拍摄时间，单位秒'*/
                        maxDuration: number,
                        /**是否压缩所选择的视频文件'*/
                        compressed: boolean,
                        /**默认拉起的是前置或者后置摄像头。部分 Android 手机下由于系统 ROM 不支持无法生效'*/
                        camera: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `拍摄视频或从手机相册中选视频。`
 * ========params==========
 *
 * `sourceType` :stringarray : (可选项) 
 *
 * `maxDuration` :number : (可选项) 
 *
 * `compressed` :boolean : (可选项) 
 *
 * `camera` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function chooseVideo(option: chooseVideo_Params):void;
            interface chooseVideoToServer_Params {
            
                        /**选择图片的来源，album 从相册选图，camera 为使用相机'*/
                        sourceType: Array,
                        /**拍摄视频最长拍摄时间，单位秒'*/
                        maxDuration: number,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `拍摄视频或从手机相册中选视频，并将视频文件上传到友空间服务器。`
 * ========params==========
 *
 * `sourceType` :stringarray : (可选项) 
 *
 * `maxDuration` :number : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function chooseVideoToServer(option: chooseVideoToServer_Params):void;
            interface getVideoThumbnail_Params {
            
                        /**本地视频的地址'*/
                        videoPath: string,
                        /**缩略图质量（0-100）'*/
                        thumbnailQuality: number,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `获取视频缩略图，返回缩略图的 base64 编码数据。`
 * ========params==========
 *
 * `videoPath` :string : (可选项) 
 *
 * `thumbnailQuality` :number : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function getVideoThumbnail(option: getVideoThumbnail_Params):void;
            interface navigateBack_Params {
            
                        /**返回的页面数，如果 delta 大于现有页面数，则返回到首页'*/
                        delta: number,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `关闭当前页面，返回上一页面或多级页面。`
 * ========params==========
 *
 * `delta` :number : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function navigateBack(option: navigateBack_Params):void;
            interface navigateTo_Params {
            
                        /**需要跳转的应用内非 tabBar 的页面的路径 (代码包路径), 路径后可以带参数。参数与路径之间使用 ? 分隔，参数键与参数值用 = 相连，不同参数用 & 分隔；如 'path?key=value&key2=value2''*/
                        url: string,
                       /**页面间通信接口，用于监听被打开页面发送到当前页面的数据'*/
                        events: any ,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `保留当前页面，跳转到应用内的某个页面。`
 * ========params==========
 *
 * `url` :string : (可选项) 
 *
 * `events` :Object : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function navigateTo(option: navigateTo_Params):void;
            interface reLaunch_Params {
            
                        /**需要跳转的应用内非 tabBar 的页面的路径 (代码包路径), 路径后可以带参数。参数与路径之间使用 ? 分隔，参数键与参数值用 = 相连，不同参数用 & 分隔；如 'path?key=value&key2=value2''*/
                        url: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `关闭所有页面，打开到应用内的某个页面。`
 * ========params==========
 *
 * `url` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function reLaunch(option: reLaunch_Params):void;
            interface redirectTo_Params {
            
                        /**需要跳转的应用内非 tabBar 的页面的路径 (代码包路径), 路径后可以带参数。参数与路径之间使用 ? 分隔，参数键与参数值用 = 相连，不同参数用 & 分隔；如 'path?key=value&key2=value2''*/
                        url: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `关闭当前页面，跳转到应用内的某个页面。但是不允许跳转到 tabbar 页面。`
 * ========params==========
 *
 * `url` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function redirectTo(option: redirectTo_Params):void;
            interface chooseLocation_Params {
            
                        /**目标地纬度'*/
                        latitude: number,
                        /**目标地经度'*/
                        longitude: number,
                        /**查询半径（单位：米），小于0时不限制'*/
                        searchRadius: number,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `打开地图选择位置。`
 * ========params==========
 *
 * `latitude` :number : (可选项) 
 *
 * `longitude` :number : (可选项) 
 *
 * `searchRadius` :number : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function chooseLocation(option: chooseLocation_Params):void;
            interface getLocationInfo_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `获取当前的地理位置信息，系统会根据当前手机所处位置使用不同坐标系，国内使用高德地图坐标系，国外使用WGS-84坐标系。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function getLocationInfo(option: getLocationInfo_Params):void;
            interface getLocationUpdateInfo_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `获取持续定位的位置信息。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function getLocationUpdateInfo(option: getLocationUpdateInfo_Params):void;
            interface mapLocationExtend_Params {
            
                        /**纬度'*/
                        latitude: string,
                        /**经度'*/
                        longitude: string,
                        /**目标距离，单位米'*/
                        targetDistance: number,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `地图定位扩展。`
 * ========params==========
 *
 * `latitude` :string : (可选项) 
 *
 * `longitude` :string : (可选项) 
 *
 * `targetDistance` :number : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function mapLocationExtend(option: mapLocationExtend_Params):void;
            interface markAndNavigationDestination_Params {
            
                        /**目标地区地址'*/
                        address: string,
                        /**目标地区详细地址'*/
                        subAddress: string,
                        /**目标地纬度'*/
                        latitude: string,
                        /**目标地经度'*/
                        longitude: string,
                         /**用户信息'*/
                        userInfo: Object,
                        /**客户信息'*/
                        infomation: string,
                        /**是否需要导航'*/
                        navigation: boolean,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `在地图中展示目标点以及跳转第三方地图进行导航。`
 * ========params==========
 *
 * `address` :string : (可选项) 
 *
 * `subAddress` :string : (可选项) 
 *
 * `latitude` :string : (可选项) 
 *
 * `longitude` :string : (可选项) 
 *
 * `userInfo` :object : (可选项) 
 *
 * `infomation` :string : (可选项) 
 *
 * `navigation` :boolean : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function markAndNavigationDestination(option: markAndNavigationDestination_Params):void;
            interface startLocationUpdate_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `开启持续定位。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function startLocationUpdate(option: startLocationUpdate_Params):void;
            interface stopLocationUpdate_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `停止持续定位。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function stopLocationUpdate(option: stopLocationUpdate_Params):void;
            interface chooseFileFromLibrary_Params {
            
                        /**选择类型，0 从文库列表和传输列表选择，1 从文库列表选择，2 从传输列表选择'*/
                        type: number,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `从文库和文件传输列表中选择文件，返回文件信息。`
 * ========params==========
 *
 * `type` :number : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function chooseFileFromLibrary(option: chooseFileFromLibrary_Params):void;
            interface chooseLocalFileToServer_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `选取本地文件，上传到友空间服务器，并返回文件名称、路径、类型等信息。 android：最大可选数为 5，所选文件不大于 100MB，且不能为空。iOS：选择 iCloud 文件，仅支持单选文件，所选文件不大于 100MB，且不能为空。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function chooseLocalFileToServer(option: chooseLocalFileToServer_Params):void;
            interface chooseLocalFiles_Params {
            
                        /**iOS 默认是 1，且无法修改数量，android 可以选择文件的最大数量是 5，不能超过 5'*/
                        maxNumber: number,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `选取本地文件，并返回文件本地路径。`
 * ========params==========
 *
 * `maxNumber` :number : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function chooseLocalFiles(option: chooseLocalFiles_Params):void;
            interface isFileExist_Params {
            
                        /**本地文件路径'*/
                        filePath: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `获取本地文件是否存在。`
 * ========params==========
 *
 * `filePath` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function isFileExist(option: isFileExist_Params):void;
            interface openDocument_Params {
            
                        /**文件路径 (本地路径)'*/
                        filePath: string,
                        /**文件类型，指定文件类型打开文件，支持 doc、docx、xls、xlsx、ppt、pptx、pdf 等'*/
                        fileType: string,
                        /**是否显示右上角菜单'*/
                        showMenu: boolean,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `打开文档。`
 * ========params==========
 *
 * `filePath` :string : (可选项) 
 *
 * `fileType` :string : (可选项) 
 *
 * `showMenu` :boolean : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function openDocument(option: openDocument_Params):void;
            interface previewDoc_Params {
            
                        /**文件 id'*/
                        fileId: string,
                        /**文件来源，0：来自文库，1：IM，2：web，3：项目，4：旧IM，6：公告附件，7：新NC预览，8：任务预览'*/
                        fromType: number,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `提供文件下载 url 或者文件 fid，实现文件的预览，界面可包含下载等功能。`
 * ========params==========
 *
 * `fileId` :string : (可选项) 
 *
 * `fromType` :number : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function previewDoc(option: previewDoc_Params):void;
            interface previewFile_Params {
            
                        /**文件ID或下载url（下载url预览from_type传入5）'*/
                        fid: string,
                        /**0来自文库，1IM，2web，3项目，4旧IM，5下载地址预览,6公告附件，7.新NC预览,8任务预览,9金格编辑'*/
                        from_type: number,
                        /**1.企业文档，2.团队文档，3.我的文档，4.项目文档'*/
                        file_type: number,
                        /**文件名（fid为下载url的预览,即from_type=5的时候，文件名必须传且必须带后缀名）'*/
                        filename: string,
                        /**是否需要下载按钮（0不需要，1需要，对from_type = 5有效）'*/
                        need_download: number,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `预览文件。`
 * ========params==========
 *
 * `fid` :string : (可选项) 
 *
 * `from_type` :number : (可选项) 
 *
 * `file_type` :number : (可选项) 
 *
 * `filename` :string : (可选项) 
 *
 * `need_download` :number : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function previewFile(option: previewFile_Params):void;
            interface wpsPreview_Params {
            
                        /**文件地址，使用 url 方式时必传'*/
                        fileUrl: string,
                        /**文件 id，使用文件 fid 方式时必传'*/
                        fileId: string,
                        /**文件名称'*/
                        fileName: string,
                        /**文件扩展名'*/
                        fileExt: string,
                        /**文件来源，具体应用调用需要传入自己的 appId 才生效'*/
                        appId: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `wps 文件预览。`
 * ========params==========
 *
 * `fileUrl` :string : (可选项) 
 *
 * `fileId` :string : (可选项) 
 *
 * `fileName` :string : (可选项) 
 *
 * `fileExt` :string : (可选项) 
 *
 * `appId` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function wpsPreview(option: wpsPreview_Params):void;
            interface alipayPayment_Params {
            
                         /**包含支付信息，后台生成，包含参数 orderInfo（支付的详细信息）'*/
                        parameters: Object,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `支付宝支付。`
 * ========params==========
 *
 * `parameters` :object : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function alipayPayment(option: alipayPayment_Params):void;
            interface getWechatBill_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `跳转微信卡包。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function getWechatBill(option: getWechatBill_Params):void;
            interface wxpayPayment_Params {
            
                       /**包含支付的详细信息，后台生成'*/
                        parameters: any ,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `微信支付。`
 * ========params==========
 *
 * `parameters` :JSON : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function wxpayPayment(option: wxpayPayment_Params):void;
            interface yonyouPay_Params {
            
                        /**支付类型，见下表'*/
                        type: number,
                        /**订单号'*/
                        orderNo: string,
                        /**订单金额，必须大于0'*/
                        totalAmount: number,
                        /**订单说明'*/
                        orderDesc: string,
                        /**支付结果回调函数'*/
                        callback():void ,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `用友支付。`
 * ========params==========
 *
 * `type` :number : (可选项) 
 *
 * `orderNo` :string : (可选项) 
 *
 * `totalAmount` :number : (可选项) 
 *
 * `orderDesc` :string : (可选项) 
 *
 * `callback` :function : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function yonyouPay(option: yonyouPay_Params):void;
            interface yonyouPayQuery_Params {
            
                        /**订单号'*/
                        orderNo: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `查询用友支付结果。`
 * ========params==========
 *
 * `orderNo` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function yonyouPayQuery(option: yonyouPayQuery_Params):void;
            interface shareWithType_Params {
            
                        /**分享到的平台'*/
                        type: number,
                        /**分享标题'*/
                        title: string,
                        /**分享描述'*/
                        desc: string,
                        /**分享图标'*/
                        imageUrl: string,
                        /**用户点击分享消息打开的详细内容页面'*/
                        pageUrl: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `自定义分享，不提供页面组件，支持将特定信息分享到不同平台，包括友空间消息、友空间动态、微信、QQ。`
 * ========params==========
 *
 * `type` :number : (可选项) 
 *
 * `title` :string : (可选项) 
 *
 * `desc` :string : (可选项) 
 *
 * `imageUrl` :string : (可选项) 
 *
 * `pageUrl` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function shareWithType(option: shareWithType_Params):void;
            interface showShareMenu_Params {
            
                        /**menu 中展示的可分享到的平台'*/
                        type: number,
                        /**分享标题'*/
                        title: string,
                        /**分享描述'*/
                        desc: string,
                        /**分享图标'*/
                        imageUrl: string,
                        /**用户点击分享消息打开的详细内容页面'*/
                        pageUrl: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `提供分享页面组件，支持将特定信息分享到不同平台，包括友空间消息、友空间动态、微信、QQ。`
 * ========params==========
 *
 * `type` :number : (可选项) 
 *
 * `title` :string : (可选项) 
 *
 * `desc` :string : (可选项) 
 *
 * `imageUrl` :string : (可选项) 
 *
 * `pageUrl` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function showShareMenu(option: showShareMenu_Params):void;
            interface announceDetail_Params {
            
                        /**公告id'*/
                        announce_id: number,
                        /**空间id'*/
                        qz_id: number,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `公告详情。`
 * ========params==========
 *
 * `announce_id` :number : (可选项) 
 *
 * `qz_id` :number : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function announceDetail(option: announceDetail_Params):void;
            interface openAnnounceReply_Params {
            
                        /**发言Id'*/
                        feedId: string,
                        /**回复数量'*/
                        replyNum: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `打开公告评论列表。`
 * ========params==========
 *
 * `feedId` :string : (可选项) 
 *
 * `replyNum` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function openAnnounceReply(option: openAnnounceReply_Params):void;
            interface writeAnnounceReply_Params {
            
                        /**发言Id'*/
                        feedId: string,
                        /**回复数量'*/
                        replyNum: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `公告写评论。`
 * ========params==========
 *
 * `feedId` :string : (可选项) 
 *
 * `replyNum` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function writeAnnounceReply(option: writeAnnounceReply_Params):void;
            interface appletFromQzId_Params {
            
                        /**fromQzId'*/
                        fromQzId: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `获取小程序来源圈子ID。`
 * ========params==========
 *
 * `fromQzId` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function appletFromQzId(option: appletFromQzId_Params):void;
            interface configAppletMenu_Params {
            
                        /**隐藏分享按钮'*/
                        hideShare: number,
                        /**隐藏转发按钮'*/
                        hideForward: number,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `配置小程序的菜单。`
 * ========params==========
 *
 * `hideShare` :number : (可选项) 
 *
 * `hideForward` :number : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function configAppletMenu(option: configAppletMenu_Params):void;
            interface enterApplet_Params {
            
                        /**小程序 id'*/
                        appId: string,
                        /**空间 id'*/
                        qzId: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `小程序的关于界面，进入小程序。`
 * ========params==========
 *
 * `appId` :string : (可选项) 
 *
 * `qzId` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function enterApplet(option: enterApplet_Params):void;
            interface getAppData_Params {
            
                        /**appid'*/
                        appId: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `查询单个应用信息(只返回当前空间，getlist3接口数据)。`
 * ========params==========
 *
 * `appId` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function getAppData(option: getAppData_Params):void;
            interface getAppletCapsuleParams_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `获取小程序胶囊占屏幕宽度比例值。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function getAppletCapsuleParams(option: getAppletCapsuleParams_Params):void;
            interface getAppletShareParams_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `获取小程序分享的参数。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function getAppletShareParams(option: getAppletShareParams_Params):void;
            interface getGzipAppData_Params {
            
                        /**gzip 存数据的键'*/
                        key: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `获取 gzip 应用数据。`
 * ========params==========
 *
 * `key` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function getGzipAppData(option: getGzipAppData_Params):void;
            interface getHhtQrCodeInfo_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `获取红火台缓存信息。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function getHhtQrCodeInfo(option: getHhtQrCodeInfo_Params):void;
            interface getOffLineOutSignPhoto_Params {
            
                        /**租户ID，可跨租户上传(友空间6.5.0及以上版本)'*/
                        tenantId: string,
                        /**签到'*/
                        watermark_type: number,
                         /**水印数据对象与type匹配'*/
                        watermark: Object,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `拍照上传服务器或者返回base64信息（上传成功返回图片url,上传失败返回图片的base64信息）。`
 * ========params==========
 *
 * `tenantId` :string : (可选项) 
 *
 * `watermark_type` :number : (可选项) 
 *
 * `watermark` :object : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function getOffLineOutSignPhoto(option: getOffLineOutSignPhoto_Params):void;
            interface openAppSetting_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `打开混合云常用应用页面。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function openAppSetting(option: openAppSetting_Params):void;
            interface openAppWithParams_Params {
            
                        /**应用id'*/
                        app_id: string,
                        /**日程当前时间(20201112)'*/
                        currentDay: string,
                        /**用户id(从哪个进入的，从共享人进行，就是共享人的id)'*/
                        member_id: number,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `启动应用。`
 * ========params==========
 *
 * `app_id` :string : (可选项) 
 *
 * `currentDay` :string : (可选项) 
 *
 * `member_id` :number : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function openAppWithParams(option: openAppWithParams_Params):void;
            interface openCustomSetting_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `打开多维门户自定义设置。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function openCustomSetting(option: openCustomSetting_Params):void;
            interface openGzipApp_Params {
            
                        /**应用id'*/
                        appId: string,
                        /**应用所属空间id'*/
                        qzId: string,
                        /**eclocal://开头，例如eclocal://index.html，如果没有传，则使用工作台的加载首页'*/
                        url: string,
                        /**gzip的自定义参数值，可通过getGzipAppData桥接获取'*/
                        appData: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `打开gzip应用。`
 * ========params==========
 *
 * `appId` :string : (可选项) 
 *
 * `qzId` :string : (可选项) 
 *
 * `url` :string : (可选项) 
 *
 * `appData` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function openGzipApp(option: openGzipApp_Params):void;
            interface openPluginWithParams_Params {
            
                        /**插件id'*/
                        plugin_id: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `打开插件。`
 * ========params==========
 *
 * `plugin_id` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function openPluginWithParams(option: openPluginWithParams_Params):void;
            interface openSearchAppList_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `打开应用搜索列表。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function openSearchAppList(option: openSearchAppList_Params):void;
            interface openSignViewWithParams_Params {
            
                        /**域名'*/
                        domainUrl: string,
                        /**cookie的key'*/
                        cookieKey: string,
                        /**cookie的域名'*/
                        cookieDomain: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `打开专属化考勤应用。`
 * ========params==========
 *
 * `domainUrl` :string : (可选项) 
 *
 * `cookieKey` :string : (可选项) 
 *
 * `cookieDomain` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function openSignViewWithParams(option: openSignViewWithParams_Params):void;
            interface setAppletCapsuleStyle_Params {
            
                        /**胶囊样式，0浅色 1深色 2自定义颜色'*/
                        capsuleStyle: number,
                        /**自定义胶囊背景色值 例:#00ff00'*/
                        customCapsuleBgColor: string,
                        /**自定义胶囊背景透明度 0-1，默认0-完全透明'*/
                        customCapsuleBgAlpha: number,
                        /**自定义胶囊图片色值 例:#00ff00'*/
                        customCapsuleImgColor: string,
                        /**自定义胶囊边框色值 例:#00ff00'*/
                        customCapsuleBorderColor: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `设置小程序胶囊样式。`
 * ========params==========
 *
 * `capsuleStyle` :number : (可选项) 
 *
 * `customCapsuleBgColor` :string : (可选项) 
 *
 * `customCapsuleBgAlpha` :number : (可选项) 
 *
 * `customCapsuleImgColor` :string : (可选项) 
 *
 * `customCapsuleBorderColor` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function setAppletCapsuleStyle(option: setAppletCapsuleStyle_Params):void;
            interface shareApplet_Params {
            
                        /**0-转发到im，1-分享到动态'*/
                        type: number,
                        /**共享的自定义参数值'*/
                        params: string,
                        /**自定义标题'*/
                        customTitle: string,
                        /**自定义副标题'*/
                        customSubTitle: string,
                        /**自定义图标远程地址'*/
                        customShowImgUrl: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `分享小程序到im或动态。`
 * ========params==========
 *
 * `type` :number : (可选项) 
 *
 * `params` :string : (可选项) 
 *
 * `customTitle` :string : (可选项) 
 *
 * `customSubTitle` :string : (可选项) 
 *
 * `customShowImgUrl` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function shareApplet(option: shareApplet_Params):void;
            interface config_Params {
            
                        /**代理 id'*/
                        agentId: string,
                        /**签名'*/
                        signature: string,
                        /**当前的时间戳'*/
                        timeStamp: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `全局鉴权配置。参考[鉴权说明](https://open.diwork.com/#/doc-center/docDes/doc?code=open_jrwd&section=3e4da74fc346424aaa0532542a47684d)`
 * ========params==========
 *
 * `agentId` :string : (可选项) 
 *
 * `signature` :string : (可选项) 
 *
 * `timeStamp` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function config(option: config_Params):void;
            interface getOAuthCode_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `获取免登授权码，实现单点登录。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function getOAuthCode(option: getOAuthCode_Params):void;
            interface chooseChatFromContact_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `选取联系人进行单聊会话。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function chooseChatFromContact(option: chooseChatFromContact_Params):void;
            interface openChatByGroupId_Params {
            
                        /**群组的ID'*/
                        groupId: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `发起群聊会话。`
 * ========params==========
 *
 * `groupId` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function openChatByGroupId(option: openChatByGroupId_Params):void;
            interface openChatByUserId_Params {
            
                        /**对方用户id的使用类型，0-使用友空间用户id；1-使用友互通用户id'*/
                        userType: number,
                        /**对方用户的唯一标示'*/
                        userId: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `直接发起和特定人员的单聊会话。`
 * ========params==========
 *
 * `userType` :number : (可选项) 
 *
 * `userId` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function openChatByUserId(option: openChatByUserId_Params):void;
            interface sendImageMessages_Params {
            
                        /**对方用户id的使用类型，0-使用友空间用户id；1-使用友互通用户id'*/
                        userType: number,
                        /**对方的唯一标示'*/
                        chatId: string,
                        /**对方的类型(chat: 单聊 groupchat: 群聊)'*/
                        chatType: string,
                        /**发送图片的本地地址集合'*/
                        filePaths: Array,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `向指定的个人或者群组发送图片消息。`
 * ========params==========
 *
 * `userType` :number : (可选项) 
 *
 * `chatId` :string : (可选项) 
 *
 * `chatType` :string : (可选项) 
 *
 * `filePaths` :Arraystring : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function sendImageMessages(option: sendImageMessages_Params):void;
            interface checkCloudAlarm_Params {
            
                        /**事件id'*/
                        id: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `查询云闹钟开关状态。`
 * ========params==========
 *
 * `id` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function checkCloudAlarm(option: checkCloudAlarm_Params):void;
            interface operateCloudAlarm_Params {
            
                        /**人员id'*/
                        member_id: string,
                        /**空间id'*/
                        qz_id: number,
                        /**开关，1开启，0关闭 (开闹钟必须传)'*/
                        operate_type: number,
                        /**事件id'*/
                        id: string,
                        /**提醒时间（10位）(开闹钟必须传)'*/
                        remind_time: string,
                        /**事件名称 (开闹钟必须传)'*/
                        title: string,
                        /**事件名称 事件开始时间（10位）'*/
                        start_time: string,
                        /**事件结束时间（10位）'*/
                        end_time: string,
                        /**事件来源（0考勤，1日程，2会议）(开闹钟必须传)'*/
                        from: number,
                        /**提醒模式（0只提醒一次，暂时不需要）'*/
                        remind_mode: number,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `开关云闹铃。`
 * ========params==========
 *
 * `member_id` :string : (可选项) 
 *
 * `qz_id` :number : (可选项) 
 *
 * `operate_type` :number : (可选项) 
 *
 * `id` :string : (可选项) 
 *
 * `remind_time` :string : (可选项) 
 *
 * `title` :string : (可选项) 
 *
 * `start_time` :string : (可选项) 
 *
 * `end_time` :string : (可选项) 
 *
 * `from` :number : (可选项) 
 *
 * `remind_mode` :number : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function operateCloudAlarm(option: operateCloudAlarm_Params):void;
            interface chooseAllContacts_Params {
            
                        /**是否多选'*/
                        multiple: boolean,
                       /**已选人员ID数组'*/
                        selectedList: any ,
                        /**导航标题'*/
                        navTitle: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `跨空间选择联系人，返回联系人基础信息。`
 * ========params==========
 *
 * `multiple` :boolean : (可选项) 
 *
 * `selectedList` :arraystring : (可选项) 
 *
 * `navTitle` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function chooseAllContacts(option: chooseAllContacts_Params):void;
            interface chooseContacts_Params {
            
                        /**是否多选'*/
                        multiple: boolean,
                       /**已选用户数组'*/
                        selectedList: any ,
                        /**最大选择人数'*/
                        maxCount: number,
                        /**导航标题'*/
                        navTitle: string,
                        /**导航颜色值'*/
                        navColor: string,
                        /**需要选择的空间id'*/
                        qzId: string,
                        /**是否可以删除已选人员(IOS 已弃用)'*/
                        canDelete: boolean,
                        /**是否可以点部门选择（仅多选时有效）(true:可通过部门选择 false:不可以通过部门选择)'*/
                        canSelectDept: boolean,
                        /**是否需要友户通ID(1:需要友户通ID 0:不需要友户通ID)'*/
                        needYhtUserId: number,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `选择联系人，返回联系人基础信息。`
 * ========params==========
 *
 * `multiple` :boolean : (可选项) 
 *
 * `selectedList` :arraystring : (可选项) 
 *
 * `maxCount` :number : (可选项) 
 *
 * `navTitle` :string : (可选项) 
 *
 * `navColor` :string : (可选项) 
 *
 * `qzId` :string : (可选项) 
 *
 * `canDelete` :boolean : (可选项) 
 *
 * `canSelectDept` :boolean : (可选项) 
 *
 * `needYhtUserId` :number : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function chooseContacts(option: chooseContacts_Params):void;
            interface chooseDepartment_Params {
            
                        /**是否多选'*/
                        multiple: boolean,
                        /**已选部门数组'*/
                        selectedList: Array,
                        /**最大选择组织数'*/
                        maxCount: number,
                        /**已选择组织数'*/
                        selectedCount: number,
                        /**部门类型(0:所有 1:部门 2:组织)'*/
                        deptType: number,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `选择部门，返回部门基础信息。`
 * ========params==========
 *
 * `multiple` :boolean : (可选项) 
 *
 * `selectedList` :arrayobject : (可选项) 
 *
 * `maxCount` :number : (可选项) 
 *
 * `selectedCount` :number : (可选项) 
 *
 * `deptType` :number : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function chooseDepartment(option: chooseDepartment_Params):void;
            interface chooseGroupContacts_Params {
            
                        /**需要选择的空间 id'*/
                        qzId: string,
                        /**已选用户数组'*/
                        groupId: string,
                        /**是否多选'*/
                        multiple: boolean,
                        /**最大选择人数, 多选时用'*/
                        maxCount: number,
                        /**导航标题'*/
                        navTitle: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `群内选择联系人，支持单选和多选。`
 * ========params==========
 *
 * `qzId` :string : (可选项) 
 *
 * `groupId` :string : (可选项) 
 *
 * `multiple` :boolean : (可选项) 
 *
 * `maxCount` :number : (可选项) 
 *
 * `navTitle` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function chooseGroupContacts(option: chooseGroupContacts_Params):void;
            interface chooseInsideGroup_Params {
            
                        /**是否多选'*/
                        multiple: boolean,
                        /**已选内部群数组'*/
                        selectedList: Array,
                        /**内部群类型(0:已加入的内部群 1:所有内部群 2:未加入的内部群)'*/
                        groupType: number,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `选择内部群，返回内部群信息。`
 * ========params==========
 *
 * `multiple` :boolean : (可选项) 
 *
 * `selectedList` :arrayobject : (可选项) 
 *
 * `groupType` :number : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function chooseInsideGroup(option: chooseInsideGroup_Params):void;
            interface chooseUserOrGroupFromChat_Params {
            
                        /**导航标题(ios有这个参数Android没有)'*/
                        navTitle: string,
                        /**内部群类型(0:已加入的内部群 1:所有内部群 2:未加入的内部群)'*/
                        groupType: number,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `通过会话列表，选择个人或者群组，返回个人的用户id或者群组id。`
 * ========params==========
 *
 * `navTitle` :string : (可选项) 
 *
 * `groupType` :number : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function chooseUserOrGroupFromChat(option: chooseUserOrGroupFromChat_Params):void;
            interface convertMemberIDs_Params {
            
                        /**转换类型(0:空间ID换友互通ID 1:友互通ID换空间ID)'*/
                        type: string,
                        /**需要转换的数组'*/
                        idArray: Array,
                        /**内部群类型(0:已加入的内部群 1:所有内部群 2:未加入的内部群)'*/
                        groupType: number,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `空间member_id和友户通user_id相互转换。`
 * ========params==========
 *
 * `type` :string : (可选项) 
 *
 * `idArray` :arrayobject : (可选项) 
 *
 * `groupType` :number : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function convertMemberIDs(option: convertMemberIDs_Params):void;
            interface openCreateSpace_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `选择空间类型，跳转到对应的原生创建页面。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function openCreateSpace(option: openCreateSpace_Params):void;
            interface viewUserInfo_Params {
            
                        /**人员id'*/
                        memberId: number,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `打开人员详情界面。`
 * ========params==========
 *
 * `memberId` :number : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function viewUserInfo(option: viewUserInfo_Params):void;
            interface chooseLibraryFiles_Params {
            
                        /**文库选择类型(0:从文库列表和传输列表选择 1:从文库列表选择 2:从传输列表选择)'*/
                        type: number,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `从文库列表中选择文库文件，返回文件基础信息。`
 * ========params==========
 *
 * `type` :number : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function chooseLibraryFiles(option: chooseLibraryFiles_Params):void;
            interface openLibraryFiles_Params {
            
                        /**一级目录(企业文档：1；内部群文档：2；我的文档：3；项目文档：4)'*/
                        firstCatalog: number,
                        /**二级目录(企业文档：0；我的文档：0；我的文档(TA人共享)：-4；内部群文档：内部群ID；项目文档：项目ID；)'*/
                        secondCatalog: number,
                        /**三级目录(文件夹id)'*/
                        thirdCatalog: number,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `打开文库具体路径。`
 * ========params==========
 *
 * `firstCatalog` :number : (可选项) 
 *
 * `secondCatalog` :number : (可选项) 
 *
 * `thirdCatalog` :number : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function openLibraryFiles(option: openLibraryFiles_Params):void;
            interface openLiveFlow_Params {
            
                        /**推流URL'*/
                        pushurl: string,
                        /**默认竖屏, 是否需要横屏, true不需要, false需要'*/
                        screenOrientation: boolean,
                        /**0 320p, 1 640p, 2 865p, 3 1280p'*/
                        videoResolution: number,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `调用直播界面。`
 * ========params==========
 *
 * `pushurl` :string : (可选项) 
 *
 * `screenOrientation` :boolean : (可选项) 
 *
 * `videoResolution` :number : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function openLiveFlow(option: openLiveFlow_Params):void;
            interface sendMiniMail_Params {
            
                        /**收件人列表'*/
                        users: Array,
                        /**空间id'*/
                        spaceId: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `打开发送微邮界面。`
 * ========params==========
 *
 * `users` :arrayobject : (可选项) 
 *
 * `spaceId` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function sendMiniMail(option: sendMiniMail_Params):void;
            interface checkMirrorStatus_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `检测投屏状态。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function checkMirrorStatus(option: checkMirrorStatus_Params):void;
            interface closeMirrorScreen_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `关闭投屏功能。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function closeMirrorScreen(option: closeMirrorScreen_Params):void;
            interface startMirrorScreen_Params {
            
                        /**投屏码'*/
                        code: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `开启投屏功能。`
 * ========params==========
 *
 * `code` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function startMirrorScreen(option: startMirrorScreen_Params):void;
            interface collectionData_Params {
            
                        /**应用ID'*/
                        appId: string,
                        /**埋点事件'*/
                        action: string,
                        /**详情ID'*/
                        detailId: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `埋点。`
 * ========params==========
 *
 * `appId` :string : (可选项) 
 *
 * `action` :string : (可选项) 
 *
 * `detailId` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function collectionData(option: collectionData_Params):void;
            interface configSkinAndTabbar_Params {
            
                        /**需要更换主题租户的空间 id'*/
                        currentQzId: string,
                        /**换肤主题色数据，json 字符串，用于取主题色'*/
                        skinData: string,
                        /**换肤下导航数据，json 字符串，用于下导航显示'*/
                        tabbarData: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `换肤功能，保存换肤数据到本地，用与显示用户的换肤数据。`
 * ========params==========
 *
 * `currentQzId` :string : (可选项) 
 *
 * `skinData` :string : (可选项) 
 *
 * `tabbarData` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function configSkinAndTabbar(option: configSkinAndTabbar_Params):void;
            interface getComponentList_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `获取组件列表。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function getComponentList(option: getComponentList_Params):void;
            interface getMultiDataCenterConfig_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `获取服务端API的多数据中心配置，包括集中部署、多数据中心部署的服务的域名、服务编码。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function getMultiDataCenterConfig(option: getMultiDataCenterConfig_Params):void;
            interface mdfIsLoad_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `返回预加载状态，用于 MDF 在线 H5 调用，预加载完成后打开 MDF 应用时使用预加载。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function mdfIsLoad(option: mdfIsLoad_Params):void;
            interface reloadWorkbenchPath_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `通知客户端加载最新资源包。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function reloadWorkbenchPath(option: reloadWorkbenchPath_Params):void;
            interface writeLocationLog_Params {
            
                         /**日志数据信息'*/
                        parameterDic: Object,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `写入本地日志。`
 * ========params==========
 *
 * `parameterDic` :object : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function writeLocationLog(option: writeLocationLog_Params):void;
            interface gainUserInfo_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `获取个人信息。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function gainUserInfo(option: gainUserInfo_Params):void;
            interface getUserAgent_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `获取友空间自定义通用UserAgent信息。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function getUserAgent(option: getUserAgent_Params):void;
            interface getUserFontSize_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `获取个人在应用设置中设置的字体大小。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function getUserFontSize(option: getUserFontSize_Params):void;
            interface getUserYHTInfo_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `获取个人友互通信息。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function getUserYHTInfo(option: getUserYHTInfo_Params):void;
            interface createFeedComponent_Params {
            
                        /**开放权限(是否能看到这条发言)的团队id'*/
                        groupId: string,
                        /**开放权限的团队id的名字'*/
                        groupName: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `新建发言。`
 * ========params==========
 *
 * `groupId` :string : (可选项) 
 *
 * `groupName` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function createFeedComponent(option: createFeedComponent_Params):void;
            interface createNewSchedule_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `提供新建日程功能，调用时端上会打开新建日程页面，用户可以在此完善日程信息，并新建日程。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function createNewSchedule(option: createNewSchedule_Params):void;
            interface getSchedulesFromMobile_Params {
            
                       /**开始时间戳'*/
                        startTime: any ,
                       /**结束时间戳'*/
                        endTime: any ,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `提供时间区间，如果用户开启了同步手机日程的开关，返回该时间区间内的手机日程列表，否则返回空。`
 * ========params==========
 *
 * `startTime` :long : (可选项) 
 *
 * `endTime` :long : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function getSchedulesFromMobile(option: getSchedulesFromMobile_Params):void;
            interface openScheduleDetail_Params {
            
                        /**日程id'*/
                        scheduleId: number,
                        /**日程当前时间(20201112)'*/
                        currentDay: string,
                        /**用户id(从哪个进入的，从共享人进行，就是共享人的id)'*/
                        member_id: number,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `打开日程查看详情界面。`
 * ========params==========
 *
 * `scheduleId` :number : (可选项) 
 *
 * `currentDay` :string : (可选项) 
 *
 * `member_id` :number : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function openScheduleDetail(option: openScheduleDetail_Params):void;
            interface sendTodoReceipt_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `发送待办处理回执。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function sendTodoReceipt(option: sendTodoReceipt_Params):void;
            interface viewScheduleDetail_Params {
            
                        /**日程id'*/
                        scheduleId: string,
                        /**日程子Id(只有重复日程存在子Id)'*/
                        subId: string,
                        /**用户ID'*/
                        memberId: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `提供一个日程详情页面，根据传入的日程id以及用户id，展示出指定日程的详细信息。`
 * ========params==========
 *
 * `scheduleId` :string : (可选项) 
 *
 * `subId` :string : (可选项) 
 *
 * `memberId` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function viewScheduleDetail(option: viewScheduleDetail_Params):void;
            interface viewScheduleList_Params {
            
                        /**指定日期时间戳（10位）'*/
                        time: number,
                        /**人员id'*/
                        memberId: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `传入指定日期，展示指定日期的日程列表界面（展示界面包括月视图）。`
 * ========params==========
 *
 * `time` :number : (可选项) 
 *
 * `memberId` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function viewScheduleList(option: viewScheduleList_Params):void;
            interface getToken_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `获取轻应用code。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function getToken(option: getToken_Params):void;
            interface getU8DeviceInfo_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `u8轻应用登录获取设备信息。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function getU8DeviceInfo(option: getU8DeviceInfo_Params):void;
            interface u8DeleteAttachment_Params {
            
                        /**文件id'*/
                        fileid: string,
                        /**文件名后缀'*/
                        filetype: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `u8删除附件。`
 * ========params==========
 *
 * `fileid` :string : (可选项) 
 *
 * `filetype` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function u8DeleteAttachment(option: u8DeleteAttachment_Params):void;
            interface u8DownLoadAttachment_Params {
            
                        /**true 是分片下载  false 不是分片下载'*/
                        ispiece: boolean,
                        /**文件后缀'*/
                        fileType: string,
                        /**当前文件id'*/
                        fileId: string,
                        /**Base64字符串'*/
                        fileContent: string,
                        /**文件id数组'*/
                        fileIdArray: string,
                        /**false 不展示exif信息  true 展示exif信息'*/
                        isshowexif: boolean,
                        /**分片时文件的总大小'*/
                        ftotalsize: number,
                        /**分片时分片的数量'*/
                        piececount: number,
                        /**分片时文件的总大小'*/
                        offset: number,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `u8下载附件。`
 * ========params==========
 *
 * `ispiece` :boolean : (可选项) 
 *
 * `fileType` :string : (可选项) 
 *
 * `fileId` :string : (可选项) 
 *
 * `fileContent` :string : (可选项) 
 *
 * `fileIdArray` :string : (可选项) 
 *
 * `isshowexif` :boolean : (可选项) 
 *
 * `ftotalsize` :number : (可选项) 
 *
 * `piececount` :number : (可选项) 
 *
 * `offset` :number : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function u8DownLoadAttachment(option: u8DownLoadAttachment_Params):void;
            interface u8JudgeCacheAttachment_Params {
            
                       /**文件id'*/
                        fileid: any ,
                        /**文件后缀'*/
                        isaddexif: string,
                        /**false 不分片 true 分片'*/
                        ispiece: boolean,
                        /**true 只有图片才会有,传一组id'*/
                        fileNameArray: string,
                        /**false 不展示exif信息  true 展示exif信息'*/
                        isshowexif: boolean,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `u8上传附件。`
 * ========params==========
 *
 * `fileid` :numner : (可选项) 
 *
 * `isaddexif` :string : (可选项) 
 *
 * `ispiece` :boolean : (可选项) 
 *
 * `fileNameArray` :string : (可选项) 
 *
 * `isshowexif` :boolean : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function u8JudgeCacheAttachment(option: u8JudgeCacheAttachment_Params):void;
            interface u8PreviewVoucherDetail_Params {
            
                        /**标题'*/
                        title: string,
                        /**单据内容（base64字符串）'*/
                        content: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `u8预览单据详情。`
 * ========params==========
 *
 * `title` :string : (可选项) 
 *
 * `content` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function u8PreviewVoucherDetail(option: u8PreviewVoucherDetail_Params):void;
            interface u8ScanCode_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `u8销售订单打开连续扫码页面。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function u8ScanCode(option: u8ScanCode_Params):void;
            interface u8UploadAttachment_Params {
            
                        /**文件类型(0:相机 1:相册 2:录音 3:本地文件)'*/
                        filetype: number,
                        /**false 不添加exif信息   true 添加exif信息'*/
                        isaddexif: boolean,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `u8上传附件。`
 * ========params==========
 *
 * `filetype` :number : (可选项) 
 *
 * `isaddexif` :boolean : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function u8UploadAttachment(option: u8UploadAttachment_Params):void;
            interface setGesturePassword_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `设置手势密码。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function setGesturePassword(option: setGesturePassword_Params):void;
            interface verifyGesturePassword_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `验证手势密码。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function verifyGesturePassword(option: verifyGesturePassword_Params):void;
            interface verifyLoginPassword_Params {
            
                        /**弹窗标题，若不传，显示默认的文案：为了确保数据安全，需要验证您的登录密码'*/
                        title: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `弹出密码验证对话框，验证用户身份。`
 * ========params==========
 *
 * `title` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function verifyLoginPassword(option: verifyLoginPassword_Params):void;
            interface getWatermarkInfo_Params {
            
                        /**圈子ID，若为空，返回app当前空间水印信息'*/
                        qzId: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `获取空间水印信息。`
 * ========params==========
 *
 * `qzId` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function getWatermarkInfo(option: getWatermarkInfo_Params):void;
            interface closeXYChatView_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `关闭小友页面。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function closeXYChatView(option: closeXYChatView_Params):void;
            interface getXYVersion_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `获得小友版本号。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function getXYVersion(option: getXYVersion_Params):void;
            interface openXYChatView_Params {
            
                       /**业务方自定义参数'*/
                        xiaoyou_params: any ,
                        /**NCC订单定制功能，在订单确定后自动关闭页面'*/
                        autoClose: boolean,
                        /**NCC订单定制功能，在订单确定后回调的函数'*/
                        callback():void ,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `打开小友页面。`
 * ========params==========
 *
 * `xiaoyou_params` :JSON : (可选项) 
 *
 * `autoClose` :boolean : (可选项) 
 *
 * `callback` :function : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function openXYChatView(option: openXYChatView_Params):void;
            interface faceCollect_Params {
            
                        /**空间id'*/
                        spaceId: string,
                        /**存放人脸信息的库id'*/
                        faceGroupId: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `采集当前面部信息并与当前登录用户绑定。`
 * ========params==========
 *
 * `spaceId` :string : (可选项) 
 *
 * `faceGroupId` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function faceCollect(option: faceCollect_Params):void;
            interface faceCompare_Params {
            
                        /**空间id'*/
                        spaceId: string,
                        /**存放人脸信息的库id'*/
                        faceGroupId: string,
                        /**是否需要返回微笑分数'*/
                        needSmile: boolean,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `提供当前采集的面部信息与人脸库内的面部信息进行比对，返回匹配的用户id和分数，以及微笑值（可选）。`
 * ========params==========
 *
 * `spaceId` :string : (可选项) 
 *
 * `faceGroupId` :string : (可选项) 
 *
 * `needSmile` :boolean : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function faceCompare(option: faceCompare_Params):void;
            interface faceDetect_Params {
            
                        /**空间id'*/
                        spaceId: string,
                        /**存放人脸信息的库id'*/
                        faceGroupId: string,
                        /**是否需要返回微笑分数'*/
                        needSmile: boolean,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `提供当前采集到的人脸信息与当前账号录入的人脸信息进行识别，返回对比分数以及微笑值（可选）。`
 * ========params==========
 *
 * `spaceId` :string : (可选项) 
 *
 * `faceGroupId` :string : (可选项) 
 *
 * `needSmile` :boolean : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function faceDetect(option: faceDetect_Params):void;
            interface smileDetect_Params {
            
                        /**空间id'*/
                        spaceId: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `提供检测目标微笑值的功能。`
 * ========params==========
 *
 * `spaceId` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function smileDetect(option: smileDetect_Params):void;
            interface startSpeechSyn_Params {
            
                        /**需要合成的字符串'*/
                        text: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `提供文字合成语音的功能,如果在合成期间再次调用合成返回错误。`
 * ========params==========
 *
 * `text` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function startSpeechSyn(option: startSpeechSyn_Params):void;
            interface stopSpeechSyn_Params {
            
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `提供结束语音合成的功能，如果没有在合成调用此方法会返回错误。`
 * ========params==========
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function stopSpeechSyn(option: stopSpeechSyn_Params):void;
            interface translateVoice_Params {
            
                        /**base64数据音频数据字符串'*/
                        bytes: string,
                        /**是否提供UI界面'*/
                        isShowUI: boolean,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `提供实时语音数据转文字的功能,结束调用后会返回相应转换完成的文字。`
 * ========params==========
 *
 * `bytes` :string : (可选项) 
 *
 * `isShowUI` :boolean : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function translateVoice(option: translateVoice_Params):void;
            interface voiceToText_Params {
            
                        /**是否提供UI界面'*/
                        isShowUI: boolean,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `提供实时语音转文字的功能,结束调用后会返回相应转换完成的文字。`
 * ========params==========
 *
 * `isShowUI` :boolean : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function voiceToText(option: voiceToText_Params):void;
            interface decryptData_Params {
            
                        /**需要解密的数据'*/
                        data: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `使用可逆算法解密指定数据。`
 * ========params==========
 *
 * `data` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function decryptData(option: decryptData_Params):void;
            interface encryptData_Params {
            
                        /**需要加密的数据'*/
                        data: string,
                        /**接口调用成功的回调函数'*/
                        success():void ,
                        /**接口调用失败的回调函数'*/
                        fail():void ,
                        /**接口调用结束的回调函数（调用成功、失败都会执行）'*/
                        complete():void 
            }
  
           /**
 * `使用可逆算法加密指定数据。`
 * ========params==========
 *
 * `data` :string : (可选项) 
 *
 * `success` :function : (可选项) 
 *
 * `fail` :function : (可选项) 
 *
 * `complete` :function : (可选项) 
 *
 */
            function encryptData(option: encryptData_Params):void;


}

type eventType = "batterylow" | "batterystatus" | "keyback" | "keymenu" | "volumeup" | "volumedown" | "offline" | "online" | "pause" | "resume" | "active" | "inactive" | "scrolltobottom" | "backtotop" | "shake" | "takescreenshot" | "appidle" | "swipedown" | "swipeleft" | "swiperight" | "swipeup" | "tap" | "longpress" | "viewappear" | "viewdisappear" | "noticeclicked" | "appintent" | "smartupdatefinish" | "launchviewclicked" | "keyboardshow" | "keyboardhide" | "safeareachanged" | "interfacestylechanged" | "navtitle" | "navbackbtn" | "navitembtn" | "tabitembtn" | "tabframe";

