"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function escapeRegExp(text) {
    return text.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, '\\$&');
}
exports.escapeRegExp = escapeRegExp;
/** Check whether text is a variable: `/^[\t ]*(\$|--)\S+:.* /` */
function isVar(text) {
    return /^[\t ]*(\$|--)\S+:.*/.test(text);
}
exports.isVar = isVar;
/** Check whether text @import: `/^[\t ]*@import/` */
function isAtImport(text) {
    return /^[\t ]*@import/.test(text);
}
exports.isAtImport = isAtImport;
/** Check whether text is a \*: `/^[\t ]*?\*\/` */
function isStar(text) {
    return /^[\t ]*?\*/.test(text);
}
exports.isStar = isStar;
/**Check whether text is class, id or placeholder: `/^[\t ]*[#\.%]/` */
function isClassOrId(text) {
    return /^[\t ]*[#\.%]/.test(text);
}
exports.isClassOrId = isClassOrId;
/**Check whether text is a selector: `^[\t ]*([#\.%&>~]|\+[\t ])` */
function isSelector(text) {
    return /^[\t ]*([#\.%&>~]|\+[\t ])/.test(text);
}
exports.isSelector = isSelector;
/**Check whether text starts with one of [>\~]: `/^[\t ]*[>~]/` */
function isSelectorOperator(text) {
    return /^[\t ]*[>~]/.test(text);
}
exports.isSelectorOperator = isSelectorOperator;
/** `/^[\t ]*[{}]?[\t ]*[#\.%@]/` */
function isCssSelector(text) {
    return /^[\t ]*[{}]?[\t ]*[#\.%@]/.test(text);
}
exports.isCssSelector = isCssSelector;
/**`/^[\t ]*\+[\t ]+/` */
function isAdjacentSelector(text) {
    return /^[\t ]*\+[\t ]+/.test(text);
}
exports.isAdjacentSelector = isAdjacentSelector;
/**Check whether text is class, id or placeholder: `/^[\t ]*\r?\n?$/` */
function isEmptyOrWhitespace(text) {
    return /^[\t ]*\r?\n?$/.test(text);
}
exports.isEmptyOrWhitespace = isEmptyOrWhitespace;
/** Check whether text is a property: `empty` ? `!/^[\t ]*[\w\-]+: *\S+/` : `/^[\t ]*[\w\-]+:/` */
function isProperty(text, empty) {
    if (empty) {
        return !/^[\t ]*[\w\-]+: *\S+/.test(text);
    }
    return /^[\t ]*[\w\-]+:/.test(text);
}
exports.isProperty = isProperty;
/** Check whether text starts with &: `/^[\t ]*&/` */
function isAnd(text) {
    return /^[\t ]*&/.test(text);
}
exports.isAnd = isAnd;
/** Check whether text is a AtRoot: `/^[\t ]*@at-root/` */
function isAtRoot(text) {
    return /^[\t ]*@at-root/.test(text);
}
exports.isAtRoot = isAtRoot;
/** Check whether text is a extend: `/^[\t ]*@extend/` */
function isAtExtend(text) {
    return /^[\t ]*@extend/.test(text);
}
exports.isAtExtend = isAtExtend;
/** Check whether text is at rule :  `/^[\t ]*@/`*/
function isAtRule(text) {
    return /^[\t ]*@/.test(text);
}
exports.isAtRule = isAtRule;
/** Check whether text is include mixin statement */
function isInclude(text) {
    if (/^[\t ]*\+[-\w_]+\(.*\)/.test(text)) {
        return 'prop';
    }
    else if (/^[\t ]*(@include|\+\w+)/.test(text)) {
        return 'header';
    }
    return false;
}
exports.isInclude = isInclude;
/** Check whether text is a @keyframes: `/^[\t ]*@keyframes/` */
function isKeyframes(text) {
    return /^[\t ]*@keyframes/.test(text);
}
exports.isKeyframes = isKeyframes;
/** Check whether text is a mixin: `/^[\t ]*=|^[\t ]*@mixin/` */
function isMixin(text) {
    return /^[\t ]*=|^[\t ]*@mixin/.test(text);
}
exports.isMixin = isMixin;
/** Check whether text is a loop: `/^[\t ]*(@each|@for|@while)/` */
function isLoop(text) {
    return /^[\t ]*(@each|@for|@while)/.test(text);
}
exports.isLoop = isLoop;
/** Check whether text starts with @media: `/^[\t ]*@media/`*/
function isMedia(text) {
    return /^[\t ]*@media/.test(text);
}
exports.isMedia = isMedia;
/** `/^[\t ]*@font-face/` */
function isFontFace(text) {
    return /^[\t ]*@font-face/.test(text);
}
exports.isFontFace = isFontFace;
/** Check whether text is a Pseudo selector: `/^[\t ]*\\?::?/`. */
function isPseudo(text) {
    return /^[\t ]*\\?::?/.test(text);
}
exports.isPseudo = isPseudo;
/** Check whether text starts with @if or @else: `/^[\t ]*@if|^ *@else/` */
function isIfOrElse(text) {
    return /^[\t ]*@if|^ *@else/.test(text);
}
exports.isIfOrElse = isIfOrElse;
/** Check whether text starts with @else: `/^[\t ]*@else/` */
function isElse(text) {
    return /^[\t ]*@else/.test(text);
}
exports.isElse = isElse;
/** Check whether text is bracket selector: `/^[\t ]*\[[\w=\-*"' ]*\]/`*/
function isBracketSelector(text) {
    return /^[\t ]*\[[\w=\-*"' ]*\]/.test(text);
}
exports.isBracketSelector = isBracketSelector;
/** checks if text last char is a number: `/[0-9]$/` && `!text.includes('#')` */
function isNumber(text) {
    return /[0-9]$/.test(text) && !text.includes('#');
}
exports.isNumber = isNumber;
/** Check whether text starts with an html tag. */
function isHtmlTag(text) {
    return /^[\t ]*(a|abbr|address|area|article|aside|audio|b|base|bdi|bdo|blockquote|body|br|button|canvas|caption|cite|code|col|colgroup|data|datalist|dd|del|details|dfn|dialog|div|dl|dt|em|embed|fieldset|figcaption|figure|footer|form|h1|h2|h3|h4|h5|h6|head|header|hgroup|hr|html|i|iframe|img|input|ins|kbd|keygen|label|legend|li|link|main|map|mark|menu|menuitem|meta|meter|nav|noscript|object|ol|optgroup|option|output|p|param|pre|progress|q|rb|rp|rt|rtc|ruby|s|samp|script|section|select|small|source|span|strong|style|sub|summary|sup|svg|table|tbody|td|template|textarea|tfoot|th|thead|time|title|tr|track|u|ul|var|video|wbr|path)((:|::|,|\.|#|\[)[:$#{}()\w\-\[\]='",\.# +]*)?$/.test(text);
}
exports.isHtmlTag = isHtmlTag;
/** Check whether text starts with a self closing html tag. */
function isVoidHtmlTag(text) {
    return /^[\t ]*(area|base|br|col|embed|hr|img|input|link|meta|param|source|track|wbr|command|keygen|menuitem|path)((:|::|,|\.|#|\[)[:$#{}()\w\-\[\]='",\.# ]*)?$/.test(text);
}
exports.isVoidHtmlTag = isVoidHtmlTag;
/** Check whether text starts with //R: `/^[\t ]*\/?\/\/ *R *$/` */
function isReset(text) {
    return /^[\t ]*\/?\/\/ *R *$/.test(text);
}
exports.isReset = isReset;
/** Check whether text starts with //I: `/^[\t ]*\/?\/\/ *I *$/` */
function isIgnore(text) {
    return /^[\t ]*\/?\/\/ *I *$/.test(text);
}
exports.isIgnore = isIgnore;
/** Check whether text starts with //S: `/^[\t ]*\/?\/\/ *S *$/` */
function isSassSpace(text) {
    return /^[\t ]*\/?\/\/ *S *$/.test(text);
}
exports.isSassSpace = isSassSpace;
/** `/^.*['"]\.?[\.\/]$/` */
function isPath(text) {
    return /^.*['"]\.?[\.\/]$/.test(text);
}
exports.isPath = isPath;
/** Returns true if the string has brackets or semicolons at the end, comments get ignored. */
function isScssOrCss(text, wasLastLineCss) {
    if (wasLastLineCss === void 0) { wasLastLineCss = false; }
    if (wasLastLineCss && text.endsWith(',') && isClassOrId(text)) {
        return true;
    }
    // Check if has brackets at the end and ignore comments.
    return /[;\{\}][\t ]*(\/\/.*)?$/.test(text);
}
exports.isScssOrCss = isScssOrCss;
/** `/^[\t ]*[&.#%].*:/` */
function isCssPseudo(text) {
    return /^[\t ]*[&.#%].*:/.test(text);
}
exports.isCssPseudo = isCssPseudo;
/** `/^[\t ]*[&.#%][\w-]*(?!#)[\t ]*\{.*[;\}][\t ]*$/` */
function isCssOneLiner(text) {
    return /^[\t ]*[&.#%][\w-]*(?!#)[\t ]*\{.*[;\}][\t ]*$/.test(text);
}
exports.isCssOneLiner = isCssOneLiner;
/** `/^[\t ]*::?[\w\-]+\(.*\)/` */
function isPseudoWithParenthesis(text) {
    return /^[\t ]*::?[\w\-]+\(.*\)/.test(text);
}
exports.isPseudoWithParenthesis = isPseudoWithParenthesis;
/** `/^[\t ]*(\/\/|\/\*)/` */
function isComment(text) {
    return /^[\t ]*(\/\/|\/\*)/.test(text);
}
exports.isComment = isComment;
/** `/^[\t ]*\/\//` */
function isSingleLineComment(text) {
    return /^[\t ]*\/\//.test(text);
}
exports.isSingleLineComment = isSingleLineComment;
/** `/^[\t ]*(\/\*)/` */
function isBlockCommentStart(text) {
    return /^[\t ]*(\/\*)/.test(text);
}
exports.isBlockCommentStart = isBlockCommentStart;
/** `/[\t ]*(\*\/)/` */
function isBlockCommentEnd(text) {
    return /[\t ]*(\*\/)/.test(text);
}
exports.isBlockCommentEnd = isBlockCommentEnd;
/** `/^[\t ]*[\.#%].* ?, *[\.#%].*\/` */
function isMoreThanOneClassOrId(text) {
    return /^[\t ]*[\.#%].* ?, *[\.#%].*/.test(text);
}
exports.isMoreThanOneClassOrId = isMoreThanOneClassOrId;
/** `/^.*#[a-fA-F\d]{3,4}\b|^.*#[a-fA-F\d]{6}\b|^.*#[a-fA-F\d]{8}\b|rgba?\([\d. ]+,[\d. ]+,[\d. ]+(,[\d. ]+)?\)/` */
function hasColor(text) {
    return /^.*#[a-fA-F\d]{3,4}\b|^.*#[a-fA-F\d]{6}\b|^.*#[a-fA-F\d]{8}\b|rgba?\([\d. ]+,[\d. ]+,[\d. ]+(,[\d. ]+)?\)/.test(text);
}
exports.hasColor = hasColor;
/** `/^[\t ]*[}{]+[\t }{]*$/` */
function isBracketOrWhitespace(text) {
    return /^[\t ]*[}{]+[\t }{]*$/.test(text);
}
exports.isBracketOrWhitespace = isBracketOrWhitespace;
/** `/[\t ]*@forward|[\t ]*@use/` */
function isAtForwardOrAtUse(text) {
    return /[\t ]*@forward|[\t ]*@use/.test(text);
}
exports.isAtForwardOrAtUse = isAtForwardOrAtUse;
/** `/^[\t ]*[\w-]*#\{.*?\}[\w-]*:/` */
function isInterpolatedProperty(text) {
    return /^[\t ]*[\w-]*#\{.*?\}[\w-]*:/.test(text);
}
exports.isInterpolatedProperty = isInterpolatedProperty;
/** `/^[\t ]*([\w ]+|[\w ]*#\{.*?\}[\w ]*): [^ ]/` */
function hasPropertyValueSpace(text) {
    return /^[\t ]*([\w ]+|[\w ]*#\{.*?\}[\w ]*): [^ ]/.test(text);
}
exports.hasPropertyValueSpace = hasPropertyValueSpace;
/** returns the distance between the beginning and the first char. */
function getDistance(text, tabSize) {
    var count = 0;
    for (var i = 0; i < text.length; i++) {
        var char = text[i];
        if (char !== ' ' && char !== '\t') {
            break;
        }
        if (char === '\t') {
            count += tabSize;
        }
        else {
            count++;
        }
    }
    return count;
}
exports.getDistance = getDistance;
/** returns the distance between the end and the first char.*/
function getDistanceReversed(text, tabSize) {
    var count = 0;
    for (var i = text.length - 1; i > 0; i--) {
        var char = text[i];
        if (char !== ' ' && char !== '\t') {
            break;
        }
        if (char === '\t') {
            count += tabSize;
        }
        else {
            count++;
        }
    }
    return count;
}
exports.getDistanceReversed = getDistanceReversed;
/** What is this function even used for ??, good job me. */
function splitOnce(text, splitter) {
    var split = text.split(splitter);
    var key = split.shift();
    return { body: (split.length > 0 ? splitter : '') + split.join(splitter), key: key };
}
exports.splitOnce = splitOnce;
