export declare function escapeRegExp(text: string): string;
/** Check whether text is a variable: `/^[\t ]*(\$|--)\S+:.* /` */
export declare function isVar(text: string): boolean;
/** Check whether text @import: `/^[\t ]*@import/` */
export declare function isAtImport(text: string): boolean;
/** Check whether text is a \*: `/^[\t ]*?\*\/` */
export declare function isStar(text: string): boolean;
/**Check whether text is class, id or placeholder: `/^[\t ]*[#\.%]/` */
export declare function isClassOrId(text: string): boolean;
/**Check whether text is a selector: `^[\t ]*([#\.%&>~]|\+[\t ])` */
export declare function isSelector(text: string): boolean;
/**Check whether text starts with one of [>\~]: `/^[\t ]*[>~]/` */
export declare function isSelectorOperator(text: string): boolean;
/** `/^[\t ]*[{}]?[\t ]*[#\.%@]/` */
export declare function isCssSelector(text: string): boolean;
/**`/^[\t ]*\+[\t ]+/` */
export declare function isAdjacentSelector(text: string): boolean;
/**Check whether text is class, id or placeholder: `/^[\t ]*\r?\n?$/` */
export declare function isEmptyOrWhitespace(text: string): boolean;
/** Check whether text is a property: `empty` ? `!/^[\t ]*[\w\-]+: *\S+/` : `/^[\t ]*[\w\-]+:/` */
export declare function isProperty(text: string, empty?: boolean): boolean;
/** Check whether text starts with &: `/^[\t ]*&/` */
export declare function isAnd(text: string): boolean;
/** Check whether text is a AtRoot: `/^[\t ]*@at-root/` */
export declare function isAtRoot(text: string): boolean;
/** Check whether text is a extend: `/^[\t ]*@extend/` */
export declare function isAtExtend(text: string): boolean;
/** Check whether text is at rule :  `/^[\t ]*@/`*/
export declare function isAtRule(text: string): boolean;
/** Check whether text is include mixin statement */
export declare function isInclude(text: string): false | "prop" | "header";
/** Check whether text is a @keyframes: `/^[\t ]*@keyframes/` */
export declare function isKeyframes(text: string): boolean;
/** Check whether text is a mixin: `/^[\t ]*=|^[\t ]*@mixin/` */
export declare function isMixin(text: string): boolean;
/** Check whether text is a loop: `/^[\t ]*(@each|@for|@while)/` */
export declare function isLoop(text: string): boolean;
/** Check whether text starts with @media: `/^[\t ]*@media/`*/
export declare function isMedia(text: string): boolean;
/** `/^[\t ]*@font-face/` */
export declare function isFontFace(text: string): boolean;
/** Check whether text is a Pseudo selector: `/^[\t ]*\\?::?/`. */
export declare function isPseudo(text: string): boolean;
/** Check whether text starts with @if or @else: `/^[\t ]*@if|^ *@else/` */
export declare function isIfOrElse(text: string): boolean;
/** Check whether text starts with @else: `/^[\t ]*@else/` */
export declare function isElse(text: string): boolean;
/** Check whether text is bracket selector: `/^[\t ]*\[[\w=\-*"' ]*\]/`*/
export declare function isBracketSelector(text: string): boolean;
/** checks if text last char is a number: `/[0-9]$/` && `!text.includes('#')` */
export declare function isNumber(text: string): boolean;
/** Check whether text starts with an html tag. */
export declare function isHtmlTag(text: string): boolean;
/** Check whether text starts with a self closing html tag. */
export declare function isVoidHtmlTag(text: string): boolean;
/** Check whether text starts with //R: `/^[\t ]*\/?\/\/ *R *$/` */
export declare function isReset(text: string): boolean;
/** Check whether text starts with //I: `/^[\t ]*\/?\/\/ *I *$/` */
export declare function isIgnore(text: string): boolean;
/** Check whether text starts with //S: `/^[\t ]*\/?\/\/ *S *$/` */
export declare function isSassSpace(text: string): boolean;
/** `/^.*['"]\.?[\.\/]$/` */
export declare function isPath(text: string): boolean;
/** Returns true if the string has brackets or semicolons at the end, comments get ignored. */
export declare function isScssOrCss(text: string, wasLastLineCss?: boolean): boolean;
/** `/^[\t ]*[&.#%].*:/` */
export declare function isCssPseudo(text: string): boolean;
/** `/^[\t ]*[&.#%][\w-]*(?!#)[\t ]*\{.*[;\}][\t ]*$/` */
export declare function isCssOneLiner(text: string): boolean;
/** `/^[\t ]*::?[\w\-]+\(.*\)/` */
export declare function isPseudoWithParenthesis(text: string): boolean;
/** `/^[\t ]*(\/\/|\/\*)/` */
export declare function isComment(text: string): boolean;
/** `/^[\t ]*\/\//` */
export declare function isSingleLineComment(text: string): boolean;
/** `/^[\t ]*(\/\*)/` */
export declare function isBlockCommentStart(text: string): boolean;
/** `/[\t ]*(\*\/)/` */
export declare function isBlockCommentEnd(text: string): boolean;
/** `/^[\t ]*[\.#%].* ?, *[\.#%].*\/` */
export declare function isMoreThanOneClassOrId(text: string): boolean;
/** `/^.*#[a-fA-F\d]{3,4}\b|^.*#[a-fA-F\d]{6}\b|^.*#[a-fA-F\d]{8}\b|rgba?\([\d. ]+,[\d. ]+,[\d. ]+(,[\d. ]+)?\)/` */
export declare function hasColor(text: string): boolean;
/** `/^[\t ]*[}{]+[\t }{]*$/` */
export declare function isBracketOrWhitespace(text: string): boolean;
/** `/[\t ]*@forward|[\t ]*@use/` */
export declare function isAtForwardOrAtUse(text: string): boolean;
/** `/^[\t ]*[\w-]*#\{.*?\}[\w-]*:/` */
export declare function isInterpolatedProperty(text: string): boolean;
/** `/^[\t ]*([\w ]+|[\w ]*#\{.*?\}[\w ]*): [^ ]/` */
export declare function hasPropertyValueSpace(text: string): boolean;
/** returns the distance between the beginning and the first char. */
export declare function getDistance(text: string, tabSize: number): number;
/** returns the distance between the end and the first char.*/
export declare function getDistanceReversed(text: string, tabSize: number): number;
/** What is this function even used for ??, good job me. */
export declare function splitOnce(text: string, splitter: string): {
    body: string;
    key: string;
};
