import { SassTextLine } from './sassTextLine';
import { FormattingState } from './state';
/** returns the relative distance that the class or id should be at. */
export declare function getBlockHeaderOffset(distance: number, tabSize: number, current: number, ignoreCurrent: boolean): number;
/**
 * adds or removes whitespace based on the given offset, a positive value adds whitespace a negative value removes it.
 */
export declare function replaceWithOffset(text: string, offset: number, STATE: FormattingState): string;
/** returns the difference between the current indentation and the indentation of the given text. */
export declare function getIndentationOffset(text: string, indentation: number, tabSize: number): {
    offset: number;
    distance: number;
};
export declare function isKeyframePoint(text: string, isAtKeyframe: boolean): boolean;
export declare function replaceSpacesOrTabs(text: string, STATE: FormattingState, insertSpaces?: boolean): string;
export declare function convertLine(line: SassTextLine, STATE: FormattingState): boolean;
