"use strict";
exports.__esModule = true;
exports.PushDebugInfo = exports.StoreLog = exports.LogDebugResult = void 0;
var suf_log_1 = require("suf-log");
suf_log_1.SetEnvironment('node');
var colon = suf_log_1.styler(':', '#777');
// const quote = styler('"', '#f64');
var pipe = suf_log_1.styler('|', '#f64');
var TEXT = function (text) { return suf_log_1.styler(text, '#bbb'); };
var NUMBER = function (number) { return suf_log_1.styler(number.toString(), '#f03'); };
var BOOL = function (bool) { return suf_log_1.styler(bool.toString(), bool ? '#0c0' : '#c00'); };
function LogDebugResult(result) {
    var data = StoreLog.logs;
    var out = suf_log_1.styler('FORMAT', '#0af');
    for (var i = 0; i < data.length; i++) {
        out += '\n';
        out += InfoLogHelper(data[i]);
    }
    out += "\n" + pipe + suf_log_1.styler(replaceWhitespace(result.replace(/\n/g, '|\n|')), '#c76') + pipe;
    console.log(out);
}
exports.LogDebugResult = LogDebugResult;
var emptyTempConvertData = {
    text: '',
    type: '',
    log: false
};
var StoreLog = /** @class */ (function () {
    function StoreLog() {
    }
    StoreLog.resetTempConvertData = function () {
        this.TempConvertData = emptyTempConvertData;
    };
    StoreLog.TempConvertData = emptyTempConvertData;
    StoreLog.logs = [];
    return StoreLog;
}());
exports.StoreLog = StoreLog;
function PushDebugInfo(info) {
    if (info.debug) {
        StoreLog.logs.push({
            info: info,
            ConvertData: StoreLog.TempConvertData ? StoreLog.TempConvertData : {}
        });
        StoreLog.resetTempConvertData();
    }
    else {
        StoreLog.resetTempConvertData();
    }
}
exports.PushDebugInfo = PushDebugInfo;
function InfoLogHelper(data) {
    if (data) {
        var ConvertData = data.ConvertData, info = data.info;
        var notProvided = null;
        var title = suf_log_1.styler(info.title, '#cc0');
        var lineNumber = "" + TEXT('Line Number') + colon + " " + NUMBER(info.lineNumber);
        var offset = info.offset !== undefined ? "" + TEXT('Offset') + colon + " " + NUMBER(info.offset) : '';
        var propertySpace = info.setSpace !== undefined ? BOOL(info.setSpace) : notProvided;
        var nextLine = info.nextLine !== undefined
            ? JSON.stringify(info.nextLine)
                .replace(/[{}]/g, '')
                .replace(/:/g, ': ')
                .replace(/,/g, ', ')
                .replace(/".*?"/g, function (s) {
                return suf_log_1.styler(s, '#c76');
            })
            : notProvided;
        var replace = info.replaceSpaceOrTabs !== undefined ? BOOL(info.replaceSpaceOrTabs) : notProvided;
        var CONVERT = ConvertData.log
            ? "\n      " + TEXT('Convert') + "        " + colon + " " + suf_log_1.styler(ConvertData.type, '#f64')
            : '';
        switch (info.newLineText) {
            case 'DELETED':
                return " " + title + " " + lineNumber + " " + TEXT('Next Line') + colon + " " + nextLine;
            case 'NEWLINE':
            case 'NULL':
                return " " + title + " " + lineNumber;
            default:
                var additionalInfo = '';
                additionalInfo +=
                    propertySpace !== null
                        ? "\n      " + TEXT('Property Space') + " " + colon + " " + propertySpace
                        : '';
                additionalInfo +=
                    nextLine !== null ? "\n      " + TEXT('Next Line') + "      " + colon + " " + nextLine : '';
                additionalInfo +=
                    replace !== null ? "\n      " + TEXT('Replace') + "        " + colon + " " + replace : '';
                return " " + title + " " + lineNumber + " " + offset + "\n      " + TEXT('Old') + "            " + colon + " " + suf_log_1.styler(replaceWhitespace(info.oldLineText), '#c64') + "\n      " + TEXT('New') + "            " + colon + " " + suf_log_1.styler(replaceWhitespace(info.newLineText.replace(/\n/g, '\\n')), '#2c2') + CONVERT + additionalInfo;
        }
    }
    return '';
}
function replaceWhitespace(text) {
    return text.replace(/ /g, '·').replace(/\t/g, '⟶');
}
