import { SassTextLine } from './sassTextLine';
export interface LogFormatInfo {
    title: string;
    debug: boolean;
    lineNumber: number;
    oldLineText: string;
    newLineText: string;
    setSpace?: boolean;
    offset?: number;
    replaceSpaceOrTabs?: boolean;
    nextLine?: SassTextLine;
}
export interface LogConvertData {
    type: string;
    text: string;
    log: boolean;
}
declare type Logs = {
    ConvertData: LogConvertData;
    info: LogFormatInfo;
};
export declare function LogDebugResult(result: string): void;
export declare class StoreLog {
    static TempConvertData: LogConvertData;
    static resetTempConvertData(): void;
    static logs: Logs[];
}
export declare function PushDebugInfo(info: LogFormatInfo): void;
export {};
