"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
exports.__esModule = true;
exports.SassFormatter = exports.defaultSassFormatterConfig = void 0;
var utility_1 = require("./utility");
var suf_regex_1 = require("suf-regex");
var state_1 = require("./state");
var format_utility_1 = require("./formatters/format.utility");
var format_header_1 = require("./formatters/format.header");
var format_property_1 = require("./formatters/format.property");
var format_blockComment_1 = require("./formatters/format.blockComment");
var format_convert_1 = require("./formatters/format.convert");
var format_atForwardOrAtUse_1 = require("./formatters/format.atForwardOrAtUse");
var sassTextLine_1 = require("./sassTextLine");
var logger_1 = require("./logger");
var config_1 = require("./config");
__createBinding(exports, config_1, "defaultSassFormatterConfig");
var SassFormatter = /** @class */ (function () {
    function SassFormatter() {
    }
    SassFormatter.Format = function (text, config) {
        var STATE = new state_1.FormattingState();
        STATE.lines = text.split(/\r?\n/);
        STATE.CONFIG = __assign(__assign({}, STATE.CONFIG), config);
        STATE.LINE_ENDING = STATE.CONFIG.lineEnding === 'LF' ? '\n' : '\r\n';
        for (var i = 0; i < STATE.lines.length; i++) {
            STATE.currentLine = i;
            this.formatLine(new sassTextLine_1.SassTextLine(STATE.lines[i]), STATE);
        }
        if (!STATE.RESULT.endsWith(STATE.LINE_ENDING)) {
            this.addNewLine(STATE);
        }
        if (STATE.CONFIG.debug) {
            logger_1.LogDebugResult(STATE.RESULT);
        }
        return STATE.RESULT;
    };
    SassFormatter.formatLine = function (line, STATE) {
        if (suf_regex_1.isBlockCommentStart(line.get())) {
            STATE.CONTEXT.isInBlockComment = true;
            STATE.CONTEXT.blockCommentDistance = suf_regex_1.getDistance(line.get(), STATE.CONFIG.tabSize);
        }
        else if (STATE.CONTEXT.isInBlockComment &&
            STATE.CONTEXT.blockCommentDistance >= suf_regex_1.getDistance(line.get(), STATE.CONFIG.tabSize)) {
            STATE.CONTEXT.isInBlockComment = false;
            STATE.CONTEXT.blockCommentDistance = 0;
        }
        if (STATE.CONTEXT.ignoreLine) {
            STATE.CONTEXT.ignoreLine = false;
            this.addNewLine(STATE);
            STATE.RESULT += line.get();
        }
        else if (STATE.CONTEXT.isInBlockComment) {
            this.handleCommentBlock(STATE, line);
        }
        else {
            if (suf_regex_1.isIgnore(line.get())) {
                STATE.CONTEXT.ignoreLine = true;
                this.addNewLine(STATE);
                STATE.RESULT += line.get();
            }
            else {
                if (suf_regex_1.isSassSpace(line.get())) {
                    STATE.CONTEXT.allowSpace = true;
                }
                // ####### Empty Line #######
                if (line.isEmptyOrWhitespace ||
                    (STATE.CONFIG.convert ? suf_regex_1.isBracketOrWhitespace(line.get()) : false)) {
                    this.handleEmptyLine(STATE, line);
                }
                else {
                    STATE.setLocalContext(__assign(__assign({}, format_utility_1.isAtKeyframes(line, STATE)), { ResetTabs: suf_regex_1.isReset(line.get()), isAnd_: suf_regex_1.isAnd(line.get()), isProp: suf_regex_1.isProperty(line.get()), indentation: utility_1.getIndentationOffset(line.get(), STATE.CONTEXT.tabs, STATE.CONFIG.tabSize), isAdjacentSelector: suf_regex_1.isAdjacentSelector(line.get()), isHtmlTag: suf_regex_1.isHtmlTag(line.get().trim().split(' ')[0]), isClassOrIdSelector: suf_regex_1.isClassOrId(line.get()), isAtExtend: suf_regex_1.isAtExtend(line.get()), isInterpolatedProp: suf_regex_1.isInterpolatedProperty(line.get()), isInclude: suf_regex_1.isInclude(line.get()), isVariable: suf_regex_1.isVar(line.get()), isImport: suf_regex_1.isAtImport(line.get()) }));
                    // ####### Is @forward or @use #######
                    if (suf_regex_1.isAtForwardOrAtUse(line.get())) {
                        this.addNewLine(STATE);
                        STATE.RESULT += format_atForwardOrAtUse_1.FormatAtForwardOrAtUse(line, STATE);
                    }
                    // ####### Block Header #######
                    else if (this.isBlockHeader(line, STATE)) {
                        this.addNewLine(STATE);
                        STATE.RESULT += format_header_1.FormatBlockHeader(line, STATE);
                    }
                    // ####### Properties or Vars #######
                    else if (this.isProperty(STATE)) {
                        this.ResetCONTEXT('normal', STATE);
                        this.addNewLine(STATE);
                        STATE.RESULT += format_property_1.FormatProperty(line, STATE);
                    }
                    // ####### Convert #######
                    else if (utility_1.convertLine(line, STATE)) {
                        this.ResetCONTEXT('convert', STATE);
                        var edit = format_convert_1.convertScssOrCss(line.get(), STATE).text;
                        logger_1.PushDebugInfo({
                            title: 'CONVERT',
                            lineNumber: STATE.currentLine,
                            oldLineText: STATE.lines[STATE.currentLine],
                            newLineText: edit,
                            debug: STATE.CONFIG.debug
                        });
                        this.addNewLine(STATE);
                        STATE.RESULT += edit;
                    }
                    else {
                        logger_1.PushDebugInfo({
                            title: 'NO CHANGE',
                            lineNumber: STATE.currentLine,
                            oldLineText: STATE.lines[STATE.currentLine],
                            newLineText: 'NULL',
                            debug: STATE.CONFIG.debug
                        });
                        this.addNewLine(STATE);
                        STATE.RESULT += line.get();
                    }
                    // set CONTEXT Variables
                    STATE.CONTEXT.wasLastLineSelector =
                        STATE.LOCAL_CONTEXT.isClassOrIdSelector ||
                            STATE.LOCAL_CONTEXT.isAdjacentSelector ||
                            STATE.LOCAL_CONTEXT.isHtmlTag;
                }
            }
        }
    };
    SassFormatter.handleCommentBlock = function (STATE, line) {
        this.addNewLine(STATE);
        var edit = format_blockComment_1.FormatHandleBlockComment(line.get(), STATE);
        STATE.RESULT += edit;
        if (suf_regex_1.isBlockCommentEnd(line.get())) {
            STATE.CONTEXT.isInBlockComment = false;
        }
        if (STATE.CONFIG.debug) {
            logger_1.PushDebugInfo({
                title: 'COMMENT BLOCK',
                lineNumber: STATE.currentLine,
                oldLineText: STATE.lines[STATE.currentLine],
                newLineText: edit,
                debug: STATE.CONFIG.debug
            });
        }
    };
    SassFormatter.handleEmptyLine = function (STATE, line) {
        this.ResetCONTEXT('normal', STATE);
        var pass = true; // its not useless, trust me.
        if (STATE.CONFIG.deleteEmptyRows && !STATE.CONTEXT.isLastLine) {
            var nextLine = new sassTextLine_1.SassTextLine(STATE.lines[STATE.currentLine + 1]);
            var compact = !suf_regex_1.isProperty(nextLine.get());
            var nextLineWillBeDeleted = STATE.CONFIG.convert
                ? suf_regex_1.isBracketOrWhitespace(nextLine.get())
                : false;
            if ((compact && !STATE.CONTEXT.allowSpace && nextLine.isEmptyOrWhitespace) ||
                (compact && !STATE.CONTEXT.allowSpace && nextLineWillBeDeleted)) {
                if (STATE.CONFIG.debug) {
                    logger_1.PushDebugInfo({
                        title: 'EMPTY LINE: DELETE',
                        nextLine: nextLine,
                        lineNumber: STATE.currentLine,
                        oldLineText: STATE.lines[STATE.currentLine],
                        newLineText: 'DELETED',
                        debug: STATE.CONFIG.debug
                    });
                }
                pass = false;
            }
        }
        if (line.get().length > 0 && pass && STATE.CONFIG.deleteWhitespace) {
            logger_1.PushDebugInfo({
                title: 'EMPTY LINE: WHITESPACE',
                lineNumber: STATE.currentLine,
                oldLineText: STATE.lines[STATE.currentLine],
                newLineText: 'NEWLINE',
                debug: STATE.CONFIG.debug
            });
            this.addNewLine(STATE);
        }
        else if (pass) {
            logger_1.PushDebugInfo({
                title: 'EMPTY LINE',
                lineNumber: STATE.currentLine,
                oldLineText: STATE.lines[STATE.currentLine],
                newLineText: 'NEWLINE',
                debug: STATE.CONFIG.debug
            });
            this.addNewLine(STATE);
        }
    };
    SassFormatter.isBlockHeader = function (line, STATE) {
        return (!STATE.LOCAL_CONTEXT.isInterpolatedProp &&
            !STATE.LOCAL_CONTEXT.isAtExtend &&
            !STATE.LOCAL_CONTEXT.isImport &&
            (suf_regex_1.isMixin(line.get()) || // adds =mixin
                suf_regex_1.isPseudo(line.get()) ||
                suf_regex_1.isSelectorOperator(line.get()) ||
                suf_regex_1.isStar(line.get()) ||
                suf_regex_1.isBracketSelector(line.get()) ||
                STATE.LOCAL_CONTEXT.isAdjacentSelector ||
                STATE.LOCAL_CONTEXT.ResetTabs ||
                STATE.LOCAL_CONTEXT.isAnd_ ||
                STATE.LOCAL_CONTEXT.isHtmlTag ||
                STATE.LOCAL_CONTEXT.isInclude === 'header' ||
                suf_regex_1.isCssSelector(line.get())) // adds all lines that start with [@.#%]
        );
    };
    SassFormatter.isProperty = function (STATE) {
        return (STATE.LOCAL_CONTEXT.isImport ||
            STATE.LOCAL_CONTEXT.isVariable ||
            STATE.LOCAL_CONTEXT.isInclude === 'prop' ||
            STATE.LOCAL_CONTEXT.isInterpolatedProp ||
            STATE.LOCAL_CONTEXT.isProp ||
            STATE.LOCAL_CONTEXT.isAtKeyframesPoint ||
            STATE.LOCAL_CONTEXT.isAtExtend ||
            STATE.LOCAL_CONTEXT.isIfOrElseAProp);
    };
    SassFormatter.ResetCONTEXT = function (type, STATE) {
        STATE.CONTEXT.firstCommaHeader.exists = false;
        if (type === 'convert') {
            STATE.CONTEXT.convert.wasLastLineCss = true;
        }
    };
    /** Adds new Line If not first line. */
    SassFormatter.addNewLine = function (STATE) {
        if (!STATE.CONTEXT.isFirstLine) {
            STATE.RESULT += STATE.LINE_ENDING;
        }
        else {
            STATE.CONTEXT.isFirstLine = false;
        }
    };
    return SassFormatter;
}());
exports.SassFormatter = SassFormatter;
