"use strict";
exports.__esModule = true;
exports.isAtKeyframes = exports.FormatSetTabs = void 0;
var utility_1 = require("../utility");
var suf_regex_1 = require("suf-regex");
function FormatSetTabs(STATE, headerStuff) {
    if (headerStuff === undefined) {
        // § set Tabs Property
        if (STATE.CONTEXT.keyframes.is && STATE.LOCAL_CONTEXT.isAtKeyframesPoint) {
            STATE.CONTEXT.tabs = Math.max(0, STATE.CONTEXT.keyframes.tabs + STATE.CONFIG.tabSize);
        }
        if (STATE.LOCAL_CONTEXT.isIfOrElseAProp && STATE.CONTEXT.keyframes.is) {
            STATE.CONTEXT.tabs = STATE.CONTEXT.keyframes.tabs + STATE.CONFIG.tabSize * 2;
        }
        else if (STATE.LOCAL_CONTEXT.isIfOrElseAProp && !STATE.CONTEXT.keyframes.is) {
            STATE.CONTEXT.tabs = STATE.CONTEXT.currentTabs;
        }
    }
    else {
        //§ set Tabs Header Block
        if (STATE.LOCAL_CONTEXT.isAtKeyframes) {
            STATE.CONTEXT.keyframes.tabs = Math.max(0, STATE.LOCAL_CONTEXT.indentation.distance + headerStuff.offset + STATE.CONFIG.tabSize);
        }
        if (STATE.LOCAL_CONTEXT.ResetTabs) {
            STATE.CONTEXT.tabs = Math.max(0, STATE.LOCAL_CONTEXT.indentation.distance + headerStuff.offset);
            STATE.CONTEXT.currentTabs = STATE.CONTEXT.tabs;
        }
        else {
            STATE.CONTEXT.tabs = Math.max(0, STATE.LOCAL_CONTEXT.indentation.distance +
                headerStuff.offset + // keep in mind that + offset can decrease the number.
                STATE.CONFIG.tabSize +
                headerStuff.additionalTabs);
            STATE.CONTEXT.currentTabs = STATE.CONTEXT.tabs;
        }
    }
}
exports.FormatSetTabs = FormatSetTabs;
function isAtKeyframes(line, STATE) {
    var isPointCheck = utility_1.isKeyframePoint(line.get(), STATE.CONTEXT.keyframes.is);
    if (STATE.CONTEXT.keyframes.is && isPointCheck) {
        STATE.CONTEXT.tabs = Math.max(0, STATE.CONTEXT.keyframes.tabs);
    }
    var isAtKeyframes = suf_regex_1.isKeyframes(line.get());
    var IS_IF_OR_ELSE_ = suf_regex_1.isIfOrElse(line.get());
    var isIfOrElseAProp = false;
    if (STATE.CONTEXT.keyframes.is && IS_IF_OR_ELSE_) {
        IS_IF_OR_ELSE_ = false;
        isIfOrElseAProp = true;
        STATE.CONTEXT.tabs = STATE.CONTEXT.keyframes.tabs + STATE.CONFIG.tabSize;
    }
    if (IS_IF_OR_ELSE_ && !STATE.CONTEXT.keyframes.is && suf_regex_1.isElse(line.get())) {
        isIfOrElseAProp = true;
        IS_IF_OR_ELSE_ = false;
        STATE.CONTEXT.tabs = Math.max(0, STATE.CONTEXT.currentTabs - STATE.CONFIG.tabSize);
    }
    return {
        isIfOrElseAProp: isIfOrElseAProp,
        isAtKeyframes: isAtKeyframes,
        isAtKeyframesPoint: isPointCheck
    };
}
exports.isAtKeyframes = isAtKeyframes;
