"use strict";
exports.__esModule = true;
exports.setValueSpace = exports.canReplaceSpacesOrTabs = exports.FormatProperty = void 0;
var suf_regex_1 = require("suf-regex");
var utility_1 = require("../utility");
var format_utility_1 = require("./format.utility");
var format_convert_1 = require("./format.convert");
var logger_1 = require("../logger");
function FormatProperty(line, STATE) {
    var convert = false;
    var replaceSpaceOrTabs = false;
    var edit = line.get();
    var isComment = suf_regex_1.isComment(line.get());
    var _a = setValueSpace(STATE, line.get(), false), setSpace = _a.setSpace, SetPropertySpaceRes = _a.text;
    line.set(SetPropertySpaceRes);
    if (utility_1.convertLine(line, STATE)) {
        var convertRes = format_convert_1.convertScssOrCss(line.get(), STATE);
        line.set(convertRes.text);
        convert = true;
    }
    // Set Context Vars
    STATE.CONTEXT.convert.wasLastLineCss = convert;
    var move = STATE.LOCAL_CONTEXT.indentation.offset !== 0 && !isComment;
    if (!move && canReplaceSpacesOrTabs(STATE, line.get())) {
        line.set(utility_1.replaceSpacesOrTabs(line.get(), STATE).trimRight());
        replaceSpaceOrTabs = true;
    }
    // Return
    if (move) {
        edit = utility_1.replaceWithOffset(line.get(), STATE.LOCAL_CONTEXT.indentation.offset, STATE).trimRight();
        logger_1.PushDebugInfo({
            title: 'PROPERTY: MOVE',
            lineNumber: STATE.currentLine,
            oldLineText: STATE.lines[STATE.currentLine],
            newLineText: edit,
            debug: STATE.CONFIG.debug,
            setSpace: setSpace,
            offset: STATE.LOCAL_CONTEXT.indentation.offset,
            replaceSpaceOrTabs: replaceSpaceOrTabs
        });
    }
    else if (suf_regex_1.getDistanceReversed(line.get(), STATE.CONFIG.tabSize) > 0 &&
        STATE.CONFIG.deleteWhitespace) {
        edit = line.get().trimRight();
        logger_1.PushDebugInfo({
            title: 'PROPERTY: TRAIL',
            lineNumber: STATE.currentLine,
            oldLineText: STATE.lines[STATE.currentLine],
            newLineText: edit,
            debug: STATE.CONFIG.debug,
            setSpace: setSpace,
            replaceSpaceOrTabs: replaceSpaceOrTabs
        });
    }
    else if (setSpace || convert || replaceSpaceOrTabs) {
        edit = line.get();
        logger_1.PushDebugInfo({
            title: 'PROPERTY: CHANGE',
            lineNumber: STATE.currentLine,
            oldLineText: STATE.lines[STATE.currentLine],
            newLineText: edit,
            debug: STATE.CONFIG.debug,
            setSpace: setSpace,
            replaceSpaceOrTabs: replaceSpaceOrTabs
        });
    }
    else {
        logger_1.PushDebugInfo({
            title: 'PROPERTY: DEFAULT',
            lineNumber: STATE.currentLine,
            oldLineText: STATE.lines[STATE.currentLine],
            newLineText: edit,
            debug: STATE.CONFIG.debug,
            setSpace: setSpace,
            replaceSpaceOrTabs: replaceSpaceOrTabs
        });
    }
    format_utility_1.FormatSetTabs(STATE);
    return edit;
}
exports.FormatProperty = FormatProperty;
function canReplaceSpacesOrTabs(STATE, text) {
    return STATE.CONFIG.insertSpaces
        ? /\t/g.test(text)
        : new RegExp(' '.repeat(STATE.CONFIG.tabSize), 'g').test(text);
}
exports.canReplaceSpacesOrTabs = canReplaceSpacesOrTabs;
function setValueSpace(STATE, text, setSpace) {
    if (!STATE.LOCAL_CONTEXT.isHtmlTag &&
        (STATE.LOCAL_CONTEXT.isProp || STATE.LOCAL_CONTEXT.isInterpolatedProp) &&
        STATE.CONFIG.setPropertySpace) {
        var newText = '';
        var isAfterColon = false;
        var wasLastCharSpace = true;
        for (var i = 0; i < text.length; i++) {
            var char = text[i];
            if (!isAfterColon) {
                newText += char;
                if (char === ':') {
                    isAfterColon = true;
                    newText += ' ';
                }
            }
            else if (char === ' ') {
                if (!wasLastCharSpace) {
                    newText += char;
                    wasLastCharSpace = true;
                }
            }
            else {
                newText += char;
                wasLastCharSpace = false;
            }
        }
        text = newText;
        setSpace = true;
    }
    return { setSpace: setSpace, text: text };
}
exports.setValueSpace = setValueSpace;
