"use strict";
exports.__esModule = true;
exports.FormatBlockHeader = void 0;
var suf_regex_1 = require("suf-regex");
var utility_1 = require("../utility");
var format_utility_1 = require("./format.utility");
var format_convert_1 = require("./format.convert");
var logger_1 = require("../logger");
function FormatBlockHeader(line, STATE) {
    var replaceSpaceOrTabs = false;
    var hasBeenConverted = false;
    var additionalTabs = 0;
    var edit = line.get();
    // First Convert then set Offset.
    if (STATE.CONFIG.convert &&
        suf_regex_1.isScssOrCss(line.get(), STATE.CONTEXT.convert.wasLastLineCss) &&
        !suf_regex_1.isComment(line.get())) {
        var convertRes = format_convert_1.convertScssOrCss(line.get(), STATE);
        STATE.CONTEXT.convert.lastSelector = convertRes.lastSelector;
        if (convertRes.increaseTabSize) {
            additionalTabs = STATE.CONFIG.tabSize;
        }
        line.set(convertRes.text);
        STATE.LOCAL_CONTEXT.indentation = utility_1.getIndentationOffset(line.get(), STATE.CONTEXT.tabs, STATE.CONFIG.tabSize);
        hasBeenConverted = true;
    }
    // Set offset.
    var offset = STATE.LOCAL_CONTEXT.isAdjacentSelector && STATE.CONTEXT.wasLastLineSelector
        ? STATE.CONTEXT.lastSelectorTabs - STATE.LOCAL_CONTEXT.indentation.distance
        : utility_1.getBlockHeaderOffset(STATE.LOCAL_CONTEXT.indentation.distance, STATE.CONFIG.tabSize, STATE.CONTEXT.tabs, STATE.LOCAL_CONTEXT.ResetTabs);
    if (STATE.CONTEXT.firstCommaHeader.exists) {
        offset = STATE.CONTEXT.firstCommaHeader.distance - STATE.LOCAL_CONTEXT.indentation.distance;
    }
    // Set Context Vars
    STATE.CONTEXT.keyframes.is =
        STATE.LOCAL_CONTEXT.isAtKeyframes || STATE.LOCAL_CONTEXT.isAtKeyframesPoint;
    STATE.CONTEXT.allowSpace = false;
    if (!hasBeenConverted && STATE.LOCAL_CONTEXT.isClassOrIdSelector) {
        STATE.CONTEXT.convert.lastSelector = '';
    }
    STATE.CONTEXT.convert.wasLastLineCss = hasBeenConverted;
    if (line.get().trim().endsWith(',')) {
        if (STATE.CONTEXT.firstCommaHeader.exists !== true) {
            STATE.CONTEXT.firstCommaHeader.distance = STATE.LOCAL_CONTEXT.indentation.distance + offset;
        }
        STATE.CONTEXT.firstCommaHeader.exists = true;
    }
    else {
        STATE.CONTEXT.firstCommaHeader.exists = false;
    }
    // Convert Spaces to tabs or vice versa depending on the config.
    if (STATE.CONFIG.insertSpaces ? /\t/g.test(line.get()) : / /g.test(line.get())) {
        line.set(utility_1.replaceSpacesOrTabs(line.get(), STATE));
        replaceSpaceOrTabs = true;
    }
    // Set edit or just return the line text.
    if (offset !== 0) {
        edit = utility_1.replaceWithOffset(line.get(), offset, STATE).trimRight();
        logger_1.PushDebugInfo({
            title: 'BLOCK HEADER: MOVE',
            lineNumber: STATE.currentLine,
            oldLineText: STATE.lines[STATE.currentLine],
            newLineText: edit,
            debug: STATE.CONFIG.debug,
            replaceSpaceOrTabs: replaceSpaceOrTabs,
            offset: offset
        });
    }
    else if (suf_regex_1.getDistanceReversed(line.get(), STATE.CONFIG.tabSize) > 0 &&
        STATE.CONFIG.deleteWhitespace) {
        edit = line.get().trimRight();
        logger_1.PushDebugInfo({
            title: 'BLOCK HEADER: TRAIL',
            lineNumber: STATE.currentLine,
            oldLineText: STATE.lines[STATE.currentLine],
            newLineText: edit,
            debug: STATE.CONFIG.debug,
            replaceSpaceOrTabs: replaceSpaceOrTabs
        });
    }
    else if (hasBeenConverted || replaceSpaceOrTabs) {
        edit = line.get();
        logger_1.PushDebugInfo({
            title: 'BLOCK HEADER: MODIFIED',
            lineNumber: STATE.currentLine,
            oldLineText: STATE.lines[STATE.currentLine],
            newLineText: edit,
            debug: STATE.CONFIG.debug,
            replaceSpaceOrTabs: replaceSpaceOrTabs
        });
    }
    else {
        logger_1.PushDebugInfo({
            title: 'BLOCK HEADER: DEFAULT',
            lineNumber: STATE.currentLine,
            oldLineText: STATE.lines[STATE.currentLine],
            newLineText: edit,
            debug: STATE.CONFIG.debug,
            replaceSpaceOrTabs: replaceSpaceOrTabs
        });
    }
    STATE.CONTEXT.lastSelectorTabs = Math.max(STATE.LOCAL_CONTEXT.indentation.distance + offset, 0);
    format_utility_1.FormatSetTabs(STATE, { additionalTabs: additionalTabs, offset: offset });
    return edit;
}
exports.FormatBlockHeader = FormatBlockHeader;
