"use strict";
exports.__esModule = true;
exports.convertScssOrCss = void 0;
var suf_regex_1 = require("suf-regex");
var utility_1 = require("../utility");
var format_property_1 = require("./format.property");
var logger_1 = require("../logger");
/**
 * converts scss/css to sass.
 */
function convertScssOrCss(text, STATE) {
    var isMultiple = suf_regex_1.isMoreThanOneClassOrId(text);
    var lastSelector = STATE.CONTEXT.convert.lastSelector;
    if (STATE.CONFIG.debug) {
        logger_1.StoreLog.TempConvertData.log = true;
        logger_1.StoreLog.TempConvertData.text = text;
    }
    if (!/[\t ]*[#.%]\{.*?}/.test(text)) {
        if (lastSelector && new RegExp('^.*' + suf_regex_1.escapeRegExp(lastSelector)).test(text)) {
            SetStoreConvertInfoType('LAST SELECTOR');
            var newText = text.replace(lastSelector, '');
            if (suf_regex_1.isPseudoWithParenthesis(text)) {
                newText = newText.split('(')[0].trim() + '(&' + ')';
            }
            else if (text.trim().startsWith(lastSelector)) {
                newText = text.replace(lastSelector, '&');
            }
            else {
                newText = newText.replace(/ /g, '') + ' &';
            }
            return {
                lastSelector: lastSelector,
                increaseTabSize: true,
                text: '\n'.concat(utility_1.replaceWithOffset(removeInvalidChars(newText).trimRight(), STATE.CONFIG.tabSize, STATE))
            };
        }
        else if (isCssOneLiner(text)) {
            SetStoreConvertInfoType('ONE LINER');
            var split = text.split('{');
            var properties = split[1].split(';');
            // Set isProp to true so that it Sets the property space.
            STATE.LOCAL_CONTEXT.isProp = true;
            var selector = split[0].trim();
            return {
                increaseTabSize: false,
                lastSelector: selector,
                text: removeInvalidChars(selector.concat('\n', properties
                    .map(function (v) {
                    return utility_1.replaceWithOffset(format_property_1.setValueSpace(STATE, v.trim(), false).text, STATE.CONFIG.tabSize, STATE);
                })
                    .join('\n'))).trimRight()
            };
        }
        else if (suf_regex_1.isCssPseudo(text) && !isMultiple) {
            SetStoreConvertInfoType('PSEUDO');
            return {
                increaseTabSize: false,
                lastSelector: lastSelector,
                text: removeInvalidChars(text).trimRight()
            };
        }
        else if (suf_regex_1.isCssSelector(text)) {
            SetStoreConvertInfoType('SELECTOR');
            lastSelector = removeInvalidChars(text).trimRight();
            return { text: lastSelector, increaseTabSize: false, lastSelector: lastSelector };
        }
    }
    SetStoreConvertInfoType('DEFAULT');
    return { text: removeInvalidChars(text).trimRight(), increaseTabSize: false, lastSelector: lastSelector };
}
exports.convertScssOrCss = convertScssOrCss;
function isCssOneLiner(text) {
    return /^[\t ]*[&.#%][\w-]*(?!#)[\t ]*\{.*[;\}][\t ]*$/.test(text);
}
function removeInvalidChars(text) {
    var newText = '';
    var isInQuotes = false;
    var isInComment = false;
    var isInInterpolation = false;
    for (var i = 0; i < text.length; i++) {
        var char = text[i];
        if (!isInQuotes && char === '/' && text[i + 1] === '/') {
            isInComment = true;
        }
        else if (/['"]/.test(char)) {
            isInQuotes = !isInQuotes;
        }
        else if (/#/.test(char) && /{/.test(text[i + 1])) {
            isInInterpolation = true;
        }
        else if (isInInterpolation && /}/.test(text[i - 1])) {
            isInInterpolation = false;
        }
        if (!/[;\{\}]/.test(char) || isInQuotes || isInComment || isInInterpolation) {
            newText += char;
        }
    }
    return newText;
}
function SetStoreConvertInfoType(type) {
    logger_1.StoreLog.TempConvertData.type = type;
}
