"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _fs = require("fs");

var _utils = require("./utils");

/**
 * @returns true iff output === input
 */
var runPrettier = function runPrettier(filepath, fix) {
  var prettier = (0, _utils.requireModule)((0, _utils.getModulePath)(filepath, "prettier"));
  var config = (0, _utils.getPrettierConfig)(filepath, prettier);
  var code = (0, _fs.readFileSync)(filepath, "utf8");
  var options = Object.assign({ filepath }, config);

  if (fix) {
    var output = prettier.format(code, options);
    if (output !== code) {
      (0, _fs.writeFileSync)(filepath, output);
      return false;
    }
    return true;
  } else {
    return prettier.check(code, options);
  }
};

exports.default = runPrettier;