"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _fs = require("fs");

var _path = require("path");

var _path2 = _interopRequireDefault(_path);

var _ignore = require("ignore");

var _ignore2 = _interopRequireDefault(_ignore);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var createIgnorer = function createIgnorer() {
  var ignorePath = _path2.default.resolve(process.cwd(), ".prettierignore");
  if ((0, _fs.existsSync)(ignorePath)) {
    var ignorer = (0, _ignore2.default)().add((0, _fs.readFileSync)(ignorePath, "utf8"));
    return function (filePath) {
      return ignorer.ignores(_path2.default.relative(process.cwd(), filePath));
    };
  }

  return function () {
    return false;
  };
};

exports.default = createIgnorer;