import { ParseError } from './parse_util';
export declare function dashCaseToCamelCase(input: string): string;
export declare function splitAtColon(input: string, defaultValues: string[]): string[];
export declare function splitAtPeriod(input: string, defaultValues: string[]): string[];
export declare function visitValue(value: any, visitor: ValueVisitor, context: any): any;
export declare function isDefined(val: any): boolean;
export declare function noUndefined<T>(val: T | undefined): T;
export interface ValueVisitor {
    visitArray(arr: any[], context: any): any;
    visitStringMap(map: {
        [key: string]: any;
    }, context: any): any;
    visitPrimitive(value: any, context: any): any;
    visitOther(value: any, context: any): any;
}
export declare class ValueTransformer implements ValueVisitor {
    visitArray(arr: any[], context: any): any;
    visitStringMap(map: {
        [key: string]: any;
    }, context: any): any;
    visitPrimitive(value: any, context: any): any;
    visitOther(value: any, context: any): any;
}
export declare type SyncAsync<T> = T | Promise<T>;
export declare const SyncAsync: {
    assertSync: <T>(value: SyncAsync<T>) => T;
    then: <T, R>(value: SyncAsync<T>, cb: (value: T) => SyncAsync<R>) => SyncAsync<R>;
    all: <T>(syncAsyncValues: SyncAsync<T>[]) => SyncAsync<T[]>;
};
export declare function error(msg: string): never;
export declare function syntaxError(msg: string, parseErrors?: ParseError[]): Error;
export declare function isSyntaxError(error: Error): boolean;
export declare function getParseErrors(error: Error): ParseError[];
export declare function escapeRegExp(s: string): string;
export declare function utf8Encode(str: string): string;
export declare function stringify(token: any): string;
/**
 * Lazily retrieves the reference value from a forwardRef.
 */
export declare function resolveForwardRef(type: any): any;
/**
 * Determine if the argument is shaped like a Promise
 */
export declare function isPromise(obj: any): obj is Promise<any>;
export declare class Version {
    full: string;
    readonly major: string;
    readonly minor: string;
    readonly patch: string;
    constructor(full: string);
}
export interface Console {
    log(message: string): void;
    warn(message: string): void;
}
