import { ParseError, ParseSourceSpan } from './parse_util';
import * as html from './ast';
import { InterpolationConfig } from './interpolation_config';
import { TagDefinition } from './tags';
export declare class TreeError extends ParseError {
    elementName: string | null;
    static create(elementName: string | null, span: ParseSourceSpan, msg: string): TreeError;
    constructor(elementName: string | null, span: ParseSourceSpan, msg: string);
}
export interface ParserOptions {
    decodeEntities?: boolean;
    insertRequiredParents?: boolean;
    ignoreFirstLf?: boolean;
    selfClosingElements?: boolean;
    selfClosingCustomElements?: boolean;
}
export interface TreeBuilderOptions {
    ignoreFirstLf?: boolean;
    insertRequiredParents?: boolean;
    selfClosingElements?: boolean;
    selfClosingCustomElements?: boolean;
}
export declare class ParseTreeResult {
    rootNodes: html.Node[];
    errors: ParseError[];
    constructor(rootNodes: html.Node[], errors: ParseError[]);
}
export declare class Parser {
    options: ParserOptions;
    getTagDefinition: (tagName: string, ignoreFirstLf: boolean, canSelfClose: boolean) => TagDefinition;
    constructor(options: ParserOptions, getTagDefinition: (tagName: string, ignoreFirstLf: boolean, canSelfClose: boolean) => TagDefinition);
    parse(source: string, url: string, interpolationConfig?: InterpolationConfig): ParseTreeResult;
}
