import { TagContentType, TagDefinition } from './tags';
export declare class HtmlTagDefinition implements TagDefinition {
    private closedByChildren;
    closedByParent: boolean;
    requiredParents: {
        [key: string]: boolean;
    };
    parentToAdd: string;
    implicitNamespacePrefix: string | null;
    contentType: TagContentType;
    isVoid: boolean;
    ignoreFirstLf: boolean;
    canSelfClose: boolean;
    constructor({ closedByChildren, requiredParents, implicitNamespacePrefix, contentType, closedByParent, isVoid, ignoreFirstLf, canSelfClose }?: {
        closedByChildren?: string[];
        closedByParent?: boolean;
        requiredParents?: string[];
        implicitNamespacePrefix?: string;
        contentType?: TagContentType;
        isVoid?: boolean;
        ignoreFirstLf?: boolean;
        canSelfClose?: boolean;
    });
    requireExtraParent(currentParent: string): boolean;
    isClosedByChild(name: string): boolean;
}
export declare function getHtmlTagDefinition(tagName: string, ignoreFirstLf: boolean, canSelfClose: boolean): HtmlTagDefinition;
export declare function isKnownHTMLTag(tagName: string): boolean;
