"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const html_tags_1 = require("./html_tags");
const interpolation_config_1 = require("./interpolation_config");
const parser_1 = require("./parser");
var parser_2 = require("./parser");
exports.ParseTreeResult = parser_2.ParseTreeResult;
exports.TreeError = parser_2.TreeError;
class HtmlParser extends parser_1.Parser {
    constructor(options = {
        decodeEntities: true,
        ignoreFirstLf: true,
        insertRequiredParents: false,
        selfClosingElements: false,
        selfClosingCustomElements: false
    }) {
        super(options, html_tags_1.getHtmlTagDefinition);
        this.options = options;
    }
    parse(source, url, interpolationConfig = interpolation_config_1.DEFAULT_INTERPOLATION_CONFIG) {
        return super.parse(source, url, interpolationConfig);
    }
}
exports.HtmlParser = HtmlParser;
//# sourceMappingURL=html_parser.js.map