"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const html = __importStar(require("./ast"));
function humanizeDom(parseResult, addSourceSpan = false) {
    if (parseResult.errors.length > 0) {
        const errorString = parseResult.errors.join('\n');
        throw new Error(`Unexpected parse errors:\n${errorString}`);
    }
    return humanizeNodes(parseResult.rootNodes, addSourceSpan);
}
exports.humanizeDom = humanizeDom;
function humanizeDomSourceSpans(parseResult) {
    return humanizeDom(parseResult, true);
}
exports.humanizeDomSourceSpans = humanizeDomSourceSpans;
function humanizeNodes(nodes, addSourceSpan = false) {
    const humanizer = new _Humanizer(addSourceSpan);
    html.visitAll(humanizer, nodes);
    return humanizer.result;
}
exports.humanizeNodes = humanizeNodes;
function humanizeLineColumn(location) {
    return `${location.line}:${location.col}`;
}
exports.humanizeLineColumn = humanizeLineColumn;
class _Humanizer {
    constructor(includeSourceSpan) {
        this.includeSourceSpan = includeSourceSpan;
        this.result = [];
        this.elDepth = 0;
    }
    visitElement(element, context) {
        const input = [html.Element, element.name, this.elDepth++];
        if (element.implicitNs) {
            input.push(element.implicitNs);
        }
        const res = this._appendContext(element, input);
        this.result.push(res);
        html.visitAll(this, element.attrs);
        html.visitAll(this, element.children);
        this.elDepth--;
    }
    visitAttribute(attribute, context) {
        const res = this._appendContext(attribute, [html.Attribute, attribute.name, attribute.value]);
        this.result.push(res);
    }
    visitText(text, context) {
        const res = this._appendContext(text, [html.Text, text.value, this.elDepth]);
        this.result.push(res);
    }
    visitComment(comment, context) {
        const res = this._appendContext(comment, [html.Comment, comment.value, this.elDepth]);
        this.result.push(res);
    }
    visitDoctype(doctype, context) {
        const res = this._appendContext(doctype, [html.Doctype, doctype.value, this.elDepth]);
        this.result.push(res);
    }
    _appendContext(ast, input) {
        if (!this.includeSourceSpan)
            return input;
        input.push(ast.sourceSpan.toString());
        return input;
    }
}
//# sourceMappingURL=ast_spec_utils.js.map