import { AstPath } from './ast_path';
import { ParseSourceSpan } from './parse_util';
export interface Node {
    sourceSpan: ParseSourceSpan;
    visit(visitor: Visitor, context: any): any;
}
export declare class Text implements Node {
    value: string;
    sourceSpan: ParseSourceSpan;
    constructor(value: string, sourceSpan: ParseSourceSpan);
    visit(visitor: Visitor, context: any): any;
}
export declare class Attribute implements Node {
    name: string;
    value: string;
    implicitNs: boolean;
    sourceSpan: ParseSourceSpan;
    valueSpan?: ParseSourceSpan;
    constructor(name: string, value: string, implicitNs: boolean, sourceSpan: ParseSourceSpan, valueSpan?: ParseSourceSpan);
    visit(visitor: Visitor, context: any): any;
}
export declare class Element implements Node {
    name: string;
    attrs: Attribute[];
    children: Node[];
    implicitNs: boolean;
    sourceSpan: ParseSourceSpan;
    startSourceSpan: ParseSourceSpan | null;
    endSourceSpan: ParseSourceSpan | null;
    constructor(name: string, attrs: Attribute[], children: Node[], implicitNs: boolean, sourceSpan: ParseSourceSpan, startSourceSpan?: ParseSourceSpan | null, endSourceSpan?: ParseSourceSpan | null);
    visit(visitor: Visitor, context: any): any;
}
export declare class Comment implements Node {
    value: string | null;
    sourceSpan: ParseSourceSpan;
    constructor(value: string | null, sourceSpan: ParseSourceSpan);
    visit(visitor: Visitor, context: any): any;
}
export declare class Doctype implements Node {
    value: string | null;
    sourceSpan: ParseSourceSpan;
    constructor(value: string | null, sourceSpan: ParseSourceSpan);
    visit(visitor: Visitor, context: any): any;
}
export interface Visitor {
    visit?(node: Node, context: any): any;
    visitDoctype(doctype: Doctype, context: any): any;
    visitElement(element: Element, context: any): any;
    visitAttribute(attribute: Attribute, context: any): any;
    visitText(text: Text, context: any): any;
    visitComment(comment: Comment, context: any): any;
}
export declare function visitAll(visitor: Visitor, nodes: Node[], context?: any): any[];
export declare class RecursiveVisitor implements Visitor {
    constructor();
    visitElement(ast: Element, context: any): any;
    visitAttribute(ast: Attribute, context: any): any;
    visitText(ast: Text, context: any): any;
    visitComment(ast: Comment, context: any): any;
    visitDoctype(doctype: Doctype, context: any): any;
    private visitChildren;
}
export declare type HtmlAstPath = AstPath<Node>;
export declare function findNode(nodes: Node[], position: number): HtmlAstPath;
