"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
const webparser_1 = require("@starptech/webparser");
const hast_util_from_webparser_1 = __importDefault(require("@starptech/hast-util-from-webparser"));
module.exports = function parse(options = {}) {
    this.Parser = parser;
    function parser(doc, file) {
        const parseResult = new webparser_1.HtmlParser(options).parse(doc, file.path);
        const lexerErrors = parseResult.errors.filter(e => !(e instanceof webparser_1.TreeError));
        const parserErrors = parseResult.errors.filter(e => e instanceof webparser_1.TreeError);
        const parserWarnings = parserErrors.filter(e => e.level === webparser_1.ParseErrorLevel.WARNING);
        for (const err of parserWarnings) {
            file.message(err.msg, {
                start: {
                    // webparser format counts lines beginning from zero
                    line: ++err.span.start.line,
                    offset: err.span.start.offset,
                    column: err.span.start.col
                },
                end: {
                    line: ++err.span.end.line,
                    offset: err.span.end.offset,
                    column: err.span.end.col
                }
            }, 'ParseError');
        }
        // log the first error which is related to the parser not lexer
        const parserFatalErrors = parserErrors.filter(e => e.level === webparser_1.ParseErrorLevel.ERROR);
        for (const err of parserFatalErrors) {
            file.fail(err.msg, {
                start: {
                    // webparser format counts lines beginning from zero
                    line: ++err.span.start.line,
                    offset: err.span.start.offset,
                    column: err.span.start.col
                },
                end: {
                    line: ++err.span.end.line,
                    offset: err.span.end.offset,
                    column: err.span.end.col
                }
            }, 'ParseError');
        }
        // when lexer error don't produce a parser error we still need to fail with the lexer error
        if (parserFatalErrors.length === 0 && lexerErrors.length > 0) {
            const err = lexerErrors[0];
            file.fail(err.msg, {
                start: {
                    // webparser format counts lines beginning from zero
                    line: ++err.span.start.line,
                    offset: err.span.start.offset,
                    column: err.span.start.col
                },
                end: {
                    line: ++err.span.end.line,
                    offset: err.span.end.offset,
                    column: err.span.end.col
                }
            }, 'LexerError');
        }
        return hast_util_from_webparser_1.default(parseResult.rootNodes, options);
    }
};
//# sourceMappingURL=index.js.map