export type DoctypeShortcut =
	| 'doctype html'
	| 'doctype xml'
	| 'doctype transitional'
	| 'doctype strict'
	| 'doctype frameset'
	| 'doctype 1.1'
	| 'doctype basic'
	| 'doctype mobile'
	| 'doctype plist';

// eslint-disable-next-line @typescript-eslint/typedef
export const DOCTYPE_SHORTCUT_REGISTRY = {
	'<!doctype html>': 'doctype html',
	'<?xml version="1.0" encoding="utf-8" ?>': 'doctype xml',
	'<!doctype html public "-//w3c//dtd xhtml 1.0 transitional//en" "http://www.w3.org/tr/xhtml1/dtd/xhtml1-transitional.dtd">':
		'doctype transitional',
	'<!doctype html public "-//w3c//dtd xhtml 1.0 strict//en" "http://www.w3.org/tr/xhtml1/dtd/xhtml1-strict.dtd">':
		'doctype strict',
	'<!doctype html public "-//w3c//dtd xhtml 1.0 frameset//en" "http://www.w3.org/tr/xhtml1/dtd/xhtml1-frameset.dtd">':
		'doctype frameset',
	'<!doctype html public "-//w3c//dtd xhtml 1.1//en" "http://www.w3.org/tr/xhtml11/dtd/xhtml11.dtd">': 'doctype 1.1',
	'<!doctype html public "-//w3c//dtd xhtml basic 1.1//en" "http://www.w3.org/tr/xhtml-basic/xhtml-basic11.dtd">':
		'doctype basic',
	'<!doctype html public "-//wapforum//dtd xhtml mobile 1.2//en" "http://www.openmobilealliance.org/tech/dtd/xhtml-mobile12.dtd">':
		'doctype mobile',
	'<!doctype plist public "-//apple//dtd plist 1.0//en" "http://www.apple.com/dtds/propertylist-1.0.dtd">':
		'doctype plist'
} as const;
