"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ParseEngineGateway = exports.CssClassDefinition = void 0;
const fs = require("fs");
const css = require("css");
class CssClassDefinition {
    constructor(className, location) {
        this.className = className;
        this.location = location;
    }
}
exports.CssClassDefinition = CssClassDefinition;
class CssParseEngine {
    constructor() {
        this.languageId = "css";
        this.extension = "css";
    }
    parse(textDocument) {
        const code = textDocument.getText();
        const codeAst = css.parse(code);
        return CssClassExtractor.extract(codeAst);
    }
}
class ParseEngineRegistry {
    static getParseEngine(languageId) {
        const foundParseEngine = ParseEngineRegistry.registry.find((value) => value.languageId === languageId);
        if (!foundParseEngine) {
            throw new Error(`Could not find a parse engine for the provided language id ("${languageId}").`);
        }
        return foundParseEngine;
    }
    static get supportedLanguagesIds() {
        if (!ParseEngineRegistry.languagesIds) {
            ParseEngineRegistry.languagesIds = ParseEngineRegistry.registry.map((parseEngine) => parseEngine.languageId);
        }
        return ParseEngineRegistry.languagesIds;
    }
}
ParseEngineRegistry.registry = [
    new CssParseEngine(),
    // new StmlParseEngine()
];
class CssClassExtractor {
    /**
     * @description Extracts class names from CSS AST
     */
    static extract(ast) {
        var _a;
        const classNameRegex = /[.]([\w-]+)/g;
        const definitions = [];
        // go through each of the selectors of the current rule
        const addRule = (rule) => {
            var _a;
            (_a = rule.selectors) === null || _a === void 0 ? void 0 : _a.forEach((selector) => {
                let item = classNameRegex.exec(selector);
                while (item) {
                    definitions.push(new CssClassDefinition(item[1]));
                    item = classNameRegex.exec(selector);
                }
            });
        };
        // go through each of the rules or media query...
        (_a = ast.stylesheet) === null || _a === void 0 ? void 0 : _a.rules.forEach((rule) => {
            var _a;
            // ...of type rule
            if (rule.type === "rule") {
                addRule(rule);
            }
            // of type media queries
            if (rule.type === "media") {
                // go through rules inside media queries
                (_a = rule.rules) === null || _a === void 0 ? void 0 : _a.forEach((rule) => addRule(rule));
            }
        });
        return definitions;
    }
}
// class StmlParseEngine implements IParseEngine {
//     public languageId = "stml";
//     public extension = "stml";
//     public parse(textDocument: ISimpleTextDocument): CssClassDefinition[] {
//         const { regions } = parseStmlDocumentRegions(textDocument.uri)
//         let text = textDocument.getText();
//         for (let index = 0; index < regions.length; index++) {
//             const region = regions[index];
//             if(region.languageId === 'css'){
//                 const start = region.start
//                 const end = region.end
//                 const value = text.substring(start, end);
//                 if(value){
//                     const codeAst: css.Stylesheet = css.parse(value);
//                     return CssClassExtractor.extract(codeAst);
//                 }
//             }
//         }
//         return [];
//     }
// }
function createSimpleTextDocument(uri) {
    const text = fs.readFileSync(uri.fsPath, { encoding: 'utf-8' });
    const simpleDocument = {
        languageId: uri.fsPath.split(".").pop() || "",
        getText() {
            return text;
        },
        uri
    };
    return simpleDocument;
}
class ParseEngineGateway {
    static callParser(uri) {
        const textDocument = createSimpleTextDocument(uri);
        const parseEngine = ParseEngineRegistry.getParseEngine(textDocument.languageId);
        const cssClassDefinitions = parseEngine.parse(textDocument);
        return cssClassDefinitions;
    }
}
exports.ParseEngineGateway = ParseEngineGateway;
//# sourceMappingURL=parse-engine-gateway.js.map