"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateOpenUserScaffoldSnippetFolderCommand = void 0;
const vscode = require("vscode");
const fs = require("fs");
function generateOpenUserScaffoldSnippetFolderCommand(globalSnippetDir) {
    return async () => {
        const uri = vscode.Uri.file(globalSnippetDir);
        if (!fs.existsSync(uri.fsPath)) {
            fs.mkdirSync(uri.fsPath);
        }
        vscode.commands.executeCommand('vscode.openFolder', uri, true);
    };
}
exports.generateOpenUserScaffoldSnippetFolderCommand = generateOpenUserScaffoldSnippetFolderCommand;
//# sourceMappingURL=openUserScaffoldSnippetFolderCommand.js.map