"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateDoctorCommand = void 0;
const vscode = require("vscode");
function generateDoctorCommand(client) {
    return async () => {
        if (!vscode.window.activeTextEditor || !vscode.window.activeTextEditor.document.fileName.endsWith('.stml')) {
            return vscode.window.showInformationMessage('Failed to doctor. Make sure the current file is a .stml file.');
        }
        const fileName = vscode.window.activeTextEditor.document.fileName;
        const result = await client.sendRequest('$/doctor', { fileName });
        const showText = result.slice(0, 1000) + '....';
        const action = await vscode.window.showInformationMessage(showText, { modal: true }, 'Ok', 'Copy');
        if (action === 'Copy') {
            await vscode.env.clipboard.writeText(result);
        }
    };
}
exports.generateDoctorCommand = generateDoctorCommand;
//# sourceMappingURL=doctorCommand.js.map